// $Id: SetOfPrefix.cc 1.6 Sat, 07 Feb 1998 10:16:34 -0800 cengiz $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#pragma implementation

#include "config.hh"
#include "debug.hh"
#include "SetOfPrefix.hh"
#include <cstdio>
#include "dbase/Prefask.h"
#include "dbase/dbase.hh"

void SetOfPrefix::insert(const _SetOfPix& b) { // assignment from _SetOfPix
   if (_universal)
      return;

   u_int64_t rngs; int i;

   for (Pix p = b.first(); p; b.next(p)) {
      Prefask &address = Prefask_map(b(p));
      rngs = 0;
      for (i = address.get_n(); i <= address.get_m(); ++i)
	 rngs |= bits[i];

      if (not)
	 members.remove(address.get_prefix(), address.get_length(), rngs); 
      else
	 members.insert(address.get_prefix(), address.get_length(), rngs); 
   }
}

void SetOfPrefix::remove(const _SetOfPix& b) { // assignment from _SetOfPix
   if (_universal) {
      _universal = 0;
      not = 1;
   }

   u_int64_t rngs; int i;

   for (Pix p = b.first(); p; b.next(p)) {
      Prefask &address = Prefask_map(b(p));
      rngs = 0;
      for (i = address.get_n(); i <= address.get_m(); ++i)
	 rngs |= bits[i];

      if (not)
	 members.insert(address.get_prefix(), address.get_length(), rngs); 
      else
	 members.remove(address.get_prefix(), address.get_length(), rngs); 
   }
}

void SetOfPrefix::operator= (const _SetOfPix& b) { // assignment from _SetOfPix
   _universal = 0;
   not = 0;

   insert(b);
}

void SetOfPrefix::do_print (ostream& stream) {
   stream << *this;
}

ostream& operator<<(ostream& stream, SetOfPrefix& set) {
   if (set._universal)
      stream << "UNIVERSAL";
   else {
      if (set.not)
	 stream << "NOT";

      stream << set.members;
   }
   
   return stream;
}


void SetOfPrefix::operator |= (SetOfPrefix& b) { // union
   RadixSet c;

   if (_universal || b.empty())
      ; // done
   else
      if (b._universal) {
	 members.clear();
	 _universal = 1;
	 not = 0;
      } else {
	 switch (not*2+b.not) {
	 case 0: // not = 0, b.not = 0 => this UNION b = members UNION b.members
	    members |= b.members;
	    break;
	 case 1: // not = 0, b.not = 1 => this UNION b = members MINUS b.members
	    c = members;
	    members = b.members;
	    members -= c;
	    not = 1;
 	    break;
	 case 2: // not = 1, b.not = 0 => this UNION b = b.members MINUS members
	    members -= b.members;
 	    break;
	 case 3: // not = 1, b.not = 1 => this UNION b = members INTERSECTION b.members
	    members &= b.members;
	    break;
	 default:
	    ASSERT(0);
	 }
	 if (empty() && not) { // case 1,2,3 can cause this
	    _universal = 1;
	    not = 0;
	 }
      }
}

void SetOfPrefix::operator &= (SetOfPrefix& b) { // intersection
   RadixSet c;

   if (empty() || b._universal)
      ; // done
   else
      if (b.empty()) {
	 members.clear();
	 _universal = 0;
	 not = 0;
      } else 
	 if (_universal) {
	    _universal = b._universal;
	    not = b.not;
	    members = b.members;
	 } else {
	    switch (not*2+b.not) {
	    case 0: // not = 0, b.not = 0 => this INTSCTN b = members INTSCTN b.members
	       members &= b.members;
	       break;
	    case 1: // not = 0, b.not = 1 => this INTSCTN b = members MINUS b.members
	       members -= b.members;
	       break;
	    case 2: // not = 1, b.not = 0 => this INTSCTN b = b.members MINUS members
	       c = members;
	       members = b.members;
	       members -= c;	    
	       not = 0;
	       break;
	    case 3: // not = 1, b.not = 1 => this INTSCTN b = members UNION b.members
	       members |= b.members;
	       break;
	    default:
	       ASSERT(0);
	    }
	 }
}

void SetOfPrefix::operator ~  () { // complement
   if (_universal) {
      ASSERT(members.isEmpty());
      _universal = 0;
   } else 
      if (empty()) {
	 ASSERT(! not);
	 _universal = 1;
      } else
	 not = ! not;
}

int  SetOfPrefix::operator == (SetOfPrefix& other) { // equivalance
   return (_universal == other._universal 
	   && not == other.not
	   && members == other.members);
}

void  SetOfPrefix::operator = (SetOfPrefix& other) { // assignment
   members.clear();
   not = other.not;
   _universal = other._universal;
   members = other.members;
}

