/*
 * Platform data for WM8904
 *
 * Copyright 2009 Wolfson Microelectronics PLC.
 *
 * Author: Mark Brown <broonie@opensource.wolfsonmicro.com>
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 */

#ifndef __MFD_WM8994_PDATA_H__
#define __MFD_WM8994_PDATA_H__

#define WM8904_DRC_REGS 4
#define WM8904_EQ_REGS  25

/**
 * DRC configurations are specified with a label and a set of register
 * values to write (the enable bits will be ignored).  At runtime an
 * enumerated control will be presented for each DRC block allowing
 * the user to choose the configration to use.
 *
 * Configurations may be generated by hand or by using the DRC control
 * panel provided by the WISCE - see  http://www.wolfsonmicro.com/wisce/
 * for details.
 */
struct wm8904_drc_cfg {
	const char *name;
	u16 regs[WM8904_DRC_REGS];
};

/**
 * ReTune Mobile configurations are specified with a label, sample
 * rate and set of values to write (the enable bits will be ignored).
 *
 * Configurations are expected to be generated using the ReTune Mobile
 * control panel in WISCE - see http://www.wolfsonmicro.com/wisce/
 */
struct wm8904_retune_mobile_cfg {
	const char *name;
	unsigned int rate;
	u16 regs[WM8904_EQ_REGS];
};

struct wm8904_pdata {
	int num_drc_cfgs;
	struct wm8904_drc_cfg *drc_cfgs;

	int num_retune_mobile_cfgs;
	struct wm8904_retune_mobile_cfg *retune_mobile_cfgs;
};

#endif
