/*
 * linux/drivers/video/vmware/vmwarefb.h -- VMware SVGA Framebuffer Driver
 *
 * Copyright (c) 2002  Denis Oliver Kropp <dok@directfb.org>
 *
 *
 * Card specific code is based on XFree86's VMware driver.
 * Framebuffer framework code is based on code of neofb.
 *
 * This file is subject to the terms and conditions of the GNU General
 * Public License.  See the file COPYING in the main directory of this
 * archive for more details.
 *
 */


#ifdef VMWAREFB_DEBUG
# define DBG(x)		printk (KERN_DEBUG "vmwarefb: %s\n", (x));
#else
# define DBG(x)
#endif

#define PCI_VENDOR_ID_VMWARE        0x15AD
#define PCI_DEVICE_ID_VMWARE_SVGA2  0x0405
#define PCI_DEVICE_ID_VMWARE_SVGA   0x0710

/* --------------------------------------------------------------------- */

#define NR_PALETTE	256


struct vmwarefb_par {

  /* SVGA registers */
  u32 svga_reg_width;
  u32 svga_reg_height;
};

struct vmwarefb_info {

  /* Base struct */
  struct fb_info  fb;

  /* Console drawing functions */
  struct display_switch	dispsw;

  /* VMware VGA PCI device */
  struct pci_dev *pcidev;

  /* Current active console */
  int currcon;

  /* Accelerator id */
  int accel;

  /* Video memory */
  struct {
    u8  *vbase;
    u32  pbase;
    u32  len;
  } video;

  /* Memory mapped IO for acceleration */
  struct {
    u8  *vbase;
    u32  pbase;
    u32  len;
  } mmio;

  /* FIFO handling */
  u32 *vmwareFIFO;
  int  vmwareFIFOMarkSet;

  /* SVGA ports */
  u32 indexReg;
  u32 valueReg;

  /* Maximum screen resolution */
  int maxWidth;
  int maxHeight;

  /* Maximum dot clock */
  int maxClock;

  /* Bits per pixel in host format */
  unsigned int hostBitsPerPixel;

  /* Capabilities of the virtual card */
  unsigned int capabilities;

  /* Text color map */
  struct {
    u16 red, green, blue, transp;
  } palette[NR_PALETTE];
};
