#ifndef _SHFS_H_
#define _SHFS_H_

#include <linux/types.h>

#define SHFS_DEFAULT_TTL 20000

#define SHFS_SUPER_MAGIC 0xD0D0
#define SHFS_VERSION 1

#define SHFS_LINE_MAX 512
#define SHFS_PATH_MAX 1024

#include "shfs_debug.h"
#include "shfs_dcache.h"
#include "shfs_fcache.h"

struct shfs_mount_data {
	int version;
	int ttl;
	__kernel_uid_t uid;
	__kernel_gid_t gid;
	__kernel_mode_t root_mode;
	__kernel_mode_t fmask;
	char root[SHFS_PATH_MAX];
	char mount_point[SHFS_PATH_MAX];
	struct file *pin;
	struct file *pout;
	char *printf_buffer;
	char *readln_buffer;
	int readln_buffer_len;
	int garbage_read;
	int garbage_write;
	int garbage:1;
	int readonly:1;
	int preserve_own:1;
	int disable_fcache:1;
	int generic_host:1;
	int stable_symlinks:1;
};

struct shfs_sb_info {
	struct shfs_mount_data mnt;
	struct semaphore sem;
};

struct shfs_fattr {
	unsigned long 	f_ino;
	umode_t		f_mode;
	nlink_t		f_nlink;
	uid_t		f_uid;
	gid_t		f_gid;
	kdev_t		f_rdev;
	off_t		f_size;
	time_t		f_atime;
	time_t		f_mtime;
	time_t		f_ctime;
	unsigned long 	f_blksize;
	unsigned long	f_blocks;
};


#endif	/* _SHFS_H_ */
