Summary: OpenSSL Cell/B.E.Engine 
Name: openssl-cell-engine
Version: 1.1.4
Release: 1
License: OpenSSL Cell/B.E. Engine License and OpenSSL License
Group: System Environment/Libraries
URL: ftp://ftp.infradead.org/pub/Sony-PS3/mars/
Source0: ftp://ftp.infradead.org/pub/Sony-PS3/mars/latest/openssl-cell-engine-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

Requires: openssl, libspe2, mars
BuildRequires: ppu-gcc, spu-gcc, openssl-devel, libspe2-devel, mars-devel

%define __os_install_post	/usr/lib/rpm/brp-compress

%description
OpenSSL Cell/B.E.Engine is an implementation of OpenSSL which is
accelerated and/or offloaded by Cell Broadband Engine (Cell/B.E). It
is implemented as an 'ENGINE', which is an OpenSSL's component to
support external hardware devices.

%prep
%setup -q -n openssl-cell-engine-%{version}
OPENSSL_VERSION=openssl-`openssl version | sed -e 's/OpenSSL \([^ -]*\).*/\1/'`
wget ftp://ftp.openssl.org/source/$OPENSSL_VERSION.tar.gz
tar xzf $OPENSSL_VERSION.tar.gz

%build

%ifarch ppc
PPU_CFLAGS='-m32'
%endif
%ifarch ppc64
PPU_CFLAGS='-m64'
%endif

OPENSSL_VERSION=openssl-`openssl version | sed -e 's/OpenSSL \([^ -]*\).*/\1/'`
make OPENSSL_DIR=$OPENSSL_VERSION RUNTIME_SYSTEM="mars" SPU_CROSS="spu-" CROSS="ppu-" ARCH_CFLAGS="$PPU_CFLAGS"

%install
install -m 755 -d %{buildroot}%{_libdir}/openssl/engines
install -m 755 -t %{buildroot}%{_libdir}/openssl/engines libcell.so 

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%{_libdir}/openssl/engines/libcell.so

%changelog
* Thu Oct 01 2009 Yuji Mano <yuji.mano@am.sony.com> - 1.1.4-1
- Initial build.
