#ifndef __AIO_SYSCALL_i386
#define __AIO_SYSCALL_i386

#include <asm/unistd.h>
#undef __syscall_return
#define __syscall_return(type, res) \
do { \
	return (type) (res); \
} while (0)

#ifdef __s390__
#define __NR_sys_io_setup          243
#define __NR_sys_io_destroy        244
#define __NR_sys_io_getevents      245
#define __NR_sys_io_submit         246
#define __NR_sys_io_cancel         247
#endif

#ifdef __i386__
#define __NR_sys_io_setup		245
#define __NR_sys_io_destroy		246
#define __NR_sys_io_getevents		247
#define __NR_sys_io_submit		248
#define __NR_sys_io_cancel		249
#endif

static inline _syscall2(long, sys_io_setup, unsigned int, nr_reqs, io_context_t *, ctxp)
static inline _syscall1(long, sys_io_destroy, io_context_t, ctx)
static inline _syscall3(long, sys_io_submit, io_context_t, ctx_id,
			long, nr, struct iocb **, iocbpp)
static inline _syscall3(long, sys_io_cancel, io_context_t, ctx_id,
			struct iocb *, iocb, struct io_event *, result)
static inline _syscall5(long, sys_io_getevents, io_context_t, ctx_id,
			long, min_nr, long, nr, struct io_event *, events,
			struct timespec *, timeout)

#endif /* __AIO_SYSCALL_i386 */
