/*
 * Copyright (c) 2003 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 *
 * This file houses the Serial Number Arithmetic functions.
 * See RFC 1982
 *
 * Nicholas A. Bellinger <nab@kernel.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 *
 */
#ifndef ISCSI_SERIAL_C
#define ISCSI_SERIAL_C

#include <iscsi_linux_os.h>
#include <iscsi_initiator_serial.h>

#define SERIAL_BITS	31
#define MAX_BOUND	(u32)2147483647UL

extern int serial_lt (u32 x, u32 y)
{
	return((x != y) && (((x < y) && ((y - x) < MAX_BOUND)) ||
			    ((x > y) && ((x - y) > MAX_BOUND))));
}

extern int serial_lte (u32 x, u32 y)
{
	return((x == y) ? 1 : serial_lt(x, y));
}

extern int serial_gt (u32 x, u32 y)
{
	return((x != y) && (((x < y) && ((y - x) > MAX_BOUND)) ||
			    ((x > y) && ((x - y) < MAX_BOUND))));
}

extern int serial_gte (u32 x, u32 y)
{
	return((x == y) ? 1 : serial_gt(x, y));
}

#endif /* ISCSI_SERIAL_C */
