/*
 * Copyright (c) 2003 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 *
 * This file houses the iSCSI protocol debuging methods
 *
 * Nicholas A. Bellinger <nab@kernel.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#include <linux/string.h>
#include <linux/timer.h>
#include <linux/slab.h>
#include <iscsi_protocol.h>

void print_status_class_and_detail(u8 status_class, u8 status_detail)
{
	printk("Status-Class: ");
	switch (status_class) {
	case STAT_CLASS_SUCCESS:
		printk("Success, ");
		printk("Status-Detail: ");
		switch (status_detail) {
			case STAT_DETAIL_SUCCESS:
				printk("Login is prcedding OK.\n");
				break;
			default:
				printk("ERROR Unknown Status-Detail!\n");
				break;
		}
		break;
	case STAT_CLASS_REDIRECTION:
		printk("Redirection, ");
		printk("Status-Detail: ");
		switch (status_detail) {
			case STAT_DETAIL_TARG_MOVED_TEMP:
				printk("The requested iSCSI Target Name"
				" has temporarily moved to the address"
					" provided.\n");
				break;
			case STAT_DETAIL_TARG_MOVED_PERM:
				printk("The requested iSCSI Target Name"
				" permanently moved to the address"
					" provided.\n");
				break;
			default:
				printk("ERROR Unknown Status-Detail!\n");
				break;
		}
		break;
	case STAT_CLASS_INITIATOR:
		printk("Initiator Error, ");
		printk("Status-Detail: ");
		switch (status_detail) {
			case STAT_DETAIL_INIT_ERROR:
				printk("Miscellaneous iSCSI Initiator"
						" errors.\n");
				break;
			case STAT_DETAIL_NOT_AUTH:
				printk("The initiator could not be"
				" successfully authenticated or target"
				" authentication is not supported.\n");
				break;
			case STAT_DETAIL_NOT_ALLOWED:
				printk("The initiator is not allowed"
				" access to the given target.\n");
				break;
			case STAT_DETAIL_NOT_FOUND:
				printk("The requested iSCSI Target Name"
				" does not exist at this address.\n");
				break;
			case STAT_DETAIL_TARG_REMOVED:
				printk("The requested iSCSI Target Name"
				" has been removed and no forwarding"
				" address is provided.\n");
				break;
			case STAT_DETAIL_VERSION_NOT_SUPPORTED:
				printk("The requested iSCSI version range"
				" is not supported by the target.\n");
				break;
			case STAT_DETAIL_TOO_MANY_CONNECTIONS:
				printk("Too many connections on this SSID.\n");
				break;
			case STAT_DETAIL_MISSING_PARAMETER:
				printk("Missing parameters (e.g., iSCSI"
				" Initiator and/or Target Name).\n");
				break;
			case STAT_DETAIL_NOT_INCLUDED:
				printk("Target does not support session"
				" spanning to this connection (address).\n");
				break;
			case STAT_DETAIL_SESSION_TYPE:
				printk("Target does not support this type"
				" of session or not from this Initiator.\n");
			case STAT_DETAIL_SESSION_DOES_NOT_EXIST:
				printk("Attempt to add a connections to a"
				" non-existent session.\n");
				break;
			case STAT_DETAIL_INVALID_DURING_LOGIN:
				printk("Invalid Request type during Login.\n");
				break;
			default:
				printk("ERROR Unknown Status-Detail!\n");
				break;
		}
		break;
	case STAT_CLASS_TARGET:
		printk("Target Error, ");
		printk("Status-Detail: ");
		switch(status_detail) {
			case STAT_DETAIL_TARG_ERROR:
				printk("Target hardware or software error.\n");
				break;
			case STAT_DETAIL_SERVICE_UNAVAILABLE:
				printk("The iSCSI server or target is not"
				" currently operational.\n");
				break;
			case STAT_DETAIL_OUT_OF_RESOURCE:
				printk("The target has insufficient session,"
				" connection, or other resources.\n");
				break;
			default:
				printk("ERROR Unknown Status-Detail!\n");
				break;
		}
		break;
	default:
		printk("ERROR: Unknown Login Status Class\n");
		break;
	}
}

void print_reject_reason(u8 reason)
{
	printk("Reject Reason: ");
	switch (reason) {
	case REASON_FULL_BEFORE_LOGIN:
		printk("REASON_FULL_BEFORE_LOGIN");
		break;
	case REASON_DATA_DIGEST_ERR:
		printk("REASON_DATA_DIGEST_ERR");
		break;
	case REASON_DATA_SNACK:
		printk("REASON_DATA_SNACK");
		break;
	case REASON_PROTOCOL_ERR:
		printk("REASON_PROTOCOL_ERR");
		break;
	case REASON_COMMAND_NOT_SUPPORTED:
		printk("REASON_COMMAND_NOT_SUPPORTED");
		break;
	case REASON_TOO_MANY_IMMEDIATE_COMMANDS:
		printk("REASON_TOO_MANY_IMMEDIATE_COMMANDS");
		break;
	case REASON_TASK_IN_PROGRESS:
		printk("REASON_TASK_IN_PROGRESS");
		break;
	case REASON_INVALID_DATA_ACK:
		printk("REASON_INVALID_DATA_ACK");
		break;
	case REASON_INVALID_PDU_FIELD:
		printk("REASON_INVALID_PDU_FIELD");
		break;
	case REASON_OUT_OF_RESOURCES:
		printk("REASON_OUT_OF_RESOURCES");
		break;
	case REASON_NEGOTIATION_RESET:
		printk("REASON_NEGOTIATION_RESET");
		break;
	case REASON_WAITING_FOR_LOGOUT:
		printk("REASON_WAITING_FOR_LOGOUT");
		break;
	default:
		printk("ERROR: Unknown Reject Reason!");
		break;
	}
	printk("\n");
}

