/*
 * Copyright (c) 2003, 2004, 2005 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#ifndef CRC_H
#define CRC_H

#include <iscsi_linux_os.h>

extern void crc32c(u8 *, u32, int, u32 *);

#ifdef ISCSI_BIG_ENDIAN
#define ISCSI_CRC32C_RX_HDR_RX_PATH_BIG_ENDIAN(val)	val = cpu_to_le32(val);
#else
#define ISCSI_CRC32C_RX_HDR_RX_PATH_BIG_ENDIAN(val)
#endif

#define ISCSI_CRC32C_RX_HDR_RX_PATH(chksum, buf, data_crc, conn)				\
	crypto_digest_init(conn->conn_rx_tfm);							\
	memset(conn->conn_rx_tfm_sg, 0, sizeof(struct scatterlist));				\
	conn->conn_rx_tfm_sg->page = virt_to_page(buf);						\
	conn->conn_rx_tfm_sg->offset = offset_in_page(buf);					\
	conn->conn_rx_tfm_sg->length = ISCSI_HDR_LEN;						\
	crypto_digest_digest(conn->conn_rx_tfm, conn->conn_rx_tfm_sg, 1, (u8 *)&data_crc);	\
	ISCSI_CRC32C_RX_HDR_RX_PATH_BIG_ENDIAN(data_crc)

#ifdef ISCSI_BIG_ENDIAN
#define ISCSI_CRC32C_TX_HDR_TX_PATH_BIG_ENDIAN(val)	val = cpu_to_le32(val);
#else
#define ISCSI_CRC32C_TX_HDR_TX_PATH_BIG_ENDIAN(val)
#endif
	
#define ISCSI_CRC32C_TX_HDR_TX_PATH(buf, chksum, conn)						\
	crypto_digest_init(conn->conn_tx_tfm);							\
	memset(conn->conn_tx_tfm_sg, 0, sizeof(struct scatterlist));				\
	conn->conn_tx_tfm_sg->page = virt_to_page(buf);						\
	conn->conn_tx_tfm_sg->offset = offset_in_page(buf);					\
	conn->conn_tx_tfm_sg->length = ISCSI_HDR_LEN;						\
	crypto_digest_digest(conn->conn_tx_tfm, conn->conn_tx_tfm_sg, 1, (u8 *)&chksum);	\
	ISCSI_CRC32C_TX_HDR_TX_PATH_BIG_ENDIAN(chksum)

#ifdef ISCSI_BIG_ENDIAN
#define ISCSI_CRC32C_TX_HDR_RX_PATH_BIG_ENDIAN(val)	val = cpu_to_le32(val);
#else
#define ISCSI_CRC32C_TX_HDR_RX_PATH_BIG_ENDIAN(val)
#endif
	
#define ISCSI_CRC32C_TX_HDR_RX_PATH(buf, chksum, conn)						\
	crypto_digest_init(conn->conn_rx_tfm);							\
	memset(conn->conn_rx_tfm_sg, 0, sizeof(struct scatterlist));				\
	conn->conn_rx_tfm_sg->page = virt_to_page(buf);						\
	conn->conn_rx_tfm_sg->offset = offset_in_page(buf);					\
	conn->conn_rx_tfm_sg->length = ISCSI_HDR_LEN;						\
	crypto_digest_digest(conn->conn_rx_tfm, conn->conn_rx_tfm_sg, 1, (u8 *)&chksum);	\
	ISCSI_CRC32C_TX_HDR_RX_PATH_BIG_ENDIAN(chksum)

#ifdef ISCSI_BIG_ENDIAN
#define ISCSI_CRC32C_TX_DATA_TX_PATH_NON_SG_BIG_ENDIAN(val) val = cpu_to_le32(val);
#else
#define ISCSI_CRC32C_TX_DATA_TX_PATH_NON_SG_BIG_ENDIAN(val)
#endif
	
#define ISCSI_CRC32C_TX_DATA_TX_PATH_NON_SG(buf, len, chksum, conn)				\
	crypto_digest_init(conn->conn_tx_tfm);							\
	memset(conn->conn_tx_tfm_sg, 0, sizeof(struct scatterlist));				\
	conn->conn_tx_tfm_sg->page = virt_to_page(buf);						\
	conn->conn_tx_tfm_sg->offset = offset_in_page(buf);					\
	conn->conn_tx_tfm_sg->length = len;							\
	crypto_digest_digest(conn->conn_tx_tfm, conn->conn_tx_tfm_sg, 1, (u8 *)&chksum);	\
	chksum = cpu_to_le32(chksum);

#ifdef ISCSI_BIG_ENDIAN
#define ISCSI_CRC32C_RX_DATA_RX_PATH_BIG_ENDIAN(val)	val = cpu_to_le32(val);
#else
#define ISCSI_CRC32C_RX_DATA_RX_PATH_BIG_ENDIAN(val)
#endif
	
#define ISCSI_CRC32C_RX_DATA_RX_PATH(buf, len, conn)						\
	memset(conn->conn_rx_tfm_sg, 0, sizeof(struct scatterlist));				\
	conn->conn_rx_tfm_sg->page = virt_to_page(buf);						\
	conn->conn_rx_tfm_sg->offset = offset_in_page(buf);					\
	conn->conn_rx_tfm_sg->length = len;							\
	crypto_digest_update(conn->conn_rx_tfm, conn->conn_rx_tfm_sg, 1);	

#define ISCSI_CRC32C_RX_DATA_RX_PATH_FINAL(chksum, conn)					\
	crypto_digest_final(conn->conn_rx_tfm, (u8 *)&chksum);						\
	chksum = cpu_to_le32(chksum);

#ifdef ISCSI_BIG_ENDIAN
#define ISCSI_CRC32C_TX_DATA_TX_PATH_BIG_ENDIAN(val)	val = cpu_to_le32(val);
#else
#define ISCSI_CRC32C_TX_DATA_TX_PATH_BIG_ENDIAN(val)
#endif
	
#define ISCSI_CRC32C_TX_DATA_TX_PATH(buf, len, conn)						\
	memset(conn->conn_tx_tfm_sg, 0, sizeof(struct scatterlist));				\
	conn->conn_tx_tfm_sg->page = virt_to_page(buf);						\
	conn->conn_tx_tfm_sg->offset = offset_in_page(buf);					\
	conn->conn_tx_tfm_sg->length = len;							\
	crypto_digest_update(conn->conn_tx_tfm, conn->conn_tx_tfm_sg, 1);

#define ISCSI_CRC32C_TX_DATA_TX_PATH_FINAL(chksum, conn)					\
	crypto_digest_final(conn->conn_tx_tfm, (u8 *)&chksum);					\
	chksum = cpu_to_le32(chksum);

#endif /* CRC_H */
