/*
 * Copyright (c) 2002-2004 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 *  
 * This file houses definitions related to the iSCSI Initiator driver.
 */
#ifndef ISCSI_INITIATOR_H
#define ISCSI_INITIATOR_H

iscsi_global_t *iscsi_global;

extern int iscsi_send_text_param (iscsi_conn_t *, unsigned char *, unsigned char *);
extern int iscsi_scsi_queue_cmd (struct scsi_cmnd *, iscsi_session_t *);
extern void iscsi_start_tx_timer (iscsi_conn_t *, u32);
extern int iscsi_initiator_tx_thread (void *);
extern int iscsi_initiator_rx_thread (void *);
extern int iscsi_create_connection (iscsi_session_t *, iscsi_login_holder_t *, u16 *);
extern u32 iscsi_create_session (iscsi_login_holder_t *);
extern int iscsi_close_connection (iscsi_conn_t *);
extern int iscsi_close_session (iscsi_session_t *);
extern void iscsi_close_all_sessions (void);
extern int iscsi_free_session (iscsi_session_t *);
extern int iscsi_stop_session (iscsi_session_t *, int, int);
extern void iscsi_set_state_for_connections (iscsi_session_t *, u8);
extern int iscsi_start_logout (iscsi_session_t *, int, int, u8, u16, u16);
extern void iscsi_logout_thread (void *);

#endif /* ISCSI_INITIATOR_H */
