/*
 * Copyright (c) 2003 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 *
 * This file houses definitions related to
 * iSCSI CHAP Authenication.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#define CHAP_DIGEST_MD5		5
#define CHAP_DIGEST_SHA		6

#define CHAP_CHALLENGE_LENGTH	16
#define MAX_RESPONSE_LENGTH	64	/* sufficient for MD5 */
#define	MAX_CHAP_N_SIZE		16

#define MD5_SIGNATURE_SIZE	16	/* 16 bytes in a MD5 message digest */

#define DECIMAL  0
#define HEX      1

#define CHAP_STAGE_CLIENT_A	1
#define CHAP_STAGE_SERVER_AIC	2
#define CHAP_STAGE_CLIENT_NR	3
#define CHAP_STAGE_CLIENT_NRIC	4
#define CHAP_STAGE_SERVER_NR	5

typedef struct iscsi_chap_s {
	unsigned char	digest_type;
	unsigned char	id;
	unsigned char	challenge[CHAP_CHALLENGE_LENGTH];
	unsigned int	challenge_len;
	MD5_CTX		md5_context;
} iscsi_chap_t;	
	
