/*
 * Copyright (c) 2003, 2004, 2005 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 * 
 * This file houses the iSCSI Initiator specific utility definitions.
 */

#ifndef ISCSI_INITIATOR_UTIL_H
#define ISCSI_INITIATOR_UTIL_H

#define MARKER_SIZE	8

extern void iscsi_add_conn_to_list (iscsi_session_t *, iscsi_conn_t *);
extern int iscsi_remove_conn_from_list (iscsi_session_t *, iscsi_conn_t *);
extern void iscsi_add_session_to_list (iscsi_session_t *);
extern int iscsi_remove_session_from_list (iscsi_session_t *);
extern void iscsi_add_cmd_to_immediate_queue (iscsi_cmd_t *, iscsi_conn_t *, u8);
extern iscsi_queue_req_t *iscsi_get_cmd_from_immediate_queue (iscsi_conn_t *);
extern void iscsi_remove_cmd_from_immediate_queue (iscsi_cmd_t *, iscsi_conn_t *);
extern iscsi_cmd_t *iscsi_get_cmd_from_pool (iscsi_session_t *);
extern void iscsi_release_cmd_to_pool (iscsi_cmd_t *, iscsi_session_t *);
extern void iscsi_release_all_cmds_in_pool (iscsi_session_t *);
extern void iscsi_add_cmd_to_session_queue (iscsi_cmd_t *, iscsi_session_t *);
extern iscsi_cmd_t *iscsi_get_cmd_from_session_queue (iscsi_session_t *);
extern iscsi_cmd_t *iscsi_allocate_cmd (iscsi_session_t *, struct scsi_cmnd *);
extern void iscsi_attach_cmd_to_conn (iscsi_cmd_t *, iscsi_conn_t *);
extern void __iscsi_remove_cmd_from_conn_list (iscsi_cmd_t *, iscsi_conn_t *);
extern void iscsi_remove_cmd_from_conn_list (iscsi_cmd_t *, iscsi_conn_t *);
extern int iscsi_free_command_from_conn (iscsi_cmd_t *, iscsi_conn_t *);
extern int iscsi_free_command_from_sess (iscsi_cmd_t *, iscsi_session_t *);
extern void iscsi_stop_datain_timers_for_cmds (iscsi_conn_t *);
extern int iscsi_free_all_commands_for_conn (iscsi_conn_t *);
extern void iscsi_free_all_cr_entries (iscsi_session_t *);
extern void iscsi_free_all_cr_queue_cmds (iscsi_session_t *);
extern int iscsi_free_all_commands_for_sess (iscsi_session_t *);
extern int iscsi_start_login_process (iscsi_login_holder_t *);
extern void iscsi_add_cr_cmds_to_channel (iscsi_session_t *);
extern void iscsi_add_cr_queue_cmds_to_channel (iscsi_session_t *);
extern int iscsi_process_response (iscsi_conn_t *, iscsi_cmd_t *, unsigned char *);
extern iscsi_cmd_t *iscsi_find_cmd_from_itt (iscsi_conn_t *, u32);
extern iscsi_cmd_t *iscsi_find_cmd_from_itt_or_dump (iscsi_conn_t *, u32, u32);
extern int iscsi_set_initiator_name (char *);
extern int iscsi_set_sync_and_steering_values (iscsi_conn_t *);
extern iscsi_conn_t *iscsi_get_conn (iscsi_session_t *);
extern iscsi_conn_t *iscsi_get_conn_from_cid (iscsi_session_t *, u16);
extern void iscsi_check_cmd_usage_count (iscsi_cmd_t *);
extern void iscsi_dec_cmd_usage_count (iscsi_cmd_t *);
extern void iscsi_inc_cmd_usage_count (iscsi_cmd_t *);
extern void iscsi_check_scsi_usage_count (iscsi_cmd_t *, int);
extern void __iscsi_dec_scsi_usage_count (iscsi_cmd_t *);
extern void iscsi_dec_scsi_usage_count (iscsi_cmd_t *);
extern void __iscsi_inc_scsi_usage_count (iscsi_cmd_t *);
extern void iscsi_inc_scsi_usage_count (iscsi_cmd_t *);
extern void iscsi_check_conn_usage_count (iscsi_conn_t *);
extern void __iscsi_dec_conn_usage_count (iscsi_conn_t *);
extern void iscsi_dec_conn_usage_count (iscsi_conn_t *);
extern void __iscsi_inc_conn_usage_count (iscsi_conn_t *);
extern void iscsi_inc_conn_usage_count (iscsi_conn_t *);
extern void iscsi_update_cmdsn (iscsi_session_t *, u32, u32, int);
extern int iscsi_update_statsn (iscsi_conn_t *, iscsi_cmd_t *cmd, u32, u8);
extern void iscsi_add_r2t_to_cmd (iscsi_cmd_t *, iscsi_r2t_t *);
extern iscsi_r2t_t *iscsi_allocate_r2t (void);
extern iscsi_pdu_t *iscsi_get_pdu_holder_from_r2t (iscsi_cmd_t *, iscsi_r2t_t *);
extern iscsi_r2t_t *iscsi_get_r2t_for_cmd (iscsi_cmd_t *);
extern int iscsi_set_pdu_values_for_r2t (iscsi_cmd_t *, iscsi_r2t_t *);
extern void iscsi_free_r2t (iscsi_cmd_t *, iscsi_r2t_t *);
extern iscsi_session_t *iscsi_get_session_from_sid (u32);
extern void iscsi_check_session_usage_count (iscsi_session_t *);
extern void __iscsi_dec_session_usage_count (iscsi_session_t *);
extern void iscsi_dec_session_usage_count (iscsi_session_t *);
extern void __iscsi_inc_session_usage_count (iscsi_session_t *);
extern void iscsi_inc_session_usage_count (iscsi_session_t *);
extern char *iscsi_ntoa (u32);
extern void iscsi_ntoa2 (unsigned char *, __u32);
extern u64 iscsi_put_lun (unsigned int);
extern u32 iscsi_get_lun (unsigned char *);
extern void iscsi_print_sess_params (iscsi_session_t *);
extern void iscsi_start_netif_timer (iscsi_conn_t *);
extern void iscsi_stop_netif_timer (iscsi_conn_t *);
extern void iscsi_mod_nopout_response_timer (iscsi_conn_t *);
extern void iscsi_start_nopout_response_timer (iscsi_conn_t *);
extern void iscsi_stop_nopout_response_timer (iscsi_conn_t *);
extern void iscsi_start_nopout_timer (iscsi_conn_t *);
extern void iscsi_stop_nopout_timer (iscsi_conn_t *);
extern void iscsi_cmd_state_check (iscsi_cmd_t *);
extern int iscsi_cmd_state_wait (iscsi_cmd_t *);
extern unsigned char *iscsi_rx_data_payload (iscsi_conn_t *, u32);
extern int iscsi_send_tx_data (iscsi_cmd_t *, iscsi_conn_t *, int);
extern int rx_data (iscsi_conn_t *, struct iovec *, int, int);
extern int tx_data (iscsi_conn_t *, struct iovec *, int, int);

#endif /* ISCSI_INITIATOR_UTIL_H */
