/*
 * Copyright (c) 2004-2005 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 *  
 * This file houses the iSCSI Initiator specific SCSI timeout and TMR related functions.
 *
 * Nicholas A. Bellinger <nab@kernel.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#define ISCSI_INITIATOR_SCSI_C
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/slab.h>
#include <linux/spinlock.h>
#include <linux/smp_lock.h>
#include <linux/interrupt.h>
#include <linux/blkdev.h>
#include <scsi/scsi_cmnd.h>
#include <scsi/scsi_host.h>
#include <iscsi_linux_os.h>
#include <iscsi_protocol.h>
#include <iscsi_debug.h>
#include <iscsi_lists.h>
#include <iscsi_initiator_core.h>
#include <iscsi_initiator_channel.h>
#include <iscsi_initiator_erl0.h>
#include <iscsi_initiator_linux.h>
#include <iscsi_initiator_lu.h>
#include <iscsi_initiator_scsi.h>
#include <iscsi_initiator_util.h>

#undef ISCSI_INITIATOR_SCSI_C

/*	iscsi_linux_eh_scsi_timeout():
 *
 *	Used in struct scsi_host_template->eh_timed_out() from
 *	drivers/scsi/scsi_error.c:scsi_times_out()
 */
extern enum scsi_eh_timer_return iscsi_linux_eh_scsi_timeout (struct scsi_cmnd *sc)
{	
	iscsi_cmd_t *cmd = (iscsi_cmd_t *) sc->SCp.ptr;
	iscsi_conn_t *conn;
	iscsi_lun_t *lu;
	iscsi_channel_t *ch;

	if (!cmd || !CONN(cmd)) {
		printk("iscsi_cmd_t is NULL for sc to %d/%d/%d\n",
			sc->device->channel, sc->device->id, sc->device->lun);
		return(EH_RESET_TIMER);
	}
	conn = CONN(cmd);
	lu = &cmd->lun;
	ch = lu->channel;
	
	iscsi_inc_session_usage_count(SESS(conn));
	
	printk("iCHANNEL[%d]_LU[%u] - SCSI Task Timeout with ITT: 0x%08x\n",
		ch->channel_id, lu->lun, cmd->init_task_tag);
	/*
	 * If the device has not come online yet, take it offline and try 
	 * again later.  Note in this case that the iSCSI Channel thread will
	 * handle decrementing cmd->cmd_usage_count.
	 */
	if (!iscsi_OS_check_lu_online(lu->OS_SCSI_lu)) {
		iscsi_channel_req_t *cr;
loop:	
		if (!(cr = iscsi_allocate_ch_req(CREQ_STOP_SCSI_CMD_FROM_TIMER,
				(void *)cmd, 1, NULL)))
			goto loop;

		ISCSI_ADD_CH_req(cr, ch);
		iscsi_dec_session_usage_count(SESS(conn));
		return(EH_RESET_TIMER);
	}

	printk("iCHANNEL[%d]_LU[%d] - Forcing Session Reinstatement for timed-out SCSI Task"
		" to ONLINE Logical Unit\n", ch->channel_id, lu->lun);
	
	__iscsi_cause_session_reinstatement(SESS(conn));
	iscsi_dec_session_usage_count(SESS(conn));
	
	/*
	 * At this point we are done accessing the iscsi_cmd_t in question.
	 */
	iscsi_dec_scsi_usage_count(cmd);
	
	return(EH_RESET_TIMER);
}

/*	iscsi_start_scsi_task_timer():
 *
 *
 */
extern void iscsi_start_scsi_task_timer (iscsi_cmd_t *cmd, iscsi_channel_t *ch)
{
	iscsi_inc_scsi_usage_count(cmd);
	return;
}
