/*
 * Copyright (c) 2003, 2004, 2005 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 * 
 * This file houses definitions related to the LINUX SCSI Mid-Layer.
 *
 * Nicholas A. Bellinger <nab@kernel.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#ifndef ISCSI_LINUX_INITIATOR_SCSI_DEFS_H
#define ISCSI_LINUX_INITIATOR_SCSI_DEFS_H

static int iscsi_linux_proc_info (struct Scsi_Host *, char *, char **, off_t, int, int);
extern int iscsi_linux_init (struct scsi_host_template *);
extern int iscsi_linux_fini (void);
static const char *iscsi_linux_info (struct Scsi_Host *);
static inline int iscsi_linux_queuecommand (struct scsi_cmnd *, void (* done)(struct scsi_cmnd *));
extern enum scsi_eh_timer_return iscsi_linux_eh_scsi_timeout (struct scsi_cmnd *);
static int iscsi_linux_eh_strategy_handler (struct Scsi_Host *);
static int iscsi_linux_biosparam (struct scsi_device *, struct block_device *, sector_t, int []);

#define SCSI_MAX_CAN_QUEUE		255
#define SCSI_MIN_CAN_QUEUE		1
#define SCSI_DEFAULT_CAN_QUEUE		64

#define SCSI_MAX_CMD_PER_LUN		64
#define SCSI_MIN_CMD_PER_LUN		1
#define SCSI_DEFAULT_CMD_PER_LUN	32

#define SCSI_MAX_SG_TABLESIZE		64
#define SCSI_MIN_SG_TABLESIZE		8
#define SCSI_DEFAULT_SG_TABLESIZE	32

#define SCSI_DEFAULT_MAXSECTORS		0 /* Let Linux set the default */

#define SCSI_MAX_CHANNELS		1
#define SCSI_MAX_TARGET_IDS		1
#define SCSI_MAX_LUNS			ISCSI_MAX_LUNS
#define SCSI_MAX_CDB_LENGTH		16

static unsigned int iscsi_can_queue		= SCSI_DEFAULT_CAN_QUEUE;
static unsigned int iscsi_cmd_per_lun		= SCSI_DEFAULT_CMD_PER_LUN;
static unsigned int iscsi_max_sectors		= SCSI_DEFAULT_MAXSECTORS;
static unsigned int iscsi_sg_tablesize		= SCSI_DEFAULT_SG_TABLESIZE;

struct scsi_host_template iscsi_template = {
	name:				"PyX iSCSI Initiator Core",
	proc_name:			"iscsi_initiator",
	proc_info:			iscsi_linux_proc_info,
	info:				iscsi_linux_info,
	queuecommand:			iscsi_linux_queuecommand,
	eh_timed_out:			iscsi_linux_eh_scsi_timeout,
	eh_strategy_handler:		iscsi_linux_eh_strategy_handler,
	bios_param:			iscsi_linux_biosparam,
	can_queue:			SCSI_DEFAULT_CAN_QUEUE,
	this_id:			-1,
	sg_tablesize:			SCSI_DEFAULT_SG_TABLESIZE,
	cmd_per_lun:			SCSI_DEFAULT_CMD_PER_LUN,
	present:			0,
	unchecked_isa_dma:		0,
	use_clustering:			ENABLE_CLUSTERING,
	emulated:			1,
};

static int __init check_module_params(void)
{
	if (iscsi_can_queue > SCSI_MAX_CAN_QUEUE) {
		printk("iSCSI: module param iscsi_can_queue: %d is"
			" greater than max: %d,  cannot continue.\n",
			iscsi_can_queue, SCSI_MAX_CAN_QUEUE);
		return(-1);
	} else if (iscsi_can_queue < SCSI_MIN_CAN_QUEUE) {
		printk("iSCSI: module param iscsi_can_queue: %d is"
			" less than min: %d,  cannot continue.\n",
			iscsi_can_queue, SCSI_MIN_CAN_QUEUE);
		return(-1);
	} else {
		iscsi_template.can_queue = iscsi_can_queue;
		printk("iSCSI: iscsi_can_queue		= %d\n",
				iscsi_can_queue);
	}
		
	if (iscsi_cmd_per_lun > SCSI_MAX_CMD_PER_LUN) {
		printk("iSCSI: module param iscsi_cmd_per_lun: %d is"
			" greater than max: %d,  cannot continue.\n",
			iscsi_cmd_per_lun, SCSI_MAX_CMD_PER_LUN);
		return(-1);
	} else if (iscsi_cmd_per_lun < SCSI_MIN_CMD_PER_LUN) {
		printk("iSCSI: module param iscsi_cmd_per_lun: %d is"
			" less than min: %d,  cannot continue.\n",
			iscsi_cmd_per_lun, SCSI_MIN_CMD_PER_LUN);
		return(-1);
	} else {
		iscsi_template.cmd_per_lun = iscsi_cmd_per_lun;
		printk("iSCSI: iscsi_cmd_per_lun	= %d\n",
				iscsi_cmd_per_lun);
	}

	if (iscsi_max_sectors) {
		iscsi_template.max_sectors = iscsi_max_sectors;
		printk("iSCSI: iscsi_max_sectors	= %d\n",
				iscsi_max_sectors);
	}
		
	if (iscsi_sg_tablesize > SCSI_MAX_SG_TABLESIZE) {
		printk("iSCSI: module param iscsi_sg_tablesize: %d is"
			" greater than max: %d,  cannot continue.\n",
			iscsi_sg_tablesize, SCSI_MAX_SG_TABLESIZE);
		return(-1);
	} else if (iscsi_sg_tablesize < SCSI_MIN_SG_TABLESIZE) {
		printk("iSCSI: module param iscsi_sg_tablesize: %d is"
			" less than min: %d,  cannot continue.\n",
			iscsi_sg_tablesize, SCSI_MIN_SG_TABLESIZE);
		return(-1);
	} else {
		iscsi_template.sg_tablesize = iscsi_sg_tablesize;
		printk("iSCSI: iscsi_sg_tablesize	= %d\n",
				iscsi_sg_tablesize);
	}
		
	return(0);
}

extern int iscsi_initiator_mod_init (void);
				
static int __init init_iscsi_module(void)
{
	if (check_module_params() < 0)
		return(-ENODEV);

        if (iscsi_initiator_mod_init() < 0)
		return(-ENODEV);
	
	iscsi_template.module = THIS_MODULE;

	if (!(iscsi_linux_init(&iscsi_template)))
		return(0);

	return(-ENODEV);
}

static void __exit exit_iscsi_module(void)
{
	iscsi_linux_fini();
	return;
}

#ifdef MODULE
MODULE_DESCRIPTION("PyX iSCSI Initiator Driver Core 1.x Release");
MODULE_LICENSE("GPL");
MODULE_PARM(iscsi_can_queue, "i");
MODULE_PARM(iscsi_cmd_per_lun, "i");
MODULE_PARM(iscsi_sg_tablesize, "i");
#endif /* MODULE */
module_init(init_iscsi_module);
module_exit(exit_iscsi_module);
#endif /* ISCSI_LINUX_INITIATOR_SCSI_DEFS_H */
