/*
 * Copyright (c) 2003-2004 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 *
 * This file houses error recovery level zero definitions used by
 *  the iSCSI Initiator driver.
 */
#ifndef ISCSI_INITIATOR_ERL0_H
#define ISCSI_INITIATOR_ERL0_H

extern void iscsi_set_datain_sequence_values (iscsi_cmd_t *);
extern int iscsi_check_pre_datain (iscsi_cmd_t *, unsigned char *);
extern int iscsi_check_post_datain (iscsi_cmd_t *, unsigned char *, u8);
extern int iscsi_build_retry_command (iscsi_cmd_t *, iscsi_conn_t *, iscsi_unmap_sg_t *);
extern void iscsi_cause_connection_reinstatement (iscsi_conn_t *, int);
extern void iscsi_stop_connection_and_reinstatement (iscsi_conn_t *);
extern void __iscsi_cause_session_reinstatement (iscsi_session_t *);
extern void iscsi_cause_session_reinstatement (iscsi_session_t *);
extern void iscsi_stop_session_and_reinstatement (iscsi_session_t *, int);
extern int iscsi_connection_reconnect (iscsi_conn_t *);
extern int iscsi_session_reinstatement (iscsi_channel_t *);
extern void iscsi_take_action_for_connection_exit (iscsi_conn_t *);
extern int iscsi_recover_from_unknown_opcode (iscsi_conn_t *);

#endif /* ISCSI_INITIATOR_ERL0_H */

