/***********************************************************************
/ Copyright (c) 2001, Nishan Systems, Inc.
/ All rights reserved.
/ 
/ Redistribution and use in source and binary forms, with or without 
/ modification, are permitted provided that the following conditions are 
/ met:
/ 
/ - Redistributions of source code must retain the above copyright notice, 
/   this list of conditions and the following disclaimer. 
/ 
/ - Redistributions in binary form must reproduce the above copyright 
/   notice, this list of conditions and the following disclaimer in the 
/   documentation and/or other materials provided with the distribution. 
/ 
/ - Neither the name of the Nishan Systems, Inc. nor the names of its 
/   contributors may be used to endorse or promote products derived from 
/   this software without specific prior written permission. 
/ 
/ THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
/ AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
/ IMPLIED WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS FOR A 
/ PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL NISHAN SYSTEMS, INC. 
/ OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
/ EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
/ PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
/ OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
/ WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
/ OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
/ ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
/
/***********************************************************************/
#include <signal.h>
#include "isns.h"

#include "iscsi.h"
#include "util.h"
#include "comm.h"
#include "menu.h"

extern int hexDumpFlag;
extern int parserFlag;

void HexDumpToggle(void);
void ParserToggle(void);
void ReplaceSet(void);
int register_initiator(void);
int deregister_initiator(void);
int register_target(void);
int deregister_target(void);
int snooper(void);
int initiator_status(void);
int sync_portals(void);
int check_initiator_registration_status(void);
int check_target_registration_status(void);
int get_network_portals(void);
int get_initiators_full(void);

/* Number of menu options */
//#define MENU_SIZE             (53)
#define MENU_SIZE 6
int replaceFlag = FALSE;
int node_flag = 0;
/***********************************************************************/
/* These are all the menu options.  The 1st field is the option name.
   2nd is a unique ID, 3rd is the function call. */
/***********************************************************************/
MENU_ITEM menu[MENU_SIZE] = {
   {"Query for iSCSI Node",      12,      GetISCSI},
   {"Check Initiator registration status",   307,     check_initiator_registration_status},
   {"Register this iSCSI Initiator", 308,   register_initiator},
   {"Deregister this iSCSI Initiator", 309, deregister_initiator},
   {"Run initiator status daemon", 310,	    initiator_status},
   {"Get a list of Network Portals", 311,   get_network_portals},
};

void ReplaceSet(void)
{
   char cmdLine[ 256 ];
   if ( GetYesNo(cmdLine, "Enable REPLACE flag", 
        replaceFlag, sizeof(cmdLine)))
   {
      replaceFlag = TRUE;
   }
   else
   {
      replaceFlag = FALSE;
   }

   printf ("Replace bit is %s!\n", replaceFlag?"ENABLED":"DISABLED");
}

void HexDumpToggle(void)
{
   hexDumpFlag = hexDumpFlag?FALSE:TRUE;
   printf("Hex dump is now %s.\n", hexDumpFlag?"ON":"OFF");
}

void ParserToggle(void)
{
   parserFlag = parserFlag?FALSE:TRUE;
   printf("PDU Parser is now %s.\n", parserFlag?"ON":"OFF");
}

/***********************************************************************/
/* Displays the menu */
/***********************************************************************/
void
DisplayMenu (void)
{
   int i;
   printf ("Item\t Menu Name\n");
   printf ("----\t ---------\n");
   for (i = 0; i < MENU_SIZE; i++)
   {
      printf ("%d)\t %s.\n", menu[i].id, menu[i].name);
   }
}

/* Exit on connection timeout */
void
ExitOnTimeout(int sig_num)
{
	printf("Connection timeout\n");
	exit(-1);
}

/* Ignore connection timeout */
void
IgnoreTimeout(int sig_num)
{
	return;
}

/***********************************************************************/
/* Prompt the user for a menu selection and calls the menu function. */
/***********************************************************************/
int
Interact (int selection)
{
	int i;

	if (selection < 1) {
		printf("Invalid selection ID: %d\n", selection);
		return(-1);
	}

	for (i = 0; i < MENU_SIZE; i++) {
		if (selection == menu[i].id) {
			if (menu[i].func == NULL) {
				printf("Selection not implemented for ID: %d\n", selection);
				return(-1);
			}

			/* 
			 * Lower TCP connection timeout for all commands except
			 * snooper and initiator_status daemons.
			 */
			if ((selection == 305) || (selection == 310))
				signal(SIGALRM, IgnoreTimeout);
			else
				signal(SIGALRM, ExitOnTimeout);

			return(menu[i].func());
		}
	}
	
	return;
}



