/*
 * Copyright (c) 2003 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 * 
 * This file houses the definitons related to the Initiator IOCTL.
 */

#ifndef ISCSI_INITIATOR_IOCTL_H
#define ISCSI_INITIATOR_IOCTL_H

struct iscsi_client {
	short int ca_params_set_count;
	short int cid;
	short int conns;
	short int debug_type;
	short int force;
	short int lun_remove;
	short int port;
	short int on_cid;
	int target;
	int channel;
	int lun;
	int host;
	int count;
	unsigned int ca_params_set;
	unsigned int ca_value;
	unsigned int channel_attrib;
	unsigned int ip;
	unsigned int max_sectors;
	unsigned int nsessions;
	unsigned int params_set;
	unsigned int sid;
	char dev[12];
	char key[256];
	char value[256];
	char keytext[513]; /* key size + = + value size */
};

#define ISCSI_INITIATOR_DEVICE  "/dev/iscsi"
#define ISCSI_INITIATOR_MINOR   202

#if defined(__KERNEL__) && defined(LINUX)

#ifdef ISCSI_INITIATOR_IOCTL_C
#include <linux/miscdevice.h>
#include <linux/major.h>

extern int iscsi_ioctl (struct inode *, struct file *, unsigned int, unsigned long);
extern int iscsi_open (struct inode *, struct file *);
extern int iscsi_close (struct inode *, struct file *);

#define ISCSI_MINOR	202

static struct file_operations iscsi_fops = {
	owner:		THIS_MODULE,
	ioctl:		iscsi_ioctl,
	open:		iscsi_open,
	release:	iscsi_close,
};

struct miscdevice iscsi_dev = { ISCSI_MINOR, "iscsi", &iscsi_fops };

#endif /* ISCSI_INITIATOR_IOCTL_C */
#endif /* __KERNEL__ && LINUX */

#endif /* ISCSI_INITIATOR_IOCTL_H */
