/***********************************************************************
/ Copyright (c) 2001, Nishan Systems, Inc.
/ All rights reserved.
/ 
/ Redistribution and use in source and binary forms, with or without 
/ modification, are permitted provided that the following conditions are 
/ met:
/ 
/ - Redistributions of source code must retain the above copyright notice, 
/   this list of conditions and the following disclaimer. 
/ 
/ - Redistributions in binary form must reproduce the above copyright 
/   notice, this list of conditions and the following disclaimer in the 
/   documentation and/or other materials provided with the distribution. 
/ 
/ - Neither the name of the Nishan Systems, Inc. nor the names of its 
/   contributors may be used to endorse or promote products derived from 
/   this software without specific prior written permission. 
/ 
/ THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
/ AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
/ IMPLIED WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS FOR A 
/ PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL NISHAN SYSTEMS, INC. 
/ OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
/ EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
/ PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
/ OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
/ WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
/ OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
/ ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
/
/***********************************************************************/
/* -bli0 -i3 -ts3 -nut*/

#ifdef SNS_LINUX
#define DWORD unsigned int
#define WINAPI
#define HANDLE pthread_t*
#include <pthread.h>
#else
#include "getarg.h"
#endif


#include "isns.h"

#include "iscsi.h"
#include "util.h"
#include "comm.h"
#include "menu.h"

/***************************************
 Globals
 **************************************/
int debugFlag = FALSE;
char p_ip[256];
char alias[256];
uint32_t g_dd_id;
uint32_t g_dds_id;
char     g_sym_name[DD_SYM_NAME_SIZE];

/********************************
********************************/
extern int isns_port;
extern int enableESIFlag;
extern char multicast_addr[20];
int alias_set = FALSE;

/********************************
********************************/


/*****************
   Usage Message
*****************/
char Usage[] = "\
Usage: isnsc [options] \n\
Options:\n\
    [-h]          Listen for L2 heartbeat from an iSNS.\n\
    [-s ip]       iSNS Address.\n\
    [-t]          TCP mode.\n\
    [-p port]     Port used for sending. Default is port 60000.\n\
    [-a alias]    iSCSI Alias\n\
    [-j dds_id]   Discovery Domain Set id\n\
    [-k dd_id]    Discovery Domain id\n\
    [-n name/id]  DD/DDS symbolic name or iSCSI node id\n\
    [-i]	  Item.\n\
    [-l]	  Item List.\n\
    [-?]          Help.\n\
\n\
";
#if 0
    [-m grp]      Listens for L3 heartbeat.
#endif

/***********************************************************************/
int
main (int argc, char **argv)
{
   int l3_hb_flag;
   int hb_flag;
   int c, ret;
   int tcpFlag;
   int selection = 0;
   memset (p_ip, 0, sizeof (p_ip));

   if (geteuid() != 0)
   {
      fprintf (stderr, "Error: Requires root permissions\n");
      exit(-1);
   }

//   printf ("IETF iSNS Open Source Client, v%s.\n", ISNS_VERSION);

   if (argc < 1)
   {
      fprintf (stderr, Usage);
      exit (0);
   }

   /* init ESI */
   InitESITable ();

   /* Default Values */
   isns_port = ISNS_SERVER_PORT;
   tcpFlag = FALSE;
   enableESIFlag = TRUE;
   hb_flag = FALSE;
   l3_hb_flag = FALSE;

   /* Parse Command Line arguments */
   while (optind != argc)
   {
      c = getopt (argc, argv, "hltd:p:s:ma:i:j:k:n:");

      switch (c)
      {
      case EOF:
         optarg = argv[optind];
         optind++;
         break;
      case 'a':
	 strcpy(alias, optarg);
	 alias_set = TRUE;
	 break;
      case 't':
         tcpFlag = TRUE;
         break;

      case 'p':
         isns_port = atoi (optarg);
         break;

      case 'd':
         debugFlag = TRUE;
         break;

      case 's':
         strcpy (p_ip, optarg);
         break;

      case 'h':
         hb_flag=TRUE;
         break;

      case 'm':
         l3_hb_flag=TRUE;
         strcpy (multicast_addr, optarg);
         break;

      case 'i':
	 selection = atoi (optarg);
	 break;

      case 'j':
	 g_dds_id = atoi (optarg);
	 break;

      case 'k':
	 g_dd_id = atoi (optarg);
	 break;

      case 'n':
         strcpy (g_sym_name, optarg);
         break;

      case 'l':
	 DisplayMenu();
         exit(0);

      case '?':
      default:
         fprintf (stderr, Usage);
         exit (0);
      }
   }

   if (0 == strlen (p_ip) && hb_flag==FALSE && l3_hb_flag==FALSE)
   {
      /* Error case: No IP */
      fprintf (stderr, Usage);
      exit (0);
   }

   /* Init the Communications sockets */
   if (-1==InitComm(hb_flag, l3_hb_flag, tcpFlag))
      exit(-1);

//   printf ("Using iSNS IP: %s.\n", p_ip);

   ret = Interact(selection);
   /* We Should never return. */

#ifndef SNS_LINUX
   WSACleanup ();
#endif
   return (ret);
}



