/*
 * Copyright (c) 2003, 2004, 2005 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#ifndef ISCSI_INITIATOR_IOCTL_DEFS_H
#define ISCSI_INITIATOR_IOCTL_DEFS_H

#include <iscsi_ipyxd.h>

/* Parameters passed into initiator_ctl */
#define PARAM_CHANNEL_ID		0x00000001
#define PARAM_CONNECTION_COUNT		0x00000002
#define PARAM_IPV4_ADDRESS		0x00000004
#define PARAM_PORT			0x00000008
#define PARAM_SETINITIATORNAME		0x00000010
#define PARAM_ISCSI_PARAMETER		0x00000020
#define PARAM_NETWORK_DEVICE		0x00000040
#define PARAM_SESSION_ID		0x00000080
#define PARAM_CONNECTION_ID		0x00000100
#define PARAM_ON_CONNECTION_ID		0x00000200
#define PARAM_NOP_SECONDS		0x00000400
#define PARAM_DEBUGERL_TYPE		0x00000800
#define PARAM_DEBUGERL_COUNT		0x00001000
#define PARAM_FORCE			0x00002000
#define PARAM_MAX_SECTORS		0x00004000
#define PARAM_LUN_REMOVE		0x00008000
#define PARAM_SCTP_TCP			0x00010000
#define PARAM_SCTP_UDP			0x00020000
#define PARAM_TARGETNAME		0x00040000

#define PARAM_CA_CLOSECONN_REINSTATEMENT	0x00000001
#define PARAM_CA_CMDSN_TIMEOUT			0x00000002
#define PARAM_CA_CMDSN_TIMEOUT_RETRIES		0x00000004
#define PARAM_CA_CONN_RECOVERY_TIMEOUT		0x00000008
#define PARAM_CA_DATAIN_TIMEOUT			0x00000010
#define PARAM_CA_DATAIN_TIMEOUT_RETRIES		0x00000020
#define PARAM_CA_IMMEDIATE_LOGOUT		0x00000040
#define PARAM_CA_IMMEDIATE_TEXT			0x00000080
#define PARAM_CA_LOGIN_RETRIES			0x00000100
#define PARAM_CA_LOGIN_RETRY_WAIT		0x00000200
#define PARAM_CA_LOGIN_TIMEOUT			0x00000400
#define PARAM_CA_LOGOUT_TIMEOUT			0x00000800
#define PARAM_CA_NETIF_TIMEOUT			0x00001000
#define PARAM_CA_NOPOUT_TIMEOUT			0x00002000
#define PARAM_CA_NOPOUT_RESPONSE_TIMEOUT	0x00004000
#define PARAM_CA_RANDOM_DATAOUT_PDU_OFFSETS	0x00008000
#define PARAM_CA_TPGFAILOVER			0x00010000
#define PARAM_CA_TPGFAILOVER_ATTEMPTS		0x00020000
#define PARAM_CA_TPGFAILOVER_LOGIN_RETRIES	0x00040000

/* Used to set channel attribute */
#define CA_SET_CLOSECONN_REINSTATEMENT		1	/* Perform Session Reinstatement upon CLOSECONNECTION failure */
#define CA_SET_CMDSN_TIMEOUT			2	/* CmdSN Timeout to retry non immediate CmdSN */
#define CA_SET_CMDSN_TIMEOUT_RETRIES		3	/* CmdSN Timeout Retries before failing session */
#define CA_SET_DATAIN_TIMEOUT			4	/* DataIN Timeout to send Data Snack */
#define CA_SET_DATAIN_TIMEOUT_RETRIES		5	/* DataIN Timeout Retires before failing connection */
#define CA_SET_IMMEDIATE_LOGOUT			6	/* Non REMOVECONNFORRECOVERY Logout request set immediate bit */
#define CA_SET_IMMEDIATE_TEXT			7	/* Text Requets set immediate bit */
#define CA_SET_LOGIN_RETRIES			8	/* Login Attempts to network portal before giving up */
#define CA_SET_LOGIN_RETRY_WAIT			9  	/* Time to wait before attempting relogin */
#define CA_SET_LOGIN_TIMEOUT			10	/* Time to wait before aborting login attempt */
#define CA_SET_LOGOUT_TIMEOUT			11	/* Time to wait before aborting logout attempt */
#define CA_SET_LU_SCAN_TIMEOUT			12	/* Time to wait before aborting Logical Unit Scan */
#define CA_SET_NETIF_TIMEOUT			13	/* Network interface Link Falure timeout check */
#define CA_SET_NOPOUT_TIMEOUT			14	/* Time to wait between sending NOPOUT requests */
#define CA_SET_NOPOUT_RESPONSE_TIMEOUT		15	/* Time to wait before not receiving NOPIN and failing connection */
#define CA_SET_RANDOM_DATAOUT_PDU_OFFSETS	16	/* Randomize DataOUT PDU Offsets for DataPDUInOrder=No */
#define CA_SET_SCSI_TASK_ONLINE_TIMEOUT		17	/* Timeout for SCSI Tasks to an ONLINE (ie: Post Lunscan) SCSI Device */
#define CA_SET_SCSI_TASK_OFFLINE_TIMEOUT	18	/* Timeout for SCSI Tasks to a OFFLINE (ie: Pre Lunscan) SCSI Device */
#define CA_SET_TPGFAILOVER			19	/* Perform TPG Failover after CA_SET_LOGIN_RETRY_FOR_FAILOVER */
#define CA_SET_TPGFAILOVER_ATTEMPTS		20	/* TPG Failover attempts before failing connection */
#define CA_SET_TPGFAILOVER_LOGIN_RETRIES	21	/* Login Retries before doing TPG Failover */

typedef enum {
	ISCSI_INITIATOR_FULLINIT_CHANNEL	= 0x0001,
	ISCSI_INITIATOR_INIT_CHANNEL		= 0x0002,
	ISCSI_INITIATOR_FREE_CHANNEL		= 0x0003,
	ISCSI_INITIATOR_FORCE_CHANNEL_OFFLINE	= 0x0004,
	ISCSI_INITIATOR_SET_CHANNEL_ATTRIB	= 0x0005,
	ISCSI_INITIATOR_STOP_CHANNEL		= 0x0006,
	ISCSI_INITIATOR_LOGIN			= 0x0007,
	ISCSI_INITIATOR_SCANSCSI		= 0x0008,
	ISCSI_INITIATOR_LOGOUTSESS		= 0x0009,
	ISCSI_INITIATOR_LOGOUTCONN		= 0x000A,
	ISCSI_INITIATOR_LISTCHANNELPARAMS	= 0x000B,
	ISCSI_INITIATOR_LISTSESSPARAMS		= 0x000C,
	ISCSI_INITIATOR_SETCHANNELPARAM		= 0x000D,
	ISCSI_INITIATOR_SETSESSPARAM		= 0x000E,
	ISCSI_INITIATOR_SETINITNAME		= 0x000F,
	ISCSI_INITIATOR_LISTKNOWNTARGETS	= 0x0010,
	ISCSI_INITIATOR_ADDCONN			= 0x0020,
	ISCSI_INITIATOR_DEBUG_ERL		= 0x0030,
	ISCSI_INITIATOR_CHECK_KEY		= 0x0040,
} ISCSI_CMD_CTL;

#endif /* ISCSI_INITIATOR_IOCTL_DEFS_H */

