/*
 * Copyright (c) 2003, 2004, 2005 PyX Technologies, Inc.
 * Copyright (c) 2005 SBE, Inc.
 * 
 * This file houses definitions related to the
 * 	iSCSI Initiator Authentication Daemon.
 */
#ifndef ISCSI_AUTH_H
#define ISCSI_AUTH_H

#define VERSION		"v1.0"
#define AUTH_PORT	5002
#define TEXT_LEN 	4096
#define AUTH_CLIENT	1
#define AUTH_SERVER	2
#define	MAX_AUTH_CONN	16
#define DECIMAL		0
#define HEX		1
#define BASE64		2
#define MAX_USER_LEN	256
#define MAX_PASS_LEN	256
#define MAX_BUF		512
#define MAX_INITIATORNAME 256
#define INITIATOR_AUTH	"initiator-authd"
#define CLIENT_AUTHPATH "/etc/sysconfig/initiator_auth"

extern void convert_null_to_semi (char *, int);
extern int extract_param (const char *, const char *, unsigned int, char *, unsigned char *);
extern void remove_auth_conn (unsigned int);

typedef struct auth_conn_s {
	int		authenticate_target;
	unsigned char	auth_state;
	unsigned char	in_use;
	unsigned short	cid;
	unsigned int	sid;
	unsigned int	auth_id;
	int		role;
	int		channel_id;
	unsigned short int tpgt;
	char		initiatorname[MAX_INITIATORNAME];
	void		*auth_protocol;
	char		userid[MAX_USER_LEN];
	char		password[MAX_PASS_LEN];
	char		ma_userid[MAX_USER_LEN];	
	char		ma_password[MAX_PASS_LEN];
} auth_conn_t;

extern int iscsi_get_client_auth_info (auth_conn_t *);
extern int iscsi_get_server_auth_info (auth_conn_t *);

typedef struct auth_daemon_s {
	char		kill_auth_id;
	int		channel_id;
	unsigned short	cid;
	unsigned int	sid;
	unsigned int	auth_id;
	unsigned int	role;
	unsigned short int tpgt;
        char            initiatorname[MAX_INITIATORNAME];
	char		type[15];
	char		in_text[TEXT_LEN];
	unsigned int	in_len;
	char		out_text[TEXT_LEN];
	unsigned int	out_len;
} auth_daemon_t;

#endif /* ISCSI_AUTH_H */
