/*
 * hankaku.c  ->ȾѴ
 *
 * Copyright (C) 1997-1998 Masaki Chikama (Wren) <chikama@kasumi.ipl.mech.nagoya-u.ac.jp>
 *               1998-                           <masaki-c@is.aist-nara.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
*/
/* $Id: hankaku.c,v 1.7 2001/03/22 11:10:13 chikama Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "portab.h"

/* defined by hankan2sjis.c */
extern char *hankana2sjis(int index);

static BYTE hankakutable[3][192][2] = {{
	{0x00, 0x20}, /* SPC */
	{0x00, 0xa4}, /*  */
	{0x00, 0xa2}, /*  */ 
	{0x00, 0x2c}, /* , */
	{0x00, 0x2e}, /* . */
	{0x00, 0xa5}, /*  */
	{0x00, 0x3a}, /* : */
	{0x00, 0x3b}, /* ; */
	{0x00, 0x3f}, /* ? */
	{0x00, 0x21}, /* ! */
	{0x00, 0xde}, /*  */
	{0x00, 0xdf}, /*  */
	{0x00, 0x27}, /* ' */
	{0x00, 0x60}, /* ` */
	{0x81, 0x4e},
	{0x00, 0x5d}, /* ^ */
	{0x00, 0x7e}, /* ~ */ 
	{0x00, 0x5f}, /* _ */
	{0x81, 0x52},
	{0x81, 0x53},
	{0x81, 0x54},
	{0x81, 0x55},
	{0x81, 0x56},
	{0x81, 0x57},
	{0x81, 0x58},
	{0x81, 0x59},
	{0x81, 0x5a},
	{0x00, 0xb0}, /*  */
	{0x81, 0x5c},
	{0x81, 0x5d},
	{0x00, 0x2f}, /* / */
	{0x81, 0x5f},
	{0x81, 0x60},
	{0x81, 0x61},
	{0x00, 0x7c}, /* | */
	{0x81, 0x63},
	{0x81, 0x64},
	{0x81, 0x65},
	{0x00, 0x27}, /* ' */
	{0x81, 0x67}, 
	{0x00, 0x22}, /*  */
	{0x00, 0x28}, /* ( */
	{0x00, 0x29}, /* ) */
	{0x81, 0x6b},
	{0x81, 0x6c},
	{0x00, 0x5b}, /* [ */
	{0x00, 0x5d}, /* ] */
	{0x00, 0x7b}, /* { */
	{0x00, 0x7d}, /* } */
	{0x81, 0x71},
	{0x81, 0x72},
	{0x81, 0x73},
	{0x81, 0x74},
	{0x00, 0xa2}, /*  */
	{0x00, 0xa3}, /*  */
	{0x81, 0x77},
	{0x81, 0x78},
	{0x81, 0x79},
	{0x81, 0x7a},
	{0x00, 0x2b}, /* + */
	{0x00, 0x2d}, /* - */
	{0x81, 0x7d},
	{0x81, 0x7e},
	{0x81, 0x7f},
	{0x81, 0x80},
	{0x00, 0x3d}, /* = */
	{0x81, 0x82},
	{0x00, 0x3c}, /* < */
	{0x00, 0x3e}, /* > */
	{0x81, 0x85},
	{0x81, 0x86},
	{0x81, 0x87},
	{0x81, 0x88},
	{0x81, 0x89},
	{0x81, 0x8a},
	{0x81, 0x8b},
	{0x81, 0x8c},
	{0x81, 0x8d},
	{0x81, 0x8e},
	{0x00, 0x5c}, /*  */
	{0x00, 0x24}, /* $ */
	{0x81, 0x91},
	{0x81, 0x92},
	{0x00, 0x25}, /* % */
	{0x00, 0x23}, /* # */
	{0x00, 0x26}, /* & */
	{0x00, 0x2a}, /* * */
	{0x00, 0x40}, /* @ */
	{0x81, 0x98},
	{0x81, 0x99},
	{0x81, 0x9a},
	{0x81, 0x9b},
	{0x81, 0x9c},
	{0x81, 0x9d},
	{0x81, 0x9e},
	{0x81, 0x9f},
	{0x81, 0xa0},
	{0x81, 0xa1},
	{0x81, 0xa2},
	{0x81, 0xa3},
	{0x81, 0xa4},
	{0x81, 0xa5},
	{0x81, 0xa6},
	{0x81, 0xa7},
	{0x81, 0xa8},
	{0x81, 0xa9},
	{0x81, 0xaa},
	{0x81, 0xab},
	{0x81, 0xac},
	{0x81, 0xad},
	{0x81, 0xae},
	{0x81, 0xaf},
	{0x81, 0xb0},
	{0x81, 0xb1},
	{0x81, 0xb2},
	{0x81, 0xb3},
	{0x81, 0xb4},
	{0x81, 0xb5},
	{0x81, 0xb6},
	{0x81, 0xb7},
	{0x81, 0xb8},
	{0x81, 0xb9},
	{0x81, 0xba},
	{0x81, 0xbb},
	{0x81, 0xbc},
	{0x81, 0xbd},
	{0x81, 0xbe},
	{0x81, 0xbf},
	{0x81, 0xc0},
	{0x81, 0xc1},
	{0x81, 0xc2},
	{0x81, 0xc3},
	{0x81, 0xc4},
	{0x81, 0xc5},
	{0x81, 0xc6},
	{0x81, 0xc7},
	{0x81, 0xc8},
	{0x81, 0xc9},
	{0x81, 0xca},
	{0x81, 0xcb},
	{0x81, 0xcc},
	{0x81, 0xcd},
	{0x81, 0xce},
	{0x81, 0xcf},
	{0x81, 0xd0},
	{0x81, 0xd1},
	{0x81, 0xd2},
	{0x81, 0xd3},
	{0x81, 0xd4},
	{0x81, 0xd5},
	{0x81, 0xd6},
	{0x81, 0xd7},
	{0x81, 0xd8},
	{0x81, 0xd9},
	{0x81, 0xda},
	{0x81, 0xdb},
	{0x81, 0xdc},
	{0x81, 0xdd},
	{0x81, 0xde},
	{0x81, 0xdf},
	{0x81, 0xe0},
	{0x81, 0xe1},
	{0x81, 0xe2},
	{0x81, 0xe3},
	{0x81, 0xe4},
	{0x81, 0xe5},
	{0x81, 0xe6},
	{0x81, 0xe7},
	{0x81, 0xe8},
	{0x81, 0xe9},
	{0x81, 0xea},
	{0x81, 0xeb},
	{0x81, 0xec},
	{0x81, 0xed},
	{0x81, 0xee},
	{0x81, 0xef},
	{0x81, 0xf0},
	{0x81, 0xf1},
	{0x81, 0xf2},
	{0x81, 0xf3},
	{0x81, 0xf4},
	{0x81, 0xf5},
	{0x81, 0xf6},
	{0x81, 0xf7},
	{0x81, 0xf8},
	{0x81, 0xf9},
	{0x81, 0xfa},
	{0x81, 0xfb},
	{0x81, 0xfc},
	{0x81, 0xfd},
	{0x81, 0xfe},
	{0x81, 0xff}
},{
	{0x82, 0x40},
	{0x82, 0x41},
	{0x82, 0x42},
	{0x82, 0x43},
	{0x82, 0x44},
	{0x82, 0x45},
	{0x82, 0x46},
	{0x82, 0x47},
	{0x82, 0x48},
	{0x82, 0x49},
	{0x82, 0x4a},
	{0x82, 0x4b},
	{0x82, 0x4c},
	{0x82, 0x4d},
	{0x82, 0x4e},
	{0x00, 0x30}, /* 0 */
	{0x00, 0x31}, /* 1 */
	{0x00, 0x32}, /* 2 */
	{0x00, 0x33}, /* 3 */
	{0x00, 0x34}, /* 4 */
	{0x00, 0x35}, /* 5 */
	{0x00, 0x36}, /* 6 */
	{0x00, 0x37}, /* 7 */
	{0x00, 0x38}, /* 8 */
	{0x00, 0x39}, /* 9 */
	{0x82, 0x59},
	{0x82, 0x5a},
	{0x82, 0x5b},
	{0x82, 0x5c},
	{0x82, 0x5d},
	{0x82, 0x5e},
	{0x82, 0x5f},
	{0x00, 0x41}, /* A */
	{0x00, 0x42}, /* B */ 
	{0x00, 0x43}, /* C */
	{0x00, 0x44}, /* D */
	{0x00, 0x45}, /* E */
	{0x00, 0x46}, /* F */
	{0x00, 0x47}, /* G */
	{0x00, 0x48}, /* H */
	{0x00, 0x49}, /* I */
	{0x00, 0x4a}, /* J */
	{0x00, 0x4b}, /* K */
	{0x00, 0x4c}, /* L */
	{0x00, 0x4d}, /* M */
	{0x00, 0x4e}, /* N */
	{0x00, 0x4f}, /* O */
	{0x00, 0x50}, /* P */
	{0x00, 0x51}, /* Q */
	{0x00, 0x52}, /* R */
	{0x00, 0x53}, /* S */
	{0x00, 0x54}, /* T */
	{0x00, 0x55}, /* U */
	{0x00, 0x56}, /* V */
	{0x00, 0x57}, /* W */
	{0x00, 0x58}, /* X */
	{0x00, 0x59}, /* Y */
	{0x00, 0x5a}, /* Z */
	{0x82, 0x7a},
	{0x82, 0x7b},
	{0x82, 0x7c},
	{0x82, 0x7d},
	{0x82, 0x7e},
	{0x82, 0x7f},
	{0x82, 0x80},
	{0x00, 0x61}, /* a */
	{0x00, 0x62}, /* b */
	{0x00, 0x63}, /* c */
	{0x00, 0x64}, /* d */
	{0x00, 0x65}, /* e */
	{0x00, 0x66}, /* f */
	{0x00, 0x67}, /* g */
	{0x00, 0x68}, /* h */
	{0x00, 0x69}, /* i */
	{0x00, 0x6a}, /* j */
	{0x00, 0x6b}, /* k */
	{0x00, 0x6c}, /* l */
	{0x00, 0x6d}, /* m */
	{0x00, 0x6e}, /* n */
	{0x00, 0x6f}, /* o */
	{0x00, 0x70}, /* p */
	{0x00, 0x71}, /* q */
	{0x00, 0x72}, /* r */
	{0x00, 0x73}, /* s */
	{0x00, 0x74}, /* t */
	{0x00, 0x75}, /* u */
	{0x00, 0x76}, /* v */
	{0x00, 0x77}, /* w */
	{0x00, 0x78}, /* x */
	{0x00, 0x79}, /* y */
	{0x00, 0x7a}, /* z */
	{0x82, 0x9b},
	{0x82, 0x9c},
	{0x82, 0x9d},
	{0x82, 0x9e},
	{0x82, 0x9f}, /*  */
	{0x82, 0xa0}, /*  */
	{0x82, 0xa1}, /*  */
	{0x82, 0xa2}, /*  */
	{0x82, 0xa3}, /*  */
	{0x82, 0xa4}, /*  */
	{0x82, 0xa5}, /*  */
	{0x82, 0xa6}, /*  */
	{0x82, 0xa7}, /*  */
	{0x82, 0xa8}, /*  */
	{0x82, 0xa9}, /*  */
	{0x82, 0xaa},
	{0x82, 0xab}, /*  */
	{0x82, 0xac},
	{0x82, 0xad}, /*  */
	{0x82, 0xae},
	{0x82, 0xaf}, /*  */
	{0x82, 0xb0},
	{0x82, 0xb1}, /*  */
	{0x82, 0xb2},
	{0x82, 0xb3}, /*  */
	{0x82, 0xb4},
	{0x82, 0xb4}, /*  */
	{0x82, 0xb6},
	{0x82, 0xb7}, /*  */
	{0x82, 0xb8},
	{0x82, 0xb9}, /*  */
	{0x82, 0xba},
	{0x82, 0xbf}, /*  */
	{0x82, 0xbc},
	{0x82, 0xbd}, /*  */
	{0x82, 0xbe},
	{0x82, 0xbf}, /*  */
	{0x82, 0xc0},
	{0x82, 0xc1}, /*  */
	{0x82, 0xc2}, /*  */
	{0x82, 0xc3},
	{0x82, 0xc4}, /*  */
	{0x82, 0xc5},
	{0x82, 0xc6}, /*  */
	{0x82, 0xc7},
	{0x82, 0xc8}, /*  */
	{0x82, 0xc9}, /*  */
	{0x82, 0xca}, /*  */
	{0x82, 0xcb}, /*  */
	{0x82, 0xcc}, /*  */
	{0x82, 0xcd}, /*  */
	{0x82, 0xce},
	{0x82, 0xcf},
	{0x82, 0xd0}, /*  */
	{0x82, 0xd1},
	{0x82, 0xd2},
	{0x82, 0xd3}, /*  */
	{0x82, 0xd4},
	{0x82, 0xd5},
	{0x82, 0xd6}, /*  */
	{0x82, 0xd7},
	{0x82, 0xd8},
	{0x82, 0xd9}, /*  */
	{0x82, 0xda},
	{0x82, 0xdb},
	{0x82, 0xdc}, /*  */
	{0x82, 0xdd}, /*  */
	{0x82, 0xde}, /*  */
	{0x82, 0xdf}, /*  */
	{0x82, 0xe0}, /*  */
	{0x82, 0xe1}, /*  */
	{0x82, 0xe2}, /*  */
	{0x82, 0xe3}, /*  */
	{0x82, 0xe4}, /*  */
	{0x82, 0xe5}, /*  */
	{0x82, 0xe6}, /*  */
	{0x82, 0xe7}, /*  */
	{0x82, 0xe8}, /*  */
	{0x82, 0xe9}, /*  */
	{0x82, 0xea}, /*  */
	{0x82, 0xeb}, /*  */
	{0x82, 0xec},
	{0x82, 0xed}, /*  */
	{0x82, 0xee},
	{0x82, 0xef},
	{0x82, 0xf0}, /*  */
	{0x82, 0xf1}, /*  */
	{0x82, 0xf2},
	{0x82, 0xf3},
	{0x82, 0xf4},
	{0x82, 0xf5},
	{0x82, 0xf6},
	{0x82, 0xf7},
	{0x82, 0xf8},
	{0x82, 0xf9},
	{0x82, 0xfa},
	{0x82, 0xfb},
	{0x82, 0xfc},
	{0x82, 0xfd},
	{0x82, 0xfe},
	{0x82, 0xff}
},{
	{0x00, 0xa7}, /*  */
	{0x00, 0xb1}, /*  */
	{0x00, 0xa8}, /*  */
	{0x00, 0xb2}, /*  */
	{0x00, 0xa9}, /*  */
	{0x00, 0xb3}, /*  */
	{0x00, 0xaa}, /*  */
	{0x00, 0xb4}, /*  */
	{0x00, 0xab}, /*  */
	{0x00, 0xb5}, /*  */
	{0x00, 0xb6}, /*  */
	{0x83, 0x4b},
	{0x00, 0xb7}, /*  */
	{0x83, 0x4d},
	{0x00, 0xb8}, /*  */
	{0x83, 0x4f},
	{0x00, 0xb9}, /*  */
	{0x83, 0x51},
	{0x00, 0xba}, /*  */
	{0x83, 0x53},
	{0x00, 0xbb}, /*  */
	{0x83, 0x55},
	{0x00, 0xbc}, /*  */
	{0x83, 0x57},
	{0x00, 0xbd}, /*  */
	{0x83, 0x59},
	{0x00, 0xbe}, /*  */
	{0x83, 0x5b},
	{0x00, 0xbf}, /*  */
	{0x83, 0x5d},
	{0x00, 0xc0}, /*  */
	{0x83, 0x5f},
	{0x00, 0xc1}, /*  */
	{0x83, 0x61},
	{0x00, 0xaf}, /*  */
	{0x00, 0xc2}, /*  */
	{0x83, 0x64},
	{0x00, 0xc3}, /*  */
	{0x83, 0x66},
	{0x00, 0xc4}, /*  */
	{0x83, 0x68},
	{0x00, 0xc5}, /*  */
	{0x00, 0xc6}, /*  */
	{0x00, 0xc7}, /*  */
	{0x00, 0xc8}, /*  */
	{0x00, 0xc9}, /*  */
	{0x00, 0xca}, /*  */
	{0x83, 0x6f},
	{0x83, 0x70},
	{0x00, 0xcb}, /*  */
	{0x83, 0x72},
	{0x83, 0x73},
	{0x00, 0xcc}, /*  */
	{0x83, 0x75},
	{0x83, 0x76},
	{0x00, 0xcd}, /*  */
	{0x83, 0x78},
	{0x83, 0x79},
	{0x00, 0xce}, /*  */
	{0x83, 0x7b},
	{0x83, 0x7c},
	{0x00, 0xcf}, /*  */
	{0x00, 0xd0}, /*  */
	{0x83, 0x7f},
	{0x00, 0xd1}, /*  */
	{0x00, 0xd2}, /*  */
	{0x00, 0xd3}, /*  */
	{0x00, 0xac}, /*  */
	{0x00, 0xd4}, /*  */
	{0x00, 0xad}, /*  */
	{0x00, 0xd5}, /*  */
	{0x00, 0xae}, /*  */
	{0x00, 0xd6}, /*  */
	{0x00, 0xd7}, /*  */
	{0x00, 0xd8}, /*  */
	{0x00, 0xd9}, /*  */
	{0x00, 0xda}, /*  */
	{0x00, 0xdb}, /*  */
	{0x83, 0x8e},
	{0x00, 0xdc}, /*  */
	{0x83, 0x90},
	{0x83, 0x91},
	{0x00, 0xa6}, /*  */
	{0x00, 0xdd}, /*  */
	{0x83, 0x94},
	{0x83, 0x95},
	{0x83, 0x96},
	{0x83, 0x97},
	{0x83, 0x98},
	{0x83, 0x99},
	{0x83, 0x9a},
	{0x83, 0x9b},
	{0x83, 0x9c},
	{0x83, 0x9d},
	{0x83, 0x9e},
	{0x83, 0x9f},
	{0x83, 0xa0},
	{0x83, 0xa1},
	{0x83, 0xa2},
	{0x83, 0xa3},
	{0x83, 0xa4},
	{0x83, 0xa5},
	{0x83, 0xa6},
	{0x83, 0xa7},
	{0x83, 0xa8},
	{0x83, 0xa9},
	{0x83, 0xaa},
	{0x83, 0xab},
	{0x83, 0xac},
	{0x83, 0xad},
	{0x83, 0xae},
	{0x83, 0xaf},
	{0x83, 0xb0},
	{0x83, 0xb1},
	{0x83, 0xb2},
	{0x83, 0xb3},
	{0x83, 0xb4},
	{0x83, 0xb5},
	{0x83, 0xb6},
	{0x83, 0xb7},
	{0x83, 0xb8},
	{0x83, 0xb9},
	{0x83, 0xba},
	{0x83, 0xbb},
	{0x83, 0xbc},
	{0x83, 0xbd},
	{0x83, 0xbe},
	{0x83, 0xbf},
	{0x83, 0xc0},
	{0x83, 0xc1},
	{0x83, 0xc2},
	{0x83, 0xc3},
	{0x83, 0xc4},
	{0x83, 0xc5},
	{0x83, 0xc6},
	{0x83, 0xc7},
	{0x83, 0xc8},
	{0x83, 0xc9},
	{0x83, 0xca},
	{0x83, 0xcb},
	{0x83, 0xcc},
	{0x83, 0xcd},
	{0x83, 0xce},
	{0x83, 0xcf},
	{0x83, 0xd0},
	{0x83, 0xd1},
	{0x83, 0xd2},
	{0x83, 0xd3},
	{0x83, 0xd4},
	{0x83, 0xd5},
	{0x83, 0xd6},
	{0x83, 0xd7},
	{0x83, 0xd8},
	{0x83, 0xd9},
	{0x83, 0xda},
	{0x83, 0xdb},
	{0x83, 0xdc},
	{0x83, 0xdd},
	{0x83, 0xde},
	{0x83, 0xdf},
	{0x83, 0xe0},
	{0x83, 0xe1},
	{0x83, 0xe2},
	{0x83, 0xe3},
	{0x83, 0xe4},
	{0x83, 0xe5},
	{0x83, 0xe6},
	{0x83, 0xe7},
	{0x83, 0xe8},
	{0x83, 0xe9},
	{0x83, 0xea},
	{0x83, 0xeb},
	{0x83, 0xec},
	{0x83, 0xed},
	{0x83, 0xee},
	{0x83, 0xef},
	{0x83, 0xf0},
	{0x83, 0xf1},
	{0x83, 0xf2},
	{0x83, 0xf3},
	{0x83, 0xf4},
	{0x83, 0xf5},
	{0x83, 0xf6},
	{0x83, 0xf7},
	{0x83, 0xf8},
	{0x83, 0xf9},
	{0x83, 0xfa},
	{0x83, 0xfb},
	{0x83, 0xfc},
	{0x83, 0xfd},
	{0x83, 0xfe},
	{0x83, 0xff}
}};

BYTE *zen2han(BYTE *src) {
	BYTE c0, c1;
	char *dst, *_dst;
	
	dst = _dst = malloc(strlen(src) + 1);
	if (dst == NULL) {
		fprintf(stderr, "zen2han(): Out of Memory (size %d)", strlen(src) + 1);
		return NULL;
	}
	
	while(0 != (c0 = *src++)) {
		if (c0 < 0x81) {
			*dst++ = c0;
		} else if (c0 <= 0x83) {
			c1 = *src++;
			if (hankakutable[c0 - 0x81][c1 - 0x40][0] == 0) {
				*dst++ = hankakutable[c0 - 0x81][c1 - 0x40][1];
			} else {
				*dst++ = c0; *dst++ = c1;
			}
		} else if (c0 < 0xa0){
			*dst++ = c0; *dst++ = *src++;
		} else if (c0 < 0xe0){
			*dst++ = c0;
		} else {
			*dst++ = c0; *dst++ = *src++;
		}
	}
	*dst = 0; 
	return _dst;
}

BYTE *han2zen(BYTE *src) {
	BYTE c0;
	BYTE *dst, *_dst;
	BYTE *kindex;
	dst = _dst = malloc(strlen(src) * 2 + 1);
	
	if (dst == NULL) {
		fprintf(stderr, "han2zen(): Out of Memory (size %d)", strlen(src) *2 + 1);
		return NULL;
	}
	
	while(0 != (c0 = *src++)) {
		if (c0 == 0x20) {
			*dst++ = 0x81; *dst++ = 0x40;
		} else if (c0 < 0x80) {
			*dst++ = c0;
		} else if (c0 >= 0xe0) {
			*dst++ = (char)c0; *dst++ = *src++;
		} else if (c0 >= 0xa0) {
			kindex = hankana2sjis(c0);
			*dst++ = *kindex; *dst++ = *(kindex+1);
		} else {
			*dst++ = (char)c0; *dst++ = *src++;
		}
	}
	*dst = 0; 
	return _dst;
}
