/*
 * Copyright (c) 2006 Alvaro Lopes <alvieboy@alvie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "preferences.h"
#include "modem_driver.h"
#include "autodetect.h"

static void
cellmodem_t_dialog_response( GtkWidget *dlg, int response, cellmodem_t *monitor )
{
    /* Set default driver if none is still defined */


    DEBUG("Got dialog response");


    if (monitor->options.modem_driver == NULL) {
	monitor->options.modem_driver =
	    g_strdup( find_driver_by_index( 0 )->name );
	DEBUG("Setting driver to default entry ('%s')",
              monitor->options.modem_driver );
    }

    gtk_widget_destroy (dlg);
    xfce_panel_plugin_unblock_menu (monitor->plugin);

    cellmodem_write_config (monitor->plugin, monitor);

    /* Reconfigure everything */

    cellmodem_t_initialize_modem( monitor );
}


static void
update_dialog( cellmodem_dialog_t *dialog )
{
    int idx;
    cellmodem_t *monitor = dialog->monitor;

    if ( monitor->options.modem_device != NULL )
	gtk_entry_set_text( GTK_ENTRY(dialog->device_entry),
			   monitor->options.modem_device);

    if (monitor->options.modem_driver != NULL) {
	idx = find_driver_index_by_name( monitor->options.modem_driver );
    } else {
	idx=0;
	/*  monitor->options.modem_driver = find_driver_by_index( idx );*/

    }

    if (idx<=0)
	idx=0;

    gtk_combo_box_set_active(GTK_COMBO_BOX(dialog->driver_entry),idx);



    gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->low_entry),
			      monitor->options.low_threshold);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->critical_entry),
			      monitor->options.critical_threshold);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->maxqual_entry),
			      monitor->options.max_quality);

    /*
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(dialog->ask_pin_entry),
				 monitor->options.ask_for_pin);
    */
}


static void
cb_device_entry_changed(GtkEntry *entry, cellmodem_dialog_t *dialog)
{
    if ( dialog->monitor->options.modem_device != NULL )
	g_free( dialog->monitor->options.modem_device );

    dialog->monitor->options.modem_device = NULL;
            
    const gchar *text =
	gtk_entry_get_text( entry );

    if ( text && strlen( text ) > 0 ) {
	dialog->monitor->options.modem_device = g_strdup( text );
	DEBUG("Modem device: '%s'", text);
    }
}

/*
static void
cb_pin_entry_toggled(GtkToggleButton *entry, cellmodem_dialog_t *dialog)
{
    dialog->monitor->options.ask_for_pin = gtk_toggle_button_get_active(entry);
}
*/
static void
cb_driver_entry_changed(GtkComboBox *combo, cellmodem_dialog_t *dialog)
{
    modem_driver_t *driver;
    int idx;

    if ( dialog->monitor->options.modem_driver != NULL )
	g_free( dialog->monitor->options.modem_driver );

    dialog->monitor->options.modem_driver = NULL;

    idx = gtk_combo_box_get_active( combo );


    driver = find_driver_by_index( idx );

    if (!driver)
	return; /* ????? */

    dialog->monitor->options.modem_driver = g_strdup( driver->name );
}


static void
cb_maxqual_entry_changed(GtkSpinButton *button, cellmodem_dialog_t *dialog)
{
    dialog->monitor->options.max_quality =
	gtk_spin_button_get_value_as_int( button );
    DEBUG("Max qual: %d",
	  dialog->monitor->options.max_quality);
}

static void
cb_low_entry_changed(GtkSpinButton *button, cellmodem_dialog_t *dialog)
{
    dialog->monitor->options.low_threshold =
        gtk_spin_button_get_value_as_int( button );
}

static void
cb_critical_entry_changed(GtkSpinButton *button, cellmodem_dialog_t *dialog)
{
    dialog->monitor->options.critical_threshold =
        gtk_spin_button_get_value_as_int( button );
}

static void
autodetect_dialog_callback( GtkDialog *dlg, int response, cellmodem_dialog_t *dialog )
{

    if ( response == GTK_RESPONSE_OK ) {
	/* Fill in device */

        guint a = gtk_combo_box_get_active( GTK_COMBO_BOX(dialog->device_combo) );

        struct known_device *d = g_list_nth_data( dialog->devices, a );

	if (d && d->info && d->info->device)
	    gtk_entry_set_text( GTK_ENTRY(dialog->device_entry), d->info->device );

	/* Set the driver */

	int di = find_driver_index_by_name( d->driver );

	if (di>=0) {
            gtk_combo_box_set_active( GTK_COMBO_BOX( dialog->driver_entry ), di );
	}

    }

    free_detected_devices( dialog->devices );
    dialog->devices = NULL;

    gtk_widget_destroy( GTK_WIDGET( dialog->autodetect_dialog ) );
}


static void
append_device_info( struct known_device *dev, GtkWidget *w )
{

    if (dev == NULL)
	return;

    gtk_combo_box_append_text(GTK_COMBO_BOX(w), dev->description );

}

static void
cb_autodetect_modem(GtkButton *button, cellmodem_dialog_t *dialog)
{
    GtkWidget *label;

    dialog->device_combo = NULL;

    DEBUG("Getting devices");

    dialog->devices = detect_devices();

    dialog->autodetect_dialog = gtk_dialog_new();

    gtk_dialog_add_button( GTK_DIALOG( dialog->autodetect_dialog), _("Close"), GTK_RESPONSE_CLOSE);

    DEBUG("Parsing devices");

    if ( g_list_length( dialog->devices ) == 0 ) {
	label = gtk_label_new(_("No known device found.") );
    } else {
	label = gtk_label_new(_("The following devices were found:") );
        dialog->device_combo = gtk_combo_box_new_text();

        g_list_foreach( dialog->devices, (GFunc)&append_device_info, dialog->device_combo );

	gtk_combo_box_set_active(GTK_COMBO_BOX( dialog->device_combo ),0);

	gtk_dialog_add_button( GTK_DIALOG( dialog->autodetect_dialog), _("Use this device"), GTK_RESPONSE_OK);

	gtk_widget_show( dialog->device_combo );
    }


    gtk_widget_show( label );



    gtk_box_pack_start( GTK_BOX( GTK_DIALOG(dialog->autodetect_dialog)->vbox ), label, FALSE, FALSE, 0);

    if (dialog->device_combo)
	gtk_box_pack_start( GTK_BOX( GTK_DIALOG(dialog->autodetect_dialog)->vbox ), dialog->device_combo, FALSE, FALSE, 0);

    gtk_window_set_modal( GTK_WINDOW( dialog->autodetect_dialog ), TRUE );

    gtk_window_set_default_size( GTK_WINDOW( dialog->autodetect_dialog ), 300, 100 );

    g_signal_connect (dialog->autodetect_dialog, "response", G_CALLBACK (autodetect_dialog_callback), dialog);


    gtk_widget_show( dialog->autodetect_dialog );
}

void
cellmodem_create_options(XfcePanelPlugin *plugin, cellmodem_t *monitor)
{
    GtkWidget *dlg;
    GtkWidget *header;
    GtkWidget *vbox;
/*    GtkWidget *vbox2;*/
    GtkSizeGroup *sizegr;
    GtkWidget *hbox;
    GtkWidget *label;

    cellmodem_dialog_t *dialog;

    dialog = g_new0(cellmodem_dialog_t, 1);

    dialog->monitor = monitor;

    xfce_panel_plugin_block_menu (plugin);
    
    dlg = gtk_dialog_new_with_buttons (_("Configure Cell Modem Monitor"),
                GTK_WINDOW (gtk_widget_get_toplevel (GTK_WIDGET (plugin))),
                GTK_DIALOG_DESTROY_WITH_PARENT |
                GTK_DIALOG_NO_SEPARATOR,
                GTK_STOCK_CLOSE, GTK_RESPONSE_OK,
                NULL);
    
    g_signal_connect (dlg, "response", G_CALLBACK (cellmodem_t_dialog_response),
                      monitor);


    /* The header - this was most copied from other sources*/

    header = xfce_create_header (NULL, _("Cellular Modem Monitor"));
    gtk_widget_set_size_request (GTK_BIN (header)->child, -1, 32);
    gtk_container_set_border_width (GTK_CONTAINER (header), BORDER - 2);
    gtk_widget_show (header);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dlg)->vbox), header,
                        FALSE, TRUE, 0);

    /* Our own Vbox, so we can have a border */

    vbox = gtk_vbox_new(FALSE, BORDER);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), BORDER - 2);
    gtk_widget_show(vbox);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dlg)->vbox), vbox,
                        TRUE, TRUE, 0);

    /* Saw this nice one in other plugin */
    sizegr = gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);

#define MAKEHBOX( name ) \
    name = gtk_hbox_new(FALSE, BORDER); \
    gtk_widget_show(name);\
    gtk_box_pack_start(GTK_BOX(vbox), name, FALSE, FALSE, 0)

#define MAKELABEL( name, text ) \
    name = gtk_label_new(text); \
    gtk_size_group_add_widget(sizegr, name); \
    gtk_misc_set_alignment(GTK_MISC(name), 0, 0.5); \
    gtk_widget_show( name )


    MAKEHBOX( hbox );
    MAKELABEL( label, _("Modem driver:") );
    gtk_box_pack_start( GTK_BOX(hbox), label, 0, FALSE, FALSE );
    /* Create a combo with the drivers */

    dialog->driver_entry = gtk_combo_box_new_text();


    int idx;

    for (idx=0; drivers[idx]; idx++)
    {
	gtk_combo_box_append_text(GTK_COMBO_BOX(dialog->driver_entry), drivers[idx]->description);
    }

    gtk_combo_box_set_active(GTK_COMBO_BOX(dialog->driver_entry),0);

    gtk_box_pack_start( GTK_BOX(hbox), dialog->driver_entry, 0, FALSE, FALSE );
    gtk_widget_show( dialog->driver_entry );

    g_signal_connect(dialog->driver_entry, "changed", G_CALLBACK(cb_driver_entry_changed), dialog);

    MAKEHBOX( hbox );
    MAKELABEL( label, _("Modem device:") );

    gtk_box_pack_start( GTK_BOX(hbox), label, 0, FALSE, FALSE );
   
    dialog->device_entry = gtk_entry_new();
    gtk_widget_show(dialog->device_entry);
    gtk_box_pack_start(GTK_BOX(hbox), dialog->device_entry, FALSE, FALSE, 0);

    g_signal_connect(dialog->device_entry, "changed", G_CALLBACK(cb_device_entry_changed), dialog);


    MAKEHBOX( hbox );
    GtkWidget *autodetect_button = gtk_button_new_with_label("Autodetect modem...");

    gtk_widget_show(autodetect_button);
    gtk_box_pack_start(GTK_BOX(hbox), autodetect_button, FALSE, FALSE, 0);
    g_signal_connect(autodetect_button, "clicked", G_CALLBACK(cb_autodetect_modem), dialog);




    MAKEHBOX( hbox );
    MAKELABEL( label, _("Maximum quality:") );
    gtk_box_pack_start( GTK_BOX(hbox), label, 0, FALSE, FALSE );

    dialog->maxqual_entry = gtk_spin_button_new_with_range(1, 100, 1);
    gtk_widget_show(dialog->maxqual_entry);
    gtk_box_pack_start(GTK_BOX(hbox), dialog->maxqual_entry, FALSE, FALSE, 0);

    g_signal_connect(dialog->maxqual_entry, "value-changed", G_CALLBACK(cb_maxqual_entry_changed), dialog);


    MAKEHBOX( hbox );
    MAKELABEL( label, _("Low quality percentage:") );
    gtk_box_pack_start( GTK_BOX(hbox), label, 0, FALSE, FALSE );

    dialog->low_entry = gtk_spin_button_new_with_range(1, 100, 1);
    gtk_widget_show(dialog->low_entry);
    gtk_box_pack_start(GTK_BOX(hbox), dialog->low_entry, FALSE, FALSE, 0);

    g_signal_connect(dialog->low_entry, "value-changed", G_CALLBACK(cb_low_entry_changed), dialog);

    MAKEHBOX( hbox );
    MAKELABEL( label, _("Critical quality percentage:") );
    gtk_box_pack_start( GTK_BOX(hbox), label, 0, FALSE, FALSE );

    dialog->critical_entry = gtk_spin_button_new_with_range(1, 100, 1);
    gtk_widget_show(dialog->critical_entry);
    gtk_box_pack_start(GTK_BOX(hbox), dialog->critical_entry, FALSE, FALSE, 0);

    g_signal_connect(dialog->critical_entry, "value-changed", G_CALLBACK(cb_critical_entry_changed), dialog);


    /* Toggle buttons. */
    /*

    MAKEHBOX( hbox );

    vbox2 = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(vbox2);
    gtk_box_pack_start(GTK_BOX(hbox), vbox2, FALSE, FALSE, 0);


     dialog->ask_pin_entry = gtk_check_button_new_with_mnemonic( _("Ask for PIN if needed") );
    gtk_box_pack_start( GTK_BOX(hbox), dialog->ask_pin_entry, 0, FALSE, FALSE );
    gtk_widget_show( dialog->ask_pin_entry );

    g_signal_connect(dialog->ask_pin_entry, "toggled", G_CALLBACK(cb_pin_entry_toggled), dialog);
    */



    update_dialog( dialog );


    gtk_widget_show( dlg );
}
