/*
 *========================================================================
 * $Id: wulflogger.h 68 2004-12-01 16:51:29Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "copyright.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <strings.h>
#include <string.h>
#include <signal.h>
#include <ctype.h>
#include <pthread.h>
#include <time.h>
#include <math.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
/* libxml includes */
/*
 * COMPAT using xml-config --cflags to get the include path this will
 * work with both 
 */
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>


/* 
 * This ensures that wulfstat can execute all the commands recognized
 * by xmlsysd, no more and no less.  With a fair bit of work, of course...;-)
 */
#include <wulfware/libwulf_commands.h>

/*
 * This is all structs and enums needed to extract and store the values
 * on a per-host basis for further processing and display.
 */
#include <wulfware/libwulf_values.h>

/*
 * These are structs used to xml-parse wulfhosts
 */
#include <wulfware/libwulf_wulfhosts.h>

/*
 * The primary host structs.  Must be included after xml stuff.
 */
#include <wulfware/libwulf_wulfhost.h>

/*
 * Subroutine Prototypes from libwulf
 */
#include <wulfware/libwulf_prototypes.h>

/*
 * wulflogger prototypes
 */
void parsecl(int argc, char **argv);
void startup();
void dump_dctl_state(Host *hostptr);
void set_display_dctl_state();
void display_values();
void display_basic();
void display_load();
void display_memory();
void display_net();
void display_times();
void display_pids_cmdline();
void display_pids();

/*
 *========================================================================
 * Useful defines
 *========================================================================
 */

#define STDIN	stdin
#define STDOUT	stdout
#define STDERR	stderr
#define YES	1
#define NO	0
#define PI 3.141592653589793238462643
#define K 1024
#define K4 4096
#define K64 65536

/* Default xmlsysd port */
#define XMLSYSD_PORT 7887


/*
 *========================================================================
 * Debug enum -- one per separate component, no particular order
 *========================================================================
 */
 typedef enum {
   D_QUIET,
   D_ALL,
   D_MAIN,
   D_UTIL,
   D_PARSECL,
   D_STARTUP,
   D_WORK,
   D_PARSE,
   D_CONNECT,
   D_INIT_HOST,
   D_CONNECT_HOSTS,
   D_READHOST,
   D_SENDCMD,
   D_SELECT_OPTION,
   D_EXTRACT_VALUES,
   D_INIT_VALUES,
   D_UPDATE_VALUES,
   D_VALUES,
   D_DISPLAY_VALUES,
   D_DISPLAY_DEBUG,
   D_SCREEN,
   D_XMLSYSD,
   D_QUIT,
   N_DEBUG
 } Debug;

 /*
  *========================================================================
  * Subroutine Prototypes
  *========================================================================
  */
 /* toplevel routines in the main execution schema. */
 void Usage();
 void Usagemap();
 void startup();
 void work();
 void quit();

 /* from display_values.c */
 void display_values();
 void display_load();
 void display_user();
 void display_memory();
 void display_net();
 void display_times();

 /*
  *========================================================================
  * Global Variables and relevant #defines
  *
  * Set the default values and override from the command line in parsecl().
  *========================================================================
  */

 /* 
  * verbose is also a debug switch.  One can switch on the debugging
  * of many components of the program with different values.  However
  * one has to read the source to know what turns on what.  These are
  * shared with libwulf and MUST be defined/allocated here, I suppose.
  */
 int verbose;
 int udelay;	      /* debug message delay */

/* command buffer, parse buffer, space for hostfile path */
 char command[K];
 char hostfile[K];
 char display_msg[K];	/* a global buffer to display errors or messages in */
 int update_delay;    /* how long to wait between updates */
 int connect_delay;   /* how long to wait between reconnection loops */
 unsigned long long int count;      /* how many times to loop before exiting */
 unsigned long long int cycle_cnt;  /* the loop cycle counter */
 Connectlist connectlist; /* Argument struct for threaded connect_to_hosts() */

 /* pthread tid's */
 pthread_t connecttid;

 int numhosts;

 /* 
  * This list of types will eventually allow users to select from 
  * several predefined and simple displays.  Most of the time they
  * will likely choose only load or wulfstat, but if we make the display
  * width depend on what is being shown, a load display might be only
  * 30 characters wide, so that a row of xterm windows, each with a list
  * of perhaps 50 hosts, could conceivably allow hundreds of hosts to be
  * monitored on single X window.
  */
 int display_type;
 typedef enum {
   DISPLAY_BASIC,	/* show basic stats */
   DISPLAY_LOAD,	/* show load average only */
   DISPLAY_MEMORY,	/* show memory only */
   DISPLAY_NET,		/* show network loads only */
   DISPLAY_TIMES,	/* show uptime and current time */
   DISPLAY_PIDS,	/* show pids */
   DISPLAY_PIDS_CMDLINE, /* show pids AND command line */
   /* The following aren't implemented */
   DISPLAY_STAT,	/* show stat-derived rates (mostly) */
   N_DISPLAYTYPES
 } Displaytypes;
