(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require list.List.
Require list.Length.
Require list.Mem.
Require map.Map.
Require list.Append.
Require list.Distinct.

(* Why3 assumption *)
Definition unit := unit.

Axiom qtmark : Type.
Parameter qtmark_WhyType : WhyType qtmark.
Existing Instance qtmark_WhyType.

(* Why3 assumption *)
Inductive array (a:Type) :=
  | mk_array : Z -> (map.Map.map Z a) -> array a.
Axiom array_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (array a).
Existing Instance array_WhyType.
Implicit Arguments mk_array [[a]].

(* Why3 assumption *)
Definition elts {a:Type} {a_WT:WhyType a} (v:(array a)): (map.Map.map Z a) :=
  match v with
  | (mk_array x x1) => x1
  end.

(* Why3 assumption *)
Definition length {a:Type} {a_WT:WhyType a} (v:(array a)): Z :=
  match v with
  | (mk_array x x1) => x
  end.

(* Why3 assumption *)
Definition get {a:Type} {a_WT:WhyType a} (a1:(array a)) (i:Z): a :=
  (map.Map.get (elts a1) i).

(* Why3 assumption *)
Definition set {a:Type} {a_WT:WhyType a} (a1:(array a)) (i:Z) (v:a): (array
  a) := (mk_array (length a1) (map.Map.set (elts a1) i v)).

(* Why3 assumption *)
Definition make {a:Type} {a_WT:WhyType a} (n:Z) (v:a): (array a) :=
  (mk_array n (map.Map.const v: (map.Map.map Z a))).

(* Why3 assumption *)
Inductive tree :=
  | Empty : tree
  | Node : tree -> tree -> tree.
Axiom tree_WhyType : WhyType tree.
Existing Instance tree_WhyType.

(* Why3 assumption *)
Fixpoint size (t:tree) {struct t}: Z :=
  match t with
  | Empty => 0%Z
  | (Node l r) => ((1%Z + (size l))%Z + (size r))%Z
  end.

Axiom size_nonneg : forall (t:tree), (0%Z <= (size t))%Z.

Axiom size_left : forall (t:tree), (0%Z < (size t))%Z -> exists l:tree,
  exists r:tree, (t = (Node l r)) /\ ((size l) < (size t))%Z.

(* Why3 assumption *)
Definition all_trees (n:Z) (l:(list tree)): Prop := (list.Distinct.distinct
  l) /\ forall (t:tree), ((size t) = n) <-> (list.Mem.mem t l).

Axiom all_trees_0 : (all_trees 0%Z
  (Init.Datatypes.cons Empty Init.Datatypes.nil)).

Axiom tree_diff : forall (l1:tree) (l2:tree), (~ ((size l1) = (size l2))) ->
  forall (r1:tree) (r2:tree), ~ ((Node l1 r1) = (Node l2 r2)).

(* Why3 goal *)
Theorem WP_parameter_combine : forall (i1:Z) (l1:(list tree)) (i2:Z)
  (l2:(list tree)), ((0%Z <= i1)%Z /\ ((all_trees i1 l1) /\ ((0%Z <= i2)%Z /\
  (all_trees i2 l2)))) -> forall (l11:(list tree)), (list.Distinct.distinct
  l11) -> forall (x:tree) (x1:(list tree)),
  (l11 = (Init.Datatypes.cons x x1)) -> forall (l21:(list tree)),
  (list.Distinct.distinct l21) -> forall (x2:tree) (x3:(list tree)),
  (l21 = (Init.Datatypes.cons x2 x3)) -> ((list.Distinct.distinct x3) ->
  forall (o:(list tree)), ((list.Distinct.distinct o) /\ forall (t:tree),
  (list.Mem.mem t o) <-> exists r:tree, (t = (Node x r)) /\ (list.Mem.mem r
  x3)) -> forall (t:tree), (list.Mem.mem t (Init.Datatypes.cons (Node x
  x2) o)) -> exists r:tree, (t = (Node x r)) /\ (list.Mem.mem r l21)).
intros i1 l1 i2 l2 (h1,(h2,(h3,h4))) l11 h5 x x1 h6 l21 h7 x2 x3 h8
        h9 o (h10,h11) t h12.
subst.
unfold Mem.mem in h12; fold @Mem.mem in h12.
destruct h12.
exists x2; intuition.
red; intuition.
generalize (h11 t). intuition.
destruct H0 as (r,h); exists r; intuition.
red; intuition.
Qed.

