// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See generate_spec_error_message.py for modifications
// Based on Vulkan specification version: 1.3.290

/***************************************************************************
 *
 * Copyright (c) 2016-2024 Google Inc.
 * Copyright (c) 2016-2024 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ****************************************************************************/
#pragma once

// clang-format off

// Mapping from VUID string to the corresponding spec text
typedef struct _vuid_spec_text_pair {
    const char * vuid;
    const char * spec_text;
    const char * url_id;
} vuid_spec_text_pair;

static const vuid_spec_text_pair vuid_spec_text[] = {
    {"VUID-BaryCoordKHR-BaryCoordKHR-04154", "The BaryCoordKHR decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-BaryCoordKHR-BaryCoordKHR-04155", "The variable decorated with BaryCoordKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-BaryCoordKHR-BaryCoordKHR-04156", "The variable decorated with BaryCoordKHR must be declared as a three-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-BaryCoordNoPerspAMD-BaryCoordNoPerspAMD-04157", "The BaryCoordNoPerspAMD decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-BaryCoordNoPerspAMD-BaryCoordNoPerspAMD-04158", "The variable decorated with BaryCoordNoPerspAMD must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-BaryCoordNoPerspAMD-BaryCoordNoPerspAMD-04159", "The variable decorated with BaryCoordNoPerspAMD must be declared as a two-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-BaryCoordNoPerspCentroidAMD-BaryCoordNoPerspCentroidAMD-04163", "The BaryCoordNoPerspCentroidAMD decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-BaryCoordNoPerspCentroidAMD-BaryCoordNoPerspCentroidAMD-04164", "The variable decorated with BaryCoordNoPerspCentroidAMD must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-BaryCoordNoPerspCentroidAMD-BaryCoordNoPerspCentroidAMD-04165", "The variable decorated with BaryCoordNoPerspCentroidAMD must be declared as a three-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-BaryCoordNoPerspKHR-BaryCoordNoPerspKHR-04160", "The BaryCoordNoPerspKHR decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-BaryCoordNoPerspKHR-BaryCoordNoPerspKHR-04161", "The variable decorated with BaryCoordNoPerspKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-BaryCoordNoPerspKHR-BaryCoordNoPerspKHR-04162", "The variable decorated with BaryCoordNoPerspKHR must be declared as a three-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-BaryCoordNoPerspSampleAMD-BaryCoordNoPerspSampleAMD-04166", "The BaryCoordNoPerspSampleAMD decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-BaryCoordNoPerspSampleAMD-BaryCoordNoPerspSampleAMD-04167", "The variable decorated with BaryCoordNoPerspSampleAMD must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-BaryCoordNoPerspSampleAMD-BaryCoordNoPerspSampleAMD-04168", "The variable decorated with BaryCoordNoPerspSampleAMD must be declared as a two-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-BaryCoordPullModelAMD-BaryCoordPullModelAMD-04169", "The BaryCoordPullModelAMD decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-BaryCoordPullModelAMD-BaryCoordPullModelAMD-04170", "The variable decorated with BaryCoordPullModelAMD must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-BaryCoordPullModelAMD-BaryCoordPullModelAMD-04171", "The variable decorated with BaryCoordPullModelAMD must be declared as a three-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-BaryCoordSmoothAMD-BaryCoordSmoothAMD-04172", "The BaryCoordSmoothAMD decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-BaryCoordSmoothAMD-BaryCoordSmoothAMD-04173", "The variable decorated with BaryCoordSmoothAMD must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-BaryCoordSmoothAMD-BaryCoordSmoothAMD-04174", "The variable decorated with BaryCoordSmoothAMD must be declared as a two-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-BaryCoordSmoothCentroidAMD-BaryCoordSmoothCentroidAMD-04175", "The BaryCoordSmoothCentroidAMD decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-BaryCoordSmoothCentroidAMD-BaryCoordSmoothCentroidAMD-04176", "The variable decorated with BaryCoordSmoothCentroidAMD must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-BaryCoordSmoothCentroidAMD-BaryCoordSmoothCentroidAMD-04177", "The variable decorated with BaryCoordSmoothCentroidAMD must be declared as a two-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-BaryCoordSmoothSampleAMD-BaryCoordSmoothSampleAMD-04178", "The BaryCoordSmoothSampleAMD decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-BaryCoordSmoothSampleAMD-BaryCoordSmoothSampleAMD-04179", "The variable decorated with BaryCoordSmoothSampleAMD must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-BaryCoordSmoothSampleAMD-BaryCoordSmoothSampleAMD-04180", "The variable decorated with BaryCoordSmoothSampleAMD must be declared as a two-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-BaseInstance-BaseInstance-04181", "The BaseInstance decoration must be used only within the Vertex Execution Model", "1.3-extensions"},
    {"VUID-BaseInstance-BaseInstance-04182", "The variable decorated with BaseInstance must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-BaseInstance-BaseInstance-04183", "The variable decorated with BaseInstance must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-BaseVertex-BaseVertex-04184", "The BaseVertex decoration must be used only within the Vertex Execution Model", "1.3-extensions"},
    {"VUID-BaseVertex-BaseVertex-04185", "The variable decorated with BaseVertex must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-BaseVertex-BaseVertex-04186", "The variable decorated with BaseVertex must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-ClipDistance-ClipDistance-04187", "The ClipDistance decoration must be used only within the MeshEXT, MeshNV, Vertex, Fragment, TessellationControl, TessellationEvaluation, or Geometry Execution Model", "1.3-extensions"},
    {"VUID-ClipDistance-ClipDistance-04188", "The variable decorated with ClipDistance within the MeshEXT, MeshNV, or Vertex Execution Model must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-ClipDistance-ClipDistance-04189", "The variable decorated with ClipDistance within the Fragment Execution Model must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-ClipDistance-ClipDistance-04190", "The variable decorated with ClipDistance within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared in a Storage Class other than Input or Output", "1.3-extensions"},
    {"VUID-ClipDistance-ClipDistance-04191", "The variable decorated with ClipDistance must be declared as an array of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04192", "The ClipDistancePerViewNV decoration must be used only within the MeshNV Execution Model", "1.3-extensions"},
    {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04193", "The variable decorated with ClipDistancePerViewNV must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04194", "The variable decorated with ClipDistancePerViewNV must also be decorated with the PerViewNV decoration", "1.3-extensions"},
    {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04195", "The variable decorated with ClipDistancePerViewNV must be declared as a two-dimensional array of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-ClusterIDHUAWEI-ClusterIDHUAWEI-07797", "The ClusterIDHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "1.3-extensions"},
    {"VUID-ClusterIDHUAWEI-ClusterIDHUAWEI-07798", "The variable decorated with ClusterIDHUAWEI must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-ClusterShadingRateHUAWEI-ClusterShadingRateHUAWEI-09448", "The ClusterShadingRateHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "1.3-extensions"},
    {"VUID-ClusterShadingRateHUAWEI-ClusterShadingRateHUAWEI-09449", "The variable decorated with ClusterShadingRateHUAWEI must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-CoalescedInputCountAMDX-CoalescedInputCountAMDX-09172", "The variable decorated with CoalescedInputCountAMDX must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-CoalescedInputCountAMDX-CoalescedInputCountAMDX-09173", "If a variable is decorated with CoalescedInputCountAMDX, the CoalescingAMDX execution mode must be declared", "1.3-extensions"},
    {"VUID-CoalescedInputCountAMDX-CoalescedInputCountAMDX-09174", "The variable decorated with CoalescedInputCountAMDX must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-CoreCountARM-CoreCountARM-07595", "The variable decorated with CoreCountARM must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-CoreCountARM-CoreCountARM-07596", "The variable decorated with CoreCountARM must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-CoreIDARM-CoreIDARM-07599", "The variable decorated with CoreIDARM must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-CoreIDARM-CoreIDARM-07600", "The variable decorated with CoreIDARM must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-CoreMaxIDARM-CoreMaxIDARM-07597", "The variable decorated with CoreMaxIDARM must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-CoreMaxIDARM-CoreMaxIDARM-07598", "The variable decorated with CoreMaxIDARM must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-CullDistance-CullDistance-04196", "The CullDistance decoration must be used only within the MeshEXT, MeshNV, Vertex, Fragment, TessellationControl, TessellationEvaluation, or Geometry Execution Model", "1.3-extensions"},
    {"VUID-CullDistance-CullDistance-04197", "The variable decorated with CullDistance within the MeshEXT, MeshNV or Vertex Execution Model must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-CullDistance-CullDistance-04198", "The variable decorated with CullDistance within the Fragment Execution Model must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-CullDistance-CullDistance-04199", "The variable decorated with CullDistance within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared using a Storage Class other than Input or Output", "1.3-extensions"},
    {"VUID-CullDistance-CullDistance-04200", "The variable decorated with CullDistance must be declared as an array of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04201", "The CullDistancePerViewNV decoration must be used only within the MeshNV Execution Model", "1.3-extensions"},
    {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04202", "The variable decorated with CullDistancePerViewNV must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04203", "The variable decorated with CullDistancePerViewNV must also be decorated with the PerViewNV decoration", "1.3-extensions"},
    {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04204", "The variable decorated with CullDistancePerViewNV must be declared as a two-dimensional array of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-CullMaskKHR-CullMaskKHR-06735", "The CullMaskKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", "1.3-extensions"},
    {"VUID-CullMaskKHR-CullMaskKHR-06736", "The variable decorated with CullMaskKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-CullMaskKHR-CullMaskKHR-06737", "The variable decorated with CullMaskKHR must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-07034", "The CullPrimitiveEXT decoration must be used only within the MeshEXT Execution Model", "1.3-extensions"},
    {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-07035", "The variable decorated with CullPrimitiveEXT must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-07036", "The variable decorated with CullPrimitiveEXT must be declared as an array of boolean values", "1.3-extensions"},
    {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-07037", "The size of the array decorated with CullPrimitiveEXT must match the value specified by OutputPrimitivesEXT", "1.3-extensions"},
    {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-07038", "The variable decorated with CullPrimitiveEXT within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", "1.3-extensions"},
    {"VUID-CurrentRayTimeNV-CurrentRayTimeNV-04942", "The CurrentRayTimeNV decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", "1.3-extensions"},
    {"VUID-CurrentRayTimeNV-CurrentRayTimeNV-04943", "The variable decorated with CurrentRayTimeNV must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-CurrentRayTimeNV-CurrentRayTimeNV-04944", "The variable decorated with CurrentRayTimeNV must be declared as a scalar 32-bit floating-point value", "1.3-extensions"},
    {"VUID-DeviceIndex-DeviceIndex-04205", "The variable decorated with DeviceIndex must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-DeviceIndex-DeviceIndex-04206", "The variable decorated with DeviceIndex must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-DrawIndex-DrawIndex-04207", "The DrawIndex decoration must be used only within the Vertex, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", "1.3-extensions"},
    {"VUID-DrawIndex-DrawIndex-04208", "The variable decorated with DrawIndex must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-DrawIndex-DrawIndex-04209", "The variable decorated with DrawIndex must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-FirstIndexHUAWEI-FirstIndexHUAWEI-07799", "The FirstIndexHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "1.3-extensions"},
    {"VUID-FirstIndexHUAWEI-FirstIndexHUAWEI-07800", "The variable decorated with FirstIndexHUAWEI must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-FirstInstanceHUAWEI-FirstInstanceHUAWEI-07801", "The FirstInstanceHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "1.3-extensions"},
    {"VUID-FirstInstanceHUAWEI-FirstInstanceHUAWEI-07802", "The variable decorated with FirstInstanceHUAWEI must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-FirstVertexHUAWEI-FirstVertexHUAWEI-07803", "The FirstVertexHUAWEI decoration must be used only within the FirstVertexHUAWEI Execution Model", "1.3-extensions"},
    {"VUID-FirstVertexHUAWEI-FirstVertexHUAWEI-07804", "The variable decorated with FirstVertexHUAWEI must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-FragCoord-FragCoord-04210", "The FragCoord decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-FragCoord-FragCoord-04211", "The variable decorated with FragCoord must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-FragCoord-FragCoord-04212", "The variable decorated with FragCoord must be declared as a four-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-FragDepth-FragDepth-04213", "The FragDepth decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-FragDepth-FragDepth-04214", "The variable decorated with FragDepth must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-FragDepth-FragDepth-04215", "The variable decorated with FragDepth must be declared as a scalar 32-bit floating-point value", "1.3-extensions"},
    {"VUID-FragDepth-FragDepth-04216", "If the shader dynamically writes to the variable decorated with FragDepth, the DepthReplacing Execution Mode must be declared", "1.3-extensions"},
    {"VUID-FragInvocationCountEXT-FragInvocationCountEXT-04217", "The FragInvocationCountEXT decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-FragInvocationCountEXT-FragInvocationCountEXT-04218", "The variable decorated with FragInvocationCountEXT must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-FragInvocationCountEXT-FragInvocationCountEXT-04219", "The variable decorated with FragInvocationCountEXT must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-FragSizeEXT-FragSizeEXT-04220", "The FragSizeEXT decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-FragSizeEXT-FragSizeEXT-04221", "The variable decorated with FragSizeEXT must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-FragSizeEXT-FragSizeEXT-04222", "The variable decorated with FragSizeEXT must be declared as a two-component vector of 32-bit integer values", "1.3-extensions"},
    {"VUID-FragStencilRefEXT-FragStencilRefEXT-04223", "The FragStencilRefEXT decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-FragStencilRefEXT-FragStencilRefEXT-04224", "The variable decorated with FragStencilRefEXT must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-FragStencilRefEXT-FragStencilRefEXT-04225", "The variable decorated with FragStencilRefEXT must be declared as a scalar integer value", "1.3-extensions"},
    {"VUID-FragmentSizeNV-FragmentSizeNV-04226", "The FragmentSizeNV decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-FragmentSizeNV-FragmentSizeNV-04227", "The variable decorated with FragmentSizeNV must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-FragmentSizeNV-FragmentSizeNV-04228", "The variable decorated with FragmentSizeNV must be declared as a two-component vector of 32-bit integer values", "1.3-extensions"},
    {"VUID-FrontFacing-FrontFacing-04229", "The FrontFacing decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-FrontFacing-FrontFacing-04230", "The variable decorated with FrontFacing must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-FrontFacing-FrontFacing-04231", "The variable decorated with FrontFacing must be declared as a boolean value", "1.3-extensions"},
    {"VUID-FullyCoveredEXT-FullyCoveredEXT-04232", "The FullyCoveredEXT decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-FullyCoveredEXT-FullyCoveredEXT-04233", "The variable decorated with FullyCoveredEXT must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-FullyCoveredEXT-FullyCoveredEXT-04234", "The variable decorated with FullyCoveredEXT must be declared as a boolean value", "1.3-extensions"},
    {"VUID-FullyCoveredEXT-conservativeRasterizationPostDepthCoverage-04235", "If VkPhysicalDeviceConservativeRasterizationPropertiesEXT::conservativeRasterizationPostDepthCoverage is not supported the PostDepthCoverage Execution Mode must not be declared, when a variable with the FullyCoveredEXT decoration is declared", "1.3-extensions"},
    {"VUID-GlobalInvocationId-GlobalInvocationId-04236", "The GlobalInvocationId decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", "1.3-extensions"},
    {"VUID-GlobalInvocationId-GlobalInvocationId-04237", "The variable decorated with GlobalInvocationId must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-GlobalInvocationId-GlobalInvocationId-04238", "The variable decorated with GlobalInvocationId must be declared as a three-component vector of 32-bit integer values", "1.3-extensions"},
    {"VUID-HelperInvocation-HelperInvocation-04239", "The HelperInvocation decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-HelperInvocation-HelperInvocation-04240", "The variable decorated with HelperInvocation must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-HelperInvocation-HelperInvocation-04241", "The variable decorated with HelperInvocation must be declared as a boolean value", "1.3-extensions"},
    {"VUID-HitKindKHR-HitKindKHR-04242", "The HitKindKHR decoration must be used only within the AnyHitKHR or ClosestHitKHR Execution Model", "1.3-extensions"},
    {"VUID-HitKindKHR-HitKindKHR-04243", "The variable decorated with HitKindKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-HitKindKHR-HitKindKHR-04244", "The variable decorated with HitKindKHR must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-HitTNV-HitTNV-04245", "The HitTNV decoration must be used only within the AnyHitNV or ClosestHitNV Execution Model", "1.3-extensions"},
    {"VUID-HitTNV-HitTNV-04246", "The variable decorated with HitTNV must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-HitTNV-HitTNV-04247", "The variable decorated with HitTNV must be declared as a scalar 32-bit floating-point value", "1.3-extensions"},
    {"VUID-HitTriangleVertexPositionsKHR-HitTriangleVertexPositionsKHR-08747", "The HitTriangleVertexPositionsKHR decoration must be used only within the AnyHitKHR or ClosestHitKHR Execution Model", "1.3-extensions"},
    {"VUID-HitTriangleVertexPositionsKHR-HitTriangleVertexPositionsKHR-08748", "The variable decorated with HitTriangleVertexPositionsKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-HitTriangleVertexPositionsKHR-HitTriangleVertexPositionsKHR-08749", "The variable decorated with HitTriangleVertexPositionsKHR must be declared as an array of three vectors of three 32-bit float values", "1.3-extensions"},
    {"VUID-HitTriangleVertexPositionsKHR-HitTriangleVertexPositionsKHR-08750", "The variable decorated with HitTriangleVertexPositionsKHR must be used only if the value of HitKindKHR is HitKindFrontFacingTriangleKHR or HitKindBackFacingTriangleKHR", "1.3-extensions"},
    {"VUID-HitTriangleVertexPositionsKHR-None-08751", "The acceleration structure corresponding to the current intersection must have been built with VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DATA_ACCESS_KHR", "1.3-extensions"},
    {"VUID-IncomingRayFlagsKHR-IncomingRayFlagsKHR-04248", "The IncomingRayFlagsKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", "1.3-extensions"},
    {"VUID-IncomingRayFlagsKHR-IncomingRayFlagsKHR-04249", "The variable decorated with IncomingRayFlagsKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-IncomingRayFlagsKHR-IncomingRayFlagsKHR-04250", "The variable decorated with IncomingRayFlagsKHR must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-IndexCountHUAWEI-IndexCountHUAWEI-07805", "The IndexCountHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "1.3-extensions"},
    {"VUID-IndexCountHUAWEI-IndexCountHUAWEI-07806", "The variable decorated with IndexCountHUAWEI must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-InstanceCountHUAWEI-InstanceCountHUAWEI-07807", "The InstanceCountHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "1.3-extensions"},
    {"VUID-InstanceCountHUAWEI-InstanceCountHUAWEI-07808", "The variable decorated with InstanceCountHUAWEI must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-InstanceCustomIndexKHR-InstanceCustomIndexKHR-04251", "The InstanceCustomIndexKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", "1.3-extensions"},
    {"VUID-InstanceCustomIndexKHR-InstanceCustomIndexKHR-04252", "The variable decorated with InstanceCustomIndexKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-InstanceCustomIndexKHR-InstanceCustomIndexKHR-04253", "The variable decorated with InstanceCustomIndexKHR must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-InstanceId-InstanceId-04254", "The InstanceId decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", "1.3-extensions"},
    {"VUID-InstanceId-InstanceId-04255", "The variable decorated with InstanceId must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-InstanceId-InstanceId-04256", "The variable decorated with InstanceId must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-InstanceIndex-InstanceIndex-04263", "The InstanceIndex decoration must be used only within the Vertex Execution Model", "1.3-extensions"},
    {"VUID-InstanceIndex-InstanceIndex-04264", "The variable decorated with InstanceIndex must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-InstanceIndex-InstanceIndex-04265", "The variable decorated with InstanceIndex must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-InvocationId-InvocationId-04257", "The InvocationId decoration must be used only within the TessellationControl or Geometry Execution Model", "1.3-extensions"},
    {"VUID-InvocationId-InvocationId-04258", "The variable decorated with InvocationId must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-InvocationId-InvocationId-04259", "The variable decorated with InvocationId must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-InvocationsPerPixelNV-InvocationsPerPixelNV-04260", "The InvocationsPerPixelNV decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-InvocationsPerPixelNV-InvocationsPerPixelNV-04261", "The variable decorated with InvocationsPerPixelNV must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-InvocationsPerPixelNV-InvocationsPerPixelNV-04262", "The variable decorated with InvocationsPerPixelNV must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-LaunchIdKHR-LaunchIdKHR-04266", "The LaunchIdKHR decoration must be used only within the RayGenerationKHR, IntersectionKHR, AnyHitKHR, ClosestHitKHR, MissKHR, or CallableKHR Execution Model", "1.3-extensions"},
    {"VUID-LaunchIdKHR-LaunchIdKHR-04267", "The variable decorated with LaunchIdKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-LaunchIdKHR-LaunchIdKHR-04268", "The variable decorated with LaunchIdKHR must be declared as a three-component vector of 32-bit integer values", "1.3-extensions"},
    {"VUID-LaunchSizeKHR-LaunchSizeKHR-04269", "The LaunchSizeKHR decoration must be used only within the RayGenerationKHR, IntersectionKHR, AnyHitKHR, ClosestHitKHR, MissKHR, or CallableKHR Execution Model", "1.3-extensions"},
    {"VUID-LaunchSizeKHR-LaunchSizeKHR-04270", "The variable decorated with LaunchSizeKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-LaunchSizeKHR-LaunchSizeKHR-04271", "The variable decorated with LaunchSizeKHR must be declared as a three-component vector of 32-bit integer values", "1.3-extensions"},
    {"VUID-Layer-Layer-04272", "The Layer decoration must be used only within the MeshEXT, MeshNV, Vertex, TessellationEvaluation, Geometry, or Fragment Execution Model", "1.3-extensions"},
    {"VUID-Layer-Layer-04273", "If the shaderOutputLayer feature is not enabled then the Layer decoration must be used only within the Geometry or Fragment Execution Model", "1.3-extensions"},
    {"VUID-Layer-Layer-04274", "The variable decorated with Layer within the MeshEXT, MeshNV, Vertex, TessellationEvaluation, or Geometry Execution Model must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-Layer-Layer-04275", "The variable decorated with Layer within the Fragment Execution Model must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-Layer-Layer-04276", "The variable decorated with Layer must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-Layer-Layer-07039", "The variable decorated with Layer within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", "1.3-extensions"},
    {"VUID-LayerPerViewNV-LayerPerViewNV-04277", "The LayerPerViewNV decoration must be used only within the MeshNV Execution Model", "1.3-extensions"},
    {"VUID-LayerPerViewNV-LayerPerViewNV-04278", "The variable decorated with LayerPerViewNV must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-LayerPerViewNV-LayerPerViewNV-04279", "The variable decorated with LayerPerViewNV must also be decorated with the PerViewNV decoration", "1.3-extensions"},
    {"VUID-LayerPerViewNV-LayerPerViewNV-04280", "The variable decorated with LayerPerViewNV must be declared as an array of scalar 32-bit integer values", "1.3-extensions"},
    {"VUID-LocalInvocationId-LocalInvocationId-04281", "The LocalInvocationId decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", "1.3-extensions"},
    {"VUID-LocalInvocationId-LocalInvocationId-04282", "The variable decorated with LocalInvocationId must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-LocalInvocationId-LocalInvocationId-04283", "The variable decorated with LocalInvocationId must be declared as a three-component vector of 32-bit integer values", "1.3-extensions"},
    {"VUID-LocalInvocationIndex-LocalInvocationIndex-04284", "The LocalInvocationIndex decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", "1.3-extensions"},
    {"VUID-LocalInvocationIndex-LocalInvocationIndex-04285", "The variable decorated with LocalInvocationIndex must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-LocalInvocationIndex-LocalInvocationIndex-04286", "The variable decorated with LocalInvocationIndex must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-MeshViewCountNV-MeshViewCountNV-04287", "The MeshViewCountNV decoration must be used only within the MeshNV or TaskNV Execution Model", "1.3-extensions"},
    {"VUID-MeshViewCountNV-MeshViewCountNV-04288", "The variable decorated with MeshViewCountNV must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-MeshViewCountNV-MeshViewCountNV-04289", "The variable decorated with MeshViewCountNV must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-MeshViewIndicesNV-MeshViewIndicesNV-04290", "The MeshViewIndicesNV decoration must be used only within the MeshNV or TaskNV Execution Model", "1.3-extensions"},
    {"VUID-MeshViewIndicesNV-MeshViewIndicesNV-04291", "The variable decorated with MeshViewIndicesNV must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-MeshViewIndicesNV-MeshViewIndicesNV-04292", "The variable decorated with MeshViewIndicesNV must be declared as an array of scalar 32-bit integer values", "1.3-extensions"},
    {"VUID-NumSubgroups-NumSubgroups-04293", "The NumSubgroups decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", "1.3-extensions"},
    {"VUID-NumSubgroups-NumSubgroups-04294", "The variable decorated with NumSubgroups must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-NumSubgroups-NumSubgroups-04295", "The variable decorated with NumSubgroups must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-NumWorkgroups-NumWorkgroups-04296", "The NumWorkgroups decoration must be used only within the GLCompute, MeshEXT, or TaskEXT Execution Model", "1.3-extensions"},
    {"VUID-NumWorkgroups-NumWorkgroups-04297", "The variable decorated with NumWorkgroups must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-NumWorkgroups-NumWorkgroups-04298", "The variable decorated with NumWorkgroups must be declared as a three-component vector of 32-bit integer values", "1.3-extensions"},
    {"VUID-ObjectRayDirectionKHR-ObjectRayDirectionKHR-04299", "The ObjectRayDirectionKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", "1.3-extensions"},
    {"VUID-ObjectRayDirectionKHR-ObjectRayDirectionKHR-04300", "The variable decorated with ObjectRayDirectionKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-ObjectRayDirectionKHR-ObjectRayDirectionKHR-04301", "The variable decorated with ObjectRayDirectionKHR must be declared as a three-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-ObjectRayOriginKHR-ObjectRayOriginKHR-04302", "The ObjectRayOriginKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", "1.3-extensions"},
    {"VUID-ObjectRayOriginKHR-ObjectRayOriginKHR-04303", "The variable decorated with ObjectRayOriginKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-ObjectRayOriginKHR-ObjectRayOriginKHR-04304", "The variable decorated with ObjectRayOriginKHR must be declared as a three-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-ObjectToWorldKHR-ObjectToWorldKHR-04305", "The ObjectToWorldKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", "1.3-extensions"},
    {"VUID-ObjectToWorldKHR-ObjectToWorldKHR-04306", "The variable decorated with ObjectToWorldKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-ObjectToWorldKHR-ObjectToWorldKHR-04307", "The variable decorated with ObjectToWorldKHR must be declared as a matrix with four columns of three-component vectors of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-PFN_vkDebugUtilsMessengerCallbackEXT-None-04769", "The callback must not make calls to any Vulkan commands", "1.3-extensions"},
    {"VUID-PatchVertices-PatchVertices-04308", "The PatchVertices decoration must be used only within the TessellationControl or TessellationEvaluation Execution Model", "1.3-extensions"},
    {"VUID-PatchVertices-PatchVertices-04309", "The variable decorated with PatchVertices must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-PatchVertices-PatchVertices-04310", "The variable decorated with PatchVertices must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-PointCoord-PointCoord-04311", "The PointCoord decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-PointCoord-PointCoord-04312", "The variable decorated with PointCoord must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-PointCoord-PointCoord-04313", "The variable decorated with PointCoord must be declared as a two-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-PointSize-PointSize-04314", "The PointSize decoration must be used only within the MeshEXT, MeshNV, Vertex, TessellationControl, TessellationEvaluation, or Geometry Execution Model", "1.3-extensions"},
    {"VUID-PointSize-PointSize-04315", "The variable decorated with PointSize within the MeshEXT, MeshNV, or Vertex Execution Model must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-PointSize-PointSize-04316", "The variable decorated with PointSize within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared using a Storage Class other than Input or Output", "1.3-extensions"},
    {"VUID-PointSize-PointSize-04317", "The variable decorated with PointSize must be declared as a scalar 32-bit floating-point value", "1.3-extensions"},
    {"VUID-Position-Position-04318", "The Position decoration must be used only within the MeshEXT, MeshNV, Vertex, TessellationControl, TessellationEvaluation, or Geometry Execution Model", "1.3-extensions"},
    {"VUID-Position-Position-04319", "The variable decorated with Position within the MeshEXT, MeshNV, or Vertex Execution Model must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-Position-Position-04320", "The variable decorated with Position within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared using a Storage Class other than Input or Output", "1.3-extensions"},
    {"VUID-Position-Position-04321", "The variable decorated with Position must be declared as a four-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04322", "The PositionPerViewNV decoration must be used only within the MeshNV, Vertex, TessellationControl, TessellationEvaluation, or Geometry Execution Model", "1.3-extensions"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04323", "The variable decorated with PositionPerViewNV within the Vertex, or MeshNV Execution Model must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04324", "The variable decorated with PositionPerViewNV within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared using a Storage Class other than Input or Output", "1.3-extensions"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04325", "The variable decorated with PositionPerViewNV must be declared as an array of four-component vector of 32-bit floating-point values with at least as many elements as the maximum view in the subpass's view mask plus one", "1.3-extensions"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04326", "The array variable decorated with PositionPerViewNV must only be indexed by a constant or specialization constant", "1.3-extensions"},
    {"VUID-PrimitiveCountNV-PrimitiveCountNV-04327", "The PrimitiveCountNV decoration must be used only within the MeshNV Execution Model", "1.3-extensions"},
    {"VUID-PrimitiveCountNV-PrimitiveCountNV-04328", "The variable decorated with PrimitiveCountNV must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-PrimitiveCountNV-PrimitiveCountNV-04329", "The variable decorated with PrimitiveCountNV must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-PrimitiveId-Fragment-04331", "If pipeline contains both the Fragment and Geometry Execution Model and a variable decorated with PrimitiveId is read from Fragment shader, then the Geometry shader must write to the output variables decorated with PrimitiveId in all execution paths", "1.3-extensions"},
    {"VUID-PrimitiveId-Fragment-04332", "If pipeline contains both the Fragment and MeshEXT or MeshNV Execution Model and a variable decorated with PrimitiveId is read from Fragment shader, then the MeshEXT or MeshNV shader must write to the output variables decorated with PrimitiveId in all execution paths", "1.3-extensions"},
    {"VUID-PrimitiveId-Fragment-04333", "If Fragment Execution Model contains a variable decorated with PrimitiveId, then either the MeshShadingEXT, MeshShadingNV, Geometry or Tessellation capability must also be declared", "1.3-extensions"},
    {"VUID-PrimitiveId-PrimitiveId-04330", "The PrimitiveId decoration must be used only within the MeshEXT, MeshNV, IntersectionKHR, AnyHitKHR, ClosestHitKHR, TessellationControl, TessellationEvaluation, Geometry, or Fragment Execution Model", "1.3-extensions"},
    {"VUID-PrimitiveId-PrimitiveId-04334", "The variable decorated with PrimitiveId within the TessellationControl, TessellationEvaluation, Fragment, IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-PrimitiveId-PrimitiveId-04335", "The variable decorated with PrimitiveId within the Geometry Execution Model must be declared using the Input or Output Storage Class", "1.3-extensions"},
    {"VUID-PrimitiveId-PrimitiveId-04336", "The variable decorated with PrimitiveId within the MeshEXT or MeshNV Execution Model must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-PrimitiveId-PrimitiveId-04337", "The variable decorated with PrimitiveId must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-PrimitiveId-PrimitiveId-07040", "The variable decorated with PrimitiveId within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", "1.3-extensions"},
    {"VUID-PrimitiveIndicesNV-OutputLinesNV-04343", "If the Execution Mode is OutputLinesNV, then the array decorated with PrimitiveIndicesNV must be the size of two times the value specified by OutputPrimitivesNV", "1.3-extensions"},
    {"VUID-PrimitiveIndicesNV-OutputPoints-04342", "If the Execution Mode is OutputPoints, then the array decorated with PrimitiveIndicesNV must be the size of the value specified by OutputPrimitivesNV", "1.3-extensions"},
    {"VUID-PrimitiveIndicesNV-OutputTrianglesNV-04344", "If the Execution Mode is OutputTrianglesNV, then the array decorated with PrimitiveIndicesNV must be the size of three times the value specified by OutputPrimitivesNV", "1.3-extensions"},
    {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04338", "The PrimitiveIndicesNV decoration must be used only within the MeshNV Execution Model", "1.3-extensions"},
    {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04339", "The variable decorated with PrimitiveIndicesNV must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04340", "The variable decorated with PrimitiveIndicesNV must be declared as an array of scalar 32-bit integer values", "1.3-extensions"},
    {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04341", "All index values of the array decorated with PrimitiveIndicesNV must be in the range [0, N-1], where N is the value specified by the OutputVertices Execution Mode", "1.3-extensions"},
    {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07047", "The PrimitiveLineIndicesEXT decoration must be used only within the MeshEXT Execution Model", "1.3-extensions"},
    {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07048", "The PrimitiveLineIndicesEXT decoration must be used with the OutputLinesEXT Execution Mode", "1.3-extensions"},
    {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07049", "The variable decorated with PrimitiveLineIndicesEXT must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07050", "The variable decorated with PrimitiveLineIndicesEXT must be declared as an array of two component vector 32-bit integer values", "1.3-extensions"},
    {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07051", "All index values of the array decorated with PrimitiveLineIndicesEXT must be in the range [0, N-1], where N is the value specified by the OutputVertices Execution Mode", "1.3-extensions"},
    {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07052", "The size of the array decorated with PrimitiveLineIndicesEXT must match the value specified by OutputPrimitivesEXT", "1.3-extensions"},
    {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07041", "The PrimitivePointIndicesEXT decoration must be used only within the MeshEXT Execution Model", "1.3-extensions"},
    {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07042", "The PrimitivePointIndicesEXT decoration must be used with the OutputPoints Execution Mode", "1.3-extensions"},
    {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07043", "The variable decorated with PrimitivePointIndicesEXT must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07044", "The variable decorated with PrimitivePointIndicesEXT must be declared as an array of scalar 32-bit integer values", "1.3-extensions"},
    {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07045", "All index values of the array decorated with PrimitivePointIndicesEXT must be in the range [0, N-1], where N is the value specified by the OutputVertices Execution Mode", "1.3-extensions"},
    {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07046", "The size of the array decorated with PrimitivePointIndicesEXT must match the value specified by OutputPrimitivesEXT", "1.3-extensions"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04484", "The PrimitiveShadingRateKHR decoration must be used only within the MeshEXT, MeshNV, Vertex, or Geometry Execution Model", "1.3-extensions"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04485", "The variable decorated with PrimitiveShadingRateKHR must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04486", "The variable decorated with PrimitiveShadingRateKHR must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04487", "The value written to PrimitiveShadingRateKHR must include no more than one of Vertical2Pixels and Vertical4Pixels", "1.3-extensions"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04488", "The value written to PrimitiveShadingRateKHR must include no more than one of Horizontal2Pixels and Horizontal4Pixels", "1.3-extensions"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04489", "The value written to PrimitiveShadingRateKHR must not have any bits set other than those defined by Fragment Shading Rate Flags enumerants in the SPIR-V specification", "1.3-extensions"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-07059", "The variable decorated with PrimitiveShadingRateKHR within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", "1.3-extensions"},
    {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07053", "The PrimitiveTriangleIndicesEXT decoration must be used only within the MeshEXT Execution Model", "1.3-extensions"},
    {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07054", "The PrimitiveTriangleIndicesEXT decoration must be used with the OutputTrianglesEXT Execution Mode", "1.3-extensions"},
    {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07055", "The variable decorated with PrimitiveTriangleIndicesEXT must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07056", "The variable decorated with PrimitiveTriangleIndicesEXT must be declared as an array of three component vector 32-bit integer values", "1.3-extensions"},
    {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07057", "All index values of the array decorated with PrimitiveTriangleIndicesEXT must be in the range [0, N-1], where N is the value specified by the OutputVertices Execution Mode", "1.3-extensions"},
    {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07058", "The size of the array decorated with PrimitiveTriangleIndicesEXT must match the value specified by OutputPrimitivesEXT", "1.3-extensions"},
    {"VUID-RayGeometryIndexKHR-RayGeometryIndexKHR-04345", "The RayGeometryIndexKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", "1.3-extensions"},
    {"VUID-RayGeometryIndexKHR-RayGeometryIndexKHR-04346", "The variable decorated with RayGeometryIndexKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-RayGeometryIndexKHR-RayGeometryIndexKHR-04347", "The variable decorated with RayGeometryIndexKHR must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-RayTmaxKHR-RayTmaxKHR-04348", "The RayTmaxKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", "1.3-extensions"},
    {"VUID-RayTmaxKHR-RayTmaxKHR-04349", "The variable decorated with RayTmaxKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-RayTmaxKHR-RayTmaxKHR-04350", "The variable decorated with RayTmaxKHR must be declared as a scalar 32-bit floating-point value", "1.3-extensions"},
    {"VUID-RayTminKHR-RayTminKHR-04351", "The RayTminKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", "1.3-extensions"},
    {"VUID-RayTminKHR-RayTminKHR-04352", "The variable decorated with RayTminKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-RayTminKHR-RayTminKHR-04353", "The variable decorated with RayTminKHR must be declared as a scalar 32-bit floating-point value", "1.3-extensions"},
    {"VUID-RuntimeSpirv-DescriptorSet-06323", "DescriptorSet and Binding decorations must obey the constraints on Storage Class, type, and descriptor type described in DescriptorSet and Binding Assignment", "1.3-extensions"},
    {"VUID-RuntimeSpirv-LocalSizeId-06434", "If Execution Mode LocalSizeId is used, maintenance4 must be enabled", "1.3-extensions"},
    {"VUID-RuntimeSpirv-Location-06272", "The sum of Location and the number of locations the variable it decorates consumes must be less than or equal to the value for the matching Execution Model defined in Shader Input and Output Locations", "1.3-extensions"},
    {"VUID-RuntimeSpirv-Location-06428", "The maximum number of storage buffers, storage images, and output Location decorated color attachments written to in the Fragment Execution Model must be less than or equal to maxFragmentCombinedOutputResources", "1.3-extensions"},
    {"VUID-RuntimeSpirv-MaximallyReconvergesKHR-09565", "The execution mode MaximallyReconvergesKHR must not be applied to an entry point unless the entry point does not execute any invocation repack instructions", "1.3-extensions"},
    {"VUID-RuntimeSpirv-MeshEXT-07115", "For mesh shaders using the MeshEXT Execution Model the OutputVertices OpExecutionMode must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshOutputVertices", "1.3-extensions"},
    {"VUID-RuntimeSpirv-MeshEXT-07116", "For mesh shaders using the MeshEXT Execution Model the OutputPrimitivesEXT OpExecutionMode must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshOutputPrimitives", "1.3-extensions"},
    {"VUID-RuntimeSpirv-MeshEXT-07118", "In mesh shaders using the MeshEXT Execution Model OpSetMeshOutputsEXT must be called at most once under dynamically uniform conditions", "1.3-extensions"},
    {"VUID-RuntimeSpirv-MeshEXT-07295", "For mesh shaders using the MeshEXT Execution Model the x size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupSize[0]", "1.3-extensions"},
    {"VUID-RuntimeSpirv-MeshEXT-07296", "For mesh shaders using the MeshEXT Execution Model the y size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupSize[1]", "1.3-extensions"},
    {"VUID-RuntimeSpirv-MeshEXT-07297", "For mesh shaders using the MeshEXT Execution Model the z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupSize[2]", "1.3-extensions"},
    {"VUID-RuntimeSpirv-MeshEXT-07298", "For mesh shaders using the MeshEXT Execution Model the product of x size, y size, and z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupInvocations", "1.3-extensions"},
    {"VUID-RuntimeSpirv-MeshEXT-07332", "For mesh shaders using the MeshEXT Execution Model the \"Vertex Count\" operand of OpSetMeshOutputsEXT must be less than or equal to OutputVertices OpExecutionMode", "1.3-extensions"},
    {"VUID-RuntimeSpirv-MeshEXT-07333", "For mesh shaders using the MeshEXT Execution Model the \"Primitive Count\" operand of OpSetMeshOutputsEXT must be less than or equal to OutputPrimitivesEXT OpExecutionMode", "1.3-extensions"},
    {"VUID-RuntimeSpirv-MeshEXT-09218", "In mesh shaders using the MeshEXT or MeshNV Execution Model and the OutputPoints Execution Mode, if maintenance5 is not enabled, and if the number of output points is greater than 0, a PointSize decorated variable must be written to for each output point", "1.3-extensions"},
    {"VUID-RuntimeSpirv-MeshNV-07113", "For mesh shaders using the MeshNV Execution Model the OutputVertices OpExecutionMode must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxMeshOutputVertices", "1.3-extensions"},
    {"VUID-RuntimeSpirv-MeshNV-07114", "For mesh shaders using the MeshNV Execution Model the OutputPrimitivesNV OpExecutionMode must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxMeshOutputPrimitives", "1.3-extensions"},
    {"VUID-RuntimeSpirv-NodePayloadAMDX-09192", "Variables in the NodePayloadAMDX storage class must only be declared in the GLCompute execution model", "1.3-extensions"},
    {"VUID-RuntimeSpirv-NonUniform-06274", "If an instruction loads from or stores to a resource (including atomics and image instructions) and the resource descriptor being accessed is not dynamically uniform, then the operand corresponding to that resource (e.g. the pointer or sampled image operand) must be decorated with NonUniform", "1.3-extensions"},
    {"VUID-RuntimeSpirv-NonWritable-06340", "If fragmentStoresAndAtomics is not enabled, then all storage image, storage texel buffer, and storage buffer variables in the fragment stage must be decorated with the NonWritable decoration", "1.3-extensions"},
    {"VUID-RuntimeSpirv-NonWritable-06341", "If vertexPipelineStoresAndAtomics is not enabled, then all storage image, storage texel buffer, and storage buffer variables in the vertex, tessellation, and geometry stages must be decorated with the NonWritable decoration", "1.3-extensions"},
    {"VUID-RuntimeSpirv-None-06275", "shaderSubgroupExtendedTypes must be enabled for group operations to use 8-bit integer, 16-bit integer, 64-bit integer, 16-bit floating-point, and vectors of these types", "1.3-extensions"},
    {"VUID-RuntimeSpirv-None-06278", "shaderBufferInt64Atomics must be enabled for 64-bit integer atomic operations to be supported on a Pointer with a Storage Class of StorageBuffer or Uniform", "1.3-extensions"},
    {"VUID-RuntimeSpirv-None-06279", "shaderSharedInt64Atomics must be enabled for 64-bit integer atomic operations to be supported on a Pointer with a Storage Class of Workgroup", "1.3-extensions"},
    {"VUID-RuntimeSpirv-None-06284", "shaderBufferFloat32Atomics, or shaderBufferFloat32AtomicAdd, or shaderBufferFloat64Atomics, or shaderBufferFloat64AtomicAdd, or shaderBufferFloat16Atomics, or shaderBufferFloat16AtomicAdd, or shaderBufferFloat16AtomicMinMax, or shaderBufferFloat32AtomicMinMax, or shaderBufferFloat64AtomicMinMax, or shaderFloat16VectorAtomics must be enabled for floating-point atomic operations to be supported on a Pointer with a Storage Class of StorageBuffer", "1.3-extensions"},
    {"VUID-RuntimeSpirv-None-06285", "shaderSharedFloat32Atomics, or shaderSharedFloat32AtomicAdd, or shaderSharedFloat64Atomics, or shaderSharedFloat64AtomicAdd, or shaderSharedFloat16Atomics, or shaderSharedFloat16AtomicAdd, or shaderSharedFloat16AtomicMinMax, or shaderSharedFloat32AtomicMinMax, or shaderSharedFloat64AtomicMinMax, or shaderFloat16VectorAtomics, must be enabled for floating-point atomic operations to be supported on a Pointer with a Storage Class of Workgroup", "1.3-extensions"},
    {"VUID-RuntimeSpirv-None-06286", "shaderImageFloat32Atomics, or shaderImageFloat32AtomicAdd, or shaderImageFloat32AtomicMinMax, must be enabled for 32-bit floating-point atomic operations to be supported on a Pointer with a Storage Class of Image", "1.3-extensions"},
    {"VUID-RuntimeSpirv-None-06287", "sparseImageFloat32Atomics, or sparseImageFloat32AtomicAdd, or sparseImageFloat32AtomicMinMax, must be enabled for 32-bit floating-point atomics to be supported on sparse images", "1.3-extensions"},
    {"VUID-RuntimeSpirv-None-06288", "shaderImageInt64Atomics must be enabled for 64-bit integer atomic operations to be supported on a Pointer with a Storage Class of Image", "1.3-extensions"},
    {"VUID-RuntimeSpirv-None-06337", "shaderBufferFloat16Atomics, or shaderBufferFloat16AtomicAdd, or shaderBufferFloat16AtomicMinMax, or shaderSharedFloat16Atomics, or shaderSharedFloat16AtomicAdd, or shaderSharedFloat16AtomicMinMax must be enabled for 16-bit floating-point atomic operations", "1.3-extensions"},
    {"VUID-RuntimeSpirv-None-06338", "shaderBufferFloat32Atomics, or shaderBufferFloat32AtomicAdd, or shaderSharedFloat32Atomics, or shaderSharedFloat32AtomicAdd, or shaderImageFloat32Atomics, or shaderImageFloat32AtomicAdd or shaderBufferFloat32AtomicMinMax, or shaderSharedFloat32AtomicMinMax, or shaderImageFloat32AtomicMinMax must be enabled for 32-bit floating-point atomic operations", "1.3-extensions"},
    {"VUID-RuntimeSpirv-None-06339", "shaderBufferFloat64Atomics, or shaderBufferFloat64AtomicAdd, or shaderSharedFloat64Atomics, or shaderSharedFloat64AtomicAdd, or shaderBufferFloat64AtomicMinMax, or shaderSharedFloat64AtomicMinMax, must be enabled for 64-bit floating-point atomic operations", "1.3-extensions"},
    {"VUID-RuntimeSpirv-None-06342", "If subgroupQuadOperationsInAllStages is VK_FALSE, then quad subgroup operations must not be used except for in fragment and compute stages", "1.3-extensions"},
    {"VUID-RuntimeSpirv-None-06343", "Group operations with subgroup scope must not be used if the shader stage is not in subgroupSupportedStages", "1.3-extensions"},
    {"VUID-RuntimeSpirv-None-09558", "If dynamicRenderingLocalRead is not enabled, any variable created with a \"Type\" of OpTypeImage that has a \"Dim\" operand of SubpassData must be decorated with InputAttachmentIndex", "1.3-extensions"},
    {"VUID-RuntimeSpirv-Offset-06308", "The Offset plus size of the type of each variable, in the output interface of the entry point being compiled, decorated with XfbBuffer must not be greater than VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackBufferDataSize", "1.3-extensions"},
    {"VUID-RuntimeSpirv-Offset-06344", "The first element of the Offset operand of InterpolateAtOffset must be greater than or equal to: fragwidth × minInterpolationOffset where fragwidth is the width of the current fragment in pixels", "1.3-extensions"},
    {"VUID-RuntimeSpirv-Offset-06345", "The first element of the Offset operand of InterpolateAtOffset must be less than or equal to fragwidth × (maxInterpolationOffset + ULP ) - ULP where fragwidth is the width of the current fragment in pixels and ULP = 1 / 2^subPixelInterpolationOffsetBits^", "1.3-extensions"},
    {"VUID-RuntimeSpirv-Offset-06346", "The second element of the Offset operand of InterpolateAtOffset must be greater than or equal to fragheight × minInterpolationOffset where fragheight is the height of the current fragment in pixels", "1.3-extensions"},
    {"VUID-RuntimeSpirv-Offset-06347", "The second element of the Offset operand of InterpolateAtOffset must be less than or equal to fragheight × (maxInterpolationOffset + ULP ) - ULP where fragheight is the height of the current fragment in pixels and ULP = 1 / 2^subPixelInterpolationOffsetBits^", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpCooperativeMatrixLoadKHR-08986", "For OpCooperativeMatrixLoadKHR and OpCooperativeMatrixStoreKHR instructions, the Pointer and Stride operands must be aligned to at least the lesser of 16 bytes or the natural alignment of a row or column (depending on ColumnMajor) of the matrix (where the natural alignment is the number of columns/rows multiplied by the component size)", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpCooperativeMatrixLoadNV-06324", "For OpCooperativeMatrixLoadNV and OpCooperativeMatrixStoreNV instructions, the Pointer and Stride operands must be aligned to at least the lesser of 16 bytes or the natural alignment of a row or column (depending on ColumnMajor) of the matrix (where the natural alignment is the number of columns/rows multiplied by the component size)", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpCooperativeMatrixMulAddKHR-10060", "For OpCooperativeMatrixMulAddKHR, the operands must match a supported VkCooperativeMatrixPropertiesKHR", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpEmitStreamVertex-06310", "The Stream value to OpEmitStreamVertex and OpEndStreamPrimitive must be less than VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackStreams", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpEntryPoint-07754", "Any user-defined variables between the OpEntryPoint of two shader stages must have the same type and width for each Component", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpEntryPoint-08727", "Each OpEntryPoint must not have more than one variable decorated with InputAttachmentIndex per image aspect of the attachment image bound to it, either explicitly or implicitly as described by input attachment interface", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpEntryPoint-08743", "Any user-defined variables shared between the OpEntryPoint of two shader stages, and declared with Input as its Storage Class for the subsequent shader stage, must have all Location slots and Component words declared in the preceding shader stage's OpEntryPoint with Output as the Storage Class", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayMotionNV-07704", "For OpHitObjectTraceRayMotionNV instructions, if Acceleration Structure was built with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags, the pipeline must have been created with VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV set", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayMotionNV-07709", "For OpHitObjectTraceRayMotionNV instructions, Acceleration Structure must be an acceleration structure built as a top-level acceleration structure with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayMotionNV-07711", "For OpHitObjectTraceRayMotionNV instructions the pipeline must have been created with VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV set", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07705", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, all components of the RayOrigin and RayDirection operands must be finite floating-point values", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07706", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the RayTmin and RayTmax operands must be non-negative floating-point values", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07707", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the RayTmin operand must be less than or equal to the RayTmax operand", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07708", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, RayOrigin, RayDirection, RayTmin, and RayTmax operands must not contain NaNs", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07710", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions the time operand must be between 0.0 and 1.0", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07712", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the Rayflags operand must not contain both SkipTrianglesKHR and SkipAABBsKHR", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07713", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the Rayflags operand must not contain more than one of SkipTrianglesKHR, CullBackFacingTrianglesKHR, and CullFrontFacingTrianglesKHR", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07714", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the Rayflags operand must not contain more than one of OpaqueKHR, NoOpaqueKHR, CullOpaqueKHR, and CullNoOpaqueKHR", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07715", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, if the Rayflags operand contains SkipTrianglesKHR, the pipeline must not have been created with VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR set", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07716", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, if the Rayflags operand contains SkipAABBsKHR, the pipeline must not have been created with VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR set", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImage-06376", "If an OpImage*Gather operation has an image operand of Offset, ConstOffset, or ConstOffsets the offset value must be greater than or equal to minTexelGatherOffset", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImage-06377", "If an OpImage*Gather operation has an image operand of Offset, ConstOffset, or ConstOffsets the offset value must be less than or equal to maxTexelGatherOffset", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchSADQCOM-06982", "If an OpImageBlockMatchSADQCOM or OpImageBlockMatchSSDQCOM operation is used, then the target sampled image, reference sampled image, and Block Size parameters must both be dynamically uniform for the quad", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06983", "If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then target sampled image and reference sampled image parameters must be of storage class UniformConstant and type OpTypeImage with Depth=0, Dim=2D, Arrayed=0, MS=0, and Sampled=1", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06984", "If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then the target sampled image and reference sampled image parameters must be decorated with BlockMatchTextureQCOM", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06985", "If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then target sampled image and reference sampled image parameters must have been created using an identical sampler object", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06986", "If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then target sampled image and reference sampled image parameters must have been created with a sampler object with unnormalizedCoordinates equal to VK_TRUE", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06987", "If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then target sampled image and reference sampled image parameters must have been created with a sampler object with unnormalizedCoordinates equal to VK_TRUE", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06988", "If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then Block Size less than or equal to maxBlockMatchRegion", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09219", "If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then the target sampled image, reference sampled image, and Block Size parameters must both be dynamically uniform for the quad", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09220", "If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then target sampled image and reference sampled image parameters must be of storage class UniformConstant and type OpTypeImage with Depth=0, Dim=2D, Arrayed=0, MS=0, and Sampled=1", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09221", "If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then the target sampled image and reference sampled image parameters must be decorated with BlockMatchTextureQCOM", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09222", "If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then target sampled image and reference sampled image parameters must have been created using an identical sampler object", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09223", "If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then target sampled image and reference sampled image parameters must have been created with a sampler object with unnormalizedCoordinates equal to VK_TRUE", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09224", "If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then target sampled image and reference sampled image parameters must have been created with sampler object with unnormalizedCoordinates equal to VK_TRUE", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBoxFilterQCOM-06989", "If an OpImageBoxFilterQCOM operation is used, then Box Size.y must be equal to or greater than 1.0 and less than or equal to maxBoxFilterBlockSize.height", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageBoxFilterQCOM-06990", "If an OpImageBoxFilterQCOM operation is used, then Sampled Texture Image and Box Size parameters must be dynamically uniform", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageSample-06435", "If an OpImageSample* or OpImageFetch* operation has an image operand of ConstOffset then the offset value must be greater than or equal to minTexelOffset", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageSample-06436", "If an OpImageSample* or OpImageFetch* operation has an image operand of ConstOffset then the offset value must be less than or equal to maxTexelOffset", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageWeightedSampleQCOM-06979", "If an OpImageWeightedSampleQCOM operation is used, then the Texture Sampled Image and Weight Image parameters must both be dynamically uniform for the quad", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageWeightedSampleQCOM-06980", "If an OpImageWeightedSampleQCOM operation is used, then the Weight Image parameter must be of Storage Class UniformConstant and type OpTypeImage with Depth=0, Dim=2D, Arrayed=1, MS=0, and Sampled=1", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageWeightedSampleQCOM-06981", "If an OpImageWeightedSampleQCOM operation is used, then the Weight Image parameter must be decorated with WeightTextureQCOM", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpImageWrite-07112", "OpImageWrite to any Image whose Image Format is not Unknown must have the Texel operand contain at least as many components as the corresponding VkFormat as given in the SPIR-V Image Format compatibility table", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpRayQueryGenerateIntersectionKHR-06353", "For OpRayQueryGenerateIntersectionKHR instructions, Hit T must satisfy the condition RayTmin ≤ Hit T ≤ RayTmax, where RayTmin is equal to the value returned by OpRayQueryGetRayTMinKHR with the same ray query object, and RayTmax is equal to the value of OpRayQueryGetIntersectionTKHR for the current committed intersection with the same ray query object", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpRayQueryGenerateIntersectionKHR-06354", "For OpRayQueryGenerateIntersectionKHR instructions, Acceleration Structure must not be built with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06348", "For OpRayQueryInitializeKHR instructions, all components of the RayOrigin and RayDirection operands must be finite floating-point values", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06349", "For OpRayQueryInitializeKHR instructions, the RayTmin and RayTmax operands must be non-negative floating-point values", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06350", "For OpRayQueryInitializeKHR instructions, the RayTmin operand must be less than or equal to the RayTmax operand", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06351", "For OpRayQueryInitializeKHR instructions, RayOrigin, RayDirection, RayTmin, and RayTmax operands must not contain NaNs", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06352", "For OpRayQueryInitializeKHR instructions, Acceleration Structure must be an acceleration structure built as a top-level acceleration structure", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06889", "For OpRayQueryInitializeKHR instructions, the Rayflags operand must not contain both SkipTrianglesKHR and SkipAABBsKHR", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06890", "For OpRayQueryInitializeKHR instructions, the Rayflags operand must not contain more than one of SkipTrianglesKHR, CullBackFacingTrianglesKHR, and CullFrontFacingTrianglesKHR", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06891", "For OpRayQueryInitializeKHR instructions, the Rayflags operand must not contain more than one of OpaqueKHR, NoOpaqueKHR, CullOpaqueKHR, and CullNoOpaqueKHR", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpReportIntersectionKHR-06998", "The value of the \"Hit Kind\" operand of OpReportIntersectionKHR must be in the range [0,127]", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06355", "For OpTraceRayKHR instructions, all components of the RayOrigin and RayDirection operands must be finite floating-point values", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06356", "For OpTraceRayKHR instructions, the RayTmin and RayTmax operands must be non-negative floating-point values", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06357", "For OpTraceRayKHR instructions, the RayTmin operand must be less than or equal to the RayTmax operand", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06358", "For OpTraceRayKHR instructions, RayOrigin, RayDirection, RayTmin, and RayTmax operands must not contain NaNs", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06359", "For OpTraceRayKHR instructions, Acceleration Structure must be an acceleration structure built as a top-level acceleration structure", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06360", "For OpTraceRayKHR instructions, if Acceleration Structure was built with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags, the pipeline must have been created with VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV set", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06552", "For OpTraceRayKHR instructions, the Rayflags operand must not contain both SkipTrianglesKHR and SkipAABBsKHR", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06553", "For OpTraceRayKHR instructions, if the Rayflags operand contains SkipTrianglesKHR, the pipeline must not have been created with VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR set", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06554", "For OpTraceRayKHR instructions, if the Rayflags operand contains SkipAABBsKHR, the pipeline must not have been created with VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR set", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06892", "For OpTraceRayKHR instructions, the Rayflags operand must not contain more than one of SkipTrianglesKHR, CullBackFacingTrianglesKHR, and CullFrontFacingTrianglesKHR", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06893", "For OpTraceRayKHR instructions, the Rayflags operand must not contain more than one of OpaqueKHR, NoOpaqueKHR, CullOpaqueKHR, and CullNoOpaqueKHR", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06361", "For OpTraceRayMotionNV instructions, all components of the RayOrigin and RayDirection operands must be finite floating-point values", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06362", "For OpTraceRayMotionNV instructions, the RayTmin and RayTmax operands must be non-negative floating-point values", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06363", "For OpTraceRayMotionNV instructions, the RayTmin operand must be less than or equal to the RayTmax operand", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06364", "For OpTraceRayMotionNV instructions, RayOrigin, RayDirection, RayTmin, and RayTmax operands must not contain NaNs", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06365", "For OpTraceRayMotionNV instructions, Acceleration Structure must be an acceleration structure built as a top-level acceleration structure with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06366", "For OpTraceRayMotionNV instructions the time operand must be between 0.0 and 1.0", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06367", "For OpTraceRayMotionNV instructions the pipeline must have been created with VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV set", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixKHR-08974", "For OpTypeCooperativeMatrixKHR, the component type, scope, number of rows, and number of columns must match one of the matrices in any of the supported VkCooperativeMatrixPropertiesKHR.", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixMulAddNV-10059", "For OpTypeCooperativeMatrixMulAddNV, the operands must match a supported VkCooperativeMatrixPropertiesNV, such that: The type of A must have Rows match VkCooperativeMatrixPropertiesNV::MSize, Columns match VkCooperativeMatrixPropertiesNV::KSize, and ComponentType match VkCooperativeMatrixPropertiesNV::AType. The type of B must have Rows match VkCooperativeMatrixPropertiesNV::KSize, Columns match VkCooperativeMatrixPropertiesNV::NSize, and ComponentType match VkCooperativeMatrixPropertiesNV::BType. The type of C must have Rows match VkCooperativeMatrixPropertiesNV::MSize, Columns match VkCooperativeMatrixPropertiesNV::NSize, and ComponentType match VkCooperativeMatrixPropertiesNV::CType. The type of Result must have Rows match VkCooperativeMatrixPropertiesNV::MSize, Columns match VkCooperativeMatrixPropertiesNV::NSize, and ComponentType match VkCooperativeMatrixPropertiesNV::DType. The scope of all cooperative matrix operands must be VkScopeNV::VK_SCOPE_SUBGROUP_NV. If ComponentType of A, B, C, or Result is a signed integral type, the Signedness operand of the OpTypeInt must be 1. If ComponentType of A, B, C, or Result is an unsigned integral type, the Signedness operand of the OpTypeInt must be 0.", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixNV-06316", "For OpTypeCooperativeMatrixNV, the component type, scope, number of rows, and number of columns must match one of the matrices in any of the supported VkCooperativeMatrixPropertiesNV", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixNV-06322", "OpTypeCooperativeMatrixNV and OpCooperativeMatrix* instructions must not be used in shader stages not included in VkPhysicalDeviceCooperativeMatrixPropertiesNV::cooperativeMatrixSupportedStages", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpTypeImage-09644", "Any variable declared as an OpTypeArray where the Element Type is an OpTypeImage with a \"Dim\" operand of SubpassData must be decorated with InputAttachmentIndex", "1.3-extensions"},
    {"VUID-RuntimeSpirv-OpVariable-08746", "Any OpVariable, Block-decorated OpTypeStruct, or Block-decorated OpTypeStruct members shared between the OpEntryPoint of two shader stages must have matching decorations as defined in interface matching", "1.3-extensions"},
    {"VUID-RuntimeSpirv-PhysicalStorageBuffer64-06314", "If the PhysicalStorageBuffer64 addressing model is enabled any load or store through a physical pointer type must be aligned to a multiple of the size of the largest scalar type in the pointed-to type", "1.3-extensions"},
    {"VUID-RuntimeSpirv-PhysicalStorageBuffer64-06315", "If the PhysicalStorageBuffer64 addressing model is enabled the pointer value of a memory access instruction must be at least as aligned as specified by the Aligned memory access operand", "1.3-extensions"},
    {"VUID-RuntimeSpirv-SampleRateShading-06378", "If the subpass description contains VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM, then the SPIR-V fragment shader Capability SampleRateShading must not be enabled", "1.3-extensions"},
    {"VUID-RuntimeSpirv-ShaderEnqueueAMDX-09191", "The ShaderEnqueueAMDX capability must only be used in shaders with the GLCompute execution model", "1.3-extensions"},
    {"VUID-RuntimeSpirv-Stream-06312", "The stream number value to Stream must be less than VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackStreams", "1.3-extensions"},
    {"VUID-RuntimeSpirv-SubgroupUniformControlFlowKHR-06379", "The Execution Mode SubgroupUniformControlFlowKHR must not be applied to an entry point unless shaderSubgroupUniformControlFlow is enabled, the corresponding shader stage bit is set in subgroupSupportedStages, and the entry point does not execute any invocation repack instructions", "1.3-extensions"},
    {"VUID-RuntimeSpirv-TaskEXT-07117", "In task shaders using the TaskEXT Execution Model OpEmitMeshTasksEXT must be called exactly once under dynamically uniform conditions", "1.3-extensions"},
    {"VUID-RuntimeSpirv-TaskEXT-07291", "In task shaders using the TaskEXT Execution Model the x size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupSize[0]", "1.3-extensions"},
    {"VUID-RuntimeSpirv-TaskEXT-07292", "In task shaders using the TaskEXT Execution Model the y size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupSize[1]", "1.3-extensions"},
    {"VUID-RuntimeSpirv-TaskEXT-07293", "In task shaders using the TaskEXT Execution Model the z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupSize[2]", "1.3-extensions"},
    {"VUID-RuntimeSpirv-TaskEXT-07294", "In task shaders using the TaskEXT Execution Model the product of x size, y size, and z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupInvocations", "1.3-extensions"},
    {"VUID-RuntimeSpirv-TaskEXT-07299", "In task shaders using the TaskEXT Execution Model the value of the \"Group Count X\" operand of OpEmitMeshTasksEXT must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[0]", "1.3-extensions"},
    {"VUID-RuntimeSpirv-TaskEXT-07300", "In task shaders using the TaskEXT Execution Model the value of the \"Group Count Y\" operand of OpEmitMeshTasksEXT must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[1]", "1.3-extensions"},
    {"VUID-RuntimeSpirv-TaskEXT-07301", "In task shaders using the TaskEXT Execution Model the value of the \"Group Count Z\" operand of OpEmitMeshTasksEXT must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[2]", "1.3-extensions"},
    {"VUID-RuntimeSpirv-TaskEXT-07302", "In task shaders using the TaskEXT Execution Model the product of the \"Group Count\" operands of OpEmitMeshTasksEXT must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupTotalCount", "1.3-extensions"},
    {"VUID-RuntimeSpirv-Workgroup-06530", "The sum of size in bytes for variables and padding in the Workgroup Storage Class in the GLCompute Execution Model must be less than or equal to maxComputeSharedMemorySize", "1.3-extensions"},
    {"VUID-RuntimeSpirv-XfbBuffer-06309", "For any given XfbBuffer value, define the buffer data size to be smallest number of bytes such that, for all outputs decorated with the same XfbBuffer value, the size of the output interface variable plus the Offset is less than or equal to the buffer data size. For a given Stream, the sum of all the buffer data sizes for all buffers writing to that stream the must not exceed VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackStreamDataSize", "1.3-extensions"},
    {"VUID-RuntimeSpirv-XfbStride-06313", "The XFB Stride value to XfbStride must be less than or equal to VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackBufferDataStride", "1.3-extensions"},
    {"VUID-RuntimeSpirv-apiVersion-07954", "If VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.3, the VK_KHR_format_feature_flags2 extension is not supported, and shaderStorageImageWriteWithoutFormat is not enabled, any variable created with a \"Type\" of OpTypeImage that has a \"Sampled\" operand of 2 and an \"Image Format\" operand of Unknown must be decorated with NonWritable", "1.3-extensions"},
    {"VUID-RuntimeSpirv-apiVersion-07955", "If VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.3, the VK_KHR_format_feature_flags2 extension is not supported, and shaderStorageImageReadWithoutFormat is not enabled, any variable created with a \"Type\" of OpTypeImage that has a \"Sampled\" operand of 2 and an \"Image Format\" operand of Unknown must be decorated with NonReadable", "1.3-extensions"},
    {"VUID-RuntimeSpirv-cooperativeMatrixSupportedStages-08985", "OpTypeCooperativeMatrixKHR and OpCooperativeMatrix* instructions must not be used in shader stages not included in VkPhysicalDeviceCooperativeMatrixPropertiesKHR::cooperativeMatrixSupportedStages", "1.3-extensions"},
    {"VUID-RuntimeSpirv-denormBehaviorIndependence-06289", "If denormBehaviorIndependence is VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY, then the entry point must use the same denormals Execution Mode for both 16-bit and 64-bit floating-point types", "1.3-extensions"},
    {"VUID-RuntimeSpirv-denormBehaviorIndependence-06290", "If denormBehaviorIndependence is VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE, then the entry point must use the same denormals Execution Mode for all floating-point types", "1.3-extensions"},
    {"VUID-RuntimeSpirv-flags-08761", "For OpRayQueryGetIntersectionTriangleVertexPositionsKHR instructions, Acceleration Structure must have been built with VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DATA_ACCESS_KHR in flags", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maintenance4-06817", "If maintenance4 is not enabled, any OpTypeVector output interface variables must not have a higher Component Count than a matching OpTypeVector input interface variable", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maintenance5-09190", "If maintenance5 is enabled and a PointSize decorated variable is written to, all execution paths must write to a PointSize decorated variable", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maxBlockMatchRegion-09225", "If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then Block Size less than or equal to maxBlockMatchRegion", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maxExecutionGraphShaderOutputNodes-09197", "Shaders must not include more than maxExecutionGraphShaderOutputNodes instances of OpInitializeNodePayloadsAMDX", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maxExecutionGraphShaderPayloadCount-09196", "Shaders must not statically initialize more than maxExecutionGraphShaderPayloadCount variables in the NodeOutputPayloadAMDX storage class", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maxExecutionGraphShaderPayloadSize-09193", "Variables declared in the NodePayloadAMDX storage class must not be larger than the maxExecutionGraphShaderPayloadSize limit", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maxExecutionGraphShaderPayloadSize-09194", "Variables declared in the NodeOutputPayloadAMDX storage class must not be larger than the maxExecutionGraphShaderPayloadSize limit", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maxExecutionGraphShaderPayloadSize-09195", "For a given entry point, the sum of the size of any variable in the NodePayloadAMDX storage class, and the combined size of all statically initialized variables in the NodeOutputPayloadAMDX storage class must not be greater than maxExecutionGraphShaderPayloadSize", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maxMeshOutputMemorySize-08756", "The sum of size in bytes for variables in the Output Storage Class in the MeshEXT Execution Model must be less than or equal to maxMeshOutputMemorySize according to the formula in Mesh Shader Output", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maxMeshPayloadAndOutputMemorySize-08757", "The sum of size in bytes for variables and in the TaskPayloadWorkgroupEXT or Output Storage Class in the MeshEXT Execution Model must be less than or equal to maxMeshPayloadAndOutputMemorySize according to the formula in Mesh Shader Output", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maxMeshPayloadAndSharedMemorySize-08755", "The sum of size in bytes for variables and padding in the TaskPayloadWorkgroupEXT or Workgroup Storage Class in the MeshEXT Execution Model must be less than or equal to maxMeshPayloadAndSharedMemorySize", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maxMeshSharedMemorySize-08754", "The sum of size in bytes for variables and padding in the Workgroup Storage Class in the MeshEXT Execution Model must be less than or equal to maxMeshSharedMemorySize", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maxTaskPayloadAndSharedMemorySize-08760", "The sum of size in bytes for variables and padding in the TaskPayloadWorkgroupEXT or Workgroup Storage Class in the TaskEXT Execution Model must be less than or equal to maxTaskPayloadAndSharedMemorySize", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maxTaskPayloadSize-08758", "The sum of size in bytes for variables and in the TaskPayloadWorkgroupEXT Storage Class in the TaskEXT Execution Model must be less than or equal to maxTaskPayloadSize", "1.3-extensions"},
    {"VUID-RuntimeSpirv-maxTaskSharedMemorySize-08759", "The sum of size in bytes for variables and padding in the Workgroup Storage Class in the TaskEXT Execution Model must be less than or equal to maxTaskSharedMemorySize", "1.3-extensions"},
    {"VUID-RuntimeSpirv-minSampleShading-08731", "If sample shading is enabled and minSampleShading is 1.0, the sample operand of any OpColorAttachmentReadEXT, OpDepthAttachmentReadEXT, or OpStencilAttachmentReadEXT operation must evaluate to the value of the coverage index for any given fragment invocation", "1.3-extensions"},
    {"VUID-RuntimeSpirv-minSampleShading-08732", "If sample shading is enabled and any of the OpColorAttachmentReadEXT, OpDepthAttachmentReadEXT, or OpStencilAttachmentReadEXT operations are used, then minSampleShading must be 1.0", "1.3-extensions"},
    {"VUID-RuntimeSpirv-pNext-09226", "If a OpImageBlockMatchWindow*QCOM operation is used, then target sampled image must have been created using asampler object that included VkSamplerBlockMatchWindowCreateInfoQCOM in the pNext chain", "1.3-extensions"},
    {"VUID-RuntimeSpirv-protectedNoFault-09645", "If protectedNoFault is not supported, the Storage Class of the PhysicalStorageBuffer must not be used if the buffer being accessed is protected", "1.3-extensions"},
    {"VUID-RuntimeSpirv-roundingModeIndependence-06291", "If roundingModeIndependence is VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY, then the entry point must use the same rounding Execution Mode for both 16-bit and 64-bit floating-point types", "1.3-extensions"},
    {"VUID-RuntimeSpirv-roundingModeIndependence-06292", "If roundingModeIndependence is VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE, then the entry point must use the same rounding Execution Mode for all floating-point types", "1.3-extensions"},
    {"VUID-RuntimeSpirv-samples-08725", "If an OpTypeImage has an MS operand 0, its bound image must have been created with VkImageCreateInfo::samples as VK_SAMPLE_COUNT_1_BIT", "1.3-extensions"},
    {"VUID-RuntimeSpirv-samples-08726", "If an OpTypeImage has an MS operand 1, its bound image must not have been created with VkImageCreateInfo::samples as VK_SAMPLE_COUNT_1_BIT", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderDenormFlushToZeroFloat16-06299", "If shaderDenormFlushToZeroFloat16 is VK_FALSE, then DenormFlushToZero for 16-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderDenormFlushToZeroFloat32-06300", "If shaderDenormFlushToZeroFloat32 is VK_FALSE, then DenormFlushToZero for 32-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderDenormFlushToZeroFloat64-06301", "If shaderDenormFlushToZeroFloat64 is VK_FALSE, then DenormFlushToZero for 64-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderDenormPreserveFloat16-06296", "If shaderDenormPreserveFloat16 is VK_FALSE, then DenormPreserve for 16-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderDenormPreserveFloat32-06297", "If shaderDenormPreserveFloat32 is VK_FALSE, then DenormPreserve for 32-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderDenormPreserveFloat64-06298", "If shaderDenormPreserveFloat64 is VK_FALSE, then DenormPreserve for 64-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderDeviceClock-06268", "If shaderDeviceClock is not enabled, the Device scope must not be used for OpReadClockKHR", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06767", "If shaderEarlyAndLateFragmentTests is not enabled, the EarlyAndLateFragmentTestsEXT Execution Mode must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06768", "If shaderEarlyAndLateFragmentTests feature is not enabled, the StencilRefUnchangedFrontEXT Execution Mode must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06769", "If shaderEarlyAndLateFragmentTests is not enabled, the StencilRefUnchangedBackEXT Execution Mode must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06770", "If shaderEarlyAndLateFragmentTests is not enabled, the StencilRefGreaterFrontEXT Execution Mode must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06771", "If shaderEarlyAndLateFragmentTests is not enabled, the StencilRefGreaterBackEXT Execution Mode must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06772", "If shaderEarlyAndLateFragmentTests is not enabled, the StencilRefLessFrontEXT Execution Mode must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06773", "If shaderEarlyAndLateFragmentTests is not enabled, the StencilRefLessBackEXT Execution Mode must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderFloat16VectorAtomics-09581", "shaderFloat16VectorAtomics, must be enabled for 16-bit floating-point, 2- and 4-component vector atomic operations to be supported", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderRoundingModeRTEFloat16-06302", "If shaderRoundingModeRTEFloat16 is VK_FALSE, then RoundingModeRTE for 16-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderRoundingModeRTEFloat32-06303", "If shaderRoundingModeRTEFloat32 is VK_FALSE, then RoundingModeRTE for 32-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderRoundingModeRTEFloat64-06304", "If shaderRoundingModeRTEFloat64 is VK_FALSE, then RoundingModeRTE for 64-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderRoundingModeRTZFloat16-06305", "If shaderRoundingModeRTZFloat16 is VK_FALSE, then RoundingModeRTZ for 16-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderRoundingModeRTZFloat32-06306", "If shaderRoundingModeRTZFloat32 is VK_FALSE, then RoundingModeRTZ for 32-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderRoundingModeRTZFloat64-06307", "If shaderRoundingModeRTZFloat64 is VK_FALSE, then RoundingModeRTZ for 64-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderSampleRateInterpolationFunctions-06325", "If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::shaderSampleRateInterpolationFunctions is VK_FALSE, then GLSL.std.450 fragment interpolation functions are not supported by the implementation and OpCapability must not be set to InterpolationFunction", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat16-06293", "If shaderSignedZeroInfNanPreserveFloat16 is VK_FALSE, then SignedZeroInfNanPreserve for 16-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat16-09559", "If shaderSignedZeroInfNanPreserveFloat16 is VK_FALSE then any FPFastMathDefault execution mode with a type of 16-bit float must include the NSZ, NotInf, and NotNaN flags", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat16-09560", "If shaderSignedZeroInfNanPreserveFloat16 is VK_FALSE then any FPFastMathMode decoration on an instruction with result type or any operand type that includes a 16-bit float must include the NSZ, NotInf, and NotNaN flags", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat32-06294", "If shaderSignedZeroInfNanPreserveFloat32 is VK_FALSE, then SignedZeroInfNanPreserve for 32-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat32-09561", "If shaderSignedZeroInfNanPreserveFloat32 is VK_FALSE then any FPFastMathDefault execution mode with a type of 32-bit float must include the NSZ, NotInf, and NotNaN flags", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat32-09562", "If shaderSignedZeroInfNanPreserveFloat32 is VK_FALSE then any FPFastMathMode decoration on an instruction with result type or any operand type that includes a 32-bit float must include the NSZ, NotInf, and NotNaN flags", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat64-06295", "If shaderSignedZeroInfNanPreserveFloat64 is VK_FALSE, then SignedZeroInfNanPreserve for 64-bit floating-point type must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat64-09563", "If shaderSignedZeroInfNanPreserveFloat64 is VK_FALSE then any FPFastMathDefault execution mode with a type of 64-bit float must include the NSZ, NotInf, and NotNaN flags", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat64-09564", "If shaderSignedZeroInfNanPreserveFloat64 is VK_FALSE then any FPFastMathMode decoration on an instruction with result type or any operand type that includes a 64-bit float must include the NSZ, NotInf, and NotNaN flags", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderSubgroupClock-06267", "If shaderSubgroupClock is not enabled, the Subgroup scope must not be used for OpReadClockKHR", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderSubgroupRotateClustered-09566", "If shaderSubgroupRotateClustered is VK_FALSE, then the ClusterSize operand to OpGroupNonUniformRotateKHR must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderTileImageColorReadAccess-08728", "If shaderTileImageColorReadAccess is not enabled, OpColorAttachmentReadEXT operation must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderTileImageDepthReadAccess-08729", "If shaderTileImageDepthReadAccess is not enabled, OpDepthAttachmentReadEXT operation must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderTileImageStencilReadAccess-08730", "If shaderTileImageStencilReadAccess is not enabled, OpStencilAttachmentReadEXT operation must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-shaderZeroInitializeWorkgroupMemory-06372", "If shaderZeroInitializeWorkgroupMemory is not enabled, any OpVariable with Workgroup as its Storage Class must not have an Initializer operand", "1.3-extensions"},
    {"VUID-RuntimeSpirv-storageBuffer16BitAccess-06331", "If storageBuffer16BitAccess is VK_FALSE, then objects containing 16-bit integer or 16-bit floating-point elements must not have Storage Class of StorageBuffer, ShaderRecordBufferKHR, or PhysicalStorageBuffer", "1.3-extensions"},
    {"VUID-RuntimeSpirv-storageBuffer8BitAccess-06328", "If storageBuffer8BitAccess is VK_FALSE, then objects containing an 8-bit integer element must not have Storage Class of StorageBuffer, ShaderRecordBufferKHR, or PhysicalStorageBuffer", "1.3-extensions"},
    {"VUID-RuntimeSpirv-storageInputOutput16-06334", "If storageInputOutput16 is VK_FALSE, then objects containing 16-bit integer or 16-bit floating-point elements must not have Storage Class of Input or Output", "1.3-extensions"},
    {"VUID-RuntimeSpirv-storagePushConstant16-06333", "If storagePushConstant16 is VK_FALSE, then objects containing 16-bit integer or 16-bit floating-point elements must not have Storage Class of PushConstant", "1.3-extensions"},
    {"VUID-RuntimeSpirv-storagePushConstant8-06330", "If storagePushConstant8 is VK_FALSE, then objects containing an 8-bit integer element must not have Storage Class of PushConstant", "1.3-extensions"},
    {"VUID-RuntimeSpirv-subgroupBroadcastDynamicId-06276", "If subgroupBroadcastDynamicId is VK_TRUE, and the shader module version is 1.5 or higher, the \"Index\" for OpGroupNonUniformQuadBroadcast must be dynamically uniform within the derivative group. Otherwise, \"Index\" must be a constant", "1.3-extensions"},
    {"VUID-RuntimeSpirv-subgroupBroadcastDynamicId-06277", "If subgroupBroadcastDynamicId is VK_TRUE, and the shader module version is 1.5 or higher, the \"Id\" for OpGroupNonUniformBroadcast must be dynamically uniform within the subgroup. Otherwise, \"Id\" must be a constant", "1.3-extensions"},
    {"VUID-RuntimeSpirv-tessellationShader-06326", "If tessellationShader is enabled, and the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::tessellationIsolines is VK_FALSE, then OpExecutionMode must not be set to IsoLines", "1.3-extensions"},
    {"VUID-RuntimeSpirv-tessellationShader-06327", "If tessellationShader is enabled, and the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::tessellationPointMode is VK_FALSE, then OpExecutionMode must not be set to PointMode", "1.3-extensions"},
    {"VUID-RuntimeSpirv-transformFeedbackStreamsLinesTriangles-06311", "If the geometry shader emits to more than one vertex stream and VkPhysicalDeviceTransformFeedbackPropertiesEXT::transformFeedbackStreamsLinesTriangles is VK_FALSE, then Execution Mode must be OutputPoints", "1.3-extensions"},
    {"VUID-RuntimeSpirv-uniformAndStorageBuffer16BitAccess-06332", "If uniformAndStorageBuffer16BitAccess is VK_FALSE, then objects in the Uniform Storage Class with the Block decoration must not have 16-bit integer or 16-bit floating-point members", "1.3-extensions"},
    {"VUID-RuntimeSpirv-uniformAndStorageBuffer8BitAccess-06329", "If uniformAndStorageBuffer8BitAccess is VK_FALSE, then objects in the Uniform Storage Class with the Block decoration must not have an 8-bit integer member", "1.3-extensions"},
    {"VUID-RuntimeSpirv-vulkanMemoryModel-06265", "If vulkanMemoryModel is enabled and vulkanMemoryModelDeviceScope is not enabled, Device memory scope must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-vulkanMemoryModel-06266", "If vulkanMemoryModel is not enabled, QueueFamily memory scope must not be used", "1.3-extensions"},
    {"VUID-RuntimeSpirv-x-06429", "In compute shaders using the GLCompute Execution Model the x size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupSize[0]", "1.3-extensions"},
    {"VUID-RuntimeSpirv-x-06432", "In compute shaders using the GLCompute Execution Model the product of x size, y size, and z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupInvocations", "1.3-extensions"},
    {"VUID-RuntimeSpirv-y-06430", "In compute shaders using the GLCompute Execution Model the y size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupSize[1]", "1.3-extensions"},
    {"VUID-RuntimeSpirv-z-06431", "In compute shaders using the GLCompute Execution Model the z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupSize[2]", "1.3-extensions"},
    {"VUID-SMCountNV-SMCountNV-04363", "The variable decorated with SMCountNV must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-SMCountNV-SMCountNV-04364", "The variable decorated with SMCountNV must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-SMIDNV-SMIDNV-04365", "The variable decorated with SMIDNV must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-SMIDNV-SMIDNV-04366", "The variable decorated with SMIDNV must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-SampleId-SampleId-04354", "The SampleId decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-SampleId-SampleId-04355", "The variable decorated with SampleId must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-SampleId-SampleId-04356", "The variable decorated with SampleId must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-SampleMask-SampleMask-04357", "The SampleMask decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-SampleMask-SampleMask-04358", "The variable decorated with SampleMask must be declared using the Input or Output Storage Class", "1.3-extensions"},
    {"VUID-SampleMask-SampleMask-04359", "The variable decorated with SampleMask must be declared as an array of 32-bit integer values", "1.3-extensions"},
    {"VUID-SamplePosition-SamplePosition-04360", "The SamplePosition decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-SamplePosition-SamplePosition-04361", "The variable decorated with SamplePosition must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-SamplePosition-SamplePosition-04362", "The variable decorated with SamplePosition must be declared as a two-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-ShaderIndexAMDX-ShaderIndexAMDX-09175", "The variable decorated with ShaderIndexAMDX must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-ShaderIndexAMDX-ShaderIndexAMDX-09176", "The variable decorated with ShaderIndexAMDX must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-ShadingRateKHR-ShadingRateKHR-04490", "The ShadingRateKHR decoration must be used only within the Fragment Execution Model", "1.3-extensions"},
    {"VUID-ShadingRateKHR-ShadingRateKHR-04491", "The variable decorated with ShadingRateKHR must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-ShadingRateKHR-ShadingRateKHR-04492", "The variable decorated with ShadingRateKHR must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Base-04781", "The Base operand of any OpBitCount, OpBitReverse, OpBitFieldInsert, OpBitFieldSExtract, or OpBitFieldUExtract instruction must be a 32-bit integer scalar or a vector of 32-bit integers", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Base-07650", "The Base operand of OpPtrAccessChain must have a storage class of Workgroup, StorageBuffer, or PhysicalStorageBuffer", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Base-07651", "If the Base operand of OpPtrAccessChain has a Workgroup Storage Class, then the VariablePointers capability must be declared", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Base-07652", "If the Base operand of OpPtrAccessChain has a StorageBuffer Storage Class, then the VariablePointers or VariablePointersStorageBuffer capability must be declared", "1.3-extensions"},
    {"VUID-StandaloneSpirv-BuiltIn-04668", "Any BuiltIn decoration not listed in Built-In Variables must not be used", "1.3-extensions"},
    {"VUID-StandaloneSpirv-CallableDataKHR-04704", "CallableDataKHR Storage Class must only be used in ray generation, closest hit, miss, and callable shaders", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Component-04920", "The Component decoration value must not be greater than 3", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Component-04921", "If the Component decoration is used on an OpVariable that has a OpTypeVector type with a Component Type with a Width that is less than or equal to 32, the sum of its Component Count and the Component decoration value must be less than or equal to 4", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Component-04922", "If the Component decoration is used on an OpVariable that has a OpTypeVector type with a Component Type with a Width that is equal to 64, the sum of two times its Component Count and the Component decoration value must be less than or equal to 4", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Component-04923", "The Component decorations value must not be 1 or 3 for scalar or two-component 64-bit data types", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Component-04924", "The Component decorations must not be used with any type that is not a scalar or vector, or an array of such a type", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Component-07703", "The Component decorations must not be used for a 64-bit vector type with more than two components", "1.3-extensions"},
    {"VUID-StandaloneSpirv-DerivativeGroupLinearNV-04778", "For compute shaders using the DerivativeGroupLinearNV execution mode, the product of the dimensions of the local workgroup size must be a multiple of four", "1.3-extensions"},
    {"VUID-StandaloneSpirv-DerivativeGroupQuadsNV-04684", "For compute shaders using the DerivativeGroupQuadsNV execution mode, the first two dimensions of the local workgroup size must be a multiple of two", "1.3-extensions"},
    {"VUID-StandaloneSpirv-DescriptorSet-06491", "If a variable is decorated by DescriptorSet or Binding, the Storage Class must correspond to an entry in Shader Resource and Storage Class Correspondence", "1.3-extensions"},
    {"VUID-StandaloneSpirv-ExecutionModel-07320", "If the Execution Model is TessellationControl, and the MemoryModel is GLSL450, the Scope for memory must not be Workgroup", "1.3-extensions"},
    {"VUID-StandaloneSpirv-FPRoundingMode-04675", "Rounding modes other than round-to-nearest-even and round-towards-zero must not be used for the FPRoundingMode decoration", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Flat-04670", "The Flat, NoPerspective, Sample, and Centroid decorations must only be used on variables with the Output or Input Storage Class", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Flat-04744", "Any variable with integer or double-precision floating-point type and with Input Storage Class in a fragment shader, must be decorated Flat", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Flat-06201", "The Flat, NoPerspective, Sample, and Centroid decorations must not be used on variables with the Output storage class in a fragment shader", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Flat-06202", "The Flat, NoPerspective, Sample, and Centroid decorations must not be used on variables with the Input storage class in a vertex shader", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Function-04681", "A type T that is an array sized with a specialization constant must neither be, nor be contained in, the type T2 of a variable V, unless either: a) T is equal to T2, b) V is declared in the Function, or Private Storage Class, c) V is a non-Block variable in the Workgroup Storage Class, or d) V is an interface variable with an additional level of arrayness, as described in interface matching, and T is the member type of the array type T2", "1.3-extensions"},
    {"VUID-StandaloneSpirv-GLSLShared-04669", "The GLSLShared and GLSLPacked decorations must not be used", "1.3-extensions"},
    {"VUID-StandaloneSpirv-HitAttributeKHR-04701", "HitAttributeKHR Storage Class must only be used in intersection, any-hit, or closest hit shaders", "1.3-extensions"},
    {"VUID-StandaloneSpirv-HitAttributeKHR-04702", "There must be at most one variable with the HitAttributeKHR Storage Class in the input interface of an entry point", "1.3-extensions"},
    {"VUID-StandaloneSpirv-HitAttributeKHR-04703", "A variable with HitAttributeKHR Storage Class must only be written to in an intersection shader", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Image-04965", "The SPIR-V Type of the Image Format operand of an OpTypeImage must match the Sampled Type, as defined in Image Format and Type Matching", "1.3-extensions"},
    {"VUID-StandaloneSpirv-IncomingCallableDataKHR-04705", "IncomingCallableDataKHR Storage Class must only be used in callable shaders", "1.3-extensions"},
    {"VUID-StandaloneSpirv-IncomingCallableDataKHR-04706", "There must be at most one variable with the IncomingCallableDataKHR Storage Class in the input interface of an entry point", "1.3-extensions"},
    {"VUID-StandaloneSpirv-IncomingRayPayloadKHR-04699", "IncomingRayPayloadKHR Storage Class must only be used in closest hit, any-hit, or miss shaders", "1.3-extensions"},
    {"VUID-StandaloneSpirv-IncomingRayPayloadKHR-04700", "There must be at most one variable with the IncomingRayPayloadKHR Storage Class in the input interface of an entry point", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Input-06778", "Variables with a Storage Class of Input in a fragment shader stage that are decorated with PerVertexKHR must be declared as arrays", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Input-07290", "Variables with a Storage Class of Input or Output and a type of OpTypeBool must be decorated with the BuiltIn decoration", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Input-09557", "The pointers of any Input or Output Interface user-defined variables must not contain any PhysicalStorageBuffer Storage Class pointers", "1.3-extensions"},
    {"VUID-StandaloneSpirv-InputAttachmentIndex-06678", "Variables decorated with InputAttachmentIndex must be in the UniformConstant Storage Class", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Invariant-04677", "Variables decorated with Invariant and variables with structure types that have any members decorated with Invariant must be in the Output or Input Storage Class, Invariant used on an Input Storage Class variable or structure member has no effect", "1.3-extensions"},
    {"VUID-StandaloneSpirv-LocalSize-06426", "For each compute shader entry point, either a LocalSize or LocalSizeId Execution Mode, or an object decorated with the WorkgroupSize decoration must be specified", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Location-04915", "The Location or Component decorations must not be used with BuiltIn", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Location-04916", "The Location decorations must be used on user-defined variables", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Location-04917", "If a user-defined variable is not a pointer to a Block decorated OpTypeStruct, then the OpVariable must have a Location decoration", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Location-04918", "If a user-defined variable has a Location decoration, and the variable is a pointer to a OpTypeStruct, then the members of that structure must not have Location decorations", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Location-04919", "If a user-defined variable does not have a Location decoration, and the variable is a pointer to a Block decorated OpTypeStruct, then each member of the struct must have a Location decoration", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Location-06672", "The Location or Component decorations must only be used with the Input, Output, RayPayloadKHR, IncomingRayPayloadKHR, HitAttributeKHR, HitObjectAttributeNV, CallableDataKHR, IncomingCallableDataKHR, or ShaderRecordBufferKHR storage classes", "1.3-extensions"},
    {"VUID-StandaloneSpirv-MeshEXT-07102", "The module must not contain both an entry point that uses the TaskEXT or MeshEXT Execution Model and an entry point that uses the TaskNV or MeshNV Execution Model", "1.3-extensions"},
    {"VUID-StandaloneSpirv-MeshEXT-07106", "In mesh shaders using the MeshEXT Execution Model OpSetMeshOutputsEXT must be called before any outputs are written", "1.3-extensions"},
    {"VUID-StandaloneSpirv-MeshEXT-07107", "In mesh shaders using the MeshEXT Execution Model all variables declared as output must not be read from", "1.3-extensions"},
    {"VUID-StandaloneSpirv-MeshEXT-07108", "In mesh shaders using the MeshEXT Execution Model for OpSetMeshOutputsEXT instructions, the \"Vertex Count\" and \"Primitive Count\" operands must not depend on ViewIndex", "1.3-extensions"},
    {"VUID-StandaloneSpirv-MeshEXT-07109", "In mesh shaders using the MeshEXT Execution Model variables decorated with PrimitivePointIndicesEXT, PrimitiveLineIndicesEXT, or PrimitiveTriangleIndicesEXT declared as an array must not be accessed by indices that depend on ViewIndex", "1.3-extensions"},
    {"VUID-StandaloneSpirv-MeshEXT-07110", "In mesh shaders using the MeshEXT Execution Model any values stored in variables decorated with PrimitivePointIndicesEXT, PrimitiveLineIndicesEXT, or PrimitiveTriangleIndicesEXT must not depend on ViewIndex", "1.3-extensions"},
    {"VUID-StandaloneSpirv-MeshEXT-07111", "In mesh shaders using the MeshEXT Execution Model variables in workgroup or private Storage Class declared as or containing a composite type must not be accessed by indices that depend on ViewIndex", "1.3-extensions"},
    {"VUID-StandaloneSpirv-MeshEXT-07330", "In mesh shaders using the MeshEXT Execution Model the OutputVertices Execution Mode must be greater than 0", "1.3-extensions"},
    {"VUID-StandaloneSpirv-MeshEXT-07331", "In mesh shaders using the MeshEXT Execution Model the OutputPrimitivesEXT Execution Mode must be greater than 0", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04633", "Every entry point must have no return value and accept no arguments", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04634", "The static function-call graph for an entry point must not contain cycles; that is, static recursion is not allowed", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04635", "The Logical or PhysicalStorageBuffer64 addressing model must be selected", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04636", "Scope for execution must be limited to Workgroup or Subgroup", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04637", "If the Scope for execution is Workgroup, then it must only be used in the task, mesh, tessellation control, or compute Execution Model", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04638", "Scope for memory must be limited to Device, QueueFamily, Workgroup, ShaderCallKHR, Subgroup, or Invocation", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04640", "If the Scope for memory is ShaderCallKHR, then it must only be used in ray generation, intersection, closest hit, any-hit, miss, and callable Execution Model", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04641", "If the Scope for memory is Invocation, then memory semantics must be None", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04642", "Scope for group operations must be limited to Subgroup", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04643", "Storage Class must be limited to UniformConstant, Input, Uniform, Output, Workgroup, Private, Function, PushConstant, Image, StorageBuffer, RayPayloadKHR, IncomingRayPayloadKHR, HitAttributeKHR, CallableDataKHR, IncomingCallableDataKHR, ShaderRecordBufferKHR, PhysicalStorageBuffer, or TileImageEXT", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04644", "If the Storage Class is Output, then it must not be used in the GlCompute, RayGenerationKHR, IntersectionKHR, AnyHitKHR, ClosestHitKHR, MissKHR, or CallableKHR Execution Model", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04645", "If the Storage Class is Workgroup, then it must only be used in the task, mesh, or compute Execution Model", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04667", "Structure types must not contain opaque types", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04686", "The Pointer operand of all atomic instructions must have a Storage Class limited to Uniform, Workgroup, Image, StorageBuffer, PhysicalStorageBuffer, or TaskPayloadWorkgroupEXT", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-04745", "All block members in a variable with a Storage Class of PushConstant declared as an array must only be accessed by dynamically uniform indices", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-07321", "If the Scope for memory is Workgroup, then it must only be used in the task, mesh, tessellation control, or compute Execution Model", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-08720", "If the Storage Class is TileImageEXT, then it must only be used in the fragment execution model", "1.3-extensions"},
    {"VUID-StandaloneSpirv-None-08724", "The TileImageEXT Storage Class must only be used for declaring tile image variables", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Offset-04663", "Image operand Offset must only be used with OpImage*Gather instructions", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Offset-04687", "Output variables or block members decorated with Offset that have a 64-bit type, or a composite type containing a 64-bit type, must specify an Offset value aligned to a 8 byte boundary", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Offset-04689", "The size of any output block containing any member decorated with Offset that is a 64-bit type must be a multiple of 8", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Offset-04690", "The first member of an output block specifying a Offset decoration must specify a Offset value that is aligned to an 8 byte boundary if that block contains any member decorated with Offset and is a 64-bit type", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Offset-04691", "Output variables or block members decorated with Offset that have a 32-bit type, or a composite type contains a 32-bit type, must specify an Offset value aligned to a 4 byte boundary", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Offset-04692", "Output variables, blocks or block members decorated with Offset must only contain base types that have components that are either 32-bit or 64-bit in size", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Offset-04716", "Only variables or block members in the output interface decorated with Offset can be captured for transform feedback, and those variables or block members must also be decorated with XfbBuffer and XfbStride, or inherit XfbBuffer and XfbStride decorations from a block containing them", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Offset-04865", "Any image instruction which uses an Offset, ConstOffset, or ConstOffsets image operand, must only consume a \"Sampled Image\" operand whose type has its \"Sampled\" operand set to 1", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpAtomicLoad-04731", "OpAtomicLoad must not use Release, AcquireRelease, or SequentiallyConsistent memory semantics", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpAtomicStore-04730", "OpAtomicStore must not use Acquire, AcquireRelease, or SequentiallyConsistent memory semantics", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpControlBarrier-04650", "If the semantics for OpControlBarrier includes one of Acquire, Release, AcquireRelease, or SequentiallyConsistent memory semantics, then it must include at least one Storage Class", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpControlBarrier-04682", "If OpControlBarrier is used in ray generation, intersection, any-hit, closest hit, miss, fragment, vertex, tessellation evaluation, or geometry shaders, the execution Scope must be Subgroup", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpEntryPoint-06674", "Each OpEntryPoint must not statically use more than one OpVariable in the PushConstant Storage Class", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpEntryPoint-08721", "Each OpEntryPoint must not have more than one Input variable assigned the same Component word inside a Location slot, either explicitly or implicitly", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpEntryPoint-08722", "Each OpEntryPoint must not have more than one Output variable assigned the same Component word inside a Location slot, either explicitly or implicitly", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpEntryPoint-09658", "For a given OpEntryPoint, any BuiltIn decoration must not be used more than once by the Input interface.", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpEntryPoint-09659", "For a given OpEntryPoint, any BuiltIn decoration must not be used more than once by the Output interface.", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpGroupNonUniformBallotBitCount-04685", "If OpGroupNonUniformBallotBitCount is used, the group operation must be limited to Reduce, InclusiveScan, or ExclusiveScan", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpImage-04777", "OpImage*Dref* instructions must not consume an image whose Dim is 3D", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpImageGather-04664", "The \"Component\" operand of OpImageGather, and OpImageSparseGather must be the of a constant instruction", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpImageQuerySizeLod-04659", "OpImageQuerySizeLod, OpImageQueryLod, and OpImageQueryLevels must only consume an \"Image\" operand whose type has its \"Sampled\" operand set to 1", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpImageTexelPointer-04658", "If an OpImageTexelPointer is used in an atomic operation, the image type of the image parameter to OpImageTexelPointer must have an image format of R64i, R64ui, R32f, R32i, or R32ui", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpMemoryBarrier-04732", "OpMemoryBarrier must use one of Acquire, Release, AcquireRelease, or SequentiallyConsistent memory semantics", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpMemoryBarrier-04733", "OpMemoryBarrier must include at least one Storage Class", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpReadClockKHR-04652", "Scope for OpReadClockKHR must be limited to Subgroup or Device", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpTypeForwardPointer-04711", "OpTypeForwardPointer must have a Storage Class of PhysicalStorageBuffer", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpTypeImage-04656", "OpTypeImage must declare a scalar 32-bit float, 64-bit integer, or 32-bit integer type for the \"Sampled Type\" (RelaxedPrecision can be applied to a sampling instruction and to the variable holding the result of a sampling instruction)", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpTypeImage-04657", "OpTypeImage must have a \"Sampled\" operand of 1 (sampled image) or 2 (storage image)", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpTypeImage-06214", "An OpTypeImage with a \"Dim\" operand of SubpassData must have an \"Arrayed\" operand of 0 (non-arrayed) and a \"Sampled\" operand of 2 (storage image)", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpTypeImage-06924", "Objects of types OpTypeImage, OpTypeSampler, OpTypeSampledImage, OpTypeAccelerationStructureKHR, and arrays of these types must not be stored to or modified", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpTypeImage-09638", "An OpTypeImage must not have a \"Dim\" operand of Rect", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpTypeRuntimeArray-04680", "OpTypeRuntimeArray must only be used for: the last member of a Block-decorated OpTypeStruct in StorageBuffer or PhysicalStorageBuffer storage Storage Class BufferBlock-decorated OpTypeStruct in the Uniform storage Storage Class the outermost dimension of an arrayed variable in the StorageBuffer, Uniform, or UniformConstant storage Storage Class variables in the NodePayloadAMDX storage Storage Class when the CoalescingAMDX Execution Mode is specified", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpTypeSampledImage-06671", "OpTypeSampledImage must have a OpTypeImage with a \"Sampled\" operand of 1 (sampled image)", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpVariable-04651", "Any OpVariable with an Initializer operand must have Output, Private, Function, or Workgroup as its Storage Class operand", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpVariable-04734", "Any OpVariable with an Initializer operand and Workgroup as its Storage Class operand must use OpConstantNull as the initializer", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OpVariable-06673", "There must not be more than one OpVariable in the PushConstant Storage Class listed in the Interface for each OpEntryPoint", "1.3-extensions"},
    {"VUID-StandaloneSpirv-OriginLowerLeft-04653", "The OriginLowerLeft Execution Mode must not be used; fragment entry points must declare OriginUpperLeft", "1.3-extensions"},
    {"VUID-StandaloneSpirv-PerVertexKHR-06777", "The PerVertexKHR decoration must only be used on variables with the Input Storage Class in a fragment shader", "1.3-extensions"},
    {"VUID-StandaloneSpirv-PhysicalStorageBuffer64-04708", "If the PhysicalStorageBuffer64 addressing model is enabled, all instructions that support memory access operands and that use a physical pointer must include the Aligned operand", "1.3-extensions"},
    {"VUID-StandaloneSpirv-PhysicalStorageBuffer64-04709", "If the PhysicalStorageBuffer64 addressing model is enabled, any access chain instruction that accesses into a RowMajor matrix must only be used as the Pointer operand to OpLoad or OpStore", "1.3-extensions"},
    {"VUID-StandaloneSpirv-PhysicalStorageBuffer64-04710", "If the PhysicalStorageBuffer64 addressing model is enabled, OpConvertUToPtr and OpConvertPtrToU must use an integer type whose Width is 64", "1.3-extensions"},
    {"VUID-StandaloneSpirv-PixelCenterInteger-04654", "The PixelCenterInteger Execution Mode must not be used (pixels are always centered at half-integer coordinates)", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Pointer-08973", "The Storage Class of the Pointer operand to OpCooperativeMatrixLoadKHR or OpCooperativeMatrixStoreKHR must be limited to Workgroup, StorageBuffer, or PhysicalStorageBuffer", "1.3-extensions"},
    {"VUID-StandaloneSpirv-PushConstant-06675", "Any variable in the PushConstant or StorageBuffer storage class must be decorated as Block", "1.3-extensions"},
    {"VUID-StandaloneSpirv-PushConstant-06808", "Any variable in the PushConstant Storage Class must be typed as OpTypeStruct", "1.3-extensions"},
    {"VUID-StandaloneSpirv-RayPayloadKHR-04698", "RayPayloadKHR Storage Class must only be used in ray generation, closest hit or miss shaders", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Result-04780", "The Result Type operand of any OpImageRead or OpImageSparseRead instruction must be a vector of four components", "1.3-extensions"},
    {"VUID-StandaloneSpirv-ShaderRecordBufferKHR-07119", "ShaderRecordBufferKHR Storage Class must only be used in ray generation, intersection, any-hit, closest hit, callable, or miss shaders", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Stream-04694", "If any variables or block members in the output interface of the entry point being compiled are decorated with Stream, then all variables belonging to the same XfbBuffer must specify the same Stream value", "1.3-extensions"},
    {"VUID-StandaloneSpirv-SubgroupVoteKHR-07951", "If none of the SubgroupVoteKHR, GroupNonUniform, or SubgroupBallotKHR capabilities are declared, Scope for memory must not be Subgroup", "1.3-extensions"},
    {"VUID-StandaloneSpirv-SubpassData-04660", "The (u,v) coordinates used for a SubpassData must be the of a constant vector (0,0).", "1.3-extensions"},
    {"VUID-StandaloneSpirv-TileImageEXT-08723", "The tile image variable declarations must obey the constraints on the TileImageEXT Storage Class and the Location decoration described in Fragment Tile Image Interface", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Uniform-06676", "Any variable in the Uniform Storage Class must be decorated as Block or BufferBlock", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Uniform-06807", "Any variable in the Uniform or StorageBuffer Storage Class must be typed as OpTypeStruct or an array of this type", "1.3-extensions"},
    {"VUID-StandaloneSpirv-Uniform-06925", "Any variable in the Uniform Storage Class decorated as Block must not be stored to or modified", "1.3-extensions"},
    {"VUID-StandaloneSpirv-UniformConstant-04655", "Any variable in the UniformConstant Storage Class must be typed as either OpTypeImage, OpTypeSampler, OpTypeSampledImage, OpTypeAccelerationStructureKHR, or an array of one of these types", "1.3-extensions"},
    {"VUID-StandaloneSpirv-UniformConstant-06677", "Any variable in the UniformConstant, StorageBuffer, or Uniform Storage Class must be decorated with DescriptorSet and Binding", "1.3-extensions"},
    {"VUID-StandaloneSpirv-ViewportMaskNV-04674", "The ViewportMaskNV and ViewportIndex decorations must not both be statically used by one or more OpEntryPoint's that form the pre-rasterization shader stages of a graphics pipeline", "1.3-extensions"},
    {"VUID-StandaloneSpirv-ViewportRelativeNV-04672", "The ViewportRelativeNV decoration must only be used on a variable decorated with Layer in the vertex, tessellation evaluation, or geometry shader stages", "1.3-extensions"},
    {"VUID-StandaloneSpirv-ViewportRelativeNV-04673", "The ViewportRelativeNV decoration must not be used unless a variable decorated with one of ViewportIndex or ViewportMaskNV is also statically used by the same OpEntryPoint", "1.3-extensions"},
    {"VUID-StandaloneSpirv-VulkanMemoryModel-04678", "If the VulkanMemoryModel capability is not declared, the Volatile decoration must be used on any variable declaration that includes one of the SMIDNV, WarpIDNV, SubgroupSize, SubgroupLocalInvocationId, SubgroupEqMask, SubgroupGeMask, SubgroupGtMask, SubgroupLeMask, or SubgroupLtMask BuiltIn decorations when used in the ray generation, closest hit, miss, intersection, or callable shaders, or with the RayTmaxKHR Builtin decoration when used in an intersection shader", "1.3-extensions"},
    {"VUID-StandaloneSpirv-VulkanMemoryModel-04679", "If the VulkanMemoryModel capability is declared, the OpLoad instruction must use the Volatile memory semantics when it accesses into any variable that includes one of the SMIDNV, WarpIDNV, SubgroupSize, SubgroupLocalInvocationId, SubgroupEqMask, SubgroupGeMask, SubgroupGtMask, SubgroupLeMask, or SubgroupLtMask BuiltIn decorations when used in the ray generation, closest hit, miss, intersection, or callable shaders, or with the RayTmaxKHR Builtin decoration when used in an intersection shader", "1.3-extensions"},
    {"VUID-StandaloneSpirv-XfbBuffer-04693", "All variables or block members in the output interface of the entry point being compiled decorated with a specific XfbBuffer value must all be decorated with identical XfbStride values", "1.3-extensions"},
    {"VUID-StandaloneSpirv-XfbBuffer-04696", "For any two variables or block members in the output interface of the entry point being compiled with the same XfbBuffer value, the ranges determined by the Offset decoration and the size of the type must not overlap", "1.3-extensions"},
    {"VUID-StandaloneSpirv-XfbBuffer-04697", "All block members in the output interface of the entry point being compiled that are in the same block and have a declared or inherited XfbBuffer decoration must specify the same XfbBuffer value", "1.3-extensions"},
    {"VUID-SubgroupEqMask-SubgroupEqMask-04370", "The variable decorated with SubgroupEqMask must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-SubgroupEqMask-SubgroupEqMask-04371", "The variable decorated with SubgroupEqMask must be declared as a four-component vector of 32-bit integer values", "1.3-extensions"},
    {"VUID-SubgroupGeMask-SubgroupGeMask-04372", "The variable decorated with SubgroupGeMask must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-SubgroupGeMask-SubgroupGeMask-04373", "The variable decorated with SubgroupGeMask must be declared as a four-component vector of 32-bit integer values", "1.3-extensions"},
    {"VUID-SubgroupGtMask-SubgroupGtMask-04374", "The variable decorated with SubgroupGtMask must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-SubgroupGtMask-SubgroupGtMask-04375", "The variable decorated with SubgroupGtMask must be declared as a four-component vector of 32-bit integer values", "1.3-extensions"},
    {"VUID-SubgroupId-SubgroupId-04367", "The SubgroupId decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", "1.3-extensions"},
    {"VUID-SubgroupId-SubgroupId-04368", "The variable decorated with SubgroupId must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-SubgroupId-SubgroupId-04369", "The variable decorated with SubgroupId must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-SubgroupLeMask-SubgroupLeMask-04376", "The variable decorated with SubgroupLeMask must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-SubgroupLeMask-SubgroupLeMask-04377", "The variable decorated with SubgroupLeMask must be declared as a four-component vector of 32-bit integer values", "1.3-extensions"},
    {"VUID-SubgroupLocalInvocationId-SubgroupLocalInvocationId-04380", "The variable decorated with SubgroupLocalInvocationId must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-SubgroupLocalInvocationId-SubgroupLocalInvocationId-04381", "The variable decorated with SubgroupLocalInvocationId must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-SubgroupLtMask-SubgroupLtMask-04378", "The variable decorated with SubgroupLtMask must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-SubgroupLtMask-SubgroupLtMask-04379", "The variable decorated with SubgroupLtMask must be declared as a four-component vector of 32-bit integer values", "1.3-extensions"},
    {"VUID-SubgroupSize-SubgroupSize-04382", "The variable decorated with SubgroupSize must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-SubgroupSize-SubgroupSize-04383", "The variable decorated with SubgroupSize must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-TaskCountNV-TaskCountNV-04384", "The TaskCountNV decoration must be used only within the TaskNV Execution Model", "1.3-extensions"},
    {"VUID-TaskCountNV-TaskCountNV-04385", "The variable decorated with TaskCountNV must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-TaskCountNV-TaskCountNV-04386", "The variable decorated with TaskCountNV must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-TessCoord-TessCoord-04387", "The TessCoord decoration must be used only within the TessellationEvaluation Execution Model", "1.3-extensions"},
    {"VUID-TessCoord-TessCoord-04388", "The variable decorated with TessCoord must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-TessCoord-TessCoord-04389", "The variable decorated with TessCoord must be declared as a three-component vector of 32-bit floating-point values", "1.3-extensions"},
    {"VUID-TessLevelInner-TessLevelInner-04394", "The TessLevelInner decoration must be used only within the TessellationControl or TessellationEvaluation Execution Model", "1.3-extensions"},
    {"VUID-TessLevelInner-TessLevelInner-04395", "The variable decorated with TessLevelInner within the TessellationControl Execution Model must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-TessLevelInner-TessLevelInner-04396", "The variable decorated with TessLevelInner within the TessellationEvaluation Execution Model must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-TessLevelInner-TessLevelInner-04397", "The variable decorated with TessLevelInner must be declared as an array of size two, containing 32-bit floating-point values", "1.3-extensions"},
    {"VUID-TessLevelOuter-TessLevelOuter-04390", "The TessLevelOuter decoration must be used only within the TessellationControl or TessellationEvaluation Execution Model", "1.3-extensions"},
    {"VUID-TessLevelOuter-TessLevelOuter-04391", "The variable decorated with TessLevelOuter within the TessellationControl Execution Model must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-TessLevelOuter-TessLevelOuter-04392", "The variable decorated with TessLevelOuter within the TessellationEvaluation Execution Model must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-TessLevelOuter-TessLevelOuter-04393", "The variable decorated with TessLevelOuter must be declared as an array of size four, containing 32-bit floating-point values", "1.3-extensions"},
    {"VUID-VertexCountHUAWEI-VertexCountHUAWEI-07809", "The VertexCountHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "1.3-extensions"},
    {"VUID-VertexCountHUAWEI-VertexCountHUAWEI-07810", "The variable decorated with VertexCountHUAWEI must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-VertexIndex-VertexIndex-04398", "The VertexIndex decoration must be used only within the Vertex Execution Model", "1.3-extensions"},
    {"VUID-VertexIndex-VertexIndex-04399", "The variable decorated with VertexIndex must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-VertexIndex-VertexIndex-04400", "The variable decorated with VertexIndex must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-VertexOffsetHUAWEI-VertexOffsetHUAWEI-07811", "The VertexOffsetHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "1.3-extensions"},
    {"VUID-VertexOffsetHUAWEI-VertexOffsetHUAWEI-07812", "The variable decorated with VertexOffsetHUAWEI must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-ViewIndex-ViewIndex-04401", "The ViewIndex decoration must be used only within the MeshEXT, Vertex, Geometry, TessellationControl, TessellationEvaluation or Fragment Execution Model", "1.3-extensions"},
    {"VUID-ViewIndex-ViewIndex-04402", "The variable decorated with ViewIndex must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-ViewIndex-ViewIndex-04403", "The variable decorated with ViewIndex must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-ViewportIndex-ViewportIndex-04404", "The ViewportIndex decoration must be used only within the MeshEXT, MeshNV, Vertex, TessellationEvaluation, Geometry, or Fragment Execution Model", "1.3-extensions"},
    {"VUID-ViewportIndex-ViewportIndex-04405", "If the shaderOutputViewportIndex feature is not enabled then the ViewportIndex decoration must be used only within the Geometry or Fragment Execution Model", "1.3-extensions"},
    {"VUID-ViewportIndex-ViewportIndex-04406", "The variable decorated with ViewportIndex within the MeshEXT, MeshNV, Vertex, TessellationEvaluation, or Geometry Execution Model must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-ViewportIndex-ViewportIndex-04407", "The variable decorated with ViewportIndex within the Fragment Execution Model must be declared using the Input Storage Class", "1.3-extensions"},
    {"VUID-ViewportIndex-ViewportIndex-04408", "The variable decorated with ViewportIndex must be declared as a scalar 32-bit integer value", "1.3-extensions"},
    {"VUID-ViewportIndex-ViewportIndex-07060", "The variable decorated with ViewportIndex within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", "1.3-extensions"},
    {"VUID-ViewportMaskNV-ViewportMaskNV-04409", "The ViewportMaskNV decoration must be used only within the Vertex, MeshNV, TessellationEvaluation, or Geometry Execution Model", "1.3-extensions"},
    {"VUID-ViewportMaskNV-ViewportMaskNV-04410", "The variable decorated with ViewportMaskNV must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-ViewportMaskNV-ViewportMaskNV-04411", "The variable decorated with ViewportMaskNV must be declared as an array of 32-bit integer values", "1.3-extensions"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04412", "The ViewportMaskPerViewNV decoration must be used only within the Vertex, MeshNV, TessellationControl, TessellationEvaluation, or Geometry Execution Model", "1.3-extensions"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04413", "The variable decorated with ViewportMaskPerViewNV must be declared using the Output Storage Class", "1.3-extensions"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04414", "The variable decorated with ViewportMaskPerViewNV must be declared as an array of 32-bit integer values", "1.3-extensions"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04415", "The array decorated with ViewportMaskPerViewNV must be a size less than or equal to 32", "1.3-extensions"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04416", "The array decorated with ViewportMaskPerViewNV must be a size greater than the maximum view in the subpass's view mask", "1.3-extensions"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04417", "The array variable decorated with ViewportMaskPerViewNV must only be indexed by a constant or specialization constant", "1.3-extensions"},
    {"VUID-VkAabbPositionsKHR-minX-03546", "minX must be less than or equal to maxX", "1.3-extensions"},
    {"VUID-VkAabbPositionsKHR-minY-03547", "minY must be less than or equal to maxY", "1.3-extensions"},
    {"VUID-VkAabbPositionsKHR-minZ-03548", "minZ must be less than or equal to maxZ", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-commonparent", "Both of dstAccelerationStructure, and srcAccelerationStructure that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-dstAccelerationStructure-04927", "If dstAccelerationStructure was created with VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV set in VkAccelerationStructureCreateInfoKHR::flags, VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV must be set in flags", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-03796", "If flags has the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR bit set, then it must not have the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR bit set", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-04928", "If VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV is set in flags, dstAccelerationStructure must have been created with VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV set in VkAccelerationStructureCreateInfoKHR::flags", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-04929", "If VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV is set in flags, type must not be VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-07334", "If flags has the VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_UPDATE_EXT bit set then it must not have the VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_DATA_UPDATE_EXT bit set", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-parameter", "flags must be a valid combination of VkBuildAccelerationStructureFlagBitsKHR values", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-pGeometries-03788", "If geometryCount is not 0, exactly one of pGeometries or ppGeometries must be a valid pointer, the other must be NULL", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-pGeometries-parameter", "If geometryCount is not 0, and pGeometries is not NULL, pGeometries must be a valid pointer to an array of geometryCount valid VkAccelerationStructureGeometryKHR structures", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-ppGeometries-parameter", "If geometryCount is not 0, and ppGeometries is not NULL, ppGeometries must be a valid pointer to an array of geometryCount valid pointers to valid VkAccelerationStructureGeometryKHR structures", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03654", "type must not be VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03789", "If type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, the geometryType member of elements of either pGeometries or ppGeometries must be VK_GEOMETRY_TYPE_INSTANCES_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03790", "If type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, geometryCount must be 1", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03791", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR the geometryType member of elements of either pGeometries or ppGeometries must not be VK_GEOMETRY_TYPE_INSTANCES_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03792", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR then the geometryType member of each geometry in either pGeometries or ppGeometries must be the same", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03793", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR then geometryCount must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxGeometryCount", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03794", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR and the geometryType member of either pGeometries or ppGeometries is VK_GEOMETRY_TYPE_AABBS_KHR, the total number of AABBs in all geometries must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxPrimitiveCount", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03795", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR and the geometryType member of either pGeometries or ppGeometries is VK_GEOMETRY_TYPE_TRIANGLES_KHR, the total number of triangles in all geometries must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxPrimitiveCount", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-parameter", "type must be a valid VkAccelerationStructureTypeKHR value", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03656", "For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, if the geometry uses indices, the offset primitiveOffset from VkAccelerationStructureGeometryTrianglesDataKHR::indexData must be a multiple of the element size of VkAccelerationStructureGeometryTrianglesDataKHR::indexType", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03657", "For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, if the geometry does not use indices, the offset primitiveOffset from VkAccelerationStructureGeometryTrianglesDataKHR::vertexData must be a multiple of the component size of VkAccelerationStructureGeometryTrianglesDataKHR::vertexFormat", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03659", "For geometries of type VK_GEOMETRY_TYPE_AABBS_KHR, the offset primitiveOffset from VkAccelerationStructureGeometryAabbsDataKHR::data must be a multiple of 8", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03660", "For geometries of type VK_GEOMETRY_TYPE_INSTANCES_KHR, the offset primitiveOffset from VkAccelerationStructureGeometryInstancesDataKHR::data must be a multiple of 16", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-transformOffset-03658", "For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, the offset transformOffset from VkAccelerationStructureGeometryTrianglesDataKHR::transformData must be a multiple of 16", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildSizesInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkAccelerationStructureBuildSizesInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructure-08091", "If accelerationStructure is not VK_NULL_HANDLE then accelerationStructure must have been created with VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT set in VkAccelerationStructureCreateInfoKHR::createFlags", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructure-08093", "If accelerationStructure is not VK_NULL_HANDLE then accelerationStructureNV must be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructure-parameter", "If accelerationStructure is not VK_NULL_HANDLE, accelerationStructure must be a valid VkAccelerationStructureKHR handle", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructureNV-08092", "If accelerationStructureNV is not VK_NULL_HANDLE then accelerationStructureNV must have been created with VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT set in VkAccelerationStructureCreateInfoNV::info.flags", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructureNV-08094", "If accelerationStructureNV is not VK_NULL_HANDLE then accelerationStructure must be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructureNV-parameter", "If accelerationStructureNV is not VK_NULL_HANDLE, accelerationStructureNV must be a valid VkAccelerationStructureNV handle", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-commonparent", "Both of accelerationStructure, and accelerationStructureNV that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-buffer-03614", "buffer must have been created with a usage value containing VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-buffer-03615", "buffer must not have been created with VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-03613", "If createFlags includes VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR, VkPhysicalDeviceAccelerationStructureFeaturesKHR::accelerationStructureCaptureReplay must be VK_TRUE", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-04954", "If VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV is set in createFlags and type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, one member of the pNext chain must be a pointer to a valid instance of VkAccelerationStructureMotionInfoNV", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-04955", "If any geometry includes VkAccelerationStructureGeometryMotionTrianglesDataNV then createFlags must contain VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-08108", "If createFlags includes VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT, the descriptorBufferCaptureReplay feature must be enabled", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-parameter", "createFlags must be a valid combination of VkAccelerationStructureCreateFlagBitsKHR values", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-03612", "If deviceAddress is not zero, createFlags must include VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-09488", "If deviceAddress is not zero, it must have been retrieved from an identically created acceleration structure, except for buffer and deviceAddress", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-09489", "If deviceAddress is not zero, buffer must have been created identically to the buffer used to create the acceleration structure from which deviceAddress was retrieved, except for VkBufferOpaqueCaptureAddressCreateInfo::opaqueCaptureAddress", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-09490", "If deviceAddress is not zero, buffer must have been created with a VkBufferOpaqueCaptureAddressCreateInfo::opaqueCaptureAddress that was retrieved from vkGetBufferOpaqueCaptureAddress for the buffer that was used to create the acceleration structure from which deviceAddress was retrieved", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-offset-03616", "The sum of offset and size must be less than the size of buffer", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-offset-03734", "offset must be a multiple of 256 bytes", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-pNext-08109", "If the pNext chain includes a VkOpaqueCaptureDescriptorDataCreateInfoEXT structure, createFlags must contain VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAccelerationStructureMotionInfoNV or VkOpaqueCaptureDescriptorDataCreateInfoEXT", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-type-parameter", "type must be a valid VkAccelerationStructureTypeKHR value", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoNV-compactedSize-02421", "If compactedSize is not 0 then both info.geometryCount and info.instanceCount must be 0", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoNV-info-parameter", "info must be a valid VkAccelerationStructureInfoNV structure", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoNV-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkOpaqueCaptureDescriptorDataCreateInfoEXT", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV", "1.3-extensions"},
    {"VUID-VkAccelerationStructureCreateInfoNV-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkAccelerationStructureDeviceAddressInfoKHR-accelerationStructure-parameter", "accelerationStructure must be a valid VkAccelerationStructureKHR handle", "1.3-extensions"},
    {"VUID-VkAccelerationStructureDeviceAddressInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkAccelerationStructureDeviceAddressInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-stride-03545", "stride must be a multiple of 8", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-stride-03820", "stride must be less than or equal to 232-1", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryInstancesDataKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryInstancesDataKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryKHR-aabbs-parameter", "If geometryType is VK_GEOMETRY_TYPE_AABBS_KHR, the aabbs member of geometry must be a valid VkAccelerationStructureGeometryAabbsDataKHR structure", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryKHR-flags-parameter", "flags must be a valid combination of VkGeometryFlagBitsKHR values", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryKHR-geometryType-parameter", "geometryType must be a valid VkGeometryTypeKHR value", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryKHR-instances-parameter", "If geometryType is VK_GEOMETRY_TYPE_INSTANCES_KHR, the instances member of geometry must be a valid VkAccelerationStructureGeometryInstancesDataKHR structure", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryKHR-triangles-parameter", "If geometryType is VK_GEOMETRY_TYPE_TRIANGLES_KHR, the triangles member of geometry must be a valid VkAccelerationStructureGeometryTrianglesDataKHR structure", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryMotionTrianglesDataNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-indexType-03798", "indexType must be VK_INDEX_TYPE_UINT16, VK_INDEX_TYPE_UINT32, or VK_INDEX_TYPE_NONE_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-indexType-parameter", "indexType must be a valid VkIndexType value", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAccelerationStructureGeometryMotionTrianglesDataNV, VkAccelerationStructureTrianglesDisplacementMicromapNV, or VkAccelerationStructureTrianglesOpacityMicromapEXT", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexFormat-03797", "The format features of vertexFormat must contain VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexFormat-parameter", "vertexFormat must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexStride-03735", "vertexStride must be a multiple of the size in bytes of the smallest component of vertexFormat", "1.3-extensions"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexStride-03819", "vertexStride must be less than or equal to 232-1", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-flags-02592", "If flags has the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_NV bit set, then it must not have the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_NV bit set", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-flags-parameter", "flags must be a valid combination of VkBuildAccelerationStructureFlagBitsNV values", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-geometryCount-02422", "geometryCount must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxGeometryCount", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-instanceCount-02423", "instanceCount must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxInstanceCount", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-instanceData-02782", "If instanceData is not VK_NULL_HANDLE, instanceData must have been created with VK_BUFFER_USAGE_RAY_TRACING_BIT_NV usage flag", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-maxTriangleCount-02424", "The total number of triangles in all geometries must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxTriangleCount", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-pGeometries-parameter", "If geometryCount is not 0, pGeometries must be a valid pointer to an array of geometryCount valid VkGeometryNV structures", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-scratch-02781", "scratch must have been created with VK_BUFFER_USAGE_RAY_TRACING_BIT_NV usage flag", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-type-02425", "If type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_NV then geometryCount must be 0", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-type-02426", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV then instanceCount must be 0", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-type-02786", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV then the geometryType member of each geometry in pGeometries must be the same", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-type-04623", "type must not be VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInfoNV-type-parameter", "type must be a valid VkAccelerationStructureTypeNV value", "1.3-extensions"},
    {"VUID-VkAccelerationStructureInstanceKHR-flags-parameter", "flags must be a valid combination of VkGeometryInstanceFlagBitsKHR values", "1.3-extensions"},
    {"VUID-VkAccelerationStructureMatrixMotionInstanceNV-flags-parameter", "flags must be a valid combination of VkGeometryInstanceFlagBitsKHR values", "1.3-extensions"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-accelerationStructure-parameter", "accelerationStructure must be a valid VkAccelerationStructureNV handle", "1.3-extensions"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV", "1.3-extensions"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-type-parameter", "type must be a valid VkAccelerationStructureMemoryRequirementsTypeNV value", "1.3-extensions"},
    {"VUID-VkAccelerationStructureMotionInfoNV-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkAccelerationStructureMotionInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV", "1.3-extensions"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-matrixMotionInstance-parameter", "If type is VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MATRIX_MOTION_NV, the matrixMotionInstance member of data must be a valid VkAccelerationStructureMatrixMotionInstanceNV structure", "1.3-extensions"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-srtMotionInstance-parameter", "If type is VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_SRT_MOTION_NV, the srtMotionInstance member of data must be a valid VkAccelerationStructureSRTMotionInstanceNV structure", "1.3-extensions"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-staticInstance-parameter", "If type is VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_STATIC_NV, the staticInstance member of data must be a valid VkAccelerationStructureInstanceKHR structure", "1.3-extensions"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-type-parameter", "type must be a valid VkAccelerationStructureMotionInstanceTypeNV value", "1.3-extensions"},
    {"VUID-VkAccelerationStructureSRTMotionInstanceNV-flags-parameter", "flags must be a valid combination of VkGeometryInstanceFlagBitsKHR values", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-displacementBiasAndScaleFormat-09501", "displacementBiasAndScaleFormat must not be VK_FORMAT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-displacementBiasAndScaleFormat-parameter", "displacementBiasAndScaleFormat must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-displacementVectorFormat-09502", "displacementVectorFormat must not be VK_FORMAT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-displacementVectorFormat-parameter", "displacementVectorFormat must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-indexType-parameter", "indexType must be a valid VkIndexType value", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-micromap-parameter", "If micromap is not VK_NULL_HANDLE, micromap must be a valid VkMicromapEXT handle", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-pUsageCounts-07992", "Only one of pUsageCounts or ppUsageCounts can be a valid pointer, the other must be NULL", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-pUsageCounts-parameter", "If usageCountsCount is not 0, and pUsageCounts is not NULL, pUsageCounts must be a valid pointer to an array of usageCountsCount VkMicromapUsageEXT structures", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-ppUsageCounts-parameter", "If usageCountsCount is not 0, and ppUsageCounts is not NULL, ppUsageCounts must be a valid pointer to an array of usageCountsCount valid pointers to VkMicromapUsageEXT structures", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_DISPLACEMENT_MICROMAP_NV", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-indexType-parameter", "indexType must be a valid VkIndexType value", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-micromap-parameter", "If micromap is not VK_NULL_HANDLE, micromap must be a valid VkMicromapEXT handle", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-pUsageCounts-07335", "Only one of pUsageCounts or ppUsageCounts can be a valid pointer, the other must be NULL", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-pUsageCounts-parameter", "If usageCountsCount is not 0, and pUsageCounts is not NULL, pUsageCounts must be a valid pointer to an array of usageCountsCount VkMicromapUsageEXT structures", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-ppUsageCounts-parameter", "If usageCountsCount is not 0, and ppUsageCounts is not NULL, ppUsageCounts must be a valid pointer to an array of usageCountsCount valid pointers to VkMicromapUsageEXT structures", "1.3-extensions"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_OPACITY_MICROMAP_EXT", "1.3-extensions"},
    {"VUID-VkAccelerationStructureVersionInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkAccelerationStructureVersionInfoKHR-pVersionData-parameter", "pVersionData must be a valid pointer to an array of \\(2 \\times \\mathtt{VK\\_UUID\\_SIZE}\\) uint8_t values", "1.3-extensions"},
    {"VUID-VkAccelerationStructureVersionInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR", "1.3-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-commonparent", "Each of fence, semaphore, and swapchain that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-deviceMask-01290", "deviceMask must be a valid device mask", "1.3-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-deviceMask-01291", "deviceMask must not be zero", "1.3-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-fence-01289", "If fence is not VK_NULL_HANDLE it must be unsignaled and must not be associated with any other queue command that has not yet completed execution on that queue", "1.3-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-fence-parameter", "If fence is not VK_NULL_HANDLE, fence must be a valid VkFence handle", "1.3-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-01288", "If semaphore is not VK_NULL_HANDLE it must be unsignaled", "1.3-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-01781", "If semaphore is not VK_NULL_HANDLE it must not have any uncompleted signal or wait operations pending", "1.3-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-01782", "semaphore and fence must not both be equal to VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-03266", "semaphore must have a VkSemaphoreType of VK_SEMAPHORE_TYPE_BINARY", "1.3-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-parameter", "If semaphore is not VK_NULL_HANDLE, semaphore must be a valid VkSemaphore handle", "1.3-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-swapchain-01675", "swapchain must not be in the retired state", "1.3-extensions"},
    {"VUID-VkAcquireNextImageInfoKHR-swapchain-parameter", "swapchain must be a valid VkSwapchainKHR handle", "1.3-extensions"},
    {"VUID-VkAcquireProfilingLockInfoKHR-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkAcquireProfilingLockInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkAcquireProfilingLockInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR", "1.3-extensions"},
    {"VUID-VkAllocationCallbacks-pfnAllocation-00632", "pfnAllocation must be a valid pointer to a valid application-defined PFN_vkAllocationFunction", "1.3-extensions"},
    {"VUID-VkAllocationCallbacks-pfnFree-00634", "pfnFree must be a valid pointer to a valid application-defined PFN_vkFreeFunction", "1.3-extensions"},
    {"VUID-VkAllocationCallbacks-pfnInternalAllocation-00635", "If either of pfnInternalAllocation or pfnInternalFree is not NULL, both must be valid callbacks", "1.3-extensions"},
    {"VUID-VkAllocationCallbacks-pfnReallocation-00633", "pfnReallocation must be a valid pointer to a valid application-defined PFN_vkReallocationFunction", "1.3-extensions"},
    {"VUID-VkAmigoProfilingSubmitInfoSEC-sType-sType", "sType must be VK_STRUCTURE_TYPE_AMIGO_PROFILING_SUBMIT_INFO_SEC", "1.3-extensions"},
    {"VUID-VkAndroidHardwareBufferFormatProperties2ANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID", "1.3-extensions"},
    {"VUID-VkAndroidHardwareBufferFormatPropertiesANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID", "1.3-extensions"},
    {"VUID-VkAndroidHardwareBufferFormatResolvePropertiesANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_RESOLVE_PROPERTIES_ANDROID", "1.3-extensions"},
    {"VUID-VkAndroidHardwareBufferPropertiesANDROID-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAndroidHardwareBufferFormatProperties2ANDROID, VkAndroidHardwareBufferFormatPropertiesANDROID, or VkAndroidHardwareBufferFormatResolvePropertiesANDROID", "1.3-extensions"},
    {"VUID-VkAndroidHardwareBufferPropertiesANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID", "1.3-extensions"},
    {"VUID-VkAndroidHardwareBufferPropertiesANDROID-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkAndroidHardwareBufferUsageANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID", "1.3-extensions"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-window-01248", "window must point to a valid Android ANativeWindow", "1.3-extensions"},
    {"VUID-VkApplicationInfo-apiVersion-04010", "If apiVersion is not 0, then it must be greater than or equal to VK_API_VERSION_1_0", "1.3-extensions"},
    {"VUID-VkApplicationInfo-pApplicationName-parameter", "If pApplicationName is not NULL, pApplicationName must be a null-terminated UTF-8 string", "1.3-extensions"},
    {"VUID-VkApplicationInfo-pEngineName-parameter", "If pEngineName is not NULL, pEngineName must be a null-terminated UTF-8 string", "1.3-extensions"},
    {"VUID-VkApplicationInfo-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkApplicationInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_APPLICATION_INFO", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-attachmentFeedbackLoopLayout-07309", "If the attachmentFeedbackLoopLayout feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-attachmentFeedbackLoopLayout-07310", "If the attachmentFeedbackLoopLayout feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-dynamicRenderingLocalRead-09544", "If the dynamicRenderingLocalRead feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-dynamicRenderingLocalRead-09545", "If the dynamicRenderingLocalRead feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-finalLayout-00843", "finalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-finalLayout-parameter", "finalLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-flags-parameter", "flags must be a valid combination of VkAttachmentDescriptionFlagBits values", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-03280", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-03281", "If format is a depth/stencil format, initialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-03282", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-03283", "If format is a depth/stencil format, finalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-03286", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-03287", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-03290", "If format is a depth/stencil format which includes only the depth component, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-03291", "If format is a depth/stencil format which includes only the depth component, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-03292", "If format is a depth/stencil format which includes only the stencil component, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-03293", "If format is a depth/stencil format which includes only the stencil component, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-06242", "If format is a depth/stencil format which includes both depth and stencil components, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-06243", "If format is a depth/stencil format which includes both depth and stencil components, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-06487", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-06488", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-06698", "format must not be VK_FORMAT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-06699", "If format includes a color or depth component and loadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then initialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-06700", "If format includes a stencil component and stencilLoadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then initialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-06906", "If format is a depth/stencil format which includes both depth and stencil components, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-06907", "If format is a depth/stencil format which includes both depth and stencil components, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-format-parameter", "format must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-initialLayout-parameter", "initialLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-loadOp-parameter", "loadOp must be a valid VkAttachmentLoadOp value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-samples-08745", "samples must be a valid VkSampleCountFlagBits value that is set in imageCreateSampleCounts (as defined in Image Creation Limits) for the given format", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-samples-parameter", "samples must be a valid VkSampleCountFlagBits value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-separateDepthStencilLayouts-03284", "If the separateDepthStencilLayouts feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-separateDepthStencilLayouts-03285", "If the separateDepthStencilLayouts feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-stencilLoadOp-parameter", "stencilLoadOp must be a valid VkAttachmentLoadOp value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-stencilStoreOp-parameter", "stencilStoreOp must be a valid VkAttachmentStoreOp value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-storeOp-parameter", "storeOp must be a valid VkAttachmentStoreOp value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-synchronization2-06908", "If the synchronization2 feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentDescription-synchronization2-06909", "If the synchronization2 feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-attachmentFeedbackLoopLayout-07309", "If the attachmentFeedbackLoopLayout feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-attachmentFeedbackLoopLayout-07310", "If the attachmentFeedbackLoopLayout feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-dynamicRenderingLocalRead-09544", "If the dynamicRenderingLocalRead feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-dynamicRenderingLocalRead-09545", "If the dynamicRenderingLocalRead feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-finalLayout-00843", "finalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-finalLayout-parameter", "finalLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-flags-parameter", "flags must be a valid combination of VkAttachmentDescriptionFlagBits values", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-03280", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-03281", "If format is a depth/stencil format, initialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-03282", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-03283", "If format is a depth/stencil format, finalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-03286", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-03287", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-03290", "If format is a depth/stencil format which includes only the depth component, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-03291", "If format is a depth/stencil format which includes only the depth component, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-06247", "If the pNext chain does not include a VkAttachmentDescriptionStencilLayout structure and format only includes a stencil component, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-06248", "If the pNext chain does not include a VkAttachmentDescriptionStencilLayout structure and format only includes a stencil component, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-06249", "If format is a depth/stencil format which includes both depth and stencil components, and initialLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, the pNext chain must include a VkAttachmentDescriptionStencilLayout structure", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-06250", "If format is a depth/stencil format which includes both depth and stencil components, and finalLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, the pNext chain must include a VkAttachmentDescriptionStencilLayout structure", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-06487", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-06488", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-06699", "If format includes a color or depth component and loadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then initialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-06906", "If format is a depth/stencil format which includes both depth and stencil components, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-06907", "If format is a depth/stencil format which includes both depth and stencil components, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-09332", "If externalFormatResolve is not enabled, format must not be VK_FORMAT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-09334", "If format is VK_FORMAT_UNDEFINED, there must be a VkExternalFormatANDROID structure in the pNext chain with a externalFormat that is not equal to 0", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-format-parameter", "format must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-initialLayout-parameter", "initialLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-loadOp-parameter", "loadOp must be a valid VkAttachmentLoadOp value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-pNext-06704", "If the pNext chain does not include a VkAttachmentDescriptionStencilLayout structure, format includes a stencil component, and stencilLoadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then initialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-pNext-06705", "If the pNext chain includes a VkAttachmentDescriptionStencilLayout structure, format includes a stencil component, and stencilLoadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then VkAttachmentDescriptionStencilLayout::stencilInitialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAttachmentDescriptionStencilLayout or VkExternalFormatANDROID", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-samples-08745", "samples must be a valid VkSampleCountFlagBits value that is set in imageCreateSampleCounts (as defined in Image Creation Limits) for the given format", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-samples-parameter", "samples must be a valid VkSampleCountFlagBits value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-separateDepthStencilLayouts-03284", "If the separateDepthStencilLayouts feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-separateDepthStencilLayouts-03285", "If the separateDepthStencilLayouts feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-stencilLoadOp-parameter", "stencilLoadOp must be a valid VkAttachmentLoadOp value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-stencilStoreOp-parameter", "stencilStoreOp must be a valid VkAttachmentStoreOp value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-storeOp-parameter", "storeOp must be a valid VkAttachmentStoreOp value", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-synchronization2-06908", "If the synchronization2 feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentDescription2-synchronization2-06909", "If the synchronization2 feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentDescriptionStencilLayout-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT", "1.3-extensions"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-03309", "stencilFinalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-03310", "stencilFinalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED", "1.3-extensions"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-parameter", "stencilFinalLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilInitialLayout-03308", "stencilInitialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "1.3-extensions"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilInitialLayout-parameter", "stencilInitialLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkAttachmentReference-attachmentFeedbackLoopLayout-07311", "If the attachmentFeedbackLoopLayout feature is not enabled, layout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", "1.3-extensions"},
    {"VUID-VkAttachmentReference-dynamicRenderingLocalRead-09546", "If the dynamicRenderingLocalRead feature is not enabled, layout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentReference-layout-03077", "If attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_PREINITIALIZED, or VK_IMAGE_LAYOUT_PRESENT_SRC_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentReference-layout-parameter", "layout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkAttachmentReference-separateDepthStencilLayouts-03313", "If the separateDepthStencilLayouts feature is not enabled, and attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", "1.3-extensions"},
    {"VUID-VkAttachmentReference-synchronization2-06910", "If the synchronization2 feature is not enabled, layout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentReference2-attachmentFeedbackLoopLayout-07311", "If the attachmentFeedbackLoopLayout feature is not enabled, layout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", "1.3-extensions"},
    {"VUID-VkAttachmentReference2-dynamicRenderingLocalRead-09546", "If the dynamicRenderingLocalRead feature is not enabled, layout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentReference2-layout-03077", "If attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_PREINITIALIZED, or VK_IMAGE_LAYOUT_PRESENT_SRC_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentReference2-layout-parameter", "layout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkAttachmentReference2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkAttachmentReferenceStencilLayout", "1.3-extensions"},
    {"VUID-VkAttachmentReference2-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", "1.3-extensions"},
    {"VUID-VkAttachmentReference2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkAttachmentReference2-separateDepthStencilLayouts-03313", "If the separateDepthStencilLayouts feature is not enabled, and attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", "1.3-extensions"},
    {"VUID-VkAttachmentReference2-synchronization2-06910", "If the synchronization2 feature is not enabled, layout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentReferenceStencilLayout-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT", "1.3-extensions"},
    {"VUID-VkAttachmentReferenceStencilLayout-stencilLayout-03318", "stencilLayout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_PREINITIALIZED, VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_PRESENT_SRC_KHR", "1.3-extensions"},
    {"VUID-VkAttachmentReferenceStencilLayout-stencilLayout-parameter", "stencilLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkAttachmentSampleCountInfoAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD", "1.3-extensions"},
    {"VUID-VkAttachmentSampleLocationsEXT-attachmentIndex-01531", "attachmentIndex must be less than the attachmentCount specified in VkRenderPassCreateInfo the render pass specified by VkRenderPassBeginInfo::renderPass was created with", "1.3-extensions"},
    {"VUID-VkAttachmentSampleLocationsEXT-sampleLocationsInfo-parameter", "sampleLocationsInfo must be a valid VkSampleLocationsInfoEXT structure", "1.3-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-accelerationStructure-03620", "accelerationStructure must not already be backed by a memory object", "1.3-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-accelerationStructure-parameter", "accelerationStructure must be a valid VkAccelerationStructureNV handle", "1.3-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-commonparent", "Both of accelerationStructure, and memory must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memory-03622", "memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV", "1.3-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.3-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memoryOffset-03621", "memoryOffset must be less than the size of memory", "1.3-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memoryOffset-03623", "memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV", "1.3-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-pDeviceIndices-parameter", "If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values", "1.3-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV", "1.3-extensions"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-size-03624", "The size member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV must be less than or equal to the size of memory minus memoryOffset", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-deviceIndexCount-01606", "deviceIndexCount must either be zero or equal to the number of physical devices in the logical device", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices-01607", "All elements of pDeviceIndices must be valid device indices", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices-parameter", "If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-None-01898", "If buffer was created with the VK_BUFFER_CREATE_PROTECTED_BIT bit set, the buffer must be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-None-01899", "If buffer was created with the VK_BUFFER_CREATE_PROTECTED_BIT bit not set, the buffer must not be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-apiVersion-07920", "If the VK_KHR_dedicated_allocation extension is not enabled, VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, and buffer was not created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must not have been allocated dedicated for a specific buffer or image", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01030", "buffer must not have been created with any sparse memory binding flags", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01038", "If buffer was created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must have been allocated with VkDedicatedAllocationMemoryAllocateInfoNV::buffer equal to a buffer handle created with identical creation parameters to buffer and memoryOffset must be zero", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01444", "If buffer requires a dedicated allocation (as reported by vkGetBufferMemoryRequirements2 in VkMemoryDedicatedRequirements::requiresDedicatedAllocation for buffer), memory must have been allocated with VkMemoryDedicatedAllocateInfo::buffer equal to buffer", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-buffer-06408", "If buffer was created with VkBufferCollectionBufferCreateInfoFUCHSIA chained to VkBufferCreateInfo::pNext, memory must be allocated with a VkImportMemoryBufferCollectionFUCHSIA chained to VkMemoryAllocateInfo::pNext", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-buffer-07459", "buffer must not have been bound to a memory object", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-buffer-09201", "If the buffer was created with the VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-bufferDeviceAddress-03339", "If the VkPhysicalDeviceBufferDeviceAddressFeatures::bufferDeviceAddress feature is enabled and buffer was created with the VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-bufferDeviceAddressCaptureReplay-09200", "If the VkPhysicalDeviceBufferDeviceAddressFeatures::bufferDeviceAddressCaptureReplay feature is enabled and buffer was created with the VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-commonparent", "Both of buffer, and memory must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-descriptorBufferCaptureReplay-08112", "If the buffer was created with the VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memory-01035", "memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memory-01508", "If the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::buffer was not VK_NULL_HANDLE, then buffer must equal VkMemoryDedicatedAllocateInfo::buffer, and memoryOffset must be zero", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memory-02726", "If the value of VkExportMemoryAllocateInfo::handleTypes used to allocate memory is not 0, it must include at least one of the handles set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memory-02985", "If memory was allocated by a memory import operation, that is not VkImportAndroidHardwareBufferInfoANDROID with a non-NULL buffer value, the external handle type of the imported memory must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memory-02986", "If memory was allocated with the VkImportAndroidHardwareBufferInfoANDROID memory import operation with a non-NULL buffer value, VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memoryOffset-01031", "memoryOffset must be less than the size of memory", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-memoryOffset-01036", "memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-pNext-01605", "If the pNext chain includes a VkBindBufferMemoryDeviceGroupInfo structure, all instances of memory specified by VkBindBufferMemoryDeviceGroupInfo::pDeviceIndices must have been allocated", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBindBufferMemoryDeviceGroupInfo or VkBindMemoryStatusKHR", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkBindBufferMemoryInfo-size-01037", "The size member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer must be less than or equal to the size of memory minus memoryOffset", "1.3-extensions"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-None-09495", "If the dynamicPipelineLayout feature is not enabled, layout must be a valid VkPipelineLayout handle", "1.3-extensions"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-layout-09496", "If layout is VK_NULL_HANDLE, the pNext chain must include a valid VkPipelineLayoutCreateInfo structure", "1.3-extensions"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-layout-parameter", "If layout is not VK_NULL_HANDLE, layout must be a valid VkPipelineLayout handle", "1.3-extensions"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPipelineLayoutCreateInfo", "1.3-extensions"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_BUFFER_EMBEDDED_SAMPLERS_INFO_EXT", "1.3-extensions"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-set-08070", "The VkDescriptorSetLayout at index set when layout was created must have been created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT bit set", "1.3-extensions"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-set-08071", "set must be less than or equal to VkPipelineLayoutCreateInfo::setLayoutCount provided when layout was created", "1.3-extensions"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-stageFlags-parameter", "stageFlags must be a valid combination of VkShaderStageFlagBits values", "1.3-extensions"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-stageFlags-requiredbitmask", "stageFlags must not be 0", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-None-09495", "If the dynamicPipelineLayout feature is not enabled, layout must be a valid VkPipelineLayout handle", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-commonparent", "Both of layout, and the elements of pDescriptorSets that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-descriptorSetCount-arraylength", "descriptorSetCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-dynamicOffsetCount-00359", "dynamicOffsetCount must be equal to the total number of dynamic descriptors in pDescriptorSets", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-firstSet-00360", "The sum of firstSet and descriptorSetCount must be less than or equal to VkPipelineLayoutCreateInfo::setLayoutCount provided when layout was created", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-layout-09496", "If layout is VK_NULL_HANDLE, the pNext chain must include a valid VkPipelineLayoutCreateInfo structure", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-layout-parameter", "If layout is not VK_NULL_HANDLE, layout must be a valid VkPipelineLayout handle", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-pDescriptorSets-00358", "Each element of pDescriptorSets must have been allocated with a VkDescriptorSetLayout that matches (is the same as, or identically defined as) the VkDescriptorSetLayout at set n in layout, where n is the sum of firstSet and the index into pDescriptorSets", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-pDescriptorSets-01979", "For each dynamic uniform or storage buffer binding in pDescriptorSets, the sum of the effective offset and the range of the binding must be less than or equal to the size of the buffer", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-pDescriptorSets-04616", "Each element of pDescriptorSets must not have been allocated from a VkDescriptorPool with the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT flag set", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-pDescriptorSets-06563", "If graphicsPipelineLibrary is not enabled, each element of pDescriptorSets must be a valid VkDescriptorSet", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-pDescriptorSets-06715", "For each dynamic uniform or storage buffer binding in pDescriptorSets, if the range was set with VK_WHOLE_SIZE then pDynamicOffsets which corresponds to the descriptor binding must be 0", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-pDescriptorSets-08010", "Each element of pDescriptorSets must have been allocated with a VkDescriptorSetLayout which was not created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-pDescriptorSets-parameter", "pDescriptorSets must be a valid pointer to an array of descriptorSetCount valid VkDescriptorSet handles", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-pDynamicOffsets-01971", "Each element of pDynamicOffsets which corresponds to a descriptor binding with type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC must be a multiple of VkPhysicalDeviceLimits::minUniformBufferOffsetAlignment", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-pDynamicOffsets-01972", "Each element of pDynamicOffsets which corresponds to a descriptor binding with type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC must be a multiple of VkPhysicalDeviceLimits::minStorageBufferOffsetAlignment", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-pDynamicOffsets-parameter", "If dynamicOffsetCount is not 0, and pDynamicOffsets is not NULL, pDynamicOffsets must be a valid pointer to an array of dynamicOffsetCount or VK_NULL_HANDLE uint32_t values", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPipelineLayoutCreateInfo", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_SETS_INFO_KHR", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-stageFlags-parameter", "stageFlags must be a valid combination of VkShaderStageFlagBits values", "1.3-extensions"},
    {"VUID-VkBindDescriptorSetsInfoKHR-stageFlags-requiredbitmask", "stageFlags must not be 0", "1.3-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-deviceIndexCount-01633", "At least one of deviceIndexCount and splitInstanceBindRegionCount must be zero", "1.3-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-deviceIndexCount-01634", "deviceIndexCount must either be zero or equal to the number of physical devices in the logical device", "1.3-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-extent-01640", "The extent.width member of any element of pSplitInstanceBindRegions must either be a multiple of the sparse image block width of all non-metadata aspects of the image, or else extent.width + offset.x must equal the width of the image subresource", "1.3-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-extent-01641", "The extent.height member of any element of pSplitInstanceBindRegions must either be a multiple of the sparse image block height of all non-metadata aspects of the image, or else extent.height + offset.y must equal the height of the image subresource", "1.3-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-offset-01638", "The offset.x member of any element of pSplitInstanceBindRegions must be a multiple of the sparse image block width (VkSparseImageFormatProperties::imageGranularity.width) of all non-metadata aspects of the image", "1.3-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-offset-01639", "The offset.y member of any element of pSplitInstanceBindRegions must be a multiple of the sparse image block height (VkSparseImageFormatProperties::imageGranularity.height) of all non-metadata aspects of the image", "1.3-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pDeviceIndices-01635", "All elements of pDeviceIndices must be valid device indices", "1.3-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pDeviceIndices-parameter", "If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values", "1.3-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions-01637", "Elements of pSplitInstanceBindRegions that correspond to the same instance of an image must not overlap", "1.3-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions-parameter", "If splitInstanceBindRegionCount is not 0, pSplitInstanceBindRegions must be a valid pointer to an array of splitInstanceBindRegionCount VkRect2D structures", "1.3-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO", "1.3-extensions"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-splitInstanceBindRegionCount-01636", "splitInstanceBindRegionCount must either be zero or equal to the number of physical devices in the logical device squared", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-None-01901", "If image was created with the VK_IMAGE_CREATE_PROTECTED_BIT bit set, the image must be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-None-01902", "If image was created with the VK_IMAGE_CREATE_PROTECTED_BIT bit not set, the image must not be bound to a memory object created with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-apiVersion-07921", "If the VK_KHR_dedicated_allocation extension is not enabled, VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, and image was not created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must not have been allocated dedicated for a specific buffer or image", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-commonparent", "Both of image, and memory that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-descriptorBufferCaptureReplay-08113", "If the image was created with the VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-image-01045", "image must not have been created with any sparse memory binding flags", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-image-01050", "If image was created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must have been created with VkDedicatedAllocationMemoryAllocateInfoNV::image equal to an image handle created with identical creation parameters to image and memoryOffset must be zero", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-image-01445", "If image requires a dedicated allocation (as reported by vkGetImageMemoryRequirements2 in VkMemoryDedicatedRequirements::requiresDedicatedAllocation for image), memory must have been created with VkMemoryDedicatedAllocateInfo::image equal to image", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-image-01630", "If image was created with a valid swapchain handle in VkImageSwapchainCreateInfoKHR::swapchain, then the pNext chain must include a VkBindImageMemorySwapchainInfoKHR structure containing the same swapchain handle", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-image-07460", "image must not have been bound to a memory object", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-image-07736", "If image was created with the VK_IMAGE_CREATE_DISJOINT_BIT bit set, then the pNext chain must include a VkBindImagePlaneMemoryInfo structure", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-image-09202", "If the image was created with the VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-image-parameter", "image must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-memory-02628", "If the dedicatedAllocationImageAliasing feature is not enabled, and the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then image must equal VkMemoryDedicatedAllocateInfo::image and memoryOffset must be zero", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-memory-02629", "If the dedicatedAllocationImageAliasing feature is enabled, and the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then memoryOffset must be zero, and image must be either equal to VkMemoryDedicatedAllocateInfo::image or an image that was created using the same parameters in VkImageCreateInfo, with the exception that extent and arrayLayers may differ subject to the following restrictions: every dimension in the extent parameter of the image being bound must be equal to or smaller than the original image for which the allocation was created; and the arrayLayers parameter of the image being bound must be equal to or smaller than the original image for which the allocation was created", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-memory-02728", "If the value of VkExportMemoryAllocateInfo::handleTypes used to allocate memory is not 0, it must include at least one of the handles set in VkExternalMemoryImageCreateInfo::handleTypes when image was created", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-memory-02989", "If memory was created by a memory import operation, that is not VkImportAndroidHardwareBufferInfoANDROID with a non-NULL buffer value, the external handle type of the imported memory must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when image was created", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-memory-02990", "If memory was created with the VkImportAndroidHardwareBufferInfoANDROID memory import operation with a non-NULL buffer value, VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when image was created", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-memoryOffset-01046", "memoryOffset must be less than the size of memory", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01615", "If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01616", "If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01617", "If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, the difference of the size of memory and memoryOffset must be greater than or equal to the size member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with the same image", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01618", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, image must have been created with the VK_IMAGE_CREATE_DISJOINT_BIT bit set", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01619", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image and where VkBindImagePlaneMemoryInfo::planeAspect corresponds to the VkImagePlaneMemoryRequirementsInfo::planeAspect in the VkImageMemoryRequirementsInfo2 structure's pNext chain", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01620", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image and where VkBindImagePlaneMemoryInfo::planeAspect corresponds to the VkImagePlaneMemoryRequirementsInfo::planeAspect in the VkImageMemoryRequirementsInfo2 structure's pNext chain", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01621", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, the difference of the size of memory and memoryOffset must be greater than or equal to the size member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with the same image and where VkBindImagePlaneMemoryInfo::planeAspect corresponds to the VkImagePlaneMemoryRequirementsInfo::planeAspect in the VkImageMemoryRequirementsInfo2 structure's pNext chain", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01626", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, all instances of memory specified by VkBindImageMemoryDeviceGroupInfo::pDeviceIndices must have been allocated", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01627", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, and VkBindImageMemoryDeviceGroupInfo::splitInstanceBindRegionCount is not zero, then image must have been created with the VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT bit set", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01628", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, all elements of VkBindImageMemoryDeviceGroupInfo::pSplitInstanceBindRegions must be valid rectangles contained within the dimensions of image", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01629", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, the union of the areas of all elements of VkBindImageMemoryDeviceGroupInfo::pSplitInstanceBindRegions that correspond to the same instance of image must cover the entire image", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01631", "If the pNext chain includes a VkBindImageMemorySwapchainInfoKHR structure, memory must be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-01632", "If the pNext chain does not include a VkBindImageMemorySwapchainInfoKHR structure, memory must be a valid VkDeviceMemory handle", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBindImageMemoryDeviceGroupInfo, VkBindImageMemorySwapchainInfoKHR, VkBindImagePlaneMemoryInfo, or VkBindMemoryStatusKHR", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO", "1.3-extensions"},
    {"VUID-VkBindImageMemoryInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkBindImageMemorySwapchainInfoKHR-imageIndex-01644", "imageIndex must be less than the number of images in swapchain", "1.3-extensions"},
    {"VUID-VkBindImageMemorySwapchainInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR", "1.3-extensions"},
    {"VUID-VkBindImageMemorySwapchainInfoKHR-swapchain-07756", "If the swapchain has been created with VK_SWAPCHAIN_CREATE_DEFERRED_MEMORY_ALLOCATION_BIT_EXT, imageIndex must be one that has previously been returned by vkAcquireNextImageKHR or vkAcquireNextImage2KHR", "1.3-extensions"},
    {"VUID-VkBindImageMemorySwapchainInfoKHR-swapchain-parameter", "swapchain must be a valid VkSwapchainKHR handle", "1.3-extensions"},
    {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-02283", "If the image's tiling is VK_IMAGE_TILING_LINEAR or VK_IMAGE_TILING_OPTIMAL, then planeAspect must be a single valid multi-planar aspect mask bit", "1.3-extensions"},
    {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-02284", "If the image's tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then planeAspect must be a single valid memory plane for the image (that is, aspectMask must specify a plane index that is less than the VkDrmFormatModifierPropertiesEXT::drmFormatModifierPlaneCount associated with the image's format and VkImageDrmFormatModifierPropertiesEXT::drmFormatModifier)", "1.3-extensions"},
    {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-parameter", "planeAspect must be a valid VkImageAspectFlagBits value", "1.3-extensions"},
    {"VUID-VkBindImagePlaneMemoryInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO", "1.3-extensions"},
    {"VUID-VkBindIndexBufferIndirectCommandNV-None-02946", "The buffer's usage flag from which the address was acquired must have the VK_BUFFER_USAGE_INDEX_BUFFER_BIT bit set", "1.3-extensions"},
    {"VUID-VkBindIndexBufferIndirectCommandNV-None-02948", "Each element of the buffer from which the address was acquired and that is non-sparse must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkBindIndexBufferIndirectCommandNV-bufferAddress-02947", "The bufferAddress must be aligned to the indexType used", "1.3-extensions"},
    {"VUID-VkBindIndexBufferIndirectCommandNV-indexType-parameter", "indexType must be a valid VkIndexType value", "1.3-extensions"},
    {"VUID-VkBindMemoryStatusKHR-pResult-parameter", "pResult must be a valid pointer to a VkResult value", "1.3-extensions"},
    {"VUID-VkBindMemoryStatusKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS_KHR", "1.3-extensions"},
    {"VUID-VkBindPipelineIndirectCommandNV-None-09092", "The referenced pipeline must have been created with VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "1.3-extensions"},
    {"VUID-VkBindPipelineIndirectCommandNV-None-09093", "The referenced pipeline must have been updated with vkCmdUpdatePipelineIndirectBufferNV", "1.3-extensions"},
    {"VUID-VkBindPipelineIndirectCommandNV-None-09094", "The referenced pipeline's address must have been queried with vkGetPipelineIndirectDeviceAddressNV", "1.3-extensions"},
    {"VUID-VkBindPipelineIndirectCommandNV-deviceGeneratedComputePipelines-09091", "The VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputePipelines feature must be enabled", "1.3-extensions"},
    {"VUID-VkBindShaderGroupIndirectCommandNV-None-02944", "The current bound graphics pipeline, as well as the pipelines it may reference, must have been created with VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "1.3-extensions"},
    {"VUID-VkBindShaderGroupIndirectCommandNV-index-02945", "The index must be within range of the accessible shader groups of the current bound graphics pipeline. See vkCmdBindPipelineShaderGroupNV for further details", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-commonparent", "Both of the elements of pSignalSemaphores, and the elements of pWaitSemaphores that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-pBufferBinds-parameter", "If bufferBindCount is not 0, pBufferBinds must be a valid pointer to an array of bufferBindCount valid VkSparseBufferMemoryBindInfo structures", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-pImageBinds-parameter", "If imageBindCount is not 0, pImageBinds must be a valid pointer to an array of imageBindCount valid VkSparseImageMemoryBindInfo structures", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-pImageOpaqueBinds-parameter", "If imageOpaqueBindCount is not 0, pImageOpaqueBinds must be a valid pointer to an array of imageOpaqueBindCount valid VkSparseImageOpaqueMemoryBindInfo structures", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-pNext-03247", "If the pNext chain of this structure includes a VkTimelineSemaphoreSubmitInfo structure and any element of pWaitSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then its waitSemaphoreValueCount member must equal waitSemaphoreCount", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-pNext-03248", "If the pNext chain of this structure includes a VkTimelineSemaphoreSubmitInfo structure and any element of pSignalSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then its signalSemaphoreValueCount member must equal signalSemaphoreCount", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceGroupBindSparseInfo, VkFrameBoundaryEXT, or VkTimelineSemaphoreSubmitInfo", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-pSignalSemaphores-03249", "For each element of pSignalSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pSignalSemaphoreValues must have a value greater than the current value of the semaphore when the semaphore signal operation is executed", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-pSignalSemaphores-03251", "For each element of pSignalSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pSignalSemaphoreValues must have a value which does not differ from the current value of the semaphore or from the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-pSignalSemaphores-parameter", "If signalSemaphoreCount is not 0, pSignalSemaphores must be a valid pointer to an array of signalSemaphoreCount valid VkSemaphore handles", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-pWaitSemaphores-03246", "If any element of pWaitSemaphores or pSignalSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then the pNext chain must include a VkTimelineSemaphoreSubmitInfo structure", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-pWaitSemaphores-03250", "For each element of pWaitSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pWaitSemaphoreValues must have a value which does not differ from the current value of the semaphore or from the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-pWaitSemaphores-parameter", "If waitSemaphoreCount is not 0, pWaitSemaphores must be a valid pointer to an array of waitSemaphoreCount valid VkSemaphore handles", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_SPARSE_INFO", "1.3-extensions"},
    {"VUID-VkBindSparseInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkBindVertexBufferIndirectCommandNV-None-02949", "The buffer's usage flag from which the address was acquired must have the VK_BUFFER_USAGE_VERTEX_BUFFER_BIT bit set", "1.3-extensions"},
    {"VUID-VkBindVertexBufferIndirectCommandNV-None-02950", "Each element of the buffer from which the address was acquired and that is non-sparse must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkBindVideoSessionMemoryInfoKHR-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.3-extensions"},
    {"VUID-VkBindVideoSessionMemoryInfoKHR-memoryOffset-07201", "memoryOffset must be less than the size of memory", "1.3-extensions"},
    {"VUID-VkBindVideoSessionMemoryInfoKHR-memorySize-07202", "memorySize must be less than or equal to the size of memory minus memoryOffset", "1.3-extensions"},
    {"VUID-VkBindVideoSessionMemoryInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkBindVideoSessionMemoryInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR", "1.3-extensions"},
    {"VUID-VkBlitImageCubicWeightsInfoQCOM-cubicWeights-parameter", "cubicWeights must be a valid VkCubicFilterWeightsQCOM value", "1.3-extensions"},
    {"VUID-VkBlitImageCubicWeightsInfoQCOM-sType-sType", "sType must be VK_STRUCTURE_TYPE_BLIT_IMAGE_CUBIC_WEIGHTS_INFO_QCOM", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-aspectMask-00241", "For each element of pRegions, srcSubresource.aspectMask must specify aspects present in srcImage", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-aspectMask-00242", "For each element of pRegions, dstSubresource.aspectMask must specify aspects present in dstImage", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-commonparent", "Both of dstImage, and srcImage must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstImage-00224", "dstImage must have been created with VK_IMAGE_USAGE_TRANSFER_DST_BIT usage flag", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstImage-00225", "If dstImage is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstImage-00234", "dstImage must have been created with a samples value of VK_SAMPLE_COUNT_1_BIT", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstImage-00250", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffsets[0].y must be 0 and dstOffsets[1].y must be 1", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstImage-00252", "If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, dstOffsets[0].z must be 0 and dstOffsets[1].z must be 1", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstImage-02000", "The format features of dstImage must contain VK_FORMAT_FEATURE_BLIT_DST_BIT", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstImage-02545", "dstImage and srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstImage-06422", "dstImage must not use a format that requires a sampler Y'CBCR conversion", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstImage-parameter", "dstImage must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstImageLayout-00226", "dstImageLayout must specify the layout of the image subresources of dstImage specified in pRegions at the time this command is executed on a VkDevice", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstImageLayout-01399", "dstImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstImageLayout-parameter", "dstImageLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstOffset-00248", "For each element of pRegions, dstOffsets[0].x and dstOffsets[1].x must both be greater than or equal to 0 and less than or equal to the width of the specified dstSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstOffset-00249", "For each element of pRegions, dstOffsets[0].y and dstOffsets[1].y must both be greater than or equal to 0 and less than or equal to the height of the specified dstSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstOffset-00251", "For each element of pRegions, dstOffsets[0].z and dstOffsets[1].z must both be greater than or equal to 0 and less than or equal to the depth of the specified dstSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstSubresource-01706", "The dstSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-dstSubresource-01708", "If srcSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, dstSubresource.baseArrayLayer + dstSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-filter-00237", "If filter is VK_FILTER_CUBIC_EXT, srcImage must be of type VK_IMAGE_TYPE_2D", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-filter-02001", "If filter is VK_FILTER_LINEAR, then the format features of srcImage must contain VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-filter-02002", "If filter is VK_FILTER_CUBIC_EXT, then the format features of srcImage must contain VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-filter-09204", "If filter is VK_FILTER_CUBIC_EXT and if the selectableCubicWeights feature is not enabled then the cubic weights must be VK_CUBIC_FILTER_WEIGHTS_CATMULL_ROM_QCOM", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-filter-parameter", "filter must be a valid VkFilter value", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkBlitImageCubicWeightsInfoQCOM", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-pRegions-00215", "The source region specified by each element of pRegions must be a region that is contained within srcImage", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-pRegions-00216", "The destination region specified by each element of pRegions must be a region that is contained within dstImage", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-pRegions-00217", "The union of all destination regions, specified by the elements of pRegions, must not overlap in memory with any texel that may be sampled during the blit operation", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-pRegions-04561", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage and dstImage must not be block-compressed images", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkImageBlit2 structures", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-regionCount-arraylength", "regionCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImage-00219", "srcImage must have been created with VK_IMAGE_USAGE_TRANSFER_SRC_BIT usage flag", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImage-00220", "If srcImage is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImage-00229", "If either of srcImage or dstImage was created with a signed integer VkFormat, the other must also have been created with a signed integer VkFormat", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImage-00230", "If either of srcImage or dstImage was created with an unsigned integer VkFormat, the other must also have been created with an unsigned integer VkFormat", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImage-00231", "If either of srcImage or dstImage was created with a depth/stencil format, the other must have exactly the same format", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImage-00232", "If srcImage was created with a depth/stencil format, filter must be VK_FILTER_NEAREST", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImage-00233", "srcImage must have been created with a samples value of VK_SAMPLE_COUNT_1_BIT", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImage-00240", "If either srcImage or dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer and dstSubresource.baseArrayLayer must each be 0, and srcSubresource.layerCount and dstSubresource.layerCount must each be 1", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImage-00245", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffsets[0].y must be 0 and srcOffsets[1].y must be 1", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImage-00247", "If srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, srcOffsets[0].z must be 0 and srcOffsets[1].z must be 1", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImage-01999", "The format features of srcImage must contain VK_FORMAT_FEATURE_BLIT_SRC_BIT", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImage-06421", "srcImage must not use a format that requires a sampler Y'CBCR conversion", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImage-09459", "If srcImage and dstImage are the same, and an elements of pRegions contains the srcSubresource and dstSubresource with matching mipLevel and overlapping array layers, then the srcImageLayout and dstImageLayout must be VK_IMAGE_LAYOUT_GENERAL or VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImage-parameter", "srcImage must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImageLayout-00221", "srcImageLayout must specify the layout of the image subresources of srcImage specified in pRegions at the time this command is executed on a VkDevice", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImageLayout-01398", "srcImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcImageLayout-parameter", "srcImageLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcOffset-00243", "For each element of pRegions, srcOffsets[0].x and srcOffsets[1].x must both be greater than or equal to 0 and less than or equal to the width of the specified srcSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcOffset-00244", "For each element of pRegions, srcOffsets[0].y and srcOffsets[1].y must both be greater than or equal to 0 and less than or equal to the height of the specified srcSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcOffset-00246", "For each element of pRegions, srcOffsets[0].z and srcOffsets[1].z must both be greater than or equal to 0 and less than or equal to the depth of the specified srcSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcSubresource-01705", "The srcSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2-srcSubresource-01707", "If srcSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, srcSubresource.baseArrayLayer + srcSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2KHR-pRegions-06207", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must be of type VK_IMAGE_TYPE_2D", "1.3-extensions"},
    {"VUID-VkBlitImageInfo2KHR-pRegions-06208", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must not have a multi-planar format", "1.3-extensions"},
    {"VUID-VkBufferCaptureDescriptorDataInfoEXT-buffer-08075", "buffer must have been created with VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT set in VkBufferCreateInfo::flags", "1.3-extensions"},
    {"VUID-VkBufferCaptureDescriptorDataInfoEXT-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkBufferCaptureDescriptorDataInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkBufferCaptureDescriptorDataInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT", "1.3-extensions"},
    {"VUID-VkBufferCollectionBufferCreateInfoFUCHSIA-collection-parameter", "collection must be a valid VkBufferCollectionFUCHSIA handle", "1.3-extensions"},
    {"VUID-VkBufferCollectionBufferCreateInfoFUCHSIA-index-06388", "index must be less than VkBufferCollectionPropertiesFUCHSIA::bufferCount", "1.3-extensions"},
    {"VUID-VkBufferCollectionBufferCreateInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA", "1.3-extensions"},
    {"VUID-VkBufferCollectionConstraintsInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkBufferCollectionConstraintsInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA", "1.3-extensions"},
    {"VUID-VkBufferCollectionCreateInfoFUCHSIA-collectionToken-06393", "collectionToken must be a valid zx_handle_t to a Zircon channel allocated from Sysmem (fuchsia.sysmem.Allocator/AllocateSharedCollection) with ZX_DEFAULT_CHANNEL_RIGHTS rights", "1.3-extensions"},
    {"VUID-VkBufferCollectionCreateInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkBufferCollectionCreateInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CREATE_INFO_FUCHSIA", "1.3-extensions"},
    {"VUID-VkBufferCollectionImageCreateInfoFUCHSIA-collection-parameter", "collection must be a valid VkBufferCollectionFUCHSIA handle", "1.3-extensions"},
    {"VUID-VkBufferCollectionImageCreateInfoFUCHSIA-index-06391", "index must be less than VkBufferCollectionPropertiesFUCHSIA::bufferCount", "1.3-extensions"},
    {"VUID-VkBufferCollectionImageCreateInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA", "1.3-extensions"},
    {"VUID-VkBufferCollectionPropertiesFUCHSIA-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkBufferCollectionPropertiesFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_PROPERTIES_FUCHSIA", "1.3-extensions"},
    {"VUID-VkBufferConstraintsInfoFUCHSIA-bufferCollectionConstraints-parameter", "bufferCollectionConstraints must be a valid VkBufferCollectionConstraintsInfoFUCHSIA structure", "1.3-extensions"},
    {"VUID-VkBufferConstraintsInfoFUCHSIA-createInfo-parameter", "createInfo must be a valid VkBufferCreateInfo structure", "1.3-extensions"},
    {"VUID-VkBufferConstraintsInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkBufferConstraintsInfoFUCHSIA-requiredFormatFeatures-06404", "The requiredFormatFeatures bitmask of VkFormatFeatureFlagBits must be chosen from among the buffer compatible format features listed in buffer compatible format features", "1.3-extensions"},
    {"VUID-VkBufferConstraintsInfoFUCHSIA-requiredFormatFeatures-parameter", "requiredFormatFeatures must be a valid combination of VkFormatFeatureFlagBits values", "1.3-extensions"},
    {"VUID-VkBufferConstraintsInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_CONSTRAINTS_INFO_FUCHSIA", "1.3-extensions"},
    {"VUID-VkBufferCopy-size-01988", "The size must be greater than 0", "1.3-extensions"},
    {"VUID-VkBufferCopy2-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkBufferCopy2-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_COPY_2", "1.3-extensions"},
    {"VUID-VkBufferCopy2-size-01988", "The size must be greater than 0", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-None-01888", "If any of the bits VK_BUFFER_CREATE_SPARSE_BINDING_BIT, VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT, or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT are set, VK_BUFFER_CREATE_PROTECTED_BIT must not also be set", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-None-09499", "If the pNext chain does not include a VkBufferUsageFlags2CreateInfoKHR structure, usage must be a valid combination of VkBufferUsageFlagBits values", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-None-09500", "If the pNext chain does not include a VkBufferUsageFlags2CreateInfoKHR structure, usage must not be 0", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-deviceAddress-02604", "If VkBufferDeviceAddressCreateInfoEXT::deviceAddress is not zero, flags must include VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-flags-00915", "If the sparseBinding feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_BINDING_BIT", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-flags-00916", "If the sparseResidencyBuffer feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-flags-00917", "If the sparseResidencyAliased feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_ALIASED_BIT", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-flags-00918", "If flags contains VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT, it must also contain VK_BUFFER_CREATE_SPARSE_BINDING_BIT", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-flags-01887", "If the protectedMemory feature is not enabled, flags must not contain VK_BUFFER_CREATE_PROTECTED_BIT", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-flags-03338", "If flags includes VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT, the bufferDeviceAddressCaptureReplay feature must be enabled", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-flags-08099", "If flags includes VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT, the descriptorBufferCaptureReplay feature must be enabled", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-flags-08325", "If flags includes VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then videoMaintenance1 must be enabled", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-flags-09641", "If flags includes VK_BUFFER_CREATE_PROTECTED_BIT, then usage must not contain any of the following bits VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR VK_BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT VK_BUFFER_USAGE_MICROMAP_BUILD_INPUT_READ_ONLY_BIT_EXT VK_BUFFER_USAGE_MICROMAP_STORAGE_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-flags-parameter", "flags must be a valid combination of VkBufferCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-opaqueCaptureAddress-03337", "If VkBufferOpaqueCaptureAddressCreateInfo::opaqueCaptureAddress is not zero, flags must include VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-pNext-00920", "If the pNext chain includes a VkExternalMemoryBufferCreateInfo structure, its handleTypes member must only contain bits that are also in VkExternalBufferProperties::externalMemoryProperties.compatibleHandleTypes, as returned by vkGetPhysicalDeviceExternalBufferProperties with pExternalBufferInfo->handleType equal to any one of the handle types specified in VkExternalMemoryBufferCreateInfo::handleTypes", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-pNext-01571", "If the pNext chain includes a VkDedicatedAllocationBufferCreateInfoNV structure, and the dedicatedAllocation member of the chained structure is VK_TRUE, then flags must not include VK_BUFFER_CREATE_SPARSE_BINDING_BIT, VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT, or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-pNext-08100", "If the pNext chain includes a VkOpaqueCaptureDescriptorDataCreateInfoEXT structure, flags must contain VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBufferCollectionBufferCreateInfoFUCHSIA, VkBufferDeviceAddressCreateInfoEXT, VkBufferOpaqueCaptureAddressCreateInfo, VkBufferUsageFlags2CreateInfoKHR, VkDedicatedAllocationBufferCreateInfoNV, VkExternalMemoryBufferCreateInfo, VkOpaqueCaptureDescriptorDataCreateInfoEXT, or VkVideoProfileListInfoKHR", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-sharingMode-00913", "If sharingMode is VK_SHARING_MODE_CONCURRENT, pQueueFamilyIndices must be a valid pointer to an array of queueFamilyIndexCount uint32_t values", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-sharingMode-00914", "If sharingMode is VK_SHARING_MODE_CONCURRENT, queueFamilyIndexCount must be greater than 1", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-sharingMode-01419", "If sharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by either vkGetPhysicalDeviceQueueFamilyProperties2 or vkGetPhysicalDeviceQueueFamilyProperties for the physicalDevice that was used to create device", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-sharingMode-parameter", "sharingMode must be a valid VkSharingMode value", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-size-00912", "size must be greater than 0", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-size-06409", "size must be less than or equal to VkPhysicalDeviceMaintenance4Properties::maxBufferSize", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-usage-04813", "If usage includes VK_BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR or VK_BUFFER_USAGE_VIDEO_DECODE_DST_BIT_KHR, and flags does not include VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then the pNext chain must include a VkVideoProfileListInfoKHR structure with profileCount greater than 0 and pProfiles including at least one VkVideoProfileInfoKHR structure with a videoCodecOperation member specifying a decode operation", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-usage-04814", "If usage includes VK_BUFFER_USAGE_VIDEO_ENCODE_SRC_BIT_KHR or VK_BUFFER_USAGE_VIDEO_ENCODE_DST_BIT_KHR, and flags does not include VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then the pNext chain must include a VkVideoProfileListInfoKHR structure with profileCount greater than 0 and pProfiles including at least one VkVideoProfileInfoKHR structure with a videoCodecOperation member specifying an encode operation", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-usage-08097", "If usage includes VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT, creating this VkBuffer must not cause the total required space for all currently valid buffers using this flag on the device to exceed VkPhysicalDeviceDescriptorBufferPropertiesEXT::samplerDescriptorBufferAddressSpaceSize or VkPhysicalDeviceDescriptorBufferPropertiesEXT::descriptorBufferAddressSpaceSize", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-usage-08098", "If usage includes VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT, creating this VkBuffer must not cause the total required space for all currently valid buffers using this flag on the device to exceed VkPhysicalDeviceDescriptorBufferPropertiesEXT::resourceDescriptorBufferAddressSpaceSize or VkPhysicalDeviceDescriptorBufferPropertiesEXT::descriptorBufferAddressSpaceSize", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-usage-08101", "If usage includes VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT, the descriptorBufferPushDescriptors feature must be enabled", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-usage-08102", "If usage includes VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT VkPhysicalDeviceDescriptorBufferPropertiesEXT::bufferlessPushDescriptors must be VK_FALSE", "1.3-extensions"},
    {"VUID-VkBufferCreateInfo-usage-08103", "If usage includes VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT, usage must contain at least one of VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT or VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferDeviceAddressCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkBufferDeviceAddressInfo-buffer-02600", "If buffer is non-sparse and was not created with the VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT flag, then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkBufferDeviceAddressInfo-buffer-02601", "buffer must have been created with VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT", "1.3-extensions"},
    {"VUID-VkBufferDeviceAddressInfo-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkBufferDeviceAddressInfo-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkBufferDeviceAddressInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO", "1.3-extensions"},
    {"VUID-VkBufferImageCopy-aspectMask-09103", "The aspectMask member of imageSubresource must only have a single bit set", "1.3-extensions"},
    {"VUID-VkBufferImageCopy-bufferImageHeight-09102", "bufferImageHeight must be 0, or greater than or equal to the height member of imageExtent", "1.3-extensions"},
    {"VUID-VkBufferImageCopy-bufferRowLength-09101", "bufferRowLength must be 0, or greater than or equal to the width member of imageExtent", "1.3-extensions"},
    {"VUID-VkBufferImageCopy-imageExtent-06659", "imageExtent.width must not be 0", "1.3-extensions"},
    {"VUID-VkBufferImageCopy-imageExtent-06660", "imageExtent.height must not be 0", "1.3-extensions"},
    {"VUID-VkBufferImageCopy-imageExtent-06661", "imageExtent.depth must not be 0", "1.3-extensions"},
    {"VUID-VkBufferImageCopy-imageSubresource-parameter", "imageSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkBufferImageCopy2-aspectMask-09103", "The aspectMask member of imageSubresource must only have a single bit set", "1.3-extensions"},
    {"VUID-VkBufferImageCopy2-bufferImageHeight-09102", "bufferImageHeight must be 0, or greater than or equal to the height member of imageExtent", "1.3-extensions"},
    {"VUID-VkBufferImageCopy2-bufferRowLength-09101", "bufferRowLength must be 0, or greater than or equal to the width member of imageExtent", "1.3-extensions"},
    {"VUID-VkBufferImageCopy2-imageExtent-06659", "imageExtent.width must not be 0", "1.3-extensions"},
    {"VUID-VkBufferImageCopy2-imageExtent-06660", "imageExtent.height must not be 0", "1.3-extensions"},
    {"VUID-VkBufferImageCopy2-imageExtent-06661", "imageExtent.depth must not be 0", "1.3-extensions"},
    {"VUID-VkBufferImageCopy2-imageSubresource-parameter", "imageSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkBufferImageCopy2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkCopyCommandTransformInfoQCOM", "1.3-extensions"},
    {"VUID-VkBufferImageCopy2-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2", "1.3-extensions"},
    {"VUID-VkBufferImageCopy2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-None-09049", "If the synchronization2 feature is not enabled, and buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, at least one of srcQueueFamilyIndex and dstQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-None-09050", "If the synchronization2 feature is not enabled, and buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, srcQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED or VK_QUEUE_FAMILY_EXTERNAL", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-None-09051", "If the synchronization2 feature is not enabled, and buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, dstQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED or VK_QUEUE_FAMILY_EXTERNAL", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-None-09097", "If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-None-09098", "If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-buffer-01931", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-buffer-09095", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-buffer-09096", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, dstQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-dstQueueFamilyIndex-09100", "If the VK_EXT_queue_family_foreign extension is not enabled dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-offset-01187", "offset must be less than the size of buffer", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkExternalMemoryAcquireUnmodifiedEXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-size-01188", "If size is not equal to VK_WHOLE_SIZE, size must be greater than 0", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-size-01189", "If size is not equal to VK_WHOLE_SIZE, size must be less than or equal to than the size of buffer minus offset", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-srcQueueFamilyIndex-04087", "If srcQueueFamilyIndex is not equal to dstQueueFamilyIndex, at least one of srcQueueFamilyIndex or dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL or VK_QUEUE_FAMILY_FOREIGN_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier-srcQueueFamilyIndex-09099", "If the VK_EXT_queue_family_foreign extension is not enabled srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-None-09097", "If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-None-09098", "If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-buffer-01931", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-buffer-09095", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-buffer-09096", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, dstQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03900", "If dstAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03901", "If dstAccessMask includes VK_ACCESS_2_INDEX_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03902", "If dstAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03903", "If dstAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03904", "If dstAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03905", "If dstAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03906", "If dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03907", "If dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03909", "If dstAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03910", "If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03911", "If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03912", "If dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03913", "If dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03914", "If dstAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03915", "If dstAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_CLEAR_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03916", "If dstAccessMask includes VK_ACCESS_2_HOST_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03917", "If dstAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03918", "If dstAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03919", "If dstAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03920", "If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03922", "If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03923", "If dstAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03924", "If dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03925", "If dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03926", "If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03927", "If dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03928", "If dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04747", "If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04858", "If dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04859", "If dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04860", "If dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04861", "If dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04994", "If dstAccessMask includes VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI, dstStageMask must include VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-06256", "If the rayQuery feature is not enabled and dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, dstStageMask must not include any of the VK_PIPELINE_STAGE_*_SHADER_BIT stages except VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07272", "If dstAccessMask includes VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT or VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07454", "If dstAccessMask includes VK_ACCESS_2_SHADER_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07455", "If dstAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07456", "If dstAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07457", "If dstAccessMask includes VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07458", "If dstAccessMask includes VK_ACCESS_2_MICROMAP_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT or VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-08118", "If dstAccessMask includes VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-parameter", "dstAccessMask must be a valid combination of VkAccessFlagBits2 values", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstQueueFamilyIndex-09100", "If the VK_EXT_queue_family_foreign extension is not enabled dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-03929", "If the geometryShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-03930", "If the tessellationShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-03931", "If the conditionalRendering feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-03932", "If the fragmentDensityMap feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-03933", "If the transformFeedback feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-03934", "If the meshShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-03935", "If the taskShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-04957", "If the subpassShading feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-04995", "If the invocationMask feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-07316", "If neither the shadingRateImage or attachmentFragmentShadingRate are enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-07946", "If neither the VK_NV_ray_tracing extension or rayTracingPipeline feature are enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-parameter", "dstStageMask must be a valid combination of VkPipelineStageFlagBits2 values", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-offset-01187", "offset must be less than the size of buffer", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkExternalMemoryAcquireUnmodifiedEXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-size-01188", "If size is not equal to VK_WHOLE_SIZE, size must be greater than 0", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-size-01189", "If size is not equal to VK_WHOLE_SIZE, size must be less than or equal to than the size of buffer minus offset", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03900", "If srcAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03901", "If srcAccessMask includes VK_ACCESS_2_INDEX_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03902", "If srcAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03903", "If srcAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03904", "If srcAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03905", "If srcAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03906", "If srcAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03907", "If srcAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03909", "If srcAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03910", "If srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03911", "If srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03912", "If srcAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03913", "If srcAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03914", "If srcAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03915", "If srcAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_CLEAR_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03916", "If srcAccessMask includes VK_ACCESS_2_HOST_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03917", "If srcAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03918", "If srcAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03919", "If srcAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03920", "If srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03922", "If srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03923", "If srcAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03924", "If srcAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03925", "If srcAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03926", "If srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03927", "If srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03928", "If srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04747", "If srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04858", "If srcAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04859", "If srcAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04860", "If srcAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04861", "If srcAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04994", "If srcAccessMask includes VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI, srcStageMask must include VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-06256", "If the rayQuery feature is not enabled and srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, srcStageMask must not include any of the VK_PIPELINE_STAGE_*_SHADER_BIT stages except VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07272", "If srcAccessMask includes VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT or VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07454", "If srcAccessMask includes VK_ACCESS_2_SHADER_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07455", "If srcAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07456", "If srcAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07457", "If srcAccessMask includes VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07458", "If srcAccessMask includes VK_ACCESS_2_MICROMAP_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT or VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-08118", "If srcAccessMask includes VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-parameter", "srcAccessMask must be a valid combination of VkAccessFlagBits2 values", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcQueueFamilyIndex-04087", "If srcQueueFamilyIndex is not equal to dstQueueFamilyIndex, at least one of srcQueueFamilyIndex or dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL or VK_QUEUE_FAMILY_FOREIGN_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcQueueFamilyIndex-09099", "If the VK_EXT_queue_family_foreign extension is not enabled srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03851", "If either srcStageMask or dstStageMask includes VK_PIPELINE_STAGE_2_HOST_BIT, srcQueueFamilyIndex and dstQueueFamilyIndex must be equal", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03929", "If the geometryShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03930", "If the tessellationShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03931", "If the conditionalRendering feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03932", "If the fragmentDensityMap feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03933", "If the transformFeedback feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03934", "If the meshShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03935", "If the taskShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-04957", "If the subpassShading feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-04995", "If the invocationMask feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-07316", "If neither the shadingRateImage or attachmentFragmentShadingRate are enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-07946", "If neither the VK_NV_ray_tracing extension or rayTracingPipeline feature are enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-parameter", "srcStageMask must be a valid combination of VkPipelineStageFlagBits2 values", "1.3-extensions"},
    {"VUID-VkBufferMemoryRequirementsInfo2-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkBufferMemoryRequirementsInfo2-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkBufferMemoryRequirementsInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2", "1.3-extensions"},
    {"VUID-VkBufferOpaqueCaptureAddressCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkBufferUsageFlags2CreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkBufferUsageFlags2CreateInfoKHR-usage-parameter", "usage must be a valid combination of VkBufferUsageFlagBits2KHR values", "1.3-extensions"},
    {"VUID-VkBufferUsageFlags2CreateInfoKHR-usage-requiredbitmask", "usage must not be 0", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-buffer-00932", "buffer must have been created with a usage value containing at least one of VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT or VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-buffer-00935", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-buffer-02750", "If the texelBufferAlignment feature is enabled and if buffer was created with usage containing VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT, offset must be a multiple of the lesser of VkPhysicalDeviceTexelBufferAlignmentProperties::storageTexelBufferOffsetAlignmentBytes or, if VkPhysicalDeviceTexelBufferAlignmentProperties::storageTexelBufferOffsetSingleTexelAlignment is VK_TRUE, the size of a texel of the requested format. If the size of a texel is a multiple of three bytes, then the size of a single component of format is used instead", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-buffer-02751", "If the texelBufferAlignment feature is enabled and if buffer was created with usage containing VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT, offset must be a multiple of the lesser of VkPhysicalDeviceTexelBufferAlignmentProperties::uniformTexelBufferOffsetAlignmentBytes or, if VkPhysicalDeviceTexelBufferAlignmentProperties::uniformTexelBufferOffsetSingleTexelAlignment is VK_TRUE, the size of a texel of the requested format. If the size of a texel is a multiple of three bytes, then the size of a single component of format is used instead", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-format-08778", "If the buffer view usage contains VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT, then format features of format must contain VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-format-08779", "If the buffer view usage contains VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT, then format features of format must contain VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-format-parameter", "format must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-offset-00925", "offset must be less than the size of buffer", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-offset-00931", "If range is not equal to VK_WHOLE_SIZE, the sum of offset and range must be less than or equal to the size of buffer", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-offset-02749", "If the texelBufferAlignment feature is not enabled, offset must be a multiple of VkPhysicalDeviceLimits::minTexelBufferOffsetAlignment", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-pNext-06782", "If the pNext chain includes a VkExportMetalObjectCreateInfoEXT structure, its exportObjectType member must be VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-pNext-08780", "If the pNext chain includes a VkBufferUsageFlags2CreateInfoKHR, its usage must not contain any other bit than VK_BUFFER_USAGE_2_UNIFORM_TEXEL_BUFFER_BIT_KHR or VK_BUFFER_USAGE_2_STORAGE_TEXEL_BUFFER_BIT_KHR", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-pNext-08781", "If the pNext chain includes a VkBufferUsageFlags2CreateInfoKHR, its usage must be a subset of the VkBufferCreateInfo::usage specified or VkBufferUsageFlags2CreateInfoKHR::usage from VkBufferCreateInfo::pNext when creating buffer", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBufferUsageFlags2CreateInfoKHR or VkExportMetalObjectCreateInfoEXT", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-range-00928", "If range is not equal to VK_WHOLE_SIZE, range must be greater than 0", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-range-00929", "If range is not equal to VK_WHOLE_SIZE, range must be an integer multiple of the texel block size of format", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-range-00930", "If range is not equal to VK_WHOLE_SIZE, the number of texel buffer elements given by (⌊range / (texel block size)⌋ × (texels per block)) where texel block size and texels per block are as defined in the Compatible Formats table for format, must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-range-04059", "If range is equal to VK_WHOLE_SIZE, the number of texel buffer elements given by (⌊(size - offset) / (texel block size)⌋ × (texels per block)) where size is the size of buffer, and texel block size and texels per block are as defined in the Compatible Formats table for format, must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkBufferViewCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique, with the exception of structures of type VkExportMetalObjectCreateInfoEXT", "1.3-extensions"},
    {"VUID-VkCalibratedTimestampInfoEXT-timeDomain-02354", "timeDomain must be one of the VkTimeDomainKHR values returned by vkGetPhysicalDeviceCalibrateableTimeDomainsKHR", "1.3-extensions"},
    {"VUID-VkCalibratedTimestampInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCalibratedTimestampInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_KHR", "1.3-extensions"},
    {"VUID-VkCalibratedTimestampInfoKHR-timeDomain-parameter", "timeDomain must be a valid VkTimeDomainKHR value", "1.3-extensions"},
    {"VUID-VkCheckpointData2NV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCheckpointData2NV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV", "1.3-extensions"},
    {"VUID-VkCheckpointDataNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCheckpointDataNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV", "1.3-extensions"},
    {"VUID-VkClearAttachment-aspectMask-00019", "If aspectMask includes VK_IMAGE_ASPECT_COLOR_BIT, it must not include VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT", "1.3-extensions"},
    {"VUID-VkClearAttachment-aspectMask-00020", "aspectMask must not include VK_IMAGE_ASPECT_METADATA_BIT", "1.3-extensions"},
    {"VUID-VkClearAttachment-aspectMask-02246", "aspectMask must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i", "1.3-extensions"},
    {"VUID-VkClearAttachment-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values", "1.3-extensions"},
    {"VUID-VkClearAttachment-aspectMask-requiredbitmask", "aspectMask must not be 0", "1.3-extensions"},
    {"VUID-VkClearDepthStencilValue-depth-00022", "Unless the VK_EXT_depth_range_unrestricted extension is enabled depth must be between 0.0 and 1.0, inclusive", "1.3-extensions"},
    {"VUID-VkCoarseSampleLocationNV-pixelX-02078", "pixelX must be less than the width (in pixels) of the fragment", "1.3-extensions"},
    {"VUID-VkCoarseSampleLocationNV-pixelY-02079", "pixelY must be less than the height (in pixels) of the fragment", "1.3-extensions"},
    {"VUID-VkCoarseSampleLocationNV-sample-02080", "sample must be less than the number of coverage samples in each pixel belonging to the fragment", "1.3-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-pSampleLocations-02077", "The array pSampleLocations must contain exactly one entry for every combination of valid values for pixelX, pixelY, and sample in the structure VkCoarseSampleOrderCustomNV", "1.3-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-pSampleLocations-parameter", "pSampleLocations must be a valid pointer to an array of sampleLocationCount VkCoarseSampleLocationNV structures", "1.3-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleCount-02074", "sampleCount must correspond to a sample count enumerated in VkSampleCountFlags whose corresponding bit is set in VkPhysicalDeviceLimits::framebufferNoAttachmentsSampleCounts", "1.3-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-02075", "sampleLocationCount must be equal to the product of sampleCount, the fragment width for shadingRate, and the fragment height for shadingRate", "1.3-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-02076", "sampleLocationCount must be less than or equal to the value of VkPhysicalDeviceShadingRateImagePropertiesNV::shadingRateMaxCoarseSamples", "1.3-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-arraylength", "sampleLocationCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-shadingRate-02073", "shadingRate must be a shading rate that generates fragments with more than one pixel", "1.3-extensions"},
    {"VUID-VkCoarseSampleOrderCustomNV-shadingRate-parameter", "shadingRate must be a valid VkShadingRatePaletteEntryNV value", "1.3-extensions"},
    {"VUID-VkColorBlendAdvancedEXT-advancedBlendOp-parameter", "advancedBlendOp must be a valid VkBlendOp value", "1.3-extensions"},
    {"VUID-VkColorBlendAdvancedEXT-blendOverlap-07507", "If the correlated overlap property is not supported, blendOverlap must be VK_BLEND_OVERLAP_UNCORRELATED_EXT", "1.3-extensions"},
    {"VUID-VkColorBlendAdvancedEXT-blendOverlap-parameter", "blendOverlap must be a valid VkBlendOverlapEXT value", "1.3-extensions"},
    {"VUID-VkColorBlendAdvancedEXT-dstPremultiplied-07506", "If the non-premultiplied destination color property is not supported, dstPremultiplied must be VK_TRUE", "1.3-extensions"},
    {"VUID-VkColorBlendAdvancedEXT-srcPremultiplied-07505", "If the non-premultiplied source color property is not supported, srcPremultiplied must be VK_TRUE", "1.3-extensions"},
    {"VUID-VkColorBlendEquationEXT-alphaBlendOp-parameter", "alphaBlendOp must be a valid VkBlendOp value", "1.3-extensions"},
    {"VUID-VkColorBlendEquationEXT-colorBlendOp-07361", "colorBlendOp and alphaBlendOp must not be a VkBlendOp from VK_EXT_blend_operation_advanced", "1.3-extensions"},
    {"VUID-VkColorBlendEquationEXT-colorBlendOp-parameter", "colorBlendOp must be a valid VkBlendOp value", "1.3-extensions"},
    {"VUID-VkColorBlendEquationEXT-constantAlphaColorBlendFactors-07362", "If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::constantAlphaColorBlendFactors is VK_FALSE, srcColorBlendFactor must not be VK_BLEND_FACTOR_CONSTANT_ALPHA or VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA", "1.3-extensions"},
    {"VUID-VkColorBlendEquationEXT-constantAlphaColorBlendFactors-07363", "If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::constantAlphaColorBlendFactors is VK_FALSE, dstColorBlendFactor must not be VK_BLEND_FACTOR_CONSTANT_ALPHA or VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA", "1.3-extensions"},
    {"VUID-VkColorBlendEquationEXT-dstAlphaBlendFactor-parameter", "dstAlphaBlendFactor must be a valid VkBlendFactor value", "1.3-extensions"},
    {"VUID-VkColorBlendEquationEXT-dstColorBlendFactor-parameter", "dstColorBlendFactor must be a valid VkBlendFactor value", "1.3-extensions"},
    {"VUID-VkColorBlendEquationEXT-dualSrcBlend-07357", "If the dualSrcBlend feature is not enabled, srcColorBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", "1.3-extensions"},
    {"VUID-VkColorBlendEquationEXT-dualSrcBlend-07358", "If the dualSrcBlend feature is not enabled, dstColorBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", "1.3-extensions"},
    {"VUID-VkColorBlendEquationEXT-dualSrcBlend-07359", "If the dualSrcBlend feature is not enabled, srcAlphaBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", "1.3-extensions"},
    {"VUID-VkColorBlendEquationEXT-dualSrcBlend-07360", "If the dualSrcBlend feature is not enabled, dstAlphaBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", "1.3-extensions"},
    {"VUID-VkColorBlendEquationEXT-srcAlphaBlendFactor-parameter", "srcAlphaBlendFactor must be a valid VkBlendFactor value", "1.3-extensions"},
    {"VUID-VkColorBlendEquationEXT-srcColorBlendFactor-parameter", "srcColorBlendFactor must be a valid VkBlendFactor value", "1.3-extensions"},
    {"VUID-VkCommandBufferAllocateInfo-commandPool-parameter", "commandPool must be a valid VkCommandPool handle", "1.3-extensions"},
    {"VUID-VkCommandBufferAllocateInfo-level-parameter", "level must be a valid VkCommandBufferLevel value", "1.3-extensions"},
    {"VUID-VkCommandBufferAllocateInfo-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCommandBufferAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO", "1.3-extensions"},
    {"VUID-VkCommandBufferBeginInfo-flags-00055", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the framebuffer member of pInheritanceInfo must be either VK_NULL_HANDLE, or a valid VkFramebuffer that is compatible with the renderPass member of pInheritanceInfo", "1.3-extensions"},
    {"VUID-VkCommandBufferBeginInfo-flags-06000", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the renderPass member of pInheritanceInfo is not VK_NULL_HANDLE, the renderPass member of pInheritanceInfo must be a valid VkRenderPass", "1.3-extensions"},
    {"VUID-VkCommandBufferBeginInfo-flags-06001", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the renderPass member of pInheritanceInfo is not VK_NULL_HANDLE, the subpass member of pInheritanceInfo must be a valid subpass index within the renderPass member of pInheritanceInfo", "1.3-extensions"},
    {"VUID-VkCommandBufferBeginInfo-flags-06002", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the renderPass member of pInheritanceInfo is VK_NULL_HANDLE, the pNext chain of pInheritanceInfo must include a VkCommandBufferInheritanceRenderingInfo structure", "1.3-extensions"},
    {"VUID-VkCommandBufferBeginInfo-flags-06003", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the renderPass member of pInheritanceInfo is VK_NULL_HANDLE, and the pNext chain of pInheritanceInfo includes a VkAttachmentSampleCountInfoAMD or VkAttachmentSampleCountInfoNV structure, the colorAttachmentCount member of that structure must be equal to the value of VkCommandBufferInheritanceRenderingInfo::colorAttachmentCount", "1.3-extensions"},
    {"VUID-VkCommandBufferBeginInfo-flags-09123", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the VkCommandPool that commandBuffer was allocated from must support graphics operations", "1.3-extensions"},
    {"VUID-VkCommandBufferBeginInfo-flags-09240", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the dynamicRendering feature is not enabled, the renderPass member of pInheritanceInfo must not be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkCommandBufferBeginInfo-flags-parameter", "flags must be a valid combination of VkCommandBufferUsageFlagBits values", "1.3-extensions"},
    {"VUID-VkCommandBufferBeginInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDeviceGroupCommandBufferBeginInfo", "1.3-extensions"},
    {"VUID-VkCommandBufferBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO", "1.3-extensions"},
    {"VUID-VkCommandBufferBeginInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceConditionalRenderingInfoEXT-conditionalRenderingEnable-01977", "If the inheritedConditionalRendering feature is not enabled, conditionalRenderingEnable must be VK_FALSE", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceConditionalRenderingInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-commonparent", "Both of framebuffer, and renderPass that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-occlusionQueryEnable-00056", "If the inheritedQueries feature is not enabled, occlusionQueryEnable must be VK_FALSE", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAttachmentSampleCountInfoAMD, VkCommandBufferInheritanceConditionalRenderingInfoEXT, VkCommandBufferInheritanceRenderPassTransformInfoQCOM, VkCommandBufferInheritanceRenderingInfo, VkCommandBufferInheritanceViewportScissorInfoNV, VkExternalFormatANDROID, VkMultiviewPerViewAttributesInfoNVX, VkRenderingAttachmentLocationInfoKHR, or VkRenderingInputAttachmentIndexInfoKHR", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-pipelineStatistics-00058", "If the pipelineStatisticsQuery feature is not enabled, pipelineStatistics must be 0", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-pipelineStatistics-02789", "If the pipelineStatisticsQuery feature is enabled, pipelineStatistics must be a valid combination of VkQueryPipelineStatisticFlagBits values", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-queryFlags-00057", "If the inheritedQueries feature is enabled, queryFlags must be a valid combination of VkQueryControlFlagBits values", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-queryFlags-02788", "If the inheritedQueries feature is not enabled, queryFlags must be 0", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderPassTransformInfoQCOM-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderPassTransformInfoQCOM-transform-02864", "transform must be VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-colorAttachmentCount-06004", "If colorAttachmentCount is not 0, rasterizationSamples must be a valid VkSampleCountFlagBits value", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-depthAttachmentFormat-06007", "If depthAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-depthAttachmentFormat-06200", "If depthAttachmentFormat is not VK_FORMAT_UNDEFINED and stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, depthAttachmentFormat must equal stencilAttachmentFormat", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-depthAttachmentFormat-06540", "If depthAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format that includes a depth component", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-depthAttachmentFormat-parameter", "depthAttachmentFormat must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-flags-parameter", "flags must be a valid combination of VkRenderingFlagBits values", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-multiview-06008", "If the multiview feature is not enabled, viewMask must be 0", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-pColorAttachmentFormats-06492", "If any element of pColorAttachmentFormats is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT , or VK_FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV if the linearColorAttachment feature is enabled", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-pColorAttachmentFormats-parameter", "If colorAttachmentCount is not 0, pColorAttachmentFormats must be a valid pointer to an array of colorAttachmentCount valid VkFormat values", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-rasterizationSamples-parameter", "If rasterizationSamples is not 0, rasterizationSamples must be a valid VkSampleCountFlagBits value", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-stencilAttachmentFormat-06199", "If stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-stencilAttachmentFormat-06541", "If stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format that includes a stencil aspect", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-stencilAttachmentFormat-parameter", "stencilAttachmentFormat must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-variableMultisampleRate-06005", "If the variableMultisampleRate feature is not enabled, rasterizationSamples must be a valid VkSampleCountFlagBits value", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-viewMask-06009", "The index of the most significant bit in viewMask must be less than maxMultiviewViewCount", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04782", "If the inheritedViewportScissor2D feature is not enabled, viewportScissor2D must be VK_FALSE", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04783", "If the multiViewport feature is not enabled and viewportScissor2D is VK_TRUE, then viewportDepthCount must be 1", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04784", "If viewportScissor2D is VK_TRUE, then viewportDepthCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04785", "If viewportScissor2D is VK_TRUE, then pViewportDepths must be a valid pointer to an array of viewportDepthCount valid VkViewport structures, except any requirements on x, y, width, and height do not apply", "1.3-extensions"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04786", "If viewportScissor2D is VK_TRUE, then the command buffer must be recorded with the VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT", "1.3-extensions"},
    {"VUID-VkCommandBufferSubmitInfo-commandBuffer-03890", "commandBuffer must not have been allocated with VK_COMMAND_BUFFER_LEVEL_SECONDARY", "1.3-extensions"},
    {"VUID-VkCommandBufferSubmitInfo-commandBuffer-09445", "If any render pass instance in commandBuffer was recorded with a VkRenderPassStripeBeginInfoARM structure in its pNext chain and did not specify the VK_RENDERING_RESUMING_BIT flag, a VkRenderPassStripeSubmitInfoARM must be included in the pNext chain", "1.3-extensions"},
    {"VUID-VkCommandBufferSubmitInfo-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle", "1.3-extensions"},
    {"VUID-VkCommandBufferSubmitInfo-deviceMask-03891", "If deviceMask is not 0, it must be a valid device mask", "1.3-extensions"},
    {"VUID-VkCommandBufferSubmitInfo-pNext-09446", "If a VkRenderPassStripeSubmitInfoARM is included in the pNext chain, the value of VkRenderPassStripeSubmitInfoARM::stripeSemaphoreInfoCount must be equal to the sum of the VkRenderPassStripeBeginInfoARM::stripeInfoCount parameters provided to render pass instances recorded in commandBuffer that did not specify the VK_RENDERING_RESUMING_BIT flag", "1.3-extensions"},
    {"VUID-VkCommandBufferSubmitInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkRenderPassStripeSubmitInfoARM", "1.3-extensions"},
    {"VUID-VkCommandBufferSubmitInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO", "1.3-extensions"},
    {"VUID-VkCommandBufferSubmitInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkCommandPoolCreateInfo-flags-02860", "If the protectedMemory feature is not enabled, the VK_COMMAND_POOL_CREATE_PROTECTED_BIT bit of flags must not be set", "1.3-extensions"},
    {"VUID-VkCommandPoolCreateInfo-flags-parameter", "flags must be a valid combination of VkCommandPoolCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkCommandPoolCreateInfo-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCommandPoolCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkComponentMapping-a-parameter", "a must be a valid VkComponentSwizzle value", "1.3-extensions"},
    {"VUID-VkComponentMapping-b-parameter", "b must be a valid VkComponentSwizzle value", "1.3-extensions"},
    {"VUID-VkComponentMapping-g-parameter", "g must be a valid VkComponentSwizzle value", "1.3-extensions"},
    {"VUID-VkComponentMapping-r-parameter", "r must be a valid VkComponentSwizzle value", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-None-09497", "If the pNext chain does not include a VkPipelineCreateFlags2CreateInfoKHR structure, flags must be a valid combination of VkPipelineCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-commonparent", "Both of basePipelineHandle, and layout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03365", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03366", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03367", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03368", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03369", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03370", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-03576", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-04945", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-07367", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-07984", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid compute VkPipeline handle", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-07985", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-07986", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, basePipelineIndex must be -1 or basePipelineHandle must be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-07996", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-09007", "If the VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputePipelines is not enabled, flags must not include VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-09008", "If flags includes VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then the pNext chain must include a pointer to a valid instance of VkComputePipelineIndirectBufferInfoNV specifying the address where the pipeline's metadata will be saved", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-flags-09178", "If flags does not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, the shader specified by stage must not declare the ShaderEnqueueAMDX capability", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-layout-01687", "The number of resources in layout accessible to the compute shader stage must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-layout-07987", "If a push constant block is declared in a shader, a push constant range in layout must match both the shader stage and range", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-layout-07988", "If a resource variables is declared in a shader, a descriptor slot in layout must match the shader stage", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-layout-07990", "If a resource variables is declared in a shader, and the descriptor type is not VK_DESCRIPTOR_TYPE_MUTABLE_EXT, a descriptor slot in layout must match the descriptor type", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-layout-07991", "If a resource variables is declared in a shader as an array, a descriptor slot in layout must match the descriptor count", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-layout-parameter", "layout must be a valid VkPipelineLayout handle", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkComputePipelineIndirectBufferInfoNV, VkPipelineCompilerControlCreateInfoAMD, VkPipelineCreateFlags2CreateInfoKHR, VkPipelineCreationFeedbackCreateInfo, VkPipelineRobustnessCreateInfoEXT, or VkSubpassShadingPipelineCreateInfoHUAWEI", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-pipelineCreationCacheControl-02875", "If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT or VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-pipelineStageCreationFeedbackCount-06566", "If VkPipelineCreationFeedbackCreateInfo::pipelineStageCreationFeedbackCount is not 0, it must be 1", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-shaderEnqueue-09177", "If shaderEnqueue is not enabled, flags must not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-stage-00701", "The stage member of stage must be VK_SHADER_STAGE_COMPUTE_BIT", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-stage-00702", "The shader code for the entry point identified by stage and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter", "1.3-extensions"},
    {"VUID-VkComputePipelineCreateInfo-stage-parameter", "stage must be a valid VkPipelineShaderStageCreateInfo structure", "1.3-extensions"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-deviceAddress-09011", "deviceAddress must be aligned to the VkMemoryRequirements2::alignment, as returned by vkGetPipelineIndirectMemoryRequirementsNV", "1.3-extensions"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-deviceAddress-09012", "deviceAddress must have been allocated from a buffer that was created with usage VK_BUFFER_USAGE_TRANSFER_DST_BIT and VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT", "1.3-extensions"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-deviceGeneratedComputePipelines-09009", "The VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputePipelines feature must be enabled", "1.3-extensions"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-flags-09010", "The pipeline creation flags in VkComputePipelineCreateInfo::flags must include VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "1.3-extensions"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-pipelineDeviceAddressCaptureReplay-09014", "If pipelineDeviceAddressCaptureReplay is non-zero then the VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputeCaptureReplay feature must be enabled", "1.3-extensions"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-pipelineDeviceAddressCaptureReplay-09015", "If pipelineDeviceAddressCaptureReplay is non-zero then that address must have been allocated with flag VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT set", "1.3-extensions"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-pipelineDeviceAddressCaptureReplay-09016", "If pipelineDeviceAddressCaptureReplay is non-zero, the pipeline must have been recreated for replay", "1.3-extensions"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-pipelineDeviceAddressCaptureReplay-09017", "pipelineDeviceAddressCaptureReplay must satisfy the alignment and size requirements similar to deviceAddress", "1.3-extensions"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_INDIRECT_BUFFER_INFO_NV", "1.3-extensions"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-size-09013", "size must be greater than or equal to the VkMemoryRequirements2::size, as returned by vkGetPipelineIndirectMemoryRequirementsNV", "1.3-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-01981", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-01982", "buffer must have been created with the VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT bit set", "1.3-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-flags-parameter", "flags must be a valid combination of VkConditionalRenderingFlagBitsEXT values", "1.3-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-offset-01983", "offset must be less than the size of buffer by at least 32 bits", "1.3-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-offset-01984", "offset must be a multiple of 4", "1.3-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT", "1.3-extensions"},
    {"VUID-VkCooperativeMatrixPropertiesKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCooperativeMatrixPropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_KHR", "1.3-extensions"},
    {"VUID-VkCooperativeMatrixPropertiesNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCooperativeMatrixPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-buffer-03718", "The buffer used to create src must be bound to device memory", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-buffer-03719", "The buffer used to create dst must be bound to device memory", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-commonparent", "Both of dst, and src must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-dst-07791", "The range of memory backing dst that is accessed by this command must not overlap the memory backing src that is accessed by this command", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-dst-parameter", "dst must be a valid VkAccelerationStructureKHR handle", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-mode-03410", "mode must be VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR or VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-mode-parameter", "mode must be a valid VkCopyAccelerationStructureModeKHR value", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-src-03411", "If mode is VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR, src must have been constructed with VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR in the build", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-src-04963", "The source acceleration structure src must have been constructed prior to the execution of this command", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-src-parameter", "src must be a valid VkAccelerationStructureKHR handle", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-dst-03561", "The memory pointed to by dst must be at least as large as the serialization size of src, as reported by vkWriteAccelerationStructuresPropertiesKHR or vkCmdWriteAccelerationStructuresPropertiesKHR with a query type of VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-mode-03412", "mode must be VK_COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-mode-parameter", "mode must be a valid VkCopyAccelerationStructureModeKHR value", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-src-04959", "The source acceleration structure src must have been constructed prior to the execution of this command", "1.3-extensions"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-src-parameter", "src must be a valid VkAccelerationStructureKHR handle", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-commonparent", "Both of dstBuffer, and srcBuffer must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-dstBuffer-00120", "dstBuffer must have been created with VK_BUFFER_USAGE_TRANSFER_DST_BIT usage flag", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-dstBuffer-00121", "If dstBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-dstBuffer-parameter", "dstBuffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-dstOffset-00114", "The dstOffset member of each element of pRegions must be less than the size of dstBuffer", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-pRegions-00117", "The union of the source regions, and the union of the destination regions, specified by the elements of pRegions, must not overlap in memory", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkBufferCopy2 structures", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-regionCount-arraylength", "regionCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-size-00115", "The size member of each element of pRegions must be less than or equal to the size of srcBuffer minus srcOffset", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-size-00116", "The size member of each element of pRegions must be less than or equal to the size of dstBuffer minus dstOffset", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-srcBuffer-00118", "srcBuffer must have been created with VK_BUFFER_USAGE_TRANSFER_SRC_BIT usage flag", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-srcBuffer-00119", "If srcBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-srcBuffer-parameter", "srcBuffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkCopyBufferInfo2-srcOffset-00113", "The srcOffset member of each element of pRegions must be less than the size of srcBuffer", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-bufferImageHeight-09107", "For each element of pRegions, bufferImageHeight must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-bufferRowLength-09106", "For each element of pRegions, bufferRowLength must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-bufferRowLength-09108", "For each element of pRegions, bufferRowLength divided by the texel block extent width and then multiplied by the texel block size of dstImage must be less than or equal to 231-1", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-commonparent", "Both of dstImage, and srcBuffer must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-00177", "dstImage must have been created with VK_IMAGE_USAGE_TRANSFER_DST_BIT usage flag", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-00207", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of imageOffset.x and extent.width does not equal the width of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-00208", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of imageOffset.y and extent.height does not equal the height of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-00209", "For each element of pRegions, if the sum of imageOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-01997", "The format features of dstImage must contain VK_FORMAT_FEATURE_TRANSFER_DST_BIT", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07274", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07275", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07276", "For each element of pRegions, imageOffset.z must be a multiple of the texel block extent depth of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07966", "If dstImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07969", "dstImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07973", "dstImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07975", "If dstImage does not have either a depth/stencil format or a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the texel block size", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07976", "If dstImage has a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the element size of the compatible format for the format and the aspectMask of the imageSubresource as defined in Compatible Formats of Planes of Multi-Planar Formats", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07978", "If dstImage has a depth/stencil format, the bufferOffset member of any element of pRegions must be a multiple of 4", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07979", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, imageOffset.y must be 0 and imageExtent.height must be 1", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07980", "If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, imageOffset.z must be 0 and imageExtent.depth must be 1", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07981", "If dstImage has a multi-planar image format, then for each element of pRegions, imageSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07983", "If dstImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, imageSubresource.baseArrayLayer must be 0 and imageSubresource.layerCount must be 1", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-parameter", "dstImage must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImageLayout-00180", "dstImageLayout must specify the layout of the image subresources of dstImage specified in pRegions at the time this command is executed on a VkDevice", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImageLayout-01396", "dstImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL, or VK_IMAGE_LAYOUT_GENERAL", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-dstImageLayout-parameter", "dstImageLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-09104", "For each element of pRegions, imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified imageSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10051", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and imageOffset.x does not equal the width of the subresource specified by imageSubresource, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10052", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and imageOffset.y does not equal the height of the subresource specified by imageSubresource, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10053", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of imageOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10054", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10055", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of imageOffset.x and extent.height does not equal the width of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10056", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of imageOffset.y and extent.width does not equal the height of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10057", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10058", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of imageOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-imageSubresource-07967", "The imageSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-imageSubresource-07968", "If imageSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, imageSubresource.baseArrayLayer + imageSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-imageSubresource-09105", "For each element of pRegions, imageSubresource.aspectMask must specify aspects present in dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-pRegions-00171", "srcBuffer must be large enough to contain all buffer locations that are accessed according to Buffer and Image Addressing, for each element of pRegions", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-pRegions-00173", "The union of all source regions, and the union of all destination regions, specified by the elements of pRegions, must not overlap in memory", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-pRegions-04565", "The image region specified by each element of pRegions that does not contain VkCopyCommandTransformInfoQCOM in its pNext chain must be contained within the specified imageSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-pRegions-06223", "For each element of pRegions not containing VkCopyCommandTransformInfoQCOM in its pNext chain, imageOffset.x and (imageExtent.width + imageOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified imageSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-pRegions-06224", "For each element of pRegions not containing VkCopyCommandTransformInfoQCOM in its pNext chain, imageOffset.y and (imageExtent.height + imageOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified imageSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-pRegions-07931", "If VK_EXT_depth_range_unrestricted is not enabled, for each element of pRegions whose imageSubresource contains a depth aspect, the data in srcBuffer must be in the range [0,1]", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkBufferImageCopy2 structures", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-regionCount-arraylength", "regionCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-srcBuffer-00174", "srcBuffer must have been created with VK_BUFFER_USAGE_TRANSFER_SRC_BIT usage flag", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-srcBuffer-00176", "If srcBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2-srcBuffer-parameter", "srcBuffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-04554", "If the image region specified by each element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, the rotated destination region as described in [copies-buffers-images-rotation-addressing] must be contained within dstImage", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-04555", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then dstImage must have a 1x1x1 texel block extent", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-06203", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then dstImage must be of type VK_IMAGE_TYPE_2D", "1.3-extensions"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-06204", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then dstImage must not have a multi-planar format", "1.3-extensions"},
    {"VUID-VkCopyCommandTransformInfoQCOM-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM", "1.3-extensions"},
    {"VUID-VkCopyCommandTransformInfoQCOM-transform-04560", "transform must be VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-commonparent", "Both of dstSet, and srcSet must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-dstArrayElement-00348", "The sum of dstArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding specified by dstBinding, and all applicable consecutive bindings, as described by consecutive binding updates", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-dstBinding-00347", "dstBinding must be a valid binding within dstSet", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-dstBinding-02224", "If the descriptor type of the descriptor set binding specified by dstBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, dstArrayElement must be an integer multiple of 4", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-dstBinding-02632", "The type of dstBinding within dstSet must be equal to the type of srcBinding within srcSet", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-dstBinding-02753", "If the descriptor type of the descriptor set binding specified by dstBinding is VK_DESCRIPTOR_TYPE_SAMPLER, then dstSet must not have been allocated with a layout that included immutable samplers for dstBinding", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-dstSet-04612", "If VkDescriptorSetLayoutBinding for dstSet at dstBinding is VK_DESCRIPTOR_TYPE_MUTABLE_EXT, the new active descriptor type must exist in the corresponding pMutableDescriptorTypeLists list for dstBinding if the new active descriptor type is not VK_DESCRIPTOR_TYPE_MUTABLE_EXT", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-dstSet-04614", "If VkDescriptorSetLayoutBinding for dstSet at dstBinding is VK_DESCRIPTOR_TYPE_MUTABLE_EXT, and the new active descriptor type is VK_DESCRIPTOR_TYPE_MUTABLE_EXT, the pMutableDescriptorTypeLists for srcBinding and dstBinding must match exactly", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-dstSet-parameter", "dstSet must be a valid VkDescriptorSet handle", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-srcArrayElement-00346", "The sum of srcArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding specified by srcBinding, and all applicable consecutive bindings, as described by consecutive binding updates", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-srcBinding-00345", "srcBinding must be a valid binding within srcSet", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-srcBinding-02223", "If the descriptor type of the descriptor set binding specified by srcBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, srcArrayElement must be an integer multiple of 4", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-srcBinding-02225", "If the descriptor type of the descriptor set binding specified by either srcBinding or dstBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, descriptorCount must be an integer multiple of 4", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-00349", "If srcSet is equal to dstSet, then the source and destination ranges of descriptors must not overlap, where the ranges may include array elements from consecutive bindings as described by consecutive binding updates", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-01918", "If srcSet's layout was created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set, then dstSet's layout must also have been created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-01920", "If the descriptor pool from which srcSet was allocated was created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set, then the descriptor pool from which dstSet was allocated must also have been created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-04613", "If VkDescriptorSetLayoutBinding for srcSet at srcBinding is VK_DESCRIPTOR_TYPE_MUTABLE_EXT and the VkDescriptorSetLayoutBinding for dstSet at dstBinding is not VK_DESCRIPTOR_TYPE_MUTABLE_EXT, the active descriptor type for the source descriptor must match the descriptor type of dstBinding", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-04885", "If srcSet's layout was created without either the VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT flag or the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set, then dstSet's layout must have been created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-04887", "If the descriptor pool from which srcSet was allocated was created without either the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT flag or the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set, then the descriptor pool from which dstSet was allocated must have been created without the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set", "1.3-extensions"},
    {"VUID-VkCopyDescriptorSet-srcSet-parameter", "srcSet must be a valid VkDescriptorSet handle", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-None-01549", "In a copy to or from a plane of a multi-planar image, the VkFormat of the image and plane must be compatible according to the description of compatible planes for the plane being copied", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-apiVersion-07932", "If the VK_KHR_maintenance1 extension is not enabled, or VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, and either srcImage or dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer and dstSubresource.baseArrayLayer must both be 0, and srcSubresource.layerCount and dstSubresource.layerCount must both be 1", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-apiVersion-07933", "If the VK_KHR_maintenance1 extension is not enabled, and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, srcImage and dstImage must have the same VkImageType", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-apiVersion-08969", "If the VK_KHR_maintenance1 extension is not enabled, and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, srcImage or dstImage is of type VK_IMAGE_TYPE_2D, then for each element of pRegions, extent.depth must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-aspect-06662", "If the aspect member of any element of pRegions includes any flag other than VK_IMAGE_ASPECT_STENCIL_BIT or srcImage was not created with separate stencil usage, VK_IMAGE_USAGE_TRANSFER_SRC_BIT must have been included in the VkImageCreateInfo::usage used to create srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-aspect-06663", "If the aspect member of any element of pRegions includes any flag other than VK_IMAGE_ASPECT_STENCIL_BIT or dstImage was not created with separate stencil usage, VK_IMAGE_USAGE_TRANSFER_DST_BIT must have been included in the VkImageCreateInfo::usage used to create dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-aspect-06664", "If the aspect member of any element of pRegions includes VK_IMAGE_ASPECT_STENCIL_BIT, and srcImage was created with separate stencil usage, VK_IMAGE_USAGE_TRANSFER_SRC_BIT must have been included in the VkImageStencilUsageCreateInfo::stencilUsage used to create srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-aspect-06665", "If the aspect member of any element of pRegions includes VK_IMAGE_ASPECT_STENCIL_BIT, and dstImage was created with separate stencil usage, VK_IMAGE_USAGE_TRANSFER_DST_BIT must have been included in the VkImageStencilUsageCreateInfo::stencilUsage used to create dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-aspectMask-00142", "For each element of pRegions, srcSubresource.aspectMask must specify aspects present in srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-aspectMask-00143", "For each element of pRegions, dstSubresource.aspectMask must specify aspects present in dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-commonparent", "Both of dstImage, and srcImage must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImage-00152", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffset.y must be 0 and extent.height must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImage-01557", "If dstImage has a multi-planar image format and the srcImage does not have a multi-planar image format, then for each element of pRegions, srcSubresource.aspectMask must be VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImage-01732", "For each element of pRegions, if the sum of dstOffset.x and extent.width does not equal the width of the subresource specified by dstSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImage-01733", "For each element of pRegions, if the sum of dstOffset.y and extent.height does not equal the height of the subresource specified by dstSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImage-01734", "For each element of pRegions, if the sum of dstOffset.z and extent.depth does not equal the depth of the subresource specified by dstSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImage-01786", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffset.z must be 0 and extent.depth must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImage-01788", "If dstImage is of type VK_IMAGE_TYPE_2D, then for each element of pRegions, dstOffset.z must be 0", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImage-01792", "If dstImage is of type VK_IMAGE_TYPE_2D, and srcImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, extent.depth must equal dstSubresource.layerCount", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImage-01996", "The format features of dstImage must contain VK_FORMAT_FEATURE_TRANSFER_DST_BIT", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImage-04444", "If dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, dstSubresource.baseArrayLayer must be 0 and dstSubresource.layerCount must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImage-07966", "If dstImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImage-07969", "dstImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImage-08714", "If dstImage has a multi-planar image format, then for each element of pRegions, dstSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImage-parameter", "dstImage must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImageLayout-00133", "dstImageLayout must specify the layout of the image subresources of dstImage specified in pRegions at the time this command is executed on a VkDevice", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImageLayout-01395", "dstImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL, or VK_IMAGE_LAYOUT_GENERAL", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstImageLayout-parameter", "dstImageLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstOffset-00150", "For each element of pRegions, dstOffset.x and (extent.width + dstOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified dstSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstOffset-00151", "For each element of pRegions, dstOffset.y and (extent.height + dstOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified dstSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstOffset-00153", "If dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, dstOffset.z and (extent.depth + dstOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified dstSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstOffset-01784", "The dstOffset and extent members of each element of pRegions must respect the image transfer granularity requirements of commandBuffer's command pool's queue family, as described in VkQueueFamilyProperties", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstSubresource-07967", "The dstSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-dstSubresource-07968", "If dstSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, dstSubresource.baseArrayLayer + dstSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-pRegions-00124", "The union of all source regions, and the union of all destination regions, specified by the elements of pRegions, must not overlap in memory", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-pRegions-07278", "For each element of pRegions, srcOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-pRegions-07279", "For each element of pRegions, srcOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-pRegions-07280", "For each element of pRegions, srcOffset.z must be a multiple of the texel block extent depth of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-pRegions-07281", "For each element of pRegions, dstOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-pRegions-07282", "For each element of pRegions, dstOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-pRegions-07283", "For each element of pRegions, dstOffset.z must be a multiple of the texel block extent depth of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkImageCopy2 structures", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-regionCount-arraylength", "regionCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-00136", "The sample count of srcImage and dstImage must match", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-00146", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffset.y must be 0 and extent.height must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-01548", "If the VkFormat of each of srcImage and dstImage is not a multi-planar format, the VkFormat of each of srcImage and dstImage must be size-compatible", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-01551", "If neither srcImage nor dstImage has a multi-planar image format then for each element of pRegions, srcSubresource.aspectMask and dstSubresource.aspectMask must match", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-01556", "If srcImage has a multi-planar image format and the dstImage does not have a multi-planar image format, then for each element of pRegions, dstSubresource.aspectMask must be VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-01728", "For each element of pRegions, if the sum of srcOffset.x and extent.width does not equal the width of the subresource specified by srcSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-01729", "For each element of pRegions, if the sum of srcOffset.y and extent.height does not equal the height of the subresource specified by srcSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-01730", "For each element of pRegions, if the sum of srcOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-01785", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffset.z must be 0 and extent.depth must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-01787", "If srcImage is of type VK_IMAGE_TYPE_2D, then for each element of pRegions, srcOffset.z must be 0", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-01790", "If srcImage and dstImage are both of type VK_IMAGE_TYPE_2D, then for each element of pRegions, extent.depth must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-01791", "If srcImage is of type VK_IMAGE_TYPE_2D, and dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, extent.depth must equal srcSubresource.layerCount", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-01995", "The format features of srcImage must contain VK_FORMAT_FEATURE_TRANSFER_SRC_BIT", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-04443", "If srcImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer must be 0 and srcSubresource.layerCount must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-07743", "If srcImage and dstImage have a different VkImageType, and maintenance5 is not enabled, one must be VK_IMAGE_TYPE_3D and the other must be VK_IMAGE_TYPE_2D", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-07966", "If srcImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-07969", "srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-08713", "If srcImage has a multi-planar image format, then for each element of pRegions, srcSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-08793", "If srcImage and dstImage have the same VkImageType, for each element of pRegions, if neither of the layerCount members of srcSubresource or dstSubresource are VK_REMAINING_ARRAY_LAYERS, the layerCount members of srcSubresource or dstSubresource must match", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-08794", "If srcImage and dstImage have the same VkImageType, and one of the layerCount members of srcSubresource or dstSubresource is VK_REMAINING_ARRAY_LAYERS, the other member must be either VK_REMAINING_ARRAY_LAYERS or equal to the arrayLayers member of the VkImageCreateInfo used to create the image minus baseArrayLayer", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-09247", "If the VkFormat of each of srcImage and dstImage is a compressed image format, the formats must have the same texel block extent", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-09460", "If srcImage and dstImage are the same, and any elements of pRegions contains the srcSubresource and dstSubresource with matching mipLevel and overlapping array layers, then the srcImageLayout and dstImageLayout must be VK_IMAGE_LAYOUT_GENERAL or VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImage-parameter", "srcImage must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImageLayout-00128", "srcImageLayout must specify the layout of the image subresources of srcImage specified in pRegions at the time this command is executed on a VkDevice", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImageLayout-01917", "srcImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL, or VK_IMAGE_LAYOUT_GENERAL", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcImageLayout-parameter", "srcImageLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcOffset-00144", "For each element of pRegions, srcOffset.x and (extent.width + srcOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified srcSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcOffset-00145", "For each element of pRegions, srcOffset.y and (extent.height + srcOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified srcSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcOffset-00147", "If srcImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcOffset.z and (extent.depth + srcOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified srcSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcOffset-01783", "The srcOffset and extent members of each element of pRegions must respect the image transfer granularity requirements of commandBuffer's command pool's queue family, as described in VkQueueFamilyProperties", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcSubresource-07967", "The srcSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", "1.3-extensions"},
    {"VUID-VkCopyImageInfo2-srcSubresource-07968", "If srcSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, srcSubresource.baseArrayLayer + srcSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-bufferImageHeight-09107", "For each element of pRegions, bufferImageHeight must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-bufferRowLength-09106", "For each element of pRegions, bufferRowLength must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-bufferRowLength-09108", "For each element of pRegions, bufferRowLength divided by the texel block extent width and then multiplied by the texel block size of srcImage must be less than or equal to 231-1", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-commonparent", "Both of dstBuffer, and srcImage must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-dstBuffer-00191", "dstBuffer must have been created with VK_BUFFER_USAGE_TRANSFER_DST_BIT usage flag", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-dstBuffer-00192", "If dstBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-dstBuffer-parameter", "dstBuffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-00197", "For each element of pRegions not containing VkCopyCommandTransformInfoQCOM in its pNext chain, imageOffset.x and (imageExtent.width + imageOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified imageSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-00198", "For each element of pRegions not containing VkCopyCommandTransformInfoQCOM in its pNext chain, imageOffset.y and (imageExtent.height + imageOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified imageSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-09104", "For each element of pRegions, imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified imageSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10051", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and imageOffset.x does not equal the width of the subresource specified by imageSubresource, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10052", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and imageOffset.y does not equal the height of the subresource specified by imageSubresource, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10053", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of imageOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10054", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10055", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of imageOffset.x and extent.height does not equal the width of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10056", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of imageOffset.y and extent.width does not equal the height of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10057", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10058", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of imageOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-imageSubresource-07967", "The imageSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-imageSubresource-07968", "If imageSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, imageSubresource.baseArrayLayer + imageSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-imageSubresource-09105", "For each element of pRegions, imageSubresource.aspectMask must specify aspects present in srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-pRegions-00183", "dstBuffer must be large enough to contain all buffer locations that are accessed according to Buffer and Image Addressing, for each element of pRegions", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-pRegions-00184", "The union of all source regions, and the union of all destination regions, specified by the elements of pRegions, must not overlap in memory", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-pRegions-04566", "The image region specified by each element of pRegions that does not contain VkCopyCommandTransformInfoQCOM in its pNext chain must be contained within the specified imageSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkBufferImageCopy2 structures", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-regionCount-arraylength", "regionCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-00186", "srcImage must have been created with VK_IMAGE_USAGE_TRANSFER_SRC_BIT usage flag", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-00207", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of imageOffset.x and extent.width does not equal the width of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-00208", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of imageOffset.y and extent.height does not equal the height of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-00209", "For each element of pRegions, if the sum of imageOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-01998", "The format features of srcImage must contain VK_FORMAT_FEATURE_TRANSFER_SRC_BIT", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07274", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07275", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07276", "For each element of pRegions, imageOffset.z must be a multiple of the texel block extent depth of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07966", "If srcImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07969", "srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07973", "srcImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07975", "If srcImage does not have either a depth/stencil format or a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the texel block size", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07976", "If srcImage has a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the element size of the compatible format for the format and the aspectMask of the imageSubresource as defined in Compatible Formats of Planes of Multi-Planar Formats", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07978", "If srcImage has a depth/stencil format, the bufferOffset member of any element of pRegions must be a multiple of 4", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07979", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, imageOffset.y must be 0 and imageExtent.height must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07980", "If srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, imageOffset.z must be 0 and imageExtent.depth must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07981", "If srcImage has a multi-planar image format, then for each element of pRegions, imageSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07983", "If srcImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, imageSubresource.baseArrayLayer must be 0 and imageSubresource.layerCount must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-parameter", "srcImage must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImageLayout-00189", "srcImageLayout must specify the layout of the image subresources of srcImage specified in pRegions at the time this command is executed on a VkDevice", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImageLayout-01397", "srcImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL, or VK_IMAGE_LAYOUT_GENERAL", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2-srcImageLayout-parameter", "srcImageLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-04557", "If the image region specified by each element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, the rotated source region as described in [copies-buffers-images-rotation-addressing] must be contained within srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-04558", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must have a 1x1x1 texel block extent", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-06205", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must be of type VK_IMAGE_TYPE_2D", "1.3-extensions"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-06206", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must not have a multi-planar format", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-commonparent", "Both of dstImage, and srcImage must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-00207", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of dstOffset.x and extent.width does not equal the width of the subresource specified by dstSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-00208", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of dstOffset.y and extent.height does not equal the height of the subresource specified by dstSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-00209", "For each element of pRegions, if the sum of dstOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-07274", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, dstOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-07275", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, dstOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-07276", "For each element of pRegions, dstOffset.z must be a multiple of the texel block extent depth of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-07966", "If dstImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-07969", "dstImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-07979", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffset.y must be 0 and extent.height must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-07980", "If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, dstOffset.z must be 0 and extent.depth must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-07981", "If dstImage has a multi-planar image format, then for each element of pRegions, dstSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-07983", "If dstImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, dstSubresource.baseArrayLayer must be 0 and dstSubresource.layerCount must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-09109", "If dstImage is sparse then all memory ranges accessed by the copy command must be bound as described in Binding Resource Memory", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-09111", "If the stencil aspect of dstImage is accessed, and dstImage was not created with separate stencil usage, dstImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT set in VkImageCreateInfo::usage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-09112", "If the stencil aspect of dstImage is accessed, and dstImage was created with separate stencil usage, dstImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT set in VkImageStencilUsageCreateInfo::stencilUsage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-09113", "If non-stencil aspects of dstImage are accessed, dstImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT set in VkImageCreateInfo::usage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-09115", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_EXT, the extent member of each element of pRegions must equal the extents of dstImage identified by dstSubresource", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImage-parameter", "dstImage must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImageLayout-09071", "dstImageLayout must specify the current layout of the image subresources of dstImage specified in pRegions", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImageLayout-09073", "dstImageLayout must be one of the image layouts returned in VkPhysicalDeviceHostImageCopyPropertiesEXT::pCopyDstLayouts", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstImageLayout-parameter", "dstImageLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstOffset-09104", "For each element of pRegions, dstOffset.z and (extent.depth + dstOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified dstSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstOffset-09114", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_EXT, the x, y, and z members of the dstOffset member of each element of pRegions must be 0", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstOffset-10051", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and dstOffset.x does not equal the width of the subresource specified by dstSubresource, dstOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstOffset-10052", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and dstOffset.y does not equal the height of the subresource specified by dstSubresource, dstOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstOffset-10053", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of dstOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstOffset-10054", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of dstOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstOffset-10055", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of dstOffset.x and extent.height does not equal the width of the subresource specified by dstSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstOffset-10056", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of dstOffset.y and extent.width does not equal the height of the subresource specified by dstSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstOffset-10057", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of dstOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstOffset-10058", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of dstOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstSubresource-07967", "The dstSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstSubresource-07968", "If dstSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, dstSubresource.baseArrayLayer + dstSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstSubresource-07970", "The image region specified by each element of pRegions must be contained within the specified dstSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstSubresource-07971", "For each element of pRegions, dstOffset.x and (extent.width + dstOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified dstSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstSubresource-07972", "For each element of pRegions, dstOffset.y and (extent.height + dstOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified dstSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-dstSubresource-09105", "For each element of pRegions, dstSubresource.aspectMask must specify aspects present in dstImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-flags-parameter", "flags must be a valid combination of VkHostImageCopyFlagBitsEXT values", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkImageCopy2 structures", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-regionCount-arraylength", "regionCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-00207", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of srcOffset.x and extent.width does not equal the width of the subresource specified by srcSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-00208", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of srcOffset.y and extent.height does not equal the height of the subresource specified by srcSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-00209", "For each element of pRegions, if the sum of srcOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-07274", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, srcOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-07275", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, srcOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-07276", "For each element of pRegions, srcOffset.z must be a multiple of the texel block extent depth of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-07966", "If srcImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-07969", "srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-07979", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffset.y must be 0 and extent.height must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-07980", "If srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, srcOffset.z must be 0 and extent.depth must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-07981", "If srcImage has a multi-planar image format, then for each element of pRegions, srcSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-07983", "If srcImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, srcSubresource.baseArrayLayer must be 0 and srcSubresource.layerCount must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-09069", "srcImage and dstImage must have been created with identical image creation parameters", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-09109", "If srcImage is sparse then all memory ranges accessed by the copy command must be bound as described in Binding Resource Memory", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-09111", "If the stencil aspect of srcImage is accessed, and srcImage was not created with separate stencil usage, srcImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT set in VkImageCreateInfo::usage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-09112", "If the stencil aspect of srcImage is accessed, and srcImage was created with separate stencil usage, srcImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT set in VkImageStencilUsageCreateInfo::stencilUsage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-09113", "If non-stencil aspects of srcImage are accessed, srcImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT set in VkImageCreateInfo::usage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-09115", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_EXT, the extent member of each element of pRegions must equal the extents of srcImage identified by srcSubresource", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImage-parameter", "srcImage must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImageLayout-09070", "srcImageLayout must specify the current layout of the image subresources of srcImage specified in pRegions", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImageLayout-09072", "srcImageLayout must be one of the image layouts returned in VkPhysicalDeviceHostImageCopyPropertiesEXT::pCopySrcLayouts", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcImageLayout-parameter", "srcImageLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcOffset-09104", "For each element of pRegions, srcOffset.z and (extent.depth + srcOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified srcSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcOffset-09114", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_EXT, the x, y, and z members of the srcOffset member of each element of pRegions must be 0", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcOffset-10051", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and srcOffset.x does not equal the width of the subresource specified by srcSubresource, srcOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcOffset-10052", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and srcOffset.y does not equal the height of the subresource specified by srcSubresource, srcOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcOffset-10053", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of srcOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcOffset-10054", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of srcOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcOffset-10055", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of srcOffset.x and extent.height does not equal the width of the subresource specified by srcSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcOffset-10056", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of srcOffset.y and extent.width does not equal the height of the subresource specified by srcSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcOffset-10057", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of srcOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcOffset-10058", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of srcOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcSubresource-07967", "The srcSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcSubresource-07968", "If srcSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, srcSubresource.baseArrayLayer + srcSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcSubresource-07970", "The image region specified by each element of pRegions must be contained within the specified srcSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcSubresource-07971", "For each element of pRegions, srcOffset.x and (extent.width + srcOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified srcSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcSubresource-07972", "For each element of pRegions, srcOffset.y and (extent.height + srcOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified srcSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToImageInfoEXT-srcSubresource-09105", "For each element of pRegions, srcSubresource.aspectMask must specify aspects present in srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-flags-09394", "If flags includes VK_HOST_IMAGE_COPY_MEMCPY_EXT, for each region in pRegions, memoryRowLength and memoryImageHeight must both be 0", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-flags-parameter", "flags must be a valid combination of VkHostImageCopyFlagBitsEXT values", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageOffset-09104", "For each element of pRegions, imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified imageSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageOffset-09114", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_EXT, the x, y, and z members of the imageOffset member of each element of pRegions must be 0", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageOffset-10051", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and imageOffset.x does not equal the width of the subresource specified by imageSubresource, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageOffset-10052", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and imageOffset.y does not equal the height of the subresource specified by imageSubresource, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageOffset-10053", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of imageOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageOffset-10054", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageOffset-10055", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of imageOffset.x and extent.height does not equal the width of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageOffset-10056", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of imageOffset.y and extent.width does not equal the height of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageOffset-10057", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageOffset-10058", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of imageOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageSubresource-07967", "The imageSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageSubresource-07968", "If imageSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, imageSubresource.baseArrayLayer + imageSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageSubresource-07970", "The image region specified by each element of pRegions must be contained within the specified imageSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageSubresource-07971", "For each element of pRegions, imageOffset.x and (imageExtent.width + imageOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified imageSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageSubresource-07972", "For each element of pRegions, imageOffset.y and (imageExtent.height + imageOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified imageSubresource of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-imageSubresource-09105", "For each element of pRegions, imageSubresource.aspectMask must specify aspects present in srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-memoryImageHeight-09107", "For each element of pRegions, memoryImageHeight must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-memoryRowLength-09106", "For each element of pRegions, memoryRowLength must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-memoryRowLength-09108", "For each element of pRegions, memoryRowLength divided by the texel block extent width and then multiplied by the texel block size of srcImage must be less than or equal to 231-1", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkImageToMemoryCopyEXT structures", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-regionCount-arraylength", "regionCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO_EXT", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-00207", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of imageOffset.x and extent.width does not equal the width of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-00208", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of imageOffset.y and extent.height does not equal the height of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-00209", "For each element of pRegions, if the sum of imageOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-07274", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-07275", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-07276", "For each element of pRegions, imageOffset.z must be a multiple of the texel block extent depth of the VkFormat of srcImage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-07966", "If srcImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-07969", "srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-07973", "srcImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-07979", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, imageOffset.y must be 0 and imageExtent.height must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-07980", "If srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, imageOffset.z must be 0 and imageExtent.depth must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-07981", "If srcImage has a multi-planar image format, then for each element of pRegions, imageSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-07983", "If srcImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, imageSubresource.baseArrayLayer must be 0 and imageSubresource.layerCount must be 1", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-09109", "If srcImage is sparse then all memory ranges accessed by the copy command must be bound as described in Binding Resource Memory", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-09111", "If the stencil aspect of srcImage is accessed, and srcImage was not created with separate stencil usage, srcImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT set in VkImageCreateInfo::usage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-09112", "If the stencil aspect of srcImage is accessed, and srcImage was created with separate stencil usage, srcImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT set in VkImageStencilUsageCreateInfo::stencilUsage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-09113", "If non-stencil aspects of srcImage are accessed, srcImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT set in VkImageCreateInfo::usage", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-09115", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_EXT, the imageExtent member of each element of pRegions must equal the extents of srcImage identified by imageSubresource", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImage-parameter", "srcImage must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImageLayout-09064", "srcImageLayout must specify the current layout of the image subresources of srcImage specified in pRegions", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImageLayout-09065", "srcImageLayout must be one of the image layouts returned in VkPhysicalDeviceHostImageCopyPropertiesEXT::pCopySrcLayouts", "1.3-extensions"},
    {"VUID-VkCopyImageToMemoryInfoEXT-srcImageLayout-parameter", "srcImageLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkCopyMemoryIndirectCommandNV-dstAddress-07658", "The dstAddress must be 4 byte aligned", "1.3-extensions"},
    {"VUID-VkCopyMemoryIndirectCommandNV-size-07659", "The size must be 4 byte aligned", "1.3-extensions"},
    {"VUID-VkCopyMemoryIndirectCommandNV-srcAddress-07657", "The srcAddress must be 4 byte aligned", "1.3-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-dst-03746", "dst must have been created with a size greater than or equal to that used to serialize the data in src", "1.3-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-dst-parameter", "dst must be a valid VkAccelerationStructureKHR handle", "1.3-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-mode-03413", "mode must be VK_COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR", "1.3-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-mode-parameter", "mode must be a valid VkCopyAccelerationStructureModeKHR value", "1.3-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-pInfo-03414", "The data in src must have a format compatible with the destination physical device as returned by vkGetDeviceAccelerationStructureCompatibilityKHR", "1.3-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-src-04960", "The source memory pointed to by src must contain data previously serialized using vkCmdCopyAccelerationStructureToMemoryKHR, potentially modified to relocate acceleration structure references as described in that command", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageIndirectCommandNV-bufferImageHeight-07680", "bufferImageHeight must be 0, or greater than or equal to the height member of imageExtent", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageIndirectCommandNV-bufferRowLength-07679", "bufferRowLength must be 0, or greater than or equal to the width member of imageExtent", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageIndirectCommandNV-imageExtent-07682", "imageExtent must specify a valid region in the destination image and can be 0", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageIndirectCommandNV-imageOffset-07681", "imageOffset must specify a valid offset in the destination image", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageIndirectCommandNV-imageSubresource-parameter", "imageSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageIndirectCommandNV-srcAddress-07678", "The srcAddress must be 4 byte aligned", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-00207", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of imageOffset.x and extent.width does not equal the width of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-00208", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of imageOffset.y and extent.height does not equal the height of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-00209", "For each element of pRegions, if the sum of imageOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-07274", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-07275", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-07276", "For each element of pRegions, imageOffset.z must be a multiple of the texel block extent depth of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-07966", "If dstImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-07969", "dstImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-07973", "dstImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-07979", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, imageOffset.y must be 0 and imageExtent.height must be 1", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-07980", "If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, imageOffset.z must be 0 and imageExtent.depth must be 1", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-07981", "If dstImage has a multi-planar image format, then for each element of pRegions, imageSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-07983", "If dstImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, imageSubresource.baseArrayLayer must be 0 and imageSubresource.layerCount must be 1", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-09109", "If dstImage is sparse then all memory ranges accessed by the copy command must be bound as described in Binding Resource Memory", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-09111", "If the stencil aspect of dstImage is accessed, and dstImage was not created with separate stencil usage, dstImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT set in VkImageCreateInfo::usage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-09112", "If the stencil aspect of dstImage is accessed, and dstImage was created with separate stencil usage, dstImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT set in VkImageStencilUsageCreateInfo::stencilUsage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-09113", "If non-stencil aspects of dstImage are accessed, dstImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT set in VkImageCreateInfo::usage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-09115", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_EXT, the imageExtent member of each element of pRegions must equal the extents of dstImage identified by imageSubresource", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImage-parameter", "dstImage must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImageLayout-09059", "dstImageLayout must specify the current layout of the image subresources of dstImage specified in pRegions", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImageLayout-09060", "dstImageLayout must be one of the image layouts returned in VkPhysicalDeviceHostImageCopyPropertiesEXT::pCopyDstLayouts", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-dstImageLayout-parameter", "dstImageLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-flags-09393", "If flags includes VK_HOST_IMAGE_COPY_MEMCPY_EXT, for each region in pRegions, memoryRowLength and memoryImageHeight must both be 0", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-flags-parameter", "flags must be a valid combination of VkHostImageCopyFlagBitsEXT values", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageOffset-09104", "For each element of pRegions, imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified imageSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageOffset-09114", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_EXT, the x, y, and z members of the imageOffset member of each element of pRegions must be 0", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageOffset-10051", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and imageOffset.x does not equal the width of the subresource specified by imageSubresource, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageOffset-10052", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and imageOffset.y does not equal the height of the subresource specified by imageSubresource, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageOffset-10053", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of imageOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageOffset-10054", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageOffset-10055", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of imageOffset.x and extent.height does not equal the width of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageOffset-10056", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of imageOffset.y and extent.width does not equal the height of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageOffset-10057", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageOffset-10058", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of imageOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageSubresource-07967", "The imageSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageSubresource-07968", "If imageSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, imageSubresource.baseArrayLayer + imageSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageSubresource-07970", "The image region specified by each element of pRegions must be contained within the specified imageSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageSubresource-07971", "For each element of pRegions, imageOffset.x and (imageExtent.width + imageOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified imageSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageSubresource-07972", "For each element of pRegions, imageOffset.y and (imageExtent.height + imageOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified imageSubresource of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-imageSubresource-09105", "For each element of pRegions, imageSubresource.aspectMask must specify aspects present in dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-memoryImageHeight-09107", "For each element of pRegions, memoryImageHeight must be a multiple of the texel block extent height of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-memoryRowLength-09106", "For each element of pRegions, memoryRowLength must be a multiple of the texel block extent width of the VkFormat of dstImage", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-memoryRowLength-09108", "For each element of pRegions, memoryRowLength divided by the texel block extent width and then multiplied by the texel block size of dstImage must be less than or equal to 231-1", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkMemoryToImageCopyEXT structures", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-regionCount-arraylength", "regionCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkCopyMemoryToImageInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-dst-07550", "dst must have been created with a size greater than or equal to that used to serialize the data in src", "1.3-extensions"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-dst-parameter", "dst must be a valid VkMicromapEXT handle", "1.3-extensions"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-mode-07548", "mode must be VK_COPY_MICROMAP_MODE_DESERIALIZE_EXT", "1.3-extensions"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-mode-parameter", "mode must be a valid VkCopyMicromapModeEXT value", "1.3-extensions"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_MEMORY_TO_MICROMAP_INFO_EXT", "1.3-extensions"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-src-07547", "The source memory pointed to by src must contain data previously serialized using vkCmdCopyMicromapToMemoryEXT", "1.3-extensions"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-src-07549", "The data in src must have a format compatible with the destination physical device as returned by vkGetDeviceMicromapCompatibilityEXT", "1.3-extensions"},
    {"VUID-VkCopyMicromapInfoEXT-buffer-07534", "The buffer used to create src must be bound to device memory", "1.3-extensions"},
    {"VUID-VkCopyMicromapInfoEXT-buffer-07535", "The buffer used to create dst must be bound to device memory", "1.3-extensions"},
    {"VUID-VkCopyMicromapInfoEXT-commonparent", "Both of dst, and src must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkCopyMicromapInfoEXT-dst-parameter", "dst must be a valid VkMicromapEXT handle", "1.3-extensions"},
    {"VUID-VkCopyMicromapInfoEXT-mode-07531", "mode must be VK_COPY_MICROMAP_MODE_COMPACT_EXT or VK_COPY_MICROMAP_MODE_CLONE_EXT", "1.3-extensions"},
    {"VUID-VkCopyMicromapInfoEXT-mode-07533", "If mode is VK_COPY_MICROMAP_MODE_COMPACT_EXT, src must have been constructed with VK_BUILD_MICROMAP_ALLOW_COMPACTION_BIT_EXT in the build", "1.3-extensions"},
    {"VUID-VkCopyMicromapInfoEXT-mode-parameter", "mode must be a valid VkCopyMicromapModeEXT value", "1.3-extensions"},
    {"VUID-VkCopyMicromapInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCopyMicromapInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_MICROMAP_INFO_EXT", "1.3-extensions"},
    {"VUID-VkCopyMicromapInfoEXT-src-07532", "The source acceleration structure src must have been constructed prior to the execution of this command", "1.3-extensions"},
    {"VUID-VkCopyMicromapInfoEXT-src-parameter", "src must be a valid VkMicromapEXT handle", "1.3-extensions"},
    {"VUID-VkCopyMicromapToMemoryInfoEXT-dst-07541", "The memory pointed to by dst must be at least as large as the serialization size of src, as reported by vkWriteMicromapsPropertiesEXT or vkCmdWriteMicromapsPropertiesEXT with a query type of VK_QUERY_TYPE_MICROMAP_SERIALIZATION_SIZE_EXT", "1.3-extensions"},
    {"VUID-VkCopyMicromapToMemoryInfoEXT-mode-07542", "mode must be VK_COPY_MICROMAP_MODE_SERIALIZE_EXT", "1.3-extensions"},
    {"VUID-VkCopyMicromapToMemoryInfoEXT-mode-parameter", "mode must be a valid VkCopyMicromapModeEXT value", "1.3-extensions"},
    {"VUID-VkCopyMicromapToMemoryInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCopyMicromapToMemoryInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_MICROMAP_TO_MEMORY_INFO_EXT", "1.3-extensions"},
    {"VUID-VkCopyMicromapToMemoryInfoEXT-src-07540", "The source micromap src must have been constructed prior to the execution of this command", "1.3-extensions"},
    {"VUID-VkCopyMicromapToMemoryInfoEXT-src-parameter", "src must be a valid VkMicromapEXT handle", "1.3-extensions"},
    {"VUID-VkCuFunctionCreateInfoNVX-module-parameter", "module must be a valid VkCuModuleNVX handle", "1.3-extensions"},
    {"VUID-VkCuFunctionCreateInfoNVX-pName-parameter", "pName must be a null-terminated UTF-8 string", "1.3-extensions"},
    {"VUID-VkCuFunctionCreateInfoNVX-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCuFunctionCreateInfoNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX", "1.3-extensions"},
    {"VUID-VkCuLaunchInfoNVX-function-parameter", "function must be a valid VkCuFunctionNVX handle", "1.3-extensions"},
    {"VUID-VkCuLaunchInfoNVX-pExtras-parameter", "If extraCount is not 0, pExtras must be a valid pointer to an array of extraCount bytes", "1.3-extensions"},
    {"VUID-VkCuLaunchInfoNVX-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCuLaunchInfoNVX-pParams-parameter", "If paramCount is not 0, pParams must be a valid pointer to an array of paramCount bytes", "1.3-extensions"},
    {"VUID-VkCuLaunchInfoNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX", "1.3-extensions"},
    {"VUID-VkCuModuleCreateInfoNVX-pData-parameter", "If dataSize is not 0, pData must be a valid pointer to an array of dataSize bytes", "1.3-extensions"},
    {"VUID-VkCuModuleCreateInfoNVX-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCuModuleCreateInfoNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX", "1.3-extensions"},
    {"VUID-VkCudaFunctionCreateInfoNV-module-parameter", "module must be a valid VkCudaModuleNV handle", "1.3-extensions"},
    {"VUID-VkCudaFunctionCreateInfoNV-pName-parameter", "pName must be a null-terminated UTF-8 string", "1.3-extensions"},
    {"VUID-VkCudaFunctionCreateInfoNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCudaFunctionCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CUDA_FUNCTION_CREATE_INFO_NV", "1.3-extensions"},
    {"VUID-VkCudaLaunchInfoNV-extraCount-09411", "extraCount must be 0", "1.3-extensions"},
    {"VUID-VkCudaLaunchInfoNV-function-parameter", "function must be a valid VkCudaFunctionNV handle", "1.3-extensions"},
    {"VUID-VkCudaLaunchInfoNV-gridDimX-09406", "gridDimX must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[0]", "1.3-extensions"},
    {"VUID-VkCudaLaunchInfoNV-gridDimY-09407", "gridDimY must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[1]", "1.3-extensions"},
    {"VUID-VkCudaLaunchInfoNV-gridDimZ-09408", "gridDimZ must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[2]", "1.3-extensions"},
    {"VUID-VkCudaLaunchInfoNV-pExtras-09412", "pExtras must be NULL", "1.3-extensions"},
    {"VUID-VkCudaLaunchInfoNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCudaLaunchInfoNV-pParams-09410", "pParams must be a pointer to a table of paramCount parameters, corresponding to the arguments of function", "1.3-extensions"},
    {"VUID-VkCudaLaunchInfoNV-paramCount-09409", "paramCount must be the total amount of parameters listed in the pParams table", "1.3-extensions"},
    {"VUID-VkCudaLaunchInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CUDA_LAUNCH_INFO_NV", "1.3-extensions"},
    {"VUID-VkCudaModuleCreateInfoNV-dataSize-09413", "dataSize must be the total size in bytes of the PTX files or binary cache passed to pData", "1.3-extensions"},
    {"VUID-VkCudaModuleCreateInfoNV-dataSize-arraylength", "dataSize must be greater than 0", "1.3-extensions"},
    {"VUID-VkCudaModuleCreateInfoNV-pData-parameter", "pData must be a valid pointer to an array of dataSize bytes", "1.3-extensions"},
    {"VUID-VkCudaModuleCreateInfoNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkCudaModuleCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CUDA_MODULE_CREATE_INFO_NV", "1.3-extensions"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-pSignalSemaphoreValues-parameter", "If signalSemaphoreValuesCount is not 0, and pSignalSemaphoreValues is not NULL, pSignalSemaphoreValues must be a valid pointer to an array of signalSemaphoreValuesCount uint64_t values", "1.3-extensions"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-pWaitSemaphoreValues-parameter", "If waitSemaphoreValuesCount is not 0, and pWaitSemaphoreValues is not NULL, pWaitSemaphoreValues must be a valid pointer to an array of waitSemaphoreValuesCount uint64_t values", "1.3-extensions"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR", "1.3-extensions"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-signalSemaphoreValuesCount-00080", "signalSemaphoreValuesCount must be the same value as VkSubmitInfo::signalSemaphoreCount, where this structure is in the pNext chain of a VkSubmitInfo structure", "1.3-extensions"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-waitSemaphoreValuesCount-00079", "waitSemaphoreValuesCount must be the same value as VkSubmitInfo::waitSemaphoreCount, where this structure is in the pNext chain of a VkSubmitInfo structure", "1.3-extensions"},
    {"VUID-VkDebugMarkerMarkerInfoEXT-pMarkerName-parameter", "pMarkerName must be a null-terminated UTF-8 string", "1.3-extensions"},
    {"VUID-VkDebugMarkerMarkerInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDebugMarkerMarkerInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-object-01491", "object must not be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-object-01492", "object must be a Vulkan object of the type associated with objectType as defined in VkDebugReportObjectTypeEXT and Vulkan Handle Relationship", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-objectType-01490", "objectType must not be VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-objectType-parameter", "objectType must be a valid VkDebugReportObjectTypeEXT value", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-pObjectName-parameter", "pObjectName must be a null-terminated UTF-8 string", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-object-01494", "object must not be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-object-01495", "object must be a Vulkan object of the type associated with objectType as defined in VkDebugReportObjectTypeEXT and Vulkan Handle Relationship", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-objectType-01493", "objectType must not be VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-objectType-parameter", "objectType must be a valid VkDebugReportObjectTypeEXT value", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-pTag-parameter", "pTag must be a valid pointer to an array of tagSize bytes", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-tagSize-arraylength", "tagSize must be greater than 0", "1.3-extensions"},
    {"VUID-VkDebugReportCallbackCreateInfoEXT-flags-parameter", "flags must be a valid combination of VkDebugReportFlagBitsEXT values", "1.3-extensions"},
    {"VUID-VkDebugReportCallbackCreateInfoEXT-pfnCallback-parameter", "pfnCallback must be a valid PFN_vkDebugReportCallbackEXT value", "1.3-extensions"},
    {"VUID-VkDebugReportCallbackCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDebugUtilsLabelEXT-pLabelName-parameter", "pLabelName must be a null-terminated UTF-8 string", "1.3-extensions"},
    {"VUID-VkDebugUtilsLabelEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDebugUtilsLabelEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pCmdBufLabels-parameter", "If cmdBufLabelCount is not 0, pCmdBufLabels must be a valid pointer to an array of cmdBufLabelCount valid VkDebugUtilsLabelEXT structures", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pMessage-parameter", "If pMessage is not NULL, pMessage must be a null-terminated UTF-8 string", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pMessageIdName-parameter", "If pMessageIdName is not NULL, pMessageIdName must be a null-terminated UTF-8 string", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDeviceAddressBindingCallbackDataEXT", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pObjects-parameter", "If objectCount is not 0, pObjects must be a valid pointer to an array of objectCount valid VkDebugUtilsObjectNameInfoEXT structures", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pQueueLabels-parameter", "If queueLabelCount is not 0, pQueueLabels must be a valid pointer to an array of queueLabelCount valid VkDebugUtilsLabelEXT structures", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-parameter", "messageSeverity must be a valid combination of VkDebugUtilsMessageSeverityFlagBitsEXT values", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-requiredbitmask", "messageSeverity must not be 0", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-parameter", "messageType must be a valid combination of VkDebugUtilsMessageTypeFlagBitsEXT values", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-requiredbitmask", "messageType must not be 0", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-pfnUserCallback-parameter", "pfnUserCallback must be a valid PFN_vkDebugUtilsMessengerCallbackEXT value", "1.3-extensions"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-02589", "If objectType is VK_OBJECT_TYPE_UNKNOWN, objectHandle must not be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-02590", "If objectType is not VK_OBJECT_TYPE_UNKNOWN, objectHandle must be VK_NULL_HANDLE or a valid Vulkan handle of the type associated with objectType as defined in the VkObjectType and Vulkan Handle Relationship table", "1.3-extensions"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-parameter", "objectType must be a valid VkObjectType value", "1.3-extensions"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-pObjectName-parameter", "If pObjectName is not NULL, pObjectName must be a null-terminated UTF-8 string", "1.3-extensions"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-objectHandle-01910", "objectHandle must be a valid Vulkan handle of the type associated with objectType as defined in the VkObjectType and Vulkan Handle Relationship table", "1.3-extensions"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-objectType-01908", "objectType must not be VK_OBJECT_TYPE_UNKNOWN", "1.3-extensions"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-objectType-parameter", "objectType must be a valid VkObjectType value", "1.3-extensions"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-pTag-parameter", "pTag must be a valid pointer to an array of tagSize bytes", "1.3-extensions"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-tagSize-arraylength", "tagSize must be greater than 0", "1.3-extensions"},
    {"VUID-VkDecompressMemoryRegionNV-decompressedSize-07689", "The decompressedSize must be large enough to hold the decompressed data based on the decompressionMethod", "1.3-extensions"},
    {"VUID-VkDecompressMemoryRegionNV-decompressionMethod-07690", "The decompressionMethod must have a single bit set", "1.3-extensions"},
    {"VUID-VkDecompressMemoryRegionNV-decompressionMethod-09395", "If decompressionMethod is VK_MEMORY_DECOMPRESSION_METHOD_GDEFLATE_1_0_BIT_NV, then decompressedSize must be less than or equal to 65536 bytes", "1.3-extensions"},
    {"VUID-VkDecompressMemoryRegionNV-decompressionMethod-parameter", "decompressionMethod must be a valid combination of VkMemoryDecompressionMethodFlagBitsNV values", "1.3-extensions"},
    {"VUID-VkDecompressMemoryRegionNV-decompressionMethod-requiredbitmask", "decompressionMethod must not be 0", "1.3-extensions"},
    {"VUID-VkDecompressMemoryRegionNV-dstAddress-07687", "The dstAddress must be 4 byte aligned", "1.3-extensions"},
    {"VUID-VkDecompressMemoryRegionNV-dstAddress-07688", "The memory in range dstAddress and dstAddress + decompressedSize must be valid and bound to a VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkDecompressMemoryRegionNV-srcAddress-07685", "The srcAddress must be 4 byte aligned", "1.3-extensions"},
    {"VUID-VkDecompressMemoryRegionNV-srcAddress-07686", "The memory in range srcAddress and srcAddress + compressedSize must be valid and bound to a VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkDecompressMemoryRegionNV-srcAddress-07691", "The srcAddress to srcAddress + compressedSize region must not overlap with the dstAddress and dstAddress + decompressedSize region", "1.3-extensions"},
    {"VUID-VkDedicatedAllocationBufferCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV", "1.3-extensions"},
    {"VUID-VkDedicatedAllocationImageCreateInfoNV-dedicatedAllocation-00994", "If dedicatedAllocation is VK_TRUE, VkImageCreateInfo::flags must not include VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT", "1.3-extensions"},
    {"VUID-VkDedicatedAllocationImageCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV", "1.3-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00651", "If buffer is not VK_NULL_HANDLE, the buffer must have been created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE", "1.3-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00653", "If buffer is not VK_NULL_HANDLE, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the buffer", "1.3-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00655", "If buffer is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation, the memory being imported must also be a dedicated buffer allocation and buffer must be identical to the buffer associated with the imported memory", "1.3-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-parameter", "If buffer is not VK_NULL_HANDLE, buffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-commonparent", "Both of buffer, and image that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00649", "At least one of image and buffer must be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00650", "If image is not VK_NULL_HANDLE, the image must have been created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE", "1.3-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00652", "If image is not VK_NULL_HANDLE, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the image", "1.3-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00654", "If image is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation, the memory being imported must also be a dedicated image allocation and image must be identical to the image associated with the imported memory", "1.3-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-parameter", "If image is not VK_NULL_HANDLE, image must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV", "1.3-extensions"},
    {"VUID-VkDependencyInfo-dependencyFlags-parameter", "dependencyFlags must be a valid combination of VkDependencyFlagBits values", "1.3-extensions"},
    {"VUID-VkDependencyInfo-pBufferMemoryBarriers-parameter", "If bufferMemoryBarrierCount is not 0, pBufferMemoryBarriers must be a valid pointer to an array of bufferMemoryBarrierCount valid VkBufferMemoryBarrier2 structures", "1.3-extensions"},
    {"VUID-VkDependencyInfo-pImageMemoryBarriers-parameter", "If imageMemoryBarrierCount is not 0, pImageMemoryBarriers must be a valid pointer to an array of imageMemoryBarrierCount valid VkImageMemoryBarrier2 structures", "1.3-extensions"},
    {"VUID-VkDependencyInfo-pMemoryBarriers-parameter", "If memoryBarrierCount is not 0, pMemoryBarriers must be a valid pointer to an array of memoryBarrierCount valid VkMemoryBarrier2 structures", "1.3-extensions"},
    {"VUID-VkDependencyInfo-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDependencyInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEPENDENCY_INFO", "1.3-extensions"},
    {"VUID-VkDepthBiasInfoEXT-depthBiasClamp-08950", "If the depthBiasClamp feature is not enabled, depthBiasClamp must be 0.0", "1.3-extensions"},
    {"VUID-VkDepthBiasInfoEXT-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDepthBiasRepresentationInfoEXT", "1.3-extensions"},
    {"VUID-VkDepthBiasInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEPTH_BIAS_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDepthBiasInfoEXT-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkDepthBiasRepresentationInfoEXT-depthBiasExact-08949", "If the depthBiasExact feature is not enabled, depthBiasExact must be VK_FALSE", "1.3-extensions"},
    {"VUID-VkDepthBiasRepresentationInfoEXT-depthBiasRepresentation-parameter", "depthBiasRepresentation must be a valid VkDepthBiasRepresentationEXT value", "1.3-extensions"},
    {"VUID-VkDepthBiasRepresentationInfoEXT-floatRepresentation-08948", "If the floatRepresentation feature is not enabled, depthBiasRepresentation must not be VK_DEPTH_BIAS_REPRESENTATION_FLOAT_EXT", "1.3-extensions"},
    {"VUID-VkDepthBiasRepresentationInfoEXT-leastRepresentableValueForceUnormRepresentation-08947", "If the leastRepresentableValueForceUnormRepresentation feature is not enabled, depthBiasRepresentation must not be VK_DEPTH_BIAS_REPRESENTATION_LEAST_REPRESENTABLE_VALUE_FORCE_UNORM_EXT", "1.3-extensions"},
    {"VUID-VkDepthBiasRepresentationInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEPTH_BIAS_REPRESENTATION_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorAddressInfoEXT-None-08044", "If address is not zero, address must be a valid device address at an offset within a VkBuffer", "1.3-extensions"},
    {"VUID-VkDescriptorAddressInfoEXT-None-09508", "If address is not zero, and the descriptor is of type VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER or VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, then format must not be VK_FORMAT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkDescriptorAddressInfoEXT-address-08043", "If the nullDescriptor feature is not enabled, address must not be zero", "1.3-extensions"},
    {"VUID-VkDescriptorAddressInfoEXT-format-parameter", "format must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkDescriptorAddressInfoEXT-nullDescriptor-08938", "If address is zero, range must be VK_WHOLE_SIZE", "1.3-extensions"},
    {"VUID-VkDescriptorAddressInfoEXT-nullDescriptor-08939", "If address is not zero, range must not be VK_WHOLE_SIZE", "1.3-extensions"},
    {"VUID-VkDescriptorAddressInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDescriptorAddressInfoEXT-range-08045", "range must be less than or equal to the size of the buffer containing address minus the offset of address from the base address of the buffer", "1.3-extensions"},
    {"VUID-VkDescriptorAddressInfoEXT-range-08940", "range must not be zero", "1.3-extensions"},
    {"VUID-VkDescriptorAddressInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_ADDRESS_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-None-09499", "If the pNext chain does not include a VkBufferUsageFlags2CreateInfoKHR structure, usage must be a valid combination of VkBufferUsageFlagBits values", "1.3-extensions"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-None-09500", "If the pNext chain does not include a VkBufferUsageFlags2CreateInfoKHR structure, usage must not be 0", "1.3-extensions"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-address-08057", "address must be aligned to VkPhysicalDeviceDescriptorBufferPropertiesEXT::descriptorBufferOffsetAlignment", "1.3-extensions"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-bufferlessPushDescriptors-08056", "If VkPhysicalDeviceDescriptorBufferPropertiesEXT::bufferlessPushDescriptors is VK_FALSE, and usage contains VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT, then the pNext chain must include a VkDescriptorBufferBindingPushDescriptorBufferHandleEXT structure", "1.3-extensions"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBufferUsageFlags2CreateInfoKHR or VkDescriptorBufferBindingPushDescriptorBufferHandleEXT", "1.3-extensions"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-usage-08122", "If usage includes VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT, address must be an address within a valid buffer that was created with VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-usage-08123", "If usage includes VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT, address must be an address within a valid buffer that was created with VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-usage-08124", "If usage includes VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT, address must be an address within a valid buffer that was created with VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorBufferBindingPushDescriptorBufferHandleEXT-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkDescriptorBufferBindingPushDescriptorBufferHandleEXT-bufferlessPushDescriptors-08059", "VkPhysicalDeviceDescriptorBufferPropertiesEXT::bufferlessPushDescriptors must be VK_FALSE", "1.3-extensions"},
    {"VUID-VkDescriptorBufferBindingPushDescriptorBufferHandleEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_PUSH_DESCRIPTOR_BUFFER_HANDLE_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorBufferInfo-buffer-02998", "If the nullDescriptor feature is not enabled, buffer must not be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkDescriptorBufferInfo-buffer-02999", "If buffer is VK_NULL_HANDLE, offset must be zero and range must be VK_WHOLE_SIZE", "1.3-extensions"},
    {"VUID-VkDescriptorBufferInfo-buffer-parameter", "If buffer is not VK_NULL_HANDLE, buffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkDescriptorBufferInfo-offset-00340", "offset must be less than the size of buffer", "1.3-extensions"},
    {"VUID-VkDescriptorBufferInfo-range-00341", "If range is not equal to VK_WHOLE_SIZE, range must be greater than 0", "1.3-extensions"},
    {"VUID-VkDescriptorBufferInfo-range-00342", "If range is not equal to VK_WHOLE_SIZE, range must be less than or equal to the size of buffer minus offset", "1.3-extensions"},
    {"VUID-VkDescriptorDataEXT-type-08030", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, and pUniformBuffer->address is the address of a non-sparse buffer, then that buffer must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkDescriptorDataEXT-type-08031", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, and pStorageBuffer->address is the address of a non-sparse buffer, then that buffer must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkDescriptorDataEXT-type-08032", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, and pUniformTexelBuffer->address is the address of a non-sparse buffer, then that buffer must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkDescriptorDataEXT-type-08033", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, and pStorageTexelBuffer->address is the address of a non-sparse buffer, then that buffer must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkDescriptorDataEXT-type-08034", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and the nullDescriptor feature is not enabled, pCombinedImageSampler->imageView must not be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkDescriptorDataEXT-type-08035", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and the nullDescriptor feature is not enabled, pSampledImage must not be NULL and pSampledImage->imageView must not be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkDescriptorDataEXT-type-08036", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and the nullDescriptor feature is not enabled, pStorageImage must not be NULL and pStorageImage->imageView must not be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkDescriptorDataEXT-type-08037", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, and the nullDescriptor feature is not enabled, pUniformTexelBuffer must not be NULL", "1.3-extensions"},
    {"VUID-VkDescriptorDataEXT-type-08038", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, and the nullDescriptor feature is not enabled, pStorageTexelBuffer must not be NULL", "1.3-extensions"},
    {"VUID-VkDescriptorDataEXT-type-08039", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, and the nullDescriptor feature is not enabled, pUniformBuffer must not be NULL", "1.3-extensions"},
    {"VUID-VkDescriptorDataEXT-type-08040", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, and the nullDescriptor feature is not enabled, pStorageBuffer must not be NULL", "1.3-extensions"},
    {"VUID-VkDescriptorDataEXT-type-08041", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR, and the nullDescriptor feature is not enabled, accelerationStructure must not be 0", "1.3-extensions"},
    {"VUID-VkDescriptorDataEXT-type-08042", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV, and the nullDescriptor feature is not enabled, accelerationStructure must not be 0", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-pCombinedImageSampler-parameter", "If type is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the pCombinedImageSampler member of data must be a valid pointer to a valid VkDescriptorImageInfo structure", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-pInputAttachmentImage-parameter", "If type is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the pInputAttachmentImage member of data must be a valid pointer to a valid VkDescriptorImageInfo structure", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-pSampledImage-parameter", "If type is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and if pSampledImage is not NULL, the pSampledImage member of data must be a valid pointer to a valid VkDescriptorImageInfo structure", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-pSampler-parameter", "If type is VK_DESCRIPTOR_TYPE_SAMPLER, the pSampler member of data must be a valid pointer to a valid VkSampler handle", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-pStorageBuffer-parameter", "If type is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, and if pStorageBuffer is not NULL, the pStorageBuffer member of data must be a valid pointer to a valid VkDescriptorAddressInfoEXT structure", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-pStorageImage-parameter", "If type is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and if pStorageImage is not NULL, the pStorageImage member of data must be a valid pointer to a valid VkDescriptorImageInfo structure", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-pStorageTexelBuffer-parameter", "If type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, and if pStorageTexelBuffer is not NULL, the pStorageTexelBuffer member of data must be a valid pointer to a valid VkDescriptorAddressInfoEXT structure", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-pUniformBuffer-parameter", "If type is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, and if pUniformBuffer is not NULL, the pUniformBuffer member of data must be a valid pointer to a valid VkDescriptorAddressInfoEXT structure", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-pUniformTexelBuffer-parameter", "If type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, and if pUniformTexelBuffer is not NULL, the pUniformTexelBuffer member of data must be a valid pointer to a valid VkDescriptorAddressInfoEXT structure", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_GET_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-08018", "type must not be VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-08019", "If type is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the pCombinedImageSampler->sampler member of data must be a VkSampler created on device", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-08020", "If type is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the pCombinedImageSampler->imageView member of data must be a VkImageView created on device, or VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-08021", "If type is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the pInputAttachmentImage->imageView member of data must be a VkImageView created on device", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-08022", "If type is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and if pSampledImage is not NULL, the pSampledImage->imageView member of data must be a VkImageView created on device, or VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-08023", "If type is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and if pStorageImage is not NULL, the pStorageImage->imageView member of data must be a VkImageView created on device, or VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-08024", "If type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, pUniformTexelBuffer is not NULL and pUniformTexelBuffer->address is not zero, pUniformTexelBuffer->address must be an address within a VkBuffer created on device", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-08025", "If type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, pStorageTexelBuffer is not NULL and pStorageTexelBuffer->address is not zero, pStorageTexelBuffer->address must be an address within a VkBuffer created on device", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-08026", "If type is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, pUniformBuffer is not NULL and pUniformBuffer->address is not zero, pUniformBuffer->address must be an address within a VkBuffer created on device", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-08027", "If type is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, pStorageBuffer is not NULL and pStorageBuffer->address is not zero, pStorageBuffer->address must be an address within a VkBuffer created on device", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-08028", "If type is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR and accelerationStructure is not 0, accelerationStructure must contain the address of a VkAccelerationStructureKHR created on device", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-08029", "If type is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV and accelerationStructure is not 0, accelerationStructure must contain the handle of a VkAccelerationStructureNV created on device, returned by vkGetAccelerationStructureHandleNV", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-09427", "If type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, pUniformBuffer is not NULL , the number of texel buffer elements given by (⌊pUniformBuffer->range / (texel block size)⌋ × (texels per block)) where texel block size and texels per block are as defined in the Compatible Formats table for pUniformBuffer->format, must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-09428", "If type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, pStorageBuffer is not NULL , the number of texel buffer elements given by (⌊pStorageBuffer->range / (texel block size)⌋ × (texels per block)) where texel block size and texels per block are as defined in the Compatible Formats table for pStorageBuffer->format, must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements", "1.3-extensions"},
    {"VUID-VkDescriptorGetInfoEXT-type-parameter", "type must be a valid VkDescriptorType value", "1.3-extensions"},
    {"VUID-VkDescriptorImageInfo-commonparent", "Both of imageView, and sampler that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkDescriptorImageInfo-descriptorType-06713", "If the image2DViewOf3D feature is not enabled or descriptorType is not VK_DESCRIPTOR_TYPE_STORAGE_IMAGE then imageView must not be a 2D view created from a 3D image", "1.3-extensions"},
    {"VUID-VkDescriptorImageInfo-descriptorType-06714", "If the sampler2DViewOf3D feature is not enabled or descriptorType is not VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER then imageView must not be a 2D view created from a 3D image", "1.3-extensions"},
    {"VUID-VkDescriptorImageInfo-imageLayout-00344", "imageLayout must match the actual VkImageLayout of each subresource accessible from imageView at the time this descriptor is accessed as defined by the image layout matching rules", "1.3-extensions"},
    {"VUID-VkDescriptorImageInfo-imageLayout-09425", "If imageLayout is VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, then the aspectMask used to create imageView must not include either VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorImageInfo-imageLayout-09426", "If imageLayout is VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, then the aspectMask used to create imageView must not include VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorImageInfo-imageView-01976", "If imageView is created from a depth/stencil image, the aspectMask used to create the imageView must include either VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT but not both", "1.3-extensions"},
    {"VUID-VkDescriptorImageInfo-imageView-06712", "imageView must not be a 2D array image view created from a 3D image", "1.3-extensions"},
    {"VUID-VkDescriptorImageInfo-imageView-07795", "If imageView is a 2D view created from a 3D image, then descriptorType must be VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER", "1.3-extensions"},
    {"VUID-VkDescriptorImageInfo-imageView-07796", "If imageView is a 2D view created from a 3D image, then the image must have been created with VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT set", "1.3-extensions"},
    {"VUID-VkDescriptorImageInfo-mutableComparisonSamplers-04450", "If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::mutableComparisonSamplers is VK_FALSE, then sampler must have been created with VkSamplerCreateInfo::compareEnable set to VK_FALSE", "1.3-extensions"},
    {"VUID-VkDescriptorImageInfo-sampler-01564", "If sampler is used and the VkFormat of the image is a multi-planar format, the image must have been created with VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT, and the aspectMask of the imageView must be a valid multi-planar aspect mask bit", "1.3-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-descriptorPoolOverallocation-09227", "If the descriptorPoolOverallocation feature is not enabled, or flags does not have VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_SETS_BIT_NV set, maxSets must be greater than 0", "1.3-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-flags-04607", "If flags has the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT bit set, then the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT bit must not be set", "1.3-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-flags-04609", "If flags has the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT bit set, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT::mutableDescriptorType must be enabled", "1.3-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-flags-09228", "If flags has the VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_SETS_BIT_NV or VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_POOLS_BIT_NV bits set, then descriptorPoolOverallocation must be enabled", "1.3-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-flags-parameter", "flags must be a valid combination of VkDescriptorPoolCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-mutableDescriptorType-04608", "If VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT::mutableDescriptorType is not enabled, pPoolSizes must not contain a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDescriptorPoolInlineUniformBlockCreateInfo or VkMutableDescriptorTypeCreateInfoEXT", "1.3-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-pPoolSizes-04787", "If pPoolSizes contains a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT, any other VK_DESCRIPTOR_TYPE_MUTABLE_EXT element in pPoolSizes must not have sets of supported descriptor types which partially overlap", "1.3-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-pPoolSizes-09424", "If pPoolSizes contains a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, the pNext chain must include a VkDescriptorPoolInlineUniformBlockCreateInfo structure whose maxInlineUniformBlockBindings member is not zero", "1.3-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-pPoolSizes-parameter", "If poolSizeCount is not 0, pPoolSizes must be a valid pointer to an array of poolSizeCount valid VkDescriptorPoolSize structures", "1.3-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkDescriptorPoolCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkDescriptorPoolInlineUniformBlockCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkDescriptorPoolSize-descriptorCount-00302", "descriptorCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkDescriptorPoolSize-type-02218", "If type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK then descriptorCount must be a multiple of 4", "1.3-extensions"},
    {"VUID-VkDescriptorPoolSize-type-parameter", "type must be a valid VkDescriptorType value", "1.3-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-apiVersion-07895", "If the VK_KHR_maintenance1 extension is not enabled and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, descriptorSetCount must not be greater than the number of sets that are currently available for allocation in descriptorPool", "1.3-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-apiVersion-07896", "If the VK_KHR_maintenance1 extension is not enabled and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, descriptorPool must have enough free descriptor capacity remaining to allocate the descriptor sets of the specified layouts", "1.3-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-commonparent", "Both of descriptorPool, and the elements of pSetLayouts must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-descriptorPool-parameter", "descriptorPool must be a valid VkDescriptorPool handle", "1.3-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-descriptorSetCount-arraylength", "descriptorSetCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDescriptorSetVariableDescriptorCountAllocateInfo", "1.3-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-00308", "Each element of pSetLayouts must not have been created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR set", "1.3-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-03044", "If any element of pSetLayouts was created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set, descriptorPool must have been created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set", "1.3-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-04610", "If any element of pSetLayouts was created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT bit set, descriptorPool must have been created with the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT flag set", "1.3-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-08009", "Each element of pSetLayouts must not have been created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT bit set", "1.3-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-09380", "If pSetLayouts[i] was created with an element of pBindingFlags that includes VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, and VkDescriptorSetVariableDescriptorCountAllocateInfo is included in the pNext chain, and VkDescriptorSetVariableDescriptorCountAllocateInfo::descriptorSetCount is not zero, then VkDescriptorSetVariableDescriptorCountAllocateInfo::pDescriptorCounts[i] must be less than or equal to VkDescriptorSetLayoutBinding::descriptorCount for the corresponding binding used to create pSetLayouts[i]", "1.3-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-parameter", "pSetLayouts must be a valid pointer to an array of descriptorSetCount valid VkDescriptorSetLayout handles", "1.3-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO", "1.3-extensions"},
    {"VUID-VkDescriptorSetAllocateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkDescriptorSetBindingReferenceVALVE-descriptorSetLayout-parameter", "descriptorSetLayout must be a valid VkDescriptorSetLayout handle", "1.3-extensions"},
    {"VUID-VkDescriptorSetBindingReferenceVALVE-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDescriptorSetBindingReferenceVALVE-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_BINDING_REFERENCE_VALVE", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorCount-09465", "If descriptorCount is not 0, stageFlags must be VK_SHADER_STAGE_ALL or a valid combination of other VkShaderStageFlagBits values", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-00282", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLER or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and descriptorCount is not 0 and pImmutableSamplers is not NULL, pImmutableSamplers must be a valid pointer to an array of descriptorCount valid VkSampler handles", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-01510", "If descriptorType is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT and descriptorCount is not 0, then stageFlags must be 0 or VK_SHADER_STAGE_FRAGMENT_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-02209", "If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK then descriptorCount must be a multiple of 4", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-04604", "If the inlineUniformBlock feature is not enabled, descriptorType must not be VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-04605", "If descriptorType is VK_DESCRIPTOR_TYPE_MUTABLE_EXT, then pImmutableSamplers must be NULL", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-08004", "If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK and VkDescriptorSetLayoutCreateInfo::flags does not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT then descriptorCount must be less than or equal to VkPhysicalDeviceInlineUniformBlockProperties::maxInlineUniformBlockSize", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-parameter", "descriptorType must be a valid VkDescriptorType value", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-flags-08005", "If VkDescriptorSetLayoutCreateInfo::flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, descriptorType must be VK_DESCRIPTOR_TYPE_SAMPLER", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-flags-08006", "If VkDescriptorSetLayoutCreateInfo::flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, descriptorCount must less than or equal to 1", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-flags-08007", "If VkDescriptorSetLayoutCreateInfo::flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, and descriptorCount is equal to 1, pImmutableSamplers must not be NULL", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-flags-09466", "If VkDescriptorSetLayoutCreateInfo::flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, and descriptorCount is not 0, then stageFlags must be a valid combination of VK_SHADER_STAGE_VERTEX_BIT, VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT, VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT, VK_SHADER_STAGE_GEOMETRY_BIT, VK_SHADER_STAGE_FRAGMENT_BIT and VK_SHADER_STAGE_COMPUTE_BIT values", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBinding-pImmutableSamplers-04009", "The sampler objects indicated by pImmutableSamplers must not have a borderColor with one of the values VK_BORDER_COLOR_FLOAT_CUSTOM_EXT or VK_BORDER_COLOR_INT_CUSTOM_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-None-03011", "All bindings with descriptor type VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-bindingCount-03002", "If bindingCount is not zero, bindingCount must equal VkDescriptorSetLayoutCreateInfo::bindingCount", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingAccelerationStructureUpdateAfterBind-03570", "If VkPhysicalDeviceAccelerationStructureFeaturesKHR::descriptorBindingAccelerationStructureUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR or VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingInlineUniformBlockUpdateAfterBind-02211", "If VkPhysicalDeviceInlineUniformBlockFeatures::descriptorBindingInlineUniformBlockUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingPartiallyBound-03013", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingPartiallyBound is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingSampledImageUpdateAfterBind-03006", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingSampledImageUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_SAMPLER, VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, or VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageBufferUpdateAfterBind-03008", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageImageUpdateAfterBind-03007", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageImageUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_IMAGE must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageTexelBufferUpdateAfterBind-03010", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageTexelBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUniformBufferUpdateAfterBind-03005", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUniformBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUniformTexelBufferUpdateAfterBind-03009", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUniformTexelBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUpdateUnusedWhilePending-03012", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUpdateUnusedWhilePending is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingVariableDescriptorCount-03014", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingVariableDescriptorCount is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-flags-03003", "If VkDescriptorSetLayoutCreateInfo::flags includes VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, then all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT, VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT, or VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-03004", "If an element of pBindingFlags includes VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, then it must be the element with the highest binding number", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-03015", "If an element of pBindingFlags includes VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, that element's descriptorType must not be VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-parameter", "If bindingCount is not 0, pBindingFlags must be a valid pointer to an array of bindingCount valid combinations of VkDescriptorBindingFlagBits values", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-binding-00279", "If the perStageDescriptorSet feature is not enabled, or flags does not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, then the VkDescriptorSetLayoutBinding::binding members of the elements of the pBindings array must each have different values", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-descriptorType-03001", "If any binding has the VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT bit set, then all bindings must not have descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-descriptorType-04594", "If a binding has a descriptorType value of VK_DESCRIPTOR_TYPE_MUTABLE_EXT, then pImmutableSamplers must be NULL", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-00280", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, then all elements of pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-00281", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, then the total number of elements of all bindings must be less than or equal to VkPhysicalDevicePushDescriptorPropertiesKHR::maxPushDescriptors", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-02208", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, then all elements of pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-03000", "If any binding has the VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT bit set, flags must include VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04590", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, flags must not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04591", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04592", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT, flags must not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04596", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT::mutableDescriptorType must be enabled", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-08000", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT, then all elements of pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-08001", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, flags must also contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-08002", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT, then flags must not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-08003", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT, then flags must not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-09463", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, then perStageDescriptorSet must be enabled", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-09464", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, then there must not be any two elements of the pBindings array with the same VkDescriptorSetLayoutBinding::binding value and their VkDescriptorSetLayoutBinding::stageFlags containing the same bit", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-parameter", "flags must be a valid combination of VkDescriptorSetLayoutCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-mutableDescriptorType-04595", "If VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT::mutableDescriptorType is not enabled, pBindings must not contain a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-pBindings-07303", "If any element pBindings[i] has a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT, then the pNext chain must include a VkMutableDescriptorTypeCreateInfoEXT structure, and mutableDescriptorTypeListCount must be greater than i", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-pBindings-parameter", "If bindingCount is not 0, pBindings must be a valid pointer to an array of bindingCount valid VkDescriptorSetLayoutBinding structures", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDescriptorSetLayoutBindingFlagsCreateInfo or VkMutableDescriptorTypeCreateInfoEXT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutHostMappingInfoVALVE-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutHostMappingInfoVALVE-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_HOST_MAPPING_INFO_VALVE", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutSupport-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDescriptorSetVariableDescriptorCountLayoutSupport", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutSupport-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT", "1.3-extensions"},
    {"VUID-VkDescriptorSetLayoutSupport-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-descriptorSetCount-03045", "If descriptorSetCount is not zero, descriptorSetCount must equal VkDescriptorSetAllocateInfo::descriptorSetCount", "1.3-extensions"},
    {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-pDescriptorCounts-parameter", "If descriptorSetCount is not 0, pDescriptorCounts must be a valid pointer to an array of descriptorSetCount uint32_t values", "1.3-extensions"},
    {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO", "1.3-extensions"},
    {"VUID-VkDescriptorSetVariableDescriptorCountLayoutSupport-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-commonparent", "Both of descriptorSetLayout, and pipelineLayout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-descriptorUpdateEntryCount-arraylength", "descriptorUpdateEntryCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-pDescriptorUpdateEntries-parameter", "pDescriptorUpdateEntries must be a valid pointer to an array of descriptorUpdateEntryCount valid VkDescriptorUpdateTemplateEntry structures", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00350", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET, descriptorSetLayout must be a valid VkDescriptorSetLayout handle", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00351", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR, pipelineBindPoint must be a valid VkPipelineBindPoint value", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00352", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR, pipelineLayout must be a valid VkPipelineLayout handle", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00353", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR, set must be the unique set number in the pipeline layout that uses a descriptor set layout that was created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-04615", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET, descriptorSetLayout must not contain a binding with type VK_DESCRIPTOR_TYPE_MUTABLE_EXT", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-parameter", "templateType must be a valid VkDescriptorUpdateTemplateType value", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateEntry-descriptor-02226", "If descriptor type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, dstArrayElement must be an integer multiple of 4", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateEntry-descriptor-02227", "If descriptor type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, descriptorCount must be an integer multiple of 4", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateEntry-descriptorType-parameter", "descriptorType must be a valid VkDescriptorType value", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateEntry-dstArrayElement-00355", "dstArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding implicitly specified when using a descriptor update template to update descriptors, and all applicable consecutive bindings, as described by consecutive binding updates", "1.3-extensions"},
    {"VUID-VkDescriptorUpdateTemplateEntry-dstBinding-00354", "dstBinding must be a valid binding in the descriptor set layout implicitly specified when using a descriptor update template to update descriptors", "1.3-extensions"},
    {"VUID-VkDeviceAddressBindingCallbackDataEXT-bindingType-parameter", "bindingType must be a valid VkDeviceAddressBindingTypeEXT value", "1.3-extensions"},
    {"VUID-VkDeviceAddressBindingCallbackDataEXT-flags-parameter", "flags must be a valid combination of VkDeviceAddressBindingFlagBitsEXT values", "1.3-extensions"},
    {"VUID-VkDeviceAddressBindingCallbackDataEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_ADDRESS_BINDING_CALLBACK_DATA_EXT", "1.3-extensions"},
    {"VUID-VkDeviceBufferMemoryRequirements-pCreateInfo-parameter", "pCreateInfo must be a valid pointer to a valid VkBufferCreateInfo structure", "1.3-extensions"},
    {"VUID-VkDeviceBufferMemoryRequirements-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDeviceBufferMemoryRequirements-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-None-04896", "If sparseImageInt64Atomics is enabled, shaderImageInt64Atomics must be enabled", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-None-04897", "If sparseImageFloat32Atomics is enabled, shaderImageFloat32Atomics must be enabled", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-None-04898", "If sparseImageFloat32AtomicAdd is enabled, shaderImageFloat32AtomicAdd must be enabled", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-None-08095", "If descriptorBuffer is enabled, ppEnabledExtensionNames must not contain VK_AMD_shader_fragment_mask", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-fragmentDensityMap-04481", "If the fragmentDensityMap feature is enabled, the pipelineFragmentShadingRate feature must not be enabled", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-fragmentDensityMap-04482", "If the fragmentDensityMap feature is enabled, the primitiveFragmentShadingRate feature must not be enabled", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-fragmentDensityMap-04483", "If the fragmentDensityMap feature is enabled, the attachmentFragmentShadingRate feature must not be enabled", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-pEnabledFeatures-parameter", "If pEnabledFeatures is not NULL, pEnabledFeatures must be a valid pointer to a valid VkPhysicalDeviceFeatures structure", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-pNext-00373", "If the pNext chain includes a VkPhysicalDeviceFeatures2 structure, then pEnabledFeatures must be NULL", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-pNext-02829", "If the pNext chain includes a VkPhysicalDeviceVulkan11Features structure, then it must not include a VkPhysicalDevice16BitStorageFeatures, VkPhysicalDeviceMultiviewFeatures, VkPhysicalDeviceVariablePointersFeatures, VkPhysicalDeviceProtectedMemoryFeatures, VkPhysicalDeviceSamplerYcbcrConversionFeatures, or VkPhysicalDeviceShaderDrawParametersFeatures structure", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-pNext-02830", "If the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then it must not include a VkPhysicalDevice8BitStorageFeatures, VkPhysicalDeviceShaderAtomicInt64Features, VkPhysicalDeviceShaderFloat16Int8Features, VkPhysicalDeviceDescriptorIndexingFeatures, VkPhysicalDeviceScalarBlockLayoutFeatures, VkPhysicalDeviceImagelessFramebufferFeatures, VkPhysicalDeviceUniformBufferStandardLayoutFeatures, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures, VkPhysicalDeviceHostQueryResetFeatures, VkPhysicalDeviceTimelineSemaphoreFeatures, VkPhysicalDeviceBufferDeviceAddressFeatures, or VkPhysicalDeviceVulkanMemoryModelFeatures structure", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-pNext-04748", "If the pNext chain includes a VkPhysicalDeviceVulkan12Features structure and VkPhysicalDeviceVulkan12Features::bufferDeviceAddress is VK_TRUE, ppEnabledExtensionNames must not contain VK_EXT_buffer_device_address", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-pNext-06532", "If the pNext chain includes a VkPhysicalDeviceVulkan13Features structure, then it must not include a VkPhysicalDeviceDynamicRenderingFeatures, VkPhysicalDeviceImageRobustnessFeatures, VkPhysicalDeviceInlineUniformBlockFeatures, VkPhysicalDeviceMaintenance4Features, VkPhysicalDevicePipelineCreationCacheControlFeatures, VkPhysicalDevicePrivateDataFeatures, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures, VkPhysicalDeviceShaderIntegerDotProductFeatures, VkPhysicalDeviceShaderTerminateInvocationFeatures, VkPhysicalDeviceSubgroupSizeControlFeatures, VkPhysicalDeviceSynchronization2Features, VkPhysicalDeviceTextureCompressionASTCHDRFeatures, or VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures structure", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-pNext-09396", "If the pNext chain includes a VkDeviceQueueShaderCoreControlCreateInfoARM structure, then it must not be included in the pNext chain of any of the VkDeviceQueueCreateInfo structures in pQueueCreateInfos", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-pNext-09397", "If the pNext chain includes a VkDeviceQueueShaderCoreControlCreateInfoARM structure then VkPhysicalDeviceSchedulingControlsPropertiesARM::schedulingControlsFlags must contain VK_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_SHADER_CORE_COUNT_ARM", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid struct for extending VkDeviceCreateInfo", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-pProperties-04451", "If the VK_KHR_portability_subset extension is included in pProperties of vkEnumerateDeviceExtensionProperties, ppEnabledExtensionNames must include \"VK_KHR_portability_subset\"", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-pQueueCreateInfos-06654", "If multiple elements of pQueueCreateInfos share the same queueFamilyIndex, then all of such elements must have the same global priority level, which can be specified explicitly by the including a VkDeviceQueueGlobalPriorityCreateInfoKHR structure in the pNext chain, or by the implicit default value", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-pQueueCreateInfos-06755", "If multiple elements of pQueueCreateInfos share the same queueFamilyIndex, the sum of their queueCount members must be less than or equal to the queueCount member of the VkQueueFamilyProperties structure, as returned by vkGetPhysicalDeviceQueueFamilyProperties in the pQueueFamilyProperties[queueFamilyIndex]", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-pQueueCreateInfos-parameter", "pQueueCreateInfos must be a valid pointer to an array of queueCreateInfoCount valid VkDeviceQueueCreateInfo structures", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-00374", "ppEnabledExtensionNames must not contain both VK_KHR_maintenance1 and VK_AMD_negative_viewport_height", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-01840", "If VkPhysicalDeviceProperties::apiVersion advertises Vulkan 1.1 or later, ppEnabledExtensionNames must not contain VK_AMD_negative_viewport_height", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02831", "If ppEnabledExtensionNames contains \"VK_KHR_draw_indirect_count\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::drawIndirectCount must be VK_TRUE", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02832", "If ppEnabledExtensionNames contains \"VK_KHR_sampler_mirror_clamp_to_edge\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::samplerMirrorClampToEdge must be VK_TRUE", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02833", "If ppEnabledExtensionNames contains \"VK_EXT_descriptor_indexing\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::descriptorIndexing must be VK_TRUE", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02834", "If ppEnabledExtensionNames contains \"VK_EXT_sampler_filter_minmax\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::samplerFilterMinmax must be VK_TRUE", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02835", "If ppEnabledExtensionNames contains \"VK_EXT_shader_viewport_index_layer\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::shaderOutputViewportIndex and VkPhysicalDeviceVulkan12Features::shaderOutputLayer must both be VK_TRUE", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-03328", "ppEnabledExtensionNames must not contain both VK_KHR_buffer_device_address and VK_EXT_buffer_device_address", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-04476", "If ppEnabledExtensionNames contains \"VK_KHR_shader_draw_parameters\" and the pNext chain includes a VkPhysicalDeviceVulkan11Features structure, then VkPhysicalDeviceVulkan11Features::shaderDrawParameters must be VK_TRUE", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-parameter", "If enabledExtensionCount is not 0, ppEnabledExtensionNames must be a valid pointer to an array of enabledExtensionCount null-terminated UTF-8 strings", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-ppEnabledLayerNames-parameter", "If enabledLayerCount is not 0, ppEnabledLayerNames must be a valid pointer to an array of enabledLayerCount null-terminated UTF-8 strings", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-queueCreateInfoCount-arraylength", "queueCreateInfoCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-queueFamilyIndex-02802", "The queueFamilyIndex member of each element of pQueueCreateInfos must be unique within pQueueCreateInfos , except that two members can share the same queueFamilyIndex if one describes protected-capable queues and one describes queues that are not protected-capable", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique, with the exception of structures of type VkDeviceDeviceMemoryReportCreateInfoEXT or VkDevicePrivateDataCreateInfo", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-shadingRateImage-04478", "If the shadingRateImage feature is enabled, the pipelineFragmentShadingRate feature must not be enabled", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-shadingRateImage-04479", "If the shadingRateImage feature is enabled, the primitiveFragmentShadingRate feature must not be enabled", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-shadingRateImage-04480", "If the shadingRateImage feature is enabled, the attachmentFragmentShadingRate feature must not be enabled", "1.3-extensions"},
    {"VUID-VkDeviceCreateInfo-sparseImageFloat32AtomicMinMax-04975", "If sparseImageFloat32AtomicMinMax is enabled, shaderImageFloat32AtomicMinMax must be enabled", "1.3-extensions"},
    {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-pUserData-parameter", "pUserData must be a pointer value", "1.3-extensions"},
    {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-pfnUserCallback-parameter", "pfnUserCallback must be a valid PFN_vkDeviceMemoryReportCallbackEXT value", "1.3-extensions"},
    {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDeviceDiagnosticsConfigCreateInfoNV-flags-parameter", "flags must be a valid combination of VkDeviceDiagnosticsConfigFlagBitsNV values", "1.3-extensions"},
    {"VUID-VkDeviceDiagnosticsConfigCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV", "1.3-extensions"},
    {"VUID-VkDeviceEventInfoEXT-deviceEvent-parameter", "deviceEvent must be a valid VkDeviceEventTypeEXT value", "1.3-extensions"},
    {"VUID-VkDeviceEventInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDeviceEventInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDeviceFaultAddressInfoEXT-addressType-parameter", "addressType must be a valid VkDeviceFaultAddressTypeEXT value", "1.3-extensions"},
    {"VUID-VkDeviceFaultCountsEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDeviceFaultCountsEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_FAULT_COUNTS_EXT", "1.3-extensions"},
    {"VUID-VkDeviceFaultInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDeviceFaultInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_FAULT_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDeviceFaultVendorBinaryHeaderVersionOneEXT-headerSize-07340", "headerSize must be 56", "1.3-extensions"},
    {"VUID-VkDeviceFaultVendorBinaryHeaderVersionOneEXT-headerVersion-07341", "headerVersion must be VK_DEVICE_FAULT_VENDOR_BINARY_HEADER_VERSION_ONE_EXT", "1.3-extensions"},
    {"VUID-VkDeviceFaultVendorBinaryHeaderVersionOneEXT-headerVersion-parameter", "headerVersion must be a valid VkDeviceFaultVendorBinaryHeaderVersionEXT value", "1.3-extensions"},
    {"VUID-VkDeviceGroupBindSparseInfo-memoryDeviceIndex-01119", "Each memory allocation bound in this batch must have allocated an instance for memoryDeviceIndex", "1.3-extensions"},
    {"VUID-VkDeviceGroupBindSparseInfo-resourceDeviceIndex-01118", "resourceDeviceIndex and memoryDeviceIndex must both be valid device indices", "1.3-extensions"},
    {"VUID-VkDeviceGroupBindSparseInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO", "1.3-extensions"},
    {"VUID-VkDeviceGroupCommandBufferBeginInfo-deviceMask-00106", "deviceMask must be a valid device mask value", "1.3-extensions"},
    {"VUID-VkDeviceGroupCommandBufferBeginInfo-deviceMask-00107", "deviceMask must not be zero", "1.3-extensions"},
    {"VUID-VkDeviceGroupCommandBufferBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO", "1.3-extensions"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-00375", "Each element of pPhysicalDevices must be unique", "1.3-extensions"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-00376", "All elements of pPhysicalDevices must be in the same device group as enumerated by vkEnumeratePhysicalDeviceGroups", "1.3-extensions"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-parameter", "If physicalDeviceCount is not 0, pPhysicalDevices must be a valid pointer to an array of physicalDeviceCount valid VkPhysicalDevice handles", "1.3-extensions"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-physicalDeviceCount-00377", "If physicalDeviceCount is not 0, the physicalDevice parameter of vkCreateDevice must be an element of pPhysicalDevices", "1.3-extensions"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkDeviceGroupPresentCapabilitiesKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDeviceGroupPresentCapabilitiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR", "1.3-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01298", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR, then each element of pDeviceMasks must have exactly one bit set, and the corresponding element of VkDeviceGroupPresentCapabilitiesKHR::presentMask must be non-zero", "1.3-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01299", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR, then each element of pDeviceMasks must have exactly one bit set, and some physical device in the logical device must include that bit in its VkDeviceGroupPresentCapabilitiesKHR::presentMask", "1.3-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01300", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR, then each element of pDeviceMasks must have a value for which all set bits are set in one of the elements of VkDeviceGroupPresentCapabilitiesKHR::presentMask", "1.3-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01301", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR, then for each bit set in each element of pDeviceMasks, the corresponding element of VkDeviceGroupPresentCapabilitiesKHR::presentMask must be non-zero", "1.3-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01303", "mode must have exactly one bit set, and that bit must have been included in VkDeviceGroupSwapchainCreateInfoKHR::modes", "1.3-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-parameter", "mode must be a valid VkDeviceGroupPresentModeFlagBitsKHR value", "1.3-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-pDeviceMasks-01302", "The value of each element of pDeviceMasks must be equal to the device mask passed in VkAcquireNextImageInfoKHR::deviceMask when the image index was last acquired", "1.3-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-pDeviceMasks-parameter", "If swapchainCount is not 0, pDeviceMasks must be a valid pointer to an array of swapchainCount uint32_t values", "1.3-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR", "1.3-extensions"},
    {"VUID-VkDeviceGroupPresentInfoKHR-swapchainCount-01297", "swapchainCount must equal 0 or VkPresentInfoKHR::swapchainCount", "1.3-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00905", "deviceMask must be a valid device mask value", "1.3-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00906", "deviceMask must not be zero", "1.3-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00907", "deviceMask must be a subset of the command buffer's initial device mask", "1.3-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceRenderAreaCount-00908", "deviceRenderAreaCount must either be zero or equal to the number of physical devices in the logical device", "1.3-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-extent-08998", "The extent.width member of any element of pDeviceRenderAreas must be greater than 0", "1.3-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-extent-08999", "The extent.height member of any element of pDeviceRenderAreas must be greater than 0", "1.3-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-offset-06166", "The offset.x member of any element of pDeviceRenderAreas must be greater than or equal to 0", "1.3-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-offset-06167", "The offset.y member of any element of pDeviceRenderAreas must be greater than or equal to 0", "1.3-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-offset-06168", "The sum of the offset.x and extent.width members of any element of pDeviceRenderAreas must be less than or equal to maxFramebufferWidth", "1.3-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-offset-06169", "The sum of the offset.y and extent.height members of any element of pDeviceRenderAreas must be less than or equal to maxFramebufferHeight", "1.3-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-pDeviceRenderAreas-parameter", "If deviceRenderAreaCount is not 0, pDeviceRenderAreas must be a valid pointer to an array of deviceRenderAreaCount VkRect2D structures", "1.3-extensions"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO", "1.3-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-commandBufferCount-00083", "commandBufferCount must equal VkSubmitInfo::commandBufferCount", "1.3-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks-00086", "All elements of pCommandBufferDeviceMasks must be valid device masks", "1.3-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks-parameter", "If commandBufferCount is not 0, pCommandBufferDeviceMasks must be a valid pointer to an array of commandBufferCount uint32_t values", "1.3-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-pSignalSemaphoreDeviceIndices-parameter", "If signalSemaphoreCount is not 0, pSignalSemaphoreDeviceIndices must be a valid pointer to an array of signalSemaphoreCount uint32_t values", "1.3-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices-00085", "All elements of pWaitSemaphoreDeviceIndices and pSignalSemaphoreDeviceIndices must be valid device indices", "1.3-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices-parameter", "If waitSemaphoreCount is not 0, pWaitSemaphoreDeviceIndices must be a valid pointer to an array of waitSemaphoreCount uint32_t values", "1.3-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO", "1.3-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-signalSemaphoreCount-00084", "signalSemaphoreCount must equal VkSubmitInfo::signalSemaphoreCount", "1.3-extensions"},
    {"VUID-VkDeviceGroupSubmitInfo-waitSemaphoreCount-00082", "waitSemaphoreCount must equal VkSubmitInfo::waitSemaphoreCount", "1.3-extensions"},
    {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-parameter", "modes must be a valid combination of VkDeviceGroupPresentModeFlagBitsKHR values", "1.3-extensions"},
    {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-requiredbitmask", "modes must not be 0", "1.3-extensions"},
    {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06416", "The pCreateInfo->pNext chain must not contain a VkImageSwapchainCreateInfoKHR structure", "1.3-extensions"},
    {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06417", "If pCreateInfo->format specifies a multi-planar format and pCreateInfo->flags has VK_IMAGE_CREATE_DISJOINT_BIT set then planeAspect must not be VK_IMAGE_ASPECT_NONE_KHR", "1.3-extensions"},
    {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06419", "If pCreateInfo->flags has VK_IMAGE_CREATE_DISJOINT_BIT set and if the pCreateInfo->tiling is VK_IMAGE_TILING_LINEAR or VK_IMAGE_TILING_OPTIMAL, then planeAspect must be a single valid multi-planar aspect mask bit", "1.3-extensions"},
    {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06420", "If pCreateInfo->tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then planeAspect must be a single valid memory plane for the image (that is, aspectMask must specify a plane index that is less than the VkDrmFormatModifierPropertiesEXT::drmFormatModifierPlaneCount associated with the image's format and VkImageDrmFormatModifierPropertiesEXT::drmFormatModifier)", "1.3-extensions"},
    {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06776", "The pCreateInfo->pNext chain must not contain a VkImageDrmFormatModifierExplicitCreateInfoEXT structure", "1.3-extensions"},
    {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-parameter", "pCreateInfo must be a valid pointer to a valid VkImageCreateInfo structure", "1.3-extensions"},
    {"VUID-VkDeviceImageMemoryRequirements-pNext-06996", "Applications also must not call vkGetDeviceImageMemoryRequirements with a VkImageCreateInfo whose pNext chain includes a VkExternalFormatANDROID structure with non-zero externalFormat", "1.3-extensions"},
    {"VUID-VkDeviceImageMemoryRequirements-pNext-08962", "Applications also must not call vkGetDeviceImageMemoryRequirements with a VkImageCreateInfo whose pNext chain includes a VkExternalFormatQNX structure with non-zero externalFormat", "1.3-extensions"},
    {"VUID-VkDeviceImageMemoryRequirements-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDeviceImageMemoryRequirements-planeAspect-parameter", "If planeAspect is not 0, planeAspect must be a valid VkImageAspectFlagBits value", "1.3-extensions"},
    {"VUID-VkDeviceImageMemoryRequirements-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS", "1.3-extensions"},
    {"VUID-VkDeviceImageSubresourceInfoKHR-arrayLayer-01717", "The arrayLayer member of pSubresource must be less than the arrayLayers specified in pCreateInfo", "1.3-extensions"},
    {"VUID-VkDeviceImageSubresourceInfoKHR-aspectMask-00997", "The aspectMask member of pSubresource must only have a single bit set", "1.3-extensions"},
    {"VUID-VkDeviceImageSubresourceInfoKHR-format-04462", "If format of the pCreateInfo has a depth component, the aspectMask member of pSubresource must contain VK_IMAGE_ASPECT_DEPTH_BIT", "1.3-extensions"},
    {"VUID-VkDeviceImageSubresourceInfoKHR-format-04463", "If format of the pCreateInfo has a stencil component, the aspectMask member of pSubresource must contain VK_IMAGE_ASPECT_STENCIL_BIT", "1.3-extensions"},
    {"VUID-VkDeviceImageSubresourceInfoKHR-format-04464", "If format of the pCreateInfo does not contain a stencil or depth component, the aspectMask member of pSubresource must not contain VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT", "1.3-extensions"},
    {"VUID-VkDeviceImageSubresourceInfoKHR-format-08886", "If format of the image is a color format that is not a multi-planar image format, and tiling of the pCreateInfo is VK_IMAGE_TILING_LINEAR or VK_IMAGE_TILING_OPTIMAL, the aspectMask member of pSubresource must be VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkDeviceImageSubresourceInfoKHR-mipLevel-01716", "The mipLevel member of pSubresource must be less than the mipLevels specified in pCreateInfo", "1.3-extensions"},
    {"VUID-VkDeviceImageSubresourceInfoKHR-pCreateInfo-parameter", "pCreateInfo must be a valid pointer to a valid VkImageCreateInfo structure", "1.3-extensions"},
    {"VUID-VkDeviceImageSubresourceInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDeviceImageSubresourceInfoKHR-pSubresource-parameter", "pSubresource must be a valid pointer to a valid VkImageSubresource2KHR structure", "1.3-extensions"},
    {"VUID-VkDeviceImageSubresourceInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkDeviceImageSubresourceInfoKHR-tiling-08717", "If the tiling of the pCreateInfo is VK_IMAGE_TILING_LINEAR and has a multi-planar image format, then the aspectMask member of pSubresource must be a single valid multi-planar aspect mask bit", "1.3-extensions"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-memory-03336", "memory must have been allocated with VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT", "1.3-extensions"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.3-extensions"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO", "1.3-extensions"},
    {"VUID-VkDeviceMemoryOverallocationCreateInfoAMD-overallocationBehavior-parameter", "overallocationBehavior must be a valid VkMemoryOverallocationBehaviorAMD value", "1.3-extensions"},
    {"VUID-VkDeviceMemoryOverallocationCreateInfoAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD", "1.3-extensions"},
    {"VUID-VkDeviceMemoryReportCallbackDataEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDeviceMemoryReportCallbackDataEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT", "1.3-extensions"},
    {"VUID-VkDevicePrivateDataCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-flags-02861", "If the protectedMemory feature is not enabled, the VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT bit of flags must not be set", "1.3-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-flags-06449", "If flags includes VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT, queueFamilyIndex must be the index of a queue family that includes the VK_QUEUE_PROTECTED_BIT capability", "1.3-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-flags-parameter", "flags must be a valid combination of VkDeviceQueueCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-pNext-09398", "If the pNext chain includes a VkDeviceQueueShaderCoreControlCreateInfoARM structure then VkPhysicalDeviceSchedulingControlsPropertiesARM::schedulingControlsFlags must contain VK_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_SHADER_CORE_COUNT_ARM", "1.3-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceQueueGlobalPriorityCreateInfoKHR or VkDeviceQueueShaderCoreControlCreateInfoARM", "1.3-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-pQueuePriorities-00383", "Each element of pQueuePriorities must be between 0.0 and 1.0 inclusive", "1.3-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-pQueuePriorities-parameter", "pQueuePriorities must be a valid pointer to an array of queueCount float values", "1.3-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-queueCount-00382", "queueCount must be less than or equal to the queueCount member of the VkQueueFamilyProperties structure, as returned by vkGetPhysicalDeviceQueueFamilyProperties in the pQueueFamilyProperties[queueFamilyIndex]", "1.3-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-queueCount-arraylength", "queueCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-queueFamilyIndex-00381", "queueFamilyIndex must be less than pQueueFamilyPropertyCount returned by vkGetPhysicalDeviceQueueFamilyProperties", "1.3-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkDeviceQueueCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkDeviceQueueGlobalPriorityCreateInfoKHR-globalPriority-parameter", "globalPriority must be a valid VkQueueGlobalPriorityKHR value", "1.3-extensions"},
    {"VUID-VkDeviceQueueGlobalPriorityCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkDeviceQueueInfo2-flags-06225", "flags must be equal to VkDeviceQueueCreateInfo::flags for a VkDeviceQueueCreateInfo structure for the queue family indicated by queueFamilyIndex when device was created", "1.3-extensions"},
    {"VUID-VkDeviceQueueInfo2-flags-parameter", "flags must be a valid combination of VkDeviceQueueCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkDeviceQueueInfo2-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDeviceQueueInfo2-queueFamilyIndex-01842", "queueFamilyIndex must be one of the queue family indices specified when device was created, via the VkDeviceQueueCreateInfo structure", "1.3-extensions"},
    {"VUID-VkDeviceQueueInfo2-queueIndex-01843", "queueIndex must be less than VkDeviceQueueCreateInfo::queueCount for the corresponding queue family and flags indicated by queueFamilyIndex and flags when device was created", "1.3-extensions"},
    {"VUID-VkDeviceQueueInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2", "1.3-extensions"},
    {"VUID-VkDeviceQueueShaderCoreControlCreateInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_SHADER_CORE_CONTROL_CREATE_INFO_ARM", "1.3-extensions"},
    {"VUID-VkDeviceQueueShaderCoreControlCreateInfoARM-shaderCoreCount-09399", "shaderCoreCount must be greater than 0 and less than or equal to the total number of shader cores as reported via VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM::shaderCoreCount", "1.3-extensions"},
    {"VUID-VkDirectDriverLoadingInfoLUNARG-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkDirectDriverLoadingInfoLUNARG-sType-sType", "sType must be VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG", "1.3-extensions"},
    {"VUID-VkDirectDriverLoadingListLUNARG-driverCount-arraylength", "driverCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkDirectDriverLoadingListLUNARG-mode-parameter", "mode must be a valid VkDirectDriverLoadingModeLUNARG value", "1.3-extensions"},
    {"VUID-VkDirectDriverLoadingListLUNARG-pDrivers-parameter", "pDrivers must be a valid pointer to an array of driverCount valid VkDirectDriverLoadingInfoLUNARG structures", "1.3-extensions"},
    {"VUID-VkDirectDriverLoadingListLUNARG-sType-sType", "sType must be VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG", "1.3-extensions"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-dfb-04117", "dfb must point to a valid DirectFB IDirectFB", "1.3-extensions"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-surface-04118", "surface must point to a valid DirectFB IDirectFBSurface", "1.3-extensions"},
    {"VUID-VkDispatchGraphInfoAMDX-payloadCount-09171", "payloadCount must be no greater than maxExecutionGraphShaderPayloadCount", "1.3-extensions"},
    {"VUID-VkDispatchIndirectCommand-x-00417", "x must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[0]", "1.3-extensions"},
    {"VUID-VkDispatchIndirectCommand-y-00418", "y must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[1]", "1.3-extensions"},
    {"VUID-VkDispatchIndirectCommand-z-00419", "z must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[2]", "1.3-extensions"},
    {"VUID-VkDisplayEventInfoEXT-displayEvent-parameter", "displayEvent must be a valid VkDisplayEventTypeEXT value", "1.3-extensions"},
    {"VUID-VkDisplayEventInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDisplayEventInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDisplayModeCreateInfoKHR-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkDisplayModeCreateInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDisplayModeCreateInfoKHR-parameters-parameter", "parameters must be a valid VkDisplayModeParametersKHR structure", "1.3-extensions"},
    {"VUID-VkDisplayModeCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkDisplayModeParametersKHR-height-01991", "The height member of visibleRegion must be greater than 0", "1.3-extensions"},
    {"VUID-VkDisplayModeParametersKHR-refreshRate-01992", "refreshRate must be greater than 0", "1.3-extensions"},
    {"VUID-VkDisplayModeParametersKHR-width-01990", "The width member of visibleRegion must be greater than 0", "1.3-extensions"},
    {"VUID-VkDisplayModeProperties2KHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDisplayModeProperties2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR", "1.3-extensions"},
    {"VUID-VkDisplayNativeHdrSurfaceCapabilitiesAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD", "1.3-extensions"},
    {"VUID-VkDisplayPlaneCapabilities2KHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDisplayPlaneCapabilities2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR", "1.3-extensions"},
    {"VUID-VkDisplayPlaneInfo2KHR-mode-parameter", "mode must be a valid VkDisplayModeKHR handle", "1.3-extensions"},
    {"VUID-VkDisplayPlaneInfo2KHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDisplayPlaneInfo2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR", "1.3-extensions"},
    {"VUID-VkDisplayPlaneProperties2KHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDisplayPlaneProperties2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR", "1.3-extensions"},
    {"VUID-VkDisplayPowerInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDisplayPowerInfoEXT-powerState-parameter", "powerState must be a valid VkDisplayPowerStateEXT value", "1.3-extensions"},
    {"VUID-VkDisplayPowerInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT", "1.3-extensions"},
    {"VUID-VkDisplayPresentInfoKHR-dstRect-01258", "dstRect must specify a rectangular region that is a subset of the visibleRegion parameter of the display mode the swapchain being presented uses", "1.3-extensions"},
    {"VUID-VkDisplayPresentInfoKHR-persistentContent-01259", "If the persistentContent member of the VkDisplayPropertiesKHR structure returned by vkGetPhysicalDeviceDisplayPropertiesKHR for the display the present operation targets is VK_FALSE, then persistent must be VK_FALSE", "1.3-extensions"},
    {"VUID-VkDisplayPresentInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR", "1.3-extensions"},
    {"VUID-VkDisplayPresentInfoKHR-srcRect-01257", "srcRect must specify a rectangular region that is a subset of the image being presented", "1.3-extensions"},
    {"VUID-VkDisplayProperties2KHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDisplayProperties2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR", "1.3-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-01254", "If alphaMode is VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR then globalAlpha must be between 0 and 1, inclusive", "1.3-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-01255", "alphaMode must be one of the bits present in the supportedAlpha member of VkDisplayPlaneCapabilitiesKHR for the display plane corresponding to displayMode", "1.3-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-parameter", "alphaMode must be a valid VkDisplayPlaneAlphaFlagBitsKHR value", "1.3-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-displayMode-parameter", "displayMode must be a valid VkDisplayModeKHR handle", "1.3-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-planeIndex-01252", "planeIndex must be less than the number of display planes supported by the device as determined by calling vkGetPhysicalDeviceDisplayPlanePropertiesKHR", "1.3-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-planeReorderPossible-01253", "If the planeReorderPossible member of the VkDisplayPropertiesKHR structure returned by vkGetPhysicalDeviceDisplayPropertiesKHR for the display corresponding to displayMode is VK_TRUE then planeStackIndex must be less than the number of display planes supported by the device as determined by calling vkGetPhysicalDeviceDisplayPlanePropertiesKHR; otherwise planeStackIndex must equal the currentStackIndex member of VkDisplayPlanePropertiesKHR returned by vkGetPhysicalDeviceDisplayPlanePropertiesKHR for the display plane corresponding to displayMode", "1.3-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-transform-06740", "transform must be one of the bits present in the supportedTransforms member of VkDisplayPropertiesKHR for the display corresponding to displayMode", "1.3-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-transform-parameter", "transform must be a valid VkSurfaceTransformFlagBitsKHR value", "1.3-extensions"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-width-01256", "The width and height members of imageExtent must be less than or equal to VkPhysicalDeviceLimits::maxImageDimension2D", "1.3-extensions"},
    {"VUID-VkDrawIndexedIndirectCommand-None-00552", "For a given vertex buffer binding, any attribute data fetched must be entirely contained within the corresponding vertex buffer binding, as described in Vertex Input Description", "1.3-extensions"},
    {"VUID-VkDrawIndexedIndirectCommand-None-09462", "If shader objects are used for drawing or the bound graphics pipeline state was created with the VK_DYNAMIC_STATE_VERTEX_INPUT_EXT dynamic state enabled, any member of the pVertexBindingDescriptions parameter to the vkCmdSetVertexInputEXT call that sets this dynamic state has a value other than 1 in divisor, and VkPhysicalDeviceVertexAttributeDivisorPropertiesKHR::supportsNonZeroFirstInstance is VK_FALSE, then firstInstance must be 0", "1.3-extensions"},
    {"VUID-VkDrawIndexedIndirectCommand-firstInstance-00554", "If the drawIndirectFirstInstance feature is not enabled, firstInstance must be 0", "1.3-extensions"},
    {"VUID-VkDrawIndexedIndirectCommand-pNext-09461", "If the bound graphics pipeline state was created with VkPipelineVertexInputDivisorStateCreateInfoKHR in the pNext chain of VkGraphicsPipelineCreateInfo::pVertexInputState, any member of VkPipelineVertexInputDivisorStateCreateInfoKHR::pVertexBindingDivisors has a value other than 1 in divisor, and VkPhysicalDeviceVertexAttributeDivisorPropertiesKHR::supportsNonZeroFirstInstance is VK_FALSE, then firstInstance must be 0", "1.3-extensions"},
    {"VUID-VkDrawIndexedIndirectCommand-robustBufferAccess2-08798", "If robustBufferAccess2 is not enabled, (indexSize × (firstIndex + indexCount) + offset) must be less than or equal to the size of the bound index buffer, with indexSize being based on the type specified by indexType, where the index buffer, indexType, and offset are specified via vkCmdBindIndexBuffer or vkCmdBindIndexBuffer2KHR. If vkCmdBindIndexBuffer2KHR is used to bind the index buffer, the size of the bound index buffer is vkCmdBindIndexBuffer2KHR::size", "1.3-extensions"},
    {"VUID-VkDrawIndirectCommand-None-00500", "For a given vertex buffer binding, any attribute data fetched must be entirely contained within the corresponding vertex buffer binding, as described in Vertex Input Description", "1.3-extensions"},
    {"VUID-VkDrawIndirectCommand-None-09462", "If shader objects are used for drawing or the bound graphics pipeline state was created with the VK_DYNAMIC_STATE_VERTEX_INPUT_EXT dynamic state enabled, any member of the pVertexBindingDescriptions parameter to the vkCmdSetVertexInputEXT call that sets this dynamic state has a value other than 1 in divisor, and VkPhysicalDeviceVertexAttributeDivisorPropertiesKHR::supportsNonZeroFirstInstance is VK_FALSE, then firstInstance must be 0", "1.3-extensions"},
    {"VUID-VkDrawIndirectCommand-firstInstance-00501", "If the drawIndirectFirstInstance feature is not enabled, firstInstance must be 0", "1.3-extensions"},
    {"VUID-VkDrawIndirectCommand-pNext-09461", "If the bound graphics pipeline state was created with VkPipelineVertexInputDivisorStateCreateInfoKHR in the pNext chain of VkGraphicsPipelineCreateInfo::pVertexInputState, any member of VkPipelineVertexInputDivisorStateCreateInfoKHR::pVertexBindingDivisors has a value other than 1 in divisor, and VkPhysicalDeviceVertexAttributeDivisorPropertiesKHR::supportsNonZeroFirstInstance is VK_FALSE, then firstInstance must be 0", "1.3-extensions"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07322", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS contains a shader using the TaskEXT Execution Model, groupCountX must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupCount[0]", "1.3-extensions"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07323", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS contains a shader using the TaskEXT Execution Model, groupCountY must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupCount[1]", "1.3-extensions"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07324", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS contains a shader using the TaskEXT Execution Model, groupCountZ must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupCount[2]", "1.3-extensions"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07325", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS contains a shader using the TaskEXT Execution Model, The product of groupCountX, groupCountY and groupCountZ must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupTotalCount", "1.3-extensions"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07326", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS does not contain a shader using the TaskEXT Execution Model, groupCountX must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[0]", "1.3-extensions"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07327", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS does not contain a shader using the TaskEXT Execution Model, groupCountY must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[1]", "1.3-extensions"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07328", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS does not contain a shader using the TaskEXT Execution Model, groupCountZ must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[2]", "1.3-extensions"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07329", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS does not contain a shader using the TaskEXT Execution Model, The product of groupCountX, groupCountY and groupCountZ must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupTotalCount", "1.3-extensions"},
    {"VUID-VkDrawMeshTasksIndirectCommandNV-taskCount-02175", "taskCount must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxDrawMeshTasksCount", "1.3-extensions"},
    {"VUID-VkDrmFormatModifierPropertiesList2EXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT", "1.3-extensions"},
    {"VUID-VkDrmFormatModifierPropertiesListEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT", "1.3-extensions"},
    {"VUID-VkEventCreateInfo-flags-parameter", "flags must be a valid combination of VkEventCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkEventCreateInfo-pNext-06790", "If the pNext chain includes a VkExportMetalObjectCreateInfoEXT structure, its exportObjectType member must be VK_EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT", "1.3-extensions"},
    {"VUID-VkEventCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExportMetalObjectCreateInfoEXT or VkImportMetalSharedEventInfoEXT", "1.3-extensions"},
    {"VUID-VkEventCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EVENT_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkEventCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique, with the exception of structures of type VkExportMetalObjectCreateInfoEXT", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-CoalescedInputCountAMDX-09137", "There must be no two nodes in the pipeline that share the same name where one includes CoalescedInputCountAMDX and the other does not", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-09134", "There must be no two nodes in the pipeline that share both the same shader name and index, as specified by VkPipelineShaderStageNodeCreateInfoAMDX", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-09135", "There must be no two nodes in the pipeline that share the same shader name and have input payload declarations with different sizes", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-09136", "There must be no two nodes in the pipeline that share the same name but have different execution models", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-09497", "If the pNext chain does not include a VkPipelineCreateFlags2CreateInfoKHR structure, flags must be a valid combination of VkPipelineCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-PayloadNodeNameAMDX-09139", "If an output payload declared in any shader in the pipeline has a PayloadNodeNameAMDX decoration with a Node Name that matches the shader name of any other node in the graph, the size of the output payload must match the size of the input payload in the matching node", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-StaticNumWorkgroupsAMDX-09138", "There must be no two nodes in the pipeline that share the same name where one includes StaticNumWorkgroupsAMDX and the other does not", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-commonparent", "Both of basePipelineHandle, and layout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03365", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03366", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03367", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03368", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03369", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03370", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03576", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-04945", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-07984", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid execution graph VkPipeline handle", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-07985", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-07986", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, basePipelineIndex must be -1 or basePipelineHandle must be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-09007", "If the VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputePipelines is not enabled, flags must not include VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-09008", "If flags includes VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then the pNext chain must include a pointer to a valid instance of VkComputePipelineIndirectBufferInfoNV specifying the address where the pipeline's metadata will be saved", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-07987", "If a push constant block is declared in a shader, a push constant range in layout must match both the shader stage and range", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-07988", "If a resource variables is declared in a shader, a descriptor slot in layout must match the shader stage", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-07990", "If a resource variables is declared in a shader, and the descriptor type is not VK_DESCRIPTOR_TYPE_MUTABLE_EXT, a descriptor slot in layout must match the descriptor type", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-07991", "If a resource variables is declared in a shader as an array, a descriptor slot in layout must match the descriptor count", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-09130", "layout must be consistent with the layout of the shaders specified in pStages", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-09132", "The number of resources in layout accessible to each shader stage that is used by the pipeline must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-parameter", "layout must be a valid VkPipelineLayout handle", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pLibraryInfo-09131", "If pLibraryInfo is not NULL, each element of its pLibraries member must have been created with a layout that is compatible with the layout in this pipeline", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pLibraryInfo-09133", "If pLibraryInfo is not NULL, each element of pLibraryInfo->libraries must be either a compute pipeline or an execution graph pipeline", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pLibraryInfo-parameter", "If pLibraryInfo is not NULL, pLibraryInfo must be a valid pointer to a valid VkPipelineLibraryCreateInfoKHR structure", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPipelineCompilerControlCreateInfoAMD or VkPipelineCreationFeedbackCreateInfo", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pStages-09129", "The shader code for the entry point identified by each element of pStages and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pStages-parameter", "If stageCount is not 0, and pStages is not NULL, pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pipelineCreationCacheControl-02875", "If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT or VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_CREATE_INFO_AMDX", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-stage-09128", "The stage member of any element of pStages must be VK_SHADER_STAGE_COMPUTE_BIT", "1.3-extensions"},
    {"VUID-VkExecutionGraphPipelineScratchSizeAMDX-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_SCRATCH_SIZE_AMDX", "1.3-extensions"},
    {"VUID-VkExportFenceCreateInfo-handleTypes-01446", "The bits in handleTypes must be supported and compatible, as reported by VkExternalFenceProperties", "1.3-extensions"},
    {"VUID-VkExportFenceCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalFenceHandleTypeFlagBits values", "1.3-extensions"},
    {"VUID-VkExportFenceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkExportFenceWin32HandleInfoKHR-handleTypes-01447", "If VkExportFenceCreateInfo::handleTypes does not include VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT, a VkExportFenceWin32HandleInfoKHR structure must not be included in the pNext chain of VkFenceCreateInfo", "1.3-extensions"},
    {"VUID-VkExportFenceWin32HandleInfoKHR-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", "1.3-extensions"},
    {"VUID-VkExportFenceWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkExportMemoryAllocateInfo-handleTypes-00656", "The bits in handleTypes must be supported and compatible, as reported by VkExternalImageFormatProperties or VkExternalBufferProperties", "1.3-extensions"},
    {"VUID-VkExportMemoryAllocateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values", "1.3-extensions"},
    {"VUID-VkExportMemoryAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO", "1.3-extensions"},
    {"VUID-VkExportMemoryAllocateInfoNV-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBitsNV values", "1.3-extensions"},
    {"VUID-VkExportMemoryAllocateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV", "1.3-extensions"},
    {"VUID-VkExportMemoryWin32HandleInfoKHR-handleTypes-00657", "If VkExportMemoryAllocateInfo::handleTypes does not include VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, a VkExportMemoryWin32HandleInfoKHR structure must not be included in the pNext chain of VkMemoryAllocateInfo", "1.3-extensions"},
    {"VUID-VkExportMemoryWin32HandleInfoKHR-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", "1.3-extensions"},
    {"VUID-VkExportMemoryWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkExportMemoryWin32HandleInfoNV-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", "1.3-extensions"},
    {"VUID-VkExportMemoryWin32HandleInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV", "1.3-extensions"},
    {"VUID-VkExportMetalBufferInfoEXT-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.3-extensions"},
    {"VUID-VkExportMetalBufferInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_BUFFER_INFO_EXT", "1.3-extensions"},
    {"VUID-VkExportMetalCommandQueueInfoEXT-queue-parameter", "queue must be a valid VkQueue handle", "1.3-extensions"},
    {"VUID-VkExportMetalCommandQueueInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_COMMAND_QUEUE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkExportMetalDeviceInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_DEVICE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkExportMetalIOSurfaceInfoEXT-image-parameter", "image must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkExportMetalIOSurfaceInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_IO_SURFACE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkExportMetalObjectCreateInfoEXT-exportObjectType-parameter", "If exportObjectType is not 0, exportObjectType must be a valid VkExportMetalObjectTypeFlagBitsEXT value", "1.3-extensions"},
    {"VUID-VkExportMetalObjectCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06791", "If the pNext chain includes a VkExportMetalDeviceInfoEXT structure, the VkInstance must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_DEVICE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkInstanceCreateInfo structure in the vkCreateInstance command", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06792", "If the pNext chain includes a VkExportMetalCommandQueueInfoEXT structure, the VkInstance must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_COMMAND_QUEUE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkInstanceCreateInfo structure in the vkCreateInstance command", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06793", "If the pNext chain includes a VkExportMetalBufferInfoEXT structure, the VkDeviceMemory in its memory member must have been allocated with VK_EXPORT_METAL_OBJECT_TYPE_METAL_BUFFER_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkMemoryAllocateInfo structure in the vkAllocateMemory command", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06794", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, exactly one of its image, imageView, or bufferView members must not be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06795", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and its image member is not VK_NULL_HANDLE, the VkImage in its image member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkImageCreateInfo structure in the vkCreateImage command", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06796", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and its imageView member is not VK_NULL_HANDLE, the VkImageView in its imageView member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkImageViewCreateInfo structure in the vkCreateImageView command", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06797", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and its bufferView member is not VK_NULL_HANDLE, the VkBufferView in its bufferView member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkBufferViewCreateInfo structure in the vkCreateBufferView command", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06798", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if either its image or imageView member is not VK_NULL_HANDLE, then plane must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06799", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if the VkImage in its image member does not have a multi-planar format, then its plane member must be VK_IMAGE_ASPECT_PLANE_0_BIT", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06800", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if the VkImage in its image member has a multi-planar format with only two planes, then its plane member must not be VK_IMAGE_ASPECT_PLANE_2_BIT", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06801", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if the VkImageView in its imageView member does not have a multi-planar format, then its plane member must be VK_IMAGE_ASPECT_PLANE_0_BIT", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06802", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if the VkImageView in its imageView member has a multi-planar format with only two planes, then its plane member must not be VK_IMAGE_ASPECT_PLANE_2_BIT", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06803", "If the pNext chain includes a VkExportMetalIOSurfaceInfoEXT structure, the VkImage in its image member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_IOSURFACE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkImageCreateInfo structure in the vkCreateImage command", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06804", "If the pNext chain includes a VkExportMetalSharedEventInfoEXT structure, exactly one of its semaphore or event members must not be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06805", "If the pNext chain includes a VkExportMetalSharedEventInfoEXT structure, and its semaphore member is not VK_NULL_HANDLE, the VkSemaphore in its semaphore member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkSemaphoreCreateInfo structure in the vkCreateSemaphore command", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06806", "If the pNext chain includes a VkExportMetalSharedEventInfoEXT structure, and its event member is not VK_NULL_HANDLE, the VkEvent in its event member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkEventCreateInfo structure in the vkCreateEvent command", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExportMetalBufferInfoEXT, VkExportMetalCommandQueueInfoEXT, VkExportMetalDeviceInfoEXT, VkExportMetalIOSurfaceInfoEXT, VkExportMetalSharedEventInfoEXT, or VkExportMetalTextureInfoEXT", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECTS_INFO_EXT", "1.3-extensions"},
    {"VUID-VkExportMetalObjectsInfoEXT-sType-unique", "The sType value of each struct in the pNext chain must be unique, with the exception of structures of type VkExportMetalBufferInfoEXT, VkExportMetalCommandQueueInfoEXT, VkExportMetalIOSurfaceInfoEXT, VkExportMetalSharedEventInfoEXT, or VkExportMetalTextureInfoEXT", "1.3-extensions"},
    {"VUID-VkExportMetalSharedEventInfoEXT-commonparent", "Both of event, and semaphore that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkExportMetalSharedEventInfoEXT-event-parameter", "If event is not VK_NULL_HANDLE, event must be a valid VkEvent handle", "1.3-extensions"},
    {"VUID-VkExportMetalSharedEventInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_SHARED_EVENT_INFO_EXT", "1.3-extensions"},
    {"VUID-VkExportMetalSharedEventInfoEXT-semaphore-parameter", "If semaphore is not VK_NULL_HANDLE, semaphore must be a valid VkSemaphore handle", "1.3-extensions"},
    {"VUID-VkExportMetalTextureInfoEXT-bufferView-parameter", "If bufferView is not VK_NULL_HANDLE, bufferView must be a valid VkBufferView handle", "1.3-extensions"},
    {"VUID-VkExportMetalTextureInfoEXT-commonparent", "Each of bufferView, image, and imageView that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkExportMetalTextureInfoEXT-image-parameter", "If image is not VK_NULL_HANDLE, image must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkExportMetalTextureInfoEXT-imageView-parameter", "If imageView is not VK_NULL_HANDLE, imageView must be a valid VkImageView handle", "1.3-extensions"},
    {"VUID-VkExportMetalTextureInfoEXT-plane-parameter", "plane must be a valid VkImageAspectFlagBits value", "1.3-extensions"},
    {"VUID-VkExportMetalTextureInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_TEXTURE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkExportSemaphoreCreateInfo-handleTypes-01124", "The bits in handleTypes must be supported and compatible, as reported by VkExternalSemaphoreProperties", "1.3-extensions"},
    {"VUID-VkExportSemaphoreCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalSemaphoreHandleTypeFlagBits values", "1.3-extensions"},
    {"VUID-VkExportSemaphoreCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkExportSemaphoreWin32HandleInfoKHR-handleTypes-01125", "If VkExportSemaphoreCreateInfo::handleTypes does not include VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT, VkExportSemaphoreWin32HandleInfoKHR must not be included in the pNext chain of VkSemaphoreCreateInfo", "1.3-extensions"},
    {"VUID-VkExportSemaphoreWin32HandleInfoKHR-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", "1.3-extensions"},
    {"VUID-VkExportSemaphoreWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkExternalBufferProperties-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkExternalBufferProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES", "1.3-extensions"},
    {"VUID-VkExternalFenceProperties-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkExternalFenceProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES", "1.3-extensions"},
    {"VUID-VkExternalFormatANDROID-externalFormat-01894", "externalFormat must be 0 or a value returned in the externalFormat member of VkAndroidHardwareBufferFormatPropertiesANDROID by an earlier call to vkGetAndroidHardwareBufferPropertiesANDROID", "1.3-extensions"},
    {"VUID-VkExternalFormatANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID", "1.3-extensions"},
    {"VUID-VkExternalFormatQNX-externalFormat-08956", "externalFormat must be 0 or a value returned in the externalFormat member of VkScreenBufferFormatPropertiesQNX by an earlier call to vkGetScreenBufferPropertiesQNX", "1.3-extensions"},
    {"VUID-VkExternalFormatQNX-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_QNX", "1.3-extensions"},
    {"VUID-VkExternalImageFormatProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES", "1.3-extensions"},
    {"VUID-VkExternalMemoryAcquireUnmodifiedEXT-acquireUnmodifiedMemory-08922", "If acquireUnmodifiedMemory is VK_TRUE, and the memory barrier's srcQueueFamilyIndex is a special queue family reserved for external memory ownership transfers (as described in Queue Family Ownership Transfer), then each range of VkDeviceMemory bound to the resource must have remained unmodified during all time since the resource's most recent release of ownership to the queue family", "1.3-extensions"},
    {"VUID-VkExternalMemoryAcquireUnmodifiedEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT", "1.3-extensions"},
    {"VUID-VkExternalMemoryBufferCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values", "1.3-extensions"},
    {"VUID-VkExternalMemoryBufferCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkExternalMemoryImageCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values", "1.3-extensions"},
    {"VUID-VkExternalMemoryImageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkExternalMemoryImageCreateInfoNV-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBitsNV values", "1.3-extensions"},
    {"VUID-VkExternalMemoryImageCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV", "1.3-extensions"},
    {"VUID-VkExternalSemaphoreProperties-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkExternalSemaphoreProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES", "1.3-extensions"},
    {"VUID-VkFenceCreateInfo-flags-parameter", "flags must be a valid combination of VkFenceCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkFenceCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExportFenceCreateInfo or VkExportFenceWin32HandleInfoKHR", "1.3-extensions"},
    {"VUID-VkFenceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FENCE_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkFenceCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-fence-01455", "fence must not currently have its payload replaced by an imported payload as described below in Importing Fence Payloads unless that imported payload's handle type was included in VkExternalFenceProperties::exportFromImportedHandleTypes for handleType", "1.3-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-fence-parameter", "fence must be a valid VkFence handle", "1.3-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-01453", "handleType must have been included in VkExportFenceCreateInfo::handleTypes when fence's current payload was created", "1.3-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-01454", "If handleType refers to a handle type with copy payload transference semantics, fence must be signaled, or have an associated fence signal operation pending execution", "1.3-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-01456", "handleType must be defined as a POSIX file descriptor handle", "1.3-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-parameter", "handleType must be a valid VkExternalFenceHandleTypeFlagBits value", "1.3-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkFenceGetFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR", "1.3-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-fence-01450", "fence must not currently have its payload replaced by an imported payload as described below in Importing Fence Payloads unless that imported payload's handle type was included in VkExternalFenceProperties::exportFromImportedHandleTypes for handleType", "1.3-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-fence-parameter", "fence must be a valid VkFence handle", "1.3-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01448", "handleType must have been included in VkExportFenceCreateInfo::handleTypes when the fence's current payload was created", "1.3-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01449", "If handleType is defined as an NT handle, vkGetFenceWin32HandleKHR must be called no more than once for each valid unique combination of fence and handleType", "1.3-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01451", "If handleType refers to a handle type with copy payload transference semantics, fence must be signaled, or have an associated fence signal operation pending execution", "1.3-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01452", "handleType must be defined as an NT handle or a global share handle", "1.3-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-parameter", "handleType must be a valid VkExternalFenceHandleTypeFlagBits value", "1.3-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkFilterCubicImageViewImageFormatPropertiesEXT-pNext-02627", "If the pNext chain of the VkImageFormatProperties2 structure includes a VkFilterCubicImageViewImageFormatPropertiesEXT structure, the pNext chain of the VkPhysicalDeviceImageFormatInfo2 structure must include a VkPhysicalDeviceImageViewImageFormatInfoEXT structure with an imageViewType that is compatible with imageType", "1.3-extensions"},
    {"VUID-VkFilterCubicImageViewImageFormatPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT", "1.3-extensions"},
    {"VUID-VkFormatProperties2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDrmFormatModifierPropertiesList2EXT, VkDrmFormatModifierPropertiesListEXT, VkFormatProperties3, or VkSubpassResolvePerformanceQueryEXT", "1.3-extensions"},
    {"VUID-VkFormatProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2", "1.3-extensions"},
    {"VUID-VkFormatProperties2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkFormatProperties3-sType-sType", "sType must be VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3", "1.3-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04524", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, its layout member must be equal to VK_IMAGE_LAYOUT_GENERAL or VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR", "1.3-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04525", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.width must be a power of two value", "1.3-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04526", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.width must be less than or equal to maxFragmentShadingRateAttachmentTexelSize.width", "1.3-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04527", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.width must be greater than or equal to minFragmentShadingRateAttachmentTexelSize.width", "1.3-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04528", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.height must be a power of two value", "1.3-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04529", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.height must be less than or equal to maxFragmentShadingRateAttachmentTexelSize.height", "1.3-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04530", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.height must be greater than or equal to minFragmentShadingRateAttachmentTexelSize.height", "1.3-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04531", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, the quotient of shadingRateAttachmentTexelSize.width and shadingRateAttachmentTexelSize.height must be less than or equal to maxFragmentShadingRateAttachmentTexelSizeAspectRatio", "1.3-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04532", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, the quotient of shadingRateAttachmentTexelSize.height and shadingRateAttachmentTexelSize.width must be less than or equal to maxFragmentShadingRateAttachmentTexelSizeAspectRatio", "1.3-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-parameter", "If pFragmentShadingRateAttachment is not NULL, pFragmentShadingRateAttachment must be a valid pointer to a valid VkAttachmentReference2 structure", "1.3-extensions"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR", "1.3-extensions"},
    {"VUID-VkFrameBoundaryEXT-commonparent", "Both of the elements of pBuffers, and the elements of pImages that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkFrameBoundaryEXT-flags-parameter", "flags must be a valid combination of VkFrameBoundaryFlagBitsEXT values", "1.3-extensions"},
    {"VUID-VkFrameBoundaryEXT-pBuffers-parameter", "If bufferCount is not 0, and pBuffers is not NULL, pBuffers must be a valid pointer to an array of bufferCount valid VkBuffer handles", "1.3-extensions"},
    {"VUID-VkFrameBoundaryEXT-pImages-parameter", "If imageCount is not 0, and pImages is not NULL, pImages must be a valid pointer to an array of imageCount valid VkImage handles", "1.3-extensions"},
    {"VUID-VkFrameBoundaryEXT-pTag-parameter", "If tagSize is not 0, and pTag is not NULL, pTag must be a valid pointer to an array of tagSize bytes", "1.3-extensions"},
    {"VUID-VkFrameBoundaryEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT", "1.3-extensions"},
    {"VUID-VkFramebufferAttachmentImageInfo-flags-parameter", "flags must be a valid combination of VkImageCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkFramebufferAttachmentImageInfo-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkFramebufferAttachmentImageInfo-pViewFormats-parameter", "If viewFormatCount is not 0, pViewFormats must be a valid pointer to an array of viewFormatCount valid VkFormat values", "1.3-extensions"},
    {"VUID-VkFramebufferAttachmentImageInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO", "1.3-extensions"},
    {"VUID-VkFramebufferAttachmentImageInfo-usage-parameter", "usage must be a valid combination of VkImageUsageFlagBits values", "1.3-extensions"},
    {"VUID-VkFramebufferAttachmentImageInfo-usage-requiredbitmask", "usage must not be 0", "1.3-extensions"},
    {"VUID-VkFramebufferAttachmentImageInfo-viewFormatCount-09536", "If viewFormatCount is not 0, and the render pass is not being used with an external format resolve attachment, each element of pViewFormats must not be VK_FORMAT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkFramebufferAttachmentsCreateInfo-pAttachmentImageInfos-parameter", "If attachmentImageInfoCount is not 0, pAttachmentImageInfos must be a valid pointer to an array of attachmentImageInfoCount valid VkFramebufferAttachmentImageInfo structures", "1.3-extensions"},
    {"VUID-VkFramebufferAttachmentsCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-attachmentCount-00876", "attachmentCount must be equal to the attachment count specified in renderPass", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-commonparent", "Both of renderPass, and the elements of pAttachments that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-02778", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT and attachmentCount is not 0, pAttachments must be a valid pointer to an array of attachmentCount valid VkImageView handles", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03189", "If the imagelessFramebuffer feature is not enabled, flags must not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03190", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the pNext chain must include a VkFramebufferAttachmentsCreateInfo structure", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03191", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the attachmentImageInfoCount member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain must be equal to either zero or attachmentCount", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03196", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is referenced by VkRenderPassFragmentDensityMapCreateInfoEXT::fragmentDensityMapAttachment in renderPass must be greater than or equal to the ceiling of width/maxFragmentDensityTexelSize.width", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03197", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that is referenced by VkRenderPassFragmentDensityMapCreateInfoEXT::fragmentDensityMapAttachment in renderPass must be greater than or equal to the ceiling of height/maxFragmentDensityTexelSize.height", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03201", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a color attachment or resolve attachment by renderPass must include VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03202", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a depth/stencil attachment by renderPass must include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03203", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a depth/stencil resolve attachment by renderPass must include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03204", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as an input attachment by renderPass must include VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-03205", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, at least one element of the pViewFormats member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain must be equal to the corresponding value of VkAttachmentDescription::format used to create renderPass", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04113", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with VkImageViewCreateInfo::viewType not equal to VK_IMAGE_VIEW_TYPE_3D", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04533", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have been created with a VkImageCreateInfo::extent.width greater than or equal to width", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04534", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have been created with a VkImageCreateInfo::extent.height greater than or equal to height", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04535", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have been created with a VkImageViewCreateInfo::subresourceRange.layerCount greater than or equal to layers", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04537", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, and renderPass was specified with non-zero view masks, each element of pAttachments that is used as a fragment shading rate attachment by renderPass must have a layerCount that is either 1, or greater than the index of the most significant bit set in any of those view masks", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04538", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, and renderPass was not specified with non-zero view masks, each element of pAttachments that is used as a fragment shading rate attachment by renderPass must have a layerCount that is either 1, or greater than layers", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04539", "If maintenance7 is not enabled or the robustFragmentShadingRateAttachmentAccess limit is VK_FALSE or the imageView member of a VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with VkImageSubresourceRange::baseMipLevel greater than 0, flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is used as a fragment shading rate attachment must have a width at least as large as ⌈width / texelWidth⌉, where texelWidth is the largest value of shadingRateAttachmentTexelSize.width in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04540", "If maintenance7 is not enabled or the robustFragmentShadingRateAttachmentAccess limit is VK_FALSE or the imageView member of a VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with VkImageSubresourceRange::baseMipLevel greater than 0, flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is used as a fragment shading rate attachment must have a height at least as large as ⌈height / texelHeight⌉, where texelHeight is the largest value of shadingRateAttachmentTexelSize.height in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04541", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as an input, color, resolve or depth/stencil attachment in renderPass must be greater than or equal to width", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04542", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as an input, color, resolve or depth/stencil attachment in renderPass must be greater than or equal to height", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04543", "If maintenance7 is not enabled or the robustFragmentShadingRateAttachmentAccess limit is VK_FALSE or the imageView member of a VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with VkImageSubresourceRange::baseMipLevel greater than 0, and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as a fragment shading rate attachment must be greater than or equal to ⌈width / texelWidth⌉, where texelWidth is the largest value of shadingRateAttachmentTexelSize.width in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04544", "If maintenance7 is not enabled or the robustFragmentShadingRateAttachmentAccess limit is VK_FALSE or the imageView member of a VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with VkImageSubresourceRange::baseMipLevel greater than 0, and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as a fragment shading rate attachment must be greater than or equal to ⌈height / texelHeight⌉, where texelHeight is the largest value of shadingRateAttachmentTexelSize.height in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04545", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as a fragment shading rate attachment must be either 1, or greater than or equal to layers", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04548", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a fragment shading rate attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04549", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a fragment shading rate attachment by renderPass must include VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-04587", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT and renderPass was specified with non-zero view masks, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as a fragment shading rate attachment must be either 1, or greater than the index of the most significant bit set in any of those view masks", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-flags-parameter", "flags must be a valid combination of VkFramebufferCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-height-00887", "height must be greater than 0", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-height-00888", "height must be less than or equal to maxFramebufferHeight", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-layers-00889", "layers must be greater than 0", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-layers-00890", "layers must be less than or equal to maxFramebufferLayers", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-nullColorAttachmentWithExternalFormatResolve-09349", "If the nullColorAttachmentWithExternalFormatResolve is VK_FALSE, and flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the format of the color attachment for each subpass in renderPass that includes an external format image as a resolve attachment must have a format equal to the value of VkAndroidHardwareBufferFormatResolvePropertiesANDROID::colorAttachmentFormat as returned by a call to vkGetAndroidHardwareBufferPropertiesANDROID for the Android hardware buffer that was used to create the image view use as its resolve attachment", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00877", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a color attachment or resolve attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00879", "If renderpass is not VK_NULL_HANDLE, flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00880", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with a VkFormat value that matches the VkFormat specified by the corresponding VkAttachmentDescription in renderPass", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00881", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with a samples value that matches the samples value specified by the corresponding VkAttachmentDescription in renderPass", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00883", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must only specify a single mip level", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00884", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with the identity swizzle", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00891", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is a 2D or 2D array image view taken from a 3D image must not be a depth/stencil format", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02552", "Each element of pAttachments that is used as a fragment density map attachment by renderPass must not have been created with a flags value including VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02555", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is referenced by fragmentDensityMapAttachment must have a width at least as large as the ceiling of width/maxFragmentDensityTexelSize.width", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02556", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is referenced by fragmentDensityMapAttachment must have a height at least as large as the ceiling of height/maxFragmentDensityTexelSize.height", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02633", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a depth/stencil attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02634", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a depth/stencil resolve attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-09350", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, then if an element of pAttachments has a format of VK_FORMAT_UNDEFINED, it must have been created with a VkExternalFormatANDROID::externalFormat value identical to that provided in the VkExternalFormatANDROID::externalFormat specified by the corresponding VkAttachmentDescription2 in renderPass", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkFramebufferAttachmentsCreateInfo", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02531", "If renderPass was specified with non-zero view masks, layers must be 1", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02553", "If renderPass has a fragment density map attachment and the fragmentDensityMapNonSubsampledImages feature is not enabled, each element of pAttachments must have been created with a flags value including VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT unless that element is the fragment density map attachment", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02746", "Each element of pAttachments that is referenced by fragmentDensityMapAttachment must have a layerCount equal to 1 or if renderPass was specified with non-zero view masks, greater than the index of the most significant bit set in any of those view masks", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-03198", "If multiview is enabled for renderPass and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain used as an input, color, resolve, or depth/stencil attachment in renderPass must be greater than the maximum bit index set in the view mask in the subpasses in which it is used in renderPass", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-04536", "If renderPass was specified with non-zero view masks, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have a layerCount greater than the index of the most significant bit set in any of those view masks", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-04546", "If multiview is not enabled for renderPass and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain used as an input, color, resolve, or depth/stencil attachment in renderPass must be greater than or equal to layers", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-06502", "If renderPass was created with fragment density map offsets other than (0,0), each element of pAttachments must have been created with a flags value including VK_IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_QCOM", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-renderPass-parameter", "renderPass must be a valid VkRenderPass handle", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-samples-06881", "If multisampled-render-to-single-sampled is enabled for any subpass, all color, depth/stencil and input attachments used in that subpass which have VkAttachmentDescription::samples or VkAttachmentDescription2::samples equal to VK_SAMPLE_COUNT_1_BIT must have been created with VK_IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT in their VkImageCreateInfo::flags", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-samples-07009", "If multisampled-render-to-single-sampled is enabled for any subpass, all color, depth/stencil and input attachments used in that subpass which have VkAttachmentDescription::samples or VkAttachmentDescription2::samples equal to VK_SAMPLE_COUNT_1_BIT must have a format that supports the sample count specified in VkMultisampledRenderToSingleSampledInfoEXT::rasterizationSamples", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-width-00885", "width must be greater than 0", "1.3-extensions"},
    {"VUID-VkFramebufferCreateInfo-width-00886", "width must be less than or equal to maxFramebufferWidth", "1.3-extensions"},
    {"VUID-VkFramebufferMixedSamplesCombinationNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkFramebufferMixedSamplesCombinationNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-commonparent", "Each of indirectCommandsLayout, pipeline, preprocessBuffer, sequencesCountBuffer, and sequencesIndexBuffer that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-02913", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV, then the pipeline must have been created with multiple shader groups", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-02914", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV, then the pipeline must have been created with VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV set in VkGraphicsPipelineCreateInfo::flags", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-02915", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, then the pipeline's VkPipelineLayout must match the VkIndirectCommandsLayoutTokenNV::pushconstantPipelineLayout", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-07078", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_TASKS_NV, then the pipeline must contain a shader stage using the MeshNV Execution Model", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-07079", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_NV, then the pipeline must contain a shader stage using the MeshEXT Execution Model", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-parameter", "indirectCommandsLayout must be a valid VkIndirectCommandsLayoutNV handle", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-pStreams-parameter", "pStreams must be a valid pointer to an array of streamCount valid VkIndirectCommandsStreamNV structures", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-pipeline-02912", "The provided pipeline must match the pipeline bound at execution time", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-pipeline-parameter", "If pipeline is not VK_NULL_HANDLE, pipeline must be a valid VkPipeline handle", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-pipelineBindPoint-09084", "If pipelineBindPoint is of type VK_PIPELINE_BIND_POINT_COMPUTE, then the pipeline must have been created with the flag VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-pipelineBindPoint-09085", "If pipelineBindPoint is of type VK_PIPELINE_BIND_POINT_COMPUTE, then the pipeline must have been created with a VkComputePipelineIndirectBufferInfoNV structure specifying a valid address where its metadata will be saved", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-pipelineBindPoint-09086", "If pipelineBindPoint is of type VK_PIPELINE_BIND_POINT_COMPUTE, then vkCmdUpdatePipelineIndirectBufferNV must have been called on that pipeline to save its metadata to a device address", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-pipelineBindPoint-09087", "If pipelineBindPoint is of type VK_PIPELINE_BIND_POINT_COMPUTE, and if VK_INDIRECT_COMMANDS_TOKEN_TYPE_PIPELINE_NV is used, then pipeline must be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessBuffer-02918", "preprocessBuffer must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set in its usage flag", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessBuffer-02971", "If preprocessBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessBuffer-parameter", "preprocessBuffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessOffset-02919", "preprocessOffset must be aligned to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::minIndirectCommandsBufferOffsetAlignment", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessSize-02920", "preprocessSize must be at least equal to the memory requirement`s size returned by vkGetGeneratedCommandsMemoryRequirementsNV using the matching inputs (indirectCommandsLayout, ...) as within this structure", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCount-02917", "sequencesCount must be less or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxIndirectSequenceCount and VkGeneratedCommandsMemoryRequirementsInfoNV::maxSequencesCount that was used to determine the preprocessSize", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-02921", "sequencesCountBuffer can be set if the actual used count of sequences is sourced from the provided buffer. In that case the sequencesCount serves as upper bound", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-02922", "If sequencesCountBuffer is not VK_NULL_HANDLE, its usage flag must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-02923", "If sequencesCountBuffer is not VK_NULL_HANDLE, sequencesCountOffset must be aligned to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::minSequencesCountBufferOffsetAlignment", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-02972", "If sequencesCountBuffer is not VK_NULL_HANDLE and is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-parameter", "If sequencesCountBuffer is not VK_NULL_HANDLE, sequencesCountBuffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-02924", "If indirectCommandsLayout's VK_INDIRECT_COMMANDS_LAYOUT_USAGE_INDEXED_SEQUENCES_BIT_NV is set, sequencesIndexBuffer must be set otherwise it must be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-02925", "If sequencesIndexBuffer is not VK_NULL_HANDLE, its usage flag must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-02926", "If sequencesIndexBuffer is not VK_NULL_HANDLE, sequencesIndexOffset must be aligned to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::minSequencesIndexBufferOffsetAlignment", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-02973", "If sequencesIndexBuffer is not VK_NULL_HANDLE and is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-parameter", "If sequencesIndexBuffer is not VK_NULL_HANDLE, sequencesIndexBuffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-streamCount-02916", "streamCount must match the indirectCommandsLayout's streamCount", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsInfoNV-streamCount-arraylength", "streamCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-commonparent", "Both of indirectCommandsLayout, and pipeline that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-indirectCommandsLayout-parameter", "indirectCommandsLayout must be a valid VkIndirectCommandsLayoutNV handle", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-maxSequencesCount-02907", "maxSequencesCount must be less or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxIndirectSequenceCount", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pipeline-parameter", "If pipeline is not VK_NULL_HANDLE, pipeline must be a valid VkPipeline handle", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pipelineBindPoint-09075", "If pipelineBindPoint is of type VK_PIPELINE_BIND_POINT_GRAPHICS, then pipeline must be a valid VkPipeline handle", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pipelineBindPoint-09076", "If pipelineBindPoint is of type VK_PIPELINE_BIND_POINT_COMPUTE, and the indirectCommandsLayout was not created with a VK_INDIRECT_COMMANDS_TOKEN_TYPE_PIPELINE_NV token, then the pipeline must be a valid VkPipeline handle", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pipelineBindPoint-09077", "If pipelineBindPoint is of type VK_PIPELINE_BIND_POINT_COMPUTE, and the indirectCommandsLayout contains a VK_INDIRECT_COMMANDS_TOKEN_TYPE_PIPELINE_NV token, then the pipeline must be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value", "1.3-extensions"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV", "1.3-extensions"},
    {"VUID-VkGeometryAABBNV-aabbData-parameter", "If aabbData is not VK_NULL_HANDLE, aabbData must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkGeometryAABBNV-offset-02439", "offset must be less than the size of aabbData", "1.3-extensions"},
    {"VUID-VkGeometryAABBNV-offset-02440", "offset must be a multiple of 8", "1.3-extensions"},
    {"VUID-VkGeometryAABBNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkGeometryAABBNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV", "1.3-extensions"},
    {"VUID-VkGeometryAABBNV-stride-02441", "stride must be a multiple of 8", "1.3-extensions"},
    {"VUID-VkGeometryDataNV-aabbs-parameter", "aabbs must be a valid VkGeometryAABBNV structure", "1.3-extensions"},
    {"VUID-VkGeometryDataNV-triangles-parameter", "triangles must be a valid VkGeometryTrianglesNV structure", "1.3-extensions"},
    {"VUID-VkGeometryNV-flags-parameter", "flags must be a valid combination of VkGeometryFlagBitsKHR values", "1.3-extensions"},
    {"VUID-VkGeometryNV-geometry-parameter", "geometry must be a valid VkGeometryDataNV structure", "1.3-extensions"},
    {"VUID-VkGeometryNV-geometryType-03503", "geometryType must be VK_GEOMETRY_TYPE_TRIANGLES_NV or VK_GEOMETRY_TYPE_AABBS_NV", "1.3-extensions"},
    {"VUID-VkGeometryNV-geometryType-parameter", "geometryType must be a valid VkGeometryTypeKHR value", "1.3-extensions"},
    {"VUID-VkGeometryNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkGeometryNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GEOMETRY_NV", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-commonparent", "Each of indexData, transformData, and vertexData that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexCount-02436", "indexCount must be 0 if indexType is VK_INDEX_TYPE_NONE_NV", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexData-02434", "indexData must be VK_NULL_HANDLE if indexType is VK_INDEX_TYPE_NONE_NV", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexData-02435", "indexData must be a valid VkBuffer handle if indexType is not VK_INDEX_TYPE_NONE_NV", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexData-parameter", "If indexData is not VK_NULL_HANDLE, indexData must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexOffset-02431", "indexOffset must be less than the size of indexData", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexOffset-02432", "indexOffset must be a multiple of the element size of indexType", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexType-02433", "indexType must be VK_INDEX_TYPE_UINT16, VK_INDEX_TYPE_UINT32, or VK_INDEX_TYPE_NONE_NV", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-indexType-parameter", "indexType must be a valid VkIndexType value", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-transformData-parameter", "If transformData is not VK_NULL_HANDLE, transformData must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-transformOffset-02437", "transformOffset must be less than the size of transformData", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-transformOffset-02438", "transformOffset must be a multiple of 16", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-vertexData-parameter", "If vertexData is not VK_NULL_HANDLE, vertexData must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-vertexFormat-02430", "vertexFormat must be one of VK_FORMAT_R32G32B32_SFLOAT, VK_FORMAT_R32G32_SFLOAT, VK_FORMAT_R16G16B16_SFLOAT, VK_FORMAT_R16G16_SFLOAT, VK_FORMAT_R16G16_SNORM, or VK_FORMAT_R16G16B16_SNORM", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-vertexFormat-parameter", "vertexFormat must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-vertexOffset-02428", "vertexOffset must be less than the size of vertexData", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-vertexOffset-02429", "vertexOffset must be a multiple of the component size of vertexFormat", "1.3-extensions"},
    {"VUID-VkGeometryTrianglesNV-vertexStride-03818", "vertexStride must be less than or equal to 232-1", "1.3-extensions"},
    {"VUID-VkGetLatencyMarkerInfoNV-pTimings-parameter", "If timingCount is not 0, and pTimings is not NULL, pTimings must be a valid pointer to an array of timingCount VkLatencyTimingsFrameReportNV structures", "1.3-extensions"},
    {"VUID-VkGetLatencyMarkerInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GET_LATENCY_MARKER_INFO_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-Geometry-07726", "If the pipeline is being created with a Geometry Execution Model, uses the OutputPoints Execution Mode, and shaderTessellationAndGeometryPointSize is not enabled, a PointSize decorated variable must not be written to", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-Input-06632", "If the pipeline requires fragment shader state with a fragment shader that either enables sample shading or decorates any variable in the Input storage class with Sample, and the VK_EXT_extended_dynamic_state3 extension is not enabled or any of the VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT, VK_DYNAMIC_STATE_SAMPLE_MASK_EXT, or VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT dynamic states is not set, or alphaToOne is enabled on the device and VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT is not set, then pMultisampleState must be a valid pointer to a valid VkPipelineMultisampleStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-Input-07904", "If the pipeline is being created with vertex input state and pVertexInputState is not dynamic, then all variables with the Input storage class decorated with Location in the Vertex Execution Model OpEntryPoint must contain a location in VkVertexInputAttributeDescription::location", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-Input-08733", "If the pipeline requires vertex input state and pVertexInputState is not dynamic, then the numeric type associated with all Input variables of the corresponding Location in the Vertex Execution Model OpEntryPoint must be the same as VkVertexInputAttributeDescription::format", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-02322", "If the pipeline requires pre-rasterization shader state, and there are any mesh shader stages in the pipeline there must not be any shader stage in the pipeline with a Xfb execution mode", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-04574", "If the pipeline requires fragment shader state, and the supersampleFragmentShadingRates feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRate must not be equal to VK_FRAGMENT_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV, VK_FRAGMENT_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV, VK_FRAGMENT_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV, or VK_FRAGMENT_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-04575", "If the pipeline requires fragment shader state, and the noInvocationFragmentShadingRates feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRate must not be equal to VK_FRAGMENT_SHADING_RATE_NO_INVOCATIONS_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-04889", "If the pipeline requires pre-rasterization shader state and fragment shader state, the fragment shader and last pre-rasterization shader stage and any relevant state must adhere to the pipeline linking rules described in the Shader Interfaces chapter", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-06569", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRateType must be a valid VkFragmentShadingRateTypeNV value", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-07826", "If the pipeline includes a complete set of state, and there are no libraries included in VkPipelineLibraryCreateInfoKHR::pLibraries, then VkPipelineLayout must be a valid pipeline layout", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-09043", "If pDynamicState->pDynamicStates does not include VK_DYNAMIC_STATE_COLOR_WRITE_MASK_EXT, and the format of any color attachment is VK_FORMAT_E5B9G9R9_UFLOAT_PACK32, the colorWriteMask member of the corresponding element of pColorBlendState->pAttachments must either include all of VK_COLOR_COMPONENT_R_BIT, VK_COLOR_COMPONENT_G_BIT, and VK_COLOR_COMPONENT_B_BIT, or none of them", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-09497", "If the pNext chain does not include a VkPipelineCreateFlags2CreateInfoKHR structure, flags must be a valid combination of VkPipelineCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-09526", "If the dynamicRenderingLocalRead feature is not enabled, the pipeline requires fragment output interface state, and the flags member of VkPipelineDepthStencilStateCreateInfo includes VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT or VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT, renderPass must not be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-PrimitiveId-06264", "If the pipeline requires pre-rasterization shader state, it includes a mesh shader and the fragment shader code reads from an input variable that is decorated with PrimitiveId, then the mesh shader code must write to a matching output variable, decorated with PrimitiveId, in all execution paths", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-TaskNV-07063", "The shader stages for VK_SHADER_STAGE_TASK_BIT_EXT or VK_SHADER_STAGE_MESH_BIT_EXT must use either the TaskNV and MeshNV Execution Model or the TaskEXT and MeshEXT Execution Model, but must not use both", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-TessellationEvaluation-07723", "If the pipeline is being created with a TessellationEvaluation Execution Model, no Geometry Execution Model, uses the PointMode Execution Mode, and shaderTessellationAndGeometryPointSize is enabled, a PointSize decorated variable must be written to if maintenance5 is not enabled", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-TessellationEvaluation-07724", "If the pipeline is being created with a TessellationEvaluation Execution Model, no Geometry Execution Model, uses the PointMode Execution Mode, and shaderTessellationAndGeometryPointSize is not enabled, a PointSize decorated variable must not be written to", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-alphaToCoverageEnable-08891", "If the pipeline is being created with fragment shader state, the VkPipelineMultisampleStateCreateInfo::alphaToCoverageEnable is not ignored and is VK_TRUE, then the Fragment Output Interface must contain a variable for the alpha Component word in Location 0 at Index 0", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-commonparent", "Each of basePipelineHandle, layout, and renderPass that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-conservativePointAndLineRasterization-06760", "If conservativePointAndLineRasterization is not supported, the pipeline requires pre-rasterization shader state, and the pipeline includes a geometry shader with either the OutputPoints or OutputLineStrip execution modes, VkPipelineRasterizationConservativeStateCreateInfoEXT::conservativeRasterizationMode must be VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-conservativePointAndLineRasterization-06761", "If conservativePointAndLineRasterization is not supported, the pipeline requires pre-rasterization shader state, and the pipeline includes a mesh shader with either the OutputPoints or OutputLinesNV execution modes, VkPipelineRasterizationConservativeStateCreateInfoEXT::conservativeRasterizationMode must be VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-conservativePointAndLineRasterization-08892", "If conservativePointAndLineRasterization is not supported; the pipeline is being created with vertex input state and pre-rasterization shader state; the pipeline does not include a geometry shader; and the value of VkPipelineInputAssemblyStateCreateInfo::topology is VK_PRIMITIVE_TOPOLOGY_POINT_LIST, VK_PRIMITIVE_TOPOLOGY_LINE_LIST, or VK_PRIMITIVE_TOPOLOGY_LINE_STRIP, and either VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY dynamic state is not enabled or dynamicPrimitiveTopologyUnrestricted is VK_FALSE, then VkPipelineRasterizationConservativeStateCreateInfoEXT::conservativeRasterizationMode must be VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-coverageReductionMode-02722", "If the pipeline requires fragment output interface state, the VK_NV_coverage_reduction_mode extension is enabled, and rasterizationSamples is not dynamic, the coverage reduction mode specified by VkPipelineCoverageReductionStateCreateInfoNV::coverageReductionMode, the rasterizationSamples member of pMultisampleState and the sample counts for the color and depth/stencil attachments (if the subpass has them) must be a valid combination returned by vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-depthStencilAttachmentSamples-06593", "If the fragment output interface state and the depthStencilAttachmentSamples member of VkAttachmentSampleCountInfoAMD or VkAttachmentSampleCountInfoNV is not 0, it must be a valid VkSampleCountFlagBits value", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-dynamicPrimitiveTopologyUnrestricted-09031", "If the pipeline requires vertex input state, and related dynamic state is not set, pInputAssemblyState must be a valid pointer to a valid VkPipelineInputAssemblyStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-dynamicRendering-06576", "If the dynamicRendering feature is not enabled and the pipeline requires pre-rasterization shader state, fragment shader state, or fragment output interface state, renderPass must not be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3AlphaToCoverageEnable-07375", "If the extendedDynamicState3AlphaToCoverageEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3AlphaToOneEnable-07376", "If the extendedDynamicState3AlphaToOneEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ColorBlendAdvanced-07386", "If the extendedDynamicState3ColorBlendAdvanced feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COLOR_BLEND_ADVANCED_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ColorBlendEnable-07378", "If the extendedDynamicState3ColorBlendEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ColorBlendEquation-07379", "If the extendedDynamicState3ColorBlendEquation feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ColorWriteMask-07380", "If the extendedDynamicState3ColorWriteMask feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COLOR_WRITE_MASK_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ConservativeRasterizationMode-07382", "If the extendedDynamicState3ConservativeRasterizationMode feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_CONSERVATIVE_RASTERIZATION_MODE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3CoverageModulationMode-07395", "If the extendedDynamicState3CoverageModulationMode feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COVERAGE_MODULATION_MODE_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3CoverageModulationTable-07397", "If the extendedDynamicState3CoverageModulationTable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3CoverageModulationTableEnable-07396", "If the extendedDynamicState3CoverageModulationTableEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_ENABLE_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3CoverageReductionMode-07398", "If the extendedDynamicState3CoverageReductionMode feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COVERAGE_REDUCTION_MODE_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3CoverageToColorEnable-07393", "If the extendedDynamicState3CoverageToColorEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_ENABLE_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3CoverageToColorLocation-07394", "If the extendedDynamicState3CoverageToColorLocation feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_LOCATION_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3DepthClampEnable-07371", "If the extendedDynamicState3DepthClampEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_DEPTH_CLAMP_ENABLE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3DepthClipEnable-07384", "If the extendedDynamicState3DepthClipEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_DEPTH_CLIP_ENABLE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3DepthClipNegativeOneToOne-07390", "If the extendedDynamicState3DepthClipNegativeOneToOne feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_DEPTH_CLIP_NEGATIVE_ONE_TO_ONE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ExtraPrimitiveOverestimationSize-07383", "If the extendedDynamicState3ExtraPrimitiveOverestimationSize feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_EXTRA_PRIMITIVE_OVERESTIMATION_SIZE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3LineRasterizationMode-07388", "If the extendedDynamicState3LineRasterizationMode feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_LINE_RASTERIZATION_MODE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3LineStippleEnable-07389", "If the extendedDynamicState3LineStippleEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_LINE_STIPPLE_ENABLE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3LogicOpEnable-07377", "If the extendedDynamicState3LogicOpEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3PolygonMode-07372", "If the extendedDynamicState3PolygonMode feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_POLYGON_MODE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ProvokingVertexMode-07387", "If the extendedDynamicState3ProvokingVertexMode feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_PROVOKING_VERTEX_MODE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3RasterizationSamples-07373", "If the extendedDynamicState3RasterizationSamples feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3RasterizationStream-07381", "If the extendedDynamicState3RasterizationStream feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_RASTERIZATION_STREAM_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3RepresentativeFragmentTestEnable-07399", "If the extendedDynamicState3RepresentativeFragmentTestEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_REPRESENTATIVE_FRAGMENT_TEST_ENABLE_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3SampleLocationsEnable-07385", "If the extendedDynamicState3SampleLocationsEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3SampleMask-07374", "If the extendedDynamicState3SampleMask feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_SAMPLE_MASK_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ShadingRateImageEnable-07400", "If the extendedDynamicState3ShadingRateImageEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_SHADING_RATE_IMAGE_ENABLE_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3TessellationDomainOrigin-07370", "If the extendedDynamicState3TessellationDomainOrigin feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_TESSELLATION_DOMAIN_ORIGIN_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ViewportSwizzle-07392", "If the extendedDynamicState3ViewportSwizzle feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_VIEWPORT_SWIZZLE_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ViewportWScalingEnable-07391", "If the extendedDynamicState3ViewportWScalingEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_ENABLE_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09301", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkExternalFormatANDROID::externalFormat is not 0, VkPipelineRenderingCreateInfo::viewMask must be 0", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09304", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, VkExternalFormatANDROID::externalFormat is not 0, and rasterizationSamples is not dynamic, VkPipelineMultisampleStateCreateInfo::rasterizationSamples must be 1", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09305", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkExternalFormatANDROID::externalFormat is not 0, and blendEnable is not dynamic, the blendEnable member of each element of pColorBlendState->pAttachments must be VK_FALSE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09306", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkExternalFormatANDROID::externalFormat is not 0, and pDynamicState->pDynamicStates does not include VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR, VkPipelineFragmentShadingRateStateCreateInfoKHR::width must be 1", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09307", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkExternalFormatANDROID::externalFormat is not 0, and pDynamicState->pDynamicStates does not include VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR, VkPipelineFragmentShadingRateStateCreateInfoKHR::height must be 1", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09308", "If the externalFormatResolve feature is enabled, the pipeline requires pre-rasterization shader state and fragment output interface state, renderPass is VK_NULL_HANDLE, and VkExternalFormatANDROID::externalFormat is not 0, the last pre-rasterization shader stage must not statically use a variable with the PrimitiveShadingRateKHR built-in", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09309", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkExternalFormatANDROID::externalFormat is not 0, VkPipelineRenderingCreateInfo::colorAttachmentCount must be 1", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09310", "If the externalFormatResolve feature is enabled, the pipeline requires fragment shader state and fragment output interface state, renderPass is VK_NULL_HANDLE, and VkExternalFormatANDROID::externalFormat is not 0, the fragment shader must not declare the DepthReplacing or StencilRefReplacingEXT execution modes", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09313", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is not VK_NULL_HANDLE, subpass includes an external format resolve attachment, and rasterizationSamples is not dynamic, VkPipelineMultisampleStateCreateInfo::rasterizationSamples must be VK_SAMPLE_COUNT_1_BIT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09314", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is not VK_NULL_HANDLE, subpass includes an external format resolve attachment, and blendEnable is not dynamic, the blendEnable member of each element of pColorBlendState->pAttachments must be VK_FALSE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09315", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is not VK_NULL_HANDLE, subpass includes an external format resolve attachment, and pDynamicState->pDynamicStates does not include VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR, VkPipelineFragmentShadingRateStateCreateInfoKHR::width must be 1", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09316", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is not VK_NULL_HANDLE, subpass includes an external format resolve attachment, and pDynamicState->pDynamicStates does not include VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR, VkPipelineFragmentShadingRateStateCreateInfoKHR::height must be 1", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09317", "If the externalFormatResolve feature is enabled, the pipeline requires pre-rasterization shader state and fragment output interface state, renderPass is not VK_NULL_HANDLE, and subpass includes an external format resolve attachment, the last pre-rasterization shader stage must not statically use a variable with the PrimitiveShadingRateKHR built-in", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-00764", "flags must not contain the VK_PIPELINE_CREATE_DISPATCH_BASE flag", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-02877", "If flags includes VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then the deviceGeneratedCommands feature must be enabled", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-02966", "If the pipeline requires pre-rasterization shader state and flags includes VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then all stages must not specify Xfb execution mode", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03372", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03373", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03374", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03375", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03376", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03377", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03577", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-04901", "If flags includes VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, then the subpass must be the last subpass in a subpass dependency chain", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-04902", "If flags includes VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, and if pResolveAttachments is not NULL, then each resolve attachment must be VK_ATTACHMENT_UNUSED", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-04947", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06482", "If the dynamicRenderingLocalRead feature is not enabled, the pipeline requires fragment output interface state, and the flags member of VkPipelineColorBlendStateCreateInfo includes VK_PIPELINE_COLOR_BLEND_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_BIT_EXT, renderPass must not be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06591", "If pStages includes a fragment shader stage, and the fragment shader declares the EarlyFragmentTests execution mode, the flags member of VkPipelineDepthStencilStateCreateInfo must not include VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT or VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06596", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other flag, the value of VkMultiviewPerViewAttributesInfoNVX::perViewAttributes specified in both this pipeline and the library must be equal", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06598", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other flag, the value of VkMultiviewPerViewAttributesInfoNVX::perViewAttributesPositionXOnly specified in both this pipeline and the library must be equal", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06608", "If the pipeline defines, or includes as libraries, all the state subsets required for a complete graphics pipeline, flags must not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06609", "If flags includes VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT, pipeline libraries included via VkPipelineLibraryCreateInfoKHR must have been created with VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06610", "If flags includes VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT, pipeline libraries included via VkPipelineLibraryCreateInfoKHR must have been created with VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06612", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other flag, and layout was not created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then the layout used by this pipeline and the library must be identically defined", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06614", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other subset, and layout was created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then the layout used by the library must also have been created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06616", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other subset, and layout was created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, elements of the pSetLayouts array which layout was created with that are not VK_NULL_HANDLE must be identically defined to the element at the same index of pSetLayouts used to create the library's layout", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06618", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other flag, any descriptor set layout N specified by layout in both this pipeline and the library which include bindings accessed by shader stages in each must be identically defined", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06620", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other flag, push constants specified in layout in both this pipeline and the library which are available to shader stages in each must be identically defined", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06626", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes at least one of and no more than two of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes one of the other flags, and renderPass is VK_NULL_HANDLE, the value of VkPipelineRenderingCreateInfo::viewMask used by this pipeline and that specified by the library must be identical", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06633", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT with a pMultisampleState that was not NULL, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, pMultisampleState must be identically defined to that used to create the library", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06637", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, pMultisampleState->sampleShadingEnable is VK_TRUE, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, pMultisampleState must be identically defined to that used to create the library", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06638", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other flag, values specified in VkPipelineFragmentShadingRateStateCreateInfoKHR for both this pipeline and that library must be identical", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06640", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06642", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, layout must be a valid VkPipelineLayout handle", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06643", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and renderPass is not VK_NULL_HANDLE, renderPass must be a valid VkRenderPass handle", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06644", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, stageCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06645", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags is non-zero, if flags includes VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR, any libraries must have also been created with VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06679", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other subset, any element of the pSetLayouts array when layout was created and the corresponding element of the pSetLayouts array used to create the library's layout must not both be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06682", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes both VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, layout must have been created with no elements of the pSetLayouts array set to VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06683", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and pRasterizationState->rasterizerDiscardEnable is VK_TRUE, layout must have been created with no elements of the pSetLayouts array set to VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06684", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes at least one of and no more than two of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes one of the other flags, the value of subpass must be equal to that used to create the library", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06729", "If flags includes VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT, the pipeline includes a complete set of state specified entirely by libraries, and each library was created with a VkPipelineLayout created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then layout must be compatible with the union of the libraries' pipeline layouts other than the inclusion/exclusion of VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06730", "If flags does not include VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT, the pipeline includes a complete set of state specified entirely by libraries, and each library was created with a VkPipelineLayout created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then layout must be compatible with the union of the libraries' pipeline layouts", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06756", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other subset, and any element of the pSetLayouts array which layout was created with was VK_NULL_HANDLE, then the corresponding element of the pSetLayouts array used to create the library's layout must not have shader bindings for shaders in the other subset", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06757", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other subset, and any element of the pSetLayouts array used to create the library's layout was VK_NULL_HANDLE, then the corresponding element of the pSetLayouts array used to create this pipeline's layout must not have shader bindings for shaders in the other subset", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-07369", "flags must not include both VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT_EXT and VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-07401", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-07984", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid graphics VkPipeline handle", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-07985", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-07986", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, basePipelineIndex must be -1 or basePipelineHandle must be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-07997", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08897", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_VERTEX_INPUT_INTERFACE_BIT_EXT, pre-rasterization shader state is specified either in a library or by the inclusion of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and that state includes a vertex shader stage in pStages, the pipeline must define vertex input state", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08898", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_VERTEX_INPUT_INTERFACE_BIT_EXT, and pre-rasterization shader state is not specified, the pipeline must define vertex input state", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08899", "If flags does not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, pre-rasterization shader state is specified either in a library or by the inclusion of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and that state includes a vertex shader stage in pStages, the pipeline must either define vertex input state or include that state in a linked pipeline library", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08900", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT the pipeline must define pre-rasterization shader state", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08901", "If flags does not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, the pipeline must either define pre-rasterization shader state or include that state in a linked pipeline library", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08903", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, pre-rasterization shader state is specified either in a library or by the inclusion of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and that state either includes VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE or has pRasterizationState->rasterizerDiscardEnable set to VK_FALSE, the pipeline must define fragment shader state", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08904", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and pre-rasterization shader state is not specified, the pipeline must define fragment shader state", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08906", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, pre-rasterization shader state is specified either in a library or by the inclusion of VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and that state either includes VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE or has pRasterizationState->rasterizerDiscardEnable set to VK_FALSE, the pipeline must define fragment output interface state", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08907", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and pre-rasterization shader state is not specified, the pipeline must define fragment output interface state", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08909", "If flags does not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, pre-rasterization shader state is specified either in a library or by the inclusion of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and that state either includes VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE or has pRasterizationState->rasterizerDiscardEnable set to VK_FALSE, the pipeline must define fragment output interface state and fragment shader state or include those states in linked pipeline libraries", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-09245", "If flags includes VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT, flags must also include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-fragmentShadingRateNonTrivialCombinerOps-04506", "If the pipeline requires pre-rasterization shader state or fragment shader state, the fragmentShadingRateNonTrivialCombinerOps limit is not supported, and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, elements of VkPipelineFragmentShadingRateStateCreateInfoKHR::combinerOps must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR or VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-fragmentShadingRateNonTrivialCombinerOps-04573", "If the pipeline requires fragment shader state, and the fragmentShadingRateNonTrivialCombinerOps limit is not supported and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, elements of VkPipelineFragmentShadingRateEnumStateCreateInfoNV::combinerOps must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR or VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-geometryStreams-02321", "If the pipeline requires pre-rasterization shader state, and the last pre-rasterization shader stage is a geometry shader, and that geometry shader uses the GeometryStreams capability, then VkPhysicalDeviceTransformFeedbackFeaturesEXT::geometryStreams feature must be enabled", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-graphicsPipelineLibrary-06606", "If the graphicsPipelineLibrary feature is not enabled, flags must not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-01688", "The number of resources in layout accessible to each shader stage that is used by the pipeline must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-06602", "If the pipeline requires fragment shader state or pre-rasterization shader state, layout must be a valid VkPipelineLayout handle", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-07827", "If the pipeline includes a complete set of state specified entirely by libraries, and each library was created with a VkPipelineLayout created without VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then layout must be compatible with the layouts in those libraries", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-07987", "If a push constant block is declared in a shader, a push constant range in layout must match both the shader stage and range", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-07988", "If a resource variables is declared in a shader, a descriptor slot in layout must match the shader stage", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-07990", "If a resource variables is declared in a shader, and the descriptor type is not VK_DESCRIPTOR_TYPE_MUTABLE_EXT, a descriptor slot in layout must match the descriptor type", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-07991", "If a resource variables is declared in a shader as an array, a descriptor slot in layout must match the descriptor count", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-libraryCount-06648", "If the pipeline is not created with a complete set of state, or VkPipelineLibraryCreateInfoKHR::libraryCount is not 0, VkGraphicsPipelineShaderGroupsCreateInfoNV::groupCount and VkGraphicsPipelineShaderGroupsCreateInfoNV::pipelineCount must be 0", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-libraryCount-06649", "If the pipeline is created with a complete set of state, and VkPipelineLibraryCreateInfoKHR::libraryCount is 0, and the pNext chain includes an instance of VkGraphicsPipelineShaderGroupsCreateInfoNV, VkGraphicsPipelineShaderGroupsCreateInfoNV::groupCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-lineRasterizationMode-02766", "If the pipeline requires pre-rasterization shader state and at least one of fragment output interface state or fragment shader state, and pMultisampleState is not NULL, the lineRasterizationMode member of a VkPipelineRasterizationLineStateCreateInfoKHR structure included in the pNext chain of pRasterizationState is VK_LINE_RASTERIZATION_MODE_BRESENHAM_KHR or VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH_KHR, then the alphaToCoverageEnable, alphaToOneEnable, and sampleShadingEnable members of pMultisampleState must all be VK_FALSE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-maintenance5-08775", "If maintenance5 is enabled and a PointSize decorated variable is written to, all execution paths must write to a PointSize decorated variable", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-multisampledRenderToSingleSampled-06853", "If the pipeline requires fragment output interface state, and none of the VK_AMD_mixed_attachment_samples extension, the VK_NV_framebuffer_mixed_samples extension, or the multisampledRenderToSingleSampled feature are enabled, rasterizationSamples is not dynamic, and if subpass uses color and/or depth/stencil attachments, then the rasterizationSamples member of pMultisampleState must be the same as the sample count for those subpass attachments", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-multiview-06577", "If the multiview feature is not enabled, the pipeline requires pre-rasterization shader state, fragment shader state, or fragment output interface state, and renderPass is VK_NULL_HANDLE, VkPipelineRenderingCreateInfo::viewMask must be 0", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pColorAttachmentSamples-06592", "If the fragment output interface state, elements of the pColorAttachmentSamples member of VkAttachmentSampleCountInfoAMD or VkAttachmentSampleCountInfoNV must be valid VkSampleCountFlagBits values", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pColorBlendState-09038", "If pColorBlendState is not NULL it must be a valid pointer to a valid VkPipelineColorBlendStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDepthStencilState-09029", "If pDepthStencilState is not NULL it must be a valid pointer to a valid VkPipelineDepthStencilStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDepthStencilState-09034", "If pDepthStencilState is not NULL it must be a valid pointer to a valid VkPipelineDepthStencilStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDepthStencilState-09036", "If pDepthStencilState is not NULL it must be a valid pointer to a valid VkPipelineDepthStencilStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04494", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.width must be greater than or equal to 1", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04495", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.height must be greater than or equal to 1", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04496", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.width must be a power-of-two value", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04497", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.height must be a power-of-two value", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04498", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.width must be less than or equal to 4", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04499", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.height must be less than or equal to 4", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04500", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the pipelineFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.width and VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.height must both be equal to 1", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04501", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the primitiveFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateStateCreateInfoKHR::combinerOps[0] must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04502", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the attachmentFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateStateCreateInfoKHR::combinerOps[1] must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04569", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the fragmentShadingRateEnums feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRateType must be equal to VK_FRAGMENT_SHADING_RATE_TYPE_FRAGMENT_SIZE_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04570", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the pipelineFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRate must be equal to VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04571", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the primitiveFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::combinerOps[0] must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04572", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the attachmentFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::combinerOps[1] must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-06567", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::combinerOps[0] must be a valid VkFragmentShadingRateCombinerOpKHR value", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-06568", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::combinerOps[1] must be a valid VkFragmentShadingRateCombinerOpKHR value", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-06570", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRate must be a valid VkFragmentShadingRateNV value", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-06571", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::combinerOps[0] must be a valid VkFragmentShadingRateCombinerOpKHR value", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-06572", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::combinerOps[1] must be a valid VkFragmentShadingRateCombinerOpKHR value", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-09639", "If the pipeline requires pre-rasterization shader state, pDynamicState includes VK_DYNAMIC_STATE_CONSERVATIVE_RASTERIZATION_MODE_EXT, and pDynamicState does not include VK_DYNAMIC_STATE_EXTRA_PRIMITIVE_OVERESTIMATION_SIZE_EXT, pRasterizationState must include a VkPipelineRasterizationConservativeStateCreateInfoEXT in its pNext chain", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-parameter", "If pDynamicState is not NULL, pDynamicState must be a valid pointer to a valid VkPipelineDynamicStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00749", "If the pipeline requires pre-rasterization shader state, and the wideLines feature is not enabled, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_LINE_WIDTH, the lineWidth member of pRasterizationState must be 1.0", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00754", "If the pipeline requires pre-rasterization shader state, the depthBiasClamp feature is not enabled, no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_DEPTH_BIAS, and the depthBiasEnable member of pRasterizationState is VK_TRUE, the depthBiasClamp member of pRasterizationState must be 0.0", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-01715", "If the pipeline requires pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV, and the viewportWScalingEnable member of a VkPipelineViewportWScalingStateCreateInfoNV structure, included in the pNext chain of pViewportState, is VK_TRUE, the pViewportWScalings member of the VkPipelineViewportWScalingStateCreateInfoNV must be a pointer to an array of VkPipelineViewportWScalingStateCreateInfoNV::viewportCount valid VkViewportWScalingNV structures", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-02510", "If the pipeline requires fragment shader state, the VK_EXT_depth_range_unrestricted extension is not enabled and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_DEPTH_BOUNDS, and the depthBoundsTestEnable member of pDepthStencilState is VK_TRUE, the minDepthBounds and maxDepthBounds members of pDepthStencilState must be between 0.0 and 1.0, inclusive", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-03378", "If the extendedDynamicState feature is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is less than Version 1.3 there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_CULL_MODE, VK_DYNAMIC_STATE_FRONT_FACE, VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY, VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT, VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT, VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE, VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE, VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE, VK_DYNAMIC_STATE_DEPTH_COMPARE_OP, VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE, VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE, or VK_DYNAMIC_STATE_STENCIL_OP", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-03379", "If the pipeline requires pre-rasterization shader state, and VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT is included in the pDynamicStates array then viewportCount must be zero", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-03380", "If the pipeline requires pre-rasterization shader state, and VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT is included in the pDynamicStates array then scissorCount must be zero", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-03578", "All elements of the pDynamicStates member of pDynamicState must not be VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04056", "If the pipeline requires pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV, and if pViewportState->pNext chain includes a VkPipelineViewportExclusiveScissorStateCreateInfoNV structure, and if its exclusiveScissorCount member is not 0, then its pExclusiveScissors member must be a valid pointer to an array of exclusiveScissorCount VkRect2D structures", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04057", "If the pipeline requires pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV, and if pViewportState->pNext chain includes a VkPipelineViewportShadingRateImageStateCreateInfoNV structure, then its pShadingRatePalettes member must be a valid pointer to an array of viewportCount valid VkShadingRatePaletteNV structures", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04058", "If the pipeline requires pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT, and if pNext chain includes a VkPipelineDiscardRectangleStateCreateInfoEXT structure, and if its discardRectangleCount member is not 0, then its pDiscardRectangles member must be a valid pointer to an array of discardRectangleCount VkRect2D structures", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04130", "If the pipeline requires pre-rasterization shader state, and pViewportState->pViewports is not dynamic, then pViewportState->pViewports must be a valid pointer to an array of pViewportState->viewportCount valid VkViewport structures", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04131", "If the pipeline requires pre-rasterization shader state, and pViewportState->pScissors is not dynamic, then pViewportState->pScissors must be a valid pointer to an array of pViewportState->scissorCount VkRect2D structures", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04132", "If the pipeline requires pre-rasterization shader state, and VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT is included in the pDynamicStates array then VK_DYNAMIC_STATE_VIEWPORT must not be present", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04133", "If the pipeline requires pre-rasterization shader state, and VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT is included in the pDynamicStates array then VK_DYNAMIC_STATE_SCISSOR must not be present", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04800", "If the colorWriteEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04807", "If the pipeline requires pre-rasterization shader state and the vertexInputDynamicState feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_VERTEX_INPUT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04868", "If the extendedDynamicState2 feature is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is less than Version 1.3 there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE, VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE, or VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04869", "If the extendedDynamicState2LogicOp feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_LOGIC_OP_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04870", "If the extendedDynamicState2PatchControlPoints feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07065", "If the pipeline requires pre-rasterization shader state, and includes a mesh shader, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY, or VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07066", "If the pipeline requires pre-rasterization shader state, and includes a mesh shader, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE, or VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07067", "If the pipeline requires pre-rasterization shader state, and includes a mesh shader, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_VERTEX_INPUT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07610", "If the pipeline requires fragment shader state or fragment output interface state, and rasterizationSamples and sampleLocationsInfo are not dynamic, and VkPipelineSampleLocationsStateCreateInfoEXT::sampleLocationsEnable included in the pNext chain of pMultisampleState is VK_TRUE, sampleLocationsInfo.sampleLocationGridSize.width must evenly divide VkMultisamplePropertiesEXT::sampleLocationGridSize.width as returned by vkGetPhysicalDeviceMultisamplePropertiesEXT with a samples parameter equaling rasterizationSamples", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07611", "If the pipeline requires fragment shader state or fragment output interface state, and rasterizationSamples and sampleLocationsInfo are not dynamic, and VkPipelineSampleLocationsStateCreateInfoEXT::sampleLocationsEnable the included in the pNext chain of pMultisampleState is VK_TRUE or VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT is used, sampleLocationsInfo.sampleLocationGridSize.height must evenly divide VkMultisamplePropertiesEXT::sampleLocationGridSize.height as returned by vkGetPhysicalDeviceMultisamplePropertiesEXT with a samples parameter equaling rasterizationSamples", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07612", "If the pipeline requires fragment shader state or fragment output interface state, and rasterizationSamples and sampleLocationsInfo are not dynamic, and VkPipelineSampleLocationsStateCreateInfoEXT::sampleLocationsEnable included in the pNext chain of pMultisampleState is VK_TRUE or VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT is used, sampleLocationsInfo.sampleLocationsPerPixel must equal rasterizationSamples", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07730", "If the pipeline requires pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_VIEWPORT or VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT, and if multiviewPerViewViewports is enabled, then the index of the most significant bit in each element of VkRenderPassMultiviewCreateInfo::pViewMasks must be less than pViewportState->viewportCount", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07731", "If the pipeline requires pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_SCISSOR or VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT, and if multiviewPerViewViewports is enabled, then the index of the most significant bit in each element of VkRenderPassMultiviewCreateInfo::pViewMasks must be less than pViewportState->scissorCount", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07854", "If VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_ENABLE_NV is included in the pDynamicStates array then the implementation must support at least specVersion 2 of the VK_NV_scissor_exclusive extension", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07855", "If VK_DYNAMIC_STATE_DISCARD_RECTANGLE_ENABLE_EXT is included in the pDynamicStates array then the implementation must support at least specVersion 2 of the VK_EXT_discard_rectangles extension", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07856", "If VK_DYNAMIC_STATE_DISCARD_RECTANGLE_MODE_EXT is included in the pDynamicStates array then the implementation must support at least specVersion 2 of the VK_EXT_discard_rectangles extension", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pInputAssemblyState-09032", "If pInputAssemblyState is not NULL it must be a valid pointer to a valid VkPipelineInputAssemblyStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06597", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, the value of VkMultiviewPerViewAttributesInfoNVX::perViewAttributes specified in both libraries must be equal", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06599", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, the value of VkMultiviewPerViewAttributesInfoNVX::perViewAttributesPositionXOnly specified in both libraries must be equal", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06611", "Any pipeline libraries included via VkPipelineLibraryCreateInfoKHR::pLibraries must not include any state subset already defined by this structure or defined by any other pipeline library in VkPipelineLibraryCreateInfoKHR::pLibraries", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06613", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and the layout specified by either library was not created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then the layout used by each library must be identically defined", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06615", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and the layout specified by either library was created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then the layout used by both libraries must have been created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06617", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and the layout specified by either library was created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, elements of the pSetLayouts array which either layout was created with that are not VK_NULL_HANDLE must be identically defined to the element at the same index of pSetLayouts used to create the other library's layout", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06619", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, any descriptor set layout N specified by layout in both libraries which include bindings accessed by shader stages in each must be identically defined", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06621", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, push constants specified in layout in both this pipeline and the library which are available to shader stages in each must be identically defined", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06623", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes at least one of and no more than two of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and another element of VkPipelineLibraryCreateInfoKHR::pLibraries includes one of the other flags, the value of subpass used to create each library must be identical", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06627", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes at least one of and no more than two of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, another element of VkPipelineLibraryCreateInfoKHR::pLibraries includes one of the other flags, and renderPass was VK_NULL_HANDLE for both libraries, the value of VkPipelineRenderingCreateInfo::viewMask set by each library must be identical", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06628", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes at least one of and no more than two of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and another element of VkPipelineLibraryCreateInfoKHR::pLibraries includes one of the other flags, the renderPass objects used to create each library must be compatible or all equal to VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06634", "If an element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT with a pMultisampleState that was not NULL, and if VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, pMultisampleState must be identically defined to that used to create the library", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06635", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT with a pMultisampleState that was not NULL, and if a different element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, the pMultisampleState used to create each library must be identically defined", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06636", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT and a value of pMultisampleState->sampleShadingEnable equal VK_TRUE, and if a different element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, the pMultisampleState used to create each library must be identically defined", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06639", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, values specified in VkPipelineFragmentShadingRateStateCreateInfoKHR for both this pipeline and that library must be identical", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06646", "If VkPipelineLibraryCreateInfoKHR::pLibraries includes more than one library, and any library was created with VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR, all libraries must have also been created with VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06647", "If VkPipelineLibraryCreateInfoKHR::pLibraries includes at least one library, VkGraphicsPipelineLibraryCreateInfoEXT::flags is non-zero, and any library was created with VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR, flags must include VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06681", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and any element of the pSetLayouts array used to create each library's layout was VK_NULL_HANDLE, then the corresponding element of the pSetLayouts array used to create the other library's layout must not be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06758", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and any element of the pSetLayouts array used to create each library's layout was VK_NULL_HANDLE, then the corresponding element of the pSetLayouts array used to create the other library's layout must not have shader bindings for shaders in the other subset", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-09567", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT and a value of pMultisampleState->sampleShadingEnable equal VK_TRUE, and if VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, pMultisampleState must be identically defined to that used to create the library", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pMultisampleState-09026", "If the pipeline requires fragment output interface state, and the VK_EXT_extended_dynamic_state3 extension is not enabled or any of the VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT, VK_DYNAMIC_STATE_SAMPLE_MASK_EXT, or VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT dynamic states is not set, or alphaToOne is enabled on the device and VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT is not set, pMultisampleState must be a valid pointer to a valid VkPipelineMultisampleStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pMultisampleState-09027", "If pMultisampleState is not NULL it must be a valid pointer to a valid VkPipelineMultisampleStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAttachmentSampleCountInfoAMD, VkExternalFormatANDROID, VkGraphicsPipelineLibraryCreateInfoEXT, VkGraphicsPipelineShaderGroupsCreateInfoNV, VkMultiviewPerViewAttributesInfoNVX, VkPipelineCompilerControlCreateInfoAMD, VkPipelineCreateFlags2CreateInfoKHR, VkPipelineCreationFeedbackCreateInfo, VkPipelineDiscardRectangleStateCreateInfoEXT, VkPipelineFragmentShadingRateEnumStateCreateInfoNV, VkPipelineFragmentShadingRateStateCreateInfoKHR, VkPipelineLibraryCreateInfoKHR, VkPipelineRenderingCreateInfo, VkPipelineRepresentativeFragmentTestStateCreateInfoNV, VkPipelineRobustnessCreateInfoEXT, VkRenderingAttachmentLocationInfoKHR, or VkRenderingInputAttachmentIndexInfoKHR", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pRasterizationState-06601", "If the pipeline requires pre-rasterization shader state, and related dynamic state is not set, pRasterizationState must be a valid pointer to a valid VkPipelineRasterizationStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pRasterizationState-09039", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and related dynamic state is not set, then pMultisampleState must be a valid pointer to a valid VkPipelineMultisampleStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pRasterizationState-09040", "If pRasterizationState is not NULL it must be a valid pointer to a valid VkPipelineRasterizationStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00729", "If the pipeline requires pre-rasterization shader state and pStages includes a tessellation control shader stage, it must include a tessellation evaluation shader stage", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00730", "If the pipeline requires pre-rasterization shader state and pStages includes a tessellation evaluation shader stage, it must include a tessellation control shader stage", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00732", "If the pipeline requires pre-rasterization shader state and pStages includes tessellation shader stages, the shader code of at least one stage must contain an OpExecutionMode instruction specifying the type of subdivision in the pipeline", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00733", "If the pipeline requires pre-rasterization shader state and pStages includes tessellation shader stages, and the shader code of both stages contain an OpExecutionMode instruction specifying the type of subdivision in the pipeline, they must both specify the same subdivision mode", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00734", "If the pipeline requires pre-rasterization shader state and pStages includes tessellation shader stages, the shader code of at least one stage must contain an OpExecutionMode instruction specifying the output patch size in the pipeline", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00735", "If the pipeline requires pre-rasterization shader state and pStages includes tessellation shader stages, and the shader code of both contain an OpExecutionMode instruction specifying the out patch size in the pipeline, they must both specify the same patch size", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00738", "If the pipeline requires pre-rasterization shader state and pStages includes a geometry shader stage, and does not include any tessellation shader stages, its shader code must contain an OpExecutionMode instruction specifying an input primitive type that is compatible with the primitive topology specified in pInputAssembly", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00739", "If the pipeline requires pre-rasterization shader state and pStages includes a geometry shader stage, and also includes tessellation shader stages, its shader code must contain an OpExecutionMode instruction specifying an input primitive type that is compatible with the primitive topology that is output by the tessellation stages", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00740", "If the pipeline requires pre-rasterization shader state and fragment shader state, it includes both a fragment shader and a geometry shader, and the fragment shader code reads from an input variable that is decorated with PrimitiveId, then the geometry shader code must write to a matching output variable, decorated with PrimitiveId, in all execution paths", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00742", "If the pipeline requires pre-rasterization shader state and multiple pre-rasterization shader stages are included in pStages, the shader code for the entry points identified by those pStages and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-01565", "If the pipeline requires fragment shader state and an input attachment was referenced by an aspectMask at renderPass creation time, the fragment shader must only read from the aspects that were specified for that input attachment", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02095", "If the pipeline requires pre-rasterization shader state the geometric shader stages provided in pStages must be either from the mesh shading pipeline (stage is VK_SHADER_STAGE_TASK_BIT_EXT or VK_SHADER_STAGE_MESH_BIT_EXT) or from the primitive shading pipeline (stage is VK_SHADER_STAGE_VERTEX_BIT, VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT, VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT, or VK_SHADER_STAGE_GEOMETRY_BIT)", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02097", "If the pipeline requires vertex input state, and pVertexInputState is not dynamic, then pVertexInputState must be a valid pointer to a valid VkPipelineVertexInputStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02317", "If the pipeline requires pre-rasterization shader state, the Xfb execution mode can be specified by no more than one shader stage in pStages", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02318", "If the pipeline requires pre-rasterization shader state, and any shader stage in pStages specifies Xfb execution mode it must be the last pre-rasterization shader stage", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-06600", "If the pipeline requires pre-rasterization shader state or fragment shader state, pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-06894", "If the pipeline requires pre-rasterization shader state but not fragment shader state, elements of pStages must not have stage set to VK_SHADER_STAGE_FRAGMENT_BIT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-06895", "If the pipeline requires fragment shader state but not pre-rasterization shader state, elements of pStages must not have stage set to a shader stage which participates in pre-rasterization", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-06896", "If the pipeline requires pre-rasterization shader state, all elements of pStages must have a stage set to a shader stage which participates in fragment shader state or pre-rasterization shader state", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-08711", "If pStages includes a fragment shader stage, VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE is not set in VkPipelineDynamicStateCreateInfo::pDynamicStates, and the fragment shader declares the EarlyFragmentTests execution mode and uses OpDepthAttachmentReadEXT, the depthWriteEnable member of VkPipelineDepthStencilStateCreateInfo must be VK_FALSE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-08712", "If pStages includes a fragment shader stage, VK_DYNAMIC_STATE_STENCIL_WRITE_MASK is not set in VkPipelineDynamicStateCreateInfo::pDynamicStates, and the fragment shader declares the EarlyFragmentTests execution mode and uses OpStencilAttachmentReadEXT, the value of VkStencilOpState::writeMask for both front and back in VkPipelineDepthStencilStateCreateInfo must be 0", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-08888", "If the pipeline is being created with pre-rasterization shader state and vertex input state and pStages includes tessellation shader stages, and either VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY dynamic state is not enabled or dynamicPrimitiveTopologyUnrestricted is VK_FALSE, the topology member of pInputAssembly must be VK_PRIMITIVE_TOPOLOGY_PATCH_LIST", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-09022", "If the pipeline requires pre-rasterization shader state and pStages includes a tessellation control shader stage, and the VK_EXT_extended_dynamic_state3 extension is not enabled or the VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT dynamic state is not set, pTessellationState must be a valid pointer to a valid VkPipelineTessellationStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-09631", "If the pipeline requires pre-rasterization shader state and pStages contains both VK_SHADER_STAGE_TASK_BIT_EXT and VK_SHADER_STAGE_MESH_BIT_EXT, then the mesh shader's entry point must not declare a variable with a DrawIndex BuiltIn decoration", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pTessellationState-09023", "If pTessellationState is not NULL it must be a pointer to a valid VkPipelineTessellationStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pVertexInputState-08929", "If the pipeline is being created with vertex input state and pVertexInputState is not dynamic, and VkVertexInputAttributeDescription::format has a 64-bit component, then the scalar width associated with all Input variables of the corresponding Location in the Vertex Execution Model OpEntryPoint must be 64-bit", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pVertexInputState-08930", "If the pipeline is being created with vertex input state and pVertexInputState is not dynamic, and the scalar width associated with a Location decorated Input variable in the Vertex Execution Model OpEntryPoint is 64-bit, then the corresponding VkVertexInputAttributeDescription::format must have a 64-bit component", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pVertexInputState-09198", "If the pipeline is being created with vertex input state and pVertexInputState is not dynamic, and VkVertexInputAttributeDescription::format has a 64-bit component, then all Input variables at the corresponding Location in the Vertex Execution Model OpEntryPoint must not use components that are not present in the format", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pViewportState-09025", "If pViewportState is not NULL it must be a valid pointer to a valid VkPipelineViewportStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pipelineCreationCacheControl-02878", "If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT or VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pipelineProtectedAccess-07368", "If the pipelineProtectedAccess feature is not enabled, flags must not include VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT_EXT or VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-pipelineStageCreationFeedbackCount-06594", "If VkPipelineCreationFeedbackCreateInfo::pipelineStageCreationFeedbackCount is not 0, it must be equal to stageCount", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-primitiveFragmentShadingRateWithMultipleViewports-04503", "If the pipeline requires pre-rasterization shader state and the primitiveFragmentShadingRateWithMultipleViewports limit is not supported, VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT is not included in pDynamicState->pDynamicStates, and VkPipelineViewportStateCreateInfo::viewportCount is greater than 1, entry points specified in pStages must not write to the PrimitiveShadingRateKHR built-in", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-primitiveFragmentShadingRateWithMultipleViewports-04504", "If the pipeline requires pre-rasterization shader state and the primitiveFragmentShadingRateWithMultipleViewports limit is not supported, and entry points specified in pStages write to the ViewportIndex built-in, they must not also write to the PrimitiveShadingRateKHR built-in", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-primitiveFragmentShadingRateWithMultipleViewports-04505", "If the pipeline requires pre-rasterization shader state and the primitiveFragmentShadingRateWithMultipleViewports limit is not supported, and entry points specified in pStages write to the ViewportMaskNV built-in, they must not also write to the PrimitiveShadingRateKHR built-in", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizationSamples-04899", "If the pipeline requires fragment shader state, and the VK_QCOM_render_pass_shader_resolve extension is enabled, rasterizationSamples is not dynamic, and if subpass has any input attachments, and if the subpass description contains VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM, then the sample count of the input attachments must equal rasterizationSamples", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizationStream-02319", "If the pipeline requires pre-rasterization shader state, and a VkPipelineRasterizationStateStreamCreateInfoEXT::rasterizationStream value other than zero is specified, all variables in the output interface of the entry point being compiled decorated with Position, PointSize, ClipDistance, or CullDistance must be decorated with identical Stream values that match the rasterizationStream", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizationStream-02320", "If the pipeline requires pre-rasterization shader state, and VkPipelineRasterizationStateStreamCreateInfoEXT::rasterizationStream is zero, or not specified, all variables in the output interface of the entry point being compiled decorated with Position, PointSize, ClipDistance, or CullDistance must be decorated with a Stream value of zero, or must not specify the Stream decoration", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-09024", "If the pipeline requires pre-rasterization shader state, and the VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE dynamic state is enabled or the rasterizerDiscardEnable member of pRasterizationState is VK_FALSE, and related dynamic state is not set, pViewportState must be a valid pointer to a valid VkPipelineViewportStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06038", "If renderPass is not VK_NULL_HANDLE and the pipeline is being created with fragment shader state the fragment shader must not read from any input attachment that is defined as VK_ATTACHMENT_UNUSED in subpass", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06041", "If renderPass is not VK_NULL_HANDLE, and the pipeline is being created with fragment output interface state, then for each color attachment in the subpass, if the potential format features of the format of the corresponding attachment description do not contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT, then the blendEnable member of the corresponding element of the pAttachments member of pColorBlendState must be VK_FALSE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06046", "If renderPass is not VK_NULL_HANDLE, subpass must be a valid subpass within renderPass", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06047", "If renderPass is not VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state, subpass viewMask is not 0, and multiviewTessellationShader is not enabled, then pStages must not include tessellation shaders", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06048", "If renderPass is not VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state, subpass viewMask is not 0, and multiviewGeometryShader is not enabled, then pStages must not include a geometry shader", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06050", "If renderPass is not VK_NULL_HANDLE and the pipeline is being created with pre-rasterization shader state, and subpass viewMask is not 0, then all of the shaders in the pipeline must not include variables decorated with the Layer built-in decoration in their interfaces", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06055", "If renderPass is VK_NULL_HANDLE, pColorBlendState is not dynamic, and the pipeline is being created with fragment output interface state, pColorBlendState->attachmentCount must be equal to VkPipelineRenderingCreateInfo::colorAttachmentCount", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06057", "If renderPass is VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state, VkPipelineRenderingCreateInfo::viewMask is not 0, and the multiviewTessellationShader feature is not enabled, then pStages must not include tessellation shaders", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06058", "If renderPass is VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state, VkPipelineRenderingCreateInfo::viewMask is not 0, and the multiviewGeometryShader feature is not enabled, then pStages must not include a geometry shader", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06059", "If renderPass is VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state, and VkPipelineRenderingCreateInfo::viewMask is not 0, all of the shaders in the pipeline must not include variables decorated with the Layer built-in decoration in their interfaces", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06061", "If the dynamicRenderingLocalRead feature is not enabled, the pipeline requires fragment shader state, and renderPass is VK_NULL_HANDLE, fragment shaders in pStages must not include the InputAttachment capability", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06062", "If the pipeline requires fragment output interface state and renderPass is VK_NULL_HANDLE, for each color attachment format defined by the pColorAttachmentFormats member of VkPipelineRenderingCreateInfo, if its potential format features do not contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT, then the blendEnable member of the corresponding element of the pAttachments member of pColorBlendState must be VK_FALSE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06063", "If the pipeline requires fragment output interface state and renderPass is VK_NULL_HANDLE, if the pNext chain includes VkAttachmentSampleCountInfoAMD or VkAttachmentSampleCountInfoNV, the colorAttachmentCount member of that structure must be equal to the value of VkPipelineRenderingCreateInfo::colorAttachmentCount", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06578", "If the pipeline requires pre-rasterization shader state, fragment shader state, or fragment output interface state, and renderPass is VK_NULL_HANDLE, the index of the most significant bit in VkPipelineRenderingCreateInfo::viewMask must be less than maxMultiviewViewCount", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06579", "If the pipeline requires fragment output interface state, and renderPass is VK_NULL_HANDLE, and VkPipelineRenderingCreateInfo::colorAttachmentCount is not 0, VkPipelineRenderingCreateInfo::pColorAttachmentFormats must be a valid pointer to an array of colorAttachmentCount valid VkFormat values", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06580", "If the pipeline requires fragment output interface state, and renderPass is VK_NULL_HANDLE, each element of VkPipelineRenderingCreateInfo::pColorAttachmentFormats must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06582", "If the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and any element of VkPipelineRenderingCreateInfo::pColorAttachmentFormats is not VK_FORMAT_UNDEFINED, that format must be a format with potential format features that include VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or VK_FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06583", "If the pipeline requires fragment output interface state, and renderPass is VK_NULL_HANDLE, VkPipelineRenderingCreateInfo::depthAttachmentFormat must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06584", "If the pipeline requires fragment output interface state, and renderPass is VK_NULL_HANDLE, VkPipelineRenderingCreateInfo::stencilAttachmentFormat must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06585", "If the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkPipelineRenderingCreateInfo::depthAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06586", "If the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkPipelineRenderingCreateInfo::stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06587", "If the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkPipelineRenderingCreateInfo::depthAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format that includes a depth component", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06588", "If the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkPipelineRenderingCreateInfo::stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format that includes a stencil component", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06589", "If the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, VkPipelineRenderingCreateInfo::depthAttachmentFormat is not VK_FORMAT_UNDEFINED, and VkPipelineRenderingCreateInfo::stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, depthAttachmentFormat must equal stencilAttachmentFormat", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06595", "If renderPass is VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state or fragment shader state, and VkMultiviewPerViewAttributesInfoNVX::perViewAttributesPositionXOnly is VK_TRUE then VkMultiviewPerViewAttributesInfoNVX::perViewAttributes must also be VK_TRUE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06603", "If the pipeline requires pre-rasterization shader state, fragment shader state, or fragment output state, and renderPass is not VK_NULL_HANDLE, renderPass must be a valid VkRenderPass handle", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06854", "If renderPass is not VK_NULL_HANDLE, the VK_EXT_multisampled_render_to_single_sampled extension is enabled, rasterizationSamples is not dynamic, and subpass has a VkMultisampledRenderToSingleSampledInfoEXT structure included in the VkSubpassDescription2::pNext chain with multisampledRenderToSingleSampledEnable equal to VK_TRUE, then the rasterizationSamples member of pMultisampleState must be equal to VkMultisampledRenderToSingleSampledInfoEXT::rasterizationSamples", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-07064", "If renderPass is not VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state, subpass viewMask is not 0, and multiviewMeshShader is not enabled, then pStages must not include a mesh shader", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-07609", "If renderPass is not VK_NULL_HANDLE, the pipeline is being created with fragment output interface state, the pColorBlendState pointer is not NULL, the attachmentCount member of pColorBlendState is not ignored, and the subpass uses color attachments, the attachmentCount member of pColorBlendState must be equal to the colorAttachmentCount used to create subpass", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-07720", "If renderPass is VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state, and VkPipelineRenderingCreateInfo::viewMask is not 0, and multiviewMeshShader is not enabled, then pStages must not include a mesh shader", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-08710", "If the pipeline requires fragment shader state and renderPass is not VK_NULL_HANDLE, fragment shaders in pStages must not include any of the TileImageColorReadAccessEXT, TileImageDepthReadAccessEXT, or TileImageStencilReadAccessEXT capabilities", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-08744", "If renderPass is VK_NULL_HANDLE, the pipeline requires fragment output state or fragment shader state, the pipeline enables sample shading, rasterizationSamples is not dynamic, and the pNext chain includes a VkPipelineRenderingCreateInfo structure, rasterizationSamples must be a valid VkSampleCountFlagBits value that is set in imageCreateSampleCounts (as defined in Image Creation Limits) for every element of depthAttachmentFormat, stencilAttachmentFormat and the pColorAttachmentFormats array which is not VK_FORMAT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09028", "If renderPass is not VK_NULL_HANDLE, the pipeline is being created with fragment shader state, and subpass uses a depth/stencil attachment, and related dynamic state is not set, pDepthStencilState must be a valid pointer to a valid VkPipelineDepthStencilStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09030", "If renderPass is not VK_NULL_HANDLE, the pipeline is being created with fragment output interface state, and subpass uses color attachments, and related dynamic state is not set, pColorBlendState must be a valid pointer to a valid VkPipelineColorBlendStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09033", "If renderPass is VK_NULL_HANDLE, the pipeline is being created with fragment shader state and fragment output interface state, and either of VkPipelineRenderingCreateInfo::depthAttachmentFormat or VkPipelineRenderingCreateInfo::stencilAttachmentFormat are not VK_FORMAT_UNDEFINED, and the VK_EXT_extended_dynamic_state3 extension is not enabled or any of the VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE, VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE, VK_DYNAMIC_STATE_DEPTH_COMPARE_OP, VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE, VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE, VK_DYNAMIC_STATE_STENCIL_OP, or VK_DYNAMIC_STATE_DEPTH_BOUNDS dynamic states are not set, pDepthStencilState must be a valid pointer to a valid VkPipelineDepthStencilStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09035", "If renderPass is VK_NULL_HANDLE and the pipeline is being created with fragment shader state but not fragment output interface state, and the VK_EXT_extended_dynamic_state3 extension is not enabled, or any of the VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE, VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE, VK_DYNAMIC_STATE_DEPTH_COMPARE_OP, VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE, VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE, VK_DYNAMIC_STATE_STENCIL_OP, or VK_DYNAMIC_STATE_DEPTH_BOUNDS dynamic states are not set, pDepthStencilState must be a valid pointer to a valid VkPipelineDepthStencilStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09037", "If renderPass is VK_NULL_HANDLE, the pipeline is being created with fragment output interface state, and any element of VkPipelineRenderingCreateInfo::pColorAttachmentFormats is not VK_FORMAT_UNDEFINED, and the VK_EXT_extended_dynamic_state3 extension is not enabled, or any of the VK_DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT, VK_DYNAMIC_STATE_LOGIC_OP_EXT, VK_DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT, VK_DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT, VK_DYNAMIC_STATE_COLOR_WRITE_MASK_EXT, or VK_DYNAMIC_STATE_BLEND_CONSTANTS dynamic states are not set, pColorBlendState must be a valid pointer to a valid VkPipelineColorBlendStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09527", "If the pipeline requires fragment output interface state, renderPass is not VK_NULL_HANDLE, and the flags member of VkPipelineColorBlendStateCreateInfo includes VK_PIPELINE_COLOR_BLEND_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_BIT_EXT subpass must have been created with VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_COLOR_ACCESS_BIT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09528", "If the pipeline requires fragment shader state, renderPass is not VK_NULL_HANDLE, and the flags member of VkPipelineDepthStencilStateCreateInfo includes VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT, subpass must have been created with VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09529", "If the pipeline requires fragment shader state, renderPass is not VK_NULL_HANDLE, and the flags member of VkPipelineDepthStencilStateCreateInfo includes VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT, subpass must have been created with VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09531", "If the pipeline is being created with fragment shader state and fragment output state, the value of renderPass is VK_NULL_HANDLE, and VkRenderingInputAttachmentIndexInfoKHR is included, VkRenderingInputAttachmentIndexInfoKHR::colorAttachmentCount must be equal to VkPipelineRenderingCreateInfo::colorAttachmentCount", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09532", "If the pipeline is being created with fragment output state, and the value of renderPass is VK_NULL_HANDLE, VkRenderingAttachmentLocationInfoKHR::colorAttachmentCount must be equal to VkPipelineRenderingCreateInfo::colorAttachmentCount", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09652", "If the pipeline is being created with fragment shader state and fragment output state, the value of renderPass is VK_NULL_HANDLE, and VkRenderingInputAttachmentIndexInfoKHR is not included, the fragment shader must not contain any input attachments with a InputAttachmentIndex greater than or equal to VkPipelineRenderingCreateInfo::colorAttachmentCount", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderpass-06624", "If renderpass is not VK_NULL_HANDLE, VkGraphicsPipelineLibraryCreateInfoEXT::flags includes at least one of and no more than two of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes one of the other flags, renderPass must be compatible with that used to create the library", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderpass-06625", "If renderpass is VK_NULL_HANDLE, VkGraphicsPipelineLibraryCreateInfoEXT::flags includes at least one of and no more than two of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes one of the other flags, the value of renderPass used to create that library must also be VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderpass-06631", "If renderPass is not VK_NULL_HANDLE, the pipeline requires fragment shader state, and the VK_EXT_extended_dynamic_state3 extension is not enabled or any of the VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT, VK_DYNAMIC_STATE_SAMPLE_MASK_EXT, or VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT dynamic states is not set, or alphaToOne is enabled on the device and VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT is not set, then pMultisampleState must be a valid pointer to a valid VkPipelineMultisampleStateCreateInfo structure", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-sampleLocationsEnable-01524", "If the pipeline requires fragment shader state, and the sampleLocationsEnable member of a VkPipelineSampleLocationsStateCreateInfoEXT structure included in the pNext chain of pMultisampleState is VK_TRUE, the fragment shader code must not statically use the extended instruction InterpolateAtSample", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-sampleShadingEnable-04900", "If the pipeline requires fragment shader state, and the VK_QCOM_render_pass_shader_resolve extension is enabled, and if the subpass description contains VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM, then sampleShadingEnable must be false", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-shaderTessellationAndGeometryPointSize-08776", "If the pipeline is being created with a Geometry Execution Model, uses the OutputPoints Execution Mode, and shaderTessellationAndGeometryPointSize is enabled, a PointSize decorated variable must be written to for every vertex emitted if maintenance5 is not enabled", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-stage-02096", "If the pipeline requires pre-rasterization shader state the stage member of one element of pStages must be VK_SHADER_STAGE_VERTEX_BIT or VK_SHADER_STAGE_MESH_BIT_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-stage-06897", "If the pipeline requires fragment shader state and/or pre-rasterization shader state, any value of stage must not be set in more than one element of pStages", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-stageCount-09530", "If the pipeline requires pre-rasterization shader state, stageCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-stageCount-09587", "If the pipeline does not require pre-rasterization shader state or fragment shader state, stageCount must be zero", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-stippledLineEnable-02767", "If the pipeline requires pre-rasterization shader state, the stippledLineEnable member of VkPipelineRasterizationLineStateCreateInfoKHR is VK_TRUE, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_LINE_STIPPLE_EXT, then the lineStippleFactor member of VkPipelineRasterizationLineStateCreateInfoKHR must be in the range [1,256]", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-00758", "If the pipeline requires fragment output interface state, rasterizationSamples is not dynamic, and subpass does not use any color and/or depth/stencil attachments, then the rasterizationSamples member of pMultisampleState must follow the rules for a zero-attachment subpass", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-01411", "If the pipeline requires fragment output interface state, the VK_NV_framebuffer_mixed_samples extension is enabled, rasterizationSamples is not dynamic, and if subpass has a depth/stencil attachment and depth test, stencil test, or depth bounds test are enabled, then the rasterizationSamples member of pMultisampleState must be the same as the sample count of the depth/stencil attachment", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-01412", "If the pipeline requires fragment output interface state, the VK_NV_framebuffer_mixed_samples extension is enabled, rasterizationSamples is not dynamic, and if subpass has any color attachments, then the rasterizationSamples member of pMultisampleState must be greater than or equal to the sample count for those subpass attachments", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-01505", "If the pipeline requires fragment output interface state, and the VK_AMD_mixed_attachment_samples extension is enabled, rasterizationSamples is not dynamic, and if subpass uses color and/or depth/stencil attachments, then the rasterizationSamples member of pMultisampleState must equal the maximum of the sample counts of those subpass attachments", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-topology-08773", "If the pipeline is being created with a Vertex Execution Model and no TessellationEvaluation or Geometry Execution Model, and the topology member of pInputAssembly is VK_PRIMITIVE_TOPOLOGY_POINT_LIST, and either VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY dynamic state is not enabled or dynamicPrimitiveTopologyUnrestricted is VK_FALSE, a PointSize decorated variable must be written to if maintenance5 is not enabled", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineCreateInfo-topology-08889", "If the pipeline is being created with pre-rasterization shader state and vertex input state and the topology member of pInputAssembly is VK_PRIMITIVE_TOPOLOGY_PATCH_LIST, and either VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY dynamic state is not enabled or dynamicPrimitiveTopologyUnrestricted is VK_FALSE, then pStages must include tessellation shader stages", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineLibraryCreateInfoEXT-flags-parameter", "flags must be a valid combination of VkGraphicsPipelineLibraryFlagBitsEXT values", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineLibraryCreateInfoEXT-flags-requiredbitmask", "flags must not be 0", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineLibraryCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-deviceGeneratedCommands-02887", "The deviceGeneratedCommands feature must be enabled", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-groupCount-02879", "groupCount must be at least 1 and as maximum VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxGraphicsShaderGroupCount", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-groupCount-02880", "The sum of groupCount including those groups added from referenced pPipelines must also be as maximum VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxGraphicsShaderGroupCount", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-02881", "The state of the first element of pGroups must match its equivalent within the parent's VkGraphicsPipelineCreateInfo", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-02882", "Each element of pGroups must in combination with the rest of the pipeline state yield a valid state configuration", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-02884", "All elements of pGroups must use the same shader stage combinations unless any mesh shader stage is used, then either combination of task and mesh or just mesh shader is valid", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-02885", "Mesh and regular primitive shading stages cannot be mixed across pGroups", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-parameter", "If groupCount is not 0, pGroups must be a valid pointer to an array of groupCount valid VkGraphicsShaderGroupCreateInfoNV structures", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pPipelines-02886", "Each element of pPipelines must have been created with identical state to the pipeline currently created except the state that can be overridden by VkGraphicsShaderGroupCreateInfoNV", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pPipelines-parameter", "If pipelineCount is not 0, pPipelines must be a valid pointer to an array of pipelineCount valid VkPipeline handles", "1.3-extensions"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV", "1.3-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pStages-02889", "For pStages, the same restrictions as in VkGraphicsPipelineCreateInfo::pStages apply", "1.3-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pStages-parameter", "pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures", "1.3-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pTessellationState-02891", "For pTessellationState, the same restrictions as in VkGraphicsPipelineCreateInfo::pTessellationState apply", "1.3-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pVertexInputState-02890", "For pVertexInputState, the same restrictions as in VkGraphicsPipelineCreateInfo::pVertexInputState apply", "1.3-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV", "1.3-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-stageCount-02888", "For stageCount, the same restrictions as in VkGraphicsPipelineCreateInfo::stageCount apply", "1.3-extensions"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-stageCount-arraylength", "stageCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkHdrMetadataEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkHdrMetadataEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_HDR_METADATA_EXT", "1.3-extensions"},
    {"VUID-VkHeadlessSurfaceCreateInfoEXT-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkHeadlessSurfaceCreateInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkHeadlessSurfaceCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkHostImageCopyDevicePerformanceQueryEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY_EXT", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-aspectMask-08702", "If the aspectMask member of subresourceRange includes VK_IMAGE_ASPECT_DEPTH_BIT, oldLayout and newLayout must not be one of VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-aspectMask-08703", "If the aspectMask member of subresourceRange includes VK_IMAGE_ASPECT_STENCIL_BIT, oldLayout and newLayout must not be one of VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-image-01672", "If image has a multi-planar format and the image is disjoint, then the aspectMask member of subresourceRange must include at least one multi-planar aspect mask bit or VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-image-01932", "If image is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-image-03319", "If image has a depth/stencil format with both depth and stencil and the separateDepthStencilLayouts feature is enabled, then the aspectMask member of subresourceRange must include either or both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-image-03320", "If image has a depth/stencil format with both depth and stencil and the separateDepthStencilLayouts feature is not enabled, then the aspectMask member of subresourceRange must include both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-image-09055", "image must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-image-09241", "If image has a color format that is single-plane, then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-image-09242", "If image has a color format and is not disjoint, then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-image-parameter", "image must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-newLayout-09057", "newLayout must be one of the layouts in VkPhysicalDeviceHostImageCopyPropertiesEXT::pCopyDstLayouts", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-newLayout-parameter", "newLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-oldLayout-09229", "oldLayout must be either VK_IMAGE_LAYOUT_UNDEFINED or the current layout of the image subresources as specified in subresourceRange", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-oldLayout-09230", "If oldLayout is not VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED, it must be one of the layouts in VkPhysicalDeviceHostImageCopyPropertiesEXT::pCopySrcLayouts", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-oldLayout-parameter", "oldLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO_EXT", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-subresourceRange-01486", "subresourceRange.baseMipLevel must be less than the mipLevels specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-subresourceRange-01488", "subresourceRange.baseArrayLayer must be less than the arrayLayers specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-subresourceRange-01724", "If subresourceRange.levelCount is not VK_REMAINING_MIP_LEVELS, subresourceRange.baseMipLevel + subresourceRange.levelCount must be less than or equal to the mipLevels specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-subresourceRange-01725", "If subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the arrayLayers specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-subresourceRange-09601", "subresourceRange.aspectMask must be valid for the format the image was created with", "1.3-extensions"},
    {"VUID-VkHostImageLayoutTransitionInfoEXT-subresourceRange-parameter", "subresourceRange must be a valid VkImageSubresourceRange structure", "1.3-extensions"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-pView-01316", "If pView is a UIView object, it must be a valid UIView, must be backed by a CALayer object of type CAMetalLayer, and vkCreateIOSSurfaceMVK must be called on the main thread", "1.3-extensions"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-pView-04143", "If pView is a CAMetalLayer object, it must be a valid CAMetalLayer", "1.3-extensions"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-sType-sType", "sType must be VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK", "1.3-extensions"},
    {"VUID-VkImageAlignmentControlCreateInfoMESA-imageAlignmentControl-09657", "imageAlignmentControl must be enabled on the device", "1.3-extensions"},
    {"VUID-VkImageAlignmentControlCreateInfoMESA-maximumRequestedAlignment-09655", "If maximumRequestedAlignment is not 0, maximumRequestedAlignment must be a power of two", "1.3-extensions"},
    {"VUID-VkImageAlignmentControlCreateInfoMESA-maximumRequestedAlignment-09656", "If maximumRequestedAlignment is not 0, the bitwise-and of maximumRequestedAlignment and supportedImageAlignmentMask must be non-zero", "1.3-extensions"},
    {"VUID-VkImageAlignmentControlCreateInfoMESA-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_ALIGNMENT_CONTROL_CREATE_INFO_MESA", "1.3-extensions"},
    {"VUID-VkImageBlit-aspectMask-00238", "The aspectMask member of srcSubresource and dstSubresource must match", "1.3-extensions"},
    {"VUID-VkImageBlit-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkImageBlit-layerCount-08800", "If neither of the layerCount members of srcSubresource or dstSubresource are VK_REMAINING_ARRAY_LAYERS, the layerCount members of srcSubresource or dstSubresource must match", "1.3-extensions"},
    {"VUID-VkImageBlit-layerCount-08801", "If one of the layerCount members of srcSubresource or dstSubresource is VK_REMAINING_ARRAY_LAYERS, the other member must be either VK_REMAINING_ARRAY_LAYERS or equal to the arrayLayers member of the VkImageCreateInfo used to create the image minus baseArrayLayer", "1.3-extensions"},
    {"VUID-VkImageBlit-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkImageBlit2-aspectMask-00238", "The aspectMask member of srcSubresource and dstSubresource must match", "1.3-extensions"},
    {"VUID-VkImageBlit2-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkImageBlit2-layerCount-08800", "If neither of the layerCount members of srcSubresource or dstSubresource are VK_REMAINING_ARRAY_LAYERS, the layerCount members of srcSubresource or dstSubresource must match", "1.3-extensions"},
    {"VUID-VkImageBlit2-layerCount-08801", "If one of the layerCount members of srcSubresource or dstSubresource is VK_REMAINING_ARRAY_LAYERS, the other member must be either VK_REMAINING_ARRAY_LAYERS or equal to the arrayLayers member of the VkImageCreateInfo used to create the image minus baseArrayLayer", "1.3-extensions"},
    {"VUID-VkImageBlit2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkCopyCommandTransformInfoQCOM", "1.3-extensions"},
    {"VUID-VkImageBlit2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_BLIT_2", "1.3-extensions"},
    {"VUID-VkImageBlit2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkImageBlit2-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkImageCaptureDescriptorDataInfoEXT-image-08079", "image must have been created with VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT set in VkImageCreateInfo::flags", "1.3-extensions"},
    {"VUID-VkImageCaptureDescriptorDataInfoEXT-image-parameter", "image must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkImageCaptureDescriptorDataInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImageCaptureDescriptorDataInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT", "1.3-extensions"},
    {"VUID-VkImageCompressionControlEXT-flags-06747", "flags must be one of VK_IMAGE_COMPRESSION_DEFAULT_EXT, VK_IMAGE_COMPRESSION_FIXED_RATE_DEFAULT_EXT, VK_IMAGE_COMPRESSION_FIXED_RATE_EXPLICIT_EXT, or VK_IMAGE_COMPRESSION_DISABLED_EXT", "1.3-extensions"},
    {"VUID-VkImageCompressionControlEXT-flags-06748", "If flags includes VK_IMAGE_COMPRESSION_FIXED_RATE_EXPLICIT_EXT, pFixedRateFlags must not be NULL", "1.3-extensions"},
    {"VUID-VkImageCompressionControlEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT", "1.3-extensions"},
    {"VUID-VkImageCompressionPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT", "1.3-extensions"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-attachmentFragmentShadingRate-06401", "If the attachmentFragmentShadingRate feature is enabled, and pFormatConstraints->imageCreateInfo->usage contains VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, then pFormatConstraints->requiredFormatFeatures must contain VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-bufferCollectionConstraints-parameter", "bufferCollectionConstraints must be a valid VkBufferCollectionConstraintsInfoFUCHSIA structure", "1.3-extensions"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-flags-parameter", "flags must be a valid combination of VkImageConstraintsInfoFlagBitsFUCHSIA values", "1.3-extensions"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-formatConstraintsCount-arraylength", "formatConstraintsCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pFormatConstraints-06395", "All elements of pFormatConstraints must have at least one bit set in its VkImageFormatConstraintsInfoFUCHSIA::requiredFormatFeatures", "1.3-extensions"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pFormatConstraints-06396", "If pFormatConstraints->imageCreateInfo->usage contains VK_IMAGE_USAGE_SAMPLED_BIT, then pFormatConstraints->requiredFormatFeatures must contain VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT", "1.3-extensions"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pFormatConstraints-06397", "If pFormatConstraints->imageCreateInfo->usage contains VK_IMAGE_USAGE_STORAGE_BIT, then pFormatConstraints->requiredFormatFeatures must contain VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT", "1.3-extensions"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pFormatConstraints-06398", "If pFormatConstraints->imageCreateInfo->usage contains VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, then pFormatConstraints->requiredFormatFeatures must contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pFormatConstraints-06399", "If pFormatConstraints->imageCreateInfo->usage contains VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, then pFormatConstraints->requiredFormatFeatures must contain VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pFormatConstraints-06400", "If pFormatConstraints->imageCreateInfo->usage contains VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, then pFormatConstraints->requiredFormatFeatures must contain at least one of VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pFormatConstraints-parameter", "pFormatConstraints must be a valid pointer to an array of formatConstraintsCount valid VkImageFormatConstraintsInfoFUCHSIA structures", "1.3-extensions"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_CONSTRAINTS_INFO_FUCHSIA", "1.3-extensions"},
    {"VUID-VkImageCopy-apiVersion-07940", "If the VK_KHR_sampler_ycbcr_conversion extension is not enabled, and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, the aspectMask member of srcSubresource and dstSubresource must match", "1.3-extensions"},
    {"VUID-VkImageCopy-apiVersion-07941", "If the VK_KHR_maintenance1 extension is not enabled, and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, the layerCount member of srcSubresource and dstSubresource must match", "1.3-extensions"},
    {"VUID-VkImageCopy-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkImageCopy-extent-06668", "extent.width must not be 0", "1.3-extensions"},
    {"VUID-VkImageCopy-extent-06669", "extent.height must not be 0", "1.3-extensions"},
    {"VUID-VkImageCopy-extent-06670", "extent.depth must not be 0", "1.3-extensions"},
    {"VUID-VkImageCopy-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkImageCopy2-apiVersion-07940", "If the VK_KHR_sampler_ycbcr_conversion extension is not enabled, and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, the aspectMask member of srcSubresource and dstSubresource must match", "1.3-extensions"},
    {"VUID-VkImageCopy2-apiVersion-07941", "If the VK_KHR_maintenance1 extension is not enabled, and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, the layerCount member of srcSubresource and dstSubresource must match", "1.3-extensions"},
    {"VUID-VkImageCopy2-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkImageCopy2-extent-06668", "extent.width must not be 0", "1.3-extensions"},
    {"VUID-VkImageCopy2-extent-06669", "extent.height must not be 0", "1.3-extensions"},
    {"VUID-VkImageCopy2-extent-06670", "extent.depth must not be 0", "1.3-extensions"},
    {"VUID-VkImageCopy2-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImageCopy2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_COPY_2", "1.3-extensions"},
    {"VUID-VkImageCopy2-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-Format-02536", "If Format is a depth-stencil format and the pNext chain includes a VkImageStencilUsageCreateInfo structure with its stencilUsage member including VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, extent.width must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferWidth", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-None-01891", "If any of the bits VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT are set, VK_IMAGE_CREATE_PROTECTED_BIT must not also be set", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-None-01925", "If any of the bits VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT are set, VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT must not also be set", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-arrayLayers-00948", "arrayLayers must be greater than 0", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-arrayLayers-02256", "arrayLayers must be less than or equal to imageCreateMaxArrayLayers (as defined in Image Creation Limits)", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-extent-00944", "extent.width must be greater than 0", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-extent-00945", "extent.height must be greater than 0", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-extent-00946", "extent.depth must be greater than 0", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-extent-02252", "extent.width must be less than or equal to imageCreateMaxExtent.width (as defined in Image Creation Limits)", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-extent-02253", "extent.height must be less than or equal to imageCreateMaxExtent.height (as defined in Image Creation Limits)", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-extent-02254", "extent.depth must be less than or equal to imageCreateMaxExtent.depth (as defined in Image Creation Limits)", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-00949", "If flags contains VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, imageType must be VK_IMAGE_TYPE_2D", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-00950", "If flags contains VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT, imageType must be VK_IMAGE_TYPE_3D", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-00969", "If the sparseBinding feature is not enabled, flags must not contain VK_IMAGE_CREATE_SPARSE_BINDING_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-00987", "If flags contains VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT, it must also contain VK_IMAGE_CREATE_SPARSE_BINDING_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-01533", "If flags contains VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT format must be a depth or depth/stencil format", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-01572", "If flags contains VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT, then format must be a compressed image format", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-01573", "If flags contains VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT, then flags must also contain VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-01890", "If the protectedMemory feature is not enabled, flags must not contain VK_IMAGE_CREATE_PROTECTED_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-01924", "If the sparseResidencyAliased feature is not enabled, flags must not contain VK_IMAGE_CREATE_SPARSE_ALIASED_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-02050", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV, imageType must be VK_IMAGE_TYPE_2D or VK_IMAGE_TYPE_3D", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-02051", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV, it must not contain VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT and the format must not be a depth/stencil format", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-02052", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV and imageType is VK_IMAGE_TYPE_2D, extent.width and extent.height must be greater than 1", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-02053", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV and imageType is VK_IMAGE_TYPE_3D, extent.width, extent.height, and extent.depth must be greater than 1", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-02259", "If flags contains VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT, then mipLevels must be one, arrayLayers must be one, imageType must be VK_IMAGE_TYPE_2D. and imageCreateMaybeLinear (as defined in Image Creation Limits) must be VK_FALSE", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-02557", "If flags contains VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, imageType must be VK_IMAGE_TYPE_2D", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-02565", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, tiling must be VK_IMAGE_TILING_OPTIMAL", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-02566", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, imageType must be VK_IMAGE_TYPE_2D", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-02567", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, flags must not contain VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-02568", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, mipLevels must be 1", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-04738", "If flags does not contain VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT and the pNext chain includes a VkImageFormatListCreateInfo structure, then VkImageFormatListCreateInfo::viewFormatCount must be 0 or 1", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-06883", "If flags contains VK_IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT, samples must be VK_SAMPLE_COUNT_1_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-07755", "If flags contains VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT, imageType must be VK_IMAGE_TYPE_3D", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-08104", "If flags includes VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT, the descriptorBufferCaptureReplay feature must be enabled", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-08328", "If flags includes VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then videoMaintenance1 must be enabled", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-08329", "If flags includes VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR and usage does not include VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR, then usage must not include VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-08331", "If flags includes VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then usage must not include VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-08865", "If flags contains VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, extent.width and extent.height must be equal", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-08866", "If flags contains VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, arrayLayers must be greater than or equal to 6", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-09403", "If flags contains VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT, flags must not include VK_IMAGE_CREATE_SPARSE_ALIASED_BIT, VK_IMAGE_CREATE_SPARSE_BINDING_BIT, or VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-flags-parameter", "flags must be a valid combination of VkImageCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-01577", "If format is not a multi-planar format, and flags does not include VK_IMAGE_CREATE_ALIAS_BIT, flags must not contain VK_IMAGE_CREATE_DISJOINT_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-02537", "If format is a depth-stencil format and the pNext chain includes a VkImageStencilUsageCreateInfo structure with its stencilUsage member including VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, extent.height must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferHeight", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-02538", "If the shaderStorageImageMultisample feature is not enabled, format is a depth-stencil format and the pNext chain includes a VkImageStencilUsageCreateInfo structure with its stencilUsage including VK_IMAGE_USAGE_STORAGE_BIT, samples must be VK_SAMPLE_COUNT_1_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-02795", "If format is a depth-stencil format, usage includes VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-02796", "If format is a depth-stencil format, usage does not include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also not include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-02797", "If format is a depth-stencil format, usage includes VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also include VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-02798", "If format is a depth-stencil format, usage does not include VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also not include VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-04712", "If format has a _422 or _420 suffix, extent.width must be a multiple of 2", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-04713", "If format has a _420 suffix, extent.height must be a multiple of 2", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-06410", "If the image format is one of the formats that require a sampler Y'CBCR conversion, mipLevels must be 1", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-06411", "If the image format is one of the formats that require a sampler Y'CBCR conversion, samples must be VK_SAMPLE_COUNT_1_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-06412", "If the image format is one of the formats that require a sampler Y'CBCR conversion, imageType must be VK_IMAGE_TYPE_2D", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-09583", "If format is one of the VK_FORMAT_PVTRC1_*_IMG formats, extent.width must be a power of 2", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-09584", "If format is one of the VK_FORMAT_PVTRC1_*_IMG formats, extent.height must be a power of 2", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-format-parameter", "format must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-fragmentDensityMapOffset-06514", "If the fragmentDensityMapOffset feature is not enabled and usage includes VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, extent.width must be less than or equal to the ceiling of maxFramebufferWidth/minFragmentDensityTexelSize.width", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-fragmentDensityMapOffset-06515", "If the fragmentDensityMapOffset feature is not enabled and usage includes VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, extent.height must be less than or equal to the ceiling of maxFramebufferHeight/minFragmentDensityTexelSize.height", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageCreateFormatFeatures-02260", "If format is a multi-planar format, and if imageCreateFormatFeatures (as defined in Image Creation Limits) does not contain VK_FORMAT_FEATURE_DISJOINT_BIT, then flags must not contain VK_IMAGE_CREATE_DISJOINT_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageCreateFormatFeatures-09048", "If imageCreateFormatFeatures (as defined in Image Creation Limits) does not contain VK_FORMAT_FEATURE_2_HOST_IMAGE_TRANSFER_BIT_EXT, then usage must not contain VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageCreateMaxMipLevels-02251", "Each of the following values (as described in Image Creation Limits) must not be undefined : imageCreateMaxMipLevels, imageCreateMaxArrayLayers, imageCreateMaxExtent, and imageCreateSampleCounts", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00956", "If imageType is VK_IMAGE_TYPE_1D, both extent.height and extent.depth must be 1", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00957", "If imageType is VK_IMAGE_TYPE_2D, extent.depth must be 1", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00961", "If imageType is VK_IMAGE_TYPE_3D, arrayLayers must be 1", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00970", "If imageType is VK_IMAGE_TYPE_1D, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00971", "If the sparseResidencyImage2D feature is not enabled, and imageType is VK_IMAGE_TYPE_2D, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00972", "If the sparseResidencyImage3D feature is not enabled, and imageType is VK_IMAGE_TYPE_3D, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00973", "If the sparseResidency2Samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_2_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00974", "If the sparseResidency4Samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_4_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00975", "If the sparseResidency8Samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_8_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageType-00976", "If the sparseResidency16Samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_16_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageType-02082", "If usage includes VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, imageType must be VK_IMAGE_TYPE_2D", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageType-parameter", "imageType must be a valid VkImageType value", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-imageView2DOn3DImage-04459", "If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::imageView2DOn3DImage is VK_FALSE, flags must not contain VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-initialLayout-00993", "initialLayout must be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-initialLayout-parameter", "initialLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-mipLevels-00947", "mipLevels must be greater than 0", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-mipLevels-00958", "mipLevels must be less than or equal to the number of levels in the complete mipmap chain based on extent.width, extent.height, and extent.depth", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-mipLevels-02255", "mipLevels must be less than or equal to imageCreateMaxMipLevels (as defined in Image Creation Limits)", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-multisampleArrayImage-04460", "If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::multisampleArrayImage is VK_FALSE, and samples is not VK_SAMPLE_COUNT_1_BIT, then arrayLayers must be 1", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-multisampledRenderToSingleSampled-06882", "If the multisampledRenderToSingleSampled feature is not enabled, flags must not contain VK_IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-00988", "If the pNext chain includes a VkExternalMemoryImageCreateInfoNV structure, it must not contain a VkExternalMemoryImageCreateInfo structure", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-00990", "If the pNext chain includes a VkExternalMemoryImageCreateInfo structure, its handleTypes member must only contain bits that are also in VkExternalImageFormatProperties::externalMemoryProperties.compatibleHandleTypes, as returned by vkGetPhysicalDeviceImageFormatProperties2 with format, imageType, tiling, usage, and flags equal to those in this structure, and with a VkPhysicalDeviceExternalImageFormatInfo structure included in the pNext chain, with a handleType equal to any one of the handle types specified in VkExternalMemoryImageCreateInfo::handleTypes", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-00991", "If the pNext chain includes a VkExternalMemoryImageCreateInfoNV structure, its handleTypes member must only contain bits that are also in VkExternalImageFormatPropertiesNV::externalMemoryProperties.compatibleHandleTypes, as returned by vkGetPhysicalDeviceExternalImageFormatPropertiesNV with format, imageType, tiling, usage, and flags equal to those in this structure, and with externalHandleType equal to any one of the handle types specified in VkExternalMemoryImageCreateInfoNV::handleTypes", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-01443", "If the pNext chain includes a VkExternalMemoryImageCreateInfo or VkExternalMemoryImageCreateInfoNV structure whose handleTypes member is not 0, initialLayout must be VK_IMAGE_LAYOUT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-01974", "If the pNext chain includes a VkExternalFormatANDROID structure, and its externalFormat member is non-zero the format must be VK_FORMAT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-01975", "If the pNext chain does not include a VkExternalFormatANDROID structure, or does and its externalFormat member is 0, the format must not be VK_FORMAT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-02262", "If the pNext chain includes a VkImageDrmFormatModifierListCreateInfoEXT or VkImageDrmFormatModifierExplicitCreateInfoEXT structure, then tiling must be VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-02393", "If the pNext chain includes a VkExternalMemoryImageCreateInfo structure whose handleTypes member includes VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, imageType must be VK_IMAGE_TYPE_2D", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-02394", "If the pNext chain includes a VkExternalMemoryImageCreateInfo structure whose handleTypes member includes VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, mipLevels must either be 1 or equal to the number of levels in the complete mipmap chain based on extent.width, extent.height, and extent.depth", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-02396", "If the pNext chain includes a VkExternalFormatANDROID structure whose externalFormat member is not 0, flags must not include VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-02397", "If the pNext chain includes a VkExternalFormatANDROID structure whose externalFormat member is not 0, usage must not include any usages except VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, or VK_IMAGE_USAGE_SAMPLED_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-02398", "If the pNext chain includes a VkExternalFormatANDROID structure whose externalFormat member is not 0, tiling must be VK_IMAGE_TILING_OPTIMAL", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-06390", "If the VkImage is to be used to import memory from a VkBufferCollectionFUCHSIA, a VkBufferCollectionImageCreateInfoFUCHSIA structure must be chained to pNext", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-06722", "If a VkImageFormatListCreateInfo structure was included in the pNext chain and VkImageFormatListCreateInfo::viewFormatCount is not zero, then each format in VkImageFormatListCreateInfo::pViewFormats must either be compatible with the format as described in the compatibility table or, if flags contains VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT, be an uncompressed format that is size-compatible with format", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-06743", "If the pNext chain includes a VkImageCompressionControlEXT structure, format is a multi-planar format, and VkImageCompressionControlEXT::flags includes VK_IMAGE_COMPRESSION_FIXED_RATE_EXPLICIT_EXT, then VkImageCompressionControlEXT::compressionControlPlaneCount must be equal to the number of planes in format", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-06744", "If the pNext chain includes a VkImageCompressionControlEXT structure, format is not a multi-planar format, and VkImageCompressionControlEXT::flags includes VK_IMAGE_COMPRESSION_FIXED_RATE_EXPLICIT_EXT, then VkImageCompressionControlEXT::compressionControlPlaneCount must be 1", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-06746", "If the pNext chain includes a VkImageCompressionControlEXT structure, it must not contain a VkImageDrmFormatModifierExplicitCreateInfoEXT structure", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-06783", "If the pNext chain includes a VkExportMetalObjectCreateInfoEXT structure, its exportObjectType member must be either VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT or VK_EXPORT_METAL_OBJECT_TYPE_METAL_IOSURFACE_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-06784", "If the pNext chain includes a VkImportMetalTextureInfoEXT structure its plane member must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-06785", "If the pNext chain includes a VkImportMetalTextureInfoEXT structure and the image does not have a multi-planar format, then VkImportMetalTextureInfoEXT::plane must be VK_IMAGE_ASPECT_PLANE_0_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-06786", "If the pNext chain includes a VkImportMetalTextureInfoEXT structure and the image has a multi-planar format with only two planes, then VkImportMetalTextureInfoEXT::plane must not be VK_IMAGE_ASPECT_PLANE_2_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-06811", "If the pNext chain includes a VkVideoProfileListInfoKHR structure with profileCount greater than 0, then supportedVideoFormat must be VK_TRUE", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-08105", "If the pNext chain includes a VkOpaqueCaptureDescriptorDataCreateInfoEXT structure, flags must contain VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-08951", "If the pNext chain includes a VkExternalMemoryImageCreateInfo structure whose handleTypes member includes VK_EXTERNAL_MEMORY_HANDLE_TYPE_SCREEN_BUFFER_BIT_QNX, imageType must be VK_IMAGE_TYPE_2D", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-08952", "If the pNext chain includes a VkExternalMemoryImageCreateInfo structure whose handleTypes member includes VK_EXTERNAL_MEMORY_HANDLE_TYPE_SCREEN_BUFFER_BIT_QNX, mipLevels must either be 1 or equal to the number of levels in the complete mipmap chain based on extent.width, extent.height, and extent.depth", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-08953", "If the pNext chain includes a VkExternalFormatQNX structure whose externalFormat member is not 0, flags must not include VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-08954", "If the pNext chain includes a VkExternalFormatQNX structure whose externalFormat member is not 0, usage must not include any usages except VK_IMAGE_USAGE_SAMPLED_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-08955", "If the pNext chain includes a VkExternalFormatQNX structure whose externalFormat member is not 0, tiling must be VK_IMAGE_TILING_OPTIMAL", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-09457", "If the pNext chain includes a VkExternalFormatANDROID structure whose externalFormat member is not 0, and externalFormatResolve feature is not enabled, usage must not include VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT or VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-09653", "If the pNext chain contains a VkImageAlignmentControlCreateInfoMESA structure, tiling must be VK_IMAGE_TILING_OPTIMAL", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-09654", "If the pNext chain contains a VkImageAlignmentControlCreateInfoMESA structure, it must not contain a VkExternalMemoryImageCreateInfo structure", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBufferCollectionImageCreateInfoFUCHSIA, VkDedicatedAllocationImageCreateInfoNV, VkExportMetalObjectCreateInfoEXT, VkExternalFormatANDROID, VkExternalFormatQNX, VkExternalMemoryImageCreateInfo, VkExternalMemoryImageCreateInfoNV, VkImageAlignmentControlCreateInfoMESA, VkImageCompressionControlEXT, VkImageDrmFormatModifierExplicitCreateInfoEXT, VkImageDrmFormatModifierListCreateInfoEXT, VkImageFormatListCreateInfo, VkImageStencilUsageCreateInfo, VkImageSwapchainCreateInfoKHR, VkImportMetalIOSurfaceInfoEXT, VkImportMetalTextureInfoEXT, VkOpaqueCaptureDescriptorDataCreateInfoEXT, VkOpticalFlowImageFormatInfoNV, or VkVideoProfileListInfoKHR", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-physicalDeviceCount-01421", "If the logical device was created with VkDeviceGroupDeviceCreateInfo::physicalDeviceCount equal to 1, flags must not contain VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique, with the exception of structures of type VkExportMetalObjectCreateInfoEXT or VkImportMetalTextureInfoEXT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-samples-02083", "If usage includes VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, samples must be VK_SAMPLE_COUNT_1_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-samples-02257", "If samples is not VK_SAMPLE_COUNT_1_BIT, then imageType must be VK_IMAGE_TYPE_2D, flags must not contain VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, mipLevels must be equal to 1, and imageCreateMaybeLinear (as defined in Image Creation Limits) must be VK_FALSE,", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-samples-02258", "samples must be a valid VkSampleCountFlagBits value that is set in imageCreateSampleCounts (as defined in Image Creation Limits)", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-samples-02558", "If samples is not VK_SAMPLE_COUNT_1_BIT, usage must not contain VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-samples-parameter", "samples must be a valid VkSampleCountFlagBits value", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-shadingRateImage-07727", "If the shadingRateImage feature is enabled and usage includes VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV, tiling must be VK_IMAGE_TILING_OPTIMAL", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-sharingMode-00941", "If sharingMode is VK_SHARING_MODE_CONCURRENT, pQueueFamilyIndices must be a valid pointer to an array of queueFamilyIndexCount uint32_t values", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-sharingMode-00942", "If sharingMode is VK_SHARING_MODE_CONCURRENT, queueFamilyIndexCount must be greater than 1", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-sharingMode-01420", "If sharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by either vkGetPhysicalDeviceQueueFamilyProperties or vkGetPhysicalDeviceQueueFamilyProperties2 for the physicalDevice that was used to create device", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-sharingMode-parameter", "sharingMode must be a valid VkSharingMode value", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-tiling-02261", "If tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then the pNext chain must include exactly one of VkImageDrmFormatModifierListCreateInfoEXT or VkImageDrmFormatModifierExplicitCreateInfoEXT structures", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-tiling-02353", "If tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT and flags contains VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT, then the pNext chain must include a VkImageFormatListCreateInfo structure with non-zero viewFormatCount", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-tiling-04121", "If tiling is VK_IMAGE_TILING_LINEAR, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-tiling-parameter", "tiling must be a valid VkImageTiling value", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-usage-00963", "If usage includes VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, then bits other than VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, and VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT must not be set", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-usage-00964", "If usage includes VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, extent.width must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferWidth", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-usage-00965", "If usage includes VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, extent.height must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferHeight", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-usage-00966", "If usage includes VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, usage must also contain at least one of VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-usage-00968", "If the shaderStorageImageMultisample feature is not enabled, and usage contains VK_IMAGE_USAGE_STORAGE_BIT, samples must be VK_SAMPLE_COUNT_1_BIT", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-usage-04815", "If usage includes VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR, VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR, or VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR, and flags does not include VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then the pNext chain must include a VkVideoProfileListInfoKHR structure with profileCount greater than 0 and pProfiles including at least one VkVideoProfileInfoKHR structure with a videoCodecOperation member specifying a decode operation", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-usage-04816", "If usage includes VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR, VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR, or VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR, and flags does not include VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then the pNext chain must include a VkVideoProfileListInfoKHR structure with profileCount greater than 0 and pProfiles including at least one VkVideoProfileInfoKHR structure with a videoCodecOperation member specifying an encode operation", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-usage-04992", "If usage includes VK_IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI, tiling must be VK_IMAGE_TILING_LINEAR", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-usage-parameter", "usage must be a valid combination of VkImageUsageFlagBits values", "1.3-extensions"},
    {"VUID-VkImageCreateInfo-usage-requiredbitmask", "usage must not be 0", "1.3-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-arrayPitch-02268", "For each element of pPlaneLayouts, arrayPitch must be 0 if VkImageCreateInfo::arrayLayers is 1", "1.3-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-depthPitch-02269", "For each element of pPlaneLayouts, depthPitch must be 0 if VkImageCreateInfo::extent.depth is 1", "1.3-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-drmFormatModifier-02264", "drmFormatModifier must be compatible with the parameters in VkImageCreateInfo and its pNext chain, as determined by querying VkPhysicalDeviceImageFormatInfo2 extended with VkPhysicalDeviceImageDrmFormatModifierInfoEXT", "1.3-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-drmFormatModifierPlaneCount-02265", "drmFormatModifierPlaneCount must be equal to the VkDrmFormatModifierPropertiesEXT::drmFormatModifierPlaneCount associated with VkImageCreateInfo::format and drmFormatModifier, as found by querying VkDrmFormatModifierPropertiesListEXT", "1.3-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-drmFormatModifierPlaneCount-arraylength", "drmFormatModifierPlaneCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-pPlaneLayouts-parameter", "pPlaneLayouts must be a valid pointer to an array of drmFormatModifierPlaneCount VkSubresourceLayout structures", "1.3-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-size-02267", "For each element of pPlaneLayouts, size must be 0", "1.3-extensions"},
    {"VUID-VkImageDrmFormatModifierListCreateInfoEXT-drmFormatModifierCount-arraylength", "drmFormatModifierCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkImageDrmFormatModifierListCreateInfoEXT-pDrmFormatModifiers-02263", "Each modifier in pDrmFormatModifiers must be compatible with the parameters in VkImageCreateInfo and its pNext chain, as determined by querying VkPhysicalDeviceImageFormatInfo2 extended with VkPhysicalDeviceImageDrmFormatModifierInfoEXT", "1.3-extensions"},
    {"VUID-VkImageDrmFormatModifierListCreateInfoEXT-pDrmFormatModifiers-parameter", "pDrmFormatModifiers must be a valid pointer to an array of drmFormatModifierCount uint64_t values", "1.3-extensions"},
    {"VUID-VkImageDrmFormatModifierListCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkImageDrmFormatModifierPropertiesEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImageDrmFormatModifierPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT", "1.3-extensions"},
    {"VUID-VkImageFormatConstraintsInfoFUCHSIA-colorSpaceCount-arraylength", "colorSpaceCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkImageFormatConstraintsInfoFUCHSIA-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkImageFormatConstraintsInfoFUCHSIA-imageCreateInfo-parameter", "imageCreateInfo must be a valid VkImageCreateInfo structure", "1.3-extensions"},
    {"VUID-VkImageFormatConstraintsInfoFUCHSIA-pColorSpaces-parameter", "pColorSpaces must be a valid pointer to an array of colorSpaceCount valid VkSysmemColorSpaceFUCHSIA structures", "1.3-extensions"},
    {"VUID-VkImageFormatConstraintsInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImageFormatConstraintsInfoFUCHSIA-requiredFormatFeatures-parameter", "requiredFormatFeatures must be a valid combination of VkFormatFeatureFlagBits values", "1.3-extensions"},
    {"VUID-VkImageFormatConstraintsInfoFUCHSIA-requiredFormatFeatures-requiredbitmask", "requiredFormatFeatures must not be 0", "1.3-extensions"},
    {"VUID-VkImageFormatConstraintsInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_FORMAT_CONSTRAINTS_INFO_FUCHSIA", "1.3-extensions"},
    {"VUID-VkImageFormatListCreateInfo-pViewFormats-parameter", "If viewFormatCount is not 0, pViewFormats must be a valid pointer to an array of viewFormatCount valid VkFormat values", "1.3-extensions"},
    {"VUID-VkImageFormatListCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkImageFormatListCreateInfo-viewFormatCount-09540", "If viewFormatCount is not 0, each element of pViewFormats must not be VK_FORMAT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkImageFormatProperties2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAndroidHardwareBufferUsageANDROID, VkExternalImageFormatProperties, VkFilterCubicImageViewImageFormatPropertiesEXT, VkHostImageCopyDevicePerformanceQueryEXT, VkImageCompressionPropertiesEXT, VkSamplerYcbcrConversionImageFormatProperties, or VkTextureLODGatherFormatPropertiesAMD", "1.3-extensions"},
    {"VUID-VkImageFormatProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2", "1.3-extensions"},
    {"VUID-VkImageFormatProperties2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-None-09052", "If the synchronization2 feature is not enabled, and image was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, at least one of srcQueueFamilyIndex and dstQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-None-09053", "If the synchronization2 feature is not enabled, and image was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, srcQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED or VK_QUEUE_FAMILY_EXTERNAL", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-None-09054", "If the synchronization2 feature is not enabled, and image was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, dstQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED or VK_QUEUE_FAMILY_EXTERNAL", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-None-09119", "If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-None-09120", "If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-aspectMask-08702", "If the aspectMask member of subresourceRange includes VK_IMAGE_ASPECT_DEPTH_BIT, oldLayout and newLayout must not be one of VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-aspectMask-08703", "If the aspectMask member of subresourceRange includes VK_IMAGE_ASPECT_STENCIL_BIT, oldLayout and newLayout must not be one of VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-attachmentFeedbackLoopLayout-07313", "If the attachmentFeedbackLoopLayout feature is not enabled, newLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-dstQueueFamilyIndex-09122", "If the VK_EXT_queue_family_foreign extension is not enabled dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-dynamicRenderingLocalRead-09551", "If the dynamicRenderingLocalRead feature is not enabled, oldLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-dynamicRenderingLocalRead-09552", "If the dynamicRenderingLocalRead feature is not enabled, newLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-image-01672", "If image has a multi-planar format and the image is disjoint, then the aspectMask member of subresourceRange must include at least one multi-planar aspect mask bit or VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-image-01932", "If image is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-image-03319", "If image has a depth/stencil format with both depth and stencil and the separateDepthStencilLayouts feature is enabled, then the aspectMask member of subresourceRange must include either or both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-image-03320", "If image has a depth/stencil format with both depth and stencil and the separateDepthStencilLayouts feature is not enabled, then the aspectMask member of subresourceRange must include both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-image-09117", "If image was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-image-09118", "If image was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, dstQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-image-09241", "If image has a color format that is single-plane, then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-image-09242", "If image has a color format and is not disjoint, then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-image-parameter", "image must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-newLayout-01198", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, newLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-newLayout-parameter", "newLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01197", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, oldLayout must be VK_IMAGE_LAYOUT_UNDEFINED or the current layout of the image subresources affected by the barrier", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01208", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01209", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01210", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01211", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_SAMPLED_BIT or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01212", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL then image must have been created with VK_IMAGE_USAGE_TRANSFER_SRC_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01213", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL then image must have been created with VK_IMAGE_USAGE_TRANSFER_DST_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01658", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01659", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-02088", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR then image must have been created with VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR set", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-oldLayout-parameter", "oldLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExternalMemoryAcquireUnmodifiedEXT or VkSampleLocationsInfoEXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-03938", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL, image must have been created with VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT or VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-03939", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL, image must have been created with at least one of VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_SAMPLED_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-04065", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL then image must have been created with at least one of VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_SAMPLED_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-04066", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT set", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-04067", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL then image must have been created with at least one of VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_SAMPLED_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-04068", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT set", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-04070", "If srcQueueFamilyIndex is not equal to dstQueueFamilyIndex, at least one of srcQueueFamilyIndex or dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL or VK_QUEUE_FAMILY_FOREIGN_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-07006", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT then image must have been created with either the VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT or VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT usage bits, and the VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT or VK_IMAGE_USAGE_SAMPLED_BIT usage bits, and the VK_IMAGE_USAGE_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT usage bit", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-07120", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_VIDEO_DECODE_SRC_KHR then image must have been created with VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-07121", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_VIDEO_DECODE_DST_KHR then image must have been created with VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-07122", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_VIDEO_DECODE_DPB_KHR then image must have been created with VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-07123", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_VIDEO_ENCODE_SRC_KHR then image must have been created with VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-07124", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_VIDEO_ENCODE_DST_KHR then image must have been created with VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-07125", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_VIDEO_ENCODE_DPB_KHR then image must have been created with VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-09121", "If the VK_EXT_queue_family_foreign extension is not enabled srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-srcQueueFamilyIndex-09550", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR then image must have been created with either VK_IMAGE_USAGE_STORAGE_BIT, or with both VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT and either of VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT or VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-01486", "subresourceRange.baseMipLevel must be less than the mipLevels specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-01488", "subresourceRange.baseArrayLayer must be less than the arrayLayers specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-01724", "If subresourceRange.levelCount is not VK_REMAINING_MIP_LEVELS, subresourceRange.baseMipLevel + subresourceRange.levelCount must be less than or equal to the mipLevels specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-01725", "If subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the arrayLayers specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-09601", "subresourceRange.aspectMask must be valid for the format the image was created with", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-parameter", "subresourceRange must be a valid VkImageSubresourceRange structure", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-synchronization2-07793", "If the synchronization2 feature is not enabled, oldLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier-synchronization2-07794", "If the synchronization2 feature is not enabled, newLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-None-09119", "If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-None-09120", "If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-aspectMask-08702", "If the aspectMask member of subresourceRange includes VK_IMAGE_ASPECT_DEPTH_BIT, oldLayout and newLayout must not be one of VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-aspectMask-08703", "If the aspectMask member of subresourceRange includes VK_IMAGE_ASPECT_STENCIL_BIT, oldLayout and newLayout must not be one of VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-attachmentFeedbackLoopLayout-07313", "If the attachmentFeedbackLoopLayout feature is not enabled, newLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03900", "If dstAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03901", "If dstAccessMask includes VK_ACCESS_2_INDEX_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03902", "If dstAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03903", "If dstAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03904", "If dstAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03905", "If dstAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03906", "If dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03907", "If dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03909", "If dstAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03910", "If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03911", "If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03912", "If dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03913", "If dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03914", "If dstAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03915", "If dstAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_CLEAR_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03916", "If dstAccessMask includes VK_ACCESS_2_HOST_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03917", "If dstAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03918", "If dstAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03919", "If dstAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03920", "If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03922", "If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03923", "If dstAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03924", "If dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03925", "If dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03926", "If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03927", "If dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-03928", "If dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-04747", "If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-04858", "If dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-04859", "If dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-04860", "If dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-04861", "If dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-04994", "If dstAccessMask includes VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI, dstStageMask must include VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-06256", "If the rayQuery feature is not enabled and dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, dstStageMask must not include any of the VK_PIPELINE_STAGE_*_SHADER_BIT stages except VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-07272", "If dstAccessMask includes VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT or VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-07454", "If dstAccessMask includes VK_ACCESS_2_SHADER_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-07455", "If dstAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-07456", "If dstAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-07457", "If dstAccessMask includes VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-07458", "If dstAccessMask includes VK_ACCESS_2_MICROMAP_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT or VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-08118", "If dstAccessMask includes VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstAccessMask-parameter", "dstAccessMask must be a valid combination of VkAccessFlagBits2 values", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstQueueFamilyIndex-09122", "If the VK_EXT_queue_family_foreign extension is not enabled dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstStageMask-03929", "If the geometryShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstStageMask-03930", "If the tessellationShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstStageMask-03931", "If the conditionalRendering feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstStageMask-03932", "If the fragmentDensityMap feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstStageMask-03933", "If the transformFeedback feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstStageMask-03934", "If the meshShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstStageMask-03935", "If the taskShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstStageMask-04957", "If the subpassShading feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstStageMask-04995", "If the invocationMask feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstStageMask-07316", "If neither the shadingRateImage or attachmentFragmentShadingRate are enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstStageMask-07946", "If neither the VK_NV_ray_tracing extension or rayTracingPipeline feature are enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dstStageMask-parameter", "dstStageMask must be a valid combination of VkPipelineStageFlagBits2 values", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dynamicRenderingLocalRead-09551", "If the dynamicRenderingLocalRead feature is not enabled, oldLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-dynamicRenderingLocalRead-09552", "If the dynamicRenderingLocalRead feature is not enabled, newLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-image-01672", "If image has a multi-planar format and the image is disjoint, then the aspectMask member of subresourceRange must include at least one multi-planar aspect mask bit or VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-image-01932", "If image is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-image-03319", "If image has a depth/stencil format with both depth and stencil and the separateDepthStencilLayouts feature is enabled, then the aspectMask member of subresourceRange must include either or both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-image-03320", "If image has a depth/stencil format with both depth and stencil and the separateDepthStencilLayouts feature is not enabled, then the aspectMask member of subresourceRange must include both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-image-09117", "If image was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-image-09118", "If image was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, dstQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-image-09241", "If image has a color format that is single-plane, then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-image-09242", "If image has a color format and is not disjoint, then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-image-parameter", "image must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-newLayout-01198", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, newLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-newLayout-parameter", "newLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-oldLayout-01197", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, oldLayout must be VK_IMAGE_LAYOUT_UNDEFINED or the current layout of the image subresources affected by the barrier", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-oldLayout-01208", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-oldLayout-01209", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-oldLayout-01210", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-oldLayout-01211", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_SAMPLED_BIT or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-oldLayout-01212", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL then image must have been created with VK_IMAGE_USAGE_TRANSFER_SRC_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-oldLayout-01213", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL then image must have been created with VK_IMAGE_USAGE_TRANSFER_DST_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-oldLayout-01658", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-oldLayout-01659", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-oldLayout-02088", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR then image must have been created with VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR set", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-oldLayout-parameter", "oldLayout must be a valid VkImageLayout value", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExternalMemoryAcquireUnmodifiedEXT or VkSampleLocationsInfoEXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03900", "If srcAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03901", "If srcAccessMask includes VK_ACCESS_2_INDEX_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03902", "If srcAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03903", "If srcAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03904", "If srcAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03905", "If srcAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03906", "If srcAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03907", "If srcAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03909", "If srcAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03910", "If srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03911", "If srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03912", "If srcAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03913", "If srcAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03914", "If srcAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03915", "If srcAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_CLEAR_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03916", "If srcAccessMask includes VK_ACCESS_2_HOST_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03917", "If srcAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03918", "If srcAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03919", "If srcAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03920", "If srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03922", "If srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03923", "If srcAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03924", "If srcAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03925", "If srcAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03926", "If srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03927", "If srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-03928", "If srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-04747", "If srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-04858", "If srcAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-04859", "If srcAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-04860", "If srcAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-04861", "If srcAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-04994", "If srcAccessMask includes VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI, srcStageMask must include VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-06256", "If the rayQuery feature is not enabled and srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, srcStageMask must not include any of the VK_PIPELINE_STAGE_*_SHADER_BIT stages except VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-07272", "If srcAccessMask includes VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT or VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-07454", "If srcAccessMask includes VK_ACCESS_2_SHADER_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-07455", "If srcAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-07456", "If srcAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-07457", "If srcAccessMask includes VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-07458", "If srcAccessMask includes VK_ACCESS_2_MICROMAP_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT or VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-08118", "If srcAccessMask includes VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcAccessMask-parameter", "srcAccessMask must be a valid combination of VkAccessFlagBits2 values", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-03938", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL, image must have been created with VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT or VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-03939", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL, image must have been created with at least one of VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_SAMPLED_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-04065", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL then image must have been created with at least one of VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_SAMPLED_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-04066", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT set", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-04067", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL then image must have been created with at least one of VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_SAMPLED_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-04068", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT set", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-04070", "If srcQueueFamilyIndex is not equal to dstQueueFamilyIndex, at least one of srcQueueFamilyIndex or dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL or VK_QUEUE_FAMILY_FOREIGN_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-07006", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT then image must have been created with either the VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT or VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT usage bits, and the VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT or VK_IMAGE_USAGE_SAMPLED_BIT usage bits, and the VK_IMAGE_USAGE_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT usage bit", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-07120", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_VIDEO_DECODE_SRC_KHR then image must have been created with VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-07121", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_VIDEO_DECODE_DST_KHR then image must have been created with VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-07122", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_VIDEO_DECODE_DPB_KHR then image must have been created with VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-07123", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_VIDEO_ENCODE_SRC_KHR then image must have been created with VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-07124", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_VIDEO_ENCODE_DST_KHR then image must have been created with VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-07125", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_VIDEO_ENCODE_DPB_KHR then image must have been created with VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-09121", "If the VK_EXT_queue_family_foreign extension is not enabled srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcQueueFamilyIndex-09550", "If srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, and oldLayout or newLayout is VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ_KHR then image must have been created with either VK_IMAGE_USAGE_STORAGE_BIT, or with both VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT and either of VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT or VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcStageMask-03854", "If either srcStageMask or dstStageMask includes VK_PIPELINE_STAGE_2_HOST_BIT, srcQueueFamilyIndex and dstQueueFamilyIndex must be equal", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcStageMask-03855", "If srcStageMask includes VK_PIPELINE_STAGE_2_HOST_BIT, and srcQueueFamilyIndex and dstQueueFamilyIndex define a queue family ownership transfer or oldLayout and newLayout define an image layout transition, oldLayout must be one of VK_IMAGE_LAYOUT_PREINITIALIZED, VK_IMAGE_LAYOUT_UNDEFINED, or VK_IMAGE_LAYOUT_GENERAL", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcStageMask-03929", "If the geometryShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcStageMask-03930", "If the tessellationShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcStageMask-03931", "If the conditionalRendering feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcStageMask-03932", "If the fragmentDensityMap feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcStageMask-03933", "If the transformFeedback feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcStageMask-03934", "If the meshShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcStageMask-03935", "If the taskShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcStageMask-04957", "If the subpassShading feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcStageMask-04995", "If the invocationMask feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcStageMask-07316", "If neither the shadingRateImage or attachmentFragmentShadingRate are enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcStageMask-07946", "If neither the VK_NV_ray_tracing extension or rayTracingPipeline feature are enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-srcStageMask-parameter", "srcStageMask must be a valid combination of VkPipelineStageFlagBits2 values", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-subresourceRange-01486", "subresourceRange.baseMipLevel must be less than the mipLevels specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-subresourceRange-01488", "subresourceRange.baseArrayLayer must be less than the arrayLayers specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-subresourceRange-01724", "If subresourceRange.levelCount is not VK_REMAINING_MIP_LEVELS, subresourceRange.baseMipLevel + subresourceRange.levelCount must be less than or equal to the mipLevels specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-subresourceRange-01725", "If subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the arrayLayers specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-subresourceRange-09601", "subresourceRange.aspectMask must be valid for the format the image was created with", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-subresourceRange-parameter", "subresourceRange must be a valid VkImageSubresourceRange structure", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-synchronization2-07793", "If the synchronization2 feature is not enabled, oldLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryBarrier2-synchronization2-07794", "If the synchronization2 feature is not enabled, newLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "1.3-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-01589", "If image was created with a multi-planar format and the VK_IMAGE_CREATE_DISJOINT_BIT flag, there must be a VkImagePlaneMemoryRequirementsInfo included in the pNext chain of the VkImageMemoryRequirementsInfo2 structure", "1.3-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-01590", "If image was not created with the VK_IMAGE_CREATE_DISJOINT_BIT flag, there must not be a VkImagePlaneMemoryRequirementsInfo included in the pNext chain of the VkImageMemoryRequirementsInfo2 structure", "1.3-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-01897", "If image was created with the VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID external memory handle type, then image must be bound to memory", "1.3-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-02279", "If image was created with VK_IMAGE_CREATE_DISJOINT_BIT and with VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then there must be a VkImagePlaneMemoryRequirementsInfo included in the pNext chain of the VkImageMemoryRequirementsInfo2 structure", "1.3-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-02280", "If image was created with a single-plane format and with any tiling other than VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then there must not be a VkImagePlaneMemoryRequirementsInfo included in the pNext chain of the VkImageMemoryRequirementsInfo2 structure", "1.3-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-08961", "If image was created with the VK_EXTERNAL_MEMORY_HANDLE_TYPE_SCREEN_BUFFER_BIT_QNX external memory handle type, then image must be bound to memory", "1.3-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-parameter", "image must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkImagePlaneMemoryRequirementsInfo", "1.3-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2", "1.3-extensions"},
    {"VUID-VkImageMemoryRequirementsInfo2-sType-unique", "The sType value of each struct in the pNext chain must be unique", "1.3-extensions"},
    {"VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-imagePipeHandle-04863", "imagePipeHandle must be a valid zx_handle_t", "1.3-extensions"},
    {"VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA", "1.3-extensions"},
    {"VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-02281", "If the image's tiling is VK_IMAGE_TILING_LINEAR or VK_IMAGE_TILING_OPTIMAL, then planeAspect must be a single valid multi-planar aspect mask bit", "1.3-extensions"},
    {"VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-02282", "If the image's tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then planeAspect must be a single valid memory plane for the image (that is, aspectMask must specify a plane index that is less than the VkDrmFormatModifierPropertiesEXT::drmFormatModifierPlaneCount associated with the image's format and VkImageDrmFormatModifierPropertiesEXT::drmFormatModifier)", "1.3-extensions"},
    {"VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-parameter", "planeAspect must be a valid VkImageAspectFlagBits value", "1.3-extensions"},
    {"VUID-VkImagePlaneMemoryRequirementsInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO", "1.3-extensions"},
    {"VUID-VkImageResolve-aspectMask-00266", "The aspectMask member of srcSubresource and dstSubresource must only contain VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkImageResolve-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkImageResolve-layerCount-08803", "If neither of the layerCount members of srcSubresource or dstSubresource are VK_REMAINING_ARRAY_LAYERS, the layerCount member of srcSubresource and dstSubresource must match", "1.3-extensions"},
    {"VUID-VkImageResolve-layerCount-08804", "If one of the layerCount members of srcSubresource or dstSubresource is VK_REMAINING_ARRAY_LAYERS, the other member must be either VK_REMAINING_ARRAY_LAYERS or equal to the arrayLayers member of the VkImageCreateInfo used to create the image minus baseArrayLayer", "1.3-extensions"},
    {"VUID-VkImageResolve-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkImageResolve2-aspectMask-00266", "The aspectMask member of srcSubresource and dstSubresource must only contain VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkImageResolve2-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkImageResolve2-layerCount-08803", "If neither of the layerCount members of srcSubresource or dstSubresource are VK_REMAINING_ARRAY_LAYERS, the layerCount member of srcSubresource and dstSubresource must match", "1.3-extensions"},
    {"VUID-VkImageResolve2-layerCount-08804", "If one of the layerCount members of srcSubresource or dstSubresource is VK_REMAINING_ARRAY_LAYERS, the other member must be either VK_REMAINING_ARRAY_LAYERS or equal to the arrayLayers member of the VkImageCreateInfo used to create the image minus baseArrayLayer", "1.3-extensions"},
    {"VUID-VkImageResolve2-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImageResolve2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2", "1.3-extensions"},
    {"VUID-VkImageResolve2-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkImageSparseMemoryRequirementsInfo2-image-parameter", "image must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkImageSparseMemoryRequirementsInfo2-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImageSparseMemoryRequirementsInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2", "1.3-extensions"},
    {"VUID-VkImageStencilUsageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkImageStencilUsageCreateInfo-stencilUsage-02539", "If stencilUsage includes VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, it must not include bits other than VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageStencilUsageCreateInfo-stencilUsage-parameter", "stencilUsage must be a valid combination of VkImageUsageFlagBits values", "1.3-extensions"},
    {"VUID-VkImageStencilUsageCreateInfo-stencilUsage-requiredbitmask", "stencilUsage must not be 0", "1.3-extensions"},
    {"VUID-VkImageSubresource-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values", "1.3-extensions"},
    {"VUID-VkImageSubresource-aspectMask-requiredbitmask", "aspectMask must not be 0", "1.3-extensions"},
    {"VUID-VkImageSubresource2KHR-imageSubresource-parameter", "imageSubresource must be a valid VkImageSubresource structure", "1.3-extensions"},
    {"VUID-VkImageSubresource2KHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImageSubresource2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2_KHR", "1.3-extensions"},
    {"VUID-VkImageSubresourceLayers-aspectMask-00167", "If aspectMask contains VK_IMAGE_ASPECT_COLOR_BIT, it must not contain either of VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT", "1.3-extensions"},
    {"VUID-VkImageSubresourceLayers-aspectMask-00168", "aspectMask must not contain VK_IMAGE_ASPECT_METADATA_BIT", "1.3-extensions"},
    {"VUID-VkImageSubresourceLayers-aspectMask-02247", "aspectMask must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i", "1.3-extensions"},
    {"VUID-VkImageSubresourceLayers-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values", "1.3-extensions"},
    {"VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask", "aspectMask must not be 0", "1.3-extensions"},
    {"VUID-VkImageSubresourceLayers-layerCount-01700", "If layerCount is not VK_REMAINING_ARRAY_LAYERS, it must be greater than 0", "1.3-extensions"},
    {"VUID-VkImageSubresourceLayers-layerCount-09243", "If the maintenance5 feature is not enabled, layerCount must not be VK_REMAINING_ARRAY_LAYERS", "1.3-extensions"},
    {"VUID-VkImageSubresourceRange-aspectMask-01670", "If aspectMask includes VK_IMAGE_ASPECT_COLOR_BIT, then it must not include any of VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT", "1.3-extensions"},
    {"VUID-VkImageSubresourceRange-aspectMask-02278", "aspectMask must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i", "1.3-extensions"},
    {"VUID-VkImageSubresourceRange-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values", "1.3-extensions"},
    {"VUID-VkImageSubresourceRange-aspectMask-requiredbitmask", "aspectMask must not be 0", "1.3-extensions"},
    {"VUID-VkImageSubresourceRange-layerCount-01721", "If layerCount is not VK_REMAINING_ARRAY_LAYERS, it must be greater than 0", "1.3-extensions"},
    {"VUID-VkImageSubresourceRange-levelCount-01720", "If levelCount is not VK_REMAINING_MIP_LEVELS, it must be greater than 0", "1.3-extensions"},
    {"VUID-VkImageSwapchainCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkImageSwapchainCreateInfoKHR-swapchain-00995", "If swapchain is not VK_NULL_HANDLE, the fields of VkImageCreateInfo must match the implied image creation parameters of the swapchain", "1.3-extensions"},
    {"VUID-VkImageSwapchainCreateInfoKHR-swapchain-parameter", "If swapchain is not VK_NULL_HANDLE, swapchain must be a valid VkSwapchainKHR handle", "1.3-extensions"},
    {"VUID-VkImageToMemoryCopyEXT-aspectMask-09103", "The aspectMask member of imageSubresource must only have a single bit set", "1.3-extensions"},
    {"VUID-VkImageToMemoryCopyEXT-imageExtent-06659", "imageExtent.width must not be 0", "1.3-extensions"},
    {"VUID-VkImageToMemoryCopyEXT-imageExtent-06660", "imageExtent.height must not be 0", "1.3-extensions"},
    {"VUID-VkImageToMemoryCopyEXT-imageExtent-06661", "imageExtent.depth must not be 0", "1.3-extensions"},
    {"VUID-VkImageToMemoryCopyEXT-imageSubresource-parameter", "imageSubresource must be a valid VkImageSubresourceLayers structure", "1.3-extensions"},
    {"VUID-VkImageToMemoryCopyEXT-memoryImageHeight-09102", "memoryImageHeight must be 0, or greater than or equal to the height member of imageExtent", "1.3-extensions"},
    {"VUID-VkImageToMemoryCopyEXT-memoryRowLength-09101", "memoryRowLength must be 0, or greater than or equal to the width member of imageExtent", "1.3-extensions"},
    {"VUID-VkImageToMemoryCopyEXT-pHostPointer-09066", "pHostPointer must point to memory that is large enough to contain all memory locations that are accessed according to Buffer and Image Addressing, for each element of pRegions", "1.3-extensions"},
    {"VUID-VkImageToMemoryCopyEXT-pHostPointer-parameter", "pHostPointer must be a pointer value", "1.3-extensions"},
    {"VUID-VkImageToMemoryCopyEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImageToMemoryCopyEXT-pRegions-09067", "The union of all source regions, and the union of all destination regions, specified by the elements of pRegions, must not overlap in memory", "1.3-extensions"},
    {"VUID-VkImageToMemoryCopyEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_TO_MEMORY_COPY_EXT", "1.3-extensions"},
    {"VUID-VkImageViewASTCDecodeModeEXT-decodeMode-02230", "decodeMode must be one of VK_FORMAT_R16G16B16A16_SFLOAT, VK_FORMAT_R8G8B8A8_UNORM, or VK_FORMAT_E5B9G9R9_UFLOAT_PACK32", "1.3-extensions"},
    {"VUID-VkImageViewASTCDecodeModeEXT-decodeMode-02231", "If the decodeModeSharedExponent feature is not enabled, decodeMode must not be VK_FORMAT_E5B9G9R9_UFLOAT_PACK32", "1.3-extensions"},
    {"VUID-VkImageViewASTCDecodeModeEXT-decodeMode-02232", "If decodeMode is VK_FORMAT_R8G8B8A8_UNORM the image view must not include blocks using any of the ASTC HDR modes", "1.3-extensions"},
    {"VUID-VkImageViewASTCDecodeModeEXT-decodeMode-parameter", "decodeMode must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkImageViewASTCDecodeModeEXT-format-04084", "format of the image view must be one of the ASTC Compressed Image Formats", "1.3-extensions"},
    {"VUID-VkImageViewASTCDecodeModeEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT", "1.3-extensions"},
    {"VUID-VkImageViewAddressPropertiesNVX-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImageViewAddressPropertiesNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX", "1.3-extensions"},
    {"VUID-VkImageViewCaptureDescriptorDataInfoEXT-imageView-08083", "imageView must have been created with VK_IMAGE_VIEW_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT set in VkImageViewCreateInfo::flags", "1.3-extensions"},
    {"VUID-VkImageViewCaptureDescriptorDataInfoEXT-imageView-parameter", "imageView must be a valid VkImageView handle", "1.3-extensions"},
    {"VUID-VkImageViewCaptureDescriptorDataInfoEXT-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImageViewCaptureDescriptorDataInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_CAPTURE_DESCRIPTOR_DATA_INFO_EXT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-None-02273", "The format features of the resultant image view must contain at least one bit", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-components-parameter", "components must be a valid VkComponentMapping structure", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-flags-02572", "If the fragmentDensityMapDynamic feature is not enabled, flags must not contain VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-flags-03567", "If the fragmentDensityMapDeferred feature is not enabled, flags must not contain VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-flags-03568", "If flags contains VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT, flags must not contain VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-flags-04116", "If flags does not contain VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT and image was created with usage containing VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, its flags must not contain any of VK_IMAGE_CREATE_PROTECTED_BIT, VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-flags-08106", "If flags includes VK_IMAGE_VIEW_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT, the descriptorBufferCaptureReplay feature must be enabled", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-flags-parameter", "flags must be a valid combination of VkImageViewCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-format-04714", "If format has a _422 or _420 suffix then image must have been created with a width that is a multiple of 2", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-format-04715", "If format has a _420 suffix then image must have been created with a height that is a multiple of 2", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-format-06415", "If the image view requires a sampler Y'CBCR conversion and usage contains VK_IMAGE_USAGE_SAMPLED_BIT, then the pNext chain must include a VkSamplerYcbcrConversionInfo structure with a conversion value other than VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-format-parameter", "format must be a valid VkFormat value", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01003", "If image was not created with VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT then viewType must not be VK_IMAGE_VIEW_TYPE_CUBE or VK_IMAGE_VIEW_TYPE_CUBE_ARRAY", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01020", "If image is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01583", "If image was created with the VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, format must be compatible with, or must be an uncompressed format that is size-compatible with, the format used to create image", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01586", "If image was created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, if the format of the image is a multi-planar format, and if subresourceRange.aspectMask is one of the multi-planar aspect mask bits, then format must be compatible with the VkFormat for the plane of the image format indicated by subresourceRange.aspectMask, as defined in Compatible Formats of Planes of Multi-Planar Formats", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01761", "If image was created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, but without the VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, and if the format of the image is not a multi-planar format, format must be compatible with the format used to create image, as defined in Format Compatibility Classes", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-01762", "If image was not created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, or if the format of the image is a multi-planar format and if subresourceRange.aspectMask is VK_IMAGE_ASPECT_COLOR_BIT, format must be identical to the format used to create image", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-02086", "If image was created with usage containing VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, viewType must be VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-02087", "If the shadingRateImage feature is enabled, and If image was created with usage containing VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV, format must be VK_FORMAT_R8_UINT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-02399", "If image has an Android external format, format must be VK_FORMAT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-02400", "If image has an Android external format, the pNext chain must include a VkSamplerYcbcrConversionInfo structure with a conversion object created with the same external format as image", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-02401", "If image has an Android external format, all members of components must be the identity swizzle", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-02571", "If image was created with usage containing VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, subresourceRange.levelCount must be 1", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-02724", "If image is a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, and viewType is VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY, subresourceRange.baseArrayLayer must be less than the depth computed from baseMipLevel and extent.depth specified in VkImageCreateInfo when image was created, according to the formula defined in Image Mip Level Sizing", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-03569", "If image was created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT and usage containing VK_IMAGE_USAGE_SAMPLED_BIT, subresourceRange.layerCount must be less than or equal to VkPhysicalDeviceFragmentDensityMap2PropertiesEXT::maxSubsampledArrayLayers", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-04441", "image must have been created with a usage value containing at least one of the usages defined in the valid image usage list for image views", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-04817", "If image was created with usage containing VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR, VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR, or VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR, then the viewType must be VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-04818", "If image was created with usage containing VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR, VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR, or VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR, then the viewType must be VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-04970", "If image was created with VK_IMAGE_TYPE_3D and viewType is VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY then subresourceRange.levelCount must be 1", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-04971", "If image was created with VK_IMAGE_TYPE_3D and viewType is VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY then VkImageCreateInfo::flags must not contain any of VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, and VK_IMAGE_CREATE_SPARSE_ALIASED_BIT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-04972", "If image was created with a samples value not equal to VK_SAMPLE_COUNT_1_BIT then viewType must be either VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-06723", "If image was created with VK_IMAGE_TYPE_3D but without VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set then viewType must not be VK_IMAGE_VIEW_TYPE_2D_ARRAY", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-06724", "If image is not a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT or VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT set, or viewType is not VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY, subresourceRange.baseArrayLayer must be less than the arrayLayers specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-06728", "If image was created with VK_IMAGE_TYPE_3D but without VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT or VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT set, then viewType must not be VK_IMAGE_VIEW_TYPE_2D", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-07072", "If image was created with the VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag and format is a non-compressed format, the levelCount member of subresourceRange must be 1", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-08333", "If image was created with VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR and usage contains VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR, then the image view's format features must contain VK_FORMAT_FEATURE_VIDEO_DECODE_OUTPUT_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-08334", "If image was created with VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR and usage contains VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR, then the image view's format features must contain VK_FORMAT_FEATURE_VIDEO_DECODE_DPB_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-08335", "If image was created with VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then usage must not include VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-08336", "If image was created with VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR and usage contains VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR, then the image view's format features must contain VK_FORMAT_FEATURE_VIDEO_ENCODE_INPUT_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-08337", "If image was created with VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR and usage contains VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR, then the image view's format features must contain VK_FORMAT_FEATURE_VIDEO_ENCODE_DPB_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-08338", "If image was created with VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then usage must not include VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-08957", "If image has an QNX Screen external format, format must be VK_FORMAT_UNDEFINED", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-08958", "If image has an QNX Screen external format, the pNext chain must include a VkSamplerYcbcrConversionInfo structure with a conversion object created with the same external format as image", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-08959", "If image has an QNX Screen external format, all members of components must be the identity swizzle", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-09487", "If image was created with the VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, the VkPhysicalDeviceMaintenance6PropertiesKHR::blockTexelViewCompatibleMultipleLayers property is not set to VK_TRUE, and format is a non-compressed format, then the layerCount member of subresourceRange must be 1", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-image-parameter", "image must be a valid VkImage handle", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-imageViewFormatReinterpretation-04466", "If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::imageViewFormatReinterpretation is VK_FALSE, the VkFormat in format must not contain a different number of components, or a different number of bits in each component, than the format of the VkImage in image", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-imageViewFormatSwizzle-04465", "If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::imageViewFormatSwizzle is VK_FALSE, all elements of components must have the identity swizzle", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-imageViewType-04973", "If viewType is VK_IMAGE_VIEW_TYPE_1D, VK_IMAGE_VIEW_TYPE_2D, or VK_IMAGE_VIEW_TYPE_3D; and subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, then subresourceRange.layerCount must be 1", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-imageViewType-04974", "If viewType is VK_IMAGE_VIEW_TYPE_1D, VK_IMAGE_VIEW_TYPE_2D, or VK_IMAGE_VIEW_TYPE_3D; and subresourceRange.layerCount is VK_REMAINING_ARRAY_LAYERS, then the remaining number of layers must be 1", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-invocationMask-04993", "If the invocationMask feature is enabled, and if image was created with usage containing VK_IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI, format must be VK_FORMAT_R8_UINT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-01585", "If a VkImageFormatListCreateInfo structure was included in the pNext chain of the VkImageCreateInfo structure used when creating image and VkImageFormatListCreateInfo::viewFormatCount is not zero then format must be one of the formats in VkImageFormatListCreateInfo::pViewFormats", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-01970", "If the pNext chain includes a VkSamplerYcbcrConversionInfo structure with a conversion value other than VK_NULL_HANDLE, all members of components must have the identity swizzle", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-02662", "If the pNext chain includes a VkImageViewUsageCreateInfo structure, and image was not created with a VkImageStencilUsageCreateInfo structure included in the pNext chain of VkImageCreateInfo, its usage member must not include any bits that were not set in the usage member of the VkImageCreateInfo structure used to create image", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-02663", "If the pNext chain includes a VkImageViewUsageCreateInfo structure, image was created with a VkImageStencilUsageCreateInfo structure included in the pNext chain of VkImageCreateInfo, and subresourceRange.aspectMask includes VK_IMAGE_ASPECT_STENCIL_BIT, the usage member of the VkImageViewUsageCreateInfo structure must not include any bits that were not set in the usage member of the VkImageStencilUsageCreateInfo structure used to create image", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-02664", "If the pNext chain includes a VkImageViewUsageCreateInfo structure, image was created with a VkImageStencilUsageCreateInfo structure included in the pNext chain of VkImageCreateInfo, and subresourceRange.aspectMask includes bits other than VK_IMAGE_ASPECT_STENCIL_BIT, the usage member of the VkImageViewUsageCreateInfo structure must not include any bits that were not set in the usage member of the VkImageCreateInfo structure used to create image", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06658", "If the pNext chain includes a VkSamplerYcbcrConversionInfo structure with a conversion value other than VK_NULL_HANDLE, format must be the same used in VkSamplerYcbcrConversionCreateInfo::format", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06787", "If the pNext chain includes a VkExportMetalObjectCreateInfoEXT structure, its exportObjectType member must be VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06944", "If the pNext chain includes VkImageViewSampleWeightCreateInfoQCOM structure, then textureSampleWeighted feature must be enabled", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06945", "If the pNext chain includes VkImageViewSampleWeightCreateInfoQCOM structure, then image must have been created with usage containing VK_IMAGE_USAGE_SAMPLE_WEIGHT_BIT_QCOM", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06946", "If the pNext chain includes VkImageViewSampleWeightCreateInfoQCOM structure, then components must be VK_COMPONENT_SWIZZLE_IDENTITY for all components", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06947", "If the pNext chain includes VkImageViewSampleWeightCreateInfoQCOM structure, then subresourceRange.aspectMask must be VK_IMAGE_ASPECT_COLOR_BIT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06948", "If the pNext chain includes VkImageViewSampleWeightCreateInfoQCOM structure, then subresourceRange.levelCount must be 1", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06949", "If the pNext chain includes VkImageViewSampleWeightCreateInfoQCOM structure, then viewType must be VK_IMAGE_VIEW_TYPE_1D_ARRAY or VK_IMAGE_VIEW_TYPE_2D_ARRAY", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06950", "If the pNext chain includes VkImageViewSampleWeightCreateInfoQCOM structure and if viewType is VK_IMAGE_VIEW_TYPE_1D_ARRAY, then image must have been created with imageType VK_IMAGE_TYPE_1D", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06951", "If the pNext chain includes VkImageViewSampleWeightCreateInfoQCOM structure and viewType is VK_IMAGE_VIEW_TYPE_1D_ARRAY, then subresourceRange.layerCount must be equal to 2", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06952", "If the pNext chain includes VkImageViewSampleWeightCreateInfoQCOM structure and viewType is VK_IMAGE_VIEW_TYPE_1D_ARRAY, then image must have been created with width equal to or greater than \\((numPhases \\times \\mathbin{max}\\left( \\mathbin{align}\\left(filterSize.width,4\\right), filterSize.height\\right))\\)", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06953", "If the pNext chain includes VkImageViewSampleWeightCreateInfoQCOM structure and if viewType is VK_IMAGE_VIEW_TYPE_2D_ARRAY, then image must have been created with imageType VK_IMAGE_TYPE_2D", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06954", "If the pNext chain includes VkImageViewSampleWeightCreateInfoQCOM structure and viewType is VK_IMAGE_VIEW_TYPE_2D_ARRAY, then subresourceRange.layerCount must be equal or greater than numPhases", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06955", "If the pNext chain includes VkImageViewSampleWeightCreateInfoQCOM structure and viewType is VK_IMAGE_VIEW_TYPE_2D_ARRAY, then image must have been created with width equal to or greater than filterSize.width", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06956", "If the pNext chain includes VkImageViewSampleWeightCreateInfoQCOM structure and viewType is VK_IMAGE_VIEW_TYPE_2D_ARRAY, then image must have been created with height equal to or greater than filterSize.height", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-06957", "If the pNext chain includes VkImageViewSampleWeightCreateInfoQCOM structure then VkImageViewSampleWeightCreateInfoQCOM::filterSize.height must be less than or equal to VkPhysicalDeviceImageProcessingPropertiesQCOM::maxWeightFilterDimension.height", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-08107", "If the pNext chain includes a VkOpaqueCaptureDescriptorDataCreateInfoEXT structure, flags must contain VK_IMAGE_VIEW_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExportMetalObjectCreateInfoEXT, VkImageViewASTCDecodeModeEXT, VkImageViewMinLodCreateInfoEXT, VkImageViewSampleWeightCreateInfoQCOM, VkImageViewSlicedCreateInfoEXT, VkImageViewUsageCreateInfo, VkOpaqueCaptureDescriptorDataCreateInfoEXT, or VkSamplerYcbcrConversionInfo", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique, with the exception of structures of type VkExportMetalObjectCreateInfoEXT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-subResourceRange-01021", "viewType must be compatible with the type of image as shown in the view type compatibility table", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-01478", "subresourceRange.baseMipLevel must be less than the mipLevels specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-01718", "If subresourceRange.levelCount is not VK_REMAINING_MIP_LEVELS, subresourceRange.baseMipLevel + subresourceRange.levelCount must be less than or equal to the mipLevels specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-02725", "If subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, image is a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, and viewType is VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY, subresourceRange.layerCount must be non-zero and subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the depth computed from baseMipLevel and extent.depth specified in VkImageCreateInfo when image was created, according to the formula defined in Image Mip Level Sizing", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-06725", "If subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, image is not a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT or VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT set, or viewType is not VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY, subresourceRange.layerCount must be non-zero and subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the arrayLayers specified in VkImageCreateInfo when image was created", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-07818", "subresourceRange.aspectMask must only have at most 1 valid multi-planar aspect mask bit", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-09594", "subresourceRange.aspectMask must be valid for the format the image was created with", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-parameter", "subresourceRange must be a valid VkImageSubresourceRange structure", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-usage-02274", "If usage contains VK_IMAGE_USAGE_SAMPLED_BIT, then the format features of the resultant image view must contain VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-usage-02275", "If usage contains VK_IMAGE_USAGE_STORAGE_BIT, then the image view's format features must contain VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-usage-02277", "If usage contains VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, then the image view's format features must contain VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-usage-04550", "If the attachmentFragmentShadingRate feature is enabled, and the usage for the image view includes VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, then the image view's format features must contain VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-usage-04551", "If the attachmentFragmentShadingRate feature is enabled, the usage for the image view includes VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, and layeredShadingRateAttachments is VK_FALSE, subresourceRange.layerCount must be 1", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-usage-08931", "If usage contains VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, then the image view's format features must contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or VK_FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-usage-08932", "If usage contains VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, and any of the following is true: the externalFormatResolve feature is not enabled the nullColorAttachmentWithExternalFormatResolve property is VK_FALSE image was created with an VkExternalFormatANDROID::externalFormat value of 0 then the image view's format features must contain at least one of VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT or VK_FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-viewType-01004", "If the imageCubeArray feature is not enabled, viewType must not be VK_IMAGE_VIEW_TYPE_CUBE_ARRAY", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-viewType-02960", "If viewType is VK_IMAGE_VIEW_TYPE_CUBE and subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, subresourceRange.layerCount must be 6", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-viewType-02961", "If viewType is VK_IMAGE_VIEW_TYPE_CUBE_ARRAY and subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, subresourceRange.layerCount must be a multiple of 6", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-viewType-02962", "If viewType is VK_IMAGE_VIEW_TYPE_CUBE and subresourceRange.layerCount is VK_REMAINING_ARRAY_LAYERS, the remaining number of layers must be 6", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-viewType-02963", "If viewType is VK_IMAGE_VIEW_TYPE_CUBE_ARRAY and subresourceRange.layerCount is VK_REMAINING_ARRAY_LAYERS, the remaining number of layers must be a multiple of 6", "1.3-extensions"},
    {"VUID-VkImageViewCreateInfo-viewType-parameter", "viewType must be a valid VkImageViewType value", "1.3-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-commonparent", "Both of imageView, and sampler that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "1.3-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-descriptorType-02654", "descriptorType must be VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER", "1.3-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-descriptorType-parameter", "descriptorType must be a valid VkDescriptorType value", "1.3-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-imageView-02656", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the image that imageView was created from must have been created with the VK_IMAGE_USAGE_SAMPLED_BIT usage bit set", "1.3-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-imageView-02657", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, the image that imageView was created from must have been created with the VK_IMAGE_USAGE_STORAGE_BIT usage bit set", "1.3-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-imageView-parameter", "imageView must be a valid VkImageView handle", "1.3-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX", "1.3-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-sampler-02655", "sampler must be a valid VkSampler if descriptorType is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER", "1.3-extensions"},
    {"VUID-VkImageViewHandleInfoNVX-sampler-parameter", "If sampler is not VK_NULL_HANDLE, sampler must be a valid VkSampler handle", "1.3-extensions"},
    {"VUID-VkImageViewMinLodCreateInfoEXT-minLod-06455", "If the minLod feature is not enabled, minLod must be 0.0", "1.3-extensions"},
    {"VUID-VkImageViewMinLodCreateInfoEXT-minLod-06456", "minLod must be less or equal to the index of the last mipmap level accessible to the view", "1.3-extensions"},
    {"VUID-VkImageViewMinLodCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkImageViewSampleWeightCreateInfoQCOM-filterCenter-06960", "filterCenter.x must be less than or equal to (filterSize.width - 1)", "1.3-extensions"},
    {"VUID-VkImageViewSampleWeightCreateInfoQCOM-filterCenter-06961", "filterCenter.y must be less than or equal to (filterSize.height - 1)", "1.3-extensions"},
    {"VUID-VkImageViewSampleWeightCreateInfoQCOM-filterSize-06958", "filterSize.width must be less than or equal to VkPhysicalDeviceImageProcessingPropertiesQCOM::maxWeightFilterDimension.width", "1.3-extensions"},
    {"VUID-VkImageViewSampleWeightCreateInfoQCOM-filterSize-06959", "filterSize.height must be less than or equal to VkPhysicalDeviceImageProcessingPropertiesQCOM::maxWeightFilterDimension.height", "1.3-extensions"},
    {"VUID-VkImageViewSampleWeightCreateInfoQCOM-numPhases-06962", "numPhases must be a power of two squared value (i.e., 1, 4, 16, 64, 256, etc.)", "1.3-extensions"},
    {"VUID-VkImageViewSampleWeightCreateInfoQCOM-numPhases-06963", "numPhases must be less than or equal to VkPhysicalDeviceImageProcessingPropertiesQCOM::maxWeightFilterPhases", "1.3-extensions"},
    {"VUID-VkImageViewSampleWeightCreateInfoQCOM-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_SAMPLE_WEIGHT_CREATE_INFO_QCOM", "1.3-extensions"},
    {"VUID-VkImageViewSlicedCreateInfoEXT-None-07870", "The image view must reference exactly 1 mip level", "1.3-extensions"},
    {"VUID-VkImageViewSlicedCreateInfoEXT-None-07871", "The imageSlicedViewOf3D feature must be enabled on the device", "1.3-extensions"},
    {"VUID-VkImageViewSlicedCreateInfoEXT-image-07869", "image must have been created with imageType equal to VK_IMAGE_TYPE_3D", "1.3-extensions"},
    {"VUID-VkImageViewSlicedCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_SLICED_CREATE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkImageViewSlicedCreateInfoEXT-sliceCount-07868", "If sliceCount is not VK_REMAINING_3D_SLICES_EXT, it must be non-zero and sliceOffset + sliceCount must be less than or equal to the effective view depth as specified in Image Mip Level Sizing", "1.3-extensions"},
    {"VUID-VkImageViewSlicedCreateInfoEXT-sliceOffset-07867", "sliceOffset must be less than the effective view depth as specified in Image Mip Level Sizing", "1.3-extensions"},
    {"VUID-VkImageViewSlicedCreateInfoEXT-viewType-07909", "viewType must be VK_IMAGE_VIEW_TYPE_3D", "1.3-extensions"},
    {"VUID-VkImageViewUsageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkImageViewUsageCreateInfo-usage-parameter", "usage must be a valid combination of VkImageUsageFlagBits values", "1.3-extensions"},
    {"VUID-VkImageViewUsageCreateInfo-usage-requiredbitmask", "usage must not be 0", "1.3-extensions"},
    {"VUID-VkImportAndroidHardwareBufferInfoANDROID-buffer-01880", "If buffer is not NULL, Android hardware buffers must be supported for import, as reported by VkExternalImageFormatProperties or VkExternalBufferProperties", "1.3-extensions"},
    {"VUID-VkImportAndroidHardwareBufferInfoANDROID-buffer-01881", "If buffer is not NULL, it must be a valid Android hardware buffer object with AHardwareBuffer_Desc::usage compatible with Vulkan as described in Android Hardware Buffers", "1.3-extensions"},
    {"VUID-VkImportAndroidHardwareBufferInfoANDROID-buffer-parameter", "buffer must be a valid pointer to an AHardwareBuffer value", "1.3-extensions"},
    {"VUID-VkImportAndroidHardwareBufferInfoANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID", "1.3-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-fd-01541", "fd must obey any requirements listed for handleType in external fence handle types compatibility", "1.3-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-fence-parameter", "fence must be a valid VkFence handle", "1.3-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-flags-parameter", "flags must be a valid combination of VkFenceImportFlagBits values", "1.3-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-handleType-01464", "handleType must be a value included in the Handle Types Supported by VkImportFenceFdInfoKHR table", "1.3-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-handleType-07306", "If handleType refers to a handle type with copy payload transference semantics, flags must contain VK_FENCE_IMPORT_TEMPORARY_BIT", "1.3-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-handleType-parameter", "handleType must be a valid VkExternalFenceHandleTypeFlagBits value", "1.3-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImportFenceFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR", "1.3-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-fence-parameter", "fence must be a valid VkFence handle", "1.3-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-flags-parameter", "flags must be a valid combination of VkFenceImportFlagBits values", "1.3-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handle-01462", "If handle is not NULL, name must be NULL", "1.3-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handle-01539", "If handle is not NULL, it must obey any requirements listed for handleType in external fence handle types compatibility", "1.3-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handleType-01457", "handleType must be a value included in the Handle Types Supported by VkImportFenceWin32HandleInfoKHR table", "1.3-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handleType-01459", "If handleType is not VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT, name must be NULL", "1.3-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handleType-01460", "If handle is NULL, name must name a valid synchronization primitive of the type specified by handleType", "1.3-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handleType-01461", "If name is NULL, handle must be a valid handle of the type specified by handleType", "1.3-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-name-01540", "If name is not NULL, it must obey any requirements listed for handleType in external fence handle types compatibility", "1.3-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkImportMemoryBufferCollectionFUCHSIA-collection-parameter", "collection must be a valid VkBufferCollectionFUCHSIA handle", "1.3-extensions"},
    {"VUID-VkImportMemoryBufferCollectionFUCHSIA-index-06406", "index must be less than the value retrieved as VkBufferCollectionPropertiesFUCHSIA:bufferCount", "1.3-extensions"},
    {"VUID-VkImportMemoryBufferCollectionFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA", "1.3-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-fd-00668", "The memory from which fd was exported must have been created on the same underlying physical device as device", "1.3-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-fd-01520", "fd must obey any requirements listed for handleType in external memory handle types compatibility", "1.3-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-fd-01746", "The memory represented by fd must have been created from a physical device and driver that is compatible with device and handleType, as described in External memory handle types compatibility", "1.3-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-handleType-00667", "If handleType is not 0, it must be supported for import, as reported by VkExternalImageFormatProperties or VkExternalBufferProperties", "1.3-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-handleType-00669", "If handleType is not 0, it must be VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT or VK_EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-handleType-00670", "If handleType is not 0, fd must be a valid handle of the type specified by handleType", "1.3-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-handleType-parameter", "If handleType is not 0, handleType must be a valid VkExternalMemoryHandleTypeFlagBits value", "1.3-extensions"},
    {"VUID-VkImportMemoryFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR", "1.3-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-01747", "If handleType is not 0, it must be supported for import, as reported in VkExternalMemoryProperties", "1.3-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-01748", "If handleType is not 0, it must be VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT or VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT", "1.3-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-01750", "If handleType is VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT, pHostPointer must be a pointer to allocationSize number of bytes of host memory, where allocationSize is the member of the VkMemoryAllocateInfo structure this structure is chained to", "1.3-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-01751", "If handleType is VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT, pHostPointer must be a pointer to allocationSize number of bytes of host mapped foreign memory, where allocationSize is the member of the VkMemoryAllocateInfo structure this structure is chained to", "1.3-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-parameter", "handleType must be a valid VkExternalMemoryHandleTypeFlagBits value", "1.3-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-pHostPointer-01749", "pHostPointer must be a pointer aligned to an integer multiple of VkPhysicalDeviceExternalMemoryHostPropertiesEXT::minImportedHostPointerAlignment", "1.3-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-pHostPointer-parameter", "pHostPointer must be a pointer value", "1.3-extensions"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handle-00659", "The memory from which handle was exported, or the memory named by name must have been created on the same underlying physical device as device", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handle-01441", "If handle is not NULL, name must be NULL", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handle-01518", "If handle is not NULL, it must obey any requirements listed for handleType in external memory handle types compatibility", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-00658", "If handleType is not 0, it must be supported for import, as reported by VkExternalImageFormatProperties or VkExternalBufferProperties", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-00660", "If handleType is not 0, it must be defined as an NT handle or a global share handle", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-00661", "If handleType is not 0 and name is NULL, handle must be a valid handle of the type specified by handleType", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-01439", "If handleType is not VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, or VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT, name must be NULL", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-01440", "If handleType is not 0 and handle is NULL, name must name a valid memory resource of the type specified by handleType", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-parameter", "If handleType is not 0, handleType must be a valid VkExternalMemoryHandleTypeFlagBits value", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-name-01519", "If name is not NULL, it must obey any requirements listed for handleType in external memory handle types compatibility", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoNV-handle-01328", "handle must be a valid handle to memory, obtained as specified by handleType", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoNV-handleType-01327", "handleType must not have more than one bit set", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoNV-handleType-parameter", "handleType must be a valid combination of VkExternalMemoryHandleTypeFlagBitsNV values", "1.3-extensions"},
    {"VUID-VkImportMemoryWin32HandleInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV", "1.3-extensions"},
    {"VUID-VkImportMemoryZirconHandleInfoFUCHSIA-handle-04772", "handle must be a valid VMO handle", "1.3-extensions"},
    {"VUID-VkImportMemoryZirconHandleInfoFUCHSIA-handleType-04771", "handleType must be VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA", "1.3-extensions"},
    {"VUID-VkImportMemoryZirconHandleInfoFUCHSIA-handleType-parameter", "If handleType is not 0, handleType must be a valid VkExternalMemoryHandleTypeFlagBits value", "1.3-extensions"},
    {"VUID-VkImportMemoryZirconHandleInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA", "1.3-extensions"},
    {"VUID-VkImportMetalBufferInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_METAL_BUFFER_INFO_EXT", "1.3-extensions"},
    {"VUID-VkImportMetalIOSurfaceInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_METAL_IO_SURFACE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkImportMetalSharedEventInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_METAL_SHARED_EVENT_INFO_EXT", "1.3-extensions"},
    {"VUID-VkImportMetalTextureInfoEXT-plane-parameter", "plane must be a valid VkImageAspectFlagBits value", "1.3-extensions"},
    {"VUID-VkImportMetalTextureInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_METAL_TEXTURE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkImportScreenBufferInfoQNX-buffer-08966", "If buffer is not NULL, QNX Screen Buffers must be supported for import, as reported by VkExternalImageFormatProperties or VkExternalBufferProperties", "1.3-extensions"},
    {"VUID-VkImportScreenBufferInfoQNX-buffer-08967", "buffer is not NULL, it must be a pointer to valid QNX Screen buffer", "1.3-extensions"},
    {"VUID-VkImportScreenBufferInfoQNX-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_SCREEN_BUFFER_INFO_QNX", "1.3-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-fd-01544", "fd must obey any requirements listed for handleType in external semaphore handle types compatibility", "1.3-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-flags-03323", "If flags contains VK_SEMAPHORE_IMPORT_TEMPORARY_BIT, the VkSemaphoreTypeCreateInfo::semaphoreType field of the semaphore from which fd was exported must not be VK_SEMAPHORE_TYPE_TIMELINE", "1.3-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-flags-parameter", "flags must be a valid combination of VkSemaphoreImportFlagBits values", "1.3-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-handleType-01143", "handleType must be a value included in the Handle Types Supported by VkImportSemaphoreFdInfoKHR table", "1.3-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-handleType-03263", "If handleType is VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT, the VkSemaphoreCreateInfo::flags field must match that of the semaphore from which fd was exported", "1.3-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-handleType-03264", "If handleType is VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT, the VkSemaphoreTypeCreateInfo::semaphoreType field must match that of the semaphore from which fd was exported", "1.3-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-handleType-07307", "If handleType refers to a handle type with copy payload transference semantics, flags must contain VK_SEMAPHORE_IMPORT_TEMPORARY_BIT", "1.3-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-handleType-parameter", "handleType must be a valid VkExternalSemaphoreHandleTypeFlagBits value", "1.3-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR", "1.3-extensions"},
    {"VUID-VkImportSemaphoreFdInfoKHR-semaphore-parameter", "semaphore must be a valid VkSemaphore handle", "1.3-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-flags-03322", "If flags contains VK_SEMAPHORE_IMPORT_TEMPORARY_BIT, the VkSemaphoreTypeCreateInfo::semaphoreType field of the semaphore from which handle or name was exported must not be VK_SEMAPHORE_TYPE_TIMELINE", "1.3-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-flags-parameter", "flags must be a valid combination of VkSemaphoreImportFlagBits values", "1.3-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handle-01469", "If handle is not NULL, name must be NULL", "1.3-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handle-01542", "If handle is not NULL, it must obey any requirements listed for handleType in external semaphore handle types compatibility", "1.3-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01140", "handleType must be a value included in the Handle Types Supported by VkImportSemaphoreWin32HandleInfoKHR table", "1.3-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01466", "If handleType is not VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT, name must be NULL", "1.3-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01467", "If handle is NULL, name must name a valid synchronization primitive of the type specified by handleType", "1.3-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01468", "If name is NULL, handle must be a valid handle of the type specified by handleType", "1.3-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-03261", "If handleType is VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, the VkSemaphoreCreateInfo::flags field must match that of the semaphore from which handle or name was exported", "1.3-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-03262", "If handleType is VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, the VkSemaphoreTypeCreateInfo::semaphoreType field must match that of the semaphore from which handle or name was exported", "1.3-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-name-01543", "If name is not NULL, it must obey any requirements listed for handleType in external semaphore handle types compatibility", "1.3-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR", "1.3-extensions"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-semaphore-parameter", "semaphore must be a valid VkSemaphore handle", "1.3-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-flags-parameter", "flags must be a valid combination of VkSemaphoreImportFlagBits values", "1.3-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-handleType-04765", "handleType must be a value included in the Handle Types Supported by VkImportSemaphoreZirconHandleInfoFUCHSIA table", "1.3-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-handleType-parameter", "handleType must be a valid VkExternalSemaphoreHandleTypeFlagBits value", "1.3-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA", "1.3-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-semaphore-parameter", "semaphore must be a valid VkSemaphore handle", "1.3-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-semaphoreType-04768", "The VkSemaphoreTypeCreateInfo::semaphoreType field must not be VK_SEMAPHORE_TYPE_TIMELINE", "1.3-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-zirconHandle-04766", "zirconHandle must obey any requirements listed for handleType in external semaphore handle types compatibility", "1.3-extensions"},
    {"VUID-VkImportSemaphoreZirconHandleInfoFUCHSIA-zirconHandle-04767", "zirconHandle must have ZX_RIGHTS_BASIC and ZX_RIGHTS_SIGNAL rights", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-flags-parameter", "flags must be a valid combination of VkIndirectCommandsLayoutUsageFlagBitsNV values", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pStreamStrides-02937", "each element of pStreamStrides must be greater than 0 and less than or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxIndirectCommandsStreamStride. Furthermore the alignment of each token input must be ensured", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pStreamStrides-parameter", "pStreamStrides must be a valid pointer to an array of streamCount uint32_t values", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pTokens-02932", "If pTokens contains an entry of VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV it must be the first element of the array and there must be only a single element of such token type", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pTokens-02933", "If pTokens contains an entry of VK_INDIRECT_COMMANDS_TOKEN_TYPE_STATE_FLAGS_NV there must be only a single element of such token type", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pTokens-02934", "All state tokens in pTokens must occur before any action command tokens (VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_NV, VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_NV, VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_TASKS_NV, VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_NV , VK_INDIRECT_COMMANDS_TOKEN_TYPE_DISPATCH_NV )", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pTokens-02935", "The content of pTokens must include one single action command token that is compatible with the pipelineBindPoint", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pTokens-09585", "If pTokens contains an entry of VK_INDIRECT_COMMANDS_TOKEN_TYPE_PIPELINE_NV it must be the first element of the array and there must be only a single element of such token type", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pTokens-parameter", "pTokens must be a valid pointer to an array of tokenCount valid VkIndirectCommandsLayoutTokenNV structures", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pipelineBindPoint-02930", "The pipelineBindPoint must be VK_PIPELINE_BIND_POINT_GRAPHICS or VK_PIPELINE_BIND_POINT_COMPUTE", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pipelineBindPoint-09088", "If pipelineBindPoint is VK_PIPELINE_BIND_POINT_COMPUTE then the VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedCompute feature must be enabled", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pipelineBindPoint-09089", "If pipelineBindPoint is VK_PIPELINE_BIND_POINT_COMPUTE then the state tokens in pTokens must only include VK_INDIRECT_COMMANDS_TOKEN_TYPE_DISPATCH_NV, VK_INDIRECT_COMMANDS_TOKEN_TYPE_PIPELINE_NV, or VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pipelineBindPoint-09090", "If pipelineBindPoint is VK_PIPELINE_BIND_POINT_COMPUTE and pTokens includes VK_INDIRECT_COMMANDS_TOKEN_TYPE_PIPELINE_NV, then the VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputePipelines feature must be enabled", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-streamCount-02936", "streamCount must be greater than 0 and less or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxIndirectCommandsStreamCount", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-streamCount-arraylength", "streamCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-tokenCount-02931", "tokenCount must be greater than 0 and less than or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxIndirectCommandsTokenCount", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNV-tokenCount-arraylength", "tokenCount must be greater than 0", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-indirectStateFlags-parameter", "indirectStateFlags must be a valid combination of VkIndirectStateFlagBitsNV values", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-offset-02952", "offset must be less than or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxIndirectCommandsTokenOffset", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-offset-06888", "offset must be aligned to the scalar alignment of tokenType or minIndirectCommandsBufferOffsetAlignment, whichever is lower", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-pIndexTypeValues-parameter", "If indexTypeCount is not 0, pIndexTypeValues must be a valid pointer to an array of indexTypeCount uint32_t values", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-pIndexTypes-parameter", "If indexTypeCount is not 0, pIndexTypes must be a valid pointer to an array of indexTypeCount valid VkIndexType values", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-pushconstantPipelineLayout-parameter", "If pushconstantPipelineLayout is not VK_NULL_HANDLE, pushconstantPipelineLayout must be a valid VkPipelineLayout handle", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-pushconstantShaderStageFlags-parameter", "pushconstantShaderStageFlags must be a valid combination of VkShaderStageFlagBits values", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-stream-02951", "stream must be smaller than VkIndirectCommandsLayoutCreateInfoNV::streamCount", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02976", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_NV, vertexBindingUnit must stay within device supported limits for the appropriate commands", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02977", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, pushconstantPipelineLayout must be valid", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02978", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, pushconstantOffset must be a multiple of 4", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02979", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, pushconstantSize must be a multiple of 4", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02980", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, pushconstantOffset must be less than VkPhysicalDeviceLimits::maxPushConstantsSize", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02981", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, pushconstantSize must be less than or equal to VkPhysicalDeviceLimits::maxPushConstantsSize minus pushconstantOffset", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02982", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, for each byte in the range specified by pushconstantOffset and pushconstantSize and for each shader stage in pushconstantShaderStageFlags, there must be a push constant range in pushconstantPipelineLayout that includes that byte and that stage", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02983", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, for each byte in the range specified by pushconstantOffset and pushconstantSize and for each push constant range that overlaps that byte, pushconstantShaderStageFlags must include all stages in that push constant range's VkPushConstantRange::stageFlags", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-02984", "If tokenType is VK_INDIRECT_COMMANDS_TOKEN_TYPE_STATE_FLAGS_NV, indirectStateFlags must not be 0", "1.3-extensions"},
    {"VUID-VkIndirectCommandsLayoutTokenNV-tokenType-parameter", "tokenType must be a valid VkIndirectCommandsTokenTypeNV value", "1.3-extensions"},
    {"VUID-VkIndirectCommandsStreamNV-buffer-02942", "The buffer's usage flag must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set", "1.3-extensions"},
    {"VUID-VkIndirectCommandsStreamNV-buffer-02975", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "1.3-extensions"},
    {"VUID-VkIndirectCommandsStreamNV-buffer-parameter", "buffer must be a valid VkBuffer handle", "1.3-extensions"},
    {"VUID-VkIndirectCommandsStreamNV-offset-02943", "The offset must be aligned to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::minIndirectCommandsBufferOffsetAlignment", "1.3-extensions"},
    {"VUID-VkInitializePerformanceApiInfoINTEL-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkInitializePerformanceApiInfoINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL", "1.3-extensions"},
    {"VUID-VkInputAttachmentAspectReference-aspectMask-01964", "aspectMask must not include VK_IMAGE_ASPECT_METADATA_BIT", "1.3-extensions"},
    {"VUID-VkInputAttachmentAspectReference-aspectMask-02250", "aspectMask must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i", "1.3-extensions"},
    {"VUID-VkInputAttachmentAspectReference-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values", "1.3-extensions"},
    {"VUID-VkInputAttachmentAspectReference-aspectMask-requiredbitmask", "aspectMask must not be 0", "1.3-extensions"},
    {"VUID-VkInstanceCreateInfo-flags-06559", "If flags has the VK_INSTANCE_CREATE_ENUMERATE_PORTABILITY_BIT_KHR bit set, the list of enabled extensions in ppEnabledExtensionNames must contain VK_KHR_portability_enumeration", "1.3-extensions"},
    {"VUID-VkInstanceCreateInfo-flags-parameter", "flags must be a valid combination of VkInstanceCreateFlagBits values", "1.3-extensions"},
    {"VUID-VkInstanceCreateInfo-pApplicationInfo-parameter", "If pApplicationInfo is not NULL, pApplicationInfo must be a valid pointer to a valid VkApplicationInfo structure", "1.3-extensions"},
    {"VUID-VkInstanceCreateInfo-pNext-04925", "If the pNext chain of VkInstanceCreateInfo includes a VkDebugReportCallbackCreateInfoEXT structure, the list of enabled extensions in ppEnabledExtensionNames must contain VK_EXT_debug_report", "1.3-extensions"},
    {"VUID-VkInstanceCreateInfo-pNext-04926", "If the pNext chain of VkInstanceCreateInfo includes a VkDebugUtilsMessengerCreateInfoEXT structure, the list of enabled extensions in ppEnabledExtensionNames must contain VK_EXT_debug_utils", "1.3-extensions"},
    {"VUID-VkInstanceCreateInfo-pNext-06779", "If the pNext chain includes a VkExportMetalObjectCreateInfoEXT structure, its exportObjectType member must be either VK_EXPORT_METAL_OBJECT_TYPE_METAL_DEVICE_BIT_EXT or VK_EXPORT_METAL_OBJECT_TYPE_METAL_COMMAND_QUEUE_BIT_EXT", "1.3-extensions"},
    {"VUID-VkInstanceCreateInfo-pNext-09400", "If the pNext chain of VkInstanceCreateInfo includes a VkDirectDriverLoadingListLUNARG structure, the list of enabled extensions in ppEnabledExtensionNames must contain VK_LUNARG_direct_driver_loading", "1.3-extensions"},
    {"VUID-VkInstanceCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDebugReportCallbackCreateInfoEXT, VkDebugUtilsMessengerCreateInfoEXT, VkDirectDriverLoadingListLUNARG, VkExportMetalObjectCreateInfoEXT, VkLayerSettingsCreateInfoEXT, VkValidationFeaturesEXT, or VkValidationFlagsEXT", "1.3-extensions"},
    {"VUID-VkInstanceCreateInfo-ppEnabledExtensionNames-parameter", "If enabledExtensionCount is not 0, ppEnabledExtensionNames must be a valid pointer to an array of enabledExtensionCount null-terminated UTF-8 strings", "1.3-extensions"},
    {"VUID-VkInstanceCreateInfo-ppEnabledLayerNames-parameter", "If enabledLayerCount is not 0, ppEnabledLayerNames must be a valid pointer to an array of enabledLayerCount null-terminated UTF-8 strings", "1.3-extensions"},
    {"VUID-VkInstanceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO", "1.3-extensions"},
    {"VUID-VkInstanceCreateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique, with the exception of structures of type VkDebugUtilsMessengerCreateInfoEXT, VkExportMetalObjectCreateInfoEXT, or VkLayerSettingsCreateInfoEXT", "1.3-extensions"},
    {"VUID-VkLatencySleepInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_LATENCY_SLEEP_INFO_NV", "1.3-extensions"},
    {"VUID-VkLatencySleepInfoNV-signalSemaphore-09361", "signalSemaphore must be a timeline semaphore", "1.3-extensions"},
    {"VUID-VkLatencySleepInfoNV-signalSemaphore-parameter", "signalSemaphore must be a valid VkSemaphore handle", "1.3-extensions"},
    {"VUID-VkLatencySleepModeInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_LATENCY_SLEEP_MODE_INFO_NV", "1.3-extensions"},
    {"VUID-VkLatencySubmissionPresentIdNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_LATENCY_SUBMISSION_PRESENT_ID_NV", "1.3-extensions"},
    {"VUID-VkLatencySurfaceCapabilitiesNV-pPresentModes-parameter", "If presentModeCount is not 0, and pPresentModes is not NULL, pPresentModes must be a valid pointer to an array of presentModeCount VkPresentModeKHR values", "1.3-extensions"},
    {"VUID-VkLatencySurfaceCapabilitiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_LATENCY_SURFACE_CAPABILITIES_NV", "1.3-extensions"},
    {"VUID-VkLatencyTimingsFrameReportNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_LATENCY_TIMINGS_FRAME_REPORT_NV", "1.3-extensions"},
    {"VUID-VkLayerSettingEXT-pLayerName-parameter", "pLayerName must be a null-terminated UTF-8 string", "1.3-extensions"},
    {"VUID-VkLayerSettingEXT-pSettingName-parameter", "pSettingName must be a null-terminated UTF-8 string", "1.3-extensions"},
    {"VUID-VkLayerSettingEXT-pValues-parameter", "If valueCount is not 0, pValues must be a valid pointer to an array of valueCount bytes", "1.3-extensions"},
    {"VUID-VkLayerSettingEXT-type-parameter", "type must be a valid VkLayerSettingTypeEXT value", "1.3-extensions"},
    {"VUID-VkLayerSettingsCreateInfoEXT-pSettings-parameter", "If settingCount is not 0, pSettings must be a valid pointer to an array of settingCount valid VkLayerSettingEXT structures", "1.3-extensions"},
    {"VUID-VkLayerSettingsCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_LAYER_SETTINGS_CREATE_INFO_EXT", "1.3-extensions"},
    {"VUID-VkMacOSSurfaceCreateInfoMVK-flags-zerobitmask", "flags must be 0", "1.3-extensions"},
    {"VUID-VkMacOSSurfaceCreateInfoMVK-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkMacOSSurfaceCreateInfoMVK-pView-01317", "If pView is an NSView object, it must be a valid NSView, must be backed by a CALayer object of type CAMetalLayer, and vkCreateMacOSSurfaceMVK must be called on the main thread", "1.3-extensions"},
    {"VUID-VkMacOSSurfaceCreateInfoMVK-pView-04144", "If pView is a CAMetalLayer object, it must be a valid CAMetalLayer", "1.3-extensions"},
    {"VUID-VkMacOSSurfaceCreateInfoMVK-sType-sType", "sType must be VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK", "1.3-extensions"},
    {"VUID-VkMappedMemoryRange-memory-00684", "memory must be currently host mapped", "1.3-extensions"},
    {"VUID-VkMappedMemoryRange-memory-parameter", "memory must be a valid VkDeviceMemory handle", "1.3-extensions"},
    {"VUID-VkMappedMemoryRange-offset-00687", "offset must be a multiple of VkPhysicalDeviceLimits::nonCoherentAtomSize", "1.3-extensions"},
    {"VUID-VkMappedMemoryRange-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkMappedMemoryRange-sType-sType", "sType must be VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE", "1.3-extensions"},
    {"VUID-VkMappedMemoryRange-size-00685", "If size is not equal to VK_WHOLE_SIZE, offset and size must specify a range contained within the currently mapped range of memory", "1.3-extensions"},
    {"VUID-VkMappedMemoryRange-size-00686", "If size is equal to VK_WHOLE_SIZE, offset must be within the currently mapped range of memory", "1.3-extensions"},
    {"VUID-VkMappedMemoryRange-size-01389", "If size is equal to VK_WHOLE_SIZE, the end of the current mapping of memory must either be a multiple of VkPhysicalDeviceLimits::nonCoherentAtomSize bytes from the beginning of the memory object, or be equal to the end of the memory object", "1.3-extensions"},
    {"VUID-VkMappedMemoryRange-size-01390", "If size is not equal to VK_WHOLE_SIZE, size must either be a multiple of VkPhysicalDeviceLimits::nonCoherentAtomSize, or offset plus size must equal the size of memory", "1.3-extensions"},
    {"VUID-VkMemoryAllocateFlagsInfo-deviceMask-00675", "If VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT is set, deviceMask must be a valid device mask", "1.3-extensions"},
    {"VUID-VkMemoryAllocateFlagsInfo-deviceMask-00676", "If VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT is set, deviceMask must not be zero", "1.3-extensions"},
    {"VUID-VkMemoryAllocateFlagsInfo-flags-parameter", "flags must be a valid combination of VkMemoryAllocateFlagBits values", "1.3-extensions"},
    {"VUID-VkMemoryAllocateFlagsInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-None-00643", "If the parameters define an import operation and the external handle specified was created by the Vulkan API, the device mask specified by VkMemoryAllocateFlagsInfo must match the mask specified when the payload being imported was allocated", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-None-00644", "If the parameters define an import operation and the external handle specified was created by the Vulkan API, the list of physical devices that comprise the logical device passed to vkAllocateMemory must match the list of physical devices that comprise the logical device on which the payload was originally allocated", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-None-04749", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA, the value of memoryTypeIndex must be an index identifying a memory type from the memoryTypeBits field of the VkMemoryZirconHandlePropertiesFUCHSIA structure populated by a call to vkGetMemoryZirconHandlePropertiesFUCHSIA", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-None-06657", "The parameters must not define more than one import operation", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-00647", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, allocationSize must match the size specified when creating the Direct3D 12 heap from which the payload was extracted", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-01742", "If the parameters define an import operation, the external handle specified was created by the Vulkan API, and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT, then the values of allocationSize and memoryTypeIndex must match those specified when the payload being imported was created", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-01743", "If the parameters define an import operation, the external handle was created by the Vulkan API, and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, then the values of allocationSize and memoryTypeIndex must match those specified when the payload being imported was created", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-01745", "If the parameters define an import operation and the external handle is a host pointer, allocationSize must be an integer multiple of VkPhysicalDeviceExternalMemoryHostPropertiesEXT::minImportedHostPointerAlignment", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-02383", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, allocationSize must be the size returned by vkGetAndroidHardwareBufferPropertiesANDROID for the Android hardware buffer", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-06382", "If the parameters define an import operation from an VkBufferCollectionFUCHSIA, allocationSize must match VkMemoryRequirements::size value retrieved by vkGetImageMemoryRequirements or vkGetBufferMemoryRequirements for image-based or buffer-based collections respectively", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-07897", "If the parameters do not define an import or export operation, allocationSize must be greater than 0", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-07899", "If the parameters define an export operation and the handle type is not VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID , allocationSize must be greater than 0", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-07902", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA, the value of allocationSize must be greater than 0", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-07903", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA, the value of allocationSize must be less than or equal to the size of the VMO as determined by zx_vmo_get_size(handle) where handle is the VMO handle to the imported external memory", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-08942", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_SCREEN_BUFFER_BIT_QNX, allocationSize must be the size returned by vkGetScreenBufferPropertiesQNX for the QNX Screen buffer", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-buffer-06380", "If the parameters define an import operation from an VkBufferCollectionFUCHSIA, and VkMemoryDedicatedAllocateInfo::buffer is present and non-NULL, VkImportMemoryBufferCollectionFUCHSIA::collection and VkImportMemoryBufferCollectionFUCHSIA::index must match VkBufferCollectionBufferCreateInfoFUCHSIA::collection and VkBufferCollectionBufferCreateInfoFUCHSIA::index, respectively, of the VkBufferCollectionBufferCreateInfoFUCHSIA structure used to create the VkMemoryDedicatedAllocateInfo::buffer", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-buffer-06385", "If the parameters define an import operation from an VkBufferCollectionFUCHSIA and VkMemoryDedicatedAllocateInfo::buffer is not VK_NULL_HANDLE, the buffer must be created with a VkBufferCollectionBufferCreateInfoFUCHSIA structure chained to its VkBufferCreateInfo::pNext pointer", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-flags-03330", "If VkMemoryAllocateFlagsInfo::flags includes VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT, the bufferDeviceAddressCaptureReplay feature must be enabled", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-flags-03331", "If VkMemoryAllocateFlagsInfo::flags includes VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT, the bufferDeviceAddress feature must be enabled", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-image-06381", "If the parameters define an import operation from an VkBufferCollectionFUCHSIA, and VkMemoryDedicatedAllocateInfo::image is present and non-NULL, VkImportMemoryBufferCollectionFUCHSIA::collection and VkImportMemoryBufferCollectionFUCHSIA::index must match VkBufferCollectionImageCreateInfoFUCHSIA::collection and VkBufferCollectionImageCreateInfoFUCHSIA::index, respectively, of the VkBufferCollectionImageCreateInfoFUCHSIA structure used to create the VkMemoryDedicatedAllocateInfo::image", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-image-06384", "If the parameters define an import operation from an VkBufferCollectionFUCHSIA and VkMemoryDedicatedAllocateInfo::image is not VK_NULL_HANDLE, the image must be created with a VkBufferCollectionImageCreateInfoFUCHSIA structure chained to its VkImageCreateInfo::pNext pointer", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-00645", "If the parameters define an import operation and the external handle is an NT handle or a global share handle created outside of the Vulkan API, the value of memoryTypeIndex must be one of those returned by vkGetMemoryWin32HandlePropertiesKHR", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-00648", "If the parameters define an import operation and the external handle is a POSIX file descriptor created outside of the Vulkan API, the value of memoryTypeIndex must be one of those returned by vkGetMemoryFdPropertiesKHR", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-01744", "If the parameters define an import operation and the external handle is a host pointer, the value of memoryTypeIndex must be one of those returned by vkGetMemoryHostPointerPropertiesEXT", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-01872", "If the protectedMemory feature is not enabled, the VkMemoryAllocateInfo::memoryTypeIndex must not indicate a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-02385", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, memoryTypeIndex must be one of those returned by vkGetAndroidHardwareBufferPropertiesANDROID for the Android hardware buffer", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-06386", "If the parameters define an import operation from an VkBufferCollectionFUCHSIA, memoryTypeIndex must be from VkBufferCollectionPropertiesFUCHSIA as retrieved by vkGetBufferCollectionPropertiesFUCHSIA", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-08943", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_SCREEN_BUFFER_BIT_QNX, memoryTypeIndex must be one of those returned by vkGetScreenBufferPropertiesQNX for the QNX Screen buffer", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-opaqueCaptureAddress-03329", "If VkMemoryOpaqueCaptureAddressAllocateInfo::opaqueCaptureAddress is not zero, VkMemoryAllocateFlagsInfo::flags must include VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-opaqueCaptureAddress-03333", "If the parameters define an import operation, VkMemoryOpaqueCaptureAddressAllocateInfo::opaqueCaptureAddress must be zero", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-00639", "If the pNext chain includes a VkExportMemoryAllocateInfo structure, and any of the handle types specified in VkExportMemoryAllocateInfo::handleTypes require a dedicated allocation, as reported by vkGetPhysicalDeviceImageFormatProperties2 in VkExternalImageFormatProperties::externalMemoryProperties.externalMemoryFeatures, or by vkGetPhysicalDeviceExternalBufferProperties in VkExternalBufferProperties::externalMemoryProperties.externalMemoryFeatures, the pNext chain must include a VkMemoryDedicatedAllocateInfo or VkDedicatedAllocationMemoryAllocateInfoNV structure with either its image or buffer member set to a value other than VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-00640", "If the pNext chain includes a VkExportMemoryAllocateInfo structure, it must not include a VkExportMemoryAllocateInfoNV or VkExportMemoryWin32HandleInfoNV structure", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-00641", "If the pNext chain includes a VkImportMemoryWin32HandleInfoKHR structure, it must not include a VkImportMemoryWin32HandleInfoNV structure", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-01874", "If the parameters do not define an import operation, and the pNext chain includes a VkExportMemoryAllocateInfo structure with VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID included in its handleTypes member, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image not equal to VK_NULL_HANDLE, then allocationSize must be 0", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02384", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, and the pNext chain does not include a VkMemoryDedicatedAllocateInfo structure or VkMemoryDedicatedAllocateInfo::image is VK_NULL_HANDLE, the Android hardware buffer must have a AHardwareBuffer_Desc::format of AHARDWAREBUFFER_FORMAT_BLOB and a AHardwareBuffer_Desc::usage that includes AHARDWAREBUFFER_USAGE_GPU_DATA_BUFFER", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02386", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo with image that is not VK_NULL_HANDLE, the Android hardware buffer's AHardwareBuffer::usage must include at least one of AHARDWAREBUFFER_USAGE_GPU_FRAMEBUFFER, AHARDWAREBUFFER_USAGE_GPU_SAMPLED_IMAGE or AHARDWAREBUFFER_USAGE_GPU_DATA_BUFFER", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02387", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo with image that is not VK_NULL_HANDLE, the format of image must be VK_FORMAT_UNDEFINED or the format returned by vkGetAndroidHardwareBufferPropertiesANDROID in VkAndroidHardwareBufferFormatPropertiesANDROID::format for the Android hardware buffer", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02388", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image that is not VK_NULL_HANDLE, the width, height, and array layer dimensions of image and the Android hardware buffer's AHardwareBuffer_Desc must be identical", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02389", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image that is not VK_NULL_HANDLE, and the Android hardware buffer's AHardwareBuffer::usage includes AHARDWAREBUFFER_USAGE_GPU_MIPMAP_COMPLETE, the image must have a complete mipmap chain", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02390", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image that is not VK_NULL_HANDLE, each bit set in the usage of image must be listed in AHardwareBuffer Usage Equivalence, and if there is a corresponding AHARDWAREBUFFER_USAGE bit listed that bit must be included in the Android hardware buffer's AHardwareBuffer_Desc::usage", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02586", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image that is not VK_NULL_HANDLE, and the Android hardware buffer's AHardwareBuffer::usage does not include AHARDWAREBUFFER_USAGE_GPU_MIPMAP_COMPLETE, the image must have exactly one mipmap level", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02805", "If the parameters define an import operation and the external handle is a host pointer, the pNext chain must not include a VkDedicatedAllocationMemoryAllocateInfoNV structure with either its image or buffer field set to a value other than VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-02806", "If the parameters define an import operation and the external handle is a host pointer, the pNext chain must not include a VkMemoryDedicatedAllocateInfo structure with either its image or buffer field set to a value other than VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-03332", "If the pNext chain includes a VkImportMemoryHostPointerInfoEXT structure, VkMemoryOpaqueCaptureAddressAllocateInfo::opaqueCaptureAddress must be zero", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-06383", "If the parameters define an import operation from an VkBufferCollectionFUCHSIA, the pNext chain must include a VkMemoryDedicatedAllocateInfo structure with either its image or buffer field set to a value other than VK_NULL_HANDLE", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-06780", "If the pNext chain includes a VkExportMetalObjectCreateInfoEXT structure, its exportObjectType member must be VK_EXPORT_METAL_OBJECT_TYPE_METAL_BUFFER_BIT_EXT", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-07900", "If the parameters define an export operation, the handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, and the pNext does not include a VkMemoryDedicatedAllocateInfo structure, allocationSize must be greater than 0", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-07901", "If the parameters define an export operation, the handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with buffer set to a valid VkBuffer object, allocationSize must be greater than 0", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-08944", "If the parameters define an import operation, the external handle is a QNX Screen buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo with image that is not VK_NULL_HANDLE, the QNX Screen's buffer must be a valid QNX Screen buffer", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-08945", "If the parameters define an import operation, the external handle is an QNX Screen buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo with image that is not VK_NULL_HANDLE, the format of image must be VK_FORMAT_UNDEFINED or the format returned by vkGetScreenBufferPropertiesQNX in VkScreenBufferFormatPropertiesQNX::format for the QNX Screen buffer", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-08946", "If the parameters define an import operation, the external handle is a QNX Screen buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image that is not VK_NULL_HANDLE, the width, height, and array layer dimensions of image and the QNX Screen buffer's _screen_buffer must be identical", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDedicatedAllocationMemoryAllocateInfoNV, VkExportMemoryAllocateInfo, VkExportMemoryAllocateInfoNV, VkExportMemoryWin32HandleInfoKHR, VkExportMemoryWin32HandleInfoNV, VkExportMetalObjectCreateInfoEXT, VkImportAndroidHardwareBufferInfoANDROID, VkImportMemoryBufferCollectionFUCHSIA, VkImportMemoryFdInfoKHR, VkImportMemoryHostPointerInfoEXT, VkImportMemoryWin32HandleInfoKHR, VkImportMemoryWin32HandleInfoNV, VkImportMemoryZirconHandleInfoFUCHSIA, VkImportMetalBufferInfoEXT, VkImportScreenBufferInfoQNX, VkMemoryAllocateFlagsInfo, VkMemoryDedicatedAllocateInfo, VkMemoryOpaqueCaptureAddressAllocateInfo, or VkMemoryPriorityAllocateInfoEXT", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-sType-unique", "The sType value of each struct in the pNext chain must be unique, with the exception of structures of type VkExportMetalObjectCreateInfoEXT", "1.3-extensions"},
    {"VUID-VkMemoryAllocateInfo-screenBufferImport-08941", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_SCREEN_BUFFER_BIT_QNX, VkPhysicalDeviceExternalMemoryScreenBufferFeaturesQNX::screenBufferImport must be enabled", "1.3-extensions"},
    {"VUID-VkMemoryBarrier-dstAccessMask-parameter", "dstAccessMask must be a valid combination of VkAccessFlagBits values", "1.3-extensions"},
    {"VUID-VkMemoryBarrier-pNext-pNext", "pNext must be NULL", "1.3-extensions"},
    {"VUID-VkMemoryBarrier-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_BARRIER", "1.3-extensions"},
    {"VUID-VkMemoryBarrier-srcAccessMask-parameter", "srcAccessMask must be a valid combination of VkAccessFlagBits values", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03900", "If dstAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03901", "If dstAccessMask includes VK_ACCESS_2_INDEX_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03902", "If dstAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03903", "If dstAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03904", "If dstAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03905", "If dstAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03906", "If dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03907", "If dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03909", "If dstAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03910", "If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03911", "If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03912", "If dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03913", "If dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03914", "If dstAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03915", "If dstAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_CLEAR_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, or VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03916", "If dstAccessMask includes VK_ACCESS_2_HOST_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03917", "If dstAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03918", "If dstAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03919", "If dstAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03920", "If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03922", "If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03923", "If dstAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03924", "If dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03925", "If dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03926", "If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03927", "If dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-03928", "If dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-04747", "If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-04858", "If dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-04859", "If dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-04860", "If dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-04861", "If dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-04994", "If dstAccessMask includes VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI, dstStageMask must include VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", "1.3-extensions"},
    {"VUID-VkMemoryBarrier2-dstAccessMask-06256", "If the rayQuery feature is not enabled and dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, dstStageMask must not include any of the VK_PIPELINE_STAGE_*_SHADER_BIT stages except VK_PIP