/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.3
 * July 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif
#include <vdkb2/vdkb_pholder.h>
#include <vdkb2/vdkb_evbox.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_objinspect.h>
#include <vdkb2/vdkb_prjman.h>
#include <stdlib.h>
#include <vdkb2/vdkb_fixed.h>
/*
================================
symbolic constants to templatize
a bit 
================================
*/
// for methods and other stuff
#define CLASS VDKBPlaceHolder
// put here how the widget will be named
#define VDK_WIDGET "placeholder"
extern char* wi_widget_prompts[];
static char buff[128];

// used to autogenerate default
// names

int CLASS::Counter = 0;
/* 
 properties 
 */
char* vdkpholder_props[] = {   PHOLDER_CTOR, 0 };
//////////////////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDKCanvas);
DEFINE_EVENT_LIST(CLASS,VDKCanvas);
///////////////////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, VDKForm* owner):
  VDKCanvas(owner),VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  // each time 
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add  frame properties
  // names. (Others props are prepended  by VDKBObject constructor)
  for(t=0; vdkpholder_props[t]; t++)
    proplist.add(VDKBProperty(vdkpholder_props[t]));
  // connects events.
  CONNECT_COMMON_EVENTS;
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
}
////////////////////////////////////////////////////////////////
//
//               WRITER TO .FRM FILE
//
///////////////////////////////////////////////////////////////
/*
Writes a .frm format representation of label button widget
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s%s;", 
	  PROP_PHOLDER_CTOR,(char*) GetProp(PHOLDER_CTOR));
}
//////////////////////////////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
//////////////////////////////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable label button counter
  // to ensure unicity
  CLASS* pholder;
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2; 
  else
  pholder = new CLASS(buff,owner);
  VDKRgb white("white");
  if(white.IsValid())
    pholder->NormalBackground = white;
  // add widget to form
  return owner->AddToSelf(pholder,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char ctor[256];
  char arg[64];
  char tmp[256];
  // gets widget name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return NULL;
  // get constructor definition
  else if ( !parser.GetParam(ctor,buffer,PROP_PHOLDER_CTOR) )
    return NULL;
  source = new char[4096];
  sprintf(tmp,"\n%s = new %s;",obj_name,ctor);
  strcpy(source,tmp);
  ///////////////////////////////////////
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
  // get code that adds widget to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner, 
		    char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  CLASS* pholder;
  // get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
    return false;

  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ? 
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      pholder = new CLASS(obj_name,owner);
      if(
	 parser.GetParam(arg,buffer,PROP_PHOLDER_CTOR) &&
	 strcmp(arg,NIHIL_PROP)
	 )
	  pholder->SetPropValue(PHOLDER_CTOR,arg);
      // pack widget to container
      return owner->PackToSelf(pholder, container, buffer, parser);
    }
  else
    return false;
}
/*
 */
VDKObjectContainer* 
CLASS::ExtraWidget(VDKBObjectInspector* isp) 
{ 
  inspector = isp;
  VDKCustomButton* button;
  VDKFrame* bframe = new VDKFrame(inspector,NULL, v_box,shadow_etched_in);
  VDKBox *box = new VDKBox(inspector);
  box->SetSize(219,-1);

  button = new VDKCustomButton(inspector,
			      _(wi_widget_prompts[51]));
  box->Add(button,l_justify,false,false,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&CLASS::OnSetCtor);

  ctor = new VDKEntry(inspector,0,(char*) GetProp(PHOLDER_CTOR));
  ctor->Parent(this);
  SignalConnect(ctor,"activated",&CLASS::OnSetCtor);
  box->Add(ctor);

  bframe->Add(box);
  return bframe; 
}
/*
 */
bool
CLASS::OnSetCtor(VDKObject*)
{
  if(strlen(ctor->Text) > 0)
    SetPropValue(PHOLDER_CTOR,(char*) ctor->Text);
  inspector->FormNeedToBeChanged();
  return true;
}
