/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_textwidget_h
#define _vdkb_textwidget_h
#include <vdk/vdk.h>
#include <vdkb2/vdkb_object.h>
#include <vdkb2/vdkb_widpopmenu.h>


class VDKBGuiForm;
class VDKBParser;
class VDKBTextWidget: public VDKTextView, public VDKBObject
{

 protected:
  VDKBWidgetPopMenu *popmenu;
  VDKMenuItem *setsize,*delwidget;
  VDKBObjectInspector* inspector;
  VDKCheckButton* wrap,*editable;
 public:
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBTextWidget(char* name,VDKForm* owner);
  virtual ~VDKBTextWidget() {}
  virtual int Type() { return vdkbclass_textwidget; }
  virtual char* VDKName() { return "VDKTextView"; }
  virtual int isA() { return vdkbclass_textwidget; }
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  void PopMenu() { popmenu->Popup(); }
  // designer
  // bool OnSetWordWrap(VDKObject*);
  bool OnSetEditable(VDKObject*);
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  DECLARE_SIGNAL_LIST(VDKBTextWidget);
  DECLARE_EVENT_LIST(VDKBTextWidget);
};
#endif
