/*
 *   This file is part of VBA Express.
 *
 *   Copyright (c) 2005-2006 Achraf cherti <achrafcherti@gmail.com>
 * 
 *   VBA Express is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   VBA Express is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with VBA Express; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/************************
 * voir vbaconfig.cpp
 ************************/

#ifndef __vba_config_h
#define __vba_config_h

#include "lcfg.h"
#include "interface.h"
#include "astring.h"

class VbaConfig {
	private:
		LCFG lcfg;
		int lcfg_loaded;
	public:
		int frameSkip;     // 0..5
		int gbFrameSkip;   // 0..5
		int video;
		char fullScreen;
		char disableMMX;
		char useBios;
		AString biosFile;   // FichierBios
		int filter;        // 0..12
		char disableStatus;
		char borderOn;
		int emulatorType;  // 0..5
		char colorOption;
		AString saveDir;
		AString captureDir;
		AString batteryDir;
		char captureFormat; // 0..1
		int soundQuality;  // 1 or 2 or 4
		char soundEcho;
		char soundLowPass;
		char soundReverse;
		char removeIntros;
		int saveType;      // 0..5
		int flashSize;     // 0 1
		int soundVolume;   // 0..3
		int ifbType;       // 0..2
		int showSpeed;     // 0..2
		char showSpeedTransparent;
		char autoFrameSkip;
		int throttle; // 0 ou 5...1000
		char pauseWhenInactive;
		char agbPrint;
		char rtcEnabled;
		char soundOff;
		int soundEnable;
		char borderAutomatic;
		char skipBios;
		int rewindTimer;
		char enhancedDetection;
		
		int Joy0_Left;
		int Joy0_Right;
		int Joy0_Up;
		int Joy0_Down;
		int Joy0_A;
		int Joy0_B;
		int Joy0_L;
		int Joy0_R;
		int Joy0_Start;
		int Joy0_Select;
		int Joy0_Speed;
		int Joy0_Capture;

		int Motion_Left;
		int Motion_Right;
		int Motion_Up;
		int Motion_Down;

		//fonction pour verifier puis fixer les
		//mauvaises valeurs contenues dans les variables
		void _fix_and_verify();

		//constructeur
		VbaConfig();
		~VbaConfig();

		//Mets les paramtres par dfaut dans les variables (comme c'est
		//dfini dans VisualBoyAdvance.cfg version 1.7.2 (dernire version
		//actuellement).
		void SetDefault();

		//chargement d'un fichier CONFIG
		bool LoadConfig(const char *filename);
		bool SaveConfig(const char *filename);

		//cration d'un nouveau fichier VisualBoyAdvance.cfg
		//en se basant sur toutes les variables membres :-)
		bool CreateConfig(const char *filename);

		// Pour communiquer avec l'interface graphique
		void Get(Interface *);
		void Put(Interface *);
};

#endif

