/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp546_ = FALSE;
	gboolean _tmp547_ = FALSE;
	gboolean _tmp548_ = FALSE;
	ValaExpression* _tmp549_;
	ValaExpression* _tmp550_;
	ValaSymbol* _tmp576_;
	ValaSymbol* _tmp577_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp629_;
	ValaSymbol* _tmp630_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp631_;
	ValaSymbol* _tmp632_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1019_;
	ValaSymbol* _tmp1020_;
	ValaSymbol* _tmp1022_;
	ValaVersionAttribute* _tmp1023_;
	ValaVersionAttribute* _tmp1024_;
	ValaSourceReference* _tmp1025_;
	ValaSourceReference* _tmp1026_;
	gboolean _tmp1027_ = FALSE;
	ValaSymbolAccessibility _tmp1028_;
	gboolean _tmp1084_ = FALSE;
	gboolean _tmp1111_ = FALSE;
	gboolean _tmp1112_ = FALSE;
	ValaDataType* _tmp1364_;
	ValaDataType* _tmp1365_;
	gboolean _tmp1368_;
	gboolean _tmp1369_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaScope* _tmp20_;
		ValaScope* _tmp21_;
		const gchar* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		base_symbol = (ValaSymbol*) _tmp18_;
		_tmp19_ = base_symbol;
		_tmp20_ = vala_symbol_get_scope (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_member_name;
		_tmp23_ = vala_scope_lookup (_tmp21_, _tmp22_);
		_tmp24_ = _tmp23_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp24_);
		_vala_code_node_unref0 (_tmp24_);
	} else {
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		_tmp25_ = vala_member_access_get_inner (self);
		_tmp26_ = _tmp25_;
		if (_tmp26_ == NULL) {
			const gchar* _tmp27_;
			ValaSemanticAnalyzer* _tmp32_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			gboolean _tmp138_ = FALSE;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			_tmp27_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp27_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp28_;
				ValaSemanticAnalyzer* _tmp29_;
				_tmp28_ = vala_code_context_get_analyzer (context);
				_tmp29_ = _tmp28_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp29_)) {
					ValaSourceReference* _tmp30_;
					ValaSourceReference* _tmp31_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp31_ = _tmp30_;
					vala_report_error (_tmp31_, "This access invalid outside of instance methods");
					result = FALSE;
					return result;
				}
			}
			_tmp32_ = vala_code_context_get_analyzer (context);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_semantic_analyzer_get_current_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			base_symbol = _tmp35_;
			method_found = FALSE;
			_tmp36_ = vala_code_context_get_analyzer (context);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_semantic_analyzer_get_current_symbol (_tmp37_);
			_tmp39_ = _tmp38_;
			sym = _tmp39_;
			while (TRUE) {
				gboolean _tmp40_ = FALSE;
				ValaSymbol* _tmp41_;
				ValaSymbol* _tmp87_;
				const gchar* _tmp88_;
				ValaSymbol* _tmp89_;
				ValaSymbol* _tmp90_;
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				ValaSymbol* _tmp93_;
				ValaSymbol* _tmp94_;
				ValaSymbol* _tmp132_;
				ValaSymbol* _tmp133_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp136_;
				ValaSymbol* _tmp137_;
				_tmp41_ = sym;
				if (_tmp41_ != NULL) {
					ValaSymbol* _tmp42_;
					ValaSymbol* _tmp43_;
					_tmp42_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp43_ = _tmp42_;
					_tmp40_ = _tmp43_ == NULL;
				} else {
					_tmp40_ = FALSE;
				}
				if (!_tmp40_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp44_;
					_tmp44_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp44_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp45_;
						ValaCreationMethod* _tmp46_;
						ValaParameter* _tmp47_;
						ValaParameter* _tmp48_;
						_tmp45_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp46_ = cm;
						_tmp47_ = vala_method_get_this_parameter ((ValaMethod*) _tmp46_);
						_tmp48_ = _tmp47_;
						this_parameter = _tmp48_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp49_;
						_tmp49_ = sym;
						if (VALA_IS_PROPERTY (_tmp49_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp50_;
							ValaProperty* _tmp51_;
							ValaParameter* _tmp52_;
							ValaParameter* _tmp53_;
							ValaProperty* _tmp54_;
							ValaMemberBinding _tmp55_;
							ValaMemberBinding _tmp56_;
							ValaProperty* _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaMemberBinding _tmp59_;
							_tmp50_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp51_ = prop;
							_tmp52_ = vala_property_get_this_parameter (_tmp51_);
							_tmp53_ = _tmp52_;
							this_parameter = _tmp53_;
							_tmp54_ = prop;
							_tmp55_ = vala_property_get_binding (_tmp54_);
							_tmp56_ = _tmp55_;
							may_access_instance_members = _tmp56_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_binding (_tmp57_);
							_tmp59_ = _tmp58_;
							may_access_klass_members = _tmp59_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp60_;
							_tmp60_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp60_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp61_;
								ValaConstructor* _tmp62_;
								ValaParameter* _tmp63_;
								ValaParameter* _tmp64_;
								ValaConstructor* _tmp65_;
								ValaMemberBinding _tmp66_;
								ValaMemberBinding _tmp67_;
								_tmp61_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp62_ = c;
								_tmp63_ = vala_constructor_get_this_parameter (_tmp62_);
								_tmp64_ = _tmp63_;
								this_parameter = _tmp64_;
								_tmp65_ = c;
								_tmp66_ = vala_constructor_get_binding (_tmp65_);
								_tmp67_ = _tmp66_;
								may_access_instance_members = _tmp67_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp68_;
								_tmp68_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp68_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp69_;
									ValaDestructor* _tmp70_;
									ValaParameter* _tmp71_;
									ValaParameter* _tmp72_;
									ValaDestructor* _tmp73_;
									ValaMemberBinding _tmp74_;
									ValaMemberBinding _tmp75_;
									_tmp69_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp70_ = d;
									_tmp71_ = vala_destructor_get_this_parameter (_tmp70_);
									_tmp72_ = _tmp71_;
									this_parameter = _tmp72_;
									_tmp73_ = d;
									_tmp74_ = vala_destructor_get_binding (_tmp73_);
									_tmp75_ = _tmp74_;
									may_access_instance_members = _tmp75_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp76_;
									_tmp76_ = sym;
									if (VALA_IS_METHOD (_tmp76_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp77_;
										ValaMethod* _tmp78_;
										ValaParameter* _tmp79_;
										ValaParameter* _tmp80_;
										ValaMethod* _tmp81_;
										ValaMemberBinding _tmp82_;
										ValaMemberBinding _tmp83_;
										ValaMethod* _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMemberBinding _tmp86_;
										_tmp77_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_METHOD, ValaMethod);
										_tmp78_ = m;
										_tmp79_ = vala_method_get_this_parameter (_tmp78_);
										_tmp80_ = _tmp79_;
										this_parameter = _tmp80_;
										_tmp81_ = m;
										_tmp82_ = vala_method_get_binding (_tmp81_);
										_tmp83_ = _tmp82_;
										may_access_instance_members = _tmp83_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp84_ = m;
										_tmp85_ = vala_method_get_binding (_tmp84_);
										_tmp86_ = _tmp85_;
										may_access_klass_members = _tmp86_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp87_ = sym;
				_tmp88_ = self->priv->_member_name;
				_tmp89_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp87_, _tmp88_);
				_tmp90_ = _tmp89_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp90_);
				_vala_code_node_unref0 (_tmp90_);
				_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp94_ = _tmp93_;
				if (_tmp94_ == NULL) {
					ValaSymbol* _tmp95_;
					_tmp95_ = sym;
					_tmp92_ = VALA_IS_TYPESYMBOL (_tmp95_);
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					_tmp91_ = may_access_instance_members;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaParameter* _tmp96_;
					ValaDataType* _tmp97_;
					ValaDataType* _tmp98_;
					const gchar* _tmp99_;
					ValaSymbol* _tmp100_;
					ValaSymbol* _tmp101_;
					gboolean _tmp102_ = FALSE;
					ValaSymbol* _tmp103_;
					ValaSymbol* _tmp104_;
					_tmp96_ = this_parameter;
					_tmp97_ = vala_variable_get_variable_type ((ValaVariable*) _tmp96_);
					_tmp98_ = _tmp97_;
					_tmp99_ = self->priv->_member_name;
					_tmp100_ = vala_data_type_get_member (_tmp98_, _tmp99_);
					_tmp101_ = _tmp100_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp101_);
					_vala_code_node_unref0 (_tmp101_);
					_tmp103_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp104_ = _tmp103_;
					if (_tmp104_ != NULL) {
						ValaSymbol* _tmp105_;
						ValaSymbol* _tmp106_;
						_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp106_ = _tmp105_;
						_tmp102_ = vala_member_access_is_instance_symbol (_tmp106_);
					} else {
						_tmp102_ = FALSE;
					}
					if (_tmp102_) {
						ValaSourceReference* _tmp107_;
						ValaSourceReference* _tmp108_;
						ValaMemberAccess* _tmp109_;
						ValaMemberAccess* _tmp110_;
						ValaExpression* _tmp111_;
						ValaExpression* _tmp112_;
						ValaParameter* _tmp113_;
						ValaDataType* _tmp114_;
						ValaDataType* _tmp115_;
						ValaDataType* _tmp116_;
						ValaDataType* _tmp117_;
						ValaExpression* _tmp118_;
						ValaExpression* _tmp119_;
						ValaDataType* _tmp120_;
						ValaDataType* _tmp121_;
						ValaExpression* _tmp122_;
						ValaExpression* _tmp123_;
						ValaParameter* _tmp124_;
						ValaExpression* _tmp125_;
						ValaExpression* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						const gchar* _tmp129_;
						ValaSymbol* _tmp130_;
						ValaSymbol* _tmp131_;
						_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp108_ = _tmp107_;
						_tmp109_ = vala_member_access_new (NULL, "this", _tmp108_);
						_tmp110_ = _tmp109_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp110_);
						_vala_code_node_unref0 (_tmp110_);
						_tmp111_ = vala_member_access_get_inner (self);
						_tmp112_ = _tmp111_;
						_tmp113_ = this_parameter;
						_tmp114_ = vala_variable_get_variable_type ((ValaVariable*) _tmp113_);
						_tmp115_ = _tmp114_;
						_tmp116_ = vala_data_type_copy (_tmp115_);
						_tmp117_ = _tmp116_;
						vala_expression_set_value_type (_tmp112_, _tmp117_);
						_vala_code_node_unref0 (_tmp117_);
						_tmp118_ = vala_member_access_get_inner (self);
						_tmp119_ = _tmp118_;
						_tmp120_ = vala_expression_get_value_type (_tmp119_);
						_tmp121_ = _tmp120_;
						vala_data_type_set_value_owned (_tmp121_, FALSE);
						_tmp122_ = vala_member_access_get_inner (self);
						_tmp123_ = _tmp122_;
						_tmp124_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp123_, (ValaSymbol*) _tmp124_);
						_tmp125_ = vala_member_access_get_inner (self);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_expression_get_value_type (_tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = self->priv->_member_name;
						_tmp130_ = vala_data_type_get_member (_tmp128_, _tmp129_);
						_tmp131_ = _tmp130_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp131_);
						_vala_code_node_unref0 (_tmp131_);
					}
				}
				_tmp132_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp133_ = _tmp132_;
				if (_tmp133_ == NULL) {
					ValaSymbol* _tmp134_;
					_tmp134_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp134_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp135_ = sym;
				_tmp136_ = vala_symbol_get_parent_symbol (_tmp135_);
				_tmp137_ = _tmp136_;
				sym = _tmp137_;
			}
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp140_ = _tmp139_;
			if (_tmp140_ == NULL) {
				ValaSourceReference* _tmp141_;
				ValaSourceReference* _tmp142_;
				_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp142_ = _tmp141_;
				_tmp138_ = _tmp142_ != NULL;
			} else {
				_tmp138_ = FALSE;
			}
			if (_tmp138_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp143_;
					ValaSourceReference* _tmp144_;
					ValaList* _tmp145_;
					ValaList* _tmp146_;
					ValaList* _tmp147_;
					gint _ns_size = 0;
					ValaList* _tmp148_;
					gint _tmp149_;
					gint _tmp150_;
					gint _ns_index = 0;
					_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp144_ = _tmp143_;
					_tmp145_ = vala_source_reference_get_using_directives (_tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = _vala_iterable_ref0 (_tmp146_);
					_ns_list = _tmp147_;
					_tmp148_ = _ns_list;
					_tmp149_ = vala_collection_get_size ((ValaCollection*) _tmp148_);
					_tmp150_ = _tmp149_;
					_ns_size = _tmp150_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp151_;
						gpointer _tmp152_;
						ValaUsingDirective* _tmp153_;
						gboolean _tmp154_;
						gboolean _tmp155_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp156_;
						ValaSymbol* _tmp157_;
						ValaSymbol* _tmp158_;
						ValaScope* _tmp159_;
						ValaScope* _tmp160_;
						const gchar* _tmp161_;
						ValaSymbol* _tmp162_;
						ValaSymbol* _tmp163_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp151_ = _ns_list;
						_tmp152_ = vala_list_get (_tmp151_, _ns_index);
						ns = (ValaUsingDirective*) _tmp152_;
						_tmp153_ = ns;
						_tmp154_ = vala_code_node_get_error ((ValaCodeNode*) _tmp153_);
						_tmp155_ = _tmp154_;
						if (_tmp155_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp156_ = ns;
						_tmp157_ = vala_using_directive_get_namespace_symbol (_tmp156_);
						_tmp158_ = _tmp157_;
						_tmp159_ = vala_symbol_get_scope (_tmp158_);
						_tmp160_ = _tmp159_;
						_tmp161_ = self->priv->_member_name;
						_tmp162_ = vala_scope_lookup (_tmp160_, _tmp161_);
						local_sym = _tmp162_;
						_tmp163_ = local_sym;
						if (_tmp163_ != NULL) {
							gboolean _tmp164_ = FALSE;
							ValaSymbol* _tmp165_;
							ValaSymbol* _tmp166_;
							ValaSymbol* _tmp182_;
							_tmp165_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp166_ = _tmp165_;
							if (_tmp166_ != NULL) {
								ValaSymbol* _tmp167_;
								ValaSymbol* _tmp168_;
								ValaSymbol* _tmp169_;
								_tmp167_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp168_ = _tmp167_;
								_tmp169_ = local_sym;
								_tmp164_ = _tmp168_ != _tmp169_;
							} else {
								_tmp164_ = FALSE;
							}
							if (_tmp164_) {
								ValaSourceReference* _tmp170_;
								ValaSourceReference* _tmp171_;
								const gchar* _tmp172_;
								ValaSymbol* _tmp173_;
								ValaSymbol* _tmp174_;
								gchar* _tmp175_;
								gchar* _tmp176_;
								ValaSymbol* _tmp177_;
								gchar* _tmp178_;
								gchar* _tmp179_;
								gchar* _tmp180_;
								gchar* _tmp181_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp170_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp171_ = _tmp170_;
								_tmp172_ = self->priv->_member_name;
								_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp174_ = _tmp173_;
								_tmp175_ = vala_symbol_get_full_name (_tmp174_);
								_tmp176_ = _tmp175_;
								_tmp177_ = local_sym;
								_tmp178_ = vala_symbol_get_full_name (_tmp177_);
								_tmp179_ = _tmp178_;
								_tmp180_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp172_, _tmp176_, _tmp179_);
								_tmp181_ = _tmp180_;
								vala_report_error (_tmp171_, _tmp181_);
								_g_free0 (_tmp181_);
								_g_free0 (_tmp179_);
								_g_free0 (_tmp176_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								return result;
							}
							_tmp182_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp182_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp183_;
			ValaExpression* _tmp184_;
			gboolean _tmp185_;
			gboolean _tmp186_;
			ValaExpression* _tmp187_;
			ValaExpression* _tmp188_;
			ValaDataType* _tmp189_;
			ValaDataType* _tmp190_;
			ValaExpression* _tmp208_;
			ValaExpression* _tmp209_;
			gboolean _tmp224_ = FALSE;
			ValaExpression* _tmp225_;
			ValaExpression* _tmp226_;
			gboolean _tmp233_ = FALSE;
			ValaExpression* _tmp234_;
			ValaExpression* _tmp235_;
			gboolean _tmp256_ = FALSE;
			ValaExpression* _tmp257_;
			ValaExpression* _tmp258_;
			gboolean _tmp277_ = FALSE;
			ValaSymbol* _tmp278_;
			ValaSymbol* _tmp279_;
			gboolean _tmp313_ = FALSE;
			gboolean _tmp314_ = FALSE;
			ValaSymbol* _tmp315_;
			ValaSymbol* _tmp316_;
			gboolean _tmp528_ = FALSE;
			ValaSymbol* _tmp529_;
			ValaSymbol* _tmp530_;
			_tmp183_ = vala_member_access_get_inner (self);
			_tmp184_ = _tmp183_;
			_tmp185_ = vala_code_node_get_error ((ValaCodeNode*) _tmp184_);
			_tmp186_ = _tmp185_;
			if (_tmp186_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp187_ = vala_member_access_get_inner (self);
			_tmp188_ = _tmp187_;
			_tmp189_ = vala_expression_get_value_type (_tmp188_);
			_tmp190_ = _tmp189_;
			if (VALA_IS_POINTER_TYPE (_tmp190_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp191_;
				ValaExpression* _tmp192_;
				ValaDataType* _tmp193_;
				ValaDataType* _tmp194_;
				gboolean _tmp195_ = FALSE;
				ValaPointerType* _tmp196_;
				_tmp191_ = vala_member_access_get_inner (self);
				_tmp192_ = _tmp191_;
				_tmp193_ = vala_expression_get_value_type (_tmp192_);
				_tmp194_ = _tmp193_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp194_) ? ((ValaPointerType*) _tmp194_) : NULL;
				_tmp196_ = pointer_type;
				if (_tmp196_ != NULL) {
					ValaPointerType* _tmp197_;
					ValaDataType* _tmp198_;
					ValaDataType* _tmp199_;
					_tmp197_ = pointer_type;
					_tmp198_ = vala_pointer_type_get_base_type (_tmp197_);
					_tmp199_ = _tmp198_;
					_tmp195_ = VALA_IS_VALUE_TYPE (_tmp199_);
				} else {
					_tmp195_ = FALSE;
				}
				if (_tmp195_) {
					ValaExpression* _tmp200_;
					ValaExpression* _tmp201_;
					ValaSourceReference* _tmp202_;
					ValaSourceReference* _tmp203_;
					ValaPointerIndirection* _tmp204_;
					ValaPointerIndirection* _tmp205_;
					ValaExpression* _tmp206_;
					ValaExpression* _tmp207_;
					_tmp200_ = vala_member_access_get_inner (self);
					_tmp201_ = _tmp200_;
					_tmp202_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp203_ = _tmp202_;
					_tmp204_ = vala_pointer_indirection_new (_tmp201_, _tmp203_);
					_tmp205_ = _tmp204_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp205_);
					_vala_code_node_unref0 (_tmp205_);
					_tmp206_ = vala_member_access_get_inner (self);
					_tmp207_ = _tmp206_;
					vala_code_node_check ((ValaCodeNode*) _tmp207_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp208_ = vala_member_access_get_inner (self);
			_tmp209_ = _tmp208_;
			if (VALA_IS_MEMBER_ACCESS (_tmp209_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp210_;
				ValaExpression* _tmp211_;
				ValaMemberAccess* _tmp212_;
				gboolean _tmp213_;
				_tmp210_ = vala_member_access_get_inner (self);
				_tmp211_ = _tmp210_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp211_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp212_ = ma;
				_tmp213_ = _tmp212_->priv->_prototype_access;
				if (_tmp213_) {
					ValaSourceReference* _tmp214_;
					ValaSourceReference* _tmp215_;
					ValaExpression* _tmp216_;
					ValaExpression* _tmp217_;
					ValaSymbol* _tmp218_;
					ValaSymbol* _tmp219_;
					gchar* _tmp220_;
					gchar* _tmp221_;
					gchar* _tmp222_;
					gchar* _tmp223_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					_tmp216_ = vala_member_access_get_inner (self);
					_tmp217_ = _tmp216_;
					_tmp218_ = vala_expression_get_symbol_reference (_tmp217_);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_symbol_get_full_name (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp221_);
					_tmp223_ = _tmp222_;
					vala_report_error (_tmp215_, _tmp223_);
					_g_free0 (_tmp223_);
					_g_free0 (_tmp221_);
					result = FALSE;
					return result;
				}
			}
			_tmp225_ = vala_member_access_get_inner (self);
			_tmp226_ = _tmp225_;
			if (VALA_IS_CAST_EXPRESSION (_tmp226_)) {
				ValaExpression* _tmp227_;
				ValaExpression* _tmp228_;
				gboolean _tmp229_;
				gboolean _tmp230_;
				_tmp227_ = vala_member_access_get_inner (self);
				_tmp228_ = _tmp227_;
				_tmp229_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp228_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp230_ = _tmp229_;
				_tmp224_ = _tmp230_;
			} else {
				_tmp224_ = FALSE;
			}
			if (_tmp224_) {
				ValaSourceReference* _tmp231_;
				ValaSourceReference* _tmp232_;
				_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp232_ = _tmp231_;
				vala_report_warning (_tmp232_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp234_ = vala_member_access_get_inner (self);
			_tmp235_ = _tmp234_;
			if (VALA_IS_MEMBER_ACCESS (_tmp235_)) {
				_tmp233_ = TRUE;
			} else {
				ValaExpression* _tmp236_;
				ValaExpression* _tmp237_;
				_tmp236_ = vala_member_access_get_inner (self);
				_tmp237_ = _tmp236_;
				_tmp233_ = VALA_IS_BASE_ACCESS (_tmp237_);
			}
			if (_tmp233_) {
				ValaExpression* _tmp238_;
				ValaExpression* _tmp239_;
				ValaSymbol* _tmp240_;
				ValaSymbol* _tmp241_;
				gboolean _tmp242_ = FALSE;
				ValaSymbol* _tmp243_;
				ValaSymbol* _tmp244_;
				_tmp238_ = vala_member_access_get_inner (self);
				_tmp239_ = _tmp238_;
				_tmp240_ = vala_expression_get_symbol_reference (_tmp239_);
				_tmp241_ = _tmp240_;
				base_symbol = _tmp241_;
				_tmp243_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp244_ = _tmp243_;
				if (_tmp244_ == NULL) {
					gboolean _tmp245_ = FALSE;
					ValaSymbol* _tmp246_;
					_tmp246_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp246_)) {
						_tmp245_ = TRUE;
					} else {
						ValaSymbol* _tmp247_;
						_tmp247_ = base_symbol;
						_tmp245_ = VALA_IS_TYPESYMBOL (_tmp247_);
					}
					_tmp242_ = _tmp245_;
				} else {
					_tmp242_ = FALSE;
				}
				if (_tmp242_) {
					ValaSymbol* _tmp248_;
					ValaScope* _tmp249_;
					ValaScope* _tmp250_;
					const gchar* _tmp251_;
					ValaSymbol* _tmp252_;
					ValaSymbol* _tmp253_;
					ValaExpression* _tmp254_;
					ValaExpression* _tmp255_;
					_tmp248_ = base_symbol;
					_tmp249_ = vala_symbol_get_scope (_tmp248_);
					_tmp250_ = _tmp249_;
					_tmp251_ = self->priv->_member_name;
					_tmp252_ = vala_scope_lookup (_tmp250_, _tmp251_);
					_tmp253_ = _tmp252_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp253_);
					_vala_code_node_unref0 (_tmp253_);
					_tmp254_ = vala_member_access_get_inner (self);
					_tmp255_ = _tmp254_;
					if (VALA_IS_BASE_ACCESS (_tmp255_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp257_ = vala_member_access_get_inner (self);
			_tmp258_ = _tmp257_;
			if (VALA_IS_MEMBER_ACCESS (_tmp258_)) {
				ValaExpression* _tmp259_;
				ValaExpression* _tmp260_;
				ValaSymbol* _tmp261_;
				ValaSymbol* _tmp262_;
				_tmp259_ = vala_member_access_get_inner (self);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_expression_get_symbol_reference (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp256_ = VALA_IS_TYPEPARAMETER (_tmp262_);
			} else {
				_tmp256_ = FALSE;
			}
			if (_tmp256_) {
				ValaExpression* _tmp263_;
				ValaExpression* _tmp264_;
				ValaExpression* _tmp265_;
				ValaExpression* _tmp266_;
				ValaSymbol* _tmp267_;
				ValaSymbol* _tmp268_;
				ValaGenericType* _tmp269_;
				ValaGenericType* _tmp270_;
				ValaExpression* _tmp271_;
				ValaExpression* _tmp272_;
				ValaDataType* _tmp273_;
				ValaDataType* _tmp274_;
				ValaSourceReference* _tmp275_;
				ValaSourceReference* _tmp276_;
				_tmp263_ = vala_member_access_get_inner (self);
				_tmp264_ = _tmp263_;
				_tmp265_ = vala_member_access_get_inner (self);
				_tmp266_ = _tmp265_;
				_tmp267_ = vala_expression_get_symbol_reference (_tmp266_);
				_tmp268_ = _tmp267_;
				_tmp269_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp268_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp270_ = _tmp269_;
				vala_expression_set_value_type (_tmp264_, (ValaDataType*) _tmp270_);
				_vala_code_node_unref0 (_tmp270_);
				_tmp271_ = vala_member_access_get_inner (self);
				_tmp272_ = _tmp271_;
				_tmp273_ = vala_expression_get_value_type (_tmp272_);
				_tmp274_ = _tmp273_;
				_tmp275_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp276_ = _tmp275_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp274_, _tmp276_);
			}
			_tmp278_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp279_ = _tmp278_;
			if (_tmp279_ == NULL) {
				ValaExpression* _tmp280_;
				ValaExpression* _tmp281_;
				ValaDataType* _tmp282_;
				ValaDataType* _tmp283_;
				_tmp280_ = vala_member_access_get_inner (self);
				_tmp281_ = _tmp280_;
				_tmp282_ = vala_expression_get_value_type (_tmp281_);
				_tmp283_ = _tmp282_;
				_tmp277_ = _tmp283_ != NULL;
			} else {
				_tmp277_ = FALSE;
			}
			if (_tmp277_) {
				gboolean _tmp284_;
				ValaSymbol* _tmp311_;
				ValaSymbol* _tmp312_;
				_tmp284_ = self->priv->_pointer_member_access;
				if (_tmp284_) {
					ValaExpression* _tmp285_;
					ValaExpression* _tmp286_;
					ValaDataType* _tmp287_;
					ValaDataType* _tmp288_;
					const gchar* _tmp289_;
					ValaSymbol* _tmp290_;
					ValaSymbol* _tmp291_;
					_tmp285_ = vala_member_access_get_inner (self);
					_tmp286_ = _tmp285_;
					_tmp287_ = vala_expression_get_value_type (_tmp286_);
					_tmp288_ = _tmp287_;
					_tmp289_ = self->priv->_member_name;
					_tmp290_ = vala_data_type_get_pointer_member (_tmp288_, _tmp289_);
					_tmp291_ = _tmp290_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp291_);
					_vala_code_node_unref0 (_tmp291_);
				} else {
					ValaExpression* _tmp292_;
					ValaExpression* _tmp293_;
					ValaDataType* _tmp294_;
					ValaDataType* _tmp295_;
					ValaTypeSymbol* _tmp296_;
					ValaTypeSymbol* _tmp297_;
					ValaExpression* _tmp304_;
					ValaExpression* _tmp305_;
					ValaDataType* _tmp306_;
					ValaDataType* _tmp307_;
					const gchar* _tmp308_;
					ValaSymbol* _tmp309_;
					ValaSymbol* _tmp310_;
					_tmp292_ = vala_member_access_get_inner (self);
					_tmp293_ = _tmp292_;
					_tmp294_ = vala_expression_get_value_type (_tmp293_);
					_tmp295_ = _tmp294_;
					_tmp296_ = vala_data_type_get_type_symbol (_tmp295_);
					_tmp297_ = _tmp296_;
					if (_tmp297_ != NULL) {
						ValaExpression* _tmp298_;
						ValaExpression* _tmp299_;
						ValaDataType* _tmp300_;
						ValaDataType* _tmp301_;
						ValaTypeSymbol* _tmp302_;
						ValaTypeSymbol* _tmp303_;
						_tmp298_ = vala_member_access_get_inner (self);
						_tmp299_ = _tmp298_;
						_tmp300_ = vala_expression_get_value_type (_tmp299_);
						_tmp301_ = _tmp300_;
						_tmp302_ = vala_data_type_get_type_symbol (_tmp301_);
						_tmp303_ = _tmp302_;
						base_symbol = (ValaSymbol*) _tmp303_;
					}
					_tmp304_ = vala_member_access_get_inner (self);
					_tmp305_ = _tmp304_;
					_tmp306_ = vala_expression_get_value_type (_tmp305_);
					_tmp307_ = _tmp306_;
					_tmp308_ = self->priv->_member_name;
					_tmp309_ = vala_data_type_get_member (_tmp307_, _tmp308_);
					_tmp310_ = _tmp309_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp310_);
					_vala_code_node_unref0 (_tmp310_);
				}
				_tmp311_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp312_ = _tmp311_;
				if (_tmp312_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp315_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp316_ = _tmp315_;
			if (_tmp316_ == NULL) {
				ValaExpression* _tmp317_;
				ValaExpression* _tmp318_;
				ValaDataType* _tmp319_;
				ValaDataType* _tmp320_;
				_tmp317_ = vala_member_access_get_inner (self);
				_tmp318_ = _tmp317_;
				_tmp319_ = vala_expression_get_value_type (_tmp318_);
				_tmp320_ = _tmp319_;
				_tmp314_ = _tmp320_ != NULL;
			} else {
				_tmp314_ = FALSE;
			}
			if (_tmp314_) {
				ValaExpression* _tmp321_;
				ValaExpression* _tmp322_;
				ValaDataType* _tmp323_;
				ValaDataType* _tmp324_;
				gboolean _tmp325_;
				gboolean _tmp326_;
				_tmp321_ = vala_member_access_get_inner (self);
				_tmp322_ = _tmp321_;
				_tmp323_ = vala_expression_get_value_type (_tmp322_);
				_tmp324_ = _tmp323_;
				_tmp325_ = vala_data_type_get_is_dynamic (_tmp324_);
				_tmp326_ = _tmp325_;
				_tmp313_ = _tmp326_;
			} else {
				_tmp313_ = FALSE;
			}
			if (_tmp313_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp327_;
				ValaExpression* _tmp328_;
				ValaDataType* _tmp329_;
				ValaDataType* _tmp330_;
				ValaObjectType* _tmp331_;
				ValaCodeNode* _tmp332_;
				ValaCodeNode* _tmp333_;
				ValaSymbol* _tmp476_;
				ValaSymbol* _tmp477_;
				ValaSymbol* _tmp526_;
				ValaSymbol* _tmp527_;
				_tmp327_ = vala_member_access_get_inner (self);
				_tmp328_ = _tmp327_;
				_tmp329_ = vala_expression_get_value_type (_tmp328_);
				_tmp330_ = _tmp329_;
				_tmp331_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp330_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp331_;
				_tmp332_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp333_ = _tmp332_;
				if (VALA_IS_METHOD_CALL (_tmp333_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp334_;
					ValaCodeNode* _tmp335_;
					ValaMethodCall* _tmp336_;
					ValaExpression* _tmp337_;
					ValaExpression* _tmp338_;
					_tmp334_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp335_ = _tmp334_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp335_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp336_ = invoc;
					_tmp337_ = vala_method_call_get_call (_tmp336_);
					_tmp338_ = _tmp337_;
					if (_tmp338_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp339_;
						ValaDataType* _tmp340_;
						ValaDataType* _tmp341_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp356_;
						ValaExpression* _tmp357_;
						ValaDataType* _tmp358_;
						ValaDataType* _tmp359_;
						const gchar* _tmp360_;
						ValaDataType* _tmp361_;
						ValaSourceReference* _tmp362_;
						ValaSourceReference* _tmp363_;
						ValaDynamicMethod* _tmp364_;
						ValaDynamicMethod* _tmp365_;
						ValaMethodCall* _tmp366_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp367_;
						ValaErrorType* _tmp368_;
						ValaDynamicMethod* _tmp369_;
						ValaErrorType* _tmp370_;
						ValaDynamicMethod* _tmp371_;
						ValaDynamicMethod* _tmp372_;
						ValaParameter* _tmp373_;
						ValaParameter* _tmp374_;
						ValaDynamicMethod* _tmp375_;
						ValaObjectType* _tmp376_;
						ValaDataType* _tmp377_;
						ValaDataType* _tmp378_;
						ValaParameter* _tmp379_;
						ValaParameter* _tmp380_;
						ValaObjectType* _tmp381_;
						ValaTypeSymbol* _tmp382_;
						ValaTypeSymbol* _tmp383_;
						ValaScope* _tmp384_;
						ValaScope* _tmp385_;
						ValaDynamicMethod* _tmp386_;
						ValaDynamicMethod* _tmp387_;
						_tmp339_ = invoc;
						_tmp340_ = vala_expression_get_target_type ((ValaExpression*) _tmp339_);
						_tmp341_ = _tmp340_;
						if (_tmp341_ != NULL) {
							ValaMethodCall* _tmp342_;
							ValaDataType* _tmp343_;
							ValaDataType* _tmp344_;
							ValaDataType* _tmp345_;
							ValaDataType* _tmp346_;
							_tmp342_ = invoc;
							_tmp343_ = vala_expression_get_target_type ((ValaExpression*) _tmp342_);
							_tmp344_ = _tmp343_;
							_tmp345_ = vala_data_type_copy (_tmp344_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp345_;
							_tmp346_ = ret_type;
							vala_data_type_set_value_owned (_tmp346_, TRUE);
						} else {
							ValaMethodCall* _tmp347_;
							ValaCodeNode* _tmp348_;
							ValaCodeNode* _tmp349_;
							_tmp347_ = invoc;
							_tmp348_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp347_);
							_tmp349_ = _tmp348_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp349_)) {
								ValaVoidType* _tmp350_;
								_tmp350_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp350_;
							} else {
								ValaExpression* _tmp351_;
								ValaExpression* _tmp352_;
								ValaDataType* _tmp353_;
								ValaDataType* _tmp354_;
								ValaDataType* _tmp355_;
								_tmp351_ = vala_member_access_get_inner (self);
								_tmp352_ = _tmp351_;
								_tmp353_ = vala_expression_get_value_type (_tmp352_);
								_tmp354_ = _tmp353_;
								_tmp355_ = vala_data_type_copy (_tmp354_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp355_;
							}
						}
						_tmp356_ = vala_member_access_get_inner (self);
						_tmp357_ = _tmp356_;
						_tmp358_ = vala_expression_get_value_type (_tmp357_);
						_tmp359_ = _tmp358_;
						_tmp360_ = self->priv->_member_name;
						_tmp361_ = ret_type;
						_tmp362_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp363_ = _tmp362_;
						_tmp364_ = vala_dynamic_method_new (_tmp359_, _tmp360_, _tmp361_, _tmp363_, NULL);
						m = _tmp364_;
						_tmp365_ = m;
						_tmp366_ = invoc;
						vala_dynamic_method_set_invocation (_tmp365_, _tmp366_);
						_tmp367_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp367_;
						_tmp368_ = err;
						vala_error_type_set_dynamic_error (_tmp368_, TRUE);
						_tmp369_ = m;
						_tmp370_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp369_, (ValaDataType*) _tmp370_);
						_tmp371_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp371_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp372_ = m;
						_tmp373_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp374_ = _tmp373_;
						vala_callable_add_parameter ((ValaCallable*) _tmp372_, _tmp374_);
						_vala_code_node_unref0 (_tmp374_);
						_tmp375_ = m;
						_tmp376_ = dynamic_object_type;
						_tmp377_ = vala_data_type_copy ((ValaDataType*) _tmp376_);
						_tmp378_ = _tmp377_;
						_tmp379_ = vala_parameter_new ("this", _tmp378_, NULL);
						_tmp380_ = _tmp379_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp375_, _tmp380_);
						_vala_code_node_unref0 (_tmp380_);
						_vala_code_node_unref0 (_tmp378_);
						_tmp381_ = dynamic_object_type;
						_tmp382_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp381_);
						_tmp383_ = _tmp382_;
						_tmp384_ = vala_symbol_get_scope ((ValaSymbol*) _tmp383_);
						_tmp385_ = _tmp384_;
						_tmp386_ = m;
						vala_scope_add (_tmp385_, NULL, (ValaSymbol*) _tmp386_);
						_tmp387_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp387_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp388_;
					ValaCodeNode* _tmp389_;
					_tmp388_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp389_ = _tmp388_;
					if (VALA_IS_ASSIGNMENT (_tmp389_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp390_;
						ValaCodeNode* _tmp391_;
						ValaAssignment* _tmp392_;
						ValaExpression* _tmp393_;
						ValaExpression* _tmp394_;
						_tmp390_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp391_ = _tmp390_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp391_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp392_ = a;
						_tmp393_ = vala_assignment_get_left (_tmp392_);
						_tmp394_ = _tmp393_;
						if (_tmp394_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp395_;
							ValaExpression* _tmp396_;
							ValaDataType* _tmp397_;
							ValaDataType* _tmp398_;
							const gchar* _tmp399_;
							ValaSourceReference* _tmp400_;
							ValaSourceReference* _tmp401_;
							ValaDynamicProperty* _tmp402_;
							ValaDynamicProperty* _tmp403_;
							ValaDynamicProperty* _tmp404_;
							ValaDynamicProperty* _tmp405_;
							ValaSourceReference* _tmp406_;
							ValaSourceReference* _tmp407_;
							ValaPropertyAccessor* _tmp408_;
							ValaPropertyAccessor* _tmp409_;
							ValaDynamicProperty* _tmp410_;
							ValaExpression* _tmp411_;
							ValaExpression* _tmp412_;
							ValaDataType* _tmp413_;
							ValaDataType* _tmp414_;
							ValaTypeSymbol* _tmp415_;
							ValaTypeSymbol* _tmp416_;
							ValaScope* _tmp417_;
							ValaScope* _tmp418_;
							ValaObjectType* _tmp419_;
							ValaTypeSymbol* _tmp420_;
							ValaTypeSymbol* _tmp421_;
							ValaScope* _tmp422_;
							ValaScope* _tmp423_;
							ValaDynamicProperty* _tmp424_;
							ValaDynamicProperty* _tmp425_;
							_tmp395_ = vala_member_access_get_inner (self);
							_tmp396_ = _tmp395_;
							_tmp397_ = vala_expression_get_value_type (_tmp396_);
							_tmp398_ = _tmp397_;
							_tmp399_ = self->priv->_member_name;
							_tmp400_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp401_ = _tmp400_;
							_tmp402_ = vala_dynamic_property_new (_tmp398_, _tmp399_, _tmp401_, NULL);
							prop = _tmp402_;
							_tmp403_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp403_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp404_ = prop;
							_tmp405_ = prop;
							_tmp406_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp405_);
							_tmp407_ = _tmp406_;
							_tmp408_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp407_, NULL);
							_tmp409_ = _tmp408_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp404_, _tmp409_);
							_vala_code_node_unref0 (_tmp409_);
							_tmp410_ = prop;
							_tmp411_ = vala_member_access_get_inner (self);
							_tmp412_ = _tmp411_;
							_tmp413_ = vala_expression_get_value_type (_tmp412_);
							_tmp414_ = _tmp413_;
							_tmp415_ = vala_data_type_get_type_symbol (_tmp414_);
							_tmp416_ = _tmp415_;
							_tmp417_ = vala_symbol_get_scope ((ValaSymbol*) _tmp416_);
							_tmp418_ = _tmp417_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp410_, _tmp418_);
							_tmp419_ = dynamic_object_type;
							_tmp420_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp419_);
							_tmp421_ = _tmp420_;
							_tmp422_ = vala_symbol_get_scope ((ValaSymbol*) _tmp421_);
							_tmp423_ = _tmp422_;
							_tmp424_ = prop;
							vala_scope_add (_tmp423_, NULL, (ValaSymbol*) _tmp424_);
							_tmp425_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp425_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp426_ = FALSE;
						gboolean _tmp427_ = FALSE;
						ValaCodeNode* _tmp428_;
						ValaCodeNode* _tmp429_;
						_tmp428_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp429_ = _tmp428_;
						if (VALA_IS_MEMBER_ACCESS (_tmp429_)) {
							ValaExpression* _tmp430_;
							ValaExpression* _tmp431_;
							_tmp430_ = vala_member_access_get_inner (self);
							_tmp431_ = _tmp430_;
							_tmp427_ = VALA_IS_MEMBER_ACCESS (_tmp431_);
						} else {
							_tmp427_ = FALSE;
						}
						if (_tmp427_) {
							ValaCodeNode* _tmp432_;
							ValaCodeNode* _tmp433_;
							ValaCodeNode* _tmp434_;
							ValaCodeNode* _tmp435_;
							_tmp432_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp433_ = _tmp432_;
							_tmp434_ = vala_code_node_get_parent_node (_tmp433_);
							_tmp435_ = _tmp434_;
							_tmp426_ = VALA_IS_METHOD_CALL (_tmp435_);
						} else {
							_tmp426_ = FALSE;
						}
						if (_tmp426_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp436_;
							ValaCodeNode* _tmp437_;
							gboolean _tmp438_ = FALSE;
							ValaMemberAccess* _tmp439_;
							const gchar* _tmp440_;
							_tmp436_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp437_ = _tmp436_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp437_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp439_ = ma;
							_tmp440_ = _tmp439_->priv->_member_name;
							if (g_strcmp0 (_tmp440_, "connect") == 0) {
								_tmp438_ = TRUE;
							} else {
								ValaMemberAccess* _tmp441_;
								const gchar* _tmp442_;
								_tmp441_ = ma;
								_tmp442_ = _tmp441_->priv->_member_name;
								_tmp438_ = g_strcmp0 (_tmp442_, "connect_after") == 0;
							}
							if (_tmp438_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp443_;
								ValaExpression* _tmp444_;
								ValaDataType* _tmp445_;
								ValaDataType* _tmp446_;
								const gchar* _tmp447_;
								ValaVoidType* _tmp448_;
								ValaVoidType* _tmp449_;
								ValaSourceReference* _tmp450_;
								ValaSourceReference* _tmp451_;
								ValaDynamicSignal* _tmp452_;
								ValaDynamicSignal* _tmp453_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp454_;
								ValaCodeNode* _tmp455_;
								ValaCodeNode* _tmp456_;
								ValaCodeNode* _tmp457_;
								ValaMethodCall* _tmp458_;
								ValaMethodCall* _tmp459_;
								ValaList* _tmp460_;
								gint _tmp461_;
								gint _tmp462_;
								ValaDynamicSignal* _tmp468_;
								ValaObjectType* _tmp469_;
								ValaTypeSymbol* _tmp470_;
								ValaTypeSymbol* _tmp471_;
								ValaScope* _tmp472_;
								ValaScope* _tmp473_;
								ValaDynamicSignal* _tmp474_;
								ValaDynamicSignal* _tmp475_;
								_tmp443_ = vala_member_access_get_inner (self);
								_tmp444_ = _tmp443_;
								_tmp445_ = vala_expression_get_value_type (_tmp444_);
								_tmp446_ = _tmp445_;
								_tmp447_ = self->priv->_member_name;
								_tmp448_ = vala_void_type_new (NULL);
								_tmp449_ = _tmp448_;
								_tmp450_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp451_ = _tmp450_;
								_tmp452_ = vala_dynamic_signal_new (_tmp446_, _tmp447_, (ValaDataType*) _tmp449_, _tmp451_, NULL);
								_tmp453_ = _tmp452_;
								_vala_code_node_unref0 (_tmp449_);
								s = _tmp453_;
								_tmp454_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp455_ = _tmp454_;
								_tmp456_ = vala_code_node_get_parent_node (_tmp455_);
								_tmp457_ = _tmp456_;
								_tmp458_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp457_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp458_;
								_tmp459_ = mcall;
								_tmp460_ = vala_method_call_get_argument_list (_tmp459_);
								_tmp461_ = vala_collection_get_size ((ValaCollection*) _tmp460_);
								_tmp462_ = _tmp461_;
								if (_tmp462_ > 0) {
									ValaDynamicSignal* _tmp463_;
									ValaMethodCall* _tmp464_;
									ValaList* _tmp465_;
									gpointer _tmp466_;
									ValaExpression* _tmp467_;
									_tmp463_ = s;
									_tmp464_ = mcall;
									_tmp465_ = vala_method_call_get_argument_list (_tmp464_);
									_tmp466_ = vala_list_get (_tmp465_, 0);
									_tmp467_ = (ValaExpression*) _tmp466_;
									vala_dynamic_signal_set_handler (_tmp463_, _tmp467_);
									_vala_code_node_unref0 (_tmp467_);
								}
								_tmp468_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp468_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp469_ = dynamic_object_type;
								_tmp470_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp469_);
								_tmp471_ = _tmp470_;
								_tmp472_ = vala_symbol_get_scope ((ValaSymbol*) _tmp471_);
								_tmp473_ = _tmp472_;
								_tmp474_ = s;
								vala_scope_add (_tmp473_, NULL, (ValaSymbol*) _tmp474_);
								_tmp475_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp475_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp476_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp477_ = _tmp476_;
				if (_tmp477_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp478_;
					ValaExpression* _tmp479_;
					ValaDataType* _tmp480_;
					ValaDataType* _tmp481_;
					const gchar* _tmp482_;
					ValaSourceReference* _tmp483_;
					ValaSourceReference* _tmp484_;
					ValaDynamicProperty* _tmp485_;
					ValaDataType* _tmp486_;
					ValaDataType* _tmp487_;
					ValaDynamicProperty* _tmp498_;
					ValaDynamicProperty* _tmp499_;
					ValaDynamicProperty* _tmp500_;
					ValaDataType* _tmp501_;
					ValaDataType* _tmp502_;
					ValaDataType* _tmp503_;
					ValaDataType* _tmp504_;
					ValaDynamicProperty* _tmp505_;
					ValaSourceReference* _tmp506_;
					ValaSourceReference* _tmp507_;
					ValaPropertyAccessor* _tmp508_;
					ValaPropertyAccessor* _tmp509_;
					ValaDynamicProperty* _tmp510_;
					ValaExpression* _tmp511_;
					ValaExpression* _tmp512_;
					ValaDataType* _tmp513_;
					ValaDataType* _tmp514_;
					ValaTypeSymbol* _tmp515_;
					ValaTypeSymbol* _tmp516_;
					ValaScope* _tmp517_;
					ValaScope* _tmp518_;
					ValaObjectType* _tmp519_;
					ValaTypeSymbol* _tmp520_;
					ValaTypeSymbol* _tmp521_;
					ValaScope* _tmp522_;
					ValaScope* _tmp523_;
					ValaDynamicProperty* _tmp524_;
					ValaDynamicProperty* _tmp525_;
					_tmp478_ = vala_member_access_get_inner (self);
					_tmp479_ = _tmp478_;
					_tmp480_ = vala_expression_get_value_type (_tmp479_);
					_tmp481_ = _tmp480_;
					_tmp482_ = self->priv->_member_name;
					_tmp483_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp484_ = _tmp483_;
					_tmp485_ = vala_dynamic_property_new (_tmp481_, _tmp482_, _tmp484_, NULL);
					prop = _tmp485_;
					_tmp486_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp487_ = _tmp486_;
					if (_tmp487_ != NULL) {
						ValaDynamicProperty* _tmp488_;
						ValaDataType* _tmp489_;
						ValaDataType* _tmp490_;
						_tmp488_ = prop;
						_tmp489_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp490_ = _tmp489_;
						vala_property_set_property_type ((ValaProperty*) _tmp488_, _tmp490_);
					} else {
						ValaDynamicProperty* _tmp491_;
						ValaExpression* _tmp492_;
						ValaExpression* _tmp493_;
						ValaDataType* _tmp494_;
						ValaDataType* _tmp495_;
						ValaDataType* _tmp496_;
						ValaDataType* _tmp497_;
						_tmp491_ = prop;
						_tmp492_ = vala_member_access_get_inner (self);
						_tmp493_ = _tmp492_;
						_tmp494_ = vala_expression_get_value_type (_tmp493_);
						_tmp495_ = _tmp494_;
						_tmp496_ = vala_data_type_copy (_tmp495_);
						_tmp497_ = _tmp496_;
						vala_property_set_property_type ((ValaProperty*) _tmp491_, _tmp497_);
						_vala_code_node_unref0 (_tmp497_);
					}
					_tmp498_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp498_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp499_ = prop;
					_tmp500_ = prop;
					_tmp501_ = vala_property_get_property_type ((ValaProperty*) _tmp500_);
					_tmp502_ = _tmp501_;
					_tmp503_ = vala_data_type_copy (_tmp502_);
					_tmp504_ = _tmp503_;
					_tmp505_ = prop;
					_tmp506_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp505_);
					_tmp507_ = _tmp506_;
					_tmp508_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp504_, NULL, _tmp507_, NULL);
					_tmp509_ = _tmp508_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp499_, _tmp509_);
					_vala_code_node_unref0 (_tmp509_);
					_vala_code_node_unref0 (_tmp504_);
					_tmp510_ = prop;
					_tmp511_ = vala_member_access_get_inner (self);
					_tmp512_ = _tmp511_;
					_tmp513_ = vala_expression_get_value_type (_tmp512_);
					_tmp514_ = _tmp513_;
					_tmp515_ = vala_data_type_get_type_symbol (_tmp514_);
					_tmp516_ = _tmp515_;
					_tmp517_ = vala_symbol_get_scope ((ValaSymbol*) _tmp516_);
					_tmp518_ = _tmp517_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp510_, _tmp518_);
					_tmp519_ = dynamic_object_type;
					_tmp520_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp519_);
					_tmp521_ = _tmp520_;
					_tmp522_ = vala_symbol_get_scope ((ValaSymbol*) _tmp521_);
					_tmp523_ = _tmp522_;
					_tmp524_ = prop;
					vala_scope_add (_tmp523_, NULL, (ValaSymbol*) _tmp524_);
					_tmp525_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp525_);
					_vala_code_node_unref0 (prop);
				}
				_tmp526_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp527_ = _tmp526_;
				if (_tmp527_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp529_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp530_ = _tmp529_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp530_)) {
				ValaExpression* _tmp531_;
				ValaExpression* _tmp532_;
				ValaDataType* _tmp533_;
				ValaDataType* _tmp534_;
				_tmp531_ = vala_member_access_get_inner (self);
				_tmp532_ = _tmp531_;
				_tmp533_ = vala_expression_get_value_type (_tmp532_);
				_tmp534_ = _tmp533_;
				_tmp528_ = VALA_IS_ARRAY_TYPE (_tmp534_);
			} else {
				_tmp528_ = FALSE;
			}
			if (_tmp528_) {
				ValaArrayType* value_array_type = NULL;
				ValaExpression* _tmp535_;
				ValaExpression* _tmp536_;
				ValaDataType* _tmp537_;
				ValaDataType* _tmp538_;
				gboolean _tmp539_ = FALSE;
				ValaArrayType* _tmp540_;
				_tmp535_ = vala_member_access_get_inner (self);
				_tmp536_ = _tmp535_;
				_tmp537_ = vala_expression_get_value_type (_tmp536_);
				_tmp538_ = _tmp537_;
				value_array_type = VALA_IS_ARRAY_TYPE (_tmp538_) ? ((ValaArrayType*) _tmp538_) : NULL;
				_tmp540_ = value_array_type;
				if (_tmp540_ != NULL) {
					ValaArrayType* _tmp541_;
					gboolean _tmp542_;
					gboolean _tmp543_;
					_tmp541_ = value_array_type;
					_tmp542_ = vala_array_type_get_inline_allocated (_tmp541_);
					_tmp543_ = _tmp542_;
					_tmp539_ = _tmp543_;
				} else {
					_tmp539_ = FALSE;
				}
				if (_tmp539_) {
					ValaSourceReference* _tmp544_;
					ValaSourceReference* _tmp545_;
					_tmp544_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp545_ = _tmp544_;
					vala_report_error (_tmp545_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp549_ = vala_member_access_get_inner (self);
	_tmp550_ = _tmp549_;
	if (_tmp550_ == NULL) {
		ValaSymbol* _tmp551_;
		ValaSymbol* _tmp552_;
		_tmp551_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp552_ = _tmp551_;
		_tmp548_ = _tmp552_ == NULL;
	} else {
		_tmp548_ = FALSE;
	}
	if (_tmp548_) {
		ValaDataType* _tmp553_;
		ValaDataType* _tmp554_;
		_tmp553_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp554_ = _tmp553_;
		_tmp547_ = _tmp554_ != NULL;
	} else {
		_tmp547_ = FALSE;
	}
	if (_tmp547_) {
		ValaDataType* _tmp555_;
		ValaDataType* _tmp556_;
		ValaTypeSymbol* _tmp557_;
		ValaTypeSymbol* _tmp558_;
		_tmp555_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp556_ = _tmp555_;
		_tmp557_ = vala_data_type_get_type_symbol (_tmp556_);
		_tmp558_ = _tmp557_;
		_tmp546_ = VALA_IS_ENUM (_tmp558_);
	} else {
		_tmp546_ = FALSE;
	}
	if (_tmp546_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp559_;
		ValaDataType* _tmp560_;
		ValaTypeSymbol* _tmp561_;
		ValaTypeSymbol* _tmp562_;
		_tmp559_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp560_ = _tmp559_;
		_tmp561_ = vala_data_type_get_type_symbol (_tmp560_);
		_tmp562_ = _tmp561_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp562_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp563_;
			ValaList* _tmp564_;
			ValaList* _tmp565_;
			gint _val_size = 0;
			ValaList* _tmp566_;
			gint _tmp567_;
			gint _tmp568_;
			gint _val_index = 0;
			_tmp563_ = enum_type;
			_tmp564_ = vala_enum_get_values (_tmp563_);
			_tmp565_ = _vala_iterable_ref0 (_tmp564_);
			_val_list = _tmp565_;
			_tmp566_ = _val_list;
			_tmp567_ = vala_collection_get_size ((ValaCollection*) _tmp566_);
			_tmp568_ = _tmp567_;
			_val_size = _tmp568_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp569_;
				gpointer _tmp570_;
				const gchar* _tmp571_;
				ValaEnumValue* _tmp572_;
				const gchar* _tmp573_;
				const gchar* _tmp574_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp569_ = _val_list;
				_tmp570_ = vala_list_get (_tmp569_, _val_index);
				val = (ValaEnumValue*) _tmp570_;
				_tmp571_ = self->priv->_member_name;
				_tmp572_ = val;
				_tmp573_ = vala_symbol_get_name ((ValaSymbol*) _tmp572_);
				_tmp574_ = _tmp573_;
				if (g_strcmp0 (_tmp571_, _tmp574_) == 0) {
					ValaEnumValue* _tmp575_;
					_tmp575_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp575_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp576_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp577_ = _tmp576_;
	if (_tmp577_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp578_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp579_ = FALSE;
		ValaExpression* _tmp580_;
		ValaExpression* _tmp581_;
		gchar* base_type_package = NULL;
		gchar* _tmp601_;
		gboolean _tmp602_ = FALSE;
		ValaSymbol* _tmp603_;
		ValaSourceReference* _tmp618_;
		ValaSourceReference* _tmp619_;
		const gchar* _tmp620_;
		const gchar* _tmp621_;
		const gchar* _tmp622_;
		gchar* _tmp623_;
		gchar* _tmp624_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp578_ = g_strdup ("(null)");
		base_type_name = _tmp578_;
		base_type = NULL;
		_tmp580_ = vala_member_access_get_inner (self);
		_tmp581_ = _tmp580_;
		if (_tmp581_ != NULL) {
			ValaExpression* _tmp582_;
			ValaExpression* _tmp583_;
			ValaDataType* _tmp584_;
			ValaDataType* _tmp585_;
			_tmp582_ = vala_member_access_get_inner (self);
			_tmp583_ = _tmp582_;
			_tmp584_ = vala_expression_get_value_type (_tmp583_);
			_tmp585_ = _tmp584_;
			_tmp579_ = _tmp585_ != NULL;
		} else {
			_tmp579_ = FALSE;
		}
		if (_tmp579_) {
			ValaExpression* _tmp586_;
			ValaExpression* _tmp587_;
			ValaDataType* _tmp588_;
			ValaDataType* _tmp589_;
			gchar* _tmp590_;
			ValaExpression* _tmp591_;
			ValaExpression* _tmp592_;
			ValaDataType* _tmp593_;
			ValaDataType* _tmp594_;
			ValaTypeSymbol* _tmp595_;
			ValaTypeSymbol* _tmp596_;
			_tmp586_ = vala_member_access_get_inner (self);
			_tmp587_ = _tmp586_;
			_tmp588_ = vala_expression_get_value_type (_tmp587_);
			_tmp589_ = _tmp588_;
			_tmp590_ = vala_code_node_to_string ((ValaCodeNode*) _tmp589_);
			_g_free0 (base_type_name);
			base_type_name = _tmp590_;
			_tmp591_ = vala_member_access_get_inner (self);
			_tmp592_ = _tmp591_;
			_tmp593_ = vala_expression_get_value_type (_tmp592_);
			_tmp594_ = _tmp593_;
			_tmp595_ = vala_data_type_get_type_symbol (_tmp594_);
			_tmp596_ = _tmp595_;
			base_type = (ValaSymbol*) _tmp596_;
		} else {
			ValaSymbol* _tmp597_;
			_tmp597_ = base_symbol;
			if (_tmp597_ != NULL) {
				ValaSymbol* _tmp598_;
				gchar* _tmp599_;
				ValaSymbol* _tmp600_;
				_tmp598_ = base_symbol;
				_tmp599_ = vala_symbol_get_full_name (_tmp598_);
				_g_free0 (base_type_name);
				base_type_name = _tmp599_;
				_tmp600_ = base_symbol;
				base_type = _tmp600_;
			}
		}
		_tmp601_ = g_strdup ("");
		base_type_package = _tmp601_;
		_tmp603_ = base_type;
		if (_tmp603_ != NULL) {
			ValaSymbol* _tmp604_;
			gboolean _tmp605_;
			gboolean _tmp606_;
			_tmp604_ = base_type;
			_tmp605_ = vala_symbol_get_external_package (_tmp604_);
			_tmp606_ = _tmp605_;
			_tmp602_ = _tmp606_;
		} else {
			_tmp602_ = FALSE;
		}
		if (_tmp602_) {
			ValaSymbol* _tmp607_;
			ValaSourceReference* _tmp608_;
			ValaSourceReference* _tmp609_;
			ValaSourceFile* _tmp610_;
			ValaSourceFile* _tmp611_;
			const gchar* _tmp612_;
			const gchar* _tmp613_;
			gchar* _tmp614_;
			const gchar* _tmp615_;
			_tmp607_ = base_symbol;
			_tmp608_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp607_);
			_tmp609_ = _tmp608_;
			_tmp610_ = vala_source_reference_get_file (_tmp609_);
			_tmp611_ = _tmp610_;
			_tmp612_ = vala_source_file_get_package_name (_tmp611_);
			_tmp613_ = _tmp612_;
			_tmp614_ = g_strdup (_tmp613_);
			_g_free0 (base_type_package);
			base_type_package = _tmp614_;
			_tmp615_ = base_type_package;
			if (_tmp615_ != NULL) {
				const gchar* _tmp616_;
				gchar* _tmp617_;
				_tmp616_ = base_type_package;
				_tmp617_ = g_strdup_printf (" (%s)", _tmp616_);
				_g_free0 (base_type_package);
				base_type_package = _tmp617_;
			}
		}
		_tmp618_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp619_ = _tmp618_;
		_tmp620_ = self->priv->_member_name;
		_tmp621_ = base_type_name;
		_tmp622_ = base_type_package;
		_tmp623_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s", _tmp620_, _tmp621_, _tmp622_);
		_tmp624_ = _tmp623_;
		vala_report_error (_tmp619_, _tmp624_);
		_g_free0 (_tmp624_);
		result = FALSE;
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		return result;
	} else {
		ValaSymbol* _tmp625_;
		ValaSymbol* _tmp626_;
		gboolean _tmp627_;
		gboolean _tmp628_;
		_tmp625_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp626_ = _tmp625_;
		_tmp627_ = vala_code_node_get_error ((ValaCodeNode*) _tmp626_);
		_tmp628_ = _tmp627_;
		if (_tmp628_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp629_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp630_ = _tmp629_;
	member = _tmp630_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp631_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp631_, context)) {
		result = FALSE;
		return result;
	}
	_tmp632_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp632_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp633_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp634_;
		ValaSymbol* _tmp635_;
		ValaSymbol* _tmp636_;
		gboolean _tmp637_ = FALSE;
		ValaBlock* _tmp638_;
		_tmp633_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp633_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp634_ = local;
		_tmp635_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp634_);
		_tmp636_ = _tmp635_;
		block = VALA_IS_BLOCK (_tmp636_) ? ((ValaBlock*) _tmp636_) : NULL;
		_tmp638_ = block;
		if (_tmp638_ != NULL) {
			ValaBlock* _tmp639_;
			ValaSymbol* _tmp640_;
			ValaSemanticAnalyzer* _tmp641_;
			ValaSemanticAnalyzer* _tmp642_;
			ValaSymbol* _tmp643_;
			ValaSymbol* _tmp644_;
			_tmp639_ = block;
			_tmp640_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp639_);
			_tmp641_ = vala_code_context_get_analyzer (context);
			_tmp642_ = _tmp641_;
			_tmp643_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp642_);
			_tmp644_ = _tmp643_;
			_tmp637_ = _tmp640_ != _tmp644_;
		} else {
			_tmp637_ = FALSE;
		}
		if (_tmp637_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp645_;
			ValaSemanticAnalyzer* _tmp646_;
			ValaSymbol* _tmp647_;
			ValaSymbol* _tmp648_;
			ValaLocalVariable* _tmp659_;
			ValaBlock* _tmp660_;
			_tmp645_ = vala_code_context_get_analyzer (context);
			_tmp646_ = _tmp645_;
			_tmp647_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp646_);
			_tmp648_ = _tmp647_;
			sym = _tmp648_;
			while (TRUE) {
				ValaSymbol* _tmp649_;
				ValaBlock* _tmp650_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp651_;
				ValaMethod* _tmp652_;
				ValaSymbol* _tmp656_;
				ValaSymbol* _tmp657_;
				ValaSymbol* _tmp658_;
				_tmp649_ = sym;
				_tmp650_ = block;
				if (!(_tmp649_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp650_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp651_ = sym;
				method = VALA_IS_METHOD (_tmp651_) ? ((ValaMethod*) _tmp651_) : NULL;
				_tmp652_ = method;
				if (_tmp652_ != NULL) {
					ValaMethod* _tmp653_;
					ValaMethod* _tmp654_;
					ValaLocalVariable* _tmp655_;
					_tmp653_ = method;
					vala_method_set_closure (_tmp653_, TRUE);
					_tmp654_ = method;
					_tmp655_ = local;
					vala_method_add_captured_variable (_tmp654_, _tmp655_);
				}
				_tmp656_ = sym;
				_tmp657_ = vala_symbol_get_parent_symbol (_tmp656_);
				_tmp658_ = _tmp657_;
				sym = _tmp658_;
			}
			_tmp659_ = local;
			vala_local_variable_set_captured (_tmp659_, TRUE);
			_tmp660_ = block;
			vala_block_set_captured (_tmp660_, TRUE);
		}
	} else {
		ValaSymbol* _tmp661_;
		_tmp661_ = member;
		if (VALA_IS_PARAMETER (_tmp661_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp662_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp663_;
			ValaSymbol* _tmp664_;
			ValaSymbol* _tmp665_;
			gboolean _tmp666_ = FALSE;
			gboolean _tmp667_ = FALSE;
			ValaMethod* _tmp668_;
			_tmp662_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp662_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp663_ = param;
			_tmp664_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp663_);
			_tmp665_ = _tmp664_;
			m = VALA_IS_METHOD (_tmp665_) ? ((ValaMethod*) _tmp665_) : NULL;
			_tmp668_ = m;
			if (_tmp668_ != NULL) {
				ValaMethod* _tmp669_;
				ValaSemanticAnalyzer* _tmp670_;
				ValaSemanticAnalyzer* _tmp671_;
				ValaSymbol* _tmp672_;
				ValaSymbol* _tmp673_;
				_tmp669_ = m;
				_tmp670_ = vala_code_context_get_analyzer (context);
				_tmp671_ = _tmp670_;
				_tmp672_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp671_);
				_tmp673_ = _tmp672_;
				_tmp667_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp669_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp673_;
			} else {
				_tmp667_ = FALSE;
			}
			if (_tmp667_) {
				ValaParameter* _tmp674_;
				ValaMethod* _tmp675_;
				ValaParameter* _tmp676_;
				ValaParameter* _tmp677_;
				_tmp674_ = param;
				_tmp675_ = m;
				_tmp676_ = vala_method_get_this_parameter (_tmp675_);
				_tmp677_ = _tmp676_;
				_tmp666_ = _tmp674_ != _tmp677_;
			} else {
				_tmp666_ = FALSE;
			}
			if (_tmp666_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp678_;
				ValaSemanticAnalyzer* _tmp679_;
				ValaSymbol* _tmp680_;
				ValaSymbol* _tmp681_;
				ValaParameter* _tmp690_;
				ValaMethod* _tmp691_;
				ValaBlock* _tmp692_;
				ValaBlock* _tmp693_;
				ValaParameter* _tmp694_;
				ValaParameterDirection _tmp695_;
				ValaParameterDirection _tmp696_;
				_tmp678_ = vala_code_context_get_analyzer (context);
				_tmp679_ = _tmp678_;
				_tmp680_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp679_);
				_tmp681_ = _tmp680_;
				sym = _tmp681_;
				while (TRUE) {
					ValaSymbol* _tmp682_;
					ValaMethod* _tmp683_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp684_;
					ValaMethod* _tmp685_;
					ValaSymbol* _tmp687_;
					ValaSymbol* _tmp688_;
					ValaSymbol* _tmp689_;
					_tmp682_ = sym;
					_tmp683_ = m;
					if (!(_tmp682_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp683_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp684_ = sym;
					method = VALA_IS_METHOD (_tmp684_) ? ((ValaMethod*) _tmp684_) : NULL;
					_tmp685_ = method;
					if (_tmp685_ != NULL) {
						ValaMethod* _tmp686_;
						_tmp686_ = method;
						vala_method_set_closure (_tmp686_, TRUE);
					}
					_tmp687_ = sym;
					_tmp688_ = vala_symbol_get_parent_symbol (_tmp687_);
					_tmp689_ = _tmp688_;
					sym = _tmp689_;
				}
				_tmp690_ = param;
				vala_parameter_set_captured (_tmp690_, TRUE);
				_tmp691_ = m;
				_tmp692_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp691_);
				_tmp693_ = _tmp692_;
				vala_block_set_captured (_tmp693_, TRUE);
				_tmp694_ = param;
				_tmp695_ = vala_parameter_get_direction (_tmp694_);
				_tmp696_ = _tmp695_;
				if (_tmp696_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp697_;
					ValaSourceReference* _tmp698_;
					ValaParameter* _tmp699_;
					gchar* _tmp700_;
					gchar* _tmp701_;
					gchar* _tmp702_;
					gchar* _tmp703_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp697_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp698_ = _tmp697_;
					_tmp699_ = param;
					_tmp700_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp699_);
					_tmp701_ = _tmp700_;
					_tmp702_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp701_);
					_tmp703_ = _tmp702_;
					vala_report_error (_tmp698_, _tmp703_);
					_g_free0 (_tmp703_);
					_g_free0 (_tmp701_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp704_;
				ValaSymbol* _tmp705_;
				ValaSymbol* _tmp706_;
				ValaSymbol* _tmp707_;
				ValaSymbol* _tmp708_;
				gboolean _tmp709_ = FALSE;
				gboolean _tmp710_ = FALSE;
				ValaPropertyAccessor* _tmp711_;
				_tmp704_ = param;
				_tmp705_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp704_);
				_tmp706_ = _tmp705_;
				_tmp707_ = vala_symbol_get_parent_symbol (_tmp706_);
				_tmp708_ = _tmp707_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp708_) ? ((ValaPropertyAccessor*) _tmp708_) : NULL;
				_tmp711_ = acc;
				if (_tmp711_ != NULL) {
					ValaPropertyAccessor* _tmp712_;
					ValaSemanticAnalyzer* _tmp713_;
					ValaSemanticAnalyzer* _tmp714_;
					ValaSymbol* _tmp715_;
					ValaSymbol* _tmp716_;
					_tmp712_ = acc;
					_tmp713_ = vala_code_context_get_analyzer (context);
					_tmp714_ = _tmp713_;
					_tmp715_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp714_);
					_tmp716_ = _tmp715_;
					_tmp710_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp712_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp716_;
				} else {
					_tmp710_ = FALSE;
				}
				if (_tmp710_) {
					ValaParameter* _tmp717_;
					ValaPropertyAccessor* _tmp718_;
					ValaProperty* _tmp719_;
					ValaProperty* _tmp720_;
					ValaParameter* _tmp721_;
					ValaParameter* _tmp722_;
					_tmp717_ = param;
					_tmp718_ = acc;
					_tmp719_ = vala_property_accessor_get_prop (_tmp718_);
					_tmp720_ = _tmp719_;
					_tmp721_ = vala_property_get_this_parameter (_tmp720_);
					_tmp722_ = _tmp721_;
					_tmp709_ = _tmp717_ != _tmp722_;
				} else {
					_tmp709_ = FALSE;
				}
				if (_tmp709_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp723_;
					ValaSemanticAnalyzer* _tmp724_;
					ValaSymbol* _tmp725_;
					ValaSymbol* _tmp726_;
					ValaParameter* _tmp735_;
					ValaPropertyAccessor* _tmp736_;
					ValaBlock* _tmp737_;
					ValaBlock* _tmp738_;
					_tmp723_ = vala_code_context_get_analyzer (context);
					_tmp724_ = _tmp723_;
					_tmp725_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp724_);
					_tmp726_ = _tmp725_;
					sym = _tmp726_;
					while (TRUE) {
						ValaSymbol* _tmp727_;
						ValaMethod* _tmp728_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp729_;
						ValaMethod* _tmp730_;
						ValaSymbol* _tmp732_;
						ValaSymbol* _tmp733_;
						ValaSymbol* _tmp734_;
						_tmp727_ = sym;
						_tmp728_ = m;
						if (!(_tmp727_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp728_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp729_ = sym;
						method = VALA_IS_METHOD (_tmp729_) ? ((ValaMethod*) _tmp729_) : NULL;
						_tmp730_ = method;
						if (_tmp730_ != NULL) {
							ValaMethod* _tmp731_;
							_tmp731_ = method;
							vala_method_set_closure (_tmp731_, TRUE);
						}
						_tmp732_ = sym;
						_tmp733_ = vala_symbol_get_parent_symbol (_tmp732_);
						_tmp734_ = _tmp733_;
						sym = _tmp734_;
					}
					_tmp735_ = param;
					vala_parameter_set_captured (_tmp735_, TRUE);
					_tmp736_ = acc;
					_tmp737_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp736_);
					_tmp738_ = _tmp737_;
					vala_block_set_captured (_tmp738_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp739_;
			_tmp739_ = member;
			if (VALA_IS_FIELD (_tmp739_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp740_;
				ValaField* _tmp741_;
				ValaSymbolAccessibility _tmp742_;
				ValaSymbolAccessibility _tmp743_;
				ValaField* _tmp744_;
				ValaMemberBinding _tmp745_;
				ValaMemberBinding _tmp746_;
				ValaField* _tmp747_;
				ValaMemberBinding _tmp748_;
				ValaMemberBinding _tmp749_;
				ValaField* _tmp750_;
				ValaDataType* _tmp751_;
				ValaDataType* _tmp752_;
				_tmp740_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp740_, VALA_TYPE_FIELD, ValaField);
				_tmp741_ = f;
				_tmp742_ = vala_symbol_get_access ((ValaSymbol*) _tmp741_);
				_tmp743_ = _tmp742_;
				access = _tmp743_;
				_tmp744_ = f;
				_tmp745_ = vala_field_get_binding (_tmp744_);
				_tmp746_ = _tmp745_;
				instance = _tmp746_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp747_ = f;
				_tmp748_ = vala_field_get_binding (_tmp747_);
				_tmp749_ = _tmp748_;
				klass = _tmp749_ == VALA_MEMBER_BINDING_CLASS;
				_tmp750_ = f;
				_tmp751_ = vala_variable_get_variable_type ((ValaVariable*) _tmp750_);
				_tmp752_ = _tmp751_;
				if (VALA_IS_GENERIC_TYPE (_tmp752_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp753_;
				_tmp753_ = member;
				if (VALA_IS_CONSTANT (_tmp753_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp754_;
					ValaConstant* _tmp755_;
					ValaSymbolAccessibility _tmp756_;
					ValaSymbolAccessibility _tmp757_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp758_;
					ValaSymbol* _tmp759_;
					ValaSymbol* _tmp760_;
					gboolean _tmp761_ = FALSE;
					ValaBlock* _tmp762_;
					_tmp754_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp754_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp755_ = c;
					_tmp756_ = vala_symbol_get_access ((ValaSymbol*) _tmp755_);
					_tmp757_ = _tmp756_;
					access = _tmp757_;
					_tmp758_ = c;
					_tmp759_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp758_);
					_tmp760_ = _tmp759_;
					block = VALA_IS_BLOCK (_tmp760_) ? ((ValaBlock*) _tmp760_) : NULL;
					_tmp762_ = block;
					if (_tmp762_ != NULL) {
						ValaBlock* _tmp763_;
						ValaSymbol* _tmp764_;
						ValaSemanticAnalyzer* _tmp765_;
						ValaSemanticAnalyzer* _tmp766_;
						ValaSymbol* _tmp767_;
						ValaSymbol* _tmp768_;
						_tmp763_ = block;
						_tmp764_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp763_);
						_tmp765_ = vala_code_context_get_analyzer (context);
						_tmp766_ = _tmp765_;
						_tmp767_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp766_);
						_tmp768_ = _tmp767_;
						_tmp761_ = _tmp764_ != _tmp768_;
					} else {
						_tmp761_ = FALSE;
					}
					if (_tmp761_) {
						ValaSourceReference* _tmp769_;
						ValaSourceReference* _tmp770_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp769_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp770_ = _tmp769_;
						vala_report_error (_tmp770_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						return result;
					}
				} else {
					ValaSymbol* _tmp771_;
					_tmp771_ = member;
					if (VALA_IS_METHOD (_tmp771_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp772_;
						ValaMethod* _tmp773_;
						gboolean _tmp774_;
						gboolean _tmp775_;
						ValaMethod* _tmp864_;
						ValaSymbolAccessibility _tmp865_;
						ValaSymbolAccessibility _tmp866_;
						ValaMethod* _tmp867_;
						ValaMethod* _tmp871_;
						ValaMemberBinding _tmp872_;
						ValaMemberBinding _tmp873_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp892_;
						ValaDataType* _tmp893_;
						ValaDataType* _tmp894_;
						gboolean _tmp895_ = FALSE;
						ValaGenericType* _tmp896_;
						_tmp772_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp772_, VALA_TYPE_METHOD, ValaMethod);
						_tmp773_ = m;
						_tmp774_ = vala_method_get_is_async_callback (_tmp773_);
						_tmp775_ = _tmp774_;
						if (_tmp775_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp776_;
							ValaSemanticAnalyzer* _tmp777_;
							ValaMethod* _tmp778_;
							ValaMethod* _tmp779_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp780_;
							ValaMethod* _tmp809_;
							ValaSemanticAnalyzer* _tmp810_;
							ValaSemanticAnalyzer* _tmp811_;
							ValaMethod* _tmp812_;
							ValaMethod* _tmp813_;
							ValaMethod* _tmp829_;
							ValaMethod* _tmp830_;
							ValaMethod* _tmp831_;
							ValaSymbol* _tmp832_;
							ValaSymbol* _tmp833_;
							_tmp776_ = vala_code_context_get_analyzer (context);
							_tmp777_ = _tmp776_;
							_tmp778_ = vala_semantic_analyzer_get_current_async_method (_tmp777_);
							_tmp779_ = _tmp778_;
							async_method = _tmp779_;
							is_valid_access = FALSE;
							_tmp780_ = async_method;
							if (_tmp780_ != NULL) {
								ValaMethod* _tmp781_;
								ValaMethod* _tmp782_;
								ValaMethod* _tmp783_;
								_tmp781_ = m;
								_tmp782_ = async_method;
								_tmp783_ = vala_method_get_callback_method (_tmp782_);
								if (_tmp781_ == _tmp783_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp784_ = FALSE;
									ValaMethod* _tmp785_;
									ValaMethod* _tmp786_;
									ValaMethod* _tmp787_;
									_tmp785_ = async_method;
									_tmp786_ = vala_method_get_base_method (_tmp785_);
									_tmp787_ = _tmp786_;
									if (_tmp787_ != NULL) {
										ValaMethod* _tmp788_;
										ValaMethod* _tmp789_;
										ValaMethod* _tmp790_;
										ValaMethod* _tmp791_;
										ValaMethod* _tmp792_;
										_tmp788_ = m;
										_tmp789_ = async_method;
										_tmp790_ = vala_method_get_base_method (_tmp789_);
										_tmp791_ = _tmp790_;
										_tmp792_ = vala_method_get_callback_method (_tmp791_);
										_tmp784_ = _tmp788_ == _tmp792_;
									} else {
										_tmp784_ = FALSE;
									}
									if (_tmp784_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp793_ = FALSE;
										ValaMethod* _tmp794_;
										ValaMethod* _tmp795_;
										ValaMethod* _tmp796_;
										_tmp794_ = async_method;
										_tmp795_ = vala_method_get_base_interface_method (_tmp794_);
										_tmp796_ = _tmp795_;
										if (_tmp796_ != NULL) {
											ValaMethod* _tmp797_;
											ValaMethod* _tmp798_;
											ValaMethod* _tmp799_;
											ValaMethod* _tmp800_;
											ValaMethod* _tmp801_;
											_tmp797_ = m;
											_tmp798_ = async_method;
											_tmp799_ = vala_method_get_base_interface_method (_tmp798_);
											_tmp800_ = _tmp799_;
											_tmp801_ = vala_method_get_callback_method (_tmp800_);
											_tmp793_ = _tmp797_ == _tmp801_;
										} else {
											_tmp793_ = FALSE;
										}
										if (_tmp793_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp802_;
								ValaSourceReference* _tmp803_;
								ValaMethod* _tmp804_;
								gchar* _tmp805_;
								gchar* _tmp806_;
								gchar* _tmp807_;
								gchar* _tmp808_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp802_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp803_ = _tmp802_;
								_tmp804_ = m;
								_tmp805_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp804_);
								_tmp806_ = _tmp805_;
								_tmp807_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp806_);
								_tmp808_ = _tmp807_;
								vala_report_error (_tmp803_, _tmp808_);
								_g_free0 (_tmp808_);
								_g_free0 (_tmp806_);
								result = FALSE;
								return result;
							}
							_tmp809_ = async_method;
							_tmp810_ = vala_code_context_get_analyzer (context);
							_tmp811_ = _tmp810_;
							_tmp812_ = vala_semantic_analyzer_get_current_method (_tmp811_);
							_tmp813_ = _tmp812_;
							if (_tmp809_ != _tmp813_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp814_;
								ValaSemanticAnalyzer* _tmp815_;
								ValaMethod* _tmp816_;
								ValaMethod* _tmp817_;
								ValaMethod* _tmp826_;
								ValaBlock* _tmp827_;
								ValaBlock* _tmp828_;
								_tmp814_ = vala_code_context_get_analyzer (context);
								_tmp815_ = _tmp814_;
								_tmp816_ = vala_semantic_analyzer_get_current_method (_tmp815_);
								_tmp817_ = _tmp816_;
								sym = (ValaSymbol*) _tmp817_;
								while (TRUE) {
									ValaSymbol* _tmp818_;
									ValaMethod* _tmp819_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp820_;
									ValaMethod* _tmp821_;
									ValaSymbol* _tmp823_;
									ValaSymbol* _tmp824_;
									ValaSymbol* _tmp825_;
									_tmp818_ = sym;
									_tmp819_ = async_method;
									if (!(_tmp818_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp819_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp820_ = sym;
									method = VALA_IS_METHOD (_tmp820_) ? ((ValaMethod*) _tmp820_) : NULL;
									_tmp821_ = method;
									if (_tmp821_ != NULL) {
										ValaMethod* _tmp822_;
										_tmp822_ = method;
										vala_method_set_closure (_tmp822_, TRUE);
									}
									_tmp823_ = sym;
									_tmp824_ = vala_symbol_get_parent_symbol (_tmp823_);
									_tmp825_ = _tmp824_;
									sym = _tmp825_;
								}
								_tmp826_ = async_method;
								_tmp827_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp826_);
								_tmp828_ = _tmp827_;
								vala_block_set_captured (_tmp828_, TRUE);
							}
							_tmp829_ = async_method;
							_tmp830_ = vala_method_get_callback_method (_tmp829_);
							m = _tmp830_;
							_tmp831_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp831_);
							_tmp832_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp833_ = _tmp832_;
							member = _tmp833_;
						} else {
							ValaMethod* _tmp834_;
							ValaMethod* _tmp835_;
							ValaMethod* _tmp836_;
							_tmp834_ = m;
							_tmp835_ = vala_method_get_base_method (_tmp834_);
							_tmp836_ = _tmp835_;
							if (_tmp836_ != NULL) {
								ValaMethod* _tmp837_;
								ValaMethod* _tmp838_;
								ValaMethod* _tmp839_;
								ValaMethod* _tmp840_;
								ValaSignal* _tmp841_;
								ValaSignal* _tmp842_;
								ValaSymbol* _tmp847_;
								ValaSymbol* _tmp848_;
								_tmp837_ = m;
								_tmp838_ = vala_method_get_base_method (_tmp837_);
								_tmp839_ = _tmp838_;
								m = _tmp839_;
								_tmp840_ = m;
								_tmp841_ = vala_method_get_signal_reference (_tmp840_);
								_tmp842_ = _tmp841_;
								if (_tmp842_ != NULL) {
									ValaMethod* _tmp843_;
									ValaSignal* _tmp844_;
									ValaSignal* _tmp845_;
									_tmp843_ = m;
									_tmp844_ = vala_method_get_signal_reference (_tmp843_);
									_tmp845_ = _tmp844_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp845_);
								} else {
									ValaMethod* _tmp846_;
									_tmp846_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp846_);
								}
								_tmp847_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp848_ = _tmp847_;
								member = _tmp848_;
							} else {
								ValaMethod* _tmp849_;
								ValaMethod* _tmp850_;
								ValaMethod* _tmp851_;
								_tmp849_ = m;
								_tmp850_ = vala_method_get_base_interface_method (_tmp849_);
								_tmp851_ = _tmp850_;
								if (_tmp851_ != NULL) {
									ValaMethod* _tmp852_;
									ValaMethod* _tmp853_;
									ValaMethod* _tmp854_;
									ValaMethod* _tmp855_;
									ValaSignal* _tmp856_;
									ValaSignal* _tmp857_;
									ValaSymbol* _tmp862_;
									ValaSymbol* _tmp863_;
									_tmp852_ = m;
									_tmp853_ = vala_method_get_base_interface_method (_tmp852_);
									_tmp854_ = _tmp853_;
									m = _tmp854_;
									_tmp855_ = m;
									_tmp856_ = vala_method_get_signal_reference (_tmp855_);
									_tmp857_ = _tmp856_;
									if (_tmp857_ != NULL) {
										ValaMethod* _tmp858_;
										ValaSignal* _tmp859_;
										ValaSignal* _tmp860_;
										_tmp858_ = m;
										_tmp859_ = vala_method_get_signal_reference (_tmp858_);
										_tmp860_ = _tmp859_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp860_);
									} else {
										ValaMethod* _tmp861_;
										_tmp861_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp861_);
									}
									_tmp862_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp863_ = _tmp862_;
									member = _tmp863_;
								}
							}
						}
						_tmp864_ = m;
						_tmp865_ = vala_symbol_get_access ((ValaSymbol*) _tmp864_);
						_tmp866_ = _tmp865_;
						access = _tmp866_;
						_tmp867_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp867_)) {
							ValaMethod* _tmp868_;
							ValaMemberBinding _tmp869_;
							ValaMemberBinding _tmp870_;
							_tmp868_ = m;
							_tmp869_ = vala_method_get_binding (_tmp868_);
							_tmp870_ = _tmp869_;
							instance = _tmp870_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp871_ = m;
						_tmp872_ = vala_method_get_binding (_tmp871_);
						_tmp873_ = _tmp872_;
						klass = _tmp873_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp874_;
							ValaList* _tmp875_;
							ValaList* _tmp876_;
							gint _param_size = 0;
							ValaList* _tmp877_;
							gint _tmp878_;
							gint _tmp879_;
							gint _param_index = 0;
							_tmp874_ = m;
							_tmp875_ = vala_callable_get_parameters ((ValaCallable*) _tmp874_);
							_tmp876_ = _vala_iterable_ref0 (_tmp875_);
							_param_list = _tmp876_;
							_tmp877_ = _param_list;
							_tmp878_ = vala_collection_get_size ((ValaCollection*) _tmp877_);
							_tmp879_ = _tmp878_;
							_param_size = _tmp879_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp880_;
								gpointer _tmp881_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp882_;
								ValaDataType* _tmp883_;
								ValaDataType* _tmp884_;
								gboolean _tmp885_ = FALSE;
								ValaGenericType* _tmp886_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp880_ = _param_list;
								_tmp881_ = vala_list_get (_tmp880_, _param_index);
								param = (ValaParameter*) _tmp881_;
								_tmp882_ = param;
								_tmp883_ = vala_variable_get_variable_type ((ValaVariable*) _tmp882_);
								_tmp884_ = _tmp883_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp884_) ? ((ValaGenericType*) _tmp884_) : NULL;
								_tmp886_ = generic_type;
								if (_tmp886_ != NULL) {
									ValaGenericType* _tmp887_;
									ValaTypeParameter* _tmp888_;
									ValaTypeParameter* _tmp889_;
									ValaSymbol* _tmp890_;
									ValaSymbol* _tmp891_;
									_tmp887_ = generic_type;
									_tmp888_ = vala_generic_type_get_type_parameter (_tmp887_);
									_tmp889_ = _tmp888_;
									_tmp890_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp889_);
									_tmp891_ = _tmp890_;
									_tmp885_ = VALA_IS_TYPESYMBOL (_tmp891_);
								} else {
									_tmp885_ = FALSE;
								}
								if (_tmp885_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp892_ = m;
						_tmp893_ = vala_callable_get_return_type ((ValaCallable*) _tmp892_);
						_tmp894_ = _tmp893_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp894_) ? ((ValaGenericType*) _tmp894_) : NULL;
						_tmp896_ = generic_type;
						if (_tmp896_ != NULL) {
							ValaGenericType* _tmp897_;
							ValaTypeParameter* _tmp898_;
							ValaTypeParameter* _tmp899_;
							ValaSymbol* _tmp900_;
							ValaSymbol* _tmp901_;
							_tmp897_ = generic_type;
							_tmp898_ = vala_generic_type_get_type_parameter (_tmp897_);
							_tmp899_ = _tmp898_;
							_tmp900_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp899_);
							_tmp901_ = _tmp900_;
							_tmp895_ = VALA_IS_TYPESYMBOL (_tmp901_);
						} else {
							_tmp895_ = FALSE;
						}
						if (_tmp895_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp902_;
						_tmp902_ = member;
						if (VALA_IS_PROPERTY (_tmp902_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp903_;
							ValaProperty* _tmp904_;
							ValaProperty* _tmp905_;
							ValaProperty* _tmp906_;
							ValaProperty* _tmp907_;
							ValaProperty* _tmp923_;
							ValaSymbolAccessibility _tmp924_;
							ValaSymbolAccessibility _tmp925_;
							gboolean _tmp926_;
							gboolean _tmp927_;
							ValaProperty* _tmp992_;
							ValaMemberBinding _tmp993_;
							ValaMemberBinding _tmp994_;
							ValaProperty* _tmp995_;
							ValaDataType* _tmp996_;
							ValaDataType* _tmp997_;
							_tmp903_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp903_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp904_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp904_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp905_ = prop;
							_tmp906_ = vala_property_get_base_property (_tmp905_);
							_tmp907_ = _tmp906_;
							if (_tmp907_ != NULL) {
								ValaProperty* _tmp908_;
								ValaProperty* _tmp909_;
								ValaProperty* _tmp910_;
								ValaProperty* _tmp911_;
								ValaSymbol* _tmp912_;
								ValaSymbol* _tmp913_;
								_tmp908_ = prop;
								_tmp909_ = vala_property_get_base_property (_tmp908_);
								_tmp910_ = _tmp909_;
								prop = _tmp910_;
								_tmp911_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp911_);
								_tmp912_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp913_ = _tmp912_;
								member = _tmp913_;
							} else {
								ValaProperty* _tmp914_;
								ValaProperty* _tmp915_;
								ValaProperty* _tmp916_;
								_tmp914_ = prop;
								_tmp915_ = vala_property_get_base_interface_property (_tmp914_);
								_tmp916_ = _tmp915_;
								if (_tmp916_ != NULL) {
									ValaProperty* _tmp917_;
									ValaProperty* _tmp918_;
									ValaProperty* _tmp919_;
									ValaProperty* _tmp920_;
									ValaSymbol* _tmp921_;
									ValaSymbol* _tmp922_;
									_tmp917_ = prop;
									_tmp918_ = vala_property_get_base_interface_property (_tmp917_);
									_tmp919_ = _tmp918_;
									prop = _tmp919_;
									_tmp920_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp920_);
									_tmp921_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp922_ = _tmp921_;
									member = _tmp922_;
								}
							}
							_tmp923_ = prop;
							_tmp924_ = vala_symbol_get_access ((ValaSymbol*) _tmp923_);
							_tmp925_ = _tmp924_;
							access = _tmp925_;
							_tmp926_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp927_ = _tmp926_;
							if (_tmp927_) {
								ValaProperty* _tmp928_;
								ValaPropertyAccessor* _tmp929_;
								ValaPropertyAccessor* _tmp930_;
								ValaProperty* _tmp938_;
								ValaSymbolAccessibility _tmp939_;
								ValaSymbolAccessibility _tmp940_;
								_tmp928_ = prop;
								_tmp929_ = vala_property_get_set_accessor (_tmp928_);
								_tmp930_ = _tmp929_;
								if (_tmp930_ == NULL) {
									ValaSourceReference* _tmp931_;
									ValaSourceReference* _tmp932_;
									ValaProperty* _tmp933_;
									gchar* _tmp934_;
									gchar* _tmp935_;
									gchar* _tmp936_;
									gchar* _tmp937_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp931_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp932_ = _tmp931_;
									_tmp933_ = prop;
									_tmp934_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp933_);
									_tmp935_ = _tmp934_;
									_tmp936_ = g_strdup_printf ("Property `%s' is read-only", _tmp935_);
									_tmp937_ = _tmp936_;
									vala_report_error (_tmp932_, _tmp937_);
									_g_free0 (_tmp937_);
									_g_free0 (_tmp935_);
									result = FALSE;
									return result;
								}
								_tmp938_ = prop;
								_tmp939_ = vala_symbol_get_access ((ValaSymbol*) _tmp938_);
								_tmp940_ = _tmp939_;
								if (_tmp940_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp941_;
									ValaPropertyAccessor* _tmp942_;
									ValaPropertyAccessor* _tmp943_;
									ValaSymbolAccessibility _tmp944_;
									ValaSymbolAccessibility _tmp945_;
									_tmp941_ = prop;
									_tmp942_ = vala_property_get_set_accessor (_tmp941_);
									_tmp943_ = _tmp942_;
									_tmp944_ = vala_symbol_get_access ((ValaSymbol*) _tmp943_);
									_tmp945_ = _tmp944_;
									access = _tmp945_;
								} else {
									gboolean _tmp946_ = FALSE;
									ValaProperty* _tmp947_;
									ValaSymbolAccessibility _tmp948_;
									ValaSymbolAccessibility _tmp949_;
									_tmp947_ = prop;
									_tmp948_ = vala_symbol_get_access ((ValaSymbol*) _tmp947_);
									_tmp949_ = _tmp948_;
									if (_tmp949_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp950_;
										ValaPropertyAccessor* _tmp951_;
										ValaPropertyAccessor* _tmp952_;
										ValaSymbolAccessibility _tmp953_;
										ValaSymbolAccessibility _tmp954_;
										_tmp950_ = prop;
										_tmp951_ = vala_property_get_set_accessor (_tmp950_);
										_tmp952_ = _tmp951_;
										_tmp953_ = vala_symbol_get_access ((ValaSymbol*) _tmp952_);
										_tmp954_ = _tmp953_;
										_tmp946_ = _tmp954_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp946_ = FALSE;
									}
									if (_tmp946_) {
										ValaProperty* _tmp955_;
										ValaPropertyAccessor* _tmp956_;
										ValaPropertyAccessor* _tmp957_;
										ValaSymbolAccessibility _tmp958_;
										ValaSymbolAccessibility _tmp959_;
										_tmp955_ = prop;
										_tmp956_ = vala_property_get_set_accessor (_tmp955_);
										_tmp957_ = _tmp956_;
										_tmp958_ = vala_symbol_get_access ((ValaSymbol*) _tmp957_);
										_tmp959_ = _tmp958_;
										access = _tmp959_;
									}
								}
							} else {
								ValaProperty* _tmp960_;
								ValaPropertyAccessor* _tmp961_;
								ValaPropertyAccessor* _tmp962_;
								ValaProperty* _tmp970_;
								ValaSymbolAccessibility _tmp971_;
								ValaSymbolAccessibility _tmp972_;
								_tmp960_ = prop;
								_tmp961_ = vala_property_get_get_accessor (_tmp960_);
								_tmp962_ = _tmp961_;
								if (_tmp962_ == NULL) {
									ValaSourceReference* _tmp963_;
									ValaSourceReference* _tmp964_;
									ValaProperty* _tmp965_;
									gchar* _tmp966_;
									gchar* _tmp967_;
									gchar* _tmp968_;
									gchar* _tmp969_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp963_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp964_ = _tmp963_;
									_tmp965_ = prop;
									_tmp966_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp965_);
									_tmp967_ = _tmp966_;
									_tmp968_ = g_strdup_printf ("Property `%s' is write-only", _tmp967_);
									_tmp969_ = _tmp968_;
									vala_report_error (_tmp964_, _tmp969_);
									_g_free0 (_tmp969_);
									_g_free0 (_tmp967_);
									result = FALSE;
									return result;
								}
								_tmp970_ = prop;
								_tmp971_ = vala_symbol_get_access ((ValaSymbol*) _tmp970_);
								_tmp972_ = _tmp971_;
								if (_tmp972_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp973_;
									ValaPropertyAccessor* _tmp974_;
									ValaPropertyAccessor* _tmp975_;
									ValaSymbolAccessibility _tmp976_;
									ValaSymbolAccessibility _tmp977_;
									_tmp973_ = prop;
									_tmp974_ = vala_property_get_get_accessor (_tmp973_);
									_tmp975_ = _tmp974_;
									_tmp976_ = vala_symbol_get_access ((ValaSymbol*) _tmp975_);
									_tmp977_ = _tmp976_;
									access = _tmp977_;
								} else {
									gboolean _tmp978_ = FALSE;
									ValaProperty* _tmp979_;
									ValaSymbolAccessibility _tmp980_;
									ValaSymbolAccessibility _tmp981_;
									_tmp979_ = prop;
									_tmp980_ = vala_symbol_get_access ((ValaSymbol*) _tmp979_);
									_tmp981_ = _tmp980_;
									if (_tmp981_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp982_;
										ValaPropertyAccessor* _tmp983_;
										ValaPropertyAccessor* _tmp984_;
										ValaSymbolAccessibility _tmp985_;
										ValaSymbolAccessibility _tmp986_;
										_tmp982_ = prop;
										_tmp983_ = vala_property_get_get_accessor (_tmp982_);
										_tmp984_ = _tmp983_;
										_tmp985_ = vala_symbol_get_access ((ValaSymbol*) _tmp984_);
										_tmp986_ = _tmp985_;
										_tmp978_ = _tmp986_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp978_ = FALSE;
									}
									if (_tmp978_) {
										ValaProperty* _tmp987_;
										ValaPropertyAccessor* _tmp988_;
										ValaPropertyAccessor* _tmp989_;
										ValaSymbolAccessibility _tmp990_;
										ValaSymbolAccessibility _tmp991_;
										_tmp987_ = prop;
										_tmp988_ = vala_property_get_get_accessor (_tmp987_);
										_tmp989_ = _tmp988_;
										_tmp990_ = vala_symbol_get_access ((ValaSymbol*) _tmp989_);
										_tmp991_ = _tmp990_;
										access = _tmp991_;
									}
								}
							}
							_tmp992_ = prop;
							_tmp993_ = vala_property_get_binding (_tmp992_);
							_tmp994_ = _tmp993_;
							instance = _tmp994_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp995_ = prop;
							_tmp996_ = vala_property_get_property_type (_tmp995_);
							_tmp997_ = _tmp996_;
							if (VALA_IS_GENERIC_TYPE (_tmp997_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp998_;
							_tmp998_ = member;
							if (VALA_IS_SIGNAL (_tmp998_)) {
								ValaSymbol* _tmp999_;
								ValaSymbolAccessibility _tmp1000_;
								ValaSymbolAccessibility _tmp1001_;
								instance = TRUE;
								_tmp999_ = member;
								_tmp1000_ = vala_symbol_get_access (_tmp999_);
								_tmp1001_ = _tmp1000_;
								access = _tmp1001_;
							} else {
								gboolean _tmp1002_ = FALSE;
								gboolean _tmp1003_;
								_tmp1003_ = self->priv->_creation_member;
								if (!_tmp1003_) {
									ValaSymbol* _tmp1004_;
									_tmp1004_ = member;
									_tmp1002_ = VALA_IS_ERROR_CODE (_tmp1004_);
								} else {
									_tmp1002_ = FALSE;
								}
								if (_tmp1002_) {
									ValaSymbol* _tmp1005_;
									ValaConstant* _tmp1006_;
									ValaConstant* _tmp1007_;
									ValaSymbol* _tmp1008_;
									ValaSymbol* _tmp1009_;
									_tmp1005_ = member;
									_tmp1006_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1005_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1007_ = _tmp1006_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1007_);
									_tmp1008_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1009_ = _tmp1008_;
									member = _tmp1009_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1010_;
		ValaSymbol* _tmp1011_;
		ValaCodeNode* _tmp1012_;
		ValaCodeNode* _tmp1013_;
		ValaCodeNode* _tmp1014_;
		gboolean _tmp1015_ = FALSE;
		ValaCodeNode* _tmp1016_;
		_tmp1010_ = parent;
		_tmp1011_ = member;
		if (!(_tmp1010_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1011_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1012_ = parent;
		_tmp1013_ = vala_code_node_get_parent_node (_tmp1012_);
		_tmp1014_ = _tmp1013_;
		parent = _tmp1014_;
		_tmp1016_ = parent;
		if (_tmp1016_ == NULL) {
			_tmp1015_ = TRUE;
		} else {
			ValaCodeNode* _tmp1017_;
			ValaSymbol* _tmp1018_;
			_tmp1017_ = parent;
			_tmp1018_ = member;
			_tmp1015_ = _tmp1017_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1018_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1015_) {
			break;
		}
	}
	_tmp1019_ = parent;
	_tmp1020_ = member;
	if (_tmp1019_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1020_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1021_;
		_tmp1021_ = member;
		vala_symbol_set_used (_tmp1021_, TRUE);
	}
	_tmp1022_ = member;
	_tmp1023_ = vala_symbol_get_version (_tmp1022_);
	_tmp1024_ = _tmp1023_;
	_tmp1025_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1026_ = _tmp1025_;
	vala_version_attribute_check (_tmp1024_, _tmp1026_);
	_tmp1028_ = access;
	if (_tmp1028_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1029_;
		ValaSymbol* _tmp1030_;
		ValaSymbol* _tmp1031_;
		_tmp1029_ = member;
		_tmp1030_ = vala_symbol_get_parent_symbol (_tmp1029_);
		_tmp1031_ = _tmp1030_;
		_tmp1027_ = VALA_IS_TYPESYMBOL (_tmp1031_);
	} else {
		_tmp1027_ = FALSE;
	}
	if (_tmp1027_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1032_;
		ValaSymbol* _tmp1033_;
		ValaSymbol* _tmp1034_;
		gboolean in_subtype = FALSE;
		_tmp1032_ = member;
		_tmp1033_ = vala_symbol_get_parent_symbol (_tmp1032_);
		_tmp1034_ = _tmp1033_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1034_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1035_;
			ValaSemanticAnalyzer* _tmp1036_;
			ValaSymbol* _tmp1037_;
			ValaSymbol* _tmp1038_;
			ValaSymbol* _tmp1039_;
			_tmp1035_ = vala_code_context_get_analyzer (context);
			_tmp1036_ = _tmp1035_;
			_tmp1037_ = vala_semantic_analyzer_get_current_symbol (_tmp1036_);
			_tmp1038_ = _tmp1037_;
			_tmp1039_ = _vala_code_node_ref0 (_tmp1038_);
			this_symbol = _tmp1039_;
			{
				gboolean _tmp1040_ = FALSE;
				_tmp1040_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1045_;
					ValaSymbol* _tmp1046_;
					ValaTypeSymbol* _tmp1047_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1048_;
					gboolean _tmp1049_ = FALSE;
					ValaClass* _tmp1050_;
					if (!_tmp1040_) {
						ValaSymbol* _tmp1041_;
						ValaSymbol* _tmp1042_;
						ValaSymbol* _tmp1043_;
						ValaSymbol* _tmp1044_;
						_tmp1041_ = this_symbol;
						_tmp1042_ = vala_symbol_get_parent_symbol (_tmp1041_);
						_tmp1043_ = _tmp1042_;
						_tmp1044_ = _vala_code_node_ref0 (_tmp1043_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1044_;
					}
					_tmp1040_ = FALSE;
					_tmp1045_ = this_symbol;
					if (!(_tmp1045_ != NULL)) {
						break;
					}
					_tmp1046_ = this_symbol;
					_tmp1047_ = target_type;
					if (_tmp1046_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1047_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1048_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1048_) ? ((ValaClass*) _tmp1048_) : NULL;
					_tmp1050_ = cl;
					if (_tmp1050_ != NULL) {
						ValaClass* _tmp1051_;
						ValaTypeSymbol* _tmp1052_;
						_tmp1051_ = cl;
						_tmp1052_ = target_type;
						_tmp1049_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1051_, _tmp1052_);
					} else {
						_tmp1049_ = FALSE;
					}
					if (_tmp1049_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1053_;
			ValaSourceReference* _tmp1054_;
			ValaSymbol* _tmp1055_;
			gchar* _tmp1056_;
			gchar* _tmp1057_;
			gchar* _tmp1058_;
			gchar* _tmp1059_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1053_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1054_ = _tmp1053_;
			_tmp1055_ = member;
			_tmp1056_ = vala_symbol_get_full_name (_tmp1055_);
			_tmp1057_ = _tmp1056_;
			_tmp1058_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1057_);
			_tmp1059_ = _tmp1058_;
			vala_report_error (_tmp1054_, _tmp1059_);
			_g_free0 (_tmp1059_);
			_g_free0 (_tmp1057_);
			result = FALSE;
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1060_;
		_tmp1060_ = access;
		if (_tmp1060_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1061_;
			ValaSymbol* _tmp1062_;
			ValaSymbol* _tmp1063_;
			gboolean in_target_type = FALSE;
			_tmp1061_ = member;
			_tmp1062_ = vala_symbol_get_parent_symbol (_tmp1061_);
			_tmp1063_ = _tmp1062_;
			target_type = _tmp1063_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1064_;
				ValaSemanticAnalyzer* _tmp1065_;
				ValaSymbol* _tmp1066_;
				ValaSymbol* _tmp1067_;
				ValaSymbol* _tmp1068_;
				_tmp1064_ = vala_code_context_get_analyzer (context);
				_tmp1065_ = _tmp1064_;
				_tmp1066_ = vala_semantic_analyzer_get_current_symbol (_tmp1065_);
				_tmp1067_ = _tmp1066_;
				_tmp1068_ = _vala_code_node_ref0 (_tmp1067_);
				this_symbol = _tmp1068_;
				{
					gboolean _tmp1069_ = FALSE;
					_tmp1069_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1074_;
						ValaSymbol* _tmp1075_;
						ValaSymbol* _tmp1076_;
						if (!_tmp1069_) {
							ValaSymbol* _tmp1070_;
							ValaSymbol* _tmp1071_;
							ValaSymbol* _tmp1072_;
							ValaSymbol* _tmp1073_;
							_tmp1070_ = this_symbol;
							_tmp1071_ = vala_symbol_get_parent_symbol (_tmp1070_);
							_tmp1072_ = _tmp1071_;
							_tmp1073_ = _vala_code_node_ref0 (_tmp1072_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1073_;
						}
						_tmp1069_ = FALSE;
						_tmp1074_ = this_symbol;
						if (!(_tmp1074_ != NULL)) {
							break;
						}
						_tmp1075_ = target_type;
						_tmp1076_ = this_symbol;
						if (_tmp1075_ == _tmp1076_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1077_;
				ValaSourceReference* _tmp1078_;
				ValaSymbol* _tmp1079_;
				gchar* _tmp1080_;
				gchar* _tmp1081_;
				gchar* _tmp1082_;
				gchar* _tmp1083_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1077_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1078_ = _tmp1077_;
				_tmp1079_ = member;
				_tmp1080_ = vala_symbol_get_full_name (_tmp1079_);
				_tmp1081_ = _tmp1080_;
				_tmp1082_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1081_);
				_tmp1083_ = _tmp1082_;
				vala_report_error (_tmp1078_, _tmp1083_);
				_g_free0 (_tmp1083_);
				_g_free0 (_tmp1081_);
				result = FALSE;
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1085_;
		ValaExpression* _tmp1086_;
		_tmp1085_ = vala_member_access_get_inner (self);
		_tmp1086_ = _tmp1085_;
		_tmp1084_ = _tmp1086_ != NULL;
	} else {
		_tmp1084_ = FALSE;
	}
	if (_tmp1084_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1087_;
		ValaExpression* _tmp1088_;
		ValaDataType* _tmp1089_;
		ValaDataType* _tmp1090_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1091_;
		ValaExpression* _tmp1092_;
		ValaDataType* _tmp1093_;
		ValaDataType* _tmp1094_;
		ValaPointerType* _tmp1095_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1099_;
		gboolean _tmp1100_ = FALSE;
		gboolean _tmp1101_ = FALSE;
		ValaObjectType* _tmp1102_;
		_tmp1087_ = vala_member_access_get_inner (self);
		_tmp1088_ = _tmp1087_;
		_tmp1089_ = vala_expression_get_value_type (_tmp1088_);
		_tmp1090_ = _tmp1089_;
		instance_type = _tmp1090_;
		_tmp1091_ = vala_member_access_get_inner (self);
		_tmp1092_ = _tmp1091_;
		_tmp1093_ = vala_expression_get_value_type (_tmp1092_);
		_tmp1094_ = _tmp1093_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1094_) ? ((ValaPointerType*) _tmp1094_) : NULL;
		_tmp1095_ = pointer_type;
		if (_tmp1095_ != NULL) {
			ValaPointerType* _tmp1096_;
			ValaDataType* _tmp1097_;
			ValaDataType* _tmp1098_;
			_tmp1096_ = pointer_type;
			_tmp1097_ = vala_pointer_type_get_base_type (_tmp1096_);
			_tmp1098_ = _tmp1097_;
			instance_type = _tmp1098_;
		}
		_tmp1099_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1099_) ? ((ValaObjectType*) _tmp1099_) : NULL;
		_tmp1102_ = object_type;
		if (_tmp1102_ != NULL) {
			ValaObjectType* _tmp1103_;
			ValaObjectTypeSymbol* _tmp1104_;
			ValaObjectTypeSymbol* _tmp1105_;
			_tmp1103_ = object_type;
			_tmp1104_ = vala_object_type_get_object_type_symbol (_tmp1103_);
			_tmp1105_ = _tmp1104_;
			_tmp1101_ = vala_object_type_symbol_has_type_parameters (_tmp1105_);
		} else {
			_tmp1101_ = FALSE;
		}
		if (_tmp1101_) {
			ValaDataType* _tmp1106_;
			_tmp1106_ = instance_type;
			_tmp1100_ = !vala_data_type_has_type_arguments (_tmp1106_);
		} else {
			_tmp1100_ = FALSE;
		}
		if (_tmp1100_) {
			ValaExpression* _tmp1107_;
			ValaExpression* _tmp1108_;
			ValaSourceReference* _tmp1109_;
			ValaSourceReference* _tmp1110_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1107_ = vala_member_access_get_inner (self);
			_tmp1108_ = _tmp1107_;
			_tmp1109_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1108_);
			_tmp1110_ = _tmp1109_;
			vala_report_error (_tmp1110_, "missing generic type arguments");
			result = FALSE;
			return result;
		}
	}
	if (instance) {
		_tmp1112_ = !may_access_instance_members;
	} else {
		_tmp1112_ = FALSE;
	}
	if (_tmp1112_) {
		_tmp1111_ = TRUE;
	} else {
		gboolean _tmp1113_ = FALSE;
		if (klass) {
			_tmp1113_ = !may_access_klass_members;
		} else {
			_tmp1113_ = FALSE;
		}
		_tmp1111_ = _tmp1113_;
	}
	if (_tmp1111_) {
		ValaSymbol* _tmp1114_;
		ValaSymbol* _tmp1115_;
		ValaDataType* _tmp1138_;
		ValaDataType* _tmp1139_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1114_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1115_ = _tmp1114_;
		if (VALA_IS_METHOD (_tmp1115_)) {
			ValaSemanticAnalyzer* _tmp1116_;
			ValaSemanticAnalyzer* _tmp1117_;
			ValaSymbol* _tmp1118_;
			ValaSymbol* _tmp1119_;
			gboolean _tmp1120_;
			gboolean _tmp1121_;
			ValaDataType* _tmp1122_;
			ValaDataType* _tmp1123_;
			_tmp1116_ = vala_code_context_get_analyzer (context);
			_tmp1117_ = _tmp1116_;
			_tmp1118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1119_ = _tmp1118_;
			_tmp1120_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1121_ = _tmp1120_;
			_tmp1122_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1117_, _tmp1119_, _tmp1121_);
			_tmp1123_ = _tmp1122_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1123_);
			_vala_code_node_unref0 (_tmp1123_);
		} else {
			ValaSymbol* _tmp1124_;
			ValaSymbol* _tmp1125_;
			_tmp1124_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1125_ = _tmp1124_;
			if (VALA_IS_FIELD (_tmp1125_)) {
				ValaSymbol* _tmp1126_;
				ValaSymbol* _tmp1127_;
				ValaFieldPrototype* _tmp1128_;
				ValaFieldPrototype* _tmp1129_;
				_tmp1126_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1127_ = _tmp1126_;
				_tmp1128_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1127_, VALA_TYPE_FIELD, ValaField));
				_tmp1129_ = _tmp1128_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1129_);
				_vala_code_node_unref0 (_tmp1129_);
			} else {
				ValaSymbol* _tmp1130_;
				ValaSymbol* _tmp1131_;
				_tmp1130_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1131_ = _tmp1130_;
				if (VALA_IS_PROPERTY (_tmp1131_)) {
					ValaSymbol* _tmp1132_;
					ValaSymbol* _tmp1133_;
					ValaPropertyPrototype* _tmp1134_;
					ValaPropertyPrototype* _tmp1135_;
					_tmp1132_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1133_ = _tmp1132_;
					_tmp1134_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1133_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1135_ = _tmp1134_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1135_);
					_vala_code_node_unref0 (_tmp1135_);
				} else {
					ValaInvalidType* _tmp1136_;
					ValaInvalidType* _tmp1137_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1136_ = vala_invalid_type_new ();
					_tmp1137_ = _tmp1136_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1137_);
					_vala_code_node_unref0 (_tmp1137_);
				}
			}
		}
		_tmp1138_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1139_ = _tmp1138_;
		if (_tmp1139_ != NULL) {
			ValaDataType* _tmp1140_;
			ValaDataType* _tmp1141_;
			ValaDataType* _tmp1142_;
			ValaDataType* _tmp1143_;
			gboolean _tmp1144_;
			gboolean _tmp1145_;
			_tmp1140_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1141_ = _tmp1140_;
			_tmp1142_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1143_ = _tmp1142_;
			_tmp1144_ = vala_data_type_get_value_owned (_tmp1143_);
			_tmp1145_ = _tmp1144_;
			vala_data_type_set_value_owned (_tmp1141_, _tmp1145_);
		}
	} else {
		gboolean _tmp1146_ = FALSE;
		gboolean _tmp1167_ = FALSE;
		gboolean _tmp1168_ = FALSE;
		gboolean _tmp1169_ = FALSE;
		gboolean _tmp1170_ = FALSE;
		gboolean _tmp1187_ = FALSE;
		gboolean _tmp1188_ = FALSE;
		gboolean _tmp1189_ = FALSE;
		gboolean _tmp1190_ = FALSE;
		gboolean _tmp1191_ = FALSE;
		gboolean _tmp1192_;
		gboolean _tmp1193_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1220_;
		ValaSymbol* _tmp1221_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1222_;
		ValaExpression* _tmp1223_;
		gboolean _tmp1224_ = FALSE;
		gboolean _tmp1225_ = FALSE;
		gboolean _tmp1226_ = FALSE;
		gboolean _tmp1227_ = FALSE;
		gboolean _tmp1228_ = FALSE;
		ValaMethod* _tmp1229_;
		ValaSemanticAnalyzer* _tmp1266_;
		ValaSemanticAnalyzer* _tmp1267_;
		ValaSymbol* _tmp1268_;
		ValaSymbol* _tmp1269_;
		gboolean _tmp1270_;
		gboolean _tmp1271_;
		ValaDataType* _tmp1272_;
		ValaDataType* _tmp1273_;
		gboolean _tmp1274_ = FALSE;
		ValaExpression* _tmp1275_;
		ValaExpression* _tmp1276_;
		ValaSymbol* _tmp1289_;
		ValaSymbol* _tmp1290_;
		if (instance) {
			ValaExpression* _tmp1147_;
			ValaExpression* _tmp1148_;
			_tmp1147_ = vala_member_access_get_inner (self);
			_tmp1148_ = _tmp1147_;
			_tmp1146_ = _tmp1148_ == NULL;
		} else {
			_tmp1146_ = FALSE;
		}
		if (_tmp1146_) {
			ValaSourceReference* _tmp1149_;
			ValaSourceReference* _tmp1150_;
			ValaMemberAccess* _tmp1151_;
			ValaMemberAccess* _tmp1152_;
			ValaExpression* _tmp1153_;
			ValaExpression* _tmp1154_;
			ValaParameter* _tmp1155_;
			ValaDataType* _tmp1156_;
			ValaDataType* _tmp1157_;
			ValaDataType* _tmp1158_;
			ValaDataType* _tmp1159_;
			ValaExpression* _tmp1160_;
			ValaExpression* _tmp1161_;
			ValaDataType* _tmp1162_;
			ValaDataType* _tmp1163_;
			ValaExpression* _tmp1164_;
			ValaExpression* _tmp1165_;
			ValaParameter* _tmp1166_;
			_tmp1149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1150_ = _tmp1149_;
			_tmp1151_ = vala_member_access_new (NULL, "this", _tmp1150_);
			_tmp1152_ = _tmp1151_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1152_);
			_vala_code_node_unref0 (_tmp1152_);
			_tmp1153_ = vala_member_access_get_inner (self);
			_tmp1154_ = _tmp1153_;
			_tmp1155_ = this_parameter;
			_tmp1156_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1155_);
			_tmp1157_ = _tmp1156_;
			_tmp1158_ = vala_data_type_copy (_tmp1157_);
			_tmp1159_ = _tmp1158_;
			vala_expression_set_value_type (_tmp1154_, _tmp1159_);
			_vala_code_node_unref0 (_tmp1159_);
			_tmp1160_ = vala_member_access_get_inner (self);
			_tmp1161_ = _tmp1160_;
			_tmp1162_ = vala_expression_get_value_type (_tmp1161_);
			_tmp1163_ = _tmp1162_;
			vala_data_type_set_value_owned (_tmp1163_, FALSE);
			_tmp1164_ = vala_member_access_get_inner (self);
			_tmp1165_ = _tmp1164_;
			_tmp1166_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1165_, (ValaSymbol*) _tmp1166_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1170_ = !klass;
		} else {
			_tmp1170_ = FALSE;
		}
		if (_tmp1170_) {
			ValaSymbol* _tmp1171_;
			ValaSymbol* _tmp1172_;
			_tmp1171_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1172_ = _tmp1171_;
			_tmp1169_ = !VALA_IS_CREATION_METHOD (_tmp1172_);
		} else {
			_tmp1169_ = FALSE;
		}
		if (_tmp1169_) {
			_tmp1168_ = may_access_instance_members;
		} else {
			_tmp1168_ = FALSE;
		}
		if (_tmp1168_) {
			ValaExpression* _tmp1173_;
			ValaExpression* _tmp1174_;
			_tmp1173_ = vala_member_access_get_inner (self);
			_tmp1174_ = _tmp1173_;
			_tmp1167_ = _tmp1174_ != NULL;
		} else {
			_tmp1167_ = FALSE;
		}
		if (_tmp1167_) {
			ValaExpression* _tmp1175_;
			ValaExpression* _tmp1176_;
			ValaSymbol* _tmp1177_;
			ValaSymbol* _tmp1178_;
			_tmp1175_ = vala_member_access_get_inner (self);
			_tmp1176_ = _tmp1175_;
			_tmp1177_ = vala_expression_get_symbol_reference (_tmp1176_);
			_tmp1178_ = _tmp1177_;
			if (VALA_IS_METHOD (_tmp1178_)) {
			} else {
				ValaSourceReference* _tmp1179_;
				ValaSourceReference* _tmp1180_;
				ValaSymbol* _tmp1181_;
				ValaSymbol* _tmp1182_;
				gchar* _tmp1183_;
				gchar* _tmp1184_;
				gchar* _tmp1185_;
				gchar* _tmp1186_;
				_tmp1179_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1180_ = _tmp1179_;
				_tmp1181_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1182_ = _tmp1181_;
				_tmp1183_ = vala_symbol_get_full_name (_tmp1182_);
				_tmp1184_ = _tmp1183_;
				_tmp1185_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1184_);
				_tmp1186_ = _tmp1185_;
				vala_report_warning (_tmp1180_, _tmp1186_);
				_g_free0 (_tmp1186_);
				_g_free0 (_tmp1184_);
			}
		}
		_tmp1192_ = vala_code_context_get_experimental_non_null (context);
		_tmp1193_ = _tmp1192_;
		if (_tmp1193_) {
			_tmp1191_ = instance;
		} else {
			_tmp1191_ = FALSE;
		}
		if (_tmp1191_) {
			ValaExpression* _tmp1194_;
			ValaExpression* _tmp1195_;
			ValaDataType* _tmp1196_;
			ValaDataType* _tmp1197_;
			gboolean _tmp1198_;
			gboolean _tmp1199_;
			_tmp1194_ = vala_member_access_get_inner (self);
			_tmp1195_ = _tmp1194_;
			_tmp1196_ = vala_expression_get_value_type (_tmp1195_);
			_tmp1197_ = _tmp1196_;
			_tmp1198_ = vala_data_type_get_nullable (_tmp1197_);
			_tmp1199_ = _tmp1198_;
			_tmp1190_ = _tmp1199_;
		} else {
			_tmp1190_ = FALSE;
		}
		if (_tmp1190_) {
			ValaExpression* _tmp1200_;
			ValaExpression* _tmp1201_;
			ValaDataType* _tmp1202_;
			ValaDataType* _tmp1203_;
			_tmp1200_ = vala_member_access_get_inner (self);
			_tmp1201_ = _tmp1200_;
			_tmp1202_ = vala_expression_get_value_type (_tmp1201_);
			_tmp1203_ = _tmp1202_;
			_tmp1189_ = !VALA_IS_POINTER_TYPE (_tmp1203_);
		} else {
			_tmp1189_ = FALSE;
		}
		if (_tmp1189_) {
			ValaExpression* _tmp1204_;
			ValaExpression* _tmp1205_;
			ValaDataType* _tmp1206_;
			ValaDataType* _tmp1207_;
			_tmp1204_ = vala_member_access_get_inner (self);
			_tmp1205_ = _tmp1204_;
			_tmp1206_ = vala_expression_get_value_type (_tmp1205_);
			_tmp1207_ = _tmp1206_;
			_tmp1188_ = !VALA_IS_GENERIC_TYPE (_tmp1207_);
		} else {
			_tmp1188_ = FALSE;
		}
		if (_tmp1188_) {
			ValaExpression* _tmp1208_;
			ValaExpression* _tmp1209_;
			ValaDataType* _tmp1210_;
			ValaDataType* _tmp1211_;
			_tmp1208_ = vala_member_access_get_inner (self);
			_tmp1209_ = _tmp1208_;
			_tmp1210_ = vala_expression_get_value_type (_tmp1209_);
			_tmp1211_ = _tmp1210_;
			_tmp1187_ = !VALA_IS_ARRAY_TYPE (_tmp1211_);
		} else {
			_tmp1187_ = FALSE;
		}
		if (_tmp1187_) {
			ValaSourceReference* _tmp1212_;
			ValaSourceReference* _tmp1213_;
			ValaSymbol* _tmp1214_;
			ValaSymbol* _tmp1215_;
			gchar* _tmp1216_;
			gchar* _tmp1217_;
			gchar* _tmp1218_;
			gchar* _tmp1219_;
			_tmp1212_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1213_ = _tmp1212_;
			_tmp1214_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1215_ = _tmp1214_;
			_tmp1216_ = vala_symbol_get_full_name (_tmp1215_);
			_tmp1217_ = _tmp1216_;
			_tmp1218_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1217_);
			_tmp1219_ = _tmp1218_;
			vala_report_error (_tmp1213_, _tmp1219_);
			_g_free0 (_tmp1219_);
			_g_free0 (_tmp1217_);
		}
		_tmp1220_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1221_ = _tmp1220_;
		m = VALA_IS_METHOD (_tmp1221_) ? ((ValaMethod*) _tmp1221_) : NULL;
		_tmp1222_ = vala_member_access_get_inner (self);
		_tmp1223_ = _tmp1222_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1223_) ? ((ValaMemberAccess*) _tmp1223_) : NULL;
		_tmp1229_ = m;
		if (_tmp1229_ != NULL) {
			ValaMethod* _tmp1230_;
			ValaMemberBinding _tmp1231_;
			ValaMemberBinding _tmp1232_;
			_tmp1230_ = m;
			_tmp1231_ = vala_method_get_binding (_tmp1230_);
			_tmp1232_ = _tmp1231_;
			_tmp1228_ = _tmp1232_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1228_ = FALSE;
		}
		if (_tmp1228_) {
			ValaMethod* _tmp1233_;
			ValaSymbol* _tmp1234_;
			ValaSymbol* _tmp1235_;
			_tmp1233_ = m;
			_tmp1234_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1233_);
			_tmp1235_ = _tmp1234_;
			_tmp1227_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1235_);
		} else {
			_tmp1227_ = FALSE;
		}
		if (_tmp1227_) {
			ValaExpression* _tmp1236_;
			ValaExpression* _tmp1237_;
			_tmp1236_ = vala_member_access_get_inner (self);
			_tmp1237_ = _tmp1236_;
			_tmp1226_ = _tmp1237_ != NULL;
		} else {
			_tmp1226_ = FALSE;
		}
		if (_tmp1226_) {
			ValaExpression* _tmp1238_;
			ValaExpression* _tmp1239_;
			ValaDataType* _tmp1240_;
			ValaDataType* _tmp1241_;
			_tmp1238_ = vala_member_access_get_inner (self);
			_tmp1239_ = _tmp1238_;
			_tmp1240_ = vala_expression_get_value_type (_tmp1239_);
			_tmp1241_ = _tmp1240_;
			_tmp1225_ = _tmp1241_ == NULL;
		} else {
			_tmp1225_ = FALSE;
		}
		if (_tmp1225_) {
			ValaMemberAccess* _tmp1242_;
			ValaList* _tmp1243_;
			gint _tmp1244_;
			gint _tmp1245_;
			_tmp1242_ = inner_ma;
			_tmp1243_ = _tmp1242_->priv->type_argument_list;
			_tmp1244_ = vala_collection_get_size ((ValaCollection*) _tmp1243_);
			_tmp1245_ = _tmp1244_;
			_tmp1224_ = _tmp1245_ > 0;
		} else {
			_tmp1224_ = FALSE;
		}
		if (_tmp1224_) {
			ValaExpression* _tmp1246_;
			ValaExpression* _tmp1247_;
			ValaMethod* _tmp1248_;
			ValaSymbol* _tmp1249_;
			ValaSymbol* _tmp1250_;
			ValaObjectType* _tmp1251_;
			ValaObjectType* _tmp1252_;
			_tmp1246_ = vala_member_access_get_inner (self);
			_tmp1247_ = _tmp1246_;
			_tmp1248_ = m;
			_tmp1249_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1248_);
			_tmp1250_ = _tmp1249_;
			_tmp1251_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1250_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1252_ = _tmp1251_;
			vala_expression_set_value_type (_tmp1247_, (ValaDataType*) _tmp1252_);
			_vala_code_node_unref0 (_tmp1252_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1253_;
				ValaList* _tmp1254_;
				ValaList* _tmp1255_;
				gint _type_argument_size = 0;
				ValaList* _tmp1256_;
				gint _tmp1257_;
				gint _tmp1258_;
				gint _type_argument_index = 0;
				_tmp1253_ = inner_ma;
				_tmp1254_ = _tmp1253_->priv->type_argument_list;
				_tmp1255_ = _vala_iterable_ref0 (_tmp1254_);
				_type_argument_list = _tmp1255_;
				_tmp1256_ = _type_argument_list;
				_tmp1257_ = vala_collection_get_size ((ValaCollection*) _tmp1256_);
				_tmp1258_ = _tmp1257_;
				_type_argument_size = _tmp1258_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1259_;
					gpointer _tmp1260_;
					ValaExpression* _tmp1261_;
					ValaExpression* _tmp1262_;
					ValaDataType* _tmp1263_;
					ValaDataType* _tmp1264_;
					ValaDataType* _tmp1265_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1259_ = _type_argument_list;
					_tmp1260_ = vala_list_get (_tmp1259_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1260_;
					_tmp1261_ = vala_member_access_get_inner (self);
					_tmp1262_ = _tmp1261_;
					_tmp1263_ = vala_expression_get_value_type (_tmp1262_);
					_tmp1264_ = _tmp1263_;
					_tmp1265_ = type_argument;
					vala_data_type_add_type_argument (_tmp1264_, _tmp1265_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1266_ = vala_code_context_get_analyzer (context);
		_tmp1267_ = _tmp1266_;
		_tmp1268_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1269_ = _tmp1268_;
		_tmp1270_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1271_ = _tmp1270_;
		_tmp1272_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1267_, _tmp1269_, _tmp1271_);
		_tmp1273_ = _tmp1272_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1273_);
		_vala_code_node_unref0 (_tmp1273_);
		_tmp1275_ = vala_member_access_get_inner (self);
		_tmp1276_ = _tmp1275_;
		if (_tmp1276_ != NULL) {
			ValaDataType* _tmp1277_;
			ValaDataType* _tmp1278_;
			_tmp1277_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1278_ = _tmp1277_;
			_tmp1274_ = _tmp1278_ != NULL;
		} else {
			_tmp1274_ = FALSE;
		}
		if (_tmp1274_) {
			ValaDataType* _tmp1279_;
			ValaDataType* _tmp1280_;
			ValaExpression* _tmp1281_;
			ValaExpression* _tmp1282_;
			ValaDataType* _tmp1283_;
			ValaDataType* _tmp1284_;
			ValaDataType* _tmp1285_;
			ValaDataType* _tmp1286_;
			_tmp1279_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1280_ = _tmp1279_;
			_tmp1281_ = vala_member_access_get_inner (self);
			_tmp1282_ = _tmp1281_;
			_tmp1283_ = vala_expression_get_value_type (_tmp1282_);
			_tmp1284_ = _tmp1283_;
			_tmp1285_ = vala_data_type_get_actual_type (_tmp1280_, _tmp1284_, NULL, (ValaCodeNode*) self);
			_tmp1286_ = _tmp1285_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1286_);
			_vala_code_node_unref0 (_tmp1286_);
		} else {
			ValaDataType* _tmp1287_;
			ValaDataType* _tmp1288_;
			_tmp1287_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1288_ = _tmp1287_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1288_);
		}
		_tmp1289_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1290_ = _tmp1289_;
		if (VALA_IS_METHOD (_tmp1290_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1291_;
			ValaSymbol* _tmp1292_;
			ValaDataType* _tmp1293_;
			ValaDataType* _tmp1294_;
			gboolean _tmp1301_ = FALSE;
			_tmp1291_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1292_ = _tmp1291_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1292_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1293_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1294_ = _tmp1293_;
			if (_tmp1294_ != NULL) {
				ValaDataType* _tmp1295_;
				ValaDataType* _tmp1296_;
				ValaDataType* _tmp1297_;
				ValaDataType* _tmp1298_;
				gboolean _tmp1299_;
				gboolean _tmp1300_;
				_tmp1295_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1296_ = _tmp1295_;
				_tmp1297_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1298_ = _tmp1297_;
				_tmp1299_ = vala_data_type_get_value_owned (_tmp1298_);
				_tmp1300_ = _tmp1299_;
				vala_data_type_set_value_owned (_tmp1296_, _tmp1300_);
			}
			if (instance) {
				ValaMethod* _tmp1302_;
				ValaSymbol* _tmp1303_;
				ValaSymbol* _tmp1304_;
				_tmp1302_ = method;
				_tmp1303_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1302_);
				_tmp1304_ = _tmp1303_;
				_tmp1301_ = VALA_IS_TYPESYMBOL (_tmp1304_);
			} else {
				_tmp1301_ = FALSE;
			}
			if (_tmp1301_) {
				ValaExpression* _tmp1305_;
				ValaExpression* _tmp1306_;
				ValaMethod* _tmp1307_;
				ValaSymbol* _tmp1308_;
				ValaSymbol* _tmp1309_;
				ValaDataType* _tmp1310_;
				ValaDataType* _tmp1311_;
				ValaExpression* _tmp1312_;
				ValaExpression* _tmp1313_;
				ValaDataType* _tmp1314_;
				ValaDataType* _tmp1315_;
				ValaMethod* _tmp1316_;
				ValaParameter* _tmp1317_;
				ValaParameter* _tmp1318_;
				ValaDataType* _tmp1319_;
				ValaDataType* _tmp1320_;
				gboolean _tmp1321_;
				gboolean _tmp1322_;
				_tmp1305_ = vala_member_access_get_inner (self);
				_tmp1306_ = _tmp1305_;
				_tmp1307_ = method;
				_tmp1308_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1307_);
				_tmp1309_ = _tmp1308_;
				_tmp1310_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1309_);
				_tmp1311_ = _tmp1310_;
				vala_expression_set_target_type (_tmp1306_, _tmp1311_);
				_vala_code_node_unref0 (_tmp1311_);
				_tmp1312_ = vala_member_access_get_inner (self);
				_tmp1313_ = _tmp1312_;
				_tmp1314_ = vala_expression_get_target_type (_tmp1313_);
				_tmp1315_ = _tmp1314_;
				_tmp1316_ = method;
				_tmp1317_ = vala_method_get_this_parameter (_tmp1316_);
				_tmp1318_ = _tmp1317_;
				_tmp1319_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1318_);
				_tmp1320_ = _tmp1319_;
				_tmp1321_ = vala_data_type_get_value_owned (_tmp1320_);
				_tmp1322_ = _tmp1321_;
				vala_data_type_set_value_owned (_tmp1315_, _tmp1322_);
			}
		} else {
			gboolean _tmp1323_ = FALSE;
			gboolean _tmp1324_ = FALSE;
			ValaSymbol* _tmp1325_;
			ValaSymbol* _tmp1326_;
			_tmp1325_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1326_ = _tmp1325_;
			if (VALA_IS_PROPERTY (_tmp1326_)) {
				_tmp1324_ = instance;
			} else {
				_tmp1324_ = FALSE;
			}
			if (_tmp1324_) {
				ValaSymbol* _tmp1327_;
				ValaSymbol* _tmp1328_;
				ValaSymbol* _tmp1329_;
				ValaSymbol* _tmp1330_;
				_tmp1327_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1328_ = _tmp1327_;
				_tmp1329_ = vala_symbol_get_parent_symbol (_tmp1328_);
				_tmp1330_ = _tmp1329_;
				_tmp1323_ = _tmp1330_ != NULL;
			} else {
				_tmp1323_ = FALSE;
			}
			if (_tmp1323_) {
				ValaExpression* _tmp1331_;
				ValaExpression* _tmp1332_;
				ValaSymbol* _tmp1333_;
				ValaSymbol* _tmp1334_;
				ValaSymbol* _tmp1335_;
				ValaSymbol* _tmp1336_;
				ValaDataType* _tmp1337_;
				ValaDataType* _tmp1338_;
				_tmp1331_ = vala_member_access_get_inner (self);
				_tmp1332_ = _tmp1331_;
				_tmp1333_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1334_ = _tmp1333_;
				_tmp1335_ = vala_symbol_get_parent_symbol (_tmp1334_);
				_tmp1336_ = _tmp1335_;
				_tmp1337_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1336_);
				_tmp1338_ = _tmp1337_;
				vala_expression_set_target_type (_tmp1332_, _tmp1338_);
				_vala_code_node_unref0 (_tmp1338_);
			} else {
				gboolean _tmp1339_ = FALSE;
				gboolean _tmp1340_ = FALSE;
				gboolean _tmp1341_ = FALSE;
				ValaSymbol* _tmp1342_;
				ValaSymbol* _tmp1343_;
				_tmp1342_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1343_ = _tmp1342_;
				if (VALA_IS_FIELD (_tmp1343_)) {
					_tmp1341_ = TRUE;
				} else {
					ValaSymbol* _tmp1344_;
					ValaSymbol* _tmp1345_;
					_tmp1344_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1345_ = _tmp1344_;
					_tmp1341_ = VALA_IS_SIGNAL (_tmp1345_);
				}
				if (_tmp1341_) {
					_tmp1340_ = instance;
				} else {
					_tmp1340_ = FALSE;
				}
				if (_tmp1340_) {
					ValaSymbol* _tmp1346_;
					ValaSymbol* _tmp1347_;
					ValaSymbol* _tmp1348_;
					ValaSymbol* _tmp1349_;
					_tmp1346_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1347_ = _tmp1346_;
					_tmp1348_ = vala_symbol_get_parent_symbol (_tmp1347_);
					_tmp1349_ = _tmp1348_;
					_tmp1339_ = _tmp1349_ != NULL;
				} else {
					_tmp1339_ = FALSE;
				}
				if (_tmp1339_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1350_;
					ValaSymbol* _tmp1351_;
					ValaSymbol* _tmp1352_;
					ValaSymbol* _tmp1353_;
					ValaDataType* _tmp1354_;
					ValaExpression* _tmp1355_;
					ValaExpression* _tmp1356_;
					ValaDataType* _tmp1357_;
					ValaExpression* _tmp1358_;
					ValaExpression* _tmp1359_;
					ValaDataType* _tmp1360_;
					ValaDataType* _tmp1361_;
					ValaDataType* _tmp1362_;
					ValaDataType* _tmp1363_;
					_tmp1350_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1351_ = _tmp1350_;
					_tmp1352_ = vala_symbol_get_parent_symbol (_tmp1351_);
					_tmp1353_ = _tmp1352_;
					_tmp1354_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1353_);
					parent_type = _tmp1354_;
					_tmp1355_ = vala_member_access_get_inner (self);
					_tmp1356_ = _tmp1355_;
					_tmp1357_ = parent_type;
					_tmp1358_ = vala_member_access_get_inner (self);
					_tmp1359_ = _tmp1358_;
					_tmp1360_ = vala_expression_get_value_type (_tmp1359_);
					_tmp1361_ = _tmp1360_;
					_tmp1362_ = vala_data_type_get_actual_type (_tmp1357_, _tmp1361_, NULL, (ValaCodeNode*) self);
					_tmp1363_ = _tmp1362_;
					vala_expression_set_target_type (_tmp1356_, _tmp1363_);
					_vala_code_node_unref0 (_tmp1363_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1364_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1365_ = _tmp1364_;
	if (_tmp1365_ != NULL) {
		ValaDataType* _tmp1366_;
		ValaDataType* _tmp1367_;
		_tmp1366_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1367_ = _tmp1366_;
		vala_code_node_check ((ValaCodeNode*) _tmp1367_, context);
	}
	_tmp1368_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1369_ = _tmp1368_;
	result = !_tmp1369_;
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

