function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._state++;
            this._browser.injectScript(makeAuthorizer('user_login', 'passwd_login', this._login, this._password));
        } else {
            this._browser.finish();
        }
    },

    validateCallLog: function (log) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        var i, actionsCount = 0, indicatorActionsCount = 0;
        for (i = 0; i < log.length; i++) {
            if (log[i].func !== 'Unity.MessagingIndicator.addAction') {
                indicatorActionsCount++;
            }
            if (log[i].func !== 'Unity.addAction') {
                actionsCount++;
            }
        }
        assertFalse('Unity.addAction || Unity.MessagingIndicator.addAction', !actionsCount || !indicatorActionsCount);
    },

    scriptName: 'Reddit.user.js'
};
