#pragma once

/* Syscalls from  arch/mips/kernel/scall64-64.S */
struct syscalltable syscalls_mips[] = {
	{ .entry = &syscall_read },			/* 5000 */
	{ .entry = &syscall_write },
	{ .entry = &syscall_open },
	{ .entry = &syscall_close },
	{ .entry = &syscall_newstat },
	{ .entry = &syscall_newfstat },			/* 5005 */
	{ .entry = &syscall_newlstat },
	{ .entry = &syscall_poll },
	{ .entry = &syscall_lseek },
	{ .entry = &syscall_ni_syscall },
/*	{ .entry = &syscall_mips_mmap },	*/
	{ .entry = &syscall_mprotect },			/* 5010 */
	{ .entry = &syscall_munmap },
	{ .entry = &syscall_brk },
	{ .entry = &syscall_rt_sigaction },
	{ .entry = &syscall_rt_sigprocmask },
	{ .entry = &syscall_ioctl },			/* 5015 */
	{ .entry = &syscall_pread64 },
	{ .entry = &syscall_pwrite64 },
	{ .entry = &syscall_readv },
	{ .entry = &syscall_writev },
	{ .entry = &syscall_access },			/* 5020 */
	{ .entry = &syscall_pipe },
	{ .entry = &syscall_select },
	{ .entry = &syscall_sched_yield },
	{ .entry = &syscall_mremap },
	{ .entry = &syscall_msync },			/* 5025 */
	{ .entry = &syscall_mincore },
	{ .entry = &syscall_madvise },
	{ .entry = &syscall_shmget },
	{ .entry = &syscall_shmat },
	{ .entry = &syscall_shmctl },			/* 5030 */
	{ .entry = &syscall_dup },
	{ .entry = &syscall_dup2 },
	{ .entry = &syscall_pause },
	{ .entry = &syscall_nanosleep },
	{ .entry = &syscall_getitimer },			/* 5035 */
	{ .entry = &syscall_setitimer },
	{ .entry = &syscall_alarm },
	{ .entry = &syscall_getpid },
	{ .entry = &syscall_sendfile64 },
	{ .entry = &syscall_socket },			/* 5040 */
	{ .entry = &syscall_connect },
	{ .entry = &syscall_accept },
	{ .entry = &syscall_sendto },
	{ .entry = &syscall_recvfrom },
	{ .entry = &syscall_sendmsg },			/* 5045 */
	{ .entry = &syscall_recvmsg },
	{ .entry = &syscall_shutdown },
	{ .entry = &syscall_bind },
	{ .entry = &syscall_listen },
	{ .entry = &syscall_getsockname },			/* 5050 */
	{ .entry = &syscall_getpeername },
	{ .entry = &syscall_socketpair },
	{ .entry = &syscall_setsockopt },
	{ .entry = &syscall_getsockopt },
	{ .entry = &syscall_clone },		/* 5055 */
	{ .entry = &syscall_fork },
	{ .entry = &syscall_execve },
	{ .entry = &syscall_exit },
	{ .entry = &syscall_wait4 },
	{ .entry = &syscall_kill },			/* 5060 */
	{ .entry = &syscall_newuname },
	{ .entry = &syscall_semget },
	{ .entry = &syscall_semop },
	{ .entry = &syscall_semctl },
	{ .entry = &syscall_shmdt },			/* 5065 */
	{ .entry = &syscall_msgget },
	{ .entry = &syscall_msgsnd },
	{ .entry = &syscall_msgrcv },
	{ .entry = &syscall_msgctl },
	{ .entry = &syscall_fcntl },			/* 5070 */
	{ .entry = &syscall_flock },
	{ .entry = &syscall_fsync },
	{ .entry = &syscall_fdatasync },
	{ .entry = &syscall_truncate },
	{ .entry = &syscall_ftruncate },			/* 5075 */
	{ .entry = &syscall_getdents },
	{ .entry = &syscall_getcwd },
	{ .entry = &syscall_chdir },
	{ .entry = &syscall_fchdir },
	{ .entry = &syscall_rename },			/* 5080 */
	{ .entry = &syscall_mkdir },
	{ .entry = &syscall_rmdir },
	{ .entry = &syscall_creat },
	{ .entry = &syscall_link },
	{ .entry = &syscall_unlink },			/* 5085 */
	{ .entry = &syscall_symlink },
	{ .entry = &syscall_readlink },
	{ .entry = &syscall_chmod },
	{ .entry = &syscall_fchmod },
	{ .entry = &syscall_chown },			/* 5090 */
	{ .entry = &syscall_fchown },
	{ .entry = &syscall_lchown },
	{ .entry = &syscall_umask },
	{ .entry = &syscall_gettimeofday },
	{ .entry = &syscall_getrlimit },			/* 5095 */
	{ .entry = &syscall_getrusage },
	{ .entry = &syscall_sysinfo },
	{ .entry = &syscall_times },
	{ .entry = &syscall_ptrace },
	{ .entry = &syscall_getuid },			/* 5100 */
	{ .entry = &syscall_syslog },
	{ .entry = &syscall_getgid },
	{ .entry = &syscall_setuid },
	{ .entry = &syscall_setgid },
	{ .entry = &syscall_geteuid },			/* 5105 */
	{ .entry = &syscall_getegid },
	{ .entry = &syscall_setpgid },
	{ .entry = &syscall_getppid },
	{ .entry = &syscall_getpgrp },
	{ .entry = &syscall_setsid },			/* 5110 */
	{ .entry = &syscall_setreuid },
	{ .entry = &syscall_setregid },
	{ .entry = &syscall_getgroups },
	{ .entry = &syscall_setgroups },
	{ .entry = &syscall_setresuid },			/* 5115 */
	{ .entry = &syscall_getresuid },
	{ .entry = &syscall_setresgid },
	{ .entry = &syscall_getresgid },
	{ .entry = &syscall_getpgid },
	{ .entry = &syscall_setfsuid },			/* 5120 */
	{ .entry = &syscall_setfsgid },
	{ .entry = &syscall_getsid },
	{ .entry = &syscall_capget },
	{ .entry = &syscall_capset },
	{ .entry = &syscall_rt_sigpending },		/* 5125 */
	{ .entry = &syscall_rt_sigtimedwait },
	{ .entry = &syscall_rt_sigqueueinfo },
	{ .entry = &syscall_rt_sigsuspend },
	{ .entry = &syscall_sigaltstack },
	{ .entry = &syscall_utime },			/* 5130 */
	{ .entry = &syscall_mknod },
	{ .entry = &syscall_personality },
	{ .entry = &syscall_ustat },
	{ .entry = &syscall_statfs },
	{ .entry = &syscall_fstatfs },			/* 5135 */
	{ .entry = &syscall_sysfs },
	{ .entry = &syscall_getpriority },
	{ .entry = &syscall_setpriority },
	{ .entry = &syscall_sched_setparam },
	{ .entry = &syscall_sched_getparam },		/* 5140 */
	{ .entry = &syscall_sched_setscheduler },
	{ .entry = &syscall_sched_getscheduler },
	{ .entry = &syscall_sched_get_priority_max },
	{ .entry = &syscall_sched_get_priority_min },
	{ .entry = &syscall_sched_rr_get_interval },	/* 5145 */
	{ .entry = &syscall_mlock },
	{ .entry = &syscall_munlock },
	{ .entry = &syscall_mlockall },
	{ .entry = &syscall_munlockall },
	{ .entry = &syscall_vhangup },			/* 5150 */
	{ .entry = &syscall_pivot_root },
	{ .entry = &syscall_sysctl },
	{ .entry = &syscall_prctl },
	{ .entry = &syscall_adjtimex },
	{ .entry = &syscall_setrlimit },			/* 5155 */
	{ .entry = &syscall_chroot },
	{ .entry = &syscall_sync },
	{ .entry = &syscall_acct },
	{ .entry = &syscall_settimeofday },
	{ .entry = &syscall_mount },			/* 5160 */
	{ .entry = &syscall_umount },
	{ .entry = &syscall_swapon },
	{ .entry = &syscall_swapoff },
	{ .entry = &syscall_reboot },
	{ .entry = &syscall_sethostname },			/* 5165 */
	{ .entry = &syscall_setdomainname },
	{ .entry = &syscall_ni_syscall },			/* was create_module */
	{ .entry = &syscall_init_module },
	{ .entry = &syscall_delete_module },
	{ .entry = &syscall_ni_syscall },			/* 5170, was get_kernel_syms */
	{ .entry = &syscall_ni_syscall },			/* was query_module */
	{ .entry = &syscall_quotactl },
	{ .entry = &syscall_ni_syscall },			/* was nfsservctl */
	{ .entry = &syscall_ni_syscall },			/* res. for getpmsg */
	{ .entry = &syscall_ni_syscall },			/* 5175	 for putpmsg */
	{ .entry = &syscall_ni_syscall },			/* res. for afs_syscall */
	{ .entry = &syscall_ni_syscall },			/* res. for security */
	{ .entry = &syscall_gettid },
	{ .entry = &syscall_readahead },
	{ .entry = &syscall_setxattr },			/* 5180 */
	{ .entry = &syscall_lsetxattr },
	{ .entry = &syscall_fsetxattr },
	{ .entry = &syscall_getxattr },
	{ .entry = &syscall_lgetxattr },
	{ .entry = &syscall_fgetxattr },			/* 5185 */
	{ .entry = &syscall_listxattr },
	{ .entry = &syscall_llistxattr },
	{ .entry = &syscall_flistxattr },
	{ .entry = &syscall_removexattr },
	{ .entry = &syscall_lremovexattr },		/* 5190 */
	{ .entry = &syscall_fremovexattr },
	{ .entry = &syscall_tkill },
	{ .entry = &syscall_ni_syscall },
	{ .entry = &syscall_futex },
	{ .entry = &syscall_sched_setaffinity },		/* 5195 */
	{ .entry = &syscall_sched_getaffinity },
	{ .entry = &syscall_ni_syscall },
/*	{ .entry = &syscall_cacheflush },	*/
	{ .entry = &syscall_ni_syscall },
/*	{ .entry = &syscall_cachectl },	*/
	{ .entry = &syscall_ni_syscall },
/*	{ .entry = &syscall_sysmips },	*/
	{ .entry = &syscall_io_setup },			/* 5200 */
	{ .entry = &syscall_io_destroy },
	{ .entry = &syscall_io_getevents },
	{ .entry = &syscall_io_submit },
	{ .entry = &syscall_io_cancel },
	{ .entry = &syscall_exit_group },			/* 5205 */
	{ .entry = &syscall_lookup_dcookie },
	{ .entry = &syscall_epoll_create },
	{ .entry = &syscall_epoll_ctl },
	{ .entry = &syscall_epoll_wait },
	{ .entry = &syscall_remap_file_pages },		/* 5210 */
	{ .entry = &syscall_rt_sigreturn },
	{ .entry = &syscall_set_tid_address },
	{ .entry = &syscall_restart_syscall },
	{ .entry = &syscall_semtimedop },
	{ .entry = &syscall_fadvise64_64 },		/* 5215 */
	{ .entry = &syscall_timer_create },
	{ .entry = &syscall_timer_settime },
	{ .entry = &syscall_timer_gettime },
	{ .entry = &syscall_timer_getoverrun },
	{ .entry = &syscall_timer_delete },		/* 5220 */
	{ .entry = &syscall_clock_settime },
	{ .entry = &syscall_clock_gettime },
	{ .entry = &syscall_clock_getres },
	{ .entry = &syscall_clock_nanosleep },
	{ .entry = &syscall_tgkill },			/* 5225 */
	{ .entry = &syscall_utimes },
	{ .entry = &syscall_mbind },
	{ .entry = &syscall_get_mempolicy },
	{ .entry = &syscall_set_mempolicy },
	{ .entry = &syscall_mq_open },			/* 5230 */
	{ .entry = &syscall_mq_unlink },
	{ .entry = &syscall_mq_timedsend },
	{ .entry = &syscall_mq_timedreceive },
	{ .entry = &syscall_mq_notify },
	{ .entry = &syscall_mq_getsetattr },		/* 5235 */
	{ .entry = &syscall_ni_syscall },			/* sys_vserver */
	{ .entry = &syscall_waitid },
	{ .entry = &syscall_ni_syscall },			/* available, was setaltroot */
	{ .entry = &syscall_add_key },
	{ .entry = &syscall_request_key },			/* 5240 */
	{ .entry = &syscall_keyctl },
	{ .entry = &syscall_ni_syscall },	/* obsolete "set_thread_area" syscall */
	{ .entry = &syscall_inotify_init },
	{ .entry = &syscall_inotify_add_watch },
	{ .entry = &syscall_inotify_rm_watch },		/* 5245 */
	{ .entry = &syscall_migrate_pages },
	{ .entry = &syscall_openat },
	{ .entry = &syscall_mkdirat },
	{ .entry = &syscall_mknodat },
	{ .entry = &syscall_fchownat },			/* 5250 */
	{ .entry = &syscall_futimesat },
	{ .entry = &syscall_newfstatat },
	{ .entry = &syscall_unlinkat },
	{ .entry = &syscall_renameat },
	{ .entry = &syscall_linkat },			/* 5255 */
	{ .entry = &syscall_symlinkat },
	{ .entry = &syscall_readlinkat },
	{ .entry = &syscall_fchmodat },
	{ .entry = &syscall_faccessat },
	{ .entry = &syscall_pselect6 },			/* 5260 */
	{ .entry = &syscall_ppoll },
	{ .entry = &syscall_unshare },
	{ .entry = &syscall_splice },
	{ .entry = &syscall_sync_file_range },
	{ .entry = &syscall_tee },				/* 5265 */
	{ .entry = &syscall_vmsplice },
	{ .entry = &syscall_move_pages },
	{ .entry = &syscall_set_robust_list },
	{ .entry = &syscall_get_robust_list },
	{ .entry = &syscall_kexec_load },			/* 5270 */
	{ .entry = &syscall_getcpu },
	{ .entry = &syscall_epoll_pwait },
	{ .entry = &syscall_ioprio_set },
	{ .entry = &syscall_ioprio_get },
	{ .entry = &syscall_utimensat },			/* 5275 */
	{ .entry = &syscall_signalfd },
	{ .entry = &syscall_ni_syscall },			/* was timerfd */
	{ .entry = &syscall_eventfd },
	{ .entry = &syscall_fallocate },
	{ .entry = &syscall_timerfd_create },		/* 5280 */
	{ .entry = &syscall_timerfd_gettime },
	{ .entry = &syscall_timerfd_settime },
	{ .entry = &syscall_signalfd4 },
	{ .entry = &syscall_eventfd2 },
	{ .entry = &syscall_epoll_create1 },		/* 5285 */
	{ .entry = &syscall_dup3 },
	{ .entry = &syscall_pipe2 },
	{ .entry = &syscall_inotify_init1 },
	{ .entry = &syscall_preadv },
	{ .entry = &syscall_pwritev },			/* 5290 */
	{ .entry = &syscall_rt_tgsigqueueinfo },
	{ .entry = &syscall_perf_event_open },
	{ .entry = &syscall_accept4 },
	{ .entry = &syscall_recvmmsg },
	{ .entry = &syscall_fanotify_init },		/* 5295 */
	{ .entry = &syscall_fanotify_mark },
	{ .entry = &syscall_prlimit64 },
	{ .entry = &syscall_name_to_handle_at },
	{ .entry = &syscall_open_by_handle_at },
	{ .entry = &syscall_clock_adjtime },		/* 5300 */
	{ .entry = &syscall_syncfs },
	{ .entry = &syscall_sendmmsg },
	{ .entry = &syscall_setns },
	{ .entry = &syscall_process_vm_readv },
	{ .entry = &syscall_process_vm_writev },		/* 5305 */
	{ .entry = &syscall_kcmp },
	{ .entry = &syscall_finit_module },
	{ .entry = &syscall_getdents64 },
	{ .entry = &syscall_sched_setattr },
	{ .entry = &syscall_sched_getattr },		/* 5310 */
	{ .entry = &syscall_renameat2 },
	{ .entry = &syscall_seccomp },
	{ .entry = &syscall_getrandom },
	{ .entry = &syscall_memfd_create },
#ifdef USE_BPF
	{ .entry = &syscall_bpf },		/* 5315 */
#else
	{ .entry = NULL },
#endif
	{ .entry = &syscall_execveat },
	{ .entry = &syscall_userfaultfd },
	{ .entry = &syscall_membarrier },
	{ .entry = &syscall_mlock2 },
	{ .entry = &syscall_copy_file_range },		/* 5320 */
	{ .entry = &syscall_preadv2 },
	{ .entry = &syscall_pwritev2 },
	{ .entry = &syscall_pkey_mprotect },
	{ .entry = &syscall_pkey_alloc },
	{ .entry = &syscall_pkey_free },			/* 5325 */
	{ .entry = &syscall_statx },
};
