# -*- coding: utf-8 -*-
#
# Copyright 2008-2012 Zuza Software Foundation
#
# This file is part of the Translate Toolkit.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>.

"""Tools and API for translation and localization engineering.

The `Translate Toolkit <http://toolkit.translatehouse.org/>`_ is created by
localizers for localizers. It contains several utilities, as well as an API for
building localization tools.

Some of the **tools** include:

- File format `converters
  <http://docs.translatehouse.org/projects/translate-toolkit/en/latest/commands/index.html#converters>`_
- `Quality checking
  <http://docs.translatehouse.org/projects/translate-toolkit/en/latest/commands/index.html#quality-assurance>`_
  tools
- Tools for counting, grepping, terminology extraction, and pseudo-localization

Apart from the code for the tools above, some features of the **API** include:

- Support for multiple `file formats
  <http://docs.translatehouse.org/projects/translate-toolkit/en/latest/formats/index.html>`_
- Language information and language support code (including language detection)
- Code for translation memory, terminology matching and indexed search
- Several helper classes and functions for tools built on the Translate
  Toolkit.

"""
