/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.tinyos.message.Message;
import net.tinyos.message.MessageListener;
import net.tinyos.message.MoteIF;
import net.tinyos.util.Messenger;

public class AntiTheftGui
implements MessageListener,
Messenger {
    MoteIF mote;
    JFrame frame;
    JTextArea mssgArea;
    JTextField fieldInterval;
    JCheckBox detDarkCb;
    JCheckBox detAccelCb;
    JCheckBox repLedCb;
    JCheckBox repSirenCb;
    JCheckBox repServerCb;
    JCheckBox repNeighboursCb;

    public AntiTheftGui() {
        try {
            this.guiInit();
            this.mote = new MoteIF((Messenger)this);
            this.mote.registerListener((Message)new AlertMsg(), (MessageListener)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(2);
        }
    }

    private void guiInit() throws Exception {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setMinimumSize(new Dimension(500, 250));
        jPanel.setPreferredSize(new Dimension(500, 300));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setAutoscrolls(true);
        this.mssgArea = new JTextArea();
        this.mssgArea.setFont(new Font("Monospaced", 0, 20));
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)this.mssgArea, null);
        BagPanel bagPanel = new BagPanel();
        GridBagConstraints gridBagConstraints = bagPanel.c;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        bagPanel.makeLabel("Detection", 0);
        gridBagConstraints.gridwidth = -1;
        this.detDarkCb = bagPanel.makeCheckBox("Dark", true);
        gridBagConstraints.gridwidth = 0;
        this.detAccelCb = bagPanel.makeCheckBox("Movement", false);
        bagPanel.makeSeparator(0);
        bagPanel.makeLabel("Theft Reports", 0);
        gridBagConstraints.gridwidth = -1;
        this.repLedCb = bagPanel.makeCheckBox("LED", true);
        gridBagConstraints.gridwidth = 0;
        this.repSirenCb = bagPanel.makeCheckBox("Siren", false);
        gridBagConstraints.gridwidth = -1;
        this.repServerCb = bagPanel.makeCheckBox("Server", false);
        gridBagConstraints.gridwidth = 0;
        this.repNeighboursCb = bagPanel.makeCheckBox("Neighbours", false);
        bagPanel.makeSeparator(0);
        bagPanel.makeLabel("Interval", 0);
        this.fieldInterval = bagPanel.makeTextField(10, null);
        this.fieldInterval.setText(Integer.toString(1000));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AntiTheftGui.this.updateSettings();
            }
        };
        bagPanel.makeButton("Update", actionListener);
        jPanel.add((Component)bagPanel, "East");
        this.frame = new JFrame("AntiTheft");
        this.frame.setSize(jPanel.getPreferredSize());
        this.frame.getContentPane().add(jPanel);
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    public synchronized void message(String string) {
        this.mssgArea.append(string + "\n");
        this.mssgArea.setCaretPosition(this.mssgArea.getDocument().getLength());
    }

    void error(String string) {
        JOptionPane.showMessageDialog(this.frame, string, "Error", 0);
    }

    public void updateSettings() {
        SettingsMsg settingsMsg = new SettingsMsg();
        short s = 0;
        short s2 = 0;
        int n = 1000;
        String string = this.fieldInterval.getText().trim();
        try {
            int n2 = Integer.parseInt(string);
            if (n2 < 10) {
                throw new NumberFormatException();
            }
            n = n2;
        }
        catch (NumberFormatException numberFormatException) {
            this.fieldInterval.setText("" + n);
        }
        if (this.repLedCb.isSelected()) {
            s = (short)(s | 1);
        }
        if (this.repSirenCb.isSelected()) {
            s = (short)(s | 2);
        }
        if (this.repNeighboursCb.isSelected()) {
            s = (short)(s | 4);
        }
        if (this.repServerCb.isSelected()) {
            s = (short)(s | 8);
        }
        if (s == 0) {
            s = 1;
            this.repLedCb.setSelected(true);
        }
        if (this.detDarkCb.isSelected()) {
            s2 = (short)(s2 | 1);
        }
        if (this.detAccelCb.isSelected()) {
            s2 = (short)(s2 | 2);
        }
        if (s2 == 0) {
            s2 = 1;
            this.detDarkCb.setSelected(true);
        }
        settingsMsg.set_alert(s);
        settingsMsg.set_detect(s2);
        settingsMsg.set_checkInterval(n);
        try {
            this.mote.send(65535, (Message)settingsMsg);
        }
        catch (IOException iOException) {
            this.error("Cannot send message to mote");
        }
    }

    public void messageReceived(int n, Message message) {
        if (message instanceof AlertMsg) {
            AlertMsg alertMsg = (AlertMsg)message;
            this.message("Theft of " + alertMsg.get_stolenId());
        }
    }

    public static void main(String[] stringArray) {
        AntiTheftGui antiTheftGui = new AntiTheftGui();
    }
}

