/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.packet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.tinyos.packet.AbstractSource;

public abstract class SFProtocol
extends AbstractSource {
    static final byte[] VERSION = new byte[]{85, 32};
    int version;
    protected InputStream is;
    protected OutputStream os;

    protected SFProtocol(String string) {
        super(string);
    }

    protected void openSource() throws IOException {
        this.os.write(VERSION);
        byte[] byArray = this.readN(2);
        if (byArray[0] != VERSION[0]) {
            throw new IOException("protocol error");
        }
        this.version = byArray[1] & 0xFF;
        int n = VERSION[1] & 0xFF;
        if (n < this.version) {
            this.version = n;
        }
        switch (this.version) {
            case 32: {
                break;
            }
            default: {
                throw new IOException("bad protocol version");
            }
        }
    }

    protected byte[] readSourcePacket() throws IOException {
        byte[] byArray = this.readN(1);
        if (byArray[0] == 0) {
            throw new IOException("0-byte packet");
        }
        byte[] byArray2 = this.readN(byArray[0] & 0xFF);
        return byArray2;
    }

    protected byte[] readN(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += n2) {
            n2 = this.is.read(byArray, i, n - i);
            if (n2 != -1) continue;
            throw new IOException("end-of-stream");
        }
        return byArray;
    }

    protected boolean writeSourcePacket(byte[] byArray) throws IOException {
        if (byArray.length > 255) {
            throw new IOException("packet too long");
        }
        if (byArray.length == 0) {
            throw new IOException("packet too short");
        }
        this.os.write((byte)byArray.length);
        this.os.write(byArray);
        this.os.flush();
        return true;
    }
}

