/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

/*****************************************************************************

  sc_int_mask.cpp -- Fills the mask_int lookup table to enable efficient
                     part-selection on sc_ints and sc_uints.

  Original Author: Amit Rao, Synopsys, Inc.

 *****************************************************************************/

/*****************************************************************************

  MODIFICATION LOG - modifiers, enter your name, affiliation, date and
  changes you are making here.

      Name, Affiliation, Date: Ali Dasdan, Synopsys, Inc.
  Description of Modification: - Resolved ambiguity with sc_(un)signed.
                               - Merged the code for 64- and 32-bit versions
                                 via the constants in sc_nbdefs.h.
                               - Eliminated redundant file inclusions.

      Name, Affiliation, Date: Philipp A Hartmann, Intel
  Description of Modification: - drop specializations for Windows, 32-bit only

      Name, Affiliation, Date:
  Description of Modification:

 *****************************************************************************/

#include "sysc/datatypes/int/sc_int_base.h"
#include "sysc/datatypes/int/sc_uint_base.h"

#ifndef UINT64_C
#if defined(_WIN32) && !defined(__MINGW32__)
# define UINT64_C(v) v ## ui64
#else
# define UINT64_C(v) v ## ULL
#endif
#endif // UINT64_C

namespace sc_dt {

SC_API const uint_type mask_int[SC_INTWIDTH][SC_INTWIDTH] = 
{
{
UINT64_C(0xfffffffffffffffe)
},
{
UINT64_C(0xfffffffffffffffc),
UINT64_C(0xfffffffffffffffd)
},
{
UINT64_C(0xfffffffffffffff8),
UINT64_C(0xfffffffffffffff9),
UINT64_C(0xfffffffffffffffb)
},
{
UINT64_C(0xfffffffffffffff0),
UINT64_C(0xfffffffffffffff1),
UINT64_C(0xfffffffffffffff3),
UINT64_C(0xfffffffffffffff7)
},
{
UINT64_C(0xffffffffffffffe0),
UINT64_C(0xffffffffffffffe1),
UINT64_C(0xffffffffffffffe3),
UINT64_C(0xffffffffffffffe7),
UINT64_C(0xffffffffffffffef)
},
{
UINT64_C(0xffffffffffffffc0),
UINT64_C(0xffffffffffffffc1),
UINT64_C(0xffffffffffffffc3),
UINT64_C(0xffffffffffffffc7),
UINT64_C(0xffffffffffffffcf),
UINT64_C(0xffffffffffffffdf)
},
{
UINT64_C(0xffffffffffffff80),
UINT64_C(0xffffffffffffff81),
UINT64_C(0xffffffffffffff83),
UINT64_C(0xffffffffffffff87),
UINT64_C(0xffffffffffffff8f),
UINT64_C(0xffffffffffffff9f),
UINT64_C(0xffffffffffffffbf)
},
{
UINT64_C(0xffffffffffffff00),
UINT64_C(0xffffffffffffff01),
UINT64_C(0xffffffffffffff03),
UINT64_C(0xffffffffffffff07),
UINT64_C(0xffffffffffffff0f),
UINT64_C(0xffffffffffffff1f),
UINT64_C(0xffffffffffffff3f),
UINT64_C(0xffffffffffffff7f)
},
{
UINT64_C(0xfffffffffffffe00),
UINT64_C(0xfffffffffffffe01),
UINT64_C(0xfffffffffffffe03),
UINT64_C(0xfffffffffffffe07),
UINT64_C(0xfffffffffffffe0f),
UINT64_C(0xfffffffffffffe1f),
UINT64_C(0xfffffffffffffe3f),
UINT64_C(0xfffffffffffffe7f),
UINT64_C(0xfffffffffffffeff)
},
{
UINT64_C(0xfffffffffffffc00),
UINT64_C(0xfffffffffffffc01),
UINT64_C(0xfffffffffffffc03),
UINT64_C(0xfffffffffffffc07),
UINT64_C(0xfffffffffffffc0f),
UINT64_C(0xfffffffffffffc1f),
UINT64_C(0xfffffffffffffc3f),
UINT64_C(0xfffffffffffffc7f),
UINT64_C(0xfffffffffffffcff),
UINT64_C(0xfffffffffffffdff)
},
{
UINT64_C(0xfffffffffffff800),
UINT64_C(0xfffffffffffff801),
UINT64_C(0xfffffffffffff803),
UINT64_C(0xfffffffffffff807),
UINT64_C(0xfffffffffffff80f),
UINT64_C(0xfffffffffffff81f),
UINT64_C(0xfffffffffffff83f),
UINT64_C(0xfffffffffffff87f),
UINT64_C(0xfffffffffffff8ff),
UINT64_C(0xfffffffffffff9ff),
UINT64_C(0xfffffffffffffbff)
},
{
UINT64_C(0xfffffffffffff000),
UINT64_C(0xfffffffffffff001),
UINT64_C(0xfffffffffffff003),
UINT64_C(0xfffffffffffff007),
UINT64_C(0xfffffffffffff00f),
UINT64_C(0xfffffffffffff01f),
UINT64_C(0xfffffffffffff03f),
UINT64_C(0xfffffffffffff07f),
UINT64_C(0xfffffffffffff0ff),
UINT64_C(0xfffffffffffff1ff),
UINT64_C(0xfffffffffffff3ff),
UINT64_C(0xfffffffffffff7ff)
},
{
UINT64_C(0xffffffffffffe000),
UINT64_C(0xffffffffffffe001),
UINT64_C(0xffffffffffffe003),
UINT64_C(0xffffffffffffe007),
UINT64_C(0xffffffffffffe00f),
UINT64_C(0xffffffffffffe01f),
UINT64_C(0xffffffffffffe03f),
UINT64_C(0xffffffffffffe07f),
UINT64_C(0xffffffffffffe0ff),
UINT64_C(0xffffffffffffe1ff),
UINT64_C(0xffffffffffffe3ff),
UINT64_C(0xffffffffffffe7ff),
UINT64_C(0xffffffffffffefff)
},
{
UINT64_C(0xffffffffffffc000),
UINT64_C(0xffffffffffffc001),
UINT64_C(0xffffffffffffc003),
UINT64_C(0xffffffffffffc007),
UINT64_C(0xffffffffffffc00f),
UINT64_C(0xffffffffffffc01f),
UINT64_C(0xffffffffffffc03f),
UINT64_C(0xffffffffffffc07f),
UINT64_C(0xffffffffffffc0ff),
UINT64_C(0xffffffffffffc1ff),
UINT64_C(0xffffffffffffc3ff),
UINT64_C(0xffffffffffffc7ff),
UINT64_C(0xffffffffffffcfff),
UINT64_C(0xffffffffffffdfff)
},
{
UINT64_C(0xffffffffffff8000),
UINT64_C(0xffffffffffff8001),
UINT64_C(0xffffffffffff8003),
UINT64_C(0xffffffffffff8007),
UINT64_C(0xffffffffffff800f),
UINT64_C(0xffffffffffff801f),
UINT64_C(0xffffffffffff803f),
UINT64_C(0xffffffffffff807f),
UINT64_C(0xffffffffffff80ff),
UINT64_C(0xffffffffffff81ff),
UINT64_C(0xffffffffffff83ff),
UINT64_C(0xffffffffffff87ff),
UINT64_C(0xffffffffffff8fff),
UINT64_C(0xffffffffffff9fff),
UINT64_C(0xffffffffffffbfff)
},
{
UINT64_C(0xffffffffffff0000),
UINT64_C(0xffffffffffff0001),
UINT64_C(0xffffffffffff0003),
UINT64_C(0xffffffffffff0007),
UINT64_C(0xffffffffffff000f),
UINT64_C(0xffffffffffff001f),
UINT64_C(0xffffffffffff003f),
UINT64_C(0xffffffffffff007f),
UINT64_C(0xffffffffffff00ff),
UINT64_C(0xffffffffffff01ff),
UINT64_C(0xffffffffffff03ff),
UINT64_C(0xffffffffffff07ff),
UINT64_C(0xffffffffffff0fff),
UINT64_C(0xffffffffffff1fff),
UINT64_C(0xffffffffffff3fff),
UINT64_C(0xffffffffffff7fff)
},
{
UINT64_C(0xfffffffffffe0000),
UINT64_C(0xfffffffffffe0001),
UINT64_C(0xfffffffffffe0003),
UINT64_C(0xfffffffffffe0007),
UINT64_C(0xfffffffffffe000f),
UINT64_C(0xfffffffffffe001f),
UINT64_C(0xfffffffffffe003f),
UINT64_C(0xfffffffffffe007f),
UINT64_C(0xfffffffffffe00ff),
UINT64_C(0xfffffffffffe01ff),
UINT64_C(0xfffffffffffe03ff),
UINT64_C(0xfffffffffffe07ff),
UINT64_C(0xfffffffffffe0fff),
UINT64_C(0xfffffffffffe1fff),
UINT64_C(0xfffffffffffe3fff),
UINT64_C(0xfffffffffffe7fff),
UINT64_C(0xfffffffffffeffff)
},
{
UINT64_C(0xfffffffffffc0000),
UINT64_C(0xfffffffffffc0001),
UINT64_C(0xfffffffffffc0003),
UINT64_C(0xfffffffffffc0007),
UINT64_C(0xfffffffffffc000f),
UINT64_C(0xfffffffffffc001f),
UINT64_C(0xfffffffffffc003f),
UINT64_C(0xfffffffffffc007f),
UINT64_C(0xfffffffffffc00ff),
UINT64_C(0xfffffffffffc01ff),
UINT64_C(0xfffffffffffc03ff),
UINT64_C(0xfffffffffffc07ff),
UINT64_C(0xfffffffffffc0fff),
UINT64_C(0xfffffffffffc1fff),
UINT64_C(0xfffffffffffc3fff),
UINT64_C(0xfffffffffffc7fff),
UINT64_C(0xfffffffffffcffff),
UINT64_C(0xfffffffffffdffff)
},
{
UINT64_C(0xfffffffffff80000),
UINT64_C(0xfffffffffff80001),
UINT64_C(0xfffffffffff80003),
UINT64_C(0xfffffffffff80007),
UINT64_C(0xfffffffffff8000f),
UINT64_C(0xfffffffffff8001f),
UINT64_C(0xfffffffffff8003f),
UINT64_C(0xfffffffffff8007f),
UINT64_C(0xfffffffffff800ff),
UINT64_C(0xfffffffffff801ff),
UINT64_C(0xfffffffffff803ff),
UINT64_C(0xfffffffffff807ff),
UINT64_C(0xfffffffffff80fff),
UINT64_C(0xfffffffffff81fff),
UINT64_C(0xfffffffffff83fff),
UINT64_C(0xfffffffffff87fff),
UINT64_C(0xfffffffffff8ffff),
UINT64_C(0xfffffffffff9ffff),
UINT64_C(0xfffffffffffbffff)
},
{
UINT64_C(0xfffffffffff00000),
UINT64_C(0xfffffffffff00001),
UINT64_C(0xfffffffffff00003),
UINT64_C(0xfffffffffff00007),
UINT64_C(0xfffffffffff0000f),
UINT64_C(0xfffffffffff0001f),
UINT64_C(0xfffffffffff0003f),
UINT64_C(0xfffffffffff0007f),
UINT64_C(0xfffffffffff000ff),
UINT64_C(0xfffffffffff001ff),
UINT64_C(0xfffffffffff003ff),
UINT64_C(0xfffffffffff007ff),
UINT64_C(0xfffffffffff00fff),
UINT64_C(0xfffffffffff01fff),
UINT64_C(0xfffffffffff03fff),
UINT64_C(0xfffffffffff07fff),
UINT64_C(0xfffffffffff0ffff),
UINT64_C(0xfffffffffff1ffff),
UINT64_C(0xfffffffffff3ffff),
UINT64_C(0xfffffffffff7ffff)
},
{
UINT64_C(0xffffffffffe00000),
UINT64_C(0xffffffffffe00001),
UINT64_C(0xffffffffffe00003),
UINT64_C(0xffffffffffe00007),
UINT64_C(0xffffffffffe0000f),
UINT64_C(0xffffffffffe0001f),
UINT64_C(0xffffffffffe0003f),
UINT64_C(0xffffffffffe0007f),
UINT64_C(0xffffffffffe000ff),
UINT64_C(0xffffffffffe001ff),
UINT64_C(0xffffffffffe003ff),
UINT64_C(0xffffffffffe007ff),
UINT64_C(0xffffffffffe00fff),
UINT64_C(0xffffffffffe01fff),
UINT64_C(0xffffffffffe03fff),
UINT64_C(0xffffffffffe07fff),
UINT64_C(0xffffffffffe0ffff),
UINT64_C(0xffffffffffe1ffff),
UINT64_C(0xffffffffffe3ffff),
UINT64_C(0xffffffffffe7ffff),
UINT64_C(0xffffffffffefffff)
},
{
UINT64_C(0xffffffffffc00000),
UINT64_C(0xffffffffffc00001),
UINT64_C(0xffffffffffc00003),
UINT64_C(0xffffffffffc00007),
UINT64_C(0xffffffffffc0000f),
UINT64_C(0xffffffffffc0001f),
UINT64_C(0xffffffffffc0003f),
UINT64_C(0xffffffffffc0007f),
UINT64_C(0xffffffffffc000ff),
UINT64_C(0xffffffffffc001ff),
UINT64_C(0xffffffffffc003ff),
UINT64_C(0xffffffffffc007ff),
UINT64_C(0xffffffffffc00fff),
UINT64_C(0xffffffffffc01fff),
UINT64_C(0xffffffffffc03fff),
UINT64_C(0xffffffffffc07fff),
UINT64_C(0xffffffffffc0ffff),
UINT64_C(0xffffffffffc1ffff),
UINT64_C(0xffffffffffc3ffff),
UINT64_C(0xffffffffffc7ffff),
UINT64_C(0xffffffffffcfffff),
UINT64_C(0xffffffffffdfffff)
},
{
UINT64_C(0xffffffffff800000),
UINT64_C(0xffffffffff800001),
UINT64_C(0xffffffffff800003),
UINT64_C(0xffffffffff800007),
UINT64_C(0xffffffffff80000f),
UINT64_C(0xffffffffff80001f),
UINT64_C(0xffffffffff80003f),
UINT64_C(0xffffffffff80007f),
UINT64_C(0xffffffffff8000ff),
UINT64_C(0xffffffffff8001ff),
UINT64_C(0xffffffffff8003ff),
UINT64_C(0xffffffffff8007ff),
UINT64_C(0xffffffffff800fff),
UINT64_C(0xffffffffff801fff),
UINT64_C(0xffffffffff803fff),
UINT64_C(0xffffffffff807fff),
UINT64_C(0xffffffffff80ffff),
UINT64_C(0xffffffffff81ffff),
UINT64_C(0xffffffffff83ffff),
UINT64_C(0xffffffffff87ffff),
UINT64_C(0xffffffffff8fffff),
UINT64_C(0xffffffffff9fffff),
UINT64_C(0xffffffffffbfffff)
},
{
UINT64_C(0xffffffffff000000),
UINT64_C(0xffffffffff000001),
UINT64_C(0xffffffffff000003),
UINT64_C(0xffffffffff000007),
UINT64_C(0xffffffffff00000f),
UINT64_C(0xffffffffff00001f),
UINT64_C(0xffffffffff00003f),
UINT64_C(0xffffffffff00007f),
UINT64_C(0xffffffffff0000ff),
UINT64_C(0xffffffffff0001ff),
UINT64_C(0xffffffffff0003ff),
UINT64_C(0xffffffffff0007ff),
UINT64_C(0xffffffffff000fff),
UINT64_C(0xffffffffff001fff),
UINT64_C(0xffffffffff003fff),
UINT64_C(0xffffffffff007fff),
UINT64_C(0xffffffffff00ffff),
UINT64_C(0xffffffffff01ffff),
UINT64_C(0xffffffffff03ffff),
UINT64_C(0xffffffffff07ffff),
UINT64_C(0xffffffffff0fffff),
UINT64_C(0xffffffffff1fffff),
UINT64_C(0xffffffffff3fffff),
UINT64_C(0xffffffffff7fffff)
},
{
UINT64_C(0xfffffffffe000000),
UINT64_C(0xfffffffffe000001),
UINT64_C(0xfffffffffe000003),
UINT64_C(0xfffffffffe000007),
UINT64_C(0xfffffffffe00000f),
UINT64_C(0xfffffffffe00001f),
UINT64_C(0xfffffffffe00003f),
UINT64_C(0xfffffffffe00007f),
UINT64_C(0xfffffffffe0000ff),
UINT64_C(0xfffffffffe0001ff),
UINT64_C(0xfffffffffe0003ff),
UINT64_C(0xfffffffffe0007ff),
UINT64_C(0xfffffffffe000fff),
UINT64_C(0xfffffffffe001fff),
UINT64_C(0xfffffffffe003fff),
UINT64_C(0xfffffffffe007fff),
UINT64_C(0xfffffffffe00ffff),
UINT64_C(0xfffffffffe01ffff),
UINT64_C(0xfffffffffe03ffff),
UINT64_C(0xfffffffffe07ffff),
UINT64_C(0xfffffffffe0fffff),
UINT64_C(0xfffffffffe1fffff),
UINT64_C(0xfffffffffe3fffff),
UINT64_C(0xfffffffffe7fffff),
UINT64_C(0xfffffffffeffffff)
},
{
UINT64_C(0xfffffffffc000000),
UINT64_C(0xfffffffffc000001),
UINT64_C(0xfffffffffc000003),
UINT64_C(0xfffffffffc000007),
UINT64_C(0xfffffffffc00000f),
UINT64_C(0xfffffffffc00001f),
UINT64_C(0xfffffffffc00003f),
UINT64_C(0xfffffffffc00007f),
UINT64_C(0xfffffffffc0000ff),
UINT64_C(0xfffffffffc0001ff),
UINT64_C(0xfffffffffc0003ff),
UINT64_C(0xfffffffffc0007ff),
UINT64_C(0xfffffffffc000fff),
UINT64_C(0xfffffffffc001fff),
UINT64_C(0xfffffffffc003fff),
UINT64_C(0xfffffffffc007fff),
UINT64_C(0xfffffffffc00ffff),
UINT64_C(0xfffffffffc01ffff),
UINT64_C(0xfffffffffc03ffff),
UINT64_C(0xfffffffffc07ffff),
UINT64_C(0xfffffffffc0fffff),
UINT64_C(0xfffffffffc1fffff),
UINT64_C(0xfffffffffc3fffff),
UINT64_C(0xfffffffffc7fffff),
UINT64_C(0xfffffffffcffffff),
UINT64_C(0xfffffffffdffffff)
},
{
UINT64_C(0xfffffffff8000000),
UINT64_C(0xfffffffff8000001),
UINT64_C(0xfffffffff8000003),
UINT64_C(0xfffffffff8000007),
UINT64_C(0xfffffffff800000f),
UINT64_C(0xfffffffff800001f),
UINT64_C(0xfffffffff800003f),
UINT64_C(0xfffffffff800007f),
UINT64_C(0xfffffffff80000ff),
UINT64_C(0xfffffffff80001ff),
UINT64_C(0xfffffffff80003ff),
UINT64_C(0xfffffffff80007ff),
UINT64_C(0xfffffffff8000fff),
UINT64_C(0xfffffffff8001fff),
UINT64_C(0xfffffffff8003fff),
UINT64_C(0xfffffffff8007fff),
UINT64_C(0xfffffffff800ffff),
UINT64_C(0xfffffffff801ffff),
UINT64_C(0xfffffffff803ffff),
UINT64_C(0xfffffffff807ffff),
UINT64_C(0xfffffffff80fffff),
UINT64_C(0xfffffffff81fffff),
UINT64_C(0xfffffffff83fffff),
UINT64_C(0xfffffffff87fffff),
UINT64_C(0xfffffffff8ffffff),
UINT64_C(0xfffffffff9ffffff),
UINT64_C(0xfffffffffbffffff)
},
{
UINT64_C(0xfffffffff0000000),
UINT64_C(0xfffffffff0000001),
UINT64_C(0xfffffffff0000003),
UINT64_C(0xfffffffff0000007),
UINT64_C(0xfffffffff000000f),
UINT64_C(0xfffffffff000001f),
UINT64_C(0xfffffffff000003f),
UINT64_C(0xfffffffff000007f),
UINT64_C(0xfffffffff00000ff),
UINT64_C(0xfffffffff00001ff),
UINT64_C(0xfffffffff00003ff),
UINT64_C(0xfffffffff00007ff),
UINT64_C(0xfffffffff0000fff),
UINT64_C(0xfffffffff0001fff),
UINT64_C(0xfffffffff0003fff),
UINT64_C(0xfffffffff0007fff),
UINT64_C(0xfffffffff000ffff),
UINT64_C(0xfffffffff001ffff),
UINT64_C(0xfffffffff003ffff),
UINT64_C(0xfffffffff007ffff),
UINT64_C(0xfffffffff00fffff),
UINT64_C(0xfffffffff01fffff),
UINT64_C(0xfffffffff03fffff),
UINT64_C(0xfffffffff07fffff),
UINT64_C(0xfffffffff0ffffff),
UINT64_C(0xfffffffff1ffffff),
UINT64_C(0xfffffffff3ffffff),
UINT64_C(0xfffffffff7ffffff)
},
{
UINT64_C(0xffffffffe0000000),
UINT64_C(0xffffffffe0000001),
UINT64_C(0xffffffffe0000003),
UINT64_C(0xffffffffe0000007),
UINT64_C(0xffffffffe000000f),
UINT64_C(0xffffffffe000001f),
UINT64_C(0xffffffffe000003f),
UINT64_C(0xffffffffe000007f),
UINT64_C(0xffffffffe00000ff),
UINT64_C(0xffffffffe00001ff),
UINT64_C(0xffffffffe00003ff),
UINT64_C(0xffffffffe00007ff),
UINT64_C(0xffffffffe0000fff),
UINT64_C(0xffffffffe0001fff),
UINT64_C(0xffffffffe0003fff),
UINT64_C(0xffffffffe0007fff),
UINT64_C(0xffffffffe000ffff),
UINT64_C(0xffffffffe001ffff),
UINT64_C(0xffffffffe003ffff),
UINT64_C(0xffffffffe007ffff),
UINT64_C(0xffffffffe00fffff),
UINT64_C(0xffffffffe01fffff),
UINT64_C(0xffffffffe03fffff),
UINT64_C(0xffffffffe07fffff),
UINT64_C(0xffffffffe0ffffff),
UINT64_C(0xffffffffe1ffffff),
UINT64_C(0xffffffffe3ffffff),
UINT64_C(0xffffffffe7ffffff),
UINT64_C(0xffffffffefffffff)
},
{
UINT64_C(0xffffffffc0000000),
UINT64_C(0xffffffffc0000001),
UINT64_C(0xffffffffc0000003),
UINT64_C(0xffffffffc0000007),
UINT64_C(0xffffffffc000000f),
UINT64_C(0xffffffffc000001f),
UINT64_C(0xffffffffc000003f),
UINT64_C(0xffffffffc000007f),
UINT64_C(0xffffffffc00000ff),
UINT64_C(0xffffffffc00001ff),
UINT64_C(0xffffffffc00003ff),
UINT64_C(0xffffffffc00007ff),
UINT64_C(0xffffffffc0000fff),
UINT64_C(0xffffffffc0001fff),
UINT64_C(0xffffffffc0003fff),
UINT64_C(0xffffffffc0007fff),
UINT64_C(0xffffffffc000ffff),
UINT64_C(0xffffffffc001ffff),
UINT64_C(0xffffffffc003ffff),
UINT64_C(0xffffffffc007ffff),
UINT64_C(0xffffffffc00fffff),
UINT64_C(0xffffffffc01fffff),
UINT64_C(0xffffffffc03fffff),
UINT64_C(0xffffffffc07fffff),
UINT64_C(0xffffffffc0ffffff),
UINT64_C(0xffffffffc1ffffff),
UINT64_C(0xffffffffc3ffffff),
UINT64_C(0xffffffffc7ffffff),
UINT64_C(0xffffffffcfffffff),
UINT64_C(0xffffffffdfffffff)
},
{
UINT64_C(0xffffffff80000000),
UINT64_C(0xffffffff80000001),
UINT64_C(0xffffffff80000003),
UINT64_C(0xffffffff80000007),
UINT64_C(0xffffffff8000000f),
UINT64_C(0xffffffff8000001f),
UINT64_C(0xffffffff8000003f),
UINT64_C(0xffffffff8000007f),
UINT64_C(0xffffffff800000ff),
UINT64_C(0xffffffff800001ff),
UINT64_C(0xffffffff800003ff),
UINT64_C(0xffffffff800007ff),
UINT64_C(0xffffffff80000fff),
UINT64_C(0xffffffff80001fff),
UINT64_C(0xffffffff80003fff),
UINT64_C(0xffffffff80007fff),
UINT64_C(0xffffffff8000ffff),
UINT64_C(0xffffffff8001ffff),
UINT64_C(0xffffffff8003ffff),
UINT64_C(0xffffffff8007ffff),
UINT64_C(0xffffffff800fffff),
UINT64_C(0xffffffff801fffff),
UINT64_C(0xffffffff803fffff),
UINT64_C(0xffffffff807fffff),
UINT64_C(0xffffffff80ffffff),
UINT64_C(0xffffffff81ffffff),
UINT64_C(0xffffffff83ffffff),
UINT64_C(0xffffffff87ffffff),
UINT64_C(0xffffffff8fffffff),
UINT64_C(0xffffffff9fffffff),
UINT64_C(0xffffffffbfffffff)
},
{
UINT64_C(0xffffffff00000000),
UINT64_C(0xffffffff00000001),
UINT64_C(0xffffffff00000003),
UINT64_C(0xffffffff00000007),
UINT64_C(0xffffffff0000000f),
UINT64_C(0xffffffff0000001f),
UINT64_C(0xffffffff0000003f),
UINT64_C(0xffffffff0000007f),
UINT64_C(0xffffffff000000ff),
UINT64_C(0xffffffff000001ff),
UINT64_C(0xffffffff000003ff),
UINT64_C(0xffffffff000007ff),
UINT64_C(0xffffffff00000fff),
UINT64_C(0xffffffff00001fff),
UINT64_C(0xffffffff00003fff),
UINT64_C(0xffffffff00007fff),
UINT64_C(0xffffffff0000ffff),
UINT64_C(0xffffffff0001ffff),
UINT64_C(0xffffffff0003ffff),
UINT64_C(0xffffffff0007ffff),
UINT64_C(0xffffffff000fffff),
UINT64_C(0xffffffff001fffff),
UINT64_C(0xffffffff003fffff),
UINT64_C(0xffffffff007fffff),
UINT64_C(0xffffffff00ffffff),
UINT64_C(0xffffffff01ffffff),
UINT64_C(0xffffffff03ffffff),
UINT64_C(0xffffffff07ffffff),
UINT64_C(0xffffffff0fffffff),
UINT64_C(0xffffffff1fffffff),
UINT64_C(0xffffffff3fffffff),
UINT64_C(0xffffffff7fffffff)
},
{
UINT64_C(0xfffffffe00000000),
UINT64_C(0xfffffffe00000001),
UINT64_C(0xfffffffe00000003),
UINT64_C(0xfffffffe00000007),
UINT64_C(0xfffffffe0000000f),
UINT64_C(0xfffffffe0000001f),
UINT64_C(0xfffffffe0000003f),
UINT64_C(0xfffffffe0000007f),
UINT64_C(0xfffffffe000000ff),
UINT64_C(0xfffffffe000001ff),
UINT64_C(0xfffffffe000003ff),
UINT64_C(0xfffffffe000007ff),
UINT64_C(0xfffffffe00000fff),
UINT64_C(0xfffffffe00001fff),
UINT64_C(0xfffffffe00003fff),
UINT64_C(0xfffffffe00007fff),
UINT64_C(0xfffffffe0000ffff),
UINT64_C(0xfffffffe0001ffff),
UINT64_C(0xfffffffe0003ffff),
UINT64_C(0xfffffffe0007ffff),
UINT64_C(0xfffffffe000fffff),
UINT64_C(0xfffffffe001fffff),
UINT64_C(0xfffffffe003fffff),
UINT64_C(0xfffffffe007fffff),
UINT64_C(0xfffffffe00ffffff),
UINT64_C(0xfffffffe01ffffff),
UINT64_C(0xfffffffe03ffffff),
UINT64_C(0xfffffffe07ffffff),
UINT64_C(0xfffffffe0fffffff),
UINT64_C(0xfffffffe1fffffff),
UINT64_C(0xfffffffe3fffffff),
UINT64_C(0xfffffffe7fffffff),
UINT64_C(0xfffffffeffffffff)
},
{
UINT64_C(0xfffffffc00000000),
UINT64_C(0xfffffffc00000001),
UINT64_C(0xfffffffc00000003),
UINT64_C(0xfffffffc00000007),
UINT64_C(0xfffffffc0000000f),
UINT64_C(0xfffffffc0000001f),
UINT64_C(0xfffffffc0000003f),
UINT64_C(0xfffffffc0000007f),
UINT64_C(0xfffffffc000000ff),
UINT64_C(0xfffffffc000001ff),
UINT64_C(0xfffffffc000003ff),
UINT64_C(0xfffffffc000007ff),
UINT64_C(0xfffffffc00000fff),
UINT64_C(0xfffffffc00001fff),
UINT64_C(0xfffffffc00003fff),
UINT64_C(0xfffffffc00007fff),
UINT64_C(0xfffffffc0000ffff),
UINT64_C(0xfffffffc0001ffff),
UINT64_C(0xfffffffc0003ffff),
UINT64_C(0xfffffffc0007ffff),
UINT64_C(0xfffffffc000fffff),
UINT64_C(0xfffffffc001fffff),
UINT64_C(0xfffffffc003fffff),
UINT64_C(0xfffffffc007fffff),
UINT64_C(0xfffffffc00ffffff),
UINT64_C(0xfffffffc01ffffff),
UINT64_C(0xfffffffc03ffffff),
UINT64_C(0xfffffffc07ffffff),
UINT64_C(0xfffffffc0fffffff),
UINT64_C(0xfffffffc1fffffff),
UINT64_C(0xfffffffc3fffffff),
UINT64_C(0xfffffffc7fffffff),
UINT64_C(0xfffffffcffffffff),
UINT64_C(0xfffffffdffffffff)
},
{
UINT64_C(0xfffffff800000000),
UINT64_C(0xfffffff800000001),
UINT64_C(0xfffffff800000003),
UINT64_C(0xfffffff800000007),
UINT64_C(0xfffffff80000000f),
UINT64_C(0xfffffff80000001f),
UINT64_C(0xfffffff80000003f),
UINT64_C(0xfffffff80000007f),
UINT64_C(0xfffffff8000000ff),
UINT64_C(0xfffffff8000001ff),
UINT64_C(0xfffffff8000003ff),
UINT64_C(0xfffffff8000007ff),
UINT64_C(0xfffffff800000fff),
UINT64_C(0xfffffff800001fff),
UINT64_C(0xfffffff800003fff),
UINT64_C(0xfffffff800007fff),
UINT64_C(0xfffffff80000ffff),
UINT64_C(0xfffffff80001ffff),
UINT64_C(0xfffffff80003ffff),
UINT64_C(0xfffffff80007ffff),
UINT64_C(0xfffffff8000fffff),
UINT64_C(0xfffffff8001fffff),
UINT64_C(0xfffffff8003fffff),
UINT64_C(0xfffffff8007fffff),
UINT64_C(0xfffffff800ffffff),
UINT64_C(0xfffffff801ffffff),
UINT64_C(0xfffffff803ffffff),
UINT64_C(0xfffffff807ffffff),
UINT64_C(0xfffffff80fffffff),
UINT64_C(0xfffffff81fffffff),
UINT64_C(0xfffffff83fffffff),
UINT64_C(0xfffffff87fffffff),
UINT64_C(0xfffffff8ffffffff),
UINT64_C(0xfffffff9ffffffff),
UINT64_C(0xfffffffbffffffff)
},
{
UINT64_C(0xfffffff000000000),
UINT64_C(0xfffffff000000001),
UINT64_C(0xfffffff000000003),
UINT64_C(0xfffffff000000007),
UINT64_C(0xfffffff00000000f),
UINT64_C(0xfffffff00000001f),
UINT64_C(0xfffffff00000003f),
UINT64_C(0xfffffff00000007f),
UINT64_C(0xfffffff0000000ff),
UINT64_C(0xfffffff0000001ff),
UINT64_C(0xfffffff0000003ff),
UINT64_C(0xfffffff0000007ff),
UINT64_C(0xfffffff000000fff),
UINT64_C(0xfffffff000001fff),
UINT64_C(0xfffffff000003fff),
UINT64_C(0xfffffff000007fff),
UINT64_C(0xfffffff00000ffff),
UINT64_C(0xfffffff00001ffff),
UINT64_C(0xfffffff00003ffff),
UINT64_C(0xfffffff00007ffff),
UINT64_C(0xfffffff0000fffff),
UINT64_C(0xfffffff0001fffff),
UINT64_C(0xfffffff0003fffff),
UINT64_C(0xfffffff0007fffff),
UINT64_C(0xfffffff000ffffff),
UINT64_C(0xfffffff001ffffff),
UINT64_C(0xfffffff003ffffff),
UINT64_C(0xfffffff007ffffff),
UINT64_C(0xfffffff00fffffff),
UINT64_C(0xfffffff01fffffff),
UINT64_C(0xfffffff03fffffff),
UINT64_C(0xfffffff07fffffff),
UINT64_C(0xfffffff0ffffffff),
UINT64_C(0xfffffff1ffffffff),
UINT64_C(0xfffffff3ffffffff),
UINT64_C(0xfffffff7ffffffff)
},
{
UINT64_C(0xffffffe000000000),
UINT64_C(0xffffffe000000001),
UINT64_C(0xffffffe000000003),
UINT64_C(0xffffffe000000007),
UINT64_C(0xffffffe00000000f),
UINT64_C(0xffffffe00000001f),
UINT64_C(0xffffffe00000003f),
UINT64_C(0xffffffe00000007f),
UINT64_C(0xffffffe0000000ff),
UINT64_C(0xffffffe0000001ff),
UINT64_C(0xffffffe0000003ff),
UINT64_C(0xffffffe0000007ff),
UINT64_C(0xffffffe000000fff),
UINT64_C(0xffffffe000001fff),
UINT64_C(0xffffffe000003fff),
UINT64_C(0xffffffe000007fff),
UINT64_C(0xffffffe00000ffff),
UINT64_C(0xffffffe00001ffff),
UINT64_C(0xffffffe00003ffff),
UINT64_C(0xffffffe00007ffff),
UINT64_C(0xffffffe0000fffff),
UINT64_C(0xffffffe0001fffff),
UINT64_C(0xffffffe0003fffff),
UINT64_C(0xffffffe0007fffff),
UINT64_C(0xffffffe000ffffff),
UINT64_C(0xffffffe001ffffff),
UINT64_C(0xffffffe003ffffff),
UINT64_C(0xffffffe007ffffff),
UINT64_C(0xffffffe00fffffff),
UINT64_C(0xffffffe01fffffff),
UINT64_C(0xffffffe03fffffff),
UINT64_C(0xffffffe07fffffff),
UINT64_C(0xffffffe0ffffffff),
UINT64_C(0xffffffe1ffffffff),
UINT64_C(0xffffffe3ffffffff),
UINT64_C(0xffffffe7ffffffff),
UINT64_C(0xffffffefffffffff)
},
{
UINT64_C(0xffffffc000000000),
UINT64_C(0xffffffc000000001),
UINT64_C(0xffffffc000000003),
UINT64_C(0xffffffc000000007),
UINT64_C(0xffffffc00000000f),
UINT64_C(0xffffffc00000001f),
UINT64_C(0xffffffc00000003f),
UINT64_C(0xffffffc00000007f),
UINT64_C(0xffffffc0000000ff),
UINT64_C(0xffffffc0000001ff),
UINT64_C(0xffffffc0000003ff),
UINT64_C(0xffffffc0000007ff),
UINT64_C(0xffffffc000000fff),
UINT64_C(0xffffffc000001fff),
UINT64_C(0xffffffc000003fff),
UINT64_C(0xffffffc000007fff),
UINT64_C(0xffffffc00000ffff),
UINT64_C(0xffffffc00001ffff),
UINT64_C(0xffffffc00003ffff),
UINT64_C(0xffffffc00007ffff),
UINT64_C(0xffffffc0000fffff),
UINT64_C(0xffffffc0001fffff),
UINT64_C(0xffffffc0003fffff),
UINT64_C(0xffffffc0007fffff),
UINT64_C(0xffffffc000ffffff),
UINT64_C(0xffffffc001ffffff),
UINT64_C(0xffffffc003ffffff),
UINT64_C(0xffffffc007ffffff),
UINT64_C(0xffffffc00fffffff),
UINT64_C(0xffffffc01fffffff),
UINT64_C(0xffffffc03fffffff),
UINT64_C(0xffffffc07fffffff),
UINT64_C(0xffffffc0ffffffff),
UINT64_C(0xffffffc1ffffffff),
UINT64_C(0xffffffc3ffffffff),
UINT64_C(0xffffffc7ffffffff),
UINT64_C(0xffffffcfffffffff),
UINT64_C(0xffffffdfffffffff)
},
{
UINT64_C(0xffffff8000000000),
UINT64_C(0xffffff8000000001),
UINT64_C(0xffffff8000000003),
UINT64_C(0xffffff8000000007),
UINT64_C(0xffffff800000000f),
UINT64_C(0xffffff800000001f),
UINT64_C(0xffffff800000003f),
UINT64_C(0xffffff800000007f),
UINT64_C(0xffffff80000000ff),
UINT64_C(0xffffff80000001ff),
UINT64_C(0xffffff80000003ff),
UINT64_C(0xffffff80000007ff),
UINT64_C(0xffffff8000000fff),
UINT64_C(0xffffff8000001fff),
UINT64_C(0xffffff8000003fff),
UINT64_C(0xffffff8000007fff),
UINT64_C(0xffffff800000ffff),
UINT64_C(0xffffff800001ffff),
UINT64_C(0xffffff800003ffff),
UINT64_C(0xffffff800007ffff),
UINT64_C(0xffffff80000fffff),
UINT64_C(0xffffff80001fffff),
UINT64_C(0xffffff80003fffff),
UINT64_C(0xffffff80007fffff),
UINT64_C(0xffffff8000ffffff),
UINT64_C(0xffffff8001ffffff),
UINT64_C(0xffffff8003ffffff),
UINT64_C(0xffffff8007ffffff),
UINT64_C(0xffffff800fffffff),
UINT64_C(0xffffff801fffffff),
UINT64_C(0xffffff803fffffff),
UINT64_C(0xffffff807fffffff),
UINT64_C(0xffffff80ffffffff),
UINT64_C(0xffffff81ffffffff),
UINT64_C(0xffffff83ffffffff),
UINT64_C(0xffffff87ffffffff),
UINT64_C(0xffffff8fffffffff),
UINT64_C(0xffffff9fffffffff),
UINT64_C(0xffffffbfffffffff)
},
{
UINT64_C(0xffffff0000000000),
UINT64_C(0xffffff0000000001),
UINT64_C(0xffffff0000000003),
UINT64_C(0xffffff0000000007),
UINT64_C(0xffffff000000000f),
UINT64_C(0xffffff000000001f),
UINT64_C(0xffffff000000003f),
UINT64_C(0xffffff000000007f),
UINT64_C(0xffffff00000000ff),
UINT64_C(0xffffff00000001ff),
UINT64_C(0xffffff00000003ff),
UINT64_C(0xffffff00000007ff),
UINT64_C(0xffffff0000000fff),
UINT64_C(0xffffff0000001fff),
UINT64_C(0xffffff0000003fff),
UINT64_C(0xffffff0000007fff),
UINT64_C(0xffffff000000ffff),
UINT64_C(0xffffff000001ffff),
UINT64_C(0xffffff000003ffff),
UINT64_C(0xffffff000007ffff),
UINT64_C(0xffffff00000fffff),
UINT64_C(0xffffff00001fffff),
UINT64_C(0xffffff00003fffff),
UINT64_C(0xffffff00007fffff),
UINT64_C(0xffffff0000ffffff),
UINT64_C(0xffffff0001ffffff),
UINT64_C(0xffffff0003ffffff),
UINT64_C(0xffffff0007ffffff),
UINT64_C(0xffffff000fffffff),
UINT64_C(0xffffff001fffffff),
UINT64_C(0xffffff003fffffff),
UINT64_C(0xffffff007fffffff),
UINT64_C(0xffffff00ffffffff),
UINT64_C(0xffffff01ffffffff),
UINT64_C(0xffffff03ffffffff),
UINT64_C(0xffffff07ffffffff),
UINT64_C(0xffffff0fffffffff),
UINT64_C(0xffffff1fffffffff),
UINT64_C(0xffffff3fffffffff),
UINT64_C(0xffffff7fffffffff)
},
{
UINT64_C(0xfffffe0000000000),
UINT64_C(0xfffffe0000000001),
UINT64_C(0xfffffe0000000003),
UINT64_C(0xfffffe0000000007),
UINT64_C(0xfffffe000000000f),
UINT64_C(0xfffffe000000001f),
UINT64_C(0xfffffe000000003f),
UINT64_C(0xfffffe000000007f),
UINT64_C(0xfffffe00000000ff),
UINT64_C(0xfffffe00000001ff),
UINT64_C(0xfffffe00000003ff),
UINT64_C(0xfffffe00000007ff),
UINT64_C(0xfffffe0000000fff),
UINT64_C(0xfffffe0000001fff),
UINT64_C(0xfffffe0000003fff),
UINT64_C(0xfffffe0000007fff),
UINT64_C(0xfffffe000000ffff),
UINT64_C(0xfffffe000001ffff),
UINT64_C(0xfffffe000003ffff),
UINT64_C(0xfffffe000007ffff),
UINT64_C(0xfffffe00000fffff),
UINT64_C(0xfffffe00001fffff),
UINT64_C(0xfffffe00003fffff),
UINT64_C(0xfffffe00007fffff),
UINT64_C(0xfffffe0000ffffff),
UINT64_C(0xfffffe0001ffffff),
UINT64_C(0xfffffe0003ffffff),
UINT64_C(0xfffffe0007ffffff),
UINT64_C(0xfffffe000fffffff),
UINT64_C(0xfffffe001fffffff),
UINT64_C(0xfffffe003fffffff),
UINT64_C(0xfffffe007fffffff),
UINT64_C(0xfffffe00ffffffff),
UINT64_C(0xfffffe01ffffffff),
UINT64_C(0xfffffe03ffffffff),
UINT64_C(0xfffffe07ffffffff),
UINT64_C(0xfffffe0fffffffff),
UINT64_C(0xfffffe1fffffffff),
UINT64_C(0xfffffe3fffffffff),
UINT64_C(0xfffffe7fffffffff),
UINT64_C(0xfffffeffffffffff)
},
{
UINT64_C(0xfffffc0000000000),
UINT64_C(0xfffffc0000000001),
UINT64_C(0xfffffc0000000003),
UINT64_C(0xfffffc0000000007),
UINT64_C(0xfffffc000000000f),
UINT64_C(0xfffffc000000001f),
UINT64_C(0xfffffc000000003f),
UINT64_C(0xfffffc000000007f),
UINT64_C(0xfffffc00000000ff),
UINT64_C(0xfffffc00000001ff),
UINT64_C(0xfffffc00000003ff),
UINT64_C(0xfffffc00000007ff),
UINT64_C(0xfffffc0000000fff),
UINT64_C(0xfffffc0000001fff),
UINT64_C(0xfffffc0000003fff),
UINT64_C(0xfffffc0000007fff),
UINT64_C(0xfffffc000000ffff),
UINT64_C(0xfffffc000001ffff),
UINT64_C(0xfffffc000003ffff),
UINT64_C(0xfffffc000007ffff),
UINT64_C(0xfffffc00000fffff),
UINT64_C(0xfffffc00001fffff),
UINT64_C(0xfffffc00003fffff),
UINT64_C(0xfffffc00007fffff),
UINT64_C(0xfffffc0000ffffff),
UINT64_C(0xfffffc0001ffffff),
UINT64_C(0xfffffc0003ffffff),
UINT64_C(0xfffffc0007ffffff),
UINT64_C(0xfffffc000fffffff),
UINT64_C(0xfffffc001fffffff),
UINT64_C(0xfffffc003fffffff),
UINT64_C(0xfffffc007fffffff),
UINT64_C(0xfffffc00ffffffff),
UINT64_C(0xfffffc01ffffffff),
UINT64_C(0xfffffc03ffffffff),
UINT64_C(0xfffffc07ffffffff),
UINT64_C(0xfffffc0fffffffff),
UINT64_C(0xfffffc1fffffffff),
UINT64_C(0xfffffc3fffffffff),
UINT64_C(0xfffffc7fffffffff),
UINT64_C(0xfffffcffffffffff),
UINT64_C(0xfffffdffffffffff)
},
{
UINT64_C(0xfffff80000000000),
UINT64_C(0xfffff80000000001),
UINT64_C(0xfffff80000000003),
UINT64_C(0xfffff80000000007),
UINT64_C(0xfffff8000000000f),
UINT64_C(0xfffff8000000001f),
UINT64_C(0xfffff8000000003f),
UINT64_C(0xfffff8000000007f),
UINT64_C(0xfffff800000000ff),
UINT64_C(0xfffff800000001ff),
UINT64_C(0xfffff800000003ff),
UINT64_C(0xfffff800000007ff),
UINT64_C(0xfffff80000000fff),
UINT64_C(0xfffff80000001fff),
UINT64_C(0xfffff80000003fff),
UINT64_C(0xfffff80000007fff),
UINT64_C(0xfffff8000000ffff),
UINT64_C(0xfffff8000001ffff),
UINT64_C(0xfffff8000003ffff),
UINT64_C(0xfffff8000007ffff),
UINT64_C(0xfffff800000fffff),
UINT64_C(0xfffff800001fffff),
UINT64_C(0xfffff800003fffff),
UINT64_C(0xfffff800007fffff),
UINT64_C(0xfffff80000ffffff),
UINT64_C(0xfffff80001ffffff),
UINT64_C(0xfffff80003ffffff),
UINT64_C(0xfffff80007ffffff),
UINT64_C(0xfffff8000fffffff),
UINT64_C(0xfffff8001fffffff),
UINT64_C(0xfffff8003fffffff),
UINT64_C(0xfffff8007fffffff),
UINT64_C(0xfffff800ffffffff),
UINT64_C(0xfffff801ffffffff),
UINT64_C(0xfffff803ffffffff),
UINT64_C(0xfffff807ffffffff),
UINT64_C(0xfffff80fffffffff),
UINT64_C(0xfffff81fffffffff),
UINT64_C(0xfffff83fffffffff),
UINT64_C(0xfffff87fffffffff),
UINT64_C(0xfffff8ffffffffff),
UINT64_C(0xfffff9ffffffffff),
UINT64_C(0xfffffbffffffffff)
},
{
UINT64_C(0xfffff00000000000),
UINT64_C(0xfffff00000000001),
UINT64_C(0xfffff00000000003),
UINT64_C(0xfffff00000000007),
UINT64_C(0xfffff0000000000f),
UINT64_C(0xfffff0000000001f),
UINT64_C(0xfffff0000000003f),
UINT64_C(0xfffff0000000007f),
UINT64_C(0xfffff000000000ff),
UINT64_C(0xfffff000000001ff),
UINT64_C(0xfffff000000003ff),
UINT64_C(0xfffff000000007ff),
UINT64_C(0xfffff00000000fff),
UINT64_C(0xfffff00000001fff),
UINT64_C(0xfffff00000003fff),
UINT64_C(0xfffff00000007fff),
UINT64_C(0xfffff0000000ffff),
UINT64_C(0xfffff0000001ffff),
UINT64_C(0xfffff0000003ffff),
UINT64_C(0xfffff0000007ffff),
UINT64_C(0xfffff000000fffff),
UINT64_C(0xfffff000001fffff),
UINT64_C(0xfffff000003fffff),
UINT64_C(0xfffff000007fffff),
UINT64_C(0xfffff00000ffffff),
UINT64_C(0xfffff00001ffffff),
UINT64_C(0xfffff00003ffffff),
UINT64_C(0xfffff00007ffffff),
UINT64_C(0xfffff0000fffffff),
UINT64_C(0xfffff0001fffffff),
UINT64_C(0xfffff0003fffffff),
UINT64_C(0xfffff0007fffffff),
UINT64_C(0xfffff000ffffffff),
UINT64_C(0xfffff001ffffffff),
UINT64_C(0xfffff003ffffffff),
UINT64_C(0xfffff007ffffffff),
UINT64_C(0xfffff00fffffffff),
UINT64_C(0xfffff01fffffffff),
UINT64_C(0xfffff03fffffffff),
UINT64_C(0xfffff07fffffffff),
UINT64_C(0xfffff0ffffffffff),
UINT64_C(0xfffff1ffffffffff),
UINT64_C(0xfffff3ffffffffff),
UINT64_C(0xfffff7ffffffffff)
},
{
UINT64_C(0xffffe00000000000),
UINT64_C(0xffffe00000000001),
UINT64_C(0xffffe00000000003),
UINT64_C(0xffffe00000000007),
UINT64_C(0xffffe0000000000f),
UINT64_C(0xffffe0000000001f),
UINT64_C(0xffffe0000000003f),
UINT64_C(0xffffe0000000007f),
UINT64_C(0xffffe000000000ff),
UINT64_C(0xffffe000000001ff),
UINT64_C(0xffffe000000003ff),
UINT64_C(0xffffe000000007ff),
UINT64_C(0xffffe00000000fff),
UINT64_C(0xffffe00000001fff),
UINT64_C(0xffffe00000003fff),
UINT64_C(0xffffe00000007fff),
UINT64_C(0xffffe0000000ffff),
UINT64_C(0xffffe0000001ffff),
UINT64_C(0xffffe0000003ffff),
UINT64_C(0xffffe0000007ffff),
UINT64_C(0xffffe000000fffff),
UINT64_C(0xffffe000001fffff),
UINT64_C(0xffffe000003fffff),
UINT64_C(0xffffe000007fffff),
UINT64_C(0xffffe00000ffffff),
UINT64_C(0xffffe00001ffffff),
UINT64_C(0xffffe00003ffffff),
UINT64_C(0xffffe00007ffffff),
UINT64_C(0xffffe0000fffffff),
UINT64_C(0xffffe0001fffffff),
UINT64_C(0xffffe0003fffffff),
UINT64_C(0xffffe0007fffffff),
UINT64_C(0xffffe000ffffffff),
UINT64_C(0xffffe001ffffffff),
UINT64_C(0xffffe003ffffffff),
UINT64_C(0xffffe007ffffffff),
UINT64_C(0xffffe00fffffffff),
UINT64_C(0xffffe01fffffffff),
UINT64_C(0xffffe03fffffffff),
UINT64_C(0xffffe07fffffffff),
UINT64_C(0xffffe0ffffffffff),
UINT64_C(0xffffe1ffffffffff),
UINT64_C(0xffffe3ffffffffff),
UINT64_C(0xffffe7ffffffffff),
UINT64_C(0xffffefffffffffff)
},
{
UINT64_C(0xffffc00000000000),
UINT64_C(0xffffc00000000001),
UINT64_C(0xffffc00000000003),
UINT64_C(0xffffc00000000007),
UINT64_C(0xffffc0000000000f),
UINT64_C(0xffffc0000000001f),
UINT64_C(0xffffc0000000003f),
UINT64_C(0xffffc0000000007f),
UINT64_C(0xffffc000000000ff),
UINT64_C(0xffffc000000001ff),
UINT64_C(0xffffc000000003ff),
UINT64_C(0xffffc000000007ff),
UINT64_C(0xffffc00000000fff),
UINT64_C(0xffffc00000001fff),
UINT64_C(0xffffc00000003fff),
UINT64_C(0xffffc00000007fff),
UINT64_C(0xffffc0000000ffff),
UINT64_C(0xffffc0000001ffff),
UINT64_C(0xffffc0000003ffff),
UINT64_C(0xffffc0000007ffff),
UINT64_C(0xffffc000000fffff),
UINT64_C(0xffffc000001fffff),
UINT64_C(0xffffc000003fffff),
UINT64_C(0xffffc000007fffff),
UINT64_C(0xffffc00000ffffff),
UINT64_C(0xffffc00001ffffff),
UINT64_C(0xffffc00003ffffff),
UINT64_C(0xffffc00007ffffff),
UINT64_C(0xffffc0000fffffff),
UINT64_C(0xffffc0001fffffff),
UINT64_C(0xffffc0003fffffff),
UINT64_C(0xffffc0007fffffff),
UINT64_C(0xffffc000ffffffff),
UINT64_C(0xffffc001ffffffff),
UINT64_C(0xffffc003ffffffff),
UINT64_C(0xffffc007ffffffff),
UINT64_C(0xffffc00fffffffff),
UINT64_C(0xffffc01fffffffff),
UINT64_C(0xffffc03fffffffff),
UINT64_C(0xffffc07fffffffff),
UINT64_C(0xffffc0ffffffffff),
UINT64_C(0xffffc1ffffffffff),
UINT64_C(0xffffc3ffffffffff),
UINT64_C(0xffffc7ffffffffff),
UINT64_C(0xffffcfffffffffff),
UINT64_C(0xffffdfffffffffff)
},
{
UINT64_C(0xffff800000000000),
UINT64_C(0xffff800000000001),
UINT64_C(0xffff800000000003),
UINT64_C(0xffff800000000007),
UINT64_C(0xffff80000000000f),
UINT64_C(0xffff80000000001f),
UINT64_C(0xffff80000000003f),
UINT64_C(0xffff80000000007f),
UINT64_C(0xffff8000000000ff),
UINT64_C(0xffff8000000001ff),
UINT64_C(0xffff8000000003ff),
UINT64_C(0xffff8000000007ff),
UINT64_C(0xffff800000000fff),
UINT64_C(0xffff800000001fff),
UINT64_C(0xffff800000003fff),
UINT64_C(0xffff800000007fff),
UINT64_C(0xffff80000000ffff),
UINT64_C(0xffff80000001ffff),
UINT64_C(0xffff80000003ffff),
UINT64_C(0xffff80000007ffff),
UINT64_C(0xffff8000000fffff),
UINT64_C(0xffff8000001fffff),
UINT64_C(0xffff8000003fffff),
UINT64_C(0xffff8000007fffff),
UINT64_C(0xffff800000ffffff),
UINT64_C(0xffff800001ffffff),
UINT64_C(0xffff800003ffffff),
UINT64_C(0xffff800007ffffff),
UINT64_C(0xffff80000fffffff),
UINT64_C(0xffff80001fffffff),
UINT64_C(0xffff80003fffffff),
UINT64_C(0xffff80007fffffff),
UINT64_C(0xffff8000ffffffff),
UINT64_C(0xffff8001ffffffff),
UINT64_C(0xffff8003ffffffff),
UINT64_C(0xffff8007ffffffff),
UINT64_C(0xffff800fffffffff),
UINT64_C(0xffff801fffffffff),
UINT64_C(0xffff803fffffffff),
UINT64_C(0xffff807fffffffff),
UINT64_C(0xffff80ffffffffff),
UINT64_C(0xffff81ffffffffff),
UINT64_C(0xffff83ffffffffff),
UINT64_C(0xffff87ffffffffff),
UINT64_C(0xffff8fffffffffff),
UINT64_C(0xffff9fffffffffff),
UINT64_C(0xffffbfffffffffff)
},
{
UINT64_C(0xffff000000000000),
UINT64_C(0xffff000000000001),
UINT64_C(0xffff000000000003),
UINT64_C(0xffff000000000007),
UINT64_C(0xffff00000000000f),
UINT64_C(0xffff00000000001f),
UINT64_C(0xffff00000000003f),
UINT64_C(0xffff00000000007f),
UINT64_C(0xffff0000000000ff),
UINT64_C(0xffff0000000001ff),
UINT64_C(0xffff0000000003ff),
UINT64_C(0xffff0000000007ff),
UINT64_C(0xffff000000000fff),
UINT64_C(0xffff000000001fff),
UINT64_C(0xffff000000003fff),
UINT64_C(0xffff000000007fff),
UINT64_C(0xffff00000000ffff),
UINT64_C(0xffff00000001ffff),
UINT64_C(0xffff00000003ffff),
UINT64_C(0xffff00000007ffff),
UINT64_C(0xffff0000000fffff),
UINT64_C(0xffff0000001fffff),
UINT64_C(0xffff0000003fffff),
UINT64_C(0xffff0000007fffff),
UINT64_C(0xffff000000ffffff),
UINT64_C(0xffff000001ffffff),
UINT64_C(0xffff000003ffffff),
UINT64_C(0xffff000007ffffff),
UINT64_C(0xffff00000fffffff),
UINT64_C(0xffff00001fffffff),
UINT64_C(0xffff00003fffffff),
UINT64_C(0xffff00007fffffff),
UINT64_C(0xffff0000ffffffff),
UINT64_C(0xffff0001ffffffff),
UINT64_C(0xffff0003ffffffff),
UINT64_C(0xffff0007ffffffff),
UINT64_C(0xffff000fffffffff),
UINT64_C(0xffff001fffffffff),
UINT64_C(0xffff003fffffffff),
UINT64_C(0xffff007fffffffff),
UINT64_C(0xffff00ffffffffff),
UINT64_C(0xffff01ffffffffff),
UINT64_C(0xffff03ffffffffff),
UINT64_C(0xffff07ffffffffff),
UINT64_C(0xffff0fffffffffff),
UINT64_C(0xffff1fffffffffff),
UINT64_C(0xffff3fffffffffff),
UINT64_C(0xffff7fffffffffff)
},
{
UINT64_C(0xfffe000000000000),
UINT64_C(0xfffe000000000001),
UINT64_C(0xfffe000000000003),
UINT64_C(0xfffe000000000007),
UINT64_C(0xfffe00000000000f),
UINT64_C(0xfffe00000000001f),
UINT64_C(0xfffe00000000003f),
UINT64_C(0xfffe00000000007f),
UINT64_C(0xfffe0000000000ff),
UINT64_C(0xfffe0000000001ff),
UINT64_C(0xfffe0000000003ff),
UINT64_C(0xfffe0000000007ff),
UINT64_C(0xfffe000000000fff),
UINT64_C(0xfffe000000001fff),
UINT64_C(0xfffe000000003fff),
UINT64_C(0xfffe000000007fff),
UINT64_C(0xfffe00000000ffff),
UINT64_C(0xfffe00000001ffff),
UINT64_C(0xfffe00000003ffff),
UINT64_C(0xfffe00000007ffff),
UINT64_C(0xfffe0000000fffff),
UINT64_C(0xfffe0000001fffff),
UINT64_C(0xfffe0000003fffff),
UINT64_C(0xfffe0000007fffff),
UINT64_C(0xfffe000000ffffff),
UINT64_C(0xfffe000001ffffff),
UINT64_C(0xfffe000003ffffff),
UINT64_C(0xfffe000007ffffff),
UINT64_C(0xfffe00000fffffff),
UINT64_C(0xfffe00001fffffff),
UINT64_C(0xfffe00003fffffff),
UINT64_C(0xfffe00007fffffff),
UINT64_C(0xfffe0000ffffffff),
UINT64_C(0xfffe0001ffffffff),
UINT64_C(0xfffe0003ffffffff),
UINT64_C(0xfffe0007ffffffff),
UINT64_C(0xfffe000fffffffff),
UINT64_C(0xfffe001fffffffff),
UINT64_C(0xfffe003fffffffff),
UINT64_C(0xfffe007fffffffff),
UINT64_C(0xfffe00ffffffffff),
UINT64_C(0xfffe01ffffffffff),
UINT64_C(0xfffe03ffffffffff),
UINT64_C(0xfffe07ffffffffff),
UINT64_C(0xfffe0fffffffffff),
UINT64_C(0xfffe1fffffffffff),
UINT64_C(0xfffe3fffffffffff),
UINT64_C(0xfffe7fffffffffff),
UINT64_C(0xfffeffffffffffff)
},
{
UINT64_C(0xfffc000000000000),
UINT64_C(0xfffc000000000001),
UINT64_C(0xfffc000000000003),
UINT64_C(0xfffc000000000007),
UINT64_C(0xfffc00000000000f),
UINT64_C(0xfffc00000000001f),
UINT64_C(0xfffc00000000003f),
UINT64_C(0xfffc00000000007f),
UINT64_C(0xfffc0000000000ff),
UINT64_C(0xfffc0000000001ff),
UINT64_C(0xfffc0000000003ff),
UINT64_C(0xfffc0000000007ff),
UINT64_C(0xfffc000000000fff),
UINT64_C(0xfffc000000001fff),
UINT64_C(0xfffc000000003fff),
UINT64_C(0xfffc000000007fff),
UINT64_C(0xfffc00000000ffff),
UINT64_C(0xfffc00000001ffff),
UINT64_C(0xfffc00000003ffff),
UINT64_C(0xfffc00000007ffff),
UINT64_C(0xfffc0000000fffff),
UINT64_C(0xfffc0000001fffff),
UINT64_C(0xfffc0000003fffff),
UINT64_C(0xfffc0000007fffff),
UINT64_C(0xfffc000000ffffff),
UINT64_C(0xfffc000001ffffff),
UINT64_C(0xfffc000003ffffff),
UINT64_C(0xfffc000007ffffff),
UINT64_C(0xfffc00000fffffff),
UINT64_C(0xfffc00001fffffff),
UINT64_C(0xfffc00003fffffff),
UINT64_C(0xfffc00007fffffff),
UINT64_C(0xfffc0000ffffffff),
UINT64_C(0xfffc0001ffffffff),
UINT64_C(0xfffc0003ffffffff),
UINT64_C(0xfffc0007ffffffff),
UINT64_C(0xfffc000fffffffff),
UINT64_C(0xfffc001fffffffff),
UINT64_C(0xfffc003fffffffff),
UINT64_C(0xfffc007fffffffff),
UINT64_C(0xfffc00ffffffffff),
UINT64_C(0xfffc01ffffffffff),
UINT64_C(0xfffc03ffffffffff),
UINT64_C(0xfffc07ffffffffff),
UINT64_C(0xfffc0fffffffffff),
UINT64_C(0xfffc1fffffffffff),
UINT64_C(0xfffc3fffffffffff),
UINT64_C(0xfffc7fffffffffff),
UINT64_C(0xfffcffffffffffff),
UINT64_C(0xfffdffffffffffff)
},
{
UINT64_C(0xfff8000000000000),
UINT64_C(0xfff8000000000001),
UINT64_C(0xfff8000000000003),
UINT64_C(0xfff8000000000007),
UINT64_C(0xfff800000000000f),
UINT64_C(0xfff800000000001f),
UINT64_C(0xfff800000000003f),
UINT64_C(0xfff800000000007f),
UINT64_C(0xfff80000000000ff),
UINT64_C(0xfff80000000001ff),
UINT64_C(0xfff80000000003ff),
UINT64_C(0xfff80000000007ff),
UINT64_C(0xfff8000000000fff),
UINT64_C(0xfff8000000001fff),
UINT64_C(0xfff8000000003fff),
UINT64_C(0xfff8000000007fff),
UINT64_C(0xfff800000000ffff),
UINT64_C(0xfff800000001ffff),
UINT64_C(0xfff800000003ffff),
UINT64_C(0xfff800000007ffff),
UINT64_C(0xfff80000000fffff),
UINT64_C(0xfff80000001fffff),
UINT64_C(0xfff80000003fffff),
UINT64_C(0xfff80000007fffff),
UINT64_C(0xfff8000000ffffff),
UINT64_C(0xfff8000001ffffff),
UINT64_C(0xfff8000003ffffff),
UINT64_C(0xfff8000007ffffff),
UINT64_C(0xfff800000fffffff),
UINT64_C(0xfff800001fffffff),
UINT64_C(0xfff800003fffffff),
UINT64_C(0xfff800007fffffff),
UINT64_C(0xfff80000ffffffff),
UINT64_C(0xfff80001ffffffff),
UINT64_C(0xfff80003ffffffff),
UINT64_C(0xfff80007ffffffff),
UINT64_C(0xfff8000fffffffff),
UINT64_C(0xfff8001fffffffff),
UINT64_C(0xfff8003fffffffff),
UINT64_C(0xfff8007fffffffff),
UINT64_C(0xfff800ffffffffff),
UINT64_C(0xfff801ffffffffff),
UINT64_C(0xfff803ffffffffff),
UINT64_C(0xfff807ffffffffff),
UINT64_C(0xfff80fffffffffff),
UINT64_C(0xfff81fffffffffff),
UINT64_C(0xfff83fffffffffff),
UINT64_C(0xfff87fffffffffff),
UINT64_C(0xfff8ffffffffffff),
UINT64_C(0xfff9ffffffffffff),
UINT64_C(0xfffbffffffffffff)
},
{
UINT64_C(0xfff0000000000000),
UINT64_C(0xfff0000000000001),
UINT64_C(0xfff0000000000003),
UINT64_C(0xfff0000000000007),
UINT64_C(0xfff000000000000f),
UINT64_C(0xfff000000000001f),
UINT64_C(0xfff000000000003f),
UINT64_C(0xfff000000000007f),
UINT64_C(0xfff00000000000ff),
UINT64_C(0xfff00000000001ff),
UINT64_C(0xfff00000000003ff),
UINT64_C(0xfff00000000007ff),
UINT64_C(0xfff0000000000fff),
UINT64_C(0xfff0000000001fff),
UINT64_C(0xfff0000000003fff),
UINT64_C(0xfff0000000007fff),
UINT64_C(0xfff000000000ffff),
UINT64_C(0xfff000000001ffff),
UINT64_C(0xfff000000003ffff),
UINT64_C(0xfff000000007ffff),
UINT64_C(0xfff00000000fffff),
UINT64_C(0xfff00000001fffff),
UINT64_C(0xfff00000003fffff),
UINT64_C(0xfff00000007fffff),
UINT64_C(0xfff0000000ffffff),
UINT64_C(0xfff0000001ffffff),
UINT64_C(0xfff0000003ffffff),
UINT64_C(0xfff0000007ffffff),
UINT64_C(0xfff000000fffffff),
UINT64_C(0xfff000001fffffff),
UINT64_C(0xfff000003fffffff),
UINT64_C(0xfff000007fffffff),
UINT64_C(0xfff00000ffffffff),
UINT64_C(0xfff00001ffffffff),
UINT64_C(0xfff00003ffffffff),
UINT64_C(0xfff00007ffffffff),
UINT64_C(0xfff0000fffffffff),
UINT64_C(0xfff0001fffffffff),
UINT64_C(0xfff0003fffffffff),
UINT64_C(0xfff0007fffffffff),
UINT64_C(0xfff000ffffffffff),
UINT64_C(0xfff001ffffffffff),
UINT64_C(0xfff003ffffffffff),
UINT64_C(0xfff007ffffffffff),
UINT64_C(0xfff00fffffffffff),
UINT64_C(0xfff01fffffffffff),
UINT64_C(0xfff03fffffffffff),
UINT64_C(0xfff07fffffffffff),
UINT64_C(0xfff0ffffffffffff),
UINT64_C(0xfff1ffffffffffff),
UINT64_C(0xfff3ffffffffffff),
UINT64_C(0xfff7ffffffffffff)
},
{
UINT64_C(0xffe0000000000000),
UINT64_C(0xffe0000000000001),
UINT64_C(0xffe0000000000003),
UINT64_C(0xffe0000000000007),
UINT64_C(0xffe000000000000f),
UINT64_C(0xffe000000000001f),
UINT64_C(0xffe000000000003f),
UINT64_C(0xffe000000000007f),
UINT64_C(0xffe00000000000ff),
UINT64_C(0xffe00000000001ff),
UINT64_C(0xffe00000000003ff),
UINT64_C(0xffe00000000007ff),
UINT64_C(0xffe0000000000fff),
UINT64_C(0xffe0000000001fff),
UINT64_C(0xffe0000000003fff),
UINT64_C(0xffe0000000007fff),
UINT64_C(0xffe000000000ffff),
UINT64_C(0xffe000000001ffff),
UINT64_C(0xffe000000003ffff),
UINT64_C(0xffe000000007ffff),
UINT64_C(0xffe00000000fffff),
UINT64_C(0xffe00000001fffff),
UINT64_C(0xffe00000003fffff),
UINT64_C(0xffe00000007fffff),
UINT64_C(0xffe0000000ffffff),
UINT64_C(0xffe0000001ffffff),
UINT64_C(0xffe0000003ffffff),
UINT64_C(0xffe0000007ffffff),
UINT64_C(0xffe000000fffffff),
UINT64_C(0xffe000001fffffff),
UINT64_C(0xffe000003fffffff),
UINT64_C(0xffe000007fffffff),
UINT64_C(0xffe00000ffffffff),
UINT64_C(0xffe00001ffffffff),
UINT64_C(0xffe00003ffffffff),
UINT64_C(0xffe00007ffffffff),
UINT64_C(0xffe0000fffffffff),
UINT64_C(0xffe0001fffffffff),
UINT64_C(0xffe0003fffffffff),
UINT64_C(0xffe0007fffffffff),
UINT64_C(0xffe000ffffffffff),
UINT64_C(0xffe001ffffffffff),
UINT64_C(0xffe003ffffffffff),
UINT64_C(0xffe007ffffffffff),
UINT64_C(0xffe00fffffffffff),
UINT64_C(0xffe01fffffffffff),
UINT64_C(0xffe03fffffffffff),
UINT64_C(0xffe07fffffffffff),
UINT64_C(0xffe0ffffffffffff),
UINT64_C(0xffe1ffffffffffff),
UINT64_C(0xffe3ffffffffffff),
UINT64_C(0xffe7ffffffffffff),
UINT64_C(0xffefffffffffffff)
},
{
UINT64_C(0xffc0000000000000),
UINT64_C(0xffc0000000000001),
UINT64_C(0xffc0000000000003),
UINT64_C(0xffc0000000000007),
UINT64_C(0xffc000000000000f),
UINT64_C(0xffc000000000001f),
UINT64_C(0xffc000000000003f),
UINT64_C(0xffc000000000007f),
UINT64_C(0xffc00000000000ff),
UINT64_C(0xffc00000000001ff),
UINT64_C(0xffc00000000003ff),
UINT64_C(0xffc00000000007ff),
UINT64_C(0xffc0000000000fff),
UINT64_C(0xffc0000000001fff),
UINT64_C(0xffc0000000003fff),
UINT64_C(0xffc0000000007fff),
UINT64_C(0xffc000000000ffff),
UINT64_C(0xffc000000001ffff),
UINT64_C(0xffc000000003ffff),
UINT64_C(0xffc000000007ffff),
UINT64_C(0xffc00000000fffff),
UINT64_C(0xffc00000001fffff),
UINT64_C(0xffc00000003fffff),
UINT64_C(0xffc00000007fffff),
UINT64_C(0xffc0000000ffffff),
UINT64_C(0xffc0000001ffffff),
UINT64_C(0xffc0000003ffffff),
UINT64_C(0xffc0000007ffffff),
UINT64_C(0xffc000000fffffff),
UINT64_C(0xffc000001fffffff),
UINT64_C(0xffc000003fffffff),
UINT64_C(0xffc000007fffffff),
UINT64_C(0xffc00000ffffffff),
UINT64_C(0xffc00001ffffffff),
UINT64_C(0xffc00003ffffffff),
UINT64_C(0xffc00007ffffffff),
UINT64_C(0xffc0000fffffffff),
UINT64_C(0xffc0001fffffffff),
UINT64_C(0xffc0003fffffffff),
UINT64_C(0xffc0007fffffffff),
UINT64_C(0xffc000ffffffffff),
UINT64_C(0xffc001ffffffffff),
UINT64_C(0xffc003ffffffffff),
UINT64_C(0xffc007ffffffffff),
UINT64_C(0xffc00fffffffffff),
UINT64_C(0xffc01fffffffffff),
UINT64_C(0xffc03fffffffffff),
UINT64_C(0xffc07fffffffffff),
UINT64_C(0xffc0ffffffffffff),
UINT64_C(0xffc1ffffffffffff),
UINT64_C(0xffc3ffffffffffff),
UINT64_C(0xffc7ffffffffffff),
UINT64_C(0xffcfffffffffffff),
UINT64_C(0xffdfffffffffffff)
},
{
UINT64_C(0xff80000000000000),
UINT64_C(0xff80000000000001),
UINT64_C(0xff80000000000003),
UINT64_C(0xff80000000000007),
UINT64_C(0xff8000000000000f),
UINT64_C(0xff8000000000001f),
UINT64_C(0xff8000000000003f),
UINT64_C(0xff8000000000007f),
UINT64_C(0xff800000000000ff),
UINT64_C(0xff800000000001ff),
UINT64_C(0xff800000000003ff),
UINT64_C(0xff800000000007ff),
UINT64_C(0xff80000000000fff),
UINT64_C(0xff80000000001fff),
UINT64_C(0xff80000000003fff),
UINT64_C(0xff80000000007fff),
UINT64_C(0xff8000000000ffff),
UINT64_C(0xff8000000001ffff),
UINT64_C(0xff8000000003ffff),
UINT64_C(0xff8000000007ffff),
UINT64_C(0xff800000000fffff),
UINT64_C(0xff800000001fffff),
UINT64_C(0xff800000003fffff),
UINT64_C(0xff800000007fffff),
UINT64_C(0xff80000000ffffff),
UINT64_C(0xff80000001ffffff),
UINT64_C(0xff80000003ffffff),
UINT64_C(0xff80000007ffffff),
UINT64_C(0xff8000000fffffff),
UINT64_C(0xff8000001fffffff),
UINT64_C(0xff8000003fffffff),
UINT64_C(0xff8000007fffffff),
UINT64_C(0xff800000ffffffff),
UINT64_C(0xff800001ffffffff),
UINT64_C(0xff800003ffffffff),
UINT64_C(0xff800007ffffffff),
UINT64_C(0xff80000fffffffff),
UINT64_C(0xff80001fffffffff),
UINT64_C(0xff80003fffffffff),
UINT64_C(0xff80007fffffffff),
UINT64_C(0xff8000ffffffffff),
UINT64_C(0xff8001ffffffffff),
UINT64_C(0xff8003ffffffffff),
UINT64_C(0xff8007ffffffffff),
UINT64_C(0xff800fffffffffff),
UINT64_C(0xff801fffffffffff),
UINT64_C(0xff803fffffffffff),
UINT64_C(0xff807fffffffffff),
UINT64_C(0xff80ffffffffffff),
UINT64_C(0xff81ffffffffffff),
UINT64_C(0xff83ffffffffffff),
UINT64_C(0xff87ffffffffffff),
UINT64_C(0xff8fffffffffffff),
UINT64_C(0xff9fffffffffffff),
UINT64_C(0xffbfffffffffffff)
},
{
UINT64_C(0xff00000000000000),
UINT64_C(0xff00000000000001),
UINT64_C(0xff00000000000003),
UINT64_C(0xff00000000000007),
UINT64_C(0xff0000000000000f),
UINT64_C(0xff0000000000001f),
UINT64_C(0xff0000000000003f),
UINT64_C(0xff0000000000007f),
UINT64_C(0xff000000000000ff),
UINT64_C(0xff000000000001ff),
UINT64_C(0xff000000000003ff),
UINT64_C(0xff000000000007ff),
UINT64_C(0xff00000000000fff),
UINT64_C(0xff00000000001fff),
UINT64_C(0xff00000000003fff),
UINT64_C(0xff00000000007fff),
UINT64_C(0xff0000000000ffff),
UINT64_C(0xff0000000001ffff),
UINT64_C(0xff0000000003ffff),
UINT64_C(0xff0000000007ffff),
UINT64_C(0xff000000000fffff),
UINT64_C(0xff000000001fffff),
UINT64_C(0xff000000003fffff),
UINT64_C(0xff000000007fffff),
UINT64_C(0xff00000000ffffff),
UINT64_C(0xff00000001ffffff),
UINT64_C(0xff00000003ffffff),
UINT64_C(0xff00000007ffffff),
UINT64_C(0xff0000000fffffff),
UINT64_C(0xff0000001fffffff),
UINT64_C(0xff0000003fffffff),
UINT64_C(0xff0000007fffffff),
UINT64_C(0xff000000ffffffff),
UINT64_C(0xff000001ffffffff),
UINT64_C(0xff000003ffffffff),
UINT64_C(0xff000007ffffffff),
UINT64_C(0xff00000fffffffff),
UINT64_C(0xff00001fffffffff),
UINT64_C(0xff00003fffffffff),
UINT64_C(0xff00007fffffffff),
UINT64_C(0xff0000ffffffffff),
UINT64_C(0xff0001ffffffffff),
UINT64_C(0xff0003ffffffffff),
UINT64_C(0xff0007ffffffffff),
UINT64_C(0xff000fffffffffff),
UINT64_C(0xff001fffffffffff),
UINT64_C(0xff003fffffffffff),
UINT64_C(0xff007fffffffffff),
UINT64_C(0xff00ffffffffffff),
UINT64_C(0xff01ffffffffffff),
UINT64_C(0xff03ffffffffffff),
UINT64_C(0xff07ffffffffffff),
UINT64_C(0xff0fffffffffffff),
UINT64_C(0xff1fffffffffffff),
UINT64_C(0xff3fffffffffffff),
UINT64_C(0xff7fffffffffffff)
},
{
UINT64_C(0xfe00000000000000),
UINT64_C(0xfe00000000000001),
UINT64_C(0xfe00000000000003),
UINT64_C(0xfe00000000000007),
UINT64_C(0xfe0000000000000f),
UINT64_C(0xfe0000000000001f),
UINT64_C(0xfe0000000000003f),
UINT64_C(0xfe0000000000007f),
UINT64_C(0xfe000000000000ff),
UINT64_C(0xfe000000000001ff),
UINT64_C(0xfe000000000003ff),
UINT64_C(0xfe000000000007ff),
UINT64_C(0xfe00000000000fff),
UINT64_C(0xfe00000000001fff),
UINT64_C(0xfe00000000003fff),
UINT64_C(0xfe00000000007fff),
UINT64_C(0xfe0000000000ffff),
UINT64_C(0xfe0000000001ffff),
UINT64_C(0xfe0000000003ffff),
UINT64_C(0xfe0000000007ffff),
UINT64_C(0xfe000000000fffff),
UINT64_C(0xfe000000001fffff),
UINT64_C(0xfe000000003fffff),
UINT64_C(0xfe000000007fffff),
UINT64_C(0xfe00000000ffffff),
UINT64_C(0xfe00000001ffffff),
UINT64_C(0xfe00000003ffffff),
UINT64_C(0xfe00000007ffffff),
UINT64_C(0xfe0000000fffffff),
UINT64_C(0xfe0000001fffffff),
UINT64_C(0xfe0000003fffffff),
UINT64_C(0xfe0000007fffffff),
UINT64_C(0xfe000000ffffffff),
UINT64_C(0xfe000001ffffffff),
UINT64_C(0xfe000003ffffffff),
UINT64_C(0xfe000007ffffffff),
UINT64_C(0xfe00000fffffffff),
UINT64_C(0xfe00001fffffffff),
UINT64_C(0xfe00003fffffffff),
UINT64_C(0xfe00007fffffffff),
UINT64_C(0xfe0000ffffffffff),
UINT64_C(0xfe0001ffffffffff),
UINT64_C(0xfe0003ffffffffff),
UINT64_C(0xfe0007ffffffffff),
UINT64_C(0xfe000fffffffffff),
UINT64_C(0xfe001fffffffffff),
UINT64_C(0xfe003fffffffffff),
UINT64_C(0xfe007fffffffffff),
UINT64_C(0xfe00ffffffffffff),
UINT64_C(0xfe01ffffffffffff),
UINT64_C(0xfe03ffffffffffff),
UINT64_C(0xfe07ffffffffffff),
UINT64_C(0xfe0fffffffffffff),
UINT64_C(0xfe1fffffffffffff),
UINT64_C(0xfe3fffffffffffff),
UINT64_C(0xfe7fffffffffffff),
UINT64_C(0xfeffffffffffffff)
},
{
UINT64_C(0xfc00000000000000),
UINT64_C(0xfc00000000000001),
UINT64_C(0xfc00000000000003),
UINT64_C(0xfc00000000000007),
UINT64_C(0xfc0000000000000f),
UINT64_C(0xfc0000000000001f),
UINT64_C(0xfc0000000000003f),
UINT64_C(0xfc0000000000007f),
UINT64_C(0xfc000000000000ff),
UINT64_C(0xfc000000000001ff),
UINT64_C(0xfc000000000003ff),
UINT64_C(0xfc000000000007ff),
UINT64_C(0xfc00000000000fff),
UINT64_C(0xfc00000000001fff),
UINT64_C(0xfc00000000003fff),
UINT64_C(0xfc00000000007fff),
UINT64_C(0xfc0000000000ffff),
UINT64_C(0xfc0000000001ffff),
UINT64_C(0xfc0000000003ffff),
UINT64_C(0xfc0000000007ffff),
UINT64_C(0xfc000000000fffff),
UINT64_C(0xfc000000001fffff),
UINT64_C(0xfc000000003fffff),
UINT64_C(0xfc000000007fffff),
UINT64_C(0xfc00000000ffffff),
UINT64_C(0xfc00000001ffffff),
UINT64_C(0xfc00000003ffffff),
UINT64_C(0xfc00000007ffffff),
UINT64_C(0xfc0000000fffffff),
UINT64_C(0xfc0000001fffffff),
UINT64_C(0xfc0000003fffffff),
UINT64_C(0xfc0000007fffffff),
UINT64_C(0xfc000000ffffffff),
UINT64_C(0xfc000001ffffffff),
UINT64_C(0xfc000003ffffffff),
UINT64_C(0xfc000007ffffffff),
UINT64_C(0xfc00000fffffffff),
UINT64_C(0xfc00001fffffffff),
UINT64_C(0xfc00003fffffffff),
UINT64_C(0xfc00007fffffffff),
UINT64_C(0xfc0000ffffffffff),
UINT64_C(0xfc0001ffffffffff),
UINT64_C(0xfc0003ffffffffff),
UINT64_C(0xfc0007ffffffffff),
UINT64_C(0xfc000fffffffffff),
UINT64_C(0xfc001fffffffffff),
UINT64_C(0xfc003fffffffffff),
UINT64_C(0xfc007fffffffffff),
UINT64_C(0xfc00ffffffffffff),
UINT64_C(0xfc01ffffffffffff),
UINT64_C(0xfc03ffffffffffff),
UINT64_C(0xfc07ffffffffffff),
UINT64_C(0xfc0fffffffffffff),
UINT64_C(0xfc1fffffffffffff),
UINT64_C(0xfc3fffffffffffff),
UINT64_C(0xfc7fffffffffffff),
UINT64_C(0xfcffffffffffffff),
UINT64_C(0xfdffffffffffffff)
},
{
UINT64_C(0xf800000000000000),
UINT64_C(0xf800000000000001),
UINT64_C(0xf800000000000003),
UINT64_C(0xf800000000000007),
UINT64_C(0xf80000000000000f),
UINT64_C(0xf80000000000001f),
UINT64_C(0xf80000000000003f),
UINT64_C(0xf80000000000007f),
UINT64_C(0xf8000000000000ff),
UINT64_C(0xf8000000000001ff),
UINT64_C(0xf8000000000003ff),
UINT64_C(0xf8000000000007ff),
UINT64_C(0xf800000000000fff),
UINT64_C(0xf800000000001fff),
UINT64_C(0xf800000000003fff),
UINT64_C(0xf800000000007fff),
UINT64_C(0xf80000000000ffff),
UINT64_C(0xf80000000001ffff),
UINT64_C(0xf80000000003ffff),
UINT64_C(0xf80000000007ffff),
UINT64_C(0xf8000000000fffff),
UINT64_C(0xf8000000001fffff),
UINT64_C(0xf8000000003fffff),
UINT64_C(0xf8000000007fffff),
UINT64_C(0xf800000000ffffff),
UINT64_C(0xf800000001ffffff),
UINT64_C(0xf800000003ffffff),
UINT64_C(0xf800000007ffffff),
UINT64_C(0xf80000000fffffff),
UINT64_C(0xf80000001fffffff),
UINT64_C(0xf80000003fffffff),
UINT64_C(0xf80000007fffffff),
UINT64_C(0xf8000000ffffffff),
UINT64_C(0xf8000001ffffffff),
UINT64_C(0xf8000003ffffffff),
UINT64_C(0xf8000007ffffffff),
UINT64_C(0xf800000fffffffff),
UINT64_C(0xf800001fffffffff),
UINT64_C(0xf800003fffffffff),
UINT64_C(0xf800007fffffffff),
UINT64_C(0xf80000ffffffffff),
UINT64_C(0xf80001ffffffffff),
UINT64_C(0xf80003ffffffffff),
UINT64_C(0xf80007ffffffffff),
UINT64_C(0xf8000fffffffffff),
UINT64_C(0xf8001fffffffffff),
UINT64_C(0xf8003fffffffffff),
UINT64_C(0xf8007fffffffffff),
UINT64_C(0xf800ffffffffffff),
UINT64_C(0xf801ffffffffffff),
UINT64_C(0xf803ffffffffffff),
UINT64_C(0xf807ffffffffffff),
UINT64_C(0xf80fffffffffffff),
UINT64_C(0xf81fffffffffffff),
UINT64_C(0xf83fffffffffffff),
UINT64_C(0xf87fffffffffffff),
UINT64_C(0xf8ffffffffffffff),
UINT64_C(0xf9ffffffffffffff),
UINT64_C(0xfbffffffffffffff)
},
{
UINT64_C(0xf000000000000000),
UINT64_C(0xf000000000000001),
UINT64_C(0xf000000000000003),
UINT64_C(0xf000000000000007),
UINT64_C(0xf00000000000000f),
UINT64_C(0xf00000000000001f),
UINT64_C(0xf00000000000003f),
UINT64_C(0xf00000000000007f),
UINT64_C(0xf0000000000000ff),
UINT64_C(0xf0000000000001ff),
UINT64_C(0xf0000000000003ff),
UINT64_C(0xf0000000000007ff),
UINT64_C(0xf000000000000fff),
UINT64_C(0xf000000000001fff),
UINT64_C(0xf000000000003fff),
UINT64_C(0xf000000000007fff),
UINT64_C(0xf00000000000ffff),
UINT64_C(0xf00000000001ffff),
UINT64_C(0xf00000000003ffff),
UINT64_C(0xf00000000007ffff),
UINT64_C(0xf0000000000fffff),
UINT64_C(0xf0000000001fffff),
UINT64_C(0xf0000000003fffff),
UINT64_C(0xf0000000007fffff),
UINT64_C(0xf000000000ffffff),
UINT64_C(0xf000000001ffffff),
UINT64_C(0xf000000003ffffff),
UINT64_C(0xf000000007ffffff),
UINT64_C(0xf00000000fffffff),
UINT64_C(0xf00000001fffffff),
UINT64_C(0xf00000003fffffff),
UINT64_C(0xf00000007fffffff),
UINT64_C(0xf0000000ffffffff),
UINT64_C(0xf0000001ffffffff),
UINT64_C(0xf0000003ffffffff),
UINT64_C(0xf0000007ffffffff),
UINT64_C(0xf000000fffffffff),
UINT64_C(0xf000001fffffffff),
UINT64_C(0xf000003fffffffff),
UINT64_C(0xf000007fffffffff),
UINT64_C(0xf00000ffffffffff),
UINT64_C(0xf00001ffffffffff),
UINT64_C(0xf00003ffffffffff),
UINT64_C(0xf00007ffffffffff),
UINT64_C(0xf0000fffffffffff),
UINT64_C(0xf0001fffffffffff),
UINT64_C(0xf0003fffffffffff),
UINT64_C(0xf0007fffffffffff),
UINT64_C(0xf000ffffffffffff),
UINT64_C(0xf001ffffffffffff),
UINT64_C(0xf003ffffffffffff),
UINT64_C(0xf007ffffffffffff),
UINT64_C(0xf00fffffffffffff),
UINT64_C(0xf01fffffffffffff),
UINT64_C(0xf03fffffffffffff),
UINT64_C(0xf07fffffffffffff),
UINT64_C(0xf0ffffffffffffff),
UINT64_C(0xf1ffffffffffffff),
UINT64_C(0xf3ffffffffffffff),
UINT64_C(0xf7ffffffffffffff)
},
{
UINT64_C(0xe000000000000000),
UINT64_C(0xe000000000000001),
UINT64_C(0xe000000000000003),
UINT64_C(0xe000000000000007),
UINT64_C(0xe00000000000000f),
UINT64_C(0xe00000000000001f),
UINT64_C(0xe00000000000003f),
UINT64_C(0xe00000000000007f),
UINT64_C(0xe0000000000000ff),
UINT64_C(0xe0000000000001ff),
UINT64_C(0xe0000000000003ff),
UINT64_C(0xe0000000000007ff),
UINT64_C(0xe000000000000fff),
UINT64_C(0xe000000000001fff),
UINT64_C(0xe000000000003fff),
UINT64_C(0xe000000000007fff),
UINT64_C(0xe00000000000ffff),
UINT64_C(0xe00000000001ffff),
UINT64_C(0xe00000000003ffff),
UINT64_C(0xe00000000007ffff),
UINT64_C(0xe0000000000fffff),
UINT64_C(0xe0000000001fffff),
UINT64_C(0xe0000000003fffff),
UINT64_C(0xe0000000007fffff),
UINT64_C(0xe000000000ffffff),
UINT64_C(0xe000000001ffffff),
UINT64_C(0xe000000003ffffff),
UINT64_C(0xe000000007ffffff),
UINT64_C(0xe00000000fffffff),
UINT64_C(0xe00000001fffffff),
UINT64_C(0xe00000003fffffff),
UINT64_C(0xe00000007fffffff),
UINT64_C(0xe0000000ffffffff),
UINT64_C(0xe0000001ffffffff),
UINT64_C(0xe0000003ffffffff),
UINT64_C(0xe0000007ffffffff),
UINT64_C(0xe000000fffffffff),
UINT64_C(0xe000001fffffffff),
UINT64_C(0xe000003fffffffff),
UINT64_C(0xe000007fffffffff),
UINT64_C(0xe00000ffffffffff),
UINT64_C(0xe00001ffffffffff),
UINT64_C(0xe00003ffffffffff),
UINT64_C(0xe00007ffffffffff),
UINT64_C(0xe0000fffffffffff),
UINT64_C(0xe0001fffffffffff),
UINT64_C(0xe0003fffffffffff),
UINT64_C(0xe0007fffffffffff),
UINT64_C(0xe000ffffffffffff),
UINT64_C(0xe001ffffffffffff),
UINT64_C(0xe003ffffffffffff),
UINT64_C(0xe007ffffffffffff),
UINT64_C(0xe00fffffffffffff),
UINT64_C(0xe01fffffffffffff),
UINT64_C(0xe03fffffffffffff),
UINT64_C(0xe07fffffffffffff),
UINT64_C(0xe0ffffffffffffff),
UINT64_C(0xe1ffffffffffffff),
UINT64_C(0xe3ffffffffffffff),
UINT64_C(0xe7ffffffffffffff),
UINT64_C(0xefffffffffffffff)
},
{
UINT64_C(0xc000000000000000),
UINT64_C(0xc000000000000001),
UINT64_C(0xc000000000000003),
UINT64_C(0xc000000000000007),
UINT64_C(0xc00000000000000f),
UINT64_C(0xc00000000000001f),
UINT64_C(0xc00000000000003f),
UINT64_C(0xc00000000000007f),
UINT64_C(0xc0000000000000ff),
UINT64_C(0xc0000000000001ff),
UINT64_C(0xc0000000000003ff),
UINT64_C(0xc0000000000007ff),
UINT64_C(0xc000000000000fff),
UINT64_C(0xc000000000001fff),
UINT64_C(0xc000000000003fff),
UINT64_C(0xc000000000007fff),
UINT64_C(0xc00000000000ffff),
UINT64_C(0xc00000000001ffff),
UINT64_C(0xc00000000003ffff),
UINT64_C(0xc00000000007ffff),
UINT64_C(0xc0000000000fffff),
UINT64_C(0xc0000000001fffff),
UINT64_C(0xc0000000003fffff),
UINT64_C(0xc0000000007fffff),
UINT64_C(0xc000000000ffffff),
UINT64_C(0xc000000001ffffff),
UINT64_C(0xc000000003ffffff),
UINT64_C(0xc000000007ffffff),
UINT64_C(0xc00000000fffffff),
UINT64_C(0xc00000001fffffff),
UINT64_C(0xc00000003fffffff),
UINT64_C(0xc00000007fffffff),
UINT64_C(0xc0000000ffffffff),
UINT64_C(0xc0000001ffffffff),
UINT64_C(0xc0000003ffffffff),
UINT64_C(0xc0000007ffffffff),
UINT64_C(0xc000000fffffffff),
UINT64_C(0xc000001fffffffff),
UINT64_C(0xc000003fffffffff),
UINT64_C(0xc000007fffffffff),
UINT64_C(0xc00000ffffffffff),
UINT64_C(0xc00001ffffffffff),
UINT64_C(0xc00003ffffffffff),
UINT64_C(0xc00007ffffffffff),
UINT64_C(0xc0000fffffffffff),
UINT64_C(0xc0001fffffffffff),
UINT64_C(0xc0003fffffffffff),
UINT64_C(0xc0007fffffffffff),
UINT64_C(0xc000ffffffffffff),
UINT64_C(0xc001ffffffffffff),
UINT64_C(0xc003ffffffffffff),
UINT64_C(0xc007ffffffffffff),
UINT64_C(0xc00fffffffffffff),
UINT64_C(0xc01fffffffffffff),
UINT64_C(0xc03fffffffffffff),
UINT64_C(0xc07fffffffffffff),
UINT64_C(0xc0ffffffffffffff),
UINT64_C(0xc1ffffffffffffff),
UINT64_C(0xc3ffffffffffffff),
UINT64_C(0xc7ffffffffffffff),
UINT64_C(0xcfffffffffffffff),
UINT64_C(0xdfffffffffffffff)
},
{
UINT64_C(0x8000000000000000),
UINT64_C(0x8000000000000001),
UINT64_C(0x8000000000000003),
UINT64_C(0x8000000000000007),
UINT64_C(0x800000000000000f),
UINT64_C(0x800000000000001f),
UINT64_C(0x800000000000003f),
UINT64_C(0x800000000000007f),
UINT64_C(0x80000000000000ff),
UINT64_C(0x80000000000001ff),
UINT64_C(0x80000000000003ff),
UINT64_C(0x80000000000007ff),
UINT64_C(0x8000000000000fff),
UINT64_C(0x8000000000001fff),
UINT64_C(0x8000000000003fff),
UINT64_C(0x8000000000007fff),
UINT64_C(0x800000000000ffff),
UINT64_C(0x800000000001ffff),
UINT64_C(0x800000000003ffff),
UINT64_C(0x800000000007ffff),
UINT64_C(0x80000000000fffff),
UINT64_C(0x80000000001fffff),
UINT64_C(0x80000000003fffff),
UINT64_C(0x80000000007fffff),
UINT64_C(0x8000000000ffffff),
UINT64_C(0x8000000001ffffff),
UINT64_C(0x8000000003ffffff),
UINT64_C(0x8000000007ffffff),
UINT64_C(0x800000000fffffff),
UINT64_C(0x800000001fffffff),
UINT64_C(0x800000003fffffff),
UINT64_C(0x800000007fffffff),
UINT64_C(0x80000000ffffffff),
UINT64_C(0x80000001ffffffff),
UINT64_C(0x80000003ffffffff),
UINT64_C(0x80000007ffffffff),
UINT64_C(0x8000000fffffffff),
UINT64_C(0x8000001fffffffff),
UINT64_C(0x8000003fffffffff),
UINT64_C(0x8000007fffffffff),
UINT64_C(0x800000ffffffffff),
UINT64_C(0x800001ffffffffff),
UINT64_C(0x800003ffffffffff),
UINT64_C(0x800007ffffffffff),
UINT64_C(0x80000fffffffffff),
UINT64_C(0x80001fffffffffff),
UINT64_C(0x80003fffffffffff),
UINT64_C(0x80007fffffffffff),
UINT64_C(0x8000ffffffffffff),
UINT64_C(0x8001ffffffffffff),
UINT64_C(0x8003ffffffffffff),
UINT64_C(0x8007ffffffffffff),
UINT64_C(0x800fffffffffffff),
UINT64_C(0x801fffffffffffff),
UINT64_C(0x803fffffffffffff),
UINT64_C(0x807fffffffffffff),
UINT64_C(0x80ffffffffffffff),
UINT64_C(0x81ffffffffffffff),
UINT64_C(0x83ffffffffffffff),
UINT64_C(0x87ffffffffffffff),
UINT64_C(0x8fffffffffffffff),
UINT64_C(0x9fffffffffffffff),
UINT64_C(0xbfffffffffffffff)
},
{
UINT64_C(0x0),
UINT64_C(0x1),
UINT64_C(0x3),
UINT64_C(0x7),
UINT64_C(0xf),
UINT64_C(0x1f),
UINT64_C(0x3f),
UINT64_C(0x7f),
UINT64_C(0xff),
UINT64_C(0x1ff),
UINT64_C(0x3ff),
UINT64_C(0x7ff),
UINT64_C(0xfff),
UINT64_C(0x1fff),
UINT64_C(0x3fff),
UINT64_C(0x7fff),
UINT64_C(0xffff),
UINT64_C(0x1ffff),
UINT64_C(0x3ffff),
UINT64_C(0x7ffff),
UINT64_C(0xfffff),
UINT64_C(0x1fffff),
UINT64_C(0x3fffff),
UINT64_C(0x7fffff),
UINT64_C(0xffffff),
UINT64_C(0x1ffffff),
UINT64_C(0x3ffffff),
UINT64_C(0x7ffffff),
UINT64_C(0xfffffff),
UINT64_C(0x1fffffff),
UINT64_C(0x3fffffff),
UINT64_C(0x7fffffff),
UINT64_C(0xffffffff),
UINT64_C(0x1ffffffff),
UINT64_C(0x3ffffffff),
UINT64_C(0x7ffffffff),
UINT64_C(0xfffffffff),
UINT64_C(0x1fffffffff),
UINT64_C(0x3fffffffff),
UINT64_C(0x7fffffffff),
UINT64_C(0xffffffffff),
UINT64_C(0x1ffffffffff),
UINT64_C(0x3ffffffffff),
UINT64_C(0x7ffffffffff),
UINT64_C(0xfffffffffff),
UINT64_C(0x1fffffffffff),
UINT64_C(0x3fffffffffff),
UINT64_C(0x7fffffffffff),
UINT64_C(0xffffffffffff),
UINT64_C(0x1ffffffffffff),
UINT64_C(0x3ffffffffffff),
UINT64_C(0x7ffffffffffff),
UINT64_C(0xfffffffffffff),
UINT64_C(0x1fffffffffffff),
UINT64_C(0x3fffffffffffff),
UINT64_C(0x7fffffffffffff),
UINT64_C(0xffffffffffffff),
UINT64_C(0x1ffffffffffffff),
UINT64_C(0x3ffffffffffffff),
UINT64_C(0x7ffffffffffffff),
UINT64_C(0xfffffffffffffff),
UINT64_C(0x1fffffffffffffff),
UINT64_C(0x3fffffffffffffff),
UINT64_C(0x7fffffffffffffff)
}
};

} // namespace sc_dt
// Taf!
