/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_EXPORTCMD_H
#define _SC_EXPORTCMD_H

// sc
#include "ScCmd.h"
#include "svn/svn.h"
class ExportParam;
class CmdResultCallback;

/**
 * Command for exporting a working copy or repository ulr.
 */
class ExportCmd : public ScCmd
{
public:
  /**
   * Construct a ExportCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  ExportCmd( ExportParam* param, CmdResultCallback* cb );
  ~ExportCmd();

  void run();

private:
  // in
  ExportParam*       _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_EXPORTCMD_H
