/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_EDITCONFLICTCMD_H
#define _SC_EDITCONFLICTCMD_H

// sc
#include "ScCmd.h"
class EditConflictParam;
class CmdResultCallback;


/**
 * Command for resolving merge conflicts on a working copy file.
 */
class EditConflictCmd : public ScCmd
{
public:
  /**
   * Construct a EditConflictCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  EditConflictCmd( EditConflictParam* param, CmdResultCallback* );
  ~EditConflictCmd();

  void run();

private:
  // in
  EditConflictParam* _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_EDITCONFLICTCMD_H
