/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "ListViewColumnTooltips.h"

// qt
#include <Qt3Support/Q3ListView>
#include <Qt3Support/Q3Header>


ListViewColumnTooltips::ListViewColumnTooltips( Q3ListView* parent, const QStringList& tooltips )
: /*QToolTip(parent),*/ _w(parent), _tooltips(tooltips)
{
}

ListViewColumnTooltips::~ListViewColumnTooltips()
{
}

void ListViewColumnTooltips::maybeTip( const QPoint& p )
{
  Q3Header* h = _w->header();

  for( int cnt = 0; cnt < h->count(); cnt++ )
  {
    QRect r = h->sectionRect(cnt);
    if( r.contains(p) )
    {
      QString sTip = _q(_tooltips[cnt]);

#if 0
      if( cnt == 0 )
      {
        sTip += " - " + h->label(cnt);
      }
#endif

      //tip( r, sTip );
      break;
    }
  }
}
