/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "BlameDialog.h"
#include "BlameLineLvi.h"
#include "BlameViewModel.h"
#include "RevisionWidget.h"
#include "Settings.h"
#include "sublib/Gui.h"
#include "sublib/settings/LayoutSettings.h"
#include "svn/BlameLine.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QPushButton>
#include <Qt3Support/Q3ListView>
#include <Qt3Support/Q3GroupBox>
#include <Qt3Support/Q3Header>
#include <Qt3Support/Q3HBox>


BlameDialog::BlameDialog( BlameViewModel* model, const QFont& font, QWidget *parent )
: super( 0, "", Qt::WStyle_Customize | Qt::WType_TopLevel | Qt::WStyle_MinMax |
  Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu |
  Qt::WDestructiveClose ), TargetId(this), _model(model)
{
  setName( "BlameDialog" );
  setCaption( QString(_q("subcommander:blame (%1)")).arg(
    (const char*)_model->getName()) );

  QVBoxLayout *vbl = new QVBoxLayout(this,5,8);
  vbl->setSpacing(10);
  {
    Q3GroupBox* gb = new Q3GroupBox(1,Qt::Vertical,this);
    gb->setTitle( _q("blame options: ") );
    gb->setInsideMargin(0);
    gb->setFlat(true);
    vbl->addWidget(gb);
    {
      Q3HBox* hb = new Q3HBox(gb);
      hb->setSpacing(5);
      {
        _rwStart = new RevisionWidget(false,"NDS","HBCP",0,hb);
        _rwStart->setTitle( _q("start revision") );
        _rwStop = new RevisionWidget(false,"SND","HBCP",0,hb);
        _rwStop->setTitle( _q("stop revision") );

        _rwStart->setRevision(_model->getStartRevision());
        _rwStop->setRevision(_model->getStopRevision());

        connect(
          _rwStart, SIGNAL(revChanged(svn::RevisionPtr)),
          _model, SLOT(setStartRevision(svn::RevisionPtr)) );
        connect(
          _rwStop, SIGNAL(revChanged(svn::RevisionPtr)),
          _model, SLOT(setStopRevision(svn::RevisionPtr)) );
      }
    }

    _blame = new Q3ListView(this);
    vbl->addWidget(_blame);
    _blame->addColumn( _q("line") );
    _blame->addColumn( _q("revision") );
    _blame->addColumn( _q("date") );
    _blame->addColumn( _q("author") );
    _blame->addColumn( _q("content") );
    //_blame->addColumn( "" );
    _blame->setColumnAlignment( 0, Qt::AlignRight );
    _blame->setColumnAlignment( 1, Qt::AlignRight );
    _blame->setColumnAlignment( 2, Qt::AlignRight );
    _blame->setResizeMode(Q3ListView::LastColumn);
    _blame->setAllColumnsShowFocus(true);
    _blame->setSortOrder(Qt::Ascending);
    _blame->setSorting(0);
    _blame->setItemMargin(0);
    _blame->setFont( font );

    QHBoxLayout* hu = new QHBoxLayout;
    vbl->addLayout(hu);
    {
      // eats extra space, so the buttons keep their size
      hu->addStretch(1); 

      _run = new QPushButton(this);
      _run->setText( _q("&Run") );
      _run->setFocus();
      hu->addWidget(_run);
      _done = new QPushButton(this);
      _done->setText( _q("&Done") );
      hu->addWidget(_done);

      hu->addSpacing(getSizeGripSpacing());
      
      connect( _run,  SIGNAL(clicked()), SLOT(run()) );
      connect( _done, SIGNAL(clicked()), SLOT(close()) );
    }
  }

  connect( _model, SIGNAL(addBlameLine(svn::BlameLinePtr)),
           this,   SLOT(add(svn::BlameLinePtr)) );
  connect( _model, SIGNAL(doneBlame()),
           this,   SLOT(done()) );

  Settings s;
  resize( s.layout().getSize( name(), QSize(700,600) ) );
}

BlameDialog::~BlameDialog()
{
  Settings s;
  s.layout().setSize( name(), geometry().size() );
}

void BlameDialog::add( svn::BlameLinePtr line )
{
  new BlameLineLvi( _blame, line );      
}

void BlameDialog::done()
{
  _run->setEnabled(true);
  _done->setEnabled(true);
}

void BlameDialog::run()
{
  _run->setEnabled(false);
  _done->setEnabled(false);
  _blame->clear();

  _model->blame();
}

