/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.record;

import java.io.IOException;
import java.io.InputStream;
import uk.ac.bristol.star.cdf.CdfFormatException;

class RunLengthInputStream
extends InputStream {
    private final InputStream base_;
    private final int rleVal_;
    private int vCount_;

    public RunLengthInputStream(InputStream inputStream, byte by) {
        this.base_ = inputStream;
        this.rleVal_ = by & 0xFF;
    }

    public int read() throws IOException {
        if (this.vCount_ > 0) {
            --this.vCount_;
            return this.rleVal_;
        }
        int n = this.base_.read();
        if (n == this.rleVal_) {
            int n2 = this.base_.read();
            if (n2 >= 0) {
                this.vCount_ = n2;
                return this.rleVal_;
            }
            throw new CdfFormatException("Bad RLE data");
        }
        return n;
    }

    public int available() throws IOException {
        return this.base_.available() + this.vCount_;
    }

    public void close() throws IOException {
        this.base_.close();
    }

    public boolean markSupported() {
        return false;
    }
}

