/*
$Id: Variable.java,v 1.4 2006/01/19 00:06:51 blackdrag Exp $

Copyright 2003 (C) James Strachan and Bob Mcwhirter. All Rights Reserved.

Redistribution and use of this software and associated documentation
("Software"), with or without modification, are permitted provided
that the following conditions are met:

1. Redistributions of source code must retain copyright
   statements and notices.  Redistributions must also contain a
   copy of this document.

2. Redistributions in binary form must reproduce the
   above copyright notice, this list of conditions and the
   following disclaimer in the documentation and/or other
   materials provided with the distribution.

3. The name "groovy" must not be used to endorse or promote
   products derived from this Software without prior written
   permission of The Codehaus.  For written permission,
   please contact info@codehaus.org.

4. Products derived from this Software may not be called "groovy"
   nor may "groovy" appear in their names without prior written
   permission of The Codehaus. "groovy" is a registered
   trademark of The Codehaus.

5. Due credit should be given to The Codehaus -
   http://groovy.codehaus.org/

THIS SOFTWARE IS PROVIDED BY THE CODEHAUS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT
NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
THE CODEHAUS OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

*/
package org.codehaus.groovy.ast;

import org.codehaus.groovy.ast.expr.Expression;

/**
 * interface to mark a AstNode as Variable. Typically these are 
 * VariableExpression, FieldNode, PropertyNode and Parameter
 * 
 * @author Jochen Theodorou
 */
public interface Variable {
    
    /**
     * the type of the variable
     */
    public ClassNode getType();
    
    /**
     * the name of the variable
     */
    public String getName();
    
    /**
     * expression used to initialize the variable or null of there
     * is no initialization.
     */
    public Expression getInitialExpression();
    
    /**
     * returns true if there is an initialization expression
     */
    public boolean hasInitialExpression();
    
    /**
     * returns true if this variable is used in a static context.
     * A static context is any static initializer block, when this variable
     * is declared as static or when this variable is used in a static method 
     */
    public boolean isInStaticContext();

    public boolean isDynamicTyped();
    public boolean isClosureSharedVariable();
    public void setClosureSharedVariable(boolean inClosure);
    
}
