/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed May 27 18:50:23 2015

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_39 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 26917, "epsg", 26917,
        "NAD83 / UTM zone 17N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 17N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26917\"]]");
    p = add_epsg_def_ex (filter, first, last, 26918, "epsg", 26918,
        "NAD83 / UTM zone 18N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 18N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26918\"]]");
    p = add_epsg_def_ex (filter, first, last, 26919, "epsg", 26919,
        "NAD83 / UTM zone 19N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 19N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26919\"]]");
    p = add_epsg_def_ex (filter, first, last, 26920, "epsg", 26920,
        "NAD83 / UTM zone 20N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 20N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26920\"]]");
    p = add_epsg_def_ex (filter, first, last, 26921, "epsg", 26921,
        "NAD83 / UTM zone 21N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 21N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26921\"]]");
    p = add_epsg_def_ex (filter, first, last, 26922, "epsg", 26922,
        "NAD83 / UTM zone 22N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 22N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26922\"]]");
    p = add_epsg_def_ex (filter, first, last, 26923, "epsg", 26923,
        "NAD83 / UTM zone 23N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 23N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-45],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26923\"]]");
    p = add_epsg_def_ex (filter, first, last, 26929, "epsg", 26929,
        "NAD83 / Alabama East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9996 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alabama East\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",30.5],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",-85.83333333333333],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.99996],PARAMETER[\"false_easting\",200000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"26929\"]]");
    p = add_epsg_def_ex (filter, first, last, 26930, "epsg", 26930,
        "NAD83 / Alabama West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=6");
    add_proj4text (p, 1,
        "00000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alabama West\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",30],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-87.5],PARAMETER[\"scale_factor\",0.999933333],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",600000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"26930\"]]");
    p = add_epsg_def_ex (filter, first, last, 26931, "epsg", 26931,
        "NAD83 / Alaska zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Hotine_Oblique_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=57 +lonc=-133.6666666666667 +alpha=32");
    add_proj4text (p, 1,
        "3.1301023611111 +k=0.9999 +x_0=5000000 +y_0=-5000000 +no");
    add_proj4text (p, 2,
        "_uoff +gamma=323.1301023611111 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 3,
        ",0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alaska zone 1\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Hotine_Oblique_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_center\",57],PARAMETER[\"longit");
    add_srs_wkt (p, 9,
        "ude_of_center\",-133.6666666666667],PARAMETER[\"azimuth\"");
    add_srs_wkt (p, 10,
        ",323.1301023611111],PARAMETER[\"rectified_grid_angle\",3");
    add_srs_wkt (p, 11,
        "23.1301023611111],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_easting\",5000000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 13,
        "hing\",-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 15,
        "PSG\",\"26931\"]]");
    p = add_epsg_def_ex (filter, first, last, 26932, "epsg", 26932,
        "NAD83 / Alaska zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alaska zone 2\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",54],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-142],PARAMETER[\"scale_factor\",0.9999],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"269");
    add_srs_wkt (p, 13,
        "32\"]]");
    p = add_epsg_def_ex (filter, first, last, 26933, "epsg", 26933,
        "NAD83 / Alaska zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alaska zone 3\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",54],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-146],PARAMETER[\"scale_factor\",0.9999],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"269");
    add_srs_wkt (p, 13,
        "33\"]]");
    p = add_epsg_def_ex (filter, first, last, 26934, "epsg", 26934,
        "NAD83 / Alaska zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alaska zone 4\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",54],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-150],PARAMETER[\"scale_factor\",0.9999],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"269");
    add_srs_wkt (p, 13,
        "34\"]]");
    p = add_epsg_def_ex (filter, first, last, 26935, "epsg", 26935,
        "NAD83 / Alaska zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alaska zone 5\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",54],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-154],PARAMETER[\"scale_factor\",0.9999],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"269");
    add_srs_wkt (p, 13,
        "35\"]]");
    p = add_epsg_def_ex (filter, first, last, 26936, "epsg", 26936,
        "NAD83 / Alaska zone 6", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alaska zone 6\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",54],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-158],PARAMETER[\"scale_factor\",0.9999],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"269");
    add_srs_wkt (p, 13,
        "36\"]]");
    p = add_epsg_def_ex (filter, first, last, 26937, "epsg", 26937,
        "NAD83 / Alaska zone 7", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alaska zone 7\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",54],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-162],PARAMETER[\"scale_factor\",0.9999],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"269");
    add_srs_wkt (p, 13,
        "37\"]]");
    p = add_epsg_def_ex (filter, first, last, 26938, "epsg", 26938,
        "NAD83 / Alaska zone 8", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alaska zone 8\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",54],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-166],PARAMETER[\"scale_factor\",0.9999],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"269");
    add_srs_wkt (p, 13,
        "38\"]]");
    p = add_epsg_def_ex (filter, first, last, 26939, "epsg", 26939,
        "NAD83 / Alaska zone 9", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alaska zone 9\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",54],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-170],PARAMETER[\"scale_factor\",0.9999],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"269");
    add_srs_wkt (p, 13,
        "39\"]]");
    p = add_epsg_def_ex (filter, first, last, 26940, "epsg", 26940,
        "NAD83 / Alaska zone 10", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=51 +lon_0=-176 +x_0=1000000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alaska zone 10\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 8,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",53.83333333333");
    add_srs_wkt (p, 9,
        "334],PARAMETER[\"standard_parallel_2\",51.83333333333334");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",51],PARAMETER[\"centr");
    add_srs_wkt (p, 11,
        "al_meridian\",-176],PARAMETER[\"false_easting\",1000000]");
    add_srs_wkt (p, 12,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"26940\"]]");
    p = add_epsg_def_ex (filter, first, last, 26941, "epsg", 26941,
        "NAD83 / California zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.3");
    add_proj4text (p, 1,
        "3333333333334 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 1\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",41.66666666");
    add_srs_wkt (p, 9,
        "666666],PARAMETER[\"standard_parallel_2\",40],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"latitude_of_origin\",39.33333333333334],PARAMETER[\"ce");
    add_srs_wkt (p, 11,
        "ntral_meridian\",-122],PARAMETER[\"false_easting\",20000");
    add_srs_wkt (p, 12,
        "00],PARAMETER[\"false_northing\",500000],UNIT[\"metre\",");
    add_srs_wkt (p, 13,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26941\"]]");
    p = add_epsg_def_ex (filter, first, last, 26942, "epsg", 26942,
        "NAD83 / California zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000 +y");
    add_proj4text (p, 2,
        "_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 2\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",39.83333333");
    add_srs_wkt (p, 9,
        "333334],PARAMETER[\"standard_parallel_2\",38.33333333333");
    add_srs_wkt (p, 10,
        "334],PARAMETER[\"latitude_of_origin\",37.66666666666666]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"central_meridian\",-122],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "easting\",2000000],PARAMETER[\"false_northing\",500000],");
    add_srs_wkt (p, 13,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26942\"]]");
    p = add_epsg_def_ex (filter, first, last, 26943, "epsg", 26943,
        "NAD83 / California zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000 +y_0=500000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 3\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",38.43333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"standard_parallel_2\",37.06666666666");
    add_srs_wkt (p, 10,
        "667],PARAMETER[\"latitude_of_origin\",36.5],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "central_meridian\",-120.5],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 12,
        "000000],PARAMETER[\"false_northing\",500000],UNIT[\"metr");
    add_srs_wkt (p, 13,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 14,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26943\"]]");
    p = add_epsg_def_ex (filter, first, last, 26944, "epsg", 26944,
        "NAD83 / California zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.3333333333333");
    add_proj4text (p, 1,
        "4 +lon_0=-119 +x_0=2000000 +y_0=500000 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 4\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",37.25],PARA");
    add_srs_wkt (p, 9,
        "METER[\"standard_parallel_2\",36],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 10,
        "f_origin\",35.33333333333334],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 11,
        "an\",-119],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",500000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"26944\"]]");
    p = add_epsg_def_ex (filter, first, last, 26945, "epsg", 26945,
        "NAD83 / California zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.5 +lon_0=-118 +x_0=2000000 +y_0=500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 5\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",35.46666666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"standard_parallel_2\",34.03333333333");
    add_srs_wkt (p, 10,
        "333],PARAMETER[\"latitude_of_origin\",33.5],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "central_meridian\",-118],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 12,
        "0000],PARAMETER[\"false_northing\",500000],UNIT[\"metre\"");
    add_srs_wkt (p, 13,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26945\"]]");
    p = add_epsg_def_ex (filter, first, last, 26946, "epsg", 26946,
        "NAD83 / California zone 6", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000");
    add_proj4text (p, 2,
        " +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 3,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 6\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",33.88333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"standard_parallel_2\",32.78333333333");
    add_srs_wkt (p, 10,
        "333],PARAMETER[\"latitude_of_origin\",32.16666666666666]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"central_meridian\",-116.25],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_easting\",2000000],PARAMETER[\"false_northing\",50000");
    add_srs_wkt (p, 13,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26946\"");
    add_srs_wkt (p, 15,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 26948, "epsg", 26948,
        "NAD83 / Arizona East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arizona East\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",31],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-110.1666666666667],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9999],PARAMETER[\"false_easting\",213360],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"26948\"]]");
    p = add_epsg_def_ex (filter, first, last, 26949, "epsg", 26949,
        "NAD83 / Arizona Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arizona Central\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-111.9166666666667],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.9999],PARAMETER[\"false_easting\",213360],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"26949\"]]");
    p = add_epsg_def_ex (filter, first, last, 26950, "epsg", 26950,
        "NAD83 / Arizona West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
        "=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arizona West\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",31],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-113.75],PARAMETER[\"scale_factor\",0.999933333");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",213360],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"26950\"]]");
    p = add_epsg_def_ex (filter, first, last, 26951, "epsg", 26951,
        "NAD83 / Arkansas North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=400000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arkansas North\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 8,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",36.23333333333");
    add_srs_wkt (p, 9,
        "333],PARAMETER[\"standard_parallel_2\",34.93333333333333");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",34.33333333333334],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"central_meridian\",-92],PARAMETER[\"false_east");
    add_srs_wkt (p, 12,
        "ing\",400000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 13,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26951\"]]");
    p = add_epsg_def_ex (filter, first, last, 26952, "epsg", 26952,
        "NAD83 / Arkansas South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=400000 +y_0=400000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arkansas South\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 8,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",34.76666666666");
    add_srs_wkt (p, 9,
        "667],PARAMETER[\"standard_parallel_2\",33.3],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",32.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-92],PARAMETER[\"false_easting\",400000],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",400000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"26952\"]]");
    p = add_epsg_def_ex (filter, first, last, 26953, "epsg", 26953,
        "NAD83 / Colorado North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 3,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Colorado North\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 8,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",40.78333333333");
    add_srs_wkt (p, 9,
        "333],PARAMETER[\"standard_parallel_2\",39.71666666666667");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",39.33333333333334],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"central_meridian\",-105.5],PARAMETER[\"false_e");
    add_srs_wkt (p, 12,
        "asting\",914401.8289],PARAMETER[\"false_northing\",30480");
    add_srs_wkt (p, 13,
        "0.6096],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 15,
        "6953\"]]");
    p = add_epsg_def_ex (filter, first, last, 26954, "epsg", 26954,
        "NAD83 / Colorado Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.8333333333");
    add_proj4text (p, 1,
        "3334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Colorado Central\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 8,
        "c_2SP\"],PARAMETER[\"standard_parallel_1\",39.75],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",38.45],PARAMETER[\"latitude_");
    add_srs_wkt (p, 10,
        "of_origin\",37.83333333333334],PARAMETER[\"central_merid");
    add_srs_wkt (p, 11,
        "ian\",-105.5],PARAMETER[\"false_easting\",914401.8289],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",304800.6096],UNIT[\"metre\",");
    add_srs_wkt (p, 13,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26954\"]]");
    p = add_epsg_def_ex (filter, first, last, 26955, "epsg", 26955,
        "NAD83 / Colorado South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 3,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Colorado South\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 8,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",38.43333333333");
    add_srs_wkt (p, 9,
        "333],PARAMETER[\"standard_parallel_2\",37.23333333333333");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",36.66666666666666],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"central_meridian\",-105.5],PARAMETER[\"false_e");
    add_srs_wkt (p, 12,
        "asting\",914401.8289],PARAMETER[\"false_northing\",30480");
    add_srs_wkt (p, 13,
        "0.6096],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 15,
        "6955\"]]");
    p = add_epsg_def_ex (filter, first, last, 26956, "epsg", 26956,
        "NAD83 / Connecticut", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40");
    add_proj4text (p, 1,
        ".83333333333334 +lon_0=-72.75 +x_0=304800.6096 +y_0=1524");
    add_proj4text (p, 2,
        "00.3048 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Connecticut\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2S");
    add_srs_wkt (p, 8,
        "P\"],PARAMETER[\"standard_parallel_1\",41.86666666666667");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_2\",41.2],PARAMETER[\"la");
    add_srs_wkt (p, 10,
        "titude_of_origin\",40.83333333333334],PARAMETER[\"centra");
    add_srs_wkt (p, 11,
        "l_meridian\",-72.75],PARAMETER[\"false_easting\",304800.");
    add_srs_wkt (p, 12,
        "6096],PARAMETER[\"false_northing\",152400.3048],UNIT[\"m");
    add_srs_wkt (p, 13,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26956\"]]");
    p = add_epsg_def_ex (filter, first, last, 26957, "epsg", 26957,
        "NAD83 / Delaware", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999");
    add_proj4text (p, 1,
        "995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Delaware\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",38],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-75.41666666666667],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "99995],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"26957\"]]");
    p = add_epsg_def_ex (filter, first, last, 26958, "epsg", 26958,
        "NAD83 / Florida East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Florida East\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",24.33333333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-81],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.999941177],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"26958\"]]");
    p = add_epsg_def_ex (filter, first, last, 26959, "epsg", 26959,
        "NAD83 / Florida West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Florida West\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",24.33333333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-82],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.999941177],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"26959\"]]");
    p = add_epsg_def_ex (filter, first, last, 26960, "epsg", 26960,
        "NAD83 / Florida North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=2");
    add_proj4text (p, 1,
        "9 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Florida North\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2S");
    add_srs_wkt (p, 8,
        "P\"],PARAMETER[\"standard_parallel_1\",30.75],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",29.58333333333333],PARAMETER[\"l");
    add_srs_wkt (p, 10,
        "atitude_of_origin\",29],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 11,
        "84.5],PARAMETER[\"false_easting\",600000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"26960\"]]");
    p = add_epsg_def_ex (filter, first, last, 26961, "epsg", 26961,
        "NAD83 / Hawaii zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=18.83333333333333 +lon_0=-155.5 +k=0.");
    add_proj4text (p, 1,
        "999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 2,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Hawaii zone 1\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",18.83333333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-155.5],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.999966667],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"26961\"]]");
    p = add_epsg_def_ex (filter, first, last, 26962, "epsg", 26962,
        "NAD83 / Hawaii zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=20.33333333333333 +lon_0=-156.6666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Hawaii zone 2\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",20.33333333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-156.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.999966667],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"26962\"]]");
    p = add_epsg_def_ex (filter, first, last, 26963, "epsg", 26963,
        "NAD83 / Hawaii zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99");
    add_proj4text (p, 1,
        "999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Hawaii zone 3\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",21.16666666666667],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-158],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.99999],PARAMETER[\"false_easting\",500000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"26963\"]]");
    p = add_epsg_def_ex (filter, first, last, 26964, "epsg", 26964,
        "NAD83 / Hawaii zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.83333333333333 +lon_0=-159.5 +k=0.");
    add_proj4text (p, 1,
        "99999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Hawaii zone 4\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",21.83333333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-159.5],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.99999],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"26964\"]]");
    p = add_epsg_def_ex (filter, first, last, 26965, "epsg", 26965,
        "NAD83 / Hawaii zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.66666666666667 +lon_0=-160.1666666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 2,
        ",0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Hawaii zone 5\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",21.66666666666667],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-160.1666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"26965\"]]");
    p = add_epsg_def_ex (filter, first, last, 26966, "epsg", 26966,
        "NAD83 / Georgia East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Georgia East\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",30],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-82.16666666666667],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"26966\"]]");
    p = add_epsg_def_ex (filter, first, last, 26967, "epsg", 26967,
        "NAD83 / Georgia West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Georgia West\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",30],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-84.16666666666667],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9999],PARAMETER[\"false_easting\",700000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"26967\"]]");
    p = add_epsg_def_ex (filter, first, last, 26968, "epsg", 26968,
        "NAD83 / Idaho East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999473679999999 +x_0=200000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Idaho East\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",41.66666666666666],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-112.1666666666667],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",0.999947368],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"26968\"]]");
    p = add_epsg_def_ex (filter, first, last, 26969, "epsg", 26969,
        "NAD83 / Idaho Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.99");
    add_proj4text (p, 1,
        "99473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Idaho Central\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",41.66666666666666],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-114],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.999947368],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"26969\"]]");
    p = add_epsg_def_ex (filter, first, last, 26970, "epsg", 26970,
        "NAD83 / Idaho West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0");
    add_proj4text (p, 1,
        ".999933333 +x_0=800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Idaho West\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",41.66666666666666],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-115.75],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.999933333],PARAMETER[\"false_easting\",800000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"26970\"]]");
    p = add_epsg_def_ex (filter, first, last, 26971, "epsg", 26971,
        "NAD83 / Illinois East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333");
    add_proj4text (p, 1,
        "333333 +k=0.9999749999999999 +x_0=300000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Illinois East\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",36.66666666666666],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-88.33333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.999975],PARAMETER[\"false_easting\",300");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"26971\"]]");
    p = add_epsg_def_ex (filter, first, last, 26972, "epsg", 26972,
        "NAD83 / Illinois West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=700000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Illinois West\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",36.66666666666666],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-90.16666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.999941177],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "700000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"26972\"]]");
    p = add_epsg_def_ex (filter, first, last, 26973, "epsg", 26973,
        "NAD83 / Indiana East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=100000 +y_0=250000 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Indiana East\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",37.5],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",-85.66666666666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.999966667],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",250000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"26973\"]]");
    p = add_epsg_def_ex (filter, first, last, 26974, "epsg", 26974,
        "NAD83 / Indiana West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=900000 +y_0=250000 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Indiana West\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",37.5],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",-87.08333333333333],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.999966667],PARAMETER[\"false_easting\",900000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",250000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"26974\"]]");
    p = add_epsg_def_ex (filter, first, last, 26975, "epsg", 26975,
        "NAD83 / Iowa North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=1000000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Iowa North\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"standard_parallel_1\",43.26666666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",42.06666666666667],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"latitude_of_origin\",41.5],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-93.5],PARAMETER[\"false_easting\",1500000],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"26975\"]]");
    p = add_epsg_def_ex (filter, first, last, 26976, "epsg", 26976,
        "NAD83 / Iowa South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40 +lon_0=-93.5 +x_0=500000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Iowa South\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"standard_parallel_1\",41.78333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",40.61666666666667],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"latitude_of_origin\",40],PARAMETER[\"central_m");
    add_srs_wkt (p, 11,
        "eridian\",-93.5],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"26976\"]]");
    p = add_epsg_def_ex (filter, first, last, 26977, "epsg", 26977,
        "NAD83 / Kansas North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=400000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kansas North\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2S");
    add_srs_wkt (p, 8,
        "P\"],PARAMETER[\"standard_parallel_1\",39.78333333333333");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_2\",38.71666666666667],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"latitude_of_origin\",38.33333333333334],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"central_meridian\",-98],PARAMETER[\"false_easting");
    add_srs_wkt (p, 12,
        "\",400000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 13,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26977\"]]");
    p = add_epsg_def_ex (filter, first, last, 26978, "epsg", 26978,
        "NAD83 / Kansas South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=400000 +y");
    add_proj4text (p, 2,
        "_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kansas South\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2S");
    add_srs_wkt (p, 8,
        "P\"],PARAMETER[\"standard_parallel_1\",38.56666666666667");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_2\",37.26666666666667],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"latitude_of_origin\",36.66666666666666],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"central_meridian\",-98.5],PARAMETER[\"false_easti");
    add_srs_wkt (p, 12,
        "ng\",400000],PARAMETER[\"false_northing\",400000],UNIT[\"");
    add_srs_wkt (p, 13,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26978\"]]");
    p = add_epsg_def_ex (filter, first, last, 26979, "epsg", 26979,
        "NAD83 / Kentucky North (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=37.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kentucky North (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 9,
        "7.96666666666667],PARAMETER[\"standard_parallel_2\",37.9");
    add_srs_wkt (p, 10,
        "6666666666667],PARAMETER[\"latitude_of_origin\",37.5],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"central_meridian\",-84.25],PARAMETER[\"false_e");
    add_srs_wkt (p, 12,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 13,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26979\"]]");
    p = add_epsg_def_ex (filter, first, last, 26980, "epsg", 26980,
        "NAD83 / Kentucky South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000 +");
    add_proj4text (p, 2,
        "y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kentucky South\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 8,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",37.93333333333");
    add_srs_wkt (p, 9,
        "333],PARAMETER[\"standard_parallel_2\",36.73333333333333");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",36.33333333333334],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"central_meridian\",-85.75],PARAMETER[\"false_e");
    add_srs_wkt (p, 12,
        "asting\",500000],PARAMETER[\"false_northing\",500000],UN");
    add_srs_wkt (p, 13,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26980\"]]");
    p = add_epsg_def_ex (filter, first, last, 26981, "epsg", 26981,
        "NAD83 / Louisiana North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=30.5 +lon_0=-92.5 +x_0=1000000 +y_0=0 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Louisiana North\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 8,
        "c_2SP\"],PARAMETER[\"standard_parallel_1\",32.6666666666");
    add_srs_wkt (p, 9,
        "6666],PARAMETER[\"standard_parallel_2\",31.1666666666666");
    add_srs_wkt (p, 10,
        "7],PARAMETER[\"latitude_of_origin\",30.5],PARAMETER[\"ce");
    add_srs_wkt (p, 11,
        "ntral_meridian\",-92.5],PARAMETER[\"false_easting\",1000");
    add_srs_wkt (p, 12,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"26981\"]]");
    p = add_epsg_def_ex (filter, first, last, 26982, "epsg", 26982,
        "NAD83 / Louisiana South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91");
    add_proj4text (p, 1,
        ".33333333333333 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Louisiana South\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 8,
        "c_2SP\"],PARAMETER[\"standard_parallel_1\",30.7],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_2\",29.3],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 10,
        "_origin\",28.5],PARAMETER[\"central_meridian\",-91.33333");
    add_srs_wkt (p, 11,
        "333333333],PARAMETER[\"false_easting\",1000000],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"26982\"]]");
    p = add_epsg_def_ex (filter, first, last, 26983, "epsg", 26983,
        "NAD83 / Maine East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine East\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",43.66666666666666],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-68.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9999],PARAMETER[\"false_easting\",300000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"26983\"]]");
    p = add_epsg_def_ex (filter, first, last, 26984, "epsg", 26984,
        "NAD83 / Maine West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine West\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",42.83333333333334],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-70.16666666666667],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",0.999966667],PARAMETER[\"false_easting\",9");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"26984\"]]");
    p = add_epsg_def_ex (filter, first, last, 26985, "epsg", 26985,
        "NAD83 / Maryland", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-77 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maryland\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",39.45],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_2\",38.3],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 10,
        "n\",37.66666666666666],PARAMETER[\"central_meridian\",-7");
    add_srs_wkt (p, 11,
        "7],PARAMETER[\"false_easting\",400000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"26985\"]]");
    p = add_epsg_def_ex (filter, first, last, 26986, "epsg", 26986,
        "NAD83 / Massachusetts Mainland", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41 +lon_0=-71.5 +x_0=200000 +y_0=750000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Massachusetts Mainland\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",42.6833");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"standard_parallel_2\",41.7166666");
    add_srs_wkt (p, 10,
        "6666667],PARAMETER[\"latitude_of_origin\",41],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"central_meridian\",-71.5],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 12,
        "200000],PARAMETER[\"false_northing\",750000],UNIT[\"metr");
    add_srs_wkt (p, 13,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 14,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26986\"]]");
    p = add_epsg_def_ex (filter, first, last, 26987, "epsg", 26987,
        "NAD83 / Massachusetts Island", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333");
    add_proj4text (p, 1,
        "333 +lat_0=41 +lon_0=-70.5 +x_0=500000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Massachusetts Island\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",41.48333");
    add_srs_wkt (p, 9,
        "333333333],PARAMETER[\"standard_parallel_2\",41.28333333");
    add_srs_wkt (p, 10,
        "333333],PARAMETER[\"latitude_of_origin\",41],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "central_meridian\",-70.5],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 12,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"26987\"]]");
    p = add_epsg_def_ex (filter, first, last, 26988, "epsg", 26988,
        "NAD83 / Michigan North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=8000000 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Michigan North\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 8,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",47.08333333333");
    add_srs_wkt (p, 9,
        "334],PARAMETER[\"standard_parallel_2\",45.48333333333333");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",44.78333333333333],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"central_meridian\",-87],PARAMETER[\"false_east");
    add_srs_wkt (p, 12,
        "ing\",8000000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 13,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 14,
        "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26988\"]]");
    p = add_epsg_def_ex (filter, first, last, 26989, "epsg", 26989,
        "NAD83 / Michigan Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43");
    add_proj4text (p, 1,
        ".31666666666667 +lon_0=-84.36666666666666 +x_0=6000000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Michigan Central\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 8,
        "c_2SP\"],PARAMETER[\"standard_parallel_1\",45.7],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_2\",44.18333333333333],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"latitude_of_origin\",43.31666666666667],PARAMETER[\"ce");
    add_srs_wkt (p, 11,
        "ntral_meridian\",-84.36666666666666],PARAMETER[\"false_e");
    add_srs_wkt (p, 12,
        "asting\",6000000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 13,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26989\"]]");
    p = add_epsg_def_ex (filter, first, last, 26990, "epsg", 26990,
        "NAD83 / Michigan South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41");
    add_proj4text (p, 1,
        ".5 +lon_0=-84.36666666666666 +x_0=4000000 +y_0=0 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Michigan South\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 8,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",43.66666666666");
    add_srs_wkt (p, 9,
        "666],PARAMETER[\"standard_parallel_2\",42.1],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",41.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 11,
        ",-84.36666666666666],PARAMETER[\"false_easting\",4000000");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"26990\"]]");
    p = add_epsg_def_ex (filter, first, last, 26991, "epsg", 26991,
        "NAD83 / Minnesota North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000 +y");
    add_proj4text (p, 2,
        "_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota North\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 8,
        "c_2SP\"],PARAMETER[\"standard_parallel_1\",48.6333333333");
    add_srs_wkt (p, 9,
        "3333],PARAMETER[\"standard_parallel_2\",47.0333333333333");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"latitude_of_origin\",46.5],PARAMETER[\"ce");
    add_srs_wkt (p, 11,
        "ntral_meridian\",-93.1],PARAMETER[\"false_easting\",8000");
    add_srs_wkt (p, 12,
        "00],PARAMETER[\"false_northing\",100000],UNIT[\"metre\",");
    add_srs_wkt (p, 13,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26991\"]]");
    p = add_epsg_def_ex (filter, first, last, 26992, "epsg", 26992,
        "NAD83 / Minnesota Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000 +y_0=100000 +ellps=GRS80 +to");
    add_proj4text (p, 2,
        "wgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota Central\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",47.05],PARA");
    add_srs_wkt (p, 9,
        "METER[\"standard_parallel_2\",45.61666666666667],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"latitude_of_origin\",45],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 11,
        "an\",-94.25],PARAMETER[\"false_easting\",800000],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",100000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"26992\"]]");
    p = add_epsg_def_ex (filter, first, last, 26993, "epsg", 26993,
        "NAD83 / Minnesota South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000 +y_0=100000 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota South\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 8,
        "c_2SP\"],PARAMETER[\"standard_parallel_1\",45.2166666666");
    add_srs_wkt (p, 9,
        "6667],PARAMETER[\"standard_parallel_2\",43.7833333333333");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"latitude_of_origin\",43],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-94],PARAMETER[\"false_easting\",800000],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",100000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"26993\"]]");
    p = add_epsg_def_ex (filter, first, last, 26994, "epsg", 26994,
        "NAD83 / Mississippi East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9995 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Mississippi East\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",29.5],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",-88.83333333333333],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.99995],PARAMETER[\"false_easting\",300000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"26994\"]]");
    p = add_epsg_def_ex (filter, first, last, 26995, "epsg", 26995,
        "NAD83 / Mississippi West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9995 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Mississippi West\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",29.5],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",-90.33333333333333],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.99995],PARAMETER[\"false_easting\",700000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"26995\"]]");
    p = add_epsg_def_ex (filter, first, last, 26996, "epsg", 26996,
        "NAD83 / Missouri East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.9");
    add_proj4text (p, 1,
        "99933333 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Missouri East\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",35.83333333333334],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-90.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.999933333],PARAMETER[\"false_easting\",250000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"26996\"]]");
    p = add_epsg_def_ex (filter, first, last, 26997, "epsg", 26997,
        "NAD83 / Missouri Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.9");
    add_proj4text (p, 1,
        "99933333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Missouri Central\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",35.83333333333334],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",-92.5],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.999933333],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"26997\"]]");
    p = add_epsg_def_ex (filter, first, last, 26998, "epsg", 26998,
        "NAD83 / Missouri West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.9");
    add_proj4text (p, 1,
        "99941177 +x_0=850000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Missouri West\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",36.16666666666666],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-94.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.999941177],PARAMETER[\"false_easting\",850000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"26998\"]]");
    p = add_epsg_def_ex (filter, first, last, 27037, "epsg", 27037,
        "Nahrwan 1967 / UTM zone 37N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1967", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=clrk80 +towgs84=-242.2,-144.9,");
    add_proj4text (p, 1,
        "370.3,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1967 / UTM zone 37N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1967\",DATUM[\"Nahrwan_1967\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-242.2,-144.9,370.3,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6270\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4270\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",39],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"27037\"]]");
    p = add_epsg_def_ex (filter, first, last, 27038, "epsg", 27038,
        "Nahrwan 1967 / UTM zone 38N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1967", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=clrk80 +towgs84=-242.2,-144.9,");
    add_proj4text (p, 1,
        "370.3,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1967 / UTM zone 38N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1967\",DATUM[\"Nahrwan_1967\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-242.2,-144.9,370.3,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6270\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4270\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",45],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"27038\"]]");
    p = add_epsg_def_ex (filter, first, last, 27039, "epsg", 27039,
        "Nahrwan 1967 / UTM zone 39N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1967", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=clrk80 +towgs84=-242.2,-144.9,");
    add_proj4text (p, 1,
        "370.3,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1967 / UTM zone 39N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1967\",DATUM[\"Nahrwan_1967\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-242.2,-144.9,370.3,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6270\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4270\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",51],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"27039\"]]");
    p = add_epsg_def_ex (filter, first, last, 27040, "epsg", 27040,
        "Nahrwan 1967 / UTM zone 40N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1967", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=clrk80 +towgs84=-242.2,-144.9,");
    add_proj4text (p, 1,
        "370.3,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1967 / UTM zone 40N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1967\",DATUM[\"Nahrwan_1967\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-242.2,-144.9,370.3,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6270\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4270\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",57],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"27040\"]]");
    p = add_epsg_def_ex (filter, first, last, 27120, "epsg", 27120,
        "Naparima 1972 / UTM zone 20N", 0, 0,
        "International 1924", "Greenwich",
        "Naparima_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=intl +towgs84=-10,375,165,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Naparima 1972 / UTM zone 20N\",GEOGCS[\"Naparim");
    add_srs_wkt (p, 1,
        "a 1972\",DATUM[\"Naparima_1972\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-10,375,165,0,0,0,0],AUTHORITY[\"EPSG\",\"6271\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4271\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-63],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"27120\"]]");
    p = add_epsg_def_ex (filter, first, last, 27200, "epsg", 27200,
        "NZGD49 / New Zealand Map Grid", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "New_Zealand_Map_Grid", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=nzmg +lat_0=-41 +lon_0=173 +x_0=2510000 +y_0=60231");
    add_proj4text (p, 1,
        "50 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.0");
    add_proj4text (p, 2,
        "24,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / New Zealand Map Grid\",GEOGCS[\"NZGD49");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.599");
    add_srs_wkt (p, 4,
        "3],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 8,
        "72\"]],PROJECTION[\"New_Zealand_Map_Grid\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",-41],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",173],PARAMETER[\"false_easting\",2510000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",6023150],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"27200\"]]");
    p = add_epsg_def_ex (filter, first, last, 27205, "epsg", 27205,
        "NZGD49 / Mount Eden Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-36.87986527777778 +lon_0=174.7643393");
    add_proj4text (p, 1,
        "611111 +k=0.9999 +x_0=300000 +y_0=700000 +ellps=intl +to");
    add_proj4text (p, 2,
        "wgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=");
    add_proj4text (p, 3,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount Eden Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",-36.87986527777778],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",174.7643393611111],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 11,
        "\",0.9999],PARAMETER[\"false_easting\",300000],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 14,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27205\"]]");
    p = add_epsg_def_ex (filter, first, last, 27206, "epsg", 27206,
        "NZGD49 / Bay of Plenty Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-37.76124980555556 +lon_0=176.4661972");
    add_proj4text (p, 1,
        "5 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Bay of Plenty Circuit\",GEOGCS[\"NZGD4");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.599");
    add_srs_wkt (p, 4,
        "3],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 8,
        "72\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",-37.76124980555556],PARAMETER[\"cent");
    add_srs_wkt (p, 10,
        "ral_meridian\",176.46619725],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 11,
        "1],PARAMETER[\"false_easting\",300000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"27206\"]]");
    p = add_epsg_def_ex (filter, first, last, 27207, "epsg", 27207,
        "NZGD49 / Poverty Bay Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-38.62470277777778 +lon_0=177.8856362");
    add_proj4text (p, 1,
        "777778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Poverty Bay Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",-38.62470277777778],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",177.8856362777778],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 11,
        "\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AUTHORITY[\"EPSG\",\"27207\"]]");
    p = add_epsg_def_ex (filter, first, last, 27208, "epsg", 27208,
        "NZGD49 / Hawkes Bay Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.65092930555556 +lon_0=176.6736805");
    add_proj4text (p, 1,
        "277778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Hawkes Bay Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",-39.65092930555556],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",176.6736805277778],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 11,
        "\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AUTHORITY[\"EPSG\",\"27208\"]]");
    p = add_epsg_def_ex (filter, first, last, 27209, "epsg", 27209,
        "NZGD49 / Taranaki Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.13575830555556 +lon_0=174.2280117");
    add_proj4text (p, 1,
        "5 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Taranaki Circuit\",GEOGCS[\"NZGD49\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",-39.13575830555556],PARAMETER[\"central_");
    add_srs_wkt (p, 10,
        "meridian\",174.22801175],PARAMETER[\"scale_factor\",1],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",300000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"27209\"]]");
    p = add_epsg_def_ex (filter, first, last, 27210, "epsg", 27210,
        "NZGD49 / Tuhirangi Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.51247038888889 +lon_0=175.6400368");
    add_proj4text (p, 1,
        "055556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Tuhirangi Circuit\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",-39.51247038888889],PARAMETER[\"central_");
    add_srs_wkt (p, 10,
        "meridian\",175.6400368055556],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 14,
        "ST],AUTHORITY[\"EPSG\",\"27210\"]]");
    p = add_epsg_def_ex (filter, first, last, 27211, "epsg", 27211,
        "NZGD49 / Wanganui Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.24194713888889 +lon_0=175.4880996");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Wanganui Circuit\",GEOGCS[\"NZGD49\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",-40.24194713888889],PARAMETER[\"central_");
    add_srs_wkt (p, 10,
        "meridian\",175.4880996111111],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 14,
        "ST],AUTHORITY[\"EPSG\",\"27211\"]]");
    p = add_epsg_def_ex (filter, first, last, 27212, "epsg", 27212,
        "NZGD49 / Wairarapa Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.92553263888889 +lon_0=175.6473496");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Wairarapa Circuit\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",-40.92553263888889],PARAMETER[\"central_");
    add_srs_wkt (p, 10,
        "meridian\",175.6473496666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 14,
        "ST],AUTHORITY[\"EPSG\",\"27212\"]]");
    p = add_epsg_def_ex (filter, first, last, 27213, "epsg", 27213,
        "NZGD49 / Wellington Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.30131963888888 +lon_0=174.7766231");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Wellington Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",-41.30131963888888],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",174.7766231111111],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 11,
        "\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AUTHORITY[\"EPSG\",\"27213\"]]");
    p = add_epsg_def_ex (filter, first, last, 27214, "epsg", 27214,
        "NZGD49 / Collingwood Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.71475905555556 +lon_0=172.6720465");
    add_proj4text (p, 1,
        " +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47");
    add_proj4text (p, 2,
        ",-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Collingwood Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",-40.71475905555556],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",172.6720465],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",300000],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"27214\"]]");
    p = add_epsg_def_ex (filter, first, last, 27215, "epsg", 27215,
        "NZGD49 / Nelson Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.27454472222222 +lon_0=173.2993168");
    add_proj4text (p, 1,
        "055555 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Nelson Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",-41.27454472222222],PARAMETER[\"central_me");
    add_srs_wkt (p, 10,
        "ridian\",173.2993168055555],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",300000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"27215\"]]");
    p = add_epsg_def_ex (filter, first, last, 27216, "epsg", 27216,
        "NZGD49 / Karamea Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.28991152777778 +lon_0=172.1090281");
    add_proj4text (p, 1,
        "944444 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Karamea Circuit\",GEOGCS[\"NZGD49\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 7,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"]");
    add_srs_wkt (p, 8,
        "],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 9,
        "de_of_origin\",-41.28991152777778],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",172.1090281944444],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 11,
        "1],PARAMETER[\"false_easting\",300000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"27216\"]]");
    p = add_epsg_def_ex (filter, first, last, 27217, "epsg", 27217,
        "NZGD49 / Buller Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.81080286111111 +lon_0=171.5812600");
    add_proj4text (p, 1,
        "555556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Buller Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",-41.81080286111111],PARAMETER[\"central_me");
    add_srs_wkt (p, 10,
        "ridian\",171.5812600555556],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",300000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"27217\"]]");
    p = add_epsg_def_ex (filter, first, last, 27218, "epsg", 27218,
        "NZGD49 / Grey Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.33369427777778 +lon_0=171.5497713");
    add_proj4text (p, 1,
        "055556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Grey Circuit\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",-42.33369427777778],PARAMETER[\"central_meri");
    add_srs_wkt (p, 10,
        "dian\",171.5497713055556],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",300000],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"27218\"]]");
    p = add_epsg_def_ex (filter, first, last, 27219, "epsg", 27219,
        "NZGD49 / Amuri Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.68911658333333 +lon_0=173.0101333");
    add_proj4text (p, 1,
        "888889 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Amuri Circuit\",GEOGCS[\"NZGD49\",DATU");
    add_srs_wkt (p, 1,
        "M[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",-42.68911658333333],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",173.0101333888889],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",300000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"27219\"]]");
    p = add_epsg_def_ex (filter, first, last, 27220, "epsg", 27220,
        "NZGD49 / Marlborough Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.54448666666666 +lon_0=173.8020741");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Marlborough Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",-41.54448666666666],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",173.8020741111111],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 11,
        "\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AUTHORITY[\"EPSG\",\"27220\"]]");
    p = add_epsg_def_ex (filter, first, last, 27221, "epsg", 27221,
        "NZGD49 / Hokitika Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.88632236111111 +lon_0=170.9799935");
    add_proj4text (p, 1,
        " +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47");
    add_proj4text (p, 2,
        ",-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Hokitika Circuit\",GEOGCS[\"NZGD49\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",-42.88632236111111],PARAMETER[\"central_");
    add_srs_wkt (p, 10,
        "meridian\",170.9799935],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",300000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"27221\"]]");
    p = add_epsg_def_ex (filter, first, last, 27222, "epsg", 27222,
        "NZGD49 / Okarito Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.11012813888889 +lon_0=170.2609258");
    add_proj4text (p, 1,
        "333333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Okarito Circuit\",GEOGCS[\"NZGD49\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 7,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"]");
    add_srs_wkt (p, 8,
        "],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 9,
        "de_of_origin\",-43.11012813888889],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",170.2609258333333],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 11,
        "1],PARAMETER[\"false_easting\",300000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"27222\"]]");
    p = add_epsg_def_ex (filter, first, last, 27223, "epsg", 27223,
        "NZGD49 / Jacksons Bay Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.97780288888889 +lon_0=168.606267 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,");
    add_proj4text (p, 2,
        "-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Jacksons Bay Circuit\",GEOGCS[\"NZGD49");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.599");
    add_srs_wkt (p, 4,
        "3],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 8,
        "72\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",-43.97780288888889],PARAMETER[\"cent");
    add_srs_wkt (p, 10,
        "ral_meridian\",168.606267],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",300000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"27223\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

