Directory Structure of scap-security-guide
------------------------------------------


OS and Application Directories
------------------------------

Under the top level directory, there are sub-directories for different
OSs and applications.  The sub-directories can either be directly under
the top-level, or they can use the structure of a distribution name with
version numbers underneath.  For example, Fedora contains all the code for
all supported versions of Fedora, but RHEL contains subdirectories to make
the code for each supported version independent of each other.

The remainder of this section discusses the OS or application sub-directory,
whether immediately under the top level directory or in a version-specific
sub-sub-directory.

Each OS or application sub-directory must contain a Makefile with the make
targets: default, dist, validate, and clean.  The default rule must build
everything in that directory and make it suitable for use.

The input directory (normal) contains source files that generate SCAP content,
such as XCCDF and OVAL.  Since a single large XML file is an impractical format
for multiple authors to collaborate on editing SCAP content, efforts are made
to keep logically related guidance and checking content in individual files.

The transforms directory (normal) contains resources that enable the files
inside the input directory (or output directory) to be combined and reformatted
into valid SCAP formats or human-readable formats.

The utils directory (normal) contains helper scripts and other items that are
useful to developers but are not essential to producing the project's output.

The references directory (optional: the shared version should be used when
possible) should contain documents which are specified as references from
within the SCAP content, or documents that are "seeds," viz.  documents whose
prose will be translated into SCAP formats, as well as other examples of
SCAP content.

The output directory (created during build) is used as a storage area for
items generated by the files in the inputs directory.  It should be empty
in the repository, and built on users' individual systems (and rely on
its .gitignore file to keep such files out).  The output directory contains
transitional output (which may only exist in order to be further transformed)
as well as final output.

The dist directory (created during build) contains final outputs, which could
be shipped in an RPM for consumption by end-users.  Updating the Makefile
to copy an item from the outputs directory to the dist directory indicates
that an item is considered a final output.


Shared Directory
----------------

The shared directory contains code that can be shared among different OSs
and applications.  The sub-directories in the shared directory augment the
sub-directories in the OS and application areas, though the tree structure
is somewhat different.

    OS-or-app/input/oval ... shared/oval
    OS-or-app/input/remediations ... shared/remediations
    OS-or-app/transforms ... shared/transforms
    OS-or-app/utils ... shared/utils

In addition, the shared directory contains "modules" containing python code,
and "references" containing references to external identifiers.
