/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.Hashtable;
import java.util.Vector;
import org.sablecc.sablecc.CharSet;
import org.sablecc.sablecc.IntSet;
import org.sablecc.sablecc.NFA;

public class DFA {
    public NFA nfa;
    public final Vector states = new Vector(0);
    public final Hashtable finder = new Hashtable(1);
    private IntSet[] eclosures;

    public DFA(NFA nFA) {
        this.nfa = nFA;
        this.construct();
        this.optimize();
    }

    private void optimize() {
        State state;
        int n;
        Vector vector = new Vector(0);
        for (n = 0; n < this.states.size(); ++n) {
            state = (State)this.states.elementAt(n);
            vector.addElement(new Vector(0));
            for (int i = 0; i < state.transitions.size(); ++i) {
                int n2 = 0;
                int n3 = -1;
                for (int j = 0; j < n; ++j) {
                    int n4 = this.match(n, i, j);
                    if (n4 <= n2) continue;
                    n2 = n4;
                    n3 = j;
                }
                if (n2 < 2) {
                    ((Vector)vector.elementAt(n)).addElement(state.transitions.elementAt(i));
                    continue;
                }
                Transition transition = (Transition)state.transitions.elementAt(i);
                Transition transition2 = (Transition)state.transitions.elementAt(i + n2 - 1);
                Transition transition3 = new Transition(new CharSet.Interval(transition.interval().start, transition2.interval().end), -2 - n3);
                ((Vector)vector.elementAt(n)).addElement(transition3);
                i += n2 - 1;
            }
        }
        for (n = 0; n < this.states.size(); ++n) {
            state = (State)this.states.elementAt(n);
            state.transitions = (Vector)vector.elementAt(n);
        }
    }

    private int match(int n, int n2, int n3) {
        int n4;
        State state = (State)this.states.elementAt(n);
        State state2 = (State)this.states.elementAt(n3);
        Transition transition = (Transition)state.transitions.elementAt(n2);
        int n5 = -1;
        for (n4 = 0; n4 < state2.transitions.size(); ++n4) {
            Transition transition2 = (Transition)state2.transitions.elementAt(n4);
            if (!transition2.match(transition)) continue;
            n5 = n4;
            break;
        }
        if (n5 == -1) {
            return 0;
        }
        n4 = 0;
        for (int i = n2; i < state.transitions.size() && n5 < state2.transitions.size(); ++i, ++n5) {
            Transition transition3;
            Transition transition4 = (Transition)state.transitions.elementAt(i);
            if (!transition4.match(transition3 = (Transition)state2.transitions.elementAt(n5))) {
                return n4;
            }
            ++n4;
        }
        return n4;
    }

    private void construct() {
        this.computeEClosures();
        IntSet intSet = new IntSet();
        intSet.or(this.eclosure(0));
        State state = new State(intSet);
        this.states.addElement(state);
        this.finder.put(state.nfaStates, new Integer(0));
        int n = -1;
        while (++n < this.states.size()) {
            System.out.print(".");
            state = (State)this.states.elementAt(n);
            CharSet.Interval interval = new CharSet.Interval('\u0000', '\uffff');
            do {
                IntSet intSet2 = new IntSet();
                interval.end = (char)65535;
                boolean bl = false;
                int[] nArray = state.nfaStates.elements();
                for (int i = 0; i < nArray.length; ++i) {
                    CharSet.Interval interval2;
                    int n2 = nArray[i];
                    if (this.nfa.states[n2].transitions[0] != null && this.nfa.states[n2].transitions[0].chars != null && (interval2 = this.nfa.states[n2].transitions[0].chars.findOverlap(interval)) != null) {
                        if (interval2.start > interval.start) {
                            interval.end = (char)(interval2.start - '\u0001');
                        } else {
                            intSet2.set(this.nfa.states[n2].transitions[0].destination);
                            bl = true;
                            if (interval2.end < interval.end) {
                                interval.end = interval2.end;
                            }
                        }
                    }
                    if (this.nfa.states[n2].transitions[1] == null || this.nfa.states[n2].transitions[1].chars == null || (interval2 = this.nfa.states[n2].transitions[1].chars.findOverlap(interval)) == null) continue;
                    if (interval2.start > interval.start) {
                        interval.end = (char)(interval2.start - '\u0001');
                        continue;
                    }
                    intSet2.set(this.nfa.states[n2].transitions[1].destination);
                    if (interval2.end >= interval.end) continue;
                    interval.end = interval2.end;
                }
                if (bl) {
                    Integer n3 = (Integer)this.finder.get(intSet2 = this.eclosure(intSet2));
                    if (n3 != null) {
                        state.transitions.addElement(new Transition((CharSet.Interval)interval.clone(), n3));
                    } else {
                        State state2 = new State(intSet2);
                        this.states.addElement(state2);
                        this.finder.put(state2.nfaStates, new Integer(this.states.size() - 1));
                        state.transitions.addElement(new Transition((CharSet.Interval)interval.clone(), this.states.size() - 1));
                    }
                }
                interval.start = (char)(interval.end + '\u0001');
            } while (interval.end != '\uffff');
        }
    }

    private void computeEClosures() {
        this.eclosures = new IntSet[this.nfa.states.length];
        for (int i = 0; i < this.nfa.states.length; ++i) {
            System.out.print(".");
            IntSet intSet = new IntSet();
            this.eclosure(i, intSet);
            this.eclosures[i] = intSet;
        }
        System.out.println();
    }

    private IntSet eclosure(int n) {
        return this.eclosures[n];
    }

    private void eclosure(int n, IntSet intSet) {
        if (this.eclosures[n] != null) {
            intSet.or(this.eclosures[n]);
            return;
        }
        intSet.set(n);
        if (this.nfa.states[n].transitions[0] != null && this.nfa.states[n].transitions[0].chars == null && !intSet.get(this.nfa.states[n].transitions[0].destination)) {
            this.eclosure(this.nfa.states[n].transitions[0].destination, intSet);
        }
        if (this.nfa.states[n].transitions[1] != null && this.nfa.states[n].transitions[1].chars == null && !intSet.get(this.nfa.states[n].transitions[1].destination)) {
            this.eclosure(this.nfa.states[n].transitions[1].destination, intSet);
        }
    }

    private IntSet eclosure(IntSet intSet) {
        IntSet intSet2 = new IntSet();
        int[] nArray = intSet.elements();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            intSet2.or(this.eclosure(n));
        }
        return intSet2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.states.size(); ++i) {
            stringBuffer.append(i + ": " + this.states.elementAt(i) + System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    public static class Transition {
        private char start;
        private char end;
        public int destination;

        public Transition(CharSet.Interval interval, int n) {
            this.start = interval.start;
            this.end = interval.end;
            this.destination = n;
        }

        public CharSet.Interval interval() {
            return new CharSet.Interval(this.start, this.end);
        }

        public Transition(Transition transition) {
            this.start = transition.start;
            this.end = transition.end;
            this.destination = transition.destination;
        }

        public String toString() {
            return this.destination + ":[" + this.interval() + "]";
        }

        public boolean match(Transition transition) {
            return this.start == transition.start && this.end == transition.end && this.destination == transition.destination;
        }
    }

    public static class State {
        public IntSet nfaStates = new IntSet();
        public Vector transitions = new Vector(0);
        public int accept;

        public State(IntSet intSet) {
            this.nfaStates = intSet;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.transitions.size(); ++i) {
                stringBuffer.append(this.transitions.elementAt(i) + ",");
            }
            return stringBuffer + "";
        }
    }
}

