// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#[cfg(feature = "futures")]
use futures::future;
use gio_sys;
use glib::object::IsA;
use glib::translate::*;
use glib::GString;
use glib_sys;
use gobject_sys;
#[cfg(feature = "futures")]
use std::boxed::Box as Box_;
use std::fmt;
use std::ptr;
use Cancellable;
use Error;
use Icon;
use InputStream;

glib_wrapper! {
    pub struct LoadableIcon(Interface<gio_sys::GLoadableIcon>) @requires Icon;

    match fn {
        get_type => || gio_sys::g_loadable_icon_get_type(),
    }
}

pub const NONE_LOADABLE_ICON: Option<&LoadableIcon> = None;

pub trait LoadableIconExt: 'static {
    fn load<P: IsA<Cancellable>>(
        &self,
        size: i32,
        cancellable: Option<&P>,
    ) -> Result<(InputStream, GString), Error>;

    fn load_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<(InputStream, GString), Error>) + Send + 'static,
    >(
        &self,
        size: i32,
        cancellable: Option<&P>,
        callback: Q,
    );

    #[cfg(feature = "futures")]
    fn load_async_future(
        &self,
        size: i32,
    ) -> Box_<dyn future::Future<Output = Result<(InputStream, GString), Error>> + std::marker::Unpin>;
}

impl<O: IsA<LoadableIcon>> LoadableIconExt for O {
    fn load<P: IsA<Cancellable>>(
        &self,
        size: i32,
        cancellable: Option<&P>,
    ) -> Result<(InputStream, GString), Error> {
        unsafe {
            let mut type_ = ptr::null_mut();
            let mut error = ptr::null_mut();
            let ret = gio_sys::g_loadable_icon_load(
                self.as_ref().to_glib_none().0,
                size,
                &mut type_,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok((from_glib_full(ret), from_glib_full(type_)))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn load_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<(InputStream, GString), Error>) + Send + 'static,
    >(
        &self,
        size: i32,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box<Q> = Box::new(callback);
        unsafe extern "C" fn load_async_trampoline<
            Q: FnOnce(Result<(InputStream, GString), Error>) + Send + 'static,
        >(
            _source_object: *mut gobject_sys::GObject,
            res: *mut gio_sys::GAsyncResult,
            user_data: glib_sys::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let mut type_ = ptr::null_mut();
            let ret = gio_sys::g_loadable_icon_load_finish(
                _source_object as *mut _,
                res,
                &mut type_,
                &mut error,
            );
            let result = if error.is_null() {
                Ok((from_glib_full(ret), from_glib_full(type_)))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box<Q> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = load_async_trampoline::<Q>;
        unsafe {
            gio_sys::g_loadable_icon_load_async(
                self.as_ref().to_glib_none().0,
                size,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box::into_raw(user_data) as *mut _,
            );
        }
    }

    #[cfg(feature = "futures")]
    fn load_async_future(
        &self,
        size: i32,
    ) -> Box_<dyn future::Future<Output = Result<(InputStream, GString), Error>> + std::marker::Unpin>
    {
        use fragile::Fragile;
        use GioFuture;

        GioFuture::new(self, move |obj, send| {
            let cancellable = Cancellable::new();
            let send = Fragile::new(send);
            obj.load_async(size, Some(&cancellable), move |res| {
                let _ = send.into_inner().send(res);
            });

            cancellable
        })
    }
}

impl fmt::Display for LoadableIcon {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "LoadableIcon")
    }
}
