
#line 1 "ragel/i18n/fr.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/fr.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_fr/gherkin_lexer_fr.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 21, 22, 23, 24, 25, 26, 
	27, 28, 29, 30, 31, 32, 33, 36, 
	38, 40, 60, 61, 62, 64, 66, 71, 
	76, 81, 86, 90, 94, 96, 97, 98, 
	99, 100, 101, 102, 103, 104, 105, 106, 
	107, 108, 109, 110, 111, 112, 117, 124, 
	129, 130, 131, 132, 133, 134, 135, 136, 
	137, 138, 139, 140, 141, 142, 143, 160, 
	162, 164, 166, 168, 170, 172, 174, 176, 
	178, 180, 182, 184, 188, 208, 210, 212, 
	213, 214, 215, 216, 217, 218, 219, 220, 
	221, 228, 230, 232, 234, 236, 238, 240, 
	242, 244, 246, 248, 250, 252, 254, 256, 
	258, 259, 260, 261, 262, 263, 264, 265, 
	266, 267, 268, 269, 270, 271, 272, 273, 
	274, 275, 287, 289, 291, 293, 295, 297, 
	299, 301, 303, 305, 307, 309, 311, 313, 
	315, 317, 319, 321, 323, 325, 327, 329, 
	331, 333, 335, 337, 339, 341, 343, 345, 
	347, 349, 351, 353, 355, 357, 359, 361, 
	363, 365, 367, 369, 371, 373, 375, 377, 
	379, 381, 383, 385, 387, 390, 392, 394, 
	396, 398, 400, 402, 404, 406, 407, 408, 
	409, 410, 411, 413, 414, 415, 416, 417, 
	418, 419, 420, 421, 422, 424, 425, 426, 
	427, 428, 429, 430, 431, 432, 433, 434, 
	435, 451, 453, 455, 457, 459, 461, 463, 
	465, 467, 469, 471, 473, 475, 479, 482, 
	484, 486, 488, 490, 492, 494, 496, 498, 
	500, 502, 504, 506, 508, 510, 512, 514, 
	516, 518, 520, 522, 525, 527, 529, 531, 
	533, 535, 537, 539, 541, 543, 545, 547, 
	549, 551, 553, 555, 557, 559, 561, 563, 
	565, 568, 570, 572, 574, 576, 578, 580, 
	583, 585, 587, 589, 591, 593, 595, 597, 
	599, 601, 602, 603, 604, 605, 607, 608, 
	609, 610, 611, 612, 613, 614, 615, 616, 
	617, 635, 637, 639, 641, 643, 645, 647, 
	649, 651, 653, 655, 657, 659, 663, 666, 
	668, 670, 672, 674, 676, 678, 680, 682, 
	684, 686, 688, 690, 692, 694, 696, 698, 
	700, 702, 704, 706, 708, 710, 712, 714, 
	716, 718, 720, 722, 725, 727, 729, 731, 
	733, 735, 737, 739, 741, 743, 745, 747, 
	749, 751, 753, 755, 757, 759, 761, 763, 
	766, 768, 770, 772, 774, 776, 778, 780, 
	782, 784, 787, 789, 791, 793, 795, 797, 
	799, 801, 803, 805, 807, 809, 811, 814, 
	816, 818, 819, 820, 824, 830, 833, 835, 
	841, 861, 864, 866, 868, 870, 872, 874, 
	876, 878, 880, 882, 884, 886, 888, 890, 
	892, 894, 896, 898, 900, 902, 904, 907, 
	909, 911, 913, 915, 917, 919, 921, 923, 
	925, 927, 929, 931, 933, 935, 937, 939, 
	941, 943, 945, 947, 950, 952, 954, 956, 
	958, 960, 962, 964, 966, 968, 971, 973, 
	975, 977, 979, 981, 983, 985, 987, 989, 
	991, 993, 995, 998, 1000, 1002, 1004, 1005, 
	1006
};

static const char _lexer_trans_keys[] = {
	-61, -17, 10, 32, 34, 35, 37, 42, 
	64, 65, 67, 69, 70, 76, 77, 80, 
	81, 83, 124, 9, 13, -119, 116, 97, 
	110, 116, 32, 100, 111, 110, 110, -61, 
	-87, 32, 101, 115, 10, 13, 10, 13, 
	-61, 10, 32, 34, 35, 37, 42, 64, 
	65, 67, 69, 70, 76, 77, 80, 81, 
	83, 124, 9, 13, 34, 34, 10, 13, 
	10, 13, 10, 32, 34, 9, 13, 10, 
	32, 34, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	9, 13, 10, 32, 9, 13, 10, 13, 
	10, 95, 70, 69, 65, 84, 85, 82, 
	69, 95, 69, 78, 68, 95, 37, 32, 
	13, 32, 64, 9, 10, 9, 10, 13, 
	32, 64, 11, 12, 10, 32, 64, 9, 
	13, 108, 111, 114, 115, 111, 110, 116, 
	101, 120, 116, 101, 58, 10, 10, -61, 
	10, 32, 35, 37, 42, 64, 65, 69, 
	70, 76, 77, 80, 81, 83, 9, 13, 
	-119, 10, 10, 116, 10, 97, 10, 110, 
	10, 116, 10, 32, 10, 100, 10, 111, 
	10, 110, 10, 110, -61, 10, -87, 10, 
	10, 32, 101, 115, -61, 10, 32, 34, 
	35, 37, 42, 64, 65, 67, 69, 70, 
	76, 77, 80, 81, 83, 124, 9, 13, 
	116, 120, 32, 97, 101, 109, 112, 108, 
	101, 115, 58, 10, 10, 10, 32, 35, 
	70, 124, 9, 13, 10, 111, 10, 110, 
	10, 99, 10, 116, 10, 105, 10, 111, 
	10, 110, 10, 110, 10, 97, 10, 108, 
	10, 105, 10, 116, -61, 10, -87, 10, 
	10, 58, 111, 110, 99, 116, 105, 111, 
	110, 110, 97, 108, 105, 116, -61, -87, 
	58, 10, 10, 10, 32, 35, 37, 64, 
	67, 69, 70, 80, 83, 9, 13, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, 10, 111, 10, 110, 10, 
	116, 10, 101, 10, 120, 10, 116, 10, 
	101, 10, 58, 10, 120, 10, 101, 10, 
	109, 10, 112, 10, 108, 10, 101, 10, 
	115, 10, 111, 10, 110, 10, 99, 10, 
	116, 10, 105, 10, 111, 10, 110, 10, 
	110, 10, 97, 10, 108, 10, 105, 10, 
	116, -61, 10, -87, 10, 10, 108, 10, 
	97, 10, 110, 10, 32, 10, 100, 10, 
	117, 10, 32, 10, 83, 115, 10, 99, 
	-61, 10, -87, 10, 10, 110, 10, 97, 
	10, 114, 10, 105, 10, 111, 111, 114, 
	115, 113, 117, 39, 101, 97, 105, 108, 
	97, 110, 32, 100, 117, 32, 83, 115, 
	99, -61, -87, 110, 97, 114, 105, 111, 
	58, 10, 10, -61, 10, 32, 35, 37, 
	42, 64, 65, 69, 70, 76, 77, 81, 
	83, 9, 13, -119, 10, 10, 116, 10, 
	97, 10, 110, 10, 116, 10, 32, 10, 
	100, 10, 111, 10, 110, 10, 110, -61, 
	10, -87, 10, 10, 32, 101, 115, 10, 
	32, 115, 10, 32, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	10, 108, 10, 111, 10, 114, 10, 115, 
	10, 116, 10, 32, 97, 10, 111, 10, 
	110, 10, 99, 10, 116, 10, 105, 10, 
	111, 10, 110, 10, 110, 10, 97, 10, 
	108, 10, 105, 10, 116, -61, 10, -87, 
	10, 10, 58, 10, 111, 10, 114, 10, 
	115, 10, 113, 10, 117, 10, 39, 101, 
	10, 97, 10, 105, 10, 117, 10, 97, 
	10, 110, 10, 100, 10, 99, 111, -61, 
	10, -87, 10, 10, 110, 10, 97, 10, 
	114, 10, 105, 10, 111, 10, 105, 10, 
	116, 117, 97, 110, 100, 99, 111, -61, 
	-87, 110, 97, 114, 105, 111, 58, 10, 
	10, -61, 10, 32, 35, 37, 42, 64, 
	65, 67, 69, 70, 76, 77, 80, 81, 
	83, 9, 13, -119, 10, 10, 116, 10, 
	97, 10, 110, 10, 116, 10, 32, 10, 
	100, 10, 111, 10, 110, 10, 110, -61, 
	10, -87, 10, 10, 32, 101, 115, 10, 
	32, 115, 10, 32, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	10, 108, 10, 111, 10, 114, 10, 115, 
	10, 111, 10, 110, 10, 116, 10, 101, 
	10, 120, 10, 116, 10, 101, 10, 58, 
	10, 116, 10, 32, 97, 10, 111, 10, 
	110, 10, 99, 10, 116, 10, 105, 10, 
	111, 10, 110, 10, 110, 10, 97, 10, 
	108, 10, 105, 10, 116, -61, 10, -87, 
	10, 10, 111, 10, 114, 10, 115, 10, 
	113, 10, 117, 10, 39, 101, 10, 97, 
	10, 105, 10, 108, 10, 97, 10, 110, 
	10, 32, 10, 100, 10, 117, 10, 32, 
	10, 83, 115, 10, 99, -61, 10, -87, 
	10, 10, 110, 10, 97, 10, 114, 10, 
	105, 10, 111, 10, 117, 10, 97, 10, 
	110, 10, 100, 10, 99, 111, 10, 105, 
	10, 116, 105, 116, 32, 124, 9, 13, 
	10, 32, 92, 124, 9, 13, 10, 92, 
	124, 10, 92, 10, 32, 92, 124, 9, 
	13, -61, 10, 32, 34, 35, 37, 42, 
	64, 65, 67, 69, 70, 76, 77, 80, 
	81, 83, 124, 9, 13, 10, 32, 115, 
	10, 32, 10, 95, 10, 70, 10, 69, 
	10, 65, 10, 84, 10, 85, 10, 82, 
	10, 69, 10, 95, 10, 69, 10, 78, 
	10, 68, 10, 95, 10, 37, 10, 108, 
	10, 111, 10, 114, 10, 115, 10, 116, 
	10, 32, 97, 10, 111, 10, 110, 10, 
	99, 10, 116, 10, 105, 10, 111, 10, 
	110, 10, 110, 10, 97, 10, 108, 10, 
	105, 10, 116, -61, 10, -87, 10, 10, 
	58, 10, 111, 10, 114, 10, 115, 10, 
	113, 10, 117, 10, 39, 101, 10, 97, 
	10, 105, 10, 108, 10, 97, 10, 110, 
	10, 32, 10, 100, 10, 117, 10, 32, 
	10, 83, 115, 10, 99, -61, 10, -87, 
	10, 10, 110, 10, 97, 10, 114, 10, 
	105, 10, 111, 10, 117, 10, 97, 10, 
	110, 10, 100, 10, 99, 111, 10, 105, 
	10, 116, 32, 115, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 19, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 3, 2, 
	2, 18, 1, 1, 2, 2, 3, 3, 
	3, 3, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 3, 5, 3, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 15, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 4, 18, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	5, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 10, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	14, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 4, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	16, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 4, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 1, 1, 2, 4, 3, 2, 4, 
	18, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 1, 1, 
	0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 1, 1, 
	1, 1, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 1, 0, 0, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0
};

static const short _lexer_index_offsets[] = {
	0, 0, 21, 23, 25, 27, 29, 31, 
	33, 35, 37, 39, 41, 43, 45, 49, 
	52, 55, 75, 77, 79, 82, 85, 90, 
	95, 100, 105, 109, 113, 116, 118, 120, 
	122, 124, 126, 128, 130, 132, 134, 136, 
	138, 140, 142, 144, 146, 148, 153, 160, 
	165, 167, 169, 171, 173, 175, 177, 179, 
	181, 183, 185, 187, 189, 191, 193, 210, 
	213, 216, 219, 222, 225, 228, 231, 234, 
	237, 240, 243, 246, 251, 271, 274, 277, 
	279, 281, 283, 285, 287, 289, 291, 293, 
	295, 302, 305, 308, 311, 314, 317, 320, 
	323, 326, 329, 332, 335, 338, 341, 344, 
	347, 349, 351, 353, 355, 357, 359, 361, 
	363, 365, 367, 369, 371, 373, 375, 377, 
	379, 381, 393, 396, 399, 402, 405, 408, 
	411, 414, 417, 420, 423, 426, 429, 432, 
	435, 438, 441, 444, 447, 450, 453, 456, 
	459, 462, 465, 468, 471, 474, 477, 480, 
	483, 486, 489, 492, 495, 498, 501, 504, 
	507, 510, 513, 516, 519, 522, 525, 528, 
	531, 534, 537, 540, 543, 547, 550, 553, 
	556, 559, 562, 565, 568, 571, 573, 575, 
	577, 579, 581, 584, 586, 588, 590, 592, 
	594, 596, 598, 600, 602, 605, 607, 609, 
	611, 613, 615, 617, 619, 621, 623, 625, 
	627, 643, 646, 649, 652, 655, 658, 661, 
	664, 667, 670, 673, 676, 679, 684, 688, 
	691, 694, 697, 700, 703, 706, 709, 712, 
	715, 718, 721, 724, 727, 730, 733, 736, 
	739, 742, 745, 748, 752, 755, 758, 761, 
	764, 767, 770, 773, 776, 779, 782, 785, 
	788, 791, 794, 797, 800, 803, 806, 809, 
	812, 816, 819, 822, 825, 828, 831, 834, 
	838, 841, 844, 847, 850, 853, 856, 859, 
	862, 865, 867, 869, 871, 873, 876, 878, 
	880, 882, 884, 886, 888, 890, 892, 894, 
	896, 914, 917, 920, 923, 926, 929, 932, 
	935, 938, 941, 944, 947, 950, 955, 959, 
	962, 965, 968, 971, 974, 977, 980, 983, 
	986, 989, 992, 995, 998, 1001, 1004, 1007, 
	1010, 1013, 1016, 1019, 1022, 1025, 1028, 1031, 
	1034, 1037, 1040, 1043, 1047, 1050, 1053, 1056, 
	1059, 1062, 1065, 1068, 1071, 1074, 1077, 1080, 
	1083, 1086, 1089, 1092, 1095, 1098, 1101, 1104, 
	1108, 1111, 1114, 1117, 1120, 1123, 1126, 1129, 
	1132, 1135, 1139, 1142, 1145, 1148, 1151, 1154, 
	1157, 1160, 1163, 1166, 1169, 1172, 1175, 1179, 
	1182, 1185, 1187, 1189, 1193, 1199, 1203, 1206, 
	1212, 1232, 1236, 1239, 1242, 1245, 1248, 1251, 
	1254, 1257, 1260, 1263, 1266, 1269, 1272, 1275, 
	1278, 1281, 1284, 1287, 1290, 1293, 1296, 1300, 
	1303, 1306, 1309, 1312, 1315, 1318, 1321, 1324, 
	1327, 1330, 1333, 1336, 1339, 1342, 1345, 1348, 
	1351, 1354, 1357, 1360, 1364, 1367, 1370, 1373, 
	1376, 1379, 1382, 1385, 1388, 1391, 1395, 1398, 
	1401, 1404, 1407, 1410, 1413, 1416, 1419, 1422, 
	1425, 1428, 1431, 1435, 1438, 1441, 1444, 1446, 
	1448
};

static const short _lexer_trans_targs[] = {
	2, 462, 17, 17, 18, 28, 30, 44, 
	45, 48, 52, 77, 104, 181, 187, 189, 
	281, 285, 387, 17, 0, 3, 0, 4, 
	0, 5, 0, 6, 0, 7, 0, 8, 
	0, 9, 0, 10, 0, 11, 0, 12, 
	0, 13, 0, 14, 0, 15, 461, 44, 
	0, 17, 29, 16, 17, 29, 16, 2, 
	17, 17, 18, 28, 30, 44, 45, 48, 
	52, 77, 104, 181, 187, 189, 281, 285, 
	387, 17, 0, 19, 0, 20, 0, 22, 
	21, 21, 22, 21, 21, 23, 23, 24, 
	23, 23, 23, 23, 24, 23, 23, 23, 
	23, 25, 23, 23, 23, 23, 26, 23, 
	23, 17, 27, 27, 0, 17, 27, 27, 
	0, 17, 29, 28, 17, 0, 31, 0, 
	32, 0, 33, 0, 34, 0, 35, 0, 
	36, 0, 37, 0, 38, 0, 39, 0, 
	40, 0, 41, 0, 42, 0, 43, 0, 
	464, 0, 15, 0, 0, 0, 0, 0, 
	46, 47, 17, 47, 47, 45, 46, 46, 
	17, 47, 45, 47, 0, 49, 0, 50, 
	0, 51, 0, 44, 0, 53, 0, 54, 
	0, 55, 0, 56, 0, 57, 0, 58, 
	0, 59, 0, 60, 0, 62, 61, 62, 
	61, 63, 62, 62, 17, 395, 394, 17, 
	409, 413, 415, 430, 436, 438, 454, 458, 
	62, 61, 64, 62, 61, 62, 65, 61, 
	62, 66, 61, 62, 67, 61, 62, 68, 
	61, 62, 69, 61, 62, 70, 61, 62, 
	71, 61, 62, 72, 61, 62, 73, 61, 
	74, 62, 61, 75, 62, 61, 62, 76, 
	393, 394, 61, 2, 17, 17, 18, 28, 
	30, 44, 45, 48, 52, 77, 104, 181, 
	187, 189, 281, 285, 387, 17, 0, 78, 
	79, 0, 15, 5, 0, 80, 0, 81, 
	0, 82, 0, 83, 0, 84, 0, 85, 
	0, 86, 0, 88, 87, 88, 87, 88, 
	88, 17, 89, 17, 88, 87, 88, 90, 
	87, 88, 91, 87, 88, 92, 87, 88, 
	93, 87, 88, 94, 87, 88, 95, 87, 
	88, 96, 87, 88, 97, 87, 88, 98, 
	87, 88, 99, 87, 88, 100, 87, 88, 
	101, 87, 102, 88, 87, 103, 88, 87, 
	88, 76, 87, 105, 0, 106, 0, 107, 
	0, 108, 0, 109, 0, 110, 0, 111, 
	0, 112, 0, 113, 0, 114, 0, 115, 
	0, 116, 0, 117, 0, 118, 0, 119, 
	0, 121, 120, 121, 120, 121, 121, 17, 
	122, 17, 136, 144, 151, 165, 173, 121, 
	120, 121, 123, 120, 121, 124, 120, 121, 
	125, 120, 121, 126, 120, 121, 127, 120, 
	121, 128, 120, 121, 129, 120, 121, 130, 
	120, 121, 131, 120, 121, 132, 120, 121, 
	133, 120, 121, 134, 120, 121, 135, 120, 
	121, 17, 120, 121, 137, 120, 121, 138, 
	120, 121, 139, 120, 121, 140, 120, 121, 
	141, 120, 121, 142, 120, 121, 143, 120, 
	121, 76, 120, 121, 145, 120, 121, 146, 
	120, 121, 147, 120, 121, 148, 120, 121, 
	149, 120, 121, 150, 120, 121, 143, 120, 
	121, 152, 120, 121, 153, 120, 121, 154, 
	120, 121, 155, 120, 121, 156, 120, 121, 
	157, 120, 121, 158, 120, 121, 159, 120, 
	121, 160, 120, 121, 161, 120, 121, 162, 
	120, 121, 163, 120, 164, 121, 120, 143, 
	121, 120, 121, 166, 120, 121, 167, 120, 
	121, 168, 120, 121, 169, 120, 121, 170, 
	120, 121, 171, 120, 121, 172, 120, 121, 
	173, 173, 120, 121, 174, 120, 175, 121, 
	120, 176, 121, 120, 121, 177, 120, 121, 
	178, 120, 121, 179, 120, 121, 180, 120, 
	121, 143, 120, 182, 0, 183, 0, 184, 
	0, 185, 0, 186, 0, 15, 44, 0, 
	188, 0, 51, 0, 190, 0, 191, 0, 
	192, 0, 193, 0, 194, 0, 195, 0, 
	196, 0, 197, 197, 0, 198, 0, 199, 
	0, 200, 0, 201, 0, 202, 0, 203, 
	0, 204, 0, 205, 0, 206, 0, 208, 
	207, 208, 207, 209, 208, 208, 17, 224, 
	223, 17, 238, 242, 244, 259, 265, 267, 
	271, 208, 207, 210, 208, 207, 208, 211, 
	207, 208, 212, 207, 208, 213, 207, 208, 
	214, 207, 208, 215, 207, 208, 216, 207, 
	208, 217, 207, 208, 218, 207, 208, 219, 
	207, 220, 208, 207, 221, 208, 207, 208, 
	76, 222, 223, 207, 208, 76, 223, 207, 
	208, 76, 207, 208, 225, 207, 208, 226, 
	207, 208, 227, 207, 208, 228, 207, 208, 
	229, 207, 208, 230, 207, 208, 231, 207, 
	208, 232, 207, 208, 233, 207, 208, 234, 
	207, 208, 235, 207, 208, 236, 207, 208, 
	237, 207, 208, 17, 207, 208, 239, 207, 
	208, 240, 207, 208, 241, 207, 208, 223, 
	207, 208, 243, 207, 208, 76, 212, 207, 
	208, 245, 207, 208, 246, 207, 208, 247, 
	207, 208, 248, 207, 208, 249, 207, 208, 
	250, 207, 208, 251, 207, 208, 252, 207, 
	208, 253, 207, 208, 254, 207, 208, 255, 
	207, 208, 256, 207, 257, 208, 207, 258, 
	208, 207, 208, 76, 207, 208, 260, 207, 
	208, 261, 207, 208, 262, 207, 208, 263, 
	207, 208, 264, 207, 208, 76, 223, 207, 
	208, 266, 207, 208, 241, 207, 208, 268, 
	207, 208, 269, 207, 208, 270, 207, 208, 
	223, 207, 208, 272, 279, 207, 273, 208, 
	207, 274, 208, 207, 208, 275, 207, 208, 
	276, 207, 208, 277, 207, 208, 278, 207, 
	208, 258, 207, 208, 280, 207, 208, 223, 
	207, 282, 0, 283, 0, 284, 0, 44, 
	0, 286, 385, 0, 287, 0, 288, 0, 
	289, 0, 290, 0, 291, 0, 292, 0, 
	293, 0, 294, 0, 296, 295, 296, 295, 
	297, 296, 296, 17, 312, 311, 17, 326, 
	330, 338, 340, 354, 360, 362, 378, 382, 
	296, 295, 298, 296, 295, 296, 299, 295, 
	296, 300, 295, 296, 301, 295, 296, 302, 
	295, 296, 303, 295, 296, 304, 295, 296, 
	305, 295, 296, 306, 295, 296, 307, 295, 
	308, 296, 295, 309, 296, 295, 296, 76, 
	310, 311, 295, 296, 76, 311, 295, 296, 
	76, 295, 296, 313, 295, 296, 314, 295, 
	296, 315, 295, 296, 316, 295, 296, 317, 
	295, 296, 318, 295, 296, 319, 295, 296, 
	320, 295, 296, 321, 295, 296, 322, 295, 
	296, 323, 295, 296, 324, 295, 296, 325, 
	295, 296, 17, 295, 296, 327, 295, 296, 
	328, 295, 296, 329, 295, 296, 311, 295, 
	296, 331, 295, 296, 332, 295, 296, 333, 
	295, 296, 334, 295, 296, 335, 295, 296, 
	336, 295, 296, 337, 295, 296, 76, 295, 
	296, 339, 295, 296, 76, 300, 295, 296, 
	341, 295, 296, 342, 295, 296, 343, 295, 
	296, 344, 295, 296, 345, 295, 296, 346, 
	295, 296, 347, 295, 296, 348, 295, 296, 
	349, 295, 296, 350, 295, 296, 351, 295, 
	296, 352, 295, 353, 296, 295, 337, 296, 
	295, 296, 355, 295, 296, 356, 295, 296, 
	357, 295, 296, 358, 295, 296, 359, 295, 
	296, 76, 311, 295, 296, 361, 295, 296, 
	329, 295, 296, 363, 295, 296, 364, 295, 
	296, 365, 295, 296, 366, 295, 296, 367, 
	295, 296, 368, 295, 296, 369, 295, 296, 
	370, 370, 295, 296, 371, 295, 372, 296, 
	295, 373, 296, 295, 296, 374, 295, 296, 
	375, 295, 296, 376, 295, 296, 377, 295, 
	296, 337, 295, 296, 379, 295, 296, 380, 
	295, 296, 381, 295, 296, 311, 295, 296, 
	371, 383, 295, 296, 384, 295, 296, 311, 
	295, 386, 0, 44, 0, 387, 388, 387, 
	0, 392, 391, 390, 388, 391, 389, 0, 
	390, 388, 389, 0, 390, 389, 392, 391, 
	390, 388, 391, 389, 2, 392, 392, 18, 
	28, 30, 44, 45, 48, 52, 77, 104, 
	181, 187, 189, 281, 285, 387, 392, 0, 
	62, 76, 394, 61, 62, 76, 61, 62, 
	396, 61, 62, 397, 61, 62, 398, 61, 
	62, 399, 61, 62, 400, 61, 62, 401, 
	61, 62, 402, 61, 62, 403, 61, 62, 
	404, 61, 62, 405, 61, 62, 406, 61, 
	62, 407, 61, 62, 408, 61, 62, 17, 
	61, 62, 410, 61, 62, 411, 61, 62, 
	412, 61, 62, 394, 61, 62, 414, 61, 
	62, 76, 66, 61, 62, 416, 61, 62, 
	417, 61, 62, 418, 61, 62, 419, 61, 
	62, 420, 61, 62, 421, 61, 62, 422, 
	61, 62, 423, 61, 62, 424, 61, 62, 
	425, 61, 62, 426, 61, 62, 427, 61, 
	428, 62, 61, 429, 62, 61, 62, 76, 
	61, 62, 431, 61, 62, 432, 61, 62, 
	433, 61, 62, 434, 61, 62, 435, 61, 
	62, 76, 394, 61, 62, 437, 61, 62, 
	412, 61, 62, 439, 61, 62, 440, 61, 
	62, 441, 61, 62, 442, 61, 62, 443, 
	61, 62, 444, 61, 62, 445, 61, 62, 
	446, 446, 61, 62, 447, 61, 448, 62, 
	61, 449, 62, 61, 62, 450, 61, 62, 
	451, 61, 62, 452, 61, 62, 453, 61, 
	62, 429, 61, 62, 455, 61, 62, 456, 
	61, 62, 457, 61, 62, 394, 61, 62, 
	447, 459, 61, 62, 460, 61, 62, 394, 
	61, 15, 44, 0, 463, 0, 17, 0, 
	0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 0, 54, 0, 5, 1, 0, 29, 
	1, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 35, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 0, 
	43, 149, 126, 57, 110, 23, 0, 29, 
	54, 0, 5, 1, 0, 29, 1, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	35, 0, 43, 0, 43, 0, 43, 139, 
	48, 9, 106, 11, 0, 134, 45, 45, 
	45, 3, 122, 33, 33, 33, 0, 122, 
	33, 33, 33, 0, 122, 33, 0, 33, 
	0, 102, 7, 7, 43, 54, 0, 0, 
	43, 114, 25, 0, 54, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 43, 43, 43, 43, 
	0, 27, 118, 27, 27, 51, 27, 0, 
	54, 0, 1, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 84, 54, 0, 72, 33, 84, 72, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	0, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 54, 15, 
	0, 0, 0, 63, 130, 31, 60, 57, 
	31, 63, 57, 63, 63, 63, 63, 63, 
	63, 63, 63, 63, 66, 31, 43, 0, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 54, 
	0, 81, 84, 81, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	54, 21, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 54, 0, 69, 
	33, 69, 84, 84, 84, 84, 84, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 13, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 13, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 84, 54, 0, 78, 33, 
	84, 78, 84, 84, 84, 84, 84, 84, 
	84, 0, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	19, 0, 0, 0, 54, 19, 0, 0, 
	54, 19, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 19, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 19, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 54, 19, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 19, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 144, 57, 54, 0, 
	84, 54, 0, 75, 33, 84, 75, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	0, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 54, 17, 
	0, 0, 0, 54, 17, 0, 0, 54, 
	17, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 17, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 17, 0, 
	54, 0, 0, 54, 17, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 17, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 43, 0, 43, 0, 0, 0, 
	43, 54, 37, 37, 87, 37, 37, 43, 
	0, 39, 0, 43, 0, 0, 54, 0, 
	0, 39, 0, 0, 96, 54, 0, 93, 
	90, 41, 96, 90, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 99, 0, 43, 
	54, 15, 0, 0, 54, 15, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 15, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 15, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 54, 15, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 15, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 0, 43, 0, 43, 0, 43, 
	0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43
};

static const int lexer_start = 1;
static const int lexer_first_final = 464;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/fr.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1097 "ext/gherkin_lexer_fr/gherkin_lexer_fr.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/fr.c.rl"
    
#line 1104 "ext/gherkin_lexer_fr/gherkin_lexer_fr.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/fr.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/fr.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/fr.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/fr.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/fr.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/fr.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/fr.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/fr.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/fr.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/fr.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/fr.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/fr.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/fr.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/fr.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/fr.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/fr.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/fr.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/fr.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/fr.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/fr.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/fr.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/fr.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/fr.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/fr.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1394 "ext/gherkin_lexer_fr/gherkin_lexer_fr.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/fr.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1457 "ext/gherkin_lexer_fr/gherkin_lexer_fr.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/fr.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_fr()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Fr", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

