module Fog
  module Compute
    class Brightbox
      class Real
        # Create a new image for the account by registering it against an image stored within the Brightbox cloud image library.
        #
        # The disk image must be in place before you can attempt to create a reference in the API.
        #
        # @param [Hash] options
        # @option options [String] :source Filename of the image file uploaded to /incoming via FTP
        # @option options [String] :arch OS architecture this image is built for
        # @option options [String] :name Name for this image. If no name is specified, a name will be autogenerated based on the source filename &amp; current time. Can be modified later.
        # @option options [String] :username Username for the image
        # @option options [Boolean] :public
        # @option options [Boolean] :compatibility_mode
        # @option options [String] :description
        #
        # @return [Hash] if successful Hash version of JSON object
        # @return [NilClass] if no options were passed
        #
        # @see https://api.gb1.brightbox.com/1.0/#image_create_image
        #
        def create_image(options)
          wrapped_request("post", "/1.0/images", [201], options)
        end
      end
    end
  end
end
