# Module.mk for spectrumpainter module
# Copyright (c) 2000 Rene Brun and Fons Rademakers
#
# Author: Olivier Couet, 27/11/2006

MODNAME      := spectrumpainter
MODDIR       := $(ROOT_SRCDIR)/hist/$(MODNAME)
MODDIRS      := $(MODDIR)/src
MODDIRI      := $(MODDIR)/inc

SPECTRUMPAINTERDIR  := $(MODDIR)
SPECTRUMPAINTERDIRS := $(SPECTRUMPAINTERDIR)/src
SPECTRUMPAINTERDIRI := $(SPECTRUMPAINTERDIR)/inc

##### libSpectrumPainter #####
SPECTRUMPAINTERL  := $(MODDIRI)/LinkDef.h
SPECTRUMPAINTERDS := $(call stripsrc,$(MODDIRS)/G__Spectrum2Painter.cxx)
SPECTRUMPAINTERDO := $(SPECTRUMPAINTERDS:.cxx=.o)
SPECTRUMPAINTERDH := $(SPECTRUMPAINTERDS:.cxx=.h)

SPECTRUMPAINTERH  := $(filter-out $(MODDIRI)/LinkDef%,$(wildcard $(MODDIRI)/*.h))
SPECTRUMPAINTERS  := $(filter-out $(MODDIRS)/G__%,$(wildcard $(MODDIRS)/*.cxx))
SPECTRUMPAINTERO  := $(call stripsrc,$(SPECTRUMPAINTERS:.cxx=.o))

SPECTRUMPAINTERDEP := $(SPECTRUMPAINTERO:.o=.d) $(SPECTRUMPAINTERDO:.o=.d)

SPECTRUMPAINTERLIB := $(LPATH)/libSpectrumPainter.$(SOEXT)
SPECTRUMPAINTERMAP := $(SPECTRUMPAINTERLIB:.$(SOEXT)=.rootmap)

# used in the main Makefile
ALLHDRS       += $(patsubst $(MODDIRI)/%.h,include/%.h,$(SPECTRUMPAINTERH))
ALLLIBS       += $(SPECTRUMPAINTERLIB)
ALLMAPS       += $(SPECTRUMPAINTERMAP)

# include all dependency files
INCLUDEFILES += $(SPECTRUMPAINTERDEP)

##### local rules #####
.PHONY:         all-$(MODNAME) clean-$(MODNAME) distclean-$(MODNAME)

include/%.h:    $(SPECTRUMPAINTERDIRI)/%.h
		cp $< $@

$(SPECTRUMPAINTERLIB): $(SPECTRUMPAINTERO) $(SPECTRUMPAINTERDO) $(ORDER_) \
                       $(MAINLIBS) $(SPECTRUMPAINTERLIBDEP)
		@$(MAKELIB) $(PLATFORM) $(LD) "$(LDFLAGS)" \
		   "$(SOFLAGS)" libSpectrumPainter.$(SOEXT) $@ \
		   "$(SPECTRUMPAINTERO) $(SPECTRUMPAINTERDO)" \
		   "$(SPECTRUMPAINTERLIBEXTRA)"

$(SPECTRUMPAINTERDS): $(SPECTRUMPAINTERH) $(SPECTRUMPAINTERL) $(ROOTCINTTMPDEP)
		$(MAKEDIR)
		@echo "Generating dictionary $@..."
		$(ROOTCINTTMP) -f $@ -c $(SPECTRUMPAINTERH) $(SPECTRUMPAINTERL)

$(SPECTRUMPAINTERMAP): $(RLIBMAP) $(MAKEFILEDEP) $(SPECTRUMPAINTERL)
		$(RLIBMAP) -o $@ -l $(SPECTRUMPAINTERLIB) \
		   -d $(SPECTRUMPAINTERLIBDEPM) -c $(SPECTRUMPAINTERL)

all-$(MODNAME): $(SPECTRUMPAINTERLIB) $(SPECTRUMPAINTERMAP)

clean-$(MODNAME):
		@rm -f $(SPECTRUMPAINTERO) $(SPECTRUMPAINTERDO)

clean::         clean-$(MODNAME)

distclean-$(MODNAME): clean-$(MODNAME)
		@rm -f $(SPECTRUMPAINTERDEP) $(SPECTRUMPAINTERDS) \
		   $(SPECTRUMPAINTERDH) $(SPECTRUMPAINTERLIB) $(SPECTRUMPAINTERMAP)

distclean::     distclean-$(MODNAME)
