/******************************************************************************
 * The MIT License (MIT)
 *
 * Copyright (c) 2018-2023 Baldur Karlsson
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

#pragma once

// This file is autogenerated with gen_dispatch_table.py - any changes will be overwritten next time
// that script is run.
// $ ./gen_dispatch_table.py

// We need to disable clang-format since this struct is programmatically generated
// clang-format off




#define ForEachSupported(FUNC) \
  FUNC(glBindTexture, glBindTexture); \
  FUNC(glBlendFunc, glBlendFunc); \
  FUNC(glClear, glClear); \
  FUNC(glClearColor, glClearColor); \
  FUNC(glClearDepth, glClearDepth); \
  FUNC(glClearStencil, glClearStencil); \
  FUNC(glColorMask, glColorMask); \
  FUNC(glCullFace, glCullFace); \
  FUNC(glDepthFunc, glDepthFunc); \
  FUNC(glDepthMask, glDepthMask); \
  FUNC(glDepthRange, glDepthRange); \
  FUNC(glStencilFunc, glStencilFunc); \
  FUNC(glStencilMask, glStencilMask); \
  FUNC(glStencilOp, glStencilOp); \
  FUNC(glDisable, glDisable); \
  FUNC(glDrawBuffer, glDrawBuffer); \
  FUNC(glDrawElements, glDrawElements); \
  FUNC(glDrawArrays, glDrawArrays); \
  FUNC(glEnable, glEnable); \
  FUNC(glFlush, glFlush); \
  FUNC(glFinish, glFinish); \
  FUNC(glFrontFace, glFrontFace); \
  FUNC(glGenTextures, glGenTextures); \
  FUNC(glDeleteTextures, glDeleteTextures); \
  FUNC(glIsEnabled, glIsEnabled); \
  FUNC(glIsTexture, glIsTexture); \
  FUNC(glGetError, glGetError); \
  FUNC(glGetTexLevelParameteriv, glGetTexLevelParameteriv); \
  FUNC(glGetTexLevelParameterfv, glGetTexLevelParameterfv); \
  FUNC(glGetTexParameterfv, glGetTexParameterfv); \
  FUNC(glGetTexParameteriv, glGetTexParameteriv); \
  FUNC(glGetTexImage, glGetTexImage); \
  FUNC(glGetBooleanv, glGetBooleanv); \
  FUNC(glGetFloatv, glGetFloatv); \
  FUNC(glGetDoublev, glGetDoublev); \
  FUNC(glGetIntegerv, glGetIntegerv); \
  FUNC(glGetPointerv, glGetPointerv); \
  FUNC(glGetPointerv, glGetPointervKHR); \
  FUNC(glGetString, glGetString); \
  FUNC(glHint, glHint); \
  FUNC(glLogicOp, glLogicOp); \
  FUNC(glPixelStorei, glPixelStorei); \
  FUNC(glPixelStoref, glPixelStoref); \
  FUNC(glPolygonMode, glPolygonMode); \
  FUNC(glPolygonOffset, glPolygonOffset); \
  FUNC(glPointSize, glPointSize); \
  FUNC(glLineWidth, glLineWidth); \
  FUNC(glReadPixels, glReadPixels); \
  FUNC(glReadBuffer, glReadBuffer); \
  FUNC(glScissor, glScissor); \
  FUNC(glTexImage1D, glTexImage1D); \
  FUNC(glTexImage2D, glTexImage2D); \
  FUNC(glTexSubImage1D, glTexSubImage1D); \
  FUNC(glTexSubImage2D, glTexSubImage2D); \
  FUNC(glCopyTexImage1D, glCopyTexImage1D); \
  FUNC(glCopyTexImage2D, glCopyTexImage2D); \
  FUNC(glCopyTexSubImage1D, glCopyTexSubImage1D); \
  FUNC(glCopyTexSubImage2D, glCopyTexSubImage2D); \
  FUNC(glTexParameterf, glTexParameterf); \
  FUNC(glTexParameterfv, glTexParameterfv); \
  FUNC(glTexParameteri, glTexParameteri); \
  FUNC(glTexParameteriv, glTexParameteriv); \
  FUNC(glViewport, glViewport); \
  FUNC(glActiveTexture, glActiveTexture); \
  FUNC(glActiveTexture, glActiveTextureARB); \
  FUNC(glTexStorage1D, glTexStorage1D); \
  FUNC(glTexStorage1D, glTexStorage1DEXT); \
  FUNC(glTexStorage2D, glTexStorage2D); \
  FUNC(glTexStorage2D, glTexStorage2DEXT); \
  FUNC(glTexStorage3D, glTexStorage3D); \
  FUNC(glTexStorage3D, glTexStorage3DEXT); \
  FUNC(glTexStorage2DMultisample, glTexStorage2DMultisample); \
  FUNC(glTexStorage3DMultisample, glTexStorage3DMultisample); \
  FUNC(glTexStorage3DMultisample, glTexStorage3DMultisampleOES); \
  FUNC(glTexImage3D, glTexImage3D); \
  FUNC(glTexImage3D, glTexImage3DEXT); \
  FUNC(glTexImage3D, glTexImage3DOES); \
  FUNC(glTexSubImage3D, glTexSubImage3D); \
  FUNC(glTexSubImage3D, glTexSubImage3DOES); \
  FUNC(glTexBuffer, glTexBuffer); \
  FUNC(glTexBuffer, glTexBufferARB); \
  FUNC(glTexBuffer, glTexBufferEXT); \
  FUNC(glTexBuffer, glTexBufferOES); \
  FUNC(glTexImage2DMultisample, glTexImage2DMultisample); \
  FUNC(glTexImage3DMultisample, glTexImage3DMultisample); \
  FUNC(glCompressedTexImage1D, glCompressedTexImage1D); \
  FUNC(glCompressedTexImage1D, glCompressedTexImage1DARB); \
  FUNC(glCompressedTexImage2D, glCompressedTexImage2D); \
  FUNC(glCompressedTexImage2D, glCompressedTexImage2DARB); \
  FUNC(glCompressedTexImage3D, glCompressedTexImage3D); \
  FUNC(glCompressedTexImage3D, glCompressedTexImage3DARB); \
  FUNC(glCompressedTexImage3D, glCompressedTexImage3DOES); \
  FUNC(glCompressedTexSubImage1D, glCompressedTexSubImage1D); \
  FUNC(glCompressedTexSubImage1D, glCompressedTexSubImage1DARB); \
  FUNC(glCompressedTexSubImage2D, glCompressedTexSubImage2D); \
  FUNC(glCompressedTexSubImage2D, glCompressedTexSubImage2DARB); \
  FUNC(glCompressedTexSubImage3D, glCompressedTexSubImage3D); \
  FUNC(glCompressedTexSubImage3D, glCompressedTexSubImage3DARB); \
  FUNC(glCompressedTexSubImage3D, glCompressedTexSubImage3DOES); \
  FUNC(glTexBufferRange, glTexBufferRange); \
  FUNC(glTexBufferRange, glTexBufferRangeEXT); \
  FUNC(glTexBufferRange, glTexBufferRangeOES); \
  FUNC(glTextureView, glTextureView); \
  FUNC(glTextureView, glTextureViewOES); \
  FUNC(glTextureView, glTextureViewEXT); \
  FUNC(glTexParameterIiv, glTexParameterIiv); \
  FUNC(glTexParameterIiv, glTexParameterIivEXT); \
  FUNC(glTexParameterIiv, glTexParameterIivOES); \
  FUNC(glTexParameterIuiv, glTexParameterIuiv); \
  FUNC(glTexParameterIuiv, glTexParameterIuivEXT); \
  FUNC(glTexParameterIuiv, glTexParameterIuivOES); \
  FUNC(glGenerateMipmap, glGenerateMipmap); \
  FUNC(glGenerateMipmap, glGenerateMipmapEXT); \
  FUNC(glCopyImageSubData, glCopyImageSubData); \
  FUNC(glCopyImageSubData, glCopyImageSubDataEXT); \
  FUNC(glCopyImageSubData, glCopyImageSubDataOES); \
  FUNC(glCopyTexSubImage3D, glCopyTexSubImage3D); \
  FUNC(glCopyTexSubImage3D, glCopyTexSubImage3DOES); \
  FUNC(glGetInternalformativ, glGetInternalformativ); \
  FUNC(glGetInternalformati64v, glGetInternalformati64v); \
  FUNC(glGetBufferParameteriv, glGetBufferParameteriv); \
  FUNC(glGetBufferParameteriv, glGetBufferParameterivARB); \
  FUNC(glGetBufferParameteri64v, glGetBufferParameteri64v); \
  FUNC(glGetBufferPointerv, glGetBufferPointerv); \
  FUNC(glGetBufferPointerv, glGetBufferPointervARB); \
  FUNC(glGetBufferPointerv, glGetBufferPointervOES); \
  FUNC(glGetFragDataIndex, glGetFragDataIndex); \
  FUNC(glGetFragDataLocation, glGetFragDataLocation); \
  FUNC(glGetFragDataLocation, glGetFragDataLocationEXT); \
  FUNC(glGetStringi, glGetStringi); \
  FUNC(glGetBooleani_v, glGetBooleani_v); \
  FUNC(glGetIntegeri_v, glGetIntegeri_v); \
  FUNC(glGetFloati_v, glGetFloati_v); \
  FUNC(glGetFloati_v, glGetFloati_vEXT); \
  FUNC(glGetFloati_v, glGetFloati_vOES); \
  FUNC(glGetFloati_v, glGetFloati_vNV); \
  FUNC(glGetDoublei_v, glGetDoublei_v); \
  FUNC(glGetDoublei_v, glGetDoublei_vEXT); \
  FUNC(glGetInteger64i_v, glGetInteger64i_v); \
  FUNC(glGetInteger64v, glGetInteger64v); \
  FUNC(glGetShaderiv, glGetShaderiv); \
  FUNC(glGetShaderInfoLog, glGetShaderInfoLog); \
  FUNC(glGetShaderPrecisionFormat, glGetShaderPrecisionFormat); \
  FUNC(glGetShaderSource, glGetShaderSource); \
  FUNC(glGetAttachedShaders, glGetAttachedShaders); \
  FUNC(glGetProgramiv, glGetProgramiv); \
  FUNC(glGetProgramInfoLog, glGetProgramInfoLog); \
  FUNC(glGetProgramInterfaceiv, glGetProgramInterfaceiv); \
  FUNC(glGetProgramResourceIndex, glGetProgramResourceIndex); \
  FUNC(glGetProgramResourceiv, glGetProgramResourceiv); \
  FUNC(glGetProgramResourceName, glGetProgramResourceName); \
  FUNC(glGetProgramPipelineiv, glGetProgramPipelineiv); \
  FUNC(glGetProgramPipelineiv, glGetProgramPipelineivEXT); \
  FUNC(glGetProgramPipelineInfoLog, glGetProgramPipelineInfoLog); \
  FUNC(glGetProgramPipelineInfoLog, glGetProgramPipelineInfoLogEXT); \
  FUNC(glGetProgramBinary, glGetProgramBinary); \
  FUNC(glGetProgramResourceLocation, glGetProgramResourceLocation); \
  FUNC(glGetProgramResourceLocationIndex, glGetProgramResourceLocationIndex); \
  FUNC(glGetProgramStageiv, glGetProgramStageiv); \
  FUNC(glGetGraphicsResetStatus, glGetGraphicsResetStatus); \
  FUNC(glGetGraphicsResetStatus, glGetGraphicsResetStatusARB); \
  FUNC(glGetGraphicsResetStatus, glGetGraphicsResetStatusEXT); \
  FUNC(glGetObjectLabel, glGetObjectLabel); \
  FUNC(glGetObjectLabel, glGetObjectLabelKHR); \
  FUNC(glGetObjectLabelEXT, glGetObjectLabelEXT); \
  FUNC(glGetObjectPtrLabel, glGetObjectPtrLabel); \
  FUNC(glGetObjectPtrLabel, glGetObjectPtrLabelKHR); \
  FUNC(glGetDebugMessageLog, glGetDebugMessageLog); \
  FUNC(glGetDebugMessageLog, glGetDebugMessageLogARB); \
  FUNC(glGetDebugMessageLog, glGetDebugMessageLogKHR); \
  FUNC(glGetFramebufferAttachmentParameteriv, glGetFramebufferAttachmentParameteriv); \
  FUNC(glGetFramebufferAttachmentParameteriv, glGetFramebufferAttachmentParameterivEXT); \
  FUNC(glGetFramebufferParameteriv, glGetFramebufferParameteriv); \
  FUNC(glGetRenderbufferParameteriv, glGetRenderbufferParameteriv); \
  FUNC(glGetRenderbufferParameteriv, glGetRenderbufferParameterivEXT); \
  FUNC(glGetMultisamplefv, glGetMultisamplefv); \
  FUNC(glGetQueryIndexediv, glGetQueryIndexediv); \
  FUNC(glGetQueryObjectui64v, glGetQueryObjectui64v); \
  FUNC(glGetQueryObjectui64v, glGetQueryObjectui64vEXT); \
  FUNC(glGetQueryObjectuiv, glGetQueryObjectuiv); \
  FUNC(glGetQueryObjectuiv, glGetQueryObjectuivARB); \
  FUNC(glGetQueryObjectuiv, glGetQueryObjectuivEXT); \
  FUNC(glGetQueryObjecti64v, glGetQueryObjecti64v); \
  FUNC(glGetQueryObjecti64v, glGetQueryObjecti64vEXT); \
  FUNC(glGetQueryObjectiv, glGetQueryObjectiv); \
  FUNC(glGetQueryObjectiv, glGetQueryObjectivARB); \
  FUNC(glGetQueryObjectiv, glGetQueryObjectivEXT); \
  FUNC(glGetQueryiv, glGetQueryiv); \
  FUNC(glGetQueryiv, glGetQueryivARB); \
  FUNC(glGetQueryiv, glGetQueryivEXT); \
  FUNC(glGetSynciv, glGetSynciv); \
  FUNC(glGetBufferSubData, glGetBufferSubData); \
  FUNC(glGetBufferSubData, glGetBufferSubDataARB); \
  FUNC(glGetVertexAttribiv, glGetVertexAttribiv); \
  FUNC(glGetVertexAttribPointerv, glGetVertexAttribPointerv); \
  FUNC(glGetCompressedTexImage, glGetCompressedTexImage); \
  FUNC(glGetCompressedTexImage, glGetCompressedTexImageARB); \
  FUNC(glGetnCompressedTexImage, glGetnCompressedTexImage); \
  FUNC(glGetnCompressedTexImage, glGetnCompressedTexImageARB); \
  FUNC(glGetnTexImage, glGetnTexImage); \
  FUNC(glGetnTexImage, glGetnTexImageARB); \
  FUNC(glGetTexParameterIiv, glGetTexParameterIiv); \
  FUNC(glGetTexParameterIiv, glGetTexParameterIivEXT); \
  FUNC(glGetTexParameterIiv, glGetTexParameterIivOES); \
  FUNC(glGetTexParameterIuiv, glGetTexParameterIuiv); \
  FUNC(glGetTexParameterIuiv, glGetTexParameterIuivEXT); \
  FUNC(glGetTexParameterIuiv, glGetTexParameterIuivOES); \
  FUNC(glClampColor, glClampColor); \
  FUNC(glClampColor, glClampColorARB); \
  FUNC(glReadnPixels, glReadnPixels); \
  FUNC(glReadnPixels, glReadnPixelsARB); \
  FUNC(glReadnPixels, glReadnPixelsEXT); \
  FUNC(glGetSamplerParameterIiv, glGetSamplerParameterIiv); \
  FUNC(glGetSamplerParameterIiv, glGetSamplerParameterIivEXT); \
  FUNC(glGetSamplerParameterIiv, glGetSamplerParameterIivOES); \
  FUNC(glGetSamplerParameterIuiv, glGetSamplerParameterIuiv); \
  FUNC(glGetSamplerParameterIuiv, glGetSamplerParameterIuivEXT); \
  FUNC(glGetSamplerParameterIuiv, glGetSamplerParameterIuivOES); \
  FUNC(glGetSamplerParameterfv, glGetSamplerParameterfv); \
  FUNC(glGetSamplerParameteriv, glGetSamplerParameteriv); \
  FUNC(glGetTransformFeedbackVarying, glGetTransformFeedbackVarying); \
  FUNC(glGetTransformFeedbackVarying, glGetTransformFeedbackVaryingEXT); \
  FUNC(glGetSubroutineIndex, glGetSubroutineIndex); \
  FUNC(glGetSubroutineUniformLocation, glGetSubroutineUniformLocation); \
  FUNC(glGetActiveAtomicCounterBufferiv, glGetActiveAtomicCounterBufferiv); \
  FUNC(glGetActiveSubroutineName, glGetActiveSubroutineName); \
  FUNC(glGetActiveSubroutineUniformName, glGetActiveSubroutineUniformName); \
  FUNC(glGetActiveSubroutineUniformiv, glGetActiveSubroutineUniformiv); \
  FUNC(glGetUniformLocation, glGetUniformLocation); \
  FUNC(glGetUniformIndices, glGetUniformIndices); \
  FUNC(glGetUniformSubroutineuiv, glGetUniformSubroutineuiv); \
  FUNC(glGetUniformBlockIndex, glGetUniformBlockIndex); \
  FUNC(glGetAttribLocation, glGetAttribLocation); \
  FUNC(glGetActiveUniform, glGetActiveUniform); \
  FUNC(glGetActiveUniformName, glGetActiveUniformName); \
  FUNC(glGetActiveUniformBlockName, glGetActiveUniformBlockName); \
  FUNC(glGetActiveUniformBlockiv, glGetActiveUniformBlockiv); \
  FUNC(glGetActiveUniformsiv, glGetActiveUniformsiv); \
  FUNC(glGetActiveAttrib, glGetActiveAttrib); \
  FUNC(glGetUniformfv, glGetUniformfv); \
  FUNC(glGetUniformiv, glGetUniformiv); \
  FUNC(glGetUniformuiv, glGetUniformuiv); \
  FUNC(glGetUniformuiv, glGetUniformuivEXT); \
  FUNC(glGetUniformdv, glGetUniformdv); \
  FUNC(glGetnUniformdv, glGetnUniformdv); \
  FUNC(glGetnUniformdv, glGetnUniformdvARB); \
  FUNC(glGetnUniformfv, glGetnUniformfv); \
  FUNC(glGetnUniformfv, glGetnUniformfvARB); \
  FUNC(glGetnUniformfv, glGetnUniformfvEXT); \
  FUNC(glGetnUniformiv, glGetnUniformiv); \
  FUNC(glGetnUniformiv, glGetnUniformivARB); \
  FUNC(glGetnUniformiv, glGetnUniformivEXT); \
  FUNC(glGetnUniformuiv, glGetnUniformuiv); \
  FUNC(glGetnUniformuiv, glGetnUniformuivARB); \
  FUNC(glGetVertexAttribIiv, glGetVertexAttribIiv); \
  FUNC(glGetVertexAttribIiv, glGetVertexAttribIivEXT); \
  FUNC(glGetVertexAttribIuiv, glGetVertexAttribIuiv); \
  FUNC(glGetVertexAttribIuiv, glGetVertexAttribIuivEXT); \
  FUNC(glGetVertexAttribLdv, glGetVertexAttribLdv); \
  FUNC(glGetVertexAttribLdv, glGetVertexAttribLdvEXT); \
  FUNC(glGetVertexAttribdv, glGetVertexAttribdv); \
  FUNC(glGetVertexAttribfv, glGetVertexAttribfv); \
  FUNC(glCheckFramebufferStatus, glCheckFramebufferStatus); \
  FUNC(glCheckFramebufferStatus, glCheckFramebufferStatusEXT); \
  FUNC(glBlendColor, glBlendColor); \
  FUNC(glBlendColor, glBlendColorEXT); \
  FUNC(glBlendFunci, glBlendFunci); \
  FUNC(glBlendFunci, glBlendFunciARB); \
  FUNC(glBlendFunci, glBlendFunciEXT); \
  FUNC(glBlendFunci, glBlendFunciOES); \
  FUNC(glBlendFuncSeparate, glBlendFuncSeparate); \
  FUNC(glBlendFuncSeparate, glBlendFuncSeparateARB); \
  FUNC(glBlendFuncSeparatei, glBlendFuncSeparatei); \
  FUNC(glBlendFuncSeparatei, glBlendFuncSeparateiARB); \
  FUNC(glBlendFuncSeparatei, glBlendFuncSeparateiEXT); \
  FUNC(glBlendFuncSeparatei, glBlendFuncSeparateiOES); \
  FUNC(glBlendEquation, glBlendEquation); \
  FUNC(glBlendEquation, glBlendEquationEXT); \
  FUNC(glBlendEquation, glBlendEquationARB); \
  FUNC(glBlendEquationi, glBlendEquationi); \
  FUNC(glBlendEquationi, glBlendEquationiARB); \
  FUNC(glBlendEquationi, glBlendEquationiEXT); \
  FUNC(glBlendEquationi, glBlendEquationiOES); \
  FUNC(glBlendEquationSeparate, glBlendEquationSeparate); \
  FUNC(glBlendEquationSeparate, glBlendEquationSeparateARB); \
  FUNC(glBlendEquationSeparate, glBlendEquationSeparateEXT); \
  FUNC(glBlendEquationSeparatei, glBlendEquationSeparatei); \
  FUNC(glBlendEquationSeparatei, glBlendEquationSeparateiARB); \
  FUNC(glBlendEquationSeparatei, glBlendEquationSeparateiEXT); \
  FUNC(glBlendEquationSeparatei, glBlendEquationSeparateiOES); \
  FUNC(glBlendBarrierKHR, glBlendBarrierKHR); \
  FUNC(glStencilFuncSeparate, glStencilFuncSeparate); \
  FUNC(glStencilMaskSeparate, glStencilMaskSeparate); \
  FUNC(glStencilOpSeparate, glStencilOpSeparate); \
  FUNC(glColorMaski, glColorMaski); \
  FUNC(glColorMaski, glColorMaskiEXT); \
  FUNC(glColorMaski, glColorMaskIndexedEXT); \
  FUNC(glColorMaski, glColorMaskiOES); \
  FUNC(glSampleMaski, glSampleMaski); \
  FUNC(glSampleCoverage, glSampleCoverage); \
  FUNC(glSampleCoverage, glSampleCoverageARB); \
  FUNC(glMinSampleShading, glMinSampleShading); \
  FUNC(glMinSampleShading, glMinSampleShadingARB); \
  FUNC(glMinSampleShading, glMinSampleShadingOES); \
  FUNC(glDepthRangef, glDepthRangef); \
  FUNC(glDepthRangeIndexed, glDepthRangeIndexed); \
  FUNC(glDepthRangeArrayv, glDepthRangeArrayv); \
  FUNC(glClipControl, glClipControl); \
  FUNC(glProvokingVertex, glProvokingVertex); \
  FUNC(glProvokingVertex, glProvokingVertexEXT); \
  FUNC(glPrimitiveRestartIndex, glPrimitiveRestartIndex); \
  FUNC(glCreateShader, glCreateShader); \
  FUNC(glDeleteShader, glDeleteShader); \
  FUNC(glShaderSource, glShaderSource); \
  FUNC(glCompileShader, glCompileShader); \
  FUNC(glCreateShaderProgramv, glCreateShaderProgramv); \
  FUNC(glCreateShaderProgramv, glCreateShaderProgramvEXT); \
  FUNC(glCreateProgram, glCreateProgram); \
  FUNC(glDeleteProgram, glDeleteProgram); \
  FUNC(glAttachShader, glAttachShader); \
  FUNC(glDetachShader, glDetachShader); \
  FUNC(glReleaseShaderCompiler, glReleaseShaderCompiler); \
  FUNC(glLinkProgram, glLinkProgram); \
  FUNC(glProgramParameteri, glProgramParameteri); \
  FUNC(glProgramParameteri, glProgramParameteriARB); \
  FUNC(glProgramParameteri, glProgramParameteriEXT); \
  FUNC(glUseProgram, glUseProgram); \
  FUNC(glShaderBinary, glShaderBinary); \
  FUNC(glProgramBinary, glProgramBinary); \
  FUNC(glUseProgramStages, glUseProgramStages); \
  FUNC(glUseProgramStages, glUseProgramStagesEXT); \
  FUNC(glValidateProgram, glValidateProgram); \
  FUNC(glGenProgramPipelines, glGenProgramPipelines); \
  FUNC(glGenProgramPipelines, glGenProgramPipelinesEXT); \
  FUNC(glBindProgramPipeline, glBindProgramPipeline); \
  FUNC(glBindProgramPipeline, glBindProgramPipelineEXT); \
  FUNC(glActiveShaderProgram, glActiveShaderProgram); \
  FUNC(glActiveShaderProgram, glActiveShaderProgramEXT); \
  FUNC(glDeleteProgramPipelines, glDeleteProgramPipelines); \
  FUNC(glDeleteProgramPipelines, glDeleteProgramPipelinesEXT); \
  FUNC(glValidateProgramPipeline, glValidateProgramPipeline); \
  FUNC(glValidateProgramPipeline, glValidateProgramPipelineEXT); \
  FUNC(glDebugMessageCallback, glDebugMessageCallback); \
  FUNC(glDebugMessageCallback, glDebugMessageCallbackARB); \
  FUNC(glDebugMessageCallback, glDebugMessageCallbackKHR); \
  FUNC(glDebugMessageControl, glDebugMessageControl); \
  FUNC(glDebugMessageControl, glDebugMessageControlARB); \
  FUNC(glDebugMessageControl, glDebugMessageControlKHR); \
  FUNC(glDebugMessageInsert, glDebugMessageInsert); \
  FUNC(glDebugMessageInsert, glDebugMessageInsertARB); \
  FUNC(glDebugMessageInsert, glDebugMessageInsertKHR); \
  FUNC(glPushDebugGroup, glPushDebugGroup); \
  FUNC(glPushDebugGroup, glPushDebugGroupKHR); \
  FUNC(glPopDebugGroup, glPopDebugGroup); \
  FUNC(glPopDebugGroup, glPopDebugGroupKHR); \
  FUNC(glObjectLabel, glObjectLabel); \
  FUNC(glObjectLabel, glObjectLabelKHR); \
  FUNC(glLabelObjectEXT, glLabelObjectEXT); \
  FUNC(glObjectPtrLabel, glObjectPtrLabel); \
  FUNC(glObjectPtrLabel, glObjectPtrLabelKHR); \
  FUNC(glEnablei, glEnablei); \
  FUNC(glEnablei, glEnableiEXT); \
  FUNC(glEnablei, glEnableIndexedEXT); \
  FUNC(glEnablei, glEnableiOES); \
  FUNC(glEnablei, glEnableiNV); \
  FUNC(glDisablei, glDisablei); \
  FUNC(glDisablei, glDisableiEXT); \
  FUNC(glDisablei, glDisableIndexedEXT); \
  FUNC(glDisablei, glDisableiOES); \
  FUNC(glDisablei, glDisableiNV); \
  FUNC(glIsEnabledi, glIsEnabledi); \
  FUNC(glIsEnabledi, glIsEnablediEXT); \
  FUNC(glIsEnabledi, glIsEnabledIndexedEXT); \
  FUNC(glIsEnabledi, glIsEnablediOES); \
  FUNC(glIsEnabledi, glIsEnablediNV); \
  FUNC(glIsBuffer, glIsBuffer); \
  FUNC(glIsBuffer, glIsBufferARB); \
  FUNC(glIsFramebuffer, glIsFramebuffer); \
  FUNC(glIsFramebuffer, glIsFramebufferEXT); \
  FUNC(glIsProgram, glIsProgram); \
  FUNC(glIsProgramPipeline, glIsProgramPipeline); \
  FUNC(glIsProgramPipeline, glIsProgramPipelineEXT); \
  FUNC(glIsQuery, glIsQuery); \
  FUNC(glIsQuery, glIsQueryARB); \
  FUNC(glIsQuery, glIsQueryEXT); \
  FUNC(glIsRenderbuffer, glIsRenderbuffer); \
  FUNC(glIsRenderbuffer, glIsRenderbufferEXT); \
  FUNC(glIsSampler, glIsSampler); \
  FUNC(glIsShader, glIsShader); \
  FUNC(glIsSync, glIsSync); \
  FUNC(glIsTransformFeedback, glIsTransformFeedback); \
  FUNC(glIsVertexArray, glIsVertexArray); \
  FUNC(glIsVertexArray, glIsVertexArrayOES); \
  FUNC(glGenBuffers, glGenBuffers); \
  FUNC(glGenBuffers, glGenBuffersARB); \
  FUNC(glBindBuffer, glBindBuffer); \
  FUNC(glBindBuffer, glBindBufferARB); \
  FUNC(glDrawBuffers, glDrawBuffers); \
  FUNC(glDrawBuffers, glDrawBuffersARB); \
  FUNC(glDrawBuffers, glDrawBuffersEXT); \
  FUNC(glGenFramebuffers, glGenFramebuffers); \
  FUNC(glGenFramebuffers, glGenFramebuffersEXT); \
  FUNC(glBindFramebuffer, glBindFramebuffer); \
  FUNC(glBindFramebuffer, glBindFramebufferEXT); \
  FUNC(glFramebufferTexture, glFramebufferTexture); \
  FUNC(glFramebufferTexture, glFramebufferTextureARB); \
  FUNC(glFramebufferTexture, glFramebufferTextureOES); \
  FUNC(glFramebufferTexture, glFramebufferTextureEXT); \
  FUNC(glFramebufferTexture1D, glFramebufferTexture1D); \
  FUNC(glFramebufferTexture1D, glFramebufferTexture1DEXT); \
  FUNC(glFramebufferTexture2D, glFramebufferTexture2D); \
  FUNC(glFramebufferTexture2D, glFramebufferTexture2DEXT); \
  FUNC(glFramebufferTexture3D, glFramebufferTexture3D); \
  FUNC(glFramebufferTexture3D, glFramebufferTexture3DEXT); \
  FUNC(glFramebufferTexture3D, glFramebufferTexture3DOES); \
  FUNC(glFramebufferRenderbuffer, glFramebufferRenderbuffer); \
  FUNC(glFramebufferRenderbuffer, glFramebufferRenderbufferEXT); \
  FUNC(glFramebufferTextureLayer, glFramebufferTextureLayer); \
  FUNC(glFramebufferTextureLayer, glFramebufferTextureLayerARB); \
  FUNC(glFramebufferTextureLayer, glFramebufferTextureLayerEXT); \
  FUNC(glFramebufferParameteri, glFramebufferParameteri); \
  FUNC(glDeleteFramebuffers, glDeleteFramebuffers); \
  FUNC(glDeleteFramebuffers, glDeleteFramebuffersEXT); \
  FUNC(glGenRenderbuffers, glGenRenderbuffers); \
  FUNC(glGenRenderbuffers, glGenRenderbuffersEXT); \
  FUNC(glRenderbufferStorage, glRenderbufferStorage); \
  FUNC(glRenderbufferStorage, glRenderbufferStorageEXT); \
  FUNC(glRenderbufferStorageMultisample, glRenderbufferStorageMultisample); \
  FUNC(glDeleteRenderbuffers, glDeleteRenderbuffers); \
  FUNC(glDeleteRenderbuffers, glDeleteRenderbuffersEXT); \
  FUNC(glBindRenderbuffer, glBindRenderbuffer); \
  FUNC(glBindRenderbuffer, glBindRenderbufferEXT); \
  FUNC(glFenceSync, glFenceSync); \
  FUNC(glClientWaitSync, glClientWaitSync); \
  FUNC(glWaitSync, glWaitSync); \
  FUNC(glDeleteSync, glDeleteSync); \
  FUNC(glGenQueries, glGenQueries); \
  FUNC(glGenQueries, glGenQueriesARB); \
  FUNC(glGenQueries, glGenQueriesEXT); \
  FUNC(glBeginQuery, glBeginQuery); \
  FUNC(glBeginQuery, glBeginQueryARB); \
  FUNC(glBeginQuery, glBeginQueryEXT); \
  FUNC(glBeginQueryIndexed, glBeginQueryIndexed); \
  FUNC(glEndQuery, glEndQuery); \
  FUNC(glEndQuery, glEndQueryARB); \
  FUNC(glEndQuery, glEndQueryEXT); \
  FUNC(glEndQueryIndexed, glEndQueryIndexed); \
  FUNC(glBeginConditionalRender, glBeginConditionalRender); \
  FUNC(glEndConditionalRender, glEndConditionalRender); \
  FUNC(glQueryCounter, glQueryCounter); \
  FUNC(glQueryCounter, glQueryCounterEXT); \
  FUNC(glDeleteQueries, glDeleteQueries); \
  FUNC(glDeleteQueries, glDeleteQueriesARB); \
  FUNC(glDeleteQueries, glDeleteQueriesEXT); \
  FUNC(glBufferData, glBufferData); \
  FUNC(glBufferData, glBufferDataARB); \
  FUNC(glBufferStorage, glBufferStorage); \
  FUNC(glBufferStorage, glBufferStorageEXT); \
  FUNC(glBufferSubData, glBufferSubData); \
  FUNC(glBufferSubData, glBufferSubDataARB); \
  FUNC(glCopyBufferSubData, glCopyBufferSubData); \
  FUNC(glBindBufferBase, glBindBufferBase); \
  FUNC(glBindBufferBase, glBindBufferBaseEXT); \
  FUNC(glBindBufferRange, glBindBufferRange); \
  FUNC(glBindBufferRange, glBindBufferRangeEXT); \
  FUNC(glBindBuffersBase, glBindBuffersBase); \
  FUNC(glBindBuffersRange, glBindBuffersRange); \
  FUNC(glMapBuffer, glMapBuffer); \
  FUNC(glMapBuffer, glMapBufferARB); \
  FUNC(glMapBuffer, glMapBufferOES); \
  FUNC(glMapBufferRange, glMapBufferRange); \
  FUNC(glMapBufferRange, glMapBufferRangeEXT); \
  FUNC(glFlushMappedBufferRange, glFlushMappedBufferRange); \
  FUNC(glFlushMappedBufferRange, glFlushMappedBufferRangeEXT); \
  FUNC(glUnmapBuffer, glUnmapBuffer); \
  FUNC(glUnmapBuffer, glUnmapBufferARB); \
  FUNC(glUnmapBuffer, glUnmapBufferOES); \
  FUNC(glTransformFeedbackVaryings, glTransformFeedbackVaryings); \
  FUNC(glTransformFeedbackVaryings, glTransformFeedbackVaryingsEXT); \
  FUNC(glGenTransformFeedbacks, glGenTransformFeedbacks); \
  FUNC(glDeleteTransformFeedbacks, glDeleteTransformFeedbacks); \
  FUNC(glBindTransformFeedback, glBindTransformFeedback); \
  FUNC(glBeginTransformFeedback, glBeginTransformFeedback); \
  FUNC(glBeginTransformFeedback, glBeginTransformFeedbackEXT); \
  FUNC(glPauseTransformFeedback, glPauseTransformFeedback); \
  FUNC(glResumeTransformFeedback, glResumeTransformFeedback); \
  FUNC(glEndTransformFeedback, glEndTransformFeedback); \
  FUNC(glEndTransformFeedback, glEndTransformFeedbackEXT); \
  FUNC(glDrawTransformFeedback, glDrawTransformFeedback); \
  FUNC(glDrawTransformFeedbackInstanced, glDrawTransformFeedbackInstanced); \
  FUNC(glDrawTransformFeedbackStream, glDrawTransformFeedbackStream); \
  FUNC(glDrawTransformFeedbackStreamInstanced, glDrawTransformFeedbackStreamInstanced); \
  FUNC(glDeleteBuffers, glDeleteBuffers); \
  FUNC(glDeleteBuffers, glDeleteBuffersARB); \
  FUNC(glGenVertexArrays, glGenVertexArrays); \
  FUNC(glGenVertexArrays, glGenVertexArraysOES); \
  FUNC(glBindVertexArray, glBindVertexArray); \
  FUNC(glBindVertexArray, glBindVertexArrayOES); \
  FUNC(glDeleteVertexArrays, glDeleteVertexArrays); \
  FUNC(glDeleteVertexArrays, glDeleteVertexArraysOES); \
  FUNC(glVertexAttrib1d, glVertexAttrib1d); \
  FUNC(glVertexAttrib1d, glVertexAttrib1dARB); \
  FUNC(glVertexAttrib1dv, glVertexAttrib1dv); \
  FUNC(glVertexAttrib1dv, glVertexAttrib1dvARB); \
  FUNC(glVertexAttrib1f, glVertexAttrib1f); \
  FUNC(glVertexAttrib1f, glVertexAttrib1fARB); \
  FUNC(glVertexAttrib1fv, glVertexAttrib1fv); \
  FUNC(glVertexAttrib1fv, glVertexAttrib1fvARB); \
  FUNC(glVertexAttrib1s, glVertexAttrib1s); \
  FUNC(glVertexAttrib1s, glVertexAttrib1sARB); \
  FUNC(glVertexAttrib1sv, glVertexAttrib1sv); \
  FUNC(glVertexAttrib1sv, glVertexAttrib1svARB); \
  FUNC(glVertexAttrib2d, glVertexAttrib2d); \
  FUNC(glVertexAttrib2d, glVertexAttrib2dARB); \
  FUNC(glVertexAttrib2dv, glVertexAttrib2dv); \
  FUNC(glVertexAttrib2dv, glVertexAttrib2dvARB); \
  FUNC(glVertexAttrib2f, glVertexAttrib2f); \
  FUNC(glVertexAttrib2f, glVertexAttrib2fARB); \
  FUNC(glVertexAttrib2fv, glVertexAttrib2fv); \
  FUNC(glVertexAttrib2fv, glVertexAttrib2fvARB); \
  FUNC(glVertexAttrib2s, glVertexAttrib2s); \
  FUNC(glVertexAttrib2s, glVertexAttrib2sARB); \
  FUNC(glVertexAttrib2sv, glVertexAttrib2sv); \
  FUNC(glVertexAttrib2sv, glVertexAttrib2svARB); \
  FUNC(glVertexAttrib3d, glVertexAttrib3d); \
  FUNC(glVertexAttrib3d, glVertexAttrib3dARB); \
  FUNC(glVertexAttrib3dv, glVertexAttrib3dv); \
  FUNC(glVertexAttrib3dv, glVertexAttrib3dvARB); \
  FUNC(glVertexAttrib3f, glVertexAttrib3f); \
  FUNC(glVertexAttrib3f, glVertexAttrib3fARB); \
  FUNC(glVertexAttrib3fv, glVertexAttrib3fv); \
  FUNC(glVertexAttrib3fv, glVertexAttrib3fvARB); \
  FUNC(glVertexAttrib3s, glVertexAttrib3s); \
  FUNC(glVertexAttrib3s, glVertexAttrib3sARB); \
  FUNC(glVertexAttrib3sv, glVertexAttrib3sv); \
  FUNC(glVertexAttrib3sv, glVertexAttrib3svARB); \
  FUNC(glVertexAttrib4Nbv, glVertexAttrib4Nbv); \
  FUNC(glVertexAttrib4Nbv, glVertexAttrib4NbvARB); \
  FUNC(glVertexAttrib4Niv, glVertexAttrib4Niv); \
  FUNC(glVertexAttrib4Niv, glVertexAttrib4NivARB); \
  FUNC(glVertexAttrib4Nsv, glVertexAttrib4Nsv); \
  FUNC(glVertexAttrib4Nsv, glVertexAttrib4NsvARB); \
  FUNC(glVertexAttrib4Nub, glVertexAttrib4Nub); \
  FUNC(glVertexAttrib4Nubv, glVertexAttrib4Nubv); \
  FUNC(glVertexAttrib4Nubv, glVertexAttrib4NubvARB); \
  FUNC(glVertexAttrib4Nuiv, glVertexAttrib4Nuiv); \
  FUNC(glVertexAttrib4Nuiv, glVertexAttrib4NuivARB); \
  FUNC(glVertexAttrib4Nusv, glVertexAttrib4Nusv); \
  FUNC(glVertexAttrib4Nusv, glVertexAttrib4NusvARB); \
  FUNC(glVertexAttrib4bv, glVertexAttrib4bv); \
  FUNC(glVertexAttrib4bv, glVertexAttrib4bvARB); \
  FUNC(glVertexAttrib4d, glVertexAttrib4d); \
  FUNC(glVertexAttrib4d, glVertexAttrib4dARB); \
  FUNC(glVertexAttrib4dv, glVertexAttrib4dv); \
  FUNC(glVertexAttrib4dv, glVertexAttrib4dvARB); \
  FUNC(glVertexAttrib4f, glVertexAttrib4f); \
  FUNC(glVertexAttrib4f, glVertexAttrib4fARB); \
  FUNC(glVertexAttrib4fv, glVertexAttrib4fv); \
  FUNC(glVertexAttrib4fv, glVertexAttrib4fvARB); \
  FUNC(glVertexAttrib4iv, glVertexAttrib4iv); \
  FUNC(glVertexAttrib4iv, glVertexAttrib4ivARB); \
  FUNC(glVertexAttrib4s, glVertexAttrib4s); \
  FUNC(glVertexAttrib4s, glVertexAttrib4sARB); \
  FUNC(glVertexAttrib4sv, glVertexAttrib4sv); \
  FUNC(glVertexAttrib4sv, glVertexAttrib4svARB); \
  FUNC(glVertexAttrib4ubv, glVertexAttrib4ubv); \
  FUNC(glVertexAttrib4ubv, glVertexAttrib4ubvARB); \
  FUNC(glVertexAttrib4uiv, glVertexAttrib4uiv); \
  FUNC(glVertexAttrib4uiv, glVertexAttrib4uivARB); \
  FUNC(glVertexAttrib4usv, glVertexAttrib4usv); \
  FUNC(glVertexAttrib4usv, glVertexAttrib4usvARB); \
  FUNC(glVertexAttribI1i, glVertexAttribI1i); \
  FUNC(glVertexAttribI1i, glVertexAttribI1iEXT); \
  FUNC(glVertexAttribI1iv, glVertexAttribI1iv); \
  FUNC(glVertexAttribI1iv, glVertexAttribI1ivEXT); \
  FUNC(glVertexAttribI1ui, glVertexAttribI1ui); \
  FUNC(glVertexAttribI1ui, glVertexAttribI1uiEXT); \
  FUNC(glVertexAttribI1uiv, glVertexAttribI1uiv); \
  FUNC(glVertexAttribI1uiv, glVertexAttribI1uivEXT); \
  FUNC(glVertexAttribI2i, glVertexAttribI2i); \
  FUNC(glVertexAttribI2i, glVertexAttribI2iEXT); \
  FUNC(glVertexAttribI2iv, glVertexAttribI2iv); \
  FUNC(glVertexAttribI2iv, glVertexAttribI2ivEXT); \
  FUNC(glVertexAttribI2ui, glVertexAttribI2ui); \
  FUNC(glVertexAttribI2ui, glVertexAttribI2uiEXT); \
  FUNC(glVertexAttribI2uiv, glVertexAttribI2uiv); \
  FUNC(glVertexAttribI2uiv, glVertexAttribI2uivEXT); \
  FUNC(glVertexAttribI3i, glVertexAttribI3i); \
  FUNC(glVertexAttribI3i, glVertexAttribI3iEXT); \
  FUNC(glVertexAttribI3iv, glVertexAttribI3iv); \
  FUNC(glVertexAttribI3iv, glVertexAttribI3ivEXT); \
  FUNC(glVertexAttribI3ui, glVertexAttribI3ui); \
  FUNC(glVertexAttribI3ui, glVertexAttribI3uiEXT); \
  FUNC(glVertexAttribI3uiv, glVertexAttribI3uiv); \
  FUNC(glVertexAttribI3uiv, glVertexAttribI3uivEXT); \
  FUNC(glVertexAttribI4bv, glVertexAttribI4bv); \
  FUNC(glVertexAttribI4bv, glVertexAttribI4bvEXT); \
  FUNC(glVertexAttribI4i, glVertexAttribI4i); \
  FUNC(glVertexAttribI4i, glVertexAttribI4iEXT); \
  FUNC(glVertexAttribI4iv, glVertexAttribI4iv); \
  FUNC(glVertexAttribI4iv, glVertexAttribI4ivEXT); \
  FUNC(glVertexAttribI4sv, glVertexAttribI4sv); \
  FUNC(glVertexAttribI4sv, glVertexAttribI4svEXT); \
  FUNC(glVertexAttribI4ubv, glVertexAttribI4ubv); \
  FUNC(glVertexAttribI4ubv, glVertexAttribI4ubvEXT); \
  FUNC(glVertexAttribI4ui, glVertexAttribI4ui); \
  FUNC(glVertexAttribI4ui, glVertexAttribI4uiEXT); \
  FUNC(glVertexAttribI4uiv, glVertexAttribI4uiv); \
  FUNC(glVertexAttribI4uiv, glVertexAttribI4uivEXT); \
  FUNC(glVertexAttribI4usv, glVertexAttribI4usv); \
  FUNC(glVertexAttribI4usv, glVertexAttribI4usvEXT); \
  FUNC(glVertexAttribL1d, glVertexAttribL1d); \
  FUNC(glVertexAttribL1d, glVertexAttribL1dEXT); \
  FUNC(glVertexAttribL1dv, glVertexAttribL1dv); \
  FUNC(glVertexAttribL1dv, glVertexAttribL1dvEXT); \
  FUNC(glVertexAttribL2d, glVertexAttribL2d); \
  FUNC(glVertexAttribL2d, glVertexAttribL2dEXT); \
  FUNC(glVertexAttribL2dv, glVertexAttribL2dv); \
  FUNC(glVertexAttribL2dv, glVertexAttribL2dvEXT); \
  FUNC(glVertexAttribL3d, glVertexAttribL3d); \
  FUNC(glVertexAttribL3d, glVertexAttribL3dEXT); \
  FUNC(glVertexAttribL3dv, glVertexAttribL3dv); \
  FUNC(glVertexAttribL3dv, glVertexAttribL3dvEXT); \
  FUNC(glVertexAttribL4d, glVertexAttribL4d); \
  FUNC(glVertexAttribL4d, glVertexAttribL4dEXT); \
  FUNC(glVertexAttribL4dv, glVertexAttribL4dv); \
  FUNC(glVertexAttribL4dv, glVertexAttribL4dvEXT); \
  FUNC(glVertexAttribP1ui, glVertexAttribP1ui); \
  FUNC(glVertexAttribP1uiv, glVertexAttribP1uiv); \
  FUNC(glVertexAttribP2ui, glVertexAttribP2ui); \
  FUNC(glVertexAttribP2uiv, glVertexAttribP2uiv); \
  FUNC(glVertexAttribP3ui, glVertexAttribP3ui); \
  FUNC(glVertexAttribP3uiv, glVertexAttribP3uiv); \
  FUNC(glVertexAttribP4ui, glVertexAttribP4ui); \
  FUNC(glVertexAttribP4uiv, glVertexAttribP4uiv); \
  FUNC(glVertexAttribPointer, glVertexAttribPointer); \
  FUNC(glVertexAttribPointer, glVertexAttribPointerARB); \
  FUNC(glVertexAttribIPointer, glVertexAttribIPointer); \
  FUNC(glVertexAttribIPointer, glVertexAttribIPointerEXT); \
  FUNC(glVertexAttribLPointer, glVertexAttribLPointer); \
  FUNC(glVertexAttribLPointer, glVertexAttribLPointerEXT); \
  FUNC(glVertexAttribBinding, glVertexAttribBinding); \
  FUNC(glVertexAttribFormat, glVertexAttribFormat); \
  FUNC(glVertexAttribIFormat, glVertexAttribIFormat); \
  FUNC(glVertexAttribLFormat, glVertexAttribLFormat); \
  FUNC(glVertexAttribDivisor, glVertexAttribDivisor); \
  FUNC(glVertexAttribDivisor, glVertexAttribDivisorARB); \
  FUNC(glBindAttribLocation, glBindAttribLocation); \
  FUNC(glBindFragDataLocation, glBindFragDataLocation); \
  FUNC(glBindFragDataLocation, glBindFragDataLocationEXT); \
  FUNC(glBindFragDataLocationIndexed, glBindFragDataLocationIndexed); \
  FUNC(glEnableVertexAttribArray, glEnableVertexAttribArray); \
  FUNC(glEnableVertexAttribArray, glEnableVertexAttribArrayARB); \
  FUNC(glDisableVertexAttribArray, glDisableVertexAttribArray); \
  FUNC(glDisableVertexAttribArray, glDisableVertexAttribArrayARB); \
  FUNC(glBindVertexBuffer, glBindVertexBuffer); \
  FUNC(glBindVertexBuffers, glBindVertexBuffers); \
  FUNC(glVertexBindingDivisor, glVertexBindingDivisor); \
  FUNC(glBindImageTexture, glBindImageTexture); \
  FUNC(glBindImageTexture, glBindImageTextureEXT); \
  FUNC(glBindImageTextures, glBindImageTextures); \
  FUNC(glGenSamplers, glGenSamplers); \
  FUNC(glBindSampler, glBindSampler); \
  FUNC(glBindSamplers, glBindSamplers); \
  FUNC(glBindTextures, glBindTextures); \
  FUNC(glDeleteSamplers, glDeleteSamplers); \
  FUNC(glSamplerParameteri, glSamplerParameteri); \
  FUNC(glSamplerParameterf, glSamplerParameterf); \
  FUNC(glSamplerParameteriv, glSamplerParameteriv); \
  FUNC(glSamplerParameterfv, glSamplerParameterfv); \
  FUNC(glSamplerParameterIiv, glSamplerParameterIiv); \
  FUNC(glSamplerParameterIiv, glSamplerParameterIivEXT); \
  FUNC(glSamplerParameterIiv, glSamplerParameterIivOES); \
  FUNC(glSamplerParameterIuiv, glSamplerParameterIuiv); \
  FUNC(glSamplerParameterIuiv, glSamplerParameterIuivEXT); \
  FUNC(glSamplerParameterIuiv, glSamplerParameterIuivOES); \
  FUNC(glPatchParameteri, glPatchParameteri); \
  FUNC(glPatchParameteri, glPatchParameteriEXT); \
  FUNC(glPatchParameteri, glPatchParameteriOES); \
  FUNC(glPatchParameterfv, glPatchParameterfv); \
  FUNC(glPointParameterf, glPointParameterf); \
  FUNC(glPointParameterf, glPointParameterfARB); \
  FUNC(glPointParameterf, glPointParameterfEXT); \
  FUNC(glPointParameterfv, glPointParameterfv); \
  FUNC(glPointParameterfv, glPointParameterfvARB); \
  FUNC(glPointParameterfv, glPointParameterfvEXT); \
  FUNC(glPointParameteri, glPointParameteri); \
  FUNC(glPointParameteriv, glPointParameteriv); \
  FUNC(glDispatchCompute, glDispatchCompute); \
  FUNC(glDispatchComputeIndirect, glDispatchComputeIndirect); \
  FUNC(glMemoryBarrier, glMemoryBarrier); \
  FUNC(glMemoryBarrier, glMemoryBarrierEXT); \
  FUNC(glMemoryBarrierByRegion, glMemoryBarrierByRegion); \
  FUNC(glTextureBarrier, glTextureBarrier); \
  FUNC(glClearDepthf, glClearDepthf); \
  FUNC(glClearBufferfv, glClearBufferfv); \
  FUNC(glClearBufferiv, glClearBufferiv); \
  FUNC(glClearBufferuiv, glClearBufferuiv); \
  FUNC(glClearBufferfi, glClearBufferfi); \
  FUNC(glClearBufferData, glClearBufferData); \
  FUNC(glClearBufferSubData, glClearBufferSubData); \
  FUNC(glClearTexImage, glClearTexImage); \
  FUNC(glClearTexSubImage, glClearTexSubImage); \
  FUNC(glInvalidateBufferData, glInvalidateBufferData); \
  FUNC(glInvalidateBufferSubData, glInvalidateBufferSubData); \
  FUNC(glInvalidateFramebuffer, glInvalidateFramebuffer); \
  FUNC(glInvalidateSubFramebuffer, glInvalidateSubFramebuffer); \
  FUNC(glInvalidateTexImage, glInvalidateTexImage); \
  FUNC(glInvalidateTexSubImage, glInvalidateTexSubImage); \
  FUNC(glScissorArrayv, glScissorArrayv); \
  FUNC(glScissorArrayv, glScissorArrayvOES); \
  FUNC(glScissorArrayv, glScissorArrayvNV); \
  FUNC(glScissorIndexed, glScissorIndexed); \
  FUNC(glScissorIndexed, glScissorIndexedOES); \
  FUNC(glScissorIndexed, glScissorIndexedNV); \
  FUNC(glScissorIndexedv, glScissorIndexedv); \
  FUNC(glScissorIndexedv, glScissorIndexedvOES); \
  FUNC(glScissorIndexedv, glScissorIndexedvNV); \
  FUNC(glViewportIndexedf, glViewportIndexedf); \
  FUNC(glViewportIndexedf, glViewportIndexedfOES); \
  FUNC(glViewportIndexedf, glViewportIndexedfNV); \
  FUNC(glViewportIndexedfv, glViewportIndexedfv); \
  FUNC(glViewportIndexedfv, glViewportIndexedfvOES); \
  FUNC(glViewportIndexedfv, glViewportIndexedfvNV); \
  FUNC(glViewportArrayv, glViewportArrayv); \
  FUNC(glViewportArrayv, glViewportArrayvOES); \
  FUNC(glViewportArrayv, glViewportArrayvNV); \
  FUNC(glUniformBlockBinding, glUniformBlockBinding); \
  FUNC(glShaderStorageBlockBinding, glShaderStorageBlockBinding); \
  FUNC(glUniformSubroutinesuiv, glUniformSubroutinesuiv); \
  FUNC(glUniform1f, glUniform1f); \
  FUNC(glUniform1f, glUniform1fARB); \
  FUNC(glUniform1i, glUniform1i); \
  FUNC(glUniform1i, glUniform1iARB); \
  FUNC(glUniform1ui, glUniform1ui); \
  FUNC(glUniform1ui, glUniform1uiEXT); \
  FUNC(glUniform1d, glUniform1d); \
  FUNC(glUniform2f, glUniform2f); \
  FUNC(glUniform2f, glUniform2fARB); \
  FUNC(glUniform2i, glUniform2i); \
  FUNC(glUniform2i, glUniform2iARB); \
  FUNC(glUniform2ui, glUniform2ui); \
  FUNC(glUniform2ui, glUniform2uiEXT); \
  FUNC(glUniform2d, glUniform2d); \
  FUNC(glUniform3f, glUniform3f); \
  FUNC(glUniform3f, glUniform3fARB); \
  FUNC(glUniform3i, glUniform3i); \
  FUNC(glUniform3i, glUniform3iARB); \
  FUNC(glUniform3ui, glUniform3ui); \
  FUNC(glUniform3ui, glUniform3uiEXT); \
  FUNC(glUniform3d, glUniform3d); \
  FUNC(glUniform4f, glUniform4f); \
  FUNC(glUniform4f, glUniform4fARB); \
  FUNC(glUniform4i, glUniform4i); \
  FUNC(glUniform4i, glUniform4iARB); \
  FUNC(glUniform4ui, glUniform4ui); \
  FUNC(glUniform4ui, glUniform4uiEXT); \
  FUNC(glUniform4d, glUniform4d); \
  FUNC(glUniform1fv, glUniform1fv); \
  FUNC(glUniform1fv, glUniform1fvARB); \
  FUNC(glUniform1iv, glUniform1iv); \
  FUNC(glUniform1iv, glUniform1ivARB); \
  FUNC(glUniform1uiv, glUniform1uiv); \
  FUNC(glUniform1uiv, glUniform1uivEXT); \
  FUNC(glUniform1dv, glUniform1dv); \
  FUNC(glUniform2fv, glUniform2fv); \
  FUNC(glUniform2fv, glUniform2fvARB); \
  FUNC(glUniform2iv, glUniform2iv); \
  FUNC(glUniform2iv, glUniform2ivARB); \
  FUNC(glUniform2uiv, glUniform2uiv); \
  FUNC(glUniform2uiv, glUniform2uivEXT); \
  FUNC(glUniform2dv, glUniform2dv); \
  FUNC(glUniform3fv, glUniform3fv); \
  FUNC(glUniform3fv, glUniform3fvARB); \
  FUNC(glUniform3iv, glUniform3iv); \
  FUNC(glUniform3iv, glUniform3ivARB); \
  FUNC(glUniform3uiv, glUniform3uiv); \
  FUNC(glUniform3uiv, glUniform3uivEXT); \
  FUNC(glUniform3dv, glUniform3dv); \
  FUNC(glUniform4fv, glUniform4fv); \
  FUNC(glUniform4fv, glUniform4fvARB); \
  FUNC(glUniform4iv, glUniform4iv); \
  FUNC(glUniform4iv, glUniform4ivARB); \
  FUNC(glUniform4uiv, glUniform4uiv); \
  FUNC(glUniform4uiv, glUniform4uivEXT); \
  FUNC(glUniform4dv, glUniform4dv); \
  FUNC(glUniformMatrix2fv, glUniformMatrix2fv); \
  FUNC(glUniformMatrix2fv, glUniformMatrix2fvARB); \
  FUNC(glUniformMatrix2x3fv, glUniformMatrix2x3fv); \
  FUNC(glUniformMatrix2x4fv, glUniformMatrix2x4fv); \
  FUNC(glUniformMatrix3fv, glUniformMatrix3fv); \
  FUNC(glUniformMatrix3fv, glUniformMatrix3fvARB); \
  FUNC(glUniformMatrix3x2fv, glUniformMatrix3x2fv); \
  FUNC(glUniformMatrix3x4fv, glUniformMatrix3x4fv); \
  FUNC(glUniformMatrix4fv, glUniformMatrix4fv); \
  FUNC(glUniformMatrix4fv, glUniformMatrix4fvARB); \
  FUNC(glUniformMatrix4x2fv, glUniformMatrix4x2fv); \
  FUNC(glUniformMatrix4x3fv, glUniformMatrix4x3fv); \
  FUNC(glUniformMatrix2dv, glUniformMatrix2dv); \
  FUNC(glUniformMatrix2x3dv, glUniformMatrix2x3dv); \
  FUNC(glUniformMatrix2x4dv, glUniformMatrix2x4dv); \
  FUNC(glUniformMatrix3dv, glUniformMatrix3dv); \
  FUNC(glUniformMatrix3x2dv, glUniformMatrix3x2dv); \
  FUNC(glUniformMatrix3x4dv, glUniformMatrix3x4dv); \
  FUNC(glUniformMatrix4dv, glUniformMatrix4dv); \
  FUNC(glUniformMatrix4x2dv, glUniformMatrix4x2dv); \
  FUNC(glUniformMatrix4x3dv, glUniformMatrix4x3dv); \
  FUNC(glProgramUniform1f, glProgramUniform1f); \
  FUNC(glProgramUniform1f, glProgramUniform1fEXT); \
  FUNC(glProgramUniform1i, glProgramUniform1i); \
  FUNC(glProgramUniform1i, glProgramUniform1iEXT); \
  FUNC(glProgramUniform1ui, glProgramUniform1ui); \
  FUNC(glProgramUniform1ui, glProgramUniform1uiEXT); \
  FUNC(glProgramUniform1d, glProgramUniform1d); \
  FUNC(glProgramUniform1d, glProgramUniform1dEXT); \
  FUNC(glProgramUniform2f, glProgramUniform2f); \
  FUNC(glProgramUniform2f, glProgramUniform2fEXT); \
  FUNC(glProgramUniform2i, glProgramUniform2i); \
  FUNC(glProgramUniform2i, glProgramUniform2iEXT); \
  FUNC(glProgramUniform2ui, glProgramUniform2ui); \
  FUNC(glProgramUniform2ui, glProgramUniform2uiEXT); \
  FUNC(glProgramUniform2d, glProgramUniform2d); \
  FUNC(glProgramUniform2d, glProgramUniform2dEXT); \
  FUNC(glProgramUniform3f, glProgramUniform3f); \
  FUNC(glProgramUniform3f, glProgramUniform3fEXT); \
  FUNC(glProgramUniform3i, glProgramUniform3i); \
  FUNC(glProgramUniform3i, glProgramUniform3iEXT); \
  FUNC(glProgramUniform3ui, glProgramUniform3ui); \
  FUNC(glProgramUniform3ui, glProgramUniform3uiEXT); \
  FUNC(glProgramUniform3d, glProgramUniform3d); \
  FUNC(glProgramUniform3d, glProgramUniform3dEXT); \
  FUNC(glProgramUniform4f, glProgramUniform4f); \
  FUNC(glProgramUniform4f, glProgramUniform4fEXT); \
  FUNC(glProgramUniform4i, glProgramUniform4i); \
  FUNC(glProgramUniform4i, glProgramUniform4iEXT); \
  FUNC(glProgramUniform4ui, glProgramUniform4ui); \
  FUNC(glProgramUniform4ui, glProgramUniform4uiEXT); \
  FUNC(glProgramUniform4d, glProgramUniform4d); \
  FUNC(glProgramUniform4d, glProgramUniform4dEXT); \
  FUNC(glProgramUniform1fv, glProgramUniform1fv); \
  FUNC(glProgramUniform1fv, glProgramUniform1fvEXT); \
  FUNC(glProgramUniform1iv, glProgramUniform1iv); \
  FUNC(glProgramUniform1iv, glProgramUniform1ivEXT); \
  FUNC(glProgramUniform1uiv, glProgramUniform1uiv); \
  FUNC(glProgramUniform1uiv, glProgramUniform1uivEXT); \
  FUNC(glProgramUniform1dv, glProgramUniform1dv); \
  FUNC(glProgramUniform1dv, glProgramUniform1dvEXT); \
  FUNC(glProgramUniform2fv, glProgramUniform2fv); \
  FUNC(glProgramUniform2fv, glProgramUniform2fvEXT); \
  FUNC(glProgramUniform2iv, glProgramUniform2iv); \
  FUNC(glProgramUniform2iv, glProgramUniform2ivEXT); \
  FUNC(glProgramUniform2uiv, glProgramUniform2uiv); \
  FUNC(glProgramUniform2uiv, glProgramUniform2uivEXT); \
  FUNC(glProgramUniform2dv, glProgramUniform2dv); \
  FUNC(glProgramUniform2dv, glProgramUniform2dvEXT); \
  FUNC(glProgramUniform3fv, glProgramUniform3fv); \
  FUNC(glProgramUniform3fv, glProgramUniform3fvEXT); \
  FUNC(glProgramUniform3iv, glProgramUniform3iv); \
  FUNC(glProgramUniform3iv, glProgramUniform3ivEXT); \
  FUNC(glProgramUniform3uiv, glProgramUniform3uiv); \
  FUNC(glProgramUniform3uiv, glProgramUniform3uivEXT); \
  FUNC(glProgramUniform3dv, glProgramUniform3dv); \
  FUNC(glProgramUniform3dv, glProgramUniform3dvEXT); \
  FUNC(glProgramUniform4fv, glProgramUniform4fv); \
  FUNC(glProgramUniform4fv, glProgramUniform4fvEXT); \
  FUNC(glProgramUniform4iv, glProgramUniform4iv); \
  FUNC(glProgramUniform4iv, glProgramUniform4ivEXT); \
  FUNC(glProgramUniform4uiv, glProgramUniform4uiv); \
  FUNC(glProgramUniform4uiv, glProgramUniform4uivEXT); \
  FUNC(glProgramUniform4dv, glProgramUniform4dv); \
  FUNC(glProgramUniform4dv, glProgramUniform4dvEXT); \
  FUNC(glProgramUniformMatrix2fv, glProgramUniformMatrix2fv); \
  FUNC(glProgramUniformMatrix2fv, glProgramUniformMatrix2fvEXT); \
  FUNC(glProgramUniformMatrix2x3fv, glProgramUniformMatrix2x3fv); \
  FUNC(glProgramUniformMatrix2x3fv, glProgramUniformMatrix2x3fvEXT); \
  FUNC(glProgramUniformMatrix2x4fv, glProgramUniformMatrix2x4fv); \
  FUNC(glProgramUniformMatrix2x4fv, glProgramUniformMatrix2x4fvEXT); \
  FUNC(glProgramUniformMatrix3fv, glProgramUniformMatrix3fv); \
  FUNC(glProgramUniformMatrix3fv, glProgramUniformMatrix3fvEXT); \
  FUNC(glProgramUniformMatrix3x2fv, glProgramUniformMatrix3x2fv); \
  FUNC(glProgramUniformMatrix3x2fv, glProgramUniformMatrix3x2fvEXT); \
  FUNC(glProgramUniformMatrix3x4fv, glProgramUniformMatrix3x4fv); \
  FUNC(glProgramUniformMatrix3x4fv, glProgramUniformMatrix3x4fvEXT); \
  FUNC(glProgramUniformMatrix4fv, glProgramUniformMatrix4fv); \
  FUNC(glProgramUniformMatrix4fv, glProgramUniformMatrix4fvEXT); \
  FUNC(glProgramUniformMatrix4x2fv, glProgramUniformMatrix4x2fv); \
  FUNC(glProgramUniformMatrix4x2fv, glProgramUniformMatrix4x2fvEXT); \
  FUNC(glProgramUniformMatrix4x3fv, glProgramUniformMatrix4x3fv); \
  FUNC(glProgramUniformMatrix4x3fv, glProgramUniformMatrix4x3fvEXT); \
  FUNC(glProgramUniformMatrix2dv, glProgramUniformMatrix2dv); \
  FUNC(glProgramUniformMatrix2dv, glProgramUniformMatrix2dvEXT); \
  FUNC(glProgramUniformMatrix2x3dv, glProgramUniformMatrix2x3dv); \
  FUNC(glProgramUniformMatrix2x3dv, glProgramUniformMatrix2x3dvEXT); \
  FUNC(glProgramUniformMatrix2x4dv, glProgramUniformMatrix2x4dv); \
  FUNC(glProgramUniformMatrix2x4dv, glProgramUniformMatrix2x4dvEXT); \
  FUNC(glProgramUniformMatrix3dv, glProgramUniformMatrix3dv); \
  FUNC(glProgramUniformMatrix3dv, glProgramUniformMatrix3dvEXT); \
  FUNC(glProgramUniformMatrix3x2dv, glProgramUniformMatrix3x2dv); \
  FUNC(glProgramUniformMatrix3x2dv, glProgramUniformMatrix3x2dvEXT); \
  FUNC(glProgramUniformMatrix3x4dv, glProgramUniformMatrix3x4dv); \
  FUNC(glProgramUniformMatrix3x4dv, glProgramUniformMatrix3x4dvEXT); \
  FUNC(glProgramUniformMatrix4dv, glProgramUniformMatrix4dv); \
  FUNC(glProgramUniformMatrix4dv, glProgramUniformMatrix4dvEXT); \
  FUNC(glProgramUniformMatrix4x2dv, glProgramUniformMatrix4x2dv); \
  FUNC(glProgramUniformMatrix4x2dv, glProgramUniformMatrix4x2dvEXT); \
  FUNC(glProgramUniformMatrix4x3dv, glProgramUniformMatrix4x3dv); \
  FUNC(glProgramUniformMatrix4x3dv, glProgramUniformMatrix4x3dvEXT); \
  FUNC(glDrawRangeElements, glDrawRangeElements); \
  FUNC(glDrawRangeElements, glDrawRangeElementsEXT); \
  FUNC(glDrawRangeElementsBaseVertex, glDrawRangeElementsBaseVertex); \
  FUNC(glDrawRangeElementsBaseVertex, glDrawRangeElementsBaseVertexEXT); \
  FUNC(glDrawRangeElementsBaseVertex, glDrawRangeElementsBaseVertexOES); \
  FUNC(glDrawArraysInstancedBaseInstance, glDrawArraysInstancedBaseInstance); \
  FUNC(glDrawArraysInstancedBaseInstance, glDrawArraysInstancedBaseInstanceEXT); \
  FUNC(glDrawArraysInstanced, glDrawArraysInstanced); \
  FUNC(glDrawArraysInstanced, glDrawArraysInstancedARB); \
  FUNC(glDrawArraysInstanced, glDrawArraysInstancedEXT); \
  FUNC(glDrawElementsInstanced, glDrawElementsInstanced); \
  FUNC(glDrawElementsInstanced, glDrawElementsInstancedARB); \
  FUNC(glDrawElementsInstanced, glDrawElementsInstancedEXT); \
  FUNC(glDrawElementsInstancedBaseInstance, glDrawElementsInstancedBaseInstance); \
  FUNC(glDrawElementsInstancedBaseInstance, glDrawElementsInstancedBaseInstanceEXT); \
  FUNC(glDrawElementsBaseVertex, glDrawElementsBaseVertex); \
  FUNC(glDrawElementsBaseVertex, glDrawElementsBaseVertexEXT); \
  FUNC(glDrawElementsBaseVertex, glDrawElementsBaseVertexOES); \
  FUNC(glDrawElementsInstancedBaseVertex, glDrawElementsInstancedBaseVertex); \
  FUNC(glDrawElementsInstancedBaseVertex, glDrawElementsInstancedBaseVertexEXT); \
  FUNC(glDrawElementsInstancedBaseVertex, glDrawElementsInstancedBaseVertexOES); \
  FUNC(glDrawElementsInstancedBaseVertexBaseInstance, glDrawElementsInstancedBaseVertexBaseInstance); \
  FUNC(glDrawElementsInstancedBaseVertexBaseInstance, glDrawElementsInstancedBaseVertexBaseInstanceEXT); \
  FUNC(glMultiDrawArrays, glMultiDrawArrays); \
  FUNC(glMultiDrawArrays, glMultiDrawArraysEXT); \
  FUNC(glMultiDrawElements, glMultiDrawElements); \
  FUNC(glMultiDrawElementsBaseVertex, glMultiDrawElementsBaseVertex); \
  FUNC(glMultiDrawElementsBaseVertex, glMultiDrawElementsBaseVertexEXT); \
  FUNC(glMultiDrawElementsBaseVertex, glMultiDrawElementsBaseVertexOES); \
  FUNC(glMultiDrawArraysIndirect, glMultiDrawArraysIndirect); \
  FUNC(glMultiDrawElementsIndirect, glMultiDrawElementsIndirect); \
  FUNC(glDrawArraysIndirect, glDrawArraysIndirect); \
  FUNC(glDrawElementsIndirect, glDrawElementsIndirect); \
  FUNC(glBlitFramebuffer, glBlitFramebuffer); \
  FUNC(glBlitFramebuffer, glBlitFramebufferEXT); \
  FUNC(glPrimitiveBoundingBox, glPrimitiveBoundingBox); \
  FUNC(glPrimitiveBoundingBox, glPrimitiveBoundingBoxARB); \
  FUNC(glPrimitiveBoundingBox, glPrimitiveBoundingBoxEXT); \
  FUNC(glPrimitiveBoundingBox, glPrimitiveBoundingBoxOES); \
  FUNC(glBlendBarrier, glBlendBarrier); \
  FUNC(glFramebufferTexture2DMultisampleEXT, glFramebufferTexture2DMultisampleEXT); \
  FUNC(glRenderbufferStorageMultisampleEXT, glRenderbufferStorageMultisampleEXT); \
  FUNC(glDiscardFramebufferEXT, glDiscardFramebufferEXT); \
  FUNC(glDepthRangeArrayfvOES, glDepthRangeArrayfvOES); \
  FUNC(glDepthRangeArrayfvOES, glDepthRangeArrayfvNV); \
  FUNC(glDepthRangeIndexedfOES, glDepthRangeIndexedfOES); \
  FUNC(glDepthRangeIndexedfOES, glDepthRangeIndexedfNV); \
  FUNC(glNamedStringARB, glNamedStringARB); \
  FUNC(glDeleteNamedStringARB, glDeleteNamedStringARB); \
  FUNC(glCompileShaderIncludeARB, glCompileShaderIncludeARB); \
  FUNC(glIsNamedStringARB, glIsNamedStringARB); \
  FUNC(glGetNamedStringARB, glGetNamedStringARB); \
  FUNC(glGetNamedStringivARB, glGetNamedStringivARB); \
  FUNC(glDispatchComputeGroupSizeARB, glDispatchComputeGroupSizeARB); \
  FUNC(glMultiDrawArraysIndirectCount, glMultiDrawArraysIndirectCount); \
  FUNC(glMultiDrawArraysIndirectCount, glMultiDrawArraysIndirectCountARB); \
  FUNC(glMultiDrawElementsIndirectCount, glMultiDrawElementsIndirectCount); \
  FUNC(glMultiDrawElementsIndirectCount, glMultiDrawElementsIndirectCountARB); \
  FUNC(glRasterSamplesEXT, glRasterSamplesEXT); \
  FUNC(glDepthBoundsEXT, glDepthBoundsEXT); \
  FUNC(glPolygonOffsetClamp, glPolygonOffsetClamp); \
  FUNC(glPolygonOffsetClamp, glPolygonOffsetClampEXT); \
  FUNC(glInsertEventMarkerEXT, glInsertEventMarkerEXT); \
  FUNC(glPushGroupMarkerEXT, glPushGroupMarkerEXT); \
  FUNC(glPopGroupMarkerEXT, glPopGroupMarkerEXT); \
  FUNC(glFrameTerminatorGREMEDY, glFrameTerminatorGREMEDY); \
  FUNC(glStringMarkerGREMEDY, glStringMarkerGREMEDY); \
  FUNC(glFramebufferTextureMultiviewOVR, glFramebufferTextureMultiviewOVR); \
  FUNC(glFramebufferTextureMultisampleMultiviewOVR, glFramebufferTextureMultisampleMultiviewOVR); \
  FUNC(glTextureFoveationParametersQCOM, glTextureFoveationParametersQCOM); \
  FUNC(glMaxShaderCompilerThreadsKHR, glMaxShaderCompilerThreadsKHR); \
  FUNC(glMaxShaderCompilerThreadsKHR, glMaxShaderCompilerThreadsARB); \
  FUNC(glSpecializeShader, glSpecializeShader); \
  FUNC(glSpecializeShader, glSpecializeShaderARB); \
  FUNC(glGetUnsignedBytevEXT, glGetUnsignedBytevEXT); \
  FUNC(glGetUnsignedBytei_vEXT, glGetUnsignedBytei_vEXT); \
  FUNC(glDeleteMemoryObjectsEXT, glDeleteMemoryObjectsEXT); \
  FUNC(glIsMemoryObjectEXT, glIsMemoryObjectEXT); \
  FUNC(glCreateMemoryObjectsEXT, glCreateMemoryObjectsEXT); \
  FUNC(glMemoryObjectParameterivEXT, glMemoryObjectParameterivEXT); \
  FUNC(glGetMemoryObjectParameterivEXT, glGetMemoryObjectParameterivEXT); \
  FUNC(glTexStorageMem2DEXT, glTexStorageMem2DEXT); \
  FUNC(glTexStorageMem2DMultisampleEXT, glTexStorageMem2DMultisampleEXT); \
  FUNC(glTexStorageMem3DEXT, glTexStorageMem3DEXT); \
  FUNC(glTexStorageMem3DMultisampleEXT, glTexStorageMem3DMultisampleEXT); \
  FUNC(glBufferStorageMemEXT, glBufferStorageMemEXT); \
  FUNC(glTextureStorageMem2DEXT, glTextureStorageMem2DEXT); \
  FUNC(glTextureStorageMem2DMultisampleEXT, glTextureStorageMem2DMultisampleEXT); \
  FUNC(glTextureStorageMem3DEXT, glTextureStorageMem3DEXT); \
  FUNC(glTextureStorageMem3DMultisampleEXT, glTextureStorageMem3DMultisampleEXT); \
  FUNC(glNamedBufferStorageMemEXT, glNamedBufferStorageMemEXT); \
  FUNC(glTexStorageMem1DEXT, glTexStorageMem1DEXT); \
  FUNC(glTextureStorageMem1DEXT, glTextureStorageMem1DEXT); \
  FUNC(glGenSemaphoresEXT, glGenSemaphoresEXT); \
  FUNC(glDeleteSemaphoresEXT, glDeleteSemaphoresEXT); \
  FUNC(glIsSemaphoreEXT, glIsSemaphoreEXT); \
  FUNC(glSemaphoreParameterui64vEXT, glSemaphoreParameterui64vEXT); \
  FUNC(glGetSemaphoreParameterui64vEXT, glGetSemaphoreParameterui64vEXT); \
  FUNC(glWaitSemaphoreEXT, glWaitSemaphoreEXT); \
  FUNC(glSignalSemaphoreEXT, glSignalSemaphoreEXT); \
  FUNC(glImportMemoryFdEXT, glImportMemoryFdEXT); \
  FUNC(glImportSemaphoreFdEXT, glImportSemaphoreFdEXT); \
  FUNC(glImportMemoryWin32HandleEXT, glImportMemoryWin32HandleEXT); \
  FUNC(glImportMemoryWin32NameEXT, glImportMemoryWin32NameEXT); \
  FUNC(glImportSemaphoreWin32HandleEXT, glImportSemaphoreWin32HandleEXT); \
  FUNC(glImportSemaphoreWin32NameEXT, glImportSemaphoreWin32NameEXT); \
  FUNC(glAcquireKeyedMutexWin32EXT, glAcquireKeyedMutexWin32EXT); \
  FUNC(glReleaseKeyedMutexWin32EXT, glReleaseKeyedMutexWin32EXT); \
  FUNC(glCompressedTextureImage1DEXT, glCompressedTextureImage1DEXT); \
  FUNC(glCompressedTextureImage2DEXT, glCompressedTextureImage2DEXT); \
  FUNC(glCompressedTextureImage3DEXT, glCompressedTextureImage3DEXT); \
  FUNC(glCompressedTextureSubImage1DEXT, glCompressedTextureSubImage1DEXT); \
  FUNC(glCompressedTextureSubImage2DEXT, glCompressedTextureSubImage2DEXT); \
  FUNC(glCompressedTextureSubImage3DEXT, glCompressedTextureSubImage3DEXT); \
  FUNC(glGenerateTextureMipmapEXT, glGenerateTextureMipmapEXT); \
  FUNC(glGetPointeri_vEXT, glGetPointeri_vEXT); \
  FUNC(glGetDoubleIndexedvEXT, glGetDoubleIndexedvEXT); \
  FUNC(glGetPointerIndexedvEXT, glGetPointerIndexedvEXT); \
  FUNC(glGetIntegerIndexedvEXT, glGetIntegerIndexedvEXT); \
  FUNC(glGetBooleanIndexedvEXT, glGetBooleanIndexedvEXT); \
  FUNC(glGetFloatIndexedvEXT, glGetFloatIndexedvEXT); \
  FUNC(glGetMultiTexImageEXT, glGetMultiTexImageEXT); \
  FUNC(glGetMultiTexParameterfvEXT, glGetMultiTexParameterfvEXT); \
  FUNC(glGetMultiTexParameterivEXT, glGetMultiTexParameterivEXT); \
  FUNC(glGetMultiTexParameterIivEXT, glGetMultiTexParameterIivEXT); \
  FUNC(glGetMultiTexParameterIuivEXT, glGetMultiTexParameterIuivEXT); \
  FUNC(glGetMultiTexLevelParameterfvEXT, glGetMultiTexLevelParameterfvEXT); \
  FUNC(glGetMultiTexLevelParameterivEXT, glGetMultiTexLevelParameterivEXT); \
  FUNC(glGetCompressedMultiTexImageEXT, glGetCompressedMultiTexImageEXT); \
  FUNC(glGetNamedBufferPointervEXT, glGetNamedBufferPointervEXT); \
  FUNC(glGetNamedBufferPointervEXT, glGetNamedBufferPointerv); \
  FUNC(glGetNamedProgramivEXT, glGetNamedProgramivEXT); \
  FUNC(glGetNamedFramebufferAttachmentParameterivEXT, glGetNamedFramebufferAttachmentParameterivEXT); \
  FUNC(glGetNamedFramebufferAttachmentParameterivEXT, glGetNamedFramebufferAttachmentParameteriv); \
  FUNC(glGetNamedBufferParameterivEXT, glGetNamedBufferParameterivEXT); \
  FUNC(glGetNamedBufferParameterivEXT, glGetNamedBufferParameteriv); \
  FUNC(glCheckNamedFramebufferStatusEXT, glCheckNamedFramebufferStatusEXT); \
  FUNC(glCheckNamedFramebufferStatusEXT, glCheckNamedFramebufferStatus); \
  FUNC(glGetNamedBufferSubDataEXT, glGetNamedBufferSubDataEXT); \
  FUNC(glGetNamedFramebufferParameterivEXT, glGetNamedFramebufferParameterivEXT); \
  FUNC(glGetNamedFramebufferParameterivEXT, glGetFramebufferParameterivEXT); \
  FUNC(glGetNamedFramebufferParameterivEXT, glGetNamedFramebufferParameteriv); \
  FUNC(glGetNamedRenderbufferParameterivEXT, glGetNamedRenderbufferParameterivEXT); \
  FUNC(glGetNamedRenderbufferParameterivEXT, glGetNamedRenderbufferParameteriv); \
  FUNC(glGetVertexArrayIntegervEXT, glGetVertexArrayIntegervEXT); \
  FUNC(glGetVertexArrayPointervEXT, glGetVertexArrayPointervEXT); \
  FUNC(glGetVertexArrayIntegeri_vEXT, glGetVertexArrayIntegeri_vEXT); \
  FUNC(glGetVertexArrayPointeri_vEXT, glGetVertexArrayPointeri_vEXT); \
  FUNC(glGetCompressedTextureImageEXT, glGetCompressedTextureImageEXT); \
  FUNC(glGetTextureImageEXT, glGetTextureImageEXT); \
  FUNC(glGetTextureParameterivEXT, glGetTextureParameterivEXT); \
  FUNC(glGetTextureParameterfvEXT, glGetTextureParameterfvEXT); \
  FUNC(glGetTextureParameterIivEXT, glGetTextureParameterIivEXT); \
  FUNC(glGetTextureParameterIuivEXT, glGetTextureParameterIuivEXT); \
  FUNC(glGetTextureLevelParameterivEXT, glGetTextureLevelParameterivEXT); \
  FUNC(glGetTextureLevelParameterfvEXT, glGetTextureLevelParameterfvEXT); \
  FUNC(glBindMultiTextureEXT, glBindMultiTextureEXT); \
  FUNC(glMapNamedBufferEXT, glMapNamedBufferEXT); \
  FUNC(glMapNamedBufferEXT, glMapNamedBuffer); \
  FUNC(glMapNamedBufferRangeEXT, glMapNamedBufferRangeEXT); \
  FUNC(glFlushMappedNamedBufferRangeEXT, glFlushMappedNamedBufferRangeEXT); \
  FUNC(glUnmapNamedBufferEXT, glUnmapNamedBufferEXT); \
  FUNC(glUnmapNamedBufferEXT, glUnmapNamedBuffer); \
  FUNC(glClearNamedBufferDataEXT, glClearNamedBufferDataEXT); \
  FUNC(glClearNamedBufferDataEXT, glClearNamedBufferData); \
  FUNC(glClearNamedBufferSubDataEXT, glClearNamedBufferSubDataEXT); \
  FUNC(glNamedBufferDataEXT, glNamedBufferDataEXT); \
  FUNC(glNamedBufferStorageEXT, glNamedBufferStorageEXT); \
  FUNC(glNamedBufferSubDataEXT, glNamedBufferSubDataEXT); \
  FUNC(glNamedCopyBufferSubDataEXT, glNamedCopyBufferSubDataEXT); \
  FUNC(glNamedFramebufferTextureEXT, glNamedFramebufferTextureEXT); \
  FUNC(glNamedFramebufferTextureEXT, glNamedFramebufferTexture); \
  FUNC(glNamedFramebufferTexture1DEXT, glNamedFramebufferTexture1DEXT); \
  FUNC(glNamedFramebufferTexture2DEXT, glNamedFramebufferTexture2DEXT); \
  FUNC(glNamedFramebufferTexture3DEXT, glNamedFramebufferTexture3DEXT); \
  FUNC(glNamedFramebufferRenderbufferEXT, glNamedFramebufferRenderbufferEXT); \
  FUNC(glNamedFramebufferRenderbufferEXT, glNamedFramebufferRenderbuffer); \
  FUNC(glNamedFramebufferTextureLayerEXT, glNamedFramebufferTextureLayerEXT); \
  FUNC(glNamedFramebufferTextureLayerEXT, glNamedFramebufferTextureLayer); \
  FUNC(glNamedFramebufferParameteriEXT, glNamedFramebufferParameteriEXT); \
  FUNC(glNamedFramebufferParameteriEXT, glNamedFramebufferParameteri); \
  FUNC(glNamedRenderbufferStorageEXT, glNamedRenderbufferStorageEXT); \
  FUNC(glNamedRenderbufferStorageEXT, glNamedRenderbufferStorage); \
  FUNC(glNamedRenderbufferStorageMultisampleEXT, glNamedRenderbufferStorageMultisampleEXT); \
  FUNC(glNamedRenderbufferStorageMultisampleEXT, glNamedRenderbufferStorageMultisample); \
  FUNC(glFramebufferDrawBufferEXT, glFramebufferDrawBufferEXT); \
  FUNC(glFramebufferDrawBufferEXT, glNamedFramebufferDrawBuffer); \
  FUNC(glFramebufferDrawBuffersEXT, glFramebufferDrawBuffersEXT); \
  FUNC(glFramebufferDrawBuffersEXT, glNamedFramebufferDrawBuffers); \
  FUNC(glFramebufferReadBufferEXT, glFramebufferReadBufferEXT); \
  FUNC(glFramebufferReadBufferEXT, glNamedFramebufferReadBuffer); \
  FUNC(glTextureBufferEXT, glTextureBufferEXT); \
  FUNC(glTextureBufferRangeEXT, glTextureBufferRangeEXT); \
  FUNC(glTextureImage1DEXT, glTextureImage1DEXT); \
  FUNC(glTextureImage2DEXT, glTextureImage2DEXT); \
  FUNC(glTextureImage3DEXT, glTextureImage3DEXT); \
  FUNC(glTextureParameterfEXT, glTextureParameterfEXT); \
  FUNC(glTextureParameterfvEXT, glTextureParameterfvEXT); \
  FUNC(glTextureParameteriEXT, glTextureParameteriEXT); \
  FUNC(glTextureParameterivEXT, glTextureParameterivEXT); \
  FUNC(glTextureParameterIivEXT, glTextureParameterIivEXT); \
  FUNC(glTextureParameterIuivEXT, glTextureParameterIuivEXT); \
  FUNC(glTextureStorage1DEXT, glTextureStorage1DEXT); \
  FUNC(glTextureStorage2DEXT, glTextureStorage2DEXT); \
  FUNC(glTextureStorage3DEXT, glTextureStorage3DEXT); \
  FUNC(glTextureStorage2DMultisampleEXT, glTextureStorage2DMultisampleEXT); \
  FUNC(glTextureStorage3DMultisampleEXT, glTextureStorage3DMultisampleEXT); \
  FUNC(glTextureSubImage1DEXT, glTextureSubImage1DEXT); \
  FUNC(glTextureSubImage2DEXT, glTextureSubImage2DEXT); \
  FUNC(glTextureSubImage3DEXT, glTextureSubImage3DEXT); \
  FUNC(glCopyTextureImage1DEXT, glCopyTextureImage1DEXT); \
  FUNC(glCopyTextureImage2DEXT, glCopyTextureImage2DEXT); \
  FUNC(glCopyTextureSubImage1DEXT, glCopyTextureSubImage1DEXT); \
  FUNC(glCopyTextureSubImage2DEXT, glCopyTextureSubImage2DEXT); \
  FUNC(glCopyTextureSubImage3DEXT, glCopyTextureSubImage3DEXT); \
  FUNC(glMultiTexParameteriEXT, glMultiTexParameteriEXT); \
  FUNC(glMultiTexParameterivEXT, glMultiTexParameterivEXT); \
  FUNC(glMultiTexParameterfEXT, glMultiTexParameterfEXT); \
  FUNC(glMultiTexParameterfvEXT, glMultiTexParameterfvEXT); \
  FUNC(glMultiTexImage1DEXT, glMultiTexImage1DEXT); \
  FUNC(glMultiTexImage2DEXT, glMultiTexImage2DEXT); \
  FUNC(glMultiTexSubImage1DEXT, glMultiTexSubImage1DEXT); \
  FUNC(glMultiTexSubImage2DEXT, glMultiTexSubImage2DEXT); \
  FUNC(glCopyMultiTexImage1DEXT, glCopyMultiTexImage1DEXT); \
  FUNC(glCopyMultiTexImage2DEXT, glCopyMultiTexImage2DEXT); \
  FUNC(glCopyMultiTexSubImage1DEXT, glCopyMultiTexSubImage1DEXT); \
  FUNC(glCopyMultiTexSubImage2DEXT, glCopyMultiTexSubImage2DEXT); \
  FUNC(glMultiTexImage3DEXT, glMultiTexImage3DEXT); \
  FUNC(glMultiTexSubImage3DEXT, glMultiTexSubImage3DEXT); \
  FUNC(glCopyMultiTexSubImage3DEXT, glCopyMultiTexSubImage3DEXT); \
  FUNC(glCompressedMultiTexImage3DEXT, glCompressedMultiTexImage3DEXT); \
  FUNC(glCompressedMultiTexImage2DEXT, glCompressedMultiTexImage2DEXT); \
  FUNC(glCompressedMultiTexImage1DEXT, glCompressedMultiTexImage1DEXT); \
  FUNC(glCompressedMultiTexSubImage3DEXT, glCompressedMultiTexSubImage3DEXT); \
  FUNC(glCompressedMultiTexSubImage2DEXT, glCompressedMultiTexSubImage2DEXT); \
  FUNC(glCompressedMultiTexSubImage1DEXT, glCompressedMultiTexSubImage1DEXT); \
  FUNC(glMultiTexBufferEXT, glMultiTexBufferEXT); \
  FUNC(glMultiTexParameterIivEXT, glMultiTexParameterIivEXT); \
  FUNC(glMultiTexParameterIuivEXT, glMultiTexParameterIuivEXT); \
  FUNC(glGenerateMultiTexMipmapEXT, glGenerateMultiTexMipmapEXT); \
  FUNC(glVertexArrayVertexAttribOffsetEXT, glVertexArrayVertexAttribOffsetEXT); \
  FUNC(glVertexArrayVertexAttribIOffsetEXT, glVertexArrayVertexAttribIOffsetEXT); \
  FUNC(glEnableVertexArrayAttribEXT, glEnableVertexArrayAttribEXT); \
  FUNC(glEnableVertexArrayAttribEXT, glEnableVertexArrayAttrib); \
  FUNC(glDisableVertexArrayAttribEXT, glDisableVertexArrayAttribEXT); \
  FUNC(glDisableVertexArrayAttribEXT, glDisableVertexArrayAttrib); \
  FUNC(glVertexArrayBindVertexBufferEXT, glVertexArrayBindVertexBufferEXT); \
  FUNC(glVertexArrayBindVertexBufferEXT, glVertexArrayVertexBuffer); \
  FUNC(glVertexArrayVertexAttribFormatEXT, glVertexArrayVertexAttribFormatEXT); \
  FUNC(glVertexArrayVertexAttribFormatEXT, glVertexArrayAttribFormat); \
  FUNC(glVertexArrayVertexAttribIFormatEXT, glVertexArrayVertexAttribIFormatEXT); \
  FUNC(glVertexArrayVertexAttribIFormatEXT, glVertexArrayAttribIFormat); \
  FUNC(glVertexArrayVertexAttribLFormatEXT, glVertexArrayVertexAttribLFormatEXT); \
  FUNC(glVertexArrayVertexAttribLFormatEXT, glVertexArrayAttribLFormat); \
  FUNC(glVertexArrayVertexAttribBindingEXT, glVertexArrayVertexAttribBindingEXT); \
  FUNC(glVertexArrayVertexAttribBindingEXT, glVertexArrayAttribBinding); \
  FUNC(glVertexArrayVertexBindingDivisorEXT, glVertexArrayVertexBindingDivisorEXT); \
  FUNC(glVertexArrayVertexBindingDivisorEXT, glVertexArrayBindingDivisor); \
  FUNC(glVertexArrayVertexAttribLOffsetEXT, glVertexArrayVertexAttribLOffsetEXT); \
  FUNC(glVertexArrayVertexAttribDivisorEXT, glVertexArrayVertexAttribDivisorEXT); \
  FUNC(glCreateTransformFeedbacks, glCreateTransformFeedbacks); \
  FUNC(glTransformFeedbackBufferBase, glTransformFeedbackBufferBase); \
  FUNC(glTransformFeedbackBufferRange, glTransformFeedbackBufferRange); \
  FUNC(glGetTransformFeedbacki64_v, glGetTransformFeedbacki64_v); \
  FUNC(glGetTransformFeedbacki_v, glGetTransformFeedbacki_v); \
  FUNC(glGetTransformFeedbackiv, glGetTransformFeedbackiv); \
  FUNC(glCreateBuffers, glCreateBuffers); \
  FUNC(glGetNamedBufferSubData, glGetNamedBufferSubData); \
  FUNC(glNamedBufferStorage, glNamedBufferStorage); \
  FUNC(glNamedBufferData, glNamedBufferData); \
  FUNC(glNamedBufferSubData, glNamedBufferSubData); \
  FUNC(glCopyNamedBufferSubData, glCopyNamedBufferSubData); \
  FUNC(glClearNamedBufferSubData, glClearNamedBufferSubData); \
  FUNC(glMapNamedBufferRange, glMapNamedBufferRange); \
  FUNC(glFlushMappedNamedBufferRange, glFlushMappedNamedBufferRange); \
  FUNC(glGetNamedBufferParameteri64v, glGetNamedBufferParameteri64v); \
  FUNC(glCreateFramebuffers, glCreateFramebuffers); \
  FUNC(glInvalidateNamedFramebufferData, glInvalidateNamedFramebufferData); \
  FUNC(glInvalidateNamedFramebufferSubData, glInvalidateNamedFramebufferSubData); \
  FUNC(glClearNamedFramebufferiv, glClearNamedFramebufferiv); \
  FUNC(glClearNamedFramebufferuiv, glClearNamedFramebufferuiv); \
  FUNC(glClearNamedFramebufferfv, glClearNamedFramebufferfv); \
  FUNC(glClearNamedFramebufferfi, glClearNamedFramebufferfi); \
  FUNC(glBlitNamedFramebuffer, glBlitNamedFramebuffer); \
  FUNC(glCreateRenderbuffers, glCreateRenderbuffers); \
  FUNC(glCreateTextures, glCreateTextures); \
  FUNC(glTextureBuffer, glTextureBuffer); \
  FUNC(glTextureBufferRange, glTextureBufferRange); \
  FUNC(glTextureStorage1D, glTextureStorage1D); \
  FUNC(glTextureStorage2D, glTextureStorage2D); \
  FUNC(glTextureStorage3D, glTextureStorage3D); \
  FUNC(glTextureStorage2DMultisample, glTextureStorage2DMultisample); \
  FUNC(glTextureStorage3DMultisample, glTextureStorage3DMultisample); \
  FUNC(glTextureSubImage1D, glTextureSubImage1D); \
  FUNC(glTextureSubImage2D, glTextureSubImage2D); \
  FUNC(glTextureSubImage3D, glTextureSubImage3D); \
  FUNC(glCompressedTextureSubImage1D, glCompressedTextureSubImage1D); \
  FUNC(glCompressedTextureSubImage2D, glCompressedTextureSubImage2D); \
  FUNC(glCompressedTextureSubImage3D, glCompressedTextureSubImage3D); \
  FUNC(glCopyTextureSubImage1D, glCopyTextureSubImage1D); \
  FUNC(glCopyTextureSubImage2D, glCopyTextureSubImage2D); \
  FUNC(glCopyTextureSubImage3D, glCopyTextureSubImage3D); \
  FUNC(glTextureParameterf, glTextureParameterf); \
  FUNC(glTextureParameterfv, glTextureParameterfv); \
  FUNC(glTextureParameteri, glTextureParameteri); \
  FUNC(glTextureParameterIiv, glTextureParameterIiv); \
  FUNC(glTextureParameterIuiv, glTextureParameterIuiv); \
  FUNC(glTextureParameteriv, glTextureParameteriv); \
  FUNC(glGenerateTextureMipmap, glGenerateTextureMipmap); \
  FUNC(glBindTextureUnit, glBindTextureUnit); \
  FUNC(glGetTextureImage, glGetTextureImage); \
  FUNC(glGetTextureSubImage, glGetTextureSubImage); \
  FUNC(glGetCompressedTextureImage, glGetCompressedTextureImage); \
  FUNC(glGetCompressedTextureSubImage, glGetCompressedTextureSubImage); \
  FUNC(glGetTextureLevelParameterfv, glGetTextureLevelParameterfv); \
  FUNC(glGetTextureLevelParameteriv, glGetTextureLevelParameteriv); \
  FUNC(glGetTextureParameterIiv, glGetTextureParameterIiv); \
  FUNC(glGetTextureParameterIuiv, glGetTextureParameterIuiv); \
  FUNC(glGetTextureParameterfv, glGetTextureParameterfv); \
  FUNC(glGetTextureParameteriv, glGetTextureParameteriv); \
  FUNC(glCreateVertexArrays, glCreateVertexArrays); \
  FUNC(glCreateSamplers, glCreateSamplers); \
  FUNC(glCreateProgramPipelines, glCreateProgramPipelines); \
  FUNC(glCreateQueries, glCreateQueries); \
  FUNC(glVertexArrayElementBuffer, glVertexArrayElementBuffer); \
  FUNC(glVertexArrayVertexBuffers, glVertexArrayVertexBuffers); \
  FUNC(glGetVertexArrayiv, glGetVertexArrayiv); \
  FUNC(glGetVertexArrayIndexed64iv, glGetVertexArrayIndexed64iv); \
  FUNC(glGetVertexArrayIndexediv, glGetVertexArrayIndexediv); \
  FUNC(glGetQueryBufferObjecti64v, glGetQueryBufferObjecti64v); \
  FUNC(glGetQueryBufferObjectiv, glGetQueryBufferObjectiv); \
  FUNC(glGetQueryBufferObjectui64v, glGetQueryBufferObjectui64v); \
  FUNC(glGetQueryBufferObjectuiv, glGetQueryBufferObjectuiv); \
  FUNC(glBeginPerfQueryINTEL, glBeginPerfQueryINTEL); \
  FUNC(glCreatePerfQueryINTEL, glCreatePerfQueryINTEL); \
  FUNC(glDeletePerfQueryINTEL, glDeletePerfQueryINTEL); \
  FUNC(glEndPerfQueryINTEL, glEndPerfQueryINTEL); \
  FUNC(glGetFirstPerfQueryIdINTEL, glGetFirstPerfQueryIdINTEL); \
  FUNC(glGetNextPerfQueryIdINTEL, glGetNextPerfQueryIdINTEL); \
  FUNC(glGetPerfCounterInfoINTEL, glGetPerfCounterInfoINTEL); \
  FUNC(glGetPerfQueryDataINTEL, glGetPerfQueryDataINTEL); \
  FUNC(glGetPerfQueryIdByNameINTEL, glGetPerfQueryIdByNameINTEL); \
  FUNC(glGetPerfQueryInfoINTEL, glGetPerfQueryInfoINTEL); \
  FUNC(wglDXSetResourceShareHandleNV, wglDXSetResourceShareHandleNV); \
  FUNC(wglDXOpenDeviceNV, wglDXOpenDeviceNV); \
  FUNC(wglDXCloseDeviceNV, wglDXCloseDeviceNV); \
  FUNC(wglDXRegisterObjectNV, wglDXRegisterObjectNV); \
  FUNC(wglDXUnregisterObjectNV, wglDXUnregisterObjectNV); \
  FUNC(wglDXObjectAccessNV, wglDXObjectAccessNV); \
  FUNC(wglDXLockObjectsNV, wglDXLockObjectsNV); \
  FUNC(wglDXUnlockObjectsNV, wglDXUnlockObjectsNV); \




#define DefineSupportedHooks() \
  FuncWrapper2(void, glBindTexture, GLenum, target, GLuint, texture); \
  FuncWrapper2(void, glBlendFunc, GLenum, sfactor, GLenum, dfactor); \
  FuncWrapper1(void, glClear, GLbitfield, mask); \
  FuncWrapper4(void, glClearColor, GLfloat, red, GLfloat, green, GLfloat, blue, GLfloat, alpha); \
  FuncWrapper1(void, glClearDepth, GLdouble, depth); \
  FuncWrapper1(void, glClearStencil, GLint, s); \
  FuncWrapper4(void, glColorMask, GLboolean, red, GLboolean, green, GLboolean, blue, GLboolean, alpha); \
  FuncWrapper1(void, glCullFace, GLenum, mode); \
  FuncWrapper1(void, glDepthFunc, GLenum, func); \
  FuncWrapper1(void, glDepthMask, GLboolean, flag); \
  FuncWrapper2(void, glDepthRange, GLdouble, near, GLdouble, far); \
  FuncWrapper3(void, glStencilFunc, GLenum, func, GLint, ref, GLuint, mask); \
  FuncWrapper1(void, glStencilMask, GLuint, mask); \
  FuncWrapper3(void, glStencilOp, GLenum, fail, GLenum, zfail, GLenum, zpass); \
  FuncWrapper1(void, glDisable, GLenum, cap); \
  FuncWrapper1(void, glDrawBuffer, GLenum, buf); \
  FuncWrapper4(void, glDrawElements, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices); \
  FuncWrapper3(void, glDrawArrays, GLenum, mode, GLint, first, GLsizei, count); \
  FuncWrapper1(void, glEnable, GLenum, cap); \
  FuncWrapper0(void, glFlush); \
  FuncWrapper0(void, glFinish); \
  FuncWrapper1(void, glFrontFace, GLenum, mode); \
  FuncWrapper2(void, glGenTextures, GLsizei, n, GLuint *, textures); \
  FuncWrapper2(void, glDeleteTextures, GLsizei, n, const GLuint *, textures); \
  FuncWrapper1(GLboolean, glIsEnabled, GLenum, cap); \
  FuncWrapper1(GLboolean, glIsTexture, GLuint, texture); \
  FuncWrapper0(GLenum, glGetError); \
  FuncWrapper4(void, glGetTexLevelParameteriv, GLenum, target, GLint, level, GLenum, pname, GLint *, params); \
  FuncWrapper4(void, glGetTexLevelParameterfv, GLenum, target, GLint, level, GLenum, pname, GLfloat *, params); \
  FuncWrapper3(void, glGetTexParameterfv, GLenum, target, GLenum, pname, GLfloat *, params); \
  FuncWrapper3(void, glGetTexParameteriv, GLenum, target, GLenum, pname, GLint *, params); \
  FuncWrapper5(void, glGetTexImage, GLenum, target, GLint, level, GLenum, format, GLenum, type, void *, pixels); \
  FuncWrapper2(void, glGetBooleanv, GLenum, pname, GLboolean *, data); \
  FuncWrapper2(void, glGetFloatv, GLenum, pname, GLfloat *, data); \
  FuncWrapper2(void, glGetDoublev, GLenum, pname, GLdouble *, data); \
  FuncWrapper2(void, glGetIntegerv, GLenum, pname, GLint *, data); \
  FuncWrapper2(void, glGetPointerv, GLenum, pname, void **, params); \
  AliasWrapper2(void, glGetPointervKHR, glGetPointerv, GLenum, pname, void **, params); \
  FuncWrapper1(const GLubyte *, glGetString, GLenum, name); \
  FuncWrapper2(void, glHint, GLenum, target, GLenum, mode); \
  FuncWrapper1(void, glLogicOp, GLenum, opcode); \
  FuncWrapper2(void, glPixelStorei, GLenum, pname, GLint, param); \
  FuncWrapper2(void, glPixelStoref, GLenum, pname, GLfloat, param); \
  FuncWrapper2(void, glPolygonMode, GLenum, face, GLenum, mode); \
  FuncWrapper2(void, glPolygonOffset, GLfloat, factor, GLfloat, units); \
  FuncWrapper1(void, glPointSize, GLfloat, size); \
  FuncWrapper1(void, glLineWidth, GLfloat, width); \
  FuncWrapper7(void, glReadPixels, GLint, x, GLint, y, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, void *, pixels); \
  FuncWrapper1(void, glReadBuffer, GLenum, src); \
  FuncWrapper4(void, glScissor, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  FuncWrapper8(void, glTexImage1D, GLenum, target, GLint, level, GLint, internalformat, GLsizei, width, GLint, border, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper9(void, glTexImage2D, GLenum, target, GLint, level, GLint, internalformat, GLsizei, width, GLsizei, height, GLint, border, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper7(void, glTexSubImage1D, GLenum, target, GLint, level, GLint, xoffset, GLsizei, width, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper9(void, glTexSubImage2D, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper7(void, glCopyTexImage1D, GLenum, target, GLint, level, GLenum, internalformat, GLint, x, GLint, y, GLsizei, width, GLint, border); \
  FuncWrapper8(void, glCopyTexImage2D, GLenum, target, GLint, level, GLenum, internalformat, GLint, x, GLint, y, GLsizei, width, GLsizei, height, GLint, border); \
  FuncWrapper6(void, glCopyTexSubImage1D, GLenum, target, GLint, level, GLint, xoffset, GLint, x, GLint, y, GLsizei, width); \
  FuncWrapper8(void, glCopyTexSubImage2D, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  FuncWrapper3(void, glTexParameterf, GLenum, target, GLenum, pname, GLfloat, param); \
  FuncWrapper3(void, glTexParameterfv, GLenum, target, GLenum, pname, const GLfloat *, params); \
  FuncWrapper3(void, glTexParameteri, GLenum, target, GLenum, pname, GLint, param); \
  FuncWrapper3(void, glTexParameteriv, GLenum, target, GLenum, pname, const GLint *, params); \
  FuncWrapper4(void, glViewport, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  FuncWrapper1(void, glActiveTexture, GLenum, texture); \
  AliasWrapper1(void, glActiveTextureARB, glActiveTexture, GLenum, texture); \
  FuncWrapper4(void, glTexStorage1D, GLenum, target, GLsizei, levels, GLenum, internalformat, GLsizei, width); \
  AliasWrapper4(void, glTexStorage1DEXT, glTexStorage1D, GLenum, target, GLsizei, levels, GLenum, internalformat, GLsizei, width); \
  FuncWrapper5(void, glTexStorage2D, GLenum, target, GLsizei, levels, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  AliasWrapper5(void, glTexStorage2DEXT, glTexStorage2D, GLenum, target, GLsizei, levels, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  FuncWrapper6(void, glTexStorage3D, GLenum, target, GLsizei, levels, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth); \
  AliasWrapper6(void, glTexStorage3DEXT, glTexStorage3D, GLenum, target, GLsizei, levels, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth); \
  FuncWrapper6(void, glTexStorage2DMultisample, GLenum, target, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height, GLboolean, fixedsamplelocations); \
  FuncWrapper7(void, glTexStorage3DMultisample, GLenum, target, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLboolean, fixedsamplelocations); \
  AliasWrapper7(void, glTexStorage3DMultisampleOES, glTexStorage3DMultisample, GLenum, target, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLboolean, fixedsamplelocations); \
  FuncWrapper10(void, glTexImage3D, GLenum, target, GLint, level, GLint, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLint, border, GLenum, format, GLenum, type, const void *, pixels); \
  AliasWrapper10(void, glTexImage3DEXT, glTexImage3D, GLenum, target, GLint, level, GLint, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLint, border, GLenum, format, GLenum, type, const void *, pixels); \
  AliasWrapper10(void, glTexImage3DOES, glTexImage3D, GLenum, target, GLint, level, GLint, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLint, border, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper11(void, glTexSubImage3D, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLenum, type, const void *, pixels); \
  AliasWrapper11(void, glTexSubImage3DOES, glTexSubImage3D, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper3(void, glTexBuffer, GLenum, target, GLenum, internalformat, GLuint, buffer); \
  AliasWrapper3(void, glTexBufferARB, glTexBuffer, GLenum, target, GLenum, internalformat, GLuint, buffer); \
  AliasWrapper3(void, glTexBufferEXT, glTexBuffer, GLenum, target, GLenum, internalformat, GLuint, buffer); \
  AliasWrapper3(void, glTexBufferOES, glTexBuffer, GLenum, target, GLenum, internalformat, GLuint, buffer); \
  FuncWrapper6(void, glTexImage2DMultisample, GLenum, target, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height, GLboolean, fixedsamplelocations); \
  FuncWrapper7(void, glTexImage3DMultisample, GLenum, target, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLboolean, fixedsamplelocations); \
  FuncWrapper7(void, glCompressedTexImage1D, GLenum, target, GLint, level, GLenum, internalformat, GLsizei, width, GLint, border, GLsizei, imageSize, const void *, data); \
  AliasWrapper7(void, glCompressedTexImage1DARB, glCompressedTexImage1D, GLenum, target, GLint, level, GLenum, internalformat, GLsizei, width, GLint, border, GLsizei, imageSize, const void *, data); \
  FuncWrapper8(void, glCompressedTexImage2D, GLenum, target, GLint, level, GLenum, internalformat, GLsizei, width, GLsizei, height, GLint, border, GLsizei, imageSize, const void *, data); \
  AliasWrapper8(void, glCompressedTexImage2DARB, glCompressedTexImage2D, GLenum, target, GLint, level, GLenum, internalformat, GLsizei, width, GLsizei, height, GLint, border, GLsizei, imageSize, const void *, data); \
  FuncWrapper9(void, glCompressedTexImage3D, GLenum, target, GLint, level, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLint, border, GLsizei, imageSize, const void *, data); \
  AliasWrapper9(void, glCompressedTexImage3DARB, glCompressedTexImage3D, GLenum, target, GLint, level, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLint, border, GLsizei, imageSize, const void *, data); \
  AliasWrapper9(void, glCompressedTexImage3DOES, glCompressedTexImage3D, GLenum, target, GLint, level, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLint, border, GLsizei, imageSize, const void *, data); \
  FuncWrapper7(void, glCompressedTexSubImage1D, GLenum, target, GLint, level, GLint, xoffset, GLsizei, width, GLenum, format, GLsizei, imageSize, const void *, data); \
  AliasWrapper7(void, glCompressedTexSubImage1DARB, glCompressedTexSubImage1D, GLenum, target, GLint, level, GLint, xoffset, GLsizei, width, GLenum, format, GLsizei, imageSize, const void *, data); \
  FuncWrapper9(void, glCompressedTexSubImage2D, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLsizei, width, GLsizei, height, GLenum, format, GLsizei, imageSize, const void *, data); \
  AliasWrapper9(void, glCompressedTexSubImage2DARB, glCompressedTexSubImage2D, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLsizei, width, GLsizei, height, GLenum, format, GLsizei, imageSize, const void *, data); \
  FuncWrapper11(void, glCompressedTexSubImage3D, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLsizei, imageSize, const void *, data); \
  AliasWrapper11(void, glCompressedTexSubImage3DARB, glCompressedTexSubImage3D, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLsizei, imageSize, const void *, data); \
  AliasWrapper11(void, glCompressedTexSubImage3DOES, glCompressedTexSubImage3D, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLsizei, imageSize, const void *, data); \
  FuncWrapper5(void, glTexBufferRange, GLenum, target, GLenum, internalformat, GLuint, buffer, GLintptr, offset, GLsizeiptr, size); \
  AliasWrapper5(void, glTexBufferRangeEXT, glTexBufferRange, GLenum, target, GLenum, internalformat, GLuint, buffer, GLintptr, offset, GLsizeiptr, size); \
  AliasWrapper5(void, glTexBufferRangeOES, glTexBufferRange, GLenum, target, GLenum, internalformat, GLuint, buffer, GLintptr, offset, GLsizeiptr, size); \
  FuncWrapper8(void, glTextureView, GLuint, texture, GLenum, target, GLuint, origtexture, GLenum, internalformat, GLuint, minlevel, GLuint, numlevels, GLuint, minlayer, GLuint, numlayers); \
  AliasWrapper8(void, glTextureViewOES, glTextureView, GLuint, texture, GLenum, target, GLuint, origtexture, GLenum, internalformat, GLuint, minlevel, GLuint, numlevels, GLuint, minlayer, GLuint, numlayers); \
  AliasWrapper8(void, glTextureViewEXT, glTextureView, GLuint, texture, GLenum, target, GLuint, origtexture, GLenum, internalformat, GLuint, minlevel, GLuint, numlevels, GLuint, minlayer, GLuint, numlayers); \
  FuncWrapper3(void, glTexParameterIiv, GLenum, target, GLenum, pname, const GLint *, params); \
  AliasWrapper3(void, glTexParameterIivEXT, glTexParameterIiv, GLenum, target, GLenum, pname, const GLint *, params); \
  AliasWrapper3(void, glTexParameterIivOES, glTexParameterIiv, GLenum, target, GLenum, pname, const GLint *, params); \
  FuncWrapper3(void, glTexParameterIuiv, GLenum, target, GLenum, pname, const GLuint *, params); \
  AliasWrapper3(void, glTexParameterIuivEXT, glTexParameterIuiv, GLenum, target, GLenum, pname, const GLuint *, params); \
  AliasWrapper3(void, glTexParameterIuivOES, glTexParameterIuiv, GLenum, target, GLenum, pname, const GLuint *, params); \
  FuncWrapper1(void, glGenerateMipmap, GLenum, target); \
  AliasWrapper1(void, glGenerateMipmapEXT, glGenerateMipmap, GLenum, target); \
  FuncWrapper15(void, glCopyImageSubData, GLuint, srcName, GLenum, srcTarget, GLint, srcLevel, GLint, srcX, GLint, srcY, GLint, srcZ, GLuint, dstName, GLenum, dstTarget, GLint, dstLevel, GLint, dstX, GLint, dstY, GLint, dstZ, GLsizei, srcWidth, GLsizei, srcHeight, GLsizei, srcDepth); \
  AliasWrapper15(void, glCopyImageSubDataEXT, glCopyImageSubData, GLuint, srcName, GLenum, srcTarget, GLint, srcLevel, GLint, srcX, GLint, srcY, GLint, srcZ, GLuint, dstName, GLenum, dstTarget, GLint, dstLevel, GLint, dstX, GLint, dstY, GLint, dstZ, GLsizei, srcWidth, GLsizei, srcHeight, GLsizei, srcDepth); \
  AliasWrapper15(void, glCopyImageSubDataOES, glCopyImageSubData, GLuint, srcName, GLenum, srcTarget, GLint, srcLevel, GLint, srcX, GLint, srcY, GLint, srcZ, GLuint, dstName, GLenum, dstTarget, GLint, dstLevel, GLint, dstX, GLint, dstY, GLint, dstZ, GLsizei, srcWidth, GLsizei, srcHeight, GLsizei, srcDepth); \
  FuncWrapper9(void, glCopyTexSubImage3D, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  AliasWrapper9(void, glCopyTexSubImage3DOES, glCopyTexSubImage3D, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  FuncWrapper5(void, glGetInternalformativ, GLenum, target, GLenum, internalformat, GLenum, pname, GLsizei, bufSize, GLint *, params); \
  FuncWrapper5(void, glGetInternalformati64v, GLenum, target, GLenum, internalformat, GLenum, pname, GLsizei, bufSize, GLint64 *, params); \
  FuncWrapper3(void, glGetBufferParameteriv, GLenum, target, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetBufferParameterivARB, glGetBufferParameteriv, GLenum, target, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetBufferParameteri64v, GLenum, target, GLenum, pname, GLint64 *, params); \
  FuncWrapper3(void, glGetBufferPointerv, GLenum, target, GLenum, pname, void **, params); \
  AliasWrapper3(void, glGetBufferPointervARB, glGetBufferPointerv, GLenum, target, GLenum, pname, void **, params); \
  AliasWrapper3(void, glGetBufferPointervOES, glGetBufferPointerv, GLenum, target, GLenum, pname, void **, params); \
  FuncWrapper2(GLint, glGetFragDataIndex, GLuint, program, const GLchar *, name); \
  FuncWrapper2(GLint, glGetFragDataLocation, GLuint, program, const GLchar *, name); \
  AliasWrapper2(GLint, glGetFragDataLocationEXT, glGetFragDataLocation, GLuint, program, const GLchar *, name); \
  FuncWrapper2(const GLubyte *, glGetStringi, GLenum, name, GLuint, index); \
  FuncWrapper3(void, glGetBooleani_v, GLenum, target, GLuint, index, GLboolean *, data); \
  FuncWrapper3(void, glGetIntegeri_v, GLenum, target, GLuint, index, GLint *, data); \
  FuncWrapper3(void, glGetFloati_v, GLenum, target, GLuint, index, GLfloat *, data); \
  AliasWrapper3(void, glGetFloati_vEXT, glGetFloati_v, GLenum, target, GLuint, index, GLfloat *, data); \
  AliasWrapper3(void, glGetFloati_vOES, glGetFloati_v, GLenum, target, GLuint, index, GLfloat *, data); \
  AliasWrapper3(void, glGetFloati_vNV, glGetFloati_v, GLenum, target, GLuint, index, GLfloat *, data); \
  FuncWrapper3(void, glGetDoublei_v, GLenum, target, GLuint, index, GLdouble *, data); \
  AliasWrapper3(void, glGetDoublei_vEXT, glGetDoublei_v, GLenum, target, GLuint, index, GLdouble *, data); \
  FuncWrapper3(void, glGetInteger64i_v, GLenum, target, GLuint, index, GLint64 *, data); \
  FuncWrapper2(void, glGetInteger64v, GLenum, pname, GLint64 *, data); \
  FuncWrapper3(void, glGetShaderiv, GLuint, shader, GLenum, pname, GLint *, params); \
  FuncWrapper4(void, glGetShaderInfoLog, GLuint, shader, GLsizei, bufSize, GLsizei *, length, GLchar *, infoLog); \
  FuncWrapper4(void, glGetShaderPrecisionFormat, GLenum, shadertype, GLenum, precisiontype, GLint *, range, GLint *, precision); \
  FuncWrapper4(void, glGetShaderSource, GLuint, shader, GLsizei, bufSize, GLsizei *, length, GLchar *, source); \
  FuncWrapper4(void, glGetAttachedShaders, GLuint, program, GLsizei, maxCount, GLsizei *, count, GLuint *, shaders); \
  FuncWrapper3(void, glGetProgramiv, GLuint, program, GLenum, pname, GLint *, params); \
  FuncWrapper4(void, glGetProgramInfoLog, GLuint, program, GLsizei, bufSize, GLsizei *, length, GLchar *, infoLog); \
  FuncWrapper4(void, glGetProgramInterfaceiv, GLuint, program, GLenum, programInterface, GLenum, pname, GLint *, params); \
  FuncWrapper3(GLuint, glGetProgramResourceIndex, GLuint, program, GLenum, programInterface, const GLchar *, name); \
  FuncWrapper8(void, glGetProgramResourceiv, GLuint, program, GLenum, programInterface, GLuint, index, GLsizei, propCount, const GLenum *, props, GLsizei, bufSize, GLsizei *, length, GLint *, params); \
  FuncWrapper6(void, glGetProgramResourceName, GLuint, program, GLenum, programInterface, GLuint, index, GLsizei, bufSize, GLsizei *, length, GLchar *, name); \
  FuncWrapper3(void, glGetProgramPipelineiv, GLuint, pipeline, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetProgramPipelineivEXT, glGetProgramPipelineiv, GLuint, pipeline, GLenum, pname, GLint *, params); \
  FuncWrapper4(void, glGetProgramPipelineInfoLog, GLuint, pipeline, GLsizei, bufSize, GLsizei *, length, GLchar *, infoLog); \
  AliasWrapper4(void, glGetProgramPipelineInfoLogEXT, glGetProgramPipelineInfoLog, GLuint, pipeline, GLsizei, bufSize, GLsizei *, length, GLchar *, infoLog); \
  FuncWrapper5(void, glGetProgramBinary, GLuint, program, GLsizei, bufSize, GLsizei *, length, GLenum *, binaryFormat, void *, binary); \
  FuncWrapper3(GLint, glGetProgramResourceLocation, GLuint, program, GLenum, programInterface, const GLchar *, name); \
  FuncWrapper3(GLint, glGetProgramResourceLocationIndex, GLuint, program, GLenum, programInterface, const GLchar *, name); \
  FuncWrapper4(void, glGetProgramStageiv, GLuint, program, GLenum, shadertype, GLenum, pname, GLint *, values); \
  FuncWrapper0(GLenum, glGetGraphicsResetStatus); \
  AliasWrapper0(GLenum, glGetGraphicsResetStatusARB, glGetGraphicsResetStatus); \
  AliasWrapper0(GLenum, glGetGraphicsResetStatusEXT, glGetGraphicsResetStatus); \
  FuncWrapper5(void, glGetObjectLabel, GLenum, identifier, GLuint, name, GLsizei, bufSize, GLsizei *, length, GLchar *, label); \
  AliasWrapper5(void, glGetObjectLabelKHR, glGetObjectLabel, GLenum, identifier, GLuint, name, GLsizei, bufSize, GLsizei *, length, GLchar *, label); \
  FuncWrapper5(void, glGetObjectLabelEXT, GLenum, type, GLuint, object, GLsizei, bufSize, GLsizei *, length, GLchar *, label); \
  FuncWrapper4(void, glGetObjectPtrLabel, const void *, ptr, GLsizei, bufSize, GLsizei *, length, GLchar *, label); \
  AliasWrapper4(void, glGetObjectPtrLabelKHR, glGetObjectPtrLabel, const void *, ptr, GLsizei, bufSize, GLsizei *, length, GLchar *, label); \
  FuncWrapper8(GLuint, glGetDebugMessageLog, GLuint, count, GLsizei, bufSize, GLenum *, sources, GLenum *, types, GLuint *, ids, GLenum *, severities, GLsizei *, lengths, GLchar *, messageLog); \
  AliasWrapper8(GLuint, glGetDebugMessageLogARB, glGetDebugMessageLog, GLuint, count, GLsizei, bufSize, GLenum *, sources, GLenum *, types, GLuint *, ids, GLenum *, severities, GLsizei *, lengths, GLchar *, messageLog); \
  AliasWrapper8(GLuint, glGetDebugMessageLogKHR, glGetDebugMessageLog, GLuint, count, GLsizei, bufSize, GLenum *, sources, GLenum *, types, GLuint *, ids, GLenum *, severities, GLsizei *, lengths, GLchar *, messageLog); \
  FuncWrapper4(void, glGetFramebufferAttachmentParameteriv, GLenum, target, GLenum, attachment, GLenum, pname, GLint *, params); \
  AliasWrapper4(void, glGetFramebufferAttachmentParameterivEXT, glGetFramebufferAttachmentParameteriv, GLenum, target, GLenum, attachment, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetFramebufferParameteriv, GLenum, target, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetRenderbufferParameteriv, GLenum, target, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetRenderbufferParameterivEXT, glGetRenderbufferParameteriv, GLenum, target, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetMultisamplefv, GLenum, pname, GLuint, index, GLfloat *, val); \
  FuncWrapper4(void, glGetQueryIndexediv, GLenum, target, GLuint, index, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetQueryObjectui64v, GLuint, id, GLenum, pname, GLuint64 *, params); \
  AliasWrapper3(void, glGetQueryObjectui64vEXT, glGetQueryObjectui64v, GLuint, id, GLenum, pname, GLuint64 *, params); \
  FuncWrapper3(void, glGetQueryObjectuiv, GLuint, id, GLenum, pname, GLuint *, params); \
  AliasWrapper3(void, glGetQueryObjectuivARB, glGetQueryObjectuiv, GLuint, id, GLenum, pname, GLuint *, params); \
  AliasWrapper3(void, glGetQueryObjectuivEXT, glGetQueryObjectuiv, GLuint, id, GLenum, pname, GLuint *, params); \
  FuncWrapper3(void, glGetQueryObjecti64v, GLuint, id, GLenum, pname, GLint64 *, params); \
  AliasWrapper3(void, glGetQueryObjecti64vEXT, glGetQueryObjecti64v, GLuint, id, GLenum, pname, GLint64 *, params); \
  FuncWrapper3(void, glGetQueryObjectiv, GLuint, id, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetQueryObjectivARB, glGetQueryObjectiv, GLuint, id, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetQueryObjectivEXT, glGetQueryObjectiv, GLuint, id, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetQueryiv, GLenum, target, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetQueryivARB, glGetQueryiv, GLenum, target, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetQueryivEXT, glGetQueryiv, GLenum, target, GLenum, pname, GLint *, params); \
  FuncWrapper5(void, glGetSynciv, GLsync, sync, GLenum, pname, GLsizei, bufSize, GLsizei *, length, GLint *, values); \
  FuncWrapper4(void, glGetBufferSubData, GLenum, target, GLintptr, offset, GLsizeiptr, size, void *, data); \
  AliasWrapper4(void, glGetBufferSubDataARB, glGetBufferSubData, GLenum, target, GLintptr, offset, GLsizeiptr, size, void *, data); \
  FuncWrapper3(void, glGetVertexAttribiv, GLuint, index, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetVertexAttribPointerv, GLuint, index, GLenum, pname, void **, pointer); \
  FuncWrapper3(void, glGetCompressedTexImage, GLenum, target, GLint, level, void *, img); \
  AliasWrapper3(void, glGetCompressedTexImageARB, glGetCompressedTexImage, GLenum, target, GLint, level, void *, img); \
  FuncWrapper4(void, glGetnCompressedTexImage, GLenum, target, GLint, lod, GLsizei, bufSize, void *, pixels); \
  AliasWrapper4(void, glGetnCompressedTexImageARB, glGetnCompressedTexImage, GLenum, target, GLint, lod, GLsizei, bufSize, void *, pixels); \
  FuncWrapper6(void, glGetnTexImage, GLenum, target, GLint, level, GLenum, format, GLenum, type, GLsizei, bufSize, void *, pixels); \
  AliasWrapper6(void, glGetnTexImageARB, glGetnTexImage, GLenum, target, GLint, level, GLenum, format, GLenum, type, GLsizei, bufSize, void *, pixels); \
  FuncWrapper3(void, glGetTexParameterIiv, GLenum, target, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetTexParameterIivEXT, glGetTexParameterIiv, GLenum, target, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetTexParameterIivOES, glGetTexParameterIiv, GLenum, target, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetTexParameterIuiv, GLenum, target, GLenum, pname, GLuint *, params); \
  AliasWrapper3(void, glGetTexParameterIuivEXT, glGetTexParameterIuiv, GLenum, target, GLenum, pname, GLuint *, params); \
  AliasWrapper3(void, glGetTexParameterIuivOES, glGetTexParameterIuiv, GLenum, target, GLenum, pname, GLuint *, params); \
  FuncWrapper2(void, glClampColor, GLenum, target, GLenum, clamp); \
  AliasWrapper2(void, glClampColorARB, glClampColor, GLenum, target, GLenum, clamp); \
  FuncWrapper8(void, glReadnPixels, GLint, x, GLint, y, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, GLsizei, bufSize, void *, data); \
  AliasWrapper8(void, glReadnPixelsARB, glReadnPixels, GLint, x, GLint, y, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, GLsizei, bufSize, void *, data); \
  AliasWrapper8(void, glReadnPixelsEXT, glReadnPixels, GLint, x, GLint, y, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, GLsizei, bufSize, void *, data); \
  FuncWrapper3(void, glGetSamplerParameterIiv, GLuint, sampler, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetSamplerParameterIivEXT, glGetSamplerParameterIiv, GLuint, sampler, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetSamplerParameterIivOES, glGetSamplerParameterIiv, GLuint, sampler, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetSamplerParameterIuiv, GLuint, sampler, GLenum, pname, GLuint *, params); \
  AliasWrapper3(void, glGetSamplerParameterIuivEXT, glGetSamplerParameterIuiv, GLuint, sampler, GLenum, pname, GLuint *, params); \
  AliasWrapper3(void, glGetSamplerParameterIuivOES, glGetSamplerParameterIuiv, GLuint, sampler, GLenum, pname, GLuint *, params); \
  FuncWrapper3(void, glGetSamplerParameterfv, GLuint, sampler, GLenum, pname, GLfloat *, params); \
  FuncWrapper3(void, glGetSamplerParameteriv, GLuint, sampler, GLenum, pname, GLint *, params); \
  FuncWrapper7(void, glGetTransformFeedbackVarying, GLuint, program, GLuint, index, GLsizei, bufSize, GLsizei *, length, GLsizei *, size, GLenum *, type, GLchar *, name); \
  AliasWrapper7(void, glGetTransformFeedbackVaryingEXT, glGetTransformFeedbackVarying, GLuint, program, GLuint, index, GLsizei, bufSize, GLsizei *, length, GLsizei *, size, GLenum *, type, GLchar *, name); \
  FuncWrapper3(GLuint, glGetSubroutineIndex, GLuint, program, GLenum, shadertype, const GLchar *, name); \
  FuncWrapper3(GLint, glGetSubroutineUniformLocation, GLuint, program, GLenum, shadertype, const GLchar *, name); \
  FuncWrapper4(void, glGetActiveAtomicCounterBufferiv, GLuint, program, GLuint, bufferIndex, GLenum, pname, GLint *, params); \
  FuncWrapper6(void, glGetActiveSubroutineName, GLuint, program, GLenum, shadertype, GLuint, index, GLsizei, bufsize, GLsizei *, length, GLchar *, name); \
  FuncWrapper6(void, glGetActiveSubroutineUniformName, GLuint, program, GLenum, shadertype, GLuint, index, GLsizei, bufsize, GLsizei *, length, GLchar *, name); \
  FuncWrapper5(void, glGetActiveSubroutineUniformiv, GLuint, program, GLenum, shadertype, GLuint, index, GLenum, pname, GLint *, values); \
  FuncWrapper2(GLint, glGetUniformLocation, GLuint, program, const GLchar *, name); \
  FuncWrapper4(void, glGetUniformIndices, GLuint, program, GLsizei, uniformCount, const GLchar *const*, uniformNames, GLuint *, uniformIndices); \
  FuncWrapper3(void, glGetUniformSubroutineuiv, GLenum, shadertype, GLint, location, GLuint *, params); \
  FuncWrapper2(GLuint, glGetUniformBlockIndex, GLuint, program, const GLchar *, uniformBlockName); \
  FuncWrapper2(GLint, glGetAttribLocation, GLuint, program, const GLchar *, name); \
  FuncWrapper7(void, glGetActiveUniform, GLuint, program, GLuint, index, GLsizei, bufSize, GLsizei *, length, GLint *, size, GLenum *, type, GLchar *, name); \
  FuncWrapper5(void, glGetActiveUniformName, GLuint, program, GLuint, uniformIndex, GLsizei, bufSize, GLsizei *, length, GLchar *, uniformName); \
  FuncWrapper5(void, glGetActiveUniformBlockName, GLuint, program, GLuint, uniformBlockIndex, GLsizei, bufSize, GLsizei *, length, GLchar *, uniformBlockName); \
  FuncWrapper4(void, glGetActiveUniformBlockiv, GLuint, program, GLuint, uniformBlockIndex, GLenum, pname, GLint *, params); \
  FuncWrapper5(void, glGetActiveUniformsiv, GLuint, program, GLsizei, uniformCount, const GLuint *, uniformIndices, GLenum, pname, GLint *, params); \
  FuncWrapper7(void, glGetActiveAttrib, GLuint, program, GLuint, index, GLsizei, bufSize, GLsizei *, length, GLint *, size, GLenum *, type, GLchar *, name); \
  FuncWrapper3(void, glGetUniformfv, GLuint, program, GLint, location, GLfloat *, params); \
  FuncWrapper3(void, glGetUniformiv, GLuint, program, GLint, location, GLint *, params); \
  FuncWrapper3(void, glGetUniformuiv, GLuint, program, GLint, location, GLuint *, params); \
  AliasWrapper3(void, glGetUniformuivEXT, glGetUniformuiv, GLuint, program, GLint, location, GLuint *, params); \
  FuncWrapper3(void, glGetUniformdv, GLuint, program, GLint, location, GLdouble *, params); \
  FuncWrapper4(void, glGetnUniformdv, GLuint, program, GLint, location, GLsizei, bufSize, GLdouble *, params); \
  AliasWrapper4(void, glGetnUniformdvARB, glGetnUniformdv, GLuint, program, GLint, location, GLsizei, bufSize, GLdouble *, params); \
  FuncWrapper4(void, glGetnUniformfv, GLuint, program, GLint, location, GLsizei, bufSize, GLfloat *, params); \
  AliasWrapper4(void, glGetnUniformfvARB, glGetnUniformfv, GLuint, program, GLint, location, GLsizei, bufSize, GLfloat *, params); \
  AliasWrapper4(void, glGetnUniformfvEXT, glGetnUniformfv, GLuint, program, GLint, location, GLsizei, bufSize, GLfloat *, params); \
  FuncWrapper4(void, glGetnUniformiv, GLuint, program, GLint, location, GLsizei, bufSize, GLint *, params); \
  AliasWrapper4(void, glGetnUniformivARB, glGetnUniformiv, GLuint, program, GLint, location, GLsizei, bufSize, GLint *, params); \
  AliasWrapper4(void, glGetnUniformivEXT, glGetnUniformiv, GLuint, program, GLint, location, GLsizei, bufSize, GLint *, params); \
  FuncWrapper4(void, glGetnUniformuiv, GLuint, program, GLint, location, GLsizei, bufSize, GLuint *, params); \
  AliasWrapper4(void, glGetnUniformuivARB, glGetnUniformuiv, GLuint, program, GLint, location, GLsizei, bufSize, GLuint *, params); \
  FuncWrapper3(void, glGetVertexAttribIiv, GLuint, index, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetVertexAttribIivEXT, glGetVertexAttribIiv, GLuint, index, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetVertexAttribIuiv, GLuint, index, GLenum, pname, GLuint *, params); \
  AliasWrapper3(void, glGetVertexAttribIuivEXT, glGetVertexAttribIuiv, GLuint, index, GLenum, pname, GLuint *, params); \
  FuncWrapper3(void, glGetVertexAttribLdv, GLuint, index, GLenum, pname, GLdouble *, params); \
  AliasWrapper3(void, glGetVertexAttribLdvEXT, glGetVertexAttribLdv, GLuint, index, GLenum, pname, GLdouble *, params); \
  FuncWrapper3(void, glGetVertexAttribdv, GLuint, index, GLenum, pname, GLdouble *, params); \
  FuncWrapper3(void, glGetVertexAttribfv, GLuint, index, GLenum, pname, GLfloat *, params); \
  FuncWrapper1(GLenum, glCheckFramebufferStatus, GLenum, target); \
  AliasWrapper1(GLenum, glCheckFramebufferStatusEXT, glCheckFramebufferStatus, GLenum, target); \
  FuncWrapper4(void, glBlendColor, GLfloat, red, GLfloat, green, GLfloat, blue, GLfloat, alpha); \
  AliasWrapper4(void, glBlendColorEXT, glBlendColor, GLfloat, red, GLfloat, green, GLfloat, blue, GLfloat, alpha); \
  FuncWrapper3(void, glBlendFunci, GLuint, buf, GLenum, src, GLenum, dst); \
  AliasWrapper3(void, glBlendFunciARB, glBlendFunci, GLuint, buf, GLenum, src, GLenum, dst); \
  AliasWrapper3(void, glBlendFunciEXT, glBlendFunci, GLuint, buf, GLenum, src, GLenum, dst); \
  AliasWrapper3(void, glBlendFunciOES, glBlendFunci, GLuint, buf, GLenum, src, GLenum, dst); \
  FuncWrapper4(void, glBlendFuncSeparate, GLenum, sfactorRGB, GLenum, dfactorRGB, GLenum, sfactorAlpha, GLenum, dfactorAlpha); \
  AliasWrapper4(void, glBlendFuncSeparateARB, glBlendFuncSeparate, GLenum, sfactorRGB, GLenum, dfactorRGB, GLenum, sfactorAlpha, GLenum, dfactorAlpha); \
  FuncWrapper5(void, glBlendFuncSeparatei, GLuint, buf, GLenum, srcRGB, GLenum, dstRGB, GLenum, srcAlpha, GLenum, dstAlpha); \
  AliasWrapper5(void, glBlendFuncSeparateiARB, glBlendFuncSeparatei, GLuint, buf, GLenum, srcRGB, GLenum, dstRGB, GLenum, srcAlpha, GLenum, dstAlpha); \
  AliasWrapper5(void, glBlendFuncSeparateiEXT, glBlendFuncSeparatei, GLuint, buf, GLenum, srcRGB, GLenum, dstRGB, GLenum, srcAlpha, GLenum, dstAlpha); \
  AliasWrapper5(void, glBlendFuncSeparateiOES, glBlendFuncSeparatei, GLuint, buf, GLenum, srcRGB, GLenum, dstRGB, GLenum, srcAlpha, GLenum, dstAlpha); \
  FuncWrapper1(void, glBlendEquation, GLenum, mode); \
  AliasWrapper1(void, glBlendEquationEXT, glBlendEquation, GLenum, mode); \
  AliasWrapper1(void, glBlendEquationARB, glBlendEquation, GLenum, mode); \
  FuncWrapper2(void, glBlendEquationi, GLuint, buf, GLenum, mode); \
  AliasWrapper2(void, glBlendEquationiARB, glBlendEquationi, GLuint, buf, GLenum, mode); \
  AliasWrapper2(void, glBlendEquationiEXT, glBlendEquationi, GLuint, buf, GLenum, mode); \
  AliasWrapper2(void, glBlendEquationiOES, glBlendEquationi, GLuint, buf, GLenum, mode); \
  FuncWrapper2(void, glBlendEquationSeparate, GLenum, modeRGB, GLenum, modeAlpha); \
  AliasWrapper2(void, glBlendEquationSeparateARB, glBlendEquationSeparate, GLenum, modeRGB, GLenum, modeAlpha); \
  AliasWrapper2(void, glBlendEquationSeparateEXT, glBlendEquationSeparate, GLenum, modeRGB, GLenum, modeAlpha); \
  FuncWrapper3(void, glBlendEquationSeparatei, GLuint, buf, GLenum, modeRGB, GLenum, modeAlpha); \
  AliasWrapper3(void, glBlendEquationSeparateiARB, glBlendEquationSeparatei, GLuint, buf, GLenum, modeRGB, GLenum, modeAlpha); \
  AliasWrapper3(void, glBlendEquationSeparateiEXT, glBlendEquationSeparatei, GLuint, buf, GLenum, modeRGB, GLenum, modeAlpha); \
  AliasWrapper3(void, glBlendEquationSeparateiOES, glBlendEquationSeparatei, GLuint, buf, GLenum, modeRGB, GLenum, modeAlpha); \
  FuncWrapper0(void, glBlendBarrierKHR); \
  FuncWrapper4(void, glStencilFuncSeparate, GLenum, face, GLenum, func, GLint, ref, GLuint, mask); \
  FuncWrapper2(void, glStencilMaskSeparate, GLenum, face, GLuint, mask); \
  FuncWrapper4(void, glStencilOpSeparate, GLenum, face, GLenum, sfail, GLenum, dpfail, GLenum, dppass); \
  FuncWrapper5(void, glColorMaski, GLuint, index, GLboolean, r, GLboolean, g, GLboolean, b, GLboolean, a); \
  AliasWrapper5(void, glColorMaskiEXT, glColorMaski, GLuint, index, GLboolean, r, GLboolean, g, GLboolean, b, GLboolean, a); \
  AliasWrapper5(void, glColorMaskIndexedEXT, glColorMaski, GLuint, index, GLboolean, r, GLboolean, g, GLboolean, b, GLboolean, a); \
  AliasWrapper5(void, glColorMaskiOES, glColorMaski, GLuint, index, GLboolean, r, GLboolean, g, GLboolean, b, GLboolean, a); \
  FuncWrapper2(void, glSampleMaski, GLuint, maskNumber, GLbitfield, mask); \
  FuncWrapper2(void, glSampleCoverage, GLfloat, value, GLboolean, invert); \
  AliasWrapper2(void, glSampleCoverageARB, glSampleCoverage, GLfloat, value, GLboolean, invert); \
  FuncWrapper1(void, glMinSampleShading, GLfloat, value); \
  AliasWrapper1(void, glMinSampleShadingARB, glMinSampleShading, GLfloat, value); \
  AliasWrapper1(void, glMinSampleShadingOES, glMinSampleShading, GLfloat, value); \
  FuncWrapper2(void, glDepthRangef, GLfloat, n, GLfloat, f); \
  FuncWrapper3(void, glDepthRangeIndexed, GLuint, index, GLdouble, n, GLdouble, f); \
  FuncWrapper3(void, glDepthRangeArrayv, GLuint, first, GLsizei, count, const GLdouble *, v); \
  FuncWrapper2(void, glClipControl, GLenum, origin, GLenum, depth); \
  FuncWrapper1(void, glProvokingVertex, GLenum, mode); \
  AliasWrapper1(void, glProvokingVertexEXT, glProvokingVertex, GLenum, mode); \
  FuncWrapper1(void, glPrimitiveRestartIndex, GLuint, index); \
  FuncWrapper1(GLuint, glCreateShader, GLenum, type); \
  FuncWrapper1(void, glDeleteShader, GLuint, shader); \
  FuncWrapper4(void, glShaderSource, GLuint, shader, GLsizei, count, const GLchar *const*, string, const GLint *, length); \
  FuncWrapper1(void, glCompileShader, GLuint, shader); \
  FuncWrapper3(GLuint, glCreateShaderProgramv, GLenum, type, GLsizei, count, const GLchar *const*, strings); \
  AliasWrapper3(GLuint, glCreateShaderProgramvEXT, glCreateShaderProgramv, GLenum, type, GLsizei, count, const GLchar *const*, strings); \
  FuncWrapper0(GLuint, glCreateProgram); \
  FuncWrapper1(void, glDeleteProgram, GLuint, program); \
  FuncWrapper2(void, glAttachShader, GLuint, program, GLuint, shader); \
  FuncWrapper2(void, glDetachShader, GLuint, program, GLuint, shader); \
  FuncWrapper0(void, glReleaseShaderCompiler); \
  FuncWrapper1(void, glLinkProgram, GLuint, program); \
  FuncWrapper3(void, glProgramParameteri, GLuint, program, GLenum, pname, GLint, value); \
  AliasWrapper3(void, glProgramParameteriARB, glProgramParameteri, GLuint, program, GLenum, pname, GLint, value); \
  AliasWrapper3(void, glProgramParameteriEXT, glProgramParameteri, GLuint, program, GLenum, pname, GLint, value); \
  FuncWrapper1(void, glUseProgram, GLuint, program); \
  FuncWrapper5(void, glShaderBinary, GLsizei, count, const GLuint *, shaders, GLenum, binaryformat, const void *, binary, GLsizei, length); \
  FuncWrapper4(void, glProgramBinary, GLuint, program, GLenum, binaryFormat, const void *, binary, GLsizei, length); \
  FuncWrapper3(void, glUseProgramStages, GLuint, pipeline, GLbitfield, stages, GLuint, program); \
  AliasWrapper3(void, glUseProgramStagesEXT, glUseProgramStages, GLuint, pipeline, GLbitfield, stages, GLuint, program); \
  FuncWrapper1(void, glValidateProgram, GLuint, program); \
  FuncWrapper2(void, glGenProgramPipelines, GLsizei, n, GLuint *, pipelines); \
  AliasWrapper2(void, glGenProgramPipelinesEXT, glGenProgramPipelines, GLsizei, n, GLuint *, pipelines); \
  FuncWrapper1(void, glBindProgramPipeline, GLuint, pipeline); \
  AliasWrapper1(void, glBindProgramPipelineEXT, glBindProgramPipeline, GLuint, pipeline); \
  FuncWrapper2(void, glActiveShaderProgram, GLuint, pipeline, GLuint, program); \
  AliasWrapper2(void, glActiveShaderProgramEXT, glActiveShaderProgram, GLuint, pipeline, GLuint, program); \
  FuncWrapper2(void, glDeleteProgramPipelines, GLsizei, n, const GLuint *, pipelines); \
  AliasWrapper2(void, glDeleteProgramPipelinesEXT, glDeleteProgramPipelines, GLsizei, n, const GLuint *, pipelines); \
  FuncWrapper1(void, glValidateProgramPipeline, GLuint, pipeline); \
  AliasWrapper1(void, glValidateProgramPipelineEXT, glValidateProgramPipeline, GLuint, pipeline); \
  FuncWrapper2(void, glDebugMessageCallback, GLDEBUGPROC, callback, const void *, userParam); \
  AliasWrapper2(void, glDebugMessageCallbackARB, glDebugMessageCallback, GLDEBUGPROC, callback, const void *, userParam); \
  AliasWrapper2(void, glDebugMessageCallbackKHR, glDebugMessageCallback, GLDEBUGPROC, callback, const void *, userParam); \
  FuncWrapper6(void, glDebugMessageControl, GLenum, source, GLenum, type, GLenum, severity, GLsizei, count, const GLuint *, ids, GLboolean, enabled); \
  AliasWrapper6(void, glDebugMessageControlARB, glDebugMessageControl, GLenum, source, GLenum, type, GLenum, severity, GLsizei, count, const GLuint *, ids, GLboolean, enabled); \
  AliasWrapper6(void, glDebugMessageControlKHR, glDebugMessageControl, GLenum, source, GLenum, type, GLenum, severity, GLsizei, count, const GLuint *, ids, GLboolean, enabled); \
  FuncWrapper6(void, glDebugMessageInsert, GLenum, source, GLenum, type, GLuint, id, GLenum, severity, GLsizei, length, const GLchar *, buf); \
  AliasWrapper6(void, glDebugMessageInsertARB, glDebugMessageInsert, GLenum, source, GLenum, type, GLuint, id, GLenum, severity, GLsizei, length, const GLchar *, buf); \
  AliasWrapper6(void, glDebugMessageInsertKHR, glDebugMessageInsert, GLenum, source, GLenum, type, GLuint, id, GLenum, severity, GLsizei, length, const GLchar *, buf); \
  FuncWrapper4(void, glPushDebugGroup, GLenum, source, GLuint, id, GLsizei, length, const GLchar *, message); \
  AliasWrapper4(void, glPushDebugGroupKHR, glPushDebugGroup, GLenum, source, GLuint, id, GLsizei, length, const GLchar *, message); \
  FuncWrapper0(void, glPopDebugGroup); \
  AliasWrapper0(void, glPopDebugGroupKHR, glPopDebugGroup); \
  FuncWrapper4(void, glObjectLabel, GLenum, identifier, GLuint, name, GLsizei, length, const GLchar *, label); \
  AliasWrapper4(void, glObjectLabelKHR, glObjectLabel, GLenum, identifier, GLuint, name, GLsizei, length, const GLchar *, label); \
  FuncWrapper4(void, glLabelObjectEXT, GLenum, type, GLuint, object, GLsizei, length, const GLchar *, label); \
  FuncWrapper3(void, glObjectPtrLabel, const void *, ptr, GLsizei, length, const GLchar *, label); \
  AliasWrapper3(void, glObjectPtrLabelKHR, glObjectPtrLabel, const void *, ptr, GLsizei, length, const GLchar *, label); \
  FuncWrapper2(void, glEnablei, GLenum, target, GLuint, index); \
  AliasWrapper2(void, glEnableiEXT, glEnablei, GLenum, target, GLuint, index); \
  AliasWrapper2(void, glEnableIndexedEXT, glEnablei, GLenum, target, GLuint, index); \
  AliasWrapper2(void, glEnableiOES, glEnablei, GLenum, target, GLuint, index); \
  AliasWrapper2(void, glEnableiNV, glEnablei, GLenum, target, GLuint, index); \
  FuncWrapper2(void, glDisablei, GLenum, target, GLuint, index); \
  AliasWrapper2(void, glDisableiEXT, glDisablei, GLenum, target, GLuint, index); \
  AliasWrapper2(void, glDisableIndexedEXT, glDisablei, GLenum, target, GLuint, index); \
  AliasWrapper2(void, glDisableiOES, glDisablei, GLenum, target, GLuint, index); \
  AliasWrapper2(void, glDisableiNV, glDisablei, GLenum, target, GLuint, index); \
  FuncWrapper2(GLboolean, glIsEnabledi, GLenum, target, GLuint, index); \
  AliasWrapper2(GLboolean, glIsEnablediEXT, glIsEnabledi, GLenum, target, GLuint, index); \
  AliasWrapper2(GLboolean, glIsEnabledIndexedEXT, glIsEnabledi, GLenum, target, GLuint, index); \
  AliasWrapper2(GLboolean, glIsEnablediOES, glIsEnabledi, GLenum, target, GLuint, index); \
  AliasWrapper2(GLboolean, glIsEnablediNV, glIsEnabledi, GLenum, target, GLuint, index); \
  FuncWrapper1(GLboolean, glIsBuffer, GLuint, buffer); \
  AliasWrapper1(GLboolean, glIsBufferARB, glIsBuffer, GLuint, buffer); \
  FuncWrapper1(GLboolean, glIsFramebuffer, GLuint, framebuffer); \
  AliasWrapper1(GLboolean, glIsFramebufferEXT, glIsFramebuffer, GLuint, framebuffer); \
  FuncWrapper1(GLboolean, glIsProgram, GLuint, program); \
  FuncWrapper1(GLboolean, glIsProgramPipeline, GLuint, pipeline); \
  AliasWrapper1(GLboolean, glIsProgramPipelineEXT, glIsProgramPipeline, GLuint, pipeline); \
  FuncWrapper1(GLboolean, glIsQuery, GLuint, id); \
  AliasWrapper1(GLboolean, glIsQueryARB, glIsQuery, GLuint, id); \
  AliasWrapper1(GLboolean, glIsQueryEXT, glIsQuery, GLuint, id); \
  FuncWrapper1(GLboolean, glIsRenderbuffer, GLuint, renderbuffer); \
  AliasWrapper1(GLboolean, glIsRenderbufferEXT, glIsRenderbuffer, GLuint, renderbuffer); \
  FuncWrapper1(GLboolean, glIsSampler, GLuint, sampler); \
  FuncWrapper1(GLboolean, glIsShader, GLuint, shader); \
  FuncWrapper1(GLboolean, glIsSync, GLsync, sync); \
  FuncWrapper1(GLboolean, glIsTransformFeedback, GLuint, id); \
  FuncWrapper1(GLboolean, glIsVertexArray, GLuint, array); \
  AliasWrapper1(GLboolean, glIsVertexArrayOES, glIsVertexArray, GLuint, array); \
  FuncWrapper2(void, glGenBuffers, GLsizei, n, GLuint *, buffers); \
  AliasWrapper2(void, glGenBuffersARB, glGenBuffers, GLsizei, n, GLuint *, buffers); \
  FuncWrapper2(void, glBindBuffer, GLenum, target, GLuint, buffer); \
  AliasWrapper2(void, glBindBufferARB, glBindBuffer, GLenum, target, GLuint, buffer); \
  FuncWrapper2(void, glDrawBuffers, GLsizei, n, const GLenum *, bufs); \
  AliasWrapper2(void, glDrawBuffersARB, glDrawBuffers, GLsizei, n, const GLenum *, bufs); \
  AliasWrapper2(void, glDrawBuffersEXT, glDrawBuffers, GLsizei, n, const GLenum *, bufs); \
  FuncWrapper2(void, glGenFramebuffers, GLsizei, n, GLuint *, framebuffers); \
  AliasWrapper2(void, glGenFramebuffersEXT, glGenFramebuffers, GLsizei, n, GLuint *, framebuffers); \
  FuncWrapper2(void, glBindFramebuffer, GLenum, target, GLuint, framebuffer); \
  AliasWrapper2(void, glBindFramebufferEXT, glBindFramebuffer, GLenum, target, GLuint, framebuffer); \
  FuncWrapper4(void, glFramebufferTexture, GLenum, target, GLenum, attachment, GLuint, texture, GLint, level); \
  AliasWrapper4(void, glFramebufferTextureARB, glFramebufferTexture, GLenum, target, GLenum, attachment, GLuint, texture, GLint, level); \
  AliasWrapper4(void, glFramebufferTextureOES, glFramebufferTexture, GLenum, target, GLenum, attachment, GLuint, texture, GLint, level); \
  AliasWrapper4(void, glFramebufferTextureEXT, glFramebufferTexture, GLenum, target, GLenum, attachment, GLuint, texture, GLint, level); \
  FuncWrapper5(void, glFramebufferTexture1D, GLenum, target, GLenum, attachment, GLenum, textarget, GLuint, texture, GLint, level); \
  AliasWrapper5(void, glFramebufferTexture1DEXT, glFramebufferTexture1D, GLenum, target, GLenum, attachment, GLenum, textarget, GLuint, texture, GLint, level); \
  FuncWrapper5(void, glFramebufferTexture2D, GLenum, target, GLenum, attachment, GLenum, textarget, GLuint, texture, GLint, level); \
  AliasWrapper5(void, glFramebufferTexture2DEXT, glFramebufferTexture2D, GLenum, target, GLenum, attachment, GLenum, textarget, GLuint, texture, GLint, level); \
  FuncWrapper6(void, glFramebufferTexture3D, GLenum, target, GLenum, attachment, GLenum, textarget, GLuint, texture, GLint, level, GLint, zoffset); \
  AliasWrapper6(void, glFramebufferTexture3DEXT, glFramebufferTexture3D, GLenum, target, GLenum, attachment, GLenum, textarget, GLuint, texture, GLint, level, GLint, zoffset); \
  AliasWrapper6(void, glFramebufferTexture3DOES, glFramebufferTexture3D, GLenum, target, GLenum, attachment, GLenum, textarget, GLuint, texture, GLint, level, GLint, zoffset); \
  FuncWrapper4(void, glFramebufferRenderbuffer, GLenum, target, GLenum, attachment, GLenum, renderbuffertarget, GLuint, renderbuffer); \
  AliasWrapper4(void, glFramebufferRenderbufferEXT, glFramebufferRenderbuffer, GLenum, target, GLenum, attachment, GLenum, renderbuffertarget, GLuint, renderbuffer); \
  FuncWrapper5(void, glFramebufferTextureLayer, GLenum, target, GLenum, attachment, GLuint, texture, GLint, level, GLint, layer); \
  AliasWrapper5(void, glFramebufferTextureLayerARB, glFramebufferTextureLayer, GLenum, target, GLenum, attachment, GLuint, texture, GLint, level, GLint, layer); \
  AliasWrapper5(void, glFramebufferTextureLayerEXT, glFramebufferTextureLayer, GLenum, target, GLenum, attachment, GLuint, texture, GLint, level, GLint, layer); \
  FuncWrapper3(void, glFramebufferParameteri, GLenum, target, GLenum, pname, GLint, param); \
  FuncWrapper2(void, glDeleteFramebuffers, GLsizei, n, const GLuint *, framebuffers); \
  AliasWrapper2(void, glDeleteFramebuffersEXT, glDeleteFramebuffers, GLsizei, n, const GLuint *, framebuffers); \
  FuncWrapper2(void, glGenRenderbuffers, GLsizei, n, GLuint *, renderbuffers); \
  AliasWrapper2(void, glGenRenderbuffersEXT, glGenRenderbuffers, GLsizei, n, GLuint *, renderbuffers); \
  FuncWrapper4(void, glRenderbufferStorage, GLenum, target, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  AliasWrapper4(void, glRenderbufferStorageEXT, glRenderbufferStorage, GLenum, target, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  FuncWrapper5(void, glRenderbufferStorageMultisample, GLenum, target, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  FuncWrapper2(void, glDeleteRenderbuffers, GLsizei, n, const GLuint *, renderbuffers); \
  AliasWrapper2(void, glDeleteRenderbuffersEXT, glDeleteRenderbuffers, GLsizei, n, const GLuint *, renderbuffers); \
  FuncWrapper2(void, glBindRenderbuffer, GLenum, target, GLuint, renderbuffer); \
  AliasWrapper2(void, glBindRenderbufferEXT, glBindRenderbuffer, GLenum, target, GLuint, renderbuffer); \
  FuncWrapper2(GLsync, glFenceSync, GLenum, condition, GLbitfield, flags); \
  FuncWrapper3(GLenum, glClientWaitSync, GLsync, sync, GLbitfield, flags, GLuint64, timeout); \
  FuncWrapper3(void, glWaitSync, GLsync, sync, GLbitfield, flags, GLuint64, timeout); \
  FuncWrapper1(void, glDeleteSync, GLsync, sync); \
  FuncWrapper2(void, glGenQueries, GLsizei, n, GLuint *, ids); \
  AliasWrapper2(void, glGenQueriesARB, glGenQueries, GLsizei, n, GLuint *, ids); \
  AliasWrapper2(void, glGenQueriesEXT, glGenQueries, GLsizei, n, GLuint *, ids); \
  FuncWrapper2(void, glBeginQuery, GLenum, target, GLuint, id); \
  AliasWrapper2(void, glBeginQueryARB, glBeginQuery, GLenum, target, GLuint, id); \
  AliasWrapper2(void, glBeginQueryEXT, glBeginQuery, GLenum, target, GLuint, id); \
  FuncWrapper3(void, glBeginQueryIndexed, GLenum, target, GLuint, index, GLuint, id); \
  FuncWrapper1(void, glEndQuery, GLenum, target); \
  AliasWrapper1(void, glEndQueryARB, glEndQuery, GLenum, target); \
  AliasWrapper1(void, glEndQueryEXT, glEndQuery, GLenum, target); \
  FuncWrapper2(void, glEndQueryIndexed, GLenum, target, GLuint, index); \
  FuncWrapper2(void, glBeginConditionalRender, GLuint, id, GLenum, mode); \
  FuncWrapper0(void, glEndConditionalRender); \
  FuncWrapper2(void, glQueryCounter, GLuint, id, GLenum, target); \
  AliasWrapper2(void, glQueryCounterEXT, glQueryCounter, GLuint, id, GLenum, target); \
  FuncWrapper2(void, glDeleteQueries, GLsizei, n, const GLuint *, ids); \
  AliasWrapper2(void, glDeleteQueriesARB, glDeleteQueries, GLsizei, n, const GLuint *, ids); \
  AliasWrapper2(void, glDeleteQueriesEXT, glDeleteQueries, GLsizei, n, const GLuint *, ids); \
  FuncWrapper4(void, glBufferData, GLenum, target, GLsizeiptr, size, const void *, data, GLenum, usage); \
  AliasWrapper4(void, glBufferDataARB, glBufferData, GLenum, target, GLsizeiptr, size, const void *, data, GLenum, usage); \
  FuncWrapper4(void, glBufferStorage, GLenum, target, GLsizeiptr, size, const void *, data, GLbitfield, flags); \
  AliasWrapper4(void, glBufferStorageEXT, glBufferStorage, GLenum, target, GLsizeiptr, size, const void *, data, GLbitfield, flags); \
  FuncWrapper4(void, glBufferSubData, GLenum, target, GLintptr, offset, GLsizeiptr, size, const void *, data); \
  AliasWrapper4(void, glBufferSubDataARB, glBufferSubData, GLenum, target, GLintptr, offset, GLsizeiptr, size, const void *, data); \
  FuncWrapper5(void, glCopyBufferSubData, GLenum, readTarget, GLenum, writeTarget, GLintptr, readOffset, GLintptr, writeOffset, GLsizeiptr, size); \
  FuncWrapper3(void, glBindBufferBase, GLenum, target, GLuint, index, GLuint, buffer); \
  AliasWrapper3(void, glBindBufferBaseEXT, glBindBufferBase, GLenum, target, GLuint, index, GLuint, buffer); \
  FuncWrapper5(void, glBindBufferRange, GLenum, target, GLuint, index, GLuint, buffer, GLintptr, offset, GLsizeiptr, size); \
  AliasWrapper5(void, glBindBufferRangeEXT, glBindBufferRange, GLenum, target, GLuint, index, GLuint, buffer, GLintptr, offset, GLsizeiptr, size); \
  FuncWrapper4(void, glBindBuffersBase, GLenum, target, GLuint, first, GLsizei, count, const GLuint *, buffers); \
  FuncWrapper6(void, glBindBuffersRange, GLenum, target, GLuint, first, GLsizei, count, const GLuint *, buffers, const GLintptr *, offsets, const GLsizeiptr *, sizes); \
  FuncWrapper2(void *, glMapBuffer, GLenum, target, GLenum, access); \
  AliasWrapper2(void *, glMapBufferARB, glMapBuffer, GLenum, target, GLenum, access); \
  AliasWrapper2(void *, glMapBufferOES, glMapBuffer, GLenum, target, GLenum, access); \
  FuncWrapper4(void *, glMapBufferRange, GLenum, target, GLintptr, offset, GLsizeiptr, length, GLbitfield, access); \
  AliasWrapper4(void *, glMapBufferRangeEXT, glMapBufferRange, GLenum, target, GLintptr, offset, GLsizeiptr, length, GLbitfield, access); \
  FuncWrapper3(void, glFlushMappedBufferRange, GLenum, target, GLintptr, offset, GLsizeiptr, length); \
  AliasWrapper3(void, glFlushMappedBufferRangeEXT, glFlushMappedBufferRange, GLenum, target, GLintptr, offset, GLsizeiptr, length); \
  FuncWrapper1(GLboolean, glUnmapBuffer, GLenum, target); \
  AliasWrapper1(GLboolean, glUnmapBufferARB, glUnmapBuffer, GLenum, target); \
  AliasWrapper1(GLboolean, glUnmapBufferOES, glUnmapBuffer, GLenum, target); \
  FuncWrapper4(void, glTransformFeedbackVaryings, GLuint, program, GLsizei, count, const GLchar *const*, varyings, GLenum, bufferMode); \
  AliasWrapper4(void, glTransformFeedbackVaryingsEXT, glTransformFeedbackVaryings, GLuint, program, GLsizei, count, const GLchar *const*, varyings, GLenum, bufferMode); \
  FuncWrapper2(void, glGenTransformFeedbacks, GLsizei, n, GLuint *, ids); \
  FuncWrapper2(void, glDeleteTransformFeedbacks, GLsizei, n, const GLuint *, ids); \
  FuncWrapper2(void, glBindTransformFeedback, GLenum, target, GLuint, id); \
  FuncWrapper1(void, glBeginTransformFeedback, GLenum, primitiveMode); \
  AliasWrapper1(void, glBeginTransformFeedbackEXT, glBeginTransformFeedback, GLenum, primitiveMode); \
  FuncWrapper0(void, glPauseTransformFeedback); \
  FuncWrapper0(void, glResumeTransformFeedback); \
  FuncWrapper0(void, glEndTransformFeedback); \
  AliasWrapper0(void, glEndTransformFeedbackEXT, glEndTransformFeedback); \
  FuncWrapper2(void, glDrawTransformFeedback, GLenum, mode, GLuint, id); \
  FuncWrapper3(void, glDrawTransformFeedbackInstanced, GLenum, mode, GLuint, id, GLsizei, instancecount); \
  FuncWrapper3(void, glDrawTransformFeedbackStream, GLenum, mode, GLuint, id, GLuint, stream); \
  FuncWrapper4(void, glDrawTransformFeedbackStreamInstanced, GLenum, mode, GLuint, id, GLuint, stream, GLsizei, instancecount); \
  FuncWrapper2(void, glDeleteBuffers, GLsizei, n, const GLuint *, buffers); \
  AliasWrapper2(void, glDeleteBuffersARB, glDeleteBuffers, GLsizei, n, const GLuint *, buffers); \
  FuncWrapper2(void, glGenVertexArrays, GLsizei, n, GLuint *, arrays); \
  AliasWrapper2(void, glGenVertexArraysOES, glGenVertexArrays, GLsizei, n, GLuint *, arrays); \
  FuncWrapper1(void, glBindVertexArray, GLuint, array); \
  AliasWrapper1(void, glBindVertexArrayOES, glBindVertexArray, GLuint, array); \
  FuncWrapper2(void, glDeleteVertexArrays, GLsizei, n, const GLuint *, arrays); \
  AliasWrapper2(void, glDeleteVertexArraysOES, glDeleteVertexArrays, GLsizei, n, const GLuint *, arrays); \
  FuncWrapper2(void, glVertexAttrib1d, GLuint, index, GLdouble, x); \
  AliasWrapper2(void, glVertexAttrib1dARB, glVertexAttrib1d, GLuint, index, GLdouble, x); \
  FuncWrapper2(void, glVertexAttrib1dv, GLuint, index, const GLdouble *, v); \
  AliasWrapper2(void, glVertexAttrib1dvARB, glVertexAttrib1dv, GLuint, index, const GLdouble *, v); \
  FuncWrapper2(void, glVertexAttrib1f, GLuint, index, GLfloat, x); \
  AliasWrapper2(void, glVertexAttrib1fARB, glVertexAttrib1f, GLuint, index, GLfloat, x); \
  FuncWrapper2(void, glVertexAttrib1fv, GLuint, index, const GLfloat *, v); \
  AliasWrapper2(void, glVertexAttrib1fvARB, glVertexAttrib1fv, GLuint, index, const GLfloat *, v); \
  FuncWrapper2(void, glVertexAttrib1s, GLuint, index, GLshort, x); \
  AliasWrapper2(void, glVertexAttrib1sARB, glVertexAttrib1s, GLuint, index, GLshort, x); \
  FuncWrapper2(void, glVertexAttrib1sv, GLuint, index, const GLshort *, v); \
  AliasWrapper2(void, glVertexAttrib1svARB, glVertexAttrib1sv, GLuint, index, const GLshort *, v); \
  FuncWrapper3(void, glVertexAttrib2d, GLuint, index, GLdouble, x, GLdouble, y); \
  AliasWrapper3(void, glVertexAttrib2dARB, glVertexAttrib2d, GLuint, index, GLdouble, x, GLdouble, y); \
  FuncWrapper2(void, glVertexAttrib2dv, GLuint, index, const GLdouble *, v); \
  AliasWrapper2(void, glVertexAttrib2dvARB, glVertexAttrib2dv, GLuint, index, const GLdouble *, v); \
  FuncWrapper3(void, glVertexAttrib2f, GLuint, index, GLfloat, x, GLfloat, y); \
  AliasWrapper3(void, glVertexAttrib2fARB, glVertexAttrib2f, GLuint, index, GLfloat, x, GLfloat, y); \
  FuncWrapper2(void, glVertexAttrib2fv, GLuint, index, const GLfloat *, v); \
  AliasWrapper2(void, glVertexAttrib2fvARB, glVertexAttrib2fv, GLuint, index, const GLfloat *, v); \
  FuncWrapper3(void, glVertexAttrib2s, GLuint, index, GLshort, x, GLshort, y); \
  AliasWrapper3(void, glVertexAttrib2sARB, glVertexAttrib2s, GLuint, index, GLshort, x, GLshort, y); \
  FuncWrapper2(void, glVertexAttrib2sv, GLuint, index, const GLshort *, v); \
  AliasWrapper2(void, glVertexAttrib2svARB, glVertexAttrib2sv, GLuint, index, const GLshort *, v); \
  FuncWrapper4(void, glVertexAttrib3d, GLuint, index, GLdouble, x, GLdouble, y, GLdouble, z); \
  AliasWrapper4(void, glVertexAttrib3dARB, glVertexAttrib3d, GLuint, index, GLdouble, x, GLdouble, y, GLdouble, z); \
  FuncWrapper2(void, glVertexAttrib3dv, GLuint, index, const GLdouble *, v); \
  AliasWrapper2(void, glVertexAttrib3dvARB, glVertexAttrib3dv, GLuint, index, const GLdouble *, v); \
  FuncWrapper4(void, glVertexAttrib3f, GLuint, index, GLfloat, x, GLfloat, y, GLfloat, z); \
  AliasWrapper4(void, glVertexAttrib3fARB, glVertexAttrib3f, GLuint, index, GLfloat, x, GLfloat, y, GLfloat, z); \
  FuncWrapper2(void, glVertexAttrib3fv, GLuint, index, const GLfloat *, v); \
  AliasWrapper2(void, glVertexAttrib3fvARB, glVertexAttrib3fv, GLuint, index, const GLfloat *, v); \
  FuncWrapper4(void, glVertexAttrib3s, GLuint, index, GLshort, x, GLshort, y, GLshort, z); \
  AliasWrapper4(void, glVertexAttrib3sARB, glVertexAttrib3s, GLuint, index, GLshort, x, GLshort, y, GLshort, z); \
  FuncWrapper2(void, glVertexAttrib3sv, GLuint, index, const GLshort *, v); \
  AliasWrapper2(void, glVertexAttrib3svARB, glVertexAttrib3sv, GLuint, index, const GLshort *, v); \
  FuncWrapper2(void, glVertexAttrib4Nbv, GLuint, index, const GLbyte *, v); \
  AliasWrapper2(void, glVertexAttrib4NbvARB, glVertexAttrib4Nbv, GLuint, index, const GLbyte *, v); \
  FuncWrapper2(void, glVertexAttrib4Niv, GLuint, index, const GLint *, v); \
  AliasWrapper2(void, glVertexAttrib4NivARB, glVertexAttrib4Niv, GLuint, index, const GLint *, v); \
  FuncWrapper2(void, glVertexAttrib4Nsv, GLuint, index, const GLshort *, v); \
  AliasWrapper2(void, glVertexAttrib4NsvARB, glVertexAttrib4Nsv, GLuint, index, const GLshort *, v); \
  FuncWrapper5(void, glVertexAttrib4Nub, GLuint, index, GLubyte, x, GLubyte, y, GLubyte, z, GLubyte, w); \
  FuncWrapper2(void, glVertexAttrib4Nubv, GLuint, index, const GLubyte *, v); \
  AliasWrapper2(void, glVertexAttrib4NubvARB, glVertexAttrib4Nubv, GLuint, index, const GLubyte *, v); \
  FuncWrapper2(void, glVertexAttrib4Nuiv, GLuint, index, const GLuint *, v); \
  AliasWrapper2(void, glVertexAttrib4NuivARB, glVertexAttrib4Nuiv, GLuint, index, const GLuint *, v); \
  FuncWrapper2(void, glVertexAttrib4Nusv, GLuint, index, const GLushort *, v); \
  AliasWrapper2(void, glVertexAttrib4NusvARB, glVertexAttrib4Nusv, GLuint, index, const GLushort *, v); \
  FuncWrapper2(void, glVertexAttrib4bv, GLuint, index, const GLbyte *, v); \
  AliasWrapper2(void, glVertexAttrib4bvARB, glVertexAttrib4bv, GLuint, index, const GLbyte *, v); \
  FuncWrapper5(void, glVertexAttrib4d, GLuint, index, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  AliasWrapper5(void, glVertexAttrib4dARB, glVertexAttrib4d, GLuint, index, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  FuncWrapper2(void, glVertexAttrib4dv, GLuint, index, const GLdouble *, v); \
  AliasWrapper2(void, glVertexAttrib4dvARB, glVertexAttrib4dv, GLuint, index, const GLdouble *, v); \
  FuncWrapper5(void, glVertexAttrib4f, GLuint, index, GLfloat, x, GLfloat, y, GLfloat, z, GLfloat, w); \
  AliasWrapper5(void, glVertexAttrib4fARB, glVertexAttrib4f, GLuint, index, GLfloat, x, GLfloat, y, GLfloat, z, GLfloat, w); \
  FuncWrapper2(void, glVertexAttrib4fv, GLuint, index, const GLfloat *, v); \
  AliasWrapper2(void, glVertexAttrib4fvARB, glVertexAttrib4fv, GLuint, index, const GLfloat *, v); \
  FuncWrapper2(void, glVertexAttrib4iv, GLuint, index, const GLint *, v); \
  AliasWrapper2(void, glVertexAttrib4ivARB, glVertexAttrib4iv, GLuint, index, const GLint *, v); \
  FuncWrapper5(void, glVertexAttrib4s, GLuint, index, GLshort, x, GLshort, y, GLshort, z, GLshort, w); \
  AliasWrapper5(void, glVertexAttrib4sARB, glVertexAttrib4s, GLuint, index, GLshort, x, GLshort, y, GLshort, z, GLshort, w); \
  FuncWrapper2(void, glVertexAttrib4sv, GLuint, index, const GLshort *, v); \
  AliasWrapper2(void, glVertexAttrib4svARB, glVertexAttrib4sv, GLuint, index, const GLshort *, v); \
  FuncWrapper2(void, glVertexAttrib4ubv, GLuint, index, const GLubyte *, v); \
  AliasWrapper2(void, glVertexAttrib4ubvARB, glVertexAttrib4ubv, GLuint, index, const GLubyte *, v); \
  FuncWrapper2(void, glVertexAttrib4uiv, GLuint, index, const GLuint *, v); \
  AliasWrapper2(void, glVertexAttrib4uivARB, glVertexAttrib4uiv, GLuint, index, const GLuint *, v); \
  FuncWrapper2(void, glVertexAttrib4usv, GLuint, index, const GLushort *, v); \
  AliasWrapper2(void, glVertexAttrib4usvARB, glVertexAttrib4usv, GLuint, index, const GLushort *, v); \
  FuncWrapper2(void, glVertexAttribI1i, GLuint, index, GLint, x); \
  AliasWrapper2(void, glVertexAttribI1iEXT, glVertexAttribI1i, GLuint, index, GLint, x); \
  FuncWrapper2(void, glVertexAttribI1iv, GLuint, index, const GLint *, v); \
  AliasWrapper2(void, glVertexAttribI1ivEXT, glVertexAttribI1iv, GLuint, index, const GLint *, v); \
  FuncWrapper2(void, glVertexAttribI1ui, GLuint, index, GLuint, x); \
  AliasWrapper2(void, glVertexAttribI1uiEXT, glVertexAttribI1ui, GLuint, index, GLuint, x); \
  FuncWrapper2(void, glVertexAttribI1uiv, GLuint, index, const GLuint *, v); \
  AliasWrapper2(void, glVertexAttribI1uivEXT, glVertexAttribI1uiv, GLuint, index, const GLuint *, v); \
  FuncWrapper3(void, glVertexAttribI2i, GLuint, index, GLint, x, GLint, y); \
  AliasWrapper3(void, glVertexAttribI2iEXT, glVertexAttribI2i, GLuint, index, GLint, x, GLint, y); \
  FuncWrapper2(void, glVertexAttribI2iv, GLuint, index, const GLint *, v); \
  AliasWrapper2(void, glVertexAttribI2ivEXT, glVertexAttribI2iv, GLuint, index, const GLint *, v); \
  FuncWrapper3(void, glVertexAttribI2ui, GLuint, index, GLuint, x, GLuint, y); \
  AliasWrapper3(void, glVertexAttribI2uiEXT, glVertexAttribI2ui, GLuint, index, GLuint, x, GLuint, y); \
  FuncWrapper2(void, glVertexAttribI2uiv, GLuint, index, const GLuint *, v); \
  AliasWrapper2(void, glVertexAttribI2uivEXT, glVertexAttribI2uiv, GLuint, index, const GLuint *, v); \
  FuncWrapper4(void, glVertexAttribI3i, GLuint, index, GLint, x, GLint, y, GLint, z); \
  AliasWrapper4(void, glVertexAttribI3iEXT, glVertexAttribI3i, GLuint, index, GLint, x, GLint, y, GLint, z); \
  FuncWrapper2(void, glVertexAttribI3iv, GLuint, index, const GLint *, v); \
  AliasWrapper2(void, glVertexAttribI3ivEXT, glVertexAttribI3iv, GLuint, index, const GLint *, v); \
  FuncWrapper4(void, glVertexAttribI3ui, GLuint, index, GLuint, x, GLuint, y, GLuint, z); \
  AliasWrapper4(void, glVertexAttribI3uiEXT, glVertexAttribI3ui, GLuint, index, GLuint, x, GLuint, y, GLuint, z); \
  FuncWrapper2(void, glVertexAttribI3uiv, GLuint, index, const GLuint *, v); \
  AliasWrapper2(void, glVertexAttribI3uivEXT, glVertexAttribI3uiv, GLuint, index, const GLuint *, v); \
  FuncWrapper2(void, glVertexAttribI4bv, GLuint, index, const GLbyte *, v); \
  AliasWrapper2(void, glVertexAttribI4bvEXT, glVertexAttribI4bv, GLuint, index, const GLbyte *, v); \
  FuncWrapper5(void, glVertexAttribI4i, GLuint, index, GLint, x, GLint, y, GLint, z, GLint, w); \
  AliasWrapper5(void, glVertexAttribI4iEXT, glVertexAttribI4i, GLuint, index, GLint, x, GLint, y, GLint, z, GLint, w); \
  FuncWrapper2(void, glVertexAttribI4iv, GLuint, index, const GLint *, v); \
  AliasWrapper2(void, glVertexAttribI4ivEXT, glVertexAttribI4iv, GLuint, index, const GLint *, v); \
  FuncWrapper2(void, glVertexAttribI4sv, GLuint, index, const GLshort *, v); \
  AliasWrapper2(void, glVertexAttribI4svEXT, glVertexAttribI4sv, GLuint, index, const GLshort *, v); \
  FuncWrapper2(void, glVertexAttribI4ubv, GLuint, index, const GLubyte *, v); \
  AliasWrapper2(void, glVertexAttribI4ubvEXT, glVertexAttribI4ubv, GLuint, index, const GLubyte *, v); \
  FuncWrapper5(void, glVertexAttribI4ui, GLuint, index, GLuint, x, GLuint, y, GLuint, z, GLuint, w); \
  AliasWrapper5(void, glVertexAttribI4uiEXT, glVertexAttribI4ui, GLuint, index, GLuint, x, GLuint, y, GLuint, z, GLuint, w); \
  FuncWrapper2(void, glVertexAttribI4uiv, GLuint, index, const GLuint *, v); \
  AliasWrapper2(void, glVertexAttribI4uivEXT, glVertexAttribI4uiv, GLuint, index, const GLuint *, v); \
  FuncWrapper2(void, glVertexAttribI4usv, GLuint, index, const GLushort *, v); \
  AliasWrapper2(void, glVertexAttribI4usvEXT, glVertexAttribI4usv, GLuint, index, const GLushort *, v); \
  FuncWrapper2(void, glVertexAttribL1d, GLuint, index, GLdouble, x); \
  AliasWrapper2(void, glVertexAttribL1dEXT, glVertexAttribL1d, GLuint, index, GLdouble, x); \
  FuncWrapper2(void, glVertexAttribL1dv, GLuint, index, const GLdouble *, v); \
  AliasWrapper2(void, glVertexAttribL1dvEXT, glVertexAttribL1dv, GLuint, index, const GLdouble *, v); \
  FuncWrapper3(void, glVertexAttribL2d, GLuint, index, GLdouble, x, GLdouble, y); \
  AliasWrapper3(void, glVertexAttribL2dEXT, glVertexAttribL2d, GLuint, index, GLdouble, x, GLdouble, y); \
  FuncWrapper2(void, glVertexAttribL2dv, GLuint, index, const GLdouble *, v); \
  AliasWrapper2(void, glVertexAttribL2dvEXT, glVertexAttribL2dv, GLuint, index, const GLdouble *, v); \
  FuncWrapper4(void, glVertexAttribL3d, GLuint, index, GLdouble, x, GLdouble, y, GLdouble, z); \
  AliasWrapper4(void, glVertexAttribL3dEXT, glVertexAttribL3d, GLuint, index, GLdouble, x, GLdouble, y, GLdouble, z); \
  FuncWrapper2(void, glVertexAttribL3dv, GLuint, index, const GLdouble *, v); \
  AliasWrapper2(void, glVertexAttribL3dvEXT, glVertexAttribL3dv, GLuint, index, const GLdouble *, v); \
  FuncWrapper5(void, glVertexAttribL4d, GLuint, index, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  AliasWrapper5(void, glVertexAttribL4dEXT, glVertexAttribL4d, GLuint, index, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  FuncWrapper2(void, glVertexAttribL4dv, GLuint, index, const GLdouble *, v); \
  AliasWrapper2(void, glVertexAttribL4dvEXT, glVertexAttribL4dv, GLuint, index, const GLdouble *, v); \
  FuncWrapper4(void, glVertexAttribP1ui, GLuint, index, GLenum, type, GLboolean, normalized, GLuint, value); \
  FuncWrapper4(void, glVertexAttribP1uiv, GLuint, index, GLenum, type, GLboolean, normalized, const GLuint *, value); \
  FuncWrapper4(void, glVertexAttribP2ui, GLuint, index, GLenum, type, GLboolean, normalized, GLuint, value); \
  FuncWrapper4(void, glVertexAttribP2uiv, GLuint, index, GLenum, type, GLboolean, normalized, const GLuint *, value); \
  FuncWrapper4(void, glVertexAttribP3ui, GLuint, index, GLenum, type, GLboolean, normalized, GLuint, value); \
  FuncWrapper4(void, glVertexAttribP3uiv, GLuint, index, GLenum, type, GLboolean, normalized, const GLuint *, value); \
  FuncWrapper4(void, glVertexAttribP4ui, GLuint, index, GLenum, type, GLboolean, normalized, GLuint, value); \
  FuncWrapper4(void, glVertexAttribP4uiv, GLuint, index, GLenum, type, GLboolean, normalized, const GLuint *, value); \
  FuncWrapper6(void, glVertexAttribPointer, GLuint, index, GLint, size, GLenum, type, GLboolean, normalized, GLsizei, stride, const void *, pointer); \
  AliasWrapper6(void, glVertexAttribPointerARB, glVertexAttribPointer, GLuint, index, GLint, size, GLenum, type, GLboolean, normalized, GLsizei, stride, const void *, pointer); \
  FuncWrapper5(void, glVertexAttribIPointer, GLuint, index, GLint, size, GLenum, type, GLsizei, stride, const void *, pointer); \
  AliasWrapper5(void, glVertexAttribIPointerEXT, glVertexAttribIPointer, GLuint, index, GLint, size, GLenum, type, GLsizei, stride, const void *, pointer); \
  FuncWrapper5(void, glVertexAttribLPointer, GLuint, index, GLint, size, GLenum, type, GLsizei, stride, const void *, pointer); \
  AliasWrapper5(void, glVertexAttribLPointerEXT, glVertexAttribLPointer, GLuint, index, GLint, size, GLenum, type, GLsizei, stride, const void *, pointer); \
  FuncWrapper2(void, glVertexAttribBinding, GLuint, attribindex, GLuint, bindingindex); \
  FuncWrapper5(void, glVertexAttribFormat, GLuint, attribindex, GLint, size, GLenum, type, GLboolean, normalized, GLuint, relativeoffset); \
  FuncWrapper4(void, glVertexAttribIFormat, GLuint, attribindex, GLint, size, GLenum, type, GLuint, relativeoffset); \
  FuncWrapper4(void, glVertexAttribLFormat, GLuint, attribindex, GLint, size, GLenum, type, GLuint, relativeoffset); \
  FuncWrapper2(void, glVertexAttribDivisor, GLuint, index, GLuint, divisor); \
  AliasWrapper2(void, glVertexAttribDivisorARB, glVertexAttribDivisor, GLuint, index, GLuint, divisor); \
  FuncWrapper3(void, glBindAttribLocation, GLuint, program, GLuint, index, const GLchar *, name); \
  FuncWrapper3(void, glBindFragDataLocation, GLuint, program, GLuint, color, const GLchar *, name); \
  AliasWrapper3(void, glBindFragDataLocationEXT, glBindFragDataLocation, GLuint, program, GLuint, color, const GLchar *, name); \
  FuncWrapper4(void, glBindFragDataLocationIndexed, GLuint, program, GLuint, colorNumber, GLuint, index, const GLchar *, name); \
  FuncWrapper1(void, glEnableVertexAttribArray, GLuint, index); \
  AliasWrapper1(void, glEnableVertexAttribArrayARB, glEnableVertexAttribArray, GLuint, index); \
  FuncWrapper1(void, glDisableVertexAttribArray, GLuint, index); \
  AliasWrapper1(void, glDisableVertexAttribArrayARB, glDisableVertexAttribArray, GLuint, index); \
  FuncWrapper4(void, glBindVertexBuffer, GLuint, bindingindex, GLuint, buffer, GLintptr, offset, GLsizei, stride); \
  FuncWrapper5(void, glBindVertexBuffers, GLuint, first, GLsizei, count, const GLuint *, buffers, const GLintptr *, offsets, const GLsizei *, strides); \
  FuncWrapper2(void, glVertexBindingDivisor, GLuint, bindingindex, GLuint, divisor); \
  FuncWrapper7(void, glBindImageTexture, GLuint, unit, GLuint, texture, GLint, level, GLboolean, layered, GLint, layer, GLenum, access, GLenum, format); \
  AliasWrapper7(void, glBindImageTextureEXT, glBindImageTexture, GLuint, unit, GLuint, texture, GLint, level, GLboolean, layered, GLint, layer, GLenum, access, GLenum, format); \
  FuncWrapper3(void, glBindImageTextures, GLuint, first, GLsizei, count, const GLuint *, textures); \
  FuncWrapper2(void, glGenSamplers, GLsizei, count, GLuint *, samplers); \
  FuncWrapper2(void, glBindSampler, GLuint, unit, GLuint, sampler); \
  FuncWrapper3(void, glBindSamplers, GLuint, first, GLsizei, count, const GLuint *, samplers); \
  FuncWrapper3(void, glBindTextures, GLuint, first, GLsizei, count, const GLuint *, textures); \
  FuncWrapper2(void, glDeleteSamplers, GLsizei, count, const GLuint *, samplers); \
  FuncWrapper3(void, glSamplerParameteri, GLuint, sampler, GLenum, pname, GLint, param); \
  FuncWrapper3(void, glSamplerParameterf, GLuint, sampler, GLenum, pname, GLfloat, param); \
  FuncWrapper3(void, glSamplerParameteriv, GLuint, sampler, GLenum, pname, const GLint *, param); \
  FuncWrapper3(void, glSamplerParameterfv, GLuint, sampler, GLenum, pname, const GLfloat *, param); \
  FuncWrapper3(void, glSamplerParameterIiv, GLuint, sampler, GLenum, pname, const GLint *, param); \
  AliasWrapper3(void, glSamplerParameterIivEXT, glSamplerParameterIiv, GLuint, sampler, GLenum, pname, const GLint *, param); \
  AliasWrapper3(void, glSamplerParameterIivOES, glSamplerParameterIiv, GLuint, sampler, GLenum, pname, const GLint *, param); \
  FuncWrapper3(void, glSamplerParameterIuiv, GLuint, sampler, GLenum, pname, const GLuint *, param); \
  AliasWrapper3(void, glSamplerParameterIuivEXT, glSamplerParameterIuiv, GLuint, sampler, GLenum, pname, const GLuint *, param); \
  AliasWrapper3(void, glSamplerParameterIuivOES, glSamplerParameterIuiv, GLuint, sampler, GLenum, pname, const GLuint *, param); \
  FuncWrapper2(void, glPatchParameteri, GLenum, pname, GLint, value); \
  AliasWrapper2(void, glPatchParameteriEXT, glPatchParameteri, GLenum, pname, GLint, value); \
  AliasWrapper2(void, glPatchParameteriOES, glPatchParameteri, GLenum, pname, GLint, value); \
  FuncWrapper2(void, glPatchParameterfv, GLenum, pname, const GLfloat *, values); \
  FuncWrapper2(void, glPointParameterf, GLenum, pname, GLfloat, param); \
  AliasWrapper2(void, glPointParameterfARB, glPointParameterf, GLenum, pname, GLfloat, param); \
  AliasWrapper2(void, glPointParameterfEXT, glPointParameterf, GLenum, pname, GLfloat, param); \
  FuncWrapper2(void, glPointParameterfv, GLenum, pname, const GLfloat *, params); \
  AliasWrapper2(void, glPointParameterfvARB, glPointParameterfv, GLenum, pname, const GLfloat *, params); \
  AliasWrapper2(void, glPointParameterfvEXT, glPointParameterfv, GLenum, pname, const GLfloat *, params); \
  FuncWrapper2(void, glPointParameteri, GLenum, pname, GLint, param); \
  FuncWrapper2(void, glPointParameteriv, GLenum, pname, const GLint *, params); \
  FuncWrapper3(void, glDispatchCompute, GLuint, num_groups_x, GLuint, num_groups_y, GLuint, num_groups_z); \
  FuncWrapper1(void, glDispatchComputeIndirect, GLintptr, indirect); \
  FuncWrapper1(void, glMemoryBarrier, GLbitfield, barriers); \
  AliasWrapper1(void, glMemoryBarrierEXT, glMemoryBarrier, GLbitfield, barriers); \
  FuncWrapper1(void, glMemoryBarrierByRegion, GLbitfield, barriers); \
  FuncWrapper0(void, glTextureBarrier); \
  FuncWrapper1(void, glClearDepthf, GLfloat, d); \
  FuncWrapper3(void, glClearBufferfv, GLenum, buffer, GLint, drawbuffer, const GLfloat *, value); \
  FuncWrapper3(void, glClearBufferiv, GLenum, buffer, GLint, drawbuffer, const GLint *, value); \
  FuncWrapper3(void, glClearBufferuiv, GLenum, buffer, GLint, drawbuffer, const GLuint *, value); \
  FuncWrapper4(void, glClearBufferfi, GLenum, buffer, GLint, drawbuffer, GLfloat, depth, GLint, stencil); \
  FuncWrapper5(void, glClearBufferData, GLenum, target, GLenum, internalformat, GLenum, format, GLenum, type, const void *, data); \
  FuncWrapper7(void, glClearBufferSubData, GLenum, target, GLenum, internalformat, GLintptr, offset, GLsizeiptr, size, GLenum, format, GLenum, type, const void *, data); \
  FuncWrapper5(void, glClearTexImage, GLuint, texture, GLint, level, GLenum, format, GLenum, type, const void *, data); \
  FuncWrapper11(void, glClearTexSubImage, GLuint, texture, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLenum, type, const void *, data); \
  FuncWrapper1(void, glInvalidateBufferData, GLuint, buffer); \
  FuncWrapper3(void, glInvalidateBufferSubData, GLuint, buffer, GLintptr, offset, GLsizeiptr, length); \
  FuncWrapper3(void, glInvalidateFramebuffer, GLenum, target, GLsizei, numAttachments, const GLenum *, attachments); \
  FuncWrapper7(void, glInvalidateSubFramebuffer, GLenum, target, GLsizei, numAttachments, const GLenum *, attachments, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  FuncWrapper2(void, glInvalidateTexImage, GLuint, texture, GLint, level); \
  FuncWrapper8(void, glInvalidateTexSubImage, GLuint, texture, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth); \
  FuncWrapper3(void, glScissorArrayv, GLuint, first, GLsizei, count, const GLint *, v); \
  AliasWrapper3(void, glScissorArrayvOES, glScissorArrayv, GLuint, first, GLsizei, count, const GLint *, v); \
  AliasWrapper3(void, glScissorArrayvNV, glScissorArrayv, GLuint, first, GLsizei, count, const GLint *, v); \
  FuncWrapper5(void, glScissorIndexed, GLuint, index, GLint, left, GLint, bottom, GLsizei, width, GLsizei, height); \
  AliasWrapper5(void, glScissorIndexedOES, glScissorIndexed, GLuint, index, GLint, left, GLint, bottom, GLsizei, width, GLsizei, height); \
  AliasWrapper5(void, glScissorIndexedNV, glScissorIndexed, GLuint, index, GLint, left, GLint, bottom, GLsizei, width, GLsizei, height); \
  FuncWrapper2(void, glScissorIndexedv, GLuint, index, const GLint *, v); \
  AliasWrapper2(void, glScissorIndexedvOES, glScissorIndexedv, GLuint, index, const GLint *, v); \
  AliasWrapper2(void, glScissorIndexedvNV, glScissorIndexedv, GLuint, index, const GLint *, v); \
  FuncWrapper5(void, glViewportIndexedf, GLuint, index, GLfloat, x, GLfloat, y, GLfloat, w, GLfloat, h); \
  AliasWrapper5(void, glViewportIndexedfOES, glViewportIndexedf, GLuint, index, GLfloat, x, GLfloat, y, GLfloat, w, GLfloat, h); \
  AliasWrapper5(void, glViewportIndexedfNV, glViewportIndexedf, GLuint, index, GLfloat, x, GLfloat, y, GLfloat, w, GLfloat, h); \
  FuncWrapper2(void, glViewportIndexedfv, GLuint, index, const GLfloat *, v); \
  AliasWrapper2(void, glViewportIndexedfvOES, glViewportIndexedfv, GLuint, index, const GLfloat *, v); \
  AliasWrapper2(void, glViewportIndexedfvNV, glViewportIndexedfv, GLuint, index, const GLfloat *, v); \
  FuncWrapper3(void, glViewportArrayv, GLuint, first, GLsizei, count, const GLfloat *, v); \
  AliasWrapper3(void, glViewportArrayvOES, glViewportArrayv, GLuint, first, GLsizei, count, const GLfloat *, v); \
  AliasWrapper3(void, glViewportArrayvNV, glViewportArrayv, GLuint, first, GLsizei, count, const GLfloat *, v); \
  FuncWrapper3(void, glUniformBlockBinding, GLuint, program, GLuint, uniformBlockIndex, GLuint, uniformBlockBinding); \
  FuncWrapper3(void, glShaderStorageBlockBinding, GLuint, program, GLuint, storageBlockIndex, GLuint, storageBlockBinding); \
  FuncWrapper3(void, glUniformSubroutinesuiv, GLenum, shadertype, GLsizei, count, const GLuint *, indices); \
  FuncWrapper2(void, glUniform1f, GLint, location, GLfloat, v0); \
  AliasWrapper2(void, glUniform1fARB, glUniform1f, GLint, location, GLfloat, v0); \
  FuncWrapper2(void, glUniform1i, GLint, location, GLint, v0); \
  AliasWrapper2(void, glUniform1iARB, glUniform1i, GLint, location, GLint, v0); \
  FuncWrapper2(void, glUniform1ui, GLint, location, GLuint, v0); \
  AliasWrapper2(void, glUniform1uiEXT, glUniform1ui, GLint, location, GLuint, v0); \
  FuncWrapper2(void, glUniform1d, GLint, location, GLdouble, x); \
  FuncWrapper3(void, glUniform2f, GLint, location, GLfloat, v0, GLfloat, v1); \
  AliasWrapper3(void, glUniform2fARB, glUniform2f, GLint, location, GLfloat, v0, GLfloat, v1); \
  FuncWrapper3(void, glUniform2i, GLint, location, GLint, v0, GLint, v1); \
  AliasWrapper3(void, glUniform2iARB, glUniform2i, GLint, location, GLint, v0, GLint, v1); \
  FuncWrapper3(void, glUniform2ui, GLint, location, GLuint, v0, GLuint, v1); \
  AliasWrapper3(void, glUniform2uiEXT, glUniform2ui, GLint, location, GLuint, v0, GLuint, v1); \
  FuncWrapper3(void, glUniform2d, GLint, location, GLdouble, x, GLdouble, y); \
  FuncWrapper4(void, glUniform3f, GLint, location, GLfloat, v0, GLfloat, v1, GLfloat, v2); \
  AliasWrapper4(void, glUniform3fARB, glUniform3f, GLint, location, GLfloat, v0, GLfloat, v1, GLfloat, v2); \
  FuncWrapper4(void, glUniform3i, GLint, location, GLint, v0, GLint, v1, GLint, v2); \
  AliasWrapper4(void, glUniform3iARB, glUniform3i, GLint, location, GLint, v0, GLint, v1, GLint, v2); \
  FuncWrapper4(void, glUniform3ui, GLint, location, GLuint, v0, GLuint, v1, GLuint, v2); \
  AliasWrapper4(void, glUniform3uiEXT, glUniform3ui, GLint, location, GLuint, v0, GLuint, v1, GLuint, v2); \
  FuncWrapper4(void, glUniform3d, GLint, location, GLdouble, x, GLdouble, y, GLdouble, z); \
  FuncWrapper5(void, glUniform4f, GLint, location, GLfloat, v0, GLfloat, v1, GLfloat, v2, GLfloat, v3); \
  AliasWrapper5(void, glUniform4fARB, glUniform4f, GLint, location, GLfloat, v0, GLfloat, v1, GLfloat, v2, GLfloat, v3); \
  FuncWrapper5(void, glUniform4i, GLint, location, GLint, v0, GLint, v1, GLint, v2, GLint, v3); \
  AliasWrapper5(void, glUniform4iARB, glUniform4i, GLint, location, GLint, v0, GLint, v1, GLint, v2, GLint, v3); \
  FuncWrapper5(void, glUniform4ui, GLint, location, GLuint, v0, GLuint, v1, GLuint, v2, GLuint, v3); \
  AliasWrapper5(void, glUniform4uiEXT, glUniform4ui, GLint, location, GLuint, v0, GLuint, v1, GLuint, v2, GLuint, v3); \
  FuncWrapper5(void, glUniform4d, GLint, location, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  FuncWrapper3(void, glUniform1fv, GLint, location, GLsizei, count, const GLfloat *, value); \
  AliasWrapper3(void, glUniform1fvARB, glUniform1fv, GLint, location, GLsizei, count, const GLfloat *, value); \
  FuncWrapper3(void, glUniform1iv, GLint, location, GLsizei, count, const GLint *, value); \
  AliasWrapper3(void, glUniform1ivARB, glUniform1iv, GLint, location, GLsizei, count, const GLint *, value); \
  FuncWrapper3(void, glUniform1uiv, GLint, location, GLsizei, count, const GLuint *, value); \
  AliasWrapper3(void, glUniform1uivEXT, glUniform1uiv, GLint, location, GLsizei, count, const GLuint *, value); \
  FuncWrapper3(void, glUniform1dv, GLint, location, GLsizei, count, const GLdouble *, value); \
  FuncWrapper3(void, glUniform2fv, GLint, location, GLsizei, count, const GLfloat *, value); \
  AliasWrapper3(void, glUniform2fvARB, glUniform2fv, GLint, location, GLsizei, count, const GLfloat *, value); \
  FuncWrapper3(void, glUniform2iv, GLint, location, GLsizei, count, const GLint *, value); \
  AliasWrapper3(void, glUniform2ivARB, glUniform2iv, GLint, location, GLsizei, count, const GLint *, value); \
  FuncWrapper3(void, glUniform2uiv, GLint, location, GLsizei, count, const GLuint *, value); \
  AliasWrapper3(void, glUniform2uivEXT, glUniform2uiv, GLint, location, GLsizei, count, const GLuint *, value); \
  FuncWrapper3(void, glUniform2dv, GLint, location, GLsizei, count, const GLdouble *, value); \
  FuncWrapper3(void, glUniform3fv, GLint, location, GLsizei, count, const GLfloat *, value); \
  AliasWrapper3(void, glUniform3fvARB, glUniform3fv, GLint, location, GLsizei, count, const GLfloat *, value); \
  FuncWrapper3(void, glUniform3iv, GLint, location, GLsizei, count, const GLint *, value); \
  AliasWrapper3(void, glUniform3ivARB, glUniform3iv, GLint, location, GLsizei, count, const GLint *, value); \
  FuncWrapper3(void, glUniform3uiv, GLint, location, GLsizei, count, const GLuint *, value); \
  AliasWrapper3(void, glUniform3uivEXT, glUniform3uiv, GLint, location, GLsizei, count, const GLuint *, value); \
  FuncWrapper3(void, glUniform3dv, GLint, location, GLsizei, count, const GLdouble *, value); \
  FuncWrapper3(void, glUniform4fv, GLint, location, GLsizei, count, const GLfloat *, value); \
  AliasWrapper3(void, glUniform4fvARB, glUniform4fv, GLint, location, GLsizei, count, const GLfloat *, value); \
  FuncWrapper3(void, glUniform4iv, GLint, location, GLsizei, count, const GLint *, value); \
  AliasWrapper3(void, glUniform4ivARB, glUniform4iv, GLint, location, GLsizei, count, const GLint *, value); \
  FuncWrapper3(void, glUniform4uiv, GLint, location, GLsizei, count, const GLuint *, value); \
  AliasWrapper3(void, glUniform4uivEXT, glUniform4uiv, GLint, location, GLsizei, count, const GLuint *, value); \
  FuncWrapper3(void, glUniform4dv, GLint, location, GLsizei, count, const GLdouble *, value); \
  FuncWrapper4(void, glUniformMatrix2fv, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  AliasWrapper4(void, glUniformMatrix2fvARB, glUniformMatrix2fv, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper4(void, glUniformMatrix2x3fv, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper4(void, glUniformMatrix2x4fv, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper4(void, glUniformMatrix3fv, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  AliasWrapper4(void, glUniformMatrix3fvARB, glUniformMatrix3fv, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper4(void, glUniformMatrix3x2fv, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper4(void, glUniformMatrix3x4fv, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper4(void, glUniformMatrix4fv, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  AliasWrapper4(void, glUniformMatrix4fvARB, glUniformMatrix4fv, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper4(void, glUniformMatrix4x2fv, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper4(void, glUniformMatrix4x3fv, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper4(void, glUniformMatrix2dv, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper4(void, glUniformMatrix2x3dv, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper4(void, glUniformMatrix2x4dv, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper4(void, glUniformMatrix3dv, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper4(void, glUniformMatrix3x2dv, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper4(void, glUniformMatrix3x4dv, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper4(void, glUniformMatrix4dv, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper4(void, glUniformMatrix4x2dv, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper4(void, glUniformMatrix4x3dv, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper3(void, glProgramUniform1f, GLuint, program, GLint, location, GLfloat, v0); \
  AliasWrapper3(void, glProgramUniform1fEXT, glProgramUniform1f, GLuint, program, GLint, location, GLfloat, v0); \
  FuncWrapper3(void, glProgramUniform1i, GLuint, program, GLint, location, GLint, v0); \
  AliasWrapper3(void, glProgramUniform1iEXT, glProgramUniform1i, GLuint, program, GLint, location, GLint, v0); \
  FuncWrapper3(void, glProgramUniform1ui, GLuint, program, GLint, location, GLuint, v0); \
  AliasWrapper3(void, glProgramUniform1uiEXT, glProgramUniform1ui, GLuint, program, GLint, location, GLuint, v0); \
  FuncWrapper3(void, glProgramUniform1d, GLuint, program, GLint, location, GLdouble, v0); \
  AliasWrapper3(void, glProgramUniform1dEXT, glProgramUniform1d, GLuint, program, GLint, location, GLdouble, v0); \
  FuncWrapper4(void, glProgramUniform2f, GLuint, program, GLint, location, GLfloat, v0, GLfloat, v1); \
  AliasWrapper4(void, glProgramUniform2fEXT, glProgramUniform2f, GLuint, program, GLint, location, GLfloat, v0, GLfloat, v1); \
  FuncWrapper4(void, glProgramUniform2i, GLuint, program, GLint, location, GLint, v0, GLint, v1); \
  AliasWrapper4(void, glProgramUniform2iEXT, glProgramUniform2i, GLuint, program, GLint, location, GLint, v0, GLint, v1); \
  FuncWrapper4(void, glProgramUniform2ui, GLuint, program, GLint, location, GLuint, v0, GLuint, v1); \
  AliasWrapper4(void, glProgramUniform2uiEXT, glProgramUniform2ui, GLuint, program, GLint, location, GLuint, v0, GLuint, v1); \
  FuncWrapper4(void, glProgramUniform2d, GLuint, program, GLint, location, GLdouble, v0, GLdouble, v1); \
  AliasWrapper4(void, glProgramUniform2dEXT, glProgramUniform2d, GLuint, program, GLint, location, GLdouble, v0, GLdouble, v1); \
  FuncWrapper5(void, glProgramUniform3f, GLuint, program, GLint, location, GLfloat, v0, GLfloat, v1, GLfloat, v2); \
  AliasWrapper5(void, glProgramUniform3fEXT, glProgramUniform3f, GLuint, program, GLint, location, GLfloat, v0, GLfloat, v1, GLfloat, v2); \
  FuncWrapper5(void, glProgramUniform3i, GLuint, program, GLint, location, GLint, v0, GLint, v1, GLint, v2); \
  AliasWrapper5(void, glProgramUniform3iEXT, glProgramUniform3i, GLuint, program, GLint, location, GLint, v0, GLint, v1, GLint, v2); \
  FuncWrapper5(void, glProgramUniform3ui, GLuint, program, GLint, location, GLuint, v0, GLuint, v1, GLuint, v2); \
  AliasWrapper5(void, glProgramUniform3uiEXT, glProgramUniform3ui, GLuint, program, GLint, location, GLuint, v0, GLuint, v1, GLuint, v2); \
  FuncWrapper5(void, glProgramUniform3d, GLuint, program, GLint, location, GLdouble, v0, GLdouble, v1, GLdouble, v2); \
  AliasWrapper5(void, glProgramUniform3dEXT, glProgramUniform3d, GLuint, program, GLint, location, GLdouble, v0, GLdouble, v1, GLdouble, v2); \
  FuncWrapper6(void, glProgramUniform4f, GLuint, program, GLint, location, GLfloat, v0, GLfloat, v1, GLfloat, v2, GLfloat, v3); \
  AliasWrapper6(void, glProgramUniform4fEXT, glProgramUniform4f, GLuint, program, GLint, location, GLfloat, v0, GLfloat, v1, GLfloat, v2, GLfloat, v3); \
  FuncWrapper6(void, glProgramUniform4i, GLuint, program, GLint, location, GLint, v0, GLint, v1, GLint, v2, GLint, v3); \
  AliasWrapper6(void, glProgramUniform4iEXT, glProgramUniform4i, GLuint, program, GLint, location, GLint, v0, GLint, v1, GLint, v2, GLint, v3); \
  FuncWrapper6(void, glProgramUniform4ui, GLuint, program, GLint, location, GLuint, v0, GLuint, v1, GLuint, v2, GLuint, v3); \
  AliasWrapper6(void, glProgramUniform4uiEXT, glProgramUniform4ui, GLuint, program, GLint, location, GLuint, v0, GLuint, v1, GLuint, v2, GLuint, v3); \
  FuncWrapper6(void, glProgramUniform4d, GLuint, program, GLint, location, GLdouble, v0, GLdouble, v1, GLdouble, v2, GLdouble, v3); \
  AliasWrapper6(void, glProgramUniform4dEXT, glProgramUniform4d, GLuint, program, GLint, location, GLdouble, v0, GLdouble, v1, GLdouble, v2, GLdouble, v3); \
  FuncWrapper4(void, glProgramUniform1fv, GLuint, program, GLint, location, GLsizei, count, const GLfloat *, value); \
  AliasWrapper4(void, glProgramUniform1fvEXT, glProgramUniform1fv, GLuint, program, GLint, location, GLsizei, count, const GLfloat *, value); \
  FuncWrapper4(void, glProgramUniform1iv, GLuint, program, GLint, location, GLsizei, count, const GLint *, value); \
  AliasWrapper4(void, glProgramUniform1ivEXT, glProgramUniform1iv, GLuint, program, GLint, location, GLsizei, count, const GLint *, value); \
  FuncWrapper4(void, glProgramUniform1uiv, GLuint, program, GLint, location, GLsizei, count, const GLuint *, value); \
  AliasWrapper4(void, glProgramUniform1uivEXT, glProgramUniform1uiv, GLuint, program, GLint, location, GLsizei, count, const GLuint *, value); \
  FuncWrapper4(void, glProgramUniform1dv, GLuint, program, GLint, location, GLsizei, count, const GLdouble *, value); \
  AliasWrapper4(void, glProgramUniform1dvEXT, glProgramUniform1dv, GLuint, program, GLint, location, GLsizei, count, const GLdouble *, value); \
  FuncWrapper4(void, glProgramUniform2fv, GLuint, program, GLint, location, GLsizei, count, const GLfloat *, value); \
  AliasWrapper4(void, glProgramUniform2fvEXT, glProgramUniform2fv, GLuint, program, GLint, location, GLsizei, count, const GLfloat *, value); \
  FuncWrapper4(void, glProgramUniform2iv, GLuint, program, GLint, location, GLsizei, count, const GLint *, value); \
  AliasWrapper4(void, glProgramUniform2ivEXT, glProgramUniform2iv, GLuint, program, GLint, location, GLsizei, count, const GLint *, value); \
  FuncWrapper4(void, glProgramUniform2uiv, GLuint, program, GLint, location, GLsizei, count, const GLuint *, value); \
  AliasWrapper4(void, glProgramUniform2uivEXT, glProgramUniform2uiv, GLuint, program, GLint, location, GLsizei, count, const GLuint *, value); \
  FuncWrapper4(void, glProgramUniform2dv, GLuint, program, GLint, location, GLsizei, count, const GLdouble *, value); \
  AliasWrapper4(void, glProgramUniform2dvEXT, glProgramUniform2dv, GLuint, program, GLint, location, GLsizei, count, const GLdouble *, value); \
  FuncWrapper4(void, glProgramUniform3fv, GLuint, program, GLint, location, GLsizei, count, const GLfloat *, value); \
  AliasWrapper4(void, glProgramUniform3fvEXT, glProgramUniform3fv, GLuint, program, GLint, location, GLsizei, count, const GLfloat *, value); \
  FuncWrapper4(void, glProgramUniform3iv, GLuint, program, GLint, location, GLsizei, count, const GLint *, value); \
  AliasWrapper4(void, glProgramUniform3ivEXT, glProgramUniform3iv, GLuint, program, GLint, location, GLsizei, count, const GLint *, value); \
  FuncWrapper4(void, glProgramUniform3uiv, GLuint, program, GLint, location, GLsizei, count, const GLuint *, value); \
  AliasWrapper4(void, glProgramUniform3uivEXT, glProgramUniform3uiv, GLuint, program, GLint, location, GLsizei, count, const GLuint *, value); \
  FuncWrapper4(void, glProgramUniform3dv, GLuint, program, GLint, location, GLsizei, count, const GLdouble *, value); \
  AliasWrapper4(void, glProgramUniform3dvEXT, glProgramUniform3dv, GLuint, program, GLint, location, GLsizei, count, const GLdouble *, value); \
  FuncWrapper4(void, glProgramUniform4fv, GLuint, program, GLint, location, GLsizei, count, const GLfloat *, value); \
  AliasWrapper4(void, glProgramUniform4fvEXT, glProgramUniform4fv, GLuint, program, GLint, location, GLsizei, count, const GLfloat *, value); \
  FuncWrapper4(void, glProgramUniform4iv, GLuint, program, GLint, location, GLsizei, count, const GLint *, value); \
  AliasWrapper4(void, glProgramUniform4ivEXT, glProgramUniform4iv, GLuint, program, GLint, location, GLsizei, count, const GLint *, value); \
  FuncWrapper4(void, glProgramUniform4uiv, GLuint, program, GLint, location, GLsizei, count, const GLuint *, value); \
  AliasWrapper4(void, glProgramUniform4uivEXT, glProgramUniform4uiv, GLuint, program, GLint, location, GLsizei, count, const GLuint *, value); \
  FuncWrapper4(void, glProgramUniform4dv, GLuint, program, GLint, location, GLsizei, count, const GLdouble *, value); \
  AliasWrapper4(void, glProgramUniform4dvEXT, glProgramUniform4dv, GLuint, program, GLint, location, GLsizei, count, const GLdouble *, value); \
  FuncWrapper5(void, glProgramUniformMatrix2fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  AliasWrapper5(void, glProgramUniformMatrix2fvEXT, glProgramUniformMatrix2fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper5(void, glProgramUniformMatrix2x3fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  AliasWrapper5(void, glProgramUniformMatrix2x3fvEXT, glProgramUniformMatrix2x3fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper5(void, glProgramUniformMatrix2x4fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  AliasWrapper5(void, glProgramUniformMatrix2x4fvEXT, glProgramUniformMatrix2x4fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper5(void, glProgramUniformMatrix3fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  AliasWrapper5(void, glProgramUniformMatrix3fvEXT, glProgramUniformMatrix3fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper5(void, glProgramUniformMatrix3x2fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  AliasWrapper5(void, glProgramUniformMatrix3x2fvEXT, glProgramUniformMatrix3x2fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper5(void, glProgramUniformMatrix3x4fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  AliasWrapper5(void, glProgramUniformMatrix3x4fvEXT, glProgramUniformMatrix3x4fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper5(void, glProgramUniformMatrix4fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  AliasWrapper5(void, glProgramUniformMatrix4fvEXT, glProgramUniformMatrix4fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper5(void, glProgramUniformMatrix4x2fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  AliasWrapper5(void, glProgramUniformMatrix4x2fvEXT, glProgramUniformMatrix4x2fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper5(void, glProgramUniformMatrix4x3fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  AliasWrapper5(void, glProgramUniformMatrix4x3fvEXT, glProgramUniformMatrix4x3fv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  FuncWrapper5(void, glProgramUniformMatrix2dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  AliasWrapper5(void, glProgramUniformMatrix2dvEXT, glProgramUniformMatrix2dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper5(void, glProgramUniformMatrix2x3dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  AliasWrapper5(void, glProgramUniformMatrix2x3dvEXT, glProgramUniformMatrix2x3dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper5(void, glProgramUniformMatrix2x4dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  AliasWrapper5(void, glProgramUniformMatrix2x4dvEXT, glProgramUniformMatrix2x4dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper5(void, glProgramUniformMatrix3dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  AliasWrapper5(void, glProgramUniformMatrix3dvEXT, glProgramUniformMatrix3dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper5(void, glProgramUniformMatrix3x2dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  AliasWrapper5(void, glProgramUniformMatrix3x2dvEXT, glProgramUniformMatrix3x2dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper5(void, glProgramUniformMatrix3x4dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  AliasWrapper5(void, glProgramUniformMatrix3x4dvEXT, glProgramUniformMatrix3x4dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper5(void, glProgramUniformMatrix4dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  AliasWrapper5(void, glProgramUniformMatrix4dvEXT, glProgramUniformMatrix4dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper5(void, glProgramUniformMatrix4x2dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  AliasWrapper5(void, glProgramUniformMatrix4x2dvEXT, glProgramUniformMatrix4x2dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper5(void, glProgramUniformMatrix4x3dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  AliasWrapper5(void, glProgramUniformMatrix4x3dvEXT, glProgramUniformMatrix4x3dv, GLuint, program, GLint, location, GLsizei, count, GLboolean, transpose, const GLdouble *, value); \
  FuncWrapper6(void, glDrawRangeElements, GLenum, mode, GLuint, start, GLuint, end, GLsizei, count, GLenum, type, const void *, indices); \
  AliasWrapper6(void, glDrawRangeElementsEXT, glDrawRangeElements, GLenum, mode, GLuint, start, GLuint, end, GLsizei, count, GLenum, type, const void *, indices); \
  FuncWrapper7(void, glDrawRangeElementsBaseVertex, GLenum, mode, GLuint, start, GLuint, end, GLsizei, count, GLenum, type, const void *, indices, GLint, basevertex); \
  AliasWrapper7(void, glDrawRangeElementsBaseVertexEXT, glDrawRangeElementsBaseVertex, GLenum, mode, GLuint, start, GLuint, end, GLsizei, count, GLenum, type, const void *, indices, GLint, basevertex); \
  AliasWrapper7(void, glDrawRangeElementsBaseVertexOES, glDrawRangeElementsBaseVertex, GLenum, mode, GLuint, start, GLuint, end, GLsizei, count, GLenum, type, const void *, indices, GLint, basevertex); \
  FuncWrapper5(void, glDrawArraysInstancedBaseInstance, GLenum, mode, GLint, first, GLsizei, count, GLsizei, instancecount, GLuint, baseinstance); \
  AliasWrapper5(void, glDrawArraysInstancedBaseInstanceEXT, glDrawArraysInstancedBaseInstance, GLenum, mode, GLint, first, GLsizei, count, GLsizei, instancecount, GLuint, baseinstance); \
  FuncWrapper4(void, glDrawArraysInstanced, GLenum, mode, GLint, first, GLsizei, count, GLsizei, instancecount); \
  AliasWrapper4(void, glDrawArraysInstancedARB, glDrawArraysInstanced, GLenum, mode, GLint, first, GLsizei, count, GLsizei, instancecount); \
  AliasWrapper4(void, glDrawArraysInstancedEXT, glDrawArraysInstanced, GLenum, mode, GLint, first, GLsizei, count, GLsizei, instancecount); \
  FuncWrapper5(void, glDrawElementsInstanced, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLsizei, instancecount); \
  AliasWrapper5(void, glDrawElementsInstancedARB, glDrawElementsInstanced, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLsizei, instancecount); \
  AliasWrapper5(void, glDrawElementsInstancedEXT, glDrawElementsInstanced, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLsizei, instancecount); \
  FuncWrapper6(void, glDrawElementsInstancedBaseInstance, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLsizei, instancecount, GLuint, baseinstance); \
  AliasWrapper6(void, glDrawElementsInstancedBaseInstanceEXT, glDrawElementsInstancedBaseInstance, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLsizei, instancecount, GLuint, baseinstance); \
  FuncWrapper5(void, glDrawElementsBaseVertex, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLint, basevertex); \
  AliasWrapper5(void, glDrawElementsBaseVertexEXT, glDrawElementsBaseVertex, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLint, basevertex); \
  AliasWrapper5(void, glDrawElementsBaseVertexOES, glDrawElementsBaseVertex, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLint, basevertex); \
  FuncWrapper6(void, glDrawElementsInstancedBaseVertex, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLsizei, instancecount, GLint, basevertex); \
  AliasWrapper6(void, glDrawElementsInstancedBaseVertexEXT, glDrawElementsInstancedBaseVertex, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLsizei, instancecount, GLint, basevertex); \
  AliasWrapper6(void, glDrawElementsInstancedBaseVertexOES, glDrawElementsInstancedBaseVertex, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLsizei, instancecount, GLint, basevertex); \
  FuncWrapper7(void, glDrawElementsInstancedBaseVertexBaseInstance, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLsizei, instancecount, GLint, basevertex, GLuint, baseinstance); \
  AliasWrapper7(void, glDrawElementsInstancedBaseVertexBaseInstanceEXT, glDrawElementsInstancedBaseVertexBaseInstance, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLsizei, instancecount, GLint, basevertex, GLuint, baseinstance); \
  FuncWrapper4(void, glMultiDrawArrays, GLenum, mode, const GLint *, first, const GLsizei *, count, GLsizei, drawcount); \
  AliasWrapper4(void, glMultiDrawArraysEXT, glMultiDrawArrays, GLenum, mode, const GLint *, first, const GLsizei *, count, GLsizei, drawcount); \
  FuncWrapper5(void, glMultiDrawElements, GLenum, mode, const GLsizei *, count, GLenum, type, const void *const*, indices, GLsizei, drawcount); \
  FuncWrapper6(void, glMultiDrawElementsBaseVertex, GLenum, mode, const GLsizei *, count, GLenum, type, const void *const*, indices, GLsizei, drawcount, const GLint *, basevertex); \
  AliasWrapper6(void, glMultiDrawElementsBaseVertexEXT, glMultiDrawElementsBaseVertex, GLenum, mode, const GLsizei *, count, GLenum, type, const void *const*, indices, GLsizei, drawcount, const GLint *, basevertex); \
  AliasWrapper6(void, glMultiDrawElementsBaseVertexOES, glMultiDrawElementsBaseVertex, GLenum, mode, const GLsizei *, count, GLenum, type, const void *const*, indices, GLsizei, drawcount, const GLint *, basevertex); \
  FuncWrapper4(void, glMultiDrawArraysIndirect, GLenum, mode, const void *, indirect, GLsizei, drawcount, GLsizei, stride); \
  FuncWrapper5(void, glMultiDrawElementsIndirect, GLenum, mode, GLenum, type, const void *, indirect, GLsizei, drawcount, GLsizei, stride); \
  FuncWrapper2(void, glDrawArraysIndirect, GLenum, mode, const void *, indirect); \
  FuncWrapper3(void, glDrawElementsIndirect, GLenum, mode, GLenum, type, const void *, indirect); \
  FuncWrapper10(void, glBlitFramebuffer, GLint, srcX0, GLint, srcY0, GLint, srcX1, GLint, srcY1, GLint, dstX0, GLint, dstY0, GLint, dstX1, GLint, dstY1, GLbitfield, mask, GLenum, filter); \
  AliasWrapper10(void, glBlitFramebufferEXT, glBlitFramebuffer, GLint, srcX0, GLint, srcY0, GLint, srcX1, GLint, srcY1, GLint, dstX0, GLint, dstY0, GLint, dstX1, GLint, dstY1, GLbitfield, mask, GLenum, filter); \
  FuncWrapper8(void, glPrimitiveBoundingBox, GLfloat, minX, GLfloat, minY, GLfloat, minZ, GLfloat, minW, GLfloat, maxX, GLfloat, maxY, GLfloat, maxZ, GLfloat, maxW); \
  AliasWrapper8(void, glPrimitiveBoundingBoxARB, glPrimitiveBoundingBox, GLfloat, minX, GLfloat, minY, GLfloat, minZ, GLfloat, minW, GLfloat, maxX, GLfloat, maxY, GLfloat, maxZ, GLfloat, maxW); \
  AliasWrapper8(void, glPrimitiveBoundingBoxEXT, glPrimitiveBoundingBox, GLfloat, minX, GLfloat, minY, GLfloat, minZ, GLfloat, minW, GLfloat, maxX, GLfloat, maxY, GLfloat, maxZ, GLfloat, maxW); \
  AliasWrapper8(void, glPrimitiveBoundingBoxOES, glPrimitiveBoundingBox, GLfloat, minX, GLfloat, minY, GLfloat, minZ, GLfloat, minW, GLfloat, maxX, GLfloat, maxY, GLfloat, maxZ, GLfloat, maxW); \
  FuncWrapper0(void, glBlendBarrier); \
  FuncWrapper6(void, glFramebufferTexture2DMultisampleEXT, GLenum, target, GLenum, attachment, GLenum, textarget, GLuint, texture, GLint, level, GLsizei, samples); \
  FuncWrapper5(void, glRenderbufferStorageMultisampleEXT, GLenum, target, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  FuncWrapper3(void, glDiscardFramebufferEXT, GLenum, target, GLsizei, numAttachments, const GLenum *, attachments); \
  FuncWrapper3(void, glDepthRangeArrayfvOES, GLuint, first, GLsizei, count, const GLfloat *, v); \
  AliasWrapper3(void, glDepthRangeArrayfvNV, glDepthRangeArrayfvOES, GLuint, first, GLsizei, count, const GLfloat *, v); \
  FuncWrapper3(void, glDepthRangeIndexedfOES, GLuint, index, GLfloat, n, GLfloat, f); \
  AliasWrapper3(void, glDepthRangeIndexedfNV, glDepthRangeIndexedfOES, GLuint, index, GLfloat, n, GLfloat, f); \
  FuncWrapper5(void, glNamedStringARB, GLenum, type, GLint, namelen, const GLchar *, name, GLint, stringlen, const GLchar *, string); \
  FuncWrapper2(void, glDeleteNamedStringARB, GLint, namelen, const GLchar *, name); \
  FuncWrapper4(void, glCompileShaderIncludeARB, GLuint, shader, GLsizei, count, const GLchar *const*, path, const GLint *, length); \
  FuncWrapper2(GLboolean, glIsNamedStringARB, GLint, namelen, const GLchar *, name); \
  FuncWrapper5(void, glGetNamedStringARB, GLint, namelen, const GLchar *, name, GLsizei, bufSize, GLint *, stringlen, GLchar *, string); \
  FuncWrapper4(void, glGetNamedStringivARB, GLint, namelen, const GLchar *, name, GLenum, pname, GLint *, params); \
  FuncWrapper6(void, glDispatchComputeGroupSizeARB, GLuint, num_groups_x, GLuint, num_groups_y, GLuint, num_groups_z, GLuint, group_size_x, GLuint, group_size_y, GLuint, group_size_z); \
  FuncWrapper5(void, glMultiDrawArraysIndirectCount, GLenum, mode, const void *, indirect, GLintptr, drawcount, GLsizei, maxdrawcount, GLsizei, stride); \
  AliasWrapper5(void, glMultiDrawArraysIndirectCountARB, glMultiDrawArraysIndirectCount, GLenum, mode, const void *, indirect, GLintptr, drawcount, GLsizei, maxdrawcount, GLsizei, stride); \
  FuncWrapper6(void, glMultiDrawElementsIndirectCount, GLenum, mode, GLenum, type, const void *, indirect, GLintptr, drawcount, GLsizei, maxdrawcount, GLsizei, stride); \
  AliasWrapper6(void, glMultiDrawElementsIndirectCountARB, glMultiDrawElementsIndirectCount, GLenum, mode, GLenum, type, const void *, indirect, GLintptr, drawcount, GLsizei, maxdrawcount, GLsizei, stride); \
  FuncWrapper2(void, glRasterSamplesEXT, GLuint, samples, GLboolean, fixedsamplelocations); \
  FuncWrapper2(void, glDepthBoundsEXT, GLclampd, zmin, GLclampd, zmax); \
  FuncWrapper3(void, glPolygonOffsetClamp, GLfloat, factor, GLfloat, units, GLfloat, clamp); \
  AliasWrapper3(void, glPolygonOffsetClampEXT, glPolygonOffsetClamp, GLfloat, factor, GLfloat, units, GLfloat, clamp); \
  FuncWrapper2(void, glInsertEventMarkerEXT, GLsizei, length, const GLchar *, marker); \
  FuncWrapper2(void, glPushGroupMarkerEXT, GLsizei, length, const GLchar *, marker); \
  FuncWrapper0(void, glPopGroupMarkerEXT); \
  FuncWrapper0(void, glFrameTerminatorGREMEDY); \
  FuncWrapper2(void, glStringMarkerGREMEDY, GLsizei, len, const void *, string); \
  FuncWrapper6(void, glFramebufferTextureMultiviewOVR, GLenum, target, GLenum, attachment, GLuint, texture, GLint, level, GLint, baseViewIndex, GLsizei, numViews); \
  FuncWrapper7(void, glFramebufferTextureMultisampleMultiviewOVR, GLenum, target, GLenum, attachment, GLuint, texture, GLint, level, GLsizei, samples, GLint, baseViewIndex, GLsizei, numViews); \
  FuncWrapper8(void, glTextureFoveationParametersQCOM, GLuint, texture, GLuint, layer, GLuint, focalPoint, GLfloat, focalX, GLfloat, focalY, GLfloat, gainX, GLfloat, gainY, GLfloat, foveaArea); \
  FuncWrapper1(void, glMaxShaderCompilerThreadsKHR, GLuint, count); \
  AliasWrapper1(void, glMaxShaderCompilerThreadsARB, glMaxShaderCompilerThreadsKHR, GLuint, count); \
  FuncWrapper5(void, glSpecializeShader, GLuint, shader, const GLchar *, pEntryPoint, GLuint, numSpecializationConstants, const GLuint *, pConstantIndex, const GLuint *, pConstantValue); \
  AliasWrapper5(void, glSpecializeShaderARB, glSpecializeShader, GLuint, shader, const GLchar *, pEntryPoint, GLuint, numSpecializationConstants, const GLuint *, pConstantIndex, const GLuint *, pConstantValue); \
  FuncWrapper2(void, glGetUnsignedBytevEXT, GLenum, pname, GLubyte *, data); \
  FuncWrapper3(void, glGetUnsignedBytei_vEXT, GLenum, target, GLuint, index, GLubyte *, data); \
  FuncWrapper2(void, glDeleteMemoryObjectsEXT, GLsizei, n, const GLuint *, memoryObjects); \
  FuncWrapper1(GLboolean, glIsMemoryObjectEXT, GLuint, memoryObject); \
  FuncWrapper2(void, glCreateMemoryObjectsEXT, GLsizei, n, GLuint *, memoryObjects); \
  FuncWrapper3(void, glMemoryObjectParameterivEXT, GLuint, memoryObject, GLenum, pname, const GLint *, params); \
  FuncWrapper3(void, glGetMemoryObjectParameterivEXT, GLuint, memoryObject, GLenum, pname, GLint *, params); \
  FuncWrapper7(void, glTexStorageMem2DEXT, GLenum, target, GLsizei, levels, GLenum, internalFormat, GLsizei, width, GLsizei, height, GLuint, memory, GLuint64, offset); \
  FuncWrapper8(void, glTexStorageMem2DMultisampleEXT, GLenum, target, GLsizei, samples, GLenum, internalFormat, GLsizei, width, GLsizei, height, GLboolean, fixedSampleLocations, GLuint, memory, GLuint64, offset); \
  FuncWrapper8(void, glTexStorageMem3DEXT, GLenum, target, GLsizei, levels, GLenum, internalFormat, GLsizei, width, GLsizei, height, GLsizei, depth, GLuint, memory, GLuint64, offset); \
  FuncWrapper9(void, glTexStorageMem3DMultisampleEXT, GLenum, target, GLsizei, samples, GLenum, internalFormat, GLsizei, width, GLsizei, height, GLsizei, depth, GLboolean, fixedSampleLocations, GLuint, memory, GLuint64, offset); \
  FuncWrapper4(void, glBufferStorageMemEXT, GLenum, target, GLsizeiptr, size, GLuint, memory, GLuint64, offset); \
  FuncWrapper7(void, glTextureStorageMem2DEXT, GLuint, texture, GLsizei, levels, GLenum, internalFormat, GLsizei, width, GLsizei, height, GLuint, memory, GLuint64, offset); \
  FuncWrapper8(void, glTextureStorageMem2DMultisampleEXT, GLuint, texture, GLsizei, samples, GLenum, internalFormat, GLsizei, width, GLsizei, height, GLboolean, fixedSampleLocations, GLuint, memory, GLuint64, offset); \
  FuncWrapper8(void, glTextureStorageMem3DEXT, GLuint, texture, GLsizei, levels, GLenum, internalFormat, GLsizei, width, GLsizei, height, GLsizei, depth, GLuint, memory, GLuint64, offset); \
  FuncWrapper9(void, glTextureStorageMem3DMultisampleEXT, GLuint, texture, GLsizei, samples, GLenum, internalFormat, GLsizei, width, GLsizei, height, GLsizei, depth, GLboolean, fixedSampleLocations, GLuint, memory, GLuint64, offset); \
  FuncWrapper4(void, glNamedBufferStorageMemEXT, GLuint, buffer, GLsizeiptr, size, GLuint, memory, GLuint64, offset); \
  FuncWrapper6(void, glTexStorageMem1DEXT, GLenum, target, GLsizei, levels, GLenum, internalFormat, GLsizei, width, GLuint, memory, GLuint64, offset); \
  FuncWrapper6(void, glTextureStorageMem1DEXT, GLuint, texture, GLsizei, levels, GLenum, internalFormat, GLsizei, width, GLuint, memory, GLuint64, offset); \
  FuncWrapper2(void, glGenSemaphoresEXT, GLsizei, n, GLuint *, semaphores); \
  FuncWrapper2(void, glDeleteSemaphoresEXT, GLsizei, n, const GLuint *, semaphores); \
  FuncWrapper1(GLboolean, glIsSemaphoreEXT, GLuint, semaphore); \
  FuncWrapper3(void, glSemaphoreParameterui64vEXT, GLuint, semaphore, GLenum, pname, const GLuint64 *, params); \
  FuncWrapper3(void, glGetSemaphoreParameterui64vEXT, GLuint, semaphore, GLenum, pname, GLuint64 *, params); \
  FuncWrapper6(void, glWaitSemaphoreEXT, GLuint, semaphore, GLuint, numBufferBarriers, const GLuint *, buffers, GLuint, numTextureBarriers, const GLuint *, textures, const GLenum *, srcLayouts); \
  FuncWrapper6(void, glSignalSemaphoreEXT, GLuint, semaphore, GLuint, numBufferBarriers, const GLuint *, buffers, GLuint, numTextureBarriers, const GLuint *, textures, const GLenum *, dstLayouts); \
  FuncWrapper4(void, glImportMemoryFdEXT, GLuint, memory, GLuint64, size, GLenum, handleType, GLint, fd); \
  FuncWrapper3(void, glImportSemaphoreFdEXT, GLuint, semaphore, GLenum, handleType, GLint, fd); \
  FuncWrapper4(void, glImportMemoryWin32HandleEXT, GLuint, memory, GLuint64, size, GLenum, handleType, void *, handle); \
  FuncWrapper4(void, glImportMemoryWin32NameEXT, GLuint, memory, GLuint64, size, GLenum, handleType, const void *, name); \
  FuncWrapper3(void, glImportSemaphoreWin32HandleEXT, GLuint, semaphore, GLenum, handleType, void *, handle); \
  FuncWrapper3(void, glImportSemaphoreWin32NameEXT, GLuint, semaphore, GLenum, handleType, const void *, name); \
  FuncWrapper3(GLboolean, glAcquireKeyedMutexWin32EXT, GLuint, memory, GLuint64, key, GLuint, timeout); \
  FuncWrapper2(GLboolean, glReleaseKeyedMutexWin32EXT, GLuint, memory, GLuint64, key); \
  FuncWrapper8(void, glCompressedTextureImage1DEXT, GLuint, texture, GLenum, target, GLint, level, GLenum, internalformat, GLsizei, width, GLint, border, GLsizei, imageSize, const void *, bits); \
  FuncWrapper9(void, glCompressedTextureImage2DEXT, GLuint, texture, GLenum, target, GLint, level, GLenum, internalformat, GLsizei, width, GLsizei, height, GLint, border, GLsizei, imageSize, const void *, bits); \
  FuncWrapper10(void, glCompressedTextureImage3DEXT, GLuint, texture, GLenum, target, GLint, level, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLint, border, GLsizei, imageSize, const void *, bits); \
  FuncWrapper8(void, glCompressedTextureSubImage1DEXT, GLuint, texture, GLenum, target, GLint, level, GLint, xoffset, GLsizei, width, GLenum, format, GLsizei, imageSize, const void *, bits); \
  FuncWrapper10(void, glCompressedTextureSubImage2DEXT, GLuint, texture, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLsizei, width, GLsizei, height, GLenum, format, GLsizei, imageSize, const void *, bits); \
  FuncWrapper12(void, glCompressedTextureSubImage3DEXT, GLuint, texture, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLsizei, imageSize, const void *, bits); \
  FuncWrapper2(void, glGenerateTextureMipmapEXT, GLuint, texture, GLenum, target); \
  FuncWrapper3(void, glGetPointeri_vEXT, GLenum, pname, GLuint, index, void **, params); \
  FuncWrapper3(void, glGetDoubleIndexedvEXT, GLenum, target, GLuint, index, GLdouble *, data); \
  FuncWrapper3(void, glGetPointerIndexedvEXT, GLenum, target, GLuint, index, void **, data); \
  FuncWrapper3(void, glGetIntegerIndexedvEXT, GLenum, target, GLuint, index, GLint *, data); \
  FuncWrapper3(void, glGetBooleanIndexedvEXT, GLenum, target, GLuint, index, GLboolean *, data); \
  FuncWrapper3(void, glGetFloatIndexedvEXT, GLenum, target, GLuint, index, GLfloat *, data); \
  FuncWrapper6(void, glGetMultiTexImageEXT, GLenum, texunit, GLenum, target, GLint, level, GLenum, format, GLenum, type, void *, pixels); \
  FuncWrapper4(void, glGetMultiTexParameterfvEXT, GLenum, texunit, GLenum, target, GLenum, pname, GLfloat *, params); \
  FuncWrapper4(void, glGetMultiTexParameterivEXT, GLenum, texunit, GLenum, target, GLenum, pname, GLint *, params); \
  FuncWrapper4(void, glGetMultiTexParameterIivEXT, GLenum, texunit, GLenum, target, GLenum, pname, GLint *, params); \
  FuncWrapper4(void, glGetMultiTexParameterIuivEXT, GLenum, texunit, GLenum, target, GLenum, pname, GLuint *, params); \
  FuncWrapper5(void, glGetMultiTexLevelParameterfvEXT, GLenum, texunit, GLenum, target, GLint, level, GLenum, pname, GLfloat *, params); \
  FuncWrapper5(void, glGetMultiTexLevelParameterivEXT, GLenum, texunit, GLenum, target, GLint, level, GLenum, pname, GLint *, params); \
  FuncWrapper4(void, glGetCompressedMultiTexImageEXT, GLenum, texunit, GLenum, target, GLint, lod, void *, img); \
  FuncWrapper3(void, glGetNamedBufferPointervEXT, GLuint, buffer, GLenum, pname, void **, params); \
  AliasWrapper3(void, glGetNamedBufferPointerv, glGetNamedBufferPointervEXT, GLuint, buffer, GLenum, pname, void **, params); \
  FuncWrapper4(void, glGetNamedProgramivEXT, GLuint, program, GLenum, target, GLenum, pname, GLint *, params); \
  FuncWrapper4(void, glGetNamedFramebufferAttachmentParameterivEXT, GLuint, framebuffer, GLenum, attachment, GLenum, pname, GLint *, params); \
  AliasWrapper4(void, glGetNamedFramebufferAttachmentParameteriv, glGetNamedFramebufferAttachmentParameterivEXT, GLuint, framebuffer, GLenum, attachment, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetNamedBufferParameterivEXT, GLuint, buffer, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetNamedBufferParameteriv, glGetNamedBufferParameterivEXT, GLuint, buffer, GLenum, pname, GLint *, params); \
  FuncWrapper2(GLenum, glCheckNamedFramebufferStatusEXT, GLuint, framebuffer, GLenum, target); \
  AliasWrapper2(GLenum, glCheckNamedFramebufferStatus, glCheckNamedFramebufferStatusEXT, GLuint, framebuffer, GLenum, target); \
  FuncWrapper4(void, glGetNamedBufferSubDataEXT, GLuint, buffer, GLintptr, offset, GLsizeiptr, size, void *, data); \
  FuncWrapper3(void, glGetNamedFramebufferParameterivEXT, GLuint, framebuffer, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetFramebufferParameterivEXT, glGetNamedFramebufferParameterivEXT, GLuint, framebuffer, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetNamedFramebufferParameteriv, glGetNamedFramebufferParameterivEXT, GLuint, framebuffer, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetNamedRenderbufferParameterivEXT, GLuint, renderbuffer, GLenum, pname, GLint *, params); \
  AliasWrapper3(void, glGetNamedRenderbufferParameteriv, glGetNamedRenderbufferParameterivEXT, GLuint, renderbuffer, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetVertexArrayIntegervEXT, GLuint, vaobj, GLenum, pname, GLint *, param); \
  FuncWrapper3(void, glGetVertexArrayPointervEXT, GLuint, vaobj, GLenum, pname, void **, param); \
  FuncWrapper4(void, glGetVertexArrayIntegeri_vEXT, GLuint, vaobj, GLuint, index, GLenum, pname, GLint *, param); \
  FuncWrapper4(void, glGetVertexArrayPointeri_vEXT, GLuint, vaobj, GLuint, index, GLenum, pname, void **, param); \
  FuncWrapper4(void, glGetCompressedTextureImageEXT, GLuint, texture, GLenum, target, GLint, lod, void *, img); \
  FuncWrapper6(void, glGetTextureImageEXT, GLuint, texture, GLenum, target, GLint, level, GLenum, format, GLenum, type, void *, pixels); \
  FuncWrapper4(void, glGetTextureParameterivEXT, GLuint, texture, GLenum, target, GLenum, pname, GLint *, params); \
  FuncWrapper4(void, glGetTextureParameterfvEXT, GLuint, texture, GLenum, target, GLenum, pname, GLfloat *, params); \
  FuncWrapper4(void, glGetTextureParameterIivEXT, GLuint, texture, GLenum, target, GLenum, pname, GLint *, params); \
  FuncWrapper4(void, glGetTextureParameterIuivEXT, GLuint, texture, GLenum, target, GLenum, pname, GLuint *, params); \
  FuncWrapper5(void, glGetTextureLevelParameterivEXT, GLuint, texture, GLenum, target, GLint, level, GLenum, pname, GLint *, params); \
  FuncWrapper5(void, glGetTextureLevelParameterfvEXT, GLuint, texture, GLenum, target, GLint, level, GLenum, pname, GLfloat *, params); \
  FuncWrapper3(void, glBindMultiTextureEXT, GLenum, texunit, GLenum, target, GLuint, texture); \
  FuncWrapper2(void *, glMapNamedBufferEXT, GLuint, buffer, GLenum, access); \
  AliasWrapper2(void *, glMapNamedBuffer, glMapNamedBufferEXT, GLuint, buffer, GLenum, access); \
  FuncWrapper4(void *, glMapNamedBufferRangeEXT, GLuint, buffer, GLintptr, offset, GLsizeiptr, length, GLbitfield, access); \
  FuncWrapper3(void, glFlushMappedNamedBufferRangeEXT, GLuint, buffer, GLintptr, offset, GLsizeiptr, length); \
  FuncWrapper1(GLboolean, glUnmapNamedBufferEXT, GLuint, buffer); \
  AliasWrapper1(GLboolean, glUnmapNamedBuffer, glUnmapNamedBufferEXT, GLuint, buffer); \
  FuncWrapper5(void, glClearNamedBufferDataEXT, GLuint, buffer, GLenum, internalformat, GLenum, format, GLenum, type, const void *, data); \
  AliasWrapper5(void, glClearNamedBufferData, glClearNamedBufferDataEXT, GLuint, buffer, GLenum, internalformat, GLenum, format, GLenum, type, const void *, data); \
  FuncWrapper7(void, glClearNamedBufferSubDataEXT, GLuint, buffer, GLenum, internalformat, GLsizeiptr, offset, GLsizeiptr, size, GLenum, format, GLenum, type, const void *, data); \
  FuncWrapper4(void, glNamedBufferDataEXT, GLuint, buffer, GLsizeiptr, size, const void *, data, GLenum, usage); \
  FuncWrapper4(void, glNamedBufferStorageEXT, GLuint, buffer, GLsizeiptr, size, const void *, data, GLbitfield, flags); \
  FuncWrapper4(void, glNamedBufferSubDataEXT, GLuint, buffer, GLintptr, offset, GLsizeiptr, size, const void *, data); \
  FuncWrapper5(void, glNamedCopyBufferSubDataEXT, GLuint, readBuffer, GLuint, writeBuffer, GLintptr, readOffset, GLintptr, writeOffset, GLsizeiptr, size); \
  FuncWrapper4(void, glNamedFramebufferTextureEXT, GLuint, framebuffer, GLenum, attachment, GLuint, texture, GLint, level); \
  AliasWrapper4(void, glNamedFramebufferTexture, glNamedFramebufferTextureEXT, GLuint, framebuffer, GLenum, attachment, GLuint, texture, GLint, level); \
  FuncWrapper5(void, glNamedFramebufferTexture1DEXT, GLuint, framebuffer, GLenum, attachment, GLenum, textarget, GLuint, texture, GLint, level); \
  FuncWrapper5(void, glNamedFramebufferTexture2DEXT, GLuint, framebuffer, GLenum, attachment, GLenum, textarget, GLuint, texture, GLint, level); \
  FuncWrapper6(void, glNamedFramebufferTexture3DEXT, GLuint, framebuffer, GLenum, attachment, GLenum, textarget, GLuint, texture, GLint, level, GLint, zoffset); \
  FuncWrapper4(void, glNamedFramebufferRenderbufferEXT, GLuint, framebuffer, GLenum, attachment, GLenum, renderbuffertarget, GLuint, renderbuffer); \
  AliasWrapper4(void, glNamedFramebufferRenderbuffer, glNamedFramebufferRenderbufferEXT, GLuint, framebuffer, GLenum, attachment, GLenum, renderbuffertarget, GLuint, renderbuffer); \
  FuncWrapper5(void, glNamedFramebufferTextureLayerEXT, GLuint, framebuffer, GLenum, attachment, GLuint, texture, GLint, level, GLint, layer); \
  AliasWrapper5(void, glNamedFramebufferTextureLayer, glNamedFramebufferTextureLayerEXT, GLuint, framebuffer, GLenum, attachment, GLuint, texture, GLint, level, GLint, layer); \
  FuncWrapper3(void, glNamedFramebufferParameteriEXT, GLuint, framebuffer, GLenum, pname, GLint, param); \
  AliasWrapper3(void, glNamedFramebufferParameteri, glNamedFramebufferParameteriEXT, GLuint, framebuffer, GLenum, pname, GLint, param); \
  FuncWrapper4(void, glNamedRenderbufferStorageEXT, GLuint, renderbuffer, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  AliasWrapper4(void, glNamedRenderbufferStorage, glNamedRenderbufferStorageEXT, GLuint, renderbuffer, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  FuncWrapper5(void, glNamedRenderbufferStorageMultisampleEXT, GLuint, renderbuffer, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  AliasWrapper5(void, glNamedRenderbufferStorageMultisample, glNamedRenderbufferStorageMultisampleEXT, GLuint, renderbuffer, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  FuncWrapper2(void, glFramebufferDrawBufferEXT, GLuint, framebuffer, GLenum, mode); \
  AliasWrapper2(void, glNamedFramebufferDrawBuffer, glFramebufferDrawBufferEXT, GLuint, framebuffer, GLenum, mode); \
  FuncWrapper3(void, glFramebufferDrawBuffersEXT, GLuint, framebuffer, GLsizei, n, const GLenum *, bufs); \
  AliasWrapper3(void, glNamedFramebufferDrawBuffers, glFramebufferDrawBuffersEXT, GLuint, framebuffer, GLsizei, n, const GLenum *, bufs); \
  FuncWrapper2(void, glFramebufferReadBufferEXT, GLuint, framebuffer, GLenum, mode); \
  AliasWrapper2(void, glNamedFramebufferReadBuffer, glFramebufferReadBufferEXT, GLuint, framebuffer, GLenum, mode); \
  FuncWrapper4(void, glTextureBufferEXT, GLuint, texture, GLenum, target, GLenum, internalformat, GLuint, buffer); \
  FuncWrapper6(void, glTextureBufferRangeEXT, GLuint, texture, GLenum, target, GLenum, internalformat, GLuint, buffer, GLintptr, offset, GLsizeiptr, size); \
  FuncWrapper9(void, glTextureImage1DEXT, GLuint, texture, GLenum, target, GLint, level, GLint, internalformat, GLsizei, width, GLint, border, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper10(void, glTextureImage2DEXT, GLuint, texture, GLenum, target, GLint, level, GLint, internalformat, GLsizei, width, GLsizei, height, GLint, border, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper11(void, glTextureImage3DEXT, GLuint, texture, GLenum, target, GLint, level, GLint, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLint, border, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper4(void, glTextureParameterfEXT, GLuint, texture, GLenum, target, GLenum, pname, GLfloat, param); \
  FuncWrapper4(void, glTextureParameterfvEXT, GLuint, texture, GLenum, target, GLenum, pname, const GLfloat *, params); \
  FuncWrapper4(void, glTextureParameteriEXT, GLuint, texture, GLenum, target, GLenum, pname, GLint, param); \
  FuncWrapper4(void, glTextureParameterivEXT, GLuint, texture, GLenum, target, GLenum, pname, const GLint *, params); \
  FuncWrapper4(void, glTextureParameterIivEXT, GLuint, texture, GLenum, target, GLenum, pname, const GLint *, params); \
  FuncWrapper4(void, glTextureParameterIuivEXT, GLuint, texture, GLenum, target, GLenum, pname, const GLuint *, params); \
  FuncWrapper5(void, glTextureStorage1DEXT, GLuint, texture, GLenum, target, GLsizei, levels, GLenum, internalformat, GLsizei, width); \
  FuncWrapper6(void, glTextureStorage2DEXT, GLuint, texture, GLenum, target, GLsizei, levels, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  FuncWrapper7(void, glTextureStorage3DEXT, GLuint, texture, GLenum, target, GLsizei, levels, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth); \
  FuncWrapper7(void, glTextureStorage2DMultisampleEXT, GLuint, texture, GLenum, target, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height, GLboolean, fixedsamplelocations); \
  FuncWrapper8(void, glTextureStorage3DMultisampleEXT, GLuint, texture, GLenum, target, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLboolean, fixedsamplelocations); \
  FuncWrapper8(void, glTextureSubImage1DEXT, GLuint, texture, GLenum, target, GLint, level, GLint, xoffset, GLsizei, width, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper10(void, glTextureSubImage2DEXT, GLuint, texture, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper12(void, glTextureSubImage3DEXT, GLuint, texture, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper8(void, glCopyTextureImage1DEXT, GLuint, texture, GLenum, target, GLint, level, GLenum, internalformat, GLint, x, GLint, y, GLsizei, width, GLint, border); \
  FuncWrapper9(void, glCopyTextureImage2DEXT, GLuint, texture, GLenum, target, GLint, level, GLenum, internalformat, GLint, x, GLint, y, GLsizei, width, GLsizei, height, GLint, border); \
  FuncWrapper7(void, glCopyTextureSubImage1DEXT, GLuint, texture, GLenum, target, GLint, level, GLint, xoffset, GLint, x, GLint, y, GLsizei, width); \
  FuncWrapper9(void, glCopyTextureSubImage2DEXT, GLuint, texture, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  FuncWrapper10(void, glCopyTextureSubImage3DEXT, GLuint, texture, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  FuncWrapper4(void, glMultiTexParameteriEXT, GLenum, texunit, GLenum, target, GLenum, pname, GLint, param); \
  FuncWrapper4(void, glMultiTexParameterivEXT, GLenum, texunit, GLenum, target, GLenum, pname, const GLint *, params); \
  FuncWrapper4(void, glMultiTexParameterfEXT, GLenum, texunit, GLenum, target, GLenum, pname, GLfloat, param); \
  FuncWrapper4(void, glMultiTexParameterfvEXT, GLenum, texunit, GLenum, target, GLenum, pname, const GLfloat *, params); \
  FuncWrapper9(void, glMultiTexImage1DEXT, GLenum, texunit, GLenum, target, GLint, level, GLint, internalformat, GLsizei, width, GLint, border, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper10(void, glMultiTexImage2DEXT, GLenum, texunit, GLenum, target, GLint, level, GLint, internalformat, GLsizei, width, GLsizei, height, GLint, border, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper8(void, glMultiTexSubImage1DEXT, GLenum, texunit, GLenum, target, GLint, level, GLint, xoffset, GLsizei, width, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper10(void, glMultiTexSubImage2DEXT, GLenum, texunit, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper8(void, glCopyMultiTexImage1DEXT, GLenum, texunit, GLenum, target, GLint, level, GLenum, internalformat, GLint, x, GLint, y, GLsizei, width, GLint, border); \
  FuncWrapper9(void, glCopyMultiTexImage2DEXT, GLenum, texunit, GLenum, target, GLint, level, GLenum, internalformat, GLint, x, GLint, y, GLsizei, width, GLsizei, height, GLint, border); \
  FuncWrapper7(void, glCopyMultiTexSubImage1DEXT, GLenum, texunit, GLenum, target, GLint, level, GLint, xoffset, GLint, x, GLint, y, GLsizei, width); \
  FuncWrapper9(void, glCopyMultiTexSubImage2DEXT, GLenum, texunit, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  FuncWrapper11(void, glMultiTexImage3DEXT, GLenum, texunit, GLenum, target, GLint, level, GLint, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLint, border, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper12(void, glMultiTexSubImage3DEXT, GLenum, texunit, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper10(void, glCopyMultiTexSubImage3DEXT, GLenum, texunit, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  FuncWrapper10(void, glCompressedMultiTexImage3DEXT, GLenum, texunit, GLenum, target, GLint, level, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLint, border, GLsizei, imageSize, const void *, bits); \
  FuncWrapper9(void, glCompressedMultiTexImage2DEXT, GLenum, texunit, GLenum, target, GLint, level, GLenum, internalformat, GLsizei, width, GLsizei, height, GLint, border, GLsizei, imageSize, const void *, bits); \
  FuncWrapper8(void, glCompressedMultiTexImage1DEXT, GLenum, texunit, GLenum, target, GLint, level, GLenum, internalformat, GLsizei, width, GLint, border, GLsizei, imageSize, const void *, bits); \
  FuncWrapper12(void, glCompressedMultiTexSubImage3DEXT, GLenum, texunit, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLsizei, imageSize, const void *, bits); \
  FuncWrapper10(void, glCompressedMultiTexSubImage2DEXT, GLenum, texunit, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLsizei, width, GLsizei, height, GLenum, format, GLsizei, imageSize, const void *, bits); \
  FuncWrapper8(void, glCompressedMultiTexSubImage1DEXT, GLenum, texunit, GLenum, target, GLint, level, GLint, xoffset, GLsizei, width, GLenum, format, GLsizei, imageSize, const void *, bits); \
  FuncWrapper4(void, glMultiTexBufferEXT, GLenum, texunit, GLenum, target, GLenum, internalformat, GLuint, buffer); \
  FuncWrapper4(void, glMultiTexParameterIivEXT, GLenum, texunit, GLenum, target, GLenum, pname, const GLint *, params); \
  FuncWrapper4(void, glMultiTexParameterIuivEXT, GLenum, texunit, GLenum, target, GLenum, pname, const GLuint *, params); \
  FuncWrapper2(void, glGenerateMultiTexMipmapEXT, GLenum, texunit, GLenum, target); \
  FuncWrapper8(void, glVertexArrayVertexAttribOffsetEXT, GLuint, vaobj, GLuint, buffer, GLuint, index, GLint, size, GLenum, type, GLboolean, normalized, GLsizei, stride, GLintptr, offset); \
  FuncWrapper7(void, glVertexArrayVertexAttribIOffsetEXT, GLuint, vaobj, GLuint, buffer, GLuint, index, GLint, size, GLenum, type, GLsizei, stride, GLintptr, offset); \
  FuncWrapper2(void, glEnableVertexArrayAttribEXT, GLuint, vaobj, GLuint, index); \
  AliasWrapper2(void, glEnableVertexArrayAttrib, glEnableVertexArrayAttribEXT, GLuint, vaobj, GLuint, index); \
  FuncWrapper2(void, glDisableVertexArrayAttribEXT, GLuint, vaobj, GLuint, index); \
  AliasWrapper2(void, glDisableVertexArrayAttrib, glDisableVertexArrayAttribEXT, GLuint, vaobj, GLuint, index); \
  FuncWrapper5(void, glVertexArrayBindVertexBufferEXT, GLuint, vaobj, GLuint, bindingindex, GLuint, buffer, GLintptr, offset, GLsizei, stride); \
  AliasWrapper5(void, glVertexArrayVertexBuffer, glVertexArrayBindVertexBufferEXT, GLuint, vaobj, GLuint, bindingindex, GLuint, buffer, GLintptr, offset, GLsizei, stride); \
  FuncWrapper6(void, glVertexArrayVertexAttribFormatEXT, GLuint, vaobj, GLuint, attribindex, GLint, size, GLenum, type, GLboolean, normalized, GLuint, relativeoffset); \
  AliasWrapper6(void, glVertexArrayAttribFormat, glVertexArrayVertexAttribFormatEXT, GLuint, vaobj, GLuint, attribindex, GLint, size, GLenum, type, GLboolean, normalized, GLuint, relativeoffset); \
  FuncWrapper5(void, glVertexArrayVertexAttribIFormatEXT, GLuint, vaobj, GLuint, attribindex, GLint, size, GLenum, type, GLuint, relativeoffset); \
  AliasWrapper5(void, glVertexArrayAttribIFormat, glVertexArrayVertexAttribIFormatEXT, GLuint, vaobj, GLuint, attribindex, GLint, size, GLenum, type, GLuint, relativeoffset); \
  FuncWrapper5(void, glVertexArrayVertexAttribLFormatEXT, GLuint, vaobj, GLuint, attribindex, GLint, size, GLenum, type, GLuint, relativeoffset); \
  AliasWrapper5(void, glVertexArrayAttribLFormat, glVertexArrayVertexAttribLFormatEXT, GLuint, vaobj, GLuint, attribindex, GLint, size, GLenum, type, GLuint, relativeoffset); \
  FuncWrapper3(void, glVertexArrayVertexAttribBindingEXT, GLuint, vaobj, GLuint, attribindex, GLuint, bindingindex); \
  AliasWrapper3(void, glVertexArrayAttribBinding, glVertexArrayVertexAttribBindingEXT, GLuint, vaobj, GLuint, attribindex, GLuint, bindingindex); \
  FuncWrapper3(void, glVertexArrayVertexBindingDivisorEXT, GLuint, vaobj, GLuint, bindingindex, GLuint, divisor); \
  AliasWrapper3(void, glVertexArrayBindingDivisor, glVertexArrayVertexBindingDivisorEXT, GLuint, vaobj, GLuint, bindingindex, GLuint, divisor); \
  FuncWrapper7(void, glVertexArrayVertexAttribLOffsetEXT, GLuint, vaobj, GLuint, buffer, GLuint, index, GLint, size, GLenum, type, GLsizei, stride, GLintptr, offset); \
  FuncWrapper3(void, glVertexArrayVertexAttribDivisorEXT, GLuint, vaobj, GLuint, index, GLuint, divisor); \
  FuncWrapper2(void, glCreateTransformFeedbacks, GLsizei, n, GLuint *, ids); \
  FuncWrapper3(void, glTransformFeedbackBufferBase, GLuint, xfb, GLuint, index, GLuint, buffer); \
  FuncWrapper5(void, glTransformFeedbackBufferRange, GLuint, xfb, GLuint, index, GLuint, buffer, GLintptr, offset, GLsizeiptr, size); \
  FuncWrapper4(void, glGetTransformFeedbacki64_v, GLuint, xfb, GLenum, pname, GLuint, index, GLint64 *, param); \
  FuncWrapper4(void, glGetTransformFeedbacki_v, GLuint, xfb, GLenum, pname, GLuint, index, GLint *, param); \
  FuncWrapper3(void, glGetTransformFeedbackiv, GLuint, xfb, GLenum, pname, GLint *, param); \
  FuncWrapper2(void, glCreateBuffers, GLsizei, n, GLuint *, buffers); \
  FuncWrapper4(void, glGetNamedBufferSubData, GLuint, buffer, GLintptr, offset, GLsizeiptr, size, void *, data); \
  FuncWrapper4(void, glNamedBufferStorage, GLuint, buffer, GLsizeiptr, size, const void *, data, GLbitfield, flags); \
  FuncWrapper4(void, glNamedBufferData, GLuint, buffer, GLsizeiptr, size, const void *, data, GLenum, usage); \
  FuncWrapper4(void, glNamedBufferSubData, GLuint, buffer, GLintptr, offset, GLsizeiptr, size, const void *, data); \
  FuncWrapper5(void, glCopyNamedBufferSubData, GLuint, readBuffer, GLuint, writeBuffer, GLintptr, readOffset, GLintptr, writeOffset, GLsizeiptr, size); \
  FuncWrapper7(void, glClearNamedBufferSubData, GLuint, buffer, GLenum, internalformat, GLintptr, offset, GLsizeiptr, size, GLenum, format, GLenum, type, const void *, data); \
  FuncWrapper4(void *, glMapNamedBufferRange, GLuint, buffer, GLintptr, offset, GLsizeiptr, length, GLbitfield, access); \
  FuncWrapper3(void, glFlushMappedNamedBufferRange, GLuint, buffer, GLintptr, offset, GLsizeiptr, length); \
  FuncWrapper3(void, glGetNamedBufferParameteri64v, GLuint, buffer, GLenum, pname, GLint64 *, params); \
  FuncWrapper2(void, glCreateFramebuffers, GLsizei, n, GLuint *, framebuffers); \
  FuncWrapper3(void, glInvalidateNamedFramebufferData, GLuint, framebuffer, GLsizei, numAttachments, const GLenum *, attachments); \
  FuncWrapper7(void, glInvalidateNamedFramebufferSubData, GLuint, framebuffer, GLsizei, numAttachments, const GLenum *, attachments, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  FuncWrapper4(void, glClearNamedFramebufferiv, GLuint, framebuffer, GLenum, buffer, GLint, drawbuffer, const GLint *, value); \
  FuncWrapper4(void, glClearNamedFramebufferuiv, GLuint, framebuffer, GLenum, buffer, GLint, drawbuffer, const GLuint *, value); \
  FuncWrapper4(void, glClearNamedFramebufferfv, GLuint, framebuffer, GLenum, buffer, GLint, drawbuffer, const GLfloat *, value); \
  FuncWrapper5(void, glClearNamedFramebufferfi, GLuint, framebuffer, GLenum, buffer, GLint, drawbuffer, GLfloat, depth, GLint, stencil); \
  FuncWrapper12(void, glBlitNamedFramebuffer, GLuint, readFramebuffer, GLuint, drawFramebuffer, GLint, srcX0, GLint, srcY0, GLint, srcX1, GLint, srcY1, GLint, dstX0, GLint, dstY0, GLint, dstX1, GLint, dstY1, GLbitfield, mask, GLenum, filter); \
  FuncWrapper2(void, glCreateRenderbuffers, GLsizei, n, GLuint *, renderbuffers); \
  FuncWrapper3(void, glCreateTextures, GLenum, target, GLsizei, n, GLuint *, textures); \
  FuncWrapper3(void, glTextureBuffer, GLuint, texture, GLenum, internalformat, GLuint, buffer); \
  FuncWrapper5(void, glTextureBufferRange, GLuint, texture, GLenum, internalformat, GLuint, buffer, GLintptr, offset, GLsizeiptr, size); \
  FuncWrapper4(void, glTextureStorage1D, GLuint, texture, GLsizei, levels, GLenum, internalformat, GLsizei, width); \
  FuncWrapper5(void, glTextureStorage2D, GLuint, texture, GLsizei, levels, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  FuncWrapper6(void, glTextureStorage3D, GLuint, texture, GLsizei, levels, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth); \
  FuncWrapper6(void, glTextureStorage2DMultisample, GLuint, texture, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height, GLboolean, fixedsamplelocations); \
  FuncWrapper7(void, glTextureStorage3DMultisample, GLuint, texture, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLboolean, fixedsamplelocations); \
  FuncWrapper7(void, glTextureSubImage1D, GLuint, texture, GLint, level, GLint, xoffset, GLsizei, width, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper9(void, glTextureSubImage2D, GLuint, texture, GLint, level, GLint, xoffset, GLint, yoffset, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper11(void, glTextureSubImage3D, GLuint, texture, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLenum, type, const void *, pixels); \
  FuncWrapper7(void, glCompressedTextureSubImage1D, GLuint, texture, GLint, level, GLint, xoffset, GLsizei, width, GLenum, format, GLsizei, imageSize, const void *, data); \
  FuncWrapper9(void, glCompressedTextureSubImage2D, GLuint, texture, GLint, level, GLint, xoffset, GLint, yoffset, GLsizei, width, GLsizei, height, GLenum, format, GLsizei, imageSize, const void *, data); \
  FuncWrapper11(void, glCompressedTextureSubImage3D, GLuint, texture, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLsizei, imageSize, const void *, data); \
  FuncWrapper6(void, glCopyTextureSubImage1D, GLuint, texture, GLint, level, GLint, xoffset, GLint, x, GLint, y, GLsizei, width); \
  FuncWrapper8(void, glCopyTextureSubImage2D, GLuint, texture, GLint, level, GLint, xoffset, GLint, yoffset, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  FuncWrapper9(void, glCopyTextureSubImage3D, GLuint, texture, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  FuncWrapper3(void, glTextureParameterf, GLuint, texture, GLenum, pname, GLfloat, param); \
  FuncWrapper3(void, glTextureParameterfv, GLuint, texture, GLenum, pname, const GLfloat *, param); \
  FuncWrapper3(void, glTextureParameteri, GLuint, texture, GLenum, pname, GLint, param); \
  FuncWrapper3(void, glTextureParameterIiv, GLuint, texture, GLenum, pname, const GLint *, params); \
  FuncWrapper3(void, glTextureParameterIuiv, GLuint, texture, GLenum, pname, const GLuint *, params); \
  FuncWrapper3(void, glTextureParameteriv, GLuint, texture, GLenum, pname, const GLint *, param); \
  FuncWrapper1(void, glGenerateTextureMipmap, GLuint, texture); \
  FuncWrapper2(void, glBindTextureUnit, GLuint, unit, GLuint, texture); \
  FuncWrapper6(void, glGetTextureImage, GLuint, texture, GLint, level, GLenum, format, GLenum, type, GLsizei, bufSize, void *, pixels); \
  FuncWrapper12(void, glGetTextureSubImage, GLuint, texture, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLenum, type, GLsizei, bufSize, void *, pixels); \
  FuncWrapper4(void, glGetCompressedTextureImage, GLuint, texture, GLint, level, GLsizei, bufSize, void *, pixels); \
  FuncWrapper10(void, glGetCompressedTextureSubImage, GLuint, texture, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLsizei, bufSize, void *, pixels); \
  FuncWrapper4(void, glGetTextureLevelParameterfv, GLuint, texture, GLint, level, GLenum, pname, GLfloat *, params); \
  FuncWrapper4(void, glGetTextureLevelParameteriv, GLuint, texture, GLint, level, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetTextureParameterIiv, GLuint, texture, GLenum, pname, GLint *, params); \
  FuncWrapper3(void, glGetTextureParameterIuiv, GLuint, texture, GLenum, pname, GLuint *, params); \
  FuncWrapper3(void, glGetTextureParameterfv, GLuint, texture, GLenum, pname, GLfloat *, params); \
  FuncWrapper3(void, glGetTextureParameteriv, GLuint, texture, GLenum, pname, GLint *, params); \
  FuncWrapper2(void, glCreateVertexArrays, GLsizei, n, GLuint *, arrays); \
  FuncWrapper2(void, glCreateSamplers, GLsizei, n, GLuint *, samplers); \
  FuncWrapper2(void, glCreateProgramPipelines, GLsizei, n, GLuint *, pipelines); \
  FuncWrapper3(void, glCreateQueries, GLenum, target, GLsizei, n, GLuint *, ids); \
  FuncWrapper2(void, glVertexArrayElementBuffer, GLuint, vaobj, GLuint, buffer); \
  FuncWrapper6(void, glVertexArrayVertexBuffers, GLuint, vaobj, GLuint, first, GLsizei, count, const GLuint *, buffers, const GLintptr *, offsets, const GLsizei *, strides); \
  FuncWrapper3(void, glGetVertexArrayiv, GLuint, vaobj, GLenum, pname, GLint *, param); \
  FuncWrapper4(void, glGetVertexArrayIndexed64iv, GLuint, vaobj, GLuint, index, GLenum, pname, GLint64 *, param); \
  FuncWrapper4(void, glGetVertexArrayIndexediv, GLuint, vaobj, GLuint, index, GLenum, pname, GLint *, param); \
  FuncWrapper4(void, glGetQueryBufferObjecti64v, GLuint, id, GLuint, buffer, GLenum, pname, GLintptr, offset); \
  FuncWrapper4(void, glGetQueryBufferObjectiv, GLuint, id, GLuint, buffer, GLenum, pname, GLintptr, offset); \
  FuncWrapper4(void, glGetQueryBufferObjectui64v, GLuint, id, GLuint, buffer, GLenum, pname, GLintptr, offset); \
  FuncWrapper4(void, glGetQueryBufferObjectuiv, GLuint, id, GLuint, buffer, GLenum, pname, GLintptr, offset); \
  FuncWrapper1(void, glBeginPerfQueryINTEL, GLuint, queryHandle); \
  FuncWrapper2(void, glCreatePerfQueryINTEL, GLuint, queryId, GLuint *, queryHandle); \
  FuncWrapper1(void, glDeletePerfQueryINTEL, GLuint, queryHandle); \
  FuncWrapper1(void, glEndPerfQueryINTEL, GLuint, queryHandle); \
  FuncWrapper1(void, glGetFirstPerfQueryIdINTEL, GLuint *, queryId); \
  FuncWrapper2(void, glGetNextPerfQueryIdINTEL, GLuint, queryId, GLuint *, nextQueryId); \
  FuncWrapper11(void, glGetPerfCounterInfoINTEL, GLuint, queryId, GLuint, counterId, GLuint, counterNameLength, GLchar *, counterName, GLuint, counterDescLength, GLchar *, counterDesc, GLuint *, counterOffset, GLuint *, counterDataSize, GLuint *, counterTypeEnum, GLuint *, counterDataTypeEnum, GLuint64 *, rawCounterMaxValue); \
  FuncWrapper5(void, glGetPerfQueryDataINTEL, GLuint, queryHandle, GLuint, flags, GLsizei, dataSize, void *, data, GLuint *, bytesWritten); \
  FuncWrapper2(void, glGetPerfQueryIdByNameINTEL, GLchar *, queryName, GLuint *, queryId); \
  FuncWrapper7(void, glGetPerfQueryInfoINTEL, GLuint, queryId, GLuint, queryNameLength, GLchar *, queryName, GLuint *, dataSize, GLuint *, noCounters, GLuint *, noInstances, GLuint *, capsMask); \
  FuncWrapper2(BOOL, wglDXSetResourceShareHandleNV, void *, dxObject, HANDLE, shareHandle); \
  FuncWrapper1(HANDLE, wglDXOpenDeviceNV, void *, dxDevice); \
  FuncWrapper1(BOOL, wglDXCloseDeviceNV, HANDLE, hDevice); \
  FuncWrapper5(HANDLE, wglDXRegisterObjectNV, HANDLE, hDevice, void *, dxObject, GLuint, name, GLenum, type, GLenum, access); \
  FuncWrapper2(BOOL, wglDXUnregisterObjectNV, HANDLE, hDevice, HANDLE, hObject); \
  FuncWrapper2(BOOL, wglDXObjectAccessNV, HANDLE, hObject, GLenum, access); \
  FuncWrapper3(BOOL, wglDXLockObjectsNV, HANDLE, hDevice, GLint, count, HANDLE *, hObjects); \
  FuncWrapper3(BOOL, wglDXUnlockObjectsNV, HANDLE, hDevice, GLint, count, HANDLE *, hObjects); \




#define ForEachUnsupported(FUNC) \
  FUNC(glAccum); \
  FUNC(glAccumxOES); \
  FUNC(glActiveProgramEXT); \
  FUNC(glActiveStencilFaceEXT); \
  FUNC(glActiveVaryingNV); \
  FUNC(glAlphaFragmentOp1ATI); \
  FUNC(glAlphaFragmentOp2ATI); \
  FUNC(glAlphaFragmentOp3ATI); \
  FUNC(glAlphaFunc); \
  FUNC(glAlphaFuncQCOM); \
  FUNC(glAlphaFuncxOES); \
  FUNC(glAlphaToCoverageDitherControlNV); \
  FUNC(glApplyFramebufferAttachmentCMAAINTEL); \
  FUNC(glApplyTextureEXT); \
  FUNC(glAreProgramsResidentNV); \
  FUNC(glAreTexturesResidentEXT); \
  FUNC(glAreTexturesResident); \
  FUNC(glArrayElementEXT); \
  FUNC(glArrayElement); \
  FUNC(glArrayObjectATI); \
  FUNC(glAsyncMarkerSGIX); \
  FUNC(glAttachObjectARB); \
  FUNC(glBeginConditionalRenderNV); \
  FUNC(glBeginConditionalRenderNVX); \
  FUNC(glBeginFragmentShaderATI); \
  FUNC(glBeginOcclusionQueryNV); \
  FUNC(glBeginPerfMonitorAMD); \
  FUNC(glBegin); \
  FUNC(glBeginTransformFeedbackNV); \
  FUNC(glBeginVertexShaderEXT); \
  FUNC(glBeginVideoCaptureNV); \
  FUNC(glBindAttribLocationARB); \
  FUNC(glBindBufferBaseNV); \
  FUNC(glBindBufferOffsetEXT); \
  FUNC(glBindBufferOffsetNV); \
  FUNC(glBindBufferRangeNV); \
  FUNC(glBindFragDataLocationIndexedEXT); \
  FUNC(glBindFragmentShaderATI); \
  FUNC(glBindLightParameterEXT); \
  FUNC(glBindMaterialParameterEXT); \
  FUNC(glBindParameterEXT); \
  FUNC(glBindProgramARB); \
  FUNC(glBindProgramNV); \
  FUNC(glBindTexGenParameterEXT); \
  FUNC(glBindTextureEXT); \
  FUNC(glBindTextureUnitParameterEXT); \
  FUNC(glBindTransformFeedbackNV); \
  FUNC(glBindVertexArrayAPPLE); \
  FUNC(glBindVertexShaderEXT); \
  FUNC(glBindVideoCaptureStreamBufferNV); \
  FUNC(glBindVideoCaptureStreamTextureNV); \
  FUNC(glBinormal3bEXT); \
  FUNC(glBinormal3bvEXT); \
  FUNC(glBinormal3dEXT); \
  FUNC(glBinormal3dvEXT); \
  FUNC(glBinormal3fEXT); \
  FUNC(glBinormal3fvEXT); \
  FUNC(glBinormal3iEXT); \
  FUNC(glBinormal3ivEXT); \
  FUNC(glBinormal3sEXT); \
  FUNC(glBinormal3svEXT); \
  FUNC(glBinormalPointerEXT); \
  FUNC(glBitmap); \
  FUNC(glBitmapxOES); \
  FUNC(glBlendBarrierNV); \
  FUNC(glBlendColorxOES); \
  FUNC(glBlendEquationIndexedAMD); \
  FUNC(glBlendEquationSeparateIndexedAMD); \
  FUNC(glBlendFuncIndexedAMD); \
  FUNC(glBlendFuncSeparateEXT); \
  FUNC(glBlendFuncSeparateIndexedAMD); \
  FUNC(glBlendFuncSeparateINGR); \
  FUNC(glBlendParameteriNV); \
  FUNC(glBlitFramebufferANGLE); \
  FUNC(glBlitFramebufferNV); \
  FUNC(glBufferAddressRangeNV); \
  FUNC(glBufferPageCommitmentARB); \
  FUNC(glBufferParameteriAPPLE); \
  FUNC(glBufferStorageExternalEXT); \
  FUNC(glCallCommandListNV); \
  FUNC(glCallList); \
  FUNC(glCallLists); \
  FUNC(glClearAccum); \
  FUNC(glClearAccumxOES); \
  FUNC(glClearColorIiEXT); \
  FUNC(glClearColorIuiEXT); \
  FUNC(glClearColorxOES); \
  FUNC(glClearDepthdNV); \
  FUNC(glClearDepthfOES); \
  FUNC(glClearDepthxOES); \
  FUNC(glClearIndex); \
  FUNC(glClearPixelLocalStorageuiEXT); \
  FUNC(glClearTexImageEXT); \
  FUNC(glClearTexSubImageEXT); \
  FUNC(glClientActiveTextureARB); \
  FUNC(glClientActiveTexture); \
  FUNC(glClientActiveVertexStreamATI); \
  FUNC(glClientAttribDefaultEXT); \
  FUNC(glClientWaitSyncAPPLE); \
  FUNC(glClipControlEXT); \
  FUNC(glClipPlanefOES); \
  FUNC(glClipPlane); \
  FUNC(glClipPlanexOES); \
  FUNC(glColor3b); \
  FUNC(glColor3bv); \
  FUNC(glColor3d); \
  FUNC(glColor3dv); \
  FUNC(glColor3f); \
  FUNC(glColor3fVertex3fSUN); \
  FUNC(glColor3fVertex3fvSUN); \
  FUNC(glColor3fv); \
  FUNC(glColor3hNV); \
  FUNC(glColor3hvNV); \
  FUNC(glColor3i); \
  FUNC(glColor3iv); \
  FUNC(glColor3s); \
  FUNC(glColor3sv); \
  FUNC(glColor3ub); \
  FUNC(glColor3ubv); \
  FUNC(glColor3ui); \
  FUNC(glColor3uiv); \
  FUNC(glColor3us); \
  FUNC(glColor3usv); \
  FUNC(glColor3xOES); \
  FUNC(glColor3xvOES); \
  FUNC(glColor4b); \
  FUNC(glColor4bv); \
  FUNC(glColor4d); \
  FUNC(glColor4dv); \
  FUNC(glColor4fNormal3fVertex3fSUN); \
  FUNC(glColor4fNormal3fVertex3fvSUN); \
  FUNC(glColor4f); \
  FUNC(glColor4fv); \
  FUNC(glColor4hNV); \
  FUNC(glColor4hvNV); \
  FUNC(glColor4i); \
  FUNC(glColor4iv); \
  FUNC(glColor4s); \
  FUNC(glColor4sv); \
  FUNC(glColor4ub); \
  FUNC(glColor4ubVertex2fSUN); \
  FUNC(glColor4ubVertex2fvSUN); \
  FUNC(glColor4ubVertex3fSUN); \
  FUNC(glColor4ubVertex3fvSUN); \
  FUNC(glColor4ubv); \
  FUNC(glColor4ui); \
  FUNC(glColor4uiv); \
  FUNC(glColor4us); \
  FUNC(glColor4usv); \
  FUNC(glColor4xOES); \
  FUNC(glColor4xvOES); \
  FUNC(glColorFormatNV); \
  FUNC(glColorFragmentOp1ATI); \
  FUNC(glColorFragmentOp2ATI); \
  FUNC(glColorFragmentOp3ATI); \
  FUNC(glColorMaterial); \
  FUNC(glColorP3ui); \
  FUNC(glColorP3uiv); \
  FUNC(glColorP4ui); \
  FUNC(glColorP4uiv); \
  FUNC(glColorPointerEXT); \
  FUNC(glColorPointerListIBM); \
  FUNC(glColorPointer); \
  FUNC(glColorPointervINTEL); \
  FUNC(glColorSubTableEXT); \
  FUNC(glColorSubTable); \
  FUNC(glColorTableEXT); \
  FUNC(glColorTableParameterfv); \
  FUNC(glColorTableParameterfvSGI); \
  FUNC(glColorTableParameteriv); \
  FUNC(glColorTableParameterivSGI); \
  FUNC(glColorTable); \
  FUNC(glColorTableSGI); \
  FUNC(glCombinerInputNV); \
  FUNC(glCombinerOutputNV); \
  FUNC(glCombinerParameterfNV); \
  FUNC(glCombinerParameterfvNV); \
  FUNC(glCombinerParameteriNV); \
  FUNC(glCombinerParameterivNV); \
  FUNC(glCombinerStageParameterfvNV); \
  FUNC(glCommandListSegmentsNV); \
  FUNC(glCompileCommandListNV); \
  FUNC(glCompileShaderARB); \
  FUNC(glConservativeRasterParameterfNV); \
  FUNC(glConservativeRasterParameteriNV); \
  FUNC(glConvolutionFilter1DEXT); \
  FUNC(glConvolutionFilter1D); \
  FUNC(glConvolutionFilter2DEXT); \
  FUNC(glConvolutionFilter2D); \
  FUNC(glConvolutionParameterfEXT); \
  FUNC(glConvolutionParameterf); \
  FUNC(glConvolutionParameterfvEXT); \
  FUNC(glConvolutionParameterfv); \
  FUNC(glConvolutionParameteriEXT); \
  FUNC(glConvolutionParameteri); \
  FUNC(glConvolutionParameterivEXT); \
  FUNC(glConvolutionParameteriv); \
  FUNC(glConvolutionParameterxOES); \
  FUNC(glConvolutionParameterxvOES); \
  FUNC(glCopyBufferSubDataNV); \
  FUNC(glCopyColorSubTableEXT); \
  FUNC(glCopyColorSubTable); \
  FUNC(glCopyColorTable); \
  FUNC(glCopyColorTableSGI); \
  FUNC(glCopyConvolutionFilter1DEXT); \
  FUNC(glCopyConvolutionFilter1D); \
  FUNC(glCopyConvolutionFilter2DEXT); \
  FUNC(glCopyConvolutionFilter2D); \
  FUNC(glCopyImageSubDataNV); \
  FUNC(glCopyPathNV); \
  FUNC(glCopyPixels); \
  FUNC(glCopyTexImage1DEXT); \
  FUNC(glCopyTexImage2DEXT); \
  FUNC(glCopyTexSubImage1DEXT); \
  FUNC(glCopyTexSubImage2DEXT); \
  FUNC(glCopyTexSubImage3DEXT); \
  FUNC(glCopyTextureLevelsAPPLE); \
  FUNC(glCoverageMaskNV); \
  FUNC(glCoverageModulationNV); \
  FUNC(glCoverageModulationTableNV); \
  FUNC(glCoverageOperationNV); \
  FUNC(glCoverFillPathInstancedNV); \
  FUNC(glCoverFillPathNV); \
  FUNC(glCoverStrokePathInstancedNV); \
  FUNC(glCoverStrokePathNV); \
  FUNC(glCreateCommandListsNV); \
  FUNC(glCreateProgramObjectARB); \
  FUNC(glCreateShaderObjectARB); \
  FUNC(glCreateShaderProgramEXT); \
  FUNC(glCreateStatesNV); \
  FUNC(glCreateSyncFromCLeventARB); \
  FUNC(glCullParameterdvEXT); \
  FUNC(glCullParameterfvEXT); \
  FUNC(glCurrentPaletteMatrixARB); \
  FUNC(glDebugMessageCallbackAMD); \
  FUNC(glDebugMessageEnableAMD); \
  FUNC(glDebugMessageInsertAMD); \
  FUNC(glDeformationMap3dSGIX); \
  FUNC(glDeformationMap3fSGIX); \
  FUNC(glDeformSGIX); \
  FUNC(glDeleteAsyncMarkersSGIX); \
  FUNC(glDeleteCommandListsNV); \
  FUNC(glDeleteFencesAPPLE); \
  FUNC(glDeleteFencesNV); \
  FUNC(glDeleteFragmentShaderATI); \
  FUNC(glDeleteLists); \
  FUNC(glDeleteNamesAMD); \
  FUNC(glDeleteObjectARB); \
  FUNC(glDeleteOcclusionQueriesNV); \
  FUNC(glDeletePathsNV); \
  FUNC(glDeletePerfMonitorsAMD); \
  FUNC(glDeleteProgramsARB); \
  FUNC(glDeleteProgramsNV); \
  FUNC(glDeleteQueryResourceTagNV); \
  FUNC(glDeleteStatesNV); \
  FUNC(glDeleteSyncAPPLE); \
  FUNC(glDeleteTexturesEXT); \
  FUNC(glDeleteTransformFeedbacksNV); \
  FUNC(glDeleteVertexArraysAPPLE); \
  FUNC(glDeleteVertexShaderEXT); \
  FUNC(glDepthBoundsdNV); \
  FUNC(glDepthRangedNV); \
  FUNC(glDepthRangefOES); \
  FUNC(glDepthRangexOES); \
  FUNC(glDetachObjectARB); \
  FUNC(glDetailTexFuncSGIS); \
  FUNC(glDisableClientStateiEXT); \
  FUNC(glDisableClientStateIndexedEXT); \
  FUNC(glDisableClientState); \
  FUNC(glDisableDriverControlQCOM); \
  FUNC(glDisableVariantClientStateEXT); \
  FUNC(glDisableVertexArrayEXT); \
  FUNC(glDisableVertexAttribAPPLE); \
  FUNC(glDrawArraysEXT); \
  FUNC(glDrawArraysInstancedANGLE); \
  FUNC(glDrawArraysInstancedNV); \
  FUNC(glDrawBuffersATI); \
  FUNC(glDrawBuffersIndexedEXT); \
  FUNC(glDrawBuffersNV); \
  FUNC(glDrawCommandsAddressNV); \
  FUNC(glDrawCommandsNV); \
  FUNC(glDrawCommandsStatesAddressNV); \
  FUNC(glDrawCommandsStatesNV); \
  FUNC(glDrawElementArrayAPPLE); \
  FUNC(glDrawElementArrayATI); \
  FUNC(glDrawElementsInstancedANGLE); \
  FUNC(glDrawElementsInstancedNV); \
  FUNC(glDrawMeshArraysSUN); \
  FUNC(glDrawPixels); \
  FUNC(glDrawRangeElementArrayAPPLE); \
  FUNC(glDrawRangeElementArrayATI); \
  FUNC(glDrawTextureNV); \
  FUNC(glDrawTransformFeedbackEXT); \
  FUNC(glDrawTransformFeedbackInstancedEXT); \
  FUNC(glDrawTransformFeedbackNV); \
  FUNC(glDrawVkImageNV); \
  FUNC(glEdgeFlagFormatNV); \
  FUNC(glEdgeFlagPointerEXT); \
  FUNC(glEdgeFlagPointerListIBM); \
  FUNC(glEdgeFlagPointer); \
  FUNC(glEdgeFlag); \
  FUNC(glEdgeFlagv); \
  FUNC(glEGLImageTargetRenderbufferStorageOES); \
  FUNC(glEGLImageTargetTexStorageEXT); \
  FUNC(glEGLImageTargetTexture2DOES); \
  FUNC(glEGLImageTargetTextureStorageEXT); \
  FUNC(glElementPointerAPPLE); \
  FUNC(glElementPointerATI); \
  FUNC(glEnableClientStateiEXT); \
  FUNC(glEnableClientStateIndexedEXT); \
  FUNC(glEnableClientState); \
  FUNC(glEnableDriverControlQCOM); \
  FUNC(glEnableVariantClientStateEXT); \
  FUNC(glEnableVertexArrayEXT); \
  FUNC(glEnableVertexAttribAPPLE); \
  FUNC(glEndConditionalRenderNV); \
  FUNC(glEndConditionalRenderNVX); \
  FUNC(glEndFragmentShaderATI); \
  FUNC(glEndList); \
  FUNC(glEndOcclusionQueryNV); \
  FUNC(glEndPerfMonitorAMD); \
  FUNC(glEnd); \
  FUNC(glEndTilingQCOM); \
  FUNC(glEndTransformFeedbackNV); \
  FUNC(glEndVertexShaderEXT); \
  FUNC(glEndVideoCaptureNV); \
  FUNC(glEvalCoord1d); \
  FUNC(glEvalCoord1dv); \
  FUNC(glEvalCoord1f); \
  FUNC(glEvalCoord1fv); \
  FUNC(glEvalCoord1xOES); \
  FUNC(glEvalCoord1xvOES); \
  FUNC(glEvalCoord2d); \
  FUNC(glEvalCoord2dv); \
  FUNC(glEvalCoord2f); \
  FUNC(glEvalCoord2fv); \
  FUNC(glEvalCoord2xOES); \
  FUNC(glEvalCoord2xvOES); \
  FUNC(glEvalMapsNV); \
  FUNC(glEvalMesh1); \
  FUNC(glEvalMesh2); \
  FUNC(glEvalPoint1); \
  FUNC(glEvalPoint2); \
  FUNC(glEvaluateDepthValuesARB); \
  FUNC(glExecuteProgramNV); \
  FUNC(glExtGetBufferPointervQCOM); \
  FUNC(glExtGetBuffersQCOM); \
  FUNC(glExtGetFramebuffersQCOM); \
  FUNC(glExtGetProgramBinarySourceQCOM); \
  FUNC(glExtGetProgramsQCOM); \
  FUNC(glExtGetRenderbuffersQCOM); \
  FUNC(glExtGetShadersQCOM); \
  FUNC(glExtGetTexLevelParameterivQCOM); \
  FUNC(glExtGetTexSubImageQCOM); \
  FUNC(glExtGetTexturesQCOM); \
  FUNC(glExtIsProgramBinaryQCOM); \
  FUNC(glExtractComponentEXT); \
  FUNC(glExtTexObjectStateOverrideiQCOM); \
  FUNC(glFeedbackBuffer); \
  FUNC(glFeedbackBufferxOES); \
  FUNC(glFenceSyncAPPLE); \
  FUNC(glFinalCombinerInputNV); \
  FUNC(glFinishAsyncSGIX); \
  FUNC(glFinishFenceAPPLE); \
  FUNC(glFinishFenceNV); \
  FUNC(glFinishObjectAPPLE); \
  FUNC(glFinishTextureSUNX); \
  FUNC(glFlushMappedBufferRangeAPPLE); \
  FUNC(glFlushPixelDataRangeNV); \
  FUNC(glFlushRasterSGIX); \
  FUNC(glFlushStaticDataIBM); \
  FUNC(glFlushVertexArrayRangeAPPLE); \
  FUNC(glFlushVertexArrayRangeNV); \
  FUNC(glFogCoorddEXT); \
  FUNC(glFogCoordd); \
  FUNC(glFogCoorddvEXT); \
  FUNC(glFogCoorddv); \
  FUNC(glFogCoordfEXT); \
  FUNC(glFogCoordFormatNV); \
  FUNC(glFogCoordf); \
  FUNC(glFogCoordfvEXT); \
  FUNC(glFogCoordfv); \
  FUNC(glFogCoordhNV); \
  FUNC(glFogCoordhvNV); \
  FUNC(glFogCoordPointerEXT); \
  FUNC(glFogCoordPointerListIBM); \
  FUNC(glFogCoordPointer); \
  FUNC(glFogf); \
  FUNC(glFogFuncSGIS); \
  FUNC(glFogfv); \
  FUNC(glFogi); \
  FUNC(glFogiv); \
  FUNC(glFogxOES); \
  FUNC(glFogxvOES); \
  FUNC(glFragmentColorMaterialSGIX); \
  FUNC(glFragmentCoverageColorNV); \
  FUNC(glFragmentLightfSGIX); \
  FUNC(glFragmentLightfvSGIX); \
  FUNC(glFragmentLightiSGIX); \
  FUNC(glFragmentLightivSGIX); \
  FUNC(glFragmentLightModelfSGIX); \
  FUNC(glFragmentLightModelfvSGIX); \
  FUNC(glFragmentLightModeliSGIX); \
  FUNC(glFragmentLightModelivSGIX); \
  FUNC(glFragmentMaterialfSGIX); \
  FUNC(glFragmentMaterialfvSGIX); \
  FUNC(glFragmentMaterialiSGIX); \
  FUNC(glFragmentMaterialivSGIX); \
  FUNC(glFramebufferFetchBarrierEXT); \
  FUNC(glFramebufferFetchBarrierQCOM); \
  FUNC(glFramebufferFoveationConfigQCOM); \
  FUNC(glFramebufferFoveationParametersQCOM); \
  FUNC(glFramebufferPixelLocalStorageSizeEXT); \
  FUNC(glFramebufferSampleLocationsfvARB); \
  FUNC(glFramebufferSampleLocationsfvNV); \
  FUNC(glFramebufferSamplePositionsfvAMD); \
  FUNC(glFramebufferTexture2DDownsampleIMG); \
  FUNC(glFramebufferTexture2DMultisampleIMG); \
  FUNC(glFramebufferTextureFaceARB); \
  FUNC(glFramebufferTextureFaceEXT); \
  FUNC(glFramebufferTextureLayerDownsampleIMG); \
  FUNC(glFrameZoomSGIX); \
  FUNC(glFreeObjectBufferATI); \
  FUNC(glFrustumfOES); \
  FUNC(glFrustum); \
  FUNC(glFrustumxOES); \
  FUNC(glGenAsyncMarkersSGIX); \
  FUNC(glGenFencesAPPLE); \
  FUNC(glGenFencesNV); \
  FUNC(glGenFragmentShadersATI); \
  FUNC(glGenLists); \
  FUNC(glGenNamesAMD); \
  FUNC(glGenOcclusionQueriesNV); \
  FUNC(glGenPathsNV); \
  FUNC(glGenPerfMonitorsAMD); \
  FUNC(glGenProgramsARB); \
  FUNC(glGenProgramsNV); \
  FUNC(glGenQueryResourceTagNV); \
  FUNC(glGenSymbolsEXT); \
  FUNC(glGenTexturesEXT); \
  FUNC(glGenTransformFeedbacksNV); \
  FUNC(glGenVertexArraysAPPLE); \
  FUNC(glGenVertexShadersEXT); \
  FUNC(glGetActiveAttribARB); \
  FUNC(glGetActiveUniformARB); \
  FUNC(glGetActiveVaryingNV); \
  FUNC(glGetArrayObjectfvATI); \
  FUNC(glGetArrayObjectivATI); \
  FUNC(glGetAttachedObjectsARB); \
  FUNC(glGetAttribLocationARB); \
  FUNC(glGetBufferParameterui64vNV); \
  FUNC(glGetClipPlanefOES); \
  FUNC(glGetClipPlane); \
  FUNC(glGetClipPlanexOES); \
  FUNC(glGetColorTableEXT); \
  FUNC(glGetColorTableParameterfvEXT); \
  FUNC(glGetColorTableParameterfv); \
  FUNC(glGetColorTableParameterfvSGI); \
  FUNC(glGetColorTableParameterivEXT); \
  FUNC(glGetColorTableParameteriv); \
  FUNC(glGetColorTableParameterivSGI); \
  FUNC(glGetColorTable); \
  FUNC(glGetColorTableSGI); \
  FUNC(glGetCombinerInputParameterfvNV); \
  FUNC(glGetCombinerInputParameterivNV); \
  FUNC(glGetCombinerOutputParameterfvNV); \
  FUNC(glGetCombinerOutputParameterivNV); \
  FUNC(glGetCombinerStageParameterfvNV); \
  FUNC(glGetCommandHeaderNV); \
  FUNC(glGetConvolutionFilterEXT); \
  FUNC(glGetConvolutionFilter); \
  FUNC(glGetConvolutionParameterfvEXT); \
  FUNC(glGetConvolutionParameterfv); \
  FUNC(glGetConvolutionParameterivEXT); \
  FUNC(glGetConvolutionParameteriv); \
  FUNC(glGetConvolutionParameterxvOES); \
  FUNC(glGetCoverageModulationTableNV); \
  FUNC(glGetDebugMessageLogAMD); \
  FUNC(glGetDetailTexFuncSGIS); \
  FUNC(glGetDriverControlsQCOM); \
  FUNC(glGetDriverControlStringQCOM); \
  FUNC(glGetFenceivNV); \
  FUNC(glGetFinalCombinerInputParameterfvNV); \
  FUNC(glGetFinalCombinerInputParameterivNV); \
  FUNC(glGetFixedvOES); \
  FUNC(glGetFogFuncSGIS); \
  FUNC(glGetFragDataIndexEXT); \
  FUNC(glGetFragmentLightfvSGIX); \
  FUNC(glGetFragmentLightivSGIX); \
  FUNC(glGetFragmentMaterialfvSGIX); \
  FUNC(glGetFragmentMaterialivSGIX); \
  FUNC(glGetFramebufferParameterfvAMD); \
  FUNC(glGetFramebufferPixelLocalStorageSizeEXT); \
  FUNC(glGetGraphicsResetStatusKHR); \
  FUNC(glGetHandleARB); \
  FUNC(glGetHistogramEXT); \
  FUNC(glGetHistogramParameterfvEXT); \
  FUNC(glGetHistogramParameterfv); \
  FUNC(glGetHistogramParameterivEXT); \
  FUNC(glGetHistogramParameteriv); \
  FUNC(glGetHistogramParameterxvOES); \
  FUNC(glGetHistogram); \
  FUNC(glGetImageHandleARB); \
  FUNC(glGetImageHandleNV); \
  FUNC(glGetImageTransformParameterfvHP); \
  FUNC(glGetImageTransformParameterivHP); \
  FUNC(glGetInfoLogARB); \
  FUNC(glGetInstrumentsSGIX); \
  FUNC(glGetInteger64vAPPLE); \
  FUNC(glGetIntegeri_vEXT); \
  FUNC(glGetIntegerui64i_vNV); \
  FUNC(glGetIntegerui64vNV); \
  FUNC(glGetInternalformatSampleivNV); \
  FUNC(glGetInvariantBooleanvEXT); \
  FUNC(glGetInvariantFloatvEXT); \
  FUNC(glGetInvariantIntegervEXT); \
  FUNC(glGetLightfv); \
  FUNC(glGetLightiv); \
  FUNC(glGetLightxOES); \
  FUNC(glGetListParameterfvSGIX); \
  FUNC(glGetListParameterivSGIX); \
  FUNC(glGetLocalConstantBooleanvEXT); \
  FUNC(glGetLocalConstantFloatvEXT); \
  FUNC(glGetLocalConstantIntegervEXT); \
  FUNC(glGetMapAttribParameterfvNV); \
  FUNC(glGetMapAttribParameterivNV); \
  FUNC(glGetMapControlPointsNV); \
  FUNC(glGetMapdv); \
  FUNC(glGetMapfv); \
  FUNC(glGetMapiv); \
  FUNC(glGetMapParameterfvNV); \
  FUNC(glGetMapParameterivNV); \
  FUNC(glGetMapxvOES); \
  FUNC(glGetMaterialfv); \
  FUNC(glGetMaterialiv); \
  FUNC(glGetMaterialxOES); \
  FUNC(glGetMinmaxEXT); \
  FUNC(glGetMinmaxParameterfvEXT); \
  FUNC(glGetMinmaxParameterfv); \
  FUNC(glGetMinmaxParameterivEXT); \
  FUNC(glGetMinmaxParameteriv); \
  FUNC(glGetMinmax); \
  FUNC(glGetMultisamplefvNV); \
  FUNC(glGetMultiTexEnvfvEXT); \
  FUNC(glGetMultiTexEnvivEXT); \
  FUNC(glGetMultiTexGendvEXT); \
  FUNC(glGetMultiTexGenfvEXT); \
  FUNC(glGetMultiTexGenivEXT); \
  FUNC(glGetNamedBufferParameterui64vNV); \
  FUNC(glGetNamedFramebufferParameterfvAMD); \
  FUNC(glGetNamedProgramLocalParameterdvEXT); \
  FUNC(glGetNamedProgramLocalParameterfvEXT); \
  FUNC(glGetNamedProgramLocalParameterIivEXT); \
  FUNC(glGetNamedProgramLocalParameterIuivEXT); \
  FUNC(glGetNamedProgramStringEXT); \
  FUNC(glGetnColorTableARB); \
  FUNC(glGetnColorTable); \
  FUNC(glGetnConvolutionFilterARB); \
  FUNC(glGetnConvolutionFilter); \
  FUNC(glGetnHistogramARB); \
  FUNC(glGetnHistogram); \
  FUNC(glGetnMapdvARB); \
  FUNC(glGetnMapdv); \
  FUNC(glGetnMapfvARB); \
  FUNC(glGetnMapfv); \
  FUNC(glGetnMapivARB); \
  FUNC(glGetnMapiv); \
  FUNC(glGetnMinmaxARB); \
  FUNC(glGetnMinmax); \
  FUNC(glGetnPixelMapfvARB); \
  FUNC(glGetnPixelMapfv); \
  FUNC(glGetnPixelMapuivARB); \
  FUNC(glGetnPixelMapuiv); \
  FUNC(glGetnPixelMapusvARB); \
  FUNC(glGetnPixelMapusv); \
  FUNC(glGetnPolygonStippleARB); \
  FUNC(glGetnPolygonStipple); \
  FUNC(glGetnSeparableFilterARB); \
  FUNC(glGetnSeparableFilter); \
  FUNC(glGetnUniformfvKHR); \
  FUNC(glGetnUniformi64vARB); \
  FUNC(glGetnUniformivKHR); \
  FUNC(glGetnUniformui64vARB); \
  FUNC(glGetnUniformuivKHR); \
  FUNC(glGetObjectBufferfvATI); \
  FUNC(glGetObjectBufferivATI); \
  FUNC(glGetObjectParameterfvARB); \
  FUNC(glGetObjectParameterivAPPLE); \
  FUNC(glGetObjectParameterivARB); \
  FUNC(glGetOcclusionQueryivNV); \
  FUNC(glGetOcclusionQueryuivNV); \
  FUNC(glGetPathColorGenfvNV); \
  FUNC(glGetPathColorGenivNV); \
  FUNC(glGetPathCommandsNV); \
  FUNC(glGetPathCoordsNV); \
  FUNC(glGetPathDashArrayNV); \
  FUNC(glGetPathLengthNV); \
  FUNC(glGetPathMetricRangeNV); \
  FUNC(glGetPathMetricsNV); \
  FUNC(glGetPathParameterfvNV); \
  FUNC(glGetPathParameterivNV); \
  FUNC(glGetPathSpacingNV); \
  FUNC(glGetPathTexGenfvNV); \
  FUNC(glGetPathTexGenivNV); \
  FUNC(glGetPerfMonitorCounterDataAMD); \
  FUNC(glGetPerfMonitorCounterInfoAMD); \
  FUNC(glGetPerfMonitorCountersAMD); \
  FUNC(glGetPerfMonitorCounterStringAMD); \
  FUNC(glGetPerfMonitorGroupsAMD); \
  FUNC(glGetPerfMonitorGroupStringAMD); \
  FUNC(glGetPixelMapfv); \
  FUNC(glGetPixelMapuiv); \
  FUNC(glGetPixelMapusv); \
  FUNC(glGetPixelMapxv); \
  FUNC(glGetPixelTexGenParameterfvSGIS); \
  FUNC(glGetPixelTexGenParameterivSGIS); \
  FUNC(glGetPixelTransformParameterfvEXT); \
  FUNC(glGetPixelTransformParameterivEXT); \
  FUNC(glGetPointervEXT); \
  FUNC(glGetPolygonStipple); \
  FUNC(glGetProgramBinaryOES); \
  FUNC(glGetProgramEnvParameterdvARB); \
  FUNC(glGetProgramEnvParameterfvARB); \
  FUNC(glGetProgramEnvParameterIivNV); \
  FUNC(glGetProgramEnvParameterIuivNV); \
  FUNC(glGetProgramivARB); \
  FUNC(glGetProgramivNV); \
  FUNC(glGetProgramLocalParameterdvARB); \
  FUNC(glGetProgramLocalParameterfvARB); \
  FUNC(glGetProgramLocalParameterIivNV); \
  FUNC(glGetProgramLocalParameterIuivNV); \
  FUNC(glGetProgramNamedParameterdvNV); \
  FUNC(glGetProgramNamedParameterfvNV); \
  FUNC(glGetProgramParameterdvNV); \
  FUNC(glGetProgramParameterfvNV); \
  FUNC(glGetProgramResourcefvNV); \
  FUNC(glGetProgramResourceLocationIndexEXT); \
  FUNC(glGetProgramStringARB); \
  FUNC(glGetProgramStringNV); \
  FUNC(glGetProgramSubroutineParameteruivNV); \
  FUNC(glGetSeparableFilterEXT); \
  FUNC(glGetSeparableFilter); \
  FUNC(glGetShaderSourceARB); \
  FUNC(glGetSharpenTexFuncSGIS); \
  FUNC(glGetStageIndexNV); \
  FUNC(glGetSyncivAPPLE); \
  FUNC(glGetTexBumpParameterfvATI); \
  FUNC(glGetTexBumpParameterivATI); \
  FUNC(glGetTexEnvfv); \
  FUNC(glGetTexEnviv); \
  FUNC(glGetTexEnvxvOES); \
  FUNC(glGetTexFilterFuncSGIS); \
  FUNC(glGetTexGendv); \
  FUNC(glGetTexGenfv); \
  FUNC(glGetTexGeniv); \
  FUNC(glGetTexGenxvOES); \
  FUNC(glGetTexLevelParameterxvOES); \
  FUNC(glGetTexParameterPointervAPPLE); \
  FUNC(glGetTexParameterxvOES); \
  FUNC(glGetTextureHandleARB); \
  FUNC(glGetTextureHandleIMG); \
  FUNC(glGetTextureHandleNV); \
  FUNC(glGetTextureSamplerHandleARB); \
  FUNC(glGetTextureSamplerHandleIMG); \
  FUNC(glGetTextureSamplerHandleNV); \
  FUNC(glGetTrackMatrixivNV); \
  FUNC(glGetTransformFeedbackVaryingNV); \
  FUNC(glGetTranslatedShaderSourceANGLE); \
  FUNC(glGetUniformBufferSizeEXT); \
  FUNC(glGetUniformfvARB); \
  FUNC(glGetUniformi64vARB); \
  FUNC(glGetUniformi64vNV); \
  FUNC(glGetUniformivARB); \
  FUNC(glGetUniformLocationARB); \
  FUNC(glGetUniformOffsetEXT); \
  FUNC(glGetUniformui64vARB); \
  FUNC(glGetUniformui64vNV); \
  FUNC(glGetVariantArrayObjectfvATI); \
  FUNC(glGetVariantArrayObjectivATI); \
  FUNC(glGetVariantBooleanvEXT); \
  FUNC(glGetVariantFloatvEXT); \
  FUNC(glGetVariantIntegervEXT); \
  FUNC(glGetVariantPointervEXT); \
  FUNC(glGetVaryingLocationNV); \
  FUNC(glGetVertexAttribArrayObjectfvATI); \
  FUNC(glGetVertexAttribArrayObjectivATI); \
  FUNC(glGetVertexAttribdvARB); \
  FUNC(glGetVertexAttribdvNV); \
  FUNC(glGetVertexAttribfvARB); \
  FUNC(glGetVertexAttribfvNV); \
  FUNC(glGetVertexAttribivARB); \
  FUNC(glGetVertexAttribivNV); \
  FUNC(glGetVertexAttribLi64vNV); \
  FUNC(glGetVertexAttribLui64vARB); \
  FUNC(glGetVertexAttribLui64vNV); \
  FUNC(glGetVertexAttribPointervARB); \
  FUNC(glGetVertexAttribPointervNV); \
  FUNC(glGetVideoCaptureivNV); \
  FUNC(glGetVideoCaptureStreamdvNV); \
  FUNC(glGetVideoCaptureStreamfvNV); \
  FUNC(glGetVideoCaptureStreamivNV); \
  FUNC(glGetVideoi64vNV); \
  FUNC(glGetVideoivNV); \
  FUNC(glGetVideoui64vNV); \
  FUNC(glGetVideouivNV); \
  FUNC(glGetVkProcAddrNV); \
  FUNC(glGlobalAlphaFactorbSUN); \
  FUNC(glGlobalAlphaFactordSUN); \
  FUNC(glGlobalAlphaFactorfSUN); \
  FUNC(glGlobalAlphaFactoriSUN); \
  FUNC(glGlobalAlphaFactorsSUN); \
  FUNC(glGlobalAlphaFactorubSUN); \
  FUNC(glGlobalAlphaFactoruiSUN); \
  FUNC(glGlobalAlphaFactorusSUN); \
  FUNC(glHintPGI); \
  FUNC(glHistogramEXT); \
  FUNC(glHistogram); \
  FUNC(glIglooInterfaceSGIX); \
  FUNC(glImageTransformParameterfHP); \
  FUNC(glImageTransformParameterfvHP); \
  FUNC(glImageTransformParameteriHP); \
  FUNC(glImageTransformParameterivHP); \
  FUNC(glImportSyncEXT); \
  FUNC(glIndexd); \
  FUNC(glIndexdv); \
  FUNC(glIndexFormatNV); \
  FUNC(glIndexf); \
  FUNC(glIndexFuncEXT); \
  FUNC(glIndexfv); \
  FUNC(glIndexi); \
  FUNC(glIndexiv); \
  FUNC(glIndexMask); \
  FUNC(glIndexMaterialEXT); \
  FUNC(glIndexPointerEXT); \
  FUNC(glIndexPointerListIBM); \
  FUNC(glIndexPointer); \
  FUNC(glIndexs); \
  FUNC(glIndexsv); \
  FUNC(glIndexub); \
  FUNC(glIndexubv); \
  FUNC(glIndexxOES); \
  FUNC(glIndexxvOES); \
  FUNC(glInitNames); \
  FUNC(glInsertComponentEXT); \
  FUNC(glInstrumentsBufferSGIX); \
  FUNC(glInterleavedArrays); \
  FUNC(glInterpolatePathsNV); \
  FUNC(glIsAsyncMarkerSGIX); \
  FUNC(glIsBufferResidentNV); \
  FUNC(glIsCommandListNV); \
  FUNC(glIsFenceAPPLE); \
  FUNC(glIsFenceNV); \
  FUNC(glIsImageHandleResidentARB); \
  FUNC(glIsImageHandleResidentNV); \
  FUNC(glIsList); \
  FUNC(glIsNameAMD); \
  FUNC(glIsNamedBufferResidentNV); \
  FUNC(glIsObjectBufferATI); \
  FUNC(glIsOcclusionQueryNV); \
  FUNC(glIsPathNV); \
  FUNC(glIsPointInFillPathNV); \
  FUNC(glIsPointInStrokePathNV); \
  FUNC(glIsProgramARB); \
  FUNC(glIsProgramNV); \
  FUNC(glIsStateNV); \
  FUNC(glIsSyncAPPLE); \
  FUNC(glIsTextureEXT); \
  FUNC(glIsTextureHandleResidentARB); \
  FUNC(glIsTextureHandleResidentNV); \
  FUNC(glIsTransformFeedbackNV); \
  FUNC(glIsVariantEnabledEXT); \
  FUNC(glIsVertexArrayAPPLE); \
  FUNC(glIsVertexAttribEnabledAPPLE); \
  FUNC(glLGPUCopyImageSubDataNVX); \
  FUNC(glLGPUInterlockNVX); \
  FUNC(glLGPUNamedBufferSubDataNVX); \
  FUNC(glLightEnviSGIX); \
  FUNC(glLightf); \
  FUNC(glLightfv); \
  FUNC(glLighti); \
  FUNC(glLightiv); \
  FUNC(glLightModelf); \
  FUNC(glLightModelfv); \
  FUNC(glLightModeli); \
  FUNC(glLightModeliv); \
  FUNC(glLightModelxOES); \
  FUNC(glLightModelxvOES); \
  FUNC(glLightxOES); \
  FUNC(glLightxvOES); \
  FUNC(glLineStipple); \
  FUNC(glLineWidthxOES); \
  FUNC(glLinkProgramARB); \
  FUNC(glListBase); \
  FUNC(glListDrawCommandsStatesClientNV); \
  FUNC(glListParameterfSGIX); \
  FUNC(glListParameterfvSGIX); \
  FUNC(glListParameteriSGIX); \
  FUNC(glListParameterivSGIX); \
  FUNC(glLoadIdentityDeformationMapSGIX); \
  FUNC(glLoadIdentity); \
  FUNC(glLoadMatrixd); \
  FUNC(glLoadMatrixf); \
  FUNC(glLoadMatrixxOES); \
  FUNC(glLoadName); \
  FUNC(glLoadProgramNV); \
  FUNC(glLoadTransposeMatrixdARB); \
  FUNC(glLoadTransposeMatrixd); \
  FUNC(glLoadTransposeMatrixfARB); \
  FUNC(glLoadTransposeMatrixf); \
  FUNC(glLoadTransposeMatrixxOES); \
  FUNC(glLockArraysEXT); \
  FUNC(glMakeBufferNonResidentNV); \
  FUNC(glMakeBufferResidentNV); \
  FUNC(glMakeImageHandleNonResidentARB); \
  FUNC(glMakeImageHandleNonResidentNV); \
  FUNC(glMakeImageHandleResidentARB); \
  FUNC(glMakeImageHandleResidentNV); \
  FUNC(glMakeNamedBufferNonResidentNV); \
  FUNC(glMakeNamedBufferResidentNV); \
  FUNC(glMakeTextureHandleNonResidentARB); \
  FUNC(glMakeTextureHandleNonResidentNV); \
  FUNC(glMakeTextureHandleResidentARB); \
  FUNC(glMakeTextureHandleResidentNV); \
  FUNC(glMap1d); \
  FUNC(glMap1f); \
  FUNC(glMap1xOES); \
  FUNC(glMap2d); \
  FUNC(glMap2f); \
  FUNC(glMap2xOES); \
  FUNC(glMapControlPointsNV); \
  FUNC(glMapGrid1d); \
  FUNC(glMapGrid1f); \
  FUNC(glMapGrid1xOES); \
  FUNC(glMapGrid2d); \
  FUNC(glMapGrid2f); \
  FUNC(glMapGrid2xOES); \
  FUNC(glMapObjectBufferATI); \
  FUNC(glMapParameterfvNV); \
  FUNC(glMapParameterivNV); \
  FUNC(glMapTexture2DINTEL); \
  FUNC(glMapVertexAttrib1dAPPLE); \
  FUNC(glMapVertexAttrib1fAPPLE); \
  FUNC(glMapVertexAttrib2dAPPLE); \
  FUNC(glMapVertexAttrib2fAPPLE); \
  FUNC(glMaterialf); \
  FUNC(glMaterialfv); \
  FUNC(glMateriali); \
  FUNC(glMaterialiv); \
  FUNC(glMaterialxOES); \
  FUNC(glMaterialxvOES); \
  FUNC(glMatrixFrustumEXT); \
  FUNC(glMatrixIndexPointerARB); \
  FUNC(glMatrixIndexubvARB); \
  FUNC(glMatrixIndexuivARB); \
  FUNC(glMatrixIndexusvARB); \
  FUNC(glMatrixLoad3x2fNV); \
  FUNC(glMatrixLoad3x3fNV); \
  FUNC(glMatrixLoaddEXT); \
  FUNC(glMatrixLoadfEXT); \
  FUNC(glMatrixLoadIdentityEXT); \
  FUNC(glMatrixLoadTranspose3x3fNV); \
  FUNC(glMatrixLoadTransposedEXT); \
  FUNC(glMatrixLoadTransposefEXT); \
  FUNC(glMatrixMode); \
  FUNC(glMatrixMult3x2fNV); \
  FUNC(glMatrixMult3x3fNV); \
  FUNC(glMatrixMultdEXT); \
  FUNC(glMatrixMultfEXT); \
  FUNC(glMatrixMultTranspose3x3fNV); \
  FUNC(glMatrixMultTransposedEXT); \
  FUNC(glMatrixMultTransposefEXT); \
  FUNC(glMatrixOrthoEXT); \
  FUNC(glMatrixPopEXT); \
  FUNC(glMatrixPushEXT); \
  FUNC(glMatrixRotatedEXT); \
  FUNC(glMatrixRotatefEXT); \
  FUNC(glMatrixScaledEXT); \
  FUNC(glMatrixScalefEXT); \
  FUNC(glMatrixTranslatedEXT); \
  FUNC(glMatrixTranslatefEXT); \
  FUNC(glMinmaxEXT); \
  FUNC(glMinmax); \
  FUNC(glMulticastBarrierNV); \
  FUNC(glMulticastBlitFramebufferNV); \
  FUNC(glMulticastBufferSubDataNV); \
  FUNC(glMulticastCopyBufferSubDataNV); \
  FUNC(glMulticastCopyImageSubDataNV); \
  FUNC(glMulticastFramebufferSampleLocationsfvNV); \
  FUNC(glMulticastGetQueryObjecti64vNV); \
  FUNC(glMulticastGetQueryObjectivNV); \
  FUNC(glMulticastGetQueryObjectui64vNV); \
  FUNC(glMulticastGetQueryObjectuivNV); \
  FUNC(glMulticastWaitSyncNV); \
  FUNC(glMultiDrawArraysIndirectAMD); \
  FUNC(glMultiDrawArraysIndirectBindlessCountNV); \
  FUNC(glMultiDrawArraysIndirectBindlessNV); \
  FUNC(glMultiDrawArraysIndirectEXT); \
  FUNC(glMultiDrawElementArrayAPPLE); \
  FUNC(glMultiDrawElementsEXT); \
  FUNC(glMultiDrawElementsIndirectAMD); \
  FUNC(glMultiDrawElementsIndirectBindlessCountNV); \
  FUNC(glMultiDrawElementsIndirectBindlessNV); \
  FUNC(glMultiDrawElementsIndirectEXT); \
  FUNC(glMultiDrawRangeElementArrayAPPLE); \
  FUNC(glMultiModeDrawArraysIBM); \
  FUNC(glMultiModeDrawElementsIBM); \
  FUNC(glMultiTexCoord1bOES); \
  FUNC(glMultiTexCoord1bvOES); \
  FUNC(glMultiTexCoord1dARB); \
  FUNC(glMultiTexCoord1d); \
  FUNC(glMultiTexCoord1dvARB); \
  FUNC(glMultiTexCoord1dv); \
  FUNC(glMultiTexCoord1fARB); \
  FUNC(glMultiTexCoord1f); \
  FUNC(glMultiTexCoord1fvARB); \
  FUNC(glMultiTexCoord1fv); \
  FUNC(glMultiTexCoord1hNV); \
  FUNC(glMultiTexCoord1hvNV); \
  FUNC(glMultiTexCoord1iARB); \
  FUNC(glMultiTexCoord1i); \
  FUNC(glMultiTexCoord1ivARB); \
  FUNC(glMultiTexCoord1iv); \
  FUNC(glMultiTexCoord1sARB); \
  FUNC(glMultiTexCoord1s); \
  FUNC(glMultiTexCoord1svARB); \
  FUNC(glMultiTexCoord1sv); \
  FUNC(glMultiTexCoord1xOES); \
  FUNC(glMultiTexCoord1xvOES); \
  FUNC(glMultiTexCoord2bOES); \
  FUNC(glMultiTexCoord2bvOES); \
  FUNC(glMultiTexCoord2dARB); \
  FUNC(glMultiTexCoord2d); \
  FUNC(glMultiTexCoord2dvARB); \
  FUNC(glMultiTexCoord2dv); \
  FUNC(glMultiTexCoord2fARB); \
  FUNC(glMultiTexCoord2f); \
  FUNC(glMultiTexCoord2fvARB); \
  FUNC(glMultiTexCoord2fv); \
  FUNC(glMultiTexCoord2hNV); \
  FUNC(glMultiTexCoord2hvNV); \
  FUNC(glMultiTexCoord2iARB); \
  FUNC(glMultiTexCoord2i); \
  FUNC(glMultiTexCoord2ivARB); \
  FUNC(glMultiTexCoord2iv); \
  FUNC(glMultiTexCoord2sARB); \
  FUNC(glMultiTexCoord2s); \
  FUNC(glMultiTexCoord2svARB); \
  FUNC(glMultiTexCoord2sv); \
  FUNC(glMultiTexCoord2xOES); \
  FUNC(glMultiTexCoord2xvOES); \
  FUNC(glMultiTexCoord3bOES); \
  FUNC(glMultiTexCoord3bvOES); \
  FUNC(glMultiTexCoord3dARB); \
  FUNC(glMultiTexCoord3d); \
  FUNC(glMultiTexCoord3dvARB); \
  FUNC(glMultiTexCoord3dv); \
  FUNC(glMultiTexCoord3fARB); \
  FUNC(glMultiTexCoord3f); \
  FUNC(glMultiTexCoord3fvARB); \
  FUNC(glMultiTexCoord3fv); \
  FUNC(glMultiTexCoord3hNV); \
  FUNC(glMultiTexCoord3hvNV); \
  FUNC(glMultiTexCoord3iARB); \
  FUNC(glMultiTexCoord3i); \
  FUNC(glMultiTexCoord3ivARB); \
  FUNC(glMultiTexCoord3iv); \
  FUNC(glMultiTexCoord3sARB); \
  FUNC(glMultiTexCoord3s); \
  FUNC(glMultiTexCoord3svARB); \
  FUNC(glMultiTexCoord3sv); \
  FUNC(glMultiTexCoord3xOES); \
  FUNC(glMultiTexCoord3xvOES); \
  FUNC(glMultiTexCoord4bOES); \
  FUNC(glMultiTexCoord4bvOES); \
  FUNC(glMultiTexCoord4dARB); \
  FUNC(glMultiTexCoord4d); \
  FUNC(glMultiTexCoord4dvARB); \
  FUNC(glMultiTexCoord4dv); \
  FUNC(glMultiTexCoord4fARB); \
  FUNC(glMultiTexCoord4f); \
  FUNC(glMultiTexCoord4fvARB); \
  FUNC(glMultiTexCoord4fv); \
  FUNC(glMultiTexCoord4hNV); \
  FUNC(glMultiTexCoord4hvNV); \
  FUNC(glMultiTexCoord4iARB); \
  FUNC(glMultiTexCoord4i); \
  FUNC(glMultiTexCoord4ivARB); \
  FUNC(glMultiTexCoord4iv); \
  FUNC(glMultiTexCoord4sARB); \
  FUNC(glMultiTexCoord4s); \
  FUNC(glMultiTexCoord4svARB); \
  FUNC(glMultiTexCoord4sv); \
  FUNC(glMultiTexCoord4xOES); \
  FUNC(glMultiTexCoord4xvOES); \
  FUNC(glMultiTexCoordP1ui); \
  FUNC(glMultiTexCoordP1uiv); \
  FUNC(glMultiTexCoordP2ui); \
  FUNC(glMultiTexCoordP2uiv); \
  FUNC(glMultiTexCoordP3ui); \
  FUNC(glMultiTexCoordP3uiv); \
  FUNC(glMultiTexCoordP4ui); \
  FUNC(glMultiTexCoordP4uiv); \
  FUNC(glMultiTexCoordPointerEXT); \
  FUNC(glMultiTexEnvfEXT); \
  FUNC(glMultiTexEnvfvEXT); \
  FUNC(glMultiTexEnviEXT); \
  FUNC(glMultiTexEnvivEXT); \
  FUNC(glMultiTexGendEXT); \
  FUNC(glMultiTexGendvEXT); \
  FUNC(glMultiTexGenfEXT); \
  FUNC(glMultiTexGenfvEXT); \
  FUNC(glMultiTexGeniEXT); \
  FUNC(glMultiTexGenivEXT); \
  FUNC(glMultiTexRenderbufferEXT); \
  FUNC(glMultMatrixd); \
  FUNC(glMultMatrixf); \
  FUNC(glMultMatrixxOES); \
  FUNC(glMultTransposeMatrixdARB); \
  FUNC(glMultTransposeMatrixd); \
  FUNC(glMultTransposeMatrixfARB); \
  FUNC(glMultTransposeMatrixf); \
  FUNC(glMultTransposeMatrixxOES); \
  FUNC(glNamedBufferPageCommitmentARB); \
  FUNC(glNamedBufferPageCommitmentEXT); \
  FUNC(glNamedBufferStorageExternalEXT); \
  FUNC(glNamedFramebufferSampleLocationsfvARB); \
  FUNC(glNamedFramebufferSampleLocationsfvNV); \
  FUNC(glNamedFramebufferSamplePositionsfvAMD); \
  FUNC(glNamedFramebufferTextureFaceEXT); \
  FUNC(glNamedProgramLocalParameter4dEXT); \
  FUNC(glNamedProgramLocalParameter4dvEXT); \
  FUNC(glNamedProgramLocalParameter4fEXT); \
  FUNC(glNamedProgramLocalParameter4fvEXT); \
  FUNC(glNamedProgramLocalParameterI4iEXT); \
  FUNC(glNamedProgramLocalParameterI4ivEXT); \
  FUNC(glNamedProgramLocalParameterI4uiEXT); \
  FUNC(glNamedProgramLocalParameterI4uivEXT); \
  FUNC(glNamedProgramLocalParameters4fvEXT); \
  FUNC(glNamedProgramLocalParametersI4ivEXT); \
  FUNC(glNamedProgramLocalParametersI4uivEXT); \
  FUNC(glNamedProgramStringEXT); \
  FUNC(glNamedRenderbufferStorageMultisampleCoverageEXT); \
  FUNC(glNewList); \
  FUNC(glNewObjectBufferATI); \
  FUNC(glNormal3b); \
  FUNC(glNormal3bv); \
  FUNC(glNormal3d); \
  FUNC(glNormal3dv); \
  FUNC(glNormal3f); \
  FUNC(glNormal3fVertex3fSUN); \
  FUNC(glNormal3fVertex3fvSUN); \
  FUNC(glNormal3fv); \
  FUNC(glNormal3hNV); \
  FUNC(glNormal3hvNV); \
  FUNC(glNormal3i); \
  FUNC(glNormal3iv); \
  FUNC(glNormal3s); \
  FUNC(glNormal3sv); \
  FUNC(glNormal3xOES); \
  FUNC(glNormal3xvOES); \
  FUNC(glNormalFormatNV); \
  FUNC(glNormalP3ui); \
  FUNC(glNormalP3uiv); \
  FUNC(glNormalPointerEXT); \
  FUNC(glNormalPointerListIBM); \
  FUNC(glNormalPointer); \
  FUNC(glNormalPointervINTEL); \
  FUNC(glNormalStream3bATI); \
  FUNC(glNormalStream3bvATI); \
  FUNC(glNormalStream3dATI); \
  FUNC(glNormalStream3dvATI); \
  FUNC(glNormalStream3fATI); \
  FUNC(glNormalStream3fvATI); \
  FUNC(glNormalStream3iATI); \
  FUNC(glNormalStream3ivATI); \
  FUNC(glNormalStream3sATI); \
  FUNC(glNormalStream3svATI); \
  FUNC(glObjectPurgeableAPPLE); \
  FUNC(glObjectUnpurgeableAPPLE); \
  FUNC(glOrthofOES); \
  FUNC(glOrtho); \
  FUNC(glOrthoxOES); \
  FUNC(glPassTexCoordATI); \
  FUNC(glPassThrough); \
  FUNC(glPassThroughxOES); \
  FUNC(glPathColorGenNV); \
  FUNC(glPathCommandsNV); \
  FUNC(glPathCoordsNV); \
  FUNC(glPathCoverDepthFuncNV); \
  FUNC(glPathDashArrayNV); \
  FUNC(glPathFogGenNV); \
  FUNC(glPathGlyphIndexArrayNV); \
  FUNC(glPathGlyphIndexRangeNV); \
  FUNC(glPathGlyphRangeNV); \
  FUNC(glPathGlyphsNV); \
  FUNC(glPathMemoryGlyphIndexArrayNV); \
  FUNC(glPathParameterfNV); \
  FUNC(glPathParameterfvNV); \
  FUNC(glPathParameteriNV); \
  FUNC(glPathParameterivNV); \
  FUNC(glPathStencilDepthOffsetNV); \
  FUNC(glPathStencilFuncNV); \
  FUNC(glPathStringNV); \
  FUNC(glPathSubCommandsNV); \
  FUNC(glPathSubCoordsNV); \
  FUNC(glPathTexGenNV); \
  FUNC(glPauseTransformFeedbackNV); \
  FUNC(glPixelDataRangeNV); \
  FUNC(glPixelMapfv); \
  FUNC(glPixelMapuiv); \
  FUNC(glPixelMapusv); \
  FUNC(glPixelMapx); \
  FUNC(glPixelStorex); \
  FUNC(glPixelTexGenParameterfSGIS); \
  FUNC(glPixelTexGenParameterfvSGIS); \
  FUNC(glPixelTexGenParameteriSGIS); \
  FUNC(glPixelTexGenParameterivSGIS); \
  FUNC(glPixelTexGenSGIX); \
  FUNC(glPixelTransferf); \
  FUNC(glPixelTransferi); \
  FUNC(glPixelTransferxOES); \
  FUNC(glPixelTransformParameterfEXT); \
  FUNC(glPixelTransformParameterfvEXT); \
  FUNC(glPixelTransformParameteriEXT); \
  FUNC(glPixelTransformParameterivEXT); \
  FUNC(glPixelZoom); \
  FUNC(glPixelZoomxOES); \
  FUNC(glPNTrianglesfATI); \
  FUNC(glPNTrianglesiATI); \
  FUNC(glPointAlongPathNV); \
  FUNC(glPointParameterfSGIS); \
  FUNC(glPointParameterfvSGIS); \
  FUNC(glPointParameteriNV); \
  FUNC(glPointParameterivNV); \
  FUNC(glPointParameterxvOES); \
  FUNC(glPointSizexOES); \
  FUNC(glPollAsyncSGIX); \
  FUNC(glPollInstrumentsSGIX); \
  FUNC(glPolygonModeNV); \
  FUNC(glPolygonOffsetEXT); \
  FUNC(glPolygonOffsetxOES); \
  FUNC(glPolygonStipple); \
  FUNC(glPopAttrib); \
  FUNC(glPopClientAttrib); \
  FUNC(glPopMatrix); \
  FUNC(glPopName); \
  FUNC(glPresentFrameDualFillNV); \
  FUNC(glPresentFrameKeyedNV); \
  FUNC(glPrimitiveRestartIndexNV); \
  FUNC(glPrimitiveRestartNV); \
  FUNC(glPrioritizeTexturesEXT); \
  FUNC(glPrioritizeTextures); \
  FUNC(glPrioritizeTexturesxOES); \
  FUNC(glProgramBinaryOES); \
  FUNC(glProgramBufferParametersfvNV); \
  FUNC(glProgramBufferParametersIivNV); \
  FUNC(glProgramBufferParametersIuivNV); \
  FUNC(glProgramEnvParameter4dARB); \
  FUNC(glProgramEnvParameter4dvARB); \
  FUNC(glProgramEnvParameter4fARB); \
  FUNC(glProgramEnvParameter4fvARB); \
  FUNC(glProgramEnvParameterI4iNV); \
  FUNC(glProgramEnvParameterI4ivNV); \
  FUNC(glProgramEnvParameterI4uiNV); \
  FUNC(glProgramEnvParameterI4uivNV); \
  FUNC(glProgramEnvParameters4fvEXT); \
  FUNC(glProgramEnvParametersI4ivNV); \
  FUNC(glProgramEnvParametersI4uivNV); \
  FUNC(glProgramLocalParameter4dARB); \
  FUNC(glProgramLocalParameter4dvARB); \
  FUNC(glProgramLocalParameter4fARB); \
  FUNC(glProgramLocalParameter4fvARB); \
  FUNC(glProgramLocalParameterI4iNV); \
  FUNC(glProgramLocalParameterI4ivNV); \
  FUNC(glProgramLocalParameterI4uiNV); \
  FUNC(glProgramLocalParameterI4uivNV); \
  FUNC(glProgramLocalParameters4fvEXT); \
  FUNC(glProgramLocalParametersI4ivNV); \
  FUNC(glProgramLocalParametersI4uivNV); \
  FUNC(glProgramNamedParameter4dNV); \
  FUNC(glProgramNamedParameter4dvNV); \
  FUNC(glProgramNamedParameter4fNV); \
  FUNC(glProgramNamedParameter4fvNV); \
  FUNC(glProgramParameter4dNV); \
  FUNC(glProgramParameter4dvNV); \
  FUNC(glProgramParameter4fNV); \
  FUNC(glProgramParameter4fvNV); \
  FUNC(glProgramParameters4dvNV); \
  FUNC(glProgramParameters4fvNV); \
  FUNC(glProgramPathFragmentInputGenNV); \
  FUNC(glProgramStringARB); \
  FUNC(glProgramSubroutineParametersuivNV); \
  FUNC(glProgramUniform1i64ARB); \
  FUNC(glProgramUniform1i64NV); \
  FUNC(glProgramUniform1i64vARB); \
  FUNC(glProgramUniform1i64vNV); \
  FUNC(glProgramUniform1ui64ARB); \
  FUNC(glProgramUniform1ui64NV); \
  FUNC(glProgramUniform1ui64vARB); \
  FUNC(glProgramUniform1ui64vNV); \
  FUNC(glProgramUniform2i64ARB); \
  FUNC(glProgramUniform2i64NV); \
  FUNC(glProgramUniform2i64vARB); \
  FUNC(glProgramUniform2i64vNV); \
  FUNC(glProgramUniform2ui64ARB); \
  FUNC(glProgramUniform2ui64NV); \
  FUNC(glProgramUniform2ui64vARB); \
  FUNC(glProgramUniform2ui64vNV); \
  FUNC(glProgramUniform3i64ARB); \
  FUNC(glProgramUniform3i64NV); \
  FUNC(glProgramUniform3i64vARB); \
  FUNC(glProgramUniform3i64vNV); \
  FUNC(glProgramUniform3ui64ARB); \
  FUNC(glProgramUniform3ui64NV); \
  FUNC(glProgramUniform3ui64vARB); \
  FUNC(glProgramUniform3ui64vNV); \
  FUNC(glProgramUniform4i64ARB); \
  FUNC(glProgramUniform4i64NV); \
  FUNC(glProgramUniform4i64vARB); \
  FUNC(glProgramUniform4i64vNV); \
  FUNC(glProgramUniform4ui64ARB); \
  FUNC(glProgramUniform4ui64NV); \
  FUNC(glProgramUniform4ui64vARB); \
  FUNC(glProgramUniform4ui64vNV); \
  FUNC(glProgramUniformHandleui64ARB); \
  FUNC(glProgramUniformHandleui64IMG); \
  FUNC(glProgramUniformHandleui64NV); \
  FUNC(glProgramUniformHandleui64vARB); \
  FUNC(glProgramUniformHandleui64vIMG); \
  FUNC(glProgramUniformHandleui64vNV); \
  FUNC(glProgramUniformui64NV); \
  FUNC(glProgramUniformui64vNV); \
  FUNC(glProgramVertexLimitNV); \
  FUNC(glPushAttrib); \
  FUNC(glPushClientAttribDefaultEXT); \
  FUNC(glPushClientAttrib); \
  FUNC(glPushMatrix); \
  FUNC(glPushName); \
  FUNC(glQueryMatrixxOES); \
  FUNC(glQueryObjectParameteruiAMD); \
  FUNC(glQueryResourceNV); \
  FUNC(glQueryResourceTagNV); \
  FUNC(glRasterPos2d); \
  FUNC(glRasterPos2dv); \
  FUNC(glRasterPos2f); \
  FUNC(glRasterPos2fv); \
  FUNC(glRasterPos2i); \
  FUNC(glRasterPos2iv); \
  FUNC(glRasterPos2s); \
  FUNC(glRasterPos2sv); \
  FUNC(glRasterPos2xOES); \
  FUNC(glRasterPos2xvOES); \
  FUNC(glRasterPos3d); \
  FUNC(glRasterPos3dv); \
  FUNC(glRasterPos3f); \
  FUNC(glRasterPos3fv); \
  FUNC(glRasterPos3i); \
  FUNC(glRasterPos3iv); \
  FUNC(glRasterPos3s); \
  FUNC(glRasterPos3sv); \
  FUNC(glRasterPos3xOES); \
  FUNC(glRasterPos3xvOES); \
  FUNC(glRasterPos4d); \
  FUNC(glRasterPos4dv); \
  FUNC(glRasterPos4f); \
  FUNC(glRasterPos4fv); \
  FUNC(glRasterPos4i); \
  FUNC(glRasterPos4iv); \
  FUNC(glRasterPos4s); \
  FUNC(glRasterPos4sv); \
  FUNC(glRasterPos4xOES); \
  FUNC(glRasterPos4xvOES); \
  FUNC(glReadBufferIndexedEXT); \
  FUNC(glReadBufferNV); \
  FUNC(glReadInstrumentsSGIX); \
  FUNC(glReadnPixelsKHR); \
  FUNC(glRectd); \
  FUNC(glRectdv); \
  FUNC(glRectf); \
  FUNC(glRectfv); \
  FUNC(glRecti); \
  FUNC(glRectiv); \
  FUNC(glRects); \
  FUNC(glRectsv); \
  FUNC(glRectxOES); \
  FUNC(glRectxvOES); \
  FUNC(glReferencePlaneSGIX); \
  FUNC(glRenderbufferStorageMultisampleANGLE); \
  FUNC(glRenderbufferStorageMultisampleAPPLE); \
  FUNC(glRenderbufferStorageMultisampleCoverageNV); \
  FUNC(glRenderbufferStorageMultisampleIMG); \
  FUNC(glRenderbufferStorageMultisampleNV); \
  FUNC(glRenderGpuMaskNV); \
  FUNC(glRenderMode); \
  FUNC(glReplacementCodePointerSUN); \
  FUNC(glReplacementCodeubSUN); \
  FUNC(glReplacementCodeubvSUN); \
  FUNC(glReplacementCodeuiColor3fVertex3fSUN); \
  FUNC(glReplacementCodeuiColor3fVertex3fvSUN); \
  FUNC(glReplacementCodeuiColor4fNormal3fVertex3fSUN); \
  FUNC(glReplacementCodeuiColor4fNormal3fVertex3fvSUN); \
  FUNC(glReplacementCodeuiColor4ubVertex3fSUN); \
  FUNC(glReplacementCodeuiColor4ubVertex3fvSUN); \
  FUNC(glReplacementCodeuiNormal3fVertex3fSUN); \
  FUNC(glReplacementCodeuiNormal3fVertex3fvSUN); \
  FUNC(glReplacementCodeuiSUN); \
  FUNC(glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN); \
  FUNC(glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN); \
  FUNC(glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN); \
  FUNC(glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN); \
  FUNC(glReplacementCodeuiTexCoord2fVertex3fSUN); \
  FUNC(glReplacementCodeuiTexCoord2fVertex3fvSUN); \
  FUNC(glReplacementCodeuiVertex3fSUN); \
  FUNC(glReplacementCodeuiVertex3fvSUN); \
  FUNC(glReplacementCodeuivSUN); \
  FUNC(glReplacementCodeusSUN); \
  FUNC(glReplacementCodeusvSUN); \
  FUNC(glRequestResidentProgramsNV); \
  FUNC(glResetHistogramEXT); \
  FUNC(glResetHistogram); \
  FUNC(glResetMinmaxEXT); \
  FUNC(glResetMinmax); \
  FUNC(glResizeBuffersMESA); \
  FUNC(glResolveDepthValuesNV); \
  FUNC(glResolveMultisampleFramebufferAPPLE); \
  FUNC(glResumeTransformFeedbackNV); \
  FUNC(glRotated); \
  FUNC(glRotatef); \
  FUNC(glRotatexOES); \
  FUNC(glSampleMapATI); \
  FUNC(glSampleMaskEXT); \
  FUNC(glSampleMaskIndexedNV); \
  FUNC(glSampleMaskSGIS); \
  FUNC(glSamplePatternEXT); \
  FUNC(glSamplePatternSGIS); \
  FUNC(glScaled); \
  FUNC(glScalef); \
  FUNC(glScalexOES); \
  FUNC(glSecondaryColor3bEXT); \
  FUNC(glSecondaryColor3b); \
  FUNC(glSecondaryColor3bvEXT); \
  FUNC(glSecondaryColor3bv); \
  FUNC(glSecondaryColor3dEXT); \
  FUNC(glSecondaryColor3d); \
  FUNC(glSecondaryColor3dvEXT); \
  FUNC(glSecondaryColor3dv); \
  FUNC(glSecondaryColor3fEXT); \
  FUNC(glSecondaryColor3f); \
  FUNC(glSecondaryColor3fvEXT); \
  FUNC(glSecondaryColor3fv); \
  FUNC(glSecondaryColor3hNV); \
  FUNC(glSecondaryColor3hvNV); \
  FUNC(glSecondaryColor3iEXT); \
  FUNC(glSecondaryColor3i); \
  FUNC(glSecondaryColor3ivEXT); \
  FUNC(glSecondaryColor3iv); \
  FUNC(glSecondaryColor3sEXT); \
  FUNC(glSecondaryColor3s); \
  FUNC(glSecondaryColor3svEXT); \
  FUNC(glSecondaryColor3sv); \
  FUNC(glSecondaryColor3ubEXT); \
  FUNC(glSecondaryColor3ub); \
  FUNC(glSecondaryColor3ubvEXT); \
  FUNC(glSecondaryColor3ubv); \
  FUNC(glSecondaryColor3uiEXT); \
  FUNC(glSecondaryColor3ui); \
  FUNC(glSecondaryColor3uivEXT); \
  FUNC(glSecondaryColor3uiv); \
  FUNC(glSecondaryColor3usEXT); \
  FUNC(glSecondaryColor3us); \
  FUNC(glSecondaryColor3usvEXT); \
  FUNC(glSecondaryColor3usv); \
  FUNC(glSecondaryColorFormatNV); \
  FUNC(glSecondaryColorP3ui); \
  FUNC(glSecondaryColorP3uiv); \
  FUNC(glSecondaryColorPointerEXT); \
  FUNC(glSecondaryColorPointerListIBM); \
  FUNC(glSecondaryColorPointer); \
  FUNC(glSelectBuffer); \
  FUNC(glSelectPerfMonitorCountersAMD); \
  FUNC(glSeparableFilter2DEXT); \
  FUNC(glSeparableFilter2D); \
  FUNC(glSetFenceAPPLE); \
  FUNC(glSetFenceNV); \
  FUNC(glSetFragmentShaderConstantATI); \
  FUNC(glSetInvariantEXT); \
  FUNC(glSetLocalConstantEXT); \
  FUNC(glSetMultisamplefvAMD); \
  FUNC(glShadeModel); \
  FUNC(glShaderOp1EXT); \
  FUNC(glShaderOp2EXT); \
  FUNC(glShaderOp3EXT); \
  FUNC(glShaderSourceARB); \
  FUNC(glSharpenTexFuncSGIS); \
  FUNC(glSignalVkFenceNV); \
  FUNC(glSignalVkSemaphoreNV); \
  FUNC(glSpriteParameterfSGIX); \
  FUNC(glSpriteParameterfvSGIX); \
  FUNC(glSpriteParameteriSGIX); \
  FUNC(glSpriteParameterivSGIX); \
  FUNC(glStartInstrumentsSGIX); \
  FUNC(glStartTilingQCOM); \
  FUNC(glStateCaptureNV); \
  FUNC(glStencilClearTagEXT); \
  FUNC(glStencilFillPathInstancedNV); \
  FUNC(glStencilFillPathNV); \
  FUNC(glStencilFuncSeparateATI); \
  FUNC(glStencilOpSeparateATI); \
  FUNC(glStencilOpValueAMD); \
  FUNC(glStencilStrokePathInstancedNV); \
  FUNC(glStencilStrokePathNV); \
  FUNC(glStencilThenCoverFillPathInstancedNV); \
  FUNC(glStencilThenCoverFillPathNV); \
  FUNC(glStencilThenCoverStrokePathInstancedNV); \
  FUNC(glStencilThenCoverStrokePathNV); \
  FUNC(glStopInstrumentsSGIX); \
  FUNC(glSubpixelPrecisionBiasNV); \
  FUNC(glSwizzleEXT); \
  FUNC(glSyncTextureINTEL); \
  FUNC(glTagSampleBufferSGIX); \
  FUNC(glTangent3bEXT); \
  FUNC(glTangent3bvEXT); \
  FUNC(glTangent3dEXT); \
  FUNC(glTangent3dvEXT); \
  FUNC(glTangent3fEXT); \
  FUNC(glTangent3fvEXT); \
  FUNC(glTangent3iEXT); \
  FUNC(glTangent3ivEXT); \
  FUNC(glTangent3sEXT); \
  FUNC(glTangent3svEXT); \
  FUNC(glTangentPointerEXT); \
  FUNC(glTbufferMask3DFX); \
  FUNC(glTessellationFactorAMD); \
  FUNC(glTessellationModeAMD); \
  FUNC(glTestFenceAPPLE); \
  FUNC(glTestFenceNV); \
  FUNC(glTestObjectAPPLE); \
  FUNC(glTexBumpParameterfvATI); \
  FUNC(glTexBumpParameterivATI); \
  FUNC(glTexCoord1bOES); \
  FUNC(glTexCoord1bvOES); \
  FUNC(glTexCoord1d); \
  FUNC(glTexCoord1dv); \
  FUNC(glTexCoord1f); \
  FUNC(glTexCoord1fv); \
  FUNC(glTexCoord1hNV); \
  FUNC(glTexCoord1hvNV); \
  FUNC(glTexCoord1i); \
  FUNC(glTexCoord1iv); \
  FUNC(glTexCoord1s); \
  FUNC(glTexCoord1sv); \
  FUNC(glTexCoord1xOES); \
  FUNC(glTexCoord1xvOES); \
  FUNC(glTexCoord2bOES); \
  FUNC(glTexCoord2bvOES); \
  FUNC(glTexCoord2d); \
  FUNC(glTexCoord2dv); \
  FUNC(glTexCoord2fColor3fVertex3fSUN); \
  FUNC(glTexCoord2fColor3fVertex3fvSUN); \
  FUNC(glTexCoord2fColor4fNormal3fVertex3fSUN); \
  FUNC(glTexCoord2fColor4fNormal3fVertex3fvSUN); \
  FUNC(glTexCoord2fColor4ubVertex3fSUN); \
  FUNC(glTexCoord2fColor4ubVertex3fvSUN); \
  FUNC(glTexCoord2fNormal3fVertex3fSUN); \
  FUNC(glTexCoord2fNormal3fVertex3fvSUN); \
  FUNC(glTexCoord2f); \
  FUNC(glTexCoord2fVertex3fSUN); \
  FUNC(glTexCoord2fVertex3fvSUN); \
  FUNC(glTexCoord2fv); \
  FUNC(glTexCoord2hNV); \
  FUNC(glTexCoord2hvNV); \
  FUNC(glTexCoord2i); \
  FUNC(glTexCoord2iv); \
  FUNC(glTexCoord2s); \
  FUNC(glTexCoord2sv); \
  FUNC(glTexCoord2xOES); \
  FUNC(glTexCoord2xvOES); \
  FUNC(glTexCoord3bOES); \
  FUNC(glTexCoord3bvOES); \
  FUNC(glTexCoord3d); \
  FUNC(glTexCoord3dv); \
  FUNC(glTexCoord3f); \
  FUNC(glTexCoord3fv); \
  FUNC(glTexCoord3hNV); \
  FUNC(glTexCoord3hvNV); \
  FUNC(glTexCoord3i); \
  FUNC(glTexCoord3iv); \
  FUNC(glTexCoord3s); \
  FUNC(glTexCoord3sv); \
  FUNC(glTexCoord3xOES); \
  FUNC(glTexCoord3xvOES); \
  FUNC(glTexCoord4bOES); \
  FUNC(glTexCoord4bvOES); \
  FUNC(glTexCoord4d); \
  FUNC(glTexCoord4dv); \
  FUNC(glTexCoord4fColor4fNormal3fVertex4fSUN); \
  FUNC(glTexCoord4fColor4fNormal3fVertex4fvSUN); \
  FUNC(glTexCoord4f); \
  FUNC(glTexCoord4fVertex4fSUN); \
  FUNC(glTexCoord4fVertex4fvSUN); \
  FUNC(glTexCoord4fv); \
  FUNC(glTexCoord4hNV); \
  FUNC(glTexCoord4hvNV); \
  FUNC(glTexCoord4i); \
  FUNC(glTexCoord4iv); \
  FUNC(glTexCoord4s); \
  FUNC(glTexCoord4sv); \
  FUNC(glTexCoord4xOES); \
  FUNC(glTexCoord4xvOES); \
  FUNC(glTexCoordFormatNV); \
  FUNC(glTexCoordP1ui); \
  FUNC(glTexCoordP1uiv); \
  FUNC(glTexCoordP2ui); \
  FUNC(glTexCoordP2uiv); \
  FUNC(glTexCoordP3ui); \
  FUNC(glTexCoordP3uiv); \
  FUNC(glTexCoordP4ui); \
  FUNC(glTexCoordP4uiv); \
  FUNC(glTexCoordPointerEXT); \
  FUNC(glTexCoordPointerListIBM); \
  FUNC(glTexCoordPointer); \
  FUNC(glTexCoordPointervINTEL); \
  FUNC(glTexEnvf); \
  FUNC(glTexEnvfv); \
  FUNC(glTexEnvi); \
  FUNC(glTexEnviv); \
  FUNC(glTexEnvxOES); \
  FUNC(glTexEnvxvOES); \
  FUNC(glTexFilterFuncSGIS); \
  FUNC(glTexGend); \
  FUNC(glTexGendv); \
  FUNC(glTexGenf); \
  FUNC(glTexGenfv); \
  FUNC(glTexGeni); \
  FUNC(glTexGeniv); \
  FUNC(glTexGenxOES); \
  FUNC(glTexGenxvOES); \
  FUNC(glTexImage2DMultisampleCoverageNV); \
  FUNC(glTexImage3DMultisampleCoverageNV); \
  FUNC(glTexImage4DSGIS); \
  FUNC(glTexPageCommitmentARB); \
  FUNC(glTexPageCommitmentEXT); \
  FUNC(glTexParameterxOES); \
  FUNC(glTexParameterxvOES); \
  FUNC(glTexRenderbufferNV); \
  FUNC(glTexStorageSparseAMD); \
  FUNC(glTexSubImage1DEXT); \
  FUNC(glTexSubImage2DEXT); \
  FUNC(glTexSubImage3DEXT); \
  FUNC(glTexSubImage4DSGIS); \
  FUNC(glTextureBarrierNV); \
  FUNC(glTextureColorMaskSGIS); \
  FUNC(glTextureImage2DMultisampleCoverageNV); \
  FUNC(glTextureImage2DMultisampleNV); \
  FUNC(glTextureImage3DMultisampleCoverageNV); \
  FUNC(glTextureImage3DMultisampleNV); \
  FUNC(glTextureLightEXT); \
  FUNC(glTextureMaterialEXT); \
  FUNC(glTextureNormalEXT); \
  FUNC(glTexturePageCommitmentEXT); \
  FUNC(glTextureRangeAPPLE); \
  FUNC(glTextureRenderbufferEXT); \
  FUNC(glTextureStorageSparseAMD); \
  FUNC(glTrackMatrixNV); \
  FUNC(glTransformFeedbackAttribsNV); \
  FUNC(glTransformFeedbackStreamAttribsNV); \
  FUNC(glTransformFeedbackVaryingsNV); \
  FUNC(glTransformPathNV); \
  FUNC(glTranslated); \
  FUNC(glTranslatef); \
  FUNC(glTranslatexOES); \
  FUNC(glUniform1i64ARB); \
  FUNC(glUniform1i64NV); \
  FUNC(glUniform1i64vARB); \
  FUNC(glUniform1i64vNV); \
  FUNC(glUniform1ui64ARB); \
  FUNC(glUniform1ui64NV); \
  FUNC(glUniform1ui64vARB); \
  FUNC(glUniform1ui64vNV); \
  FUNC(glUniform2i64ARB); \
  FUNC(glUniform2i64NV); \
  FUNC(glUniform2i64vARB); \
  FUNC(glUniform2i64vNV); \
  FUNC(glUniform2ui64ARB); \
  FUNC(glUniform2ui64NV); \
  FUNC(glUniform2ui64vARB); \
  FUNC(glUniform2ui64vNV); \
  FUNC(glUniform3i64ARB); \
  FUNC(glUniform3i64NV); \
  FUNC(glUniform3i64vARB); \
  FUNC(glUniform3i64vNV); \
  FUNC(glUniform3ui64ARB); \
  FUNC(glUniform3ui64NV); \
  FUNC(glUniform3ui64vARB); \
  FUNC(glUniform3ui64vNV); \
  FUNC(glUniform4i64ARB); \
  FUNC(glUniform4i64NV); \
  FUNC(glUniform4i64vARB); \
  FUNC(glUniform4i64vNV); \
  FUNC(glUniform4ui64ARB); \
  FUNC(glUniform4ui64NV); \
  FUNC(glUniform4ui64vARB); \
  FUNC(glUniform4ui64vNV); \
  FUNC(glUniformBufferEXT); \
  FUNC(glUniformHandleui64ARB); \
  FUNC(glUniformHandleui64IMG); \
  FUNC(glUniformHandleui64NV); \
  FUNC(glUniformHandleui64vARB); \
  FUNC(glUniformHandleui64vIMG); \
  FUNC(glUniformHandleui64vNV); \
  FUNC(glUniformMatrix2x3fvNV); \
  FUNC(glUniformMatrix2x4fvNV); \
  FUNC(glUniformMatrix3x2fvNV); \
  FUNC(glUniformMatrix3x4fvNV); \
  FUNC(glUniformMatrix4x2fvNV); \
  FUNC(glUniformMatrix4x3fvNV); \
  FUNC(glUniformui64NV); \
  FUNC(glUniformui64vNV); \
  FUNC(glUnlockArraysEXT); \
  FUNC(glUnmapObjectBufferATI); \
  FUNC(glUnmapTexture2DINTEL); \
  FUNC(glUpdateObjectBufferATI); \
  FUNC(glUseProgramObjectARB); \
  FUNC(glUseShaderProgramEXT); \
  FUNC(glValidateProgramARB); \
  FUNC(glVariantArrayObjectATI); \
  FUNC(glVariantbvEXT); \
  FUNC(glVariantdvEXT); \
  FUNC(glVariantfvEXT); \
  FUNC(glVariantivEXT); \
  FUNC(glVariantPointerEXT); \
  FUNC(glVariantsvEXT); \
  FUNC(glVariantubvEXT); \
  FUNC(glVariantuivEXT); \
  FUNC(glVariantusvEXT); \
  FUNC(glVDPAUFiniNV); \
  FUNC(glVDPAUGetSurfaceivNV); \
  FUNC(glVDPAUInitNV); \
  FUNC(glVDPAUIsSurfaceNV); \
  FUNC(glVDPAUMapSurfacesNV); \
  FUNC(glVDPAURegisterOutputSurfaceNV); \
  FUNC(glVDPAURegisterVideoSurfaceNV); \
  FUNC(glVDPAUSurfaceAccessNV); \
  FUNC(glVDPAUUnmapSurfacesNV); \
  FUNC(glVDPAUUnregisterSurfaceNV); \
  FUNC(glVertex2bOES); \
  FUNC(glVertex2bvOES); \
  FUNC(glVertex2d); \
  FUNC(glVertex2dv); \
  FUNC(glVertex2f); \
  FUNC(glVertex2fv); \
  FUNC(glVertex2hNV); \
  FUNC(glVertex2hvNV); \
  FUNC(glVertex2i); \
  FUNC(glVertex2iv); \
  FUNC(glVertex2s); \
  FUNC(glVertex2sv); \
  FUNC(glVertex2xOES); \
  FUNC(glVertex2xvOES); \
  FUNC(glVertex3bOES); \
  FUNC(glVertex3bvOES); \
  FUNC(glVertex3d); \
  FUNC(glVertex3dv); \
  FUNC(glVertex3f); \
  FUNC(glVertex3fv); \
  FUNC(glVertex3hNV); \
  FUNC(glVertex3hvNV); \
  FUNC(glVertex3i); \
  FUNC(glVertex3iv); \
  FUNC(glVertex3s); \
  FUNC(glVertex3sv); \
  FUNC(glVertex3xOES); \
  FUNC(glVertex3xvOES); \
  FUNC(glVertex4bOES); \
  FUNC(glVertex4bvOES); \
  FUNC(glVertex4d); \
  FUNC(glVertex4dv); \
  FUNC(glVertex4f); \
  FUNC(glVertex4fv); \
  FUNC(glVertex4hNV); \
  FUNC(glVertex4hvNV); \
  FUNC(glVertex4i); \
  FUNC(glVertex4iv); \
  FUNC(glVertex4s); \
  FUNC(glVertex4sv); \
  FUNC(glVertex4xOES); \
  FUNC(glVertex4xvOES); \
  FUNC(glVertexArrayColorOffsetEXT); \
  FUNC(glVertexArrayEdgeFlagOffsetEXT); \
  FUNC(glVertexArrayFogCoordOffsetEXT); \
  FUNC(glVertexArrayIndexOffsetEXT); \
  FUNC(glVertexArrayMultiTexCoordOffsetEXT); \
  FUNC(glVertexArrayNormalOffsetEXT); \
  FUNC(glVertexArrayParameteriAPPLE); \
  FUNC(glVertexArrayRangeAPPLE); \
  FUNC(glVertexArrayRangeNV); \
  FUNC(glVertexArraySecondaryColorOffsetEXT); \
  FUNC(glVertexArrayTexCoordOffsetEXT); \
  FUNC(glVertexArrayVertexOffsetEXT); \
  FUNC(glVertexAttrib1dNV); \
  FUNC(glVertexAttrib1dvNV); \
  FUNC(glVertexAttrib1fNV); \
  FUNC(glVertexAttrib1fvNV); \
  FUNC(glVertexAttrib1hNV); \
  FUNC(glVertexAttrib1hvNV); \
  FUNC(glVertexAttrib1sNV); \
  FUNC(glVertexAttrib1svNV); \
  FUNC(glVertexAttrib2dNV); \
  FUNC(glVertexAttrib2dvNV); \
  FUNC(glVertexAttrib2fNV); \
  FUNC(glVertexAttrib2fvNV); \
  FUNC(glVertexAttrib2hNV); \
  FUNC(glVertexAttrib2hvNV); \
  FUNC(glVertexAttrib2sNV); \
  FUNC(glVertexAttrib2svNV); \
  FUNC(glVertexAttrib3dNV); \
  FUNC(glVertexAttrib3dvNV); \
  FUNC(glVertexAttrib3fNV); \
  FUNC(glVertexAttrib3fvNV); \
  FUNC(glVertexAttrib3hNV); \
  FUNC(glVertexAttrib3hvNV); \
  FUNC(glVertexAttrib3sNV); \
  FUNC(glVertexAttrib3svNV); \
  FUNC(glVertexAttrib4dNV); \
  FUNC(glVertexAttrib4dvNV); \
  FUNC(glVertexAttrib4fNV); \
  FUNC(glVertexAttrib4fvNV); \
  FUNC(glVertexAttrib4hNV); \
  FUNC(glVertexAttrib4hvNV); \
  FUNC(glVertexAttrib4NubARB); \
  FUNC(glVertexAttrib4sNV); \
  FUNC(glVertexAttrib4svNV); \
  FUNC(glVertexAttrib4ubNV); \
  FUNC(glVertexAttrib4ubvNV); \
  FUNC(glVertexAttribArrayObjectATI); \
  FUNC(glVertexAttribDivisorANGLE); \
  FUNC(glVertexAttribDivisorEXT); \
  FUNC(glVertexAttribDivisorNV); \
  FUNC(glVertexAttribFormatNV); \
  FUNC(glVertexAttribIFormatNV); \
  FUNC(glVertexAttribL1i64NV); \
  FUNC(glVertexAttribL1i64vNV); \
  FUNC(glVertexAttribL1ui64ARB); \
  FUNC(glVertexAttribL1ui64NV); \
  FUNC(glVertexAttribL1ui64vARB); \
  FUNC(glVertexAttribL1ui64vNV); \
  FUNC(glVertexAttribL2i64NV); \
  FUNC(glVertexAttribL2i64vNV); \
  FUNC(glVertexAttribL2ui64NV); \
  FUNC(glVertexAttribL2ui64vNV); \
  FUNC(glVertexAttribL3i64NV); \
  FUNC(glVertexAttribL3i64vNV); \
  FUNC(glVertexAttribL3ui64NV); \
  FUNC(glVertexAttribL3ui64vNV); \
  FUNC(glVertexAttribL4i64NV); \
  FUNC(glVertexAttribL4i64vNV); \
  FUNC(glVertexAttribL4ui64NV); \
  FUNC(glVertexAttribL4ui64vNV); \
  FUNC(glVertexAttribLFormatNV); \
  FUNC(glVertexAttribParameteriAMD); \
  FUNC(glVertexAttribPointerNV); \
  FUNC(glVertexAttribs1dvNV); \
  FUNC(glVertexAttribs1fvNV); \
  FUNC(glVertexAttribs1hvNV); \
  FUNC(glVertexAttribs1svNV); \
  FUNC(glVertexAttribs2dvNV); \
  FUNC(glVertexAttribs2fvNV); \
  FUNC(glVertexAttribs2hvNV); \
  FUNC(glVertexAttribs2svNV); \
  FUNC(glVertexAttribs3dvNV); \
  FUNC(glVertexAttribs3fvNV); \
  FUNC(glVertexAttribs3hvNV); \
  FUNC(glVertexAttribs3svNV); \
  FUNC(glVertexAttribs4dvNV); \
  FUNC(glVertexAttribs4fvNV); \
  FUNC(glVertexAttribs4hvNV); \
  FUNC(glVertexAttribs4svNV); \
  FUNC(glVertexAttribs4ubvNV); \
  FUNC(glVertexBlendARB); \
  FUNC(glVertexBlendEnvfATI); \
  FUNC(glVertexBlendEnviATI); \
  FUNC(glVertexFormatNV); \
  FUNC(glVertexP2ui); \
  FUNC(glVertexP2uiv); \
  FUNC(glVertexP3ui); \
  FUNC(glVertexP3uiv); \
  FUNC(glVertexP4ui); \
  FUNC(glVertexP4uiv); \
  FUNC(glVertexPointerEXT); \
  FUNC(glVertexPointerListIBM); \
  FUNC(glVertexPointer); \
  FUNC(glVertexPointervINTEL); \
  FUNC(glVertexStream1dATI); \
  FUNC(glVertexStream1dvATI); \
  FUNC(glVertexStream1fATI); \
  FUNC(glVertexStream1fvATI); \
  FUNC(glVertexStream1iATI); \
  FUNC(glVertexStream1ivATI); \
  FUNC(glVertexStream1sATI); \
  FUNC(glVertexStream1svATI); \
  FUNC(glVertexStream2dATI); \
  FUNC(glVertexStream2dvATI); \
  FUNC(glVertexStream2fATI); \
  FUNC(glVertexStream2fvATI); \
  FUNC(glVertexStream2iATI); \
  FUNC(glVertexStream2ivATI); \
  FUNC(glVertexStream2sATI); \
  FUNC(glVertexStream2svATI); \
  FUNC(glVertexStream3dATI); \
  FUNC(glVertexStream3dvATI); \
  FUNC(glVertexStream3fATI); \
  FUNC(glVertexStream3fvATI); \
  FUNC(glVertexStream3iATI); \
  FUNC(glVertexStream3ivATI); \
  FUNC(glVertexStream3sATI); \
  FUNC(glVertexStream3svATI); \
  FUNC(glVertexStream4dATI); \
  FUNC(glVertexStream4dvATI); \
  FUNC(glVertexStream4fATI); \
  FUNC(glVertexStream4fvATI); \
  FUNC(glVertexStream4iATI); \
  FUNC(glVertexStream4ivATI); \
  FUNC(glVertexStream4sATI); \
  FUNC(glVertexStream4svATI); \
  FUNC(glVertexWeightfEXT); \
  FUNC(glVertexWeightfvEXT); \
  FUNC(glVertexWeighthNV); \
  FUNC(glVertexWeighthvNV); \
  FUNC(glVertexWeightPointerEXT); \
  FUNC(glVideoCaptureNV); \
  FUNC(glVideoCaptureStreamParameterdvNV); \
  FUNC(glVideoCaptureStreamParameterfvNV); \
  FUNC(glVideoCaptureStreamParameterivNV); \
  FUNC(glViewportPositionWScaleNV); \
  FUNC(glViewportSwizzleNV); \
  FUNC(glWaitSyncAPPLE); \
  FUNC(glWaitVkSemaphoreNV); \
  FUNC(glWeightbvARB); \
  FUNC(glWeightdvARB); \
  FUNC(glWeightfvARB); \
  FUNC(glWeightivARB); \
  FUNC(glWeightPathsNV); \
  FUNC(glWeightPointerARB); \
  FUNC(glWeightsvARB); \
  FUNC(glWeightubvARB); \
  FUNC(glWeightuivARB); \
  FUNC(glWeightusvARB); \
  FUNC(glWindowPos2dARB); \
  FUNC(glWindowPos2dMESA); \
  FUNC(glWindowPos2d); \
  FUNC(glWindowPos2dvARB); \
  FUNC(glWindowPos2dvMESA); \
  FUNC(glWindowPos2dv); \
  FUNC(glWindowPos2fARB); \
  FUNC(glWindowPos2fMESA); \
  FUNC(glWindowPos2f); \
  FUNC(glWindowPos2fvARB); \
  FUNC(glWindowPos2fvMESA); \
  FUNC(glWindowPos2fv); \
  FUNC(glWindowPos2iARB); \
  FUNC(glWindowPos2iMESA); \
  FUNC(glWindowPos2i); \
  FUNC(glWindowPos2ivARB); \
  FUNC(glWindowPos2ivMESA); \
  FUNC(glWindowPos2iv); \
  FUNC(glWindowPos2sARB); \
  FUNC(glWindowPos2sMESA); \
  FUNC(glWindowPos2s); \
  FUNC(glWindowPos2svARB); \
  FUNC(glWindowPos2svMESA); \
  FUNC(glWindowPos2sv); \
  FUNC(glWindowPos3dARB); \
  FUNC(glWindowPos3dMESA); \
  FUNC(glWindowPos3d); \
  FUNC(glWindowPos3dvARB); \
  FUNC(glWindowPos3dvMESA); \
  FUNC(glWindowPos3dv); \
  FUNC(glWindowPos3fARB); \
  FUNC(glWindowPos3fMESA); \
  FUNC(glWindowPos3f); \
  FUNC(glWindowPos3fvARB); \
  FUNC(glWindowPos3fvMESA); \
  FUNC(glWindowPos3fv); \
  FUNC(glWindowPos3iARB); \
  FUNC(glWindowPos3iMESA); \
  FUNC(glWindowPos3i); \
  FUNC(glWindowPos3ivARB); \
  FUNC(glWindowPos3ivMESA); \
  FUNC(glWindowPos3iv); \
  FUNC(glWindowPos3sARB); \
  FUNC(glWindowPos3sMESA); \
  FUNC(glWindowPos3s); \
  FUNC(glWindowPos3svARB); \
  FUNC(glWindowPos3svMESA); \
  FUNC(glWindowPos3sv); \
  FUNC(glWindowPos4dMESA); \
  FUNC(glWindowPos4dvMESA); \
  FUNC(glWindowPos4fMESA); \
  FUNC(glWindowPos4fvMESA); \
  FUNC(glWindowPos4iMESA); \
  FUNC(glWindowPos4ivMESA); \
  FUNC(glWindowPos4sMESA); \
  FUNC(glWindowPos4svMESA); \
  FUNC(glWindowRectanglesEXT); \
  FUNC(glWriteMaskEXT); \




#define DefineUnsupportedHooks() \
  UnsupportedWrapper2(void, glAccum, GLenum, op, GLfloat, value); \
  UnsupportedWrapper2(void, glAccumxOES, GLenum, op, GLfixed, value); \
  UnsupportedWrapper1(void, glActiveProgramEXT, GLuint, program); \
  UnsupportedWrapper1(void, glActiveStencilFaceEXT, GLenum, face); \
  UnsupportedWrapper2(void, glActiveVaryingNV, GLuint, program, const GLchar *, name); \
  UnsupportedWrapper6(void, glAlphaFragmentOp1ATI, GLenum, op, GLuint, dst, GLuint, dstMod, GLuint, arg1, GLuint, arg1Rep, GLuint, arg1Mod); \
  UnsupportedWrapper9(void, glAlphaFragmentOp2ATI, GLenum, op, GLuint, dst, GLuint, dstMod, GLuint, arg1, GLuint, arg1Rep, GLuint, arg1Mod, GLuint, arg2, GLuint, arg2Rep, GLuint, arg2Mod); \
  UnsupportedWrapper12(void, glAlphaFragmentOp3ATI, GLenum, op, GLuint, dst, GLuint, dstMod, GLuint, arg1, GLuint, arg1Rep, GLuint, arg1Mod, GLuint, arg2, GLuint, arg2Rep, GLuint, arg2Mod, GLuint, arg3, GLuint, arg3Rep, GLuint, arg3Mod); \
  UnsupportedWrapper2(void, glAlphaFunc, GLenum, func, GLfloat, ref); \
  UnsupportedWrapper2(void, glAlphaFuncQCOM, GLenum, func, GLclampf, ref); \
  UnsupportedWrapper2(void, glAlphaFuncxOES, GLenum, func, GLfixed, ref); \
  UnsupportedWrapper1(void, glAlphaToCoverageDitherControlNV, GLenum, mode); \
  UnsupportedWrapper0(void, glApplyFramebufferAttachmentCMAAINTEL); \
  UnsupportedWrapper1(void, glApplyTextureEXT, GLenum, mode); \
  UnsupportedWrapper3(GLboolean, glAreProgramsResidentNV, GLsizei, n, const GLuint *, programs, GLboolean *, residences); \
  UnsupportedWrapper3(GLboolean, glAreTexturesResidentEXT, GLsizei, n, const GLuint *, textures, GLboolean *, residences); \
  UnsupportedWrapper3(GLboolean, glAreTexturesResident, GLsizei, n, const GLuint *, textures, GLboolean *, residences); \
  UnsupportedWrapper1(void, glArrayElementEXT, GLint, i); \
  UnsupportedWrapper1(void, glArrayElement, GLint, i); \
  UnsupportedWrapper6(void, glArrayObjectATI, GLenum, array, GLint, size, GLenum, type, GLsizei, stride, GLuint, buffer, GLuint, offset); \
  UnsupportedWrapper1(void, glAsyncMarkerSGIX, GLuint, marker); \
  UnsupportedWrapper2(void, glAttachObjectARB, GLhandleARB, containerObj, GLhandleARB, obj); \
  UnsupportedWrapper2(void, glBeginConditionalRenderNV, GLuint, id, GLenum, mode); \
  UnsupportedWrapper1(void, glBeginConditionalRenderNVX, GLuint, id); \
  UnsupportedWrapper0(void, glBeginFragmentShaderATI); \
  UnsupportedWrapper1(void, glBeginOcclusionQueryNV, GLuint, id); \
  UnsupportedWrapper1(void, glBeginPerfMonitorAMD, GLuint, monitor); \
  UnsupportedWrapper1(void, glBegin, GLenum, mode); \
  UnsupportedWrapper1(void, glBeginTransformFeedbackNV, GLenum, primitiveMode); \
  UnsupportedWrapper0(void, glBeginVertexShaderEXT); \
  UnsupportedWrapper1(void, glBeginVideoCaptureNV, GLuint, video_capture_slot); \
  UnsupportedWrapper3(void, glBindAttribLocationARB, GLhandleARB, programObj, GLuint, index, const GLcharARB *, name); \
  UnsupportedWrapper3(void, glBindBufferBaseNV, GLenum, target, GLuint, index, GLuint, buffer); \
  UnsupportedWrapper4(void, glBindBufferOffsetEXT, GLenum, target, GLuint, index, GLuint, buffer, GLintptr, offset); \
  UnsupportedWrapper4(void, glBindBufferOffsetNV, GLenum, target, GLuint, index, GLuint, buffer, GLintptr, offset); \
  UnsupportedWrapper5(void, glBindBufferRangeNV, GLenum, target, GLuint, index, GLuint, buffer, GLintptr, offset, GLsizeiptr, size); \
  UnsupportedWrapper4(void, glBindFragDataLocationIndexedEXT, GLuint, program, GLuint, colorNumber, GLuint, index, const GLchar *, name); \
  UnsupportedWrapper1(void, glBindFragmentShaderATI, GLuint, id); \
  UnsupportedWrapper2(GLuint, glBindLightParameterEXT, GLenum, light, GLenum, value); \
  UnsupportedWrapper2(GLuint, glBindMaterialParameterEXT, GLenum, face, GLenum, value); \
  UnsupportedWrapper1(GLuint, glBindParameterEXT, GLenum, value); \
  UnsupportedWrapper2(void, glBindProgramARB, GLenum, target, GLuint, program); \
  UnsupportedWrapper2(void, glBindProgramNV, GLenum, target, GLuint, id); \
  UnsupportedWrapper3(GLuint, glBindTexGenParameterEXT, GLenum, unit, GLenum, coord, GLenum, value); \
  UnsupportedWrapper2(void, glBindTextureEXT, GLenum, target, GLuint, texture); \
  UnsupportedWrapper2(GLuint, glBindTextureUnitParameterEXT, GLenum, unit, GLenum, value); \
  UnsupportedWrapper2(void, glBindTransformFeedbackNV, GLenum, target, GLuint, id); \
  UnsupportedWrapper1(void, glBindVertexArrayAPPLE, GLuint, array); \
  UnsupportedWrapper1(void, glBindVertexShaderEXT, GLuint, id); \
  UnsupportedWrapper4(void, glBindVideoCaptureStreamBufferNV, GLuint, video_capture_slot, GLuint, stream, GLenum, frame_region, GLintptrARB, offset); \
  UnsupportedWrapper5(void, glBindVideoCaptureStreamTextureNV, GLuint, video_capture_slot, GLuint, stream, GLenum, frame_region, GLenum, target, GLuint, texture); \
  UnsupportedWrapper3(void, glBinormal3bEXT, GLbyte, bx, GLbyte, by, GLbyte, bz); \
  UnsupportedWrapper1(void, glBinormal3bvEXT, const GLbyte *, v); \
  UnsupportedWrapper3(void, glBinormal3dEXT, GLdouble, bx, GLdouble, by, GLdouble, bz); \
  UnsupportedWrapper1(void, glBinormal3dvEXT, const GLdouble *, v); \
  UnsupportedWrapper3(void, glBinormal3fEXT, GLfloat, bx, GLfloat, by, GLfloat, bz); \
  UnsupportedWrapper1(void, glBinormal3fvEXT, const GLfloat *, v); \
  UnsupportedWrapper3(void, glBinormal3iEXT, GLint, bx, GLint, by, GLint, bz); \
  UnsupportedWrapper1(void, glBinormal3ivEXT, const GLint *, v); \
  UnsupportedWrapper3(void, glBinormal3sEXT, GLshort, bx, GLshort, by, GLshort, bz); \
  UnsupportedWrapper1(void, glBinormal3svEXT, const GLshort *, v); \
  UnsupportedWrapper3(void, glBinormalPointerEXT, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper7(void, glBitmap, GLsizei, width, GLsizei, height, GLfloat, xorig, GLfloat, yorig, GLfloat, xmove, GLfloat, ymove, const GLubyte *, bitmap); \
  UnsupportedWrapper7(void, glBitmapxOES, GLsizei, width, GLsizei, height, GLfixed, xorig, GLfixed, yorig, GLfixed, xmove, GLfixed, ymove, const GLubyte *, bitmap); \
  UnsupportedWrapper0(void, glBlendBarrierNV); \
  UnsupportedWrapper4(void, glBlendColorxOES, GLfixed, red, GLfixed, green, GLfixed, blue, GLfixed, alpha); \
  UnsupportedWrapper2(void, glBlendEquationIndexedAMD, GLuint, buf, GLenum, mode); \
  UnsupportedWrapper3(void, glBlendEquationSeparateIndexedAMD, GLuint, buf, GLenum, modeRGB, GLenum, modeAlpha); \
  UnsupportedWrapper3(void, glBlendFuncIndexedAMD, GLuint, buf, GLenum, src, GLenum, dst); \
  UnsupportedWrapper4(void, glBlendFuncSeparateEXT, GLenum, sfactorRGB, GLenum, dfactorRGB, GLenum, sfactorAlpha, GLenum, dfactorAlpha); \
  UnsupportedWrapper5(void, glBlendFuncSeparateIndexedAMD, GLuint, buf, GLenum, srcRGB, GLenum, dstRGB, GLenum, srcAlpha, GLenum, dstAlpha); \
  UnsupportedWrapper4(void, glBlendFuncSeparateINGR, GLenum, sfactorRGB, GLenum, dfactorRGB, GLenum, sfactorAlpha, GLenum, dfactorAlpha); \
  UnsupportedWrapper2(void, glBlendParameteriNV, GLenum, pname, GLint, value); \
  UnsupportedWrapper10(void, glBlitFramebufferANGLE, GLint, srcX0, GLint, srcY0, GLint, srcX1, GLint, srcY1, GLint, dstX0, GLint, dstY0, GLint, dstX1, GLint, dstY1, GLbitfield, mask, GLenum, filter); \
  UnsupportedWrapper10(void, glBlitFramebufferNV, GLint, srcX0, GLint, srcY0, GLint, srcX1, GLint, srcY1, GLint, dstX0, GLint, dstY0, GLint, dstX1, GLint, dstY1, GLbitfield, mask, GLenum, filter); \
  UnsupportedWrapper4(void, glBufferAddressRangeNV, GLenum, pname, GLuint, index, GLuint64EXT, address, GLsizeiptr, length); \
  UnsupportedWrapper4(void, glBufferPageCommitmentARB, GLenum, target, GLintptr, offset, GLsizeiptr, size, GLboolean, commit); \
  UnsupportedWrapper3(void, glBufferParameteriAPPLE, GLenum, target, GLenum, pname, GLint, param); \
  UnsupportedWrapper5(void, glBufferStorageExternalEXT, GLenum, target, GLintptr, offset, GLsizeiptr, size, GLeglClientBufferEXT, clientBuffer, GLbitfield, flags); \
  UnsupportedWrapper1(void, glCallCommandListNV, GLuint, list); \
  UnsupportedWrapper1(void, glCallList, GLuint, list); \
  UnsupportedWrapper3(void, glCallLists, GLsizei, n, GLenum, type, const void *, lists); \
  UnsupportedWrapper4(void, glClearAccum, GLfloat, red, GLfloat, green, GLfloat, blue, GLfloat, alpha); \
  UnsupportedWrapper4(void, glClearAccumxOES, GLfixed, red, GLfixed, green, GLfixed, blue, GLfixed, alpha); \
  UnsupportedWrapper4(void, glClearColorIiEXT, GLint, red, GLint, green, GLint, blue, GLint, alpha); \
  UnsupportedWrapper4(void, glClearColorIuiEXT, GLuint, red, GLuint, green, GLuint, blue, GLuint, alpha); \
  UnsupportedWrapper4(void, glClearColorxOES, GLfixed, red, GLfixed, green, GLfixed, blue, GLfixed, alpha); \
  UnsupportedWrapper1(void, glClearDepthdNV, GLdouble, depth); \
  UnsupportedWrapper1(void, glClearDepthfOES, GLclampf, depth); \
  UnsupportedWrapper1(void, glClearDepthxOES, GLfixed, depth); \
  UnsupportedWrapper1(void, glClearIndex, GLfloat, c); \
  UnsupportedWrapper3(void, glClearPixelLocalStorageuiEXT, GLsizei, offset, GLsizei, n, const GLuint *, values); \
  UnsupportedWrapper5(void, glClearTexImageEXT, GLuint, texture, GLint, level, GLenum, format, GLenum, type, const void *, data); \
  UnsupportedWrapper11(void, glClearTexSubImageEXT, GLuint, texture, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLenum, type, const void *, data); \
  UnsupportedWrapper1(void, glClientActiveTextureARB, GLenum, texture); \
  UnsupportedWrapper1(void, glClientActiveTexture, GLenum, texture); \
  UnsupportedWrapper1(void, glClientActiveVertexStreamATI, GLenum, stream); \
  UnsupportedWrapper1(void, glClientAttribDefaultEXT, GLbitfield, mask); \
  UnsupportedWrapper3(GLenum, glClientWaitSyncAPPLE, GLsync, sync, GLbitfield, flags, GLuint64, timeout); \
  UnsupportedWrapper2(void, glClipControlEXT, GLenum, origin, GLenum, depth); \
  UnsupportedWrapper2(void, glClipPlanefOES, GLenum, plane, const GLfloat *, equation); \
  UnsupportedWrapper2(void, glClipPlane, GLenum, plane, const GLdouble *, equation); \
  UnsupportedWrapper2(void, glClipPlanexOES, GLenum, plane, const GLfixed *, equation); \
  UnsupportedWrapper3(void, glColor3b, GLbyte, red, GLbyte, green, GLbyte, blue); \
  UnsupportedWrapper1(void, glColor3bv, const GLbyte *, v); \
  UnsupportedWrapper3(void, glColor3d, GLdouble, red, GLdouble, green, GLdouble, blue); \
  UnsupportedWrapper1(void, glColor3dv, const GLdouble *, v); \
  UnsupportedWrapper3(void, glColor3f, GLfloat, red, GLfloat, green, GLfloat, blue); \
  UnsupportedWrapper6(void, glColor3fVertex3fSUN, GLfloat, r, GLfloat, g, GLfloat, b, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper2(void, glColor3fVertex3fvSUN, const GLfloat *, c, const GLfloat *, v); \
  UnsupportedWrapper1(void, glColor3fv, const GLfloat *, v); \
  UnsupportedWrapper3(void, glColor3hNV, GLhalfNV, red, GLhalfNV, green, GLhalfNV, blue); \
  UnsupportedWrapper1(void, glColor3hvNV, const GLhalfNV *, v); \
  UnsupportedWrapper3(void, glColor3i, GLint, red, GLint, green, GLint, blue); \
  UnsupportedWrapper1(void, glColor3iv, const GLint *, v); \
  UnsupportedWrapper3(void, glColor3s, GLshort, red, GLshort, green, GLshort, blue); \
  UnsupportedWrapper1(void, glColor3sv, const GLshort *, v); \
  UnsupportedWrapper3(void, glColor3ub, GLubyte, red, GLubyte, green, GLubyte, blue); \
  UnsupportedWrapper1(void, glColor3ubv, const GLubyte *, v); \
  UnsupportedWrapper3(void, glColor3ui, GLuint, red, GLuint, green, GLuint, blue); \
  UnsupportedWrapper1(void, glColor3uiv, const GLuint *, v); \
  UnsupportedWrapper3(void, glColor3us, GLushort, red, GLushort, green, GLushort, blue); \
  UnsupportedWrapper1(void, glColor3usv, const GLushort *, v); \
  UnsupportedWrapper3(void, glColor3xOES, GLfixed, red, GLfixed, green, GLfixed, blue); \
  UnsupportedWrapper1(void, glColor3xvOES, const GLfixed *, components); \
  UnsupportedWrapper4(void, glColor4b, GLbyte, red, GLbyte, green, GLbyte, blue, GLbyte, alpha); \
  UnsupportedWrapper1(void, glColor4bv, const GLbyte *, v); \
  UnsupportedWrapper4(void, glColor4d, GLdouble, red, GLdouble, green, GLdouble, blue, GLdouble, alpha); \
  UnsupportedWrapper1(void, glColor4dv, const GLdouble *, v); \
  UnsupportedWrapper10(void, glColor4fNormal3fVertex3fSUN, GLfloat, r, GLfloat, g, GLfloat, b, GLfloat, a, GLfloat, nx, GLfloat, ny, GLfloat, nz, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper3(void, glColor4fNormal3fVertex3fvSUN, const GLfloat *, c, const GLfloat *, n, const GLfloat *, v); \
  UnsupportedWrapper4(void, glColor4f, GLfloat, red, GLfloat, green, GLfloat, blue, GLfloat, alpha); \
  UnsupportedWrapper1(void, glColor4fv, const GLfloat *, v); \
  UnsupportedWrapper4(void, glColor4hNV, GLhalfNV, red, GLhalfNV, green, GLhalfNV, blue, GLhalfNV, alpha); \
  UnsupportedWrapper1(void, glColor4hvNV, const GLhalfNV *, v); \
  UnsupportedWrapper4(void, glColor4i, GLint, red, GLint, green, GLint, blue, GLint, alpha); \
  UnsupportedWrapper1(void, glColor4iv, const GLint *, v); \
  UnsupportedWrapper4(void, glColor4s, GLshort, red, GLshort, green, GLshort, blue, GLshort, alpha); \
  UnsupportedWrapper1(void, glColor4sv, const GLshort *, v); \
  UnsupportedWrapper4(void, glColor4ub, GLubyte, red, GLubyte, green, GLubyte, blue, GLubyte, alpha); \
  UnsupportedWrapper6(void, glColor4ubVertex2fSUN, GLubyte, r, GLubyte, g, GLubyte, b, GLubyte, a, GLfloat, x, GLfloat, y); \
  UnsupportedWrapper2(void, glColor4ubVertex2fvSUN, const GLubyte *, c, const GLfloat *, v); \
  UnsupportedWrapper7(void, glColor4ubVertex3fSUN, GLubyte, r, GLubyte, g, GLubyte, b, GLubyte, a, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper2(void, glColor4ubVertex3fvSUN, const GLubyte *, c, const GLfloat *, v); \
  UnsupportedWrapper1(void, glColor4ubv, const GLubyte *, v); \
  UnsupportedWrapper4(void, glColor4ui, GLuint, red, GLuint, green, GLuint, blue, GLuint, alpha); \
  UnsupportedWrapper1(void, glColor4uiv, const GLuint *, v); \
  UnsupportedWrapper4(void, glColor4us, GLushort, red, GLushort, green, GLushort, blue, GLushort, alpha); \
  UnsupportedWrapper1(void, glColor4usv, const GLushort *, v); \
  UnsupportedWrapper4(void, glColor4xOES, GLfixed, red, GLfixed, green, GLfixed, blue, GLfixed, alpha); \
  UnsupportedWrapper1(void, glColor4xvOES, const GLfixed *, components); \
  UnsupportedWrapper3(void, glColorFormatNV, GLint, size, GLenum, type, GLsizei, stride); \
  UnsupportedWrapper7(void, glColorFragmentOp1ATI, GLenum, op, GLuint, dst, GLuint, dstMask, GLuint, dstMod, GLuint, arg1, GLuint, arg1Rep, GLuint, arg1Mod); \
  UnsupportedWrapper10(void, glColorFragmentOp2ATI, GLenum, op, GLuint, dst, GLuint, dstMask, GLuint, dstMod, GLuint, arg1, GLuint, arg1Rep, GLuint, arg1Mod, GLuint, arg2, GLuint, arg2Rep, GLuint, arg2Mod); \
  UnsupportedWrapper13(void, glColorFragmentOp3ATI, GLenum, op, GLuint, dst, GLuint, dstMask, GLuint, dstMod, GLuint, arg1, GLuint, arg1Rep, GLuint, arg1Mod, GLuint, arg2, GLuint, arg2Rep, GLuint, arg2Mod, GLuint, arg3, GLuint, arg3Rep, GLuint, arg3Mod); \
  UnsupportedWrapper2(void, glColorMaterial, GLenum, face, GLenum, mode); \
  UnsupportedWrapper2(void, glColorP3ui, GLenum, type, GLuint, color); \
  UnsupportedWrapper2(void, glColorP3uiv, GLenum, type, const GLuint *, color); \
  UnsupportedWrapper2(void, glColorP4ui, GLenum, type, GLuint, color); \
  UnsupportedWrapper2(void, glColorP4uiv, GLenum, type, const GLuint *, color); \
  UnsupportedWrapper5(void, glColorPointerEXT, GLint, size, GLenum, type, GLsizei, stride, GLsizei, count, const void *, pointer); \
  UnsupportedWrapper5(void, glColorPointerListIBM, GLint, size, GLenum, type, GLint, stride, const void **, pointer, GLint, ptrstride); \
  UnsupportedWrapper4(void, glColorPointer, GLint, size, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper3(void, glColorPointervINTEL, GLint, size, GLenum, type, const void **, pointer); \
  UnsupportedWrapper6(void, glColorSubTableEXT, GLenum, target, GLsizei, start, GLsizei, count, GLenum, format, GLenum, type, const void *, data); \
  UnsupportedWrapper6(void, glColorSubTable, GLenum, target, GLsizei, start, GLsizei, count, GLenum, format, GLenum, type, const void *, data); \
  UnsupportedWrapper6(void, glColorTableEXT, GLenum, target, GLenum, internalFormat, GLsizei, width, GLenum, format, GLenum, type, const void *, table); \
  UnsupportedWrapper3(void, glColorTableParameterfv, GLenum, target, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper3(void, glColorTableParameterfvSGI, GLenum, target, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper3(void, glColorTableParameteriv, GLenum, target, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper3(void, glColorTableParameterivSGI, GLenum, target, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper6(void, glColorTable, GLenum, target, GLenum, internalformat, GLsizei, width, GLenum, format, GLenum, type, const void *, table); \
  UnsupportedWrapper6(void, glColorTableSGI, GLenum, target, GLenum, internalformat, GLsizei, width, GLenum, format, GLenum, type, const void *, table); \
  UnsupportedWrapper6(void, glCombinerInputNV, GLenum, stage, GLenum, portion, GLenum, variable, GLenum, input, GLenum, mapping, GLenum, componentUsage); \
  UnsupportedWrapper10(void, glCombinerOutputNV, GLenum, stage, GLenum, portion, GLenum, abOutput, GLenum, cdOutput, GLenum, sumOutput, GLenum, scale, GLenum, bias, GLboolean, abDotProduct, GLboolean, cdDotProduct, GLboolean, muxSum); \
  UnsupportedWrapper2(void, glCombinerParameterfNV, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper2(void, glCombinerParameterfvNV, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper2(void, glCombinerParameteriNV, GLenum, pname, GLint, param); \
  UnsupportedWrapper2(void, glCombinerParameterivNV, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper3(void, glCombinerStageParameterfvNV, GLenum, stage, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper2(void, glCommandListSegmentsNV, GLuint, list, GLuint, segments); \
  UnsupportedWrapper1(void, glCompileCommandListNV, GLuint, list); \
  UnsupportedWrapper1(void, glCompileShaderARB, GLhandleARB, shaderObj); \
  UnsupportedWrapper2(void, glConservativeRasterParameterfNV, GLenum, pname, GLfloat, value); \
  UnsupportedWrapper2(void, glConservativeRasterParameteriNV, GLenum, pname, GLint, param); \
  UnsupportedWrapper6(void, glConvolutionFilter1DEXT, GLenum, target, GLenum, internalformat, GLsizei, width, GLenum, format, GLenum, type, const void *, image); \
  UnsupportedWrapper6(void, glConvolutionFilter1D, GLenum, target, GLenum, internalformat, GLsizei, width, GLenum, format, GLenum, type, const void *, image); \
  UnsupportedWrapper7(void, glConvolutionFilter2DEXT, GLenum, target, GLenum, internalformat, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, const void *, image); \
  UnsupportedWrapper7(void, glConvolutionFilter2D, GLenum, target, GLenum, internalformat, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, const void *, image); \
  UnsupportedWrapper3(void, glConvolutionParameterfEXT, GLenum, target, GLenum, pname, GLfloat, params); \
  UnsupportedWrapper3(void, glConvolutionParameterf, GLenum, target, GLenum, pname, GLfloat, params); \
  UnsupportedWrapper3(void, glConvolutionParameterfvEXT, GLenum, target, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper3(void, glConvolutionParameterfv, GLenum, target, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper3(void, glConvolutionParameteriEXT, GLenum, target, GLenum, pname, GLint, params); \
  UnsupportedWrapper3(void, glConvolutionParameteri, GLenum, target, GLenum, pname, GLint, params); \
  UnsupportedWrapper3(void, glConvolutionParameterivEXT, GLenum, target, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper3(void, glConvolutionParameteriv, GLenum, target, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper3(void, glConvolutionParameterxOES, GLenum, target, GLenum, pname, GLfixed, param); \
  UnsupportedWrapper3(void, glConvolutionParameterxvOES, GLenum, target, GLenum, pname, const GLfixed *, params); \
  UnsupportedWrapper5(void, glCopyBufferSubDataNV, GLenum, readTarget, GLenum, writeTarget, GLintptr, readOffset, GLintptr, writeOffset, GLsizeiptr, size); \
  UnsupportedWrapper5(void, glCopyColorSubTableEXT, GLenum, target, GLsizei, start, GLint, x, GLint, y, GLsizei, width); \
  UnsupportedWrapper5(void, glCopyColorSubTable, GLenum, target, GLsizei, start, GLint, x, GLint, y, GLsizei, width); \
  UnsupportedWrapper5(void, glCopyColorTable, GLenum, target, GLenum, internalformat, GLint, x, GLint, y, GLsizei, width); \
  UnsupportedWrapper5(void, glCopyColorTableSGI, GLenum, target, GLenum, internalformat, GLint, x, GLint, y, GLsizei, width); \
  UnsupportedWrapper5(void, glCopyConvolutionFilter1DEXT, GLenum, target, GLenum, internalformat, GLint, x, GLint, y, GLsizei, width); \
  UnsupportedWrapper5(void, glCopyConvolutionFilter1D, GLenum, target, GLenum, internalformat, GLint, x, GLint, y, GLsizei, width); \
  UnsupportedWrapper6(void, glCopyConvolutionFilter2DEXT, GLenum, target, GLenum, internalformat, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  UnsupportedWrapper6(void, glCopyConvolutionFilter2D, GLenum, target, GLenum, internalformat, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  UnsupportedWrapper15(void, glCopyImageSubDataNV, GLuint, srcName, GLenum, srcTarget, GLint, srcLevel, GLint, srcX, GLint, srcY, GLint, srcZ, GLuint, dstName, GLenum, dstTarget, GLint, dstLevel, GLint, dstX, GLint, dstY, GLint, dstZ, GLsizei, width, GLsizei, height, GLsizei, depth); \
  UnsupportedWrapper2(void, glCopyPathNV, GLuint, resultPath, GLuint, srcPath); \
  UnsupportedWrapper5(void, glCopyPixels, GLint, x, GLint, y, GLsizei, width, GLsizei, height, GLenum, type); \
  UnsupportedWrapper7(void, glCopyTexImage1DEXT, GLenum, target, GLint, level, GLenum, internalformat, GLint, x, GLint, y, GLsizei, width, GLint, border); \
  UnsupportedWrapper8(void, glCopyTexImage2DEXT, GLenum, target, GLint, level, GLenum, internalformat, GLint, x, GLint, y, GLsizei, width, GLsizei, height, GLint, border); \
  UnsupportedWrapper6(void, glCopyTexSubImage1DEXT, GLenum, target, GLint, level, GLint, xoffset, GLint, x, GLint, y, GLsizei, width); \
  UnsupportedWrapper8(void, glCopyTexSubImage2DEXT, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  UnsupportedWrapper9(void, glCopyTexSubImage3DEXT, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLint, x, GLint, y, GLsizei, width, GLsizei, height); \
  UnsupportedWrapper4(void, glCopyTextureLevelsAPPLE, GLuint, destinationTexture, GLuint, sourceTexture, GLint, sourceBaseLevel, GLsizei, sourceLevelCount); \
  UnsupportedWrapper1(void, glCoverageMaskNV, GLboolean, mask); \
  UnsupportedWrapper1(void, glCoverageModulationNV, GLenum, components); \
  UnsupportedWrapper2(void, glCoverageModulationTableNV, GLsizei, n, const GLfloat *, v); \
  UnsupportedWrapper1(void, glCoverageOperationNV, GLenum, operation); \
  UnsupportedWrapper7(void, glCoverFillPathInstancedNV, GLsizei, numPaths, GLenum, pathNameType, const void *, paths, GLuint, pathBase, GLenum, coverMode, GLenum, transformType, const GLfloat *, transformValues); \
  UnsupportedWrapper2(void, glCoverFillPathNV, GLuint, path, GLenum, coverMode); \
  UnsupportedWrapper7(void, glCoverStrokePathInstancedNV, GLsizei, numPaths, GLenum, pathNameType, const void *, paths, GLuint, pathBase, GLenum, coverMode, GLenum, transformType, const GLfloat *, transformValues); \
  UnsupportedWrapper2(void, glCoverStrokePathNV, GLuint, path, GLenum, coverMode); \
  UnsupportedWrapper2(void, glCreateCommandListsNV, GLsizei, n, GLuint *, lists); \
  UnsupportedWrapper0(GLhandleARB, glCreateProgramObjectARB); \
  UnsupportedWrapper1(GLhandleARB, glCreateShaderObjectARB, GLenum, shaderType); \
  UnsupportedWrapper2(GLuint, glCreateShaderProgramEXT, GLenum, type, const GLchar *, string); \
  UnsupportedWrapper2(void, glCreateStatesNV, GLsizei, n, GLuint *, states); \
  UnsupportedWrapper3(GLsync, glCreateSyncFromCLeventARB, struct _cl_context *, context, struct _cl_event *, event, GLbitfield, flags); \
  UnsupportedWrapper2(void, glCullParameterdvEXT, GLenum, pname, GLdouble *, params); \
  UnsupportedWrapper2(void, glCullParameterfvEXT, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper1(void, glCurrentPaletteMatrixARB, GLint, index); \
  UnsupportedWrapper2(void, glDebugMessageCallbackAMD, GLDEBUGPROCAMD, callback, void *, userParam); \
  UnsupportedWrapper5(void, glDebugMessageEnableAMD, GLenum, category, GLenum, severity, GLsizei, count, const GLuint *, ids, GLboolean, enabled); \
  UnsupportedWrapper5(void, glDebugMessageInsertAMD, GLenum, category, GLenum, severity, GLuint, id, GLsizei, length, const GLchar *, buf); \
  UnsupportedWrapper14(void, glDeformationMap3dSGIX, GLenum, target, GLdouble, u1, GLdouble, u2, GLint, ustride, GLint, uorder, GLdouble, v1, GLdouble, v2, GLint, vstride, GLint, vorder, GLdouble, w1, GLdouble, w2, GLint, wstride, GLint, worder, const GLdouble *, points); \
  UnsupportedWrapper14(void, glDeformationMap3fSGIX, GLenum, target, GLfloat, u1, GLfloat, u2, GLint, ustride, GLint, uorder, GLfloat, v1, GLfloat, v2, GLint, vstride, GLint, vorder, GLfloat, w1, GLfloat, w2, GLint, wstride, GLint, worder, const GLfloat *, points); \
  UnsupportedWrapper1(void, glDeformSGIX, GLbitfield, mask); \
  UnsupportedWrapper2(void, glDeleteAsyncMarkersSGIX, GLuint, marker, GLsizei, range); \
  UnsupportedWrapper2(void, glDeleteCommandListsNV, GLsizei, n, const GLuint *, lists); \
  UnsupportedWrapper2(void, glDeleteFencesAPPLE, GLsizei, n, const GLuint *, fences); \
  UnsupportedWrapper2(void, glDeleteFencesNV, GLsizei, n, const GLuint *, fences); \
  UnsupportedWrapper1(void, glDeleteFragmentShaderATI, GLuint, id); \
  UnsupportedWrapper2(void, glDeleteLists, GLuint, list, GLsizei, range); \
  UnsupportedWrapper3(void, glDeleteNamesAMD, GLenum, identifier, GLuint, num, const GLuint *, names); \
  UnsupportedWrapper1(void, glDeleteObjectARB, GLhandleARB, obj); \
  UnsupportedWrapper2(void, glDeleteOcclusionQueriesNV, GLsizei, n, const GLuint *, ids); \
  UnsupportedWrapper2(void, glDeletePathsNV, GLuint, path, GLsizei, range); \
  UnsupportedWrapper2(void, glDeletePerfMonitorsAMD, GLsizei, n, GLuint *, monitors); \
  UnsupportedWrapper2(void, glDeleteProgramsARB, GLsizei, n, const GLuint *, programs); \
  UnsupportedWrapper2(void, glDeleteProgramsNV, GLsizei, n, const GLuint *, programs); \
  UnsupportedWrapper2(void, glDeleteQueryResourceTagNV, GLsizei, n, const GLint *, tagIds); \
  UnsupportedWrapper2(void, glDeleteStatesNV, GLsizei, n, const GLuint *, states); \
  UnsupportedWrapper1(void, glDeleteSyncAPPLE, GLsync, sync); \
  UnsupportedWrapper2(void, glDeleteTexturesEXT, GLsizei, n, const GLuint *, textures); \
  UnsupportedWrapper2(void, glDeleteTransformFeedbacksNV, GLsizei, n, const GLuint *, ids); \
  UnsupportedWrapper2(void, glDeleteVertexArraysAPPLE, GLsizei, n, const GLuint *, arrays); \
  UnsupportedWrapper1(void, glDeleteVertexShaderEXT, GLuint, id); \
  UnsupportedWrapper2(void, glDepthBoundsdNV, GLdouble, zmin, GLdouble, zmax); \
  UnsupportedWrapper2(void, glDepthRangedNV, GLdouble, zNear, GLdouble, zFar); \
  UnsupportedWrapper2(void, glDepthRangefOES, GLclampf, n, GLclampf, f); \
  UnsupportedWrapper2(void, glDepthRangexOES, GLfixed, n, GLfixed, f); \
  UnsupportedWrapper2(void, glDetachObjectARB, GLhandleARB, containerObj, GLhandleARB, attachedObj); \
  UnsupportedWrapper3(void, glDetailTexFuncSGIS, GLenum, target, GLsizei, n, const GLfloat *, points); \
  UnsupportedWrapper2(void, glDisableClientStateiEXT, GLenum, array, GLuint, index); \
  UnsupportedWrapper2(void, glDisableClientStateIndexedEXT, GLenum, array, GLuint, index); \
  UnsupportedWrapper1(void, glDisableClientState, GLenum, array); \
  UnsupportedWrapper1(void, glDisableDriverControlQCOM, GLuint, driverControl); \
  UnsupportedWrapper1(void, glDisableVariantClientStateEXT, GLuint, id); \
  UnsupportedWrapper2(void, glDisableVertexArrayEXT, GLuint, vaobj, GLenum, array); \
  UnsupportedWrapper2(void, glDisableVertexAttribAPPLE, GLuint, index, GLenum, pname); \
  UnsupportedWrapper3(void, glDrawArraysEXT, GLenum, mode, GLint, first, GLsizei, count); \
  UnsupportedWrapper4(void, glDrawArraysInstancedANGLE, GLenum, mode, GLint, first, GLsizei, count, GLsizei, primcount); \
  UnsupportedWrapper4(void, glDrawArraysInstancedNV, GLenum, mode, GLint, first, GLsizei, count, GLsizei, primcount); \
  UnsupportedWrapper2(void, glDrawBuffersATI, GLsizei, n, const GLenum *, bufs); \
  UnsupportedWrapper3(void, glDrawBuffersIndexedEXT, GLint, n, const GLenum *, location, const GLint *, indices); \
  UnsupportedWrapper2(void, glDrawBuffersNV, GLsizei, n, const GLenum *, bufs); \
  UnsupportedWrapper4(void, glDrawCommandsAddressNV, GLenum, primitiveMode, const GLuint64 *, indirects, const GLsizei *, sizes, GLuint, count); \
  UnsupportedWrapper5(void, glDrawCommandsNV, GLenum, primitiveMode, GLuint, buffer, const GLintptr *, indirects, const GLsizei *, sizes, GLuint, count); \
  UnsupportedWrapper5(void, glDrawCommandsStatesAddressNV, const GLuint64 *, indirects, const GLsizei *, sizes, const GLuint *, states, const GLuint *, fbos, GLuint, count); \
  UnsupportedWrapper6(void, glDrawCommandsStatesNV, GLuint, buffer, const GLintptr *, indirects, const GLsizei *, sizes, const GLuint *, states, const GLuint *, fbos, GLuint, count); \
  UnsupportedWrapper3(void, glDrawElementArrayAPPLE, GLenum, mode, GLint, first, GLsizei, count); \
  UnsupportedWrapper2(void, glDrawElementArrayATI, GLenum, mode, GLsizei, count); \
  UnsupportedWrapper5(void, glDrawElementsInstancedANGLE, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLsizei, primcount); \
  UnsupportedWrapper5(void, glDrawElementsInstancedNV, GLenum, mode, GLsizei, count, GLenum, type, const void *, indices, GLsizei, primcount); \
  UnsupportedWrapper4(void, glDrawMeshArraysSUN, GLenum, mode, GLint, first, GLsizei, count, GLsizei, width); \
  UnsupportedWrapper5(void, glDrawPixels, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, const void *, pixels); \
  UnsupportedWrapper5(void, glDrawRangeElementArrayAPPLE, GLenum, mode, GLuint, start, GLuint, end, GLint, first, GLsizei, count); \
  UnsupportedWrapper4(void, glDrawRangeElementArrayATI, GLenum, mode, GLuint, start, GLuint, end, GLsizei, count); \
  UnsupportedWrapper11(void, glDrawTextureNV, GLuint, texture, GLuint, sampler, GLfloat, x0, GLfloat, y0, GLfloat, x1, GLfloat, y1, GLfloat, z, GLfloat, s0, GLfloat, t0, GLfloat, s1, GLfloat, t1); \
  UnsupportedWrapper2(void, glDrawTransformFeedbackEXT, GLenum, mode, GLuint, id); \
  UnsupportedWrapper3(void, glDrawTransformFeedbackInstancedEXT, GLenum, mode, GLuint, id, GLsizei, instancecount); \
  UnsupportedWrapper2(void, glDrawTransformFeedbackNV, GLenum, mode, GLuint, id); \
  UnsupportedWrapper11(void, glDrawVkImageNV, GLuint64, vkImage, GLuint, sampler, GLfloat, x0, GLfloat, y0, GLfloat, x1, GLfloat, y1, GLfloat, z, GLfloat, s0, GLfloat, t0, GLfloat, s1, GLfloat, t1); \
  UnsupportedWrapper1(void, glEdgeFlagFormatNV, GLsizei, stride); \
  UnsupportedWrapper3(void, glEdgeFlagPointerEXT, GLsizei, stride, GLsizei, count, const GLboolean *, pointer); \
  UnsupportedWrapper3(void, glEdgeFlagPointerListIBM, GLint, stride, const GLboolean **, pointer, GLint, ptrstride); \
  UnsupportedWrapper2(void, glEdgeFlagPointer, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper1(void, glEdgeFlag, GLboolean, flag); \
  UnsupportedWrapper1(void, glEdgeFlagv, const GLboolean *, flag); \
  UnsupportedWrapper2(void, glEGLImageTargetRenderbufferStorageOES, GLenum, target, GLeglImageOES, image); \
  UnsupportedWrapper3(void, glEGLImageTargetTexStorageEXT, GLenum, target, GLeglImageOES, image, const GLint*, attrib_list); \
  UnsupportedWrapper2(void, glEGLImageTargetTexture2DOES, GLenum, target, GLeglImageOES, image); \
  UnsupportedWrapper3(void, glEGLImageTargetTextureStorageEXT, GLuint, texture, GLeglImageOES, image, const GLint*, attrib_list); \
  UnsupportedWrapper2(void, glElementPointerAPPLE, GLenum, type, const void *, pointer); \
  UnsupportedWrapper2(void, glElementPointerATI, GLenum, type, const void *, pointer); \
  UnsupportedWrapper2(void, glEnableClientStateiEXT, GLenum, array, GLuint, index); \
  UnsupportedWrapper2(void, glEnableClientStateIndexedEXT, GLenum, array, GLuint, index); \
  UnsupportedWrapper1(void, glEnableClientState, GLenum, array); \
  UnsupportedWrapper1(void, glEnableDriverControlQCOM, GLuint, driverControl); \
  UnsupportedWrapper1(void, glEnableVariantClientStateEXT, GLuint, id); \
  UnsupportedWrapper2(void, glEnableVertexArrayEXT, GLuint, vaobj, GLenum, array); \
  UnsupportedWrapper2(void, glEnableVertexAttribAPPLE, GLuint, index, GLenum, pname); \
  UnsupportedWrapper0(void, glEndConditionalRenderNV); \
  UnsupportedWrapper0(void, glEndConditionalRenderNVX); \
  UnsupportedWrapper0(void, glEndFragmentShaderATI); \
  UnsupportedWrapper0(void, glEndList); \
  UnsupportedWrapper0(void, glEndOcclusionQueryNV); \
  UnsupportedWrapper1(void, glEndPerfMonitorAMD, GLuint, monitor); \
  UnsupportedWrapper0(void, glEnd); \
  UnsupportedWrapper1(void, glEndTilingQCOM, GLbitfield, preserveMask); \
  UnsupportedWrapper0(void, glEndTransformFeedbackNV); \
  UnsupportedWrapper0(void, glEndVertexShaderEXT); \
  UnsupportedWrapper1(void, glEndVideoCaptureNV, GLuint, video_capture_slot); \
  UnsupportedWrapper1(void, glEvalCoord1d, GLdouble, u); \
  UnsupportedWrapper1(void, glEvalCoord1dv, const GLdouble *, u); \
  UnsupportedWrapper1(void, glEvalCoord1f, GLfloat, u); \
  UnsupportedWrapper1(void, glEvalCoord1fv, const GLfloat *, u); \
  UnsupportedWrapper1(void, glEvalCoord1xOES, GLfixed, u); \
  UnsupportedWrapper1(void, glEvalCoord1xvOES, const GLfixed *, coords); \
  UnsupportedWrapper2(void, glEvalCoord2d, GLdouble, u, GLdouble, v); \
  UnsupportedWrapper1(void, glEvalCoord2dv, const GLdouble *, u); \
  UnsupportedWrapper2(void, glEvalCoord2f, GLfloat, u, GLfloat, v); \
  UnsupportedWrapper1(void, glEvalCoord2fv, const GLfloat *, u); \
  UnsupportedWrapper2(void, glEvalCoord2xOES, GLfixed, u, GLfixed, v); \
  UnsupportedWrapper1(void, glEvalCoord2xvOES, const GLfixed *, coords); \
  UnsupportedWrapper2(void, glEvalMapsNV, GLenum, target, GLenum, mode); \
  UnsupportedWrapper3(void, glEvalMesh1, GLenum, mode, GLint, i1, GLint, i2); \
  UnsupportedWrapper5(void, glEvalMesh2, GLenum, mode, GLint, i1, GLint, i2, GLint, j1, GLint, j2); \
  UnsupportedWrapper1(void, glEvalPoint1, GLint, i); \
  UnsupportedWrapper2(void, glEvalPoint2, GLint, i, GLint, j); \
  UnsupportedWrapper0(void, glEvaluateDepthValuesARB); \
  UnsupportedWrapper3(void, glExecuteProgramNV, GLenum, target, GLuint, id, const GLfloat *, params); \
  UnsupportedWrapper2(void, glExtGetBufferPointervQCOM, GLenum, target, void **, params); \
  UnsupportedWrapper3(void, glExtGetBuffersQCOM, GLuint *, buffers, GLint, maxBuffers, GLint *, numBuffers); \
  UnsupportedWrapper3(void, glExtGetFramebuffersQCOM, GLuint *, framebuffers, GLint, maxFramebuffers, GLint *, numFramebuffers); \
  UnsupportedWrapper4(void, glExtGetProgramBinarySourceQCOM, GLuint, program, GLenum, shadertype, GLchar *, source, GLint *, length); \
  UnsupportedWrapper3(void, glExtGetProgramsQCOM, GLuint *, programs, GLint, maxPrograms, GLint *, numPrograms); \
  UnsupportedWrapper3(void, glExtGetRenderbuffersQCOM, GLuint *, renderbuffers, GLint, maxRenderbuffers, GLint *, numRenderbuffers); \
  UnsupportedWrapper3(void, glExtGetShadersQCOM, GLuint *, shaders, GLint, maxShaders, GLint *, numShaders); \
  UnsupportedWrapper5(void, glExtGetTexLevelParameterivQCOM, GLuint, texture, GLenum, face, GLint, level, GLenum, pname, GLint *, params); \
  UnsupportedWrapper11(void, glExtGetTexSubImageQCOM, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLenum, type, void *, texels); \
  UnsupportedWrapper3(void, glExtGetTexturesQCOM, GLuint *, textures, GLint, maxTextures, GLint *, numTextures); \
  UnsupportedWrapper1(GLboolean, glExtIsProgramBinaryQCOM, GLuint, program); \
  UnsupportedWrapper3(void, glExtractComponentEXT, GLuint, res, GLuint, src, GLuint, num); \
  UnsupportedWrapper3(void, glExtTexObjectStateOverrideiQCOM, GLenum, target, GLenum, pname, GLint, param); \
  UnsupportedWrapper3(void, glFeedbackBuffer, GLsizei, size, GLenum, type, GLfloat *, buffer); \
  UnsupportedWrapper3(void, glFeedbackBufferxOES, GLsizei, n, GLenum, type, const GLfixed *, buffer); \
  UnsupportedWrapper2(GLsync, glFenceSyncAPPLE, GLenum, condition, GLbitfield, flags); \
  UnsupportedWrapper4(void, glFinalCombinerInputNV, GLenum, variable, GLenum, input, GLenum, mapping, GLenum, componentUsage); \
  UnsupportedWrapper1(GLint, glFinishAsyncSGIX, GLuint *, markerp); \
  UnsupportedWrapper1(void, glFinishFenceAPPLE, GLuint, fence); \
  UnsupportedWrapper1(void, glFinishFenceNV, GLuint, fence); \
  UnsupportedWrapper2(void, glFinishObjectAPPLE, GLenum, object, GLint, name); \
  UnsupportedWrapper0(void, glFinishTextureSUNX); \
  UnsupportedWrapper3(void, glFlushMappedBufferRangeAPPLE, GLenum, target, GLintptr, offset, GLsizeiptr, size); \
  UnsupportedWrapper1(void, glFlushPixelDataRangeNV, GLenum, target); \
  UnsupportedWrapper0(void, glFlushRasterSGIX); \
  UnsupportedWrapper1(void, glFlushStaticDataIBM, GLenum, target); \
  UnsupportedWrapper2(void, glFlushVertexArrayRangeAPPLE, GLsizei, length, void *, pointer); \
  UnsupportedWrapper0(void, glFlushVertexArrayRangeNV); \
  UnsupportedWrapper1(void, glFogCoorddEXT, GLdouble, coord); \
  UnsupportedWrapper1(void, glFogCoordd, GLdouble, coord); \
  UnsupportedWrapper1(void, glFogCoorddvEXT, const GLdouble *, coord); \
  UnsupportedWrapper1(void, glFogCoorddv, const GLdouble *, coord); \
  UnsupportedWrapper1(void, glFogCoordfEXT, GLfloat, coord); \
  UnsupportedWrapper2(void, glFogCoordFormatNV, GLenum, type, GLsizei, stride); \
  UnsupportedWrapper1(void, glFogCoordf, GLfloat, coord); \
  UnsupportedWrapper1(void, glFogCoordfvEXT, const GLfloat *, coord); \
  UnsupportedWrapper1(void, glFogCoordfv, const GLfloat *, coord); \
  UnsupportedWrapper1(void, glFogCoordhNV, GLhalfNV, fog); \
  UnsupportedWrapper1(void, glFogCoordhvNV, const GLhalfNV *, fog); \
  UnsupportedWrapper3(void, glFogCoordPointerEXT, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper4(void, glFogCoordPointerListIBM, GLenum, type, GLint, stride, const void **, pointer, GLint, ptrstride); \
  UnsupportedWrapper3(void, glFogCoordPointer, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper2(void, glFogf, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper2(void, glFogFuncSGIS, GLsizei, n, const GLfloat *, points); \
  UnsupportedWrapper2(void, glFogfv, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper2(void, glFogi, GLenum, pname, GLint, param); \
  UnsupportedWrapper2(void, glFogiv, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper2(void, glFogxOES, GLenum, pname, GLfixed, param); \
  UnsupportedWrapper2(void, glFogxvOES, GLenum, pname, const GLfixed *, param); \
  UnsupportedWrapper2(void, glFragmentColorMaterialSGIX, GLenum, face, GLenum, mode); \
  UnsupportedWrapper1(void, glFragmentCoverageColorNV, GLuint, color); \
  UnsupportedWrapper3(void, glFragmentLightfSGIX, GLenum, light, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper3(void, glFragmentLightfvSGIX, GLenum, light, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper3(void, glFragmentLightiSGIX, GLenum, light, GLenum, pname, GLint, param); \
  UnsupportedWrapper3(void, glFragmentLightivSGIX, GLenum, light, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper2(void, glFragmentLightModelfSGIX, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper2(void, glFragmentLightModelfvSGIX, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper2(void, glFragmentLightModeliSGIX, GLenum, pname, GLint, param); \
  UnsupportedWrapper2(void, glFragmentLightModelivSGIX, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper3(void, glFragmentMaterialfSGIX, GLenum, face, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper3(void, glFragmentMaterialfvSGIX, GLenum, face, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper3(void, glFragmentMaterialiSGIX, GLenum, face, GLenum, pname, GLint, param); \
  UnsupportedWrapper3(void, glFragmentMaterialivSGIX, GLenum, face, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper0(void, glFramebufferFetchBarrierEXT); \
  UnsupportedWrapper0(void, glFramebufferFetchBarrierQCOM); \
  UnsupportedWrapper5(void, glFramebufferFoveationConfigQCOM, GLuint, framebuffer, GLuint, numLayers, GLuint, focalPointsPerLayer, GLuint, requestedFeatures, GLuint *, providedFeatures); \
  UnsupportedWrapper8(void, glFramebufferFoveationParametersQCOM, GLuint, framebuffer, GLuint, layer, GLuint, focalPoint, GLfloat, focalX, GLfloat, focalY, GLfloat, gainX, GLfloat, gainY, GLfloat, foveaArea); \
  UnsupportedWrapper2(void, glFramebufferPixelLocalStorageSizeEXT, GLuint, target, GLsizei, size); \
  UnsupportedWrapper4(void, glFramebufferSampleLocationsfvARB, GLenum, target, GLuint, start, GLsizei, count, const GLfloat *, v); \
  UnsupportedWrapper4(void, glFramebufferSampleLocationsfvNV, GLenum, target, GLuint, start, GLsizei, count, const GLfloat *, v); \
  UnsupportedWrapper4(void, glFramebufferSamplePositionsfvAMD, GLenum, target, GLuint, numsamples, GLuint, pixelindex, const GLfloat *, values); \
  UnsupportedWrapper7(void, glFramebufferTexture2DDownsampleIMG, GLenum, target, GLenum, attachment, GLenum, textarget, GLuint, texture, GLint, level, GLint, xscale, GLint, yscale); \
  UnsupportedWrapper6(void, glFramebufferTexture2DMultisampleIMG, GLenum, target, GLenum, attachment, GLenum, textarget, GLuint, texture, GLint, level, GLsizei, samples); \
  UnsupportedWrapper5(void, glFramebufferTextureFaceARB, GLenum, target, GLenum, attachment, GLuint, texture, GLint, level, GLenum, face); \
  UnsupportedWrapper5(void, glFramebufferTextureFaceEXT, GLenum, target, GLenum, attachment, GLuint, texture, GLint, level, GLenum, face); \
  UnsupportedWrapper7(void, glFramebufferTextureLayerDownsampleIMG, GLenum, target, GLenum, attachment, GLuint, texture, GLint, level, GLint, layer, GLint, xscale, GLint, yscale); \
  UnsupportedWrapper1(void, glFrameZoomSGIX, GLint, factor); \
  UnsupportedWrapper1(void, glFreeObjectBufferATI, GLuint, buffer); \
  UnsupportedWrapper6(void, glFrustumfOES, GLfloat, l, GLfloat, r, GLfloat, b, GLfloat, t, GLfloat, n, GLfloat, f); \
  UnsupportedWrapper6(void, glFrustum, GLdouble, left, GLdouble, right, GLdouble, bottom, GLdouble, top, GLdouble, zNear, GLdouble, zFar); \
  UnsupportedWrapper6(void, glFrustumxOES, GLfixed, l, GLfixed, r, GLfixed, b, GLfixed, t, GLfixed, n, GLfixed, f); \
  UnsupportedWrapper1(GLuint, glGenAsyncMarkersSGIX, GLsizei, range); \
  UnsupportedWrapper2(void, glGenFencesAPPLE, GLsizei, n, GLuint *, fences); \
  UnsupportedWrapper2(void, glGenFencesNV, GLsizei, n, GLuint *, fences); \
  UnsupportedWrapper1(GLuint, glGenFragmentShadersATI, GLuint, range); \
  UnsupportedWrapper1(GLuint, glGenLists, GLsizei, range); \
  UnsupportedWrapper3(void, glGenNamesAMD, GLenum, identifier, GLuint, num, GLuint *, names); \
  UnsupportedWrapper2(void, glGenOcclusionQueriesNV, GLsizei, n, GLuint *, ids); \
  UnsupportedWrapper1(GLuint, glGenPathsNV, GLsizei, range); \
  UnsupportedWrapper2(void, glGenPerfMonitorsAMD, GLsizei, n, GLuint *, monitors); \
  UnsupportedWrapper2(void, glGenProgramsARB, GLsizei, n, GLuint *, programs); \
  UnsupportedWrapper2(void, glGenProgramsNV, GLsizei, n, GLuint *, programs); \
  UnsupportedWrapper2(void, glGenQueryResourceTagNV, GLsizei, n, GLint *, tagIds); \
  UnsupportedWrapper4(GLuint, glGenSymbolsEXT, GLenum, datatype, GLenum, storagetype, GLenum, range, GLuint, components); \
  UnsupportedWrapper2(void, glGenTexturesEXT, GLsizei, n, GLuint *, textures); \
  UnsupportedWrapper2(void, glGenTransformFeedbacksNV, GLsizei, n, GLuint *, ids); \
  UnsupportedWrapper2(void, glGenVertexArraysAPPLE, GLsizei, n, GLuint *, arrays); \
  UnsupportedWrapper1(GLuint, glGenVertexShadersEXT, GLuint, range); \
  UnsupportedWrapper7(void, glGetActiveAttribARB, GLhandleARB, programObj, GLuint, index, GLsizei, maxLength, GLsizei *, length, GLint *, size, GLenum *, type, GLcharARB *, name); \
  UnsupportedWrapper7(void, glGetActiveUniformARB, GLhandleARB, programObj, GLuint, index, GLsizei, maxLength, GLsizei *, length, GLint *, size, GLenum *, type, GLcharARB *, name); \
  UnsupportedWrapper7(void, glGetActiveVaryingNV, GLuint, program, GLuint, index, GLsizei, bufSize, GLsizei *, length, GLsizei *, size, GLenum *, type, GLchar *, name); \
  UnsupportedWrapper3(void, glGetArrayObjectfvATI, GLenum, array, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetArrayObjectivATI, GLenum, array, GLenum, pname, GLint *, params); \
  UnsupportedWrapper4(void, glGetAttachedObjectsARB, GLhandleARB, containerObj, GLsizei, maxCount, GLsizei *, count, GLhandleARB *, obj); \
  UnsupportedWrapper2(GLint, glGetAttribLocationARB, GLhandleARB, programObj, const GLcharARB *, name); \
  UnsupportedWrapper3(void, glGetBufferParameterui64vNV, GLenum, target, GLenum, pname, GLuint64EXT *, params); \
  UnsupportedWrapper2(void, glGetClipPlanefOES, GLenum, plane, GLfloat *, equation); \
  UnsupportedWrapper2(void, glGetClipPlane, GLenum, plane, GLdouble *, equation); \
  UnsupportedWrapper2(void, glGetClipPlanexOES, GLenum, plane, GLfixed *, equation); \
  UnsupportedWrapper4(void, glGetColorTableEXT, GLenum, target, GLenum, format, GLenum, type, void *, data); \
  UnsupportedWrapper3(void, glGetColorTableParameterfvEXT, GLenum, target, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetColorTableParameterfv, GLenum, target, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetColorTableParameterfvSGI, GLenum, target, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetColorTableParameterivEXT, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetColorTableParameteriv, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetColorTableParameterivSGI, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper4(void, glGetColorTable, GLenum, target, GLenum, format, GLenum, type, void *, table); \
  UnsupportedWrapper4(void, glGetColorTableSGI, GLenum, target, GLenum, format, GLenum, type, void *, table); \
  UnsupportedWrapper5(void, glGetCombinerInputParameterfvNV, GLenum, stage, GLenum, portion, GLenum, variable, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper5(void, glGetCombinerInputParameterivNV, GLenum, stage, GLenum, portion, GLenum, variable, GLenum, pname, GLint *, params); \
  UnsupportedWrapper4(void, glGetCombinerOutputParameterfvNV, GLenum, stage, GLenum, portion, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper4(void, glGetCombinerOutputParameterivNV, GLenum, stage, GLenum, portion, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetCombinerStageParameterfvNV, GLenum, stage, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper2(GLuint, glGetCommandHeaderNV, GLenum, tokenID, GLuint, size); \
  UnsupportedWrapper4(void, glGetConvolutionFilterEXT, GLenum, target, GLenum, format, GLenum, type, void *, image); \
  UnsupportedWrapper4(void, glGetConvolutionFilter, GLenum, target, GLenum, format, GLenum, type, void *, image); \
  UnsupportedWrapper3(void, glGetConvolutionParameterfvEXT, GLenum, target, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetConvolutionParameterfv, GLenum, target, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetConvolutionParameterivEXT, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetConvolutionParameteriv, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetConvolutionParameterxvOES, GLenum, target, GLenum, pname, GLfixed *, params); \
  UnsupportedWrapper2(void, glGetCoverageModulationTableNV, GLsizei, bufsize, GLfloat *, v); \
  UnsupportedWrapper7(GLuint, glGetDebugMessageLogAMD, GLuint, count, GLsizei, bufsize, GLenum *, categories, GLuint *, severities, GLuint *, ids, GLsizei *, lengths, GLchar *, message); \
  UnsupportedWrapper2(void, glGetDetailTexFuncSGIS, GLenum, target, GLfloat *, points); \
  UnsupportedWrapper3(void, glGetDriverControlsQCOM, GLint *, num, GLsizei, size, GLuint *, driverControls); \
  UnsupportedWrapper4(void, glGetDriverControlStringQCOM, GLuint, driverControl, GLsizei, bufSize, GLsizei *, length, GLchar *, driverControlString); \
  UnsupportedWrapper3(void, glGetFenceivNV, GLuint, fence, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetFinalCombinerInputParameterfvNV, GLenum, variable, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetFinalCombinerInputParameterivNV, GLenum, variable, GLenum, pname, GLint *, params); \
  UnsupportedWrapper2(void, glGetFixedvOES, GLenum, pname, GLfixed *, params); \
  UnsupportedWrapper1(void, glGetFogFuncSGIS, GLfloat *, points); \
  UnsupportedWrapper2(GLint, glGetFragDataIndexEXT, GLuint, program, const GLchar *, name); \
  UnsupportedWrapper3(void, glGetFragmentLightfvSGIX, GLenum, light, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetFragmentLightivSGIX, GLenum, light, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetFragmentMaterialfvSGIX, GLenum, face, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetFragmentMaterialivSGIX, GLenum, face, GLenum, pname, GLint *, params); \
  UnsupportedWrapper6(void, glGetFramebufferParameterfvAMD, GLenum, target, GLenum, pname, GLuint, numsamples, GLuint, pixelindex, GLsizei, size, GLfloat *, values); \
  UnsupportedWrapper1(GLsizei, glGetFramebufferPixelLocalStorageSizeEXT, GLuint, target); \
  UnsupportedWrapper0(GLenum, glGetGraphicsResetStatusKHR); \
  UnsupportedWrapper1(GLhandleARB, glGetHandleARB, GLenum, pname); \
  UnsupportedWrapper5(void, glGetHistogramEXT, GLenum, target, GLboolean, reset, GLenum, format, GLenum, type, void *, values); \
  UnsupportedWrapper3(void, glGetHistogramParameterfvEXT, GLenum, target, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetHistogramParameterfv, GLenum, target, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetHistogramParameterivEXT, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetHistogramParameteriv, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetHistogramParameterxvOES, GLenum, target, GLenum, pname, GLfixed *, params); \
  UnsupportedWrapper5(void, glGetHistogram, GLenum, target, GLboolean, reset, GLenum, format, GLenum, type, void *, values); \
  UnsupportedWrapper5(GLuint64, glGetImageHandleARB, GLuint, texture, GLint, level, GLboolean, layered, GLint, layer, GLenum, format); \
  UnsupportedWrapper5(GLuint64, glGetImageHandleNV, GLuint, texture, GLint, level, GLboolean, layered, GLint, layer, GLenum, format); \
  UnsupportedWrapper3(void, glGetImageTransformParameterfvHP, GLenum, target, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetImageTransformParameterivHP, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper4(void, glGetInfoLogARB, GLhandleARB, obj, GLsizei, maxLength, GLsizei *, length, GLcharARB *, infoLog); \
  UnsupportedWrapper0(GLint, glGetInstrumentsSGIX); \
  UnsupportedWrapper2(void, glGetInteger64vAPPLE, GLenum, pname, GLint64 *, params); \
  UnsupportedWrapper3(void, glGetIntegeri_vEXT, GLenum, target, GLuint, index, GLint *, data); \
  UnsupportedWrapper3(void, glGetIntegerui64i_vNV, GLenum, value, GLuint, index, GLuint64EXT *, result); \
  UnsupportedWrapper2(void, glGetIntegerui64vNV, GLenum, value, GLuint64EXT *, result); \
  UnsupportedWrapper6(void, glGetInternalformatSampleivNV, GLenum, target, GLenum, internalformat, GLsizei, samples, GLenum, pname, GLsizei, bufSize, GLint *, params); \
  UnsupportedWrapper3(void, glGetInvariantBooleanvEXT, GLuint, id, GLenum, value, GLboolean *, data); \
  UnsupportedWrapper3(void, glGetInvariantFloatvEXT, GLuint, id, GLenum, value, GLfloat *, data); \
  UnsupportedWrapper3(void, glGetInvariantIntegervEXT, GLuint, id, GLenum, value, GLint *, data); \
  UnsupportedWrapper3(void, glGetLightfv, GLenum, light, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetLightiv, GLenum, light, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetLightxOES, GLenum, light, GLenum, pname, GLfixed *, params); \
  UnsupportedWrapper3(void, glGetListParameterfvSGIX, GLuint, list, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetListParameterivSGIX, GLuint, list, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetLocalConstantBooleanvEXT, GLuint, id, GLenum, value, GLboolean *, data); \
  UnsupportedWrapper3(void, glGetLocalConstantFloatvEXT, GLuint, id, GLenum, value, GLfloat *, data); \
  UnsupportedWrapper3(void, glGetLocalConstantIntegervEXT, GLuint, id, GLenum, value, GLint *, data); \
  UnsupportedWrapper4(void, glGetMapAttribParameterfvNV, GLenum, target, GLuint, index, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper4(void, glGetMapAttribParameterivNV, GLenum, target, GLuint, index, GLenum, pname, GLint *, params); \
  UnsupportedWrapper7(void, glGetMapControlPointsNV, GLenum, target, GLuint, index, GLenum, type, GLsizei, ustride, GLsizei, vstride, GLboolean, packed, void *, points); \
  UnsupportedWrapper3(void, glGetMapdv, GLenum, target, GLenum, query, GLdouble *, v); \
  UnsupportedWrapper3(void, glGetMapfv, GLenum, target, GLenum, query, GLfloat *, v); \
  UnsupportedWrapper3(void, glGetMapiv, GLenum, target, GLenum, query, GLint *, v); \
  UnsupportedWrapper3(void, glGetMapParameterfvNV, GLenum, target, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetMapParameterivNV, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetMapxvOES, GLenum, target, GLenum, query, GLfixed *, v); \
  UnsupportedWrapper3(void, glGetMaterialfv, GLenum, face, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetMaterialiv, GLenum, face, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetMaterialxOES, GLenum, face, GLenum, pname, GLfixed, param); \
  UnsupportedWrapper5(void, glGetMinmaxEXT, GLenum, target, GLboolean, reset, GLenum, format, GLenum, type, void *, values); \
  UnsupportedWrapper3(void, glGetMinmaxParameterfvEXT, GLenum, target, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetMinmaxParameterfv, GLenum, target, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetMinmaxParameterivEXT, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetMinmaxParameteriv, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper5(void, glGetMinmax, GLenum, target, GLboolean, reset, GLenum, format, GLenum, type, void *, values); \
  UnsupportedWrapper3(void, glGetMultisamplefvNV, GLenum, pname, GLuint, index, GLfloat *, val); \
  UnsupportedWrapper4(void, glGetMultiTexEnvfvEXT, GLenum, texunit, GLenum, target, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper4(void, glGetMultiTexEnvivEXT, GLenum, texunit, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper4(void, glGetMultiTexGendvEXT, GLenum, texunit, GLenum, coord, GLenum, pname, GLdouble *, params); \
  UnsupportedWrapper4(void, glGetMultiTexGenfvEXT, GLenum, texunit, GLenum, coord, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper4(void, glGetMultiTexGenivEXT, GLenum, texunit, GLenum, coord, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetNamedBufferParameterui64vNV, GLuint, buffer, GLenum, pname, GLuint64EXT *, params); \
  UnsupportedWrapper6(void, glGetNamedFramebufferParameterfvAMD, GLuint, framebuffer, GLenum, pname, GLuint, numsamples, GLuint, pixelindex, GLsizei, size, GLfloat *, values); \
  UnsupportedWrapper4(void, glGetNamedProgramLocalParameterdvEXT, GLuint, program, GLenum, target, GLuint, index, GLdouble *, params); \
  UnsupportedWrapper4(void, glGetNamedProgramLocalParameterfvEXT, GLuint, program, GLenum, target, GLuint, index, GLfloat *, params); \
  UnsupportedWrapper4(void, glGetNamedProgramLocalParameterIivEXT, GLuint, program, GLenum, target, GLuint, index, GLint *, params); \
  UnsupportedWrapper4(void, glGetNamedProgramLocalParameterIuivEXT, GLuint, program, GLenum, target, GLuint, index, GLuint *, params); \
  UnsupportedWrapper4(void, glGetNamedProgramStringEXT, GLuint, program, GLenum, target, GLenum, pname, void *, string); \
  UnsupportedWrapper5(void, glGetnColorTableARB, GLenum, target, GLenum, format, GLenum, type, GLsizei, bufSize, void *, table); \
  UnsupportedWrapper5(void, glGetnColorTable, GLenum, target, GLenum, format, GLenum, type, GLsizei, bufSize, void *, table); \
  UnsupportedWrapper5(void, glGetnConvolutionFilterARB, GLenum, target, GLenum, format, GLenum, type, GLsizei, bufSize, void *, image); \
  UnsupportedWrapper5(void, glGetnConvolutionFilter, GLenum, target, GLenum, format, GLenum, type, GLsizei, bufSize, void *, image); \
  UnsupportedWrapper6(void, glGetnHistogramARB, GLenum, target, GLboolean, reset, GLenum, format, GLenum, type, GLsizei, bufSize, void *, values); \
  UnsupportedWrapper6(void, glGetnHistogram, GLenum, target, GLboolean, reset, GLenum, format, GLenum, type, GLsizei, bufSize, void *, values); \
  UnsupportedWrapper4(void, glGetnMapdvARB, GLenum, target, GLenum, query, GLsizei, bufSize, GLdouble *, v); \
  UnsupportedWrapper4(void, glGetnMapdv, GLenum, target, GLenum, query, GLsizei, bufSize, GLdouble *, v); \
  UnsupportedWrapper4(void, glGetnMapfvARB, GLenum, target, GLenum, query, GLsizei, bufSize, GLfloat *, v); \
  UnsupportedWrapper4(void, glGetnMapfv, GLenum, target, GLenum, query, GLsizei, bufSize, GLfloat *, v); \
  UnsupportedWrapper4(void, glGetnMapivARB, GLenum, target, GLenum, query, GLsizei, bufSize, GLint *, v); \
  UnsupportedWrapper4(void, glGetnMapiv, GLenum, target, GLenum, query, GLsizei, bufSize, GLint *, v); \
  UnsupportedWrapper6(void, glGetnMinmaxARB, GLenum, target, GLboolean, reset, GLenum, format, GLenum, type, GLsizei, bufSize, void *, values); \
  UnsupportedWrapper6(void, glGetnMinmax, GLenum, target, GLboolean, reset, GLenum, format, GLenum, type, GLsizei, bufSize, void *, values); \
  UnsupportedWrapper3(void, glGetnPixelMapfvARB, GLenum, map, GLsizei, bufSize, GLfloat *, values); \
  UnsupportedWrapper3(void, glGetnPixelMapfv, GLenum, map, GLsizei, bufSize, GLfloat *, values); \
  UnsupportedWrapper3(void, glGetnPixelMapuivARB, GLenum, map, GLsizei, bufSize, GLuint *, values); \
  UnsupportedWrapper3(void, glGetnPixelMapuiv, GLenum, map, GLsizei, bufSize, GLuint *, values); \
  UnsupportedWrapper3(void, glGetnPixelMapusvARB, GLenum, map, GLsizei, bufSize, GLushort *, values); \
  UnsupportedWrapper3(void, glGetnPixelMapusv, GLenum, map, GLsizei, bufSize, GLushort *, values); \
  UnsupportedWrapper2(void, glGetnPolygonStippleARB, GLsizei, bufSize, GLubyte *, pattern); \
  UnsupportedWrapper2(void, glGetnPolygonStipple, GLsizei, bufSize, GLubyte *, pattern); \
  UnsupportedWrapper8(void, glGetnSeparableFilterARB, GLenum, target, GLenum, format, GLenum, type, GLsizei, rowBufSize, void *, row, GLsizei, columnBufSize, void *, column, void *, span); \
  UnsupportedWrapper8(void, glGetnSeparableFilter, GLenum, target, GLenum, format, GLenum, type, GLsizei, rowBufSize, void *, row, GLsizei, columnBufSize, void *, column, void *, span); \
  UnsupportedWrapper4(void, glGetnUniformfvKHR, GLuint, program, GLint, location, GLsizei, bufSize, GLfloat *, params); \
  UnsupportedWrapper4(void, glGetnUniformi64vARB, GLuint, program, GLint, location, GLsizei, bufSize, GLint64 *, params); \
  UnsupportedWrapper4(void, glGetnUniformivKHR, GLuint, program, GLint, location, GLsizei, bufSize, GLint *, params); \
  UnsupportedWrapper4(void, glGetnUniformui64vARB, GLuint, program, GLint, location, GLsizei, bufSize, GLuint64 *, params); \
  UnsupportedWrapper4(void, glGetnUniformuivKHR, GLuint, program, GLint, location, GLsizei, bufSize, GLuint *, params); \
  UnsupportedWrapper3(void, glGetObjectBufferfvATI, GLuint, buffer, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetObjectBufferivATI, GLuint, buffer, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetObjectParameterfvARB, GLhandleARB, obj, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper4(void, glGetObjectParameterivAPPLE, GLenum, objectType, GLuint, name, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetObjectParameterivARB, GLhandleARB, obj, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetOcclusionQueryivNV, GLuint, id, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetOcclusionQueryuivNV, GLuint, id, GLenum, pname, GLuint *, params); \
  UnsupportedWrapper3(void, glGetPathColorGenfvNV, GLenum, color, GLenum, pname, GLfloat *, value); \
  UnsupportedWrapper3(void, glGetPathColorGenivNV, GLenum, color, GLenum, pname, GLint *, value); \
  UnsupportedWrapper2(void, glGetPathCommandsNV, GLuint, path, GLubyte *, commands); \
  UnsupportedWrapper2(void, glGetPathCoordsNV, GLuint, path, GLfloat *, coords); \
  UnsupportedWrapper2(void, glGetPathDashArrayNV, GLuint, path, GLfloat *, dashArray); \
  UnsupportedWrapper3(GLfloat, glGetPathLengthNV, GLuint, path, GLsizei, startSegment, GLsizei, numSegments); \
  UnsupportedWrapper5(void, glGetPathMetricRangeNV, GLbitfield, metricQueryMask, GLuint, firstPathName, GLsizei, numPaths, GLsizei, stride, GLfloat *, metrics); \
  UnsupportedWrapper7(void, glGetPathMetricsNV, GLbitfield, metricQueryMask, GLsizei, numPaths, GLenum, pathNameType, const void *, paths, GLuint, pathBase, GLsizei, stride, GLfloat *, metrics); \
  UnsupportedWrapper3(void, glGetPathParameterfvNV, GLuint, path, GLenum, pname, GLfloat *, value); \
  UnsupportedWrapper3(void, glGetPathParameterivNV, GLuint, path, GLenum, pname, GLint *, value); \
  UnsupportedWrapper9(void, glGetPathSpacingNV, GLenum, pathListMode, GLsizei, numPaths, GLenum, pathNameType, const void *, paths, GLuint, pathBase, GLfloat, advanceScale, GLfloat, kerningScale, GLenum, transformType, GLfloat *, returnedSpacing); \
  UnsupportedWrapper3(void, glGetPathTexGenfvNV, GLenum, texCoordSet, GLenum, pname, GLfloat *, value); \
  UnsupportedWrapper3(void, glGetPathTexGenivNV, GLenum, texCoordSet, GLenum, pname, GLint *, value); \
  UnsupportedWrapper5(void, glGetPerfMonitorCounterDataAMD, GLuint, monitor, GLenum, pname, GLsizei, dataSize, GLuint *, data, GLint *, bytesWritten); \
  UnsupportedWrapper4(void, glGetPerfMonitorCounterInfoAMD, GLuint, group, GLuint, counter, GLenum, pname, void *, data); \
  UnsupportedWrapper5(void, glGetPerfMonitorCountersAMD, GLuint, group, GLint *, numCounters, GLint *, maxActiveCounters, GLsizei, counterSize, GLuint *, counters); \
  UnsupportedWrapper5(void, glGetPerfMonitorCounterStringAMD, GLuint, group, GLuint, counter, GLsizei, bufSize, GLsizei *, length, GLchar *, counterString); \
  UnsupportedWrapper3(void, glGetPerfMonitorGroupsAMD, GLint *, numGroups, GLsizei, groupsSize, GLuint *, groups); \
  UnsupportedWrapper4(void, glGetPerfMonitorGroupStringAMD, GLuint, group, GLsizei, bufSize, GLsizei *, length, GLchar *, groupString); \
  UnsupportedWrapper2(void, glGetPixelMapfv, GLenum, map, GLfloat *, values); \
  UnsupportedWrapper2(void, glGetPixelMapuiv, GLenum, map, GLuint *, values); \
  UnsupportedWrapper2(void, glGetPixelMapusv, GLenum, map, GLushort *, values); \
  UnsupportedWrapper3(void, glGetPixelMapxv, GLenum, map, GLint, size, GLfixed *, values); \
  UnsupportedWrapper2(void, glGetPixelTexGenParameterfvSGIS, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper2(void, glGetPixelTexGenParameterivSGIS, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetPixelTransformParameterfvEXT, GLenum, target, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetPixelTransformParameterivEXT, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper2(void, glGetPointervEXT, GLenum, pname, void **, params); \
  UnsupportedWrapper1(void, glGetPolygonStipple, GLubyte *, mask); \
  UnsupportedWrapper5(void, glGetProgramBinaryOES, GLuint, program, GLsizei, bufSize, GLsizei *, length, GLenum *, binaryFormat, void *, binary); \
  UnsupportedWrapper3(void, glGetProgramEnvParameterdvARB, GLenum, target, GLuint, index, GLdouble *, params); \
  UnsupportedWrapper3(void, glGetProgramEnvParameterfvARB, GLenum, target, GLuint, index, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetProgramEnvParameterIivNV, GLenum, target, GLuint, index, GLint *, params); \
  UnsupportedWrapper3(void, glGetProgramEnvParameterIuivNV, GLenum, target, GLuint, index, GLuint *, params); \
  UnsupportedWrapper3(void, glGetProgramivARB, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetProgramivNV, GLuint, id, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetProgramLocalParameterdvARB, GLenum, target, GLuint, index, GLdouble *, params); \
  UnsupportedWrapper3(void, glGetProgramLocalParameterfvARB, GLenum, target, GLuint, index, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetProgramLocalParameterIivNV, GLenum, target, GLuint, index, GLint *, params); \
  UnsupportedWrapper3(void, glGetProgramLocalParameterIuivNV, GLenum, target, GLuint, index, GLuint *, params); \
  UnsupportedWrapper4(void, glGetProgramNamedParameterdvNV, GLuint, id, GLsizei, len, const GLubyte *, name, GLdouble *, params); \
  UnsupportedWrapper4(void, glGetProgramNamedParameterfvNV, GLuint, id, GLsizei, len, const GLubyte *, name, GLfloat *, params); \
  UnsupportedWrapper4(void, glGetProgramParameterdvNV, GLenum, target, GLuint, index, GLenum, pname, GLdouble *, params); \
  UnsupportedWrapper4(void, glGetProgramParameterfvNV, GLenum, target, GLuint, index, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper8(void, glGetProgramResourcefvNV, GLuint, program, GLenum, programInterface, GLuint, index, GLsizei, propCount, const GLenum *, props, GLsizei, bufSize, GLsizei *, length, GLfloat *, params); \
  UnsupportedWrapper3(GLint, glGetProgramResourceLocationIndexEXT, GLuint, program, GLenum, programInterface, const GLchar *, name); \
  UnsupportedWrapper3(void, glGetProgramStringARB, GLenum, target, GLenum, pname, void *, string); \
  UnsupportedWrapper3(void, glGetProgramStringNV, GLuint, id, GLenum, pname, GLubyte *, program); \
  UnsupportedWrapper3(void, glGetProgramSubroutineParameteruivNV, GLenum, target, GLuint, index, GLuint *, param); \
  UnsupportedWrapper6(void, glGetSeparableFilterEXT, GLenum, target, GLenum, format, GLenum, type, void *, row, void *, column, void *, span); \
  UnsupportedWrapper6(void, glGetSeparableFilter, GLenum, target, GLenum, format, GLenum, type, void *, row, void *, column, void *, span); \
  UnsupportedWrapper4(void, glGetShaderSourceARB, GLhandleARB, obj, GLsizei, maxLength, GLsizei *, length, GLcharARB *, source); \
  UnsupportedWrapper2(void, glGetSharpenTexFuncSGIS, GLenum, target, GLfloat *, points); \
  UnsupportedWrapper1(GLushort, glGetStageIndexNV, GLenum, shadertype); \
  UnsupportedWrapper5(void, glGetSyncivAPPLE, GLsync, sync, GLenum, pname, GLsizei, bufSize, GLsizei *, length, GLint *, values); \
  UnsupportedWrapper2(void, glGetTexBumpParameterfvATI, GLenum, pname, GLfloat *, param); \
  UnsupportedWrapper2(void, glGetTexBumpParameterivATI, GLenum, pname, GLint *, param); \
  UnsupportedWrapper3(void, glGetTexEnvfv, GLenum, target, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetTexEnviv, GLenum, target, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetTexEnvxvOES, GLenum, target, GLenum, pname, GLfixed *, params); \
  UnsupportedWrapper3(void, glGetTexFilterFuncSGIS, GLenum, target, GLenum, filter, GLfloat *, weights); \
  UnsupportedWrapper3(void, glGetTexGendv, GLenum, coord, GLenum, pname, GLdouble *, params); \
  UnsupportedWrapper3(void, glGetTexGenfv, GLenum, coord, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetTexGeniv, GLenum, coord, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetTexGenxvOES, GLenum, coord, GLenum, pname, GLfixed *, params); \
  UnsupportedWrapper4(void, glGetTexLevelParameterxvOES, GLenum, target, GLint, level, GLenum, pname, GLfixed *, params); \
  UnsupportedWrapper3(void, glGetTexParameterPointervAPPLE, GLenum, target, GLenum, pname, void **, params); \
  UnsupportedWrapper3(void, glGetTexParameterxvOES, GLenum, target, GLenum, pname, GLfixed *, params); \
  UnsupportedWrapper1(GLuint64, glGetTextureHandleARB, GLuint, texture); \
  UnsupportedWrapper1(GLuint64, glGetTextureHandleIMG, GLuint, texture); \
  UnsupportedWrapper1(GLuint64, glGetTextureHandleNV, GLuint, texture); \
  UnsupportedWrapper2(GLuint64, glGetTextureSamplerHandleARB, GLuint, texture, GLuint, sampler); \
  UnsupportedWrapper2(GLuint64, glGetTextureSamplerHandleIMG, GLuint, texture, GLuint, sampler); \
  UnsupportedWrapper2(GLuint64, glGetTextureSamplerHandleNV, GLuint, texture, GLuint, sampler); \
  UnsupportedWrapper4(void, glGetTrackMatrixivNV, GLenum, target, GLuint, address, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetTransformFeedbackVaryingNV, GLuint, program, GLuint, index, GLint *, location); \
  UnsupportedWrapper4(void, glGetTranslatedShaderSourceANGLE, GLuint, shader, GLsizei, bufsize, GLsizei *, length, GLchar *, source); \
  UnsupportedWrapper2(GLint, glGetUniformBufferSizeEXT, GLuint, program, GLint, location); \
  UnsupportedWrapper3(void, glGetUniformfvARB, GLhandleARB, programObj, GLint, location, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetUniformi64vARB, GLuint, program, GLint, location, GLint64 *, params); \
  UnsupportedWrapper3(void, glGetUniformi64vNV, GLuint, program, GLint, location, GLint64EXT *, params); \
  UnsupportedWrapper3(void, glGetUniformivARB, GLhandleARB, programObj, GLint, location, GLint *, params); \
  UnsupportedWrapper2(GLint, glGetUniformLocationARB, GLhandleARB, programObj, const GLcharARB *, name); \
  UnsupportedWrapper2(GLintptr, glGetUniformOffsetEXT, GLuint, program, GLint, location); \
  UnsupportedWrapper3(void, glGetUniformui64vARB, GLuint, program, GLint, location, GLuint64 *, params); \
  UnsupportedWrapper3(void, glGetUniformui64vNV, GLuint, program, GLint, location, GLuint64EXT *, params); \
  UnsupportedWrapper3(void, glGetVariantArrayObjectfvATI, GLuint, id, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetVariantArrayObjectivATI, GLuint, id, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetVariantBooleanvEXT, GLuint, id, GLenum, value, GLboolean *, data); \
  UnsupportedWrapper3(void, glGetVariantFloatvEXT, GLuint, id, GLenum, value, GLfloat *, data); \
  UnsupportedWrapper3(void, glGetVariantIntegervEXT, GLuint, id, GLenum, value, GLint *, data); \
  UnsupportedWrapper3(void, glGetVariantPointervEXT, GLuint, id, GLenum, value, void **, data); \
  UnsupportedWrapper2(GLint, glGetVaryingLocationNV, GLuint, program, const GLchar *, name); \
  UnsupportedWrapper3(void, glGetVertexAttribArrayObjectfvATI, GLuint, index, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetVertexAttribArrayObjectivATI, GLuint, index, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetVertexAttribdvARB, GLuint, index, GLenum, pname, GLdouble *, params); \
  UnsupportedWrapper3(void, glGetVertexAttribdvNV, GLuint, index, GLenum, pname, GLdouble *, params); \
  UnsupportedWrapper3(void, glGetVertexAttribfvARB, GLuint, index, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetVertexAttribfvNV, GLuint, index, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper3(void, glGetVertexAttribivARB, GLuint, index, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetVertexAttribivNV, GLuint, index, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetVertexAttribLi64vNV, GLuint, index, GLenum, pname, GLint64EXT *, params); \
  UnsupportedWrapper3(void, glGetVertexAttribLui64vARB, GLuint, index, GLenum, pname, GLuint64EXT *, params); \
  UnsupportedWrapper3(void, glGetVertexAttribLui64vNV, GLuint, index, GLenum, pname, GLuint64EXT *, params); \
  UnsupportedWrapper3(void, glGetVertexAttribPointervARB, GLuint, index, GLenum, pname, void **, pointer); \
  UnsupportedWrapper3(void, glGetVertexAttribPointervNV, GLuint, index, GLenum, pname, void **, pointer); \
  UnsupportedWrapper3(void, glGetVideoCaptureivNV, GLuint, video_capture_slot, GLenum, pname, GLint *, params); \
  UnsupportedWrapper4(void, glGetVideoCaptureStreamdvNV, GLuint, video_capture_slot, GLuint, stream, GLenum, pname, GLdouble *, params); \
  UnsupportedWrapper4(void, glGetVideoCaptureStreamfvNV, GLuint, video_capture_slot, GLuint, stream, GLenum, pname, GLfloat *, params); \
  UnsupportedWrapper4(void, glGetVideoCaptureStreamivNV, GLuint, video_capture_slot, GLuint, stream, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetVideoi64vNV, GLuint, video_slot, GLenum, pname, GLint64EXT *, params); \
  UnsupportedWrapper3(void, glGetVideoivNV, GLuint, video_slot, GLenum, pname, GLint *, params); \
  UnsupportedWrapper3(void, glGetVideoui64vNV, GLuint, video_slot, GLenum, pname, GLuint64EXT *, params); \
  UnsupportedWrapper3(void, glGetVideouivNV, GLuint, video_slot, GLenum, pname, GLuint *, params); \
  UnsupportedWrapper1(GLVULKANPROCNV, glGetVkProcAddrNV, const GLchar *, name); \
  UnsupportedWrapper1(void, glGlobalAlphaFactorbSUN, GLbyte, factor); \
  UnsupportedWrapper1(void, glGlobalAlphaFactordSUN, GLdouble, factor); \
  UnsupportedWrapper1(void, glGlobalAlphaFactorfSUN, GLfloat, factor); \
  UnsupportedWrapper1(void, glGlobalAlphaFactoriSUN, GLint, factor); \
  UnsupportedWrapper1(void, glGlobalAlphaFactorsSUN, GLshort, factor); \
  UnsupportedWrapper1(void, glGlobalAlphaFactorubSUN, GLubyte, factor); \
  UnsupportedWrapper1(void, glGlobalAlphaFactoruiSUN, GLuint, factor); \
  UnsupportedWrapper1(void, glGlobalAlphaFactorusSUN, GLushort, factor); \
  UnsupportedWrapper2(void, glHintPGI, GLenum, target, GLint, mode); \
  UnsupportedWrapper4(void, glHistogramEXT, GLenum, target, GLsizei, width, GLenum, internalformat, GLboolean, sink); \
  UnsupportedWrapper4(void, glHistogram, GLenum, target, GLsizei, width, GLenum, internalformat, GLboolean, sink); \
  UnsupportedWrapper2(void, glIglooInterfaceSGIX, GLenum, pname, const void *, params); \
  UnsupportedWrapper3(void, glImageTransformParameterfHP, GLenum, target, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper3(void, glImageTransformParameterfvHP, GLenum, target, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper3(void, glImageTransformParameteriHP, GLenum, target, GLenum, pname, GLint, param); \
  UnsupportedWrapper3(void, glImageTransformParameterivHP, GLenum, target, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper3(GLsync, glImportSyncEXT, GLenum, external_sync_type, GLintptr, external_sync, GLbitfield, flags); \
  UnsupportedWrapper1(void, glIndexd, GLdouble, c); \
  UnsupportedWrapper1(void, glIndexdv, const GLdouble *, c); \
  UnsupportedWrapper2(void, glIndexFormatNV, GLenum, type, GLsizei, stride); \
  UnsupportedWrapper1(void, glIndexf, GLfloat, c); \
  UnsupportedWrapper2(void, glIndexFuncEXT, GLenum, func, GLclampf, ref); \
  UnsupportedWrapper1(void, glIndexfv, const GLfloat *, c); \
  UnsupportedWrapper1(void, glIndexi, GLint, c); \
  UnsupportedWrapper1(void, glIndexiv, const GLint *, c); \
  UnsupportedWrapper1(void, glIndexMask, GLuint, mask); \
  UnsupportedWrapper2(void, glIndexMaterialEXT, GLenum, face, GLenum, mode); \
  UnsupportedWrapper4(void, glIndexPointerEXT, GLenum, type, GLsizei, stride, GLsizei, count, const void *, pointer); \
  UnsupportedWrapper4(void, glIndexPointerListIBM, GLenum, type, GLint, stride, const void **, pointer, GLint, ptrstride); \
  UnsupportedWrapper3(void, glIndexPointer, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper1(void, glIndexs, GLshort, c); \
  UnsupportedWrapper1(void, glIndexsv, const GLshort *, c); \
  UnsupportedWrapper1(void, glIndexub, GLubyte, c); \
  UnsupportedWrapper1(void, glIndexubv, const GLubyte *, c); \
  UnsupportedWrapper1(void, glIndexxOES, GLfixed, component); \
  UnsupportedWrapper1(void, glIndexxvOES, const GLfixed *, component); \
  UnsupportedWrapper0(void, glInitNames); \
  UnsupportedWrapper3(void, glInsertComponentEXT, GLuint, res, GLuint, src, GLuint, num); \
  UnsupportedWrapper2(void, glInstrumentsBufferSGIX, GLsizei, size, GLint *, buffer); \
  UnsupportedWrapper3(void, glInterleavedArrays, GLenum, format, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper4(void, glInterpolatePathsNV, GLuint, resultPath, GLuint, pathA, GLuint, pathB, GLfloat, weight); \
  UnsupportedWrapper1(GLboolean, glIsAsyncMarkerSGIX, GLuint, marker); \
  UnsupportedWrapper1(GLboolean, glIsBufferResidentNV, GLenum, target); \
  UnsupportedWrapper1(GLboolean, glIsCommandListNV, GLuint, list); \
  UnsupportedWrapper1(GLboolean, glIsFenceAPPLE, GLuint, fence); \
  UnsupportedWrapper1(GLboolean, glIsFenceNV, GLuint, fence); \
  UnsupportedWrapper1(GLboolean, glIsImageHandleResidentARB, GLuint64, handle); \
  UnsupportedWrapper1(GLboolean, glIsImageHandleResidentNV, GLuint64, handle); \
  UnsupportedWrapper1(GLboolean, glIsList, GLuint, list); \
  UnsupportedWrapper2(GLboolean, glIsNameAMD, GLenum, identifier, GLuint, name); \
  UnsupportedWrapper1(GLboolean, glIsNamedBufferResidentNV, GLuint, buffer); \
  UnsupportedWrapper1(GLboolean, glIsObjectBufferATI, GLuint, buffer); \
  UnsupportedWrapper1(GLboolean, glIsOcclusionQueryNV, GLuint, id); \
  UnsupportedWrapper1(GLboolean, glIsPathNV, GLuint, path); \
  UnsupportedWrapper4(GLboolean, glIsPointInFillPathNV, GLuint, path, GLuint, mask, GLfloat, x, GLfloat, y); \
  UnsupportedWrapper3(GLboolean, glIsPointInStrokePathNV, GLuint, path, GLfloat, x, GLfloat, y); \
  UnsupportedWrapper1(GLboolean, glIsProgramARB, GLuint, program); \
  UnsupportedWrapper1(GLboolean, glIsProgramNV, GLuint, id); \
  UnsupportedWrapper1(GLboolean, glIsStateNV, GLuint, state); \
  UnsupportedWrapper1(GLboolean, glIsSyncAPPLE, GLsync, sync); \
  UnsupportedWrapper1(GLboolean, glIsTextureEXT, GLuint, texture); \
  UnsupportedWrapper1(GLboolean, glIsTextureHandleResidentARB, GLuint64, handle); \
  UnsupportedWrapper1(GLboolean, glIsTextureHandleResidentNV, GLuint64, handle); \
  UnsupportedWrapper1(GLboolean, glIsTransformFeedbackNV, GLuint, id); \
  UnsupportedWrapper2(GLboolean, glIsVariantEnabledEXT, GLuint, id, GLenum, cap); \
  UnsupportedWrapper1(GLboolean, glIsVertexArrayAPPLE, GLuint, array); \
  UnsupportedWrapper2(GLboolean, glIsVertexAttribEnabledAPPLE, GLuint, index, GLenum, pname); \
  UnsupportedWrapper17(void, glLGPUCopyImageSubDataNVX, GLuint, sourceGpu, GLbitfield, destinationGpuMask, GLuint, srcName, GLenum, srcTarget, GLint, srcLevel, GLint, srcX, GLint, srxY, GLint, srcZ, GLuint, dstName, GLenum, dstTarget, GLint, dstLevel, GLint, dstX, GLint, dstY, GLint, dstZ, GLsizei, width, GLsizei, height, GLsizei, depth); \
  UnsupportedWrapper0(void, glLGPUInterlockNVX); \
  UnsupportedWrapper5(void, glLGPUNamedBufferSubDataNVX, GLbitfield, gpuMask, GLuint, buffer, GLintptr, offset, GLsizeiptr, size, const void *, data); \
  UnsupportedWrapper2(void, glLightEnviSGIX, GLenum, pname, GLint, param); \
  UnsupportedWrapper3(void, glLightf, GLenum, light, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper3(void, glLightfv, GLenum, light, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper3(void, glLighti, GLenum, light, GLenum, pname, GLint, param); \
  UnsupportedWrapper3(void, glLightiv, GLenum, light, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper2(void, glLightModelf, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper2(void, glLightModelfv, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper2(void, glLightModeli, GLenum, pname, GLint, param); \
  UnsupportedWrapper2(void, glLightModeliv, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper2(void, glLightModelxOES, GLenum, pname, GLfixed, param); \
  UnsupportedWrapper2(void, glLightModelxvOES, GLenum, pname, const GLfixed *, param); \
  UnsupportedWrapper3(void, glLightxOES, GLenum, light, GLenum, pname, GLfixed, param); \
  UnsupportedWrapper3(void, glLightxvOES, GLenum, light, GLenum, pname, const GLfixed *, params); \
  UnsupportedWrapper2(void, glLineStipple, GLint, factor, GLushort, pattern); \
  UnsupportedWrapper1(void, glLineWidthxOES, GLfixed, width); \
  UnsupportedWrapper1(void, glLinkProgramARB, GLhandleARB, programObj); \
  UnsupportedWrapper1(void, glListBase, GLuint, base); \
  UnsupportedWrapper7(void, glListDrawCommandsStatesClientNV, GLuint, list, GLuint, segment, const void **, indirects, const GLsizei *, sizes, const GLuint *, states, const GLuint *, fbos, GLuint, count); \
  UnsupportedWrapper3(void, glListParameterfSGIX, GLuint, list, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper3(void, glListParameterfvSGIX, GLuint, list, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper3(void, glListParameteriSGIX, GLuint, list, GLenum, pname, GLint, param); \
  UnsupportedWrapper3(void, glListParameterivSGIX, GLuint, list, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper1(void, glLoadIdentityDeformationMapSGIX, GLbitfield, mask); \
  UnsupportedWrapper0(void, glLoadIdentity); \
  UnsupportedWrapper1(void, glLoadMatrixd, const GLdouble *, m); \
  UnsupportedWrapper1(void, glLoadMatrixf, const GLfloat *, m); \
  UnsupportedWrapper1(void, glLoadMatrixxOES, const GLfixed *, m); \
  UnsupportedWrapper1(void, glLoadName, GLuint, name); \
  UnsupportedWrapper4(void, glLoadProgramNV, GLenum, target, GLuint, id, GLsizei, len, const GLubyte *, program); \
  UnsupportedWrapper1(void, glLoadTransposeMatrixdARB, const GLdouble *, m); \
  UnsupportedWrapper1(void, glLoadTransposeMatrixd, const GLdouble *, m); \
  UnsupportedWrapper1(void, glLoadTransposeMatrixfARB, const GLfloat *, m); \
  UnsupportedWrapper1(void, glLoadTransposeMatrixf, const GLfloat *, m); \
  UnsupportedWrapper1(void, glLoadTransposeMatrixxOES, const GLfixed *, m); \
  UnsupportedWrapper2(void, glLockArraysEXT, GLint, first, GLsizei, count); \
  UnsupportedWrapper1(void, glMakeBufferNonResidentNV, GLenum, target); \
  UnsupportedWrapper2(void, glMakeBufferResidentNV, GLenum, target, GLenum, access); \
  UnsupportedWrapper1(void, glMakeImageHandleNonResidentARB, GLuint64, handle); \
  UnsupportedWrapper1(void, glMakeImageHandleNonResidentNV, GLuint64, handle); \
  UnsupportedWrapper2(void, glMakeImageHandleResidentARB, GLuint64, handle, GLenum, access); \
  UnsupportedWrapper2(void, glMakeImageHandleResidentNV, GLuint64, handle, GLenum, access); \
  UnsupportedWrapper1(void, glMakeNamedBufferNonResidentNV, GLuint, buffer); \
  UnsupportedWrapper2(void, glMakeNamedBufferResidentNV, GLuint, buffer, GLenum, access); \
  UnsupportedWrapper1(void, glMakeTextureHandleNonResidentARB, GLuint64, handle); \
  UnsupportedWrapper1(void, glMakeTextureHandleNonResidentNV, GLuint64, handle); \
  UnsupportedWrapper1(void, glMakeTextureHandleResidentARB, GLuint64, handle); \
  UnsupportedWrapper1(void, glMakeTextureHandleResidentNV, GLuint64, handle); \
  UnsupportedWrapper6(void, glMap1d, GLenum, target, GLdouble, u1, GLdouble, u2, GLint, stride, GLint, order, const GLdouble *, points); \
  UnsupportedWrapper6(void, glMap1f, GLenum, target, GLfloat, u1, GLfloat, u2, GLint, stride, GLint, order, const GLfloat *, points); \
  UnsupportedWrapper6(void, glMap1xOES, GLenum, target, GLfixed, u1, GLfixed, u2, GLint, stride, GLint, order, GLfixed, points); \
  UnsupportedWrapper10(void, glMap2d, GLenum, target, GLdouble, u1, GLdouble, u2, GLint, ustride, GLint, uorder, GLdouble, v1, GLdouble, v2, GLint, vstride, GLint, vorder, const GLdouble *, points); \
  UnsupportedWrapper10(void, glMap2f, GLenum, target, GLfloat, u1, GLfloat, u2, GLint, ustride, GLint, uorder, GLfloat, v1, GLfloat, v2, GLint, vstride, GLint, vorder, const GLfloat *, points); \
  UnsupportedWrapper10(void, glMap2xOES, GLenum, target, GLfixed, u1, GLfixed, u2, GLint, ustride, GLint, uorder, GLfixed, v1, GLfixed, v2, GLint, vstride, GLint, vorder, GLfixed, points); \
  UnsupportedWrapper9(void, glMapControlPointsNV, GLenum, target, GLuint, index, GLenum, type, GLsizei, ustride, GLsizei, vstride, GLint, uorder, GLint, vorder, GLboolean, packed, const void *, points); \
  UnsupportedWrapper3(void, glMapGrid1d, GLint, un, GLdouble, u1, GLdouble, u2); \
  UnsupportedWrapper3(void, glMapGrid1f, GLint, un, GLfloat, u1, GLfloat, u2); \
  UnsupportedWrapper3(void, glMapGrid1xOES, GLint, n, GLfixed, u1, GLfixed, u2); \
  UnsupportedWrapper6(void, glMapGrid2d, GLint, un, GLdouble, u1, GLdouble, u2, GLint, vn, GLdouble, v1, GLdouble, v2); \
  UnsupportedWrapper6(void, glMapGrid2f, GLint, un, GLfloat, u1, GLfloat, u2, GLint, vn, GLfloat, v1, GLfloat, v2); \
  UnsupportedWrapper5(void, glMapGrid2xOES, GLint, n, GLfixed, u1, GLfixed, u2, GLfixed, v1, GLfixed, v2); \
  UnsupportedWrapper1(void *, glMapObjectBufferATI, GLuint, buffer); \
  UnsupportedWrapper3(void, glMapParameterfvNV, GLenum, target, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper3(void, glMapParameterivNV, GLenum, target, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper5(void *, glMapTexture2DINTEL, GLuint, texture, GLint, level, GLbitfield, access, GLint *, stride, GLenum *, layout); \
  UnsupportedWrapper7(void, glMapVertexAttrib1dAPPLE, GLuint, index, GLuint, size, GLdouble, u1, GLdouble, u2, GLint, stride, GLint, order, const GLdouble *, points); \
  UnsupportedWrapper7(void, glMapVertexAttrib1fAPPLE, GLuint, index, GLuint, size, GLfloat, u1, GLfloat, u2, GLint, stride, GLint, order, const GLfloat *, points); \
  UnsupportedWrapper11(void, glMapVertexAttrib2dAPPLE, GLuint, index, GLuint, size, GLdouble, u1, GLdouble, u2, GLint, ustride, GLint, uorder, GLdouble, v1, GLdouble, v2, GLint, vstride, GLint, vorder, const GLdouble *, points); \
  UnsupportedWrapper11(void, glMapVertexAttrib2fAPPLE, GLuint, index, GLuint, size, GLfloat, u1, GLfloat, u2, GLint, ustride, GLint, uorder, GLfloat, v1, GLfloat, v2, GLint, vstride, GLint, vorder, const GLfloat *, points); \
  UnsupportedWrapper3(void, glMaterialf, GLenum, face, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper3(void, glMaterialfv, GLenum, face, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper3(void, glMateriali, GLenum, face, GLenum, pname, GLint, param); \
  UnsupportedWrapper3(void, glMaterialiv, GLenum, face, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper3(void, glMaterialxOES, GLenum, face, GLenum, pname, GLfixed, param); \
  UnsupportedWrapper3(void, glMaterialxvOES, GLenum, face, GLenum, pname, const GLfixed *, param); \
  UnsupportedWrapper7(void, glMatrixFrustumEXT, GLenum, mode, GLdouble, left, GLdouble, right, GLdouble, bottom, GLdouble, top, GLdouble, zNear, GLdouble, zFar); \
  UnsupportedWrapper4(void, glMatrixIndexPointerARB, GLint, size, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper2(void, glMatrixIndexubvARB, GLint, size, const GLubyte *, indices); \
  UnsupportedWrapper2(void, glMatrixIndexuivARB, GLint, size, const GLuint *, indices); \
  UnsupportedWrapper2(void, glMatrixIndexusvARB, GLint, size, const GLushort *, indices); \
  UnsupportedWrapper2(void, glMatrixLoad3x2fNV, GLenum, matrixMode, const GLfloat *, m); \
  UnsupportedWrapper2(void, glMatrixLoad3x3fNV, GLenum, matrixMode, const GLfloat *, m); \
  UnsupportedWrapper2(void, glMatrixLoaddEXT, GLenum, mode, const GLdouble *, m); \
  UnsupportedWrapper2(void, glMatrixLoadfEXT, GLenum, mode, const GLfloat *, m); \
  UnsupportedWrapper1(void, glMatrixLoadIdentityEXT, GLenum, mode); \
  UnsupportedWrapper2(void, glMatrixLoadTranspose3x3fNV, GLenum, matrixMode, const GLfloat *, m); \
  UnsupportedWrapper2(void, glMatrixLoadTransposedEXT, GLenum, mode, const GLdouble *, m); \
  UnsupportedWrapper2(void, glMatrixLoadTransposefEXT, GLenum, mode, const GLfloat *, m); \
  UnsupportedWrapper1(void, glMatrixMode, GLenum, mode); \
  UnsupportedWrapper2(void, glMatrixMult3x2fNV, GLenum, matrixMode, const GLfloat *, m); \
  UnsupportedWrapper2(void, glMatrixMult3x3fNV, GLenum, matrixMode, const GLfloat *, m); \
  UnsupportedWrapper2(void, glMatrixMultdEXT, GLenum, mode, const GLdouble *, m); \
  UnsupportedWrapper2(void, glMatrixMultfEXT, GLenum, mode, const GLfloat *, m); \
  UnsupportedWrapper2(void, glMatrixMultTranspose3x3fNV, GLenum, matrixMode, const GLfloat *, m); \
  UnsupportedWrapper2(void, glMatrixMultTransposedEXT, GLenum, mode, const GLdouble *, m); \
  UnsupportedWrapper2(void, glMatrixMultTransposefEXT, GLenum, mode, const GLfloat *, m); \
  UnsupportedWrapper7(void, glMatrixOrthoEXT, GLenum, mode, GLdouble, left, GLdouble, right, GLdouble, bottom, GLdouble, top, GLdouble, zNear, GLdouble, zFar); \
  UnsupportedWrapper1(void, glMatrixPopEXT, GLenum, mode); \
  UnsupportedWrapper1(void, glMatrixPushEXT, GLenum, mode); \
  UnsupportedWrapper5(void, glMatrixRotatedEXT, GLenum, mode, GLdouble, angle, GLdouble, x, GLdouble, y, GLdouble, z); \
  UnsupportedWrapper5(void, glMatrixRotatefEXT, GLenum, mode, GLfloat, angle, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper4(void, glMatrixScaledEXT, GLenum, mode, GLdouble, x, GLdouble, y, GLdouble, z); \
  UnsupportedWrapper4(void, glMatrixScalefEXT, GLenum, mode, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper4(void, glMatrixTranslatedEXT, GLenum, mode, GLdouble, x, GLdouble, y, GLdouble, z); \
  UnsupportedWrapper4(void, glMatrixTranslatefEXT, GLenum, mode, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper3(void, glMinmaxEXT, GLenum, target, GLenum, internalformat, GLboolean, sink); \
  UnsupportedWrapper3(void, glMinmax, GLenum, target, GLenum, internalformat, GLboolean, sink); \
  UnsupportedWrapper0(void, glMulticastBarrierNV); \
  UnsupportedWrapper12(void, glMulticastBlitFramebufferNV, GLuint, srcGpu, GLuint, dstGpu, GLint, srcX0, GLint, srcY0, GLint, srcX1, GLint, srcY1, GLint, dstX0, GLint, dstY0, GLint, dstX1, GLint, dstY1, GLbitfield, mask, GLenum, filter); \
  UnsupportedWrapper5(void, glMulticastBufferSubDataNV, GLbitfield, gpuMask, GLuint, buffer, GLintptr, offset, GLsizeiptr, size, const void *, data); \
  UnsupportedWrapper7(void, glMulticastCopyBufferSubDataNV, GLuint, readGpu, GLbitfield, writeGpuMask, GLuint, readBuffer, GLuint, writeBuffer, GLintptr, readOffset, GLintptr, writeOffset, GLsizeiptr, size); \
  UnsupportedWrapper17(void, glMulticastCopyImageSubDataNV, GLuint, srcGpu, GLbitfield, dstGpuMask, GLuint, srcName, GLenum, srcTarget, GLint, srcLevel, GLint, srcX, GLint, srcY, GLint, srcZ, GLuint, dstName, GLenum, dstTarget, GLint, dstLevel, GLint, dstX, GLint, dstY, GLint, dstZ, GLsizei, srcWidth, GLsizei, srcHeight, GLsizei, srcDepth); \
  UnsupportedWrapper5(void, glMulticastFramebufferSampleLocationsfvNV, GLuint, gpu, GLuint, framebuffer, GLuint, start, GLsizei, count, const GLfloat *, v); \
  UnsupportedWrapper4(void, glMulticastGetQueryObjecti64vNV, GLuint, gpu, GLuint, id, GLenum, pname, GLint64 *, params); \
  UnsupportedWrapper4(void, glMulticastGetQueryObjectivNV, GLuint, gpu, GLuint, id, GLenum, pname, GLint *, params); \
  UnsupportedWrapper4(void, glMulticastGetQueryObjectui64vNV, GLuint, gpu, GLuint, id, GLenum, pname, GLuint64 *, params); \
  UnsupportedWrapper4(void, glMulticastGetQueryObjectuivNV, GLuint, gpu, GLuint, id, GLenum, pname, GLuint *, params); \
  UnsupportedWrapper2(void, glMulticastWaitSyncNV, GLuint, signalGpu, GLbitfield, waitGpuMask); \
  UnsupportedWrapper4(void, glMultiDrawArraysIndirectAMD, GLenum, mode, const void *, indirect, GLsizei, primcount, GLsizei, stride); \
  UnsupportedWrapper6(void, glMultiDrawArraysIndirectBindlessCountNV, GLenum, mode, const void *, indirect, GLsizei, drawCount, GLsizei, maxDrawCount, GLsizei, stride, GLint, vertexBufferCount); \
  UnsupportedWrapper5(void, glMultiDrawArraysIndirectBindlessNV, GLenum, mode, const void *, indirect, GLsizei, drawCount, GLsizei, stride, GLint, vertexBufferCount); \
  UnsupportedWrapper4(void, glMultiDrawArraysIndirectEXT, GLenum, mode, const void *, indirect, GLsizei, drawcount, GLsizei, stride); \
  UnsupportedWrapper4(void, glMultiDrawElementArrayAPPLE, GLenum, mode, const GLint *, first, const GLsizei *, count, GLsizei, primcount); \
  UnsupportedWrapper5(void, glMultiDrawElementsEXT, GLenum, mode, const GLsizei *, count, GLenum, type, const void *const*, indices, GLsizei, primcount); \
  UnsupportedWrapper5(void, glMultiDrawElementsIndirectAMD, GLenum, mode, GLenum, type, const void *, indirect, GLsizei, primcount, GLsizei, stride); \
  UnsupportedWrapper7(void, glMultiDrawElementsIndirectBindlessCountNV, GLenum, mode, GLenum, type, const void *, indirect, GLsizei, drawCount, GLsizei, maxDrawCount, GLsizei, stride, GLint, vertexBufferCount); \
  UnsupportedWrapper6(void, glMultiDrawElementsIndirectBindlessNV, GLenum, mode, GLenum, type, const void *, indirect, GLsizei, drawCount, GLsizei, stride, GLint, vertexBufferCount); \
  UnsupportedWrapper5(void, glMultiDrawElementsIndirectEXT, GLenum, mode, GLenum, type, const void *, indirect, GLsizei, drawcount, GLsizei, stride); \
  UnsupportedWrapper6(void, glMultiDrawRangeElementArrayAPPLE, GLenum, mode, GLuint, start, GLuint, end, const GLint *, first, const GLsizei *, count, GLsizei, primcount); \
  UnsupportedWrapper5(void, glMultiModeDrawArraysIBM, const GLenum *, mode, const GLint *, first, const GLsizei *, count, GLsizei, primcount, GLint, modestride); \
  UnsupportedWrapper6(void, glMultiModeDrawElementsIBM, const GLenum *, mode, const GLsizei *, count, GLenum, type, const void *const*, indices, GLsizei, primcount, GLint, modestride); \
  UnsupportedWrapper2(void, glMultiTexCoord1bOES, GLenum, texture, GLbyte, s); \
  UnsupportedWrapper2(void, glMultiTexCoord1bvOES, GLenum, texture, const GLbyte *, coords); \
  UnsupportedWrapper2(void, glMultiTexCoord1dARB, GLenum, target, GLdouble, s); \
  UnsupportedWrapper2(void, glMultiTexCoord1d, GLenum, target, GLdouble, s); \
  UnsupportedWrapper2(void, glMultiTexCoord1dvARB, GLenum, target, const GLdouble *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord1dv, GLenum, target, const GLdouble *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord1fARB, GLenum, target, GLfloat, s); \
  UnsupportedWrapper2(void, glMultiTexCoord1f, GLenum, target, GLfloat, s); \
  UnsupportedWrapper2(void, glMultiTexCoord1fvARB, GLenum, target, const GLfloat *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord1fv, GLenum, target, const GLfloat *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord1hNV, GLenum, target, GLhalfNV, s); \
  UnsupportedWrapper2(void, glMultiTexCoord1hvNV, GLenum, target, const GLhalfNV *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord1iARB, GLenum, target, GLint, s); \
  UnsupportedWrapper2(void, glMultiTexCoord1i, GLenum, target, GLint, s); \
  UnsupportedWrapper2(void, glMultiTexCoord1ivARB, GLenum, target, const GLint *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord1iv, GLenum, target, const GLint *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord1sARB, GLenum, target, GLshort, s); \
  UnsupportedWrapper2(void, glMultiTexCoord1s, GLenum, target, GLshort, s); \
  UnsupportedWrapper2(void, glMultiTexCoord1svARB, GLenum, target, const GLshort *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord1sv, GLenum, target, const GLshort *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord1xOES, GLenum, texture, GLfixed, s); \
  UnsupportedWrapper2(void, glMultiTexCoord1xvOES, GLenum, texture, const GLfixed *, coords); \
  UnsupportedWrapper3(void, glMultiTexCoord2bOES, GLenum, texture, GLbyte, s, GLbyte, t); \
  UnsupportedWrapper2(void, glMultiTexCoord2bvOES, GLenum, texture, const GLbyte *, coords); \
  UnsupportedWrapper3(void, glMultiTexCoord2dARB, GLenum, target, GLdouble, s, GLdouble, t); \
  UnsupportedWrapper3(void, glMultiTexCoord2d, GLenum, target, GLdouble, s, GLdouble, t); \
  UnsupportedWrapper2(void, glMultiTexCoord2dvARB, GLenum, target, const GLdouble *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord2dv, GLenum, target, const GLdouble *, v); \
  UnsupportedWrapper3(void, glMultiTexCoord2fARB, GLenum, target, GLfloat, s, GLfloat, t); \
  UnsupportedWrapper3(void, glMultiTexCoord2f, GLenum, target, GLfloat, s, GLfloat, t); \
  UnsupportedWrapper2(void, glMultiTexCoord2fvARB, GLenum, target, const GLfloat *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord2fv, GLenum, target, const GLfloat *, v); \
  UnsupportedWrapper3(void, glMultiTexCoord2hNV, GLenum, target, GLhalfNV, s, GLhalfNV, t); \
  UnsupportedWrapper2(void, glMultiTexCoord2hvNV, GLenum, target, const GLhalfNV *, v); \
  UnsupportedWrapper3(void, glMultiTexCoord2iARB, GLenum, target, GLint, s, GLint, t); \
  UnsupportedWrapper3(void, glMultiTexCoord2i, GLenum, target, GLint, s, GLint, t); \
  UnsupportedWrapper2(void, glMultiTexCoord2ivARB, GLenum, target, const GLint *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord2iv, GLenum, target, const GLint *, v); \
  UnsupportedWrapper3(void, glMultiTexCoord2sARB, GLenum, target, GLshort, s, GLshort, t); \
  UnsupportedWrapper3(void, glMultiTexCoord2s, GLenum, target, GLshort, s, GLshort, t); \
  UnsupportedWrapper2(void, glMultiTexCoord2svARB, GLenum, target, const GLshort *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord2sv, GLenum, target, const GLshort *, v); \
  UnsupportedWrapper3(void, glMultiTexCoord2xOES, GLenum, texture, GLfixed, s, GLfixed, t); \
  UnsupportedWrapper2(void, glMultiTexCoord2xvOES, GLenum, texture, const GLfixed *, coords); \
  UnsupportedWrapper4(void, glMultiTexCoord3bOES, GLenum, texture, GLbyte, s, GLbyte, t, GLbyte, r); \
  UnsupportedWrapper2(void, glMultiTexCoord3bvOES, GLenum, texture, const GLbyte *, coords); \
  UnsupportedWrapper4(void, glMultiTexCoord3dARB, GLenum, target, GLdouble, s, GLdouble, t, GLdouble, r); \
  UnsupportedWrapper4(void, glMultiTexCoord3d, GLenum, target, GLdouble, s, GLdouble, t, GLdouble, r); \
  UnsupportedWrapper2(void, glMultiTexCoord3dvARB, GLenum, target, const GLdouble *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord3dv, GLenum, target, const GLdouble *, v); \
  UnsupportedWrapper4(void, glMultiTexCoord3fARB, GLenum, target, GLfloat, s, GLfloat, t, GLfloat, r); \
  UnsupportedWrapper4(void, glMultiTexCoord3f, GLenum, target, GLfloat, s, GLfloat, t, GLfloat, r); \
  UnsupportedWrapper2(void, glMultiTexCoord3fvARB, GLenum, target, const GLfloat *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord3fv, GLenum, target, const GLfloat *, v); \
  UnsupportedWrapper4(void, glMultiTexCoord3hNV, GLenum, target, GLhalfNV, s, GLhalfNV, t, GLhalfNV, r); \
  UnsupportedWrapper2(void, glMultiTexCoord3hvNV, GLenum, target, const GLhalfNV *, v); \
  UnsupportedWrapper4(void, glMultiTexCoord3iARB, GLenum, target, GLint, s, GLint, t, GLint, r); \
  UnsupportedWrapper4(void, glMultiTexCoord3i, GLenum, target, GLint, s, GLint, t, GLint, r); \
  UnsupportedWrapper2(void, glMultiTexCoord3ivARB, GLenum, target, const GLint *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord3iv, GLenum, target, const GLint *, v); \
  UnsupportedWrapper4(void, glMultiTexCoord3sARB, GLenum, target, GLshort, s, GLshort, t, GLshort, r); \
  UnsupportedWrapper4(void, glMultiTexCoord3s, GLenum, target, GLshort, s, GLshort, t, GLshort, r); \
  UnsupportedWrapper2(void, glMultiTexCoord3svARB, GLenum, target, const GLshort *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord3sv, GLenum, target, const GLshort *, v); \
  UnsupportedWrapper4(void, glMultiTexCoord3xOES, GLenum, texture, GLfixed, s, GLfixed, t, GLfixed, r); \
  UnsupportedWrapper2(void, glMultiTexCoord3xvOES, GLenum, texture, const GLfixed *, coords); \
  UnsupportedWrapper5(void, glMultiTexCoord4bOES, GLenum, texture, GLbyte, s, GLbyte, t, GLbyte, r, GLbyte, q); \
  UnsupportedWrapper2(void, glMultiTexCoord4bvOES, GLenum, texture, const GLbyte *, coords); \
  UnsupportedWrapper5(void, glMultiTexCoord4dARB, GLenum, target, GLdouble, s, GLdouble, t, GLdouble, r, GLdouble, q); \
  UnsupportedWrapper5(void, glMultiTexCoord4d, GLenum, target, GLdouble, s, GLdouble, t, GLdouble, r, GLdouble, q); \
  UnsupportedWrapper2(void, glMultiTexCoord4dvARB, GLenum, target, const GLdouble *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord4dv, GLenum, target, const GLdouble *, v); \
  UnsupportedWrapper5(void, glMultiTexCoord4fARB, GLenum, target, GLfloat, s, GLfloat, t, GLfloat, r, GLfloat, q); \
  UnsupportedWrapper5(void, glMultiTexCoord4f, GLenum, target, GLfloat, s, GLfloat, t, GLfloat, r, GLfloat, q); \
  UnsupportedWrapper2(void, glMultiTexCoord4fvARB, GLenum, target, const GLfloat *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord4fv, GLenum, target, const GLfloat *, v); \
  UnsupportedWrapper5(void, glMultiTexCoord4hNV, GLenum, target, GLhalfNV, s, GLhalfNV, t, GLhalfNV, r, GLhalfNV, q); \
  UnsupportedWrapper2(void, glMultiTexCoord4hvNV, GLenum, target, const GLhalfNV *, v); \
  UnsupportedWrapper5(void, glMultiTexCoord4iARB, GLenum, target, GLint, s, GLint, t, GLint, r, GLint, q); \
  UnsupportedWrapper5(void, glMultiTexCoord4i, GLenum, target, GLint, s, GLint, t, GLint, r, GLint, q); \
  UnsupportedWrapper2(void, glMultiTexCoord4ivARB, GLenum, target, const GLint *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord4iv, GLenum, target, const GLint *, v); \
  UnsupportedWrapper5(void, glMultiTexCoord4sARB, GLenum, target, GLshort, s, GLshort, t, GLshort, r, GLshort, q); \
  UnsupportedWrapper5(void, glMultiTexCoord4s, GLenum, target, GLshort, s, GLshort, t, GLshort, r, GLshort, q); \
  UnsupportedWrapper2(void, glMultiTexCoord4svARB, GLenum, target, const GLshort *, v); \
  UnsupportedWrapper2(void, glMultiTexCoord4sv, GLenum, target, const GLshort *, v); \
  UnsupportedWrapper5(void, glMultiTexCoord4xOES, GLenum, texture, GLfixed, s, GLfixed, t, GLfixed, r, GLfixed, q); \
  UnsupportedWrapper2(void, glMultiTexCoord4xvOES, GLenum, texture, const GLfixed *, coords); \
  UnsupportedWrapper3(void, glMultiTexCoordP1ui, GLenum, texture, GLenum, type, GLuint, coords); \
  UnsupportedWrapper3(void, glMultiTexCoordP1uiv, GLenum, texture, GLenum, type, const GLuint *, coords); \
  UnsupportedWrapper3(void, glMultiTexCoordP2ui, GLenum, texture, GLenum, type, GLuint, coords); \
  UnsupportedWrapper3(void, glMultiTexCoordP2uiv, GLenum, texture, GLenum, type, const GLuint *, coords); \
  UnsupportedWrapper3(void, glMultiTexCoordP3ui, GLenum, texture, GLenum, type, GLuint, coords); \
  UnsupportedWrapper3(void, glMultiTexCoordP3uiv, GLenum, texture, GLenum, type, const GLuint *, coords); \
  UnsupportedWrapper3(void, glMultiTexCoordP4ui, GLenum, texture, GLenum, type, GLuint, coords); \
  UnsupportedWrapper3(void, glMultiTexCoordP4uiv, GLenum, texture, GLenum, type, const GLuint *, coords); \
  UnsupportedWrapper5(void, glMultiTexCoordPointerEXT, GLenum, texunit, GLint, size, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper4(void, glMultiTexEnvfEXT, GLenum, texunit, GLenum, target, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper4(void, glMultiTexEnvfvEXT, GLenum, texunit, GLenum, target, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper4(void, glMultiTexEnviEXT, GLenum, texunit, GLenum, target, GLenum, pname, GLint, param); \
  UnsupportedWrapper4(void, glMultiTexEnvivEXT, GLenum, texunit, GLenum, target, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper4(void, glMultiTexGendEXT, GLenum, texunit, GLenum, coord, GLenum, pname, GLdouble, param); \
  UnsupportedWrapper4(void, glMultiTexGendvEXT, GLenum, texunit, GLenum, coord, GLenum, pname, const GLdouble *, params); \
  UnsupportedWrapper4(void, glMultiTexGenfEXT, GLenum, texunit, GLenum, coord, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper4(void, glMultiTexGenfvEXT, GLenum, texunit, GLenum, coord, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper4(void, glMultiTexGeniEXT, GLenum, texunit, GLenum, coord, GLenum, pname, GLint, param); \
  UnsupportedWrapper4(void, glMultiTexGenivEXT, GLenum, texunit, GLenum, coord, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper3(void, glMultiTexRenderbufferEXT, GLenum, texunit, GLenum, target, GLuint, renderbuffer); \
  UnsupportedWrapper1(void, glMultMatrixd, const GLdouble *, m); \
  UnsupportedWrapper1(void, glMultMatrixf, const GLfloat *, m); \
  UnsupportedWrapper1(void, glMultMatrixxOES, const GLfixed *, m); \
  UnsupportedWrapper1(void, glMultTransposeMatrixdARB, const GLdouble *, m); \
  UnsupportedWrapper1(void, glMultTransposeMatrixd, const GLdouble *, m); \
  UnsupportedWrapper1(void, glMultTransposeMatrixfARB, const GLfloat *, m); \
  UnsupportedWrapper1(void, glMultTransposeMatrixf, const GLfloat *, m); \
  UnsupportedWrapper1(void, glMultTransposeMatrixxOES, const GLfixed *, m); \
  UnsupportedWrapper4(void, glNamedBufferPageCommitmentARB, GLuint, buffer, GLintptr, offset, GLsizeiptr, size, GLboolean, commit); \
  UnsupportedWrapper4(void, glNamedBufferPageCommitmentEXT, GLuint, buffer, GLintptr, offset, GLsizeiptr, size, GLboolean, commit); \
  UnsupportedWrapper5(void, glNamedBufferStorageExternalEXT, GLuint, buffer, GLintptr, offset, GLsizeiptr, size, GLeglClientBufferEXT, clientBuffer, GLbitfield, flags); \
  UnsupportedWrapper4(void, glNamedFramebufferSampleLocationsfvARB, GLuint, framebuffer, GLuint, start, GLsizei, count, const GLfloat *, v); \
  UnsupportedWrapper4(void, glNamedFramebufferSampleLocationsfvNV, GLuint, framebuffer, GLuint, start, GLsizei, count, const GLfloat *, v); \
  UnsupportedWrapper4(void, glNamedFramebufferSamplePositionsfvAMD, GLuint, framebuffer, GLuint, numsamples, GLuint, pixelindex, const GLfloat *, values); \
  UnsupportedWrapper5(void, glNamedFramebufferTextureFaceEXT, GLuint, framebuffer, GLenum, attachment, GLuint, texture, GLint, level, GLenum, face); \
  UnsupportedWrapper7(void, glNamedProgramLocalParameter4dEXT, GLuint, program, GLenum, target, GLuint, index, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  UnsupportedWrapper4(void, glNamedProgramLocalParameter4dvEXT, GLuint, program, GLenum, target, GLuint, index, const GLdouble *, params); \
  UnsupportedWrapper7(void, glNamedProgramLocalParameter4fEXT, GLuint, program, GLenum, target, GLuint, index, GLfloat, x, GLfloat, y, GLfloat, z, GLfloat, w); \
  UnsupportedWrapper4(void, glNamedProgramLocalParameter4fvEXT, GLuint, program, GLenum, target, GLuint, index, const GLfloat *, params); \
  UnsupportedWrapper7(void, glNamedProgramLocalParameterI4iEXT, GLuint, program, GLenum, target, GLuint, index, GLint, x, GLint, y, GLint, z, GLint, w); \
  UnsupportedWrapper4(void, glNamedProgramLocalParameterI4ivEXT, GLuint, program, GLenum, target, GLuint, index, const GLint *, params); \
  UnsupportedWrapper7(void, glNamedProgramLocalParameterI4uiEXT, GLuint, program, GLenum, target, GLuint, index, GLuint, x, GLuint, y, GLuint, z, GLuint, w); \
  UnsupportedWrapper4(void, glNamedProgramLocalParameterI4uivEXT, GLuint, program, GLenum, target, GLuint, index, const GLuint *, params); \
  UnsupportedWrapper5(void, glNamedProgramLocalParameters4fvEXT, GLuint, program, GLenum, target, GLuint, index, GLsizei, count, const GLfloat *, params); \
  UnsupportedWrapper5(void, glNamedProgramLocalParametersI4ivEXT, GLuint, program, GLenum, target, GLuint, index, GLsizei, count, const GLint *, params); \
  UnsupportedWrapper5(void, glNamedProgramLocalParametersI4uivEXT, GLuint, program, GLenum, target, GLuint, index, GLsizei, count, const GLuint *, params); \
  UnsupportedWrapper5(void, glNamedProgramStringEXT, GLuint, program, GLenum, target, GLenum, format, GLsizei, len, const void *, string); \
  UnsupportedWrapper6(void, glNamedRenderbufferStorageMultisampleCoverageEXT, GLuint, renderbuffer, GLsizei, coverageSamples, GLsizei, colorSamples, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  UnsupportedWrapper2(void, glNewList, GLuint, list, GLenum, mode); \
  UnsupportedWrapper3(GLuint, glNewObjectBufferATI, GLsizei, size, const void *, pointer, GLenum, usage); \
  UnsupportedWrapper3(void, glNormal3b, GLbyte, nx, GLbyte, ny, GLbyte, nz); \
  UnsupportedWrapper1(void, glNormal3bv, const GLbyte *, v); \
  UnsupportedWrapper3(void, glNormal3d, GLdouble, nx, GLdouble, ny, GLdouble, nz); \
  UnsupportedWrapper1(void, glNormal3dv, const GLdouble *, v); \
  UnsupportedWrapper3(void, glNormal3f, GLfloat, nx, GLfloat, ny, GLfloat, nz); \
  UnsupportedWrapper6(void, glNormal3fVertex3fSUN, GLfloat, nx, GLfloat, ny, GLfloat, nz, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper2(void, glNormal3fVertex3fvSUN, const GLfloat *, n, const GLfloat *, v); \
  UnsupportedWrapper1(void, glNormal3fv, const GLfloat *, v); \
  UnsupportedWrapper3(void, glNormal3hNV, GLhalfNV, nx, GLhalfNV, ny, GLhalfNV, nz); \
  UnsupportedWrapper1(void, glNormal3hvNV, const GLhalfNV *, v); \
  UnsupportedWrapper3(void, glNormal3i, GLint, nx, GLint, ny, GLint, nz); \
  UnsupportedWrapper1(void, glNormal3iv, const GLint *, v); \
  UnsupportedWrapper3(void, glNormal3s, GLshort, nx, GLshort, ny, GLshort, nz); \
  UnsupportedWrapper1(void, glNormal3sv, const GLshort *, v); \
  UnsupportedWrapper3(void, glNormal3xOES, GLfixed, nx, GLfixed, ny, GLfixed, nz); \
  UnsupportedWrapper1(void, glNormal3xvOES, const GLfixed *, coords); \
  UnsupportedWrapper2(void, glNormalFormatNV, GLenum, type, GLsizei, stride); \
  UnsupportedWrapper2(void, glNormalP3ui, GLenum, type, GLuint, coords); \
  UnsupportedWrapper2(void, glNormalP3uiv, GLenum, type, const GLuint *, coords); \
  UnsupportedWrapper4(void, glNormalPointerEXT, GLenum, type, GLsizei, stride, GLsizei, count, const void *, pointer); \
  UnsupportedWrapper4(void, glNormalPointerListIBM, GLenum, type, GLint, stride, const void **, pointer, GLint, ptrstride); \
  UnsupportedWrapper3(void, glNormalPointer, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper2(void, glNormalPointervINTEL, GLenum, type, const void **, pointer); \
  UnsupportedWrapper4(void, glNormalStream3bATI, GLenum, stream, GLbyte, nx, GLbyte, ny, GLbyte, nz); \
  UnsupportedWrapper2(void, glNormalStream3bvATI, GLenum, stream, const GLbyte *, coords); \
  UnsupportedWrapper4(void, glNormalStream3dATI, GLenum, stream, GLdouble, nx, GLdouble, ny, GLdouble, nz); \
  UnsupportedWrapper2(void, glNormalStream3dvATI, GLenum, stream, const GLdouble *, coords); \
  UnsupportedWrapper4(void, glNormalStream3fATI, GLenum, stream, GLfloat, nx, GLfloat, ny, GLfloat, nz); \
  UnsupportedWrapper2(void, glNormalStream3fvATI, GLenum, stream, const GLfloat *, coords); \
  UnsupportedWrapper4(void, glNormalStream3iATI, GLenum, stream, GLint, nx, GLint, ny, GLint, nz); \
  UnsupportedWrapper2(void, glNormalStream3ivATI, GLenum, stream, const GLint *, coords); \
  UnsupportedWrapper4(void, glNormalStream3sATI, GLenum, stream, GLshort, nx, GLshort, ny, GLshort, nz); \
  UnsupportedWrapper2(void, glNormalStream3svATI, GLenum, stream, const GLshort *, coords); \
  UnsupportedWrapper3(GLenum, glObjectPurgeableAPPLE, GLenum, objectType, GLuint, name, GLenum, option); \
  UnsupportedWrapper3(GLenum, glObjectUnpurgeableAPPLE, GLenum, objectType, GLuint, name, GLenum, option); \
  UnsupportedWrapper6(void, glOrthofOES, GLfloat, l, GLfloat, r, GLfloat, b, GLfloat, t, GLfloat, n, GLfloat, f); \
  UnsupportedWrapper6(void, glOrtho, GLdouble, left, GLdouble, right, GLdouble, bottom, GLdouble, top, GLdouble, zNear, GLdouble, zFar); \
  UnsupportedWrapper6(void, glOrthoxOES, GLfixed, l, GLfixed, r, GLfixed, b, GLfixed, t, GLfixed, n, GLfixed, f); \
  UnsupportedWrapper3(void, glPassTexCoordATI, GLuint, dst, GLuint, coord, GLenum, swizzle); \
  UnsupportedWrapper1(void, glPassThrough, GLfloat, token); \
  UnsupportedWrapper1(void, glPassThroughxOES, GLfixed, token); \
  UnsupportedWrapper4(void, glPathColorGenNV, GLenum, color, GLenum, genMode, GLenum, colorFormat, const GLfloat *, coeffs); \
  UnsupportedWrapper6(void, glPathCommandsNV, GLuint, path, GLsizei, numCommands, const GLubyte *, commands, GLsizei, numCoords, GLenum, coordType, const void *, coords); \
  UnsupportedWrapper4(void, glPathCoordsNV, GLuint, path, GLsizei, numCoords, GLenum, coordType, const void *, coords); \
  UnsupportedWrapper1(void, glPathCoverDepthFuncNV, GLenum, func); \
  UnsupportedWrapper3(void, glPathDashArrayNV, GLuint, path, GLsizei, dashCount, const GLfloat *, dashArray); \
  UnsupportedWrapper1(void, glPathFogGenNV, GLenum, genMode); \
  UnsupportedWrapper8(GLenum, glPathGlyphIndexArrayNV, GLuint, firstPathName, GLenum, fontTarget, const void *, fontName, GLbitfield, fontStyle, GLuint, firstGlyphIndex, GLsizei, numGlyphs, GLuint, pathParameterTemplate, GLfloat, emScale); \
  UnsupportedWrapper6(GLenum, glPathGlyphIndexRangeNV, GLenum, fontTarget, const void *, fontName, GLbitfield, fontStyle, GLuint, pathParameterTemplate, GLfloat, emScale, GLuint *, baseAndCount); \
  UnsupportedWrapper9(void, glPathGlyphRangeNV, GLuint, firstPathName, GLenum, fontTarget, const void *, fontName, GLbitfield, fontStyle, GLuint, firstGlyph, GLsizei, numGlyphs, GLenum, handleMissingGlyphs, GLuint, pathParameterTemplate, GLfloat, emScale); \
  UnsupportedWrapper10(void, glPathGlyphsNV, GLuint, firstPathName, GLenum, fontTarget, const void *, fontName, GLbitfield, fontStyle, GLsizei, numGlyphs, GLenum, type, const void *, charcodes, GLenum, handleMissingGlyphs, GLuint, pathParameterTemplate, GLfloat, emScale); \
  UnsupportedWrapper9(GLenum, glPathMemoryGlyphIndexArrayNV, GLuint, firstPathName, GLenum, fontTarget, GLsizeiptr, fontSize, const void *, fontData, GLsizei, faceIndex, GLuint, firstGlyphIndex, GLsizei, numGlyphs, GLuint, pathParameterTemplate, GLfloat, emScale); \
  UnsupportedWrapper3(void, glPathParameterfNV, GLuint, path, GLenum, pname, GLfloat, value); \
  UnsupportedWrapper3(void, glPathParameterfvNV, GLuint, path, GLenum, pname, const GLfloat *, value); \
  UnsupportedWrapper3(void, glPathParameteriNV, GLuint, path, GLenum, pname, GLint, value); \
  UnsupportedWrapper3(void, glPathParameterivNV, GLuint, path, GLenum, pname, const GLint *, value); \
  UnsupportedWrapper2(void, glPathStencilDepthOffsetNV, GLfloat, factor, GLfloat, units); \
  UnsupportedWrapper3(void, glPathStencilFuncNV, GLenum, func, GLint, ref, GLuint, mask); \
  UnsupportedWrapper4(void, glPathStringNV, GLuint, path, GLenum, format, GLsizei, length, const void *, pathString); \
  UnsupportedWrapper8(void, glPathSubCommandsNV, GLuint, path, GLsizei, commandStart, GLsizei, commandsToDelete, GLsizei, numCommands, const GLubyte *, commands, GLsizei, numCoords, GLenum, coordType, const void *, coords); \
  UnsupportedWrapper5(void, glPathSubCoordsNV, GLuint, path, GLsizei, coordStart, GLsizei, numCoords, GLenum, coordType, const void *, coords); \
  UnsupportedWrapper4(void, glPathTexGenNV, GLenum, texCoordSet, GLenum, genMode, GLint, components, const GLfloat *, coeffs); \
  UnsupportedWrapper0(void, glPauseTransformFeedbackNV); \
  UnsupportedWrapper3(void, glPixelDataRangeNV, GLenum, target, GLsizei, length, const void *, pointer); \
  UnsupportedWrapper3(void, glPixelMapfv, GLenum, map, GLsizei, mapsize, const GLfloat *, values); \
  UnsupportedWrapper3(void, glPixelMapuiv, GLenum, map, GLsizei, mapsize, const GLuint *, values); \
  UnsupportedWrapper3(void, glPixelMapusv, GLenum, map, GLsizei, mapsize, const GLushort *, values); \
  UnsupportedWrapper3(void, glPixelMapx, GLenum, map, GLint, size, const GLfixed *, values); \
  UnsupportedWrapper2(void, glPixelStorex, GLenum, pname, GLfixed, param); \
  UnsupportedWrapper2(void, glPixelTexGenParameterfSGIS, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper2(void, glPixelTexGenParameterfvSGIS, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper2(void, glPixelTexGenParameteriSGIS, GLenum, pname, GLint, param); \
  UnsupportedWrapper2(void, glPixelTexGenParameterivSGIS, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper1(void, glPixelTexGenSGIX, GLenum, mode); \
  UnsupportedWrapper2(void, glPixelTransferf, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper2(void, glPixelTransferi, GLenum, pname, GLint, param); \
  UnsupportedWrapper2(void, glPixelTransferxOES, GLenum, pname, GLfixed, param); \
  UnsupportedWrapper3(void, glPixelTransformParameterfEXT, GLenum, target, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper3(void, glPixelTransformParameterfvEXT, GLenum, target, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper3(void, glPixelTransformParameteriEXT, GLenum, target, GLenum, pname, GLint, param); \
  UnsupportedWrapper3(void, glPixelTransformParameterivEXT, GLenum, target, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper2(void, glPixelZoom, GLfloat, xfactor, GLfloat, yfactor); \
  UnsupportedWrapper2(void, glPixelZoomxOES, GLfixed, xfactor, GLfixed, yfactor); \
  UnsupportedWrapper2(void, glPNTrianglesfATI, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper2(void, glPNTrianglesiATI, GLenum, pname, GLint, param); \
  UnsupportedWrapper8(GLboolean, glPointAlongPathNV, GLuint, path, GLsizei, startSegment, GLsizei, numSegments, GLfloat, distance, GLfloat *, x, GLfloat *, y, GLfloat *, tangentX, GLfloat *, tangentY); \
  UnsupportedWrapper2(void, glPointParameterfSGIS, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper2(void, glPointParameterfvSGIS, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper2(void, glPointParameteriNV, GLenum, pname, GLint, param); \
  UnsupportedWrapper2(void, glPointParameterivNV, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper2(void, glPointParameterxvOES, GLenum, pname, const GLfixed *, params); \
  UnsupportedWrapper1(void, glPointSizexOES, GLfixed, size); \
  UnsupportedWrapper1(GLint, glPollAsyncSGIX, GLuint *, markerp); \
  UnsupportedWrapper1(GLint, glPollInstrumentsSGIX, GLint *, marker_p); \
  UnsupportedWrapper2(void, glPolygonModeNV, GLenum, face, GLenum, mode); \
  UnsupportedWrapper2(void, glPolygonOffsetEXT, GLfloat, factor, GLfloat, bias); \
  UnsupportedWrapper2(void, glPolygonOffsetxOES, GLfixed, factor, GLfixed, units); \
  UnsupportedWrapper1(void, glPolygonStipple, const GLubyte *, mask); \
  UnsupportedWrapper0(void, glPopAttrib); \
  UnsupportedWrapper0(void, glPopClientAttrib); \
  UnsupportedWrapper0(void, glPopMatrix); \
  UnsupportedWrapper0(void, glPopName); \
  UnsupportedWrapper13(void, glPresentFrameDualFillNV, GLuint, video_slot, GLuint64EXT, minPresentTime, GLuint, beginPresentTimeId, GLuint, presentDurationId, GLenum, type, GLenum, target0, GLuint, fill0, GLenum, target1, GLuint, fill1, GLenum, target2, GLuint, fill2, GLenum, target3, GLuint, fill3); \
  UnsupportedWrapper11(void, glPresentFrameKeyedNV, GLuint, video_slot, GLuint64EXT, minPresentTime, GLuint, beginPresentTimeId, GLuint, presentDurationId, GLenum, type, GLenum, target0, GLuint, fill0, GLuint, key0, GLenum, target1, GLuint, fill1, GLuint, key1); \
  UnsupportedWrapper1(void, glPrimitiveRestartIndexNV, GLuint, index); \
  UnsupportedWrapper0(void, glPrimitiveRestartNV); \
  UnsupportedWrapper3(void, glPrioritizeTexturesEXT, GLsizei, n, const GLuint *, textures, const GLclampf *, priorities); \
  UnsupportedWrapper3(void, glPrioritizeTextures, GLsizei, n, const GLuint *, textures, const GLfloat *, priorities); \
  UnsupportedWrapper3(void, glPrioritizeTexturesxOES, GLsizei, n, const GLuint *, textures, const GLfixed *, priorities); \
  UnsupportedWrapper4(void, glProgramBinaryOES, GLuint, program, GLenum, binaryFormat, const void *, binary, GLint, length); \
  UnsupportedWrapper5(void, glProgramBufferParametersfvNV, GLenum, target, GLuint, bindingIndex, GLuint, wordIndex, GLsizei, count, const GLfloat *, params); \
  UnsupportedWrapper5(void, glProgramBufferParametersIivNV, GLenum, target, GLuint, bindingIndex, GLuint, wordIndex, GLsizei, count, const GLint *, params); \
  UnsupportedWrapper5(void, glProgramBufferParametersIuivNV, GLenum, target, GLuint, bindingIndex, GLuint, wordIndex, GLsizei, count, const GLuint *, params); \
  UnsupportedWrapper6(void, glProgramEnvParameter4dARB, GLenum, target, GLuint, index, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  UnsupportedWrapper3(void, glProgramEnvParameter4dvARB, GLenum, target, GLuint, index, const GLdouble *, params); \
  UnsupportedWrapper6(void, glProgramEnvParameter4fARB, GLenum, target, GLuint, index, GLfloat, x, GLfloat, y, GLfloat, z, GLfloat, w); \
  UnsupportedWrapper3(void, glProgramEnvParameter4fvARB, GLenum, target, GLuint, index, const GLfloat *, params); \
  UnsupportedWrapper6(void, glProgramEnvParameterI4iNV, GLenum, target, GLuint, index, GLint, x, GLint, y, GLint, z, GLint, w); \
  UnsupportedWrapper3(void, glProgramEnvParameterI4ivNV, GLenum, target, GLuint, index, const GLint *, params); \
  UnsupportedWrapper6(void, glProgramEnvParameterI4uiNV, GLenum, target, GLuint, index, GLuint, x, GLuint, y, GLuint, z, GLuint, w); \
  UnsupportedWrapper3(void, glProgramEnvParameterI4uivNV, GLenum, target, GLuint, index, const GLuint *, params); \
  UnsupportedWrapper4(void, glProgramEnvParameters4fvEXT, GLenum, target, GLuint, index, GLsizei, count, const GLfloat *, params); \
  UnsupportedWrapper4(void, glProgramEnvParametersI4ivNV, GLenum, target, GLuint, index, GLsizei, count, const GLint *, params); \
  UnsupportedWrapper4(void, glProgramEnvParametersI4uivNV, GLenum, target, GLuint, index, GLsizei, count, const GLuint *, params); \
  UnsupportedWrapper6(void, glProgramLocalParameter4dARB, GLenum, target, GLuint, index, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  UnsupportedWrapper3(void, glProgramLocalParameter4dvARB, GLenum, target, GLuint, index, const GLdouble *, params); \
  UnsupportedWrapper6(void, glProgramLocalParameter4fARB, GLenum, target, GLuint, index, GLfloat, x, GLfloat, y, GLfloat, z, GLfloat, w); \
  UnsupportedWrapper3(void, glProgramLocalParameter4fvARB, GLenum, target, GLuint, index, const GLfloat *, params); \
  UnsupportedWrapper6(void, glProgramLocalParameterI4iNV, GLenum, target, GLuint, index, GLint, x, GLint, y, GLint, z, GLint, w); \
  UnsupportedWrapper3(void, glProgramLocalParameterI4ivNV, GLenum, target, GLuint, index, const GLint *, params); \
  UnsupportedWrapper6(void, glProgramLocalParameterI4uiNV, GLenum, target, GLuint, index, GLuint, x, GLuint, y, GLuint, z, GLuint, w); \
  UnsupportedWrapper3(void, glProgramLocalParameterI4uivNV, GLenum, target, GLuint, index, const GLuint *, params); \
  UnsupportedWrapper4(void, glProgramLocalParameters4fvEXT, GLenum, target, GLuint, index, GLsizei, count, const GLfloat *, params); \
  UnsupportedWrapper4(void, glProgramLocalParametersI4ivNV, GLenum, target, GLuint, index, GLsizei, count, const GLint *, params); \
  UnsupportedWrapper4(void, glProgramLocalParametersI4uivNV, GLenum, target, GLuint, index, GLsizei, count, const GLuint *, params); \
  UnsupportedWrapper7(void, glProgramNamedParameter4dNV, GLuint, id, GLsizei, len, const GLubyte *, name, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  UnsupportedWrapper4(void, glProgramNamedParameter4dvNV, GLuint, id, GLsizei, len, const GLubyte *, name, const GLdouble *, v); \
  UnsupportedWrapper7(void, glProgramNamedParameter4fNV, GLuint, id, GLsizei, len, const GLubyte *, name, GLfloat, x, GLfloat, y, GLfloat, z, GLfloat, w); \
  UnsupportedWrapper4(void, glProgramNamedParameter4fvNV, GLuint, id, GLsizei, len, const GLubyte *, name, const GLfloat *, v); \
  UnsupportedWrapper6(void, glProgramParameter4dNV, GLenum, target, GLuint, index, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  UnsupportedWrapper3(void, glProgramParameter4dvNV, GLenum, target, GLuint, index, const GLdouble *, v); \
  UnsupportedWrapper6(void, glProgramParameter4fNV, GLenum, target, GLuint, index, GLfloat, x, GLfloat, y, GLfloat, z, GLfloat, w); \
  UnsupportedWrapper3(void, glProgramParameter4fvNV, GLenum, target, GLuint, index, const GLfloat *, v); \
  UnsupportedWrapper4(void, glProgramParameters4dvNV, GLenum, target, GLuint, index, GLsizei, count, const GLdouble *, v); \
  UnsupportedWrapper4(void, glProgramParameters4fvNV, GLenum, target, GLuint, index, GLsizei, count, const GLfloat *, v); \
  UnsupportedWrapper5(void, glProgramPathFragmentInputGenNV, GLuint, program, GLint, location, GLenum, genMode, GLint, components, const GLfloat *, coeffs); \
  UnsupportedWrapper4(void, glProgramStringARB, GLenum, target, GLenum, format, GLsizei, len, const void *, string); \
  UnsupportedWrapper3(void, glProgramSubroutineParametersuivNV, GLenum, target, GLsizei, count, const GLuint *, params); \
  UnsupportedWrapper3(void, glProgramUniform1i64ARB, GLuint, program, GLint, location, GLint64, x); \
  UnsupportedWrapper3(void, glProgramUniform1i64NV, GLuint, program, GLint, location, GLint64EXT, x); \
  UnsupportedWrapper4(void, glProgramUniform1i64vARB, GLuint, program, GLint, location, GLsizei, count, const GLint64 *, value); \
  UnsupportedWrapper4(void, glProgramUniform1i64vNV, GLuint, program, GLint, location, GLsizei, count, const GLint64EXT *, value); \
  UnsupportedWrapper3(void, glProgramUniform1ui64ARB, GLuint, program, GLint, location, GLuint64, x); \
  UnsupportedWrapper3(void, glProgramUniform1ui64NV, GLuint, program, GLint, location, GLuint64EXT, x); \
  UnsupportedWrapper4(void, glProgramUniform1ui64vARB, GLuint, program, GLint, location, GLsizei, count, const GLuint64 *, value); \
  UnsupportedWrapper4(void, glProgramUniform1ui64vNV, GLuint, program, GLint, location, GLsizei, count, const GLuint64EXT *, value); \
  UnsupportedWrapper4(void, glProgramUniform2i64ARB, GLuint, program, GLint, location, GLint64, x, GLint64, y); \
  UnsupportedWrapper4(void, glProgramUniform2i64NV, GLuint, program, GLint, location, GLint64EXT, x, GLint64EXT, y); \
  UnsupportedWrapper4(void, glProgramUniform2i64vARB, GLuint, program, GLint, location, GLsizei, count, const GLint64 *, value); \
  UnsupportedWrapper4(void, glProgramUniform2i64vNV, GLuint, program, GLint, location, GLsizei, count, const GLint64EXT *, value); \
  UnsupportedWrapper4(void, glProgramUniform2ui64ARB, GLuint, program, GLint, location, GLuint64, x, GLuint64, y); \
  UnsupportedWrapper4(void, glProgramUniform2ui64NV, GLuint, program, GLint, location, GLuint64EXT, x, GLuint64EXT, y); \
  UnsupportedWrapper4(void, glProgramUniform2ui64vARB, GLuint, program, GLint, location, GLsizei, count, const GLuint64 *, value); \
  UnsupportedWrapper4(void, glProgramUniform2ui64vNV, GLuint, program, GLint, location, GLsizei, count, const GLuint64EXT *, value); \
  UnsupportedWrapper5(void, glProgramUniform3i64ARB, GLuint, program, GLint, location, GLint64, x, GLint64, y, GLint64, z); \
  UnsupportedWrapper5(void, glProgramUniform3i64NV, GLuint, program, GLint, location, GLint64EXT, x, GLint64EXT, y, GLint64EXT, z); \
  UnsupportedWrapper4(void, glProgramUniform3i64vARB, GLuint, program, GLint, location, GLsizei, count, const GLint64 *, value); \
  UnsupportedWrapper4(void, glProgramUniform3i64vNV, GLuint, program, GLint, location, GLsizei, count, const GLint64EXT *, value); \
  UnsupportedWrapper5(void, glProgramUniform3ui64ARB, GLuint, program, GLint, location, GLuint64, x, GLuint64, y, GLuint64, z); \
  UnsupportedWrapper5(void, glProgramUniform3ui64NV, GLuint, program, GLint, location, GLuint64EXT, x, GLuint64EXT, y, GLuint64EXT, z); \
  UnsupportedWrapper4(void, glProgramUniform3ui64vARB, GLuint, program, GLint, location, GLsizei, count, const GLuint64 *, value); \
  UnsupportedWrapper4(void, glProgramUniform3ui64vNV, GLuint, program, GLint, location, GLsizei, count, const GLuint64EXT *, value); \
  UnsupportedWrapper6(void, glProgramUniform4i64ARB, GLuint, program, GLint, location, GLint64, x, GLint64, y, GLint64, z, GLint64, w); \
  UnsupportedWrapper6(void, glProgramUniform4i64NV, GLuint, program, GLint, location, GLint64EXT, x, GLint64EXT, y, GLint64EXT, z, GLint64EXT, w); \
  UnsupportedWrapper4(void, glProgramUniform4i64vARB, GLuint, program, GLint, location, GLsizei, count, const GLint64 *, value); \
  UnsupportedWrapper4(void, glProgramUniform4i64vNV, GLuint, program, GLint, location, GLsizei, count, const GLint64EXT *, value); \
  UnsupportedWrapper6(void, glProgramUniform4ui64ARB, GLuint, program, GLint, location, GLuint64, x, GLuint64, y, GLuint64, z, GLuint64, w); \
  UnsupportedWrapper6(void, glProgramUniform4ui64NV, GLuint, program, GLint, location, GLuint64EXT, x, GLuint64EXT, y, GLuint64EXT, z, GLuint64EXT, w); \
  UnsupportedWrapper4(void, glProgramUniform4ui64vARB, GLuint, program, GLint, location, GLsizei, count, const GLuint64 *, value); \
  UnsupportedWrapper4(void, glProgramUniform4ui64vNV, GLuint, program, GLint, location, GLsizei, count, const GLuint64EXT *, value); \
  UnsupportedWrapper3(void, glProgramUniformHandleui64ARB, GLuint, program, GLint, location, GLuint64, value); \
  UnsupportedWrapper3(void, glProgramUniformHandleui64IMG, GLuint, program, GLint, location, GLuint64, value); \
  UnsupportedWrapper3(void, glProgramUniformHandleui64NV, GLuint, program, GLint, location, GLuint64, value); \
  UnsupportedWrapper4(void, glProgramUniformHandleui64vARB, GLuint, program, GLint, location, GLsizei, count, const GLuint64 *, values); \
  UnsupportedWrapper4(void, glProgramUniformHandleui64vIMG, GLuint, program, GLint, location, GLsizei, count, const GLuint64 *, values); \
  UnsupportedWrapper4(void, glProgramUniformHandleui64vNV, GLuint, program, GLint, location, GLsizei, count, const GLuint64 *, values); \
  UnsupportedWrapper3(void, glProgramUniformui64NV, GLuint, program, GLint, location, GLuint64EXT, value); \
  UnsupportedWrapper4(void, glProgramUniformui64vNV, GLuint, program, GLint, location, GLsizei, count, const GLuint64EXT *, value); \
  UnsupportedWrapper2(void, glProgramVertexLimitNV, GLenum, target, GLint, limit); \
  UnsupportedWrapper1(void, glPushAttrib, GLbitfield, mask); \
  UnsupportedWrapper1(void, glPushClientAttribDefaultEXT, GLbitfield, mask); \
  UnsupportedWrapper1(void, glPushClientAttrib, GLbitfield, mask); \
  UnsupportedWrapper0(void, glPushMatrix); \
  UnsupportedWrapper1(void, glPushName, GLuint, name); \
  UnsupportedWrapper2(GLbitfield, glQueryMatrixxOES, GLfixed *, mantissa, GLint *, exponent); \
  UnsupportedWrapper4(void, glQueryObjectParameteruiAMD, GLenum, target, GLuint, id, GLenum, pname, GLuint, param); \
  UnsupportedWrapper4(GLint, glQueryResourceNV, GLenum, queryType, GLint, tagId, GLuint, bufSize, GLint *, buffer); \
  UnsupportedWrapper2(void, glQueryResourceTagNV, GLint, tagId, const GLchar *, tagString); \
  UnsupportedWrapper2(void, glRasterPos2d, GLdouble, x, GLdouble, y); \
  UnsupportedWrapper1(void, glRasterPos2dv, const GLdouble *, v); \
  UnsupportedWrapper2(void, glRasterPos2f, GLfloat, x, GLfloat, y); \
  UnsupportedWrapper1(void, glRasterPos2fv, const GLfloat *, v); \
  UnsupportedWrapper2(void, glRasterPos2i, GLint, x, GLint, y); \
  UnsupportedWrapper1(void, glRasterPos2iv, const GLint *, v); \
  UnsupportedWrapper2(void, glRasterPos2s, GLshort, x, GLshort, y); \
  UnsupportedWrapper1(void, glRasterPos2sv, const GLshort *, v); \
  UnsupportedWrapper2(void, glRasterPos2xOES, GLfixed, x, GLfixed, y); \
  UnsupportedWrapper1(void, glRasterPos2xvOES, const GLfixed *, coords); \
  UnsupportedWrapper3(void, glRasterPos3d, GLdouble, x, GLdouble, y, GLdouble, z); \
  UnsupportedWrapper1(void, glRasterPos3dv, const GLdouble *, v); \
  UnsupportedWrapper3(void, glRasterPos3f, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper1(void, glRasterPos3fv, const GLfloat *, v); \
  UnsupportedWrapper3(void, glRasterPos3i, GLint, x, GLint, y, GLint, z); \
  UnsupportedWrapper1(void, glRasterPos3iv, const GLint *, v); \
  UnsupportedWrapper3(void, glRasterPos3s, GLshort, x, GLshort, y, GLshort, z); \
  UnsupportedWrapper1(void, glRasterPos3sv, const GLshort *, v); \
  UnsupportedWrapper3(void, glRasterPos3xOES, GLfixed, x, GLfixed, y, GLfixed, z); \
  UnsupportedWrapper1(void, glRasterPos3xvOES, const GLfixed *, coords); \
  UnsupportedWrapper4(void, glRasterPos4d, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  UnsupportedWrapper1(void, glRasterPos4dv, const GLdouble *, v); \
  UnsupportedWrapper4(void, glRasterPos4f, GLfloat, x, GLfloat, y, GLfloat, z, GLfloat, w); \
  UnsupportedWrapper1(void, glRasterPos4fv, const GLfloat *, v); \
  UnsupportedWrapper4(void, glRasterPos4i, GLint, x, GLint, y, GLint, z, GLint, w); \
  UnsupportedWrapper1(void, glRasterPos4iv, const GLint *, v); \
  UnsupportedWrapper4(void, glRasterPos4s, GLshort, x, GLshort, y, GLshort, z, GLshort, w); \
  UnsupportedWrapper1(void, glRasterPos4sv, const GLshort *, v); \
  UnsupportedWrapper4(void, glRasterPos4xOES, GLfixed, x, GLfixed, y, GLfixed, z, GLfixed, w); \
  UnsupportedWrapper1(void, glRasterPos4xvOES, const GLfixed *, coords); \
  UnsupportedWrapper2(void, glReadBufferIndexedEXT, GLenum, src, GLint, index); \
  UnsupportedWrapper1(void, glReadBufferNV, GLenum, mode); \
  UnsupportedWrapper1(void, glReadInstrumentsSGIX, GLint, marker); \
  UnsupportedWrapper8(void, glReadnPixelsKHR, GLint, x, GLint, y, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, GLsizei, bufSize, void *, data); \
  UnsupportedWrapper4(void, glRectd, GLdouble, x1, GLdouble, y1, GLdouble, x2, GLdouble, y2); \
  UnsupportedWrapper2(void, glRectdv, const GLdouble *, v1, const GLdouble *, v2); \
  UnsupportedWrapper4(void, glRectf, GLfloat, x1, GLfloat, y1, GLfloat, x2, GLfloat, y2); \
  UnsupportedWrapper2(void, glRectfv, const GLfloat *, v1, const GLfloat *, v2); \
  UnsupportedWrapper4(void, glRecti, GLint, x1, GLint, y1, GLint, x2, GLint, y2); \
  UnsupportedWrapper2(void, glRectiv, const GLint *, v1, const GLint *, v2); \
  UnsupportedWrapper4(void, glRects, GLshort, x1, GLshort, y1, GLshort, x2, GLshort, y2); \
  UnsupportedWrapper2(void, glRectsv, const GLshort *, v1, const GLshort *, v2); \
  UnsupportedWrapper4(void, glRectxOES, GLfixed, x1, GLfixed, y1, GLfixed, x2, GLfixed, y2); \
  UnsupportedWrapper2(void, glRectxvOES, const GLfixed *, v1, const GLfixed *, v2); \
  UnsupportedWrapper1(void, glReferencePlaneSGIX, const GLdouble *, equation); \
  UnsupportedWrapper5(void, glRenderbufferStorageMultisampleANGLE, GLenum, target, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  UnsupportedWrapper5(void, glRenderbufferStorageMultisampleAPPLE, GLenum, target, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  UnsupportedWrapper6(void, glRenderbufferStorageMultisampleCoverageNV, GLenum, target, GLsizei, coverageSamples, GLsizei, colorSamples, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  UnsupportedWrapper5(void, glRenderbufferStorageMultisampleIMG, GLenum, target, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  UnsupportedWrapper5(void, glRenderbufferStorageMultisampleNV, GLenum, target, GLsizei, samples, GLenum, internalformat, GLsizei, width, GLsizei, height); \
  UnsupportedWrapper1(void, glRenderGpuMaskNV, GLbitfield, mask); \
  UnsupportedWrapper1(GLint, glRenderMode, GLenum, mode); \
  UnsupportedWrapper3(void, glReplacementCodePointerSUN, GLenum, type, GLsizei, stride, const void **, pointer); \
  UnsupportedWrapper1(void, glReplacementCodeubSUN, GLubyte, code); \
  UnsupportedWrapper1(void, glReplacementCodeubvSUN, const GLubyte *, code); \
  UnsupportedWrapper7(void, glReplacementCodeuiColor3fVertex3fSUN, GLuint, rc, GLfloat, r, GLfloat, g, GLfloat, b, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper3(void, glReplacementCodeuiColor3fVertex3fvSUN, const GLuint *, rc, const GLfloat *, c, const GLfloat *, v); \
  UnsupportedWrapper11(void, glReplacementCodeuiColor4fNormal3fVertex3fSUN, GLuint, rc, GLfloat, r, GLfloat, g, GLfloat, b, GLfloat, a, GLfloat, nx, GLfloat, ny, GLfloat, nz, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper4(void, glReplacementCodeuiColor4fNormal3fVertex3fvSUN, const GLuint *, rc, const GLfloat *, c, const GLfloat *, n, const GLfloat *, v); \
  UnsupportedWrapper8(void, glReplacementCodeuiColor4ubVertex3fSUN, GLuint, rc, GLubyte, r, GLubyte, g, GLubyte, b, GLubyte, a, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper3(void, glReplacementCodeuiColor4ubVertex3fvSUN, const GLuint *, rc, const GLubyte *, c, const GLfloat *, v); \
  UnsupportedWrapper7(void, glReplacementCodeuiNormal3fVertex3fSUN, GLuint, rc, GLfloat, nx, GLfloat, ny, GLfloat, nz, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper3(void, glReplacementCodeuiNormal3fVertex3fvSUN, const GLuint *, rc, const GLfloat *, n, const GLfloat *, v); \
  UnsupportedWrapper1(void, glReplacementCodeuiSUN, GLuint, code); \
  UnsupportedWrapper13(void, glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN, GLuint, rc, GLfloat, s, GLfloat, t, GLfloat, r, GLfloat, g, GLfloat, b, GLfloat, a, GLfloat, nx, GLfloat, ny, GLfloat, nz, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper5(void, glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN, const GLuint *, rc, const GLfloat *, tc, const GLfloat *, c, const GLfloat *, n, const GLfloat *, v); \
  UnsupportedWrapper9(void, glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN, GLuint, rc, GLfloat, s, GLfloat, t, GLfloat, nx, GLfloat, ny, GLfloat, nz, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper4(void, glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN, const GLuint *, rc, const GLfloat *, tc, const GLfloat *, n, const GLfloat *, v); \
  UnsupportedWrapper6(void, glReplacementCodeuiTexCoord2fVertex3fSUN, GLuint, rc, GLfloat, s, GLfloat, t, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper3(void, glReplacementCodeuiTexCoord2fVertex3fvSUN, const GLuint *, rc, const GLfloat *, tc, const GLfloat *, v); \
  UnsupportedWrapper4(void, glReplacementCodeuiVertex3fSUN, GLuint, rc, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper2(void, glReplacementCodeuiVertex3fvSUN, const GLuint *, rc, const GLfloat *, v); \
  UnsupportedWrapper1(void, glReplacementCodeuivSUN, const GLuint *, code); \
  UnsupportedWrapper1(void, glReplacementCodeusSUN, GLushort, code); \
  UnsupportedWrapper1(void, glReplacementCodeusvSUN, const GLushort *, code); \
  UnsupportedWrapper2(void, glRequestResidentProgramsNV, GLsizei, n, const GLuint *, programs); \
  UnsupportedWrapper1(void, glResetHistogramEXT, GLenum, target); \
  UnsupportedWrapper1(void, glResetHistogram, GLenum, target); \
  UnsupportedWrapper1(void, glResetMinmaxEXT, GLenum, target); \
  UnsupportedWrapper1(void, glResetMinmax, GLenum, target); \
  UnsupportedWrapper0(void, glResizeBuffersMESA); \
  UnsupportedWrapper0(void, glResolveDepthValuesNV); \
  UnsupportedWrapper0(void, glResolveMultisampleFramebufferAPPLE); \
  UnsupportedWrapper0(void, glResumeTransformFeedbackNV); \
  UnsupportedWrapper4(void, glRotated, GLdouble, angle, GLdouble, x, GLdouble, y, GLdouble, z); \
  UnsupportedWrapper4(void, glRotatef, GLfloat, angle, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper4(void, glRotatexOES, GLfixed, angle, GLfixed, x, GLfixed, y, GLfixed, z); \
  UnsupportedWrapper3(void, glSampleMapATI, GLuint, dst, GLuint, interp, GLenum, swizzle); \
  UnsupportedWrapper2(void, glSampleMaskEXT, GLclampf, value, GLboolean, invert); \
  UnsupportedWrapper2(void, glSampleMaskIndexedNV, GLuint, index, GLbitfield, mask); \
  UnsupportedWrapper2(void, glSampleMaskSGIS, GLclampf, value, GLboolean, invert); \
  UnsupportedWrapper1(void, glSamplePatternEXT, GLenum, pattern); \
  UnsupportedWrapper1(void, glSamplePatternSGIS, GLenum, pattern); \
  UnsupportedWrapper3(void, glScaled, GLdouble, x, GLdouble, y, GLdouble, z); \
  UnsupportedWrapper3(void, glScalef, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper3(void, glScalexOES, GLfixed, x, GLfixed, y, GLfixed, z); \
  UnsupportedWrapper3(void, glSecondaryColor3bEXT, GLbyte, red, GLbyte, green, GLbyte, blue); \
  UnsupportedWrapper3(void, glSecondaryColor3b, GLbyte, red, GLbyte, green, GLbyte, blue); \
  UnsupportedWrapper1(void, glSecondaryColor3bvEXT, const GLbyte *, v); \
  UnsupportedWrapper1(void, glSecondaryColor3bv, const GLbyte *, v); \
  UnsupportedWrapper3(void, glSecondaryColor3dEXT, GLdouble, red, GLdouble, green, GLdouble, blue); \
  UnsupportedWrapper3(void, glSecondaryColor3d, GLdouble, red, GLdouble, green, GLdouble, blue); \
  UnsupportedWrapper1(void, glSecondaryColor3dvEXT, const GLdouble *, v); \
  UnsupportedWrapper1(void, glSecondaryColor3dv, const GLdouble *, v); \
  UnsupportedWrapper3(void, glSecondaryColor3fEXT, GLfloat, red, GLfloat, green, GLfloat, blue); \
  UnsupportedWrapper3(void, glSecondaryColor3f, GLfloat, red, GLfloat, green, GLfloat, blue); \
  UnsupportedWrapper1(void, glSecondaryColor3fvEXT, const GLfloat *, v); \
  UnsupportedWrapper1(void, glSecondaryColor3fv, const GLfloat *, v); \
  UnsupportedWrapper3(void, glSecondaryColor3hNV, GLhalfNV, red, GLhalfNV, green, GLhalfNV, blue); \
  UnsupportedWrapper1(void, glSecondaryColor3hvNV, const GLhalfNV *, v); \
  UnsupportedWrapper3(void, glSecondaryColor3iEXT, GLint, red, GLint, green, GLint, blue); \
  UnsupportedWrapper3(void, glSecondaryColor3i, GLint, red, GLint, green, GLint, blue); \
  UnsupportedWrapper1(void, glSecondaryColor3ivEXT, const GLint *, v); \
  UnsupportedWrapper1(void, glSecondaryColor3iv, const GLint *, v); \
  UnsupportedWrapper3(void, glSecondaryColor3sEXT, GLshort, red, GLshort, green, GLshort, blue); \
  UnsupportedWrapper3(void, glSecondaryColor3s, GLshort, red, GLshort, green, GLshort, blue); \
  UnsupportedWrapper1(void, glSecondaryColor3svEXT, const GLshort *, v); \
  UnsupportedWrapper1(void, glSecondaryColor3sv, const GLshort *, v); \
  UnsupportedWrapper3(void, glSecondaryColor3ubEXT, GLubyte, red, GLubyte, green, GLubyte, blue); \
  UnsupportedWrapper3(void, glSecondaryColor3ub, GLubyte, red, GLubyte, green, GLubyte, blue); \
  UnsupportedWrapper1(void, glSecondaryColor3ubvEXT, const GLubyte *, v); \
  UnsupportedWrapper1(void, glSecondaryColor3ubv, const GLubyte *, v); \
  UnsupportedWrapper3(void, glSecondaryColor3uiEXT, GLuint, red, GLuint, green, GLuint, blue); \
  UnsupportedWrapper3(void, glSecondaryColor3ui, GLuint, red, GLuint, green, GLuint, blue); \
  UnsupportedWrapper1(void, glSecondaryColor3uivEXT, const GLuint *, v); \
  UnsupportedWrapper1(void, glSecondaryColor3uiv, const GLuint *, v); \
  UnsupportedWrapper3(void, glSecondaryColor3usEXT, GLushort, red, GLushort, green, GLushort, blue); \
  UnsupportedWrapper3(void, glSecondaryColor3us, GLushort, red, GLushort, green, GLushort, blue); \
  UnsupportedWrapper1(void, glSecondaryColor3usvEXT, const GLushort *, v); \
  UnsupportedWrapper1(void, glSecondaryColor3usv, const GLushort *, v); \
  UnsupportedWrapper3(void, glSecondaryColorFormatNV, GLint, size, GLenum, type, GLsizei, stride); \
  UnsupportedWrapper2(void, glSecondaryColorP3ui, GLenum, type, GLuint, color); \
  UnsupportedWrapper2(void, glSecondaryColorP3uiv, GLenum, type, const GLuint *, color); \
  UnsupportedWrapper4(void, glSecondaryColorPointerEXT, GLint, size, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper5(void, glSecondaryColorPointerListIBM, GLint, size, GLenum, type, GLint, stride, const void **, pointer, GLint, ptrstride); \
  UnsupportedWrapper4(void, glSecondaryColorPointer, GLint, size, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper2(void, glSelectBuffer, GLsizei, size, GLuint *, buffer); \
  UnsupportedWrapper5(void, glSelectPerfMonitorCountersAMD, GLuint, monitor, GLboolean, enable, GLuint, group, GLint, numCounters, GLuint *, counterList); \
  UnsupportedWrapper8(void, glSeparableFilter2DEXT, GLenum, target, GLenum, internalformat, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, const void *, row, const void *, column); \
  UnsupportedWrapper8(void, glSeparableFilter2D, GLenum, target, GLenum, internalformat, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, const void *, row, const void *, column); \
  UnsupportedWrapper1(void, glSetFenceAPPLE, GLuint, fence); \
  UnsupportedWrapper2(void, glSetFenceNV, GLuint, fence, GLenum, condition); \
  UnsupportedWrapper2(void, glSetFragmentShaderConstantATI, GLuint, dst, const GLfloat *, value); \
  UnsupportedWrapper3(void, glSetInvariantEXT, GLuint, id, GLenum, type, const void *, addr); \
  UnsupportedWrapper3(void, glSetLocalConstantEXT, GLuint, id, GLenum, type, const void *, addr); \
  UnsupportedWrapper3(void, glSetMultisamplefvAMD, GLenum, pname, GLuint, index, const GLfloat *, val); \
  UnsupportedWrapper1(void, glShadeModel, GLenum, mode); \
  UnsupportedWrapper3(void, glShaderOp1EXT, GLenum, op, GLuint, res, GLuint, arg1); \
  UnsupportedWrapper4(void, glShaderOp2EXT, GLenum, op, GLuint, res, GLuint, arg1, GLuint, arg2); \
  UnsupportedWrapper5(void, glShaderOp3EXT, GLenum, op, GLuint, res, GLuint, arg1, GLuint, arg2, GLuint, arg3); \
  UnsupportedWrapper4(void, glShaderSourceARB, GLhandleARB, shaderObj, GLsizei, count, const GLcharARB **, string, const GLint *, length); \
  UnsupportedWrapper3(void, glSharpenTexFuncSGIS, GLenum, target, GLsizei, n, const GLfloat *, points); \
  UnsupportedWrapper1(void, glSignalVkFenceNV, GLuint64, vkFence); \
  UnsupportedWrapper1(void, glSignalVkSemaphoreNV, GLuint64, vkSemaphore); \
  UnsupportedWrapper2(void, glSpriteParameterfSGIX, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper2(void, glSpriteParameterfvSGIX, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper2(void, glSpriteParameteriSGIX, GLenum, pname, GLint, param); \
  UnsupportedWrapper2(void, glSpriteParameterivSGIX, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper0(void, glStartInstrumentsSGIX); \
  UnsupportedWrapper5(void, glStartTilingQCOM, GLuint, x, GLuint, y, GLuint, width, GLuint, height, GLbitfield, preserveMask); \
  UnsupportedWrapper2(void, glStateCaptureNV, GLuint, state, GLenum, mode); \
  UnsupportedWrapper2(void, glStencilClearTagEXT, GLsizei, stencilTagBits, GLuint, stencilClearTag); \
  UnsupportedWrapper8(void, glStencilFillPathInstancedNV, GLsizei, numPaths, GLenum, pathNameType, const void *, paths, GLuint, pathBase, GLenum, fillMode, GLuint, mask, GLenum, transformType, const GLfloat *, transformValues); \
  UnsupportedWrapper3(void, glStencilFillPathNV, GLuint, path, GLenum, fillMode, GLuint, mask); \
  UnsupportedWrapper4(void, glStencilFuncSeparateATI, GLenum, frontfunc, GLenum, backfunc, GLint, ref, GLuint, mask); \
  UnsupportedWrapper4(void, glStencilOpSeparateATI, GLenum, face, GLenum, sfail, GLenum, dpfail, GLenum, dppass); \
  UnsupportedWrapper2(void, glStencilOpValueAMD, GLenum, face, GLuint, value); \
  UnsupportedWrapper8(void, glStencilStrokePathInstancedNV, GLsizei, numPaths, GLenum, pathNameType, const void *, paths, GLuint, pathBase, GLint, reference, GLuint, mask, GLenum, transformType, const GLfloat *, transformValues); \
  UnsupportedWrapper3(void, glStencilStrokePathNV, GLuint, path, GLint, reference, GLuint, mask); \
  UnsupportedWrapper9(void, glStencilThenCoverFillPathInstancedNV, GLsizei, numPaths, GLenum, pathNameType, const void *, paths, GLuint, pathBase, GLenum, fillMode, GLuint, mask, GLenum, coverMode, GLenum, transformType, const GLfloat *, transformValues); \
  UnsupportedWrapper4(void, glStencilThenCoverFillPathNV, GLuint, path, GLenum, fillMode, GLuint, mask, GLenum, coverMode); \
  UnsupportedWrapper9(void, glStencilThenCoverStrokePathInstancedNV, GLsizei, numPaths, GLenum, pathNameType, const void *, paths, GLuint, pathBase, GLint, reference, GLuint, mask, GLenum, coverMode, GLenum, transformType, const GLfloat *, transformValues); \
  UnsupportedWrapper4(void, glStencilThenCoverStrokePathNV, GLuint, path, GLint, reference, GLuint, mask, GLenum, coverMode); \
  UnsupportedWrapper1(void, glStopInstrumentsSGIX, GLint, marker); \
  UnsupportedWrapper2(void, glSubpixelPrecisionBiasNV, GLuint, xbits, GLuint, ybits); \
  UnsupportedWrapper6(void, glSwizzleEXT, GLuint, res, GLuint, in, GLenum, outX, GLenum, outY, GLenum, outZ, GLenum, outW); \
  UnsupportedWrapper1(void, glSyncTextureINTEL, GLuint, texture); \
  UnsupportedWrapper0(void, glTagSampleBufferSGIX); \
  UnsupportedWrapper3(void, glTangent3bEXT, GLbyte, tx, GLbyte, ty, GLbyte, tz); \
  UnsupportedWrapper1(void, glTangent3bvEXT, const GLbyte *, v); \
  UnsupportedWrapper3(void, glTangent3dEXT, GLdouble, tx, GLdouble, ty, GLdouble, tz); \
  UnsupportedWrapper1(void, glTangent3dvEXT, const GLdouble *, v); \
  UnsupportedWrapper3(void, glTangent3fEXT, GLfloat, tx, GLfloat, ty, GLfloat, tz); \
  UnsupportedWrapper1(void, glTangent3fvEXT, const GLfloat *, v); \
  UnsupportedWrapper3(void, glTangent3iEXT, GLint, tx, GLint, ty, GLint, tz); \
  UnsupportedWrapper1(void, glTangent3ivEXT, const GLint *, v); \
  UnsupportedWrapper3(void, glTangent3sEXT, GLshort, tx, GLshort, ty, GLshort, tz); \
  UnsupportedWrapper1(void, glTangent3svEXT, const GLshort *, v); \
  UnsupportedWrapper3(void, glTangentPointerEXT, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper1(void, glTbufferMask3DFX, GLuint, mask); \
  UnsupportedWrapper1(void, glTessellationFactorAMD, GLfloat, factor); \
  UnsupportedWrapper1(void, glTessellationModeAMD, GLenum, mode); \
  UnsupportedWrapper1(GLboolean, glTestFenceAPPLE, GLuint, fence); \
  UnsupportedWrapper1(GLboolean, glTestFenceNV, GLuint, fence); \
  UnsupportedWrapper2(GLboolean, glTestObjectAPPLE, GLenum, object, GLuint, name); \
  UnsupportedWrapper2(void, glTexBumpParameterfvATI, GLenum, pname, const GLfloat *, param); \
  UnsupportedWrapper2(void, glTexBumpParameterivATI, GLenum, pname, const GLint *, param); \
  UnsupportedWrapper1(void, glTexCoord1bOES, GLbyte, s); \
  UnsupportedWrapper1(void, glTexCoord1bvOES, const GLbyte *, coords); \
  UnsupportedWrapper1(void, glTexCoord1d, GLdouble, s); \
  UnsupportedWrapper1(void, glTexCoord1dv, const GLdouble *, v); \
  UnsupportedWrapper1(void, glTexCoord1f, GLfloat, s); \
  UnsupportedWrapper1(void, glTexCoord1fv, const GLfloat *, v); \
  UnsupportedWrapper1(void, glTexCoord1hNV, GLhalfNV, s); \
  UnsupportedWrapper1(void, glTexCoord1hvNV, const GLhalfNV *, v); \
  UnsupportedWrapper1(void, glTexCoord1i, GLint, s); \
  UnsupportedWrapper1(void, glTexCoord1iv, const GLint *, v); \
  UnsupportedWrapper1(void, glTexCoord1s, GLshort, s); \
  UnsupportedWrapper1(void, glTexCoord1sv, const GLshort *, v); \
  UnsupportedWrapper1(void, glTexCoord1xOES, GLfixed, s); \
  UnsupportedWrapper1(void, glTexCoord1xvOES, const GLfixed *, coords); \
  UnsupportedWrapper2(void, glTexCoord2bOES, GLbyte, s, GLbyte, t); \
  UnsupportedWrapper1(void, glTexCoord2bvOES, const GLbyte *, coords); \
  UnsupportedWrapper2(void, glTexCoord2d, GLdouble, s, GLdouble, t); \
  UnsupportedWrapper1(void, glTexCoord2dv, const GLdouble *, v); \
  UnsupportedWrapper8(void, glTexCoord2fColor3fVertex3fSUN, GLfloat, s, GLfloat, t, GLfloat, r, GLfloat, g, GLfloat, b, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper3(void, glTexCoord2fColor3fVertex3fvSUN, const GLfloat *, tc, const GLfloat *, c, const GLfloat *, v); \
  UnsupportedWrapper12(void, glTexCoord2fColor4fNormal3fVertex3fSUN, GLfloat, s, GLfloat, t, GLfloat, r, GLfloat, g, GLfloat, b, GLfloat, a, GLfloat, nx, GLfloat, ny, GLfloat, nz, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper4(void, glTexCoord2fColor4fNormal3fVertex3fvSUN, const GLfloat *, tc, const GLfloat *, c, const GLfloat *, n, const GLfloat *, v); \
  UnsupportedWrapper9(void, glTexCoord2fColor4ubVertex3fSUN, GLfloat, s, GLfloat, t, GLubyte, r, GLubyte, g, GLubyte, b, GLubyte, a, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper3(void, glTexCoord2fColor4ubVertex3fvSUN, const GLfloat *, tc, const GLubyte *, c, const GLfloat *, v); \
  UnsupportedWrapper8(void, glTexCoord2fNormal3fVertex3fSUN, GLfloat, s, GLfloat, t, GLfloat, nx, GLfloat, ny, GLfloat, nz, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper3(void, glTexCoord2fNormal3fVertex3fvSUN, const GLfloat *, tc, const GLfloat *, n, const GLfloat *, v); \
  UnsupportedWrapper2(void, glTexCoord2f, GLfloat, s, GLfloat, t); \
  UnsupportedWrapper5(void, glTexCoord2fVertex3fSUN, GLfloat, s, GLfloat, t, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper2(void, glTexCoord2fVertex3fvSUN, const GLfloat *, tc, const GLfloat *, v); \
  UnsupportedWrapper1(void, glTexCoord2fv, const GLfloat *, v); \
  UnsupportedWrapper2(void, glTexCoord2hNV, GLhalfNV, s, GLhalfNV, t); \
  UnsupportedWrapper1(void, glTexCoord2hvNV, const GLhalfNV *, v); \
  UnsupportedWrapper2(void, glTexCoord2i, GLint, s, GLint, t); \
  UnsupportedWrapper1(void, glTexCoord2iv, const GLint *, v); \
  UnsupportedWrapper2(void, glTexCoord2s, GLshort, s, GLshort, t); \
  UnsupportedWrapper1(void, glTexCoord2sv, const GLshort *, v); \
  UnsupportedWrapper2(void, glTexCoord2xOES, GLfixed, s, GLfixed, t); \
  UnsupportedWrapper1(void, glTexCoord2xvOES, const GLfixed *, coords); \
  UnsupportedWrapper3(void, glTexCoord3bOES, GLbyte, s, GLbyte, t, GLbyte, r); \
  UnsupportedWrapper1(void, glTexCoord3bvOES, const GLbyte *, coords); \
  UnsupportedWrapper3(void, glTexCoord3d, GLdouble, s, GLdouble, t, GLdouble, r); \
  UnsupportedWrapper1(void, glTexCoord3dv, const GLdouble *, v); \
  UnsupportedWrapper3(void, glTexCoord3f, GLfloat, s, GLfloat, t, GLfloat, r); \
  UnsupportedWrapper1(void, glTexCoord3fv, const GLfloat *, v); \
  UnsupportedWrapper3(void, glTexCoord3hNV, GLhalfNV, s, GLhalfNV, t, GLhalfNV, r); \
  UnsupportedWrapper1(void, glTexCoord3hvNV, const GLhalfNV *, v); \
  UnsupportedWrapper3(void, glTexCoord3i, GLint, s, GLint, t, GLint, r); \
  UnsupportedWrapper1(void, glTexCoord3iv, const GLint *, v); \
  UnsupportedWrapper3(void, glTexCoord3s, GLshort, s, GLshort, t, GLshort, r); \
  UnsupportedWrapper1(void, glTexCoord3sv, const GLshort *, v); \
  UnsupportedWrapper3(void, glTexCoord3xOES, GLfixed, s, GLfixed, t, GLfixed, r); \
  UnsupportedWrapper1(void, glTexCoord3xvOES, const GLfixed *, coords); \
  UnsupportedWrapper4(void, glTexCoord4bOES, GLbyte, s, GLbyte, t, GLbyte, r, GLbyte, q); \
  UnsupportedWrapper1(void, glTexCoord4bvOES, const GLbyte *, coords); \
  UnsupportedWrapper4(void, glTexCoord4d, GLdouble, s, GLdouble, t, GLdouble, r, GLdouble, q); \
  UnsupportedWrapper1(void, glTexCoord4dv, const GLdouble *, v); \
  UnsupportedWrapper15(void, glTexCoord4fColor4fNormal3fVertex4fSUN, GLfloat, s, GLfloat, t, GLfloat, p, GLfloat, q, GLfloat, r, GLfloat, g, GLfloat, b, GLfloat, a, GLfloat, nx, GLfloat, ny, GLfloat, nz, GLfloat, x, GLfloat, y, GLfloat, z, GLfloat, w); \
  UnsupportedWrapper4(void, glTexCoord4fColor4fNormal3fVertex4fvSUN, const GLfloat *, tc, const GLfloat *, c, const GLfloat *, n, const GLfloat *, v); \
  UnsupportedWrapper4(void, glTexCoord4f, GLfloat, s, GLfloat, t, GLfloat, r, GLfloat, q); \
  UnsupportedWrapper8(void, glTexCoord4fVertex4fSUN, GLfloat, s, GLfloat, t, GLfloat, p, GLfloat, q, GLfloat, x, GLfloat, y, GLfloat, z, GLfloat, w); \
  UnsupportedWrapper2(void, glTexCoord4fVertex4fvSUN, const GLfloat *, tc, const GLfloat *, v); \
  UnsupportedWrapper1(void, glTexCoord4fv, const GLfloat *, v); \
  UnsupportedWrapper4(void, glTexCoord4hNV, GLhalfNV, s, GLhalfNV, t, GLhalfNV, r, GLhalfNV, q); \
  UnsupportedWrapper1(void, glTexCoord4hvNV, const GLhalfNV *, v); \
  UnsupportedWrapper4(void, glTexCoord4i, GLint, s, GLint, t, GLint, r, GLint, q); \
  UnsupportedWrapper1(void, glTexCoord4iv, const GLint *, v); \
  UnsupportedWrapper4(void, glTexCoord4s, GLshort, s, GLshort, t, GLshort, r, GLshort, q); \
  UnsupportedWrapper1(void, glTexCoord4sv, const GLshort *, v); \
  UnsupportedWrapper4(void, glTexCoord4xOES, GLfixed, s, GLfixed, t, GLfixed, r, GLfixed, q); \
  UnsupportedWrapper1(void, glTexCoord4xvOES, const GLfixed *, coords); \
  UnsupportedWrapper3(void, glTexCoordFormatNV, GLint, size, GLenum, type, GLsizei, stride); \
  UnsupportedWrapper2(void, glTexCoordP1ui, GLenum, type, GLuint, coords); \
  UnsupportedWrapper2(void, glTexCoordP1uiv, GLenum, type, const GLuint *, coords); \
  UnsupportedWrapper2(void, glTexCoordP2ui, GLenum, type, GLuint, coords); \
  UnsupportedWrapper2(void, glTexCoordP2uiv, GLenum, type, const GLuint *, coords); \
  UnsupportedWrapper2(void, glTexCoordP3ui, GLenum, type, GLuint, coords); \
  UnsupportedWrapper2(void, glTexCoordP3uiv, GLenum, type, const GLuint *, coords); \
  UnsupportedWrapper2(void, glTexCoordP4ui, GLenum, type, GLuint, coords); \
  UnsupportedWrapper2(void, glTexCoordP4uiv, GLenum, type, const GLuint *, coords); \
  UnsupportedWrapper5(void, glTexCoordPointerEXT, GLint, size, GLenum, type, GLsizei, stride, GLsizei, count, const void *, pointer); \
  UnsupportedWrapper5(void, glTexCoordPointerListIBM, GLint, size, GLenum, type, GLint, stride, const void **, pointer, GLint, ptrstride); \
  UnsupportedWrapper4(void, glTexCoordPointer, GLint, size, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper3(void, glTexCoordPointervINTEL, GLint, size, GLenum, type, const void **, pointer); \
  UnsupportedWrapper3(void, glTexEnvf, GLenum, target, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper3(void, glTexEnvfv, GLenum, target, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper3(void, glTexEnvi, GLenum, target, GLenum, pname, GLint, param); \
  UnsupportedWrapper3(void, glTexEnviv, GLenum, target, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper3(void, glTexEnvxOES, GLenum, target, GLenum, pname, GLfixed, param); \
  UnsupportedWrapper3(void, glTexEnvxvOES, GLenum, target, GLenum, pname, const GLfixed *, params); \
  UnsupportedWrapper4(void, glTexFilterFuncSGIS, GLenum, target, GLenum, filter, GLsizei, n, const GLfloat *, weights); \
  UnsupportedWrapper3(void, glTexGend, GLenum, coord, GLenum, pname, GLdouble, param); \
  UnsupportedWrapper3(void, glTexGendv, GLenum, coord, GLenum, pname, const GLdouble *, params); \
  UnsupportedWrapper3(void, glTexGenf, GLenum, coord, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper3(void, glTexGenfv, GLenum, coord, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper3(void, glTexGeni, GLenum, coord, GLenum, pname, GLint, param); \
  UnsupportedWrapper3(void, glTexGeniv, GLenum, coord, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper3(void, glTexGenxOES, GLenum, coord, GLenum, pname, GLfixed, param); \
  UnsupportedWrapper3(void, glTexGenxvOES, GLenum, coord, GLenum, pname, const GLfixed *, params); \
  UnsupportedWrapper7(void, glTexImage2DMultisampleCoverageNV, GLenum, target, GLsizei, coverageSamples, GLsizei, colorSamples, GLint, internalFormat, GLsizei, width, GLsizei, height, GLboolean, fixedSampleLocations); \
  UnsupportedWrapper8(void, glTexImage3DMultisampleCoverageNV, GLenum, target, GLsizei, coverageSamples, GLsizei, colorSamples, GLint, internalFormat, GLsizei, width, GLsizei, height, GLsizei, depth, GLboolean, fixedSampleLocations); \
  UnsupportedWrapper11(void, glTexImage4DSGIS, GLenum, target, GLint, level, GLenum, internalformat, GLsizei, width, GLsizei, height, GLsizei, depth, GLsizei, size4d, GLint, border, GLenum, format, GLenum, type, const void *, pixels); \
  UnsupportedWrapper9(void, glTexPageCommitmentARB, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLboolean, commit); \
  UnsupportedWrapper9(void, glTexPageCommitmentEXT, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLboolean, commit); \
  UnsupportedWrapper3(void, glTexParameterxOES, GLenum, target, GLenum, pname, GLfixed, param); \
  UnsupportedWrapper3(void, glTexParameterxvOES, GLenum, target, GLenum, pname, const GLfixed *, params); \
  UnsupportedWrapper2(void, glTexRenderbufferNV, GLenum, target, GLuint, renderbuffer); \
  UnsupportedWrapper7(void, glTexStorageSparseAMD, GLenum, target, GLenum, internalFormat, GLsizei, width, GLsizei, height, GLsizei, depth, GLsizei, layers, GLbitfield, flags); \
  UnsupportedWrapper7(void, glTexSubImage1DEXT, GLenum, target, GLint, level, GLint, xoffset, GLsizei, width, GLenum, format, GLenum, type, const void *, pixels); \
  UnsupportedWrapper9(void, glTexSubImage2DEXT, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLsizei, width, GLsizei, height, GLenum, format, GLenum, type, const void *, pixels); \
  UnsupportedWrapper11(void, glTexSubImage3DEXT, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLenum, format, GLenum, type, const void *, pixels); \
  UnsupportedWrapper13(void, glTexSubImage4DSGIS, GLenum, target, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLint, woffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLsizei, size4d, GLenum, format, GLenum, type, const void *, pixels); \
  UnsupportedWrapper0(void, glTextureBarrierNV); \
  UnsupportedWrapper4(void, glTextureColorMaskSGIS, GLboolean, red, GLboolean, green, GLboolean, blue, GLboolean, alpha); \
  UnsupportedWrapper8(void, glTextureImage2DMultisampleCoverageNV, GLuint, texture, GLenum, target, GLsizei, coverageSamples, GLsizei, colorSamples, GLint, internalFormat, GLsizei, width, GLsizei, height, GLboolean, fixedSampleLocations); \
  UnsupportedWrapper7(void, glTextureImage2DMultisampleNV, GLuint, texture, GLenum, target, GLsizei, samples, GLint, internalFormat, GLsizei, width, GLsizei, height, GLboolean, fixedSampleLocations); \
  UnsupportedWrapper9(void, glTextureImage3DMultisampleCoverageNV, GLuint, texture, GLenum, target, GLsizei, coverageSamples, GLsizei, colorSamples, GLint, internalFormat, GLsizei, width, GLsizei, height, GLsizei, depth, GLboolean, fixedSampleLocations); \
  UnsupportedWrapper8(void, glTextureImage3DMultisampleNV, GLuint, texture, GLenum, target, GLsizei, samples, GLint, internalFormat, GLsizei, width, GLsizei, height, GLsizei, depth, GLboolean, fixedSampleLocations); \
  UnsupportedWrapper1(void, glTextureLightEXT, GLenum, pname); \
  UnsupportedWrapper2(void, glTextureMaterialEXT, GLenum, face, GLenum, mode); \
  UnsupportedWrapper1(void, glTextureNormalEXT, GLenum, mode); \
  UnsupportedWrapper9(void, glTexturePageCommitmentEXT, GLuint, texture, GLint, level, GLint, xoffset, GLint, yoffset, GLint, zoffset, GLsizei, width, GLsizei, height, GLsizei, depth, GLboolean, commit); \
  UnsupportedWrapper3(void, glTextureRangeAPPLE, GLenum, target, GLsizei, length, const void *, pointer); \
  UnsupportedWrapper3(void, glTextureRenderbufferEXT, GLuint, texture, GLenum, target, GLuint, renderbuffer); \
  UnsupportedWrapper8(void, glTextureStorageSparseAMD, GLuint, texture, GLenum, target, GLenum, internalFormat, GLsizei, width, GLsizei, height, GLsizei, depth, GLsizei, layers, GLbitfield, flags); \
  UnsupportedWrapper4(void, glTrackMatrixNV, GLenum, target, GLuint, address, GLenum, matrix, GLenum, transform); \
  UnsupportedWrapper3(void, glTransformFeedbackAttribsNV, GLsizei, count, const GLint *, attribs, GLenum, bufferMode); \
  UnsupportedWrapper5(void, glTransformFeedbackStreamAttribsNV, GLsizei, count, const GLint *, attribs, GLsizei, nbuffers, const GLint *, bufstreams, GLenum, bufferMode); \
  UnsupportedWrapper4(void, glTransformFeedbackVaryingsNV, GLuint, program, GLsizei, count, const GLint *, locations, GLenum, bufferMode); \
  UnsupportedWrapper4(void, glTransformPathNV, GLuint, resultPath, GLuint, srcPath, GLenum, transformType, const GLfloat *, transformValues); \
  UnsupportedWrapper3(void, glTranslated, GLdouble, x, GLdouble, y, GLdouble, z); \
  UnsupportedWrapper3(void, glTranslatef, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper3(void, glTranslatexOES, GLfixed, x, GLfixed, y, GLfixed, z); \
  UnsupportedWrapper2(void, glUniform1i64ARB, GLint, location, GLint64, x); \
  UnsupportedWrapper2(void, glUniform1i64NV, GLint, location, GLint64EXT, x); \
  UnsupportedWrapper3(void, glUniform1i64vARB, GLint, location, GLsizei, count, const GLint64 *, value); \
  UnsupportedWrapper3(void, glUniform1i64vNV, GLint, location, GLsizei, count, const GLint64EXT *, value); \
  UnsupportedWrapper2(void, glUniform1ui64ARB, GLint, location, GLuint64, x); \
  UnsupportedWrapper2(void, glUniform1ui64NV, GLint, location, GLuint64EXT, x); \
  UnsupportedWrapper3(void, glUniform1ui64vARB, GLint, location, GLsizei, count, const GLuint64 *, value); \
  UnsupportedWrapper3(void, glUniform1ui64vNV, GLint, location, GLsizei, count, const GLuint64EXT *, value); \
  UnsupportedWrapper3(void, glUniform2i64ARB, GLint, location, GLint64, x, GLint64, y); \
  UnsupportedWrapper3(void, glUniform2i64NV, GLint, location, GLint64EXT, x, GLint64EXT, y); \
  UnsupportedWrapper3(void, glUniform2i64vARB, GLint, location, GLsizei, count, const GLint64 *, value); \
  UnsupportedWrapper3(void, glUniform2i64vNV, GLint, location, GLsizei, count, const GLint64EXT *, value); \
  UnsupportedWrapper3(void, glUniform2ui64ARB, GLint, location, GLuint64, x, GLuint64, y); \
  UnsupportedWrapper3(void, glUniform2ui64NV, GLint, location, GLuint64EXT, x, GLuint64EXT, y); \
  UnsupportedWrapper3(void, glUniform2ui64vARB, GLint, location, GLsizei, count, const GLuint64 *, value); \
  UnsupportedWrapper3(void, glUniform2ui64vNV, GLint, location, GLsizei, count, const GLuint64EXT *, value); \
  UnsupportedWrapper4(void, glUniform3i64ARB, GLint, location, GLint64, x, GLint64, y, GLint64, z); \
  UnsupportedWrapper4(void, glUniform3i64NV, GLint, location, GLint64EXT, x, GLint64EXT, y, GLint64EXT, z); \
  UnsupportedWrapper3(void, glUniform3i64vARB, GLint, location, GLsizei, count, const GLint64 *, value); \
  UnsupportedWrapper3(void, glUniform3i64vNV, GLint, location, GLsizei, count, const GLint64EXT *, value); \
  UnsupportedWrapper4(void, glUniform3ui64ARB, GLint, location, GLuint64, x, GLuint64, y, GLuint64, z); \
  UnsupportedWrapper4(void, glUniform3ui64NV, GLint, location, GLuint64EXT, x, GLuint64EXT, y, GLuint64EXT, z); \
  UnsupportedWrapper3(void, glUniform3ui64vARB, GLint, location, GLsizei, count, const GLuint64 *, value); \
  UnsupportedWrapper3(void, glUniform3ui64vNV, GLint, location, GLsizei, count, const GLuint64EXT *, value); \
  UnsupportedWrapper5(void, glUniform4i64ARB, GLint, location, GLint64, x, GLint64, y, GLint64, z, GLint64, w); \
  UnsupportedWrapper5(void, glUniform4i64NV, GLint, location, GLint64EXT, x, GLint64EXT, y, GLint64EXT, z, GLint64EXT, w); \
  UnsupportedWrapper3(void, glUniform4i64vARB, GLint, location, GLsizei, count, const GLint64 *, value); \
  UnsupportedWrapper3(void, glUniform4i64vNV, GLint, location, GLsizei, count, const GLint64EXT *, value); \
  UnsupportedWrapper5(void, glUniform4ui64ARB, GLint, location, GLuint64, x, GLuint64, y, GLuint64, z, GLuint64, w); \
  UnsupportedWrapper5(void, glUniform4ui64NV, GLint, location, GLuint64EXT, x, GLuint64EXT, y, GLuint64EXT, z, GLuint64EXT, w); \
  UnsupportedWrapper3(void, glUniform4ui64vARB, GLint, location, GLsizei, count, const GLuint64 *, value); \
  UnsupportedWrapper3(void, glUniform4ui64vNV, GLint, location, GLsizei, count, const GLuint64EXT *, value); \
  UnsupportedWrapper3(void, glUniformBufferEXT, GLuint, program, GLint, location, GLuint, buffer); \
  UnsupportedWrapper2(void, glUniformHandleui64ARB, GLint, location, GLuint64, value); \
  UnsupportedWrapper2(void, glUniformHandleui64IMG, GLint, location, GLuint64, value); \
  UnsupportedWrapper2(void, glUniformHandleui64NV, GLint, location, GLuint64, value); \
  UnsupportedWrapper3(void, glUniformHandleui64vARB, GLint, location, GLsizei, count, const GLuint64 *, value); \
  UnsupportedWrapper3(void, glUniformHandleui64vIMG, GLint, location, GLsizei, count, const GLuint64 *, value); \
  UnsupportedWrapper3(void, glUniformHandleui64vNV, GLint, location, GLsizei, count, const GLuint64 *, value); \
  UnsupportedWrapper4(void, glUniformMatrix2x3fvNV, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  UnsupportedWrapper4(void, glUniformMatrix2x4fvNV, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  UnsupportedWrapper4(void, glUniformMatrix3x2fvNV, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  UnsupportedWrapper4(void, glUniformMatrix3x4fvNV, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  UnsupportedWrapper4(void, glUniformMatrix4x2fvNV, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  UnsupportedWrapper4(void, glUniformMatrix4x3fvNV, GLint, location, GLsizei, count, GLboolean, transpose, const GLfloat *, value); \
  UnsupportedWrapper2(void, glUniformui64NV, GLint, location, GLuint64EXT, value); \
  UnsupportedWrapper3(void, glUniformui64vNV, GLint, location, GLsizei, count, const GLuint64EXT *, value); \
  UnsupportedWrapper0(void, glUnlockArraysEXT); \
  UnsupportedWrapper1(void, glUnmapObjectBufferATI, GLuint, buffer); \
  UnsupportedWrapper2(void, glUnmapTexture2DINTEL, GLuint, texture, GLint, level); \
  UnsupportedWrapper5(void, glUpdateObjectBufferATI, GLuint, buffer, GLuint, offset, GLsizei, size, const void *, pointer, GLenum, preserve); \
  UnsupportedWrapper1(void, glUseProgramObjectARB, GLhandleARB, programObj); \
  UnsupportedWrapper2(void, glUseShaderProgramEXT, GLenum, type, GLuint, program); \
  UnsupportedWrapper1(void, glValidateProgramARB, GLhandleARB, programObj); \
  UnsupportedWrapper5(void, glVariantArrayObjectATI, GLuint, id, GLenum, type, GLsizei, stride, GLuint, buffer, GLuint, offset); \
  UnsupportedWrapper2(void, glVariantbvEXT, GLuint, id, const GLbyte *, addr); \
  UnsupportedWrapper2(void, glVariantdvEXT, GLuint, id, const GLdouble *, addr); \
  UnsupportedWrapper2(void, glVariantfvEXT, GLuint, id, const GLfloat *, addr); \
  UnsupportedWrapper2(void, glVariantivEXT, GLuint, id, const GLint *, addr); \
  UnsupportedWrapper4(void, glVariantPointerEXT, GLuint, id, GLenum, type, GLuint, stride, const void *, addr); \
  UnsupportedWrapper2(void, glVariantsvEXT, GLuint, id, const GLshort *, addr); \
  UnsupportedWrapper2(void, glVariantubvEXT, GLuint, id, const GLubyte *, addr); \
  UnsupportedWrapper2(void, glVariantuivEXT, GLuint, id, const GLuint *, addr); \
  UnsupportedWrapper2(void, glVariantusvEXT, GLuint, id, const GLushort *, addr); \
  UnsupportedWrapper0(void, glVDPAUFiniNV); \
  UnsupportedWrapper5(void, glVDPAUGetSurfaceivNV, GLvdpauSurfaceNV, surface, GLenum, pname, GLsizei, bufSize, GLsizei *, length, GLint *, values); \
  UnsupportedWrapper2(void, glVDPAUInitNV, const void *, vdpDevice, const void *, getProcAddress); \
  UnsupportedWrapper1(GLboolean, glVDPAUIsSurfaceNV, GLvdpauSurfaceNV, surface); \
  UnsupportedWrapper2(void, glVDPAUMapSurfacesNV, GLsizei, numSurfaces, const GLvdpauSurfaceNV *, surfaces); \
  UnsupportedWrapper4(GLvdpauSurfaceNV, glVDPAURegisterOutputSurfaceNV, const void *, vdpSurface, GLenum, target, GLsizei, numTextureNames, const GLuint *, textureNames); \
  UnsupportedWrapper4(GLvdpauSurfaceNV, glVDPAURegisterVideoSurfaceNV, const void *, vdpSurface, GLenum, target, GLsizei, numTextureNames, const GLuint *, textureNames); \
  UnsupportedWrapper2(void, glVDPAUSurfaceAccessNV, GLvdpauSurfaceNV, surface, GLenum, access); \
  UnsupportedWrapper2(void, glVDPAUUnmapSurfacesNV, GLsizei, numSurface, const GLvdpauSurfaceNV *, surfaces); \
  UnsupportedWrapper1(void, glVDPAUUnregisterSurfaceNV, GLvdpauSurfaceNV, surface); \
  UnsupportedWrapper2(void, glVertex2bOES, GLbyte, x, GLbyte, y); \
  UnsupportedWrapper1(void, glVertex2bvOES, const GLbyte *, coords); \
  UnsupportedWrapper2(void, glVertex2d, GLdouble, x, GLdouble, y); \
  UnsupportedWrapper1(void, glVertex2dv, const GLdouble *, v); \
  UnsupportedWrapper2(void, glVertex2f, GLfloat, x, GLfloat, y); \
  UnsupportedWrapper1(void, glVertex2fv, const GLfloat *, v); \
  UnsupportedWrapper2(void, glVertex2hNV, GLhalfNV, x, GLhalfNV, y); \
  UnsupportedWrapper1(void, glVertex2hvNV, const GLhalfNV *, v); \
  UnsupportedWrapper2(void, glVertex2i, GLint, x, GLint, y); \
  UnsupportedWrapper1(void, glVertex2iv, const GLint *, v); \
  UnsupportedWrapper2(void, glVertex2s, GLshort, x, GLshort, y); \
  UnsupportedWrapper1(void, glVertex2sv, const GLshort *, v); \
  UnsupportedWrapper1(void, glVertex2xOES, GLfixed, x); \
  UnsupportedWrapper1(void, glVertex2xvOES, const GLfixed *, coords); \
  UnsupportedWrapper3(void, glVertex3bOES, GLbyte, x, GLbyte, y, GLbyte, z); \
  UnsupportedWrapper1(void, glVertex3bvOES, const GLbyte *, coords); \
  UnsupportedWrapper3(void, glVertex3d, GLdouble, x, GLdouble, y, GLdouble, z); \
  UnsupportedWrapper1(void, glVertex3dv, const GLdouble *, v); \
  UnsupportedWrapper3(void, glVertex3f, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper1(void, glVertex3fv, const GLfloat *, v); \
  UnsupportedWrapper3(void, glVertex3hNV, GLhalfNV, x, GLhalfNV, y, GLhalfNV, z); \
  UnsupportedWrapper1(void, glVertex3hvNV, const GLhalfNV *, v); \
  UnsupportedWrapper3(void, glVertex3i, GLint, x, GLint, y, GLint, z); \
  UnsupportedWrapper1(void, glVertex3iv, const GLint *, v); \
  UnsupportedWrapper3(void, glVertex3s, GLshort, x, GLshort, y, GLshort, z); \
  UnsupportedWrapper1(void, glVertex3sv, const GLshort *, v); \
  UnsupportedWrapper2(void, glVertex3xOES, GLfixed, x, GLfixed, y); \
  UnsupportedWrapper1(void, glVertex3xvOES, const GLfixed *, coords); \
  UnsupportedWrapper4(void, glVertex4bOES, GLbyte, x, GLbyte, y, GLbyte, z, GLbyte, w); \
  UnsupportedWrapper1(void, glVertex4bvOES, const GLbyte *, coords); \
  UnsupportedWrapper4(void, glVertex4d, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  UnsupportedWrapper1(void, glVertex4dv, const GLdouble *, v); \
  UnsupportedWrapper4(void, glVertex4f, GLfloat, x, GLfloat, y, GLfloat, z, GLfloat, w); \
  UnsupportedWrapper1(void, glVertex4fv, const GLfloat *, v); \
  UnsupportedWrapper4(void, glVertex4hNV, GLhalfNV, x, GLhalfNV, y, GLhalfNV, z, GLhalfNV, w); \
  UnsupportedWrapper1(void, glVertex4hvNV, const GLhalfNV *, v); \
  UnsupportedWrapper4(void, glVertex4i, GLint, x, GLint, y, GLint, z, GLint, w); \
  UnsupportedWrapper1(void, glVertex4iv, const GLint *, v); \
  UnsupportedWrapper4(void, glVertex4s, GLshort, x, GLshort, y, GLshort, z, GLshort, w); \
  UnsupportedWrapper1(void, glVertex4sv, const GLshort *, v); \
  UnsupportedWrapper3(void, glVertex4xOES, GLfixed, x, GLfixed, y, GLfixed, z); \
  UnsupportedWrapper1(void, glVertex4xvOES, const GLfixed *, coords); \
  UnsupportedWrapper6(void, glVertexArrayColorOffsetEXT, GLuint, vaobj, GLuint, buffer, GLint, size, GLenum, type, GLsizei, stride, GLintptr, offset); \
  UnsupportedWrapper4(void, glVertexArrayEdgeFlagOffsetEXT, GLuint, vaobj, GLuint, buffer, GLsizei, stride, GLintptr, offset); \
  UnsupportedWrapper5(void, glVertexArrayFogCoordOffsetEXT, GLuint, vaobj, GLuint, buffer, GLenum, type, GLsizei, stride, GLintptr, offset); \
  UnsupportedWrapper5(void, glVertexArrayIndexOffsetEXT, GLuint, vaobj, GLuint, buffer, GLenum, type, GLsizei, stride, GLintptr, offset); \
  UnsupportedWrapper7(void, glVertexArrayMultiTexCoordOffsetEXT, GLuint, vaobj, GLuint, buffer, GLenum, texunit, GLint, size, GLenum, type, GLsizei, stride, GLintptr, offset); \
  UnsupportedWrapper5(void, glVertexArrayNormalOffsetEXT, GLuint, vaobj, GLuint, buffer, GLenum, type, GLsizei, stride, GLintptr, offset); \
  UnsupportedWrapper2(void, glVertexArrayParameteriAPPLE, GLenum, pname, GLint, param); \
  UnsupportedWrapper2(void, glVertexArrayRangeAPPLE, GLsizei, length, void *, pointer); \
  UnsupportedWrapper2(void, glVertexArrayRangeNV, GLsizei, length, const void *, pointer); \
  UnsupportedWrapper6(void, glVertexArraySecondaryColorOffsetEXT, GLuint, vaobj, GLuint, buffer, GLint, size, GLenum, type, GLsizei, stride, GLintptr, offset); \
  UnsupportedWrapper6(void, glVertexArrayTexCoordOffsetEXT, GLuint, vaobj, GLuint, buffer, GLint, size, GLenum, type, GLsizei, stride, GLintptr, offset); \
  UnsupportedWrapper6(void, glVertexArrayVertexOffsetEXT, GLuint, vaobj, GLuint, buffer, GLint, size, GLenum, type, GLsizei, stride, GLintptr, offset); \
  UnsupportedWrapper2(void, glVertexAttrib1dNV, GLuint, index, GLdouble, x); \
  UnsupportedWrapper2(void, glVertexAttrib1dvNV, GLuint, index, const GLdouble *, v); \
  UnsupportedWrapper2(void, glVertexAttrib1fNV, GLuint, index, GLfloat, x); \
  UnsupportedWrapper2(void, glVertexAttrib1fvNV, GLuint, index, const GLfloat *, v); \
  UnsupportedWrapper2(void, glVertexAttrib1hNV, GLuint, index, GLhalfNV, x); \
  UnsupportedWrapper2(void, glVertexAttrib1hvNV, GLuint, index, const GLhalfNV *, v); \
  UnsupportedWrapper2(void, glVertexAttrib1sNV, GLuint, index, GLshort, x); \
  UnsupportedWrapper2(void, glVertexAttrib1svNV, GLuint, index, const GLshort *, v); \
  UnsupportedWrapper3(void, glVertexAttrib2dNV, GLuint, index, GLdouble, x, GLdouble, y); \
  UnsupportedWrapper2(void, glVertexAttrib2dvNV, GLuint, index, const GLdouble *, v); \
  UnsupportedWrapper3(void, glVertexAttrib2fNV, GLuint, index, GLfloat, x, GLfloat, y); \
  UnsupportedWrapper2(void, glVertexAttrib2fvNV, GLuint, index, const GLfloat *, v); \
  UnsupportedWrapper3(void, glVertexAttrib2hNV, GLuint, index, GLhalfNV, x, GLhalfNV, y); \
  UnsupportedWrapper2(void, glVertexAttrib2hvNV, GLuint, index, const GLhalfNV *, v); \
  UnsupportedWrapper3(void, glVertexAttrib2sNV, GLuint, index, GLshort, x, GLshort, y); \
  UnsupportedWrapper2(void, glVertexAttrib2svNV, GLuint, index, const GLshort *, v); \
  UnsupportedWrapper4(void, glVertexAttrib3dNV, GLuint, index, GLdouble, x, GLdouble, y, GLdouble, z); \
  UnsupportedWrapper2(void, glVertexAttrib3dvNV, GLuint, index, const GLdouble *, v); \
  UnsupportedWrapper4(void, glVertexAttrib3fNV, GLuint, index, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper2(void, glVertexAttrib3fvNV, GLuint, index, const GLfloat *, v); \
  UnsupportedWrapper4(void, glVertexAttrib3hNV, GLuint, index, GLhalfNV, x, GLhalfNV, y, GLhalfNV, z); \
  UnsupportedWrapper2(void, glVertexAttrib3hvNV, GLuint, index, const GLhalfNV *, v); \
  UnsupportedWrapper4(void, glVertexAttrib3sNV, GLuint, index, GLshort, x, GLshort, y, GLshort, z); \
  UnsupportedWrapper2(void, glVertexAttrib3svNV, GLuint, index, const GLshort *, v); \
  UnsupportedWrapper5(void, glVertexAttrib4dNV, GLuint, index, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  UnsupportedWrapper2(void, glVertexAttrib4dvNV, GLuint, index, const GLdouble *, v); \
  UnsupportedWrapper5(void, glVertexAttrib4fNV, GLuint, index, GLfloat, x, GLfloat, y, GLfloat, z, GLfloat, w); \
  UnsupportedWrapper2(void, glVertexAttrib4fvNV, GLuint, index, const GLfloat *, v); \
  UnsupportedWrapper5(void, glVertexAttrib4hNV, GLuint, index, GLhalfNV, x, GLhalfNV, y, GLhalfNV, z, GLhalfNV, w); \
  UnsupportedWrapper2(void, glVertexAttrib4hvNV, GLuint, index, const GLhalfNV *, v); \
  UnsupportedWrapper5(void, glVertexAttrib4NubARB, GLuint, index, GLubyte, x, GLubyte, y, GLubyte, z, GLubyte, w); \
  UnsupportedWrapper5(void, glVertexAttrib4sNV, GLuint, index, GLshort, x, GLshort, y, GLshort, z, GLshort, w); \
  UnsupportedWrapper2(void, glVertexAttrib4svNV, GLuint, index, const GLshort *, v); \
  UnsupportedWrapper5(void, glVertexAttrib4ubNV, GLuint, index, GLubyte, x, GLubyte, y, GLubyte, z, GLubyte, w); \
  UnsupportedWrapper2(void, glVertexAttrib4ubvNV, GLuint, index, const GLubyte *, v); \
  UnsupportedWrapper7(void, glVertexAttribArrayObjectATI, GLuint, index, GLint, size, GLenum, type, GLboolean, normalized, GLsizei, stride, GLuint, buffer, GLuint, offset); \
  UnsupportedWrapper2(void, glVertexAttribDivisorANGLE, GLuint, index, GLuint, divisor); \
  UnsupportedWrapper2(void, glVertexAttribDivisorEXT, GLuint, index, GLuint, divisor); \
  UnsupportedWrapper2(void, glVertexAttribDivisorNV, GLuint, index, GLuint, divisor); \
  UnsupportedWrapper5(void, glVertexAttribFormatNV, GLuint, index, GLint, size, GLenum, type, GLboolean, normalized, GLsizei, stride); \
  UnsupportedWrapper4(void, glVertexAttribIFormatNV, GLuint, index, GLint, size, GLenum, type, GLsizei, stride); \
  UnsupportedWrapper2(void, glVertexAttribL1i64NV, GLuint, index, GLint64EXT, x); \
  UnsupportedWrapper2(void, glVertexAttribL1i64vNV, GLuint, index, const GLint64EXT *, v); \
  UnsupportedWrapper2(void, glVertexAttribL1ui64ARB, GLuint, index, GLuint64EXT, x); \
  UnsupportedWrapper2(void, glVertexAttribL1ui64NV, GLuint, index, GLuint64EXT, x); \
  UnsupportedWrapper2(void, glVertexAttribL1ui64vARB, GLuint, index, const GLuint64EXT *, v); \
  UnsupportedWrapper2(void, glVertexAttribL1ui64vNV, GLuint, index, const GLuint64EXT *, v); \
  UnsupportedWrapper3(void, glVertexAttribL2i64NV, GLuint, index, GLint64EXT, x, GLint64EXT, y); \
  UnsupportedWrapper2(void, glVertexAttribL2i64vNV, GLuint, index, const GLint64EXT *, v); \
  UnsupportedWrapper3(void, glVertexAttribL2ui64NV, GLuint, index, GLuint64EXT, x, GLuint64EXT, y); \
  UnsupportedWrapper2(void, glVertexAttribL2ui64vNV, GLuint, index, const GLuint64EXT *, v); \
  UnsupportedWrapper4(void, glVertexAttribL3i64NV, GLuint, index, GLint64EXT, x, GLint64EXT, y, GLint64EXT, z); \
  UnsupportedWrapper2(void, glVertexAttribL3i64vNV, GLuint, index, const GLint64EXT *, v); \
  UnsupportedWrapper4(void, glVertexAttribL3ui64NV, GLuint, index, GLuint64EXT, x, GLuint64EXT, y, GLuint64EXT, z); \
  UnsupportedWrapper2(void, glVertexAttribL3ui64vNV, GLuint, index, const GLuint64EXT *, v); \
  UnsupportedWrapper5(void, glVertexAttribL4i64NV, GLuint, index, GLint64EXT, x, GLint64EXT, y, GLint64EXT, z, GLint64EXT, w); \
  UnsupportedWrapper2(void, glVertexAttribL4i64vNV, GLuint, index, const GLint64EXT *, v); \
  UnsupportedWrapper5(void, glVertexAttribL4ui64NV, GLuint, index, GLuint64EXT, x, GLuint64EXT, y, GLuint64EXT, z, GLuint64EXT, w); \
  UnsupportedWrapper2(void, glVertexAttribL4ui64vNV, GLuint, index, const GLuint64EXT *, v); \
  UnsupportedWrapper4(void, glVertexAttribLFormatNV, GLuint, index, GLint, size, GLenum, type, GLsizei, stride); \
  UnsupportedWrapper3(void, glVertexAttribParameteriAMD, GLuint, index, GLenum, pname, GLint, param); \
  UnsupportedWrapper5(void, glVertexAttribPointerNV, GLuint, index, GLint, fsize, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper3(void, glVertexAttribs1dvNV, GLuint, index, GLsizei, count, const GLdouble *, v); \
  UnsupportedWrapper3(void, glVertexAttribs1fvNV, GLuint, index, GLsizei, count, const GLfloat *, v); \
  UnsupportedWrapper3(void, glVertexAttribs1hvNV, GLuint, index, GLsizei, n, const GLhalfNV *, v); \
  UnsupportedWrapper3(void, glVertexAttribs1svNV, GLuint, index, GLsizei, count, const GLshort *, v); \
  UnsupportedWrapper3(void, glVertexAttribs2dvNV, GLuint, index, GLsizei, count, const GLdouble *, v); \
  UnsupportedWrapper3(void, glVertexAttribs2fvNV, GLuint, index, GLsizei, count, const GLfloat *, v); \
  UnsupportedWrapper3(void, glVertexAttribs2hvNV, GLuint, index, GLsizei, n, const GLhalfNV *, v); \
  UnsupportedWrapper3(void, glVertexAttribs2svNV, GLuint, index, GLsizei, count, const GLshort *, v); \
  UnsupportedWrapper3(void, glVertexAttribs3dvNV, GLuint, index, GLsizei, count, const GLdouble *, v); \
  UnsupportedWrapper3(void, glVertexAttribs3fvNV, GLuint, index, GLsizei, count, const GLfloat *, v); \
  UnsupportedWrapper3(void, glVertexAttribs3hvNV, GLuint, index, GLsizei, n, const GLhalfNV *, v); \
  UnsupportedWrapper3(void, glVertexAttribs3svNV, GLuint, index, GLsizei, count, const GLshort *, v); \
  UnsupportedWrapper3(void, glVertexAttribs4dvNV, GLuint, index, GLsizei, count, const GLdouble *, v); \
  UnsupportedWrapper3(void, glVertexAttribs4fvNV, GLuint, index, GLsizei, count, const GLfloat *, v); \
  UnsupportedWrapper3(void, glVertexAttribs4hvNV, GLuint, index, GLsizei, n, const GLhalfNV *, v); \
  UnsupportedWrapper3(void, glVertexAttribs4svNV, GLuint, index, GLsizei, count, const GLshort *, v); \
  UnsupportedWrapper3(void, glVertexAttribs4ubvNV, GLuint, index, GLsizei, count, const GLubyte *, v); \
  UnsupportedWrapper1(void, glVertexBlendARB, GLint, count); \
  UnsupportedWrapper2(void, glVertexBlendEnvfATI, GLenum, pname, GLfloat, param); \
  UnsupportedWrapper2(void, glVertexBlendEnviATI, GLenum, pname, GLint, param); \
  UnsupportedWrapper3(void, glVertexFormatNV, GLint, size, GLenum, type, GLsizei, stride); \
  UnsupportedWrapper2(void, glVertexP2ui, GLenum, type, GLuint, value); \
  UnsupportedWrapper2(void, glVertexP2uiv, GLenum, type, const GLuint *, value); \
  UnsupportedWrapper2(void, glVertexP3ui, GLenum, type, GLuint, value); \
  UnsupportedWrapper2(void, glVertexP3uiv, GLenum, type, const GLuint *, value); \
  UnsupportedWrapper2(void, glVertexP4ui, GLenum, type, GLuint, value); \
  UnsupportedWrapper2(void, glVertexP4uiv, GLenum, type, const GLuint *, value); \
  UnsupportedWrapper5(void, glVertexPointerEXT, GLint, size, GLenum, type, GLsizei, stride, GLsizei, count, const void *, pointer); \
  UnsupportedWrapper5(void, glVertexPointerListIBM, GLint, size, GLenum, type, GLint, stride, const void **, pointer, GLint, ptrstride); \
  UnsupportedWrapper4(void, glVertexPointer, GLint, size, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper3(void, glVertexPointervINTEL, GLint, size, GLenum, type, const void **, pointer); \
  UnsupportedWrapper2(void, glVertexStream1dATI, GLenum, stream, GLdouble, x); \
  UnsupportedWrapper2(void, glVertexStream1dvATI, GLenum, stream, const GLdouble *, coords); \
  UnsupportedWrapper2(void, glVertexStream1fATI, GLenum, stream, GLfloat, x); \
  UnsupportedWrapper2(void, glVertexStream1fvATI, GLenum, stream, const GLfloat *, coords); \
  UnsupportedWrapper2(void, glVertexStream1iATI, GLenum, stream, GLint, x); \
  UnsupportedWrapper2(void, glVertexStream1ivATI, GLenum, stream, const GLint *, coords); \
  UnsupportedWrapper2(void, glVertexStream1sATI, GLenum, stream, GLshort, x); \
  UnsupportedWrapper2(void, glVertexStream1svATI, GLenum, stream, const GLshort *, coords); \
  UnsupportedWrapper3(void, glVertexStream2dATI, GLenum, stream, GLdouble, x, GLdouble, y); \
  UnsupportedWrapper2(void, glVertexStream2dvATI, GLenum, stream, const GLdouble *, coords); \
  UnsupportedWrapper3(void, glVertexStream2fATI, GLenum, stream, GLfloat, x, GLfloat, y); \
  UnsupportedWrapper2(void, glVertexStream2fvATI, GLenum, stream, const GLfloat *, coords); \
  UnsupportedWrapper3(void, glVertexStream2iATI, GLenum, stream, GLint, x, GLint, y); \
  UnsupportedWrapper2(void, glVertexStream2ivATI, GLenum, stream, const GLint *, coords); \
  UnsupportedWrapper3(void, glVertexStream2sATI, GLenum, stream, GLshort, x, GLshort, y); \
  UnsupportedWrapper2(void, glVertexStream2svATI, GLenum, stream, const GLshort *, coords); \
  UnsupportedWrapper4(void, glVertexStream3dATI, GLenum, stream, GLdouble, x, GLdouble, y, GLdouble, z); \
  UnsupportedWrapper2(void, glVertexStream3dvATI, GLenum, stream, const GLdouble *, coords); \
  UnsupportedWrapper4(void, glVertexStream3fATI, GLenum, stream, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper2(void, glVertexStream3fvATI, GLenum, stream, const GLfloat *, coords); \
  UnsupportedWrapper4(void, glVertexStream3iATI, GLenum, stream, GLint, x, GLint, y, GLint, z); \
  UnsupportedWrapper2(void, glVertexStream3ivATI, GLenum, stream, const GLint *, coords); \
  UnsupportedWrapper4(void, glVertexStream3sATI, GLenum, stream, GLshort, x, GLshort, y, GLshort, z); \
  UnsupportedWrapper2(void, glVertexStream3svATI, GLenum, stream, const GLshort *, coords); \
  UnsupportedWrapper5(void, glVertexStream4dATI, GLenum, stream, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  UnsupportedWrapper2(void, glVertexStream4dvATI, GLenum, stream, const GLdouble *, coords); \
  UnsupportedWrapper5(void, glVertexStream4fATI, GLenum, stream, GLfloat, x, GLfloat, y, GLfloat, z, GLfloat, w); \
  UnsupportedWrapper2(void, glVertexStream4fvATI, GLenum, stream, const GLfloat *, coords); \
  UnsupportedWrapper5(void, glVertexStream4iATI, GLenum, stream, GLint, x, GLint, y, GLint, z, GLint, w); \
  UnsupportedWrapper2(void, glVertexStream4ivATI, GLenum, stream, const GLint *, coords); \
  UnsupportedWrapper5(void, glVertexStream4sATI, GLenum, stream, GLshort, x, GLshort, y, GLshort, z, GLshort, w); \
  UnsupportedWrapper2(void, glVertexStream4svATI, GLenum, stream, const GLshort *, coords); \
  UnsupportedWrapper1(void, glVertexWeightfEXT, GLfloat, weight); \
  UnsupportedWrapper1(void, glVertexWeightfvEXT, const GLfloat *, weight); \
  UnsupportedWrapper1(void, glVertexWeighthNV, GLhalfNV, weight); \
  UnsupportedWrapper1(void, glVertexWeighthvNV, const GLhalfNV *, weight); \
  UnsupportedWrapper4(void, glVertexWeightPointerEXT, GLint, size, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper3(GLenum, glVideoCaptureNV, GLuint, video_capture_slot, GLuint *, sequence_num, GLuint64EXT *, capture_time); \
  UnsupportedWrapper4(void, glVideoCaptureStreamParameterdvNV, GLuint, video_capture_slot, GLuint, stream, GLenum, pname, const GLdouble *, params); \
  UnsupportedWrapper4(void, glVideoCaptureStreamParameterfvNV, GLuint, video_capture_slot, GLuint, stream, GLenum, pname, const GLfloat *, params); \
  UnsupportedWrapper4(void, glVideoCaptureStreamParameterivNV, GLuint, video_capture_slot, GLuint, stream, GLenum, pname, const GLint *, params); \
  UnsupportedWrapper3(void, glViewportPositionWScaleNV, GLuint, index, GLfloat, xcoeff, GLfloat, ycoeff); \
  UnsupportedWrapper5(void, glViewportSwizzleNV, GLuint, index, GLenum, swizzlex, GLenum, swizzley, GLenum, swizzlez, GLenum, swizzlew); \
  UnsupportedWrapper3(void, glWaitSyncAPPLE, GLsync, sync, GLbitfield, flags, GLuint64, timeout); \
  UnsupportedWrapper1(void, glWaitVkSemaphoreNV, GLuint64, vkSemaphore); \
  UnsupportedWrapper2(void, glWeightbvARB, GLint, size, const GLbyte *, weights); \
  UnsupportedWrapper2(void, glWeightdvARB, GLint, size, const GLdouble *, weights); \
  UnsupportedWrapper2(void, glWeightfvARB, GLint, size, const GLfloat *, weights); \
  UnsupportedWrapper2(void, glWeightivARB, GLint, size, const GLint *, weights); \
  UnsupportedWrapper4(void, glWeightPathsNV, GLuint, resultPath, GLsizei, numPaths, const GLuint *, paths, const GLfloat *, weights); \
  UnsupportedWrapper4(void, glWeightPointerARB, GLint, size, GLenum, type, GLsizei, stride, const void *, pointer); \
  UnsupportedWrapper2(void, glWeightsvARB, GLint, size, const GLshort *, weights); \
  UnsupportedWrapper2(void, glWeightubvARB, GLint, size, const GLubyte *, weights); \
  UnsupportedWrapper2(void, glWeightuivARB, GLint, size, const GLuint *, weights); \
  UnsupportedWrapper2(void, glWeightusvARB, GLint, size, const GLushort *, weights); \
  UnsupportedWrapper2(void, glWindowPos2dARB, GLdouble, x, GLdouble, y); \
  UnsupportedWrapper2(void, glWindowPos2dMESA, GLdouble, x, GLdouble, y); \
  UnsupportedWrapper2(void, glWindowPos2d, GLdouble, x, GLdouble, y); \
  UnsupportedWrapper1(void, glWindowPos2dvARB, const GLdouble *, v); \
  UnsupportedWrapper1(void, glWindowPos2dvMESA, const GLdouble *, v); \
  UnsupportedWrapper1(void, glWindowPos2dv, const GLdouble *, v); \
  UnsupportedWrapper2(void, glWindowPos2fARB, GLfloat, x, GLfloat, y); \
  UnsupportedWrapper2(void, glWindowPos2fMESA, GLfloat, x, GLfloat, y); \
  UnsupportedWrapper2(void, glWindowPos2f, GLfloat, x, GLfloat, y); \
  UnsupportedWrapper1(void, glWindowPos2fvARB, const GLfloat *, v); \
  UnsupportedWrapper1(void, glWindowPos2fvMESA, const GLfloat *, v); \
  UnsupportedWrapper1(void, glWindowPos2fv, const GLfloat *, v); \
  UnsupportedWrapper2(void, glWindowPos2iARB, GLint, x, GLint, y); \
  UnsupportedWrapper2(void, glWindowPos2iMESA, GLint, x, GLint, y); \
  UnsupportedWrapper2(void, glWindowPos2i, GLint, x, GLint, y); \
  UnsupportedWrapper1(void, glWindowPos2ivARB, const GLint *, v); \
  UnsupportedWrapper1(void, glWindowPos2ivMESA, const GLint *, v); \
  UnsupportedWrapper1(void, glWindowPos2iv, const GLint *, v); \
  UnsupportedWrapper2(void, glWindowPos2sARB, GLshort, x, GLshort, y); \
  UnsupportedWrapper2(void, glWindowPos2sMESA, GLshort, x, GLshort, y); \
  UnsupportedWrapper2(void, glWindowPos2s, GLshort, x, GLshort, y); \
  UnsupportedWrapper1(void, glWindowPos2svARB, const GLshort *, v); \
  UnsupportedWrapper1(void, glWindowPos2svMESA, const GLshort *, v); \
  UnsupportedWrapper1(void, glWindowPos2sv, const GLshort *, v); \
  UnsupportedWrapper3(void, glWindowPos3dARB, GLdouble, x, GLdouble, y, GLdouble, z); \
  UnsupportedWrapper3(void, glWindowPos3dMESA, GLdouble, x, GLdouble, y, GLdouble, z); \
  UnsupportedWrapper3(void, glWindowPos3d, GLdouble, x, GLdouble, y, GLdouble, z); \
  UnsupportedWrapper1(void, glWindowPos3dvARB, const GLdouble *, v); \
  UnsupportedWrapper1(void, glWindowPos3dvMESA, const GLdouble *, v); \
  UnsupportedWrapper1(void, glWindowPos3dv, const GLdouble *, v); \
  UnsupportedWrapper3(void, glWindowPos3fARB, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper3(void, glWindowPos3fMESA, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper3(void, glWindowPos3f, GLfloat, x, GLfloat, y, GLfloat, z); \
  UnsupportedWrapper1(void, glWindowPos3fvARB, const GLfloat *, v); \
  UnsupportedWrapper1(void, glWindowPos3fvMESA, const GLfloat *, v); \
  UnsupportedWrapper1(void, glWindowPos3fv, const GLfloat *, v); \
  UnsupportedWrapper3(void, glWindowPos3iARB, GLint, x, GLint, y, GLint, z); \
  UnsupportedWrapper3(void, glWindowPos3iMESA, GLint, x, GLint, y, GLint, z); \
  UnsupportedWrapper3(void, glWindowPos3i, GLint, x, GLint, y, GLint, z); \
  UnsupportedWrapper1(void, glWindowPos3ivARB, const GLint *, v); \
  UnsupportedWrapper1(void, glWindowPos3ivMESA, const GLint *, v); \
  UnsupportedWrapper1(void, glWindowPos3iv, const GLint *, v); \
  UnsupportedWrapper3(void, glWindowPos3sARB, GLshort, x, GLshort, y, GLshort, z); \
  UnsupportedWrapper3(void, glWindowPos3sMESA, GLshort, x, GLshort, y, GLshort, z); \
  UnsupportedWrapper3(void, glWindowPos3s, GLshort, x, GLshort, y, GLshort, z); \
  UnsupportedWrapper1(void, glWindowPos3svARB, const GLshort *, v); \
  UnsupportedWrapper1(void, glWindowPos3svMESA, const GLshort *, v); \
  UnsupportedWrapper1(void, glWindowPos3sv, const GLshort *, v); \
  UnsupportedWrapper4(void, glWindowPos4dMESA, GLdouble, x, GLdouble, y, GLdouble, z, GLdouble, w); \
  UnsupportedWrapper1(void, glWindowPos4dvMESA, const GLdouble *, v); \
  UnsupportedWrapper4(void, glWindowPos4fMESA, GLfloat, x, GLfloat, y, GLfloat, z, GLfloat, w); \
  UnsupportedWrapper1(void, glWindowPos4fvMESA, const GLfloat *, v); \
  UnsupportedWrapper4(void, glWindowPos4iMESA, GLint, x, GLint, y, GLint, z, GLint, w); \
  UnsupportedWrapper1(void, glWindowPos4ivMESA, const GLint *, v); \
  UnsupportedWrapper4(void, glWindowPos4sMESA, GLshort, x, GLshort, y, GLshort, z, GLshort, w); \
  UnsupportedWrapper1(void, glWindowPos4svMESA, const GLshort *, v); \
  UnsupportedWrapper3(void, glWindowRectanglesEXT, GLenum, mode, GLsizei, count, const GLint *, box); \
  UnsupportedWrapper6(void, glWriteMaskEXT, GLuint, res, GLuint, in, GLenum, outX, GLenum, outY, GLenum, outZ, GLenum, outW); \


        
// the _renderdoc_hooked variants are to make sure we always have a function symbol exported that we
// can return from GetProcAddress. On posix systems if another library (or the application itself)
// creates a symbol called 'glEnable' we'll return the address of that, and break badly. Instead we
// leave the 'naked' versions for applications trying to import those symbols, and declare the
// _renderdoc_hooked for returning as a func pointer. The raw version calls directly into the hooked
// version to hopefully allow the linker to tail-call optimise and reduce the overhead.


#define FuncWrapper0(ret, function) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)() \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, ); \
    return glhook.driver->function(); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)() \
  { \
    return CONCAT(function, _renderdoc_hooked)(); \
  } \
  HOOK_EXPORT ret HOOK_CC function();

#define AliasWrapper0(ret, function, realfunc) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)() \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, ); \
    return glhook.driver->realfunc(); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)() \
  { \
    return CONCAT(function, _renderdoc_hooked)(); \
  } \
  HOOK_EXPORT ret HOOK_CC function();

#define UnsupportedWrapper0(ret, function) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)() \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)() \
  { \
    return CONCAT(function, _renderdoc_hooked)(); \
  } \
  HOOK_EXPORT ret HOOK_CC function();


#define FuncWrapper1(ret, function, t1, p1) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1); \
    return glhook.driver->function(p1); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1);

#define AliasWrapper1(ret, function, realfunc, t1, p1) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1); \
    return glhook.driver->realfunc(p1); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1);

#define UnsupportedWrapper1(ret, function, t1, p1) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1);


#define FuncWrapper2(ret, function, t1, p1, t2, p2) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2); \
    return glhook.driver->function(p1, p2); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2);

#define AliasWrapper2(ret, function, realfunc, t1, p1, t2, p2) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2); \
    return glhook.driver->realfunc(p1, p2); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2);

#define UnsupportedWrapper2(ret, function, t1, p1, t2, p2) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2);


#define FuncWrapper3(ret, function, t1, p1, t2, p2, t3, p3) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3); \
    return glhook.driver->function(p1, p2, p3); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3);

#define AliasWrapper3(ret, function, realfunc, t1, p1, t2, p2, t3, p3) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3); \
    return glhook.driver->realfunc(p1, p2, p3); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3);

#define UnsupportedWrapper3(ret, function, t1, p1, t2, p2, t3, p3) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3);


#define FuncWrapper4(ret, function, t1, p1, t2, p2, t3, p3, t4, p4) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3, p4); \
    return glhook.driver->function(p1, p2, p3, p4); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4);

#define AliasWrapper4(ret, function, realfunc, t1, p1, t2, p2, t3, p3, t4, p4) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3, p4); \
    return glhook.driver->realfunc(p1, p2, p3, p4); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4);

#define UnsupportedWrapper4(ret, function, t1, p1, t2, p2, t3, p3, t4, p4) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3, t4 p4); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3, p4); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4);


#define FuncWrapper5(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3, p4, p5); \
    return glhook.driver->function(p1, p2, p3, p4, p5); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5);

#define AliasWrapper5(ret, function, realfunc, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3, p4, p5); \
    return glhook.driver->realfunc(p1, p2, p3, p4, p5); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5);

#define UnsupportedWrapper5(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3, p4, p5); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5);


#define FuncWrapper6(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3, p4, p5, p6); \
    return glhook.driver->function(p1, p2, p3, p4, p5, p6); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6);

#define AliasWrapper6(ret, function, realfunc, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3, p4, p5, p6); \
    return glhook.driver->realfunc(p1, p2, p3, p4, p5, p6); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6);

#define UnsupportedWrapper6(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3, p4, p5, p6); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6);


#define FuncWrapper7(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3, p4, p5, p6, p7); \
    return glhook.driver->function(p1, p2, p3, p4, p5, p6, p7); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7);

#define AliasWrapper7(ret, function, realfunc, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3, p4, p5, p6, p7); \
    return glhook.driver->realfunc(p1, p2, p3, p4, p5, p6, p7); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7);

#define UnsupportedWrapper7(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3, p4, p5, p6, p7); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7);


#define FuncWrapper8(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3, p4, p5, p6, p7, p8); \
    return glhook.driver->function(p1, p2, p3, p4, p5, p6, p7, p8); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8);

#define AliasWrapper8(ret, function, realfunc, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3, p4, p5, p6, p7, p8); \
    return glhook.driver->realfunc(p1, p2, p3, p4, p5, p6, p7, p8); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8);

#define UnsupportedWrapper8(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3, p4, p5, p6, p7, p8); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8);


#define FuncWrapper9(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3, p4, p5, p6, p7, p8, p9); \
    return glhook.driver->function(p1, p2, p3, p4, p5, p6, p7, p8, p9); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9);

#define AliasWrapper9(ret, function, realfunc, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3, p4, p5, p6, p7, p8, p9); \
    return glhook.driver->realfunc(p1, p2, p3, p4, p5, p6, p7, p8, p9); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9);

#define UnsupportedWrapper9(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3, p4, p5, p6, p7, p8, p9); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9);


#define FuncWrapper10(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); \
    return glhook.driver->function(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10);

#define AliasWrapper10(ret, function, realfunc, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); \
    return glhook.driver->realfunc(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10);

#define UnsupportedWrapper10(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10);


#define FuncWrapper11(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11); \
    return glhook.driver->function(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11);

#define AliasWrapper11(ret, function, realfunc, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11); \
    return glhook.driver->realfunc(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11);

#define UnsupportedWrapper11(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11);


#define FuncWrapper12(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12); \
    return glhook.driver->function(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12);

#define AliasWrapper12(ret, function, realfunc, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12); \
    return glhook.driver->realfunc(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12);

#define UnsupportedWrapper12(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12);


#define FuncWrapper13(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13); \
    return glhook.driver->function(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13);

#define AliasWrapper13(ret, function, realfunc, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13); \
    return glhook.driver->realfunc(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13);

#define UnsupportedWrapper13(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13);


#define FuncWrapper14(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13, t14, p14) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14); \
    return glhook.driver->function(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14);

#define AliasWrapper14(ret, function, realfunc, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13, t14, p14) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14); \
    return glhook.driver->realfunc(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14);

#define UnsupportedWrapper14(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13, t14, p14) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14);


#define FuncWrapper15(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13, t14, p14, t15, p15) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15); \
    return glhook.driver->function(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15);

#define AliasWrapper15(ret, function, realfunc, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13, t14, p14, t15, p15) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15); \
    return glhook.driver->realfunc(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15);

#define UnsupportedWrapper15(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13, t14, p14, t15, p15) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15);


#define FuncWrapper16(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13, t14, p14, t15, p15, t16, p16) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16); \
    return glhook.driver->function(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16);

#define AliasWrapper16(ret, function, realfunc, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13, t14, p14, t15, p15, t16, p16) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16); \
    return glhook.driver->realfunc(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16);

#define UnsupportedWrapper16(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13, t14, p14, t15, p15, t16, p16) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16);


#define FuncWrapper17(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13, t14, p14, t15, p15, t16, p16, t17, p17) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16, t17 p17) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(function, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17); \
    return glhook.driver->function(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16, t17 p17) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16, t17 p17);

#define AliasWrapper17(ret, function, realfunc, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13, t14, p14, t15, p15, t16, p16, t17, p17) \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16, t17 p17) \
  { \
    SCOPED_GLCALL(function); \
    UNINIT_CALL(realfunc, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17); \
    return glhook.driver->realfunc(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16, t17 p17) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16, t17 p17);

#define UnsupportedWrapper17(ret, function, t1, p1, t2, p2, t3, p3, t4, p4, t5, p5, t6, p6, t7, p7, t8, p8, t9, p9, t10, p10, t11, p11, t12, p12, t13, p13, t14, p14, t15, p15, t16, p16, t17, p17) \
  typedef ret(HOOK_CC *CONCAT(function, _hooktype))(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16, t17 p17); \
  CONCAT(function, _hooktype) CONCAT(unsupported_real_, function) = NULL; \
  ret HOOK_CC CONCAT(function, _renderdoc_hooked)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16, t17 p17) \
  { \
    glhook.UseUnusedSupportedFunction(STRINGIZE(function)); \
    if(!CONCAT(unsupported_real_, function)) \
      CONCAT(unsupported_real_, function) = \
          (CONCAT(function, _hooktype))glhook.GetUnsupportedFunction(STRINGIZE(function)); \
    return CONCAT(unsupported_real_, function)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17); \
  } \
  HOOK_EXPORT ret HOOK_CC GL_EXPORT_NAME(function)(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16, t17 p17) \
  { \
    return CONCAT(function, _renderdoc_hooked)(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17); \
  } \
  HOOK_EXPORT ret HOOK_CC function(t1 p1, t2 p2, t3 p3, t4 p4, t5 p5, t6 p6, t7 p7, t8 p8, t9 p9, t10 p10, t11 p11, t12 p12, t13 p13, t14 p14, t15 p15, t16 p16, t17 p17);

