<!--
    check our development guide
    https://github.com/rdiff-backup/rdiff-backup/blob/master/docs/DEVELOP.adoc

    You can remove those kind of comments once you're done with them
-->

<!-- TIP: add `[DOC]` at the beginning of the subject for documentation-only
     pull requests -->

## Changes done and why

<!--
    In the best case, move the commit message included by GitHub above to here.

    If your explanation needs to be (very) different from your Git commit
    message, your Git commit might be insufficient,
    please re-think it and amend it!

    Your message must contain `Closes #NNN` if it [closes an issue](https://docs.github.com/en/issues/tracking-your-work-with-issues/linking-a-pull-request-to-an-issue).
-->

## Self-Checklist

<!--
    It is the responsibility of the author of the pull request (PR) to go
    through this checklist and tick all points off.
    PRs won't be reviewed before all points have been ticked off.

    It is valid to:

    1. leave at first a point unticked and ask questions in the comments
       if you're unsure, PRs can be amended and checks can be ticked once
       the point has been cleared
    2. to tick the point without doing anything, because it is irrelevant
       (e.g. code bug fix seldomly require changes to the documentation,
       and pure documentation changes don't need tests). In doubtful cases
       add a short explanation why nothing was done, but tick the box.
-->

- [ ] changes to the code have been reflected in the documentation
- [ ] changes to the code have been covered by new/modified tests
- [ ] commit contains a description of changes
    * relevant to users prefixed by DOC:, FIX:, NEW: and/or CHG:
    * relevant to the web-site prefixed by WEB:
    * relevant to developers prefixed by DEV:

<!--
    for details on this last point, check:

    * either the [developer documentation](https://github.com/rdiff-backup/rdiff-backup/blob/master/docs/DEVELOP.adoc#22-branching-model-and-pull-requests)s
    * or the top of the [changelog](https://github.com/rdiff-backup/rdiff-backup/blob/master/CHANGELOG.adoc)
-->
